import React, { FC } from 'react';
import { TextStyle, ViewStyle } from 'react-native';
import type { ExtraInsets, Toast as ToastType } from '../core/types';
import { Toast as T } from '../core/types';
type Props = {
    toast: ToastType;
    updateHeight: (toastId: string, height: number) => void;
    offset: number;
    endPause: () => void;
    startPause: () => void;
    customRenderer?: (toast: ToastType) => React.ReactNode;
    overrideDarkMode?: boolean;
    onToastShow?: (toast: T) => void;
    onToastHide?: (toast: T) => void;
    onToastPress?: (toast: T) => void;
    extraInsets?: ExtraInsets;
    keyboardVisible?: boolean;
    keyboardHeight: number;
    defaultStyle?: {
        pressable?: ViewStyle;
        view?: ViewStyle;
        text?: TextStyle;
        indicator?: ViewStyle;
    };
};
export declare const Toast: FC<Props>;
export {};
//# sourceMappingURL=Toast.d.ts.map