"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toast = void 0;
var _types = require("./types");
var _utils = require("./utils");
var _utils2 = require("../utils");
var _store = require("./store");
const createToast = (message, type = 'blank', opts) => ({
  createdAt: Date.now(),
  visible: true,
  type,
  message,
  pauseDuration: 0,
  position: _types.ToastPosition.TOP,
  providerKey: 'DEFAULT',
  isSwipeable: true,
  animationType: opts?.animationType,
  animationConfig: opts?.animationConfig,
  ...opts,
  id: opts?.id || (0, _utils.genId)()
});
const createHandler = type => (message, options) => {
  const toast = createToast(message, type, options);
  (0, _store.dispatch)({
    type: _store.ActionType.UPSERT_TOAST,
    toast
  });
  if (toast.accessabilityMessage) {
    (0, _utils2.announceForAccessibility)(toast.accessabilityMessage);
  }
  return toast.id;
};
const toast = (message, opts) => createHandler('blank')(message, opts);
exports.toast = toast;
toast.error = createHandler('error');
toast.success = createHandler('success');
toast.loading = createHandler('loading');
toast.dismiss = toastId => {
  (0, _store.dispatch)({
    type: _store.ActionType.DISMISS_TOAST,
    toastId
  });
};
toast.remove = toastId => (0, _store.dispatch)({
  type: _store.ActionType.REMOVE_TOAST,
  toastId
});
toast.promise = (promise, msgs, opts) => {
  const id = toast.loading(msgs.loading, {
    ...opts,
    ...opts?.loading
  });
  promise.then(p => {
    toast.success((0, _types.resolveValue)(msgs.success, p), {
      id,
      ...opts,
      ...opts?.success
    });
    return p;
  }).catch(e => {
    toast.error((0, _types.resolveValue)(msgs.error, e), {
      id,
      ...opts,
      ...opts?.error
    });
  });
  return promise;
};
//# sourceMappingURL=toast.js.map