"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Toasts = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactNative = require("react-native");
var _headless = require("../headless");
var _Toast = require("./Toast");
var _reactNativeSafeAreaContext = require("react-native-safe-area-context");
var _utils = require("../utils");
var _jsxRuntime = require("react/jsx-runtime");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const Toasts = ({
  overrideDarkMode,
  extraInsets,
  onToastHide,
  onToastPress,
  onToastShow,
  providerKey = 'DEFAULT',
  preventScreenReaderFromHiding,
  defaultStyle,
  globalAnimationType,
  globalAnimationConfig
}) => {
  const {
    toasts,
    handlers
  } = (0, _headless.useToaster)({
    providerKey
  });
  const {
    startPause,
    endPause
  } = handlers;
  const insets = (0, _reactNativeSafeAreaContext.useSafeAreaInsets)();
  const isScreenReaderEnabled = (0, _utils.useScreenReader)();
  const {
    keyboardShown: keyboardVisible,
    keyboardHeight
  } = (0, _utils.useKeyboard)();
  if (isScreenReaderEnabled && !preventScreenReaderFromHiding) {
    return null;
  }
  return /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.View, {
    style: {
      position: 'absolute',
      top: insets.top + (extraInsets?.top ?? 0) + 16,
      left: insets.left + (extraInsets?.left ?? 0),
      right: insets.right + (extraInsets?.right ?? 0),
      bottom: insets.bottom + (extraInsets?.bottom ?? 0) + 16
    },
    pointerEvents: 'box-none',
    children: toasts.map(t => /*#__PURE__*/(0, _jsxRuntime.jsx)(_Toast.Toast, {
      toast: {
        ...t,
        animationType: t.animationType || globalAnimationType || 'timing',
        animationConfig: t.animationConfig || globalAnimationConfig || {
          duration: 300
        }
      },
      startPause: startPause,
      endPause: endPause,
      updateHeight: handlers.updateHeight,
      offset: handlers.calculateOffset(t, {
        reverseOrder: true
      }),
      overrideDarkMode: overrideDarkMode,
      onToastHide: onToastHide,
      onToastPress: onToastPress,
      onToastShow: onToastShow,
      extraInsets: extraInsets,
      defaultStyle: defaultStyle,
      keyboardVisible: keyboardVisible,
      keyboardHeight: keyboardHeight
    }, t.id))
  });
};
exports.Toasts = Toasts;
//# sourceMappingURL=Toasts.js.map