package dev.dimension.flare.ui.theme

import androidx.compose.runtime.Composable
import androidx.compose.ui.graphics.Color
import io.github.composefluent.FluentTheme

internal actual object PlatformColorScheme {
    actual val primary: Color
        @Composable
        get() = FluentTheme.colors.fillAccent.default
    actual val primaryContainer: Color
        @Composable
        get() = FluentTheme.colors.fillAccent.secondary
    actual val onPrimaryContainer: Color
        @Composable
        get() = FluentTheme.colors.text.onAccent.primary
    actual val error: Color
        @Composable
        get() = FluentTheme.colors.system.critical
    public actual val caption: Color
        @Composable
        get() = FluentTheme.colors.text.text.tertiary
    public actual val outline: Color
        @Composable
        get() = FluentTheme.colors.stroke.divider.default
    public actual val card: Color
        @Composable
        get() = FluentTheme.colors.background.card.default
    public actual val cardAlt: Color
        @Composable
        get() = FluentTheme.colors.background.card.secondary
    actual val onCard: Color
        @Composable
        get() = FluentTheme.colors.text.text.primary

    actual val text: Color
        @Composable
        get() = FluentTheme.colors.text.text.primary
}
