package dev.develsinthedetails.eatpoopyoucat.ui.previousgames

import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.tooling.preview.Preview
import dev.develsinthedetails.eatpoopyoucat.data.Entry
import dev.develsinthedetails.eatpoopyoucat.ui.theme.AppTheme
import kotlinx.serialization.json.Json

class PreviewData {
    companion object {
        val entries: List<Entry> = Json.decodeFromString(
            """[{"id":"4220a3cf-71eb-4daa-9bd9-2b005ebbd326","createdAt":1712948362060,"playerId":"11e178c5-8e89-432a-978e-fc95fd17f8bf","sequence":0,"gameId":"5a2376c6-3285-474c-9896-ee66829b77c2","timePassed":0,"sentence":"a cat climbing on a roof.","localPlayerName": "Not James"},{"id":"2c18c42d-d638-45d7-95d0-3084e8123189","createdAt":1712948462060,"playerId":"11e178c5-8e89-432a-978e-fc95fd17f8bf","sequence":1,"gameId":"5a2376c6-3285-474c-9896-ee66829b77c2","localPlayerName": "James","timePassed":0,"drawing":[31,-117,8,0,0,0,0,0,0,0,-19,125,-53,-82,45,-55,113,-35,-65,-12,-104,-40,-56,-9,-125,-65,97,-64,19,65,3,1,106,-120,4,104,10,16,91,-112,13,66,-1,-18,88,117,41,118,-58,-82,88,-21,-44,-74,79,-61,19,15,56,-32,-19,88,-21,-44,-82,-54,-116,-116,119,-2,-61,95,127,-6,-45,31,-1,-4,-13,127,-5,-7,95,-2,-57,-49,127,-2,-27,47,63,-3,-2,31,-2,-6,-45,95,126,-7,-89,127,-5,-27,-89,-33,-1,-11,-89,-1,-7,-33,-1,-23,79,-1,-2,-13,79,-65,111,-29,-107,-41,106,-13,119,63,-3,-81,-65,-3,75,78,125,-66,118,109,-27,63,127,-9,-45,-49,127,-2,-25,-89,-62,-1,-7,-69,-1,91,-10,92,-58,107,-82,93,-74,-109,110,-81,53,107,-115,-23,37,-30,-50,-33,-54,-85,-89,92,-37,115,126,-123,-72,-13,-113,-11,90,-91,101,47,61,94,53,-27,69,-8,21,-30,-50,-65,-42,43,-91,-98,-13,-37,-37,-84,-123,-68,125,5,-72,-79,-105,60,94,123,-91,-18,-33,-27,122,-39,-89,106,49,-67,68,-36,-7,107,127,-11,-74,-21,122,-109,-98,61,117,-62,-81,16,119,-2,94,-15,-34,-10,124,-50,-81,16,119,-2,-103,95,109,-108,-31,-97,102,-65,-26,76,-101,-16,43,-60,-99,127,-25,-41,24,117,57,-23,81,94,37,-17,65,-8,21,-30,-58,95,75,122,-83,-26,-105,-78,45,-65,92,39,-95,87,-128,59,123,-99,-10,-69,-74,123,-108,89,94,41,55,-78,-12,21,-32,-50,62,-14,43,-75,-20,-123,-101,-67,-36,74,62,-83,2,-36,-39,39,30,-27,109,23,-50,-2,50,-59,66,-40,5,-32,-50,-66,-25,-85,-113,89,-86,19,-74,-99,-109,-39,-66,-110,-120,-69,78,-50,-74,-29,86,26,78,24,-101,48,-111,55,-81,0,119,-10,-118,103,-55,-35,-67,-55,-107,94,125,117,-78,108,36,-30,-50,111,123,-80,-51,57,-36,-45,44,-84,-125,74,118,-107,68,-36,-7,-19,83,-43,-98,-41,124,-109,46,76,37,43,-64,-99,-35,-66,84,109,-5,49,55,21,-65,49,119,-24,-66,52,-100,-20,-36,-81,77,-113,42,5,-72,-77,15,-37,-38,105,-73,-2,38,-35,71,39,75,94,34,-18,-4,-10,-77,-20,-44,-49,111,-62,-71,-49,76,-24,5,-32,-58,62,82,121,-115,-106,-54,-37,2,-98,109,-111,37,-93,0,119,-10,-126,71,-55,-83,-66,73,-9,-42,24,-67,66,-36,-7,-19,0,-50,-91,-68,11,-25,58,38,-95,23,-128,59,-5,-75,19,-122,91,-67,-48,86,101,-111,-19,-86,0,55,-10,-103,108,1,-25,-3,-82,-104,122,98,-10,-97,2,-36,-39,91,51,-91,-67,-26,124,83,-85,-10,63,-78,-95,36,-30,-50,63,-20,69,-90,-73,-97,-38,94,-91,111,114,-118,40,-64,-99,125,-39,110,27,105,-8,-33,90,95,-85,103,-78,101,37,-30,-58,-65,114,125,-107,82,-68,-34,-109,-4,18,113,-25,-81,-74,-90,-78,125,-80,-73,119,89,-20,-112,38,-4,10,113,-25,-73,85,-43,-10,46,111,75,-95,-90,68,-42,-114,2,-36,-40,119,74,-81,57,-14,115,118,5,-72,-77,-41,-4,-86,99,-65,29,-8,-54,0,-111,-120,59,127,-49,-81,62,83,123,-5,80,-91,110,-94,47,21,-32,-50,110,118,-88,-39,19,94,117,-101,70,44,68,-31,8,-7,59,-9,78,-81,-35,-117,-105,53,-77,52,49,109,-90,0,119,-113,39,37,51,-105,-51,78,-9,63,52,-67,-14,92,-52,-25,-111,-112,-32,47,20,59,8,-110,-41,-82,3,-42,80,38,10,83,34,2,126,115,-25,-42,-56,110,15,14,-20,65,-22,-76,41,68,-64,-65,109,81,-39,-25,121,-13,32,109,-27,49,122,14,-72,-77,-37,-101,51,103,-73,121,15,-58,52,-32,-56,100,97,74,68,-64,111,71,103,29,126,53,116,-84,-122,-59,60,114,-123,8,-8,77,69,-75,85,-100,-122,106,56,-103,39,123,-5,10,17,-16,-37,-101,51,55,-43,-67,-52,-42,-115,96,-48,-25,23,-120,-128,-33,-116,32,-77,26,-35,90,107,-8,-75,-60,20,81,-128,-128,125,87,115,-32,-35,-85,-76,95,-65,-5,-96,47,-121,3,-126,104,78,-74,77,103,-33,-58,73,67,-61,-14,104,-114,64,4,-4,-75,-67,-14,-86,-18,-89,86,-45,-127,-83,80,126,-127,8,-8,-19,-77,-65,5,55,42,108,37,22,-53,-31,-14,81,-92,-85,32,-52,-32,86,-103,-99,24,45,49,75,71,34,2,126,91,6,99,121,123,-70,38,115,-5,58,83,11,10,17,-16,-37,66,-80,-81,-18,-98,-90,32,-78,81,-39,-46,81,-120,59,127,77,-29,-107,-34,68,-21,-24,76,-23,80,-15,-1,-49,-4,41,-77,-103,116,118,58,60,102,-2,-101,-8,19,102,-60,71,-40,-103,-54,-92,31,-16,102,115,86,106,101,-53,-102,-118,63,97,-58,-14,103,30,43,23,-1,-124,-7,31,127,-9,-45,-65,-3,-4,-105,127,-3,-45,-65,-1,-14,-57,127,-3,51,48,127,-8,-7,-113,-1,-14,-121,95,-128,-127,105,-6,31,127,-4,-25,95,-2,-16,-29,-1,92,79,-15,117,56,-65,-44,-7,-38,123,-67,-7,-70,-7,-75,114,-12,-107,-92,52,-119,-55,126,-60,-33,-110,-39,45,-19,-12,-49,54,66,65,-101,-103,-51,10,16,60,-3,-122,122,45,-121,-83,-79,-57,120,-31,-68,102,17,83,-123,8,-33,78,95,-5,-48,-24,48,-69,83,98,-31,112,42,30,48,15,-20,-56,-61,-60,-77,31,104,-25,54,13,-124,51,-15,48,-54,94,-101,-77,126,119,-79,83,117,51,63,72,1,2,-10,-6,-102,-90,-54,-113,-81,-65,-109,-71,-37,107,87,-6,-58,5,34,-32,79,118,26,-69,72,-51,90,102,60,-50,54,40,-65,64,-36,-7,77,95,-103,33,122,-68,-56,5,-33,-93,20,22,-52,84,-128,-128,125,98,91,-97,103,-100,-83,101,59,85,89,80,77,1,2,118,51,-46,-25,-50,-57,-6,90,13,-65,116,50,91,89,34,-98,-15,87,-77,104,106,99,-70,64,33,-62,119,95,-110,11,127,46,88,-90,-123,45,122,46,31,112,-17,87,-79,-3,119,88,-90,8,78,-20,89,50,125,118,-127,8,-7,87,61,109,59,-5,127,-81,-78,23,-35,-79,2,16,-82,-6,-47,75,62,-20,-46,-123,-125,-75,-85,69,-49,0,-49,-40,-117,-7,32,-117,-104,-102,10,-16,-28,-51,100,-77,74,11,61,-111,21,32,100,31,-43,5,-29,-19,-24,-127,43,-52,-20,88,-119,120,-62,63,-31,30,-81,-66,-98,-13,-1,-118,120,-60,-65,-20,0,-19,-52,-52,87,-128,-112,-67,-107,-71,78,89,-13,102,6,-13,127,-124,124,-56,-115,-44,-24,-31,15,76,-124,-76,-51,69,-32,-28,12,16,-22,2,51,27,-5,-79,-60,-26,-128,48,77,117,10,-64,19,77,51,-121,29,19,102,7,63,86,53,127,7,-124,90,126,111,-105,9,-79,-25,-78,-41,-40,6,85,6,2,17,-14,-101,-109,122,-58,-105,102,-21,118,-120,82,-65,86,34,-98,-24,-7,-39,-54,-85,53,-106,-19,84,-128,71,-20,102,116,-27,-59,50,4,10,-16,-116,-35,-20,-73,82,-71,-98,23,-120,103,-4,-8,82,-125,-42,64,40,-60,51,126,44,-76,-2,-4,8,-1,59,-32,-47,-54,44,-51,-4,-88,-51,-75,-91,64,60,-80,-98,-20,-76,52,101,78,-83,109,46,31,114,47,59,-64,14,51,116,-26,-3,-94,-71,7,33,-1,-60,58,-104,121,-67,-26,100,-107,15,10,16,-100,-81,-10,-101,-26,56,-77,127,16,-18,-109,-101,-60,28,16,-38,-13,-69,79,-89,-102,-66,96,-25,-128,-64,63,-85,-81,-98,102,-21,-113,-39,5,32,-88,-56,105,-81,110,-57,-53,-14,-62,121,-48,-27,40,0,65,61,-114,-87,56,-13,20,-49,-93,50,-37,111,47,-119,-22,97,-123,-72,-13,47,91,4,-71,23,-73,-62,80,122,-112,-39,41,34,0,-9,-86,-112,100,103,113,30,103,101,-36,76,-41,-6,37,-118,76,1,-126,90,-97,-6,-38,-87,-107,83,-42,-100,-45,-34,72,48,67,-56,-33,-71,-69,29,-12,41,-69,-113,-108,-96,-15,-24,-109,11,64,80,-117,-45,94,59,-49,-13,29,38,51,-6,-21,96,79,-50,-27,-17,-36,-53,12,-4,-19,-78,102,16,54,85,66,-72,-71,-4,-67,18,36,-75,87,-38,99,-69,87,104,118,-25,96,-59,103,10,16,84,-31,-28,87,-86,-18,20,72,56,-32,39,-39,72,66,-2,-50,-35,80,-16,50,78,-69,45,-115,87,45,-52,20,19,-14,65,-67,104,-61,-70,58,51,-48,95,-112,11,64,80,-37,99,-81,112,-67,125,-97,-2,-22,-103,-7,30,10,112,103,95,-40,-69,-43,-87,58,19,-50,-119,121,-13,10,16,84,14,65,-40,-50,-15,83,24,-65,-99,37,-42,20,-32,94,127,115,-19,47,83,-101,94,120,-104,121,78,94,-115,68,-36,-7,-53,15,-21,-72,-7,-49,-108,105,28,69,1,2,-10,121,69,-107,-69,87,71,-71,117,-94,121,21,32,-88,-84,-78,-65,-21,-73,6,14,-80,-58,22,-115,-112,-65,115,-73,109,26,-93,-99,-85,55,39,83,126,76,-61,8,-7,59,119,-97,-88,40,-22,78,24,-86,-114,-99,-90,10,16,84,-124,85,-44,-86,-98,-69,58,-101,-115,-33,51,101,23,-128,-128,29,-95,-107,-36,-67,-16,-24,102,-65,49,118,14,-72,-77,-49,43,102,-26,-113,-35,52,42,-13,-31,-123,124,-64,-115,47,-108,-22,-16,-46,-36,10,80,-128,-96,78,-50,-52,-5,-78,-100,-119,-100,-37,-85,44,86,-35,-96,0,119,-10,-115,-102,-67,51,-43,12,115,-89,-25,-62,54,41,-105,15,-72,-101,-3,-90,-27,62,-65,61,90,-53,44,58,-82,0,65,-123,95,122,-43,-19,87,46,124,66,22,54,17,-14,1,-73,29,2,99,57,-81,4,-54,-119,-98,-44,10,16,-80,-93,88,-49,-23,57,-108,81,-25,-59,28,72,5,8,-39,-73,-33,-47,5,6,-55,104,-126,-99,1,2,118,44,-82,94,-99,55,-120,99,-127,-27,-64,20,32,96,55,11,36,-99,-33,31,-50,-89,81,48,110,38,30,126,-47,-79,-50,-44,56,-30,19,-119,25,-69,92,-4,9,51,-70,87,-6,122,78,-3,95,-14,-113,-34,-10,-62,-73,97,-95,12,5,-72,-77,103,-20,-27,-30,98,-72,8,-3,111,-74,80,-72,124,-64,-115,13,113,86,16,-83,110,47,-48,-100,8,-74,-125,4,32,96,-97,-26,-91,-99,95,126,-95,58,-67,-45,-14,88,46,31,-44,-10,94,9,-71,115,-73,-103,-75,-7,90,8,15,-77,-38,94,-127,8,-8,81,-23,-76,-41,41,93,-15,98,51,-91,-25,-128,-128,29,-86,98,28,-33,127,119,-68,-40,70,63,-86,0,4,-20,118,112,-71,-30,-104,-67,-16,-37,89,29,-100,-112,-65,115,87,-28,112,-5,105,-24,-104,-39,-13,-78,15,69,-107,-82,66,-124,-49,62,-25,46,-82,-26,-49,-114,-105,-55,74,99,21,32,100,-49,99,38,95,-9,100,-26,72,77,76,15,40,68,-64,-65,-32,107,-5,42,-23,-122,-70,42,22,22,-108,-120,-112,63,55,-33,-122,52,-16,46,-23,-103,36,0,-113,-40,101,-83,-65,2,-124,43,-89,-66,-107,-47,110,20,115,-78,-36,-104,2,4,-20,-88,92,-40,-45,-43,90,110,-37,52,-103,-42,-6,43,68,-64,-113,-22,-78,-45,-24,-55,-74,-52,108,123,-77,-108,-83,2,60,99,-73,3,104,-48,101,35,0,1,-69,-87,-24,-30,-102,-17,-20,-105,-62,42,103,-28,84,-2,17,55,-118,-43,89,-40,81,-56,7,-36,-40,-58,-66,54,58,103,-12,4,80,29,-81,16,119,126,-92,-48,-57,112,93,-125,-39,-100,-109,101,-121,37,-31,87,-120,-128,127,-63,-50,41,78,24,75,96,-78,-57,23,-128,-49,-40,-65,-65,26,9,78,-101,41,-91,95,-1,-38,64,-115,125,45,41,74,95,8,-31,56,-32,-6,109,-20,-65,-63,15,71,29,-45,62,-83,-110,-127,104,-30,106,-47,1,35,-91,-55,79,-1,-120,127,-96,-58,-25,108,3,-18,123,-101,-106,100,118,-125,-112,127,18,-122,-17,104,-95,27,-119,-42,120,41,-60,-99,-33,-108,-9,104,117,28,43,22,81,-109,70,-85,-120,21,32,8,-61,-25,87,-21,-89,-7,-43,77,71,-74,-59,42,-96,-123,-4,-99,59,47,-104,-44,71,-28,-88,99,-89,-39,17,-51,-102,86,5,-32,-50,110,62,75,25,107,31,11,-70,-83,-12,106,101,51,-9,94,34,-126,48,-65,-19,-105,-39,-49,72,108,67,23,-62,-34,44,118,43,17,119,-2,-127,-97,-74,-46,97,-62,52,-5,76,35,119,-106,41,-106,-120,32,-111,96,62,122,113,45,-64,-24,76,53,-85,-116,-14,43,68,-112,76,48,5,62,-99,-127,-38,10,94,-64,-102,44,15,-94,16,119,-2,-115,95,91,79,67,-93,101,108,-100,-60,34,114,18,17,36,44,-46,-53,-68,-116,-77,-46,-92,-103,82,25,-107,118,61,75,68,-64,-113,61,119,58,-108,-56,120,-104,6,101,105,34,5,-72,-77,-101,54,47,-90,-1,-100,-76,-7,-62,-99,-123,-27,20,32,96,71,110,-90,-97,-111,-80,-70,-79,55,43,11,-50,11,64,-64,62,-48,108,-99,79,89,51,64,-52,21,100,-87,34,1,8,-40,-51,-108,-34,-29,84,81,-43,28,-89,-98,105,-74,91,34,-18,-4,-74,100,-109,105,-92,113,74,23,116,100,-77,119,35,0,1,59,-50,-28,117,58,7,-43,-12,121,-87,-44,52,-108,-120,-128,-1,-57,57,118,74,-81,-7,-102,-85,118,-74,44,21,34,72,-44,85,-104,-115,103,38,-75,46,-68,75,-45,-30,44,85,39,16,1,-1,122,85,59,58,-49,-89,65,-76,99,51,119,72,1,-126,84,-96,-19,8,20,3,-97,-62,-40,-125,-52,-95,80,-128,-128,-35,-52,-32,-35,-21,-7,75,-95,114,107,101,85,-108,18,17,38,50,-5,72,103,-46,-96,-94,-72,-69,23,86,16,32,17,119,-2,110,127,-38,-44,-47,-7,99,-19,124,75,59,-77,-48,-108,68,4,-4,102,91,-44,-103,-99,-76,-87,-12,49,-39,-37,23,-128,-128,29,-55,-27,126,38,-8,32,60,6,-21,-40,81,-128,-128,29,-119,-126,117,126,-88,-47,-52,41,-90,-36,76,60,96,-34,47,-77,62,-117,123,12,20,-38,11,114,-127,8,82,-44,40,116,-104,110,5,99,9,100,86,-43,-92,0,65,18,25,-97,-56,-107,-65,67,-73,-102,99,-52,44,76,-119,8,-8,-79,-67,-45,116,-57,26,-50,-4,-52,-52,99,-119,8,-46,-44,72,96,-73,-77,86,9,-57,-59,42,-103,37,-41,36,34,72,84,-93,54,119,57,-101,-56,52,86,-33,52,-43,43,0,119,118,76,58,25,-61,9,-93,75,-102,-103,32,66,62,72,-11,98,-34,-58,-23,79,-10,-21,-96,99,-53,70,-56,7,-87,94,100,-128,-46,-103,-94,-20,-48,-29,-85,-78,60,-78,0,4,-20,87,96,-1,116,-65,-70,-103,19,109,51,3,65,1,-62,52,117,-82,103,-52,-71,95,126,-10,-34,-20,-91,11,64,-112,72,70,107,-118,-21,-104,64,98,49,-47,-2,19,5,8,-109,-32,107,-98,-63,-111,-127,92,-1,98,-123,-73,66,62,-32,70,-102,-30,-52,-127,32,-75,48,90,105,-12,-55,57,32,76,-127,-81,-75,-49,16,-42,24,56,-101,-103,-110,84,-128,-128,29,-97,-24,76,105,-113,-123,-116,-7,96,-71,1,5,8,-40,81,-56,125,-2,78,124,-96,-59,12,50,46,30,-92,-41,-77,121,44,-25,-92,35,93,-87,38,-28,3,-18,-118,-77,-48,21,113,38,56,-93,-116,-102,-119,7,-52,-24,20,-23,111,85,-118,34,109,-49,-27,-61,-126,-125,-100,-77,75,55,-53,-126,79,5,8,-40,-15,-39,-53,89,64,-96,-109,-33,10,16,-78,-101,29,-18,50,-27,56,43,105,-59,1,-105,15,-72,-105,57,84,109,116,47,-52,107,-101,21,32,44,-60,48,51,51,-69,71,65,57,11,-53,50,40,64,-64,110,127,-73,-12,-26,-124,81,19,50,89,-96,73,34,2,126,44,93,87,1,117,-43,91,53,-90,21,-71,124,-64,-115,-27,-107,92,95,7,-38,-113,104,9,-97,2,4,-20,104,-118,-14,27,-38,-36,-83,49,27,-85,-105,-112,-120,-128,127,95,-114,-32,41,-36,95,59,111,-42,61,-85,0,65,-127,0,-66,82,115,-43,-118,24,-102,103,7,38,-83,-10,16,-120,-128,-65,98,120,82,125,-109,54,75,-118,22,32,112,-64,-109,50,27,88,36,-125,38,73,-72,124,88,74,-110,-42,114,93,82,95,-112,115,64,88,-104,81,-13,-23,116,-30,87,-26,86,-103,11,-81,0,-113,-54,62,42,10,45,89,-105,-91,2,-124,111,-67,-52,-30,-38,34,-66,96,-25,-128,-49,-40,-65,63,-121,82,-20,20,-21,-23,76,87,-102,-62,53,-101,-88,68,-17,85,74,-57,-119,-126,-113,-8,51,98,86,-69,-107,-73,-54,-69,-74,-23,28,31,1,-72,-77,-37,89,-43,-73,59,-62,85,-93,4,23,15,-104,27,66,-64,-27,-83,4,-116,31,-101,10,16,-80,-41,23,-90,-47,-99,-22,-72,92,26,-115,13,-88,17,-128,-128,29,57,-69,-19,-86,-5,49,124,105,14,118,44,75,68,-56,111,-2,-22,25,59,124,-64,79,17,1,-65,-23,99,83,-9,-11,3,126,-127,-72,-13,-49,-3,-78,15,-27,58,58,-21,-43,-103,-57,34,106,18,17,-16,-49,87,-35,-51,-43,-78,86,-40,9,44,-38,-88,0,1,59,-58,7,-69,81,78,56,13,51,109,-45,84,-128,-112,125,-82,-30,10,-108,-65,100,103,-128,-112,-67,-50,-10,38,-37,-23,84,44,42,30,50,-25,-103,-4,25,46,-115,10,-119,120,-58,-113,14,11,22,101,84,-128,-128,29,45,127,46,26,15,-31,109,-117,-126,-82,72,-127,8,118,20,122,-45,-73,-1,72,-14,112,-106,-120,71,-6,12,99,61,122,102,-107,-22,18,17,-16,111,-45,-92,-43,117,113,125,-59,47,16,-63,41,-43,-52,-25,41,-5,-23,-70,-92,-30,-9,-13,53,97,-48,-58,42,111,91,-69,109,86,-64,-85,0,1,123,67,-109,-113,-73,-95,-108,-90,81,-128,-128,29,107,-84,-75,-10,-100,-99,3,-126,-22,-115,-122,126,-30,-11,-100,93,0,66,-69,102,-10,-26,-38,21,80,-125,-122,-92,14,-73,107,40,-30,-50,111,-22,127,-19,115,-58,-23,23,71,-108,2,4,-20,-73,113,65,19,9,59,-42,16,35,-28,-17,-36,13,103,125,-10,-47,-125,118,21,-7,-48,-18,85,-127,8,-8,-79,-60,-86,-1,-91,-46,-81,-106,-120,-128,31,83,125,-38,-37,-61,-92,69,39,103,112,-7,-128,27,-93,30,-38,118,78,-8,-43,-123,66,7,59,41,-60,-99,-65,23,-52,-68,112,29,87,50,-94,-95,0,1,-5,-67,15,24,-79,-49,-54,14,17,5,8,-40,49,117,-89,38,103,99,-55,48,-107,68,4,-4,102,-117,-17,-19,-52,-108,-126,16,69,99,17,60,-119,8,-8,49,105,-29,45,122,-13,5,-65,64,-124,-4,-83,-44,-2,56,22,-90,0,65,45,26,42,-41,-36,72,104,44,4,91,-36,108,97,10,64,-64,-114,-12,-86,-113,-54,-23,9,8,2,-16,25,-5,-73,-5,-65,65,-67,-51,70,92,-67,68,-95,40,37,-4,-76,-102,71,-79,103,123,-31,126,-24,-37,-64,53,46,76,19,42,-64,-109,103,-65,102,-112,-37,-23,-50,114,-80,10,17,-108,82,-39,127,-103,111,19,-127,23,-22,-39,-39,21,9,18,17,-16,-101,-123,92,-105,-97,-21,-113,-121,97,-59,72,10,16,-80,35,93,-75,-86,-81,56,-57,56,102,94,8,38,16,1,63,-54,2,-3,-123,7,57,-31,-66,6,118,3,-125,68,60,122,-2,-116,44,46,29,73,47,17,1,-1,54,77,-100,79,3,-4,-86,-56,-81,-103,13,-72,-110,-120,-121,-4,3,-61,-68,-24,-13,11,-60,-121,-4,-33,-81,85,112,117,-64,56,-125,94,123,-94,-43,38,-68,-77,71,9,-57,27,-13,51,118,-124,-107,-102,-97,-57,59,48,35,-99,42,45,-123,8,-7,-117,59,-75,109,-101,-103,6,-81,44,115,-95,0,1,59,-118,123,-110,47,-91,-57,80,121,-74,-20,20,32,40,75,65,-103,70,61,-85,111,-82,94,-115,66,-37,106,36,34,-32,71,105,85,105,-21,3,126,-127,-8,-112,-1,-5,87,53,-26,-72,-104,-6,60,7,123,34,79,-36,67,-107,33,-91,73,-115,-28,-9,-15,127,-1,-113,-81,-29,-43,-101,75,64,108,20,15,-44,112,-36,-121,16,38,21,-124,-33,-59,-2,-101,-24,-78,-67,-38,105,55,-93,-63,113,-60,-91,-91,66,-104,-22,-78,-25,-20,-56,-115,-51,113,22,-65,111,-108,88,-52,-51,2,59,18,-15,-28,20,-3,-126,95,34,-126,114,118,92,105,85,-26,115,122,1,8,-40,-47,36,49,63,120,120,1,8,90,9,-54,43,-115,-110,-36,-77,-40,65,-111,89,115,-87,2,-36,-39,123,71,-4,-63,13,-56,53,77,62,55,117,-44,37,34,-32,111,-81,-102,-106,127,24,121,-56,74,68,-64,-113,15,53,-68,50,-6,-126,95,32,-126,-73,-33,109,127,-9,-13,88,-61,-53,52,-25,-110,-103,71,2,16,-84,28,52,101,-72,-95,-107,-5,-70,-62,-122,-11,46,41,64,-80,107,81,0,-36,79,-37,-21,-85,-125,64,33,-126,114,115,-20,-15,122,22,-70,-22,-90,106,5,8,-108,45,-26,-1,-100,110,-60,-58,60,-49,54,-24,-4,35,1,8,-54,-87,-51,-108,115,-105,-48,-19,-123,-95,-20,-76,61,-124,-53,7,69,-67,-80,14,-36,-51,-123,102,-19,34,-16,76,29,74,-123,8,-84,15,-104,90,-18,70,-82,-81,-8,21,34,-32,-57,-40,56,-41,127,-115,31,-101,22,75,46,41,-64,3,-69,21,-97,41,-75,-62,-83,110,14,8,-40,17,-31,-17,-43,-67,73,-52,-93,103,59,74,1,-126,-126,100,-116,70,89,-61,109,110,25,-121,16,-128,-80,-100,-70,-108,-27,86,-63,117,105,19,27,-56,-95,0,1,59,-58,-128,-12,-44,-98,-77,115,-64,-1,-125,103,31,-35,111,63,92,-29,86,105,99,-120,0,4,-20,-88,-127,58,-125,-73,123,98,-128,2,-69,69,71,-56,-121,37,-20,125,-66,-115,-4,-49,24,113,-54,-70,42,4,32,40,96,71,-100,118,-69,-77,24,-65,-100,-33,-17,36,17,31,-14,127,-65,-59,59,16,-74,61,91,56,-81,27,120,106,-72,89,-72,44,85,-127,-33,-63,-3,-3,63,26,51,116,-122,-81,13,-61,53,-70,59,-70,42,86,9,-109,-109,-27,35,118,51,-19,114,59,59,-122,-52,67,120,45,-45,-20,-76,7,72,32,2,126,-37,56,43,-97,-122,-17,66,-81,76,-94,-42,-108,68,4,-4,-73,-90,-98,-123,126,-106,70,-85,-117,37,-30,17,63,-38,-67,19,77,30,72,-60,51,-2,-15,66,-1,28,91,-43,10,-15,-116,31,37,-95,-20,-82,60,5,8,-51,-98,102,-102,-80,60,103,-25,-128,-128,29,-99,-118,-67,-8,23,-103,54,-101,39,37,-28,-125,-3,-114,97,-115,-21,44,57,91,-105,-57,-76,-24,-70,84,-120,-48,-28,-79,109,-31,22,25,10,-84,-23,37,-61,92,62,116,-4,-21,-12,-9,25,12,84,108,14,102,-84,9,64,120,0,-104,39,-23,-10,55,102,-27,44,-34,32,-59,1,1,59,122,-39,-22,-88,-49,-39,57,-32,94,-65,124,13,-101,76,-113,-55,-123,-4,-99,-5,74,-112,-10,-77,-110,-6,11,114,1,8,-40,-95,-95,107,123,78,78,-27,-17,-36,21,-73,52,-65,-53,-114,69,-21,-35,-71,-4,-99,-69,-95,124,125,-66,-3,-58,100,-117,-115,61,-72,0,4,-20,-17,-29,68,-41,64,45,126,99,53,58,10,112,103,-57,-99,5,-3,77,26,23,43,-77,-93,79,1,2,-10,-21,-10,-107,-19,-50,-79,107,-108,38,-3,-90,10,113,-25,-65,126,-40,56,91,42,22,-30,28,-115,77,-106,86,-128,-128,29,71,98,117,-101,-70,-29,-53,85,-42,123,44,17,1,-65,-23,106,68,-65,30,-37,5,18,113,-25,-57,5,-87,-69,-81,-25,118,-121,68,60,-27,79,60,-59,43,17,33,127,-35,103,-15,10,46,82,50,15,-118,125,92,46,31,112,-29,-42,-95,-77,-18,102,-95,-35,50,77,-38,27,36,0,1,59,-116,-63,-27,-52,67,20,111,-46,-82,38,46,31,112,87,51,78,78,7,114,-95,2,111,21,86,107,-95,0,1,59,-70,1,-50,27,-25,23,102,44,53,86,-105,38,-28,-97,112,39,-84,7,-38,68,-54,-27,-61,-73,98,-2,-53,-37,21,59,-67,-47,-10,87,46,31,126,-51,-26,27,112,80,62,75,-101,48,-119,116,-72,-66,71,-86,-82,13,111,96,-73,-47,11,61,37,-30,-119,126,-103,40,118,-23,-20,-2,13,5,8,-40,49,-112,-45,63,10,126,-7,100,-73,-28,42,64,-88,123,125,-93,44,-124,-15,-45,-71,-26,37,-14,1,55,74,-111,-109,107,-75,-64,16,-124,74,3,-119,18,17,-16,67,-91,53,55,118,29,109,-72,-91,50,-105,64,34,2,-2,-21,-58,-76,-15,1,61,7,4,103,-10,120,-11,-30,46,50,-63,-7,-34,51,-85,37,87,-128,-48,-102,-87,-85,-72,121,-6,48,-38,-10,-96,-51,-86,10,17,-40,121,120,-109,-53,-107,36,-38,-86,-18,107,83,-117,67,33,2,27,21,122,-61,-75,90,-32,96,-88,44,43,37,-28,67,-81,99,100,-41,38,50,-79,-122,-23,112,37,46,31,-8,75,112,33,-122,-85,22,-60,-95,67,39,-40,112,-7,7,-95,-19,105,62,-89,-3,3,123,110,46,31,-8,-88,112,-59,-101,107,-102,93,-16,41,120,-52,-97,3,-98,-79,-93,12,49,-45,-72,-71,66,4,-4,118,-12,-82,-10,9,61,7,60,41,-57,-8,-110,94,32,66,-2,-9,123,59,-66,-26,-89,-120,48,-31,82,115,113,125,93,11,-102,-118,14,-83,-112,-120,48,-66,49,-35,-60,-61,-71,80,24,-50,-86,-91,-123,-4,71,-36,-33,30,43,-123,-117,-34,-110,107,45,-104,-120,-59,-25,-48,95,20,-62,52,0,-16,1,59,-38,108,-118,-13,112,-82,-101,23,-88,-6,22,-128,-128,29,-107,102,46,2,-124,-27,67,-5,-58,-87,120,-96,-73,49,5,98,-25,51,114,-75,-82,-53,11,-24,109,21,10,17,-16,-93,93,-94,-70,-16,-46,-124,52,107,-38,83,-128,-128,29,107,-21,108,119,90,-105,117,67,7,83,112,-7,-113,-72,-65,63,-22,-33,-96,-33,-36,-48,-8,107,-11,-107,120,-10,23,23,38,-39,-22,15,-40,123,-59,127,58,-115,-94,-123,75,-90,10,-67,-91,-125,-53,7,-36,-5,-107,-25,89,107,49,49,107,-107,22,-105,8,-7,-64,-126,-126,-15,-29,-122,-114,108,12,79,-31,-73,0,9,64,96,-3,93,47,108,122,-31,106,-106,46,-99,35,-60,1,1,-5,-27,27,-70,97,3,95,-47,11,68,-64,15,-57,-42,77,-53,-4,-30,-59,11,64,-64,-114,-1,-110,-99,107,-121,-56,-20,98,67,-100,21,-32,73,-76,105,98,6,57,53,-1,20,-32,65,-68,3,-81,-15,42,-121,127,26,-17,-8,21,-16,25,-5,-73,43,-111,98,94,112,115,121,-126,89,-82,-53,69,-29,81,-58,92,56,-4,-31,-97,-79,-33,-101,112,16,-1,72,-76,115,85,1,2,-10,117,-115,56,62,100,11,60,102,122,-27,45,-105,127,-62,93,-79,52,27,-19,-125,19,-128,59,-5,-83,-87,102,97,-120,97,97,-11,-88,66,62,-32,-18,-74,-18,-69,-117,-31,-94,13,-59,62,16,-21,101,82,-120,-128,31,-109,64,125,-114,11,-111,62,22,-41,16,-14,15,86,-93,29,87,-104,-1,-11,124,53,-2,10,8,-40,109,37,-51,-74,-100,77,-127,-8,13,9,-104,10,-7,-128,-69,-67,102,113,87,-85,107,106,38,126,103,70,105,-123,57,-106,103,-128,114,-32,60,100,-125,-15,20,32,96,-65,93,-32,-71,6,102,107,-47,11,69,5,-32,94,-55,-120,81,98,-37,93,103,-33,49,-39,101,111,-78,88,20,32,96,-65,93,15,-118,-120,118,98,-111,24,33,127,-25,-50,-72,-64,115,-8,68,-53,-91,-59,-103,81,41,17,119,126,12,0,105,-19,28,73,9,-23,86,18,75,93,75,-60,-99,-1,26,16,-23,-98,-27,71,108,-108,-112,83,-15,59,115,27,-72,-121,37,-99,-53,-85,97,121,-47,-42,44,1,8,42,119,-47,103,53,-69,-117,-11,79,76,59,102,86,-124,68,4,-4,-26,-104,-10,-77,91,121,-95,-59,56,47,-54,78,-27,3,110,116,53,-51,-57,105,13,33,31,84,28,-37,82,50,59,120,120,-31,73,-43,-82,2,4,-20,21,67,10,-38,-37,-93,-12,-60,6,-3,40,64,-64,-114,-38,-19,-31,-46,114,13,42,-125,85,1,42,64,-56,-66,-13,58,-53,-121,33,-100,54,-67,-8,87,0,-62,74,-17,90,92,-110,-27,-14,23,120,-103,119,40,-3,-112,-73,-95,-84,-18,19,-22,31,-128,71,-20,-56,-20,118,-90,-43,21,-32,73,-11,-5,-62,80,-20,60,88,-13,-95,0,60,98,-57,101,53,-44,56,82,-128,71,-20,8,53,12,-38,56,41,0,-113,86,58,70,-103,85,122,47,-89,68,-124,-4,-39,-113,-87,66,75,74,-89,103,6,-105,127,-62,61,-82,2,18,22,78,80,-128,39,-20,-3,10,32,-47,-99,68,-27,67,-19,53,-74,-53,-128,64,23,-27,-60,110,-110,81,-128,-128,29,87,88,-72,89,55,-40,26,116,122,-88,-112,15,-71,-53,112,-9,74,127,-55,77,-28,-61,19,-29,-19,-22,-112,-81,-56,57,32,100,47,-83,-69,-127,43,13,-71,28,-66,90,56,32,60,73,75,114,67,-16,33,108,-114,10,61,-90,57,32,96,-121,37,-107,-6,115,114,42,31,112,-93,21,-57,-51,71,-58,-38,-78,-91,76,27,-77,20,34,-80,-21,96,-113,-72,10,-58,-39,-80,-91,-39,16,18,5,8,-84,-46,-21,-10,17,-1,26,17,-120,-91,-43,-102,18,17,88,-20,-72,32,-92,121,105,100,-46,50,43,52,-109,-120,-69,55,-77,-31,-79,-67,-55,78,126,-89,-96,-112,15,60,60,56,-8,-55,107,13,-51,-82,16,-127,95,-115,-127,40,46,21,-6,5,-67,0,4,-15,12,-36,6,48,-3,53,-83,72,114,-117,-15,47,68,62,-32,-82,102,-7,13,119,113,45,74,-124,-51,120,96,-13,77,20,34,-32,-57,52,-108,-22,66,-76,29,102,21,107,-59,80,-128,103,-20,48,101,105,-52,65,0,2,118,-116,71,42,46,94,6,-105,-94,86,-106,-60,-109,-120,48,-38,-109,-85,-41,30,29,-5,-113,117,60,40,-64,-109,-24,-96,46,98,81,-128,-49,-40,-65,61,44,90,51,-82,49,-101,-2,-93,-43,20,109,22,46,74,60,-1,15,-104,113,81,91,58,55,45,-100,120,-77,-124,89,-71,-86,68,4,-4,-16,-53,102,119,-27,-54,-16,109,-40,61,-112,10,16,-80,35,106,-27,-58,118,-24,-110,117,5,8,-40,-19,-83,-7,-110,98,4,80,-23,64,25,42,30,48,-101,-53,-34,91,89,-2,49,114,-89,125,65,18,17,-16,-65,95,98,-121,-72,-46,90,-101,-91,109,20,32,96,-97,24,70,-23,-62,86,13,-119,12,90,117,40,17,79,14,-27,47,98,34,2,-16,25,-5,-9,-25,62,6,-122,-94,53,55,-12,122,35,15,20,-75,49,40,97,-94,59,63,96,71,-40,-53,-33,91,-114,19,-120,117,100,81,-23,39,-42,-21,-62,-68,61,122,5,34,-105,15,61,-87,-75,-105,43,-123,91,-72,-17,-125,13,-95,83,-128,59,59,10,-115,-86,107,8,-98,87,71,38,-31,-90,-30,1,51,46,126,57,-61,-58,-88,123,89,-107,118,96,41,-64,-99,125,-101,-25,89,-89,-45,-16,95,-48,43,68,-64,-113,75,113,-68,-53,-8,21,-65,64,4,-4,-72,-49,-89,-28,-10,1,-65,64,4,-4,29,-109,8,-33,126,108,41,52,42,-63,-27,-17,69,14,-55,-66,56,-78,25,-121,-80,-88,46,-26,-30,1,51,6,-42,-44,-25,-123,64,10,-16,25,-5,-9,87,64,53,-28,72,-57,-71,13,-37,53,-17,-93,70,-41,120,74,105,82,35,-15,125,-4,-33,-1,-29,-17,69,10,-90,52,94,105,69,-47,28,37,-4,-76,4,-30,-1,-112,-3,55,-8,-31,-80,-106,-21,105,64,95,3,41,86,24,83,-111,-46,-76,-72,-28,3,-2,116,-35,-118,-32,-82,-38,-59,-67,104,37,83,126,-123,8,-7,-117,-101,-103,13,-31,93,-7,77,85,2,16,-80,95,55,-98,120,105,68,78,90,103,123,66,33,-126,-30,101,-44,-70,-20,-45,-50,-58,63,-103,97,79,43,117,21,34,-32,-65,-82,63,58,79,28,92,27,7,31,-101,-11,-128,43,68,-8,-4,-39,-23,-43,6,-53,-121,78,-109,20,-14,-63,-69,-121,-69,-28,98,13,-19,26,-73,72,-41,13,-107,15,74,38,-81,72,-35,121,-110,-75,-123,-85,101,39,59,-99,36,34,40,15,-4,-47,70,113,8,-49,43,-85,-57,94,-116,2,4,-123,114,-88,14,118,67,-101,-38,-68,66,-64,108,-60,-123,68,-124,-59,114,105,-50,124,42,106,-36,-61,90,104,-27,-92,0,-124,5,97,-7,28,89,-127,-42,-18,93,50,125,53,92,62,40,7,67,-111,-20,-103,54,-63,-59,-93,-85,-18,73,-101,119,56,32,96,-65,53,-76,64,-13,-51,-67,-23,49,-95,16,1,-1,-107,-25,-3,-124,-98,3,-62,119,-109,-90,-69,-115,18,-123,8,125,-48,43,-102,4,32,96,71,30,-26,-12,85,-38,-113,-39,92,-20,94,47,46,31,-106,87,-66,-35,-23,120,77,-35,48,47,-128,-98,81,2,17,-84,119,60,-53,-39,40,126,-107,-52,23,-34,-25,44,0,97,-55,108,65,-11,-38,-71,-9,-78,26,98,36,17,97,-111,118,113,-95,-10,107,76,81,-91,121,87,5,8,52,-27,21,33,117,-9,-128,-62,73,-94,29,-97,92,62,-48,-16,8,76,-113,51,-99,-121,73,63,-87,101,122,41,-103,66,-124,39,-56,-50,110,-104,120,-69,110,-98,95,-76,-15,72,33,30,89,7,-21,-14,124,-23,-19,-92,10,-15,-116,-1,74,-128,82,-117,92,33,-98,-66,-1,102,6,-53,71,-81,-1,2,4,43,-25,-54,39,-99,-101,4,-73,-42,-104,33,65,27,19,56,32,88,-11,87,-117,-91,59,-48,-44,125,-74,84,60,-36,-81,102,-103,15,-25,-89,-116,107,-82,29,-33,-82,12,16,-80,-1,104,120,-15,71,101,78,124,48,-127,0,4,-20,87,-107,-9,112,122,-49,124,-33,-55,66,-79,10,16,-24,73,-60,112,106,114,-62,-56,14,-77,-22,20,5,8,-83,-114,-79,118,125,78,78,-27,-61,39,-73,-41,-26,-66,-1,-107,-112,-89,99,55,37,-30,-103,111,-117,16,122,-90,-115,17,10,17,-16,-93,95,-32,44,21,111,87,-123,8,43,-107,18,-14,-31,-23,-41,-118,-69,-31,-27,-102,88,-45,-40,69,121,10,16,126,-43,-78,-50,-106,-81,-85,-111,-111,79,102,84,-128,-49,-40,-65,-33,-77,-58,-99,94,-43,-103,-94,19,-82,87,56,-2,79,9,-109,-34,-127,79,-40,51,-58,123,-100,-13,43,113,-16,-50,76,-67,94,46,31,114,119,-45,56,-29,20,70,108,110,81,45,-94,16,79,20,44,14,-106,-110,88,54,74,1,-62,-83,82,-46,-103,67,-58,-95,-120,107,122,-88,30,-31,-128,-64,20,125,111,-37,-2,42,-102,33,0,-95,3,-16,-42,-47,126,-51,72,42,124,-80,-116,66,4,-4,-56,-78,77,119,-85,59,6,56,-52,-52,-110,-104,18,17,-14,-25,-34,-49,28,56,-92,-21,-96,-67,62,2,16,-122,-47,-110,-117,-98,-73,13,-91,-42,-87,-41,43,0,-49,86,37,28,-4,-34,-97,-97,-5,-65,34,2,-125,5,125,-25,-25,42,-53,5,77,-18,-76,25,-111,-119,7,-5,21,1,57,-65,-73,-31,5,-14,-26,82,42,31,112,-93,-17,-34,-35,25,111,123,125,36,122,-29,-125,2,60,122,-25,24,-124,50,51,29,-121,-95,16,-31,-79,-97,-36,21,-107,-8,64,-77,-45,81,-96,10,-16,-60,45,69,-88,-84,-116,70,45,69,-123,8,-41,123,-103,-50,2,-39,27,-117,-126,-91,-35,20,32,96,55,-113,-11,-108,-124,-105,54,-88,-27,-49,-92,3,94,-52,0,115,38,-33,54,43,-66,-81,-63,44,33,1,8,-40,-95,48,-58,108,31,-48,11,68,-8,-12,-39,-101,-61,-72,7,123,21,58,-3,69,0,62,99,-1,118,115,5,-105,84,-81,-47,78,19,19,-57,-59,44,97,47,-74,-108,14,127,-6,103,-4,80,104,-19,116,99,-20,3,-40,-53,-24,52,-74,-59,-27,3,45,-123,48,-37,121,-41,10,46,-91,-33,-69,-48,-48,-106,0,-124,-10,-112,125,35,-9,40,48,-52,18,13,-121,10,64,-96,-93,16,114,56,-17,38,-24,72,103,115,13,-59,-60,31,-124,-28,96,98,78,49,-66,79,0,2,-5,-10,42,55,58,95,-31,-60,53,11,52,49,-62,-27,67,-37,-39,-68,-116,-23,-98,4,-29,79,-24,56,26,1,8,-40,97,-45,-116,-28,-124,49,-13,-100,109,113,46,31,112,99,24,-44,58,103,73,-61,-58,-39,-101,79,-65,83,-120,-16,-51,-28,-22,62,-1,87,-12,28,-16,-24,-101,34,26,-98,62,-8,-90,127,-109,15,117,-97,-71,107,78,91,32,7,79,-83,20,46,31,-98,-60,-39,44,-116,115,-57,-51,107,63,-117,-125,-104,1,-126,29,-6,-73,-50,-117,115,-49,-31,-42,-75,74,125,123,14,8,-40,49,86,-32,-116,37,67,-42,-114,4,-18,126,115,64,-104,-34,93,46,107,-11,-59,-93,115,-7,64,-65,96,-88,-27,74,-61,-21,11,59,108,-87,35,-89,16,-63,106,124,-97,76,8,-115,97,-50,-103,-104,-13,70,-28,3,-18,107,-64,-28,89,-119,113,-115,19,-100,-119,-107,-73,73,68,-64,-113,95,58,-122,-45,25,-16,-120,-87,35,39,0,-31,62,-67,58,60,-3,-34,48,93,74,-113,36,-123,8,-8,-33,-89,-15,125,73,-49,1,119,118,-36,67,109,-66,-5,41,-115,120,105,99,85,112,10,-16,25,-5,-9,-37,88,-16,-100,-58,-7,-61,71,66,-111,87,-114,-36,29,37,28,91,88,-97,-80,35,44,87,74,58,23,-88,109,-85,-105,25,35,-20,-75,10,64,-32,-86,33,-77,-32,30,-91,-40,23,110,-12,-90,88,5,8,-116,67,-52,36,-54,-89,-84,41,-71,69,-51,55,42,-2,-116,121,46,-70,-44,-88,120,24,-55,79,-13,-12,-27,-66,-96,-26,-14,-31,97,105,-69,103,62,-2,-108,92,-2,73,-112,102,-32,-10,100,-111,101,-26,-128,80,117,-8,-95,-84,-93,-4,-104,47,-60,53,7,-111,15,-43,-98,31,-104,-126,95,-103,51,29,-125,-61,-27,-97,-28,-10,71,-63,117,8,-12,60,16,-128,-48,20,-9,-77,36,71,-59,0,113,90,10,-82,0,97,-96,96,-19,-68,79,97,83,19,-123,94,-11,-85,0,15,12,-108,81,-31,113,80,-29,-121,-119,63,8,-49,12,83,26,101,-14,122,67,42,-1,36,19,-10,5,-71,0,60,-47,-122,95,-112,83,-7,-112,-69,-116,82,63,-31,38,-14,-95,-50,90,-5,-20,0,-128,-20,90,-44,123,-32,-14,97,-32,125,-27,82,-122,23,78,-109,122,15,2,16,-84,113,124,-5,-34,-4,-122,40,-103,79,-51,22,-128,-48,-108,93,-82,-5,9,123,121,-46,-37,87,-123,-4,71,-36,-33,-97,-94,-38,-72,88,-30,-100,6,-126,27,56,103,75,-31,-50,22,-62,-15,-49,-2,-120,-3,62,-124,12,-91,32,125,-13,10,62,-123,120,112,26,124,-107,-91,18,-128,-128,29,-109,37,-50,38,-48,43,-103,-67,-23,-116,42,5,8,-35,-8,-35,-50,-47,117,-3,42,32,74,52,52,35,0,-113,76,96,4,72,70,-85,-116,94,33,2,-2,-6,106,125,59,15,20,-9,-124,-80,-82,125,33,31,112,-93,-38,-49,89,50,9,78,28,75,116,83,-15,96,-75,-61,-61,58,-17,110,27,-24,114,-101,60,-107,33,0,1,59,102,75,-72,7,-55,-80,6,120,22,70,0,-126,-32,44,102,99,-71,71,-63,-96,-51,-102,-56,-9,20,-14,1,-9,126,-11,-7,38,-70,26,-19,-34,19,-14,-127,-57,-125,-98,46,87,-67,9,-23,66,59,-20,20,-32,-50,-114,63,92,114,118,-62,-120,86,16,110,42,30,48,-29,49,-46,25,54,-69,124,49,83,21,-20,-63,21,-30,-50,95,113,-119,104,111,-61,127,-3,-38,-103,-103,-84,0,119,118,84,-58,-52,126,122,49,-24,69,-83,-20,-66,74,33,127,-25,-18,-72,-66,117,-72,13,-121,8,14,-85,120,19,-14,1,55,-18,-12,115,-34,87,-62,-46,90,-84,98,76,1,-18,-20,40,-33,-79,23,118,70,88,-80,-61,-25,100,-111,54,-119,8,-8,-15,48,-19,45,99,81,-19,45,-78,77,42,0,1,-5,50,15,111,-42,55,13,45,-94,-7,18,17,-16,-17,-41,-98,-82,-126,99,92,-9,-69,-78,53,-61,-27,-97,112,119,-28,-119,88,37,-116,-112,127,-62,-83,-49,105,5,8,-40,77,37,-41,-77,-80,-3,10,16,44,106,33,41,64,-64,-114,91,97,-57,-39,14,-15,69,118,93,34,2,-2,-116,20,-38,-71,0,-46,-107,110,100,-98,-66,2,4,-69,117,97,70,-75,-85,126,-128,54,-35,-84,-106,68,1,2,118,-36,9,-101,93,27,13,42,77,23,-13,-57,21,32,96,47,-26,-18,-98,101,99,-78,-18,-107,-117,7,-70,23,119,63,-98,79,113,101,68,88,25,32,23,127,-96,-43,-37,53,-52,-115,14,97,81,-128,-128,-3,-70,-106,-5,20,-18,40,71,100,-18,-107,-112,15,78,59,116,-79,39,-41,-10,-45,-118,89,82,-107,-11,124,72,-60,-109,-45,-76,85,20,89,13,-42,10,47,17,-127,53,80,113,65,-84,-53,-37,-105,-10,-29,38,96,102,13,8,68,96,37,-103,17,59,92,-77,-62,53,9,-128,69,-37,-123,124,-64,-115,-102,-112,-20,-70,-11,-14,53,-100,-121,5,87,37,34,-76,30,-21,116,3,5,91,70,69,-2,100,5,-51,18,17,-16,-61,-82,114,-51,10,40,-3,-53,-119,21,-63,40,64,-64,-114,-31,-15,-89,117,-46,-82,-63,4,-12,-56,-26,-14,97,65,69,106,-53,121,-77,9,-34,-20,-94,27,86,33,2,126,-37,16,-43,12,-26,15,-8,5,34,-32,-57,77,-12,-37,21,88,-37,-101,92,-91,-80,-30,44,-119,8,125,-102,-70,-5,-37,50,24,-26,-19,-45,122,19,14,8,-4,49,120,41,-82,-95,14,29,124,59,-45,-126,59,1,8,-40,-111,-104,-87,-17,123,-92,-25,65,-5,7,21,34,-32,-121,-69,127,46,51,68,42,120,-110,-97,-118,-121,-52,-43,78,28,-9,28,3,89,38,-18,6,11,68,-24,7,-37,33,-32,26,-128,-48,-41,-79,-24,-51,95,2,-16,-64,-53,-122,-26,-77,39,-92,-55,114,1,8,-39,123,94,-29,35,118,6,8,-39,115,78,-82,115,-9,107,122,-118,8,-8,49,-57,-43,93,-7,-12,37,-65,64,-124,-4,105,-89,-6,-4,-61,82,-7,-128,27,-67,28,-91,120,89,115,87,104,-62,89,0,66,-10,50,125,-119,33,-100,-25,-55,47,-96,82,-120,48,-78,100,-90,-13,-2,96,75,113,64,-64,94,-82,-44,-116,23,-50,109,-47,-2,62,1,8,-40,17,-7,-53,-71,125,64,47,16,97,60,-81,78,-41,-112,-10,5,-67,0,4,-20,-72,-64,-50,117,-94,124,-15,97,5,32,96,-65,-82,58,-10,-69,35,-29,86,16,70,78,-27,3,-18,31,-41,-7,-100,-62,-88,-43,-91,-115,-54,92,62,-116,-49,-106,126,-50,118,108,-120,-2,-75,65,115,37,2,16,-80,-93,115,41,-99,-117,23,-51,-21,-68,98,-111,-53,7,-36,-41,-67,-40,-18,48,40,40,-17,94,-12,42,77,-123,8,-7,83,78,78,24,-125,56,-40,104,39,33,31,-106,-2,-19,-19,34,-128,-80,-7,115,-102,-76,68,66,33,-98,20,69,-102,51,-3,-22,125,-80,40,-80,68,60,41,-119,106,-59,-68,-45,93,104,3,-124,66,4,-4,-41,44,-77,51,9,-38,-112,-111,43,44,44,-87,0,97,-63,-107,-65,-81,-75,85,-52,-33,19,-7,26,14,8,-39,83,47,-50,31,-83,-105,63,-54,-69,-71,4,34,44,117,123,-69,-94,20,-2,104,-91,14,-78,2,-124,53,25,-91,-70,33,7,63,-58,-65,-46,-14,72,1,120,-76,110,42,52,-10,-92,55,14,115,64,120,62,-83,-28,84,83,-59,22,25,-76,9,66,0,66,-53,-96,77,23,-59,-88,24,-20,-67,104,59,-105,0,124,-58,-2,27,-108,-94,-27,-53,-43,-6,-11,-81,-43,-114,57,-117,45,42,2,82,-62,36,42,-16,1,-5,-67,108,-32,11,118,5,8,74,-70,-82,113,-96,-57,-50,-62,0,108,117,105,28,-107,-65,115,35,-1,84,-6,62,101,97,31,-16,-63,45,2,16,-80,-65,55,71,85,20,78,78,-38,-75,-50,-27,-17,-36,9,-35,-13,-3,12,-34,86,-116,46,88,-125,15,59,16,-120,103,-4,-104,33,-56,-21,59,20,34,-32,-57,96,-93,-107,-53,41,-115,-40,10,-69,-100,68,1,-98,-68,-7,-99,-47,-67,66,-69,-53,5,32,96,-57,-128,-81,125,-102,-107,-41,52,-69,74,-5,-77,5,32,96,-57,15,-11,65,39,-84,-126,65,-117,-72,5,32,-40,77,88,-64,-34,7,-60,28,124,-102,-52,-25,-14,-127,30,64,-43,113,119,-95,3,100,92,109,-65,-48,-86,81,-127,8,-8,77,-99,-26,-28,78,65,109,-49,9,64,88,80,-5,-34,-25,-114,-86,-54,-54,-26,87,43,64,88,86,103,122,-56,-39,-36,112,-113,-23,109,-9,92,62,40,-67,-63,-32,-23,55,-69,-55,-34,33,-11,-90,-71,124,80,-50,4,109,-22,-122,-9,-62,-80,89,-85,80,61,-96,16,15,10,72,91,-123,23,53,-39,69,31,10,16,-106,-58,-84,-28,70,117,-96,-3,-69,-48,-58,34,46,-1,40,-52,80,113,-73,84,97,90,64,0,-62,112,-17,106,-82,-111,-68,98,56,44,29,76,-87,0,97,24,127,-81,-111,-33,-52,-43,50,-24,13,-32,18,17,-40,27,8,34,22,23,13,-70,18,-93,-117,102,82,21,34,72,-47,-64,87,-56,-5,-51,83,107,-69,-45,52,-124,66,4,41,38,-124,-26,93,63,-30,23,57,26,1,8,-110,111,29,-109,63,92,-88,44,-101,71,-98,89,37,11,-105,15,82,-99,-26,-62,-90,-28,-118,-10,18,-84,109,58,116,88,34,2,126,-92,-70,124,-50,-30,-54,-26,-16,68,45,7,4,-20,13,-105,-127,-100,102,39,-126,44,-67,-77,-62,105,5,8,-97,-35,-114,-78,122,10,-29,81,54,45,79,18,-128,-80,84,6,-75,-117,-89,-11,118,61,10,79,51,115,64,-72,102,-54,-102,103,-35,111,69,-127,-29,-96,-23,19,1,8,-42,59,-94,-14,-25,-4,-127,-118,106,-107,78,-25,21,40,-64,-125,-124,39,110,106,-79,-3,65,-85,77,4,32,-48,101,-56,-122,116,-25,-86,-12,-21,-34,74,-90,-55,-88,-4,-125,-92,85,-67,46,-83,-32,-55,78,42,31,6,122,91,-99,94,-40,-114,-97,54,105,80,80,33,-62,96,-23,118,121,-100,-38,126,-36,-38,-56,99,-91,68,62,12,103,-62,-93,58,-65,16,-18,-109,17,97,94,14,120,80,112,122,-35,30,56,10,-99,-77,38,0,1,59,-46,32,-11,76,-29,84,92,-75,83,-87,-25,33,0,-31,87,45,-75,-70,-33,9,-29,103,-77,75,-12,20,32,-76,10,74,61,75,83,106,-75,-81,-74,51,111,-38,-25,-128,-49,-40,-65,-65,118,-67,-96,-9,-44,47,102,124,-76,28,-113,83,-31,-62,52,10,-16,-100,-3,54,-75,-89,44,-88,-54,-51,-89,76,112,64,96,66,95,119,34,30,-113,82,-48,-95,72,47,-101,19,-14,97,-35,-6,78,-25,-54,47,-72,67,-64,-76,60,109,60,-27,-128,48,6,-19,-69,-55,-117,-83,-51,-79,43,77,2,10,-64,35,-10,-6,-38,121,-46,-106,58,1,120,18,63,47,-48,103,-123,-70,-47,2,16,-80,-33,-122,4,-32,58,-93,74,-21,84,20,32,-52,45,-68,13,9,40,-104,-99,62,55,-101,19,45,17,-31,-69,-15,-77,-57,112,11,79,-86,-109,105,64,46,31,-58,-50,-57,112,55,-44,98,111,-108,-111,105,94,90,33,-126,-35,-124,-108,-34,-39,120,81,49,-18,127,45,-6,106,4,32,96,71,-92,-90,-100,107,12,-9,-88,-40,17,64,35,-126,10,-15,-60,-99,-82,21,-74,60,31,-103,-59,1,1,-5,-5,68,15,28,-78,-74,63,104,-113,-116,0,60,97,-105,-58,-112,-112,127,-60,61,-59,-67,63,66,62,124,-25,-91,-98,45,12,-72,-122,48,-11,76,19,105,2,16,-78,-101,-83,-19,34,-62,-19,-107,-87,-122,-92,-30,33,-77,-77,-127,7,-118,6,-38,18,79,29,-117,63,96,-122,-95,87,-23,105,71,-59,-65,102,-58,-28,-108,74,111,15,-27,-30,33,115,50,37,-12,38,61,26,13,-73,8,-64,35,-10,-127,-85,-68,55,53,48,20,34,-44,43,-59,93,-43,-126,75,115,-54,-18,106,82,57,3,-124,58,-73,-115,51,-8,0,3,117,119,62,-56,-123,-54,-121,-58,-8,24,103,55,56,110,123,-20,-10,-107,-88,31,-63,1,-97,-79,127,-65,-55,-71,81,-79,-47,-34,-78,90,-69,-20,80,85,11,97,90,-65,-11,-104,-3,94,-83,93,54,-50,-68,-60,60,40,5,8,-93,64,37,-99,-123,-26,101,-63,99,89,108,42,-90,2,4,-20,-88,98,63,-93,-92,5,-119,-92,93,105,54,81,0,2,-10,-114,100,-55,121,-65,86,-63,-112,-56,69,47,-90,-111,-120,-16,-35,-84,-20,98,70,101,99,-51,-79,56,-65,2,4,-33,21,53,-126,110,-104,-69,-83,79,-52,-91,100,-5,69,34,2,126,-60,0,78,51,-78,34,-93,97,-114,59,-117,-44,8,64,16,87,69,88,-89,-68,5,94,-122,-3,11,13,-85,114,64,-64,110,103,95,117,9,66,-52,-71,-17,-68,-2,90,0,-62,40,-45,94,46,-87,-84,19,-94,10,16,-78,-41,-23,70,52,-44,-123,99,-80,-80,12,-114,68,60,-30,-57,34,-53,-109,93,17,42,17,-49,-8,113,117,108,-94,109,-126,10,-15,-116,31,-59,-32,-107,54,-84,41,-60,19,-2,-122,118,-94,50,105,-1,-111,66,60,125,-2,98,-106,-39,7,-33,-9,-17,-120,-128,-1,125,-74,15,94,102,-27,103,-76,2,4,-20,102,-21,-27,-19,76,41,-44,113,-13,94,71,1,120,-58,62,94,-39,30,-27,19,-6,-1,66,4,122,1,81,-45,-13,-102,-51,47,-78,-11,10,16,-80,35,53,-29,34,-113,-70,-112,65,1,62,99,-1,126,3,6,-105,-12,-114,115,-106,-81,-7,-32,102,115,-122,-95,33,46,75,98,90,-33,-61,-3,27,88,109,-48,-45,-45,-67,-29,121,41,-46,-48,-73,81,-46,-60,110,-5,62,-2,-17,-1,-15,8,-3,-107,-13,-110,88,40,-79,-122,76,75,-28,101,112,97,-30,101,124,23,-5,-9,-41,-73,-35,54,22,-99,124,-54,69,31,-18,111,-50,108,106,101,-96,62,-9,-112,-35,-104,-123,-59,-58,60,40,64,-64,-34,48,-77,-58,-51,-121,70,-113,70,97,-114,-72,2,-36,-40,39,114,81,43,59,-39,-115,-119,-119,-28,60,19,-14,1,-9,-76,-65,58,-35,-8,3,-36,69,-77,-40,121,-93,0,119,-10,-100,94,115,-71,71,49,-101,-52,-42,30,-99,30,42,17,1,-1,-70,-100,93,55,93,-31,26,-76,71,66,9,10,112,103,71,89,-127,89,98,-25,-77,-96,106,-80,50,-49,78,1,2,118,44,-127,-77,-21,0,70,114,-23,-115,101,-128,20,-32,17,-69,26,68,39,-28,-97,112,-21,-95,104,10,16,-66,-11,82,-5,25,17,-44,115,-76,20,32,88,49,-37,-116,-105,51,-33,3,-73,42,-75,77,23,12,-107,15,-72,39,-22,-93,-49,9,43,13,-17,-112,-11,-112,11,-7,-128,-69,-101,35,-23,-38,16,-47,-126,-34,39,127,112,14,8,-40,109,7,-73,-13,-2,-28,43,-116,80,51,-77,-37,20,32,96,47,-104,-33,-28,70,-53,-95,-106,100,-79,-8,-117,2,-124,58,-90,-81,118,-50,18,-63,-59,-125,59,-79,6,2,5,8,-12,-29,126,-11,-31,70,2,99,-40,-126,89,-65,-20,-67,11,64,-64,-66,48,55,-60,13,59,67,32,117,-48,-114,81,-119,120,-92,-35,49,-43,108,53,22,49,-105,-120,-112,31,-33,-4,20,110,-81,-99,88,25,-114,-112,15,-72,-51,-13,72,-25,68,14,12,-47,-40,-123,31,76,84,62,-32,-18,-72,61,-14,-36,121,99,-94,80,-118,69,24,20,32,96,111,48,66,-36,16,72,92,-57,-78,-88,126,20,-128,-128,-67,-68,-38,89,78,58,-48,16,-77,88,80,-118,-117,7,-52,48,121,-6,-7,35,-111,-89,-91,121,10,33,31,114,-25,-19,-58,67,33,-47,-71,-23,44,25,5,8,45,-92,107,52,-6,33,-115,-2,-78,-54,-90,54,43,-64,51,-10,-118,78,56,-2,65,5,-30,25,63,-74,5,115,-54,21,-32,25,59,38,80,101,22,10,-108,-120,7,-21,17,-9,24,-47,113,-36,92,60,96,-74,-107,-38,-3,-100,99,-76,15,111,-106,-35,86,-128,80,-65,-108,115,-24,-72,-119,-67,102,103,-9,-98,114,-15,-112,121,-25,124,-106,121,-114,-115,-93,-105,21,108,41,-64,19,-99,123,93,-50,-52,-54,-84,-123,-4,-109,-13,8,-117,33,37,122,-15,-114,68,-124,-89,105,-19,-25,52,68,8,-73,-100,-7,-61,115,-64,3,75,0,74,-92,81,-51,72,-59,3,-26,-4,50,-29,-61,-3,72,88,-127,44,34,42,-28,67,-37,43,-71,-122,21,-56,-14,96,-73,-112,127,98,53,-50,-21,-90,-47,-63,98,-47,18,17,-14,47,-33,-1,-123,-77,-52,126,57,43,-107,-107,-120,7,22,53,-124,-37,-82,44,84,-81,0,-127,-89,1,95,-45,-35,48,4,-23,-99,-88,-9,40,0,1,123,65,-51,-91,91,94,104,98,-95,75,-99,-53,-121,-36,-85,-100,117,54,80,33,-103,38,119,-124,-4,67,-18,-50,-113,82,46,-1,-60,-73,-69,116,95,99,87,-72,40,-64,3,-65,-12,-46,125,108,31,49,-23,-112,-41,-66,-6,-14,-110,123,20,-27,-17,50,64,-64,62,80,74,-29,119,28,20,52,117,1,4,-32,-50,110,-114,118,-99,103,-51,20,116,83,-94,-75,115,66,62,-32,-34,24,-115,51,-67,108,41,108,22,-90,-112,-65,115,55,-24,-119,94,-70,127,-121,-71,117,118,62,11,-64,103,-20,-97,4,64,-1,-15,127,3,-62,-92,108,-74,-95,58,1,0]},{"id":"e68365e1-21e6-4858-b2a4-320301224e35","createdAt":1712948562060,"localPlayerName": "Zed","playerId":"11e178c5-8e89-432a-978e-fc95fd17f8bf","sequence":2,"gameId":"5a2376c6-3285-474c-9896-ee66829b77c2","timePassed":0,"sentence":"cat on a hot tin roof "},{"id":"5b5746ca-b74e-49d0-a4b5-abc2bf6b377f","createdAt":1712948662060,"playerId":"11e178c5-8e89-432a-978e-fc95fd17f8bf","localPlayerName": "Nicole","sequence":3,"gameId":"5a2376c6-3285-474c-9896-ee66829b77c2","timePassed":0,"drawing":[31,-117,8,0,0,0,0,0,0,0,-59,125,-37,-82,45,-71,-111,-36,-65,-12,-77,80,40,-34,73,-3,-122,1,-65,12,-12,48,-64,52,70,2,100,13,48,-46,96,108,8,-13,-17,-50,88,-83,110,51,87,101,-60,-26,-126,-9,-79,31,123,-97,-116,-24,85,85,100,50,51,-103,-105,127,-6,-5,79,127,-2,-45,95,126,-2,111,63,-1,-21,-1,-8,-7,47,127,-5,-21,79,-65,-1,-89,-65,-1,-12,-41,-65,-3,-13,-65,-1,-19,-89,-33,-1,-3,-89,-1,-7,-33,-1,-7,-49,-1,-15,-13,79,-65,79,-9,125,-27,-98,107,-23,-65,-5,-23,127,-3,-6,-73,60,-53,117,-89,89,-2,-21,119,63,-3,-4,-105,127,57,23,-1,-81,-33,-3,-33,-1,31,102,-67,74,-19,-91,-20,-62,119,51,-122,85,99,126,5,56,97,79,-85,95,125,-51,113,-52,-2,27,-32,-55,-98,-81,-107,-58,106,-69,-16,108,87,29,45,17,118,1,120,-78,-105,43,-27,124,-89,93,120,76,-5,-37,-100,-124,93,0,-50,-40,-17,-85,-116,74,-66,-85,2,28,-79,-73,113,-107,84,-39,-101,17,-128,35,-10,58,-81,82,90,62,103,-1,21,16,125,-43,116,-89,81,-9,-11,-101,-54,-70,70,-81,-115,126,86,-114,120,-14,-89,43,-49,-42,-86,19,78,87,89,-125,125,87,1,120,-78,-33,-41,28,-93,102,-9,91,114,-71,106,89,-20,-27,40,-60,25,127,106,-41,61,50,123,59,10,17,-15,-41,-66,-4,6,-68,-19,-57,-44,-101,-67,29,1,56,97,-65,23,-106,25,-35,83,2,-16,96,31,-21,-102,109,-92,-18,-124,109,-117,-52,-69,-57,-20,10,16,-79,-41,-70,-18,-18,-92,77,123,-12,57,-56,-90,-110,-120,67,-2,-5,74,-10,-15,62,-31,-1,7,-30,-116,127,-32,75,21,-78,50,37,34,-30,-49,-75,-71,77,110,80,83,-72,-123,-65,30,10,56,99,79,87,-67,11,-47,-105,10,112,-60,-34,-22,117,55,114,76,9,-7,35,110,83,126,-85,-75,15,126,-7,-81,-128,104,71,-27,-34,-14,-88,78,58,95,-77,20,118,-128,43,-60,25,127,-71,-81,-75,6,59,-62,21,-30,-116,63,-25,-85,-77,85,-93,0,103,-20,-87,-102,66,-20,-107,-24,4,13,57,-7,63,-84,-75,46,-45,42,-20,-13,74,-60,25,127,-66,-18,-100,-50,-33,-49,111,-128,19,-99,-80,-116,-96,-83,66,14,19,5,120,-78,79,-5,42,121,-18,-65,100,-32,67,-43,69,-56,-71,124,-60,93,-51,-80,-38,68,-69,125,-93,121,-77,-33,77,-59,15,-104,-79,-77,123,101,6,-79,-112,63,-32,-82,-61,76,-93,-50,-44,12,21,-113,-42,73,31,-91,-116,77,-42,44,-96,-44,39,-73,58,-104,124,100,49,-51,53,-6,-38,100,-13,-70,-42,-92,-26,30,-105,-113,-84,-67,118,-81,-71,-81,-89,4,-39,-50,77,120,38,127,-32,31,-84,100,-89,-29,-70,-55,-6,19,-14,-111,103,51,90,-83,121,19,-98,-85,93,-74,53,-72,-33,68,1,79,-10,126,-91,-103,-73,15,63,-89,-103,-53,-83,45,-90,-76,-72,-4,-109,123,-40,33,56,82,-34,-124,109,87,-105,-63,-84,24,33,127,-60,93,-51,-34,41,-20,119,115,-7,-24,-99,-108,-39,103,-21,-69,-80,-83,-30,59,51,69,43,0,79,-10,102,26,-8,-18,-5,-41,49,91,-92,-92,-50,-42,10,-105,-113,-42,-54,106,-77,-18,-97,-57,44,-111,-98,-23,9,-51,-27,79,-72,-101,-39,80,121,45,-10,86,4,-32,-120,61,-61,-74,63,-1,-27,-65,-54,-97,112,87,-5,33,-59,14,-105,99,-14,-33,0,71,-20,-27,-102,-99,-18,32,46,31,-83,21,-13,-3,70,-35,63,126,-63,126,51,53,68,87,11,71,-100,-15,-41,-85,78,122,80,72,-60,25,127,-70,-18,100,26,-29,3,-2,95,17,-111,22,-24,-26,98,-114,125,-29,-27,97,-17,55,83,-27,-88,16,79,126,24,-56,-10,-18,118,97,-37,-114,119,97,78,36,-105,127,112,47,120,-53,125,55,-66,-89,-7,-30,-71,-83,-101,-20,39,5,120,-78,-41,43,-103,99,-68,-57,18,102,-122,74,-22,-28,40,85,-128,39,-69,-67,69,-13,-114,-9,-105,-104,-52,111,24,101,-112,-49,-86,0,65,44,18,-57,122,-99,-5,26,72,102,-114,20,118,112,40,64,-64,14,-53,-78,-50,-3,61,38,28,5,-109,-103,-94,18,-15,-28,-73,127,74,-26,-40,39,-9,-80,-26,-53,-78,37,-87,0,1,-5,-76,-51,96,43,-54,-53,-38,42,32,-57,-121,2,60,-39,-51,-67,41,-9,-99,-100,-19,-96,-23,21,34,-32,-57,49,-100,106,61,-89,-25,-128,39,123,41,-105,-67,-52,-11,-10,-88,119,107,100,-69,42,-64,-109,-35,60,-41,113,-69,-3,-111,-96,-104,90,98,-33,85,0,2,118,115,73,114,94,-69,-127,98,-53,-82,-104,114,98,-20,28,-16,100,55,71,-95,-39,-39,56,118,97,59,21,58,-77,104,20,-32,-55,-34,-117,29,-21,125,119,31,-26,61,-52,8,-67,-39,126,21,-128,39,-5,-80,-105,-42,-25,40,-57,-20,2,16,-80,-101,-54,46,-9,-4,-128,-99,3,-98,-20,102,28,-25,123,-91,118,-52,46,0,79,-10,5,-31,-15,-63,-101,17,-128,7,123,-74,-17,109,74,-70,30,127,85,5,120,-78,103,91,96,-59,118,-102,95,-66,105,48,-61,70,1,-98,-20,-91,-39,105,-106,-36,-66,-122,127,53,39,81,-15,10,-16,100,111,102,35,-9,-27,-52,-3,-108,-81,94,89,-96,74,1,-98,-20,-74,57,76,-93,-74,125,-21,33,42,-76,50,11,36,73,-60,-109,127,-12,-85,117,-89,-107,-122,-19,117,22,68,-30,-30,79,-26,-123,-57,44,110,91,-101,9,81,-17,76,108,14,5,120,-80,-37,-98,-77,15,-110,-45,-2,-108,102,-1,-12,62,50,81,-64,18,-15,-28,55,75,45,-27,55,3,-88,95,35,-49,68,22,-115,68,60,-7,-85,61,108,-21,-18,89,97,2,101,114,-12,9,-7,39,119,-57,47,-55,-45,89,-75,-21,26,-109,93,5,41,-64,-109,29,-111,-66,-100,-57,60,102,23,-128,7,123,-67,-19,-60,29,-67,31,-1,118,5,120,-78,-101,-7,-125,91,-106,-35,-99,-64,10,51,-37,-112,-80,11,-64,-109,-35,12,-120,62,-85,-37,121,-26,-83,84,91,115,100,-51,72,-60,-109,-65,46,-84,96,47,-99,-81,-39,110,-10,110,4,-32,-55,-34,-15,91,-100,101,104,-82,-36,61,-104,-98,17,-14,79,-18,97,90,-94,57,79,72,115,115,-7,39,-73,29,99,109,-108,-46,-3,67,-10,-54,66,121,10,-16,96,111,102,1,78,127,70,-38,7,-78,-17,-45,-55,39,85,-128,39,123,-127,79,-75,-114,23,-69,-112,127,114,-73,110,-26,108,-49,94,99,-108,126,-109,-91,46,-28,-97,-36,-29,-105,-24,-118,119,-101,-117,-3,-123,-67,21,1,120,-78,-65,-126,-120,46,-58,101,-118,-76,-28,-101,-2,116,1,120,-80,-9,27,97,114,-81,-21,-102,-103,-26,-125,104,94,33,-1,-28,-50,-72,-109,120,8,-33,-117,93,-24,41,-64,-109,-67,32,10,-33,-50,99,4,10,-16,100,111,-53,-50,-109,-27,116,93,-126,73,101,-117,-103,-48,43,-60,-109,127,-32,-94,114,-70,-81,-108,-16,34,-103,-115,-89,0,79,-10,105,26,35,-69,-43,107,-18,-107,109,61,98,13,8,-7,-25,-19,-55,13,-39,-30,-20,100,-20,-107,-63,-62,86,10,-16,100,55,-97,-7,78,-23,118,-90,44,118,75,101,-38,81,34,-98,-4,-91,95,-90,-14,-74,-45,119,44,124,36,22,-88,21,-14,79,-18,-10,-54,4,-86,-69,44,30,116,-78,59,43,46,-1,-28,-74,-13,101,-38,-7,-37,119,97,91,-67,-99,25,96,10,-16,100,55,67,54,79,-73,118,109,37,-101,63,116,87,-10,-37,21,34,-72,-31,-76,115,54,-19,-73,-95,-26,-102,92,-85,52,-102,83,65,-27,-125,59,55,123,-86,92,-35,47,-63,-67,-64,-51,-93,-52,10,17,-36,-69,-51,107,-104,-10,116,-46,-120,64,117,22,-37,23,-128,-32,118,108,-63,11,92,-69,44,110,25,-42,96,63,94,0,-126,-8,-69,-83,-80,-98,-6,-74,-9,-122,-7,-24,-53,44,101,22,-128,-25,-128,32,-126,125,-61,-3,113,-78,102,76,116,-102,86,-56,-27,-125,123,-90,100,123,99,-91,93,118,32,10,-101,-23,-27,27,7,4,-79,-15,-116,-52,-79,-3,37,-114,118,-83,-44,-40,61,19,-105,127,114,-37,-73,-74,-125,108,-41,24,-72,77,91,108,-93,10,-7,32,46,110,-114,119,-11,15,-119,61,93,88,110,-107,2,60,-39,-51,-83,31,109,-71,95,98,-106,96,99,55,-75,66,-2,-55,109,38,72,29,94,29,-103,112,-82,-103,-60,31,21,-32,-55,110,71,-5,52,45,-19,-124,113,-128,-79,67,67,1,-126,-5,-126,101,7,-40,-38,67,-24,16,-74,-105,-56,34,-6,2,-16,100,-73,-123,-69,-58,-72,-49,-39,5,32,-72,-115,-80,-75,-108,103,57,38,-25,-14,79,110,92,28,-49,-78,7,64,-66,90,-114,10,17,-27,93,-9,107,118,103,-13,96,111,-52,-43,8,-65,68,68,119,41,-90,75,-77,-5,49,118,-2,18,-43,72,-91,3,94,115,-96,-46,72,-55,-117,-82,-62,78,12,5,8,-40,77,-115,38,23,64,-128,-118,46,44,124,39,-28,3,-18,126,95,-53,101,-87,-30,116,-103,-91,48,-77,84,34,2,126,91,76,-83,-19,-74,-32,-104,112,101,-7,-113,-25,-128,-128,125,66,56,-17,-78,112,124,10,11,-126,41,64,116,55,102,79,90,-90,51,74,-20,-92,31,-103,-34,-68,113,64,-60,110,102,-27,-19,54,53,18,-58,-60,-67,30,7,4,55,99,-120,-40,-90,-27,76,77,4,-52,26,-53,126,-112,-120,-120,-33,-76,-75,-69,-104,-42,62,-127,2,4,-20,102,-13,-108,-37,7,87,16,75,100,41,-71,10,16,-80,-105,116,-115,58,-9,-16,74,51,-13,-77,-46,53,41,0,17,123,-66,70,119,87,81,80,-88,57,83,29,-90,16,49,-1,26,-50,-69,90,8,-33,36,-106,-19,35,17,39,-4,11,49,29,19,-89,47,95,32,-30,-73,-65,-38,46,92,32,-100,-7,-54,-31,-128,-93,95,-33,17,99,96,-75,41,10,16,-79,23,-124,-101,92,-86,36,98,12,-52,105,82,-128,-120,29,91,36,-69,12,-28,-69,-66,-62,105,-108,-98,35,78,126,125,-70,115,51,-81,-114,101,112,72,68,-68,107,-17,-75,7,21,-46,93,27,-110,17,-44,-74,101,-120,-120,-65,-32,74,119,-18,-46,29,-46,-52,-92,-108,-120,72,-89,-103,-79,-46,-101,-5,53,19,111,-109,21,97,72,68,-60,-113,-91,-42,93,61,-50,109,27,-3,-82,-52,2,81,-120,-128,-1,94,112,81,92,77,-120,105,93,51,28,-23,-30,23,-120,-120,127,-102,49,-73,39,-104,-38,2,65,61,17,85,60,28,112,-58,-34,80,-113,-61,114,1,37,34,62,17,71,73,-82,-98,104,-32,89,89,-8,80,34,34,126,59,36,-38,126,-65,102,-89,41,-22,-107,88,74,-67,68,-60,-85,-57,76,-119,77,56,-37,86,-81,-115,-107,-111,40,64,-60,-114,-99,82,-99,116,66,125,33,-13,-19,37,-30,-116,63,-101,-25,-47,-8,-87,40,16,103,-4,56,38,-72,29,-85,16,-15,-41,109,117,-20,-33,10,23,-39,101,-78,76,111,-119,-120,87,103,-53,99,-81,-111,-52,-67,-102,-9,-53,117,-89,64,-60,-70,-63,-4,13,-9,-76,-26,39,-43,-54,-62,78,18,17,-13,-105,-69,-20,-102,42,-49,42,98,9,18,113,-92,29,-14,-70,69,-20,73,34,34,-2,-15,-118,-74,59,-23,-7,114,13,40,63,71,68,-4,21,87,87,-5,-81,49,23,-8,-70,41,57,17,-113,-104,-95,69,74,62,102,38,-30,-111,-121,50,-19,-88,-36,93,107,-55,76,-59,35,102,59,36,-109,-85,-19,-44,-52,68,60,98,-50,87,-23,125,28,51,19,-15,-56,-41,-60,89,-71,-25,61,106,102,38,30,49,-73,-53,23,95,107,-30,88,58,-30,-59,-61,-51,-45,-107,65,-59,35,-81,126,93,45,-91,-29,-107,-63,-60,35,-26,97,-26,-45,-23,54,97,-46,17,47,-50,-14,113,-4,46,-104,-8,39,-52,127,-8,-35,79,-1,-2,-13,95,-1,-19,-49,-1,-15,-73,63,-3,-37,95,-128,-7,-29,-49,127,-6,-41,63,-2,13,2,80,-85,-1,-7,-89,127,-7,-37,31,127,-7,-113,-41,-81,56,105,99,-128,-124,-16,-74,92,-18,-19,-21,-90,55,82,-103,66,-104,-59,-115,62,96,-73,-93,-84,-114,-75,103,-28,-116,-6,-70,-6,103,-6,88,0,-126,36,-54,116,-39,123,-35,77,-81,-127,-60,-9,-52,98,-22,10,16,-92,57,-34,87,-17,-73,-69,-13,-64,21,-50,-96,103,-95,0,4,105,-114,-73,121,-89,37,111,58,101,-40,122,-80,37,-62,-68,8,1,8,-46,28,-13,85,125,-8,-83,-81,118,21,4,66,89,-98,-93,64,60,-45,-42,18,-92,-45,110,22,117,116,83,-24,52,21,81,0,-126,68,-57,97,6,-48,-40,31,-75,119,-4,22,86,69,-81,0,65,-78,96,70,30,-6,-74,6,76,79,94,102,-76,-80,-116,59,46,31,36,10,54,-77,-26,-54,-98,-40,-126,-28,-123,-52,-126,34,66,-2,-55,-115,-4,-115,-75,-10,-56,94,55,-29,-62,124,25,-78,98,20,32,72,21,76,87,110,-82,49,73,-77,-13,52,-45,74,98,5,120,-78,35,55,31,65,-62,77,24,-31,96,-5,27,113,-85,36,34,72,68,-84,-41,48,-65,101,-105,-74,-35,56,11,75,-6,82,-128,32,13,17,-71,121,-50,9,104,-51,62,92,110,44,-45,92,34,-98,-4,-19,54,119,52,-19,55,-61,-83,86,-44,-38,-77,-78,86,-119,8,82,29,-85,29,-84,-9,-74,59,90,-98,87,-101,-109,101,-36,41,-64,-109,29,-105,123,35,-17,22,65,-125,-38,91,-52,-31,87,-128,-128,125,93,-11,-18,123,30,112,-69,127,-7,19,99,-25,-128,32,77,-77,-31,58,101,-81,-60,104,-9,125,-35,105,-79,-36,94,-119,120,-14,-81,114,-11,117,-17,-46,-43,44,62,59,48,89,48,74,34,-126,68,-48,-116,-102,-105,93,24,73,-127,35,-77,-58,11,10,16,36,-126,66,120,-9,-67,-112,-50,104,106,-100,121,-77,10,-16,100,-49,-56,-69,-36,-51,-11,90,-19,44,-82,-75,-109,87,-93,0,65,-102,-87,-67,-76,-69,-17,-42,100,-51,120,-46,-50,74,-106,36,-30,-55,-33,-96,-21,92,30,118,-59,50,75,-107,69,-88,37,-30,32,-47,-76,-84,113,-115,-103,-103,125,-96,0,65,-86,-87,125,-106,-31,-86,-65,10,106,-96,51,75,-93,80,-128,39,59,28,116,59,7,118,-31,110,47,55,55,-26,-122,75,68,-112,-52,-118,18,-119,-79,-101,113,-91,-107,107,-36,-107,41,5,-119,8,-46,89,-77,45,43,87,-81,82,112,79,100,74,-117,-27,86,42,68,-112,-48,106,-97,106,-20,121,-98,5,-11,108,-87,45,70,47,0,79,-10,-118,-38,-52,-70,109,-62,98,10,-86,86,-90,-114,-123,-4,-109,-37,108,-95,92,-10,59,-29,60,-19,-51,-82,-60,-30,115,10,16,-92,-76,-38,34,107,123,105,89,-74,69,32,-110,-98,20,-32,-55,-114,-42,68,-91,-18,-122,92,70,23,-83,-55,74,-35,20,-32,-103,90,-119,21,-112,-9,16,65,-82,13,85,-53,-119,101,-52,10,64,-112,50,-117,42,-16,-3,80,-8,-91,-6,-122,-83,71,33,-1,-28,54,91,37,-51,61,-115,60,35,117,-73,53,-90,-121,21,32,72,-104,77,87,71,-59,-57,38,-99,80,82,-43,-104,-86,-111,-120,39,-65,-39,-7,-43,-84,-13,-19,-72,55,79,20,-15,89,-74,36,37,34,76,-56,53,15,96,56,-23,106,-18,46,107,-118,-91,0,65,66,46,26,54,-19,-71,-57,-88,55,-21,-87,-78,-30,78,5,120,-78,-37,2,78,-87,-17,105,53,9,-27,-42,121,48,69,35,17,65,-54,47,46,-55,-18,-71,-57,-59,-20,-9,-75,84,19,75,-54,85,-120,39,63,42,-78,-36,-115,55,90,-10,-11,-44,-39,-114,85,-128,32,-91,24,-103,-45,-82,-65,-40,64,-67,92,99,-90,-103,2,4,9,-59,102,10,37,23,-41,31,8,109,-80,14,-126,66,-2,-55,-115,13,56,-110,11,-22,119,60,-25,96,21,58,18,17,38,44,-101,-31,-32,-124,43,114,-123,104,54,-76,0,4,-20,-74,-58,-18,-23,-30,124,-35,124,-55,-111,104,39,56,-123,8,82,-94,-37,117,-9,-18,-66,83,-61,-77,78,-70,42,21,34,-32,-57,-35,-92,75,44,-121,-12,125,-73,-59,22,-114,66,4,73,-41,-72,-36,75,-13,3,126,-123,8,-8,43,-116,-26,79,-24,57,32,76,25,95,-66,-74,61,117,68,-82,50,43,-41,-111,-120,39,63,90,-24,117,119,-41,13,103,-107,87,-20,40,64,-64,-114,71,117,-73,77,-29,-58,101,40,125,55,2,16,-90,-69,-101,-55,-97,-85,-41,126,-74,50,88,114,-95,68,4,-4,-56,1,-9,-121,3,78,-98,-59,-52,98,5,8,18,-34,95,109,106,-101,59,-105,-95,-69,19,-17,-51,41,16,65,-54,59,18,-98,93,59,-55,-100,113,-18,-41,-54,18,-57,21,-30,-55,111,22,80,-17,-2,-36,-41,38,-102,68,4,73,-11,-74,-53,-45,-38,13,58,52,76,28,60,-17,93,0,-126,-60,-9,12,-25,-41,-103,116,-24,110,98,127,97,109,91,20,34,72,125,-17,8,-115,-17,23,-107,37,33,56,89,105,-49,91,-123,120,-14,-29,114,-82,-18,45,-51,74,-123,-125,55,104,-33,88,1,8,18,-32,-121,-7,-42,-9,-34,29,-84,-32,-8,52,7,-127,-68,124,-119,8,-46,-44,-17,107,-11,-68,-81,-124,-126,-18,47,-56,74,98,121,-22,2,17,-92,-110,23,-40,-68,-37,66,-82,40,65,-99,-103,-59,47,21,-32,-55,110,-22,122,-91,-66,-57,-10,-85,-99,-97,102,-62,-77,-74,57,2,16,-90,-110,-49,-78,-85,-88,106,-53,-84,-26,-55,-74,-83,2,60,-39,-47,-14,21,125,65,-9,96,97,-73,85,-58,-20,111,5,-120,82,-55,27,74,46,119,-31,87,-24,-10,102,21,2,18,17,-16,-37,50,72,101,79,-67,107,29,-105,7,-20,60,81,-128,-128,-67,-26,-85,-115,-3,102,-77,33,-73,-128,21,105,10,-7,-24,94,-80,95,-71,-18,73,125,-72,-103,-24,-103,53,38,80,-128,40,-95,124,94,117,-71,-37,38,-60,-14,50,-51,-45,16,-128,-8,-86,60,-37,111,-39,-124,-51,-60,-77,101,64,63,42,7,-60,105,9,61,-19,-115,47,-6,24,-105,-71,1,52,-115,-97,3,-94,68,13,36,28,-19,-31,-21,62,113,-51,-57,-82,2,20,-32,36,65,-87,-81,87,-24,-115,-26,-33,112,64,-60,-66,-82,-26,-102,106,-116,27,-127,49,118,-124,40,64,-108,-40,-39,77,5,37,39,-68,-82,52,-103,117,-93,0,81,-38,-85,89,-4,-45,93,60,-37,-14,-67,17,-40,-89,105,-81,28,17,-16,35,99,-43,117,-113,24,25,23,-96,76,75,42,64,-64,-34,-52,110,-13,-11,-88,-90,-107,-20,-124,-96,-20,28,16,-79,47,59,44,-9,95,-126,74,-90,-107,-8,119,-27,-128,-128,-35,20,-100,-103,84,123,-71,5,-50,31,94,-4,33,0,17,123,-65,-6,126,17,-9,-14,-58,58,-49,35,-89,-14,17,55,18,-109,93,69,-89,46,-24,17,-128,-128,-35,-20,-111,84,92,-11,-49,-4,37,14,-52,-40,57,32,98,71,57,65,-39,-21,68,116,-39,-118,0,68,-20,88,94,111,69,-58,-74,-47,-7,79,103,-14,17,-73,41,-21,-108,-9,79,-76,-48,78,-79,-79,-126,106,-119,-120,-7,-85,-81,117,93,-19,26,-119,-39,98,10,112,-58,-34,81,101,79,23,36,7,-100,-79,-65,-62,-5,-84,-24,89,34,34,-2,114,-83,57,-34,-22,-34,23,-81,-68,19,-128,-109,53,57,-47,-90,-80,-48,-109,85,0,78,-10,19,42,-66,-85,-48,-64,28,112,-94,11,80,-70,100,-106,28,53,58,20,34,-30,31,-26,-116,-18,107,24,-35,-27,90,-25,45,18,57,32,-42,-110,-71,-108,-67,118,41,-95,33,-53,-94,53,114,10,17,-15,-101,-51,-1,-42,-40,79,55,-112,84,-120,-104,-65,44,-41,80,6,83,52,86,-25,-119,-47,2,17,-13,-89,85,-22,103,-4,12,17,-97,-127,118,126,-27,79,-8,57,34,-26,71,87,104,-1,54,-77,-19,22,117,-56,50,68,-60,15,51,-47,55,57,-7,-118,-97,35,98,11,-28,118,-75,111,-16,-23,50,107,86,47,-28,35,110,-100,-8,-82,-16,77,-73,116,-111,-120,-40,54,-21,-73,107,0,-82,59,-46,72,-60,25,63,-70,16,-48,-29,-118,-54,71,-36,-90,-66,-41,-98,9,-124,-90,65,-85,100,-106,-118,39,17,103,-4,80,82,-107,-42,82,113,-64,103,-20,-33,-98,118,91,-47,40,-96,-70,80,109,70,-42,68,-114,122,100,40,97,-110,-128,-15,9,-5,68,-65,-123,-79,-121,-121,94,71,-27,125,-45,-36,26,-123,8,126,61,82,101,-18,-67,109,-91,-67,-21,-41,21,19,-29,87,-120,-128,-33,44,16,119,9,-119,18,70,-5,-112,-94,19,26,-111,15,127,123,-125,-106,-36,-91,-47,-126,-16,102,-34,-116,68,-100,36,-65,124,-59,-81,16,65,114,10,92,-40,-20,-54,-63,48,32,-122,-58,-127,21,32,72,-16,120,53,62,119,-113,-38,-52,15,-91,-73,-23,10,16,-92,49,-96,30,58,85,-73,-54,58,-18,14,89,-3,-116,68,4,-87,12,11,-75,9,94,-40,-10,-51,-51,114,95,20,32,-72,-84,-73,127,73,-2,69,-94,-108,-118,6,126,20,32,-72,-20,-58,20,-98,-35,92,-5,-59,-60,-94,119,-82,92,62,-68,72,-49,109,-72,2,-47,110,46,-47,96,57,24,10,16,-80,103,-45,67,-5,73,-2,-6,37,-125,53,-67,21,-14,65,-118,-127,45,-34,-42,70,127,-45,75,118,30,50,118,-123,8,-8,127,-103,-56,-75,-85,85,-5,121,-103,-86,26,5,8,18,48,-90,57,16,-66,-72,12,-71,-29,-76,-43,-66,2,-124,-23,29,37,-17,-89,91,-54,13,55,-39,-76,-99,-101,0,-124,-65,-67,-71,75,-33,60,109,95,15,54,87,70,-56,7,111,29,-43,-55,109,63,12,50,-90,44,-47,50,67,5,8,-40,-111,-60,-46,-36,89,38,-86,120,-72,120,-80,-46,127,-103,-99,-41,15,-103,-87,120,-112,-116,-126,-12,-113,-27,-53,-125,110,17,-114,81,-128,-128,29,-89,-95,83,115,40,-94,-68,11,11,-73,43,-64,103,-20,-33,110,102,-95,117,104,-18,109,79,-27,108,-104,48,22,22,-45,43,97,114,88,126,-62,-114,-107,83,-53,126,-65,-35,22,-78,-4,-39,71,83,-128,-128,29,-47,-34,-30,-46,-28,109,-51,-9,-101,-11,102,81,-128,-128,29,86,65,-35,-5,-117,-67,122,120,46,-42,91,89,1,-126,-9,-114,-98,127,117,15,-52,32,-33,-47,-76,13,109,8,-53,1,33,-69,-7,115,123,109,72,71,11,98,83,-53,-44,6,18,-120,-128,63,-31,54,104,-65,81,-55,-11,-86,-117,93,-63,8,-7,-109,-36,-30,-98,-15,-111,-40,-56,56,5,8,-41,-69,-87,-13,-19,-36,-42,-75,77,66,62,-32,-82,-81,-55,97,-69,44,26,16,-77,-56,-94,-112,15,-72,-15,47,-9,-82,-125,123,-59,115,47,-6,86,56,32,96,127,-35,14,-20,14,66,71,-75,12,-53,55,19,-14,79,110,-36,113,-70,23,88,-51,-108,-87,-76,79,-115,-112,15,-72,-47,-72,-55,-35,-88,34,87,-69,-77,86,23,66,62,-28,-98,-51,-35,26,-42,41,12,113,33,31,112,-61,-95,-55,-18,33,-51,-50,94,-44,67,-31,-14,1,55,66,21,-2,-45,-64,-75,44,44,-118,-85,0,1,59,84,-24,-2,67,26,-86,-15,18,-27,102,-30,1,-13,66,-123,83,61,-89,-90,-14,79,110,-12,-50,-50,105,30,115,115,-7,-128,27,7,-94,-33,103,19,17,125,-30,-106,8,-7,-128,27,1,63,127,-89,47,-41,55,-105,15,-72,-37,85,110,119,125,-6,-43,-50,84,-120,-128,-1,-43,17,-50,-83,-39,118,81,37,-50,-92,67,-34,85,90,118,-21,21,42,-71,-48,-77,77,33,2,126,116,20,119,-21,10,67,19,-20,-128,-95,-117,-123,3,2,118,-37,16,102,-46,-20,-57,120,-63,-25,-97,-20,-46,82,34,66,-2,-42,93,54,2,-54,108,42,43,119,19,-14,1,55,118,-36,94,-96,-116,126,-9,44,-65,-117,74,31,-16,102,-24,31,-26,71,113,-15,19,102,60,28,109,-63,38,-28,79,-72,49,66,-126,117,5,-32,-30,39,-33,48,-95,-72,52,-47,-29,65,0,-62,-11,109,-85,-55,-39,-111,47,43,-107,47,64,14,8,-39,-121,25,54,-69,-114,-128,93,-68,104,27,114,-119,8,-7,-51,-87,-35,55,-37,13,43,-104,22,45,42,-64,-63,-34,71,-6,87,26,-20,22,69,-56,-121,-36,-87,-20,-91,88,13,109,-59,-51,-64,22,122,-123,1,78,-76,98,91,-88,-70,101,-95,55,5,8,-39,91,118,-93,-26,27,82,-88,42,63,-28,56,-32,-32,-92,64,-39,90,30,-84,-120,86,-56,-97,112,-65,2,-19,-44,108,-26,-14,71,-36,29,83,31,-39,-107,-98,2,28,-79,23,52,1,102,-105,98,10,112,-60,-98,-48,3,81,-100,-95,68,-2,-124,27,69,-121,-73,125,-91,99,-14,-33,0,39,26,-90,117,-92,-81,-78,27,49,5,56,57,-97,27,-86,33,-18,-54,63,-86,64,28,-24,118,20,-128,86,-95,-66,-88,124,120,34,-107,-71,39,28,-76,-114,-76,-31,-52,-14,-60,20,-32,-21,-13,-82,53,-100,49,44,-109,-117,-117,63,-103,-21,107,-2,-63,-2,-7,81,-49,-44,6,75,87,82,-128,35,-10,-122,36,18,-10,-61,-71,124,-56,-35,111,23,79,66,-42,-32,77,-115,0,46,127,-60,-115,-19,76,-49,81,46,127,-60,109,-34,-21,-96,13,88,21,32,96,-57,68,-54,61,97,-22,75,118,14,56,100,-81,93,-108,111,115,-64,33,123,54,-101,-127,-19,33,1,56,98,-121,-85,48,-39,105,-60,-27,15,-71,-87,62,103,-46,71,-68,-24,3,-61,46,-78,-123,-4,33,119,-51,-84,38,69,-56,-97,112,35,-84,-111,-88,30,-25,-14,-121,-36,105,45,26,121,22,-128,-112,-67,-94,-1,-28,46,109,54,-8,-96,-99,-75,37,34,-28,-97,-59,53,104,49,55,62,21,122,60,115,-7,-128,27,-93,38,62,104,-44,-93,0,33,-69,-83,-2,-31,-98,19,74,-114,-122,44,4,-32,-116,29,62,43,-99,-93,38,0,-89,-20,-71,-45,-112,-120,0,-100,-79,-93,32,-119,-34,86,8,-64,41,-69,-3,-23,51,-10,23,-32,-108,-35,86,5,85,3,28,112,-58,-114,-78,-101,73,-35,105,-123,56,-30,71,-93,-100,68,91,-59,72,-60,41,63,76,-108,-113,-24,95,-128,51,118,-76,-102,-6,96,-55,-1,67,-2,-108,-69,-48,62,-23,10,112,-58,62,96,44,127,-14,-38,-1,1,56,99,-17,-16,35,-72,-118,23,-120,51,-2,118,-115,114,-45,-37,34,-123,56,-27,79,-119,85,5,42,-64,25,123,69,66,-1,7,59,-10,87,-64,-47,-7,87,-32,81,-79,68,113,5,8,-39,115,-66,-53,-101,112,-111,22,30,3,-100,-78,-33,75,29,-35,12,112,-58,94,-60,100,0,5,56,-79,106,-66,36,39,-14,-95,-57,81,111,-41,-18,-81,-32,-104,-89,-63,47,46,127,-30,-31,-31,-90,34,-13,-93,-113,-54,-121,94,-17,90,-35,85,-77,126,-79,79,21,-30,-116,31,-58,-43,98,-67,56,36,-30,-24,-101,106,122,1,56,-37,-87,95,-46,83,-60,-119,-91,-6,53,61,3,28,-78,-81,-58,58,27,10,-7,19,59,-8,-53,-61,-119,-56,-97,-98,-85,-21,-93,-109,-29,23,-7,-1,15,-42,18,-86,-42,-10,-110,80,-32,107,103,-93,53,-124,124,-56,61,109,-97,-67,57,42,-115,54,-67,83,-128,35,-10,-122,-25,100,-51,61,20,32,96,-57,-51,109,122,-117,58,-115,-52,-35,38,42,31,112,-93,-20,101,20,23,-95,-60,117,54,-73,-34,57,32,100,111,-73,15,127,-30,-126,-123,85,5,11,-7,35,-18,87,-68,-116,90,-89,84,-2,-120,27,46,115,-95,45,12,5,32,100,55,39,118,-33,-49,-78,-35,-82,-112,15,-72,-1,81,4,-73,11,-73,87,-89,20,70,-50,1,103,-20,120,-50,-52,-11,-94,64,-124,-4,-74,78,-9,29,61,-79,43,26,15,-6,112,64,-64,-114,75,51,-41,-64,65,-33,37,113,-7,-112,-69,-71,107,-124,-7,74,77,-28,43,-99,-54,-121,-36,-66,-57,36,-90,-111,-89,65,91,47,114,-7,-128,27,-11,-39,-39,101,61,34,74,-47,-8,41,-54,1,33,-5,24,-50,28,89,-24,0,76,-81,-87,-72,124,-64,-115,-94,-79,-67,-65,36,-14,53,11,-49,51,-28,-14,79,110,20,-41,-84,-71,-9,-105,52,-93,-22,-22,-76,43,-117,2,4,-20,48,-93,92,-65,12,-108,-82,-106,65,-49,34,1,8,-39,-95,-115,-9,36,-94,47,110,-39,21,34,-32,71,83,82,-105,-83,-112,-80,0,104,-120,-99,-53,7,-36,-81,66,61,119,-33,-97,-52,-116,-94,119,-20,92,62,-32,-82,-24,4,-77,127,33,100,-4,9,-49,81,0,2,-10,-41,-40,-8,61,71,41,35,69,-74,-45,5,67,-27,3,110,40,57,-33,67,31,-35,91,120,74,-96,0,4,-20,-72,-93,-20,46,11,-94,-96,95,49,13,-7,10,-64,-109,-67,-29,114,-88,-71,-44,100,-99,-8,42,0,1,-5,123,-125,92,-76,87,-67,111,122,57,-56,-27,3,110,124,126,-105,57,12,-21,-78,13,122,73,32,0,1,-69,109,-32,52,-9,-82,-125,-56,-110,-83,-117,90,-116,2,16,-80,-29,19,-71,9,-81,72,-103,91,-103,-34,-56,10,64,-64,14,47,51,-115,-73,92,63,-37,-122,116,43,41,-60,-109,31,-45,-117,-19,121,-35,-93,-50,-85,13,-102,-104,33,0,1,59,76,-75,-67,-1,-55,87,57,-80,2,16,-80,-37,9,-42,-69,27,27,-47,-112,90,77,-115,12,1,120,-78,-93,29,-29,-38,29,100,-56,-50,-50,-38,-64,9,-7,-128,27,-89,64,-35,45,-75,14,-11,74,-53,-36,20,32,100,-81,105,-114,-113,-40,25,32,100,-97,-71,59,-115,-41,80,-14,-53,115,86,20,34,-32,-121,-34,112,7,112,-125,-34,24,-115,-83,25,1,56,97,-121,-27,105,7,13,-37,-83,2,112,-60,46,117,36,-105,63,-31,70,-108,-113,54,-107,18,-14,-31,90,-57,77,-71,107,-119,86,-19,-48,-92,-23,48,2,16,-20,-45,117,-115,-71,-121,-78,58,42,125,23,117,52,-72,124,-56,-99,70,117,45,-53,18,66,-50,55,93,-115,10,17,-22,-104,-78,-105,-13,-11,-12,-102,122,67,-65,40,-105,15,-72,7,-52,39,87,-89,-124,-40,65,-93,-58,-93,0,-124,-20,-26,-104,-20,-59,-38,-3,70,-86,24,-99,-84,36,17,33,-65,-103,-59,123,70,-44,-62,61,5,125,49,76,60,100,78,-91,-68,-27,44,-74,74,43,62,-72,124,-64,-115,126,-13,107,111,-28,-122,-75,92,115,-94,-54,81,33,-114,-8,-65,72,70,84,-120,51,126,56,63,-125,-26,81,41,-60,25,-1,43,23,-115,-38,3,28,112,-60,-114,78,-78,52,-94,-63,-27,-49,-72,113,-127,67,27,46,75,-60,25,-1,43,-95,-26,-2,-32,-53,-2,-122,56,-30,111,80,123,-12,-58,74,0,-50,-40,-57,-59,102,102,113,-15,51,102,28,5,-36,-126,-28,-128,51,118,-99,102,-90,16,33,-65,41,-48,-73,-40,-80,-56,-86,-30,-14,-121,-36,57,81,119,-116,-53,31,114,-33,-119,38,-32,112,-7,19,-51,-114,105,34,118,8,-97,-21,-10,-33,0,-97,-79,-1,-31,-69,-117,-80,-57,-85,-95,-62,-67,-121,-48,42,-74,-8,-120,-100,33,37,28,62,-8,103,-20,-67,93,-35,124,-42,-35,102,-62,112,114,-26,80,8,-7,-112,27,35,24,124,-4,-92,-9,-52,-20,20,5,8,-39,-33,-58,14,32,-126,-78,38,-69,-72,80,-128,35,118,92,-105,23,58,-34,66,0,2,118,-44,-4,103,-17,-81,34,-96,-57,95,59,7,4,-20,3,-29,107,-34,-68,-125,65,-121,-90,9,-7,-128,-37,-34,88,45,-50,23,86,-123,-81,66,62,88,-23,-23,50,-5,-53,-7,76,8,43,-79,16,-102,-112,15,119,81,118,-43,-9,-83,95,-119,70,-25,-71,-8,9,51,-52,-33,-60,18,35,-124,124,-8,-74,-33,70,95,124,17,-85,-112,-120,15,-7,127,-128,-34,-21,-41,61,-33,2,29,-75,69,-35,89,-72,40,121,-87,-33,-63,-4,-3,15,60,-47,102,-28,-18,103,65,6,41,29,63,-10,103,-4,-24,76,-102,-90,-13,25,96,-73,50,-17,72,-56,31,113,99,89,15,102,-121,42,-64,17,59,-110,-119,88,85,-94,-112,15,-72,-41,-107,-4,36,83,117,93,-54,-59,67,-26,-42,-36,53,-68,-66,68,86,-128,-128,125,94,-83,-20,-118,4,-83,-18,-25,18,-65,-100,3,-114,-40,-43,-59,-67,-112,63,-30,-58,-99,109,-1,-124,-4,87,-64,-125,125,-34,-9,-43,-52,-115,116,86,37,-78,101,26,-101,83,34,0,1,123,-70,-58,106,-35,9,43,-57,66,1,2,118,-100,13,101,127,-48,6,-81,-104,-50,64,-31,-14,-121,-36,-73,-39,45,108,2,-118,0,-124,-20,61,-91,-3,-86,92,22,-81,8,-7,-128,27,-99,26,-9,-85,50,92,-27,-102,63,76,127,56,-107,15,-71,103,-23,-50,88,-58,-73,103,-99,30,-123,124,-64,93,-81,-18,-117,104,101,41,-123,-112,63,-30,126,37,-28,50,-107,-88,0,1,59,-116,89,-97,-50,-94,-99,14,-119,56,-29,-57,-38,-30,-97,-108,3,-50,-40,85,-87,-122,2,-124,-20,-75,-49,-2,9,57,-111,63,-30,-2,-14,-75,51,64,-56,62,-57,-98,-94,-16,69,-7,-115,2,4,-20,-3,50,71,109,-74,-13,-27,-50,1,33,-69,-67,50,87,-16,-114,-50,40,-85,49,-37,72,34,2,126,-13,74,-52,-99,-38,-33,-92,-103,-4,-91,-46,-32,-123,68,4,-4,-24,-73,-73,-34,-62,98,-3,102,-66,-115,-112,15,-71,87,27,-5,77,25,78,118,126,57,-91,0,103,-20,-16,-8,-103,-97,-83,0,79,-10,116,99,60,-60,126,14,12,-124,-128,10,35,-25,-14,1,119,66,-21,-42,-13,18,124,5,56,98,87,-51,3,-124,124,-56,-35,-106,11,-31,96,114,-23,100,-3,26,-124,-4,-55,27,95,-7,53,-9,-109,-23,24,1,56,90,45,11,31,-97,107,48,14,56,-40,69,58,43,75,-56,31,113,-65,2,91,31,112,-1,67,62,124,-25,-83,-81,125,92,-102,25,63,-81,38,-24,-4,-99,51,64,-72,90,-54,-20,-5,-92,-98,-98,-32,-108,-80,91,88,5,8,-40,95,-51,40,-9,-128,69,70,-108,-123,-81,115,42,31,112,-37,-63,-37,-106,75,-126,66,-46,-55,-104,116,45,114,64,-56,62,-121,-21,90,-104,-47,-16,-118,-35,93,8,-7,-128,27,-89,-53,62,83,-75,23,-124,-59,11,-33,69,28,16,-80,79,-116,-75,113,-115,5,97,-84,-47,59,123,5,120,-78,99,72,90,-65,93,-6,-42,43,38,71,-19,0,1,8,-40,77,57,36,-33,-84,11,-22,-94,-79,-69,17,5,8,-40,-79,-70,92,-22,25,50,-23,105,-125,109,33,31,112,79,24,-60,117,-33,22,-86,-47,-95,-112,127,114,99,-66,96,114,59,14,-59,4,101,-46,1,-114,2,16,-80,-61,-108,-70,-49,-13,-79,20,32,96,-97,72,-31,78,31,-80,115,-64,-109,29,-61,-107,-101,-49,12,-125,46,-86,76,-65,112,-7,-128,27,35,72,-35,59,84,99,-14,-72,120,-64,108,94,-33,-19,-109,20,113,-51,-103,89,48,77,1,66,-10,-123,57,25,126,-57,-67,102,80,115,122,-118,8,-8,-33,103,-89,34,-59,114,116,-106,-4,34,-28,15,-71,83,-93,70,23,-105,15,-72,113,-26,58,61,4,77,-47,-23,82,97,-30,33,51,12,61,-81,-98,-17,-101,22,-109,41,-64,-109,-67,-31,56,-9,23,91,24,-112,-56,-26,88,10,-7,35,110,4,-76,39,-11,-91,5,-32,104,37,-86,-124,108,33,31,112,119,-124,31,-33,114,-98,68,-77,57,5,8,-39,111,20,88,123,3,77,100,-39,75,68,-88,91,-26,72,-73,-109,-58,-14,-94,-26,-123,0,-124,-20,-71,77,103,116,-85,-34,-40,66,62,-28,-66,91,117,-78,-16,-2,10,61,-95,5,-32,-120,29,-87,55,55,-53,-89,81,-128,-16,-85,102,-33,58,106,34,-102,-38,-87,35,45,0,7,43,18,89,85,-26,93,-78,-40,14,-105,15,-11,34,54,-122,43,-124,-86,87,94,108,68,-123,2,-124,-20,-85,-20,77,105,-47,-126,-19,46,116,-4,52,-105,63,-31,70,46,122,101,93,-32,-123,124,-88,119,75,89,46,-48,-95,19,-92,36,-30,-116,95,93,100,40,-64,25,-69,-20,-86,38,17,71,-4,40,-66,-96,21,107,10,112,-58,-114,28,-59,-58,53,-92,64,28,88,2,-86,-23,20,-107,62,57,-109,94,117,99,-117,-26,121,74,68,-56,63,-18,-15,22,-105,44,-12,22,86,-56,31,-40,-115,-120,99,-9,-55,-46,-81,-124,-4,-119,-10,-46,-67,102,20,-32,68,-13,-94,-9,43,15,50,114,-7,-109,-77,84,87,-37,43,-64,-55,-119,-92,-69,52,40,64,-64,94,47,51,-87,92,-18,-104,108,72,-94,0,33,123,46,-45,93,31,-106,87,-97,39,26,10,80,-120,-112,-1,-10,65,108,84,-118,21,-18,103,80,-7,-128,-69,-32,-110,-42,9,-93,27,115,98,-61,-121,20,32,100,-49,-55,-107,115,-26,87,-33,2,122,42,81,-7,-128,59,35,101,117,-113,-43,102,-88,57,122,-101,-55,-27,67,127,119,116,87,-79,12,-37,62,-77,-84,87,33,31,114,-105,-18,27,116,100,116,47,-31,-106,29,7,4,113,0,-72,83,-51,-67,65,-76,-23,-95,90,-105,-53,-121,-36,-87,-116,-30,101,-53,93,88,71,37,5,56,-120,96,-76,92,16,-114,-93,-34,-99,0,4,-20,-48,-47,78,93,124,-59,-50,1,97,108,7,55,-6,31,-80,115,64,-64,-34,126,-55,66,62,-1,-88,28,16,-78,-33,-83,-105,79,-56,-119,124,-64,13,53,-102,-13,7,-28,28,112,-58,-114,-120,42,61,51,4,32,100,-81,-43,21,-24,127,73,78,-28,67,-18,-37,127,30,-87,94,-88,120,-64,-116,-36,-121,124,-50,-52,-60,67,-26,-98,93,-93,-123,47,-87,-119,124,-56,93,115,57,-41,-73,92,62,-28,-66,83,115,-90,-33,-105,-28,12,16,-58,-116,-51,-87,113,-9,-17,95,-80,115,64,-64,-98,112,25,-2,-63,79,-89,-14,33,119,-13,93,127,-66,-28,38,-14,33,119,-103,-91,124,-62,77,-28,-1,-97,127,-49,-9,-96,123,-53,-80,-99,104,-126,4,-105,63,-79,42,48,-29,-119,103,-91,112,-7,-113,-72,127,64,-114,-16,91,122,116,-59,-72,-99,122,-108,121,-3,-101,-24,89,-30,53,103,126,-22,-37,122,103,100,-106,-45,64,-112,0,-124,-21,-32,-107,70,-73,75,-101,3,-112,58,75,-35,-108,-120,-48,-106,90,-51,-51,-55,-85,-73,-39,51,-85,-78,-111,70,18,17,-84,7,104,2,-9,-80,-23,-66,106,-87,-84,125,-92,2,-124,81,3,51,88,118,101,80,83,-69,-48,-117,68,68,14,40,34,-120,-105,-89,107,-52,61,101,-86,98,30,-54,-94,-93,54,20,32,96,-121,5,-77,-105,-57,84,-37,-77,102,4,-45,96,60,-107,127,114,99,-26,-5,-36,47,74,107,30,-10,-45,104,-72,-100,-53,7,-36,21,-39,5,-53,-17,-114,-37,126,8,123,43,2,16,-80,79,20,122,-19,-78,-26,-84,-9,66,-73,19,-105,127,114,-113,-124,73,-124,-5,-25,121,-75,-5,-99,108,22,-72,2,4,-20,-16,-90,-9,59,-92,90,-121,-63,121,-30,-106,0,4,-20,-120,-38,-41,61,127,-65,-94,11,92,105,-12,-14,70,33,2,126,-24,13,55,66,-75,34,65,120,117,-2,114,4,34,-28,-17,-77,-36,-18,-41,-116,43,117,58,-51,67,34,2,-2,-127,65,-112,-101,13,89,-111,-8,93,-88,-114,87,-128,-112,125,-35,-82,-109,93,69,-107,112,-71,89,-47,-126,68,-100,-15,-61,-31,104,-12,-46,95,33,-62,-73,-97,-57,-18,70,98,-42,-6,125,-45,-72,60,-105,15,-72,97,97,103,-73,7,-47,-96,-84,-36,84,-55,43,-60,-55,-82,-99,-21,-22,41,-77,26,87,5,8,-11,-51,-38,11,-38,-22,-62,26,46,108,10,-116,-112,15,-72,-5,53,93,27,-98,-70,-52,26,-94,51,113,-123,124,-64,13,-25,-6,118,-13,115,111,-36,14,12,54,75,73,34,66,45,63,-19,-93,-17,38,37,-78,-4,123,101,-75,-127,18,17,-16,35,-58,-26,124,-124,27,-47,36,54,-83,77,-56,-121,-89,-97,107,3,-127,113,-64,-81,28,57,126,-6,17,-7,-32,-44,-58,-35,-61,-34,-71,9,-13,122,51,-19,-6,44,-28,3,110,56,-40,-59,125,33,-52,-45,53,-99,-60,-68,125,-123,8,-19,-103,52,-6,62,59,28,67,111,115,-89,-111,51,1,56,-70,107,-63,-44,-37,65,77,85,1,8,-93,-49,-67,58,127,53,-95,36,73,68,-50,99,-15,-48,70,77,99,-72,-52,-8,-124,-36,-11,-50,47,67,4,34,-116,40,-90,52,110,-9,91,-48,-87,-80,-45,-69,51,-123,56,-119,16,-91,87,68,-103,-19,83,46,127,-112,-117,-10,21,55,-107,15,-67,-13,-79,-110,107,-31,-4,5,57,7,-100,-60,21,-66,36,39,-14,39,113,-123,47,-71,-119,-4,17,55,-12,28,-19,-56,-88,0,-31,-9,-84,119,121,-33,114,125,37,-106,-92,35,0,65,86,36,124,-61,-22,79,0,116,-35,-88,-44,74,82,-120,15,-7,-65,63,-66,48,81,120,86,-9,-125,-95,98,-88,116,-103,41,42,73,87,-46,113,-108,-31,51,126,120,11,102,38,-19,-26,-16,-124,57,-52,59,1,40,68,-64,-113,16,-46,-70,-33,-52,-90,-101,113,19,-23,-32,-67,96,-41,122,-93,6,67,-71,-104,91,33,-28,3,110,116,-127,112,26,-63,-52,-9,107,-108,-54,-70,9,73,68,-64,-113,106,-46,-67,-127,-83,45,62,91,-126,-109,13,-85,85,-128,39,-5,-70,-81,53,111,103,75,42,-13,80,-56,7,-36,120,-50,-37,-35,122,-33,-56,55,-94,-67,-118,36,34,-32,55,79,-11,118,55,-57,-81,86,91,-12,-89,51,-15,-25,38,15,106,108,17,-64,-70,23,-21,4,44,17,1,63,-12,-91,43,34,65,19,50,126,123,-56,-27,67,-18,-75,-106,23,-122,-90,-25,87,-51,10,17,-16,-101,17,-4,-42,-34,-1,11,-45,86,33,66,-2,94,-78,119,17,-26,-85,22,-119,-66,123,-127,8,-8,31,-107,-91,-120,29,-38,-18,56,-81,115,-3,13,16,-80,63,106,16,-51,-44,-74,103,-89,-17,-122,-54,7,-36,88,-64,-51,25,77,-16,-99,58,61,-13,5,32,96,71,26,-100,-13,64,18,-74,-57,96,-27,-1,10,-16,100,127,-42,-16,-64,-118,-17,35,-79,-90,-111,18,17,-16,-29,28,115,-13,9,18,74,-54,6,45,-52,-93,-14,1,55,-42,-41,-19,-19,50,92,-34,-45,-100,127,1,8,-40,113,66,-18,-34,-4,87,-28,84,62,-28,-98,-83,-35,111,63,100,-48,73,-54,10,16,-80,-65,23,32,125,69,78,-27,3,110,4,-55,-35,29,14,-18,-87,120,-31,12,-105,15,-72,-111,-49,48,-4,-54,-43,-50,-112,66,-124,-65,125,-108,124,-65,-71,102,-90,53,88,92,65,0,62,99,-1,1,-9,91,-26,-79,-42,-69,58,-5,-48,20,84,-118,6,12,41,97,98,-63,125,-62,-66,-112,-4,-77,39,-118,20,116,2,-92,-83,-123,-88,-8,33,-13,93,88,78,-81,-112,63,-31,110,11,-83,124,105,63,52,1,8,-39,-51,12,-34,-93,0,7,-12,20,17,-16,-25,-21,-66,83,-6,-124,95,32,2,126,36,93,-116,-35,40,43,-67,32,-88,-52,-126,42,18,17,-16,67,-97,-19,-103,23,5,-99,-61,23,43,100,21,-14,-95,121,-37,-57,30,-61,40,-104,81,-66,22,-101,-117,-94,0,1,-69,-3,127,115,-34,-49,-112,98,-122,-67,-39,58,108,47,9,-64,-119,-127,91,-52,73,104,-115,-90,105,10,64,-64,14,-121,-35,-51,-82,-88,55,-10,30,-49,-45,84,-120,-128,-1,-47,43,-95,-34,-120,-82,-45,58,92,1,8,13,-95,-30,-38,50,-101,62,-70,-18,62,-40,-88,71,5,8,-40,-33,-21,-80,-51,-21,-77,-27,91,104,93,-123,0,4,-121,-61,-93,16,27,119,-53,41,79,-102,82,-87,16,-95,65,-31,-85,-91,107,-126,55,79,-83,44,38,30,26,19,-71,-17,-7,87,16,53,31,92,24,19,68,-2,-64,80,-7,-22,14,93,0,-62,3,57,-91,-75,-69,-60,9,-47,-11,69,51,-86,5,32,100,47,-71,126,68,78,-28,-49,-72,-51,-30,102,-21,-100,-118,-121,-52,-66,-64,-5,107,106,34,127,-14,-85,-111,-5,81,104,53,40,-105,15,-94,123,72,-70,113,-31,13,91,-62,-23,-98,-44,-17,23,-128,-49,-40,-65,-35,116,-101,25,39,-91,-53,-43,-128,107,-103,106,-40,-16,69,8,-109,7,-1,-124,-67,53,116,-32,112,54,-127,105,-56,-63,-53,-113,5,32,96,71,18,64,-23,-50,100,-78,-9,-102,-24,45,-95,0,4,-20,-29,-70,87,-39,-49,-114,-46,-112,-82,67,-37,15,8,64,-64,-114,112,-14,-3,102,-19,-11,-100,-87,-93,35,0,-63,37,36,-118,-49,-85,51,84,-45,117,-73,68,-105,-77,0,-124,-65,-67,-108,-71,-57,-27,97,45,-107,-59,75,121,57,32,100,79,-91,-18,-43,21,48,-105,-78,-67,71,-26,70,41,-60,-55,-69,25,88,-64,-99,30,-60,2,16,-78,-81,113,-17,-57,-86,61,-72,-3,60,-34,6,78,33,-50,-8,113,-2,-47,-10,-77,18,113,-60,111,-74,-15,-54,-76,45,-95,0,-100,-79,-29,-73,-16,80,-106,66,-100,-16,87,4,33,-19,-41,-100,-65,-3,-1,-125,56,-29,-17,-41,-24,-119,30,-53,10,17,38,15,-40,-30,122,-53,64,-68,115,-25,121,21,28,16,-78,-113,57,-100,-23,4,63,-92,-47,42,80,1,56,98,71,54,92,-91,87,-16,2,112,-62,-98,-17,43,-25,69,123,19,8,-64,65,66,72,69,-81,1,51,-5,-24,123,-25,-128,48,-119,40,-115,-67,120,1,15,58,-6,77,-35,22,1,8,83,-1,102,-19,-51,73,35,94,-70,104,-55,-93,66,124,-56,-1,-3,-127,-89,71,-105,-17,-70,80,-1,-74,-62,-26,-78,66,56,118,-106,63,97,-17,-72,-13,-78,51,119,127,114,125,5,39,17,79,126,83,-13,121,-70,28,20,72,-105,-54,66,-29,10,-16,100,-57,17,88,93,-98,27,-12,114,-94,41,49,10,-16,100,-17,11,-35,-42,-100,-80,-52,93,83,-128,-128,-35,-100,-45,-107,-36,85,38,46,-89,51,91,-46,10,-16,100,71,-109,-12,59,-17,-105,0,-72,63,-50,52,-12,-82,0,79,118,52,110,114,45,46,-22,-85,29,-11,98,-13,-96,20,32,96,55,99,100,54,39,-116,27,65,-54,-51,-60,-97,-52,40,123,-82,46,-46,83,39,-110,-9,111,102,-110,74,68,-64,111,10,-78,36,119,18,78,-92,-117,49,-61,72,1,-98,-20,121,93,99,44,-25,-18,-95,111,97,-94,55,-38,18,17,-16,119,123,-80,-6,38,-52,-109,88,-123,124,-64,-99,77,-61,-70,110,-35,21,-93,-80,38,59,31,20,-32,-55,-114,-36,-77,-18,-46,-21,49,40,-80,36,118,45,-84,0,79,118,92,53,22,-97,72,-114,2,-106,78,3,-59,18,17,-16,99,-68,-98,91,-64,3,-57,56,37,103,-30,15,-26,-122,-76,0,-45,62,-5,-17,64,62,-1,26,116,14,-116,66,4,-4,-8,72,-5,40,-99,-118,-23,24,-3,-90,-109,96,4,-32,-55,14,19,-2,-19,-89,-32,35,101,58,29,82,0,-98,-20,3,115,48,93,-67,101,125,13,33,103,-107,-27,10,16,-80,-41,-53,118,-14,114,-62,72,-112,92,124,-70,-113,64,60,-7,-15,81,-6,-88,111,-46,117,37,58,-36,82,33,-98,-4,24,-33,-47,-99,-38,-21,-88,-52,-32,99,-60,4,-32,-55,-2,-104,-26,13,-31,-69,-118,97,-44,28,16,-80,99,68,-13,94,-70,-4,37,59,7,60,-39,75,-75,35,-3,30,-2,53,-26,57,-24,-76,88,1,120,-78,-25,-119,-112,117,-14,75,56,101,86,-76,36,-28,3,-18,27,-115,-34,119,81,120,-103,124,-78,29,-105,127,114,-89,-124,60,-104,-18,21,-98,41,38,-74,85,-71,-4,-109,-5,-82,-10,-70,-6,30,105,-57,-76,-86,-58,122,-51,9,-7,7,55,50,-68,70,27,123,126,77,-99,-80,-39,42,-53,87,-110,-120,-128,31,93,40,93,-115,-115,78,42,84,-128,-128,61,99,-117,-71,71,-43,70,-92,68,60,-7,-51,2,76,-77,-17,-7,24,42,11,-115,-117,31,49,-53,68,46,5,56,121,47,58,75,65,1,2,118,-13,71,-14,91,-115,52,78,-32,-52,-46,112,37,34,88,-17,9,117,82,-5,53,-77,-18,121,-94,0,-63,78,-59,-18,112,-83,64,94,-35,41,89,-112,65,-56,7,26,6,-118,116,-71,-68,38,-52,-35,-18,-115,-3,114,1,8,52,-81,45,-90,-36,92,-33,24,-39,13,74,1,-126,83,3,99,-73,-89,-53,-76,-85,104,11,-70,-104,38,-112,-120,-32,-60,-58,1,-23,-102,-114,55,-108,-112,-77,-96,-93,-112,15,-84,13,83,64,-67,-70,22,44,95,77,65,20,-120,-64,-50,-77,5,-26,-109,16,27,-102,94,-80,28,99,33,127,96,-3,66,-74,-48,-116,72,33,31,122,76,109,-76,-20,63,80,-67,89,-118,-124,-112,15,124,61,-8,86,110,-58,-68,-98,87,-94,0,-127,15,108,-25,122,-13,-103,80,104,-36,75,103,-1,42,64,16,123,-24,-88,-90,-103,-2,-105,-84,81,89,-108,84,1,-126,-88,76,-67,-90,43,110,-4,-118,93,0,-126,-120,-110,-83,-36,-22,-102,-103,-95,27,115,101,-7,109,66,62,-120,-122,37,116,-19,56,-97,19,-93,0,1,-69,125,-19,92,-57,57,57,-107,127,70,9,49,-60,39,-69,-58,-32,80,79,38,-53,90,102,75,68,-64,-33,-82,62,-3,2,80,-125,127,-124,-4,-109,27,105,26,-77,-66,105,58,58,104,-115,73,7,-68,19,-41,-119,-71,123,29,103,-5,-115,109,34,-119,120,-14,-93,-105,83,-11,-61,-86,-112,103,75,-39,-71,124,-64,-115,32,-82,-85,-128,107,112,6,-23,-32,72,46,-1,-28,46,-35,-36,-66,57,79,-75,-71,-112,127,114,99,-96,78,-10,93,-116,112,65,92,88,-12,78,1,2,118,-77,-29,125,-123,-83,-98,12,-93,0,79,-10,-122,105,-83,-59,-53,-102,90,26,-20,123,114,-7,-128,-37,-68,-122,-20,-118,63,26,-110,120,27,-115,-30,11,64,112,71,-128,-116,-17,-47,-34,-106,22,-97,86,-90,0,-31,13,68,-70,93,30,63,38,27,-74,76,7,-115,82,-7,32,-83,-10,-66,-54,112,-106,-85,-100,-81,44,-28,3,-18,-73,46,51,16,-83,-103,-27,-46,112,-15,-128,25,9,90,110,71,-32,-8,-99,-125,53,-126,83,-128,-128,29,69,78,-59,-23,125,124,122,-26,-17,10,-7,39,-9,-60,67,-70,70,-58,21,-17,47,-45,113,-98,2,16,-80,67,11,-35,-69,110,46,-7,-70,27,29,34,-94,0,7,-23,-58,-16,114,10,-99,-18,74,-59,3,102,12,-19,113,125,-87,84,55,40,46,126,-64,-100,-20,8,-81,55,75,22,21,-14,-31,-5,104,-90,-8,-49,-53,90,36,34,-8,-102,-56,-58,119,45,0,-47,-125,-67,-74,-58,54,-89,0,-124,43,-15,109,96,106,93,80,19,52,73,69,34,-126,93,-76,-82,101,39,-53,91,36,-91,116,-6,-22,5,-32,64,3,-44,-41,88,-45,-55,18,105,21,32,-44,92,53,-19,-66,31,-124,-17,-55,90,-50,11,-7,-112,-37,-49,36,-57,-43,-57,40,-115,-59,47,21,32,96,127,27,-23,-117,-37,3,126,47,-56,-59,63,97,-2,-10,11,122,4,84,114,118,-63,-55,-5,-105,8,75,28,-83,33,-78,52,88,115,-54,93,95,-111,22,-33,78,11,-93,34,115,99,-47,26,-119,8,-8,49,-34,-93,-20,46,6,26,48,85,51,50,-56,-81,-105,-120,-128,31,-98,86,114,-103,-52,104,-25,-70,104,-78,-84,68,-124,-4,118,-16,-7,-10,84,-78,87,-106,68,-124,-17,103,117,-105,-97,14,59,-101,78,10,18,-14,79,110,59,70,-85,107,92,-14,69,62,-114,2,4,-20,-24,-61,-97,-78,75,79,-81,-80,40,89,4,84,0,2,118,-52,-121,46,46,111,-33,86,-75,-99,37,-116,-100,-54,7,-36,-120,-119,-36,-55,101,-109,-95,12,123,-80,75,69,-119,120,-14,99,114,110,95,109,123,80,84,123,-108,-58,-26,51,40,64,-64,-114,25,104,125,111,23,81,112,70,-11,-54,78,53,-119,8,-8,95,51,-31,-9,-36,100,100,82,46,83,34,-20,-61,42,-60,-109,31,-105,118,101,-113,-57,22,-100,36,-21,102,95,-106,-53,7,-36,24,-34,-112,124,-106,38,50,-7,-40,-4,58,5,8,-40,-31,-65,-20,14,83,-79,19,35,53,90,56,-93,0,1,-69,89,2,102,-101,-70,-20,97,91,99,51,-79,-18,19,18,17,-16,-29,122,-61,-43,-87,35,59,121,-46,-84,72,5,120,-78,99,48,-25,-35,-10,-66,-95,-91,-95,126,-118,118,38,-110,-120,-112,-65,-89,-67,-23,58,-78,-62,83,41,-12,-27,8,64,-64,110,-86,105,-114,-35,48,43,56,115,58,-75,-94,37,34,-32,-57,14,116,-99,-12,75,105,-56,-26,102,-121,-108,0,4,-20,88,7,-55,21,61,-38,-95,96,11,-103,-75,-76,-110,-120,51,-2,-118,-7,29,-52,11,-112,-120,-16,-19,-116,-76,-22,118,34,-101,-73,-115,105,-87,-12,-25,115,64,-64,-114,17,-128,-82,122,-83,32,-69,-41,94,46,-3,-11,2,17,-16,-37,-98,-88,123,124,-74,-36,56,-43,-56,-91,11,23,15,-41,124,78,-9,110,23,23,-76,99,-101,84,17,11,64,-96,15,58,-22,-44,118,83,34,-81,-127,-23,49,84,-101,113,64,-88,43,-25,-36,-45,-109,-14,66,-115,8,-75,-6,-72,124,120,-126,-36,-39,21,-79,102,115,59,103,-93,-7,-23,18,17,-100,-128,-80,-32,-36,111,-103,-10,-105,-50,38,89,8,-7,-48,54,-56,-61,-51,-108,-49,118,-100,-115,116,-45,-67,-92,16,-127,109,-125,89,-99,123,73,-72,125,-3,75,-40,6,92,62,-76,-55,22,122,13,110,-62,72,-57,75,-76,-63,-88,68,4,-4,104,29,-105,118,89,-24,-92,-54,-94,-128,66,62,-76,-29,81,67,-28,126,73,-61,12,25,-86,-31,21,34,-32,-57,-6,-99,123,-28,0,-46,-91,22,-102,39,-95,16,1,63,-44,-58,116,15,107,106,-93,36,22,13,80,-128,39,123,-58,-51,73,-39,-81,37,109,-55,-103,-111,53,-23,1,-91,16,1,63,6,72,-114,-3,-22,48,35,22,58,89,98,-112,2,4,-20,-56,-93,-56,-18,-89,-96,-20,-118,78,-48,86,-128,-128,29,47,114,-7,39,53,63,-87,114,15,89,33,-98,-4,-72,17,-62,38,-15,-46,119,97,-51,87,20,32,96,127,-51,52,-33,-49,-101,108,118,-35,44,116,-35,8,64,-64,-114,91,-102,54,-90,23,-82,-71,-79,-68,85,-119,8,-8,95,99,-22,-100,-2,-24,-13,66,50,39,-45,-12,10,-15,-28,127,117,11,-54,31,-48,11,64,-64,-114,-40,94,-102,31,-80,115,64,-64,-114,-55,-122,107,-65,78,-64,50,-56,53,81,47,86,33,2,126,-12,108,-53,-3,-125,117,-81,16,1,63,-62,-62,-50,18,-126,-12,108,-76,-13,-101,68,4,-4,48,-122,-42,-86,126,-105,-101,82,-95,-81,-121,3,30,-20,101,-67,38,-54,-75,55,5,-123,44,76,-14,-21,37,34,-32,71,87,-60,84,-68,122,29,41,-79,-53,118,5,8,-40,95,-29,-45,-4,74,-112,-89,-107,68,-124,-4,-91,58,11,58,35,65,18,-41,-115,-100,-97,34,66,126,59,-56,-42,46,-116,-115,50,-39,29,-109,2,-100,-80,79,-108,79,15,102,-68,42,-64,17,123,-59,93,26,-79,67,-124,124,-72,42,-53,44,-34,-100,-21,-104,-61,-57,110,-11,37,-30,104,79,-95,49,119,-98,108,-40,-124,68,-124,58,-83,-20,119,117,121,-75,87,86,-74,-48,104,68,-2,68,27,47,44,-127,-63,118,-108,2,28,-100,36,5,79,94,22,43,-5,81,-128,-32,28,68,-118,-120,-53,8,-122,99,119,15,118,97,-85,0,39,-89,120,-71,97,-53,117,126,-54,10,68,-64,-113,-24,105,117,-18,58,-70,59,102,54,87,90,1,2,-5,12,-2,-111,107,58,-124,-114,-78,-109,-42,-76,42,64,-64,14,-33,-50,-91,25,-107,27,-26,-48,-51,-54,11,37,34,-76,-68,-25,-19,98,108,-10,-23,38,-99,68,46,-28,67,-97,97,-9,74,11,58,92,-105,76,-125,66,84,60,96,-58,-14,-86,46,64,2,-91,65,-125,30,92,62,-32,70,122,-6,-82,-17,10,-86,4,106,-89,-5,84,0,66,63,112,-104,75,-67,-65,-64,-116,-107,75,83,7,37,-30,-32,62,-89,-28,102,-8,-63,-46,-40,20,32,-68,-83,27,-82,16,-79,100,-88,36,-106,15,38,-28,3,-18,117,-39,105,-32,34,-102,5,49,-69,73,-109,-15,21,-30,-116,31,-9,110,-117,-33,-44,9,68,-8,110,-38,76,-5,-3,45,34,-78,119,-93,62,-90,0,-124,-33,117,116,55,-83,-48,108,31,51,-89,-23,-80,31,-119,8,87,-67,25,-102,-5,-35,91,105,-81,-122,123,-4,-19,8,68,-72,99,77,39,21,23,109,71,-36,-79,-14,123,94,-127,8,117,77,46,-51,-73,109,25,-88,102,-93,21,11,10,113,-94,39,49,73,-69,76,-42,114,77,1,2,118,44,-123,-78,-33,-39,22,-28,-81,-51,-62,26,104,73,68,120,-118,-116,-22,-114,-124,-114,77,78,111,121,-71,124,120,-2,-43,-103,-36,123,-60,-35,71,101,-87,28,10,16,-80,-37,-65,-28,61,-108,-127,-90,48,-26,-77,80,-125,79,0,78,98,31,101,-68,110,14,105,116,-126,3,66,-69,-93,116,55,79,-69,96,-26,-50,-92,-7,-77,18,17,-38,77,35,-113,-27,-18,61,-79,-58,6,85,57,10,17,-16,-41,43,-81,-27,26,-2,-104,95,49,103,-89,123,74,33,66,-85,-78,-70,18,-27,-14,-102,-31,-61,-125,126,2,16,-80,-61,-14,119,-38,21,-43,-2,41,83,-1,91,0,2,123,27,11,-63,89,-120,72,-108,55,-113,-114,6,15,56,32,-12,21,26,-90,84,-19,-46,-72,126,43,60,-10,33,16,1,-1,47,41,-62,-18,-41,32,-97,96,82,51,65,33,66,63,106,-91,-30,-13,21,-80,-50,26,-67,-13,82,-120,-128,31,-27,-91,-9,30,101,3,65,-70,39,127,-3,2,17,-58,-122,114,117,9,97,55,-18,-9,104,64,-105,-53,7,62,-14,-85,-34,-26,-67,31,79,95,-117,24,-81,10,16,122,-32,-55,109,-16,47,-6,-21,41,-64,65,84,8,-127,114,-5,105,-52,-90,87,-128,19,-10,-126,38,78,55,115,70,20,-32,36,98,-10,50,-111,104,-81,90,5,8,-65,-86,-71,-26,126,-48,31,-6,-21,-80,-85,41,5,8,-29,30,29,-41,-88,-69,-80,-100,12,40,17,97,-84,-75,-70,33,77,-75,-67,-54,-61,-87,38,22,-128,-109,72,113,109,-81,-74,2,-52,93,19,-128,80,19,39,-5,40,78,24,-99,-35,110,54,8,76,34,-62,115,4,-50,-77,-21,42,-128,64,-13,98,-63,62,-119,56,57,-59,113,-113,110,-122,47,-5,-7,2,112,18,-5,64,122,-63,61,-87,-85,44,0,1,59,84,-45,-19,114,126,7,114,49,89,81,-90,2,-124,55,95,-74,-58,-86,19,70,-91,120,-91,33,4,-123,8,-17,-19,110,63,41,22,45,1,109,-107,81,-101,-98,3,66,-101,-69,-103,-74,-37,95,-28,68,-124,-125,-23,27,5,8,-4,29,24,43,109,47,65,-7,-86,-86,95,33,78,-4,53,116,5,90,-119,-43,-37,40,64,-64,-114,37,-36,92,54,55,-118,0,10,-67,122,17,-128,-16,30,63,-113,-10,-34,-24,-119,-52,33,-94,-46,39,-7,7,-24,44,-112,115,101,-121,-85,68,4,-4,40,-83,-50,-82,119,-52,122,117,23,-96,-79,33,-123,8,114,63,16,5,115,38,-42,-62,-119,83,104,-126,-125,0,28,100,-83,-96,-47,67,-69,23,27,103,-82,0,97,102,-27,-20,-43,-11,-92,88,104,121,81,-87,-106,87,-120,-109,-20,71,61,74,73,1,-62,-4,-66,-68,-110,59,-48,94,-74,11,119,52,21,34,-32,71,-86,-28,116,-67,105,-66,-30,23,-120,39,-1,68,-74,97,107,-29,-100,95,33,2,-2,-9,-42,23,95,-46,115,-64,-125,-3,-43,-94,3,83,115,119,105,28,58,-119,37,-8,73,68,-64,-65,-82,-74,-14,94,-78,-9,-22,-74,-63,110,-44,-124,-4,-109,59,-93,103,-46,-12,37,59,74,15,43,-64,-109,-35,-44,106,-69,-35,107,28,-81,-114,120,-84,99,3,-105,15,-72,11,74,-34,-21,-101,-10,-32,99,-37,20,-32,51,-10,63,124,123,51,110,100,49,-34,-18,108,67,-94,-13,8,-117,50,-107,112,-8,-32,31,-79,15,123,-16,59,-69,-10,-13,13,107,103,50,-101,72,1,-98,-20,-16,-50,-46,-5,-64,-17,76,-117,101,-124,124,-16,-53,81,-42,-18,-68,-75,10,-93,-98,117,-78,20,-14,31,113,127,-5,106,24,-74,-97,-52,-35,113,118,26,53,-92,-108,112,-4,-40,-33,-58,-2,-3,15,30,-115,108,-92,-83,34,-91,116,-4,-24,-97,-15,35,-28,-107,-35,-40,82,12,29,41,-115,57,78,10,16,-80,-93,-82,126,-49,-18,-60,9,-48,-54,-99,-40,62,19,-128,-49,-40,-65,95,125,61,-6,-15,99,80,125,-50,-31,-128,64,46,27,43,-81,15,-72,-51,82,-67,-70,-73,9,42,98,112,-115,-99,-108,10,16,-80,103,-116,-3,116,-99,70,117,-112,68,34,62,-28,-1,-2,-113,86,49,-120,-64,-51,-91,121,93,5,-36,-31,20,19,33,28,127,-74,111,99,-1,1,-85,-11,49,50,-36,12,26,51,-9,74,56,79,68,73,-109,21,-5,9,-65,-39,105,118,20,-41,-18,12,13,-116,78,98,-41,8,10,16,-80,-37,-101,-99,-11,-2,-128,-99,3,-98,-20,-91,99,100,-43,57,57,-105,127,114,-37,70,-100,-59,-59,-72,-12,-36,92,5,8,-40,23,-122,50,57,-17,7,17,-57,-59,-54,-83,20,32,96,-57,115,-70,-34,-72,-38,-49,86,-128,-49,-40,-65,127,-73,100,12,59,-50,-66,108,28,54,121,-40,5,94,8,-57,123,-27,-37,-40,127,-64,-125,87,-44,-119,56,91,1,-107,-109,97,-15,-95,18,38,15,-2,93,-20,63,-32,-63,-47,103,97,47,72,69,-37,-24,-124,-90,-61,-47,79,-29,-62,-28,-63,-65,-117,-3,-5,31,-36,60,-103,-98,93,-117,92,26,59,22,-78,-15,99,127,19,-9,15,-8,-38,-21,26,-51,77,-99,98,-67,-80,-71,40,-7,-46,-33,-63,-4,67,30,56,-107,-23,98,-90,3,-41,-85,97,93,-82,-108,-90,-113,-3,93,-4,63,96,-119,99,-74,85,111,111,119,59,-92,121,-122,-108,38,-53,-4,-5,-8,-65,-1,-31,31,-93,-34,6,124,-8,112,24,11,21,-115,31,-5,91,-104,127,-64,3,15,84,72,-68,93,-122,-111,-66,51,74,-104,60,-12,119,-79,-1,-112,-77,59,-41,-28,-101,99,35,-28,-107,-93,62,-92,82,-102,-98,-34,-33,-59,-1,3,-66,-6,125,-91,-18,-118,-45,121,-48,76,9,-109,-81,-2,93,-20,63,-64,-93,-59,92,-50,-76,-9,-93,-88,-81,-42,118,97,62,-83,-108,38,62,-19,-9,-15,127,-1,-61,-49,-122,-69,52,87,-71,55,-52,84,10,-61,-103,74,56,126,-12,79,-40,-31,-96,-36,-5,-76,-50,-116,-18,2,53,-77,-102,73,33,-1,-28,54,-25,122,-67,21,116,35,21,-91,53,-106,45,33,17,79,-2,-98,-19,-79,-46,126,39,-103,-20,-39,11,-26,-69,19,126,-123,120,-14,-49,121,-75,-69,108,-106,78,-22,-13,50,31,-107,-87,26,5,120,-78,-81,117,-83,114,59,-31,-126,70,27,44,19,70,1,30,-20,-23,78,-27,74,-120,-3,110,-30,109,97,-112,28,-7,-15,18,17,-16,-61,24,74,-73,19,46,-105,-19,1,-30,54,43,64,-64,110,11,-95,-76,-67,42,58,-95,-107,-7,-88,-84,51,-127,68,124,-56,-1,-19,-5,125,-95,65,75,-38,119,13,-110,-100,113,17,19,44,11,46,27,-81,-118,15,-72,-19,19,-9,-85,-74,125,126,-58,23,5,68,18,17,-15,-73,-21,46,46,-45,61,35,-73,45,-45,-119,-37,26,18,-3,31,-42,-43,-36,-60,101,-108,55,-10,-71,88,-98,-114,68,4,-4,21,-101,-64,-107,-15,-11,87,-23,39,75,38,-107,-120,104,-31,-51,-85,-17,-39,102,-71,-65,-86,-122,-39,36,84,5,8,-40,77,1,101,55,-107,53,-29,8,-81,-76,116,64,34,-98,-4,-55,-66,-67,89,-122,123,81,-75,61,125,-93,3,-112,20,32,96,-81,11,-29,118,-9,-14,-52,-126,38,23,-109,37,58,75,68,-64,111,-81,50,-113,61,46,-104,-47,127,-49,126,31,83,42,10,-15,33,-1,-73,43,21,83,-88,-19,-54,126,110,115,65,-24,-95,71,103,-103,-108,102,10,-5,-37,-8,127,-64,-61,23,91,70,-53,-123,-39,42,-44,94,-115,-102,105,74,105,-14,-16,31,-15,-101,-110,-71,82,117,58,24,-67,-49,-18,-62,118,-75,0,4,-20,102,98,-115,-30,-22,103,-121,-83,43,98,-95,113,-15,-128,-71,100,-108,21,-69,-33,-127,-102,-68,-101,93,-62,73,68,-76,-93,11,-122,-39,46,47,-51,111,-94,20,32,96,71,67,-118,-23,-53,-98,48,84,-75,82,93,-83,16,1,-1,-54,-105,89,-98,123,1,11,-102,82,-42,-101,-11,78,-108,-120,39,63,76,-37,-107,-13,91,-29,-77,65,-53,-56,20,32,98,-97,-56,-20,-40,-123,81,-28,96,-81,-128,45,74,-123,-120,-8,-19,-33,-90,63,-73,95,-51,-61,-104,-78,22,-128,-49,-40,-65,93,-101,-32,72,-67,-117,-69,90,110,8,93,-9,40,16,-90,-124,-61,7,-1,-120,61,-95,1,77,-15,-77,26,-13,107,82,48,-101,45,38,17,1,127,-70,-22,-104,-82,35,-17,-115,-50,-62,-109,90,-42,10,-15,-28,31,47,51,122,-41,15,29,109,91,89,118,-99,-112,15,126,-69,-83,-49,-28,76,-71,-126,110,-91,-117,-114,72,-108,-120,39,63,-122,-62,-102,-35,-26,-86,76,-77,29,-23,-99,58,53,10,-15,-28,-121,46,-24,-9,-36,-21,-90,26,-70,9,-45,41,-119,18,17,-87,91,76,-64,113,-3,-4,42,90,21,36,22,11,-107,-120,-64,31,-66,122,-15,29,-3,-48,95,-40,-68,3,-22,15,115,-64,-125,29,-53,-72,-35,123,-85,-27,-110,80,114,55,-24,-88,27,1,-8,-116,-3,-5,21,-54,-85,88,-80,-71,-9,74,91,102,42,-31,88,-95,124,-60,-98,-47,-36,96,-91,-35,-1,-23,-24,8,-56,-10,-116,2,4,-20,-120,-2,-92,61,95,49,55,-76,-6,-95,9,-81,18,-15,-28,-57,-108,-12,-31,-122,76,-61,-127,88,105,-80,70,0,18,17,-4,-2,-124,112,-106,107,-58,-120,-114,105,99,86,114,74,74,68,-64,-113,71,-85,123,-125,-17,-116,-82,96,-99,-6,-13,18,17,-68,-97,122,-103,13,-80,-5,-25,-55,60,-70,-103,22,-117,34,73,-60,-109,-1,-50,-104,-49,-72,-41,23,-91,-119,-88,-51,-51,46,-53,37,-30,-87,-78,108,41,-49,-102,118,-97,41,13,-13,-2,75,39,63,95,1,-126,-61,-56,30,-52,-20,-91,-3,-73,-32,118,-74,14,86,116,45,17,1,63,-42,-14,-36,47,11,-46,-85,-115,-42,100,89,102,18,-15,33,-1,-73,107,45,12,105,89,-93,-18,-115,-53,17,97,28,-74,52,-94,108,116,37,29,39,117,127,-60,-1,26,102,-100,-6,-34,-41,39,-95,109,-48,-94,-67,4,4,32,96,71,-93,-106,-70,-101,-22,-81,64,48,45,105,-30,-14,65,5,3,-70,117,102,-41,-43,127,-95,-99,82,-94,-91,112,10,-15,33,-1,39,-53,-30,15,-1,27,25,-77,-99,-16,96,-109,1,0]},{"id":"841d20a5-af0c-4acb-86e3-4775833fed91","createdAt":1712948762060,"playerId":"11e178c5-8e89-432a-978e-fc95fd17f8bf","localPlayerName": "Mamo","sequence":4,"gameId":"5a2376c6-3285-474c-9896-ee66829b77c2","timePassed":0,"sentence":"cat on a hot tin roof"},{"id":"ad859450-07aa-47e8-ab23-2c4c24cf7d3e","createdAt":1712948862060,"playerId":"11e178c5-8e89-432a-978e-fc95fd17f8bf","localPlayerName": "Molly","sequence":5,"gameId":"5a2376c6-3285-474c-9896-ee66829b77c2","timePassed":0,"drawing":[31,-117,8,0,0,0,0,0,0,0,-51,-67,-51,-50,45,-57,113,44,-6,46,28,11,-115,-82,-1,42,-65,-61,25,25,-72,103,96,104,96,64,27,18,113,116,68,-125,-92,-32,123,97,-8,-35,111,70,111,-39,-82,92,29,-111,-35,18,55,5,9,-48,-128,107,71,-60,-41,63,-43,85,-103,89,89,-103,-1,-14,31,-33,-3,-15,-5,63,125,-7,-25,47,-65,-1,-65,95,-2,-12,-13,79,-33,-3,-45,-65,-4,-57,119,63,-3,-4,-81,63,-2,-4,-35,63,-3,-57,119,-1,-17,-1,-13,-81,127,-4,-13,-105,-17,-2,-87,28,-25,111,-66,-5,-1,-2,-14,31,41,117,-5,-17,-1,-4,-51,119,95,-2,-12,-69,39,-48,127,-2,-122,-88,-11,55,106,35,31,-71,-76,-103,118,100,-83,-57,-86,103,-31,-86,17,-31,-82,94,-113,-47,114,94,59,-72,-76,99,-44,-110,-123,122,64,-72,-85,-113,-93,-81,-98,-14,14,-50,-3,88,118,-81,66,61,32,-36,-44,-25,121,-44,-43,106,-37,-63,105,28,-93,11,-15,0,127,-41,46,71,41,101,-116,29,123,-114,99,-106,52,-123,120,64,-72,-85,-9,35,-51,-79,-10,-121,120,-82,113,-28,-86,-60,53,-2,-82,-67,-114,-108,-26,126,-109,-25,108,71,-53,-22,-95,72,-8,77,121,-91,99,-107,-44,28,-42,6,91,-87,89,-116,-60,-120,112,87,-73,-127,53,114,-18,59,-72,-83,-29,-108,15,37,34,-36,-43,-19,31,74,-11,-9,105,31,69,107,103,21,-22,1,-31,-90,-98,-50,114,-28,-66,82,119,-16,-110,-113,-76,114,-29,-6,49,-123,-4,-123,113,-44,-98,-109,27,2,105,29,61,21,113,3,33,-29,-82,-97,-14,81,75,90,115,71,-101,66,-53,51,9,-3,-120,65,-12,-89,-51,74,-93,108,95,-10,-78,23,88,123,63,-59,-64,12,25,119,-3,92,-114,-39,-110,67,-37,-9,62,75,85,-49,63,32,-36,-43,-117,77,29,118,95,101,3,-9,105,-45,-110,28,62,33,-125,-24,-37,52,-44,-54,-40,-98,-27,106,-61,-122,-126,84,-105,-8,-69,118,-75,27,29,107,31,-55,-85,-10,-93,-11,-103,-107,122,-60,-72,-21,55,123,106,35,-11,-19,59,92,118,121,54,-47,10,117,-115,39,-38,-13,56,71,-103,-5,125,-38,-125,93,-71,39,-11,90,35,-58,93,-65,-73,-93,-28,-47,118,116,-74,105,-91,-116,37,-28,3,-62,93,125,96,-120,-27,115,31,98,-10,1,-74,-95,-98,-116,-58,-33,-75,-89,-51,-93,-29,-84,99,-57,-10,35,-97,107,42,-11,-120,113,-41,-73,-71,-37,-26,-42,-75,-65,-91,-108,-114,57,-69,122,-16,1,-31,-90,-98,79,44,-59,51,-43,13,124,46,-5,96,-106,-104,108,34,-62,93,61,-99,-80,-128,-54,62,126,-49,126,-12,58,-108,122,64,-72,-85,-25,-13,40,-53,-42,-79,29,108,-93,98,100,-79,78,69,-124,-69,-70,13,-42,-106,90,-83,30,44,12,72,-119,38,-70,-13,-104,-53,125,22,6,-84,102,-98,-120,-9,25,17,-18,-22,117,-40,-3,12,55,-74,-20,1,-86,-85,86,-24,-69,-82,77,106,35,-107,-18,-82,-62,-56,115,12,33,29,16,-18,-22,-35,38,-75,-110,-10,17,123,-50,99,44,101,88,7,-8,-69,-10,-80,79,107,-8,-25,103,-93,-52,62,-62,41,-42,-69,-112,113,-41,55,35,109,-40,-5,-39,-41,-105,4,-117,-94,-88,-117,15,8,119,-11,-43,-114,-34,-19,97,-6,-71,34,-51,37,-27,35,-58,-35,67,50,-29,-57,86,91,-73,58,-38,76,87,-41,41,-66,-48,-120,112,87,-73,121,-89,-107,-45,61,-55,-100,-113,-103,-44,-126,23,17,-18,-22,-8,-100,-51,-16,-36,47,37,-37,-38,59,-43,-117,-115,8,68,-35,30,90,29,-89,91,29,-115,-33,-49,34,62,-44,-112,113,-41,55,11,115,117,63,-54,74,-63,7,-94,108,-115,-112,65,-12,-89,-39,-56,-39,13,-77,-126,-127,-35,-117,-8,100,67,-58,93,-33,108,19,27,107,105,7,-37,-118,47,87,-67,0,79,-76,109,-54,-21,101,-57,-42,-13,-14,96,-108,-74,-60,-33,-75,91,62,108,8,-44,125,17,-128,-103,-107,-102,122,44,1,-127,-88,-37,-57,109,-125,-54,-127,109,-119,89,-67,-88,65,25,49,-120,-66,77,-85,107,127,67,118,-21,109,74,-37,61,-64,-33,-75,59,-106,-57,-68,123,-119,-53,-18,-67,-51,57,-43,-93,-119,24,68,63,-37,74,-98,-5,62,51,-39,-27,-75,113,74,121,77,32,-22,-51,-52,-18,-34,-10,-81,-81,-37,-41,-79,84,-4,36,34,16,117,-5,-69,103,77,-5,-73,-41,-51,49,77,93,94,-69,38,16,-11,117,120,-109,106,-104,-25,95,-86,-80,125,53,-4,-82,108,107,89,61,-101,123,-124,-45,-36,-71,115,-88,79,41,32,-36,-43,-51,79,107,101,-106,125,124,-83,98,-21,-2,16,22,88,68,32,-22,-51,-36,-123,121,-18,-105,-78,38,126,82,107,83,64,-72,-85,-101,-103,92,83,-33,-35,78,-13,-102,43,126,83,51,88,-60,32,-6,102,72,-27,94,29,-40,-66,61,-13,-45,-107,-68,38,-36,-44,-85,-103,-31,-26,-111,-5,-88,72,-54,-41,111,92,62,100,16,125,-77,-80,-22,-88,-18,94,-109,-83,-107,-3,20,3,39,100,-36,-11,19,102,-114,-103,92,-52,40,39,-4,38,62,-41,-112,65,-12,-85,-71,-55,-93,56,112,-75,-43,95,-53,107,2,81,-73,81,101,83,-85,-65,-106,-21,55,-11,-12,35,-58,93,63,-37,60,116,-82,-31,-98,101,-7,-6,-101,-48,-113,24,68,31,31,-118,15,72,-107,-81,63,41,121,77,32,-22,54,61,-27,122,-70,-111,92,-82,-33,-108,-70,38,-36,-43,-51,10,26,115,-70,27,-83,21,-42,-71,82,15,8,68,-67,30,-13,-20,30,108,14,-88,-76,88,35,2,81,-97,71,63,-3,16,110,-25,-11,-109,82,-41,-124,-69,-70,-39,60,88,46,29,-72,30,-10,-55,11,87,33,34,16,-11,-126,16,-123,123,71,109,30,37,85,49,27,71,4,-94,110,-13,-24,-104,110,75,-64,-98,-22,81,-117,-118,94,-123,12,-94,-33,49,90,79,-9,-98,58,-74,28,-118,-68,-4,-128,65,-12,-19,-50,-42,-38,-73,122,16,96,79,75,-123,-104,34,-62,93,29,-111,-70,-45,28,117,-121,30,-121,125,-11,106,58,-117,24,68,-65,96,-47,-97,46,-126,60,-109,-115,-77,-87,-26,-77,-120,65,-12,-51,39,-83,109,14,-121,-74,-7,-61,-84,13,-91,31,48,-120,-2,-60,-109,-13,23,-77,-16,-109,-102,-49,2,-62,93,-67,-89,-29,44,126,32,-104,-47,98,63,-87,-17,42,32,16,117,-20,-29,85,119,-93,102,9,-40,79,-22,-47,7,4,-94,62,108,26,77,110,24,-84,117,-3,-92,-44,53,-31,-82,62,108,2,-55,-35,-51,79,9,22,-111,57,5,66,62,98,16,-3,106,51,-87,11,-40,93,123,121,-11,84,1,-60,-112,65,-12,109,-90,110,103,-33,87,125,-125,95,-65,41,-3,-128,65,-12,109,-104,-99,-26,32,57,116,-58,111,106,-24,68,-116,-69,-2,-124,-105,-101,63,-48,29,54,-111,-46,-113,24,68,-33,22,-73,-30,-34,-107,-39,49,83,-71,-78,26,78,-108,-31,102,-92,-30,118,105,-51,-102,-101,103,86,22,78,-60,32,-6,-120,73,-97,-18,90,-52,-100,-77,-97,-92,-68,38,-36,-43,17,98,63,-3,-20,-108,-78,-115,-78,-108,-108,124,-60,32,-6,-59,70,84,113,-98,70,42,-23,88,-22,-63,107,60,-47,-18,71,-50,30,-39,-79,99,-82,-92,21,-100,40,-101,-73,82,-41,114,-33,-122,-103,24,-8,77,-119,7,-116,-101,126,59,-19,109,-41,-18,71,0,34,49,-10,27,-41,15,25,68,127,28,-67,-104,123,-22,-48,19,-101,41,-30,-71,-121,-116,-69,-66,-71,24,-71,37,-105,14,-46,108,-55,-52,77,-72,84,17,-31,-82,-98,97,61,-76,-22,-98,-91,-83,-94,109,-87,16,125,-56,32,-6,-61,-2,-91,37,55,115,52,-71,-75,-96,-31,119,101,-13,83,106,-50,-11,-91,-80,66,19,-35,121,-100,-55,127,114,77,-18,-32,72,-12,93,-41,70,80,-81,-27,-12,-48,122,-104,5,33,86,-67,-112,65,-12,-41,-47,-102,115,88,82,-53,88,-42,-44,56,9,8,119,-11,-122,5,126,-83,-2,-127,-74,-111,32,-42,-44,-112,113,-41,-17,-3,-118,22,57,-16,121,-116,-91,-126,-120,17,-31,-82,62,16,81,104,103,-3,-8,38,-44,75,-107,-16,-69,-78,45,0,115,-12,-6,113,-109,-89,-76,-32,35,-62,77,-35,60,-74,-29,60,-25,-57,-80,-75,-31,117,102,-15,-44,67,-58,93,-33,108,4,23,-71,-65,62,-118,-107,84,86,68,-128,-65,107,-37,60,97,-21,84,-14,-24,117,-12,-87,-68,-125,-112,113,-41,47,-10,-74,123,115,-45,-100,57,114,-46,6,11,-16,68,123,34,-71,-60,13,93,-77,-97,83,21,95,106,-128,-65,107,35,76,-33,-67,-113,-123,-76,-124,-74,84,24,37,100,-36,-11,109,52,101,-97,-3,97,-24,113,-100,-83,41,-3,-120,65,-12,-51,-29,57,-3,-73,1,-80,-46,22,-24,-69,-82,-3,-100,62,-106,-107,64,87,-95,-17,-70,102,123,-89,-20,-45,41,3,93,-123,-66,-21,34,-87,-81,-25,-14,-7,-44,70,81,-97,126,-56,-72,-21,35,-80,91,-102,-101,-98,-5,-108,-41,-83,-48,-9,-100,78,-77,62,124,-38,-86,45,3,34,-101,-109,66,73,-122,43,98,-84,101,-70,-31,63,108,30,-86,69,124,-23,33,-29,-82,95,-52,-96,57,-3,-69,70,-86,77,61,-107,124,64,32,25,-76,102,77,-10,-30,18,98,7,-78,16,84,72,60,34,-36,-43,-31,118,15,111,-116,77,-101,-18,-77,-38,-16,-116,8,36,63,119,-39,87,-22,-14,74,-109,13,-78,85,78,-15,-87,71,-124,-69,-6,-78,57,-90,-71,96,19,-78,-124,-54,84,123,17,17,-31,-98,-25,106,107,-119,27,92,75,126,-108,28,122,87,-52,11,-69,42,-50,47,-56,-74,30,-62,-9,16,-62,17,-29,-82,111,-10,69,26,62,-14,-103,-81,60,35,-107,84,21,50,72,86,-15,48,23,41,-17,-26,30,50,-101,-38,84,-63,-58,-120,112,87,-97,-74,70,-99,110,96,101,-13,20,86,63,-59,-94,22,17,-18,-7,-71,118,87,-43,-116,85,119,-89,-55,60,-43,38,30,125,68,-72,-85,-25,105,-117,-87,-51,-9,14,108,43,75,81,51,76,-56,-72,-21,-61,114,108,-29,3,91,85,-50,-75,-122,-33,-107,71,-71,94,81,-1,0,-117,-111,-82,-31,36,35,26,-58,-53,-16,99,-41,30,96,63,-107,-33,25,50,72,-58,50,94,-74,77,106,-2,17,54,123,-84,42,-71,50,98,-80,-100,107,-20,-80,36,127,-85,-39,44,29,53,-67,-124,12,-94,111,111,-55,59,79,-26,47,-40,0,80,27,-75,17,-127,-27,115,23,51,108,-90,-1,-78,-111,40,-92,-94,22,33,-125,-28,91,-97,55,116,90,54,56,-52,89,80,-7,-42,1,-125,-27,-117,55,-84,-111,-50,96,48,-41,100,13,-75,-88,-122,12,-94,95,-121,-95,125,100,-52,38,20,-67,37,22,50,88,62,-6,121,101,-89,125,-96,-59,119,-91,-31,36,19,61,-75,107,123,-8,-29,62,-53,-87,54,-127,67,6,-47,-81,-26,-62,47,23,-119,79,-85,-102,83,40,-33,108,-60,32,-6,102,-116,-84,-71,-89,-112,-40,56,-77,15,39,-87,-87,56,100,-112,92,-9,-45,-97,123,-54,9,-39,100,-54,79,-41,-16,55,-54,11,121,100,-22,-125,-110,-16,-65,70,-7,-73,-65,-7,-18,-57,47,63,-3,-16,-57,63,-1,-4,-3,15,127,2,-25,15,95,-66,-1,-3,31,126,6,7,-57,-104,-2,-3,-5,-33,-3,-4,-121,-81,-1,113,93,-59,-13,17,-77,14,111,-37,-115,4,-18,62,80,-104,-16,-95,94,42,118,108,69,-7,61,12,-60,115,-106,-80,78,34,2,81,31,72,-88,-34,-80,-89,45,39,117,36,-27,18,107,60,-47,-98,-18,6,-79,37,-104,-70,-38,-35,-106,104,-22,-86,-74,-20,44,-104,-77,99,107,65,-51,113,17,-127,56,-84,-23,-104,-26,-121,-6,-115,-16,110,110,-71,10,-72,-121,12,-94,-113,-51,-46,-28,30,97,77,-10,-95,-86,-96,123,68,32,-22,-19,48,95,-44,-83,-43,-89,-103,-61,125,-87,-83,-108,-112,65,-12,-25,81,-51,-30,112,87,99,-13,100,59,-117,-78,79,98,10,113,-20,-49,-93,-42,61,42,-78,-42,-62,70,-69,-116,0,5,4,-94,110,-45,-108,-71,122,27,120,-106,3,62,-85,18,-105,120,-94,-35,48,98,-9,-19,52,100,-7,117,-101,101,-92,122,-64,-96,33,-113,-75,92,-70,28,-90,-112,62,-44,-10,109,68,32,-22,11,14,-29,110,90,47,27,102,-26,-92,-55,-117,-41,4,18,86,57,-113,57,-35,-79,58,-40,-14,-53,60,38,53,-20,35,6,-47,71,-80,-85,-19,9,38,72,116,111,73,-90,-38,-122,12,-86,63,-78,63,-118,98,118,83,82,-25,78,3,60,-47,70,2,82,-38,-125,-57,19,-82,-16,82,-5,-121,17,-127,-86,-97,59,16,25,-12,-22,64,-113,2,63,-86,34,-38,-80,-70,124,24,28,-4,-88,106,35,-84,-83,86,-27,27,20,-24,103,93,29,112,99,-56,-105,122,-33,-34,-26,-24,110,73,92,124,7,-118,-94,-28,76,-4,66,-49,-90,-68,-77,-18,14,-45,-52,72,-44,-107,81,114,-115,39,-38,-29,-40,-66,-119,-95,-125,-108,20,73,94,68,57,70,-39,67,-36,3,-5,-24,93,-98,125,-114,8,36,86,-101,112,30,108,3,119,-77,-49,-109,-52,83,10,-16,68,-69,30,99,-71,101,11,-73,124,-26,-82,-114,38,-121,12,-94,-17,-84,75,44,5,50,-58,76,-112,47,-11,-66,-3,-112,95,-50,-94,31,-4,-40,28,69,-23,0,-6,-77,-98,-7,13,-53,-59,126,-57,-87,-53,67,8,48,-39,-26,67,86,-33,-36,113,89,-118,114,-20,125,99,-46,94,67,-103,105,15,-106,-116,-45,22,74,-13,-80,-43,-114,106,-60,32,27,-97,48,16,118,91,13,96,-75,-95,42,-64,100,-93,22,-98,-18,30,90,-21,56,-56,111,-18,-82,-54,-91,8,8,100,-109,57,31,-53,-99,-49,-67,-64,106,-125,-103,-125,-55,-42,-72,-83,125,109,-98,-27,-99,-84,66,-45,-124,1,91,-70,-25,59,89,1,-90,105,19,-93,-42,-11,78,85,-128,73,-102,71,53,63,99,-66,-68,86,1,38,-87,47,-88,100,-111,-10,-51,-20,104,-112,41,52,77,-39,73,117,-20,27,-39,64,-82,-47,84,49,-122,-112,65,83,-102,-46,-84,-55,93,-119,-52,54,-112,104,-102,64,-42,115,-14,87,33,103,10,-119,-90,9,123,-26,-59,-11,-105,-70,10,77,19,25,103,25,-21,-99,-84,0,19,-43,114,-28,-22,-50,26,-123,-78,2,77,-110,94,113,62,-86,-44,119,-13,-80,68,-45,100,-38,-13,108,43,-65,-44,21,104,-98,96,60,78,-65,22,-32,60,-71,-54,-36,-118,8,52,57,-70,-44,-34,-25,-69,49,-84,-48,52,-87,-37,-2,-65,39,-18,-124,-70,2,77,116,109,94,-19,103,122,41,-53,-63,119,85,28,117,79,-18,-88,123,36,-85,-48,68,-41,70,101,-21,31,111,-94,-90,-87,98,117,17,-31,-82,94,80,-4,102,-83,-10,106,-34,-108,104,-94,123,-91,73,-89,119,-117,-66,68,19,93,108,-125,-72,111,20,43,66,-54,77,-97,-97,9,24,119,125,88,-18,-93,54,15,86,-105,45,-64,68,53,97,-62,-22,-17,-52,9,-119,-66,-21,98,23,116,-74,61,113,46,-46,85,104,-94,91,81,-79,-88,-65,124,12,10,77,116,113,110,97,-66,-77,40,20,-8,-82,-118,-125,-127,-3,28,-18,-66,80,-99,-24,84,97,-90,-112,65,-12,-19,-125,-78,-49,-57,-95,-91,-73,47,-47,68,-41,62,-53,-18,66,46,-95,-82,64,-33,116,11,114,43,-22,24,-27,-107,-82,68,19,-35,-124,99,20,-34,114,12,116,5,-6,-82,-117,-29,-65,-87,-28,-105,-41,-85,-48,68,-41,-52,114,-101,-69,95,94,-81,66,19,93,-101,-102,-118,59,-41,29,-22,10,-12,93,-9,126,52,35,-46,85,104,-94,91,81,47,106,-67,-43,21,-24,-69,110,-57,52,58,-5,-69,-39,71,-94,-119,-18,85,-5,43,-65,115,17,36,-102,-24,-98,54,79,-91,119,-109,-80,2,-33,85,-111,102,-35,-13,89,-33,-55,42,-12,93,23,105,-2,-23,-99,40,-123,18,-59,108,-13,127,-54,-17,-68,79,-119,-66,-21,-106,126,-84,62,63,29,107,33,43,-64,68,53,-101,31,-43,-49,-113,24,-125,-108,21,-24,-69,46,22,109,51,-67,94,-22,42,52,-47,-51,-26,67,-83,-73,-78,28,124,87,69,70,-49,121,-106,119,126,-83,68,19,93,100,104,-76,85,94,-22,10,52,-47,53,107,43,-73,-13,-99,-35,39,-47,119,93,91,-79,-111,-55,-16,-50,78,-107,104,-94,107,-74,86,46,-97,17,-122,60,-86,-38,122,12,25,55,-3,108,102,69,111,-93,127,-52,-90,51,-53,26,66,33,-125,-24,-29,68,-36,56,-33,-39,16,18,77,116,-19,113,-43,-103,-33,-83,-99,18,125,-41,-99,3,-90,119,113,-33,-65,76,103,-112,104,-94,-37,-16,-58,-53,75,89,14,38,-86,-120,-20,15,111,39,54,-4,-92,10,-64,5,4,-94,-114,35,18,117,13,15,-106,23,45,-48,68,23,-59,45,-69,-65,-120,-86,117,5,-6,-82,59,-112,2,-21,10,29,68,-70,10,77,116,-25,-47,94,106,18,36,-67,-1,-13,-11,-67,-33,-112,68,47,121,84,-16,-114,8,-14,-91,-34,55,-33,-10,-56,126,67,113,36,58,1,82,-108,-72,-71,55,122,-91,-103,-39,63,-89,51,31,-37,56,80,-34,74,21,4,-118,24,-60,-120,-21,-57,-84,117,-49,16,-24,-56,-78,47,-22,-64,115,68,-96,46,67,62,93,-31,-65,94,-81,18,48,85,-43,-20,-119,24,-44,53,-101,109,-81,35,-42,11,-10,59,84,-62,66,-128,-89,110,-16,104,-55,57,26,-56,-71,-55,85,-98,120,-114,24,-60,121,-97,71,-83,-69,109,-47,115,67,6,-71,-84,64,17,16,104,96,39,-73,-68,-97,116,-67,14,121,21,-107,-45,23,17,72,16,45,33,93,-36,109,-47,-40,-43,-55,68,-114,0,79,-61,-119,54,115,-44,-3,41,38,20,-118,-107,-121,-87,3,2,9,-35,34,-99,103,-19,38,82,-73,47,111,-75,33,43,91,68,12,18,34,71,85,-16,61,14,105,70,-12,-127,-86,101,42,72,46,-15,116,19,-62,108,114,-25,82,-97,25,-121,-93,-125,67,-20,-118,64,-74,102,58,106,-79,-20,-127,-67,6,-37,41,-73,33,79,107,7,12,-78,-91,-76,-114,-71,-54,-18,96,-73,-85,-56,70,83,105,-31,33,-125,108,-81,97,63,114,-33,-23,108,48,119,-32,22,-88,45,54,77,32,91,-126,102,-109,-70,42,-102,-51,-106,-99,38,-85,-47,4,120,-78,57,90,-113,92,-5,-2,101,-37,19,60,-38,-54,-30,91,-115,8,100,-69,24,-7,-41,101,-49,115,106,54,-92,87,-110,-121,-28,3,2,-39,-20,-58,-111,-9,-3,-44,-34,117,-6,88,-107,-5,-48,112,-70,53,95,115,-38,55,32,-16,80,87,85,25,87,26,127,-41,-74,-103,109,-73,87,-101,-51,79,-71,-54,-94,-31,26,126,87,46,19,57,-42,-69,-119,-115,-83,-36,118,-86,-93,27,17,-127,-92,-43,-30,120,-99,-1,34,108,13,40,85,102,-48,5,4,-110,-7,-125,8,113,115,-61,42,-39,-110,38,115,118,53,-98,100,1,97,86,-53,123,-105,7,-20,-20,-98,-71,-24,-116,-76,-128,113,-45,-57,110,-49,90,123,-116,-65,34,14,114,38,85,88,37,34,-36,-43,81,23,-81,-19,105,-6,-104,90,109,98,85,-71,-123,17,-31,-82,94,-78,-71,123,125,-33,-122,-82,-26,-8,-44,-47,-107,17,22,50,-18,-6,-75,-93,110,-21,126,-85,-88,44,-43,78,117,114,32,34,-36,-43,-37,-107,-11,-79,99,17,-87,-98,-86,-22,110,-128,-65,107,15,-100,97,-36,-29,14,40,-90,116,-43,-55,18,-30,1,-31,-82,62,81,-83,-65,-18,37,47,-80,-101,122,-10,-91,-10,2,67,-58,77,127,34,97,-24,28,-5,-83,86,88,-120,89,29,-99,-117,8,119,-11,124,-99,112,-36,-84,30,108,39,-82,-108,-121,58,85,24,16,-18,-22,37,-95,-86,-53,-66,-128,85,76,75,65,23,23,77,-72,-85,87,51,-39,92,-23,-55,-102,-5,-47,-58,84,-106,76,68,-72,-85,-93,-92,-19,-114,-108,-37,-58,20,121,-41,-21,102,51,21,119,102,26,123,116,56,-65,-85,78,-97,70,-116,-69,-66,-83,-35,-53,127,-52,95,-21,-120,-118,-81,63,-64,-33,-75,-51,-53,-84,115,-113,58,87,-100,47,106,115,-86,75,15,8,119,-11,-43,-113,-30,-30,-82,40,-118,-70,-70,74,7,14,-16,55,-19,117,-35,83,-35,-109,104,-54,58,-113,-42,74,22,3,60,100,-36,-11,51,-22,-85,-18,-103,8,5,-23,53,-93,-87,2,-122,17,-31,-82,94,-36,-63,-23,-126,84,89,33,-53,-112,119,-67,106,30,77,-18,-5,31,31,-10,57,-73,44,31,70,64,-72,-85,35,64,-80,118,-45,-87,116,100,-75,-87,-62,-67,1,-2,-82,13,43,97,-12,125,-93,10,-69,54,73,62,102,-115,-65,107,99,-80,-38,123,-39,108,-124,-126,19,123,93,-91,-27,71,-124,-69,58,-10,-80,-57,30,33,44,-59,126,73,-54,-1,15,-16,55,-19,116,-98,46,86,-122,125,28,117,-126,-110,66,-33,42,126,-13,56,-40,-102,-51,-113,87,26,-28,-93,40,-15,74,-34,-24,37,-77,61,-48,-49,101,-1,-74,97,99,-23,19,-47,18,127,-41,-74,-1,29,-71,-20,-101,-109,-27,-60,110,-35,-87,-30,72,33,-125,-24,-37,48,-56,-82,-78,68,94,25,-47,15,-39,113,38,98,16,-3,-66,14,91,103,119,52,42,-5,-99,-78,-59,82,64,-72,-85,103,88,9,-25,-98,-48,-112,-111,-23,111,115,-71,60,-43,26,48,-120,-66,63,100,-103,-69,28,42,28,-6,86,-15,-37,127,9,-59,-99,-43,40,124,-45,-125,-94,-60,74,-16,70,47,-99,-24,-92,-44,-10,40,-93,45,-87,54,101,-86,82,-42,17,-127,-116,37,20,81,116,101,-32,-14,-102,-8,69,-66,-19,-120,65,-12,97,66,-73,61,13,-55,-20,79,27,122,-78,14,122,-56,32,-17,-66,-94,-28,-42,94,-114,39,-93,20,72,46,-86,24,91,-56,32,-6,-21,42,-35,-65,25,95,57,35,93,96,-86,-28,-88,-112,113,-41,-1,56,47,-99,-51,-90,89,51,-87,-78,-63,26,-2,-88,-100,-52,-14,-102,-83,-86,-26,34,26,-2,74,89,125,-63,20,-6,86,-15,-101,127,-63,-77,-71,-114,-93,-88,-102,-50,-20,127,-122,18,-2,-60,27,61,-77,119,-113,53,-10,-116,-46,82,-41,49,86,-105,85,79,2,2,-103,31,16,-83,90,123,-36,-92,-92,98,30,-74,-102,29,20,-100,40,-81,114,-75,12,-40,-105,13,91,-11,90,86,-123,-107,67,6,-103,27,-52,-12,91,110,-47,-77,-25,89,106,82,101,26,35,2,-7,114,-51,34,24,-50,-77,73,-40,14,-22,75,-75,-42,8,25,108,102,24,-104,-89,118,52,-54,-114,-43,-92,28,-14,-112,-15,87,-22,127,-5,-59,109,-7,10,100,-104,-77,104,45,28,6,-109,-26,-15,11,-59,116,-94,66,-1,30,-90,-72,-84,-95,-13,76,-86,-99,102,64,96,-22,19,-59,-50,92,-91,-84,52,-51,85,82,-59,-104,66,6,-47,-57,-71,127,87,-20,-28,-54,22,87,-66,124,-128,103,-38,3,13,34,124,-111,4,-92,89,-86,-93,-108,33,-125,-23,47,95,-33,1,49,-106,-90,-10,79,52,-100,40,-73,-45,67,81,-120,-73,-85,-118,-23,26,-50,-108,-35,-18,-1,-102,-104,24,-89,10,64,104,-8,-77,-14,-64,110,-88,-38,37,-108,104,-82,107,127,119,63,-44,-114,114,32,102,-109,-21,-14,72,-102,-63,-12,93,64,1,-99,-75,70,82,-47,88,-119,126,-42,-51,104,-117,-89,-10,-65,36,-6,89,55,-95,43,-127,30,-47,2,-51,117,-5,-38,-109,-77,-90,-39,-91,99,-10,20,105,43,6,-45,119,-117,-3,-76,-59,34,55,-75,101,39,-47,76,-73,-38,-102,-71,55,74,-99,-88,-118,59,-106,-54,-103,8,25,76,-65,125,-108,-100,-104,56,116,94,-75,-69,24,49,-104,-66,-77,-35,-20,-23,-95,-92,-81,30,127,28,-51,116,-35,-6,1,91,107,101,89,-6,66,-61,-103,-78,-39,-29,123,6,-30,-76,105,115,86,-23,-99,107,60,-41,-34,47,3,-3,-28,-109,-38,30,-107,104,-2,52,-26,116,-11,37,-52,-21,30,67,5,-89,34,2,127,-121,109,71,74,-89,-107,67,-97,-33,30,-94,83,-89,106,90,41,-47,47,116,-53,97,-122,-123,-2,10,57,-6,-123,46,-114,-21,-55,2,55,26,-50,71,68,113,-2,-26,-52,104,-76,-86,54,-99,34,2,-117,14,20,84,44,75,59,88,23,103,83,104,-90,-69,-82,26,12,59,114,33,127,66,62,106,77,32,-22,-41,17,-44,-3,112,11,-64,-26,57,-88,109,-118,-112,-63,60,23,91,-99,93,55,47,-20,87,-99,118,-5,82,63,96,16,-49,5,109,-119,-85,-1,-72,114,-48,16,55,34,-80,-104,12,10,-12,102,7,54,-109,87,-123,-2,3,60,-117,77,94,-83,104,28,86,-6,-73,18,77,116,-51,-124,-53,99,-113,-38,-124,-70,2,-51,98,-99,88,-16,-9,-93,-115,-8,-120,-25,-46,-47,-56,-120,-63,99,-87,-61,69,-77,-16,98,106,85,-115,-36,34,2,-13,112,109,-102,-88,-51,79,20,107,-55,54,113,17,-127,-59,-42,-48,127,115,124,-96,117,97,70,-114,102,-70,56,99,-4,121,21,90,-105,-93,-119,46,90,31,-113,-39,-4,55,-122,-126,-24,74,90,19,-120,-65,124,94,53,81,63,-66,-80,83,7,50,3,2,81,79,13,121,-34,-53,127,99,-24,37,-89,-44,53,-127,-88,-29,-100,-52,-71,-5,-123,88,2,91,75,-86,-93,110,-56,-32,49,-3,51,-19,7,12,96,12,-100,-89,-116,51,6,4,22,-125,-99,48,91,-10,-71,-77,-62,-87,-19,58,-46,18,48,88,124,-1,58,-64,-79,-65,41,84,53,43,89,22,-104,-115,24,68,-1,-22,-87,-75,111,-113,-52,-118,-42,-116,42,-11,44,34,16,-11,97,-42,-6,126,98,11,88,-71,-29,-63,-63,44,-70,-107,-20,109,-69,5,37,-110,21,104,-90,-21,-50,8,-60,-94,4,-54,35,-24,-26,59,124,-68,-21,-75,84,102,73,68,96,-111,99,-76,-12,-40,75,100,-32,77,7,1,-104,-128,-16,24,-105,-58,45,118,109,114,43,-12,11,-35,101,75,-106,-66,98,10,126,86,69,-28,-89,39,105,-61,74,-8,11,101,-67,-76,83,-24,91,-59,111,30,-42,-68,90,-17,-71,-48,82,19,-5,-51,20,-89,108,-59,95,-92,-7,-19,111,50,125,-108,-19,-65,-30,105,116,-29,-101,-31,-44,-106,-9,47,-46,-4,53,110,-46,23,-25,69,-109,88,126,65,12,-89,110,-14,23,105,-2,10,55,-103,-57,-57,31,-30,-109,42,-57,41,-9,-32,23,105,-2,29,110,-78,-67,-68,-96,-10,87,-36,-28,95,-89,-7,-9,24,-82,-22,-5,97,-72,-73,-61,-11,-81,-46,-4,21,110,-78,124,124,-4,69,124,63,20,-89,124,-50,95,-92,-7,107,12,-41,-6,-15,-121,120,-56,-117,-29,116,18,-59,47,-48,-4,53,-122,-21,-25,31,82,51,33,-61,-87,-31,-6,-117,52,127,-115,-101,-4,-40,-63,-86,52,1,88,-32,-44,77,-2,34,-51,95,99,-72,-90,-105,51,33,-61,5,17,-90,-65,93,-13,-41,-72,-55,-113,29,67,-34,52,80,-32,-44,77,-2,34,-51,-65,-61,-60,83,95,78,18,-11,-81,-104,120,-2,58,-51,95,-29,-101,-4,24,50,-68,-66,-77,-64,-23,116,-51,95,-96,-7,107,-36,-28,-57,-112,41,106,-110,96,56,117,-109,-65,72,-13,-17,96,-15,36,-11,-44,25,-18,-91,-59,-13,-41,105,-2,26,-2,-28,103,18,-124,-40,63,-95,56,-27,79,-2,34,-51,-65,-61,55,41,82,-48,57,-18,-27,55,-7,-41,105,-2,61,44,30,49,19,82,-36,91,-117,-25,-81,-46,-4,-10,55,-103,63,18,43,79,17,-114,-31,56,21,55,-1,69,-102,118,-109,-1,-10,-29,15,-1,-10,-27,-57,-97,-65,-1,-14,19,8,63,-3,-4,-29,15,-1,-25,-53,-1,-2,122,115,-11,-38,16,-1,-14,-29,-65,-2,-12,-27,127,-3,-16,59,-93,-3,-4,-29,-97,-65,-4,-25,-73,127,-7,-21,115,-66,16,47,-118,-30,-12,110,-59,27,77,116,124,-102,-89,107,-82,118,-82,113,-116,37,115,115,35,6,-69,102,28,-13,115,-67,79,-49,-123,-13,59,-14,120,-128,38,48,117,28,-23,-10,-23,119,25,-83,103,-43,-58,112,64,96,-22,40,-9,-41,92,-37,76,-108,60,-53,-22,92,111,-56,96,91,91,21,-39,-81,-18,98,16,-53,57,117,-77,-76,-128,-63,54,-4,38,-114,-118,-5,-106,-16,-25,-47,79,-103,20,26,49,-8,118,-91,111,31,-36,-6,81,-122,-36,38,-46,120,-66,-123,59,122,113,-55,-119,-35,-48,83,95,123,-64,32,-6,-26,-15,-116,-113,-50,112,-40,76,-107,53,74,66,6,11,8,-40,64,115,7,-56,-19,-31,98,71,79,-90,-121,68,12,102,18,-93,17,-6,-98,-126,112,53,-69,-43,-106,-74,-128,-77,-27,96,30,-87,-72,-26,-91,72,117,-98,77,-90,81,69,12,-79,-90,-74,-113,-74,-42,-21,-48,121,-92,1,-127,37,67,20,-28,-6,-115,-113,81,-80,116,18,98,-60,96,102,-49,-64,-79,75,63,10,-54,-11,-109,52,-88,52,-125,-89,-71,-41,-20,-47,109,93,63,5,105,-18,-118,65,-12,-47,-95,112,-6,126,-24,56,-79,52,84,25,-76,-112,-63,-12,-5,-47,-50,-43,62,102,-112,83,-25,-47,71,12,-90,-113,124,-21,-26,103,-64,118,116,-43,-79,40,34,48,117,-12,82,27,-18,90,42,122,28,-23,108,-31,-128,-63,-11,79,7,69,49,31,-103,-22,39,-48,76,23,91,-86,126,-43,44,-21,-6,73,106,107,6,-41,119,87,82,102,-48,-123,87,-61,-103,-14,-7,1,13,-78,-3,40,-106,105,-26,-85,-19,-51,-57,-93,59,101,93,-15,-112,33,-58,-32,89,-6,-25,59,63,85,37,-108,-112,-63,19,-58,-14,116,77,-116,83,69,-59,1,-99,60,28,48,-40,28,-103,-82,60,107,-9,-59,37,52,9,-106,105,76,1,-125,-5,-65,107,14,103,5,-75,113,44,-99,-61,16,49,-40,-38,106,127,122,-98,-11,99,70,45,-85,-87,73,32,98,48,-37,96,30,-82,-24,-73,-127,-81,-29,-69,114,-123,-46,4,102,53,-43,-61,22,118,55,-42,58,18,92,-76,101,19,48,-104,-43,-41,-113,58,-54,-4,-72,-102,-82,-70,0,70,4,102,-77,-30,77,37,127,45,21,-91,-38,-28,-40,9,24,-52,-26,46,40,-115,-18,86,99,91,-51,102,81,-3,-117,66,6,-13,119,96,-50,-70,123,69,-30,-3,-112,-7,-25,1,-127,123,-103,-91,118,-73,86,86,-44,-32,86,5,19,67,6,75,-4,-62,9,9,119,12,-53,-26,85,-44,-26,-108,-119,95,-110,-64,-45,-54,-50,-106,-36,87,-110,19,-102,-118,-87,-127,31,49,88,98,25,-54,-109,58,15,0,81,-92,44,77,-125,-128,-64,-44,11,-70,70,-17,111,-22,58,-121,95,101,-113,-30,-120,-63,-12,63,-62,36,-93,-39,114,-87,-75,57,-6,-123,46,-46,-94,79,121,34,76,-62,-59,-13,94,-89,123,124,-104,-75,123,-8,-68,57,-127,-115,-106,-127,100,80,-41,23,22,-25,-55,100,111,-32,-112,-63,71,99,118,-103,87,87,-8,13,117,-52,-125,-47,-88,24,-20,91,93,104,-126,-29,110,-42,-106,-119,82,-11,-89,42,9,76,-67,-95,101,-62,39,56,79,-103,89,21,49,120,-36,-90,125,52,-51,69,74,103,-110,39,21,35,6,-101,-121,81,-16,-45,55,21,-66,-118,-27,-55,37,86,19,120,36,107,77,127,-81,40,-51,85,85,-19,-108,-112,-63,-29,66,61,-7,-93,-121,-41,-71,125,57,23,68,12,-74,10,46,84,-105,114,-24,117,-94,53,-69,94,5,53,-125,-81,-78,-87,59,115,-24,68,-94,-99,94,-61,53,-127,39,-126,-73,-31,61,58,28,-97,44,-46,-53,-119,24,44,118,-125,-10,-48,31,30,99,-58,97,23,-87,31,48,-72,125,102,111,-57,-83,58,-19,106,-3,27,25,104,-118,-63,-20,75,124,-119,-43,91,-117,-63,-34,-105,-126,-13,-19,-81,-39,61,-76,-95,-66,99,16,-4,-48,12,102,-39,35,-68,-23,35,49,104,17,-72,-110,-116,58,5,-116,-25,77,31,-28,17,-116,46,15,16,72,56,-69,114,-13,109,123,-1,24,-64,73,118,34,-114,8,34,42,-44,63,-114,58,-93,62,-83,-2,-96,2,6,-49,59,92,107,-71,-113,-69,30,-93,-55,85,60,32,-16,108,-115,114,118,111,6,-95,-104,-103,60,127,24,49,68,44,113,120,43,-50,-98,110,-22,-70,44,74,-64,-32,-33,83,42,110,-27,49,67,-21,-6,41,-8,-92,20,-125,-51,55,104,97,-102,-67,21,58,-82,-97,-28,124,-93,25,124,-66,-100,-50,3,64,32,70,-69,83,28,45,-42,88,-41,-31,-29,-118,-108,-52,-91,107,78,4,12,102,35,76,91,2,-86,-13,-68,112,60,40,-53,72,110,-60,96,-10,101,63,-122,-113,41,-89,106,78,-69,-100,-52,2,2,59,38,-110,-113,-30,122,-34,-38,24,48,-81,58,48,-115,3,6,-45,-57,24,110,126,31,-53,-26,43,89,88,49,100,48,-3,-118,-45,83,-29,-29,27,92,67,-105,-28,8,24,-20,-23,-37,-128,45,62,110,-115,48,77,-47,79,95,18,-72,5,101,19,-108,95,-15,-25,-47,100,31,-31,-112,-63,-93,32,-93,-100,126,-35,1,90,-58,-95,35,6,-101,19,-20,-50,106,113,35,57,-54,41,83,112,54,-101,-103,7,-102,-46,-25,-118,108,107,-88,-36,97,8,24,108,54,-98,56,117,-29,103,-112,-123,69,90,78,-58,-110,-64,-13,-59,-58,-71,62,119,16,-15,83,-112,-119,-90,24,108,-83,50,-121,107,125,4,28,38,-86,29,-21,-35,35,-51,-32,-79,-59,-76,-122,27,101,56,-83,-103,100,-127,-126,-120,33,-110,6,-3,6,110,-58,39,40,43,120,5,4,54,118,78,115,-24,92,-60,1,-71,109,77,86,-78,8,8,-52,46,54,-61,-51,21,56,-1,-102,57,39,-115,98,1,103,95,19,-114,-80,-43,-10,86,89,-63,-39,-38,-38,-48,67,-84,-65,85,86,112,54,-125,97,53,-104,-21,-83,-78,-126,-13,40,95,47,110,-98,-66,-94,94,85,-58,-49,35,6,-117,124,-104,33,-21,110,49,77,20,-86,-107,-21,-110,-60,-77,85,99,29,-18,-67,-92,-32,76,29,-59,-78,-107,110,30,31,53,-118,-52,-85,-24,93,-18,15,5,4,-94,94,-37,-111,-105,-101,-102,97,43,-97,-6,124,123,-60,96,-6,-53,-26,31,-73,44,98,-93,-55,62,49,-7,54,3,6,-47,-73,-87,-34,53,-72,-66,114,-113,86,-110,-95,-126,-128,-64,-44,43,106,-48,-72,107,105,104,81,46,-89,-108,-120,-63,-11,-41,108,-18,89,-102,25,52,-69,76,-32,-119,24,76,31,69,-38,-4,-69,-54,-59,12,-24,-91,31,127,68,-31,-49,31,65,-82,29,-114,30,42,-78,-48,122,-56,-32,-29,-89,-20,-53,-41,66,-120,58,-53,124,3,-115,-25,99,127,-84,-35,30,95,104,19,-110,-122,114,-25,3,2,83,63,-51,75,-36,119,-11,-42,64,-91,36,29,66,-44,4,97,-1,-106,61,-97,-59,86,-12,-61,6,-122,-98,21,36,-127,-5,30,-89,43,-63,-79,80,-66,38,79,-71,73,23,49,120,116,-5,-12,15,18,-59,-97,122,-42,-29,62,96,112,-33,108,-44,125,95,105,-103,49,91,-122,-34,67,-114,24,76,31,-123,39,-10,-8,-56,66,57,-1,44,-73,-112,3,2,95,91,109,-70,-34,7,2,-26,92,-19,-38,4,4,22,-3,44,-26,20,-50,-22,47,37,77,29,-60,-46,4,102,113,-40,-4,84,-9,-7,105,-43,-85,118,-74,78,-118,-109,4,-26,-41,-96,56,-102,-5,-68,-47,8,-90,-53,-125,-49,1,-127,71,58,102,-33,43,-120,47,-101,109,75,109,-78,-14,67,-60,96,22,36,58,-110,-7,79,-48,62,-7,-96,-72,65,-60,96,-10,111,-71,-46,-62,118,-12,-64,-10,-86,-82,69,45,9,-52,118,-81,87,-93,-112,125,122,66,-109,-52,37,-65,-87,-120,-63,51,-29,-70,-53,-66,92,-24,-96,-43,-12,-98,-120,38,112,-49,102,-70,54,101,107,-90,-61,124,71,-23,16,107,2,-113,80,-38,88,-37,-17,20,57,41,83,22,-35,8,8,60,-89,111,-70,16,-8,-102,-15,-119,24,-122,22,-34,-92,43,-97,-125,-118,-19,85,111,-23,6,4,-98,3,-38,-54,94,51,31,-11,-1,-37,-112,101,-91,2,2,-101,9,-52,-116,-21,-3,99,57,43,93,39,-128,106,2,-49,29,54,-57,127,127,-122,29,-83,108,-122,-114,9,7,12,-31,-29,100,55,-72,-126,45,16,-123,102,54,71,-126,39,-108,118,100,63,-38,-110,-13,99,64,96,-74,-98,-127,-9,-96,61,-34,-49,-118,108,85,-123,103,-38,8,16,87,7,-18,-24,22,33,-13,-9,34,6,-45,-73,-87,-95,14,63,87,-104,27,19,-104,-87,-110,64,-44,-69,-53,-99,91,-13,-22,77,34,31,-70,64,-65,-48,-59,-13,107,58,6,-87,-32,47,-108,-111,104,-71,-92,-31,43,-48,47,116,-81,2,-66,-81,47,-8,47,104,-10,-2,-52,-87,117,125,-86,49,-11,-104,-117,47,-61,-67,-102,-64,-44,-37,-47,-35,-2,58,46,-91,100,-71,-59,17,16,-40,87,-119,-104,-110,91,-89,-52,-62,-55,-127,7,-84,-16,-36,15,-88,46,66,102,-82,-26,-111,70,48,-80,3,6,-13,4,-48,-4,41,57,19,97,-38,75,26,50,-105,32,98,-16,92,-123,-98,-68,-123,19,-123,-111,56,-102,-51,-32,-74,-64,58,63,28,-56,-34,116,-33,15,77,96,-85,-113,77,14,99,-49,8,-128,-31,84,117,13,-81,-128,-64,119,-8,-19,13,-71,-103,45,-61,121,-45,-122,92,-64,96,-6,-27,-56,109,111,119,116,-39,101,-78,-124,-105,-58,-77,85,127,-103,-39,-12,57,120,83,-47,-27,24,35,6,-45,-17,-97,51,70,77,58,28,32,-31,60,-17,-31,3,-86,99,-69,4,-6,86,-15,-73,-1,16,-121,-30,-50,-113,-13,-91,-89,-72,5,-118,83,-101,-6,-65,72,-13,31,-30,-71,92,-87,-22,123,-16,-120,-57,100,41,44,72,126,-1,91,21,-1,49,-98,73,-5,56,-90,-117,-20,104,118,11,20,39,-98,-54,47,-45,-4,-57,120,46,-13,-77,-120,82,22,-81,-106,-31,-44,104,-7,69,-102,-1,16,-49,5,81,5,-105,-105,52,-59,-15,111,-118,-45,-111,-118,55,-102,-120,-27,-73,-23,54,12,17,-39,-85,-26,91,-86,39,30,48,-72,-2,126,29,25,126,124,-45,-123,-110,57,-102,-23,-82,99,-71,19,32,102,-18,29,-85,-87,-82,-103,17,-127,-115,22,-44,8,118,-87,21,87,50,-78,-34,25,-115,24,44,113,109,-104,101,-19,-70,-87,100,-35,-102,83,-61,-7,-106,-18,-14,91,123,-120,4,119,-39,38,54,100,-80,37,26,103,-85,-69,127,-114,21,-37,41,50,114,19,48,88,56,116,-38,27,119,7,16,50,-110,102,-70,78,-42,12,24,-52,124,-74,-105,-110,-105,-69,-37,19,61,126,-76,126,-64,96,-127,-6,-118,-38,-6,110,51,17,-87,116,67,-69,23,1,-125,-89,-39,-84,-20,-113,14,-39,5,-106,-90,93,-47,-128,-63,-36,35,52,-102,-49,-18,106,38,-30,6,-46,-108,-114,24,60,36,114,46,-97,124,114,-99,-56,-111,-43,-51,35,6,115,-89,-45,97,-81,63,127,76,125,-75,-87,-2,-99,33,-125,-24,-113,19,-57,79,-3,-43,76,27,-32,50,31,38,98,48,-3,113,-59,54,-36,-37,74,71,-49,-70,-38,113,-64,32,-6,87,-97,86,-97,89,100,62,98,-42,7,-114,52,-127,-87,79,-65,-22,44,116,116,-41,117,-96,21,-4,89,-7,58,7,-43,116,48,67,-63,-33,40,7,-127,69,-118,125,-83,-7,15,97,109,92,-91,55,-36,74,34,44,73,-118,19,11,-44,91,77,-28,15,-70,2,-61,87,64,53,104,-49,25,49,120,66,-5,112,-19,-96,-65,110,18,-21,-39,49,98,-80,45,-99,-126,-98,103,123,-2,83,46,-61,-82,-90,-21,-44,100,-51,-32,-85,107,105,-18,-124,25,30,101,49,3,43,88,93,21,-125,39,78,-83,117,122,43,-91,30,-19,-44,71,45,2,6,15,-13,-12,-20,-105,122,116,13,-110,-3,56,3,2,91,-69,11,-54,44,-8,-107,-66,35,62,33,-105,110,73,-32,91,-32,-25,114,-119,-123,-104,53,-122,-18,-52,18,49,-40,-54,93,-114,-34,-3,17,-9,-123,117,70,90,-61,17,-125,-81,-36,-87,-6,36,-11,-123,-108,58,-83,31,48,68,106,-49,-12,-21,-52,-76,-73,23,36,38,5,12,-74,114,-37,-28,95,-110,75,-68,-124,29,49,-28,-40,-113,24,68,-33,22,-59,-106,125,65,22,-124,-96,-101,-50,11,11,24,119,125,20,79,-97,37,127,-94,117,45,112,1,103,-54,-3,-61,-105,-117,100,25,-10,-99,-26,74,-14,-24,-116,-124,-65,81,70,18,-1,123,-31,-81,-24,23,-70,-56,-31,104,50,-86,46,-31,111,-108,-25,-111,-11,89,90,9,127,86,-58,-95,-54,-73,111,-18,43,-10,-75,-26,111,-65,125,115,-13,-4,-79,-90,-117,-18,-26,12,70,111,-15,-91,-30,21,-125,-50,62,-27,16,83,85,45,58,47,57,96,-80,-103,-34,-26,-43,-103,28,-70,54,-100,100,-47,-39,72,-102,-63,125,-100,-38,-110,91,-13,-85,14,-43,72,56,-101,-61,78,12,-75,-4,113,29,41,56,-60,17,48,94,-116,45,-100,122,-100,50,23,95,-62,-33,40,-65,-97,-61,-78,-24,33,32,52,-65,-7,-105,-112,-50,-13,-45,-100,23,-107,94,40,78,24,-74,111,53,-53,105,-29,108,-33,-75,79,-25,68,-105,110,25,67,-45,4,-94,110,-74,110,31,-82,-54,-41,-119,-100,-51,44,13,-26,-120,-63,-12,-51,85,-4,56,103,-100,108,9,29,-70,45,93,-64,96,-6,-27,88,-43,37,-14,33,73,101,76,89,-34,73,19,-104,122,62,-22,116,-55,112,-51,124,-125,85,-11,-59,75,2,-65,-10,-78,31,-98,91,102,-72,-61,-41,-111,-66,-112,38,48,117,87,-104,97,-27,96,40,50,-24,91,-59,111,-2,-75,117,-65,-125,49,120,-63,87,-118,-94,-73,-9,78,111,-64,99,45,123,81,-101,81,-28,-82,-125,2,-33,85,-53,85,43,-14,-99,40,-57,-34,53,-111,-48,-40,-22,-18,52,1,-71,-50,33,12,-106,-120,112,87,31,56,19,-39,-35,101,92,7,-94,84,65,-99,-120,112,87,71,-10,91,-9,15,14,91,7,-14,-46,53,-2,-82,-115,-114,50,59,-78,-90,67,30,45,85,-32,-101,-22,-52,-10,-16,-20,-2,-54,-114,-83,-10,-111,119,97,-117,68,-124,-69,58,-118,-33,-72,-98,86,-93,74,11,81,-127,-17,-86,-8,123,-23,28,47,101,21,-6,-82,-37,63,-26,-97,-95,-37,-57,8,-20,93,19,-107,25,71,73,-18,-81,103,-116,87,-15,-26,34,-62,93,125,-102,-11,-109,-50,-75,99,113,78,95,-10,-77,-115,8,119,117,-108,82,92,-61,-115,-50,-21,124,-81,-118,-11,71,-124,-69,97,-99,10,50,13,-5,14,-106,47,81,-127,-17,-86,25,89,59,101,119,106,35,89,-123,-66,-21,-38,-115,100,-105,68,27,-55,10,-16,93,-43,6,-30,106,-75,-8,-55,69,-87,10,-16,93,21,-71,104,-71,-52,-22,-111,-70,96,71,68,-72,-85,-29,-108,-56,-38,35,126,67,23,17,84,-32,-69,42,-86,-94,-83,-49,105,54,39,85,-61,46,-64,-33,-75,23,-46,101,-13,122,-9,-108,5,-104,89,-61,-88,37,54,-45,-57,83,59,117,-1,-48,-120,-63,2,-44,-72,-59,-76,-22,-85,39,-83,-31,68,57,-29,64,69,46,47,-123,5,-102,91,-37,107,-20,103,-46,113,123,-67,-56,2,-50,1,-127,-91,126,-40,-8,47,115,-6,-81,42,-97,93,30,22,-114,24,108,83,124,93,-55,-90,59,-70,-96,90,-100,46,-91,42,9,60,-55,105,-10,-23,-79,81,-26,20,1,-13,-19,-16,108,-106,-43,75,89,-127,-26,25,-127,-91,-27,-113,91,91,93,-97,9,-46,4,-106,-117,-103,80,-16,-9,-29,-29,-19,109,-54,51,-73,17,-125,-121,-94,-111,-44,-25,-105,-48,-92,7,74,64,-32,-103,-29,57,-17,-89,88,6,-74,-74,74,-108,-9,-82,25,124,11,-13,-20,-5,49,-106,-127,35,-86,85,-25,30,107,-126,8,-29,-70,92,-117,-127,-14,-62,-10,83,20,-56,-27,-124,-57,-112,-59,64,85,-47,46,-13,-34,21,-6,-123,46,26,49,-53,-93,-115,10,-3,-84,-37,81,-76,-19,109,60,-24,-65,-47,47,116,95,71,-125,-122,-56,95,-26,-118,-33,-34,59,45,-18,-49,52,-98,-78,73,81,-36,59,-3,5,122,-65,-6,-51,-15,-122,50,20,-11,-22,-26,-124,30,82,-15,-38,-98,97,80,117,39,42,5,38,-86,-27,42,-102,-66,1,-21,-70,14,106,11,-21,35,34,16,-11,121,-108,-77,-19,-25,83,107,-75,9,119,85,21,-67,9,25,36,-68,97,78,89,109,-39,93,77,58,-58,89,-44,-119,-39,-112,113,-41,-17,87,17,-5,109,-67,-88,-74,-14,47,-101,-58,-60,52,23,17,-120,122,63,-122,43,-108,90,-79,39,109,-34,-124,18,-105,-8,-69,-10,56,15,-72,99,117,7,55,91,91,101,5,-125,-112,65,-12,-25,-111,-26,-66,103,92,81,-57,51,55,-7,98,3,-62,93,29,-91,-56,-21,-40,-9,68,107,-78,-91,-5,108,114,88,70,12,-94,-97,63,78,-112,86,36,-113,47,-27,-17,6,120,-94,93,-52,87,-39,-125,-101,-11,68,27,7,-75,107,18,-32,-119,-74,75,32,-87,-25,-107,-109,-91,114,-86,36,-6,73,-73,44,-77,27,-109,-54,17,85,96,-86,-38,-13,-66,-15,95,-42,117,-10,93,25,9,17,-127,-88,-93,-120,-41,94,29,-78,32,9,38,-87,-93,-108,1,-98,106,-41,85,-110,-69,-110,118,-76,-77,-21,17,18,48,-18,-6,-21,-12,-113,16,-75,27,85,42,-79,2,19,-43,-28,-127,8,-46,52,85,-14,78,-94,31,117,-25,-60,11,87,-34,-104,68,83,-35,-18,-110,-127,-53,-20,48,-96,-27,-125,-112,120,-94,-99,-3,85,96,-43,-110,-19,-111,36,-6,89,-41,108,-73,-1,54,29,-98,117,-1,11,-3,-84,-101,14,20,103,20,-98,-122,68,63,-22,-114,117,-12,-98,-27,3,-26,-32,103,-43,121,-28,82,-28,-44,-81,-48,-49,-70,-19,-80,-17,-25,-27,75,-5,47,-16,-77,106,61,94,62,-41,11,-7,-84,119,-19,-107,-67,125,87,-1,-115,126,-42,69,-75,57,-27,13,42,-16,-77,42,-58,74,87,-55,-90,18,-3,-84,123,34,40,-91,-14,-61,37,-6,-115,-82,50,114,25,-14,113,-10,-62,-95,-47,34,-13,-52,37,-6,89,119,-104,41,-90,10,-33,42,48,93,121,-52,92,-36,79,-73,3,-84,-98,-128,66,63,-82,56,56,-99,98,-61,91,-66,45,-127,-90,-41,-101,92,31,-93,-94,-5,-2,41,48,95,-37,119,20,58,47,85,-107,-127,38,-47,68,23,-99,-46,-10,-78,4,0,-53,-85,-27,96,-86,-22,-2,126,58,102,61,85,-95,51,-119,-90,-10,83,61,-9,42,-49,-91,-97,-41,47,-38,124,18,-8,71,-117,15,7,125,-105,-38,-84,83,96,-94,-38,61,16,7,110,85,98,-94,2,63,-85,118,57,127,51,36,-47,107,-97,40,57,4,8,-14,89,47,-8,0,8,-110,-24,85,-113,-62,-63,122,89,107,67,-94,-87,-41,-77,-38,94,44,-79,-24,-12,34,5,-90,-86,-83,-19,97,-61,-94,75,-74,42,48,-11,0,91,-37,-99,-47,-126,-30,-85,45,-104,4,52,-127,-88,-97,-24,37,-106,60,88,94,51,7,19,-97,-40,-20,-91,-38,-10,94,19,-111,-84,66,83,95,-69,-26,92,-36,83,59,-65,-2,-92,-99,109,-55,32,-6,87,-71,-30,15,-80,-68,108,14,38,-86,-19,72,-83,-72,-75,-87,-54,-77,17,18,77,117,-9,-15,94,7,114,14,-91,15,-84,-48,68,-73,28,121,-72,86,-114,-91,-22,-104,-99,66,83,93,119,5,-3,-104,83,-98,84,-112,104,-94,-101,-20,-123,86,55,-35,-21,-82,-19,18,77,35,71,-19,-91,38,65,82,-67,-13,-75,-34,13,73,-94,102,-56,14,72,110,-96,92,-99,1,85,28,63,34,80,-11,-113,-25,-81,-82,-106,33,105,-116,-17,-83,30,65,18,-67,-10,90,-113,32,-119,-98,95,61,116,2,12,69,18,-67,-14,90,-113,32,-119,94,126,-83,71,-112,60,-94,-5,82,-113,32,-119,-34,-7,90,-113,32,73,68,27,103,-5,92,-45,-109,72,83,-95,-87,-18,-53,-21,100,72,-94,55,94,-21,17,-28,-77,-98,54,76,24,-110,-24,-11,-41,122,4,73,-12,-48,46,-58,-99,32,43,-75,124,-3,73,-23,6,12,-70,-109,49,114,26,30,44,47,-103,-125,-119,106,-66,98,-77,47,85,57,-104,-20,-22,44,63,-17,107,27,-121,33,-23,46,-47,58,79,103,83,-96,-61,-40,41,91,91,-122,12,-94,63,-4,85,-100,-46,127,96,72,-94,-121,34,93,-23,-29,-113,-53,71,-64,-63,84,-11,124,45,121,67,-46,-3,-62,85,-50,-67,47,92,41,-21,-21,79,122,-45,80,50,-120,-66,-3,-39,-78,-78,127,92,-14,-110,57,-104,-88,-94,88,-15,94,-90,32,84,-27,96,-78,23,-69,-48,69,-83,-66,83,21,96,-86,122,-66,-106,-68,33,-119,-34,124,-83,71,-112,68,111,-68,-42,35,-56,-89,29,-19,98,23,49,-70,-34,51,83,104,-94,-21,-57,115,-47,94,2,67,18,-67,-6,-7,-105,-91,30,65,18,-67,124,12,-73,49,90,116,-98,-101,2,19,85,111,-1,-24,92,66,-118,124,-42,-45,43,50,67,-46,-69,118,40,-100,82,-19,-22,-120,-78,68,63,-21,22,57,27,51,36,-47,75,-97,127,89,-34,55,65,18,61,115,-108,71,-85,-35,-1,101,-87,41,-48,84,-41,-3,-11,124,-76,-86,-86,-112,42,-16,93,53,-5,-103,-91,92,-71,12,42,-97,95,-94,-97,117,79,-108,-54,16,105,123,10,76,84,-47,98,100,63,32,8,-84,122,-76,2,76,84,-47,-95,116,-81,17,95,116,17,6,5,38,-86,-3,104,-71,-18,-103,40,-95,-84,64,83,-35,-3,97,5,71,114,24,-14,89,79,79,77,12,-7,-84,-89,-25,37,-122,124,-42,-45,-13,18,67,62,-21,-23,-17,-99,33,-97,-11,50,42,-22,-85,61,71,1,126,86,-43,-42,28,67,62,-22,-91,37,103,77,-122,124,-42,-77,111,109,78,61,111,8,-12,-77,-18,64,-71,80,57,-51,41,-12,-77,46,10,-74,54,-103,72,-94,-48,-49,-70,-81,71,83,122,53,-102,18,50,104,-109,106,36,46,-47,-49,-70,-24,-7,-36,-27,-2,-99,66,-13,89,-50,21,-116,47,-25,58,-22,44,50,9,45,32,-48,-103,121,-65,14,28,-26,29,89,-91,103,75,-12,-77,110,-73,-9,-37,-91,-73,-88,-48,-49,-70,-19,72,83,117,81,80,-32,103,-43,-116,-78,101,47,69,-65,98,-97,53,-47,-46,90,22,-14,-107,-24,39,-35,-68,-48,-89,82,-122,56,4,-8,89,117,28,117,-87,-126,49,10,-4,-84,-38,-111,79,-82,106,-10,74,-12,-77,-82,-39,-78,69,110,-75,8,-16,-77,106,65,117,48,-3,-103,9,-12,-77,-82,25,-92,69,-25,119,40,-12,-93,-18,-60,1,86,117,-100,94,-127,-97,85,-81,2,41,114,26,-29,-32,103,85,-13,20,78,-39,42,74,-94,-97,117,-45,-107,-104,41,-115,3,-127,126,-44,29,102,-109,-42,-87,-115,14,-127,126,-42,69,-122,109,-110,41,68,10,-3,-84,107,102,79,-98,122,85,23,-24,71,-35,-66,108,-74,-109,-35,77,36,-6,89,-41,-98,88,-87,-86,5,-83,68,63,-21,98,-45,50,13,-107,-23,-95,-48,-49,-70,-24,-30,50,-76,53,38,-48,-49,-70,-26,63,37,-39,-44,83,-94,31,117,-37,56,114,-43,70,14,7,63,-85,86,36,73,-67,92,-45,-2,7,-3,-84,-101,109,26,25,-23,-27,-92,-13,-33,-24,39,-101,44,-41,121,-40,-104,84,-99,0,36,-6,89,-41,-20,21,-13,50,-34,-39,-48,-1,-125,38,-70,-10,-127,-9,-67,72,-35,-43,115,-47,126,-111,31,-122,38,80,117,119,29,-88,-24,-89,-89,52,14,38,-86,-11,-88,-39,-27,85,103,84,15,-55,-78,-98,90,-56,-96,-6,-18,66,112,-110,84,15,13,14,38,-86,-74,-92,-12,-67,-85,28,-22,44,-31,23,105,-13,104,2,81,-49,-5,46,5,-6,114,-54,79,-113,32,-87,-34,-23,-1,-78,-12,-127,8,-110,-24,-91,-41,122,4,73,-12,-50,-49,-57,94,-50,49,-27,-5,23,-24,-69,46,-36,88,-41,99,56,7,-101,46,2,76,85,107,-37,55,81,114,-80,65,38,-64,84,-11,-12,40,-77,88,100,78,-104,66,19,93,63,-37,85,-52,-94,93,26,-4,10,77,116,-47,-54,111,63,105,-101,-125,45,98,1,38,-86,-19,24,-91,-91,-31,-25,59,41,43,-48,68,-41,110,36,-27,125,31,61,-44,21,104,-86,-21,-98,-41,-64,17,20,53,39,10,48,81,45,-97,43,-119,-68,82,-126,36,122,-2,-85,14,-78,-76,24,-110,-24,-7,-81,-70,-99,-74,-32,-21,-13,34,10,-3,-84,27,124,-84,4,73,-12,16,-69,47,123,6,-34,-43,-91,-42,12,42,57,-2,3,6,-43,-1,-80,80,-42,-112,101,88,37,-6,-82,-21,27,-99,-28,-42,-113,50,-122,106,-77,35,-47,68,119,-94,-86,-53,94,87,2,-58,-38,48,-97,94,-51,51,17,-125,-24,15,52,-21,118,79,-49,108,-52,-34,117,124,44,98,16,125,84,125,-35,-95,72,9,85,-54,20,75,53,-99,77,-84,119,-85,24,-110,-24,85,24,-21,-69,113,-46,-47,-96,81,-99,-54,15,-16,84,-37,93,1,-86,61,46,-103,45,-82,-48,68,23,69,25,-110,123,-53,-56,-87,-85,83,-113,-117,-128,65,-12,19,42,37,-17,-27,115,50,-46,21,117,-101,-118,-112,65,-11,63,-4,-47,85,-27,65,82,1,38,-86,-25,85,-127,111,-65,71,-12,85,-18,-63,83,9,24,84,-1,-61,-21,-49,37,-53,-39,67,-95,-97,117,39,74,34,-67,-107,-3,11,-8,89,85,-17,79,48,-28,77,-81,-83,-11,-119,18,115,61,69,18,61,111,17,77,-71,-19,72,-111,68,-49,94,92,114,21,-65,-13,68,89,-49,83,-99,-73,12,25,84,-33,62,-55,-75,-125,-117,89,51,-22,108,100,-128,39,-38,-26,109,-91,-67,61,111,-98,-120,93,-85,-72,124,-128,39,-38,104,-71,-66,23,-53,-66,-118,-4,-97,67,5,117,34,-62,93,125,46,-76,114,-99,-18,25,-82,-93,-38,71,-85,-98,122,-60,32,-6,87,-87,-14,109,115,3,1,-46,117,-86,-56,81,-128,39,-38,40,99,-80,-89,64,-27,-107,-51,53,49,-33,68,-119,107,2,81,71,99,-18,-3,-80,18,34,-47,-75,46,101,118,69,4,-94,-114,17,80,-35,-126,-71,96,-77,55,-75,-66,-122,12,-94,-97,81,92,-49,-127,-57,97,-17,78,109,112,69,4,-86,-2,-79,77,-79,-52,-109,-109,15,70,-96,-119,-18,105,-85,-48,62,116,-19,-27,-40,34,-92,-30,-127,1,-98,104,-5,92,21,91,-107,108,-107,80,-103,123,18,77,-81,-39,33,-117,-51,64,114,-117,75,-94,-97,117,-85,77,118,-78,58,-95,68,-33,117,109,58,-97,-91,-71,-19,70,27,70,-67,-86,24,77,68,-96,-22,-18,58,48,-122,-12,-41,-82,-48,-49,-70,54,-122,-26,80,54,-98,68,63,-22,-94,37,119,-85,42,-66,47,-47,-49,-70,104,-52,-103,-44,121,110,-119,38,-70,-29,-104,53,-19,105,-97,9,65,112,117,74,56,-64,19,109,-97,3,-103,-92,-65,78,-111,-49,122,50,-113,-122,34,-23,-67,127,-96,-6,-84,-14,-117,80,-24,103,93,25,-3,-93,-56,103,61,109,105,49,36,-47,-5,-56,103,-71,78,-49,-87,-88,-72,68,63,-21,74,-17,-97,34,-119,-98,-49,37,-51,50,72,71,-111,68,-49,-25,-110,102,52,110,-105,94,-71,68,19,93,91,-22,-58,-39,61,-72,-39,106,45,-89,41,77,32,-22,-74,38,125,100,-3,-21,-116,47,-119,-66,-21,118,-97,-7,-113,-30,-113,66,-109,33,-87,-34,-23,81,-39,76,103,53,-86,20,-102,-24,78,-108,-72,-37,-79,50,-102,38,-80,68,-45,127,39,-111,34,65,18,-67,-73,25,-125,20,73,-12,-38,-25,-45,57,-101,54,67,21,-102,-24,34,46,90,63,94,-90,-68,84,14,-90,-86,-89,31,111,-87,-85,-116,1,5,38,-86,-27,-13,-5,-109,23,74,-112,68,-17,106,-126,-45,94,74,114,48,85,117,127,91,-26,33,83,36,-47,59,95,-21,17,-28,93,15,109,-81,78,119,16,41,-112,20,96,-94,-118,-74,-12,123,65,-44,80,-107,-125,-119,106,-13,-13,76,32,73,-112,84,-17,-27,-77,100,72,-94,87,95,-21,17,36,-47,43,-81,-11,8,-110,-24,-91,-93,-108,-13,-29,-63,-12,-82,-78,108,2,60,-47,62,-33,126,-115,12,121,-41,-61,57,-82,-42,122,127,-89,-87,-48,68,-73,-103,87,-21,-70,84,-122,-70,2,77,117,95,-34,63,67,18,-67,-126,102,29,-27,-19,-3,11,52,-47,-51,-81,-81,-109,32,-17,122,101,-95,-33,-28,-53,-57,41,-64,68,-75,-93,21,109,29,47,101,5,-102,-24,-74,-93,-52,-73,-86,20,75,52,-13,-47,80,-63,-9,-91,-86,64,19,-35,-85,112,-45,120,57,2,20,-6,-82,-101,-47,106,-62,21,-91,-113,-20,69,-123,38,-70,9,-107,44,-35,52,-82,109,7,1,-66,-85,38,-44,71,42,-11,3,-40,-28,49,-90,-120,64,-44,-15,-114,-41,126,64,5,71,86,-58,-87,-74,-27,35,2,81,55,35,-95,-72,-90,2,-41,121,29,93,103,45,100,-36,-11,-49,-119,-62,67,115,-73,103,11,-38,26,46,25,90,-119,24,68,31,125,-61,-45,116,39,-31,108,-14,-86,83,101,-18,-124,12,-94,-33,112,38,-54,-35,44,-10,-12,84,-71,-72,0,79,-76,-51,29,43,30,59,-114,-39,-75,-74,-60,19,-19,-116,-86,122,59,116,97,-109,83,41,11,52,-43,-35,103,92,-100,93,-98,67,109,23,8,-16,-77,-86,-10,-110,25,-110,-24,-39,95,90,-25,120,41,-55,-63,68,53,-67,-66,74,-126,124,-44,-77,103,62,-50,-94,118,-87,37,-102,-34,-3,-7,49,72,102,87,-123,-62,37,-6,89,23,3,59,-87,110,119,18,125,-45,-83,-21,-29,96,95,61,122,61,85,-1,15,-119,38,-70,62,-126,-122,89,100,-55,-102,56,18,77,116,-5,49,-14,-98,72,116,77,-128,89,101,108,7,120,-94,-115,-20,115,55,-7,-95,-81,88,82,61,-44,2,60,-47,46,-24,-108,-27,102,62,125,-42,80,-94,-119,-82,-83,8,115,-70,-110,-87,-120,-81,-32,39,-91,29,48,-120,-2,-119,-10,6,31,-53,59,126,81,-22,18,79,-75,63,92,121,-7,60,8,-14,-82,55,-25,81,-89,43,-128,-92,-113,34,42,48,81,-67,-114,-84,121,91,-92,126,-3,73,73,7,12,-94,-113,125,93,95,37,44,-25,-81,63,41,-3,-128,65,-12,109,-68,123,-17,25,-99,-66,-27,-75,11,52,-47,61,-79,76,-71,-107,43,-83,-81,63,41,-19,-128,113,-41,-57,78,-63,56,-57,126,45,-23,47,63,9,-3,-120,65,-12,-85,89,-82,-61,-43,-94,54,-21,-83,-50,-91,54,-78,67,-58,93,-65,95,-73,86,-10,125,-86,-124,-91,126,41,-7,-128,64,-44,-57,81,-45,-38,-121,64,58,-113,124,46,-75,36,68,4,-94,94,-19,-91,-97,-2,12,-32,-8,-6,-109,-110,15,24,68,31,77,-47,-122,-101,38,-48,-14,8,63,41,-3,-128,65,-12,-79,-21,-70,-73,0,-64,-58,38,126,81,-22,18,79,-75,-35,94,30,-6,48,-40,39,-81,-107,41,-6,-82,-37,38,-6,-44,-72,-36,-95,-75,-66,-2,36,-76,35,6,-47,111,-57,-104,-59,-127,-65,-2,-94,-44,37,-98,104,39,115,-86,92,-81,-43,43,77,2,63,41,-11,-128,113,-41,71,-107,-95,-28,-46,83,38,126,16,-38,10,77,116,-57,-111,-22,-34,-121,14,-25,-38,-16,-117,-6,-118,2,2,81,71,49,112,-41,73,3,-71,70,-41,79,74,62,96,16,-3,-13,-80,-123,-43,37,-101,13,-4,34,-115,-95,-128,112,87,47,-88,60,-26,-34,-1,-64,55,-34,-43,54,66,68,32,-22,46,2,-117,-36,62,-11,76,24,-110,-24,-103,127,-122,93,-117,29,121,-30,39,-31,31,69,4,-94,-114,-74,-41,99,-81,93,-103,-5,-4,-6,-109,-110,15,24,68,-33,-106,111,-41,-79,15,96,101,-71,8,48,81,77,104,17,-6,82,-108,98,-87,-26,-7,90,-15,-122,124,-42,-45,54,49,67,62,-22,-39,43,29,-27,84,-15,8,-119,126,-42,-51,-121,-39,-7,-14,75,-32,-32,103,-43,-126,62,81,111,85,-1,2,126,86,53,-17,79,87,-81,-105,-24,103,93,-40,86,-3,-11,-77,-3,47,-12,-77,-18,58,-14,108,106,14,19,96,-6,77,37,-77,-99,-10,-44,61,-101,-85,-11,54,104,68,-96,51,-126,-53,33,93,71,106,93,-6,92,10,-3,-88,-117,53,113,-86,-44,10,5,126,86,69,85,32,-103,107,38,-47,-4,25,-105,-20,82,12,-13,49,-69,60,-70,21,17,-24,-72,24,-71,45,-105,3,88,15,51,-97,-28,-100,-82,9,119,-11,-116,-90,-116,-50,-2,88,-40,-81,86,25,7,1,-98,104,-101,115,89,92,97,35,36,-64,-99,-78,116,65,68,32,-22,-26,95,-90,-31,114,52,78,116,-60,-85,-86,55,117,-56,32,-6,-59,76,-102,89,62,-110,-76,90,107,114,-60,68,12,-94,-113,-112,117,-11,-114,-50,60,-52,-79,82,89,99,33,-29,-82,-113,-125,124,-43,101,28,35,-62,81,91,-106,22,99,-60,32,-6,-10,79,-11,116,73,108,54,-14,-52,51,84,115,86,64,32,-22,-24,-56,-35,-36,-69,50,91,37,-88,30,16,50,-120,-66,-67,-104,89,-109,-117,-63,35,-93,82,-98,114,15,25,68,-65,-64,-24,-37,95,-107,25,-51,54,-48,-92,85,26,16,-88,-70,121,-59,-50,15,108,103,104,-119,69,12,-86,-65,-5,107,-83,28,54,-123,-56,-120,-122,66,63,-21,98,90,-54,-22,20,-90,68,63,-21,-94,23,-35,84,-5,59,18,77,116,-81,-70,87,46,2,-39,108,-43,26,-85,42,127,49,98,80,-3,-3,74,-48,35,-93,100,-23,-117,42,52,-47,77,104,-31,-71,127,10,-35,94,74,-43,99,91,-30,-87,-74,-69,-118,106,-97,-80,-2,40,57,-8,-82,122,-75,-16,93,46,55,-95,119,52,-54,-112,31,76,-60,-96,-6,-18,66,86,-48,115,72,-127,-119,-86,-103,-13,-67,-69,125,95,-77,-98,-105,-84,-94,19,17,-120,-70,-49,-102,51,63,-78,104,107,91,-128,-119,106,61,-26,-23,10,57,-94,101,33,90,-91,43,101,77,-96,-22,-5,101,-96,-89,68,-53,50,-98,-91,-48,68,-41,12,36,-101,125,119,48,-54,-127,52,81,-88,39,-64,83,-19,58,93,-118,30,74,-27,36,117,-26,35,-64,83,109,119,-121,-74,34,101,-71,51,44,-47,68,-9,-93,-5,28,78,-69,-54,-64,-98,0,63,-85,-102,-73,114,-54,26,75,18,-3,-84,-69,-48,86,92,-114,100,14,126,84,93,-78,-34,53,69,62,-66,-85,37,-49,-50,81,-28,-77,-98,-52,-28,-90,-56,103,-67,-84,-17,-105,32,-97,-11,108,114,62,85,-27,14,5,126,86,109,97,-84,79,-95,-97,-33,118,55,79,-70,-55,53,94,-95,-97,117,71,-44,65,81,-94,-97,117,117,-116,-120,33,-119,-34,71,123,76,29,35,98,-56,-101,30,-2,76,-10,105,-86,90,82,-127,-119,106,67,35,-45,-75,119,6,62,81,38,119,41,-113,50,100,16,-3,-124,-103,-42,-11,77,62,-51,126,-21,106,-21,33,34,-36,-43,109,102,-76,-75,-40,117,125,54,99,-79,-26,-84,-58,89,-56,32,-6,127,-7,-89,29,-115,40,72,83,39,-45,66,-58,93,31,-35,-123,-50,115,-17,1,-125,-64,113,45,69,-83,-64,33,-29,-82,111,-106,-48,116,-19,8,106,-83,-74,22,38,117,-108,44,34,16,117,123,-106,46,116,94,-47,40,-86,-86,80,96,-128,39,-38,25,73,26,-5,126,63,54,-21,-50,-95,-50,-115,70,4,-86,126,-18,-64,121,-40,-80,22,83,-98,2,19,-43,-126,-126,-93,123,-76,-27,-38,124,-75,-97,-60,-118,28,50,-24,-37,28,-93,-83,29,44,39,41,5,38,99,48,-93,8,-83,107,34,13,-69,46,-55,-72,73,-56,32,-6,29,-107,-56,93,35,105,124,36,-8,73,-23,7,12,-14,-115,-114,-93,-107,-68,-73,-108,-121,-71,96,-65,40,-7,-128,64,-26,47,-8,-121,-85,-17,-13,-59,-110,25,-21,18,77,116,109,33,58,119,123,23,121,57,117,-12,83,-50,-117,-102,64,-41,116,27,91,-53,93,-121,78,42,81,104,-22,45,-116,-79,-50,-73,-70,2,77,-67,-67,-98,92,-117,72,-92,64,73,93,-127,-26,113,-122,-74,111,103,-43,37,-77,119,21,-104,70,-46,-122,-115,-11,-26,-111,102,-81,-88,-109,-76,33,-125,70,50,63,-63,-13,-14,-9,117,28,83,-32,-119,118,-73,17,-70,-89,-44,95,89,119,74,-104,-125,105,68,125,-50,51,-17,64,109,60,11,48,-35,109,29,61,-65,-106,21,104,-78,3,-115,93,-61,-76,-57,101,35,93,-123,38,-70,-27,40,-71,23,119,5,50,-29,83,-94,-119,-82,25,-39,-53,-59,26,67,93,-127,38,-70,40,104,-79,-10,-17,-66,-99,114,110,-109,104,-102,-9,-112,-42,110,32,2,-120,95,116,-26,-125,-64,-45,-100,-115,60,86,-38,-79,-11,-6,69,-119,7,4,-94,-18,-106,122,-92,102,-113,83,37,87,43,48,81,-83,-121,123,106,-14,-52,41,69,18,-67,97,-13,-11,116,-97,-91,118,86,4,-104,-88,-102,-33,-34,-35,-57,-114,84,-85,46,-101,118,68,4,-102,-101,117,-42,61,-40,-33,18,58,83,20,21,-60,-46,120,-98,-77,54,93,126,126,-53,-7,-21,79,65,-46,-102,98,-112,-100,59,-108,46,93,123,6,32,14,-90,20,28,-11,80,57,119,1,-125,-26,36,-74,-20,78,47,55,116,-4,49,-93,94,-26,59,6,12,-94,111,-21,112,89,123,16,19,71,-85,-16,-109,-110,-41,4,-94,-66,-52,12,-87,123,-79,-103,86,-15,-109,-52,3,-107,120,-110,107,107,-34,78,-34,125,65,-100,89,-60,47,42,-29,86,-30,111,-38,-104,20,103,-81,-5,89,40,28,86,-67,126,-30,-22,33,-125,-24,35,37,97,52,-121,70,109,119,-107,35,16,17,-18,-22,-87,-95,-4,-17,126,-89,104,-128,-101,84,-81,-127,0,127,-41,-50,8,23,-69,-89,-120,-83,127,-5,69,-119,7,-124,-69,122,-123,-93,-74,23,-8,65,105,51,-101,57,-43,-87,0,-115,-65,107,55,108,-79,-20,7,27,-81,122,122,73,-107,-74,12,-16,119,109,-92,-123,-115,61,-84,-114,-62,-104,-67,-53,74,67,26,127,-41,-74,15,-82,-74,-35,116,65,69,-45,60,-44,-50,111,-128,-65,107,-81,117,-84,-66,7,36,-82,74,-76,66,88,-128,111,-86,31,85,5,123,-48,71,-122,33,95,-22,-3,-10,55,-33,-3,-8,-27,-89,31,-2,-8,-25,-97,-65,-1,-31,79,-128,-1,-31,-53,-9,-65,-1,-125,-55,-89,-126,109,-23,127,-1,-2,119,63,-1,-31,-21,127,92,127,-5,-113,-33,-1,-23,-53,63,127,-7,-3,-1,-3,-14,-89,-97,127,-6,-18,-97,-2,-123,93,-116,111,-86,-39,69,81,91,-122,-30,55,-9,74,15,-123,89,-54,-40,-113,97,-95,85,98,-102,-89,-86,84,31,17,-18,-22,54,73,-108,-102,-9,-62,-46,-24,23,-103,-70,-38,-13,-116,8,-28,-109,58,-113,122,-18,43,13,-6,113,-114,60,-59,70,78,-128,-89,-38,-77,-19,9,6,104,78,-102,-89,60,-93,16,17,-56,-64,55,-53,-49,44,73,119,41,104,54,94,-28,-47,-16,-120,65,70,-55,-80,85,107,-19,-121,94,123,-48,-97,92,-95,-17,-70,-29,58,-10,-99,-33,-55,10,-16,77,117,-96,-56,99,77,110,72,-103,65,37,-113,61,4,-8,-69,118,74,71,-86,101,-19,88,-76,-11,86,25,79,1,-98,104,-29,-8,-62,114,3,10,-27,-62,-117,-118,79,71,4,-94,-34,-112,-57,-75,7,-32,-48,115,50,-107,-84,86,-23,-112,65,-12,-3,-4,80,-52,-11,88,-22,76,-91,2,19,-43,-116,-40,-63,-12,-40,102,-109,-90,124,38,-102,64,70,10,44,-55,-18,-64,50,-58,-93,-64,116,-4,85,115,14,62,-98,-101,-67,116,117,-52,48,100,-112,-81,-58,-36,-23,62,-10,40,72,71,91,-29,-95,-5,36,69,12,-70,38,-76,-27,-114,-47,-96,-37,111,58,79,-39,-46,38,98,-36,-11,51,-46,109,-109,-101,122,-112,29,-47,117,-33,32,77,-96,-53,107,-10,6,67,67,7,93,105,47,70,4,58,-45,-90,-75,-25,42,-95,-23,-7,-84,50,-77,52,34,16,-29,-56,38,-3,-100,-9,108,23,-12,124,-73,-103,72,45,65,1,-127,-84,-51,72,-25,112,102,90,-105,-93,93,-127,-55,-102,-36,14,3,-17,-97,69,-41,-43,8,4,-104,-88,-94,-24,-14,126,66,15,127,-66,-42,-94,50,-78,34,2,121,18,102,86,-17,101,61,-47,105,62,37,-71,-48,75,56,25,31,-13,-80,-31,-102,-35,-105,54,-114,115,-55,10,-127,1,-31,62,-74,-47,97,-69,-99,-5,106,-126,70,-97,-78,-82,-69,-124,-45,121,54,-73,58,62,108,-8,37,-49,56,70,-124,-69,-6,85,-36,-94,-19,65,-120,-2,53,-81,75,45,-101,1,-31,-82,110,-90,104,118,-69,28,40,-118,-66,-78,42,-69,29,-32,-119,-10,68,-26,-56,-2,125,33,-101,-87,-54,83,89,17,-31,-82,-34,42,-100,-78,-3,5,33,28,-120,35,-37,66,61,32,16,-11,-114,54,63,123,64,-84,-21,96,-86,68,19,93,-41,-94,61,-44,36,72,-94,-25,14,-105,119,29,-96,-90,72,122,125,-85,86,55,119,69,-102,2,77,-33,86,-86,110,-82,61,-15,-127,-87,-83,-112,0,79,-57,112,-53,-18,-88,32,-86,-61,-101,-7,37,-26,-92,-120,64,44,18,-69,-57,-26,-62,22,-24,117,96,-61,94,-102,-106,17,-29,62,47,117,-5,126,-52,-28,-33,47,-58,-100,-23,-36,-102,108,124,22,49,-18,-6,-91,28,-45,-11,-125,71,-65,-29,-86,-52,41,13,39,-13,53,-74,-85,-102,-73,113,-69,77,6,85,-70,-108,17,-125,-84,-24,-104,-53,-99,123,-85,123,-95,43,48,-11,-78,-13,74,110,98,31,40,7,-82,-116,16,-115,23,-63,31,119,60,19,118,-18,-11,83,20,-2,17,12,-86,-1,97,-6,23,91,70,-28,-107,11,52,-47,69,-48,-4,-84,-18,42,-80,110,-85,-106,-39,17,-127,-68,-57,-114,66,98,-5,-120,-102,-121,-7,-116,-78,-50,-76,-126,19,123,21,-75,-48,-99,-121,104,-26,110,-107,65,-62,0,79,44,121,-92,-125,-50,125,35,11,-115,126,-90,-18,77,25,16,-18,-22,56,-50,-28,118,-11,-48,-20,-90,-12,-82,-126,-19,17,-127,90,36,101,-71,0,-123,77,64,77,54,-36,13,-16,119,-19,-36,-113,-47,-67,85,-114,-61,-16,42,-107,42,-64,19,91,7,30,120,78,126,94,30,-91,-88,-119,92,-29,-55,10,-108,-19,-113,-18,27,124,54,25,37,-39,95,68,-61,-119,50,-74,-108,-9,108,-114,-74,-52,39,47,-54,37,11,-16,-36,94,-104,-82,-108,7,-68,-94,-82,-37,43,-122,12,106,63,-92,-71,127,17,-104,72,-121,116,-74,37,-100,-68,75,84,30,-37,-73,111,-82,-125,-127,42,94,-94,-48,100,108,79,84,-61,77,-18,-15,-39,-105,-41,-44,41,-120,-120,64,-66,75,-101,-40,-6,104,-2,-67,-73,-103,-43,98,31,17,72,-12,-63,-84,-25,-31,44,115,-108,98,-112,105,124,1,-98,-84,-13,-89,-51,109,-51,89,5,-26,84,-56,-78,-19,1,-2,-82,-99,96,123,125,-50,-101,-25,-110,83,-95,-58,-109,-43,1,-101,-8,14,107,38,-56,42,-78,-28,-74,-58,-45,117,-83,-70,-67,103,44,-82,56,64,32,-105,76,77,32,-22,40,96,-78,39,42,-62,50,48,-21,76,-82,108,1,-127,120,-15,19,-69,-99,110,-123,93,72,93,81,27,96,26,79,-75,75,77,31,-111,-43,-80,110,-12,29,76,35,3,-77,121,111,-4,-60,113,21,93,53,94,19,104,-12,-88,-71,-30,-6,120,53,54,100,101,-115,-14,-128,-64,45,-119,49,78,-9,-8,-16,-127,-24,110,72,-102,64,-66,77,-20,-1,-10,125,-99,-54,40,90,42,-37,-88,107,60,-79,83,-20,123,24,-39,57,27,29,-67,81,100,-52,46,32,-112,25,-21,-60,113,-84,-31,-116,26,-13,53,-14,41,-37,83,71,-116,-69,62,-52,118,-73,125,112,-30,-28,127,-107,45,28,53,-98,-52,-27,87,-62,-48,-66,88,-95,27,-118,-102,-57,57,-104,-8,-125,11,-101,-86,-5,53,-96,123,81,42,67,13,-13,-112,65,109,55,51,-22,-70,7,43,7,92,-128,-119,42,82,65,-102,-69,61,-77,-53,-54,-112,-47,-110,-128,64,-98,-55,21,-61,-34,-13,88,22,-78,126,-90,52,82,2,2,93,-109,-45,-39,93,-32,-58,92,25,-71,-32,7,120,50,-66,-85,25,52,123,77,-80,-53,-84,-106,13,-103,2,60,-7,-22,-111,-124,-17,38,32,28,85,63,101,-75,-118,-120,32,-68,-17,-4,-79,127,53,-106,-86,-64,21,-32,-23,-6,-48,-26,-57,-58,111,-43,61,-121,36,-100,-92,117,-32,51,107,110,59,2,-85,-73,-20,-108,-92,-15,36,33,5,-69,-45,46,-81,-89,-9,-13,-78,-50,84,66,-118,38,16,117,4,-11,93,-28,19,25,-1,-87,-85,124,-59,-120,64,18,117,-20,17,-102,-101,52,62,-48,42,77,71,-96,-119,-18,117,-117,110,119,41,-46,21,104,-94,107,75,-58,44,-18,-59,-32,108,49,126,82,-38,1,-125,-24,47,108,82,57,-45,23,85,-40,-110,-36,-13,15,8,-28,93,-30,-40,124,-5,-40,-16,-112,-27,-102,57,-104,-116,109,123,-31,-51,-107,46,4,-78,53,57,66,2,2,-75,54,-53,121,-6,119,19,-76,58,17,104,110,-7,-92,-79,-4,107,41,61,-53,-18,-52,1,-127,-52,-127,-10,-42,-13,88,31,-5,-113,102,-36,-88,16,77,64,32,-74,15,106,-76,-10,-2,-111,-119,97,30,-109,-102,-66,3,2,-119,-52,-10,-93,15,-41,-34,26,-55,13,83,55,88,15,8,100,-27,-79,-27,52,-71,68,15,36,79,-82,-90,-99,65,77,32,118,-107,-83,83,107,47,-33,122,-27,78,24,86,-87,7,4,106,-75,-83,-27,-110,62,78,-84,83,42,81,41,-64,19,-19,117,20,3,59,-61,122,30,-3,84,71,94,34,2,-115,-69,-51,-108,-89,91,6,17,-50,-107,-117,91,-56,32,-6,9,105,37,-69,-27,94,116,39,110,1,38,-49,-92,-95,45,-93,-13,121,-101,77,74,-22,-84,117,-128,39,-93,-36,30,-33,89,-35,-37,65,110,-58,-108,-49,59,32,-48,-17,-1,-13,74,-82,45,61,-3,-11,115,56,-103,-73,-46,49,92,-124,14,3,-42,-34,-118,12,74,4,4,-22,-53,-102,-63,88,62,-116,-102,41,123,-6,70,4,-78,82,96,-110,-13,105,19,5,-67,-24,101,-113,-67,-128,64,19,115,-57,-8,-104,64,-85,108,-20,-86,-48,-44,-106,40,126,-73,-67,-23,-3,24,1,38,9,-48,-21,-6,86,-35,21,-40,116,-127,115,-55,42,3,58,96,16,125,28,-75,117,107,44,42,-61,-104,57,34,-21,-106,107,2,77,15,-33,-9,88,-48,-37,-90,-56,-51,30,1,-90,-86,-93,-100,31,-85,84,-18,-86,12,80,-128,39,-38,-80,-15,-90,-53,-105,-126,-71,-98,100,83,-119,-128,64,-83,-28,50,-121,75,109,64,-74,107,-83,106,39,41,32,-112,76,-48,114,76,-1,25,20,-100,91,81,105,-96,2,77,124,41,123,-63,-27,-4,-36,-51,106,-89,-52,-104,9,8,36,103,-53,21,-7,-20,-70,52,58,69,-46,57,-75,-42,-71,-73,-56,-69,-4,-60,46,-105,-80,-128,64,-14,100,-38,-43,-65,120,-57,54,36,-92,-85,-75,93,-29,-119,-67,-106,-114,-20,-109,91,51,118,62,-86,-68,-14,-128,64,-83,-63,90,-85,-37,75,-51,25,-109,-101,-116,85,69,12,-94,111,-9,-107,-101,123,-118,-14,28,-100,2,-45,-4,96,-101,5,-36,126,103,66,33,3,-75,51,21,17,-120,-6,-126,-117,-15,-103,-87,95,-27,14,-87,-58,19,-53,-63,-2,101,44,-25,99,-104,99,122,-3,-92,76,-121,-128,65,-97,119,57,75,117,-37,-110,56,49,117,-54,92,-51,-120,65,70,-70,-3,-109,45,38,110,7,-92,-39,-24,106,-22,64,88,-56,-96,81,-33,94,-22,-12,96,53,94,4,-104,-52,85,-120,38,122,32,-4,35,121,-64,68,-29,105,-36,39,-113,-22,-26,53,27,91,-23,44,-14,-64,80,-60,32,118,-49,64,37,-1,-27,-25,-118,42,119,74,3,-4,93,27,69,-119,-35,81,64,-28,13,-52,-94,-34,101,-128,39,-85,90,63,90,42,46,43,-90,-100,-104,-103,-28,-38,19,49,-120,126,62,114,117,81,-59,107,57,-111,109,117,52,-98,104,39,-73,-90,20,89,94,-120,34,-23,-77,64,127,-42,-22,-1,-72,12,-98,8,52,121,127,-26,-6,-116,-18,-126,113,-24,56,-78,100,-41,-16,-128,64,70,118,70,65,-105,29,106,-97,114,46,-46,-58,-44,120,-30,-119,-32,-104,-43,-4,-104,-22,83,95,-86,-12,90,68,32,-77,-120,-39,44,-43,127,3,102,50,-103,35,-93,38,18,-119,-89,107,-49,-76,79,-86,-7,-7,56,119,101,-63,70,4,18,-31,-64,-7,-115,115,119,-72,-48,-79,-30,92,50,-57,37,32,16,117,-12,56,-15,73,118,-78,104,-125,2,19,79,-37,108,-49,-20,23,16,-83,42,-64,68,-43,92,-118,94,-45,75,85,14,-90,49,-98,-23,-114,-33,-122,-86,28,76,-97,-85,-83,-96,110,-67,88,-16,46,-44,1,-9,-120,64,108,-122,-116,54,102,-21,99,-20,-81,115,-54,65,17,49,104,22,68,95,-25,71,118,64,45,-46,98,-48,120,-30,125,-64,85,73,31,-69,5,105,52,-75,-29,-94,-15,100,-10,59,-79,5,-21,44,81,108,-24,-53,26,-117,17,-127,-82,1,-87,-72,-3,100,100,-106,76,-103,-25,19,17,72,92,-96,126,30,-67,29,-3,40,102,115,-56,83,-58,-102,64,-93,14,-53,-49,56,67,-73,86,20,96,-70,-30,-114,-26,118,78,113,13,114,21,19,104,50,70,108,113,-77,-23,-41,93,1,-50,-60,-85,-23,58,34,-112,92,-103,-119,4,18,-73,-119,-121,-72,83,-107,-91,-93,66,6,89,15,48,62,93,6,99,-17,65,104,32,-64,-45,104,-6,-103,-100,65,-44,-19,51,94,-14,0,-122,-58,-45,93,-36,-31,102,32,76,26,-10,-65,96,23,87,-32,-23,124,56,-70,43,-42,-12,-11,8,-117,106,-66,17,17,-56,28,110,118,91,114,45,81,49,73,100,-103,67,20,17,-24,-70,-109,-122,-97,35,-12,25,81,1,-90,-41,-4,17,-41,-109,-39,26,4,-7,82,-17,-73,-65,-7,-18,-33,126,-4,-31,-33,-66,-4,-8,-13,-9,95,126,2,-4,-89,-97,127,-4,-31,-1,124,-7,-33,95,15,115,-41,-21,48,-61,-105,31,-1,-11,-89,47,-1,-21,-121,-33,25,-21,-25,31,-1,-4,-27,63,-65,-11,57,-16,49,-36,81,-53,-36,-7,-39,6,-122,-30,105,15,-65,64,-17,31,-31,121,-52,-28,-86,17,-25,68,-25,64,-118,-94,-49,-29,-99,30,-110,92,-38,-16,-19,-108,-52,2,-104,77,-25,28,71,12,-6,-123,-49,115,-20,-79,-22,108,-82,96,78,69,37,14,-124,12,-30,31,-40,63,-43,-35,-103,-56,-27,58,-72,-81,82,53,34,2,-51,113,-52,53,111,22,-116,-3,23,-10,75,85,-58,106,68,-72,-87,-93,-109,-32,-102,105,-49,59,71,35,-103,54,-90,44,-91,26,49,-18,-6,101,-95,-83,-121,107,37,52,-47,-60,88,-74,21,13,25,55,125,-44,-61,-53,-43,-105,19,63,81,3,67,-124,-93,3,-4,93,-37,-82,-60,102,117,-41,10,17,27,97,-3,-108,101,69,35,-58,93,31,-66,115,-38,-21,27,-106,-21,69,-87,-104,67,-128,-65,107,-101,-41,-74,-70,107,-10,85,48,-121,-108,-90,42,-111,-121,12,-94,63,16,75,113,-91,101,91,-66,126,82,-11,22,35,6,121,54,102,35,-91,-26,-38,33,-74,-118,110,57,42,-42,27,50,-56,-69,-59,-7,-3,85,-9,-69,69,-38,126,82,38,69,68,-72,-85,35,97,-62,85,-82,-60,-91,-108,83,-42,61,-114,8,-9,111,-86,-83,-85,-79,-30,6,78,-51,-106,118,-35,-23,33,32,16,123,-4,68,-99,-114,125,-61,6,-33,95,54,27,83,-90,-26,4,12,18,-87,49,51,-60,29,-98,-50,125,32,89,80,-10,3,14,8,-60,10,-83,-26,58,-18,-101,-64,25,-51,-93,-53,41,35,30,1,-127,-28,65,-30,15,-69,-125,52,25,57,-57,115,-86,32,86,-56,-72,-21,95,25,-35,-66,-55,29,10,-122,-115,-94,-46,-94,66,-58,93,31,-47,127,15,-74,101,-51,110,85,109,60,70,4,98,-41,-104,63,-36,-101,91,-108,-101,45,-102,-78,34,127,68,-96,86,83,-51,123,-100,27,75,126,90,73,53,17,-113,8,119,-11,-103,-47,-30,-62,93,10,114,74,-27,-15,33,-115,39,87,-66,16,-69,-35,83,7,114,94,71,-55,83,57,-48,33,-125,-68,85,-100,-46,-35,-85,-52,-27,-118,19,-86,67,57,-115,17,-127,103,22,79,-9,-127,-104,61,-65,-46,84,95,84,68,-96,-69,-111,104,27,-21,90,-69,34,6,-103,100,-68,40,98,16,-21,9,61,69,-99,59,-123,85,-25,-20,-70,-98,-127,38,-112,-71,18,-50,-3,114,51,-21,68,-49,-18,83,26,103,17,-125,-52,-12,-104,89,-9,83,-104,104,103,84,-85,108,-128,-84,-15,119,109,108,-5,-97,-69,25,-121,-42,105,-83,-53,-118,-17,17,-31,-66,2,-50,-85,-114,-64,94,119,26,41,97,53,-87,46,-22,17,-127,-84,-81,-41,-103,-35,-67,24,-21,-123,46,-78,-40,85,-56,32,-6,-24,46,-20,75,33,99,59,41,37,-43,-28,43,100,16,-3,124,-40,-9,-25,74,91,-25,-127,50,63,42,44,16,50,-18,-17,54,-39,68,-25,15,-106,-107,-123,100,9,-35,54,47,98,16,-81,-95,124,-98,45,43,-74,38,-9,33,-65,-38,-112,65,-94,108,72,-10,61,-35,71,88,-45,97,-42,-87,-4,-82,34,6,-55,-40,-64,121,88,-33,-124,60,33,99,49,-53,-76,-43,-120,65,60,78,-40,-94,107,-97,-93,-48,-6,-43,-100,15,25,99,-41,4,98,-123,32,32,-97,-9,0,-108,125,57,-74,58,-100,69,45,-123,17,-29,-82,-97,-47,-79,-21,116,-51,112,81,7,104,-100,93,-99,-45,-115,24,68,-33,85,-66,72,-70,122,61,69,-110,-25,-127,35,124,-5,-119,65,91,-30,-19,-113,119,-43,88,39,34,-112,-104,41,14,-128,-18,14,99,-78,-105,117,-50,36,15,94,6,4,18,-15,45,-88,-76,-72,61,-72,-76,48,20,-52,76,81,1,95,77,32,-34,55,14,-107,-69,6,32,25,-57,-100,-51,-78,-112,29,74,3,6,-103,-57,-22,-47,93,-105,11,52,5,56,85,69,38,13,23,-2,-91,-85,-101,-119,-2,-46,75,118,-119,-116,8,55,117,52,-42,92,40,-86,-74,-127,-105,89,-27,-93,-86,82,85,33,-125,92,-3,-43,117,97,-70,-42,8,56,93,53,-69,-14,94,35,-58,93,-33,-122,-21,-39,-122,107,-1,-47,-81,-22,69,42,27,34,100,-112,28,-62,118,117,122,-33,109,32,-76,60,-105,59,97,26,79,-25,-10,-31,108,-49,-85,-49,67,81,-67,72,2,60,-55,-99,-71,118,-56,-10,-63,-101,-48,71,70,-26,89,104,-4,125,30,72,-11,-104,-83,37,-9,93,87,-69,-19,44,-61,124,17,-125,-24,-69,-18,117,-55,102,-111,-78,100,-34,-100,0,19,85,-101,122,-54,-66,-84,-89,-122,98,1,77,5,-103,34,2,-103,-67,108,-74,72,-5,-96,74,40,44,-106,-89,60,-60,28,16,-56,-98,105,66,-77,-86,-79,79,117,56,122,63,84,-9,-72,-120,112,-97,27,-79,-7,-111,-25,94,111,-51,-116,-99,-93,-98,77,23,35,15,24,100,14,-24,7,-6,5,-72,22,61,-88,-76,-45,-44,-63,-101,-112,113,-97,-61,16,-72,-104,123,-110,52,-118,59,35,-84,44,102,48,-115,-65,107,-29,-104,118,79,-5,-99,34,85,-85,23,-27,53,69,4,114,-27,-24,23,-68,-10,117,-64,62,57,3,-97,-54,31,14,25,36,118,-72,-114,105,14,-6,-34,-102,10,-11,91,-109,-52,-26,10,25,-60,115,-78,63,61,-10,108,91,-104,-78,85,31,88,-115,8,52,-61,-70,79,87,69,32,-101,-91,-103,-12,14,115,64,32,25,122,29,-7,16,-61,125,-127,-45,-66,-17,41,63,-86,-120,65,-12,-41,97,127,61,-19,-45,-121,-51,-126,-93,-56,76,-124,-128,64,-4,-19,-119,-105,-66,91,-7,-55,-4,-58,-91,-5,-27,-124,12,-78,-101,0,115,-92,57,11,5,-59,-119,-106,28,56,1,-127,-38,52,43,-71,84,0,-8,-120,-85,119,-107,72,22,50,-18,-33,21,-14,-5,-42,-66,-102,-75,-119,104,-125,-84,-93,28,17,-18,-22,39,-114,5,-71,-94,5,-56,-110,-17,-70,107,106,-56,-96,-77,66,74,-26,-82,109,-24,-126,-59,56,-100,21,36,-125,70,-4,81,-22,118,55,-128,-80,91,115,74,-109,41,32,16,-113,27,-35,-120,-49,125,-57,16,29,48,17,-54,-108,-51,-128,2,-58,93,127,-63,-99,42,46,18,-69,96,94,76,-75,31,18,50,-120,-27,4,35,127,55,63,-109,89,-49,54,-2,84,-15,-26,-120,64,118,72,79,-77,110,-9,71,-103,-112,-4,44,3,-61,1,-98,-20,39,-76,35,-11,-79,39,-110,-32,74,102,96,-11,69,12,-30,67,-115,-93,12,31,-91,70,-75,109,115,-96,-43,-109,-113,24,-60,-121,50,-5,-74,-82,61,47,3,-85,67,112,104,34,100,112,59,-28,-20,-43,69,-66,50,-46,104,-43,-122,75,-56,-72,127,-73,104,75,107,-125,121,-97,-93,38,34,71,69,-39,57,33,-29,-82,-113,82,116,-82,4,37,28,47,-101,19,85,-88,47,34,-48,125,-58,-85,0,-10,-66,-14,35,87,-19,-108,-5,-92,17,-125,68,112,-53,-111,-22,30,12,47,21,109,124,-109,114,-91,34,2,-51,42,-20,109,79,-66,-50,-88,95,113,-54,67,-12,26,79,102,-124,108,-21,-40,-98,68,-107,79,76,-120,-14,-54,35,2,-55,-29,-52,56,105,-79,-17,25,-102,-117,97,-66,81,-110,27,117,17,-125,-20,43,-104,-125,52,-10,13,-108,-108,27,-118,17,-87,65,31,17,72,76,8,103,11,92,-80,33,-95,-74,86,55,71,70,5,-123,2,6,121,58,-51,-71,119,-47,-79,18,-126,124,-87,-9,-113,-112,113,-108,-122,115,100,27,111,-32,71,81,-12,121,-68,-44,91,-82,117,47,-118,-45,-75,-95,-50,2,42,-16,93,117,-30,-12,83,-37,-65,-128,121,102,91,106,-44,-112,-114,8,-28,25,-28,-85,-104,-42,54,51,-52,106,-42,-108,-71,69,98,-98,13,25,119,125,20,-21,-80,111,120,-65,24,-44,-2,59,-107,121,23,17,-18,-22,56,116,-100,-42,126,38,-62,22,48,-12,111,20,-122,123,68,32,-22,-40,96,-84,123,-119,-128,85,113,26,-4,84,25,94,33,-125,-24,-69,-42,-52,-53,12,-49,-103,-27,41,56,-119,-66,-21,86,55,90,-41,68,-11,123,85,61,91,-127,-119,-86,-85,4,-67,116,-81,75,-118,124,-87,-9,-113,48,123,92,85,37,-73,-11,102,-14,-98,39,12,37,-78,41,-34,-24,-95,-4,-1,28,123,-80,-96,100,4,11,100,35,2,-115,39,30,110,-63,70,124,113,-37,-49,-40,-16,-106,13,32,66,-58,-35,30,65,71,37,-41,-15,-82,102,-60,-123,-110,-36,82,14,8,68,29,-31,-80,115,-17,-92,85,11,62,-76,-91,124,-72,-112,65,-84,-87,122,32,-77,-35,-19,-126,-94,-114,-85,42,-108,17,17,-120,-59,83,109,126,89,-39,-59,105,-48,65,117,20,105,-14,4,12,50,14,-47,31,125,-72,-44,-61,-126,109,39,-107,-90,-95,-15,119,109,68,-78,-51,123,-9,-106,93,77,-78,54,86,68,32,25,-65,40,108,-27,-30,-28,67,38,65,43,48,-71,-26,43,-45,-45,93,66,-127,-115,39,-117,-56,6,4,-110,117,-114,78,-55,123,-98,-59,-71,-80,-59,45,119,120,53,-98,-8,-77,56,-50,-25,-110,72,107,88,43,44,34,-112,8,-96,-3,83,-37,79,-8,-107,-85,73,-97,76,125,-116,8,52,-89,4,-75,39,93,-110,-56,85,-88,34,72,42,81,4,-110,-9,97,-117,-35,116,-53,54,60,-102,108,124,-107,-9,-95,9,116,126,73,115,111,115,-123,-34,-60,57,47,-103,-84,28,16,72,-20,18,-63,-68,61,5,5,57,-79,-26,95,-56,-94,45,18,79,-14,18,-51,-103,88,-53,109,-112,-37,90,51,101,55,-36,-120,64,114,-76,-48,38,117,-72,32,-86,57,-115,-91,-54,-76,-60,-128,64,-44,81,-60,118,-1,-96,97,-31,52,89,9,46,-64,-109,-67,-5,-116,67,41,123,-54,82,106,19,11,-102,26,-20,33,-125,-52,-23,56,27,59,-10,-22,78,-71,-106,99,-106,83,-74,-9,-116,24,116,-67,-18,-82,8,32,-94,39,-59,-82,69,45,25,1,-127,-60,-98,22,10,47,-18,77,82,-53,66,34,83,83,-5,-56,33,-125,-20,35,-73,-81,7,57,-73,-17,3,39,-11,102,85,121,54,33,-125,-60,92,-111,10,-79,-57,103,-51,-89,30,77,-19,34,105,56,-49,-33,30,123,-102,2,-118,-19,117,123,-70,-30,-75,70,4,50,-117,-39,11,79,105,127,75,87,121,-61,-91,-114,-103,70,4,50,-49,92,-123,-3,93,-124,-22,68,123,32,-103,15,26,50,72,-20,35,93,-51,10,-3,16,67,63,34,53,-41,4,4,-102,41,107,111,-37,125,127,-67,-101,-93,121,-54,-74,63,17,-125,-38,26,-19,-36,-113,127,-92,-110,-125,-74,-31,1,-98,104,-93,-82,-47,-98,-9,-125,26,-98,-75,45,-75,7,16,17,-18,79,-90,94,-81,100,-65,-110,-122,-64,99,85,-95,-60,-120,64,86,16,115,70,-6,94,-106,17,-31,-75,115,-98,42,-93,50,34,-48,-103,-90,12,127,58,3,-67,-40,-102,-74,-36,35,-58,61,-118,-37,-48,-29,-61,-43,-24,71,-111,-124,58,-27,-26,81,64,-72,-85,99,-105,111,-71,-115,-90,114,53,56,19,70,71,-128,39,87,126,34,-76,-18,90,-89,127,-19,56,-96,118,-43,2,2,-39,55,-78,-107,-47,-122,-64,110,-95,-40,79,-74,86,38,21,32,-114,24,36,-1,-93,-101,3,-28,58,87,33,17,-64,-84,46,89,-127,59,98,-48,-39,96,-43,-67,-60,97,-78,97,87,-52,-95,83,13,69,3,2,-3,94,91,77,123,-107,-91,116,45,112,73,29,-92,9,25,68,31,-25,-101,79,-105,-19,-126,-75,-2,-108,29,102,66,6,-55,3,29,-88,63,-75,61,73,-12,-24,-55,69,86,-74,-42,120,18,-123,-88,-121,111,82,11,-121,101,-99,75,118,-48,14,8,-60,50,64,-65,-114,61,-51,-80,-94,120,71,-111,-123,-100,35,2,-39,-45,-103,71,-86,-43,-19,60,-37,-118,-80,-12,78,117,64,-96,-39,119,-26,94,-19,75,2,-50,16,-43,81,-43,115,15,25,100,47,-42,-4,-109,-45,57,-26,-41,-50,-16,-102,106,84,-122,12,-14,77,33,-63,109,-97,-99,-82,35,61,93,-58,-111,35,-62,125,-52,35,-14,-103,-35,0,-18,9,-91,-52,84,62,107,68,32,59,35,-25,-43,105,-56,109,49,33,127,-84,-21,-102,94,1,-125,100,104,44,44,106,117,-97,91,49,-35,54,21,-116,-115,8,100,-44,-61,82,-87,-5,-82,54,10,5,-43,-46,85,-30,118,-56,32,121,-107,40,-62,-69,79,126,-43,-106,-71,-111,100,57,-6,-120,64,-29,41,-39,-11,-123,-52,39,-36,-33,41,-25,-30,-128,112,31,55,-85,35,-43,109,-9,-22,112,102,96,-55,54,118,17,-127,-40,78,29,-3,0,-9,69,-89,96,35,-76,-88,-3,-127,-120,64,86,89,124,127,-18,28,27,-4,-80,-100,-117,12,123,70,-116,-69,126,-67,78,79,-100,-13,19,-83,18,-26,35,2,-115,100,117,87,-112,27,7,115,91,-111,125,117,35,-62,-3,-67,-26,122,-12,-31,-106,123,84,87,54,115,66,25,-36,1,-127,-52,54,-53,28,35,-105,50,-119,-61,-17,-56,-123,80,-77,-115,38,-112,17,-113,-124,-106,-20,-50,-55,-95,-92,92,105,50,-90,26,49,72,110,73,-58,-125,-84,46,124,-116,-19,127,21,-51,-118,8,52,22,111,-74,-118,-13,73,-51,3,-98,89,-123,-6,35,2,-71,118,-76,3,-36,79,-108,32,77,97,-11,-66,100,90,-116,38,-36,-33,43,82,109,-77,-53,65,-55,40,-24,98,118,-93,-8,-94,66,-58,77,127,-95,-61,84,119,94,-99,-34,-58,82,96,50,-42,-81,-55,-45,25,88,54,5,86,-101,8,-43,88,-41,4,-110,-115,97,46,75,61,-9,60,-49,-102,113,-50,90,-97,-100,-114,24,36,42,-127,-29,-20,-82,-92,33,66,-112,107,40,79,36,34,-36,-43,107,-65,78,42,-17,54,-112,-34,41,-109,104,98,45,-31,28,-45,-23,14,78,-96,21,-116,44,115,16,17,-120,-123,-35,80,-75,-64,-99,91,-61,81,-77,33,35,100,33,-125,-52,95,-40,-28,-34,99,-127,104,-32,32,79,49,106,56,-103,-69,-78,-51,11,-5,-85,-49,-85,-39,109,-86,-57,18,-32,-55,72,68,127,-74,-3,67,70,90,-25,-87,14,47,106,56,25,37,-23,-88,43,-69,-122,-33,73,110,5,73,-12,125,-108,12,28,-31,-99,-5,-105,-122,100,-91,85,-44,57,-88,-120,112,127,-42,13,-41,-79,127,7,-88,-44,-79,-78,-54,121,14,-16,-9,17,-46,-57,49,-36,117,-32,-99,-97,-93,72,23,53,32,-36,-43,-51,69,107,57,-71,61,-64,19,-101,96,98,-108,4,120,-14,-52,-25,97,110,-21,94,-37,-75,-43,25,-76,-96,-117,8,-60,82,47,102,120,-69,-61,53,87,-61,-70,-90,-20,-118,-120,112,-65,118,108,-50,-75,-45,85,73,70,-119,-44,-86,12,-11,-120,64,-10,-56,38,-6,89,124,-76,18,31,51,-55,-108,-49,-128,112,-97,-77,50,122,16,-71,-8,-112,-67,-93,-71,-92,-83,27,17,-18,99,29,-55,-7,-82,97,-91,125,18,-40,-110,86,-122,-76,-58,-45,-40,-84,-39,-88,-5,-34,72,105,87,117,72,53,28,3,2,-79,41,-14,49,92,95,-81,82,-27,2,-92,-64,-28,11,-62,17,-96,-35,57,46,45,-12,44,34,2,-79,-51,81,-80,98,-71,35,59,103,-40,110,36,32,-112,125,102,84,25,-34,99,42,-26,-23,119,-35,-44,54,-64,-109,53,2,-51,-103,-68,103,-116,109,6,-67,-9,19,50,-24,-20,50,-122,59,45,117,-11,124,-107,-127,-4,-120,64,-30,-43,56,124,-23,-37,10,-40,115,52,-13,70,-122,-85,53,-127,-6,115,87,81,-15,13,-116,-46,-3,75,-98,-16,9,8,-28,-55,96,-57,98,-8,-10,-12,-40,-19,85,-71,-87,17,-127,-68,-41,-85,-96,-51,30,-113,56,-125,-122,119,26,78,70,-29,87,-53,105,-97,-122,-122,-83,45,93,-18,64,4,4,106,-55,-91,124,-70,-76,-22,-118,-14,80,-38,-116,-29,-16,-5,-116,56,-66,54,-99,113,-75,7,-6,81,100,109,23,-115,39,-79,58,-101,44,-102,-21,-125,82,-112,47,-79,100,-51,-101,-128,64,-44,39,118,91,125,-55,-81,-114,44,0,53,84,66,6,89,43,-52,-86,25,-53,-99,76,107,-24,17,-36,-27,-77,-119,24,119,125,20,11,42,126,-6,71,105,-67,108,14,-114,-48,-113,24,36,-81,-39,-26,7,119,76,33,-95,119,-80,60,-37,42,-31,100,-33,-92,32,18,-65,-105,35,-63,119,81,-78,108,53,17,16,-56,-105,-28,50,68,-51,67,-109,-7,-35,12,-7,82,-17,31,34,67,51,-69,-116,-54,122,-14,10,-112,12,37,-58,-57,27,-67,-53,-78,-101,46,73,-63,6,105,75,-54,-51,15,-16,-60,122,-125,83,-99,119,-5,-67,118,-92,20,-54,98,-53,33,-125,-24,15,100,-3,-71,85,-36,-34,103,89,77,-11,-97,13,25,-28,-39,-68,30,123,12,-7,82,-17,31,97,-20,-75,-18,-58,10,-86,110,-78,108,94,-122,18,1,-78,55,122,-88,-113,89,87,117,-3,-91,114,71,-121,37,85,-114,43,100,16,-3,-85,-126,-44,-66,-113,-121,1,-80,86,86,6,109,-56,-72,-21,-37,82,-41,-50,-23,29,-91,-116,4,102,21,-53,14,8,-60,-78,90,-40,-104,-102,14,60,-51,51,83,49,-84,-120,64,-44,109,44,-70,-59,9,-67,-90,-106,60,124,28,-32,-87,-59,-103,-51,-27,114,109,-78,16,76,-106,-47,-38,-128,64,-44,-111,7,-99,93,-3,-2,58,80,38,60,40,-44,-94,8,52,111,-46,-34,-1,94,-67,-92,-73,-116,-118,-77,42,-70,18,16,-56,-18,-118,13,-128,-111,-9,28,110,52,-22,73,53,-53,17,31,49,-120,-81,111,-17,-69,-28,61,-20,-35,-81,-116,63,89,-74,48,100,-112,72,5,-78,54,-37,94,-7,20,-11,-62,103,86,103,95,35,2,-119,-38,-38,84,-36,124,-75,112,121,-100,75,-127,-119,106,58,-52,-118,116,61,-14,-20,59,-52,65,-123,-103,-120,65,118,66,-79,121,87,92,87,76,116,-127,-74,-121,-86,54,66,53,-31,-82,-114,106,108,-18,40,31,-118,-42,-113,-107,-27,57,-5,-128,64,-44,109,-14,108,-59,53,-80,28,-11,-24,43,43,39,40,100,80,-3,125,29,-48,-11,-85,40,-14,-91,-34,111,-65,-7,114,-72,62,-106,47,-34,-90,-121,-95,68,-94,-20,43,61,20,-44,-15,107,-37,-71,-114,57,-107,3,16,-32,-55,82,-123,-16,96,119,13,90,-48,-40,98,46,93,-62,37,96,-112,105,19,19,-22,116,77,-34,-66,118,-107,-110,-45,-90,38,-48,105,13,-114,-96,107,-55,123,5,-6,84,38,70,-56,32,-97,-16,117,-28,-44,-73,-47,-84,-16,14,-27,39,-84,9,119,117,-100,-67,-11,-13,-97,-6,8,24,-14,-91,-34,-81,-16,17,-72,-61,-100,85,-100,-16,98,40,-15,17,-4,-19,122,-33,-2,-26,-122,59,-88,87,23,111,-19,-50,80,34,99,-20,-115,30,-70,84,47,-13,-96,124,116,90,-7,20,2,76,84,109,109,106,-5,121,-100,-118,85,119,-54,-86,11,17,-127,-92,41,-103,49,83,93,113,12,-77,-64,81,96,87,-54,71,12,-94,63,-111,51,-75,47,-28,-40,-42,-108,-67,36,5,-102,36,1,-41,-29,-91,38,67,18,-67,-26,-33,112,-96,71,-112,68,-81,-37,-86,-36,95,42,82,44,-47,28,-81,-81,-111,32,-119,-34,68,-85,-20,-14,82,-110,-125,-119,42,-118,114,-72,-8,79,-92,-54,-63,36,40,106,86,126,115,77,91,34,89,-123,38,-70,-55,-42,-44,122,-66,124,8,10,77,116,-77,-103,124,-29,124,123,-67,2,77,116,-53,-37,49,-64,-112,68,-81,-66,-42,35,72,26,-68,126,-85,-9,-22,59,-14,45,98,-112,63,26,28,-80,-112,-24,103,93,51,114,-53,-112,-127,37,-123,-90,-119,-50,-18,45,118,-39,50,-120,33,-119,30,-86,-52,-17,-80,-80,-11,-33,29,74,20,-105,-65,-105,64,-112,32,-97,-11,-92,19,64,-111,-49,122,-70,-119,52,67,62,-23,69,75,50,67,62,-21,101,36,-118,-86,124,109,-119,126,-42,-43,29,-105,25,-14,89,-49,-42,104,-5,-97,-84,-69,44,-48,-49,-70,50,68,77,-111,-49,122,111,-57,-29,87,36,-3,98,-54,-54,-18,-68,76,48,36,57,-104,127,-121,30,101,19,-94,-86,-68,36,-47,116,-66,112,-56,-123,104,-5,-112,123,125,2,77,-25,-73,86,-10,-109,-48,-56,-10,-106,79,-127,-125,-97,102,119,-72,-88,57,79,117,-62,83,-94,-23,42,100,-66,-101,-69,-128,-85,-122,-102,94,-118,56,-100,-82,-105,-39,85,19,70,122,113,-80,100,50,48,93,-35,-35,-99,-95,-29,-123,94,-38,-17,80,106,-121,-28,-76,-36,-97,-42,-75,-114,4,-104,90,77,-18,-113,-29,-56,119,83,-63,72,-119,-90,-106,-29,114,102,80,67,29,-34,-90,-49,112,75,60,-75,114,-21,28,123,-6,45,10,123,-38,27,86,109,8,3,2,-11,27,122,41,14,-5,-105,35,-91,-38,125,80,4,-94,-114,-124,33,55,-99,-32,-108,125,29,114,-94,8,8,-60,-105,-62,-31,28,-105,-12,-116,13,47,-71,99,16,-32,-119,118,-61,-42,-53,-98,89,-107,109,114,57,101,99,73,-115,39,-38,-11,-86,78,-74,97,-111,-96,88,-43,30,-92,-124,19,-27,19,53,12,28,52,-93,118,-111,-108,-106,120,-30,119,35,-95,111,-113,-76,34,67,36,23,89,-19,94,-29,-119,118,-75,27,114,57,-61,-59,86,-116,-42,85,-6,88,68,32,-22,-7,106,28,-25,46,5,47,71,-74,-102,11,25,100,-93,-45,22,77,-105,89,-47,80,77,107,-87,60,-49,0,79,-76,27,122,66,-69,-52,42,4,-49,101,-127,76,-115,39,27,-54,-10,-56,-90,-53,-62,65,95,-76,-47,-43,-55,-34,-120,64,-44,113,-14,125,-49,-61,107,-51,86,-21,-98,84,99,-29,-120,64,-46,48,-42,81,71,114,-32,-123,122,68,106,-58,-43,120,-94,-115,58,67,-55,61,68,-76,97,-21,106,-93,51,34,-112,-108,12,-108,-106,119,-87,-9,54,-91,-114,-87,14,-90,4,120,-102,-18,97,94,-13,62,108,-111,-60,89,101,109,67,-115,39,-95,74,20,53,-39,47,-61,86,-14,58,-69,-14,17,3,-4,93,123,-42,-85,97,-10,62,-17,-101,-79,84,78,85,65,63,34,-112,-72,-26,-64,25,-89,-23,-82,5,71,123,-110,42,84,18,50,-120,62,-50,65,-70,19,-23,-80,119,-117,-68,120,-115,-25,73,8,-10,61,59,-80,-12,0,37,-102,-24,-102,105,87,-10,76,-74,-85,-62,-77,-110,-27,-32,-69,42,62,-40,-27,10,-72,-30,77,-27,-111,85,-124,34,100,16,-3,-124,-116,-126,125,-68,-94,56,-45,84,117,20,2,-4,93,-69,-94,-24,-3,14,69,-5,20,-75,-34,75,52,-47,53,83,-68,-17,-19,33,-81,90,-41,69,30,-113,-116,8,36,-87,-45,70,-114,-17,-20,-123,-19,-73,-107,85,121,-81,-120,64,-44,93,-100,-89,-23,-40,3,69,18,61,-25,1,97,-6,-111,-105,73,-112,52,-91,-11,3,37,-81,-113,32,-119,94,-74,-95,-105,-14,75,73,14,-66,-85,-62,18,-36,81,-6,67,99,72,-94,103,-77,-109,11,61,119,29,28,81,96,-94,90,-82,-126,123,59,80,122,92,10,76,84,79,127,71,50,58,66,-111,100,-41,120,32,101,-50,1,117,94,-106,0,19,-43,-118,38,97,-55,3,103,87,105,-127,1,-98,104,35,61,38,-71,23,-96,63,35,1,-90,-69,-25,-5,120,-42,-63,12,-118,36,122,-89,71,-23,49,-54,-112,119,-67,115,121,-108,-34,75,100,72,-94,55,95,-21,17,36,-47,27,-81,-11,8,-110,-24,-11,-41,122,4,-7,-84,-89,-33,7,67,18,61,-44,-26,-36,79,-59,71,-33,-115,0,19,-43,114,-68,-4,20,25,-110,-24,101,-5,-82,-122,-97,-83,-58,-11,-109,-110,-43,4,-94,-18,-65,-124,96,122,99,-56,103,-67,-124,35,-63,-86,-47,-95,68,63,-23,98,45,85,-85,36,67,62,-21,-115,-41,122,-29,-107,94,123,-83,-41,94,-23,-39,80,57,85,-25,19,5,38,-86,62,122,-73,96,85,-87,-48,-112,2,63,-85,38,125,-17,4,121,-49,-11,89,-21,-13,15,-117,49,73,-111,68,111,-66,-42,35,72,-94,-121,-42,83,-67,-27,-105,-102,2,77,117,63,-98,78,82,81,42,-127,125,-44,68,-85,113,-39,-43,94,-127,-97,85,-5,-47,101,-113,6,-114,125,-93,25,60,-47,27,-14,89,15,-47,-79,-73,-41,-8,21,-5,-84,-103,113,38,78,-97,-51,23,104,-94,-117,115,-114,-66,-73,-48,121,-3,-94,-108,37,-98,104,99,-101,-18,116,-107,34,117,18,-90,68,83,-35,-3,-18,112,14,44,23,-27,-45,74,52,-47,45,30,-39,-48,100,73,-26,-115,43,-12,-77,-82,121,42,-89,-86,-77,-92,-64,68,53,-101,-117,-21,78,74,-93,-126,-71,-3,36,-13,18,35,6,-43,-33,47,-92,15,20,25,-111,-33,47,7,19,85,-65,96,-96,-57,-49,-87,-21,113,113,-16,-77,106,65,-85,53,57,-127,113,48,81,-11,107,70,63,-113,121,-22,-55,-122,-125,-17,-86,19,103,-48,-77,-117,-79,-76,-15,-11,39,33,29,49,-120,-66,95,-103,-48,-26,54,47,-39,-34,74,-95,-97,117,-15,-40,-78,60,105,-81,-48,-49,-70,54,-32,-21,-108,13,-80,21,-6,81,23,7,84,100,-111,76,-114,125,-42,28,104,81,-89,-110,-104,5,-8,89,21,-5,-35,111,31,-64,127,-127,-97,85,11,-22,-128,-86,-72,-74,68,63,-22,-94,-10,67,95,106,27,65,-94,-87,110,-102,-53,-59,-88,11,-38,47,-86,-99,-43,-120,-16,-8,45,-93,-108,-54,82,5,-114,21,-8,113,-34,-55,-24,116,-89,58,-28,42,48,85,69,-90,-69,-37,26,-59,-78,43,-113,66,-121,-116,-57,-103,61,-89,-85,0,-100,-44,22,-24,71,-35,-44,-114,-103,-27,-47,37,1,126,86,69,-21,-64,-90,118,-106,36,-6,81,-9,-60,-103,-128,-94,13,84,-127,-90,35,109,38,-65,25,98,30,-4,-11,-109,30,110,-110,-15,56,-110,-51,-25,-82,-25,-110,-115,-62,21,-6,73,23,14,78,83,59,50,2,-5,-84,-39,-51,-53,-82,-86,-118,-77,68,63,-21,-38,88,-97,73,-50,-18,10,-3,52,-73,-31,-91,-93,72,-19,-69,-87,-8,127,-48,-49,-70,54,19,-24,-3,110,-119,-90,-74,-60,-114,-76,-1,76,-71,-87,33,44,-64,-49,-86,50,-94,64,-111,68,-49,-25,123,79,20,-128,-112,45,-97,36,-6,89,55,-21,-21,36,72,-94,-25,-13,104,-89,-36,15,-95,72,-94,-25,115,-120,-51,-101,-111,122,4,73,-12,-22,39,106,-106,41,15,87,42,52,-47,53,-105,-61,101,64,-96,106,23,126,81,-54,18,79,-76,81,93,-72,-69,-58,65,-26,-127,93,63,41,-11,-128,113,-41,31,-53,12,-53,-78,-9,102,3,90,-7,-104,10,77,116,81,-51,-14,-83,42,-59,18,77,116,96,112,56,25,-13,20,88,-94,-119,-32,112,123,-87,73,-79,68,19,71,-19,78,-41,88,20,-23,-11,75,90,54,1,-31,-82,-34,-3,-100,1,-96,-112,101,72,-94,87,109,-15,-23,-7,-91,36,7,19,85,-77,-88,114,106,110,-112,-53,109,61,-119,-66,-21,98,-121,61,-71,116,3,-108,13,58,79,89,-50,41,100,16,125,-28,-112,-115,-102,63,-48,74,91,-96,-17,-70,56,-76,126,-70,-60,-105,-86,123,75,73,52,-47,-83,71,109,-35,-99,-36,-119,116,5,-102,-24,-62,76,-83,-18,-100,89,-92,43,-48,119,-35,-126,74,93,-59,79,126,-24,-102,35,-53,-118,-124,12,-94,-113,-17,102,-10,15,-76,-70,110,-123,-66,-21,-26,97,6,-27,40,-51,35,71,-106,57,21,33,-125,-24,-37,50,125,-6,-55,69,63,110,1,38,-86,-41,64,127,-7,18,5,-8,-82,-102,-52,113,60,-53,-37,-117,85,104,-94,59,-114,-66,-42,122,41,-53,-63,68,21,15,-85,-67,-4,64,4,-104,-88,-30,97,-19,61,-38,66,85,14,38,-86,-23,120,-5,84,9,-14,-82,119,-82,-73,122,12,73,-12,38,-122,-120,43,46,21,105,10,52,-41,-11,-33,73,-98,-86,44,-123,2,19,-43,97,35,111,-6,89,84,-49,5,10,77,117,-9,11,64,43,68,20,127,-44,-70,20,77,116,-67,85,-36,109,2,-55,-89,106,-28,39,-47,-49,-70,122,15,-127,33,-119,94,61,82,106,121,-1,74,-70,-74,-18,20,-102,-22,-70,-65,-114,42,50,67,-42,34,84,104,-94,-21,-49,74,118,52,97,-81,-86,-99,-80,68,63,-21,106,-1,-119,33,-119,94,-2,68,-55,103,74,-112,68,15,91,-117,-43,-107,-35,-18,-63,-41,42,-48,84,119,-1,-21,-51,38,-8,-38,84,-91,123,-119,38,-70,62,-50,-48,-48,-108,42,-53,-120,-85,66,63,-21,-54,83,-101,20,121,-45,43,126,-17,-70,54,-13,-38,-51,74,81,69,87,20,-102,-24,-6,-119,-83,21,24,-127,42,28,33,-47,-49,-70,-7,-24,57,-55,86,31,10,-3,-84,123,-107,25,-108,13,74,56,-8,89,-11,60,-22,60,95,95,-19,127,-95,31,117,43,-62,-57,77,-59,-46,36,-102,-24,-6,-7,-67,-54,19,-114,20,-7,-84,-121,72,102,85,-107,94,36,-102,-24,-94,114,-47,-98,41,-117,106,-82,-10,-117,108,117,20,16,-88,-70,-69,-114,-124,-120,-90,-86,14,44,-47,-49,-70,-89,77,82,67,15,50,-127,126,-44,69,-83,-75,42,-93,-30,18,77,116,125,36,-22,-22,91,81,85,53,77,-119,126,-42,-83,106,14,-93,-56,103,-67,-126,110,107,77,-66,47,-127,126,-42,53,-113,71,126,98,12,-6,-88,-104,23,-78,96,-43,25,90,-119,-90,-70,109,58,-9,44,119,116,-122,14,-98,-85,-64,-45,111,-40,1,-125,-73,69,-112,-113,115,66,46,54,27,-55,94,-26,18,77,-25,-60,-4,-47,-107,-8,-22,27,46,-21,40,-121,12,-70,82,-114,-44,-100,77,-99,19,-102,117,-56,75,-41,4,106,47,-39,-46,-28,34,3,105,126,-19,-42,-88,-19,38,-55,-32,-10,93,46,123,-58,53,42,-6,-83,33,-69,-115,-121,12,-94,-33,-114,-107,-122,-117,-102,-96,97,-15,-108,-43,119,67,6,-75,-5,75,-18,-5,17,81,120,-94,125,20,25,-103,-114,24,-44,15,26,-40,60,-33,-47,9,7,73,-12,-11,7,-116,71,-17,-11,-44,-15,127,-122,36,-34,-75,-73,-18,80,-92,-69,-21,-99,63,-123,-90,94,-69,67,-94,-3,-88,44,-32,36,-47,60,-58,-80,35,-47,-112,74,-10,100,-111,104,-86,59,-102,11,114,-40,-72,-51,102,-113,104,101,-127,39,-38,104,40,102,-114,-29,14,-42,126,-116,66,19,93,-92,-121,-71,19,120,-104,43,-20,-115,72,-1,48,98,16,-3,-66,-113,-96,-85,-12,-91,-46,37,72,-94,-121,-13,-62,-82,126,-72,46,-59,-94,-64,36,-98,-121,92,-63,-71,119,-125,88,-38,-15,22,96,26,37,116,119,36,87,43,-118,36,122,102,38,-50,57,-69,71,-54,-53,20,104,26,35,61,119,-108,77,-74,102,-110,-85,81,-85,-48,68,-73,121,-92,30,-81,12,-7,-84,-89,-9,65,25,-14,-115,-34,-37,-21,19,-79,-20,-85,-35,-8,30,-23,45,72,24,-74,47,70,-51,45,17,-125,-24,59,107,25,72,121,-67,4,73,99,-17,111,-11,8,-110,-24,77,-113,-46,-15,48,-122,36,122,-53,-93,-58,-47,-69,92,86,4,-104,-20,100,-92,-93,-38,27,-36,91,28,4,-103,-43,10,77,116,-19,25,-7,30,-77,-95,-82,64,19,93,-108,-9,118,13,19,67,93,-127,-90,59,81,-66,-51,52,-6,-67,-11,-106,-108,13,25,17,-120,58,42,68,-20,80,-76,-89,92,-86,121,-96,-122,-45,-99,57,-9,-94,-27,-39,10,-118,124,-93,23,-20,-14,-35,-112,-49,122,122,86,97,-56,71,61,125,-82,-101,34,-97,-11,116,-44,-114,33,-97,-11,80,-8,88,-26,-98,10,-16,-77,42,-50,-106,119,-103,-9,-91,-48,-49,-70,-25,81,-6,41,-3,26,-123,126,-44,-19,-26,126,-98,-22,96,-88,2,19,85,-65,-18,116,-44,107,-110,-103,-34,2,-4,-88,-38,-48,-51,126,-55,-50,103,10,-3,-84,123,-94,36,-123,-86,-44,44,-47,-113,-70,-88,-70,-97,-117,10,127,72,-12,-93,110,-66,-84,69,-103,-73,-92,-48,-49,-70,-7,-104,115,-56,60,86,-123,-90,99,-84,52,-25,48,-40,11,54,-65,62,-99,82,59,96,60,-114,97,108,-123,-98,67,-6,69,10,77,116,-35,46,77,49,103,24,75,-77,-100,117,4,-102,-82,49,57,-105,-22,-63,114,114,-28,96,-70,46,-98,47,37,9,-14,89,79,-69,43,12,-7,-84,39,-49,125,82,36,125,59,-91,46,55,68,-78,125,-30,50,107,85,-29,-97,71,84,-75,85,-66,-53,99,53,10,77,-65,-80,94,-99,127,91,18,34,-110,75,85,106,12,25,52,-85,104,-83,-28,124,92,115,123,-52,-8,81,-25,118,67,6,-47,55,-121,-71,-91,61,94,83,-52,100,-65,126,82,-6,1,-125,100,91,-7,55,-113,16,-16,76,-46,-8,82,104,-94,91,-114,110,102,-21,-2,-14,81,-82,-21,-100,-86,-118,77,-56,32,-6,126,46,-60,-79,-119,-91,-86,-64,41,48,85,93,-75,-17,-39,-107,-91,-52,-81,63,105,105,-55,32,-6,-34,-101,-79,15,100,-116,-91,-74,127,36,-102,-24,46,51,-81,-85,-21,81,-119,96,89,-107,91,-73,1,-127,100,18,102,-65,-2,102,56,14,50,43,66,-95,-87,-18,-25,72,-75,65,16,-115,-19,-120,65,-12,-69,61,48,-25,44,-76,113,-3,-94,-44,37,-98,104,-37,3,52,79,-46,-75,-18,75,95,127,82,-22,1,-125,100,-80,-26,-49,-58,-64,-67,94,-65,-88,4,86,-119,39,-38,120,100,121,-81,118,103,38,-16,-41,-97,-108,122,-64,32,-6,102,56,12,119,-97,-38,-65,-25,88,-94,-23,-29,10,-111,34,65,62,-21,105,95,-119,33,-119,-34,116,113,-71,72,-113,32,-119,-98,-117,-89,-61,-97,80,-33,4,67,-34,-11,112,-58,-71,-72,78,66,37,-56,-60,82,104,-94,-21,-65,-10,72,-109,32,-119,94,121,-83,71,-112,84,111,101,119,-14,20,-56,-21,39,-83,43,25,68,-1,-61,-17,-45,49,1,-122,36,122,-51,-65,77,29,9,101,72,-94,-25,-29,123,65,6,56,67,82,-67,49,-53,-34,2,-80,4,-55,-22,10,77,116,-3,87,54,-38,21,-37,84,107,-116,66,19,93,31,-20,11,78,-17,51,-28,27,-67,-106,-46,-53,115,80,-1,-125,-90,-70,-10,-63,37,23,-33,13,-58,-110,64,-33,117,-3,-55,-79,72,-109,33,-119,-98,45,89,115,-71,85,44,-46,20,104,-94,-21,103,7,76,22,43,-53,-25,-86,-48,-81,116,-33,107,114,-67,-75,-38,126,80,-28,65,-109,-94,-119,-82,-51,58,101,-10,-2,82,87,-96,-119,110,125,125,-1,4,73,-12,-38,107,61,-126,36,122,31,-77,14,-6,112,-53,-28,4,-119,126,-42,-59,105,87,-19,32,40,52,-47,-75,-103,103,-18,5,-43,48,-95,77,-101,45,-91,-76,38,16,-11,117,91,-45,-78,-20,31,47,-47,55,-35,-113,-38,65,8,35,-26,60,101,-91,85,-123,-90,-70,-13,108,110,87,-86,-93,-110,-22,82,-71,-67,33,-125,-24,35,-11,-63,109,36,-76,14,-109,121,-86,82,-88,1,-127,-88,-41,-93,-27,54,-9,107,49,-25,-71,106,-37,32,100,16,-3,126,-108,-47,-99,-109,-107,15,29,25,8,-16,68,-37,-81,-128,-91,31,-75,118,85,-61,64,-94,-97,117,27,66,-61,-14,101,114,48,87,-99,53,59,-33,-66,-40,87,-112,100,61,-44,-120,65,-12,-67,-89,-116,78,-63,-93,43,-25,87,-94,-119,-82,-1,-62,-14,64,-78,-124,56,21,-95,-64,84,-43,6,-116,-13,122,-80,-67,91,-85,-86,-114,16,50,-18,-6,62,111,6,-47,-91,-110,-106,44,121,-89,-48,84,-73,33,64,-66,-93,-45,81,-121,108,-30,30,50,-120,-66,-113,46,-95,-128,103,81,15,-101,99,-119,-90,-9,18,82,80,-36,-109,32,-97,-11,-58,81,100,-73,79,5,38,-86,56,5,-41,-9,-62,-39,-120,-66,-81,-77,-88,21,43,100,16,125,-5,-89,57,92,36,-74,-32,76,-90,-20,-115,41,-15,68,27,29,-64,125,-72,-44,-84,-66,83,-99,70,8,-16,119,109,36,-48,12,103,-26,32,127,77,87,127,-42,120,-94,-99,80,35,127,-65,71,-52,-65,-25,84,-59,-51,35,2,81,-1,-40,-101,40,71,-19,69,-59,-52,36,-6,89,23,-25,-38,-12,106,-85,-48,68,-41,62,-5,-113,-107,-45,-106,-22,30,12,-18,-120,65,-12,-99,53,-104,-111,101,90,101,-103,109,1,126,86,-67,26,33,-88,124,36,-119,38,-70,-35,35,-27,78,12,69,62,-21,-39,127,-90,-91,-22,-78,73,52,-47,29,30,-119,120,121,85,-15,77,-119,-90,-70,-74,-34,-44,29,92,-80,-36,-88,-35,-6,-120,64,-44,-89,-65,-114,-96,-40,52,65,62,-21,-23,90,-71,12,-7,-84,103,-93,-70,45,-75,115,42,-47,-49,-70,65,-35,110,-126,36,122,102,112,-52,-67,20,-64,117,67,83,110,-101,69,-124,-69,122,57,-3,53,-104,113,-89,6,22,-123,18,-59,-4,-7,-3,5,-91,-48,111,72,-94,-9,49,-69,5,-91,-43,9,-110,-24,121,15,-8,76,81,118,-78,68,19,-35,121,-28,-66,119,-102,46,-26,71,-32,23,-75,28,4,4,-86,-34,103,-23,14,-35,-66,-2,-92,-27,37,-29,-82,-113,-34,53,-35,79,-13,-13,-6,69,-51,5,1,-127,-88,95,-115,55,-110,-77,99,-50,-81,63,41,-7,-128,65,-12,-67,-117,-110,80,109,-81,-88,83,54,18,77,116,23,-38,30,-20,-114,32,-78,-99,-19,23,-91,44,-15,119,-19,118,30,107,-20,-51,66,-54,117,-124,65,-99,-115,10,-16,68,59,-31,-80,-123,-77,-66,-82,-29,23,106,-125,51,34,16,-11,98,-10,-41,-89,-71,-113,95,-108,-72,-60,19,109,-5,-34,-122,-49,82,-122,121,-125,-97,-108,122,-64,32,-6,31,-39,53,13,99,86,122,54,10,77,116,111,-34,102,-82,77,78,-47,10,77,116,49,-94,-22,-34,51,4,30,-14,-11,-109,-46,14,24,84,127,-71,-46,-53,-16,-17,-105,-84,85,28,-32,-17,-38,-3,35,-113,96,30,99,73,87,79,-128,-119,42,-126,63,91,-115,-121,82,-125,22,52,20,75,52,-81,1,-77,-41,37,68,80,-26,-6,73,41,7,12,-94,-113,-118,70,-82,-83,25,-10,-7,-81,-97,-108,126,-64,32,-6,29,117,21,-9,47,-84,-74,-81,-107,22,-107,-68,38,16,-11,101,79,-15,116,-31,-80,126,-3,-94,38,-40,-128,112,87,31,87,11,119,31,107,-109,9,-93,18,77,116,97,-97,-72,-67,114,-101,65,-15,-117,82,-106,120,-94,109,-122,112,-51,110,74,-69,42,-68,102,57,7,70,12,-94,-17,-125,76,95,-89,56,25,-81,84,-24,-69,-18,60,-31,114,58,-101,-93,-23,-34,42,10,77,116,-77,125,-83,62,97,67,59,83,2,76,84,-51,92,-23,-45,125,3,77,91,-109,10,77,116,-3,-6,-33,116,99,21,-122,36,122,19,-99,-43,-10,105,70,-105,127,80,96,-94,106,-2,-16,-114,-78,-89,-90,36,9,-14,-82,-9,-79,-13,-41,-75,63,-58,-112,84,15,121,74,59,80,110,17,43,48,81,-11,-53,0,-6,-122,-22,115,-108,18,77,116,-3,-119,-86,-82,-69,120,48,36,-43,115,127,89,102,-51,83,36,-47,-13,-66,75,71,-111,28,89,-60,91,-94,-33,-24,-54,-5,38,-56,103,61,-3,61,50,36,-47,-85,-81,-11,8,-110,-22,-51,-26,-29,119,-79,38,69,19,93,52,83,59,-33,-54,114,48,81,-11,89,61,-111,36,65,-34,-12,-48,-92,-53,-36,-92,-46,95,105,74,52,-47,69,-121,-114,82,-33,-22,10,52,-47,93,-40,-52,124,-7,-74,36,-102,-22,-82,-28,12,-65,88,-106,-127,-17,-86,31,-69,17,-127,36,67,18,61,28,114,90,47,-81,82,-128,-119,-86,-103,118,-75,-65,27,86,10,76,84,-51,29,76,46,-107,52,82,-27,-32,-69,-86,-7,-127,109,-28,119,73,-124,10,76,84,-15,85,-5,-59,38,80,-27,96,-94,-38,-34,-66,125,-122,36,122,-3,-75,30,65,18,-67,113,-116,-2,-6,89,114,-16,93,-43,92,83,-20,-10,-66,83,21,96,-94,90,-114,57,-21,120,-87,-54,-63,68,-43,-106,65,-5,-102,-33,101,104,74,52,-47,-11,-34,58,114,-6,70,-107,-3,-62,21,-102,-24,126,100,118,20,101,67,80,-28,93,-81,122,-69,-51,28,-102,14,71,64,104,42,-12,-93,-82,-71,5,83,-34,61,-57,62,107,-94,-8,104,74,47,-81,-11,-65,-47,-49,-70,-56,-46,87,71,-106,20,-8,81,21,-123,-16,87,81,85,-105,36,-6,89,55,-37,59,80,97,75,5,126,86,53,-61,-87,55,-39,-5,91,-95,-97,117,-91,13,77,-111,-49,122,72,-116,73,-86,-66,-80,68,63,-21,-38,92,-73,-90,-86,-107,34,-47,-49,-70,-56,-13,-108,117,35,37,-6,89,-41,-20,17,51,-65,85,79,114,-123,126,-102,95,80,32,-80,-88,93,83,-127,125,-42,-84,71,26,-86,63,-119,2,19,85,115,-118,92,-96,14,-91,101,106,-55,-22,24,81,68,-96,-22,41,-43,-67,51,37,10,-39,-52,41,-101,41,-121,12,-94,95,15,100,-28,109,96,51,-85,-50,49,-28,80,14,8,68,61,99,-69,125,-61,102,-100,58,30,-22,-12,86,-128,39,54,-61,60,-26,112,101,-126,-52,-42,72,-85,-86,-108,-111,-120,64,45,-100,-26,-6,-37,-93,40,-61,26,73,-107,-20,-119,8,68,-35,-18,-45,109,70,87,100,-90,-55,-72,120,-128,-89,118,105,78,101,47,-105,99,-85,122,105,83,21,-97,-116,8,-60,-106,94,-56,-114,116,79,17,-75,20,-26,-110,115,84,-60,32,-6,-19,58,-56,-80,-125,-19,37,-75,-70,-44,91,13,8,68,-35,-4,-6,-102,119,-37,-15,58,-20,-40,-28,-119,-26,-112,65,-12,81,-21,-3,-36,99,-45,-88,54,105,-66,-113,-54,-12,11,25,-60,55,-60,-111,-90,-67,-56,82,67,-47,1,-11,53,41,52,-15,-27,-121,125,119,-45,-41,117,61,-47,111,64,61,-10,-112,65,35,16,102,-96,-18,67,12,7,-53,-118,106,118,16,-32,105,84,103,-91,-22,46,-60,-34,-39,-108,121,-101,26,-49,35,101,105,63,84,86,-1,-78,-73,17,-60,-53,56,-98,70,94,-13,-38,55,97,-82,-14,-52,-89,-22,98,25,-32,-119,-74,-81,69,-87,-49,-4,80,-28,75,-67,-33,-2,-26,-69,31,-65,-4,-12,-61,31,-1,-4,-13,-9,63,-4,9,-16,63,124,-7,-2,-9,127,48,-7,84,112,-18,-29,-33,-65,-1,-35,-49,127,-8,-6,31,-41,-33,-2,-29,-9,127,-6,-14,-49,95,126,-1,127,-65,-4,-23,-25,-97,-66,-5,-89,127,-95,73,-92,-66,-20,89,-26,73,16,12,37,-110,82,-1,118,-67,111,127,115,-51,63,-61,-60,35,-45,12,37,118,51,-1,118,-67,111,126,115,126,124,-92,-109,111,54,80,20,-67,-71,119,122,-23,28,71,54,-61,99,-5,38,-42,-76,111,98,42,19,32,34,-36,-43,19,102,75,23,92,91,35,31,-26,-51,-85,18,43,33,-29,-82,-113,-12,-60,-22,114,65,109,89,57,-102,-52,-118,-119,8,119,117,68,30,-50,-78,95,74,109,71,-106,-119,-48,1,-98,104,-49,-85,-125,-27,22,36,91,102,46,-41,113,42,3,38,100,-36,-11,43,44,-75,-68,-105,-32,92,102,76,-91,-84,18,95,35,-62,93,-67,-39,-30,50,-37,126,52,109,-39,-109,93,93,-71,2,17,-31,-82,-34,-19,-17,118,55,79,-81,-124,-35,-39,-84,-44,3,-62,93,29,-121,-111,125,3,-114,-107,-110,121,38,-54,6,-120,8,119,117,91,98,74,61,-13,62,8,-52,-17,49,-49,68,-123,76,66,-58,93,31,-35,-37,102,-35,77,-110,-123,-90,-16,77,-7,-117,17,-127,-88,-69,73,99,46,57,-69,80,-28,75,-67,111,63,117,38,-73,79,-37,-60,-44,-55,80,124,-22,-4,5,122,-33,-2,-26,124,19,-126,-58,55,78,41,-118,-33,-36,75,61,-100,-74,109,-37,23,-43,-47,-62,85,122,-122,1,-98,106,111,87,-48,-51,-24,109,83,101,-5,43,48,81,-19,-121,-3,-71,-35,-115,-23,54,-4,-42,58,85,-15,-7,-112,65,-12,-35,-21,54,-38,81,-85,74,-80,81,96,-94,58,109,-22,-38,-93,-37,-93,-96,73,-105,74,27,15,-16,100,-128,-70,80,-47,40,-63,-128,39,-56,-105,122,-33,124,-64,-9,-7,-47,-8,-102,71,-27,25,-118,-5,112,-81,-12,-52,91,-76,-127,-27,-86,-114,32,-3,-81,-101,-33,42,-122,79,-56,-72,63,-68,-110,62,103,11,-11,-118,25,-14,-82,87,51,-94,23,30,103,-122,-109,-14,54,3,-4,93,-37,-100,-109,108,-85,68,-33,-97,90,62,114,82,93,114,35,2,81,-17,-2,125,72,-5,-100,34,95,-22,125,-13,97,-71,124,-70,126,-49,-12,98,40,-118,-34,-36,91,61,-108,78,49,27,111,-97,76,46,15,89,-68,-25,-120,64,-44,-21,-43,63,123,-61,-42,19,-83,-21,-124,-95,21,-32,-119,-74,75,0,25,-70,-16,37,69,-66,-44,-5,-10,-81,-39,103,-121,95,-121,52,-56,-59,48,20,-65,-71,95,-96,-9,-51,111,14,-19,3,-4,20,78,-77,124,56,76,-72,-125,127,-109,34,54,117,-21,84,-79,43,-119,102,-70,-34,60,-72,-114,80,104,-33,85,-96,95,-24,34,-120,-34,84,67,20,13,103,-54,-74,94,-113,-3,-40,37,18,113,-50,-90,-6,-57,71,4,-94,126,29,-87,78,-53,79,44,-67,-55,-82,-45,33,-29,62,78,-31,77,-100,-25,-98,-127,-37,39,-54,95,12,113,-11,17,-31,-82,-114,-28,-56,-44,-10,74,34,-3,-22,-39,-83,-36,-7,-120,64,-43,-45,94,-8,107,-92,110,-114,-99,-116,91,7,120,-86,-67,-42,-66,1,48,-46,-41,95,-76,-74,-64,-109,103,-114,67,-32,-55,97,-121,121,-45,-86,34,127,-128,39,-38,-13,74,127,-39,103,116,-100,-121,89,106,-17,42,34,-16,-81,-88,-12,-75,-89,16,-9,-79,-20,-101,83,-75,-33,66,6,-47,47,21,-5,8,59,-72,94,-39,-49,74,93,-30,-119,54,-62,126,117,109,55,-118,108,-87,-77,-85,61,-55,-120,-64,-62,110,-29,48,55,102,-117,41,32,25,-79,103,-23,96,-123,12,-94,-65,-112,112,-66,127,24,87,-34,-11,108,42,-124,18,16,72,88,15,13,37,-38,126,94,-24,74,22,-105,7,94,34,2,81,-49,87,-27,-118,-79,-125,-53,-47,-58,84,-5,-75,33,-125,-24,-29,112,73,-38,103,-68,43,63,-39,126,81,-14,-102,-64,66,-98,-74,118,-25,-67,11,-23,53,93,-85,61,-119,0,79,-76,91,58,86,25,110,-120,-95,105,-120,-4,-100,2,2,83,55,-121,-58,101,-26,35,-39,-64,124,120,-107,67,20,50,-104,-66,61,-58,-110,-10,59,69,-26,127,-43,-49,93,19,-120,122,71,105,-47,-3,82,38,74,-16,-88,61,-43,0,-49,-76,-57,81,-5,94,-89,-60,12,108,51,-77,-43,-12,30,17,-104,-70,-13,4,-122,125,43,102,82,-53,-79,46,-48,-4,-86,81,80,100,-9,4,6,-70,36,-55,-25,-83,9,92,-35,25,126,-46,-45,-31,-48,-73,-118,127,-115,17,-4,-37,-1,31,-6,59,12,-92,108,-33,2,0]},{"id":"798b6eff-5499-4155-8fbd-532e54b53c81","playerId":"11e178c5-8e89-432a-978e-fc95fd17f8bf","localPlayerName": "Kirjava","sequence":6,"gameId":"5a2376c6-3285-474c-9896-ee66829b77c2","timePassed":0,"sentence":"cat about to jump into the snow off tin roof."},{"id":"bef6f65c-8bab-4e40-94d4-0f992bf18382","playerId":"11e178c5-8e89-432a-978e-fc95fd17f8bf","sequence":7,"gameId":"5a2376c6-3285-474c-9896-ee66829b77c2","timePassed":0,"drawing":[31,-117,8,0,0,0,0,0,0,0,-75,93,-37,-82,36,-73,-111,-4,-105,121,22,8,-34,47,-6,-115,5,-10,-59,-16,-125,1,15,-92,1,-28,17,96,-115,-31,93,24,-2,-9,-51,-84,89,67,-52,98,68,-98,-42,-23,62,47,2,116,38,35,-70,-118,69,38,-13,-58,-28,-97,-2,-11,-23,-105,47,95,63,-1,-41,-25,-97,-2,-10,-7,-21,-73,-33,62,-3,-8,-89,127,125,-6,-19,-37,95,-2,-2,-19,-45,-113,-1,-6,-12,63,-1,-3,-105,95,-2,-15,-7,-45,-113,-87,-73,16,127,-8,-12,-65,-1,-1,-65,99,-51,16,-1,-3,-61,-89,-49,95,-1,-6,-90,-44,-65,127,120,-118,-81,-42,-75,-22,-17,-110,115,-116,16,-21,-86,-107,-13,82,4,-32,95,-95,-81,-40,55,-31,85,-61,-20,-83,49,118,42,127,114,-113,26,82,109,99,-4,46,-68,-30,10,51,-83,76,-56,29,0,96,95,33,-11,-36,-74,-9,92,-71,-55,-61,13,70,78,-27,79,-18,89,66,-53,-75,-50,77,-74,-26,16,-41,88,-124,-36,1,0,-10,17,-26,90,115,127,-51,38,-81,-39,123,98,-20,28,112,-78,-81,28,-14,24,-83,108,-62,-14,-22,57,-26,-50,102,-116,-121,0,-4,53,-84,82,-29,-10,-86,41,-58,24,98,-92,115,-58,67,0,126,121,-39,-44,86,-37,-91,115,12,61,45,-54,-17,32,0,-1,10,53,-58,105,-98,-90,38,-111,-50,108,90,122,-120,-125,63,-21,-101,-19,-110,61,-54,122,-52,100,-30,80,105,-64,-101,66,90,-26,25,-58,12,109,20,-54,76,-27,-31,51,-105,86,-58,46,-68,90,24,-115,125,82,15,-16,-26,-120,-92,36,43,-93,-77,-81,73,-91,-33,-26,-51,35,-28,-34,-5,-125,-68,-1,-111,-122,51,36,-114,-70,-53,-106,21,74,97,35,-19,-56,99,-18,93,-78,37,121,10,-121,-9,-108,-123,-100,83,-34,39,-17,-78,50,-113,102,31,116,-59,59,-120,-73,-57,121,-24,28,109,68,-49,82,105,-56,-37,-37,-66,-105,-92,52,115,-104,-18,-84,99,0,-72,94,-52,115,-56,-4,92,35,21,-66,90,-96,52,-32,-51,-95,-106,-76,79,-3,28,69,1,-51,70,-87,57,0,-78,-49,57,-53,46,-100,70,40,121,77,-50,-50,0,-128,-67,-104,-73,-52,89,52,115,75,100,-106,80,-23,63,-64,-5,-25,31,62,-3,-3,-13,111,-65,-2,-14,-113,111,95,126,-3,-86,-112,-97,63,127,-7,-23,103,-7,-103,84,-110,-52,-66,127,126,-7,-21,-73,-97,-65,-1,-49,-11,12,111,-101,97,-91,-34,-52,-90,-123,-52,38,40,5,95,-14,65,-66,86,100,-26,-51,-68,111,-111,-14,-50,57,-75,66,-66,-70,-117,0,-4,-14,20,-94,-101,-115,113,34,-109,125,-110,-81,-18,-56,3,110,-79,44,-29,76,-101,104,105,-95,-55,-102,36,122,-57,3,-100,-20,61,-87,-7,-73,-101,-101,75,94,-67,-90,21,-119,-126,112,17,-128,127,-24,63,-19,27,-39,26,89,-10,94,-94,35,28,-7,-109,123,-108,48,-57,74,-101,-31,-80,-106,-24,-127,-39,-40,-80,59,-128,-109,125,-54,-96,-83,-71,27,-100,41,-106,28,-118,88,-122,-124,-34,67,-100,-4,-14,-53,-71,-92,98,-74,-8,38,11,47,51,-3,-23,34,0,127,83,-101,-74,-20,-101,-124,108,115,-95,83,67,-49,69,0,126,-39,-124,-54,-78,-46,98,-118,22,-103,-41,-116,-33,65,28,-4,53,86,49,28,-122,49,59,83,-100,97,37,-74,-31,-70,8,-64,63,101,-109,-97,-26,105,-110,40,62,110,-110,-71,-120,-109,95,22,116,91,101,24,105,89,40,-77,52,-58,-17,33,0,127,23,-121,-88,103,-77,-99,-10,46,-101,117,33,27,-126,-117,56,-7,-117,-4,-78,-24,60,51,-102,-77,-121,62,18,-15,115,92,4,-32,-105,127,105,-35,-68,-84,122,26,125,-110,-23,-23,1,0,-5,8,99,-60,101,118,109,-79,-112,90,-91,-20,28,0,-40,-89,110,5,-75,25,105,-15,-46,7,-101,-5,46,2,-16,91,-45,81,-112,65,108,48,54,111,-104,-12,-55,91,-59,-72,107,-43,-40,50,-30,68,-41,-107,-39,99,59,0,-64,-98,66,21,91,-58,72,-53,-80,-54,-58,-64,102,-116,-121,0,-4,-39,-66,103,21,-121,40,71,-90,13,-104,-12,-37,-68,-94,83,-13,74,-113,-14,-2,71,26,-16,22,-103,82,57,-19,-21,45,119,49,-75,-26,-92,-36,14,2,-16,-73,-112,-13,-52,-29,-10,52,105,20,-78,1,-70,8,-64,63,110,35,-40,-103,25,-122,69,31,101,124,-71,-107,121,57,-99,91,-116,75,-116,108,20,-100,67,82,-40,-31,122,-120,79,109,-7,50,-30,-66,-58,-57,-92,1,68,42,125,-14,102,-15,17,86,29,-13,49,94,38,125,-14,-22,76,-106,-51,-73,-18,-110,75,39,32,97,-26,-14,39,-9,104,-22,-10,-9,109,-90,13,49,47,-78,-24,83,66,-18,0,78,-37,67,-36,-67,125,-36,-60,-80,96,54,13,-110,60,-7,82,21,-115,25,-13,-2,-119,99,88,101,46,102,99,59,-128,-109,61,-85,93,88,122,-79,51,-88,100,106,72,58,-128,-109,93,-12,101,-110,29,118,15,24,71,85,35,-87,-80,-121,-9,16,-64,23,-101,106,52,-105,61,102,28,-27,-61,-56,-33,25,-65,-121,0,-2,-115,56,-45,-75,-75,93,88,54,122,49,-74,-104,3,-30,0,-128,-1,33,54,-49,-88,125,-18,-46,26,78,47,-44,-67,-31,0,-32,-127,-88,-47,-48,-110,17,-98,106,-112,71,54,31,61,4,-16,65,74,80,51,-60,76,-124,37,106,-125,-70,-83,14,0,-80,79,-79,7,119,115,118,-90,72,29,109,34,12,-3,-114,17,-53,-18,-63,121,-76,76,26,-40,-21,-14,21,82,-99,-9,87,43,-87,-109,79,-23,34,-128,61,93,-60,-18,40,-69,-83,-93,-46,108,-61,99,-46,-64,-106,107,118,-17,-32,-100,72,-14,65,-66,-41,111,-95,98,-80,-102,-64,74,-127,91,40,-110,-62,91,-24,67,124,77,-10,46,-79,-13,119,-51,-111,68,-103,-120,-111,-126,89,29,-7,115,-32,-110,120,34,57,-17,65,-105,41,30,-105,-40,110,-28,115,112,121,-96,-60,-44,-13,20,-125,-34,-54,-78,73,-49,-92,-63,-58,36,27,65,30,-9,23,28,-117,37,-125,60,-64,-71,73,-53,-26,-35,75,-101,-45,10,23,-7,15,-37,-91,61,-60,-55,-33,-61,18,-89,115,-103,-121,-23,94,24,-41,1,-100,-20,109,-33,-39,103,26,-44,34,2,-126,-24,89,-93,-3,85,-58,6,4,31,99,123,-7,26,29,-58,-17,27,-102,-111,62,31,5,9,-63,23,123,-120,77,118,-127,-42,-21,110,2,-10,-66,-62,-100,44,-7,-26,-56,31,-36,-102,-89,-109,-43,-75,-53,-86,47,56,34,89,-96,-114,60,-80,-11,-21,61,-55,-40,-93,-40,112,-67,19,87,-55,3,0,53,40,-70,34,-82,125,-89,105,67,118,-30,-55,98,-13,30,-32,100,23,-69,123,-54,14,-66,45,-70,86,-59,-114,21,51,-126,-80,59,0,-64,-66,-62,106,-77,110,-61,-40,-82,-89,-93,-7,50,7,112,-78,107,124,114,-91,125,2,-120,-15,19,-94,120,-29,-124,-35,1,0,-10,-87,-26,-50,-82,-114,-102,108,-6,-87,49,7,-40,3,-128,-30,10,-47,-55,61,-10,109,10,-44,43,87,-51,-56,-71,60,-32,78,-94,-22,-82,117,-1,-69,-84,108,46,50,-84,44,-115,-19,33,0,-65,73,-23,-44,89,-59,117,-101,108,-66,16,97,-56,58,115,-33,43,25,-86,-88,-115,82,59,81,-24,30,0,22,-53,-12,94,-10,42,-116,42,94,97,41,78,57,-117,-125,0,-4,67,63,126,-77,-62,-76,-66,7,11,3,-42,-87,49,-84,105,-98,-95,-124,-106,88,-104,-44,3,-128,50,-103,20,102,41,101,-105,-19,-6,23,102,17,121,0,-64,-34,69,-93,-51,-42,-20,-25,-23,85,84,5,-93,119,16,-96,84,70,31,70,-68,-87,125,114,-107,-48,-13,100,-2,-111,-117,0,-4,-30,58,-107,-68,-5,-31,117,-82,32,-10,15,-117,-61,-70,8,88,-52,34,-69,-41,110,2,-42,-43,67,43,-78,16,121,49,11,69,-128,-120,-111,76,-78,18,91,-34,-43,81,13,93,20,56,45,-125,112,16,32,114,-92,10,66,-10,-83,93,-103,54,-39,53,-25,100,22,-104,-121,56,-7,75,21,123,112,87,73,45,15,-79,6,27,53,-16,28,0,48,-94,90,72,113,-18,91,112,107,61,-116,-54,66,-77,30,0,68,-88,-90,-26,49,-69,-39,-126,101,-49,-105,-35,-127,69,-88,56,0,-104,-42,98,77,-43,-79,59,-30,93,62,93,-101,-99,5,-41,28,0,-120,127,-55,-108,50,31,-87,-25,124,109,108,52,12,-58,1,32,94,21,-125,44,-73,-79,-83,-63,-82,-114,86,-30,-103,67,15,1,-8,-89,44,-72,57,-115,81,40,86,126,-102,52,30,-58,1,32,30,-42,67,22,-60,38,59,-82,34,68,22,12,99,-30,32,18,-90,-71,-48,-79,71,108,-5,18,117,21,-41,98,-34,-104,-121,0,78,-92,12,89,-36,-14,-10,98,-55,-122,-36,7,45,34,96,-30,32,10,22,117,-53,49,-111,-37,116,-3,-119,113,59,0,-64,46,59,122,-102,123,-34,117,-92,-21,79,100,7,-12,0,32,-58,38,43,-72,-20,-15,-72,33,42,67,-1,-62,34,108,84,30,-58,-41,-26,-22,-5,-68,21,-63,16,7,91,-91,30,0,68,-62,100,-119,-51,-68,103,-73,70,45,106,15,-46,101,-22,33,96,6,94,21,-13,-2,48,90,-74,18,99,101,-111,89,15,1,34,110,-70,-41,-113,-35,27,31,106,-124,-10,-60,-12,-128,-117,0,1,25,-79,122,106,-36,-75,-46,-72,-86,-51,-40,-68,-15,0,48,-1,62,-57,-38,-121,82,-85,98,27,43,-101,113,-28,1,-73,-6,12,-69,-111,50,-90,-50,-70,-76,88,30,-43,1,-128,8,95,14,125,-107,45,21,-83,-47,50,45,-18,-93,-55,101,14,-128,-71,-21,106,-62,-49,41,-80,-116,15,-111,-123,-103,78,121,21,19,-110,-105,-11,-100,-103,-111,-22,-56,-61,-100,97,-99,-83,-104,-112,-109,76,-77,65,63,-92,3,-8,99,-20,47,15,-40,-44,108,-14,-120,-75,65,-113,2,74,-111,105,-11,8,-97,-42,84,-119,86,-68,-7,-68,107,54,-10,-39,61,0,96,111,-70,19,-17,-62,-78,-110,70,-119,52,119,-26,0,0,-69,-52,64,107,48,-106,-92,42,-104,-110,83,121,88,63,-42,83,-33,43,-39,-102,76,-52,76,43,-123,61,0,-40,91,-110,24,88,38,54,-35,52,-43,-82,127,98,-101,-117,-125,-128,-69,-53,-76,111,-38,115,24,52,27,-30,-56,-125,25,88,67,21,47,99,83,-122,77,20,-83,-122,31,-40,68,-28,0,-88,-127,100,-53,-23,86,86,-117,-2,-72,22,34,-14,39,119,75,-78,69,-12,-3,11,-23,100,-90,-11,45,84,-4,100,22,91,127,-76,101,60,-81,54,-60,89,-118,-116,-37,1,-100,-20,-77,-22,44,53,-97,-89,69,45,-9,-93,91,-118,-121,56,-7,87,85,39,55,-103,-112,96,22,115,113,-79,-94,34,7,112,-90,109,116,95,-104,45,-101,101,39,-8,54,-56,100,-12,0,-128,93,54,79,-15,-22,-116,-58,104,-95,115,119,-57,69,0,126,-83,75,-84,102,-35,105,-42,97,37,102,-41,-69,-120,-109,63,-103,-30,-12,22,103,24,-30,-109,-78,-95,97,-46,111,-13,-54,92,30,44,-101,-59,-124,-63,104,-56,15,-22,-79,-115,61,-126,-95,115,-127,127,75,14,0,-20,-78,40,86,-50,123,124,100,-118,119,87,35,-85,86,112,17,-128,95,52,67,-102,-69,105,81,85,-83,46,113,2,24,-65,-125,0,-21,40,-117,86,-21,-29,22,-68,-69,-2,-60,22,-110,-125,0,122,-96,-85,-49,-65,-25,-61,101,-102,-55,-18,88,88,-58,-49,69,0,45,-74,-44,105,52,-15,-63,118,-3,-119,-47,59,0,-64,46,-69,97,54,-63,59,-83,-114,-53,-52,31,113,-28,79,110,85,-52,43,-18,-23,-98,42,-6,-82,-81,-58,42,-43,93,4,-32,23,-27,41,-45,120,31,71,77,-102,-120,74,98,67,-29,33,-32,-50,-108,83,54,-17,42,-82,81,97,-89,41,29,121,88,-19,-70,90,55,113,112,-39,106,-60,-101,73,-44,-78,119,16,-48,-105,18,23,119,95,-31,-30,-62,-113,25,-23,-34,-25,0,-96,-97,105,-46,15,52,113,14,37,31,-28,123,-67,49,47,27,-42,-82,81,101,-69,-121,-27,26,64,-118,124,-110,71,-8,74,-69,-30,85,54,74,40,22,18,-53,-40,59,-14,32,-64,117,29,84,53,-46,-87,-118,118,41,-68,-44,-53,65,0,126,61,118,56,-10,73,-41,115,10,-99,70,-69,61,0,8,-4,-119,-94,21,119,125,-105,-43,-104,106,101,110,-77,7,-128,65,-53,54,-26,126,-72,-71,-105,-85,-102,-106,-79,59,0,82,34,-40,118,-125,-91,87,-115,-87,-14,-17,-22,33,32,127,111,38,-54,89,101,15,21,-124,67,-49,0,56,-96,-101,-10,-68,103,87,93,66,-83,63,71,30,126,85,-47,-88,-15,86,65,-96,103,10,-40,-93,123,8,88,62,57,114,-33,15,122,-11,-103,67,-103,-107,-23,54,23,1,-26,-68,24,-51,57,23,19,2,86,75,-105,-105,-16,120,8,88,-98,-103,71,51,97,-32,18,-30,-94,62,44,-105,7,-70,70,-26,88,-33,-21,56,71,84,45,-98,-40,-114,-24,1,96,-32,-96,-91,90,76,-116,-71,-124,50,104,-115,-80,-117,0,-18,-3,12,-5,32,-114,-44,2,61,118,-122,101,-127,-45,93,66,-118,-5,97,-48,-95,-107,-64,-107,29,30,117,-28,-63,-74,37,10,67,92,8,19,21,23,67,52,50,47,-60,3,-128,45,92,79,-60,-114,61,-15,41,75,36,-84,-52,82,-9,30,0,-124,-47,-78,-106,106,-17,62,122,95,90,-23,-70,-40,-73,116,17,-64,120,-22,65,-20,-39,101,-42,-100,124,-78,74,-113,-13,56,0,104,90,-54,39,89,-5,46,-90,-79,-33,76,109,122,7,0,-116,-30,38,-6,98,-20,-91,4,93,-29,23,-103,71,48,61,4,112,25,-44,-127,89,-5,-121,-22,61,-21,38,73,39,-114,-121,0,-4,-78,77,-106,104,-98,70,-83,-12,-72,-40,-34,-28,34,96,-24,-93,-54,127,-10,79,85,91,-32,1,68,15,0,-39,55,-85,74,-108,-109,70,-63,-8,-56,16,105,-64,107,106,102,122,-42,-14,-24,74,19,35,76,26,-114,118,-119,54,-41,-87,37,-83,-83,48,-35,-27,34,-32,108,-103,61,-102,-35,75,75,-120,51,61,-17,-28,0,-64,92,-41,-61,91,121,-19,-78,-30,9,-60,73,125,40,7,0,67,112,-94,-35,-10,-88,-114,-22,87,102,-127,113,113,-96,1,84,-1,-37,-54,-127,57,-82,63,49,13,-64,1,-128,93,22,-105,108,49,123,-76,75,62,90,29,116,1,57,0,-88,27,71,-114,-74,-106,80,118,-35,90,-87,79,-17,33,-128,110,23,-97,118,-58,108,-30,-81,-14,-10,-87,51,-29,-47,69,0,-2,-92,39,11,76,84,125,-48,-29,77,84,26,120,94,122,22,-94,-25,102,-33,50,69,-106,57,-10,0,96,63,45,-94,-48,-52,17,-96,54,-75,66,-113,14,-70,3,-128,-63,-3,-91,9,23,-21,-73,-51,54,-87,-43,-24,33,-128,109,-92,71,90,-110,-47,-48,-71,-121,-70,104,95,23,23,-15,7,-7,63,-64,21,-97,54,-72,73,92,113,32,69,51,14,-17,-27,123,-3,-53,77,83,-104,-35,112,-59,57,-108,34,10,-3,-3,124,-81,127,-71,102,98,53,-83,-63,99,33,80,-118,-86,-74,-73,-7,-54,-56,-78,-57,-104,-90,63,-83,-56,-74,35,-85,-97,78,127,7,-127,43,121,82,54,85,116,37,-15,-29,32,68,26,-42,54,-59,-111,122,126,-116,-105,73,3,7,62,-123,44,-18,101,-77,111,-41,120,-95,-118,3,0,-43,106,118,42,101,-86,-36,-95,-28,-125,124,-81,-97,-102,125,60,50,53,-111,20,117,26,-34,-53,-9,-6,-105,91,-47,-2,12,-82,68,64,82,36,-53,-15,126,-66,15,-8,114,86,9,76,56,-23,-95,20,-7,114,-113,-16,-75,126,-23,-125,98,44,19,45,108,-104,-52,-76,118,17,39,-65,-42,65,87,83,26,-35,6,125,102,42,125,-16,-10,-88,33,-108,110,76,89,-50,75,-91,79,-34,36,-26,-57,-104,-47,72,-26,-112,-60,-119,37,-29,-31,34,78,126,13,-42,-118,23,104,-92,101,11,78,-103,-92,64,61,-64,31,99,127,-7,-116,109,-74,-21,-102,-106,-20,-93,25,-122,-92,104,82,-13,1,-66,-84,54,-29,-40,-36,0,61,-114,27,-71,-123,-20,1,0,-5,12,-14,28,-101,107,87,52,-105,56,50,11,123,120,-128,-109,93,-113,28,-103,12,-68,86,-107,-58,30,-39,-23,28,15,0,-40,-75,-80,123,-9,121,-117,-70,100,52,-94,-30,-56,3,-18,-87,-3,40,55,67,93,115,52,115,77,86,-23,-31,1,78,118,-11,-113,98,-35,75,60,-11,-64,124,73,44,82,-26,1,0,-69,-119,99,20,89,17,75,-80,-108,-102,72,-65,-55,59,53,-61,28,-39,25,49,42,13,120,-81,-126,-38,125,-20,52,59,56,83,99,73,33,23,1,-8,53,88,-79,-10,-40,-53,85,10,53,89,-63,-111,7,-128,51,-91,-119,-20,94,-102,-96,29,115,34,109,65,-26,34,0,127,-105,15,98,90,-112,84,61,32,-73,42,-21,-96,-26,34,32,-65,-4,-61,-38,21,-47,-43,89,-112,5,-123,61,0,100,55,105,94,-115,121,49,-9,-107,9,-65,-55,-70,-106,-66,48,-117,-67,81,-23,-73,120,-75,66,41,-118,106,115,-58,25,74,3,-34,102,-3,52,-38,-60,6,74,62,-56,-9,-47,126,-97,38,27,-34,-10,-5,-66,75,61,-30,-9,49,62,109,45,49,-10,-126,16,45,117,-115,-109,-9,-65,114,0,32,-127,-45,-62,-54,105,-49,-10,104,-77,-60,-42,19,91,78,46,2,-16,-25,-17,-71,-82,93,83,79,47,97,-26,34,64,-48,105,94,-75,55,70,-70,-119,110,98,85,-97,30,0,-80,87,-39,16,71,-37,101,-27,47,-77,-77,-93,-29,30,0,7,-52,-94,49,75,-81,-54,-121,-79,88,-99,-99,-117,0,-4,81,-101,-76,84,35,-67,66,43,-68,-39,33,7,-128,90,-31,-91,-106,101,49,-58,-119,-32,-25,-96,-43,-68,30,2,-16,15,61,-97,-99,118,-31,30,-76,99,39,-19,35,-61,1,-112,-35,108,-13,73,102,5,61,88,79,-91,-33,-26,-43,-107,-105,7,-83,-98,38,-46,112,-76,-27,-97,-9,-36,-96,-74,-18,20,-5,-115,-99,122,117,17,48,73,-100,75,-39,-37,-116,-106,-43,101,46,39,90,16,-31,33,0,-65,86,-4,-43,-3,0,-66,-90,-126,7,111,102,-21,0,0,-69,-20,97,-61,-98,-112,-43,-93,49,115,-78,78,123,46,2,104,-79,-92,105,-110,-35,-34,-84,90,-94,63,104,53,-81,-117,0,-4,-10,48,-69,-40,115,-67,-47,34,106,34,12,88,107,-56,-77,68,83,47,-89,93,117,121,-57,71,15,1,-7,-9,7,-47,19,114,-111,-35,-123,-64,-124,-33,100,29,-44,56,-128,-110,15,-14,-67,-34,56,-88,-74,87,16,105,8,-123,-92,72,-50,-24,33,62,53,-78,86,53,-83,-71,68,114,38,102,108,123,0,-72,121,-101,-106,48,-76,93,13,-108,124,-112,-17,-27,-97,34,101,99,14,-90,10,-121,14,74,-63,-105,123,-122,-17,-27,47,87,108,91,-57,-124,-37,58,66,41,-84,8,-97,-32,-5,-128,-76,-111,-3,-103,-114,87,52,-110,-94,101,6,-17,-27,123,-3,-76,-76,81,-14,-126,-69,103,65,41,60,45,-97,-32,123,-3,-76,-84,38,-65,-111,59,84,0,80,-118,-108,-4,-67,-97,-17,-11,-111,-50,98,-17,-105,-64,-83,73,-95,20,-15,106,-33,-49,-9,-6,-105,-85,-58,11,-51,5,118,-16,-125,82,36,90,-12,126,-66,-105,-65,92,-98,102,12,-13,-62,125,-44,-112,20,124,-71,103,-8,94,-2,114,-67,20,59,-5,113,74,3,73,-31,92,-61,19,124,47,127,57,61,107,-66,-1,76,-126,-103,71,40,5,95,-18,25,-66,-41,-65,-36,-80,75,27,79,35,40,-123,95,-18,9,-66,-41,43,-108,102,-17,-75,-63,57,99,40,-123,21,-54,19,124,47,127,-71,-85,-81,-18,-17,63,-77,-32,18,65,66,-16,-43,-34,-49,-10,-14,23,91,-74,118,38,71,24,-116,-124,82,-16,-43,-98,-31,123,-67,-23,21,111,55,68,117,124,-13,33,20,-61,-58,-41,83,-116,-81,87,40,-10,74,33,-67,118,2,41,0,36,-123,21,-54,19,124,-81,-33,-25,-106,13,-17,87,-88,0,-96,20,-34,-25,-98,-32,-5,-128,47,103,38,72,-57,-50,37,-108,34,95,-18,-3,124,-81,-1,114,54,-23,57,51,-100,70,80,10,127,-71,39,-8,94,-1,114,86,47,-49,12,-99,75,40,69,-86,84,-34,-49,-9,1,-26,-105,61,84,80,-31,-42,4,-91,-120,-7,-11,126,-66,15,-40,-21,108,-91,73,-123,-70,27,74,-111,-67,-18,-3,124,-81,-33,-21,82,51,51,36,55,28,23,-128,98,120,-81,123,-118,-15,3,54,-13,110,-115,-122,-123,31,7,-118,-111,-51,-4,25,-58,15,-8,-126,54,-10,91,39,52,-25,-79,24,-7,-126,-49,48,126,-124,57,102,6,-78,-29,112,49,22,99,-26,-40,19,-116,-81,-9,18,110,55,60,38,-36,-105,28,73,97,63,-31,9,-66,-41,-65,-100,-67,35,118,12,104,62,65,41,-4,114,79,-16,-67,126,107,-80,113,-87,57,-31,-61,64,41,-68,53,60,-63,-9,1,-21,-50,-82,-17,-119,123,81,96,49,-78,-18,-98,97,-4,0,99,-38,-40,15,19,111,-60,80,-118,24,-45,-17,-25,123,-3,-53,-39,-4,82,-50,-40,-124,66,82,-8,-27,30,-30,75,50,53,101,103,-33,-53,68,83,74,61,76,-34,63,-35,67,-128,-4,-60,10,-75,-57,-3,-40,96,-118,-38,35,-98,-74,-56,113,17,39,-65,-84,-91,-111,71,-33,47,73,-44,11,66,91,-93,119,-45,123,-120,-109,127,101,109,-44,-70,-73,-5,16,59,65,-92,35,-67,-70,-101,3,-50,72,-78,30,44,109,125,-103,103,-47,86,70,-117,94,120,-26,33,0,-1,12,107,-102,-5,41,-29,117,21,47,43,46,-13,0,39,123,-102,-95,119,123,85,98,-44,-20,26,-69,-22,-64,3,-100,-20,37,-121,-76,-6,94,29,-3,-35,66,-93,103,-68,93,-60,-55,63,-94,86,62,-20,109,-29,-81,-85,95,83,99,-73,124,-71,-120,-109,127,105,-73,-2,-70,-105,67,37,25,-52,-48,58,59,12,-32,34,-50,-28,88,89,50,-104,-5,9,45,-67,126,61,-60,68,-113,75,58,0,80,-112,84,-76,27,94,-38,-123,75,13,117,116,86,120,-25,0,-50,-108,108,22,-107,-38,-54,-34,-120,-26,-70,-31,126,70,-42,-124,-33,69,-100,-47,-30,-108,66,89,-90,25,66,-46,59,66,68,-104,44,91,23,1,-94,-47,-14,-91,106,-84,102,44,-71,-121,-59,-59,65,-6,101,-118,-88,-103,98,73,27,66,46,-42,53,-53,3,-100,-20,51,93,-9,-45,24,97,49,70,42,-5,-86,30,-32,-36,-101,-28,27,-39,30,58,73,-81,78,97,-5,19,-109,62,109,-61,36,-110,-75,-82,-37,67,116,122,21,-94,7,56,-39,123,12,51,-33,-66,77,-46,-69,47,8,57,-105,63,13,63,-19,78,-110,-90,25,-66,58,66,47,-84,-13,-97,7,56,-39,-101,54,-56,48,-38,52,-23,13,97,-84,65,-128,35,-113,92,-87,-6,-3,106,121,-77,-32,-102,94,55,64,125,52,-114,0,-4,50,102,-75,-39,55,-51,83,-5,-48,51,-69,-61,67,0,126,-67,57,124,37,51,7,-60,4,26,-123,53,-2,115,17,-64,-105,-66,90,58,101,51,13,116,-38,-79,107,38,60,0,96,-41,22,-27,-55,92,-37,46,70,-10,117,-125,18,-93,119,16,-128,95,91,55,100,-93,77,-93,-18,62,-107,-13,59,8,-64,47,99,-39,75,-37,-89,66,-44,123,-73,50,107,-87,-23,34,64,49,86,18,51,40,23,107,-61,105,-83,49,125,126,15,-127,-8,-41,125,52,-93,-84,-61,-36,-40,29,-99,46,2,-16,103,29,-51,101,-92,101,-73,108,-4,-110,24,15,-127,-8,-75,-49,72,-33,-41,74,84,2,-38,75,-63,69,32,126,89,43,-10,106,-14,-104,-102,-74,110,-90,-73,-48,-72,16,-12,11,-38,-16,59,-102,-25,-47,27,67,18,107,-55,-20,34,0,127,-119,98,13,-103,-3,62,-58,18,100,67,98,126,-125,-121,64,-4,69,13,-73,117,-109,-106,63,49,-13,-46,-121,-96,95,-24,-95,-90,-37,-13,-88,5,-55,110,-48,112,17,-128,-65,106,-115,-77,-75,-90,-109,-24,-80,37,-74,24,-5,1,15,-126,126,65,-101,-66,88,113,-67,-20,103,36,86,119,-19,67,80,-47,102,-42,-37,-9,-116,86,-55,-78,80,-23,85,111,14,0,-79,107,23,112,51,-31,116,63,-91,-34,-107,7,0,-20,-67,-24,61,0,-58,-37,104,122,-3,116,101,-82,-89,-121,64,-4,122,-76,-92,-34,53,-94,60,12,125,124,7,-127,-8,-19,-51,-22,113,-22,53,122,-20,26,19,46,-114,-104,69,111,-104,-89,88,-30,-74,86,-70,-77,115,121,-60,-83,125,19,-83,-97,-111,-82,11,-64,40,57,5,-96,25,-45,-125,120,-68,70,88,20,-17,-100,-52,-33,119,17,104,69,85,-83,-69,-33,-125,15,73,-37,-22,70,-26,51,-69,8,-68,-81,-56,-74,99,76,60,-103,97,-123,-99,-28,-11,0,-56,106,80,39,44,25,31,76,67,-119,-94,117,-87,-43,-64,17,40,-125,-43,66,-76,-46,87,60,101,-79,102,-81,46,2,-16,103,-67,-10,-52,-60,102,-78,-10,86,-20,-20,-70,80,23,-127,108,90,81,78,-45,68,-34,116,124,123,99,7,-112,92,4,-32,-41,-74,37,51,25,105,-51,-47,118,118,88,-48,69,-64,106,-96,38,-54,-37,74,119,109,-89,-53,-117,-116,24,0,120,67,-30,-105,54,-13,-91,-82,-69,7,6,-11,-122,-88,-4,-23,35,-86,27,-36,114,50,-62,10,-89,30,-88,3,0,-119,-99,116,93,-39,102,-124,-59,-12,90,76,-25,120,0,80,95,22,101,-127,-25,-5,-117,-58,-55,12,41,15,0,-30,-47,75,59,116,-101,61,39,95,30,43,51,115,92,-60,-55,-97,-44,-127,76,102,32,107,11,-107,-10,103,-10,0,103,60,100,104,-69,-12,106,94,-75,-106,48,42,115,-95,61,-64,-55,-98,-69,56,-41,-90,11,-94,72,71,39,112,-31,34,-50,40,-44,-108,-19,-66,22,51,13,-54,-43,-4,-102,-35,43,-32,0,64,9,-73,45,109,-69,-84,83,86,19,-114,68,79,-58,40,-90,-96,124,-120,118,-45,70,99,50,-3,-27,34,-50,-88,-94,108,-13,98,-98,-108,118,-45,-90,-83,-47,-10,122,30,-30,-28,23,15,126,-84,-46,-9,-67,56,-57,-21,54,89,-38,-46,-34,65,-100,-4,122,-108,109,-102,-83,82,-85,65,43,-19,-78,-55,-27,-49,120,-82,118,13,108,-42,127,79,99,-22,-11,38,-20,-124,-90,-121,56,-7,123,84,-53,-42,-104,17,93,-17,-72,99,-106,-127,7,0,7,65,-90,-98,-35,-76,-95,43,-47,35,43,-45,-21,31,61,4,-32,-41,-37,53,-106,21,22,127,-72,49,29,-23,1,64,-92,94,-106,93,-74,49,61,-19,54,78,27,-99,115,121,-64,29,67,-77,-9,85,-120,116,-69,110,52,101,-20,14,-30,-28,23,-89,90,-108,94,-49,55,105,118,-82,-121,-118,3,-26,22,86,-103,-15,97,102,38,14,-104,-75,123,-55,-78,25,74,-113,-103,-119,3,102,-115,125,-113,71,121,-79,48,96,-43,54,64,-83,-38,87,83,51,-121,94,-102,-24,33,-32,83,-41,101,-82,66,-43,4,-18,-11,55,-2,-24,20,1,-26,96,-41,-58,-4,70,-72,-117,-3,67,-5,-126,114,121,-96,87,-82,-106,-33,102,71,76,-93,57,-25,-89,93,4,-56,68,105,-116,-53,-60,19,52,-125,91,23,-21,-39,-28,1,78,118,49,96,87,105,38,-93,-105,-93,-18,47,-12,-42,50,15,113,-18,-88,-22,-16,-105,-101,125,-97,-60,30,41,-76,-95,-107,-121,0,-91,-74,61,-92,106,92,103,-67,-115,57,14,-106,4,-16,0,-89,109,39,-74,-121,-20,-64,118,115,-25,39,124,-104,-12,105,-15,106,-44,62,-81,-14,24,47,-107,62,121,-57,-48,78,70,-7,46,-55,86,-87,35,15,-22,-97,100,-11,-114,60,-116,-27,-89,-118,105,69,-94,-57,93,4,-32,-41,60,-11,48,102,49,111,93,67,-91,-63,88,-117,13,-78,-78,81,115,42,74,-81,-85,-11,0,-64,-6,-97,-38,32,-51,-82,-122,-52,-49,73,81,113,96,-101,103,109,65,117,127,10,-51,-74,49,-45,-100,3,-50,117,-87,61,-87,-110,-23,-106,-97,-76,-8,65,29,19,-78,46,61,-60,-87,87,-22,18,127,-87,-41,-37,34,-114,-107,-33,110,-54,1,-64,86,-116,33,-39,18,19,-67,-29,-67,-48,-79,-15,0,39,123,-20,33,-9,-44,-83,-122,43,-95,100,122,59,-89,-121,56,-21,46,-102,94,119,-65,110,-46,41,-120,-59,-61,-22,58,60,-60,-55,-97,-89,-72,-10,38,-120,-85,33,-95,25,89,-63,-108,7,0,53,53,-14,44,-85,-10,-69,116,79,-115,85,-115,120,8,-16,-12,-14,47,-14,97,-46,109,44,35,117,26,93,4,24,-3,-91,23,-128,-36,-89,-126,-72,42,100,102,122,0,96,105,-116,-112,-94,85,121,-102,-64,-24,-84,-84,-61,3,-100,-85,106,-43,48,-59,-59,-79,30,-113,-88,-113,-58,38,-66,-117,56,-75,66,-42,-58,113,-45,120,-77,73,-5,-72,-14,-117,23,61,4,-32,23,-73,59,89,-57,-95,77,-19,85,-57,90,-13,57,0,96,-53,104,83,-67,-47,-84,-49,19,69,-102,117,-116,115,17,-64,-5,85,-69,-83,-38,80,-79,-88,-83,-78,-88,82,-13,16,64,-17,-120,-53,102,-38,-65,-53,-61,116,49,-122,-88,-93,-28,0,64,-91,-99,120,-6,-71,89,119,86,94,63,-78,100,-100,7,64,113,125,-79,0,-109,117,-85,-90,94,13,80,120,-94,-116,35,64,-119,-85,24,-99,-39,-6,86,107,106,-84,-120,5,-15,28,0,-80,82,-43,87,78,102,107,-117,43,-120,-110,98,-45,-34,1,-128,89,127,117,-68,-79,6,92,-46,-80,52,-91,-9,16,32,70,40,-109,-84,117,107,119,-118,3,-77,88,13,-113,7,64,57,3,-115,-58,-101,10,43,-83,99,-20,-12,38,108,23,1,-12,113,-69,55,101,75,122,12,-105,23,-14,-71,-120,115,85,37,49,-25,110,-107,109,-41,-19,44,-76,107,-67,3,0,-98,-85,108,14,41,-10,-101,-6,43,-119,-35,80,-23,1,96,4,34,21,-69,68,-76,82,-113,-33,87,-19,0,-50,-111,-41,96,107,-118,-23,-18,67,-73,-50,110,113,115,17,-64,82,16,11,-88,-36,-118,-36,90,104,37,-46,-22,91,14,0,117,-31,81,47,86,46,118,-25,-47,-58,-41,-52,115,117,17,103,-74,70,-116,-106,100,99,-105,-102,-92,77,-20,-82,96,71,30,84,-12,-123,22,-57,-78,-91,-123,34,61,11,51,19,92,4,88,-77,106,93,69,27,48,-70,-54,-104,105,-102,-110,3,78,118,53,-90,-29,-104,-19,54,11,-60,2,102,-70,-34,67,-128,-70,-22,36,-10,-36,106,102,30,20,-67,-121,-116,101,41,93,4,-88,-85,78,-78,-34,114,51,-77,88,-117,-117,18,-85,43,112,17,-96,-82,90,-74,-27,-42,-116,91,-83,9,-9,86,88,74,-56,69,-128,117,-85,93,14,-41,77,90,87,33,-21,-103,-17,34,96,-35,121,79,-53,-68,-84,108,62,60,82,-18,1,-50,-39,51,-81,126,-11,118,-90,105,95,78,-90,-45,60,-64,-55,-82,55,-26,-58,-101,-122,90,93,-81,0,102,115,-45,67,0,126,109,1,-39,-83,-81,-95,53,-22,-76,65,-69,-117,-128,58,115,-108,101,106,-32,-77,30,-50,-96,-89,81,92,-60,-55,47,-1,82,-76,42,117,-105,30,93,70,-128,126,92,15,1,-14,20,122,69,-14,26,-58,-74,16,127,99,76,122,-95,-84,-121,0,113,11,-51,6,118,-93,73,-44,30,-96,-58,-120,7,56,-39,-105,-24,-92,52,-85,-51,110,22,-67,20,-111,-75,38,-9,16,-89,-91,-106,-12,-106,82,83,-30,-103,-53,-107,6,98,-43,-19,14,-32,100,-113,106,-99,23,107,-107,106,95,-85,65,47,119,-16,16,-25,-24,104,-116,58,-50,98,-33,-75,-118,-109,64,-81,-119,-9,16,-64,-65,26,90,-118,93,-19,76,-45,-124,48,-19,52,-19,33,-50,-71,41,-98,93,-102,-51,-108,-50,-27,41,59,-57,98,87,86,-70,8,-104,-43,17,-124,-75,-85,103,13,-67,-77,122,56,23,1,44,-39,-94,-18,94,50,17,-66,73,123,85,112,113,-64,-84,-38,-70,-43,-69,104,-53,-12,48,-115,-121,0,121,105,-79,65,75,30,-26,59,-23,125,-105,-109,-43,-66,-72,8,-32,-65,-119,37,-76,-20,52,-72,-18,-87,-96,105,123,7,112,-6,-98,67,23,97,-75,42,-92,-120,7,56,-40,-78,117,17,32,66,45,-17,106,-22,-37,52,36,-36,34,-53,-66,58,-14,-96,114,71,118,2,81,70,54,6,-33,-76,-2,-116,-84,41,23,1,-98,93,-75,69,-83,54,-96,77,-25,36,23,7,-93,126,-123,-31,-51,4,43,-78,28,105,-112,-44,3,-128,-24,122,81,-109,101,-36,21,-45,96,41,65,15,0,-29,116,-71,-38,-55,43,-42,116,99,103,11,28,-7,-109,91,86,94,21,91,-50,60,-119,94,-8,-45,105,-58,-50,67,-100,-70,96,-22,93,-41,-39,86,-76,12,-98,67,-90,-30,-128,57,7,89,-41,-26,-37,-21,-79,-42,-56,106,-103,60,0,-114,-50,-107,-110,-22,-3,45,-71,-114,-15,16,39,-65,-68,84,-106,-55,106,63,-110,60,77,101,25,19,23,1,108,15,-67,-22,-46,42,84,49,-115,-58,26,44,33,-29,0,64,38,83,-84,-60,100,-18,32,-47,39,19,29,78,-20,38,15,0,124,-27,37,-21,-20,-74,58,98,-44,-61,74,-84,112,-46,67,-96,-70,79,61,8,99,-49,110,106,127,-10,66,15,115,120,8,-60,47,-85,123,-40,26,-29,-21,98,-19,-62,-86,-110,61,4,-56,-53,-22,-83,12,-43,-50,100,121,-64,-78,-40,61,14,46,2,124,-35,-53,-90,-78,102,86,-42,1,38,-113,-17,1,-128,93,-103,-76,-34,-52,-52,4,109,35,71,-113,74,121,0,92,115,-41,-77,-83,-48,93,-30,80,-46,-86,50,23,113,-82,91,-51,23,-84,105,114,103,37,-54,-46,89,52,103,-30,33,64,-90,83,-122,50,25,-27,-86,-23,64,-38,85,-99,72,3,94,61,-119,49,77,70,-44,37,102,-30,64,-109,93,-33,-62,68,-105,61,102,42,126,126,-53,86,-12,88,-63,-125,-60,84,26,100,-39,-59,71,-97,54,-11,-84,-58,96,98,-123,13,30,0,86,30,-120,17,-34,111,-118,84,-4,79,118,-64,-42,1,0,-35,-94,-25,23,-14,-67,-128,126,-119,41,-60,84,11,7,-128,72,95,73,-63,94,-122,35,122,104,105,1,58,11,-89,120,8,-64,-33,-12,22,-113,106,-11,28,61,50,-51,-59,-47,-109,-81,80,83,79,119,13,-102,88,45,-84,-117,0,-29,-34,123,24,-74,50,63,37,113,42,42,85,-23,28,112,-18,120,-78,61,-106,85,109,-44,-91,124,-65,-104,-120,-20,120,30,-30,-100,-15,-30,75,-27,101,90,-128,-28,43,80,-59,74,16,60,-64,-87,-47,69,56,-107,102,-30,-103,87,-109,-24,-46,-40,33,126,15,1,-86,-78,-76,-6,-49,102,38,29,69,-64,-59,-127,-35,-66,-76,121,-55,122,-112,-104,73,-97,-68,122,-14,-68,-39,-94,31,-113,-104,-118,-97,95,82,-2,-36,-121,53,2,-59,114,91,-117,5,-101,61,-64,-87,-69,-12,90,-114,98,-51,40,77,-65,-45,43,-49,61,-64,57,-53,101,-4,-6,104,86,-113,-118,-6,104,-111,-107,29,-69,8,-80,70,-11,124,-19,-76,-123,27,122,-54,-102,30,6,115,0,72,3,12,77,77,89,101,-92,57,-96,73,-83,70,7,1,-8,-89,24,5,115,-40,76,97,-67,-18,-73,102,-4,14,2,-113,78,-118,-61,-26,-80,53,50,-51,59,28,56,-120,115,-18,-52,24,-22,-78,-57,104,-76,108,-73,-79,-56,0,-105,63,103,125,-45,99,111,-61,58,39,-38,7,-124,-87,71,15,0,50,-34,-94,-105,-21,-19,84,-105,126,-70,76,-101,-112,120,-120,-109,95,-52,-29,-66,-90,13,43,14,-7,114,44,49,-22,1,0,123,-42,92,-75,25,71,113,21,-45,96,-42,-116,7,56,-39,-81,126,66,-74,-104,75,-100,78,122,107,-103,35,127,126,85,61,94,27,-19,-14,-109,109,109,37,-26,-58,120,0,48,31,-109,-98,-22,-76,69,21,-78,94,104,33,-128,7,56,117,-103,-40,56,-61,30,73,75,-41,-35,-60,-84,76,-37,3,-96,-116,107,15,-91,-38,28,-104,-98,-119,-24,84,-107,121,8,-64,47,-45,-87,78,115,26,48,-23,72,118,122,-44,-35,67,0,-2,-91,105,30,99,-3,104,6,-75,37,86,59,-27,34,-112,-75,-89,111,107,-91,-69,-6,-5,-20,-126,52,23,-127,60,-8,121,51,-34,84,-15,-43,-52,85,37,7,-100,115,39,-82,32,-118,-38,124,43,61,-105,-42,42,51,-57,92,4,-80,-10,-60,-100,24,54,-108,-93,-35,70,-24,9,72,15,0,-40,69,-113,-90,-107,-84,107,24,-59,-30,95,-60,5,113,17,-80,-62,-70,-36,-22,-91,-59,52,44,-103,5,127,60,-64,57,-10,73,-21,-15,-118,77,-63,100,45,107,38,95,-42,3,-128,121,35,-77,44,87,27,77,111,-41,29,-102,-12,68,-79,-125,0,-13,94,-106,-12,-70,-59,42,-76,39,80,-91,-4,30,2,-44,-35,37,-39,102,-110,-83,-75,18,111,-79,-80,-119,-23,1,0,-69,56,40,-35,6,114,-82,-22,40,-70,104,29,0,122,-10,24,-90,-83,-38,-48,-52,-8,-120,44,108,-27,34,-48,-40,-85,37,109,-6,37,105,110,-74,71,-34,67,-56,65,-128,-71,-93,37,-28,-43,-98,-123,-99,-70,-18,89,1,-110,3,0,-5,85,9,99,-35,-94,46,73,11,-9,88,72,-43,1,0,118,123,-27,-104,-29,-21,96,81,108,-83,-106,-107,-5,99,-84,92,28,48,-73,37,-90,84,127,-48,55,-29,-30,96,-122,104,91,80,123,18,-53,99,-90,-30,-128,89,-116,-53,90,-115,-51,-26,50,51,113,-76,83,-53,26,40,125,62,-54,-52,-60,17,-13,12,-59,118,24,-12,-103,-119,56,98,-42,-78,100,83,-57,93,-76,111,36,11,55,120,0,28,73,18,-113,-7,-63,-96,0,23,71,51,79,-61,30,-27,81,102,42,14,-42,-97,86,119,-115,7,-89,52,-107,62,121,-75,-74,-73,-105,-15,96,-28,-123,-117,3,-26,-86,71,-96,30,92,-34,84,-6,-28,-43,-53,15,83,121,116,36,-104,52,-46,-2,26,94,-82,15,-49,102,38,-114,118,69,-47,-39,101,62,24,-26,-26,-30,-128,89,-81,35,-78,39,-85,-75,54,112,-14,-54,74,15,1,-8,53,-48,-101,-83,39,41,78,84,-23,-76,-89,-95,-121,64,-4,83,35,-29,119,79,117,-76,69,119,116,7,-127,-58,-89,-53,124,-115,54,-109,77,15,78,114,113,108,43,-56,118,-103,110,-17,41,43,-102,-6,39,14,-126,-60,-94,74,-79,-29,56,100,-58,77,26,43,114,16,-56,-1,-47,3,15,54,122,-67,-24,85,47,92,28,91,-56,-83,-37,-110,-115,-91,39,-12,-7,-109,59,8,-76,83,-10,-85,-112,-42,4,32,-60,79,29,-68,88,-39,65,-128,57,-93,-83,91,102,-77,-71,-50,-28,116,-14,117,17,104,-50,-21,114,-69,-43,-53,104,47,96,118,5,-78,-117,64,-4,106,-128,-38,50,46,-79,67,-76,100,-110,-14,115,4,126,-2,88,111,103,77,-44,-90,-26,-12,20,0,-40,-37,-48,86,96,70,86,92,-124,76,-109,60,14,0,-39,-100,35,-92,97,-3,13,-19,114,-31,4,72,41,0,-28,120,82,-56,57,-38,-22,-59,113,57,-105,68,-101,-71,8,16,85,-112,105,-36,109,103,-28,60,-8,37,63,84,-4,100,-42,43,-39,109,123,97,45,97,111,-99,118,-11,117,0,72,-41,-56,4,-80,81,102,-19,-18,52,23,-85,51,117,17,56,-89,57,-17,-25,-58,117,100,89,-53,3,23,1,-26,100,-114,-38,-89,-41,-100,70,16,-3,84,104,-115,-78,-117,0,-4,-94,-116,90,-75,-111,-73,-82,101,82,-76,75,-100,-121,0,-4,90,-30,106,51,-60,122,42,-46,-119,53,122,8,-12,-4,67,22,-72,-19,-14,-34,-12,96,17,87,9,14,2,71,21,90,-75,103,82,-75,-67,-58,96,-103,7,23,-127,98,-91,98,64,-40,114,58,-3,-109,16,80,-65,-33,65,32,-81,81,94,109,-39,70,-55,83,51,-115,44,12,-18,34,80,94,105,-120,-127,-107,109,22,71,59,-23,-46,22,-113,30,2,-16,-113,-82,61,-62,-50,19,15,-76,-15,-85,-121,64,-4,-38,-58,40,-38,10,-125,-90,74,-106,-86,101,7,1,-8,-43,-15,-76,-11,57,122,57,-11,-54,52,22,-18,33,-120,45,120,59,50,45,-54,-92,-79,60,-124,7,64,81,47,45,95,-78,-46,85,118,56,86,-114,-28,1,-48,-38,-43,67,97,-10,60,118,90,97,14,122,62,-59,67,32,11,92,-101,-100,-40,-98,91,87,-108,-119,90,107,30,2,91,35,-85,-101,-82,91,81,-52,-103,-76,104,-37,114,15,-127,-58,71,-4,-103,105,78,124,71,-115,53,-48,82,57,23,-127,-42,110,-46,-29,19,-10,36,-102,86,121,-48,-87,-55,1,32,106,-48,-11,108,-64,-68,-87,-39,56,-39,-32,123,-128,-109,93,111,32,16,35,-3,126,-122,-79,-12,-63,-20,29,15,1,-84,-110,-94,-3,113,-116,18,-108,77,-82,-47,115,101,30,0,60,125,-106,45,-70,-103,80,-58,117,-37,109,99,5,63,46,2,107,-51,33,90,-55,124,-88,21,-6,-30,-58,-90,-125,64,-107,86,98,-121,-38,50,-69,-92,69,-84,-111,21,0,-69,8,22,55,-100,-10,-108,-98,30,-15,-28,-69,-106,-125,64,-69,110,14,-53,94,-60,33,106,-124,119,102,-27,-14,40,-69,42,-5,-13,-19,74,-117,50,53,23,-53,15,-76,114,4,-88,115,-47,123,96,-84,117,39,-42,41,-19,122,-31,-56,-97,-39,49,-19,25,104,-21,-90,46,95,-116,-123,62,29,121,-100,27,-77,21,101,122,-95,96,-94,51,-98,-53,-125,-72,-36,-48,-68,-115,41,-49,-44,10,-19,-100,89,44,-57,69,32,43,92,93,106,-69,-17,104,11,-93,-54,119,42,7,-127,-84,100,-115,-116,-107,-69,-34,-114,-4,6,9,15,-127,99,105,115,-102,-47,84,51,70,91,-81,57,-79,52,-122,-64,113,17,83,-70,-106,-12,-36,79,-92,21,-23,92,30,84,-68,-118,-71,53,-110,-11,-105,82,-110,121,-57,18,123,46,-30,-28,-41,-117,88,91,95,-10,-16,64,-105,-105,103,-57,13,92,-60,-55,63,-76,-73,-110,61,-22,-109,-43,4,99,45,-120,60,0,-86,-40,77,65,-52,-13,123,-27,71,-119,-20,-68,-105,-117,64,49,-111,42,-90,-65,-79,118,-29,-44,93,-109,-57,68,40,0,89,104,89,-33,-43,-34,49,86,-44,124,103,79,-17,33,-112,119,-82,39,67,108,103,-57,36,-69,50,-35,6,29,0,-116,-71,-52,18,109,-15,-77,-106,-10,51,118,15,0,43,-34,114,-75,126,-128,-58,57,70,100,-41,45,-72,8,-80,-113,-56,46,-48,30,77,39,82,-23,-109,87,79,37,-91,71,83,126,84,26,121,58,-22,-9,-102,-77,-17,58,25,50,-83,12,113,17,39,-1,-11,-69,102,81,-88,-31,76,111,38,-92,-30,111,51,95,-41,60,76,106,-54,80,-15,7,-104,-59,42,-87,-123,94,-22,66,-59,-79,111,118,-21,87,-84,-9,-110,-118,107,-57,-17,-77,-32,8,-28,23,-85,61,104,47,-72,83,79,-126,54,-22,113,0,40,-42,-86,77,-113,-102,109,102,-91,-121,-107,39,47,119,-11,32,32,-61,-88,103,-23,-115,-93,-91,97,-9,81,-39,87,-11,0,-112,-67,-22,69,-105,-69,-12,117,83,26,-85,25,117,17,-64,94,-86,97,46,123,84,-65,107,91,119,-90,118,61,0,88,-87,121,-122,92,110,-51,69,117,41,-46,-85,92,60,4,-118,105,-107,48,-109,61,47,39,-10,92,103,-51,61,61,0,-80,-127,-109,94,-62,96,6,82,-81,4,-91,87,-72,122,0,-96,-43,-59,77,-116,-10,48,91,-41,-69,-82,88,-126,-60,3,-32,74,-114,-47,-89,-115,-99,118,13,-105,83,-49,-58,65,0,-83,16,53,-112,105,46,127,-47,-120,9,59,-75,-22,-56,3,-97,88,-117,-86,-83,-35,48,-44,101,103,-127,98,15,112,-80,-73,126,101,59,108,-13,-68,-23,56,8,30,-32,96,-81,67,-49,60,-40,35,-6,69,-113,-73,50,-121,-46,3,-128,42,105,93,105,118,87,-17,90,-127,-56,-38,6,115,121,-96,105,-28,3,89,-125,-92,-124,70,-117,-50,-72,56,-80,3,-86,120,35,-73,-128,-120,94,86,-63,2,-13,30,-32,92,71,73,31,-60,-6,-98,-23,-86,-53,100,101,-17,46,-30,28,115,-19,66,52,-5,-19,4,-108,-18,16,-119,93,102,-31,33,78,126,-7,34,109,-38,54,-93,122,33,-18,100,-115,20,60,0,-16,-75,-75,-10,-53,-76,67,-68,90,-80,54,22,-98,-15,0,32,-78,-89,61,-7,-110,29,73,-19,-112,85,-40,69,99,46,2,103,-15,107,50,13,-109,-11,-22,29,-38,-46,-42,3,-100,21,-58,-30,-59,-50,98,-37,75,13,-99,-60,108,-9,-16,0,-89,-98,-71,-86,30,106,-77,21,-67,26,-89,99,10,-34,69,-100,-13,38,78,45,100,127,-76,-98,-121,-117,-125,-54,104,-67,-95,-62,-106,43,93,87,-36,85,86,111,-29,34,-64,-66,-38,-75,-74,-49,-90,125,-94,-58,28,-103,59,-29,0,-128,-114,-84,-95,37,-77,-115,125,111,98,66,59,80,59,-128,-13,-85,106,-97,17,-101,18,-45,72,-2,96,-98,-121,35,127,-50,71,-39,85,-22,48,14,-83,-10,124,90,-111,-107,-84,120,0,-112,-73,-41,-2,78,-45,94,-100,-96,62,16,-19,-64,-31,34,-50,-81,-86,-25,127,-69,49,59,-11,44,-57,-24,108,7,-15,0,112,108,90,27,-10,12,-102,94,82,86,-103,-101,-32,34,-50,89,-93,37,-44,117,-39,-22,25,-39,-47,100,27,102,93,-88,60,-60,105,23,-44,-84,29,-115,109,-65,48,-51,105,12,-42,29,-48,69,28,-4,-38,-48,-92,-51,102,107,21,100,27,-99,-12,68,-128,-117,56,-7,-11,-124,116,73,54,74,-86,107,48,50,55,-54,69,-100,-4,-78,8,69,109,71,91,-56,40,-74,122,-93,77,67,61,-60,-55,-65,68,-123,-44,7,43,98,-103,-16,-7,85,-69,94,-115,106,119,122,-81,39,1,21,7,86,-22,-43,123,-14,-63,-70,85,42,125,-50,-13,86,-11,-46,-51,120,-81,114,-85,-76,-8,-56,69,-100,-21,84,27,-59,78,123,-123,-102,-6,-69,-103,-43,-1,123,0,-80,99,107,123,-108,108,-17,125,-54,41,-84,-62,-6,12,-70,-120,115,116,-118,-98,21,45,118,-93,-95,77,-124,-88,-12,-7,53,-117,-34,-128,103,13,-38,-91,-83,23,88,110,-34,3,-100,-77,-80,-76,-96,89,0,-101,-63,16,-35,-99,88,-74,-58,69,-128,-75,-81,-11,-88,-55,-58,-95,-93,56,-51,-76,-54,-44,69,-100,-4,122,116,60,23,-77,-110,53,123,-76,88,66,-56,3,28,-20,-22,-15,-84,94,-19,46,-87,17,5,122,25,-82,-117,0,-4,-22,-40,14,91,-73,88,-76,-19,22,121,122,15,0,-40,-81,114,-38,91,-76,-88,-122,26,105,-73,99,15,1,-57,126,-84,122,59,97,-84,-127,117,122,-53,-112,-121,56,-25,-90,94,-33,125,-69,88,88,-53,-1,-60,89,97,-3,-83,60,-60,-55,-81,-25,7,-121,93,-124,26,-19,-54,-109,-59,57,92,4,-48,-61,98,9,-50,110,-35,-13,-90,-115,-55,-104,-63,-25,0,-128,13,47,-42,90,-67,-99,31,-41,-5,67,10,-21,-41,-20,34,78,126,-67,-72,101,-60,91,-41,-108,-26,100,-25,93,-60,57,58,122,-119,-82,-19,124,45,-109,91,44,70,-42,119,-108,-53,-97,95,118,-54,-88,-39,109,71,115,-17,-119,-74,-120,-15,0,-64,94,-118,87,-23,-88,-83,-83,-46,83,-128,44,12,-28,34,-50,117,59,117,-33,-87,-74,-118,98,-23,-67,69,100,-43,114,-7,-109,59,-22,-19,-118,-55,58,21,122,-73,71,99,-107,112,46,-30,-12,-70,-11,43,-51,91,112,103,4,49,62,89,18,-41,1,-128,76,-123,118,106,-84,-74,59,105,-42,98,43,-26,-45,59,0,-56,62,-121,-19,-10,32,-122,-70,76,104,-121,-99,1,78,118,-19,8,94,-110,125,-108,46,-18,-36,-92,23,-85,123,-120,-13,-53,106,-53,-124,22,109,29,-123,48,-120,52,-5,-78,30,2,104,123,-11,-102,109,100,77,117,-73,-24,115,122,71,-112,-125,0,86,124,-41,-6,65,59,-104,87,-47,9,115,66,28,0,-40,75,-76,18,-90,-39,-8,122,-42,20,57,-101,-104,46,-30,-28,-41,-38,110,-37,-8,80,29,70,-67,39,-122,-48,59,0,-32,1,54,-19,-28,101,-91,101,95,-109,-65,-79,62,-63,30,-30,28,123,-115,1,-106,102,-10,101,77,123,-46,-114,93,30,0,-52,-100,34,-102,116,-38,-53,5,-11,-66,-63,88,-40,-89,-11,16,64,-25,104,97,64,-73,55,35,86,13,-5,-48,84,-114,-121,64,89,70,-79,62,-85,-67,51,-25,-22,106,73,-5,-103,113,0,-88,28,-47,-93,101,-55,-102,-21,81,75,67,104,-31,8,7,-128,120,-103,44,113,107,81,84,109,5,-50,60,54,71,30,-116,-117,-116,88,-102,-53,-82,111,89,53,-68,-14,-42,67,-100,-4,85,44,-61,101,27,-4,-23,94,87,18,-85,-87,113,17,64,99,-50,-96,-58,-71,-39,123,-76,-81,1,-67,37,-45,69,-128,125,124,104,74,-49,-10,26,79,41,20,122,19,-92,-117,56,-41,85,-50,122,28,111,-108,-37,52,75,-12,-112,-79,-117,56,-7,-75,-91,96,76,-74,-106,-10,74,-59,-47,-18,-34,30,2,-114,-49,-78,-35,16,53,-81,-41,10,59,-76,-32,1,-64,-41,21,43,98,-40,108,-13,-9,102,84,100,112,60,0,-86,105,23,93,61,-117,125,83,-39,79,51,61,17,-28,33,64,6,64,39,-83,-19,-90,-94,-107,-70,117,-78,-42,-63,46,-30,-76,-18,115,-120,49,-103,-74,15,73,75,-56,43,51,50,61,0,-56,-62,-118,-54,72,-55,108,-51,-38,-37,-90,-45,-14,82,7,-128,-22,40,-11,-10,-69,91,47,-41,114,-35,-73,66,-21,40,57,-126,-40,-80,-74,-122,67,87,-2,-30,-59,54,30,-30,-28,95,98,-91,52,91,80,-92,71,-73,-24,89,20,46,15,102,-67,-104,-92,-59,118,-66,86,124,-97,-52,-116,114,17,39,-65,86,-120,-120,81,116,-65,-3,-82,87,118,82,-51,69,0,-2,101,-21,-95,52,82,-50,111,-87,97,-46,96,92,100,-11,-19,-110,90,-114,-57,6,4,-119,-126,-81,40,126,127,75,54,-73,47,-82,-59,-86,-12,20,-84,-121,-128,86,-115,76,79,27,34,-44,67,-117,-115,86,97,120,8,84,-43,24,-46,-22,118,47,-104,50,-83,-24,-111,55,7,0,-40,-75,24,61,-39,91,-121,101,39,16,-41,-126,-41,-10,115,4,-86,-7,-44,-8,105,-68,-33,49,83,104,-32,-49,69,-32,-47,-65,-83,102,118,-78,28,-118,62,-54,-8,-25,31,62,-3,-3,-13,111,-65,-2,-14,-113,111,95,126,-3,-86,-14,63,127,-2,-14,-45,-49,-33,-44,-71,84,117,-8,-49,47,127,-3,-10,-13,-9,-1,-71,126,-3,-105,47,95,63,-1,-41,-25,-97,-2,-10,-7,-21,-73,-33,62,-3,-8,39,-76,15,12,-45,-68,102,77,28,85,70,82,120,95,121,-126,-17,-27,47,55,-12,84,-19,-10,51,25,30,-32,-121,82,36,-125,-16,126,-66,-41,-65,-36,48,117,-107,11,-49,35,40,69,-14,23,-17,-25,123,-7,-53,105,-24,116,-1,-103,-118,-109,98,72,-118,-122,98,-33,-53,-9,-14,-105,-21,-35,-52,-2,-39,97,-1,103,40,69,-54,10,-34,-49,-9,-14,-105,75,-79,-107,-3,119,6,-21,-102,-127,-60,-120,27,-8,12,-29,-21,95,80,-3,-11,125,32,-75,-37,3,-38,-46,-112,24,-39,-53,-98,97,124,-7,11,94,45,-124,-34,124,26,40,69,-22,120,-33,-49,-9,1,95,-81,26,-19,92,6,105,-66,-114,-60,88,-59,-1,19,-116,127,-28,5,-1,-4,127,-62,-119,-45,-8,-108,34,1,0]},{"id":"e790d4eb-7ab7-42b0-8b5c-661248c1ed5e","playerId":"11e178c5-8e89-432a-978e-fc95fd17f8bf","sequence":8,"gameId":"5a2376c6-3285-474c-9896-ee66829b77c2","timePassed":0,"sentence":"a cat on a roof at night"},{"id":"3dfcc5af-621b-475a-bd27-9b5abbb92dc5","playerId":"11e178c5-8e89-432a-978e-fc95fd17f8bf","sequence":9,"gameId":"5a2376c6-3285-474c-9896-ee66829b77c2","timePassed":0,"drawing":[31,-117,8,0,0,0,0,0,0,0,-75,93,-53,-82,101,-73,-83,-4,-105,51,54,4,-67,31,-2,-115,11,100,18,100,16,32,-115,-40,-128,-81,3,-60,29,36,-127,-111,127,-65,-28,-18,-32,-102,60,-86,98,47,27,-57,-125,12,114,92,85,-67,-10,90,18,69,82,20,-11,-57,-97,-33,126,-8,-2,-57,79,-1,-13,-23,-81,-1,-5,-23,-57,-49,63,-67,125,-5,-57,-97,-33,126,-6,-4,-25,-65,127,126,-5,-10,-25,-73,127,-3,-31,-49,63,-4,-29,-45,-37,-73,109,-108,-108,-65,121,-5,-9,127,-1,-17,-86,61,-27,-1,124,-13,-10,-23,-57,-65,124,21,-11,-97,111,126,-69,94,47,-87,-10,57,-41,47,-56,93,118,90,-21,28,34,27,16,110,-11,-74,83,-107,-1,98,-63,-93,-91,-39,115,39,-22,1,1,-88,-81,84,-37,-20,-43,-128,79,77,66,96,-30,20,15,-76,123,90,-71,-1,-126,60,-14,-2,-22,24,123,50,109,-118,7,-38,89,-34,-41,-50,-37,-96,-121,-2,105,-44,-59,-44,3,-58,-83,95,103,-46,119,104,94,-30,89,57,-19,-71,-104,124,64,0,-22,53,-83,-106,-51,75,60,123,-92,57,-40,-117,-95,-16,91,-71,-116,-44,71,27,-29,23,108,-55,121,-90,81,-103,118,64,-72,-43,-13,73,99,-43,-46,45,88,30,-18,-44,57,-39,104,12,41,-32,95,-104,105,-50,93,-86,-123,-53,-72,56,103,-80,23,31,49,-128,-66,-52,-124,101,-25,70,-55,125,-92,82,75,97,-14,-100,0,-44,-117,12,-88,-78,-35,-53,28,53,-27,69,39,107,-60,-72,-12,-21,57,-14,-30,-50,105,14,45,-45,125,103,50,95,67,6,-44,-49,22,57,-27,67,-107,66,-34,60,69,63,-48,93,-14,82,71,125,-86,-5,95,52,120,-33,57,-75,41,-58,-57,-94,87,75,125,117,-6,57,3,6,-48,-105,-119,-73,123,119,95,103,-25,84,-38,-38,76,63,96,0,-3,-98,-54,-86,123,59,-12,78,-71,45,-14,110,66,6,-48,31,-2,77,-98,33,-93,-83,51,-37,-50,-48,112,-106,-26,-35,-114,1,23,25,-56,117,-80,-95,18,17,-80,-70,67,-54,108,94,-99,-50,32,-126,126,-96,-69,-46,-55,-109,-114,20,-126,6,-70,43,53,89,75,-74,67,-117,85,-54,-125,73,115,2,-76,-71,43,-25,-27,-63,57,13,89,3,-72,-55,-91,12,-80,98,-28,119,-65,51,83,119,8,66,-97,42,-2,-23,-101,-73,-65,127,-6,-23,111,63,-4,-29,-13,-9,127,-5,81,-15,-33,125,-6,-2,-81,-33,-55,63,80,-102,26,-17,127,126,-1,-105,-49,-33,125,-7,63,-81,127,-3,-119,-73,-41,-100,119,54,-120,-73,7,80,-60,-37,123,-94,-41,-73,71,77,-6,-70,32,-14,-46,27,-78,-64,-108,-79,-83,-59,88,99,-90,86,-5,33,-33,55,100,-36,-6,-11,-92,42,102,-71,91,-76,56,38,-101,13,-4,-120,112,-85,-9,45,-82,-62,54,-117,-17,-46,-65,-76,78,-20,87,-128,-65,-75,-89,124,-128,-78,-113,-59,-86,-109,-75,-39,-125,115,-4,-83,45,-33,70,-96,-83,89,-80,120,66,57,19,-97,61,34,-36,-22,71,44,114,95,-59,98,-101,122,36,-107,24,-79,-120,112,-87,79,-103,-33,123,21,7,-82,105,20,-10,65,3,-4,-83,45,-18,-96,-4,-49,-104,-114,-43,78,42,71,28,56,34,30,16,110,-11,90,100,-28,-26,53,45,122,-90,94,59,89,55,34,2,80,87,55,121,30,59,112,-59,17,-84,83,76,57,-109,15,24,64,127,-92,-74,-69,123,-106,-94,63,-66,81,121,78,0,-22,110,-67,17,127,95,12,-10,98,111,-99,-128,-127,-86,122,-62,-43,-50,-73,38,-34,101,102,-2,75,-128,-121,-17,59,-105,101,103,68,19,79,-22,-108,70,28,-116,-120,0,70,-94,-104,-95,44,-50,-86,-1,54,-60,-42,82,52,-48,93,73,28,-18,-34,31,-22,18,52,-48,-99,50,112,-50,121,40,-117,-63,64,-75,-89,-99,-41,-45,-121,-59,96,56,-53,-77,-97,82,69,98,-124,96,-118,67,52,124,7,98,16,-89,55,6,-71,28,-26,23,70,4,-88,-34,-89,27,-101,98,36,119,-33,-60,100,7,120,56,42,-36,-38,95,82,111,-117,44,-64,12,12,84,53,-46,114,-42,75,98,36,-119,65,6,125,-43,-100,0,103,-120,124,96,55,54,-105,-84,35,107,-77,12,75,-56,-64,-42,-6,108,-13,48,91,60,-71,-78,86,101,-17,37,32,64,117,-13,18,-73,-116,-86,81,88,-106,-126,-127,-31,59,17,-5,101,76,-52,94,98,25,-38,-95,47,-100,-30,-31,-41,52,-10,-27,-24,51,-15,-49,120,33,-31,-77,-102,31,-91,-39,-88,57,58,31,26,4,13,-34,108,78,117,109,-77,-34,31,-7,77,18,125,109,-70,-102,112,2,84,119,81,-94,70,-115,44,-46,97,-32,-81,-85,-54,43,-101,115,-52,-89,-70,-1,15,-1,-70,-78,44,57,107,118,58,-48,8,26,-113,-122,126,-22,-76,104,-119,32,86,102,-15,117,-56,-128,22,73,66,112,-105,7,17,59,51,6,-13,-14,56,-2,107,-42,78,-112,91,124,-86,74,-19,40,65,-61,117,-91,-50,-31,127,-31,-86,98,-123,89,44,19,50,-66,-74,110,9,-78,-117,-63,41,-127,54,68,3,-35,38,1,-7,30,-2,41,100,-119,-50,-4,-99,4,12,-96,-97,-45,89,-37,37,17,-43,-18,22,-22,-104,6,4,24,15,-116,34,46,-21,123,52,15,7,48,28,40,-17,-92,-23,43,-97,45,-45,113,-58,-36,-57,-128,0,-44,37,58,43,-59,-91,-54,-42,-48,63,49,59,21,16,-128,-70,-4,-105,58,-50,-69,15,36,127,-94,-49,-50,9,-16,-39,-3,-40,58,-30,-22,-77,36,50,69,127,93,119,-45,-12,2,-122,62,85,-4,-8,108,76,-9,94,-94,-124,-34,112,-81,12,-96,-56,38,-39,35,-67,35,-31,-38,26,54,23,50,-27,-93,-27,66,-45,-123,1,-31,-50,-11,100,-75,68,98,-97,12,120,-54,36,63,44,-30,-117,8,64,-3,-92,94,108,92,62,101,53,16,119,-119,-71,111,17,-31,86,23,-21,55,-36,76,-100,-19,-75,-2,-112,-43,41,-64,-33,-38,-78,74,-50,121,-74,5,75,-84,123,14,-13,3,34,2,80,-81,-23,-52,110,82,10,-81,-75,109,13,98,-117,3,60,-48,-18,-87,-53,26,108,-79,69,-84,118,99,62,109,68,-128,-22,39,31,-101,-99,87,107,91,-24,-10,76,68,0,-22,50,-110,-74,-35,-118,-102,89,-29,-103,66,114,109,1,30,104,-85,-41,91,-20,75,-44,-100,-44,-102,123,-48,23,19,48,110,-3,38,19,-93,-116,51,44,90,-109,115,-20,-39,57,30,104,-81,-76,75,-73,81,-45,-112,89,-66,78,46,108,34,69,-116,91,95,-94,-58,-36,36,-118,-79,104,89,-97,37,-110,100,-6,17,-29,-42,31,-81,104,-58,-126,-73,4,125,39,-77,104,40,34,-36,-22,-77,105,-106,-46,-82,-102,67,22,-51,113,-24,-2,65,-56,0,-6,18,65,-119,-107,48,49,-27,16,-109,55,22,-35,-2,8,25,-73,-66,88,-25,51,108,-34,117,12,-7,122,-125,101,59,3,60,-56,-27,-105,-76,-59,-87,-78,-32,46,75,-77,-124,63,-20,-39,35,6,-48,-105,-107,-91,-75,-79,44,-70,-56,-113,103,-37,-109,17,-31,86,-105,33,-43,-25,-78,123,-103,67,2,99,-119,38,-40,-92,10,8,80,61,91,-32,-96,-5,28,8,-7,80,-17,-61,-35,-112,33,43,-80,-3,103,42,116,27,32,-118,108,-74,60,-46,27,90,-47,-112,-101,93,-9,-77,24,-108,-55,-94,-7,-120,0,54,66,116,-61,-25,-40,122,33,77,-120,-44,-43,72,90,45,34,-36,-22,18,110,-107,82,-35,-62,63,-45,62,-103,-91,-65,34,2,-40,104,-111,32,-76,84,-5,36,-30,-77,-20,58,-104,-125,22,17,-64,70,75,73,-39,-90,81,-25,122,-19,115,-78,34,-96,0,15,28,103,93,-25,-89,-11,-74,-74,-72,21,108,-9,-119,-61,65,56,-88,-127,121,115,-119,90,29,102,-78,118,-78,112,-112,19,96,-62,-93,21,-69,-5,-69,-44,-75,27,52,-86,-30,120,-96,45,-15,93,25,-61,62,72,-43,95,-39,-23,126,2,39,-36,-22,98,19,92,2,-1,-48,-40,7,33,-127,-34,78,-69,-71,125,-81,45,43,-37,-18,44,97,-64,-15,-73,118,87,-89,115,-38,12,-2,-48,-99,-80,66,-59,3,2,80,111,-22,-115,28,-73,-59,43,-34,-8,46,44,31,17,16,-128,122,-9,-7,107,-2,-98,17,-14,-95,-34,-57,71,-104,-102,-92,-80,-127,85,-123,17,33,66,-31,80,-16,-103,-98,-60,18,-14,3,-19,-36,83,95,113,-81,-77,104,73,93,-64,-128,-43,35,91,6,-122,117,-26,-28,91,54,86,59,74,-31,-80,122,-87,102,-105,-36,30,75,30,77,76,55,47,94,98,4,80,-45,37,-109,101,-75,-23,-64,-19,-11,39,-14,94,66,6,-48,-105,65,53,-90,13,47,-90,-38,-110,70,-26,87,-128,7,-38,-82,50,67,11,7,106,101,83,-117,-127,-127,-22,74,109,108,-69,-65,57,100,76,-51,-55,-117,-13,56,1,86,46,-18,-74,-69,117,13,101,-94,-51,51,-23,72,-31,4,48,-54,-85,-60,-6,-82,76,83,-116,-74,-116,-76,77,19,41,17,3,86,-68,-50,-26,-98,69,108,107,27,37,-86,121,101,4,80,13,92,37,-98,-77,-107,31,-22,53,75,-4,-56,107,-92,57,1,-28,-84,90,-102,-14,95,108,-68,-43,52,-3,75,107,106,3,2,-88,79,-22,-87,87,-105,-112,26,-78,66,-42,-67,-24,52,-115,24,-73,-66,-116,-41,61,-20,-106,-33,-48,61,-81,-55,-78,6,1,30,104,-97,-44,37,-40,-75,95,73,-116,95,91,-103,37,-56,66,6,-80,-27,26,-42,78,-101,30,-111,1,-96,1,24,43,125,11,8,64,93,108,91,-18,-53,61,-117,-8,-121,-99,-42,50,7,4,-96,-18,-10,-21,70,22,-29,39,81,47,83,-58,96,-72,-70,73,-112,104,11,-88,94,-113,80,39,-117,5,66,6,-44,63,-75,30,-9,-7,53,46,-39,-84,-32,53,32,-36,-22,91,2,80,9,-98,-19,11,-44,-52,96,-89,-33,51,32,0,117,49,25,18,-29,108,63,47,-14,-92,-123,-110,1,1,-88,-53,-62,-37,90,113,-63,-77,-116,7,113,27,-40,88,-113,24,32,-109,61,37,-50,-81,118,-49,71,-61,-72,-99,-23,-26,106,-56,0,-39,-26,46,78,-67,-85,124,126,-27,-21,-88,21,-117,8,64,-35,-19,50,-68,54,29,-104,44,64,62,-44,-5,-8,108,-63,113,-47,-3,107,-89,19,69,-103,0,69,-30,-53,103,122,39,-107,-66,-36,-22,-13,37,-123,77,-53,3,57,1,-60,-83,-17,18,45,-25,75,54,-113,-123,-83,4,-3,68,-105,-18,76,1,-28,67,-67,15,-1,-60,-77,-71,127,102,-118,-57,9,67,69,-128,34,65,-30,111,-41,-5,-8,31,-41,-113,15,97,112,-71,23,66,-111,120,-17,-111,-98,38,-128,-60,35,-80,-122,71,92,-39,-99,-37,102,-91,15,17,3,-24,15,61,-9,-107,29,90,-42,20,26,90,115,60,-48,-42,-3,-100,-75,-36,-58,66,-111,-43,-106,-19,115,68,4,-96,94,-46,17,-65,-46,-126,-73,-82,-27,-27,-80,10,-72,-120,113,-21,-49,-111,90,118,62,-9,-53,39,-87,44,-3,-62,-15,64,91,79,58,85,-121,125,-43,107,18,71,49,-64,67,109,59,-41,23,-33,-43,70,-56,-121,122,31,-65,60,-20,-18,-35,50,88,-57,5,81,36,-73,-7,68,79,-45,41,-37,21,69,-22,-17,-37,-67,-80,-55,-59,-15,-73,-74,30,121,-100,-39,109,-19,108,9,-6,51,27,-98,28,15,-76,37,64,-53,46,123,32,14,86,-17,-123,13,78,-114,-121,3,-65,-118,27,-21,-14,30,43,-99,67,-117,63,3,2,52,10,123,-115,-14,-50,126,-20,-63,78,123,70,-124,91,93,-2,-35,94,93,50,94,-106,62,9,110,-39,-10,100,68,-72,-44,-105,-2,39,-15,2,45,88,34,-13,-39,89,21,118,68,-72,-43,75,75,107,116,-101,-21,-49,116,105,100,-32,91,-75,118,9,-27,-121,61,-21,-85,-23,115,113,-19,-39,-98,67,-56,-8,-107,-6,31,110,38,-42,120,-105,33,-126,-119,68,-120,-62,63,-10,-103,-34,92,122,122,-39,-114,18,53,4,-115,77,-73,0,127,107,111,-79,76,-37,102,-19,-43,51,104,-109,106,115,-4,-91,-67,53,-82,-88,118,-63,-109,112,46,21,26,70,5,-8,91,-69,-107,-44,-89,-35,-71,-42,-35,13,-103,-88,100,13,11,-16,-73,-74,-42,-38,-52,62,-100,45,-84,-14,35,39,43,46,14,25,-32,-39,37,88,112,-89,69,116,-109,80,-1,-62,-98,-99,-30,111,-19,-94,-7,33,123,-2,82,35,-47,-78,89,-43,75,-128,-65,-57,-118,-60,60,-83,-43,105,29,-127,-70,-75,-26,-119,13,-106,-128,0,70,-71,-98,-108,-80,117,-106,-70,101,45,11,16,-77,110,28,127,107,-9,-99,78,-18,110,-115,-24,122,92,-3,-80,-13,72,33,-29,-42,-41,61,-18,-27,82,105,-78,110,-56,-54,-60,94,12,-57,3,19,-89,85,-100,-43,-71,-68,83,119,120,-55,122,24,-32,-95,-74,-75,63,-121,70,122,16,-7,80,-17,-29,-125,33,127,126,121,100,88,-121,0,81,-76,32,-12,-119,94,-47,-19,23,-29,10,104,94,102,-18,-61,70,104,68,0,91,-59,-14,-111,74,45,102,-64,105,-58,109,-55,2,-50,-36,-14,-120,-15,43,-11,63,126,-91,60,-13,65,102,0,-94,-120,41,121,-90,-41,-12,116,-84,25,-5,90,-96,85,114,99,101,2,17,1,-88,-65,118,-53,13,-74,105,127,-120,-54,-51,31,-59,-125,-75,-78,-90,-45,-86,61,82,-45,-11,120,-27,96,103,12,34,2,88,21,36,28,-55,-35,46,127,93,34,-108,81,104,113,70,-56,0,-6,18,-56,-114,-30,12,90,-106,-15,54,22,-85,80,10,25,-73,126,125,87,-101,67,-93,74,-120,124,-88,-9,59,-72,-117,-3,-111,-69,8,80,-60,93,124,-92,-9,-102,-23,-42,93,-24,50,16,-11,47,-52,-103,-89,120,-96,45,-111,-36,-34,-10,72,-127,90,-53,35,-127,5,19,-25,4,-80,76,-117,-31,-107,65,-15,-50,-115,18,55,-126,5,11,1,1,-66,-25,49,-49,124,-73,91,127,-60,4,-110,73,16,50,-128,3,-29,-66,-50,44,-4,59,34,-28,67,-67,15,31,-92,-37,-97,-72,27,7,46,126,16,69,102,-32,111,-41,-5,-8,31,-105,-35,63,51,113,81,31,68,17,-85,-5,-37,-11,126,-121,-124,-73,91,19,-49,-128,15,3,81,36,-31,-3,68,79,55,-3,122,-73,53,-55,50,65,82,57,-115,-19,4,71,4,80,-81,-39,82,-33,-37,-106,12,31,61,-123,-42,89,-47,70,68,0,-91,-87,75,-73,87,-84,-83,59,75,-53,15,88,96,23,17,-64,-77,107,71,1,-105,67,59,18,46,-97,-54,-42,-16,-120,112,-85,87,77,116,-69,-26,87,90,-9,49,-40,9,-83,0,15,-86,90,95,-119,69,-69,-73,43,62,-112,54,-67,96,7,-99,66,6,-84,60,-83,-67,-72,94,70,83,-100,35,122,44,46,34,0,-11,105,107,4,75,-34,-68,-56,23,66,-127,98,78,-66,-111,-39,-39,-119,29,81,101,96,-88,-22,-37,46,81,119,23,67,-97,42,126,-72,-91,41,-17,14,-53,-106,13,79,17,98,24,-4,-127,15,21,-85,86,73,-87,59,110,-95,-93,-92,-67,-40,-41,8,25,-72,-10,108,-37,83,92,69,-90,-69,88,-113,73,91,-95,113,2,-84,-123,-22,117,-72,-45,-99,-30,-14,-54,-32,96,-39,-49,-112,1,42,-118,106,42,18,101,120,-76,-116,70,-70,-107,19,50,64,37,-124,-60,43,-93,-70,30,106,-91,-75,52,90,101,-67,-76,34,-58,109,-114,-11,-41,-74,-18,-37,99,-55,-33,90,97,-119,-109,-112,113,-21,-21,-87,-50,-46,125,51,-78,-107,-10,102,77,81,34,-62,61,-7,-76,-49,-28,-5,19,-51,71,-52,119,102,-11,-94,33,3,-20,54,77,45,-53,112,99,77,-49,-87,-74,-51,91,23,5,12,88,-40,-100,71,-50,14,-83,39,-126,10,-85,48,10,25,-73,-2,-85,35,-31,-86,-66,-29,-95,-124,3,-115,-11,3,12,25,-64,-97,31,105,-55,63,-17,79,-39,75,8,92,105,106,44,98,0,47,110,-92,93,-102,63,104,47,-34,63,61,87,28,17,110,-11,-103,-109,56,-63,-51,127,43,-119,93,10,-21,-50,18,50,46,-3,-93,-127,-41,-102,126,44,-120,115,49,10,59,-15,20,50,110,125,61,-69,127,124,51,78,25,126,122,78,-112,-56,7,-124,123,37,-55,90,-98,-43,108,-119,-66,-52,-108,87,51,81,-14,-12,33,3,-24,-17,-102,92,-77,31,1,-81,116,88,-15,91,-128,-65,-75,-117,-8,-47,115,77,-25,-68,-24,-111,-58,-50,-126,-28,-112,1,-12,-59,-56,-26,119,29,32,-10,-47,-79,65,-26,109,-56,0,-85,-72,-104,41,25,12,-18,75,45,61,98,-64,-50,56,-123,12,-96,-65,-76,125,104,-9,-13,68,44,23,-19,-4,26,50,-128,-66,-68,-70,50,-69,107,77,-96,125,-111,39,59,-47,19,50,110,125,109,-51,89,93,-46,-80,-28,46,-18,-53,102,7,111,66,-58,-81,-44,-1,112,-33,-82,121,79,-84,118,-36,92,17,-95,-120,11,-13,68,-81,-22,62,98,47,-10,-32,108,-47,-82,29,-14,-54,-103,-25,21,49,-128,-66,110,61,29,-41,26,115,-107,36,15,-57,-126,-79,-112,1,28,71,-83,63,-74,81,-89,62,-116,-48,121,-81,91,78,0,69,-6,45,-27,-22,-19,-115,-106,-80,-118,-95,96,117,-59,17,3,20,-70,-9,87,-29,80,-121,22,91,-36,-26,97,-114,93,-60,0,-27,-30,122,34,-95,77,-5,-83,54,-83,-91,-92,104,88,38,62,102,117,-122,82,76,91,95,-121,-107,-52,-124,12,88,-26,94,106,119,-122,108,-45,76,23,69,-61,-9,-35,-59,107,-75,6,70,-113,-24,-10,-62,-22,-71,66,-58,-83,47,-98,-57,-100,-42,62,-42,-84,45,-47,50,-17,-91,-51,9,-9,88,95,-22,-41,-72,67,-90,-75,-106,-76,-24,90,28,17,112,-120,39,78,-39,-74,96,-7,-6,-107,-6,89,33,-29,-42,31,18,62,-119,95,-32,-48,18,38,47,-102,-80,10,25,64,95,70,88,43,-57,-94,95,-57,42,105,-38,39,100,0,-3,-11,-22,28,-15,110,118,52,121,-67,84,63,96,-128,-9,-81,-121,-75,-114,115,-118,-27,5,-113,74,61,-71,-112,1,70,-49,-111,-16,-43,86,15,-106,-111,83,-21,44,72,10,-16,-64,-54,31,61,-16,111,91,83,20,109,-89,-38,104,-85,-88,-112,1,-84,-68,118,57,-78,-57,64,-28,39,-22,95,120,122,-128,19,-64,-84,109,-38,-100,-62,-66,-59,-107,-60,94,-13,22,-14,20,15,-34,-116,-98,-89,-16,115,68,-81,-117,104,-76,-13,94,-56,-128,-93,70,86,99,-125,-99,106,-80,88,55,96,14,7,-54,106,60,-36,-50,-93,-82,-99,-107,30,-11,-114,8,96,52,-54,43,115,39,41,-102,30,122,-110,85,-104,61,121,64,-128,111,-35,-8,62,-83,-46,-75,3,34,31,-22,125,-4,70,-126,-17,56,88,113,-73,111,-120,34,-107,9,79,-12,-122,102,-27,-122,43,-102,58,90,86,120,104,59,-20,-128,112,-85,119,-115,-68,-19,85,26,-81,-90,112,117,-78,92,60,-57,3,109,117,21,-73,-51,-29,72,52,-46,70,101,-75,-33,17,1,-86,-69,-46,124,29,127,-107,-99,-122,-91,104,-96,123,-12,6,-118,95,-80,50,-72,-50,40,-20,16,47,-121,-125,52,-76,22,5,54,23,-80,-56,18,-79,115,-90,-30,17,3,84,-34,-52,84,-35,86,70,87,-9,101,-77,37,36,-64,-33,-38,122,-43,79,59,46,-25,52,-77,-74,-9,99,-121,3,67,6,-40,126,-45,-10,13,-42,-21,23,51,123,-24,-115,65,28,14,43,122,-114,107,-100,-92,30,127,-106,31,30,-76,-55,101,4,-112,125,44,-30,37,55,119,-65,-59,89,-87,55,-74,-12,69,4,-112,59,125,29,-113,-77,-31,74,45,57,-119,87,78,123,-111,68,12,-80,-47,-89,-89,79,-105,-83,-126,-85,-14,-21,-41,-36,-52,41,11,25,32,-77,-84,-39,-127,108,-85,-87,42,63,44,70,-47,-73,-82,-52,-33,93,-20,17,-108,90,52,109,-106,-103,47,22,17,-128,-6,-42,-18,34,-50,47,-41,-19,-45,82,121,7,-89,-128,1,-34,122,77,-30,-17,-72,32,84,-106,-49,81,-23,93,77,33,3,110,-127,-118,-115,118,-69,11,-38,-72,99,102,22,22,-121,12,-80,34,-55,79,-21,-42,3,42,58,-41,-5,102,-11,-5,17,1,88,73,-15,-127,-58,118,9,-54,87,35,32,86,35,21,17,110,-11,47,109,-51,-20,-20,-42,22,56,59,-77,-92,84,68,0,-22,-17,74,3,-76,-120,-9,-80,99,90,20,13,-84,-116,54,-86,26,-74,-62,-90,-108,-83,29,81,-7,30,71,-64,0,107,-98,-18,126,-40,-38,-125,50,-117,6,-113,116,-41,60,32,-64,82,-120,82,109,74,-69,-22,-99,52,-115,-74,44,-117,8,96,54,-55,42,86,-19,26,89,-75,108,-8,84,-38,-20,46,32,0,-11,-83,1,-71,77,-70,-44,-82,-114,-12,98,22,56,100,-64,66,-114,-20,-111,-76,-15,22,64,62,-44,-5,29,118,-70,-85,-21,21,-93,33,16,-36,-23,70,48,-110,92,126,-90,88,-12,-58,-120,-18,114,-12,18,-57,-49,-61,-74,114,35,2,80,-41,-84,-84,115,64,117,-37,-73,103,-38,-6,62,100,0,125,109,18,114,-20,-63,101,113,67,-59,-37,96,14,96,68,0,-22,-38,15,-40,29,-5,44,26,-124,-107,-59,28,-18,-112,-127,-12,-101,-81,70,-48,35,68,-115,29,-107,-29,112,-12,94,-78,30,26,-16,-58,-86,-73,-50,-9,-79,34,6,-39,107,-102,-82,-59,-77,56,74,-21,76,-74,34,-122,12,-96,47,81,-64,-36,46,27,-45,-101,88,-103,-59,28,-110,-112,1,-12,-59,115,-10,109,-7,11,-73,20,20,-115,116,-113,110,45,90,59,-34,-114,-98,-84,99,85,-80,33,3,-24,107,59,-22,101,-113,-121,20,-83,-14,27,-12,62,-51,-112,-127,-10,-8,-90,-90,94,108,-35,-103,94,15,65,111,-96,-119,8,-88,78,-89,-24,-59,-125,-82,19,-100,56,117,-67,-80,6,26,33,3,60,-3,-47,-116,-35,121,55,69,36,-50,96,27,112,1,1,-115,73,-19,-26,97,-35,34,61,-52,46,94,30,85,-25,4,-80,51,60,52,16,-83,-17,54,12,90,-18,-84,-3,82,-56,64,59,-37,-70,-19,99,-89,-57,-7,114,99,27,123,-6,-128,-128,-43,-121,-65,112,110,-121,-35,-99,66,6,-48,127,-3,-37,-82,48,79,91,-20,-10,78,45,113,-60,64,-10,76,75,-82,-35,45,-103,50,18,-38,90,116,-17,54,98,32,-69,-16,-14,-64,92,5,72,-109,-25,107,-20,16,71,-56,64,117,5,-30,36,-39,2,25,-103,-109,-38,69,-116,-41,21,48,60,122,-9,77,111,93,-79,-2,-35,-42,27,-72,120,-47,2,39,32,117,119,8,-86,30,122,-72,29,67,-97,42,-2,14,46,91,115,14,-42,-64,-67,44,48,-116,-43,51,60,82,20,111,34,-83,102,-9,116,-69,-4,-91,100,-38,-114,58,100,-96,-63,42,-18,117,-75,67,91,2,87,65,7,107,24,37,0,-11,33,96,119,-39,-80,44,117,-38,-113,-126,-106,121,68,12,108,-90,101,117,51,19,95,59,-119,-9,-55,95,14,39,96,119,121,-72,-29,73,69,102,101,93,-36,76,48,60,114,-106,-11,34,11,91,9,-96,-19,-2,-59,-92,112,35,17,48,-80,-2,60,-74,61,98,-109,-87,114,-58,-96,5,48,17,3,125,89,-67,107,-58,6,106,-6,52,-85,-46,-42,39,33,3,47,-17,-75,-38,32,-71,87,-67,61,-121,-43,-24,71,4,28,90,21,119,-7,-121,-98,-101,91,-117,-75,104,-120,8,64,93,-113,-36,-41,-29,6,-39,-44,-3,28,58,44,35,6,-48,23,91,49,-105,59,-106,-89,-82,-52,-90,55,-93,-123,12,-92,-81,-83,36,-83,-77,-47,-50,74,-93,-79,77,-61,-120,-128,-34,78,-42,-101,32,28,88,-5,84,110,22,-124,6,4,-28,118,-54,98,55,-36,40,-24,122,111,34,125,51,20,-113,108,-91,76,-25,109,-29,-90,62,-114,86,-42,-78,90,-33,-112,-127,-26,-84,-42,-77,-71,81,-96,71,53,-6,-94,69,95,17,3,7,-118,43,-37,-80,-84,-53,90,-67,-124,31,-60,-119,-124,-128,3,-24,-71,-86,3,-53,24,-90,-97,-107,-29,-47,-109,-21,127,113,-74,79,98,-125,87,-99,51,125,116,-50,64,-21,-56,76,-59,-42,-26,-11,-82,77,63,22,107,-11,16,17,80,-96,-91,91,55,-74,91,-77,-102,-90,118,38,-73,-107,1,3,-116,121,13,-25,-35,61,-101,-67,84,93,69,-39,119,13,8,-72,84,-45,117,120,-23,-123,-18,-54,50,48,80,-19,95,46,-21,-12,22,105,47,86,-84,20,17,-112,-6,-111,-59,-64,121,17,69,-42,-78,18,88,-32,-128,-127,-34,-119,-34,34,-65,-36,-71,107,113,-31,-13,56,84,63,96,96,43,-106,-89,67,-21,105,-91,-59,109,36,39,-32,-60,69,-73,-89,87,-122,56,46,-76,-11,47,-121,-93,121,52,-12,35,-39,-58,16,90,21,68,47,-4,-115,8,72,-67,-40,-109,85,-109,-9,-58,-62,-48,-89,-118,31,31,62,-108,-27,118,-48,79,-125,-89,113,49,-116,121,-7,-113,20,-11,122,-67,-99,-19,13,35,91,77,-53,-94,-69,101,33,3,101,50,100,37,118,-111,-9,-106,-8,-128,95,-106,19,17,-128,-70,-34,-45,-27,-86,-108,-73,30,24,-91,-41,78,69,4,-84,94,-113,-67,-73,103,107,61,66,102,-9,106,71,4,-12,-26,53,-1,99,-17,122,-38,18,123,84,46,78,-15,104,-87,-107,117,-39,-11,101,-40,122,105,115,102,59,-2,17,1,-123,61,106,-8,-20,-18,-41,-42,-101,-8,14,-69,50,43,34,-32,-112,48,47,107,-57,-59,-97,72,18,80,82,117,78,64,-22,71,-4,78,91,-46,-70,22,61,-87,73,-47,-24,-99,-120,35,-25,58,77,-81,-77,83,47,-36,-69,-31,4,-108,-59,-40,-78,56,-40,-9,-41,94,105,91,38,-50,-15,64,123,-27,119,-99,21,-9,-46,108,22,-37,-4,-116,8,104,-2,107,-44,101,119,27,-113,-34,37,66,123,119,70,4,52,67,-77,-104,6,-37,121,-19,-68,-70,-62,-79,-93,-44,17,1,-88,-21,-110,60,-36,-95,113,-34,-12,-125,-94,-47,59,41,-87,101,123,105,-44,-47,108,97,-91,-37,25,1,1,101,-1,-12,-124,-75,61,-95,-75,101,-59,92,-99,-6,-110,1,1,57,-38,-81,-84,-11,-79,-26,-7,117,-128,-100,102,13,56,1,45,-73,50,41,-122,-67,-94,96,107,75,-56,74,47,88,12,25,56,41,-47,123,117,6,90,102,74,101,-83,-112,35,2,-78,1,-38,73,-47,126,-90,45,113,-81,120,-68,52,-72,-116,24,-56,-86,-65,50,-6,-53,78,-115,-87,-121,21,105,-66,-119,19,-112,29,104,-55,-73,39,63,-38,-22,-91,6,118,-128,18,-48,-104,-41,-67,80,91,99,35,-127,-100,60,-54,-31,75,117,-64,64,-6,46,-49,123,-8,-15,123,12,125,-86,-8,-15,-82,95,115,117,-86,-38,-109,8,61,13,66,-31,-97,-9,76,47,-81,116,-38,-76,-55,60,-7,-110,106,82,-24,-57,102,-8,75,-5,52,109,22,110,47,14,125,117,-56,-28,-121,74,35,-62,-91,-82,-121,65,107,-79,-127,-116,94,32,-43,59,27,-90,1,-2,-82,102,-36,73,126,-107,-67,-88,99,101,-35,-80,-81,44,106,-117,8,-73,-70,43,72,90,-30,1,-119,-37,-55,-38,-74,97,-20,-3,54,-122,-70,81,-59,61,-64,16,3,-62,10,54,2,60,-78,-58,122,83,-83,61,75,-84,-67,98,-59,-71,-94,-98,24,39,-128,17,93,-45,88,-35,-18,41,-50,87,-49,20,90,-15,16,16,110,117,117,-115,115,-75,-119,53,89,-101,19,-83,96,14,-16,64,-37,25,6,-19,88,51,106,-89,69,38,12,13,116,-11,122,-35,-29,122,-27,-74,87,-85,4,102,34,3,2,-76,32,71,-100,20,123,101,92,-41,-107,-110,-42,93,-122,12,-96,-33,-45,46,54,123,-81,-3,-36,79,57,-4,123,114,2,74,57,107,-6,-55,70,-99,75,-81,-64,-101,-20,-114,-109,-120,-128,124,-90,-108,-75,7,-50,-16,-26,-19,12,58,94,34,-58,61,75,53,-123,92,92,93,-65,-82,-99,-103,-19,87,7,-8,91,91,124,-52,38,47,-51,-72,40,-21,-24,102,-3,100,-74,60,100,92,-6,-2,-38,-78,-99,53,11,-58,-100,119,-126,-67,-97,-7,36,9,0,-19,100,-37,-123,-9,-14,34,96,-108,-26,-108,40,-92,76,23,127,-117,117,-21,124,-41,-125,19,110,-11,-15,-70,110,-40,86,57,47,113,-100,121,-105,-30,-120,112,-85,111,45,79,-14,55,23,-50,-15,74,127,19,-11,-128,112,-85,-97,119,87,-26,109,-31,82,-113,-99,-128,-127,106,-111,-127,-28,110,-98,91,18,26,-46,-94,47,10,-121,111,-61,62,-62,-31,105,46,-124,124,-88,-9,107,92,-71,63,-3,31,-105,87,92,81,18,-102,0,0]},{"id":"a82d067d-43b1-4342-9588-5284698fd7fd","playerId":"11e178c5-8e89-432a-978e-fc95fd17f8bf","sequence":10,"gameId":"5a2376c6-3285-474c-9896-ee66829b77c2","timePassed":0,"sentence":"rooftop cat looking at the stars"},{"id":"3a3694a6-3571-4f02-997b-b6df4068ce2f","playerId":"11e178c5-8e89-432a-978e-fc95fd17f8bf","sequence":11,"gameId":"5a2376c6-3285-474c-9896-ee66829b77c2","timePassed":0,"drawing":[31,-117,8,0,0,0,0,0,0,0,-67,92,-53,-114,36,55,14,-4,-105,62,15,4,-119,122,-5,55,22,-40,-117,-31,-125,1,55,60,3,-52,-114,1,123,12,-17,-62,-16,-65,47,89,94,96,-91,82,4,43,-57,93,-29,99,103,71,68,101,-90,40,-118,20,-87,-4,-10,-9,-105,-113,31,62,-67,-2,-29,-11,-57,127,-67,126,-6,-4,-53,-53,55,-33,-2,-2,-14,-53,-25,-17,127,-2,-4,-14,-51,-17,47,-1,-2,-25,-9,31,127,125,125,-7,-90,-122,-8,-18,-27,63,-1,-5,-93,-76,20,-30,31,-17,94,94,63,-3,-16,0,-13,-57,59,-96,-43,46,104,-91,-40,-61,24,-110,-6,-118,-84,76,-111,-94,79,-35,-110,67,45,45,-114,21,-39,-126,-92,-100,-123,104,123,-116,83,-65,-73,-112,75,77,101,69,-113,-48,-54,-20,76,-33,99,-100,-6,-77,-121,58,82,-97,11,-70,-57,-112,-12,-39,-119,-68,67,56,-44,37,-107,-112,107,74,43,86,66,-84,-111,-87,123,-124,83,61,-21,-83,-28,57,-21,-118,46,97,-28,-34,-103,-68,-57,56,-11,-11,-71,106,-107,-74,90,65,87,-61,104,-93,16,121,-121,112,-86,15,-3,-49,28,-78,98,103,24,82,70,38,-22,14,-31,80,-49,49,-22,99,-107,-68,62,-23,72,65,98,30,88,-35,35,0,-11,25,102,47,-21,115,14,97,-109,-119,-127,79,-43,52,66,-49,115,-77,92,71,-106,-95,79,93,81,100,47,-46,-10,71,-77,57,72,-26,-112,-53,56,-11,-13,12,113,-50,86,118,52,-69,111,-122,-2,2,-35,-17,-34,-67,-4,-4,-6,-53,79,31,127,-3,-4,-31,-89,79,70,121,-1,-6,-31,-57,-9,-6,51,41,39,-75,-113,-33,62,-4,-16,-7,-3,-97,127,-36,-18,-31,-79,59,-106,-102,118,39,-38,-47,13,65,20,-74,-43,75,122,-71,-119,-70,-39,109,4,-43,121,-75,30,43,-103,2,30,-31,84,-97,35,12,117,-83,117,-97,48,69,29,33,113,15,46,-29,-48,87,-13,8,69,36,-17,-93,-45,122,26,100,-118,121,-124,83,-67,52,53,-63,-79,45,19,35,-121,-108,91,103,-14,30,-29,-44,-73,87,41,41,110,-58,85,-40,120,82,-12,-87,-37,107,104,-110,-25,14,-100,108,68,57,-4,84,86,-1,87,-30,40,-101,-121,-94,75,56,69,-97,-70,83,127,112,-42,-71,57,-88,-90,-50,80,26,-15,-13,46,-29,12,99,-94,-124,-108,-58,62,-18,116,-26,80,52,-48,-83,-70,-48,-57,-76,61,-31,-32,-70,4,13,116,-69,45,-25,-13,-86,46,65,3,93,117,103,-67,-76,29,88,115,39,-90,-31,-32,79,-19,20,-61,44,117,108,-32,73,-17,-103,-95,-127,-82,-24,-108,-19,43,112,-58,-37,21,-90,76,-15,64,59,-101,-55,-116,29,-85,87,38,-45,-90,120,-96,93,-125,104,72,-74,-50,-41,73,-105,36,-118,6,-70,-22,110,-37,-108,117,-76,-89,-36,46,49,105,78,0,-22,125,91,53,-90,-34,86,109,-12,85,99,-16,99,-43,25,-22,69,73,67,2,-67,-94,78,117,29,7,27,117,105,-44,-57,121,4,56,75,122,44,-21,26,84,-117,70,35,106,-81,-20,69,120,12,-96,-97,-62,76,50,23,19,109,-94,81,-15,20,58,13,57,1,-8,-46,30,114,-20,115,9,82,123,74,-70,-88,74,34,119,-17,50,-128,-66,38,55,-102,40,-3,31,60,52,110,109,-99,69,-75,14,30,106,47,-93,63,-44,-39,12,-23,100,50,50,48,124,35,11,112,-22,122,87,123,36,1,8,3,67,-43,-103,-73,100,32,-59,-86,-93,-46,70,-30,-46,-108,1,-12,53,-20,-111,28,-105,85,40,105,32,-95,-41,-104,58,-59,67,11,-116,43,78,-93,-82,-86,75,42,55,63,-120,126,-88,43,53,-121,-106,-90,99,-42,16,13,-33,-123,-122,-30,101,125,115,-94,111,83,77,-128,-65,12,70,0,119,-83,-55,115,-46,-43,121,1,-25,-40,-8,114,-53,-32,120,12,123,-100,23,-107,57,28,42,-57,-21,-86,39,20,-66,-123,-117,-118,24,-6,-73,40,-118,-59,35,85,-82,-86,50,56,-68,-41,-70,-123,-109,-113,110,23,-94,-79,-73,76,49,-115,-85,99,-59,-32,64,-39,-52,48,-73,-85,-62,4,-3,5,-70,79,79,121,45,8,92,70,-67,-58,-116,3,30,-128,-94,65,-27,5,-67,92,116,-106,-43,53,-120,-45,-96,35,105,-118,73,84,57,30,104,-73,32,-79,-106,53,-116,83,91,-23,37,50,31,-24,16,-128,-6,-74,54,-87,127,-77,-75,-125,-59,36,4,-4,88,85,35,-13,-98,-40,-6,72,-47,15,117,45,37,-47,39,-91,47,-126,-96,31,-21,-42,-112,52,58,98,-47,47,67,63,-42,-51,22,-45,9,9,107,40,-6,-79,-82,-48,-32,23,33,-95,-115,-35,-3,50,-101,15,8,9,-12,-22,-3,-81,82,61,-128,4,122,73,67,-45,57,87,-96,94,-47,24,-112,14,61,39,-100,-22,-74,-125,-109,-42,112,50,-9,-87,83,-120,-26,40,28,15,83,-74,62,116,-90,-84,96,-91,-105,58,-103,21,120,12,-80,125,82,-51,72,-30,-122,86,-105,-107,59,-117,24,29,2,-36,-82,82,-25,29,-41,71,109,58,-30,-87,69,98,111,46,-29,-44,-41,-100,32,-43,81,22,71,-104,-21,-48,-39,-92,105,60,-47,-9,24,-25,102,-95,-114,75,111,91,18,-107,107,81,-17,50,-104,-66,-53,56,-11,-117,-122,-14,43,50,-77,121,8,-111,96,-81,60,7,-37,-4,30,59,50,69,18,70,59,120,80,-103,-48,-103,-106,-73,125,-25,92,-109,-38,66,-102,-84,-82,-30,49,78,-3,22,109,87,-14,14,-52,118,-110,9,24,84,-125,110,-26,-70,-51,-28,42,58,-34,-22,117,89,53,-56,97,-64,90,-106,-108,-36,-5,62,-34,67,38,-13,-46,46,-29,-84,-60,-115,-87,-119,-23,-108,-11,110,-12,-39,99,79,-60,115,121,-124,83,-67,-107,-48,-13,54,-105,-101,-88,-79,-78,-51,38,7,127,106,-101,-89,-97,107,74,-110,91,11,125,106,46,65,-60,29,2,-88,-36,-114,80,-58,108,99,-125,-45,-3,72,14,63,-108,-11,-127,-42,5,-123,87,51,16,-16,-12,80,85,71,-10,22,-117,94,-72,75,6,6,37,-110,-112,70,26,-75,-20,-56,-39,102,99,69,12,-113,1,106,-100,65,90,25,-37,18,-43,-24,-58,41,69,-125,-39,-94,-26,-109,101,-34,33,71,106,-115,-51,70,-113,1,-22,-18,97,-114,30,-41,-99,-42,-37,-30,-60,106,-18,4,125,-24,-114,-48,-85,-34,-58,-102,5,-21,122,23,-12,-95,-39,-10,-101,-53,56,109,110,-77,-92,110,30,120,48,-1,65,-80,-113,53,107,42,108,-22,17,-20,35,77,125,127,-110,-39,-56,17,-20,35,77,90,-70,1,-72,-65,93,-21,-23,-23,102,-110,61,124,37,109,42,8,-123,77,-6,-102,-34,-35,-114,118,-41,-96,94,6,107,-19,32,96,-88,58,75,-110,-83,-2,53,-125,6,20,-84,-12,-23,50,-128,-2,-44,-80,121,75,122,-25,12,51,69,86,-112,-13,8,-32,29,111,-18,-4,-74,17,-56,-34,49,64,94,-44,123,126,-119,62,-57,125,-64,-95,-1,-126,40,18,-3,92,-46,43,61,100,93,-99,-73,110,34,13,-84,-57,96,113,-67,-53,0,45,5,49,-76,-103,-41,106,-89,58,-112,86,74,102,-14,14,1,-88,-85,51,-46,-43,111,-75,58,93,121,-85,94,103,-22,-100,0,-30,88,9,121,-85,79,-50,108,23,-40,-18,-123,-125,7,-21,114,-43,-20,101,-81,-86,106,-26,-104,98,100,-63,-90,67,0,-22,123,-49,28,47,-107,66,-28,69,-67,-89,79,-127,-68,-105,71,-12,-43,-63,-112,9,-95,72,-65,-57,21,61,-51,-128,53,-22,73,107,1,-84,-108,100,27,57,-52,70,93,6,-48,-41,68,56,-41,-75,118,82,106,11,99,10,77,109,61,6,-48,-41,-84,-73,109,-59,93,-117,79,122,102,-115,102,30,-127,36,-26,-91,-36,77,-103,-34,-123,53,79,56,4,-96,-82,73,-121,-122,110,91,-7,88,-125,-39,49,88,15,-113,-53,0,-6,-10,-38,-26,-22,-67,53,-87,-46,88,-103,-119,51,56,80,-98,-95,-113,82,-73,-86,-17,-80,21,-113,-11,14,-72,12,-48,125,-108,-126,-58,-80,-117,9,84,41,-102,-7,36,86,-95,-29,-8,47,-46,126,-2,-92,-82,99,-99,-124,18,113,-85,24,66,-31,73,125,77,-81,105,-24,43,53,109,53,-70,-82,57,-24,76,-84,18,-23,83,-64,47,-108,-67,112,-87,-109,42,-105,-54,58,14,25,26,-24,86,-37,-55,-39,106,36,-106,-13,42,-102,102,-124,14,3,-24,-85,-115,-89,-76,-74,43,36,94,-38,-95,104,-96,59,-126,70,-109,107,-13,-98,-35,69,-19,116,-105,-37,101,-128,29,-68,26,-92,-53,88,75,-48,26,-103,85,-11,-116,108,-75,-9,41,-25,47,12,-11,92,-71,-54,94,-47,11,18,-123,-10,-111,122,12,-96,-81,126,42,-53,-22,120,83,-42,48,86,82,37,91,-76,46,3,46,-116,50,54,-5,45,-73,43,-119,-72,59,-113,0,-106,25,-37,-45,24,107,-2,-82,110,94,35,16,86,-127,-9,8,-64,-99,106,-112,-89,-82,112,-83,78,107,84,-103,27,51,30,-113,0,-99,-75,6,-64,59,-72,-4,121,-119,59,107,-54,0,14,85,116,69,-107,-75,-97,56,-23,-60,-119,54,115,-104,-69,118,24,64,63,-121,-19,78,58,-37,93,-122,72,-96,103,27,-39,109,-5,-15,97,87,-40,38,-120,71,-128,-115,-77,26,-67,-52,-43,103,-12,104,125,-1,-111,-107,34,60,6,-48,31,-95,105,-28,-101,119,-12,72,-79,-46,-73,-30,48,78,-3,61,115,74,26,28,49,93,-124,4,122,106,-105,67,51,-104,-69,-89,-117,-76,-45,-41,33,0,-11,-84,102,51,-5,-35,-88,15,-95,-123,25,-121,0,-44,-53,110,79,-68,33,23,33,-127,94,-73,93,-26,-75,-119,57,89,102,90,-72,27,-15,24,-96,78,37,-10,112,-37,-102,82,-85,109,21,-48,104,-40,99,0,125,77,125,90,-115,-21,76,-88,-102,-10,-11,76,-69,-123,60,6,-40,101,-74,-118,-30,-42,79,-103,84,-96,100,-55,108,-18,120,12,-48,22,-34,67,-23,-5,76,46,124,27,-101,-95,65,91,-8,-80,-10,-86,-103,-9,-69,-120,-67,-77,-75,-51,101,-128,-58,-111,91,-49,-32,90,-115,-77,-73,24,123,99,71,-115,92,6,104,-47,-55,97,-58,117,-1,-22,102,4,-115,-83,15,14,30,54,2,-41,122,24,-16,100,39,-56,28,60,-88,88,-21,127,-30,22,32,-76,91,-45,7,-37,4,-12,8,-80,30,110,-67,40,-85,31,-54,106,90,41,-78,118,22,-121,0,107,-7,49,-21,-46,-78,-96,-121,-70,-71,25,11,107,22,-12,24,-80,-9,64,122,-34,-98,-43,78,13,-44,-106,104,-33,-123,-61,0,-6,58,21,-6,-42,80,55,-85,-90,-117,-125,53,-107,122,-124,83,-67,88,-13,-53,114,39,26,85,106,48,-56,-20,-111,-95,-127,-82,58,-97,-74,30,-63,-69,-91,80,35,51,7,-29,17,-128,122,-34,-77,-77,-95,-85,108,-55,-20,-123,48,-12,67,-35,20,45,78,-91,93,-23,12,13,117,-37,-40,-10,27,37,-91,63,47,113,109,-54,0,-6,-43,-122,124,-84,-32,114,-37,-56,-93,3,-55,9,88,125,71,-78,-18,26,-124,-68,-88,-9,-4,-42,-68,-69,-97,17,124,54,3,-95,46,61,28,-42,107,-10,52,115,-19,71,-79,-77,-82,73,38,-37,16,-16,8,-96,-40,108,-119,-91,-36,-127,105,-63,25,-125,-127,-22,-80,-45,66,-85,53,-60,-88,-53,-67,20,86,83,116,8,-89,-70,-122,-81,86,126,109,43,90,29,82,107,100,94,121,4,120,-17,67,51,-19,-66,26,-108,-24,98,16,-39,-42,-95,-53,-128,111,60,-27,-68,-126,53,-7,-23,26,81,-48,119,-61,9,-89,-70,-6,-72,-78,-19,123,-120,21,-11,7,-37,-97,119,-16,-89,101,-113,108,30,117,-59,-10,30,122,21,-26,19,56,-2,-44,110,-10,-112,109,61,-38,-98,53,86,105,-103,-18,-110,-72,-116,83,-33,-70,115,-58,-42,-81,99,-101,-104,-87,-45,53,-37,33,64,119,-100,70,93,107,-19,-39,18,-97,76,59,48,29,2,88,-80,103,-48,59,89,111,69,-105,77,-99,-120,-20,-40,-125,71,-128,-22,107,-75,-95,-34,-102,87,121,7,45,65,63,-42,-27,-25,-68,16,-14,-94,-34,-45,-99,124,-39,119,60,5,-41,31,33,-118,-28,34,-105,-12,-90,-82,-4,45,-82,71,-12,-109,29,-27,81,-117,96,-7,-97,-57,0,-6,-43,-54,15,-21,100,17,-99,44,122,57,-45,-45,34,14,3,-24,91,-21,-44,26,-32,74,-46,-112,-70,13,22,113,123,4,-8,118,74,-22,107,-17,-112,45,-106,-109,127,14,-62,101,-128,30,-44,97,-3,-93,107,-66,40,22,-104,74,105,108,-85,-61,99,0,125,-101,37,109,-19,79,-78,114,-12,72,-125,117,46,-70,12,-112,-59,22,-5,-64,67,-49,-69,23,-97,37,-78,72,-45,101,0,107,-73,5,110,109,83,-70,-11,40,106,94,-54,-110,100,-121,-16,101,-22,-49,15,-30,82,-35,-9,-66,-16,-47,23,-124,-94,-35,-50,23,-12,-44,-8,-46,-36,-42,112,77,-22,103,-100,-52,0,60,2,-52,24,91,-38,66,-5,-86,107,85,108,-84,49,-59,35,96,-57,-69,-11,115,74,-19,118,22,-98,-26,2,14,1,44,-99,-37,-127,55,41,58,75,117,5,-89,105,6,65,-109,-69,94,-109,86,-79,-125,127,-77,-45,-13,-86,14,1,-88,55,13,109,-42,109,118,-111,-92,96,-98,126,57,4,-68,3,-112,118,-17,24,111,-37,-119,108,-73,-50,101,0,125,-115,31,101,-84,-29,127,11,-28,-43,-35,83,-125,113,24,95,-88,-1,-4,82,-19,-40,-89,32,-7,108,9,66,-111,-14,-43,37,-67,-98,-52,-10,-42,50,-108,125,104,-89,-76,-60,-14,4,-105,1,11,-98,101,-5,-42,-117,-75,-77,103,-70,-107,-30,-32,-127,-74,-124,60,-46,102,-114,-77,4,-95,31,61,-16,8,-96,40,-34,-11,63,121,-39,121,-55,-47,-70,-18,7,-53,-49,60,2,80,-73,111,25,-28,-11,43,9,118,22,47,13,97,29,-23,46,-29,-44,47,45,104,24,-78,53,106,-89,104,-51,-37,-12,27,69,30,3,-24,-85,57,69,25,107,-34,-110,116,-66,-108,-50,98,110,-105,113,-22,-21,-28,-45,95,-114,119,-103,75,-49,-99,29,-40,113,25,-89,-66,-76,32,-22,111,86,-76,-26,-93,69,-17,-122,-23,123,-116,83,63,-11,-48,102,-33,14,-32,-120,-99,78,-94,-57,60,92,-58,-87,31,-11,95,125,59,-99,100,-49,-33,-40,105,68,7,15,-76,83,24,58,-10,-21,-99,100,91,88,-103,95,-11,8,103,59,-37,-108,-37,106,-73,30,-106,41,-10,-39,-128,-63,-66,98,-32,50,78,125,-21,41,-116,-91,-27,21,-83,-29,-92,104,-42,-11,-24,49,64,59,-34,8,-46,-6,-6,-84,-123,-18,-4,49,48,80,-51,-73,77,-87,117,118,20,107,58,20,-10,82,28,2,80,79,-42,-45,-74,-75,-24,-105,17,-110,12,-74,-107,-27,50,-96,-66,-122,24,-21,99,106,98,59,-123,69,41,14,30,104,-105,61,99,-90,65,44,68,94,-44,123,-2,114,-98,-10,68,-65,-32,78,41,-124,34,-18,-31,-118,-98,21,30,70,-82,121,91,36,-110,125,122,-128,5,-47,46,-29,108,-57,86,123,94,87,79,-2,81,43,-120,60,-11,116,81,-21,-79,-82,-98,67,-86,29,-68,-20,44,70,116,25,-89,-66,-99,-69,-51,99,13,40,-77,-43,-9,58,91,-60,61,2,104,78,-41,21,-65,-12,109,71,86,-121,-87,-75,-52,106,46,46,3,-24,-21,-110,-103,-26,-10,101,48,43,119,-40,53,-90,-17,48,78,125,-5,126,-112,-6,-43,109,71,-71,7,-21,121,98,-121,-53,60,6,-48,79,-101,13,88,127,25,-45,5,72,-88,55,-19,123,116,43,-44,90,82,-11,-74,-40,120,-70,20,-16,11,26,-111,-44,-40,-28,110,-128,70,111,-107,13,-87,75,1,-65,-96,-81,107,-52,-11,11,19,114,-37,-40,-97,108,-105,-61,101,0,-101,105,-74,-84,-81,-101,-78,-106,95,118,-75,2,118,-44,-47,99,-100,-6,-42,-79,17,-91,110,-31,-65,-82,-11,-71,-77,-18,75,-105,1,60,66,11,-6,-26,-30,90,-15,-76,22,-29,73,77,-46,33,-100,-22,118,16,-80,110,-99,-4,22,-28,-38,37,118,110,-57,99,0,-1,104,7,26,-30,90,-81,-51,-42,-42,60,34,59,-73,-32,50,78,125,-5,80,-90,-84,-19,44,-74,46,116,13,-67,-104,-68,67,0,-22,53,-88,33,-84,-97,-11,-53,-62,15,-16,48,52,-48,-19,86,-39,-113,-13,-94,46,65,3,-35,-37,41,-89,-19,-92,-89,-89,75,-48,-89,-82,6,-100,-87,-10,-70,-65,-76,-87,126,-125,45,74,14,1,-88,55,-117,-93,-74,-56,77,-17,-93,-74,-62,2,84,-105,1,-12,-9,-125,23,66,-65,-6,0,-111,23,-11,-98,30,48,-11,-70,-97,-12,-126,29,108,8,4,31,-19,-81,-85,61,-3,-63,82,-84,91,-24,-122,-9,86,33,10,-113,-38,27,-12,-98,-2,112,51,110,-65,34,-72,61,29,-94,-32,-61,-67,69,-17,-23,15,55,-26,-42,-55,82,-31,-12,64,32,-8,104,127,93,-19,-7,38,105,61,-89,-37,11,-60,-33,95,-121,48,22,24,-66,65,-15,-7,102,89,-10,-45,-74,5,126,31,7,-94,-80,89,-66,65,-17,-7,102,-103,-10,-29,44,-8,107,-94,16,-123,13,-13,13,122,95,-63,52,-21,93,41,10,47,74,16,70,76,-13,45,-118,95,99,57,72,23,94,55,-122,-79,5,-31,13,-118,-49,55,-49,-72,31,-98,-49,-80,33,12,-94,-80,121,-66,65,-17,43,-116,-34,-36,78,-64,-63,123,65,32,50,114,127,85,-19,-7,15,38,99,91,121,44,43,-124,-25,-15,17,-116,-28,-107,111,81,-4,26,-114,101,123,-115,-10,-75,32,-20,6,0,-116,57,-106,55,40,126,5,-45,44,91,56,43,120,-1,19,-61,-120,121,-66,69,-15,75,30,-16,-69,-1,2,53,5,-88,-84,-40,102,0,0]},{"id":"f46236e5-0fe7-4619-8577-02b375821c2b","playerId":"11e178c5-8e89-432a-978e-fc95fd17f8bf","sequence":12,"gameId":"5a2376c6-3285-474c-9896-ee66829b77c2","timePassed":0,"sentence":"a cat views the stars from the astronomy tower."}]"""
        )
    }
}


@Preview
@Composable
fun PreviousGameScreenPreview() {
    AppTheme {
        PreviousGameScreen(
            modifier = Modifier,
            PreviewData.entries,
            onBack = {},
            onContinueGame = {},
            onBackupGame = {},
            onImportGame = null,
        )
    }
}
