/*
 * Chronal: Metronome app for Android
 * Copyright (C) 2025  cognitivity
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package dev.cognitivity.chronal.rhythm.metronome

import dev.cognitivity.chronal.rhythm.metronome.elements.RhythmAtom
import dev.cognitivity.chronal.rhythm.metronome.elements.RhythmNote
import dev.cognitivity.chronal.rhythm.metronome.elements.StemDirection

data class Beat(
    val duration: Double,
    val isHigh: Boolean,
    val measure: Int,
    val index: Int
) {
    constructor(atom: RhythmAtom, measure: Int, index: Int) : this(
        duration = atom.getDuration() * (if(atom.isRest()) -1 else 1),
        isHigh = if(atom is RhythmNote) atom.stemDirection == StemDirection.UP
            else false,
        measure = measure,
        index = index
    )
}