# Support Table

## Authentication
```
+------------------+--------------------+--------------+--------------+-------------------------------------------+
| Manufacturer     | Authentication     | Auth type    | Required     | Notes                                     |
+------------------+--------------------+--------------+--------------+-------------------------------------------+
| Shimano          | Yes                | Just Works   | For writes   | 2-part handshake (on top of Just Works)   |
|                  |                    |              |              | Requires passkey                          |
+------------------+--------------------+--------------+--------------+-------------------------------------------+
| SRAM             | Unknown (WIP)      | Unknown      | Unknown      | Still a WIP                               |
+------------------+--------------------+--------------+--------------+-------------------------------------------+
```

`Auth type` is the [Bluetooth Pairing Method](https://www.bluetooth.com/blog/bluetooth-pairing-part-2-key-generation-methods/)

## General
This table shows the attributes that should be available even when your component doesn't have explicit support.

They will only show up if a valid value was returned when BikeBridge requested it.
```
+------------------+--------------------------+
| Operation        |  General                 |
|                  +------------+-------------+
|                  | Read       | Write       |
+------------------+------------+-------------+
| Battery level    | Yes        | N/A         |
+------------------+------------+-------------+
| Battery health   | Yes        | N/A         |
+------------------+------------+-------------+
| Manufacturer     | Yes        | N/A         |
+------------------+------------+-------------+
| Firmware version | Yes        | N/A         |
+------------------+------------+-------------+
| Serial number    | Yes        | N/A         |
+------------------+------------+-------------+
```

## Powertrain
```
+------------------+---------------------------+
| Operation        |  Shimano EP8              |
|                  +-------------+-------------+
|                  | Read        | Write       |
+------------------+-------------+-------------+
| Speed            | Yes         | N/A         |
+------------------+-------------+-------------+
| Avg. speed       | Yes         | N/A         |
+------------------+-------------+-------------+
| Max speed        | Yes         | N/A         |
+------------------+-------------+-------------+
| Cadence          | Yes         | N/A         |
+------------------+-------------+-------------+
| Beep             | Yes         | Yes         |
+------------------+-------------+-------------+
| Language         | Yes         | Yes         |
+------------------+-------------+-------------+
| Display colour   | Yes         | Yes         |
+------------------+-------------+-------------+
| Display units    | WIP         | WIP         |
+------------------+-------------+-------------+
```

## Drivetrain
```
+----------------+----------------------------+
| Operation      | EAGLE AXS Transmission     |
|                +------------+---------------+
|                | Read       | Write         |
+----------------+------------+---------------+
| Gear           | Yes        | WIP           |
+----------------+------------+---------------+
| Micro adjust   | Yes        | WIP           |
+----------------+------------+---------------+
```
