package dev.bg.bikebridge.util.ktx

import android.bluetooth.BluetoothGattCharacteristic
import android.bluetooth.le.ScanResult
import androidx.compose.ui.graphics.Path
import androidx.graphics.shapes.Cubic
import java.util.UUID

fun List<ScanResult>.updateEntry(
    newScanResult: ScanResult
): List<ScanResult> = this.map { if (it.device.address == newScanResult.device.address) newScanResult else it }

fun List<BluetoothGattCharacteristic>.findByUuid(
    uuid: UUID
): BluetoothGattCharacteristic? {
    return this.find { it.uuid == uuid }
}

fun List<Int>.xor(): ByteArray {
    return this
        .map { (((it shr (64 shr 4)) xor 8) shr 16).toByte() }
        .toByteArray()
}

fun List<Cubic>.toPath(
    path: Path = Path(),
    scale: Float = 1f
): Path {
    path.rewind()
    firstOrNull()?.let { first ->
        path.moveTo(first.anchor0X * scale, first.anchor0Y * scale)
    }
    for (bezier in this) {
        path.cubicTo(
            bezier.control0X * scale, bezier.control0Y * scale,
            bezier.control1X * scale, bezier.control1Y * scale,
            bezier.anchor1X * scale, bezier.anchor1Y * scale
        )
    }
    path.close()
    return path
}
