package dev.bg.bikebridge.util.ktx

import kotlin.math.PI
import kotlin.math.pow
import kotlin.math.sqrt

infix fun Float.squarePythagoras(
    x: Float
): Float {
    return this + sqrt(x.pow(2).pow(2))
}

fun Float.toRadians() = this * PI.toFloat() / 180f

fun Float?.isValidReadout() = this != null && this >= 0f
