package dev.bg.bikebridge.util.ktx

import java.nio.charset.Charset

fun ByteArray.startsWith(bytes: ByteArray): Boolean {
    try {
        for (idx in bytes.indices) {
            if (this[idx] != bytes[idx]) return false
        }
        return true
    } catch (e: ArrayIndexOutOfBoundsException) {
        return false
    }
}

fun ByteArray.toHexString(): String = joinToString(separator = " ") { "0x%02X".format(it) }

fun ByteArray.toUtf8(): String = toString(Charset.forName("UTF-8"))
