package dev.bg.bikebridge.ui.screens.permissions

import androidx.compose.foundation.border
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.lazy.LazyColumn
import androidx.compose.foundation.lazy.items
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Text
import androidx.compose.material3.TextButton
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.unit.dp
import androidx.compose.ui.unit.sp
import com.google.accompanist.permissions.ExperimentalPermissionsApi
import com.google.accompanist.permissions.PermissionState
import com.google.accompanist.permissions.isGranted
import dev.bg.bikebridge.R
import java.util.Locale

@OptIn(ExperimentalPermissionsApi::class)
@Composable
fun PermissionsScreen(
    permissions: List<PermissionState>,
    launchPermissionsRequest: () -> Unit,
) {
    Column(
        Modifier
            .fillMaxSize()
            .padding(top = 32.dp)
            .padding(horizontal = 16.dp)
    ) {
        Text(
            stringResource(R.string.permissions),
            fontSize = 32.sp,
        )
        LazyColumn(
            Modifier
                .fillMaxSize()
                .padding(top = 16.dp),
            verticalArrangement = Arrangement.spacedBy(8.dp)
        ) {
            items(permissions) { p ->
                PermissionItem(
                    p,
                    onGrant = {
                        launchPermissionsRequest()
                    }
                )
            }
        }
    }
}

@OptIn(ExperimentalPermissionsApi::class)
@Composable
private fun PermissionItem(
    permission: PermissionState,
    onGrant: () -> Unit
) {
    val isGranted = permission.status.isGranted

    Row(
        Modifier
            .fillMaxWidth()
            .border(
                1.dp,
                MaterialTheme.colorScheme.onBackground.copy(alpha = 0.4f),
                RoundedCornerShape(4.dp)
            )
            .padding(vertical = 4.dp, horizontal = 8.dp),
        verticalAlignment = Alignment.CenterVertically,
        horizontalArrangement = Arrangement.SpaceBetween
    ) {
        Text(
            permission
                .permission
                .split(".")
                .last()
                .split("_")
                .joinToString(" ")
                .lowercase()
                .replace("access", "")
                .trim()
                .replaceFirstChar { it.titlecase(Locale.getDefault()) }
        )
        TextButton(
            enabled = !isGranted,
            onClick = { onGrant() },
        ) {
            Text(if (isGranted) stringResource(R.string.granted) else stringResource(R.string.grant))
        }
    }
}
