package dev.bg.bikebridge.ui.screens.bike.components

import androidx.compose.animation.AnimatedContent
import androidx.compose.animation.AnimatedVisibility
import androidx.compose.animation.ExperimentalAnimationApi
import androidx.compose.animation.SizeTransform
import androidx.compose.animation.fadeIn
import androidx.compose.animation.fadeOut
import androidx.compose.animation.slideInHorizontally
import androidx.compose.animation.slideOutHorizontally
import androidx.compose.animation.togetherWith
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.size
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.unit.dp
import androidx.compose.ui.unit.sp
import dev.bg.bikebridge.R
import dev.bg.bikebridge.data.state.SramAxsState
import dev.bg.bikebridge.util.ktx.isValidReadout

@OptIn(ExperimentalAnimationApi::class)
@Composable
fun SramInfo(
    sramAxsState: SramAxsState
) {
    Column(
        Modifier.fillMaxWidth(),
        verticalArrangement = Arrangement.spacedBy(12.dp)
    ) {
        Spacer(Modifier.size(6.dp))
        Text(
            stringResource(R.string.sram_axs),
            fontSize = 24.sp,
            fontWeight = FontWeight.W400
        )
        Spacer(Modifier.size(8.dp))
        AnimatedVisibility(sramAxsState.gear != null) {
            if (sramAxsState.gear.isValidReadout()) {
                Column(
                    Modifier.fillMaxWidth(),
                    horizontalAlignment = Alignment.CenterHorizontally,
                    verticalArrangement = Arrangement.spacedBy(8.dp)
                ) {
                    Text(
                        stringResource(R.string.gear),
                        fontSize = 24.sp,
                        fontWeight = FontWeight.SemiBold
                    )
                    AnimatedContent(
                        targetState = sramAxsState.gear!!,
                        transitionSpec = {
                            if (targetState > initialState) {
                                (slideInHorizontally { it -> it } + fadeIn()).togetherWith(slideOutHorizontally { it -> -it } + fadeOut())
                            } else {
                                (slideInHorizontally { it -> -it } + fadeIn()).togetherWith(slideOutHorizontally { it -> it } + fadeOut())
                            }.using(
                                SizeTransform(clip = false)
                            )
                        },
                        label = "Gear value animation"
                    ) { gear ->
                        Text(
                            gear.toString(),
                            fontSize = 64.sp
                        )
                    }
                }
            }
        }
        Spacer(Modifier.size(16.dp))
        AnimatedVisibility(sramAxsState.microAdjust != null) {
            if (sramAxsState.microAdjust.isValidReadout()) {
                Column(
                    Modifier.fillMaxWidth(),
                    horizontalAlignment = Alignment.CenterHorizontally,
                    verticalArrangement = Arrangement.spacedBy(8.dp)
                ) {
                    Text(
                        stringResource(R.string.micro_adjust),
                        fontSize = 24.sp,
                        fontWeight = FontWeight.SemiBold
                    )
                    AnimatedContent(
                        targetState = sramAxsState.microAdjust!!,
                        transitionSpec = {
                            if (targetState > initialState) {
                                (slideInHorizontally { it -> it } + fadeIn()).togetherWith(slideOutHorizontally { it -> -it } + fadeOut())
                            } else {
                                (slideInHorizontally { it -> -it } + fadeIn()).togetherWith(slideOutHorizontally { it -> it } + fadeOut())
                            }.using(
                                SizeTransform(clip = false)
                            )
                        },
                        label = "Micro adjust value animation"
                    ) { microAdjust ->
                        Text(
                            microAdjust.toString(),
                            fontSize = 64.sp
                        )
                    }
                }
            }
        }
    }
}
