package dev.bg.bikebridge.ui.screens.bike.components

import androidx.compose.animation.AnimatedVisibility
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.size
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.platform.LocalContext
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.unit.dp
import androidx.compose.ui.unit.sp
import dev.bg.bikebridge.R
import dev.bg.bikebridge.ble.BleConstants
import dev.bg.bikebridge.data.state.ShimanoState
import dev.bg.bikebridge.ui.components.Bolt
import dev.bg.bikebridge.util.ktx.isValidReadout
import kotlin.math.absoluteValue

@Composable
fun ShimanoInfo(
    shimanoState: ShimanoState
) {
    val ctx = LocalContext.current

    Row(
        Modifier.fillMaxWidth(),
        verticalAlignment = Alignment.CenterVertically
    ) {
        Column(
            Modifier
                .fillMaxWidth()
                .weight(0.6f),
            verticalArrangement = Arrangement.spacedBy(12.dp)
        ) {
            Spacer(Modifier.size(6.dp))
            // 10 bytes
            Text(
                stringResource(R.string.bike),
                fontSize = 24.sp,
                fontWeight = FontWeight.W400
            )
            Text(stringResource(R.string.mode, ctx.getString(shimanoState.mode.res)))
            Text(stringResource(R.string.speed, shimanoState.speed.absoluteValue))
            Text(stringResource(R.string.cadence, shimanoState.cadence))
            // 17 bytes
            if (shimanoState.gear.isValidReadout()) {
                Text(stringResource(R.string.gear_placeholder, shimanoState.gear!!))
            }
            // 19 bytes
            AnimatedVisibility(
                shimanoState.totalDistance != null ||
                    shimanoState.averageSpeed != null ||
                    shimanoState.maxSpeed != null
            ) {
                Column(
                    verticalArrangement = Arrangement.spacedBy(12.dp)
                ) {
                    if (shimanoState.totalDistance.isValidReadout()) {
                        Text(stringResource(R.string.total_distance_km, shimanoState.totalDistance!!))
                    }
                    if (shimanoState.averageSpeed.isValidReadout()) {
                        Text(stringResource(R.string.average_speed, shimanoState.averageSpeed!!))
                    }
                    if (shimanoState.maxSpeed.isValidReadout()) {
                        Text(stringResource(R.string.max_speed, shimanoState.maxSpeed!!))
                    }
                }
            }
        }
        Bolt(
            on = !(shimanoState.mode == BleConstants.Characteristics.Shimano.Mode.Off ||
                shimanoState.mode == BleConstants.Characteristics.Shimano.Mode.Unknown),
            modifier = Modifier
                .fillMaxSize()
                .weight(0.4f)
        )
    }
}
