package dev.bg.bikebridge.di

import android.content.Context
import androidx.room.Room
import dagger.Module
import dagger.Provides
import dagger.hilt.InstallIn
import dagger.hilt.android.qualifiers.ApplicationContext
import dagger.hilt.components.SingletonComponent
import dev.bg.bikebridge.db.BikeBridgeDatabase
import dev.bg.bikebridge.db.dao.PasskeyDao
import javax.inject.Singleton

@Module
@InstallIn(SingletonComponent::class)
object DbModule {

    @Provides
    @Singleton
    fun provideDatabase(
        @ApplicationContext ctx: Context
    ): BikeBridgeDatabase = Room
        .databaseBuilder(
            ctx,
            BikeBridgeDatabase::class.java,
            "bikebridge_db"
        )
        .build()

    @Provides
    @Singleton
    fun providePasskeyDao(
        db: BikeBridgeDatabase
    ): PasskeyDao = db.getPasskeyDao()

}
