package dev.bg.bikebridge.db.dao

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.OnConflictStrategy
import androidx.room.Query
import dev.bg.bikebridge.data.db.Passkey

@Dao
interface PasskeyDao {

    @Query("SELECT passkey FROM passkeys WHERE mac=:mac")
    suspend fun getPasskey(mac: String?): String?

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    suspend fun insertPasskey(passkey: Passkey)

}
