package dev.bg.bikebridge.data.state

import android.bluetooth.BluetoothGattCharacteristic
import android.bluetooth.le.ScanResult

data class GattServiceState(
    val scanning: Boolean,
    val bikesFound: List<ScanResult>,
    // Connected properties
    val bonded: Boolean,
    val rssi: Int,
    val writableCharacteristics: List<BluetoothGattCharacteristic>,
    val writableRequiresTrigger: Boolean?,
    val manufacturer: Int?,
    val deviceName: String?,
    val deviceAddress: String?,
    val firmwareVersion: String?,
    val batteryState: BatteryState?,
    val shimanoState: ShimanoState?,
    val sramAxsState: SramAxsState?
)
