package dev.bg.bikebridge.data.state

data class BatteryState(
    val healthStatus: ByteArray?, // TODO parse
    val healthInfo: ByteArray?, // TODO parse,
    val level: Int?,
    val info: ByteArray? // TODO parse
) {
    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false
        other as BatteryState
        if (healthStatus != null) {
            if (other.healthStatus == null) return false
            if (!healthStatus.contentEquals(other.healthStatus)) return false
        } else if (other.healthStatus != null) return false
        if (healthInfo != null) {
            if (other.healthInfo == null) return false
            if (!healthInfo.contentEquals(other.healthInfo)) return false
        } else if (other.healthInfo != null) return false
        if (level != other.level) return false
        if (info != null) {
            if (other.info == null) return false
            if (!info.contentEquals(other.info)) return false
        } else if (other.info != null) return false
        return true
    }

    override fun hashCode(): Int {
        var result = healthStatus?.contentHashCode() ?: 0
        result = 31 * result + (healthInfo?.contentHashCode() ?: 0)
        result = 31 * result + (level ?: 0)
        result = 31 * result + (info?.contentHashCode() ?: 0)
        return result
    }
}
