package dev.bg.bikebridge.data

sealed class GattServiceEvent {
    abstract val action: String
}

data class GattServiceEventAction(
    override val action: String
): GattServiceEvent()

data class ShimanoSettingsNotification(
    override val action: String,
    val payload: ByteArray
): GattServiceEvent() {
    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false
        other as ShimanoSettingsNotification
        if (action != other.action) return false
        return payload.contentEquals(other.payload)
    }

    override fun hashCode(): Int {
        var result = action.hashCode()
        result = 31 * result + payload.contentHashCode()
        return result
    }
}
