package dev.bg.bikebridge.ble

import android.bluetooth.BluetoothGattCharacteristic

sealed class BleOp {
    abstract val characteristic: BluetoothGattCharacteristic?
}

data class ReadCharacteristic(
    override val characteristic: BluetoothGattCharacteristic?
): BleOp()

data class WriteCharacteristic(
    override val characteristic: BluetoothGattCharacteristic?,
    val payload: ByteArray
): BleOp() {
    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false
        other as WriteCharacteristic
        if (characteristic != other.characteristic) return false
        return payload.contentEquals(other.payload)
    }

    override fun hashCode(): Int {
        var result = characteristic.hashCode()
        result = 31 * result + payload.contentHashCode()
        return result
    }
}

data class EnableNotification(
    override val characteristic: BluetoothGattCharacteristic?
): BleOp()
