package dev.bg.bikebridge

import androidx.compose.runtime.Immutable
import androidx.navigation.NavDestination
import kotlinx.serialization.Serializable

enum class ScaffoldVisibility {
    Gone,
    Top,
    NavOnly,
    ActionsOnly
}

@Immutable
object Route {
    @Serializable
    data object Permissions

    @Serializable
    data object Enable

    @Serializable
    data object Scan

    @Serializable
    data object Bike

    @Serializable
    data object Log

    @Serializable
    data object Settings

    private val navOnly = listOf(Log, Settings)
    private val actionsOnly = listOf(Scan)
    private val gone = listOf(Permissions, Enable)

    fun getScaffoldVisibility(destination: NavDestination?): ScaffoldVisibility     {
        return when (destination?.route) {
            Permissions::class.qualifiedName.toString() -> ScaffoldVisibility.Gone
            Enable::class.qualifiedName.toString() -> ScaffoldVisibility.Gone
            Scan::class.qualifiedName.toString() -> ScaffoldVisibility.ActionsOnly
            Log::class.qualifiedName.toString() -> ScaffoldVisibility.NavOnly
            Settings::class.qualifiedName.toString() -> ScaffoldVisibility.NavOnly
            else -> ScaffoldVisibility.Top
        }
    }
}
