package dev.bg.bikebridge

import android.app.Application
import com.tencent.mmkv.MMKV
import dagger.hilt.android.HiltAndroidApp
import dev.bg.bikebridge.util.Constants
import dev.bg.bikebridge.util.ktx.getExceptionPendingIntent
import dev.bg.bikebridge.util.ktx.sendNotification
import timber.log.Timber

@HiltAndroidApp
class BikeBridge: Application() {

    private val defaultExceptionHandler = Thread.getDefaultUncaughtExceptionHandler()

    override fun onCreate() {
        super.onCreate()
        MMKV.initialize(this)
        if (BuildConfig.DEBUG) {
            Timber.plant(Timber.DebugTree())
        }
        Thread.setDefaultUncaughtExceptionHandler { t, exception ->
            sendNotification(
                channel = Constants.EXCEPTION_NOTIFICATION_CHANNEL,
                title = getString(R.string.bikebridge_exception),
                description = getString(R.string.bikebridge_exception_description),
                pendingIntent = getExceptionPendingIntent(exception)
            )
            defaultExceptionHandler?.uncaughtException(t, exception)
        }
    }

}
