import com.android.build.api.variant.FilterConfiguration

plugins {
    alias(libs.plugins.android.application)
    alias(libs.plugins.jetbrains.kotlin.android)
    alias(libs.plugins.compose.compiler)
    alias(libs.plugins.serialization)
    alias(libs.plugins.ksp)
    alias(libs.plugins.hilt)
}

android {
    namespace = "dev.bg.bikebridge"
    compileSdk = 36

    defaultConfig {
        applicationId = "dev.bg.bikebridge"
        minSdk = 24
        targetSdk = 36
        versionCode = 4
        versionName = "0.0.4"

        testInstrumentationRunner = "androidx.test.runner.AndroidJUnitRunner"
        testInstrumentationRunnerArguments["disableAnalytics"] = "true"

        vectorDrawables {
            useSupportLibrary = true
        }
    }

    buildTypes {
        debug {
            applicationIdSuffix = ".debug"
        }
        release {
            isMinifyEnabled = true
            isShrinkResources = true
            proguardFiles(
                getDefaultProguardFile("proguard-android-optimize.txt"),
                "proguard-rules.pro"
            )
        }
    }
    splits {
        abi {
            reset()
            include("x86", "x86_64", "armeabi-v7a", "arm64-v8a")
            isUniversalApk = true
        }
    }
    dependenciesInfo {
        includeInApk = false
        includeInBundle = false
    }
    compileOptions {
        sourceCompatibility = JavaVersion.VERSION_21
        targetCompatibility = JavaVersion.VERSION_21
    }
    buildFeatures {
        compose = true
        buildConfig = true
    }
    composeOptions {
        kotlinCompilerExtensionVersion = "1.5.6"
    }
    packaging {
        resources {
            excludes += "/META-INF/{AL2.0,LGPL2.1}"
        }
    }
}

kotlin {
    compilerOptions {
        freeCompilerArgs = listOf("-XXLanguage:+PropertyParamAnnotationDefaultTargetMode")
    }
}

ksp {
    arg("room.schemaLocation", "$projectDir/schemas")
}

val abiMap = mapOf(
    "armeabi-v7a" to 1,
    "arm64-v8a" to 2,
    "x86" to 3,
    "x86_64" to 4
)

androidComponents {
    onVariants { variant ->
        variant.outputs.forEach { output ->
            val name = output.filters.find { f -> f.filterType == FilterConfiguration.FilterType.ABI }?.identifier
            val code = abiMap[name]
            if (code != null) {
                output.versionCode.set("${(output.versionCode.get() as Int? ?: 1)}${code}".toInt())
            }
        }
    }
}

dependencies {
    implementation(libs.androidx.ktx)
    implementation(libs.bundles.androidx.lifecycle)
    implementation(libs.androidx.activity)

    // UI
    implementation(libs.bundles.compose)
    implementation(libs.androidx.graphics.shapes)

    // Navigation
    implementation(libs.androidx.navigation)

    // Room
    implementation(libs.bundles.room)
    ksp(libs.androidx.room.compiler)

    // Dependency Injection
    implementation(libs.bundles.hilt)
    ksp(libs.hilt.androidx.compiler)
    ksp(libs.hilt.compiler)

    // Logging
    implementation(libs.timber)

    // Preferences
    implementation(libs.mmkv)

    // Misc
    implementation(libs.permissions)

    testImplementation(libs.junit)
    androidTestImplementation(libs.androidx.junit)
    androidTestImplementation(libs.androidx.espresso)
    androidTestImplementation(platform(libs.androidx.compose.bom))
    androidTestImplementation(libs.androidx.compose.ui.junit)

    debugImplementation(libs.androidx.compose.ui.tooling)
    debugImplementation(libs.androidx.compose.ui.test.manifest)
    debugImplementation(libs.leakcanary)
}

configurations.all {
    exclude("com.google.android.gms") // Just in case
}

tasks.whenTaskAdded {
    if (name.contains("ArtProfile")) {
        enabled = false
    }
}
