<h1 align="center">BikeBridge</h1>
<div align="center">
    <p>Companion for e-bikes using BLE</p>
    <p>⚠️ This app is a work in progress ⚠️</p>
    <p>Please read below about bike support</p>

[![](https://shields.rbtlog.dev/simple/dev.bg.bikebridge?style=flat-square)](https://shields.rbtlog.dev/dev.bg.bikebridge)
</div>

## About
BikeBridge is a companion app for your e-bike, providing real-time information from your bike and components.

All raw data received from the bike, and sent to the bike (by BikeBridge) is transparent and viewable.

All Bluetooth data and parsers can be found below:
- [Static data](./app/src/main/java/dev/bg/bikebridge/ble/BleConstants.kt)
- [Parsers](./app/src/main/java/dev/bg/bikebridge/util/BikeUtil.kt)

You are also able to send custom payloads to any Bluetooth characteristic on the bike.

## Features
- [x] See statistics (e.g. speed, total distance, gear) in real-time
- [x] See all raw data transmitted/received to/from bike
- [x] Send custom payloads
- [x] Change settings on bike (see [support](./docs/support.md))
- [x] See bike info (e.g. serial number, MAC address, etc.)
- [x] HUD

## Install
### Prebuilt binaries
- Available to download in the [releases](https://codeberg.org/bg443/BikeBridge/releases) tab
- You can see the steps of the build on [BikeBridge's CI page](https://ci.codeberg.org/repos/15156)

<br />
<div>
    <a href="https://apt.izzysoft.de/fdroid/index/apk/dev.bg.bikebridge" rel="noopener noreferrer" target=_blank><img src="./assets/IzzyOnDroidButtonGreyBorder.svg" height="60" alt="Get it on IzzyOnDroid"></a>&nbsp;&nbsp;&nbsp;
    <a href="https://codeberg.org/bg443/BikeBridge/releases" rel="noopener noreferrer" target=_blank><img src="./assets/codeberg.svg" height=60 alt="Get it on Codeberg" /></a>&nbsp;&nbsp;&nbsp;
    <a href="https://github.com/ImranR98/Obtainium" rel="noopener noreferrer" target="_blank"> <img src="./assets/badge_obtainium.png" height="60" alt="Get it on Obtainium" /></a>&nbsp;&nbsp;&nbsp;
    <a href="https://codeberg.org/bg443/BikeBridge/releases.rss" rel="noopener noreferrer" target=_blank><img src="./assets/RSS.svg" height=60 alt="Follow with RSS" /></a>
</div>

### Build from source

```shell
./gradlew :app:assembleRelease
```

## Screenshots
<div align="center">
    <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/1.png" alt="" loading="lazy" width="20%" />
    <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/2.png" alt="" loading="lazy" width="20%" />
    <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/3.png" alt="" loading="lazy" width="20%" />
    <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/4.png" alt="" loading="lazy" width="20%" />
    <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/5.png" alt="" loading="lazy" width="20%" />
    <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/6.png" alt="" loading="lazy" width="20%" />
</div>

## Bike Support
| Manufacturer | Series    | Supported |
|--------------|-----------|-----------|
| Shimano      | EP8       | Yes       |
| SRAM         | Eagle AXS | Yes       |

Note: even if your manufacturer/series isn't explicitly listed above, BikeBridge will still try to fetch and display as much information as possible.

For a more detailed table, see [advanced support](./docs/support.md)

BikeBridge has only been tested on a Shimano EP8 (Canyon) as that is all I have access to.

Any features added to a bike (e.g. reading total distance) are added through reverse engineering, and can therefore take some time to develop.

## Submitting logs
BikeBridge allows you to see all data transmitted to or received from the bike by enabling logs in the settings screen.

Please enable `Log GATT table` as this shows possible data points that could be queried/written to by BikeBridge.

Censor the log to hide your device serial number and MAC address.

## Capturing BLE communication
The most useful information comes from a sniffed connection as it represents what BikeBridge will need to do under the hood.

There are numerous RF sniffers that support Bluetooth low energy or an [Android device can be used](https://source.android.com/docs/core/connect/bluetooth/verifying_debugging#debugging-options).

For encrypted/bonded BLE connections, [crackle](https://github.com/mikeryan/crackle) can be used in post to brute-force the temporary key, provided the pairing process was observed.

## Permissions
BikeBridge requires a few permissions in order to function:
- `BLUETOOTH`/`BLUETOOTH_SCAN`/`BLUETOOTH_ADMIN` - used to send and receive data to and from the bike
- `ACCESS_COARSE_LOCATION`/`ACCESS_FINE_LOCATION` - required for Bluetooth scanning

BikeBridge does not, and never will, require an internet connection.

## License
<img src="assets/gpl_v3.svg" height=100 />
<br />

BikeBridge is free software: you can redistribute it and/or modify it under the terms of the [GNU GPL-3.0-or-later License](./LICENSE) as published by the Free Software Foundation.

This software is provided with no warranty.
