import { Options, ResolvedLicense, ResolvedPackage, ripOne } from "./rip-license.js";
import resolveExpression from "./resolve-expression.js";
import { getDefaultCacheFolder } from "./cache.js";
export type Output = {
    resolved: ResolvedPackage[];
    errors: {
        missingLicenseText: string[];
        invalidLicense: string[];
    };
};
export { ripOne, resolveExpression as resolveLicenseExpression, getDefaultCacheFolder, Options, ResolvedPackage, };
export declare function ripAll(projectRoot: string, options?: Options): Promise<Output>;
export type ResolvedLicenseCompressed = Omit<ResolvedLicense, "text"> & {
    text: number;
};
export type ResolvedPackageCompressed = Omit<ResolvedPackage, "licenses"> & {
    licenses: ResolvedLicenseCompressed[];
};
export type OutputCompressed = {
    packages: ResolvedPackageCompressed[];
    licenseText: string[];
};
export declare function compress(resolvedPackages: ResolvedPackage[]): OutputCompressed;
