'use client'
"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var src_exports = {};
__export(src_exports, {
  Portal: () => Portal,
  PortalHost: () => PortalHost,
  useModalPortalRoot: () => useModalPortalRoot
});
module.exports = __toCommonJS(src_exports);

// src/portal.tsx
var React = __toESM(require("react"));
var import_react_native = require("react-native");
var import_zustand = require("zustand");
var DEFAULT_PORTAL_HOST = "INTERNAL_PRIMITIVE_DEFAULT_HOST_NAME";
var usePortal = (0, import_zustand.create)(() => ({
  map: (/* @__PURE__ */ new Map()).set(DEFAULT_PORTAL_HOST, /* @__PURE__ */ new Map())
}));
var updatePortal = (hostName, name, children) => {
  usePortal.setState((prev) => {
    const next = new Map(prev.map);
    const portal = next.get(hostName) ?? /* @__PURE__ */ new Map();
    portal.set(name, children);
    next.set(hostName, portal);
    return { map: next };
  });
};
var removePortal = (hostName, name) => {
  usePortal.setState((prev) => {
    const next = new Map(prev.map);
    const portal = next.get(hostName) ?? /* @__PURE__ */ new Map();
    portal.delete(name);
    next.set(hostName, portal);
    return { map: next };
  });
};
function PortalHost({ name = DEFAULT_PORTAL_HOST }) {
  const portalMap = usePortal((state) => state.map).get(name) ?? /* @__PURE__ */ new Map();
  if (portalMap.size === 0) return null;
  return <>{Array.from(portalMap.values())}</>;
}
function Portal({
  name,
  hostName = DEFAULT_PORTAL_HOST,
  children
}) {
  React.useEffect(() => {
    updatePortal(hostName, name, children);
  }, [hostName, name, children]);
  React.useEffect(() => {
    return () => {
      removePortal(hostName, name);
    };
  }, [hostName, name]);
  return null;
}
var ROOT = {
  flex: 1
};
function useModalPortalRoot() {
  const ref = React.useRef(null);
  const [sideOffset, setSideOffSet] = React.useState(0);
  const onLayout = React.useCallback(() => {
    if (import_react_native.Platform.OS === "web") return;
    ref.current?.measure((_x, _y, _width, _height, _pageX, pageY) => {
      setSideOffSet(-pageY);
    });
  }, []);
  return {
    ref,
    sideOffset,
    onLayout,
    style: ROOT
  };
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  Portal,
  PortalHost,
  useModalPortalRoot
});
