import * as React from 'react';
import { View, ViewStyle } from 'react-native';

declare function PortalHost({ name }: {
    name?: string;
}): React.JSX.Element | null;
declare function Portal({ name, hostName, children, }: {
    name: string;
    hostName?: string;
    children: React.ReactNode;
}): null;
/**
 * @deprecated use `FullWindowOverlay` from `react-native-screens` instead
 * @example
import { FullWindowOverlay } from "react-native-screens"
const WindowOverlay = Platform.OS === "ios" ? FullWindowOverlay : Fragment
// Wrap the `<PortalHost/>` with `<WindowOverlay/>`
<WindowOverlay><PortalHost/></WindowOverlay>
 */
declare function useModalPortalRoot(): {
    ref: React.RefObject<View>;
    sideOffset: number;
    onLayout: () => void;
    style: ViewStyle;
};

export { Portal, PortalHost, useModalPortalRoot };
