'use client'

// src/useAugmentedRef.tsx
import * as React from "react";
function useAugmentedRef({
  ref,
  methods,
  deps = []
}) {
  const augmentedRef = React.useRef(null);
  React.useImperativeHandle(
    ref,
    () => {
      if (typeof augmentedRef === "function" || !augmentedRef?.current) {
        return {};
      }
      return {
        ...augmentedRef.current,
        ...methods
      };
    },
    deps
  );
  return augmentedRef;
}

// src/useRelativePosition.tsx
import * as React2 from "react";
import { Dimensions } from "react-native";
var POSITION_ABSOLUTE = {
  position: "absolute"
};
var HIDDEN_CONTENT = {
  position: "absolute",
  opacity: 0,
  zIndex: -9999999
};
function useRelativePosition({
  align,
  avoidCollisions,
  triggerPosition,
  contentLayout,
  alignOffset,
  insets,
  sideOffset,
  side,
  disablePositioningStyle
}) {
  const dimensions = Dimensions.get("screen");
  return React2.useMemo(() => {
    if (disablePositioningStyle) {
      return {};
    }
    if (!triggerPosition || !contentLayout) {
      return HIDDEN_CONTENT;
    }
    return getContentStyle({
      align,
      avoidCollisions,
      contentLayout,
      side,
      triggerPosition,
      alignOffset,
      insets,
      sideOffset,
      dimensions
    });
  }, [
    align,
    avoidCollisions,
    side,
    alignOffset,
    insets,
    triggerPosition,
    contentLayout,
    dimensions.width,
    dimensions.height
  ]);
}
function getSidePosition({
  side,
  triggerPosition,
  contentLayout,
  sideOffset,
  insets,
  avoidCollisions,
  dimensions
}) {
  const insetTop = insets?.top ?? 0;
  const insetBottom = insets?.bottom ?? 0;
  const positionTop = triggerPosition?.pageY - sideOffset - contentLayout.height;
  const positionBottom = triggerPosition.pageY + triggerPosition.height + sideOffset;
  if (!avoidCollisions) {
    return {
      top: side === "top" ? positionTop : positionBottom
    };
  }
  if (side === "top") {
    return {
      top: Math.min(
        Math.max(insetTop, positionTop),
        dimensions.height - insetBottom - contentLayout.height
      )
    };
  }
  return {
    top: Math.min(dimensions.height - insetBottom - contentLayout.height, positionBottom)
  };
}
function getAlignPosition({
  align,
  avoidCollisions,
  contentLayout,
  triggerPosition,
  alignOffset,
  insets,
  dimensions
}) {
  const insetLeft = insets?.left ?? 0;
  const insetRight = insets?.right ?? 0;
  const maxContentWidth = dimensions.width - insetLeft - insetRight;
  const contentWidth = Math.min(contentLayout.width, maxContentWidth);
  let left = getLeftPosition(
    align,
    triggerPosition.pageX,
    triggerPosition.width,
    contentWidth,
    alignOffset,
    insetLeft,
    insetRight,
    dimensions
  );
  if (avoidCollisions) {
    const doesCollide = left < insetLeft || left + contentWidth > dimensions.width - insetRight;
    if (doesCollide) {
      const spaceLeft = left - insetLeft;
      const spaceRight = dimensions.width - insetRight - (left + contentWidth);
      if (spaceLeft > spaceRight && spaceLeft >= contentWidth) {
        left = insetLeft;
      } else if (spaceRight >= contentWidth) {
        left = dimensions.width - insetRight - contentWidth;
      } else {
        const centeredPosition = Math.max(
          insetLeft,
          (dimensions.width - contentWidth - insetRight) / 2
        );
        left = centeredPosition;
      }
    }
  }
  return { left, maxWidth: maxContentWidth };
}
function getLeftPosition(align, triggerPageX, triggerWidth, contentWidth, alignOffset, insetLeft, insetRight, dimensions) {
  let left = 0;
  if (align === "start") {
    left = triggerPageX;
  }
  if (align === "center") {
    left = triggerPageX + triggerWidth / 2 - contentWidth / 2;
  }
  if (align === "end") {
    left = triggerPageX + triggerWidth - contentWidth;
  }
  return Math.max(
    insetLeft,
    Math.min(left + alignOffset, dimensions.width - contentWidth - insetRight)
  );
}
function getContentStyle({
  align,
  avoidCollisions,
  contentLayout,
  side,
  triggerPosition,
  alignOffset,
  insets,
  sideOffset,
  dimensions
}) {
  return Object.assign(
    POSITION_ABSOLUTE,
    getSidePosition({
      side,
      triggerPosition,
      contentLayout,
      sideOffset,
      insets,
      avoidCollisions,
      dimensions
    }),
    getAlignPosition({
      align,
      avoidCollisions,
      triggerPosition,
      contentLayout,
      alignOffset,
      insets,
      dimensions
    })
  );
}

// src/useControllableState.tsx
import * as React3 from "react";
function useControllableState({
  prop,
  defaultProp,
  onChange = () => {
  }
}) {
  const [uncontrolledProp, setUncontrolledProp] = useUncontrolledState({ defaultProp, onChange });
  const isControlled = prop !== void 0;
  const value = isControlled ? prop : uncontrolledProp;
  const handleChange = useCallbackRef(onChange);
  const setValue = React3.useCallback(
    (nextValue) => {
      if (isControlled) {
        const setter = nextValue;
        const value2 = typeof nextValue === "function" ? setter(prop) : nextValue;
        if (value2 !== prop) handleChange(value2);
      } else {
        setUncontrolledProp(nextValue);
      }
    },
    [isControlled, prop, setUncontrolledProp, handleChange]
  );
  return [value, setValue];
}
function useUncontrolledState({
  defaultProp,
  onChange
}) {
  const uncontrolledState = React3.useState(defaultProp);
  const [value] = uncontrolledState;
  const prevValueRef = React3.useRef(value);
  const handleChange = useCallbackRef(onChange);
  React3.useEffect(() => {
    if (prevValueRef.current !== value) {
      handleChange(value);
      prevValueRef.current = value;
    }
  }, [value, prevValueRef, handleChange]);
  return uncontrolledState;
}
function useCallbackRef(callback) {
  const callbackRef = React3.useRef(callback);
  React3.useEffect(() => {
    callbackRef.current = callback;
  });
  return React3.useMemo(() => (...args) => callbackRef.current?.(...args), []);
}

// src/useIsomorphicLayoutEffect.tsx
import * as React4 from "react";
import { Platform } from "react-native";
function useIsomorphicLayoutEffect(effect, dependencies) {
  if (Platform.OS === "web" && typeof window === "undefined") {
    React4.useEffect(effect, dependencies);
  } else {
    React4.useLayoutEffect(effect, dependencies);
  }
}
export {
  useAugmentedRef,
  useControllableState,
  useIsomorphicLayoutEffect,
  useRelativePosition
};
