'use client'
"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var src_exports = {};
__export(src_exports, {
  useAugmentedRef: () => useAugmentedRef,
  useControllableState: () => useControllableState,
  useIsomorphicLayoutEffect: () => useIsomorphicLayoutEffect,
  useRelativePosition: () => useRelativePosition
});
module.exports = __toCommonJS(src_exports);

// src/useAugmentedRef.tsx
var React = __toESM(require("react"));
function useAugmentedRef({
  ref,
  methods,
  deps = []
}) {
  const augmentedRef = React.useRef(null);
  React.useImperativeHandle(
    ref,
    () => {
      if (typeof augmentedRef === "function" || !augmentedRef?.current) {
        return {};
      }
      return {
        ...augmentedRef.current,
        ...methods
      };
    },
    deps
  );
  return augmentedRef;
}

// src/useRelativePosition.tsx
var React2 = __toESM(require("react"));
var import_react_native = require("react-native");
var POSITION_ABSOLUTE = {
  position: "absolute"
};
var HIDDEN_CONTENT = {
  position: "absolute",
  opacity: 0,
  zIndex: -9999999
};
function useRelativePosition({
  align,
  avoidCollisions,
  triggerPosition,
  contentLayout,
  alignOffset,
  insets,
  sideOffset,
  side,
  disablePositioningStyle
}) {
  const dimensions = import_react_native.Dimensions.get("screen");
  return React2.useMemo(() => {
    if (disablePositioningStyle) {
      return {};
    }
    if (!triggerPosition || !contentLayout) {
      return HIDDEN_CONTENT;
    }
    return getContentStyle({
      align,
      avoidCollisions,
      contentLayout,
      side,
      triggerPosition,
      alignOffset,
      insets,
      sideOffset,
      dimensions
    });
  }, [
    align,
    avoidCollisions,
    side,
    alignOffset,
    insets,
    triggerPosition,
    contentLayout,
    dimensions.width,
    dimensions.height
  ]);
}
function getSidePosition({
  side,
  triggerPosition,
  contentLayout,
  sideOffset,
  insets,
  avoidCollisions,
  dimensions
}) {
  const insetTop = insets?.top ?? 0;
  const insetBottom = insets?.bottom ?? 0;
  const positionTop = triggerPosition?.pageY - sideOffset - contentLayout.height;
  const positionBottom = triggerPosition.pageY + triggerPosition.height + sideOffset;
  if (!avoidCollisions) {
    return {
      top: side === "top" ? positionTop : positionBottom
    };
  }
  if (side === "top") {
    return {
      top: Math.min(
        Math.max(insetTop, positionTop),
        dimensions.height - insetBottom - contentLayout.height
      )
    };
  }
  return {
    top: Math.min(dimensions.height - insetBottom - contentLayout.height, positionBottom)
  };
}
function getAlignPosition({
  align,
  avoidCollisions,
  contentLayout,
  triggerPosition,
  alignOffset,
  insets,
  dimensions
}) {
  const insetLeft = insets?.left ?? 0;
  const insetRight = insets?.right ?? 0;
  const maxContentWidth = dimensions.width - insetLeft - insetRight;
  const contentWidth = Math.min(contentLayout.width, maxContentWidth);
  let left = getLeftPosition(
    align,
    triggerPosition.pageX,
    triggerPosition.width,
    contentWidth,
    alignOffset,
    insetLeft,
    insetRight,
    dimensions
  );
  if (avoidCollisions) {
    const doesCollide = left < insetLeft || left + contentWidth > dimensions.width - insetRight;
    if (doesCollide) {
      const spaceLeft = left - insetLeft;
      const spaceRight = dimensions.width - insetRight - (left + contentWidth);
      if (spaceLeft > spaceRight && spaceLeft >= contentWidth) {
        left = insetLeft;
      } else if (spaceRight >= contentWidth) {
        left = dimensions.width - insetRight - contentWidth;
      } else {
        const centeredPosition = Math.max(
          insetLeft,
          (dimensions.width - contentWidth - insetRight) / 2
        );
        left = centeredPosition;
      }
    }
  }
  return { left, maxWidth: maxContentWidth };
}
function getLeftPosition(align, triggerPageX, triggerWidth, contentWidth, alignOffset, insetLeft, insetRight, dimensions) {
  let left = 0;
  if (align === "start") {
    left = triggerPageX;
  }
  if (align === "center") {
    left = triggerPageX + triggerWidth / 2 - contentWidth / 2;
  }
  if (align === "end") {
    left = triggerPageX + triggerWidth - contentWidth;
  }
  return Math.max(
    insetLeft,
    Math.min(left + alignOffset, dimensions.width - contentWidth - insetRight)
  );
}
function getContentStyle({
  align,
  avoidCollisions,
  contentLayout,
  side,
  triggerPosition,
  alignOffset,
  insets,
  sideOffset,
  dimensions
}) {
  return Object.assign(
    POSITION_ABSOLUTE,
    getSidePosition({
      side,
      triggerPosition,
      contentLayout,
      sideOffset,
      insets,
      avoidCollisions,
      dimensions
    }),
    getAlignPosition({
      align,
      avoidCollisions,
      triggerPosition,
      contentLayout,
      alignOffset,
      insets,
      dimensions
    })
  );
}

// src/useControllableState.tsx
var React3 = __toESM(require("react"));
function useControllableState({
  prop,
  defaultProp,
  onChange = () => {
  }
}) {
  const [uncontrolledProp, setUncontrolledProp] = useUncontrolledState({ defaultProp, onChange });
  const isControlled = prop !== void 0;
  const value = isControlled ? prop : uncontrolledProp;
  const handleChange = useCallbackRef(onChange);
  const setValue = React3.useCallback(
    (nextValue) => {
      if (isControlled) {
        const setter = nextValue;
        const value2 = typeof nextValue === "function" ? setter(prop) : nextValue;
        if (value2 !== prop) handleChange(value2);
      } else {
        setUncontrolledProp(nextValue);
      }
    },
    [isControlled, prop, setUncontrolledProp, handleChange]
  );
  return [value, setValue];
}
function useUncontrolledState({
  defaultProp,
  onChange
}) {
  const uncontrolledState = React3.useState(defaultProp);
  const [value] = uncontrolledState;
  const prevValueRef = React3.useRef(value);
  const handleChange = useCallbackRef(onChange);
  React3.useEffect(() => {
    if (prevValueRef.current !== value) {
      handleChange(value);
      prevValueRef.current = value;
    }
  }, [value, prevValueRef, handleChange]);
  return uncontrolledState;
}
function useCallbackRef(callback) {
  const callbackRef = React3.useRef(callback);
  React3.useEffect(() => {
    callbackRef.current = callback;
  });
  return React3.useMemo(() => (...args) => callbackRef.current?.(...args), []);
}

// src/useIsomorphicLayoutEffect.tsx
var React4 = __toESM(require("react"));
var import_react_native2 = require("react-native");
function useIsomorphicLayoutEffect(effect, dependencies) {
  if (import_react_native2.Platform.OS === "web" && typeof window === "undefined") {
    React4.useEffect(effect, dependencies);
  } else {
    React4.useLayoutEffect(effect, dependencies);
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  useAugmentedRef,
  useControllableState,
  useIsomorphicLayoutEffect,
  useRelativePosition
});
