'use client'

// src/dropdown-menu.web.tsx
import * as DropdownMenu from "@radix-ui/react-dropdown-menu";
import {
  useAugmentedRef,
  useControllableState,
  useIsomorphicLayoutEffect
} from "@rn-primitives/hooks";
import * as Slot from "@rn-primitives/slot";
import { EmptyGestureResponderEvent } from "@rn-primitives/utils";
import * as React from "react";
import { Pressable as Pressable2, Text as Text2, View as View2 } from "react-native";
var DropdownMenuContext = React.createContext(null);
var Root2 = React.forwardRef(
  ({ asChild, onOpenChange: onOpenChangeProp, ...viewProps }, ref) => {
    const [open, setOpen] = React.useState(false);
    function onOpenChange(open2) {
      setOpen(open2);
      onOpenChangeProp?.(open2);
    }
    const Component = asChild ? Slot.View : View2;
    return <DropdownMenuContext.Provider value={{ open, onOpenChange }}><DropdownMenu.Root open={open} onOpenChange={onOpenChange}><Component ref={ref} {...viewProps} /></DropdownMenu.Root></DropdownMenuContext.Provider>;
  }
);
Root2.displayName = "RootWebDropdownMenu";
function useRootContext() {
  const context = React.useContext(DropdownMenuContext);
  if (!context) {
    throw new Error(
      "DropdownMenu compound components cannot be rendered outside the DropdownMenu component"
    );
  }
  return context;
}
var Trigger2 = React.forwardRef(
  ({ asChild, disabled = false, ...props }, ref) => {
    const { open, onOpenChange } = useRootContext();
    const augmentedRef = useAugmentedRef({
      ref,
      methods: {
        open() {
          onOpenChange(true);
        },
        close() {
          onOpenChange(false);
        }
      }
    });
    useIsomorphicLayoutEffect(() => {
      if (augmentedRef.current) {
        const augRef = augmentedRef.current;
        augRef.dataset.state = open ? "open" : "closed";
      }
    }, [open]);
    useIsomorphicLayoutEffect(() => {
      if (augmentedRef.current) {
        const augRef = augmentedRef.current;
        if (disabled) {
          augRef.dataset.disabled = "true";
        } else {
          augRef.dataset.disabled = void 0;
        }
      }
    }, [disabled]);
    const Component = asChild ? Slot.Pressable : Pressable2;
    return <DropdownMenu.Trigger disabled={disabled ?? void 0} asChild><Component ref={augmentedRef} {...props} /></DropdownMenu.Trigger>;
  }
);
Trigger2.displayName = "TriggerWebDropdownMenu";
function Portal2({ forceMount, container, children }) {
  return <DropdownMenu.Portal forceMount={forceMount} container={container} children={children} />;
}
var Overlay = React.forwardRef(({ asChild, ...props }, ref) => {
  const Component = asChild ? Slot.Pressable : Pressable2;
  return <Component ref={ref} {...props} />;
});
Overlay.displayName = "OverlayWebDropdownMenu";
var DropdownMenuContentContext = React.createContext(null);
var Content2 = React.forwardRef(
  ({
    asChild = false,
    forceMount,
    align,
    side,
    sideOffset,
    alignOffset = 0,
    avoidCollisions = true,
    insets,
    loop = true,
    onCloseAutoFocus,
    onEscapeKeyDown,
    onPointerDownOutside,
    onFocusOutside,
    onInteractOutside,
    collisionBoundary,
    sticky,
    hideWhenDetached,
    ...props
  }, ref) => {
    const itemRef = React.useRef(null);
    function close() {
      itemRef.current?.click();
    }
    const Component = asChild ? Slot.Pressable : Pressable2;
    return <DropdownMenuContentContext.Provider value={{ close }}><DropdownMenu.Content
      forceMount={forceMount}
      alignOffset={alignOffset}
      avoidCollisions={avoidCollisions}
      collisionPadding={insets}
      loop={loop}
      onCloseAutoFocus={onCloseAutoFocus}
      onEscapeKeyDown={onEscapeKeyDown}
      onPointerDownOutside={onPointerDownOutside}
      onFocusOutside={onFocusOutside}
      onInteractOutside={onInteractOutside}
      collisionBoundary={collisionBoundary}
      sticky={sticky}
      hideWhenDetached={hideWhenDetached}
      align={align}
      side={side}
      sideOffset={sideOffset}
    ><Component ref={ref} {...props} /><DropdownMenu.Item
      ref={itemRef}
      aria-hidden
      style={{ position: "fixed", top: 0, left: 0, zIndex: -999999999 }}
      aria-disabled
      tabIndex={-1}
      hidden
    /></DropdownMenu.Content></DropdownMenuContentContext.Provider>;
  }
);
Content2.displayName = "ContentWebDropdownMenu";
function useDropdownMenuContentContext() {
  const context = React.useContext(DropdownMenuContentContext);
  if (!context) {
    throw new Error(
      "DropdownMenu compound components cannot be rendered outside the DropdownMenu component"
    );
  }
  return context;
}
var Item2 = React.forwardRef(
  ({
    asChild,
    textValue,
    closeOnPress = true,
    onPress: onPressProp,
    onKeyDown: onKeyDownProp,
    ...props
  }, ref) => {
    const { close } = useDropdownMenuContentContext();
    function onKeyDown(ev) {
      onKeyDownProp?.(ev);
      if (ev.key === "Enter" || ev.key === " ") {
        onPressProp?.(EmptyGestureResponderEvent);
        if (closeOnPress) {
          close();
        }
      }
    }
    function onPress(ev) {
      onPressProp?.(ev);
      if (closeOnPress) {
        close();
      }
    }
    const Component = asChild ? Slot.Pressable : Pressable2;
    return <DropdownMenu.Item
      textValue={textValue}
      disabled={props.disabled ?? void 0}
      onSelect={closeOnPress ? void 0 : onSelected}
      asChild
    ><Component
      ref={ref}
      onKeyDown={onKeyDown}
      onPress={onPress}
      {...props}
    /></DropdownMenu.Item>;
  }
);
Item2.displayName = "ItemWebDropdownMenu";
var Group2 = React.forwardRef(({ asChild, ...props }, ref) => {
  const Component = asChild ? Slot.View : View2;
  return <DropdownMenu.Group asChild><Component ref={ref} {...props} /></DropdownMenu.Group>;
});
Group2.displayName = "GroupWebDropdownMenu";
var Label2 = React.forwardRef(({ asChild, ...props }, ref) => {
  const Component = asChild ? Slot.Text : Text2;
  return <DropdownMenu.Label asChild><Component ref={ref} {...props} /></DropdownMenu.Label>;
});
Label2.displayName = "LabelWebDropdownMenu";
var CheckboxItem2 = React.forwardRef(
  ({
    asChild,
    checked,
    onCheckedChange,
    textValue,
    disabled = false,
    closeOnPress = true,
    onPress: onPressProp,
    onKeyDown: onKeyDownProp,
    ...props
  }, ref) => {
    const { close } = useDropdownMenuContentContext();
    function onKeyDown(ev) {
      onKeyDownProp?.(ev);
      if (ev.key === "Enter" || ev.key === " ") {
        onPressProp?.(EmptyGestureResponderEvent);
        onCheckedChange?.(!checked);
        if (closeOnPress) {
          close();
        }
      }
    }
    function onPress(ev) {
      onPressProp?.(ev);
      onCheckedChange?.(!checked);
      if (closeOnPress) {
        close();
      }
    }
    const Component = asChild ? Slot.Pressable : Pressable2;
    return <DropdownMenu.CheckboxItem
      textValue={textValue}
      checked={checked}
      onCheckedChange={onCheckedChange}
      onSelect={closeOnPress ? void 0 : onSelected}
      disabled={disabled ?? void 0}
      asChild
    ><Component
      ref={ref}
      onKeyDown={onKeyDown}
      onPress={onPress}
      role='button'
      {...props}
    /></DropdownMenu.CheckboxItem>;
  }
);
CheckboxItem2.displayName = "CheckboxItemWebDropdownMenu";
var DropdownMenuRadioGroupContext = React.createContext(null);
var RadioGroup2 = React.forwardRef(
  ({ asChild, value, onValueChange, ...props }, ref) => {
    const Component = asChild ? Slot.View : View2;
    return <DropdownMenuRadioGroupContext.Provider value={{ value, onValueChange }}><DropdownMenu.RadioGroup value={value} onValueChange={onValueChange} asChild><Component ref={ref} {...props} /></DropdownMenu.RadioGroup></DropdownMenuRadioGroupContext.Provider>;
  }
);
RadioGroup2.displayName = "RadioGroupWebDropdownMenu";
function useDropdownMenuRadioGroupContext() {
  const context = React.useContext(DropdownMenuRadioGroupContext);
  if (!context) {
    throw new Error(
      "DropdownMenuRadioGroup compound components cannot be rendered outside the DropdownMenuRadioGroup component"
    );
  }
  return context;
}
var RadioItem2 = React.forwardRef(
  ({
    asChild,
    value,
    textValue,
    closeOnPress = true,
    onPress: onPressProp,
    onKeyDown: onKeyDownProp,
    ...props
  }, ref) => {
    const { onValueChange } = useDropdownMenuRadioGroupContext();
    const { close } = useDropdownMenuContentContext();
    function onKeyDown(ev) {
      onKeyDownProp?.(ev);
      if (ev.key === "Enter" || ev.key === " ") {
        onValueChange?.(value);
        onPressProp?.(EmptyGestureResponderEvent);
        if (closeOnPress) {
          close();
        }
      }
    }
    function onPress(ev) {
      onValueChange?.(value);
      onPressProp?.(ev);
      if (closeOnPress) {
        close();
      }
    }
    const Component = asChild ? Slot.Pressable : Pressable2;
    return <DropdownMenu.RadioItem
      value={value}
      textValue={textValue}
      disabled={props.disabled ?? void 0}
      onSelect={closeOnPress ? void 0 : onSelected}
      asChild
    ><Component
      ref={ref}
      onKeyDown={onKeyDown}
      onPress={onPress}
      {...props}
    /></DropdownMenu.RadioItem>;
  }
);
RadioItem2.displayName = "RadioItemWebDropdownMenu";
var ItemIndicator2 = React.forwardRef(
  ({ asChild, forceMount, ...props }, ref) => {
    const Component = asChild ? Slot.View : View2;
    return <DropdownMenu.ItemIndicator forceMount={forceMount} asChild><Component ref={ref} {...props} /></DropdownMenu.ItemIndicator>;
  }
);
ItemIndicator2.displayName = "ItemIndicatorWebDropdownMenu";
var Separator2 = React.forwardRef(
  ({ asChild, decorative, ...props }, ref) => {
    const Component = asChild ? Slot.View : View2;
    return <DropdownMenu.Separator asChild><Component ref={ref} {...props} /></DropdownMenu.Separator>;
  }
);
Separator2.displayName = "SeparatorWebDropdownMenu";
var DropdownMenuSubContext = React.createContext(null);
var Sub2 = React.forwardRef(
  ({ asChild, defaultOpen, open: openProp, onOpenChange: onOpenChangeProp, ...props }, ref) => {
    const [open = false, onOpenChange] = useControllableState({
      prop: openProp,
      defaultProp: defaultOpen,
      onChange: onOpenChangeProp
    });
    const Component = asChild ? Slot.View : View2;
    return <DropdownMenuSubContext.Provider value={{ open, onOpenChange }}><DropdownMenu.Sub open={open} onOpenChange={onOpenChange}><Component ref={ref} {...props} /></DropdownMenu.Sub></DropdownMenuSubContext.Provider>;
  }
);
Sub2.displayName = "SubWebDropdownMenu";
function useSubContext() {
  const context = React.useContext(DropdownMenuSubContext);
  if (!context) {
    throw new Error(
      "DropdownMenu compound components cannot be rendered outside the DropdownMenu component"
    );
  }
  return context;
}
var SubTrigger2 = React.forwardRef(
  ({ asChild, textValue, disabled = false, onPress: onPressProp, ...props }, ref) => {
    const { onOpenChange } = useSubContext();
    function onPress(ev) {
      onOpenChange(true);
      onPressProp?.(ev);
    }
    const Component = asChild ? Slot.Pressable : Pressable2;
    return <DropdownMenu.SubTrigger disabled={disabled ?? void 0} textValue={textValue} asChild><Component ref={ref} onPress={onPress} {...props} /></DropdownMenu.SubTrigger>;
  }
);
SubTrigger2.displayName = "SubTriggerWebDropdownMenu";
var SubContent2 = React.forwardRef(
  ({ asChild = false, forceMount, ...props }, ref) => {
    const Component = asChild ? Slot.Pressable : Pressable2;
    return <DropdownMenu.Portal><DropdownMenu.SubContent forceMount={forceMount}><Component ref={ref} {...props} /></DropdownMenu.SubContent></DropdownMenu.Portal>;
  }
);
Content2.displayName = "ContentWebDropdownMenu";
function onSelected(ev) {
  ev.preventDefault();
}
export {
  CheckboxItem2 as CheckboxItem,
  Content2 as Content,
  Group2 as Group,
  Item2 as Item,
  ItemIndicator2 as ItemIndicator,
  Label2 as Label,
  Overlay,
  Portal2 as Portal,
  RadioGroup2 as RadioGroup,
  RadioItem2 as RadioItem,
  Root2 as Root,
  Separator2 as Separator,
  Sub2 as Sub,
  SubContent2 as SubContent,
  SubTrigger2 as SubTrigger,
  Trigger2 as Trigger,
  useRootContext,
  useSubContext
};
