'use client'
"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/dropdown-menu.web.tsx
var dropdown_menu_web_exports = {};
__export(dropdown_menu_web_exports, {
  CheckboxItem: () => CheckboxItem2,
  Content: () => Content2,
  Group: () => Group2,
  Item: () => Item2,
  ItemIndicator: () => ItemIndicator2,
  Label: () => Label2,
  Overlay: () => Overlay,
  Portal: () => Portal2,
  RadioGroup: () => RadioGroup2,
  RadioItem: () => RadioItem2,
  Root: () => Root2,
  Separator: () => Separator2,
  Sub: () => Sub2,
  SubContent: () => SubContent2,
  SubTrigger: () => SubTrigger2,
  Trigger: () => Trigger2,
  useRootContext: () => useRootContext,
  useSubContext: () => useSubContext
});
module.exports = __toCommonJS(dropdown_menu_web_exports);
var DropdownMenu = __toESM(require("@radix-ui/react-dropdown-menu"));
var import_hooks = require("@rn-primitives/hooks");
var Slot = __toESM(require("@rn-primitives/slot"));
var import_utils = require("@rn-primitives/utils");
var React = __toESM(require("react"));
var import_react_native = require("react-native");
var DropdownMenuContext = React.createContext(null);
var Root2 = React.forwardRef(
  ({ asChild, onOpenChange: onOpenChangeProp, ...viewProps }, ref) => {
    const [open, setOpen] = React.useState(false);
    function onOpenChange(open2) {
      setOpen(open2);
      onOpenChangeProp?.(open2);
    }
    const Component = asChild ? Slot.View : import_react_native.View;
    return <DropdownMenuContext.Provider value={{ open, onOpenChange }}><DropdownMenu.Root open={open} onOpenChange={onOpenChange}><Component ref={ref} {...viewProps} /></DropdownMenu.Root></DropdownMenuContext.Provider>;
  }
);
Root2.displayName = "RootWebDropdownMenu";
function useRootContext() {
  const context = React.useContext(DropdownMenuContext);
  if (!context) {
    throw new Error(
      "DropdownMenu compound components cannot be rendered outside the DropdownMenu component"
    );
  }
  return context;
}
var Trigger2 = React.forwardRef(
  ({ asChild, disabled = false, ...props }, ref) => {
    const { open, onOpenChange } = useRootContext();
    const augmentedRef = (0, import_hooks.useAugmentedRef)({
      ref,
      methods: {
        open() {
          onOpenChange(true);
        },
        close() {
          onOpenChange(false);
        }
      }
    });
    (0, import_hooks.useIsomorphicLayoutEffect)(() => {
      if (augmentedRef.current) {
        const augRef = augmentedRef.current;
        augRef.dataset.state = open ? "open" : "closed";
      }
    }, [open]);
    (0, import_hooks.useIsomorphicLayoutEffect)(() => {
      if (augmentedRef.current) {
        const augRef = augmentedRef.current;
        if (disabled) {
          augRef.dataset.disabled = "true";
        } else {
          augRef.dataset.disabled = void 0;
        }
      }
    }, [disabled]);
    const Component = asChild ? Slot.Pressable : import_react_native.Pressable;
    return <DropdownMenu.Trigger disabled={disabled ?? void 0} asChild><Component ref={augmentedRef} {...props} /></DropdownMenu.Trigger>;
  }
);
Trigger2.displayName = "TriggerWebDropdownMenu";
function Portal2({ forceMount, container, children }) {
  return <DropdownMenu.Portal forceMount={forceMount} container={container} children={children} />;
}
var Overlay = React.forwardRef(({ asChild, ...props }, ref) => {
  const Component = asChild ? Slot.Pressable : import_react_native.Pressable;
  return <Component ref={ref} {...props} />;
});
Overlay.displayName = "OverlayWebDropdownMenu";
var DropdownMenuContentContext = React.createContext(null);
var Content2 = React.forwardRef(
  ({
    asChild = false,
    forceMount,
    align,
    side,
    sideOffset,
    alignOffset = 0,
    avoidCollisions = true,
    insets,
    loop = true,
    onCloseAutoFocus,
    onEscapeKeyDown,
    onPointerDownOutside,
    onFocusOutside,
    onInteractOutside,
    collisionBoundary,
    sticky,
    hideWhenDetached,
    ...props
  }, ref) => {
    const itemRef = React.useRef(null);
    function close() {
      itemRef.current?.click();
    }
    const Component = asChild ? Slot.Pressable : import_react_native.Pressable;
    return <DropdownMenuContentContext.Provider value={{ close }}><DropdownMenu.Content
      forceMount={forceMount}
      alignOffset={alignOffset}
      avoidCollisions={avoidCollisions}
      collisionPadding={insets}
      loop={loop}
      onCloseAutoFocus={onCloseAutoFocus}
      onEscapeKeyDown={onEscapeKeyDown}
      onPointerDownOutside={onPointerDownOutside}
      onFocusOutside={onFocusOutside}
      onInteractOutside={onInteractOutside}
      collisionBoundary={collisionBoundary}
      sticky={sticky}
      hideWhenDetached={hideWhenDetached}
      align={align}
      side={side}
      sideOffset={sideOffset}
    ><Component ref={ref} {...props} /><DropdownMenu.Item
      ref={itemRef}
      aria-hidden
      style={{ position: "fixed", top: 0, left: 0, zIndex: -999999999 }}
      aria-disabled
      tabIndex={-1}
      hidden
    /></DropdownMenu.Content></DropdownMenuContentContext.Provider>;
  }
);
Content2.displayName = "ContentWebDropdownMenu";
function useDropdownMenuContentContext() {
  const context = React.useContext(DropdownMenuContentContext);
  if (!context) {
    throw new Error(
      "DropdownMenu compound components cannot be rendered outside the DropdownMenu component"
    );
  }
  return context;
}
var Item2 = React.forwardRef(
  ({
    asChild,
    textValue,
    closeOnPress = true,
    onPress: onPressProp,
    onKeyDown: onKeyDownProp,
    ...props
  }, ref) => {
    const { close } = useDropdownMenuContentContext();
    function onKeyDown(ev) {
      onKeyDownProp?.(ev);
      if (ev.key === "Enter" || ev.key === " ") {
        onPressProp?.(import_utils.EmptyGestureResponderEvent);
        if (closeOnPress) {
          close();
        }
      }
    }
    function onPress(ev) {
      onPressProp?.(ev);
      if (closeOnPress) {
        close();
      }
    }
    const Component = asChild ? Slot.Pressable : import_react_native.Pressable;
    return <DropdownMenu.Item
      textValue={textValue}
      disabled={props.disabled ?? void 0}
      onSelect={closeOnPress ? void 0 : onSelected}
      asChild
    ><Component
      ref={ref}
      onKeyDown={onKeyDown}
      onPress={onPress}
      {...props}
    /></DropdownMenu.Item>;
  }
);
Item2.displayName = "ItemWebDropdownMenu";
var Group2 = React.forwardRef(({ asChild, ...props }, ref) => {
  const Component = asChild ? Slot.View : import_react_native.View;
  return <DropdownMenu.Group asChild><Component ref={ref} {...props} /></DropdownMenu.Group>;
});
Group2.displayName = "GroupWebDropdownMenu";
var Label2 = React.forwardRef(({ asChild, ...props }, ref) => {
  const Component = asChild ? Slot.Text : import_react_native.Text;
  return <DropdownMenu.Label asChild><Component ref={ref} {...props} /></DropdownMenu.Label>;
});
Label2.displayName = "LabelWebDropdownMenu";
var CheckboxItem2 = React.forwardRef(
  ({
    asChild,
    checked,
    onCheckedChange,
    textValue,
    disabled = false,
    closeOnPress = true,
    onPress: onPressProp,
    onKeyDown: onKeyDownProp,
    ...props
  }, ref) => {
    const { close } = useDropdownMenuContentContext();
    function onKeyDown(ev) {
      onKeyDownProp?.(ev);
      if (ev.key === "Enter" || ev.key === " ") {
        onPressProp?.(import_utils.EmptyGestureResponderEvent);
        onCheckedChange?.(!checked);
        if (closeOnPress) {
          close();
        }
      }
    }
    function onPress(ev) {
      onPressProp?.(ev);
      onCheckedChange?.(!checked);
      if (closeOnPress) {
        close();
      }
    }
    const Component = asChild ? Slot.Pressable : import_react_native.Pressable;
    return <DropdownMenu.CheckboxItem
      textValue={textValue}
      checked={checked}
      onCheckedChange={onCheckedChange}
      onSelect={closeOnPress ? void 0 : onSelected}
      disabled={disabled ?? void 0}
      asChild
    ><Component
      ref={ref}
      onKeyDown={onKeyDown}
      onPress={onPress}
      role='button'
      {...props}
    /></DropdownMenu.CheckboxItem>;
  }
);
CheckboxItem2.displayName = "CheckboxItemWebDropdownMenu";
var DropdownMenuRadioGroupContext = React.createContext(null);
var RadioGroup2 = React.forwardRef(
  ({ asChild, value, onValueChange, ...props }, ref) => {
    const Component = asChild ? Slot.View : import_react_native.View;
    return <DropdownMenuRadioGroupContext.Provider value={{ value, onValueChange }}><DropdownMenu.RadioGroup value={value} onValueChange={onValueChange} asChild><Component ref={ref} {...props} /></DropdownMenu.RadioGroup></DropdownMenuRadioGroupContext.Provider>;
  }
);
RadioGroup2.displayName = "RadioGroupWebDropdownMenu";
function useDropdownMenuRadioGroupContext() {
  const context = React.useContext(DropdownMenuRadioGroupContext);
  if (!context) {
    throw new Error(
      "DropdownMenuRadioGroup compound components cannot be rendered outside the DropdownMenuRadioGroup component"
    );
  }
  return context;
}
var RadioItem2 = React.forwardRef(
  ({
    asChild,
    value,
    textValue,
    closeOnPress = true,
    onPress: onPressProp,
    onKeyDown: onKeyDownProp,
    ...props
  }, ref) => {
    const { onValueChange } = useDropdownMenuRadioGroupContext();
    const { close } = useDropdownMenuContentContext();
    function onKeyDown(ev) {
      onKeyDownProp?.(ev);
      if (ev.key === "Enter" || ev.key === " ") {
        onValueChange?.(value);
        onPressProp?.(import_utils.EmptyGestureResponderEvent);
        if (closeOnPress) {
          close();
        }
      }
    }
    function onPress(ev) {
      onValueChange?.(value);
      onPressProp?.(ev);
      if (closeOnPress) {
        close();
      }
    }
    const Component = asChild ? Slot.Pressable : import_react_native.Pressable;
    return <DropdownMenu.RadioItem
      value={value}
      textValue={textValue}
      disabled={props.disabled ?? void 0}
      onSelect={closeOnPress ? void 0 : onSelected}
      asChild
    ><Component
      ref={ref}
      onKeyDown={onKeyDown}
      onPress={onPress}
      {...props}
    /></DropdownMenu.RadioItem>;
  }
);
RadioItem2.displayName = "RadioItemWebDropdownMenu";
var ItemIndicator2 = React.forwardRef(
  ({ asChild, forceMount, ...props }, ref) => {
    const Component = asChild ? Slot.View : import_react_native.View;
    return <DropdownMenu.ItemIndicator forceMount={forceMount} asChild><Component ref={ref} {...props} /></DropdownMenu.ItemIndicator>;
  }
);
ItemIndicator2.displayName = "ItemIndicatorWebDropdownMenu";
var Separator2 = React.forwardRef(
  ({ asChild, decorative, ...props }, ref) => {
    const Component = asChild ? Slot.View : import_react_native.View;
    return <DropdownMenu.Separator asChild><Component ref={ref} {...props} /></DropdownMenu.Separator>;
  }
);
Separator2.displayName = "SeparatorWebDropdownMenu";
var DropdownMenuSubContext = React.createContext(null);
var Sub2 = React.forwardRef(
  ({ asChild, defaultOpen, open: openProp, onOpenChange: onOpenChangeProp, ...props }, ref) => {
    const [open = false, onOpenChange] = (0, import_hooks.useControllableState)({
      prop: openProp,
      defaultProp: defaultOpen,
      onChange: onOpenChangeProp
    });
    const Component = asChild ? Slot.View : import_react_native.View;
    return <DropdownMenuSubContext.Provider value={{ open, onOpenChange }}><DropdownMenu.Sub open={open} onOpenChange={onOpenChange}><Component ref={ref} {...props} /></DropdownMenu.Sub></DropdownMenuSubContext.Provider>;
  }
);
Sub2.displayName = "SubWebDropdownMenu";
function useSubContext() {
  const context = React.useContext(DropdownMenuSubContext);
  if (!context) {
    throw new Error(
      "DropdownMenu compound components cannot be rendered outside the DropdownMenu component"
    );
  }
  return context;
}
var SubTrigger2 = React.forwardRef(
  ({ asChild, textValue, disabled = false, onPress: onPressProp, ...props }, ref) => {
    const { onOpenChange } = useSubContext();
    function onPress(ev) {
      onOpenChange(true);
      onPressProp?.(ev);
    }
    const Component = asChild ? Slot.Pressable : import_react_native.Pressable;
    return <DropdownMenu.SubTrigger disabled={disabled ?? void 0} textValue={textValue} asChild><Component ref={ref} onPress={onPress} {...props} /></DropdownMenu.SubTrigger>;
  }
);
SubTrigger2.displayName = "SubTriggerWebDropdownMenu";
var SubContent2 = React.forwardRef(
  ({ asChild = false, forceMount, ...props }, ref) => {
    const Component = asChild ? Slot.Pressable : import_react_native.Pressable;
    return <DropdownMenu.Portal><DropdownMenu.SubContent forceMount={forceMount}><Component ref={ref} {...props} /></DropdownMenu.SubContent></DropdownMenu.Portal>;
  }
);
Content2.displayName = "ContentWebDropdownMenu";
function onSelected(ev) {
  ev.preventDefault();
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  CheckboxItem,
  Content,
  Group,
  Item,
  ItemIndicator,
  Label,
  Overlay,
  Portal,
  RadioGroup,
  RadioItem,
  Root,
  Separator,
  Sub,
  SubContent,
  SubTrigger,
  Trigger,
  useRootContext,
  useSubContext
});
