import * as _rn_primitives_types from '@rn-primitives/types';
import * as react_native from 'react-native';
import { View, Text } from 'react-native';
import * as React from 'react';
import { TriggerRef, PortalProps } from './index.mjs';
import './dropdown-menu';

declare const Root: React.ForwardRefExoticComponent<react_native.ViewProps & {
    asChild?: boolean;
} & {
    onOpenChange?: (open: boolean) => void;
} & React.RefAttributes<View>>;
declare function useRootContext(): {
    open: boolean;
    onOpenChange: (open: boolean) => void;
};
declare const Trigger: React.ForwardRefExoticComponent<Omit<react_native.PressableProps & React.RefAttributes<View>, "ref"> & {
    asChild?: boolean;
} & {
    onKeyDown?: (ev: React.KeyboardEvent) => void;
    onKeyUp?: (ev: React.KeyboardEvent) => void;
} & React.RefAttributes<TriggerRef>>;
declare function Portal({ forceMount, container, children }: PortalProps): React.JSX.Element;
declare const Overlay: React.ForwardRefExoticComponent<_rn_primitives_types.ForceMountable & Omit<react_native.PressableProps & React.RefAttributes<View>, "ref"> & {
    asChild?: boolean;
} & {
    onKeyDown?: (ev: React.KeyboardEvent) => void;
    onKeyUp?: (ev: React.KeyboardEvent) => void;
} & {
    closeOnPress?: boolean;
} & React.RefAttributes<View>>;
declare const Content: React.ForwardRefExoticComponent<Omit<react_native.PressableProps & React.RefAttributes<View>, "ref"> & {
    asChild?: boolean;
} & {
    onKeyDown?: (ev: React.KeyboardEvent) => void;
    onKeyUp?: (ev: React.KeyboardEvent) => void;
} & _rn_primitives_types.PositionedContentProps & React.RefAttributes<View>>;
declare const Item: React.ForwardRefExoticComponent<Omit<react_native.PressableProps & React.RefAttributes<View>, "ref"> & {
    asChild?: boolean;
} & {
    onKeyDown?: (ev: React.KeyboardEvent) => void;
    onKeyUp?: (ev: React.KeyboardEvent) => void;
} & {
    textValue?: string;
    closeOnPress?: boolean;
} & React.RefAttributes<View>>;
declare const Group: React.ForwardRefExoticComponent<react_native.ViewProps & {
    asChild?: boolean;
} & React.RefAttributes<View>>;
declare const Label: React.ForwardRefExoticComponent<react_native.TextProps & {
    asChild?: boolean;
} & React.RefAttributes<Text>>;
declare const CheckboxItem: React.ForwardRefExoticComponent<Omit<react_native.PressableProps & React.RefAttributes<View>, "ref"> & {
    asChild?: boolean;
} & {
    onKeyDown?: (ev: React.KeyboardEvent) => void;
    onKeyUp?: (ev: React.KeyboardEvent) => void;
} & {
    checked: boolean;
    onCheckedChange: (checked: boolean) => void;
    closeOnPress?: boolean;
    textValue?: string;
} & React.RefAttributes<View>>;
declare const RadioGroup: React.ForwardRefExoticComponent<react_native.ViewProps & {
    asChild?: boolean;
} & {
    value: string | undefined;
    onValueChange: (value: string) => void;
} & React.RefAttributes<View>>;
declare const RadioItem: React.ForwardRefExoticComponent<Omit<react_native.PressableProps & React.RefAttributes<View>, "ref"> & {
    asChild?: boolean;
} & {
    onKeyDown?: (ev: React.KeyboardEvent) => void;
    onKeyUp?: (ev: React.KeyboardEvent) => void;
} & {
    value: string;
    textValue?: string;
    closeOnPress?: boolean;
} & React.RefAttributes<View>>;
declare const ItemIndicator: React.ForwardRefExoticComponent<react_native.ViewProps & {
    asChild?: boolean;
} & _rn_primitives_types.ForceMountable & React.RefAttributes<View>>;
declare const Separator: React.ForwardRefExoticComponent<react_native.ViewProps & {
    asChild?: boolean;
} & {
    decorative?: boolean;
} & React.RefAttributes<View>>;
declare const Sub: React.ForwardRefExoticComponent<react_native.ViewProps & {
    asChild?: boolean;
} & {
    defaultOpen?: boolean;
    open?: boolean;
    onOpenChange?: (value: boolean) => void;
} & React.RefAttributes<View>>;
declare function useSubContext(): {
    open: boolean;
    onOpenChange: (open: boolean) => void;
};
declare const SubTrigger: React.ForwardRefExoticComponent<Omit<react_native.PressableProps & React.RefAttributes<View>, "ref"> & {
    asChild?: boolean;
} & {
    onKeyDown?: (ev: React.KeyboardEvent) => void;
    onKeyUp?: (ev: React.KeyboardEvent) => void;
} & {
    textValue?: string;
} & React.RefAttributes<View>>;
declare const SubContent: React.ForwardRefExoticComponent<Omit<react_native.PressableProps & React.RefAttributes<View>, "ref"> & {
    asChild?: boolean;
} & {
    onKeyDown?: (ev: React.KeyboardEvent) => void;
    onKeyUp?: (ev: React.KeyboardEvent) => void;
} & _rn_primitives_types.ForceMountable & React.RefAttributes<View>>;

export { CheckboxItem, Content, Group, Item, ItemIndicator, Label, Overlay, Portal, RadioGroup, RadioItem, Root, Separator, Sub, SubContent, SubTrigger, Trigger, useRootContext, useSubContext };
