'use client'
"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/dropdown-menu.tsx
var dropdown_menu_exports = {};
__export(dropdown_menu_exports, {
  CheckboxItem: () => CheckboxItem,
  Content: () => Content,
  Group: () => Group,
  Item: () => Item,
  ItemIndicator: () => ItemIndicator,
  Label: () => Label,
  Overlay: () => Overlay,
  Portal: () => Portal,
  RadioGroup: () => RadioGroup,
  RadioItem: () => RadioItem,
  Root: () => Root,
  Separator: () => Separator,
  Sub: () => Sub,
  SubContent: () => SubContent,
  SubTrigger: () => SubTrigger,
  Trigger: () => Trigger,
  useRootContext: () => useRootContext,
  useSubContext: () => useSubContext
});
module.exports = __toCommonJS(dropdown_menu_exports);
var import_hooks = require("@rn-primitives/hooks");
var import_portal = require("@rn-primitives/portal");
var Slot = __toESM(require("@rn-primitives/slot"));
var React = __toESM(require("react"));
var import_react_native = require("react-native");
var RootContext = React.createContext(null);
var Root = React.forwardRef(
  ({ asChild, onOpenChange: onOpenChangeProp, ...viewProps }, ref) => {
    const nativeID = React.useId();
    const [triggerPosition, setTriggerPosition] = React.useState(null);
    const [contentLayout, setContentLayout] = React.useState(null);
    const [open, setOpen] = React.useState(false);
    function onOpenChange(open2) {
      setOpen(open2);
      onOpenChangeProp?.(open2);
    }
    const Component = asChild ? Slot.View : import_react_native.View;
    return <RootContext.Provider
      value={{
        open,
        onOpenChange,
        contentLayout,
        setContentLayout,
        nativeID,
        setTriggerPosition,
        triggerPosition
      }}
    ><Component ref={ref} {...viewProps} /></RootContext.Provider>;
  }
);
Root.displayName = "RootNativeDropdownMenu";
function useRootContext() {
  const context = React.useContext(RootContext);
  if (!context) {
    throw new Error(
      "DropdownMenu compound components cannot be rendered outside the DropdownMenu component"
    );
  }
  return context;
}
var Trigger = React.forwardRef(
  ({ asChild, onPress: onPressProp, disabled = false, ...props }, ref) => {
    const { open, onOpenChange, setTriggerPosition } = useRootContext();
    const augmentedRef = (0, import_hooks.useAugmentedRef)({
      ref,
      methods: {
        open: () => {
          onOpenChange(true);
          augmentedRef.current?.measure((_x, _y, width, height, pageX, pageY) => {
            setTriggerPosition({ width, pageX, pageY, height });
          });
        },
        close: () => {
          setTriggerPosition(null);
          onOpenChange(false);
        }
      }
    });
    function onPress(ev) {
      if (disabled) return;
      augmentedRef.current?.measure((_x, _y, width, height, pageX, pageY) => {
        setTriggerPosition({ width, pageX, pageY, height });
      });
      const newValue = !open;
      onOpenChange(newValue);
      onPressProp?.(ev);
    }
    const Component = asChild ? Slot.Pressable : import_react_native.Pressable;
    return <Component
      ref={augmentedRef}
      aria-disabled={disabled ?? void 0}
      role='button'
      onPress={onPress}
      disabled={disabled ?? void 0}
      aria-expanded={open}
      {...props}
    />;
  }
);
Trigger.displayName = "TriggerNativeDropdownMenu";
function Portal({ forceMount, hostName, children }) {
  const value = useRootContext();
  if (!value.triggerPosition) {
    return null;
  }
  if (!forceMount) {
    if (!value.open) {
      return null;
    }
  }
  return <import_portal.Portal hostName={hostName} name={`${value.nativeID}_portal`}><RootContext.Provider value={value}>{children}</RootContext.Provider></import_portal.Portal>;
}
var Overlay = React.forwardRef(
  ({ asChild, forceMount, onPress: OnPressProp, closeOnPress = true, ...props }, ref) => {
    const { open, onOpenChange, setContentLayout, setTriggerPosition } = useRootContext();
    function onPress(ev) {
      if (closeOnPress) {
        setTriggerPosition(null);
        setContentLayout(null);
        onOpenChange(false);
      }
      OnPressProp?.(ev);
    }
    if (!forceMount) {
      if (!open) {
        return null;
      }
    }
    const Component = asChild ? Slot.Pressable : import_react_native.Pressable;
    return <Component ref={ref} onPress={onPress} {...props} />;
  }
);
Overlay.displayName = "OverlayNativeDropdownMenu";
var Content = React.forwardRef(
  ({
    asChild = false,
    forceMount,
    align = "start",
    side = "bottom",
    sideOffset = 0,
    alignOffset = 0,
    avoidCollisions = true,
    onLayout: onLayoutProp,
    insets,
    style,
    disablePositioningStyle,
    ...props
  }, ref) => {
    const {
      open,
      onOpenChange,
      nativeID,
      triggerPosition,
      setTriggerPosition,
      contentLayout,
      setContentLayout
    } = useRootContext();
    React.useEffect(() => {
      const backHandler = import_react_native.BackHandler.addEventListener("hardwareBackPress", () => {
        setTriggerPosition(null);
        setContentLayout(null);
        onOpenChange(false);
        return true;
      });
      return () => {
        setContentLayout(null);
        backHandler.remove();
      };
    }, []);
    const positionStyle = (0, import_hooks.useRelativePosition)({
      align,
      avoidCollisions,
      triggerPosition,
      contentLayout,
      alignOffset,
      insets,
      sideOffset,
      side,
      disablePositioningStyle
    });
    function onLayout(event) {
      setContentLayout(event.nativeEvent.layout);
      onLayoutProp?.(event);
    }
    if (!forceMount) {
      if (!open) {
        return null;
      }
    }
    const Component = asChild ? Slot.Pressable : import_react_native.Pressable;
    return <Component
      ref={ref}
      role='menu'
      nativeID={nativeID}
      aria-modal={true}
      style={[positionStyle, style]}
      onLayout={onLayout}
      {...props}
    />;
  }
);
Content.displayName = "ContentNativeDropdownMenu";
var Item = React.forwardRef(
  ({ asChild, textValue, onPress: onPressProp, disabled = false, closeOnPress = true, ...props }, ref) => {
    const { onOpenChange, setTriggerPosition, setContentLayout } = useRootContext();
    function onPress(ev) {
      if (closeOnPress) {
        setTriggerPosition(null);
        setContentLayout(null);
        onOpenChange(false);
      }
      onPressProp?.(ev);
    }
    const Component = asChild ? Slot.Pressable : import_react_native.Pressable;
    return <Component
      ref={ref}
      role='menuitem'
      onPress={onPress}
      disabled={disabled}
      aria-valuetext={textValue}
      aria-disabled={!!disabled}
      accessibilityState={{ disabled: !!disabled }}
      {...props}
    />;
  }
);
Item.displayName = "ItemNativeDropdownMenu";
var Group = React.forwardRef(({ asChild, ...props }, ref) => {
  const Component = asChild ? Slot.View : import_react_native.View;
  return <Component ref={ref} role='group' {...props} />;
});
Group.displayName = "GroupNativeDropdownMenu";
var Label = React.forwardRef(({ asChild, ...props }, ref) => {
  const Component = asChild ? Slot.Text : import_react_native.Text;
  return <Component ref={ref} {...props} />;
});
Label.displayName = "LabelNativeDropdownMenu";
var FormItemContext = React.createContext(null);
var CheckboxItem = React.forwardRef(
  ({
    asChild,
    checked,
    onCheckedChange,
    textValue,
    onPress: onPressProp,
    closeOnPress = true,
    disabled = false,
    ...props
  }, ref) => {
    const { onOpenChange, setContentLayout, setTriggerPosition, nativeID } = useRootContext();
    function onPress(ev) {
      onCheckedChange(!checked);
      if (closeOnPress) {
        setTriggerPosition(null);
        setContentLayout(null);
        onOpenChange(false);
      }
      onPressProp?.(ev);
    }
    const Component = asChild ? Slot.Pressable : import_react_native.Pressable;
    return <FormItemContext.Provider value={{ checked }}><Component
      ref={ref}
      role='checkbox'
      aria-checked={checked}
      onPress={onPress}
      disabled={disabled}
      aria-disabled={!!disabled}
      aria-valuetext={textValue}
      accessibilityState={{ disabled: !!disabled }}
      {...props}
    /></FormItemContext.Provider>;
  }
);
CheckboxItem.displayName = "CheckboxItemNativeDropdownMenu";
function useFormItemContext() {
  const context = React.useContext(FormItemContext);
  if (!context) {
    throw new Error(
      "CheckboxItem or RadioItem compound components cannot be rendered outside of a CheckboxItem or RadioItem component"
    );
  }
  return context;
}
var RadioGroup = React.forwardRef(
  ({ asChild, value, onValueChange, ...props }, ref) => {
    const Component = asChild ? Slot.View : import_react_native.View;
    return <FormItemContext.Provider value={{ value, onValueChange }}><Component ref={ref} role='radiogroup' {...props} /></FormItemContext.Provider>;
  }
);
RadioGroup.displayName = "RadioGroupNativeDropdownMenu";
var RadioItemContext = React.createContext({});
var RadioItem = React.forwardRef(
  ({
    asChild,
    value: itemValue,
    textValue,
    onPress: onPressProp,
    disabled = false,
    closeOnPress = true,
    ...props
  }, ref) => {
    const { onOpenChange, setContentLayout, setTriggerPosition } = useRootContext();
    const { value, onValueChange } = useFormItemContext();
    function onPress(ev) {
      onValueChange(itemValue);
      if (closeOnPress) {
        setTriggerPosition(null);
        setContentLayout(null);
        onOpenChange(false);
      }
      onPressProp?.(ev);
    }
    const Component = asChild ? Slot.Pressable : import_react_native.Pressable;
    return <RadioItemContext.Provider value={{ itemValue }}><Component
      ref={ref}
      onPress={onPress}
      role='radio'
      aria-checked={value === itemValue}
      disabled={disabled ?? false}
      accessibilityState={{
        disabled: disabled ?? false,
        checked: value === itemValue
      }}
      aria-valuetext={textValue}
      {...props}
    /></RadioItemContext.Provider>;
  }
);
RadioItem.displayName = "RadioItemNativeDropdownMenu";
function useItemIndicatorContext() {
  return React.useContext(RadioItemContext);
}
var ItemIndicator = React.forwardRef(
  ({ asChild, forceMount, ...props }, ref) => {
    const { itemValue } = useItemIndicatorContext();
    const { checked, value } = useFormItemContext();
    if (!forceMount) {
      if (itemValue == null && !checked) {
        return null;
      }
      if (value !== itemValue) {
        return null;
      }
    }
    const Component = asChild ? Slot.View : import_react_native.View;
    return <Component ref={ref} role='presentation' {...props} />;
  }
);
ItemIndicator.displayName = "ItemIndicatorNativeDropdownMenu";
var Separator = React.forwardRef(
  ({ asChild, decorative, ...props }, ref) => {
    const Component = asChild ? Slot.View : import_react_native.View;
    return <Component role={decorative ? "presentation" : "separator"} ref={ref} {...props} />;
  }
);
Separator.displayName = "SeparatorNativeDropdownMenu";
var SubContext = React.createContext(null);
var Sub = React.forwardRef(
  ({ asChild, defaultOpen, open: openProp, onOpenChange: onOpenChangeProp, ...props }, ref) => {
    const nativeID = React.useId();
    const [open = false, onOpenChange] = (0, import_hooks.useControllableState)({
      prop: openProp,
      defaultProp: defaultOpen,
      onChange: onOpenChangeProp
    });
    const Component = asChild ? Slot.View : import_react_native.View;
    return <SubContext.Provider
      value={{
        nativeID,
        open,
        onOpenChange
      }}
    ><Component ref={ref} {...props} /></SubContext.Provider>;
  }
);
Sub.displayName = "SubNativeDropdownMenu";
function useSubContext() {
  const context = React.useContext(SubContext);
  if (!context) {
    throw new Error("Sub compound components cannot be rendered outside of a Sub component");
  }
  return context;
}
var SubTrigger = React.forwardRef(
  ({ asChild, textValue, onPress: onPressProp, disabled = false, ...props }, ref) => {
    const { nativeID, open, onOpenChange } = useSubContext();
    function onPress(ev) {
      onOpenChange(!open);
      onPressProp?.(ev);
    }
    const Component = asChild ? Slot.Pressable : import_react_native.Pressable;
    return <Component
      ref={ref}
      aria-valuetext={textValue}
      role='menuitem'
      aria-expanded={open}
      accessibilityState={{ expanded: open, disabled: !!disabled }}
      nativeID={nativeID}
      onPress={onPress}
      disabled={disabled}
      aria-disabled={!!disabled}
      {...props}
    />;
  }
);
SubTrigger.displayName = "SubTriggerNativeDropdownMenu";
var SubContent = React.forwardRef(
  ({ asChild = false, forceMount, ...props }, ref) => {
    const { open, nativeID } = useSubContext();
    if (!forceMount) {
      if (!open) {
        return null;
      }
    }
    const Component = asChild ? Slot.Pressable : import_react_native.Pressable;
    return <Component ref={ref} role='group' aria-labelledby={nativeID} {...props} />;
  }
);
Content.displayName = "ContentNativeDropdownMenu";
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  CheckboxItem,
  Content,
  Group,
  Item,
  ItemIndicator,
  Label,
  Overlay,
  Portal,
  RadioGroup,
  RadioItem,
  Root,
  Separator,
  Sub,
  SubContent,
  SubTrigger,
  Trigger,
  useRootContext,
  useSubContext
});
