import { ForcedLicense } from "./load-forced-licenses.js";
export type ResolvedLicense = {
    expression?: string;
    source: "license" | "readme" | "forced" | "notice";
    text: string;
};
export type ResolvedPackage = {
    name: string;
    version: string;
    path: string;
    licenseExpression: string;
    licenses: ResolvedLicense[];
    homepage?: string;
    repository?: string;
    funding?: string[];
    description?: string;
};
export type Options = {
    /** Adds a homepage key containing a URL string for relevant packages, defaults to false */
    includeHomepage?: boolean;
    /** Adds a repository key containing a URL string for relevant packages, defaults to false */
    includeRepository?: boolean;
    /** Adds a funding key containing a list of URL strings for relevant packages, defaults to false */
    includeFunding?: boolean;
    /** Adds a description key containing the description stored in package.json, defaults to false */
    includeDescription?: boolean;
    /** Includes devDependencies in the output, defaults to false */
    includeDev?: boolean;
    /** List of package names to exclude from results, used when the license is only provided from a parent package */
    exclude?: string[];
    /** When defined, any packages not in this list are excluded */
    include?: string[];
    /** Useful for getting rid of warnings and handling cases where the tool fails to grab the license */
    overrides?: {
        [packageName: string]: {
            licenseExpression: string;
            licenses?: ForcedLicense[];
        };
    };
    /** Add anything not picked up by the tool */
    append?: {
        name: string;
        version?: string;
        path?: string;
        licenseExpression?: string;
        licenses?: ForcedLicense[];
        homepage?: string;
        repository?: string;
        funding?: string[];
        description?: string;
    }[];
    /** Defaults to [projectRoot]/node_modules/.cache/license-ripper */
    cacheFolder?: string;
};
export declare function ripOne(packagePath: string, options?: Options): Promise<ResolvedPackage | undefined>;
