var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import * as fs from "fs/promises";
import resolveExpression from "./resolve-expression.js";
export default function loadForcedLicenses(forcedLicenses) {
    return __awaiter(this, void 0, void 0, function* () {
        const resolved = [];
        for (const template of forcedLicenses) {
            const license = {
                expression: "UNKNOWN",
                source: "forced",
                text: "",
            };
            if (template.file) {
                license.text = yield fs.readFile(template.file, "utf8");
            }
            else if (template.text) {
                license.text = template.text;
            }
            if (template.expression) {
                license.expression = template.expression;
            }
            else if (license.text) {
                resolveExpression(license.text);
            }
            resolved.push(license);
        }
        return resolved;
    });
}
