'use client'

// src/portal.tsx
import * as React from "react";
import { Platform } from "react-native";
import { create } from "zustand";
var DEFAULT_PORTAL_HOST = "INTERNAL_PRIMITIVE_DEFAULT_HOST_NAME";
var usePortal = create(() => ({
  map: (/* @__PURE__ */ new Map()).set(DEFAULT_PORTAL_HOST, /* @__PURE__ */ new Map())
}));
var updatePortal = (hostName, name, children) => {
  usePortal.setState((prev) => {
    const next = new Map(prev.map);
    const portal = next.get(hostName) ?? /* @__PURE__ */ new Map();
    portal.set(name, children);
    next.set(hostName, portal);
    return { map: next };
  });
};
var removePortal = (hostName, name) => {
  usePortal.setState((prev) => {
    const next = new Map(prev.map);
    const portal = next.get(hostName) ?? /* @__PURE__ */ new Map();
    portal.delete(name);
    next.set(hostName, portal);
    return { map: next };
  });
};
function PortalHost({ name = DEFAULT_PORTAL_HOST }) {
  const portalMap = usePortal((state) => state.map).get(name) ?? /* @__PURE__ */ new Map();
  if (portalMap.size === 0) return null;
  return <>{Array.from(portalMap.values())}</>;
}
function Portal({
  name,
  hostName = DEFAULT_PORTAL_HOST,
  children
}) {
  React.useEffect(() => {
    updatePortal(hostName, name, children);
  }, [hostName, name, children]);
  React.useEffect(() => {
    return () => {
      removePortal(hostName, name);
    };
  }, [hostName, name]);
  return null;
}
var ROOT = {
  flex: 1
};
function useModalPortalRoot() {
  const ref = React.useRef(null);
  const [sideOffset, setSideOffSet] = React.useState(0);
  const onLayout = React.useCallback(() => {
    if (Platform.OS === "web") return;
    ref.current?.measure((_x, _y, _width, _height, _pageX, pageY) => {
      setSideOffSet(-pageY);
    });
  }, []);
  return {
    ref,
    sideOffset,
    onLayout,
    style: ROOT
  };
}
export {
  Portal,
  PortalHost,
  useModalPortalRoot
};
