var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import path from "path";
import * as fs from "fs/promises";
const CACHE_VERSION = 0;
export function getDefaultCacheFolder(projectRoot) {
    return path.join(projectRoot, "node_modules", ".cache", "license-ripper");
}
export function licenseFromCache(name, options) {
    return __awaiter(this, void 0, void 0, function* () {
        const cacheFolder = options === null || options === void 0 ? void 0 : options.cacheFolder;
        if (!cacheFolder) {
            return;
        }
        try {
            const text = yield fs.readFile(path.join(cacheFolder, name), "utf8");
            const cachedData = JSON.parse(text);
            if (cachedData.version != CACHE_VERSION) {
                return;
            }
            return cachedData.data;
        }
        catch (_a) {
            // ok to fail, either it doesn't exist or we'll fix it when we cache new results
        }
    });
}
export function cacheResult(name, data, options) {
    return __awaiter(this, void 0, void 0, function* () {
        const cacheFolder = options === null || options === void 0 ? void 0 : options.cacheFolder;
        if (!cacheFolder) {
            return;
        }
        try {
            yield fs.mkdir(cacheFolder, { recursive: true });
        }
        catch (_a) {
            // ignore errors as it may just complain about the folder already existing
        }
        try {
            yield fs.writeFile(path.join(cacheFolder, name), JSON.stringify({ version: CACHE_VERSION, data }));
        }
        catch (_b) {
            // it's just cache, shouldn't matter too much
        }
    });
}
