'use client'

// src/slot.tsx
import * as React from "react";
import {
  StyleSheet
} from "react-native";
var Pressable = React.forwardRef(
  (props, forwardedRef) => {
    const { children, ...pressableSlotProps } = props;
    if (!React.isValidElement(children)) {
      console.log("Slot.Pressable - Invalid asChild element", children);
      return null;
    }
    return React.cloneElement(isTextChildren(children) ? <></> : children, {
      ...mergeProps(pressableSlotProps, children.props),
      ref: forwardedRef ? composeRefs(forwardedRef, children.ref) : children.ref
    });
  }
);
Pressable.displayName = "SlotPressable";
var View = React.forwardRef(
  (props, forwardedRef) => {
    const { children, ...viewSlotProps } = props;
    if (!React.isValidElement(children)) {
      console.log("Slot.View - Invalid asChild element", children);
      return null;
    }
    return React.cloneElement(isTextChildren(children) ? <></> : children, {
      ...mergeProps(viewSlotProps, children.props),
      ref: forwardedRef ? composeRefs(forwardedRef, children.ref) : children.ref
    });
  }
);
View.displayName = "SlotView";
var Text = React.forwardRef(
  (props, forwardedRef) => {
    const { children, ...textSlotProps } = props;
    if (!React.isValidElement(children)) {
      console.log("Slot.Text - Invalid asChild element", children);
      return null;
    }
    return React.cloneElement(isTextChildren(children) ? <></> : children, {
      ...mergeProps(textSlotProps, children.props),
      ref: forwardedRef ? composeRefs(forwardedRef, children.ref) : children.ref
    });
  }
);
Text.displayName = "SlotText";
var Image = React.forwardRef(
  (props, forwardedRef) => {
    const { children, ...imageSlotProps } = props;
    if (!React.isValidElement(children)) {
      console.log("Slot.Image - Invalid asChild element", children);
      return null;
    }
    return React.cloneElement(isTextChildren(children) ? <></> : children, {
      ...mergeProps(imageSlotProps, children.props),
      ref: forwardedRef ? composeRefs(forwardedRef, children.ref) : children.ref
    });
  }
);
Image.displayName = "SlotImage";
function composeRefs(...refs) {
  return (node) => refs.forEach((ref) => {
    if (typeof ref === "function") {
      ref(node);
    } else if (ref != null) {
      ref.current = node;
    }
  });
}
function mergeProps(slotProps, childProps) {
  const overrideProps = { ...childProps };
  for (const propName in childProps) {
    const slotPropValue = slotProps[propName];
    const childPropValue = childProps[propName];
    const isHandler = /^on[A-Z]/.test(propName);
    if (isHandler) {
      if (slotPropValue && childPropValue) {
        overrideProps[propName] = (...args) => {
          childPropValue(...args);
          slotPropValue(...args);
        };
      } else if (slotPropValue) {
        overrideProps[propName] = slotPropValue;
      }
    } else if (propName === "style") {
      overrideProps[propName] = combineStyles(slotPropValue, childPropValue);
    } else if (propName === "className") {
      overrideProps[propName] = [slotPropValue, childPropValue].filter(Boolean).join(" ");
    }
  }
  return { ...slotProps, ...overrideProps };
}
function combineStyles(slotStyle, childValue) {
  if (typeof slotStyle === "function" && typeof childValue === "function") {
    return (state) => {
      return StyleSheet.flatten([slotStyle(state), childValue(state)]);
    };
  }
  if (typeof slotStyle === "function") {
    return (state) => {
      return childValue ? StyleSheet.flatten([slotStyle(state), childValue]) : slotStyle(state);
    };
  }
  if (typeof childValue === "function") {
    return (state) => {
      return slotStyle ? StyleSheet.flatten([slotStyle, childValue(state)]) : childValue(state);
    };
  }
  return StyleSheet.flatten([slotStyle, childValue].filter(Boolean));
}
function isTextChildren(children) {
  return Array.isArray(children) ? children.every((child) => typeof child === "string") : typeof children === "string";
}
export {
  Image,
  Pressable,
  Text,
  View,
  isTextChildren
};
