'use client'
"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var src_exports = {};
__export(src_exports, {
  Image: () => Image,
  Pressable: () => Pressable,
  Text: () => Text,
  View: () => View,
  isTextChildren: () => isTextChildren
});
module.exports = __toCommonJS(src_exports);

// src/slot.tsx
var React = __toESM(require("react"));
var import_react_native = require("react-native");
var Pressable = React.forwardRef(
  (props, forwardedRef) => {
    const { children, ...pressableSlotProps } = props;
    if (!React.isValidElement(children)) {
      console.log("Slot.Pressable - Invalid asChild element", children);
      return null;
    }
    return React.cloneElement(isTextChildren(children) ? <></> : children, {
      ...mergeProps(pressableSlotProps, children.props),
      ref: forwardedRef ? composeRefs(forwardedRef, children.ref) : children.ref
    });
  }
);
Pressable.displayName = "SlotPressable";
var View = React.forwardRef(
  (props, forwardedRef) => {
    const { children, ...viewSlotProps } = props;
    if (!React.isValidElement(children)) {
      console.log("Slot.View - Invalid asChild element", children);
      return null;
    }
    return React.cloneElement(isTextChildren(children) ? <></> : children, {
      ...mergeProps(viewSlotProps, children.props),
      ref: forwardedRef ? composeRefs(forwardedRef, children.ref) : children.ref
    });
  }
);
View.displayName = "SlotView";
var Text = React.forwardRef(
  (props, forwardedRef) => {
    const { children, ...textSlotProps } = props;
    if (!React.isValidElement(children)) {
      console.log("Slot.Text - Invalid asChild element", children);
      return null;
    }
    return React.cloneElement(isTextChildren(children) ? <></> : children, {
      ...mergeProps(textSlotProps, children.props),
      ref: forwardedRef ? composeRefs(forwardedRef, children.ref) : children.ref
    });
  }
);
Text.displayName = "SlotText";
var Image = React.forwardRef(
  (props, forwardedRef) => {
    const { children, ...imageSlotProps } = props;
    if (!React.isValidElement(children)) {
      console.log("Slot.Image - Invalid asChild element", children);
      return null;
    }
    return React.cloneElement(isTextChildren(children) ? <></> : children, {
      ...mergeProps(imageSlotProps, children.props),
      ref: forwardedRef ? composeRefs(forwardedRef, children.ref) : children.ref
    });
  }
);
Image.displayName = "SlotImage";
function composeRefs(...refs) {
  return (node) => refs.forEach((ref) => {
    if (typeof ref === "function") {
      ref(node);
    } else if (ref != null) {
      ref.current = node;
    }
  });
}
function mergeProps(slotProps, childProps) {
  const overrideProps = { ...childProps };
  for (const propName in childProps) {
    const slotPropValue = slotProps[propName];
    const childPropValue = childProps[propName];
    const isHandler = /^on[A-Z]/.test(propName);
    if (isHandler) {
      if (slotPropValue && childPropValue) {
        overrideProps[propName] = (...args) => {
          childPropValue(...args);
          slotPropValue(...args);
        };
      } else if (slotPropValue) {
        overrideProps[propName] = slotPropValue;
      }
    } else if (propName === "style") {
      overrideProps[propName] = combineStyles(slotPropValue, childPropValue);
    } else if (propName === "className") {
      overrideProps[propName] = [slotPropValue, childPropValue].filter(Boolean).join(" ");
    }
  }
  return { ...slotProps, ...overrideProps };
}
function combineStyles(slotStyle, childValue) {
  if (typeof slotStyle === "function" && typeof childValue === "function") {
    return (state) => {
      return import_react_native.StyleSheet.flatten([slotStyle(state), childValue(state)]);
    };
  }
  if (typeof slotStyle === "function") {
    return (state) => {
      return childValue ? import_react_native.StyleSheet.flatten([slotStyle(state), childValue]) : slotStyle(state);
    };
  }
  if (typeof childValue === "function") {
    return (state) => {
      return slotStyle ? import_react_native.StyleSheet.flatten([slotStyle, childValue(state)]) : childValue(state);
    };
  }
  return import_react_native.StyleSheet.flatten([slotStyle, childValue].filter(Boolean));
}
function isTextChildren(children) {
  return Array.isArray(children) ? children.every((child) => typeof child === "string") : typeof children === "string";
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  Image,
  Pressable,
  Text,
  View,
  isTextChildren
});
