import * as React from 'react';
import { Insets } from '@rn-primitives/types';
import { ViewStyle, LayoutRectangle, ScaledSize } from 'react-native';

interface AugmentRefProps<T> {
    ref: React.Ref<T>;
    methods?: Record<string, (...args: any[]) => any>;
    deps?: any[];
}
declare function useAugmentedRef<T>({ ref, methods, deps, }: AugmentRefProps<T>): React.RefObject<T>;

type UseRelativePositionArgs = Omit<GetContentStyleArgs, 'triggerPosition' | 'contentLayout' | 'dimensions'> & {
    triggerPosition: LayoutPosition | null;
    contentLayout: LayoutRectangle | null;
    disablePositioningStyle?: boolean;
};
declare function useRelativePosition({ align, avoidCollisions, triggerPosition, contentLayout, alignOffset, insets, sideOffset, side, disablePositioningStyle, }: UseRelativePositionArgs): ViewStyle;
interface LayoutPosition {
    pageY: number;
    pageX: number;
    width: number;
    height: number;
}
interface GetPositionArgs {
    dimensions: ScaledSize;
    avoidCollisions: boolean;
    triggerPosition: LayoutPosition;
    contentLayout: LayoutRectangle;
    insets?: Insets;
}
interface GetSidePositionArgs extends GetPositionArgs {
    side: 'top' | 'bottom';
    sideOffset: number;
}
interface GetAlignPositionArgs extends GetPositionArgs {
    align: 'start' | 'center' | 'end';
    alignOffset: number;
}
type GetContentStyleArgs = GetPositionArgs & GetSidePositionArgs & GetAlignPositionArgs;

type UseControllableStateParams<T> = {
    prop?: T | undefined;
    defaultProp?: T | undefined;
    onChange?: (state: T) => void;
};
declare function useControllableState<T>({ prop, defaultProp, onChange, }: UseControllableStateParams<T>): readonly [T | undefined, React.Dispatch<React.SetStateAction<T | undefined>>];

declare function useIsomorphicLayoutEffect(effect: React.EffectCallback, dependencies?: React.DependencyList): void;

export { type LayoutPosition, useAugmentedRef, useControllableState, useIsomorphicLayoutEffect, useRelativePosition };
