'use client'

// src/dropdown-menu.tsx
import {
  useAugmentedRef,
  useControllableState,
  useRelativePosition
} from "@rn-primitives/hooks";
import { Portal as RNPPortal } from "@rn-primitives/portal";
import * as Slot from "@rn-primitives/slot";
import * as React from "react";
import {
  BackHandler,
  Pressable as Pressable2,
  Text as Text2,
  View as View2
} from "react-native";
var RootContext = React.createContext(null);
var Root = React.forwardRef(
  ({ asChild, onOpenChange: onOpenChangeProp, ...viewProps }, ref) => {
    const nativeID = React.useId();
    const [triggerPosition, setTriggerPosition] = React.useState(null);
    const [contentLayout, setContentLayout] = React.useState(null);
    const [open, setOpen] = React.useState(false);
    function onOpenChange(open2) {
      setOpen(open2);
      onOpenChangeProp?.(open2);
    }
    const Component = asChild ? Slot.View : View2;
    return <RootContext.Provider
      value={{
        open,
        onOpenChange,
        contentLayout,
        setContentLayout,
        nativeID,
        setTriggerPosition,
        triggerPosition
      }}
    ><Component ref={ref} {...viewProps} /></RootContext.Provider>;
  }
);
Root.displayName = "RootNativeDropdownMenu";
function useRootContext() {
  const context = React.useContext(RootContext);
  if (!context) {
    throw new Error(
      "DropdownMenu compound components cannot be rendered outside the DropdownMenu component"
    );
  }
  return context;
}
var Trigger = React.forwardRef(
  ({ asChild, onPress: onPressProp, disabled = false, ...props }, ref) => {
    const { open, onOpenChange, setTriggerPosition } = useRootContext();
    const augmentedRef = useAugmentedRef({
      ref,
      methods: {
        open: () => {
          onOpenChange(true);
          augmentedRef.current?.measure((_x, _y, width, height, pageX, pageY) => {
            setTriggerPosition({ width, pageX, pageY, height });
          });
        },
        close: () => {
          setTriggerPosition(null);
          onOpenChange(false);
        }
      }
    });
    function onPress(ev) {
      if (disabled) return;
      augmentedRef.current?.measure((_x, _y, width, height, pageX, pageY) => {
        setTriggerPosition({ width, pageX, pageY, height });
      });
      const newValue = !open;
      onOpenChange(newValue);
      onPressProp?.(ev);
    }
    const Component = asChild ? Slot.Pressable : Pressable2;
    return <Component
      ref={augmentedRef}
      aria-disabled={disabled ?? void 0}
      role='button'
      onPress={onPress}
      disabled={disabled ?? void 0}
      aria-expanded={open}
      {...props}
    />;
  }
);
Trigger.displayName = "TriggerNativeDropdownMenu";
function Portal({ forceMount, hostName, children }) {
  const value = useRootContext();
  if (!value.triggerPosition) {
    return null;
  }
  if (!forceMount) {
    if (!value.open) {
      return null;
    }
  }
  return <RNPPortal hostName={hostName} name={`${value.nativeID}_portal`}><RootContext.Provider value={value}>{children}</RootContext.Provider></RNPPortal>;
}
var Overlay = React.forwardRef(
  ({ asChild, forceMount, onPress: OnPressProp, closeOnPress = true, ...props }, ref) => {
    const { open, onOpenChange, setContentLayout, setTriggerPosition } = useRootContext();
    function onPress(ev) {
      if (closeOnPress) {
        setTriggerPosition(null);
        setContentLayout(null);
        onOpenChange(false);
      }
      OnPressProp?.(ev);
    }
    if (!forceMount) {
      if (!open) {
        return null;
      }
    }
    const Component = asChild ? Slot.Pressable : Pressable2;
    return <Component ref={ref} onPress={onPress} {...props} />;
  }
);
Overlay.displayName = "OverlayNativeDropdownMenu";
var Content = React.forwardRef(
  ({
    asChild = false,
    forceMount,
    align = "start",
    side = "bottom",
    sideOffset = 0,
    alignOffset = 0,
    avoidCollisions = true,
    onLayout: onLayoutProp,
    insets,
    style,
    disablePositioningStyle,
    ...props
  }, ref) => {
    const {
      open,
      onOpenChange,
      nativeID,
      triggerPosition,
      setTriggerPosition,
      contentLayout,
      setContentLayout
    } = useRootContext();
    React.useEffect(() => {
      const backHandler = BackHandler.addEventListener("hardwareBackPress", () => {
        setTriggerPosition(null);
        setContentLayout(null);
        onOpenChange(false);
        return true;
      });
      return () => {
        setContentLayout(null);
        backHandler.remove();
      };
    }, []);
    const positionStyle = useRelativePosition({
      align,
      avoidCollisions,
      triggerPosition,
      contentLayout,
      alignOffset,
      insets,
      sideOffset,
      side,
      disablePositioningStyle
    });
    function onLayout(event) {
      setContentLayout(event.nativeEvent.layout);
      onLayoutProp?.(event);
    }
    if (!forceMount) {
      if (!open) {
        return null;
      }
    }
    const Component = asChild ? Slot.Pressable : Pressable2;
    return <Component
      ref={ref}
      role='menu'
      nativeID={nativeID}
      aria-modal={true}
      style={[positionStyle, style]}
      onLayout={onLayout}
      {...props}
    />;
  }
);
Content.displayName = "ContentNativeDropdownMenu";
var Item = React.forwardRef(
  ({ asChild, textValue, onPress: onPressProp, disabled = false, closeOnPress = true, ...props }, ref) => {
    const { onOpenChange, setTriggerPosition, setContentLayout } = useRootContext();
    function onPress(ev) {
      if (closeOnPress) {
        setTriggerPosition(null);
        setContentLayout(null);
        onOpenChange(false);
      }
      onPressProp?.(ev);
    }
    const Component = asChild ? Slot.Pressable : Pressable2;
    return <Component
      ref={ref}
      role='menuitem'
      onPress={onPress}
      disabled={disabled}
      aria-valuetext={textValue}
      aria-disabled={!!disabled}
      accessibilityState={{ disabled: !!disabled }}
      {...props}
    />;
  }
);
Item.displayName = "ItemNativeDropdownMenu";
var Group = React.forwardRef(({ asChild, ...props }, ref) => {
  const Component = asChild ? Slot.View : View2;
  return <Component ref={ref} role='group' {...props} />;
});
Group.displayName = "GroupNativeDropdownMenu";
var Label = React.forwardRef(({ asChild, ...props }, ref) => {
  const Component = asChild ? Slot.Text : Text2;
  return <Component ref={ref} {...props} />;
});
Label.displayName = "LabelNativeDropdownMenu";
var FormItemContext = React.createContext(null);
var CheckboxItem = React.forwardRef(
  ({
    asChild,
    checked,
    onCheckedChange,
    textValue,
    onPress: onPressProp,
    closeOnPress = true,
    disabled = false,
    ...props
  }, ref) => {
    const { onOpenChange, setContentLayout, setTriggerPosition, nativeID } = useRootContext();
    function onPress(ev) {
      onCheckedChange(!checked);
      if (closeOnPress) {
        setTriggerPosition(null);
        setContentLayout(null);
        onOpenChange(false);
      }
      onPressProp?.(ev);
    }
    const Component = asChild ? Slot.Pressable : Pressable2;
    return <FormItemContext.Provider value={{ checked }}><Component
      ref={ref}
      role='checkbox'
      aria-checked={checked}
      onPress={onPress}
      disabled={disabled}
      aria-disabled={!!disabled}
      aria-valuetext={textValue}
      accessibilityState={{ disabled: !!disabled }}
      {...props}
    /></FormItemContext.Provider>;
  }
);
CheckboxItem.displayName = "CheckboxItemNativeDropdownMenu";
function useFormItemContext() {
  const context = React.useContext(FormItemContext);
  if (!context) {
    throw new Error(
      "CheckboxItem or RadioItem compound components cannot be rendered outside of a CheckboxItem or RadioItem component"
    );
  }
  return context;
}
var RadioGroup = React.forwardRef(
  ({ asChild, value, onValueChange, ...props }, ref) => {
    const Component = asChild ? Slot.View : View2;
    return <FormItemContext.Provider value={{ value, onValueChange }}><Component ref={ref} role='radiogroup' {...props} /></FormItemContext.Provider>;
  }
);
RadioGroup.displayName = "RadioGroupNativeDropdownMenu";
var RadioItemContext = React.createContext({});
var RadioItem = React.forwardRef(
  ({
    asChild,
    value: itemValue,
    textValue,
    onPress: onPressProp,
    disabled = false,
    closeOnPress = true,
    ...props
  }, ref) => {
    const { onOpenChange, setContentLayout, setTriggerPosition } = useRootContext();
    const { value, onValueChange } = useFormItemContext();
    function onPress(ev) {
      onValueChange(itemValue);
      if (closeOnPress) {
        setTriggerPosition(null);
        setContentLayout(null);
        onOpenChange(false);
      }
      onPressProp?.(ev);
    }
    const Component = asChild ? Slot.Pressable : Pressable2;
    return <RadioItemContext.Provider value={{ itemValue }}><Component
      ref={ref}
      onPress={onPress}
      role='radio'
      aria-checked={value === itemValue}
      disabled={disabled ?? false}
      accessibilityState={{
        disabled: disabled ?? false,
        checked: value === itemValue
      }}
      aria-valuetext={textValue}
      {...props}
    /></RadioItemContext.Provider>;
  }
);
RadioItem.displayName = "RadioItemNativeDropdownMenu";
function useItemIndicatorContext() {
  return React.useContext(RadioItemContext);
}
var ItemIndicator = React.forwardRef(
  ({ asChild, forceMount, ...props }, ref) => {
    const { itemValue } = useItemIndicatorContext();
    const { checked, value } = useFormItemContext();
    if (!forceMount) {
      if (itemValue == null && !checked) {
        return null;
      }
      if (value !== itemValue) {
        return null;
      }
    }
    const Component = asChild ? Slot.View : View2;
    return <Component ref={ref} role='presentation' {...props} />;
  }
);
ItemIndicator.displayName = "ItemIndicatorNativeDropdownMenu";
var Separator = React.forwardRef(
  ({ asChild, decorative, ...props }, ref) => {
    const Component = asChild ? Slot.View : View2;
    return <Component role={decorative ? "presentation" : "separator"} ref={ref} {...props} />;
  }
);
Separator.displayName = "SeparatorNativeDropdownMenu";
var SubContext = React.createContext(null);
var Sub = React.forwardRef(
  ({ asChild, defaultOpen, open: openProp, onOpenChange: onOpenChangeProp, ...props }, ref) => {
    const nativeID = React.useId();
    const [open = false, onOpenChange] = useControllableState({
      prop: openProp,
      defaultProp: defaultOpen,
      onChange: onOpenChangeProp
    });
    const Component = asChild ? Slot.View : View2;
    return <SubContext.Provider
      value={{
        nativeID,
        open,
        onOpenChange
      }}
    ><Component ref={ref} {...props} /></SubContext.Provider>;
  }
);
Sub.displayName = "SubNativeDropdownMenu";
function useSubContext() {
  const context = React.useContext(SubContext);
  if (!context) {
    throw new Error("Sub compound components cannot be rendered outside of a Sub component");
  }
  return context;
}
var SubTrigger = React.forwardRef(
  ({ asChild, textValue, onPress: onPressProp, disabled = false, ...props }, ref) => {
    const { nativeID, open, onOpenChange } = useSubContext();
    function onPress(ev) {
      onOpenChange(!open);
      onPressProp?.(ev);
    }
    const Component = asChild ? Slot.Pressable : Pressable2;
    return <Component
      ref={ref}
      aria-valuetext={textValue}
      role='menuitem'
      aria-expanded={open}
      accessibilityState={{ expanded: open, disabled: !!disabled }}
      nativeID={nativeID}
      onPress={onPress}
      disabled={disabled}
      aria-disabled={!!disabled}
      {...props}
    />;
  }
);
SubTrigger.displayName = "SubTriggerNativeDropdownMenu";
var SubContent = React.forwardRef(
  ({ asChild = false, forceMount, ...props }, ref) => {
    const { open, nativeID } = useSubContext();
    if (!forceMount) {
      if (!open) {
        return null;
      }
    }
    const Component = asChild ? Slot.Pressable : Pressable2;
    return <Component ref={ref} role='group' aria-labelledby={nativeID} {...props} />;
  }
);
Content.displayName = "ContentNativeDropdownMenu";
export {
  CheckboxItem,
  Content,
  Group,
  Item,
  ItemIndicator,
  Label,
  Overlay,
  Portal,
  RadioGroup,
  RadioItem,
  Root,
  Separator,
  Sub,
  SubContent,
  SubTrigger,
  Trigger,
  useRootContext,
  useSubContext
};
