import * as _rn_primitives_types from '@rn-primitives/types';
import * as react_native from 'react-native';
import { View, Text, LayoutRectangle } from 'react-native';
import { LayoutPosition } from '@rn-primitives/hooks';
import * as React from 'react';
import { TriggerRef, PortalProps } from './index.js';
import './dropdown-menu';

interface IRootContext {
    open: boolean;
    onOpenChange: (open: boolean) => void;
    triggerPosition: LayoutPosition | null;
    setTriggerPosition: (triggerPosition: LayoutPosition | null) => void;
    contentLayout: LayoutRectangle | null;
    setContentLayout: (contentLayout: LayoutRectangle | null) => void;
    nativeID: string;
}
declare const Root: React.ForwardRefExoticComponent<react_native.ViewProps & {
    asChild?: boolean;
} & {
    onOpenChange?: (open: boolean) => void;
} & React.RefAttributes<View>>;
declare function useRootContext(): IRootContext;
declare const Trigger: React.ForwardRefExoticComponent<Omit<react_native.PressableProps & React.RefAttributes<View>, "ref"> & {
    asChild?: boolean;
} & {
    onKeyDown?: (ev: React.KeyboardEvent) => void;
    onKeyUp?: (ev: React.KeyboardEvent) => void;
} & React.RefAttributes<TriggerRef>>;
/**
 * @warning when using a custom `<PortalHost />`, you might have to adjust the Content's sideOffset to account for nav elements like headers.
 */
declare function Portal({ forceMount, hostName, children }: PortalProps): React.JSX.Element | null;
declare const Overlay: React.ForwardRefExoticComponent<_rn_primitives_types.ForceMountable & Omit<react_native.PressableProps & React.RefAttributes<View>, "ref"> & {
    asChild?: boolean;
} & {
    onKeyDown?: (ev: React.KeyboardEvent) => void;
    onKeyUp?: (ev: React.KeyboardEvent) => void;
} & {
    closeOnPress?: boolean;
} & React.RefAttributes<View>>;
/**
 * @info `position`, `top`, `left`, and `maxWidth` style properties are controlled internally. Opt out of this behavior by setting `disablePositioningStyle` to `true`.
 */
declare const Content: React.ForwardRefExoticComponent<Omit<react_native.PressableProps & React.RefAttributes<View>, "ref"> & {
    asChild?: boolean;
} & {
    onKeyDown?: (ev: React.KeyboardEvent) => void;
    onKeyUp?: (ev: React.KeyboardEvent) => void;
} & _rn_primitives_types.PositionedContentProps & React.RefAttributes<View>>;
declare const Item: React.ForwardRefExoticComponent<Omit<react_native.PressableProps & React.RefAttributes<View>, "ref"> & {
    asChild?: boolean;
} & {
    onKeyDown?: (ev: React.KeyboardEvent) => void;
    onKeyUp?: (ev: React.KeyboardEvent) => void;
} & {
    textValue?: string;
    closeOnPress?: boolean;
} & React.RefAttributes<View>>;
declare const Group: React.ForwardRefExoticComponent<react_native.ViewProps & {
    asChild?: boolean;
} & React.RefAttributes<View>>;
declare const Label: React.ForwardRefExoticComponent<react_native.TextProps & {
    asChild?: boolean;
} & React.RefAttributes<Text>>;
declare const CheckboxItem: React.ForwardRefExoticComponent<Omit<react_native.PressableProps & React.RefAttributes<View>, "ref"> & {
    asChild?: boolean;
} & {
    onKeyDown?: (ev: React.KeyboardEvent) => void;
    onKeyUp?: (ev: React.KeyboardEvent) => void;
} & {
    checked: boolean;
    onCheckedChange: (checked: boolean) => void;
    closeOnPress?: boolean;
    textValue?: string;
} & React.RefAttributes<View>>;
declare const RadioGroup: React.ForwardRefExoticComponent<react_native.ViewProps & {
    asChild?: boolean;
} & {
    value: string | undefined;
    onValueChange: (value: string) => void;
} & React.RefAttributes<View>>;
declare const RadioItem: React.ForwardRefExoticComponent<Omit<react_native.PressableProps & React.RefAttributes<View>, "ref"> & {
    asChild?: boolean;
} & {
    onKeyDown?: (ev: React.KeyboardEvent) => void;
    onKeyUp?: (ev: React.KeyboardEvent) => void;
} & {
    value: string;
    textValue?: string;
    closeOnPress?: boolean;
} & React.RefAttributes<View>>;
declare const ItemIndicator: React.ForwardRefExoticComponent<react_native.ViewProps & {
    asChild?: boolean;
} & _rn_primitives_types.ForceMountable & React.RefAttributes<View>>;
declare const Separator: React.ForwardRefExoticComponent<react_native.ViewProps & {
    asChild?: boolean;
} & {
    decorative?: boolean;
} & React.RefAttributes<View>>;
declare const Sub: React.ForwardRefExoticComponent<react_native.ViewProps & {
    asChild?: boolean;
} & {
    defaultOpen?: boolean;
    open?: boolean;
    onOpenChange?: (value: boolean) => void;
} & React.RefAttributes<View>>;
declare function useSubContext(): {
    nativeID: string;
    open: boolean;
    onOpenChange: (value: boolean) => void;
};
declare const SubTrigger: React.ForwardRefExoticComponent<Omit<react_native.PressableProps & React.RefAttributes<View>, "ref"> & {
    asChild?: boolean;
} & {
    onKeyDown?: (ev: React.KeyboardEvent) => void;
    onKeyUp?: (ev: React.KeyboardEvent) => void;
} & {
    textValue?: string;
} & React.RefAttributes<View>>;
declare const SubContent: React.ForwardRefExoticComponent<Omit<react_native.PressableProps & React.RefAttributes<View>, "ref"> & {
    asChild?: boolean;
} & {
    onKeyDown?: (ev: React.KeyboardEvent) => void;
    onKeyUp?: (ev: React.KeyboardEvent) => void;
} & _rn_primitives_types.ForceMountable & React.RefAttributes<View>>;

export { CheckboxItem, Content, Group, Item, ItemIndicator, Label, Overlay, Portal, RadioGroup, RadioItem, Root, Separator, Sub, SubContent, SubTrigger, Trigger, useRootContext, useSubContext };
