"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WINDOW_WIDTH = exports.WINDOW_HEIGHT = exports.SNAP_POINT_TYPE = exports.SHEET_STATE = exports.SCROLLABLE_TYPE = exports.SCROLLABLE_STATUS = exports.SCROLLABLE_DECELERATION_RATE_MAPPER = exports.SCREEN_WIDTH = exports.SCREEN_HEIGHT = exports.MODAL_STACK_BEHAVIOR = exports.KEYBOARD_STATUS = exports.KEYBOARD_INPUT_MODE = exports.KEYBOARD_DISMISS_THRESHOLD = exports.KEYBOARD_BLUR_BEHAVIOR = exports.KEYBOARD_BEHAVIOR = exports.INITIAL_LAYOUT_VALUE = exports.INITIAL_CONTAINER_LAYOUT = exports.GESTURE_SOURCE = exports.ANIMATION_STATUS = exports.ANIMATION_SOURCE = exports.ANIMATION_METHOD = exports.ANIMATION_EASING = exports.ANIMATION_DURATION = exports.ANIMATION_CONFIGS = void 0;
var _reactNative = require("react-native");
var _reactNativeReanimated = require("react-native-reanimated");
const {
  height: WINDOW_HEIGHT,
  width: WINDOW_WIDTH
} = _reactNative.Dimensions.get('window');
exports.WINDOW_WIDTH = WINDOW_WIDTH;
exports.WINDOW_HEIGHT = WINDOW_HEIGHT;
const {
  height: SCREEN_HEIGHT,
  width: SCREEN_WIDTH
} = _reactNative.Dimensions.get('screen');
exports.SCREEN_WIDTH = SCREEN_WIDTH;
exports.SCREEN_HEIGHT = SCREEN_HEIGHT;
var GESTURE_SOURCE = exports.GESTURE_SOURCE = /*#__PURE__*/function (GESTURE_SOURCE) {
  GESTURE_SOURCE[GESTURE_SOURCE["UNDETERMINED"] = 0] = "UNDETERMINED";
  GESTURE_SOURCE[GESTURE_SOURCE["SCROLLABLE"] = 1] = "SCROLLABLE";
  GESTURE_SOURCE[GESTURE_SOURCE["HANDLE"] = 2] = "HANDLE";
  GESTURE_SOURCE[GESTURE_SOURCE["CONTENT"] = 3] = "CONTENT";
  return GESTURE_SOURCE;
}(GESTURE_SOURCE || {});
var SHEET_STATE = exports.SHEET_STATE = /*#__PURE__*/function (SHEET_STATE) {
  SHEET_STATE[SHEET_STATE["CLOSED"] = 0] = "CLOSED";
  SHEET_STATE[SHEET_STATE["OPENED"] = 1] = "OPENED";
  SHEET_STATE[SHEET_STATE["EXTENDED"] = 2] = "EXTENDED";
  SHEET_STATE[SHEET_STATE["OVER_EXTENDED"] = 3] = "OVER_EXTENDED";
  SHEET_STATE[SHEET_STATE["FILL_PARENT"] = 4] = "FILL_PARENT";
  return SHEET_STATE;
}(SHEET_STATE || {});
var SCROLLABLE_STATUS = exports.SCROLLABLE_STATUS = /*#__PURE__*/function (SCROLLABLE_STATUS) {
  SCROLLABLE_STATUS[SCROLLABLE_STATUS["LOCKED"] = 0] = "LOCKED";
  SCROLLABLE_STATUS[SCROLLABLE_STATUS["UNLOCKED"] = 1] = "UNLOCKED";
  SCROLLABLE_STATUS[SCROLLABLE_STATUS["UNDETERMINED"] = 2] = "UNDETERMINED";
  return SCROLLABLE_STATUS;
}(SCROLLABLE_STATUS || {});
var SCROLLABLE_TYPE = exports.SCROLLABLE_TYPE = /*#__PURE__*/function (SCROLLABLE_TYPE) {
  SCROLLABLE_TYPE[SCROLLABLE_TYPE["UNDETERMINED"] = 0] = "UNDETERMINED";
  SCROLLABLE_TYPE[SCROLLABLE_TYPE["VIEW"] = 1] = "VIEW";
  SCROLLABLE_TYPE[SCROLLABLE_TYPE["FLATLIST"] = 2] = "FLATLIST";
  SCROLLABLE_TYPE[SCROLLABLE_TYPE["SCROLLVIEW"] = 3] = "SCROLLVIEW";
  SCROLLABLE_TYPE[SCROLLABLE_TYPE["SECTIONLIST"] = 4] = "SECTIONLIST";
  SCROLLABLE_TYPE[SCROLLABLE_TYPE["VIRTUALIZEDLIST"] = 5] = "VIRTUALIZEDLIST";
  return SCROLLABLE_TYPE;
}(SCROLLABLE_TYPE || {});
var ANIMATION_STATUS = exports.ANIMATION_STATUS = /*#__PURE__*/function (ANIMATION_STATUS) {
  ANIMATION_STATUS[ANIMATION_STATUS["UNDETERMINED"] = 0] = "UNDETERMINED";
  ANIMATION_STATUS[ANIMATION_STATUS["RUNNING"] = 1] = "RUNNING";
  ANIMATION_STATUS[ANIMATION_STATUS["STOPPED"] = 2] = "STOPPED";
  ANIMATION_STATUS[ANIMATION_STATUS["INTERRUPTED"] = 3] = "INTERRUPTED";
  return ANIMATION_STATUS;
}(ANIMATION_STATUS || {});
var ANIMATION_SOURCE = exports.ANIMATION_SOURCE = /*#__PURE__*/function (ANIMATION_SOURCE) {
  ANIMATION_SOURCE[ANIMATION_SOURCE["NONE"] = 0] = "NONE";
  ANIMATION_SOURCE[ANIMATION_SOURCE["MOUNT"] = 1] = "MOUNT";
  ANIMATION_SOURCE[ANIMATION_SOURCE["GESTURE"] = 2] = "GESTURE";
  ANIMATION_SOURCE[ANIMATION_SOURCE["USER"] = 3] = "USER";
  ANIMATION_SOURCE[ANIMATION_SOURCE["CONTAINER_RESIZE"] = 4] = "CONTAINER_RESIZE";
  ANIMATION_SOURCE[ANIMATION_SOURCE["SNAP_POINT_CHANGE"] = 5] = "SNAP_POINT_CHANGE";
  ANIMATION_SOURCE[ANIMATION_SOURCE["KEYBOARD"] = 6] = "KEYBOARD";
  return ANIMATION_SOURCE;
}(ANIMATION_SOURCE || {});
var ANIMATION_METHOD = exports.ANIMATION_METHOD = /*#__PURE__*/function (ANIMATION_METHOD) {
  ANIMATION_METHOD[ANIMATION_METHOD["TIMING"] = 0] = "TIMING";
  ANIMATION_METHOD[ANIMATION_METHOD["SPRING"] = 1] = "SPRING";
  return ANIMATION_METHOD;
}(ANIMATION_METHOD || {});
var KEYBOARD_STATUS = exports.KEYBOARD_STATUS = /*#__PURE__*/function (KEYBOARD_STATUS) {
  KEYBOARD_STATUS[KEYBOARD_STATUS["UNDETERMINED"] = 0] = "UNDETERMINED";
  KEYBOARD_STATUS[KEYBOARD_STATUS["SHOWN"] = 1] = "SHOWN";
  KEYBOARD_STATUS[KEYBOARD_STATUS["HIDDEN"] = 2] = "HIDDEN";
  return KEYBOARD_STATUS;
}(KEYBOARD_STATUS || {});
var SNAP_POINT_TYPE = exports.SNAP_POINT_TYPE = /*#__PURE__*/function (SNAP_POINT_TYPE) {
  SNAP_POINT_TYPE[SNAP_POINT_TYPE["PROVIDED"] = 0] = "PROVIDED";
  SNAP_POINT_TYPE[SNAP_POINT_TYPE["DYNAMIC"] = 1] = "DYNAMIC";
  return SNAP_POINT_TYPE;
}(SNAP_POINT_TYPE || {});
const ANIMATION_EASING = exports.ANIMATION_EASING = _reactNativeReanimated.Easing.out(_reactNativeReanimated.Easing.exp);
const ANIMATION_DURATION = exports.ANIMATION_DURATION = 250;
const ANIMATION_CONFIGS = exports.ANIMATION_CONFIGS = _reactNative.Platform.select({
  android: {
    duration: ANIMATION_DURATION,
    easing: ANIMATION_EASING
  },
  default: {
    damping: 500,
    stiffness: 1000,
    mass: 3,
    overshootClamping: true,
    restDisplacementThreshold: 10,
    restSpeedThreshold: 10
  }
});
const SCROLLABLE_DECELERATION_RATE_MAPPER = exports.SCROLLABLE_DECELERATION_RATE_MAPPER = {
  [SCROLLABLE_STATUS.UNDETERMINED]: 0,
  [SCROLLABLE_STATUS.LOCKED]: 0,
  [SCROLLABLE_STATUS.UNLOCKED]: _reactNative.Platform.select({
    ios: 0.998,
    android: 0.985,
    default: 1
  })
};
const MODAL_STACK_BEHAVIOR = exports.MODAL_STACK_BEHAVIOR = {
  replace: 'replace',
  push: 'push',
  switch: 'switch'
};
const KEYBOARD_BEHAVIOR = exports.KEYBOARD_BEHAVIOR = {
  interactive: 'interactive',
  extend: 'extend',
  fillParent: 'fillParent'
};
const KEYBOARD_BLUR_BEHAVIOR = exports.KEYBOARD_BLUR_BEHAVIOR = {
  none: 'none',
  restore: 'restore'
};
const KEYBOARD_INPUT_MODE = exports.KEYBOARD_INPUT_MODE = {
  adjustPan: 'adjustPan',
  adjustResize: 'adjustResize'
};
const KEYBOARD_DISMISS_THRESHOLD = exports.KEYBOARD_DISMISS_THRESHOLD = 12.5;
const INITIAL_LAYOUT_VALUE = exports.INITIAL_LAYOUT_VALUE = -999;
const INITIAL_CONTAINER_LAYOUT = exports.INITIAL_CONTAINER_LAYOUT = {
  height: INITIAL_LAYOUT_VALUE,
  offset: {
    top: 0,
    bottom: 0,
    right: 0,
    left: 0
  }
};
//# sourceMappingURL=constants.js.map