/**
 * Unistring: breaks a native string into an array of grapheme cluster,
 *            and provides native string like manipulation methods.
 * =============================================================================
 *
 *
 * @author akahuku@gmail.com
 * @license MIT
 */

/*
 * data table, taken from:
 * http://www.unicode.org/Public/14.0.0/ucd/auxiliary/GraphemeBreakProperty.txt
 */

// GENERATED CODE START <<<1
// This data was generated by the command 'node mkdata.js -g'.
const GRAPHEME_BREAK_PROPS = '\
0600004001050A002000060B004000040D002000060E004002067F00200406AD002000070003000E\
078304E000079105A00507BF05200007C105400007C405400007C7052000030006C0000710066001\
061C062000074B06A002077006200007D606E00003DD06200007DF06C00007E706400007EA068000\
030F0720000711072000073007600307A607600107EB07200107FD0720000716088000071B082001\
0725086000072908A00007590860000390084000079808000107CA08000303E208200007E3080004\
0903092000073A092000093B092000073C092000093E09600007410900010949098000074D092000\
094E094000075109E00007620940000781092000098209400007BC09200007BE09200009BF094000\
07C109800009C709400009CB09400007CD09200007D709200007E209400007FE09200007010A4000\
09030A2000073C0A2000093E0A600007410A400007470A4000074B0A600007510A200007700A4000\
07750A200007810A400009830A200007BC0A200009BE0A600007C10AA00007C70A400009C90A2000\
09CB0A400007CD0A200007E20A400007FA0AC00007010B200009020B4000073C0B2000073E0B4000\
09400B200007410B800009470B4000094B0B4000074D0B200007550B600007620B400007820B2000\
07BE0B200009BF0B200007C00B200009C10B400009C60B600009CA0B600007CD0B200007D70B2000\
07000C200009010C600007040C2000073C0C2000073E0C600009410C800007460C6000074A0C8000\
07550C400007620C400007810C200009820C400007BC0C200009BE0C200007BF0C200009C00C4000\
07C20C200009C30C400007C60C200009C70C400009CA0C400007CC0C400007D50C400007E20C4000\
07000D400009020D4000073B0D4000073E0D2000093F0D400007410D800009460D6000094A0D6000\
074D0D2000034E0D200007570D200007620D400007810D200009820D400007CA0D200007CF0D2000\
09D00D400007D20D600007D60D200009D80DE00007DF0D200009F20D400007310E200009330E2000\
07340EE00007470E000107B10E200009B30E200007B40E200107C80EC00007180F400007350F2000\
07370F200007390F2000093E0F400007710FC001097F0F200007800FA00007860F4000078D0F6001\
07990F800407C60F2000072D1080000931102000073210C0000739104000093B104000073D104000\
09561040000758104000075E1060000771108000078210200009841020000785104000078D102000\
079D1020000A0011000C0B601100090CA811000B075D136000071217600009151720000732174000\
09341720000752174000077217400007B417400009B617200007B717E00009BE17000107C6172000\
09C717400007C917600107DD172000070B186000060E182000070F182000078518400007A9182000\
072019600009231980000727194000092919600009301940000732192000093319C0000739196000\
07171A400009191A4000071B1A200009551A200007561A200009571A200007581AE00007601A2000\
07621A200007651A0001096D1AC00007731A4001077F1A200007B01AE00307001B800009041B2000\
07341BE000093B1B2000073C1B2000093D1BA00007421B200009431B4000076B1B200107801B4000\
09821B200009A11B200007A21B800009A61B400007A81B400009AA1B200007AB1B600007E61B2000\
09E71B200007E81B400009EA1B600007ED1B200009EE1B200007EF1B600009F21B400009241C0001\
072C1C000109341C400007361C400007D01C600007D41CA00109E11C200007E21CE00007ED1C2000\
07F41C200009F71C200007F81C400007C01D0008060B202000070C2020000F0D202000060E204000\
062820E000066020000207D020200407EF2C6000077F2D200007E02D0004072A30C0000799304000\
076FA680000774A64001079EA6400007F0A640000702A820000706A82000070BA820000923A84000\
0725A840000927A82000072CA820000980A8400009B4A8000207C4A8400007E0A8400207FFA82000\
0726A900010747A960010952A940000A60A9A0030780A960000983A9200007B3A9200009B4A94000\
07B6A9800009BAA9400007BCA9400009BEA9600007E5A920000729AAC000092FAA40000731AA4000\
0933AA40000735AA40000743AA2000074CAA2000094DAA2000077CAA200007B0AA200007B2AA6000\
07B7AA400007BEAA400007C1AA200009EBAA200007ECAA400009EEAA400009F5AA200007F6AA2000\
09E3AB400007E5AB200009E6AB400007E8AB200009E9AB400009ECAB200007EDAB20000D00AC2000\
0E01AC60030D1CAC20000E1DAC60030D38AC20000E39AC60030D54AC20000E55AC60030D70AC2000\
0E71AC60030D8CAC20000E8DAC60030DA8AC20000EA9AC60030DC4AC20000EC5AC60030DE0AC2000\
0EE1AC60030DFCAC20000EFDAC60030D18AD20000E19AD60030D34AD20000E35AD60030D50AD2000\
0E51AD60030D6CAD20000E6DAD60030D88AD20000E89AD60030DA4AD20000EA5AD60030DC0AD2000\
0EC1AD60030DDCAD20000EDDAD60030DF8AD20000EF9AD60030D14AE20000E15AE60030D30AE2000\
0E31AE60030D4CAE20000E4DAE60030D68AE20000E69AE60030D84AE20000E85AE60030DA0AE2000\
0EA1AE60030DBCAE20000EBDAE60030DD8AE20000ED9AE60030DF4AE20000EF5AE60030D10AF2000\
0E11AF60030D2CAF20000E2DAF60030D48AF20000E49AF60030D64AF20000E65AF60030D80AF2000\
0E81AF60030D9CAF20000E9DAF60030DB8AF20000EB9AF60030DD4AF20000ED5AF60030DF0AF2000\
0EF1AF60030D0CB020000E0DB060030D28B020000E29B060030D44B020000E45B060030D60B02000\
0E61B060030D7CB020000E7DB060030D98B020000E99B060030DB4B020000EB5B060030DD0B02000\
0ED1B060030DECB020000EEDB060030D08B120000E09B160030D24B120000E25B160030D40B12000\
0E41B160030D5CB120000E5DB160030D78B120000E79B160030D94B120000E95B160030DB0B12000\
0EB1B160030DCCB120000ECDB160030DE8B120000EE9B160030D04B220000E05B260030D20B22000\
0E21B260030D3CB220000E3DB260030D58B220000E59B260030D74B220000E75B260030D90B22000\
0E91B260030DACB220000EADB260030DC8B220000EC9B260030DE4B220000EE5B260030D00B32000\
0E01B360030D1CB320000E1DB360030D38B320000E39B360030D54B320000E55B360030D70B32000\
0E71B360030D8CB320000E8DB360030DA8B320000EA9B360030DC4B320000EC5B360030DE0B32000\
0EE1B360030DFCB320000EFDB360030D18B420000E19B460030D34B420000E35B460030D50B42000\
0E51B460030D6CB420000E6DB460030D88B420000E89B460030DA4B420000EA5B460030DC0B42000\
0EC1B460030DDCB420000EDDB460030DF8B420000EF9B460030D14B520000E15B560030D30B52000\
0E31B560030D4CB520000E4DB560030D68B520000E69B560030D84B520000E85B560030DA0B52000\
0EA1B560030DBCB520000EBDB560030DD8B520000ED9B560030DF4B520000EF5B560030D10B62000\
0E11B660030D2CB620000E2DB660030D48B620000E49B660030D64B620000E65B660030D80B62000\
0E81B660030D9CB620000E9DB660030DB8B620000EB9B660030DD4B620000ED5B660030DF0B62000\
0EF1B660030D0CB720000E0DB760030D28B720000E29B760030D44B720000E45B760030D60B72000\
0E61B760030D7CB720000E7DB760030D98B720000E99B760030DB4B720000EB5B760030DD0B72000\
0ED1B760030DECB720000EEDB760030D08B820000E09B860030D24B820000E25B860030D40B82000\
0E41B860030D5CB820000E5DB860030D78B820000E79B860030D94B820000E95B860030DB0B82000\
0EB1B860030DCCB820000ECDB860030DE8B820000EE9B860030D04B920000E05B960030D20B92000\
0E21B960030D3CB920000E3DB960030D58B920000E59B960030D74B920000E75B960030D90B92000\
0E91B960030DACB920000EADB960030DC8B920000EC9B960030DE4B920000EE5B960030D00BA2000\
0E01BA60030D1CBA20000E1DBA60030D38BA20000E39BA60030D54BA20000E55BA60030D70BA2000\
0E71BA60030D8CBA20000E8DBA60030DA8BA20000EA9BA60030DC4BA20000EC5BA60030DE0BA2000\
0EE1BA60030DFCBA20000EFDBA60030D18BB20000E19BB60030D34BB20000E35BB60030D50BB2000\
0E51BB60030D6CBB20000E6DBB60030D88BB20000E89BB60030DA4BB20000EA5BB60030DC0BB2000\
0EC1BB60030DDCBB20000EDDBB60030DF8BB20000EF9BB60030D14BC20000E15BC60030D30BC2000\
0E31BC60030D4CBC20000E4DBC60030D68BC20000E69BC60030D84BC20000E85BC60030DA0BC2000\
0EA1BC60030DBCBC20000EBDBC60030DD8BC20000ED9BC60030DF4BC20000EF5BC60030D10BD2000\
0E11BD60030D2CBD20000E2DBD60030D48BD20000E49BD60030D64BD20000E65BD60030D80BD2000\
0E81BD60030D9CBD20000E9DBD60030DB8BD20000EB9BD60030DD4BD20000ED5BD60030DF0BD2000\
0EF1BD60030D0CBE20000E0DBE60030D28BE20000E29BE60030D44BE20000E45BE60030D60BE2000\
0E61BE60030D7CBE20000E7DBE60030D98BE20000E99BE60030DB4BE20000EB5BE60030DD0BE2000\
0ED1BE60030DECBE20000EEDBE60030D08BF20000E09BF60030D24BF20000E25BF60030D40BF2000\
0E41BF60030D5CBF20000E5DBF60030D78BF20000E79BF60030D94BF20000E95BF60030DB0BF2000\
0EB1BF60030DCCBF20000ECDBF60030DE8BF20000EE9BF60030D04C020000E05C060030D20C02000\
0E21C060030D3CC020000E3DC060030D58C020000E59C060030D74C020000E75C060030D90C02000\
0E91C060030DACC020000EADC060030DC8C020000EC9C060030DE4C020000EE5C060030D00C12000\
0E01C160030D1CC120000E1DC160030D38C120000E39C160030D54C120000E55C160030D70C12000\
0E71C160030D8CC120000E8DC160030DA8C120000EA9C160030DC4C120000EC5C160030DE0C12000\
0EE1C160030DFCC120000EFDC160030D18C220000E19C260030D34C220000E35C260030D50C22000\
0E51C260030D6CC220000E6DC260030D88C220000E89C260030DA4C220000EA5C260030DC0C22000\
0EC1C260030DDCC220000EDDC260030DF8C220000EF9C260030D14C320000E15C360030D30C32000\
0E31C360030D4CC320000E4DC360030D68C320000E69C360030D84C320000E85C360030DA0C32000\
0EA1C360030DBCC320000EBDC360030DD8C320000ED9C360030DF4C320000EF5C360030D10C42000\
0E11C460030D2CC420000E2DC460030D48C420000E49C460030D64C420000E65C460030D80C42000\
0E81C460030D9CC420000E9DC460030DB8C420000EB9C460030DD4C420000ED5C460030DF0C42000\
0EF1C460030D0CC520000E0DC560030D28C520000E29C560030D44C520000E45C560030D60C52000\
0E61C560030D7CC520000E7DC560030D98C520000E99C560030DB4C520000EB5C560030DD0C52000\
0ED1C560030DECC520000EEDC560030D08C620000E09C660030D24C620000E25C660030D40C62000\
0E41C660030D5CC620000E5DC660030D78C620000E79C660030D94C620000E95C660030DB0C62000\
0EB1C660030DCCC620000ECDC660030DE8C620000EE9C660030D04C720000E05C760030D20C72000\
0E21C760030D3CC720000E3DC760030D58C720000E59C760030D74C720000E75C760030D90C72000\
0E91C760030DACC720000EADC760030DC8C720000EC9C760030DE4C720000EE5C760030D00C82000\
0E01C860030D1CC820000E1DC860030D38C820000E39C860030D54C820000E55C860030D70C82000\
0E71C860030D8CC820000E8DC860030DA8C820000EA9C860030DC4C820000EC5C860030DE0C82000\
0EE1C860030DFCC820000EFDC860030D18C920000E19C960030D34C920000E35C960030D50C92000\
0E51C960030D6CC920000E6DC960030D88C920000E89C960030DA4C920000EA5C960030DC0C92000\
0EC1C960030DDCC920000EDDC960030DF8C920000EF9C960030D14CA20000E15CA60030D30CA2000\
0E31CA60030D4CCA20000E4DCA60030D68CA20000E69CA60030D84CA20000E85CA60030DA0CA2000\
0EA1CA60030DBCCA20000EBDCA60030DD8CA20000ED9CA60030DF4CA20000EF5CA60030D10CB2000\
0E11CB60030D2CCB20000E2DCB60030D48CB20000E49CB60030D64CB20000E65CB60030D80CB2000\
0E81CB60030D9CCB20000E9DCB60030DB8CB20000EB9CB60030DD4CB20000ED5CB60030DF0CB2000\
0EF1CB60030D0CCC20000E0DCC60030D28CC20000E29CC60030D44CC20000E45CC60030D60CC2000\
0E61CC60030D7CCC20000E7DCC60030D98CC20000E99CC60030DB4CC20000EB5CC60030DD0CC2000\
0ED1CC60030DECCC20000EEDCC60030D08CD20000E09CD60030D24CD20000E25CD60030D40CD2000\
0E41CD60030D5CCD20000E5DCD60030D78CD20000E79CD60030D94CD20000E95CD60030DB0CD2000\
0EB1CD60030DCCCD20000ECDCD60030DE8CD20000EE9CD60030D04CE20000E05CE60030D20CE2000\
0E21CE60030D3CCE20000E3DCE60030D58CE20000E59CE60030D74CE20000E75CE60030D90CE2000\
0E91CE60030DACCE20000EADCE60030DC8CE20000EC9CE60030DE4CE20000EE5CE60030D00CF2000\
0E01CF60030D1CCF20000E1DCF60030D38CF20000E39CF60030D54CF20000E55CF60030D70CF2000\
0E71CF60030D8CCF20000E8DCF60030DA8CF20000EA9CF60030DC4CF20000EC5CF60030DE0CF2000\
0EE1CF60030DFCCF20000EFDCF60030D18D020000E19D060030D34D020000E35D060030D50D02000\
0E51D060030D6CD020000E6DD060030D88D020000E89D060030DA4D020000EA5D060030DC0D02000\
0EC1D060030DDCD020000EDDD060030DF8D020000EF9D060030D14D120000E15D160030D30D12000\
0E31D160030D4CD120000E4DD160030D68D120000E69D160030D84D120000E85D160030DA0D12000\
0EA1D160030DBCD120000EBDD160030DD8D120000ED9D160030DF4D120000EF5D160030D10D22000\
0E11D260030D2CD220000E2DD260030D48D220000E49D260030D64D220000E65D260030D80D22000\
0E81D260030D9CD220000E9DD260030DB8D220000EB9D260030DD4D220000ED5D260030DF0D22000\
0EF1D260030D0CD320000E0DD360030D28D320000E29D360030D44D320000E45D360030D60D32000\
0E61D360030D7CD320000E7DD360030D98D320000E99D360030DB4D320000EB5D360030DD0D32000\
0ED1D360030DECD320000EEDD360030D08D420000E09D460030D24D420000E25D460030D40D42000\
0E41D460030D5CD420000E5DD460030D78D420000E79D460030D94D420000E95D460030DB0D42000\
0EB1D460030DCCD420000ECDD460030DE8D420000EE9D460030D04D520000E05D560030D20D52000\
0E21D560030D3CD520000E3DD560030D58D520000E59D560030D74D520000E75D560030D90D52000\
0E91D560030DACD520000EADD560030DC8D520000EC9D560030DE4D520000EE5D560030D00D62000\
0E01D660030D1CD620000E1DD660030D38D620000E39D660030D54D620000E55D660030D70D62000\
0E71D660030D8CD620000E8DD660030DA8D620000EA9D660030DC4D620000EC5D660030DE0D62000\
0EE1D660030DFCD620000EFDD660030D18D720000E19D760030D34D720000E35D760030D50D72000\
0E51D760030D6CD720000E6DD760030D88D720000E89D760030BB0D7E0020CCBD72006071EFB2000\
0700FE00020720FE000206FFFE2000079EFF400006F0FF800107FD01210007E0022100077603A100\
07010A610007050A4100070C0A810007380A6100073F0A210007E50A410007240D810007AB0E4100\
07460F610107820F8100090010210007011021000902102100073810E10107701021000773104100\
077F106100098210210009B010610007B310810009B710410007B910410003BD10210007C2102100\
03CD1021000700116100072711A100092C112100072D110101094511410007731121000780114100\
098211210009B311610007B611210109BF11410003C211410007C911810009CE11210007CF112100\
092C126100072F1261000932124100073412210009351221000736124100073E12210007DF122100\
09E012610007E312010107001341000902134100073B134100073E132100093F1321000740132100\
09411381000947134100094B13610007571321000962134100076613E100077013A1000935146100\
07381401010940144100074214610009451421000746142100075E14210007B014210009B1144100\
07B314C10009B914210007BA14210009BB14410007BD14210009BE14210007BF14410009C1142100\
07C214410007AF15210009B015410007B215810009B815810007BC15410009BE15210007BF154100\
07DC15410009301661000733160101093B164100073D162100093E162100073F16410007AB162100\
09AC16210007AD16210009AE16410007B016C10009B616210007B7162100071D1761000722178100\
0926172100072717A100092C186100072F182101093818210007391841000730192100093119A100\
0937194100073B194100093D192100073E192100033F192100094019210003411921000942192100\
074319210009D119610007D419810007DA19410009DC19810007E019210009E419210007011A4101\
07331AC10009391A2100033A1A2100073B1A810007471A210007511AC10009571A410007591A6100\
03841AC100078A1AA10109971A210007981A4100092F1C210007301CE10007381CC100093E1C2100\
073F1C210007921CC10209A91C210007AA1CE10009B11C210007B21C410009B41C210007B51C4100\
07311DC100073A1D2100073C1D4100073F1DE10003461D210007471D2100098A1DA10007901D4100\
09931D410007951D210009961D210007971D210007F31E410009F51E4100063034210107F06AA100\
07306BE100074F6F210009516FE106078F6F810007E46F210009F06F4100079DBC410006A0BC8100\
0700CFC1050730CFE1020765D121000966D121000767D16100096DD12100076ED1A1000673D10101\
077BD101010785D1E10007AAD181000742D261000700DAE106073BDA41060775DA21000784DA2100\
079BDAA10007A1DAE1010700E0E1000708E02102071BE0E1000723E041000726E0A1000730E1E100\
07AEE2210007ECE2810007D0E8E1000744E9E10008E6F1410307FBF3A1000600000E040720000E0C\
0680000E100700010E1E06F001EEFF06EF092EC2';

const GRAPHEME_BREAK_PROP_UNIT_LENGTH = 5;
const GBP = {
	/* ` */'Other': 0,
	/* a */'SOT': 1,
	/* b */'EOT': 2,
	/* c */'Prepend': 3,
	/* d */'CR': 4,
	/* e */'LF': 5,
	/* f */'Control': 6,
	/* g */'Extend': 7,
	/* h */'Regional_Indicator': 8,
	/* i */'SpacingMark': 9,
	/* j */'L': 10,
	/* k */'V': 11,
	/* l */'T': 12,
	/* m */'LV': 13,
	/* n */'LVT': 14,
	/* o */'ZWJ': 15
};
const GBP_NAMES = Object.keys(GBP);

// GENERATED CODE END
// >>>

/*
 * While a property defined for splitting, specially assign a value for Extended_Pictographic
 */

GBP['Extended_Pictographic'] = 16;	/* p */

/*
 * data table, taken from:
 * http://www.unicode.org/Public/14.0.0/ucd/auxiliary/WordBreakProperty.txt
 */

// GENERATED CODE START <<<1
// This data was generated by the command 'node mkdata.js -w'.
const WORD_BREAK_PROPS = '\
1309002000070A002000080B004000060D0020001320002000032200200004270020000E2C002000\
0F2E00200010300040010D3A0020000E3B0020000C41004003115F0020000C610040030885002000\
0CAA0020000BAD0020000CB50020000DB70020000CBA0020000CC000E0020CD800E0030CF800003C\
0CDE024004090003000E0C7003A0000C760340000C7A0380000E7E0320000C7F0320000C86032000\
0D870320000C880360000C8C0320000C8E0380020CA303600A0CF7036011098304E0000C8A04C014\
0C3105C0040C590580000C5E0520000D5F0520000C600520050E890520000C8A052000099105A005\
09BF05200009C105400009C405400009C705200005D005600305EF0580000CF30520000DF4052000\
0B0006C0000E0C06400009100660010B1C0620000C20066005094B06A0021060064001106B062000\
0E6C0620000C6E06400009700620000C7106600C0CD506200009D606E0000BDD06200009DF06C000\
0CE506400009E706400009EA0680000CEE06400010F00640010CFA0660000CFF0620000B0F072000\
0C1007200009110720000C1207C00309300760030C4D07200B09A60760010CB107200010C0074001\
0CCA07200409EB0720010CF40740000EF80720000CFA07200009FD0720000C0008C0020916088000\
0C1A082000091B0820010C2408200009250860000C28082000092908A0000C400820030959086000\
0C600860010C700800030C8908C0000B9008400009980800010CA008400509CA0800030BE2082000\
09E30820040C0409C006093A0960000C3D092000093E0940020C50092000095109E0000C58094001\
096209400010660940010C7109000209810960000C850900010C8F0940000C9309C0020CAA09E000\
0CB20920000CB609800009BC0920000CBD09200009BE09E00009C709400009CB0960000CCE092000\
09D70920000CDC0940000CDF09600009E209400010E60940010CF00940000CFC09200009FE092000\
09010A60000C050AC0000C0F0A40000C130AC0020C2A0AE0000C320A40000C350A40000C380A4000\
093C0A2000093E0AA00009470A4000094B0A600009510A20000C590A80000C5E0A200010660A4001\
09700A40000C720A600009750A200009810A60000C850A20010C8F0A60000C930AC0020CAA0AE000\
0CB20A40000CB50AA00009BC0A20000CBD0A200009BE0A000109C70A600009CB0A60000CD00A2000\
0CE00A400009E20A400010E60A40010CF90A200009FA0AC00009010B60000C050B00010C0F0B4000\
0C130BC0020C2A0BE0000C320B40000C350BA000093C0B20000C3D0B2000093E0BE00009470B4000\
094B0B600009550B60000C5C0B40000C5F0B600009620B400010660B40010C710B200009820B2000\
0C830B20000C850BC0000C8E0B60000C920B80000C990B40000C9C0B20000C9E0B40000CA30B4000\
0CA80B60000CAE0B800109BE0BA00009C60B600009CA0B80000CD00B200009D70B200010E60B4001\
09000CA0000C050C00010C0E0C60000C120CE0020C2A0C0002093C0C20000C3D0C2000093E0CE000\
09460C6000094A0C800009550C40000C580C60000C5D0C20000C600C400009620C400010660C4001\
0C800C200009810C60000C850C00010C8E0C60000C920CE0020CAA0C40010CB50CA00009BC0C2000\
0CBD0C200009BE0CE00009C60C600009CA0C800009D50C40000CDD0C40000CE00C400009E20C4000\
10E60C40010CF10C400009000D80000C040D20010C0E0D60000C120D2005093B0D40000C3D0D2000\
093E0DE00009460D6000094A0D80000C4E0D20000C540D600009570D20000C5F0D600009620D4000\
10660D40010C7A0DC00009810D60000C850D40020C9A0D00030CB30D20010CBD0D20000CC00DE000\
09CA0D200009CF0DC00009D60D200009D80D000110E60D400109F20D400009310E200009340EE000\
09470E000110500E400109B10E200009B40E200109C80EC00010D00E40010C000F200009180F4000\
10200F400109350F200009370F200009390F2000093E0F40000C400F00010C490F800409710F8002\
09860F40000C880FA000098D0F600109990F800409C60F2000092B10800210401040010956108000\
095E1060000962106000096710E00009711080000982108001098F1020001090104001099A108000\
0CA010C0040CC71020000CCD1020000CD01060050CFC10A0290C4A1280000C5012E0000C58122000\
0C5A1280000C601220050C8A1280000C901220040CB21280000CB812E0000CC01220000CC2128000\
0CC812E0010CD81220070C121380000C18136008095D1360000C801300020CA013C00A0CF813C000\
0C0114804D0C6F16200213801620000C811640030CA01660090CEE1660010C001740020912178000\
0C1F17600209321760000C4017400209521740000C6017A0010C6E176000097217400009B4170004\
09DD17200010E0174001090B1860000B0E182000090F18200010101840010C2018200B0C8018A000\
09851840000C8718400409A91820000CAA1820000CB018C0080C0019E00309201980010930198001\
104619400110D01940010C001AE00209171AA00009551A400109601AA003097F1A200010801A4001\
10901A400109B01AE00309001BA0000C051BE00509341B20020C451B000110501B4001096B1B2001\
09801B60000C831BC00309A11BA0010CAE1B400010B01B40010CBA1B800509E61BC0010C001C8004\
09241C800210401C40010C4D1C600010501C40010C5A1C80040C801C20010C901C60050CBD1C6000\
09D01C600009D41CA0020CE91C800009ED1C20000CEE1CC00009F41C20000CF51C400009F71C6000\
0CFA1C20000C001D001809C01D00080C001EC0220C181FC0000C201FC0040C481FC0000C501F0001\
0C591F20000C5B1F20000C5D1F20000C5F1FE0030C801FA0060CB61FE0000CBE1F20000CC21F6000\
0CC61FE0000CD01F80000CD61FC0000CE01FA0010CF21F60000CF61FE000130020E0001308206000\
090C202000120D2020000B0E2040000F182040000F242020000D2720200008282040000B2A20A000\
112F202000113F2040000E442020001154202000135F2020000B6020A0000B662040010C71202000\
0C7F2020000C9020A00109D02020040C022120000C072120000C0A2140010C152120000C1921A000\
0C242120000C262120000C282120000C2A2180000C2F2160010C3C2180000C4521A0000C4E212000\
0C602120050CB62480060C002CA01C0CEB2C800009EF2C60000CF22C40000C002DC0040C272D2000\
0C2D2D20000C302D00070C6F2D2000097F2D20000C802DE0020CA02DE0000CA82DE0000CB02DE000\
0CB82DE0000CC02DE0000CC82DE0000CD02DE0000CD82DE00009E02D00040C2F2E20001300302000\
0C05302000092A30C000163130A0000C3B304000154130C00A0999304000169B308000159F302000\
16A030200014A130400B16FC30600014FF3020000C053160050C3131C00B0CA031000414F0310002\
14D032E005140033000B0C00A0A0910CD0A4C0050C00A5A0210C10A600021020A640010C2AA64000\
0C40A6E005096FA680000974A640010C7FA6E003099EA640000CA0A6000A09F0A640000C08A76018\
0CD0A740000CD3A720000CD5A7A0000CF2A700020902A820000C03A860000906A820000C07A88000\
090BA820000C0CA8E0020923A8A000092CA820000C40A880060980A840000C82A8400609B4A84002\
10D0A8400109E0A840020CF2A8C0000CFBA820000CFDA8400009FFA820001000A940010C0AA98003\
0926A900010C30A9E0020947A9A0010C60A9A0030980A980000C84A9E00509B3A9C0010CCFA92000\
10D0A9400109E5A9200010F0A940010C00AA20050929AAC0010C40AA60000943AA20000C44AA0001\
094CAA40001050AA4001097BAA600009B0AA200009B2AA600009B7AA400009BEAA400009C1AA2000\
0CE0AA600109EBAAA0000CF2AA600009F5AA40000C01ABC0000C09ABC0000C11ABC0000C20ABE000\
0C28ABE0000C30AB40070C70AB600E09E3AB000109ECAB400010F0AB40010C00ACE0FF0CFFB3E0FF\
0CFEBBE0FF0CFDC3E0FF0CFCCBE0FF0CFBD320750CB0D7E0020CCBD720060C00FBE0000C13FBA000\
051DFB2000091EFB2000051FFB4001052AFBA0010538FBA000053EFB20000540FB40000543FB4000\
0546FB40010C50FB400C0CD3FB602D0C50FD00080C92FDC0060CF0FD80010900FE00020E10FE2000\
0D13FE20000E14FE20000920FE00021133FE4000114DFE60000E50FE20000F52FE20000E54FE2000\
0D55FE20000C70FEA0000C76FEE0100BFFFE20000F07FF20000E0CFF20000F0EFF20001010FF4001\
0D1AFF20000E1BFF20000C21FF4003113FFF20000C41FF40031466FF40011670FF20001471FFA005\
099EFF40000CA0FFE0030CC2FFC0000CCAFFC0000CD2FFC0000CDAFF60000BF9FF60000C00008101\
0C0D0041030C280061020C3C0041000C3F00E1010C5000C1010C8000610F0C4001A10609FD012100\
0C8002A1030CA002210609E00221000C000301040C2D03C1030C5003C104097603A1000C8003C103\
0CA00381040CC80301010CD103A1000C0004C11310A00441010CB00481040CD80481040C00050105\
0C300581060C700561010C7C05E1010C8C05E1000C940541000C970561010CA305E1010CB305E100\
0CBB0541000C0006E1260C4007C1020C600701010C8007C1000C870741050CB20721010C0008C100\
0C080821000C0A0881050C370841000C3C0821000C3F08E1020C6008E1020C8008E1030CE0086102\
0CF40841000C0009C1020C200941030C800901070CBE0941000C000A210009010A610009050A4100\
090C0A81000C100A81000C150A61000C190AA10309380A6100093F0A21000C600AA1030C800AA103\
0CC00A01010CC90A810309E50A41000C000BC1060C400BC1020C600B61020C800B41020C000C2109\
0C800C61060CC00C61060C000D810409240D810010300D41010C800E410509AB0E41000CB00E4100\
0C000FA1030C270F21000C300FC10209460F61010C700F410209820F81000CB00FA1020CE00FE102\
09001061000C0310A106093810E101106610410109701021000C7110410009731041000C75102100\
097F1081000C8310A10509B01061010BBD10210009C21021000BCD1021000CD010210310F0104101\
09001161000C03118104092711C10110361141010C4411210009451141000C471121000C50116104\
09731121000C7611210009801161000C8311010609B311C1010CC111810009C911810009CE114100\
10D01141010CDA1121000CDC1121000C001241020C13122103092C128101093E1221000C8012E100\
0C881221000C8A1281000C8F12E1010C9F1241010CB012E10509DF12810110F01241010900138100\
0C051301010C0F1341000C1313C1020C2A13E1000C321341000C3513A100093B1341000C3D132100\
093E13E1000947134100094B1361000C5013210009571321000C5D13A1000962134100096613E100\
097013A1000C0014A10609351441020C471481001050144101095E1421000C5F1461000C80140106\
09B01481020CC41441000CC714210010D01441010C8015E10509AF15E10009B81521010CD8158100\
09DC1541000C0016010609301621020C4416210010501641010C8016610509AB16A1010CB8162100\
10C0164101091D17E10110301741010C00188105092C18E1010CA018010810E01841010CFF180101\
0C091921000C0C1901010C151941000C18190103093019C1000937194100093B1981000C3F192100\
09401921000C41192100094219410010501941010CA01901010CAA19E10409D119E10009DA19E100\
0CE11921000CE319210009E41921000C001A210009011A41010C0B1A010509331AE1000C3A1A2100\
093B1A810009471A21000C501A210009511A61010C5C1AC105098A1A01020C9D1A21000CB01A2109\
0C001C21010C0A1CA104092F1C010109381C01010C401C210010501C41010C721CC10309921CC102\
09A91CC1010C001DE1000C081D41000C0B1DC10409311DC100093A1D2100093C1D4100093F1DE100\
0C461D210009471D210010501D41010C601DC1000C671D41000C6A1D0104098A1DA10009901D4100\
09931DA1000C981D210010A01D41010CE01E610209F31E81000CB01F21000C002041730C0024E10D\
0C802481180C902F210C0C0030E1850B303421010C0044E1480C006821470C406AE10310606A4101\
0C706AE10910C06A41010CD06AC10309F06AA1000C006B010609306BE1000C406B810010506B4101\
0C636BA1020C7D6B61020C406E01080C006F6109094F6F21000C506F210009516FE106098F6F8100\
0C936FA1010CE06F41000CE36F210009E46F210009F06F41001400B021000C00BC610D0C70BCA101\
0C80BC21010C90BC4101099DBC41000BA0BC81000900CFC1050930CFE1020965D1A100096DD1C100\
0B73D10101097BD101010985D1E10009AAD181000942D261000C00D4A10A0C56D4E1080C9ED44100\
0CA2D421000CA5D441000CA9D481000CAED481010CBBD421000CBDD4E1000CC5D421080C07D58100\
0C0DD501010C16D5E1000C1ED581030C3BD581000C40D5A1000C46D521000C4AD5E1000C52D5812A\
0CA8D621030CC2D621030CDCD6E1030CFCD621030C16D7E1030C36D721030C50D7E1030C70D72103\
0C8AD7E1030CAAD721030CC4D7010110CED741060900DAE106093BDA41060975DA21000984DA2100\
099BDAA10009A1DAE1010C00DFE1030900E0E1000908E02102091BE0E1000923E041000926E0A100\
0C00E1A1050930E1E1000C37E1E1001040E141010C4EE121000C90E2C10309AEE221000CC0E28105\
09ECE2810010F0E241010CE0E7E1000CE8E781000CEDE741000CF0E7E1010C00E8A11809D0E8E100\
0C00E981080944E9E1000C4BE921001050E941010C00EE81000C05EE61030C21EE41000C24EE2100\
0C27EE21000C29EE41010C34EE81000C39EE21000C3BEE21000C42EE21000C47EE21000C49EE2100\
0C4BEE21000C4DEE61000C51EE41000C54EE21000C57EE21000C59EE21000C5BEE21000C5DEE2100\
0C5FEE21000C61EE41000C64EE21000C67EE81000C6CEEE1000C74EE81000C79EE81000C7EEE2100\
0C80EE41010C8BEE21020CA1EE61000CA5EEA1000CABEE21020C30F141030C50F141030C70F14103\
0AE6F1410309FBF3A10010F0FB41010B01002E000920000E0C0900010E1E';

const WORD_BREAK_PROP_UNIT_LENGTH = 5;
const WBP = {
	/* ` */'Other': 0,
	/* a */'SOT': 1,
	/* b */'EOT': 2,
	/* c */'Double_Quote': 3,
	/* d */'Single_Quote': 4,
	/* e */'Hebrew_Letter': 5,
	/* f */'CR': 6,
	/* g */'LF': 7,
	/* h */'Newline': 8,
	/* i */'Extend': 9,
	/* j */'Regional_Indicator': 10,
	/* k */'Format': 11,
	/* l */'ALetter': 12,
	/* m */'MidLetter': 13,
	/* n */'MidNum': 14,
	/* o */'MidNumLet': 15,
	/* p */'Numeric': 16,
	/* q */'ExtendNumLet': 17,
	/* r */'ZWJ': 18,
	/* s */'WSegSpace': 19,
	/* t */'Katakana': 20,
	/* u */'Hiragana': 21,
	/* v */'KanaExtension': 22
};
const WBP_NAMES = Object.keys(WBP);

// GENERATED CODE END
// >>>

/*
 * While a property defined for splitting, specially assign a value for Extended_Pictographic
 */

WBP['Extended_Pictographic'] = 23;	/* w */

/*
 * data table, taken from:
 * http://www.unicode.org/Public/14.0.0/ucd/auxiliary/SentenceBreakProperty.txt
 */

// GENERATED CODE START <<<1
// This data was generated by the command 'node mkdata.js -e'.
const SENTENCE_BREAK_PROPS = '\
0809002000040A002000080B004000030D00200008200020000E210020000F220020000F27006000\
102C0040000D2E0020000C30004001103A0020000E3F0020000A410040030F5B0020000F5D002000\
09610040030F7B0020000F7D002000068500200008A000200009AA0020000FAB00200007AD002000\
09B500200009BA0020000FBB0020000AC000E0020AD800E00009DF00000309F80000010A00012000\
09010120000A0201200009030120000A0401200009050120000A0601200009070120000A08012000\
09090120000A0A012000090B0120000A0C012000090D0120000A0E012000090F0120000A10012000\
09110120000A1201200009130120000A1401200009150120000A1601200009170120000A18012000\
09190120000A1A012000091B0120000A1C012000091D0120000A1E012000091F0120000A20012000\
09210120000A2201200009230120000A2401200009250120000A2601200009270120000A28012000\
09290120000A2A012000092B0120000A2C012000092D0120000A2E012000092F0120000A30012000\
09310120000A3201200009330120000A3401200009350120000A3601200009370140000A39012000\
093A0120000A3B012000093C0120000A3D012000093E0120000A3F01200009400120000A41012000\
09420120000A4301200009440120000A4501200009460120000A4701200009480140000A4A012000\
094B0120000A4C012000094D0120000A4E012000094F0120000A5001200009510120000A52012000\
09530120000A5401200009550120000A5601200009570120000A5801200009590120000A5A012000\
095B0120000A5C012000095D0120000A5E012000095F0120000A6001200009610120000A62012000\
09630120000A6401200009650120000A6601200009670120000A6801200009690120000A6A012000\
096B0120000A6C012000096D0120000A6E012000096F0120000A7001200009710120000A72012000\
09730120000A7401200009750120000A7601200009770120000A78014000097A0120000A7B012000\
097C0120000A7D012000097E0160000A8101400009830120000A8401200009850120000A86014000\
09880120000A89016000098C0140000A8E01800009920120000A9301400009950120000A96016000\
09990160000A9C014000099E0120000A9F01400009A10120000AA201200009A30120000AA4012000\
09A50120000AA601400009A80120000AA901200009AA0140000AAC01200009AD0120000AAE014000\
09B00120000AB101600009B40120000AB501200009B60120000AB701400009B90140000BBB012000\
0ABC01200009BD0160000BC00180000AC401400009C60120000AC701400009C90120000ACA014000\
09CC0120000ACD01200009CE0120000ACF01200009D00120000AD101200009D20120000AD3012000\
09D40120000AD501200009D60120000AD701200009D80120000AD901200009DA0120000ADB012000\
09DC0140000ADE01200009DF0120000AE001200009E10120000AE201200009E30120000AE4012000\
09E50120000AE601200009E70120000AE801200009E90120000AEA01200009EB0120000AEC012000\
09ED0120000AEE01200009EF0140000AF101400009F30120000AF401200009F50120000AF6016000\
09F90120000AFA01200009FB0120000AFC01200009FD0120000AFE01200009FF0120000A00022000\
09010220000A0202200009030220000A0402200009050220000A0602200009070220000A08022000\
09090220000A0A022000090B0220000A0C022000090D0220000A0E022000090F0220000A10022000\
09110220000A1202200009130220000A1402200009150220000A1602200009170220000A18022000\
09190220000A1A022000091B0220000A1C022000091D0220000A1E022000091F0220000A20022000\
09210220000A2202200009230220000A2402200009250220000A2602200009270220000A28022000\
09290220000A2A022000092B0220000A2C022000092D0220000A2E022000092F0220000A30022000\
09310220000A32022000093302E0000A3A024000093C0220000A3D024000093F0240000A41022000\
09420220000A4302800009470220000A4802200009490220000A4A022000094B0220000A4C022000\
094D0220000A4E022000094F02A0080B9402200009950280040BB902E00009C00240000BC6028001\
09E002A0000BEC0220000BEE022000050003000E0A7003200009710320000A720320000973032000\
0B740320000A760320000977032000097A0380000A7F0320000A860320000A880360000A8C032000\
0A8E03400009900320000A910320020AA303200109AC0360040ACF03200009D00340000AD2036000\
09D50360000AD803200009D90320000ADA03200009DB0320000ADC03200009DD0320000ADE032000\
09DF0320000AE003200009E10320000AE203200009E30320000AE403200009E50320000AE6032000\
09E70320000AE803200009E90320000AEA03200009EB0320000AEC03200009ED0320000AEE032000\
09EF03A0000AF403200009F50320000AF703200009F80320000AF903400009FB0340000AFD036006\
09300400060A6004200009610420000A6204200009630420000A6404200009650420000A66042000\
09670420000A6804200009690420000A6A042000096B0420000A6C042000096D0420000A6E042000\
096F0420000A7004200009710420000A7204200009730420000A7404200009750420000A76042000\
09770420000A7804200009790420000A7A042000097B0420000A7C042000097D0420000A7E042000\
097F0420000A800420000981042000058304E0000A8A042000098B0420000A8C042000098D042000\
0A8E042000098F0420000A9004200009910420000A9204200009930420000A940420000995042000\
0A9604200009970420000A9804200009990420000A9A042000099B0420000A9C042000099D042000\
0A9E042000099F0420000AA004200009A10420000AA204200009A30420000AA404200009A5042000\
0AA604200009A70420000AA804200009A90420000AAA04200009AB0420000AAC04200009AD042000\
0AAE04200009AF0420000AB004200009B10420000AB204200009B30420000AB404200009B5042000\
0AB604200009B70420000AB804200009B90420000ABA04200009BB0420000ABC04200009BD042000\
0ABE04200009BF0420000AC004400009C20420000AC304200009C40420000AC504200009C6042000\
0AC704200009C80420000AC904200009CA0420000ACB04200009CC0420000ACD04200009CE044000\
0AD004200009D10420000AD204200009D30420000AD404200009D50420000AD604200009D7042000\
0AD804200009D90420000ADA04200009DB0420000ADC04200009DD0420000ADE04200009DF042000\
0AE004200009E10420000AE204200009E30420000AE404200009E50420000AE604200009E7042000\
0AE804200009E90420000AEA04200009EB0420000AEC04200009ED0420000AEE04200009EF042000\
0AF004200009F10420000AF204200009F30420000AF404200009F50420000AF604200009F7042000\
0AF804200009F90420000AFA04200009FB0420000AFC04200009FD0420000AFE04200009FF042000\
0A0005200009010520000A0205200009030520000A0405200009050520000A060520000907052000\
0A0805200009090520000A0A052000090B0520000A0C052000090D0520000A0E052000090F052000\
0A1005200009110520000A1205200009130520000A1405200009150520000A160520000917052000\
0A1805200009190520000A1A052000091B0520000A1C052000091D0520000A1E052000091F052000\
0A2005200009210520000A2205200009230520000A2405200009250520000A260520000927052000\
0A2805200009290520000A2A052000092B0520000A2C052000092D0520000A2E052000092F052000\
0A3105C0040B59052000105D05200009600520050E89052000059105A00505BF05200005C1054000\
05C405400005C70520000BD00560030BEF05A000070006C000100C0640000510066001071C062000\
0E1D0660000B20066005054B06A0020C600640010C6B0640000B6E06400005700620000B7106600C\
0ED40620000BD506200005D606E00007DD06200005DF06C0000BE506400005E706400005EA068000\
0BEE0640000CF00640010BFA0660000BFF0620000E00076000070F0720000B100720000511072000\
0B1207C00305300760030B4D07200B05A60760010BB10720000CC00740010BCA07200405EB072001\
0BF407400010F80720000EF90720000BFA07200005FD0720000B0008C00205160880000B1A082000\
051B0820010B2408200005250860000B28082000052908A0000E370820000E390820000E3D084000\
0B4008200305590860000B600860010B700800030B8908C000079008400005980800010BA0084005\
05CA08000307E208200005E30820040B0409C006053A0960000B3D092000053E0940020B50092000\
055109E0000B5809400105620940000E640940000C660940010B7109000205810960000B85090001\
0B8F0940000B9309C0020BAA09E0000BB20920000BB609800005BC0920000BBD09200005BE09E000\
05C709400005CB0960000BCE09200005D70920000BDC0940000BDF09600005E20940000CE6094001\
0BF00940000BFC09200005FE09200005010A60000B050AC0000B0F0A40000B130AC0020B2A0AE000\
0B320A40000B350A40000B380A4000053C0A2000053E0AA00005470A4000054B0A600005510A2000\
0B590A80000B5E0A20000C660A400105700A40000B720A600005750A200005810A60000B850A2001\
0B8F0A60000B930AC0020BAA0AE0000BB20A40000BB50AA00005BC0A20000BBD0A200005BE0A0001\
05C70A600005CB0A60000BD00A20000BE00A400005E20A40000CE60A40010BF90A200005FA0AC000\
05010B60000B050B00010B0F0B40000B130BC0020B2A0BE0000B320B40000B350BA000053C0B2000\
0B3D0B2000053E0BE00005470B4000054B0B600005550B60000B5C0B40000B5F0B600005620B4000\
0C660B40010B710B200005820B20000B830B20000B850BC0000B8E0B60000B920B80000B990B4000\
0B9C0B20000B9E0B40000BA30B40000BA80B60000BAE0B800105BE0BA00005C60B600005CA0B8000\
0BD00B200005D70B20000CE60B400105000CA0000B050C00010B0E0C60000B120CE0020B2A0C0002\
053C0C20000B3D0C2000053E0CE00005460C6000054A0C800005550C40000B580C60000B5D0C2000\
0B600C400005620C40000C660C40010B800C200005810C60000B850C00010B8E0C60000B920CE002\
0BAA0C40010BB50CA00005BC0C20000BBD0C200005BE0CE00005C60C600005CA0C800005D50C4000\
0BDD0C40000BE00C400005E20C40000CE60C40010BF10C400005000D80000B040D20010B0E0D6000\
0B120D2005053B0D40000B3D0D2000053E0DE00005460D6000054A0D80000B4E0D20000B540D6000\
05570D20000B5F0D600005620D40000C660D40010B7A0DC00005810D60000B850D40020B9A0D0003\
0BB30D20010BBD0D20000BC00DE00005CA0D200005CF0DC00005D60D200005D80D00010CE60D4001\
05F20D40000B010E000605310E20000B320E400005340EE0000B400EE00005470E00010C500E4001\
0B810E40000B840E20000B860EA0000B8C0E00030BA50E20000BA70E400105B10E20000BB20E4000\
05B40E20010BBD0E20000BC00EA0000BC60E200005C80EC0000CD00E40010BDC0E80000B000F2000\
05180F40000C200F400105350F200005370F200005390F20000F3A0F8000053E0F40000B400F0001\
0B490F800405710F800205860F40000B880FA000058D0F600105990F800405C60F20000B00106005\
052B1080020B3F1020000C401040010E4A1040000B5010C00005561080000B5A108000055E106000\
0B6110200005621060000B65104000056710E0000B6E10600005711080000B7510A0010582108001\
0B8E102000058F1020000C90104001059A1080000AA010C0040AC71020000ACD1020000BD0106005\
0BFC10A0290B4A1280000B5012E0000B581220000B5A1280000B601220050B8A1280000B90122004\
0BB21280000BB812E0000BC01220000BC21280000BC812E0010BD81220070B121380000B18136008\
055D1360000E621320000E671340000B801300020AA013C00A09F813C0000B0114804D0E6E162000\
0B6F16200208801620000B811640030F9B1640000BA01660090BEE1660010B001740020512178000\
0B1F17600205321760000E351740000B4017400205521740000B6017A0010B6E1760000572174000\
0B8017800605B41700040BD71720000BDC17200005DD1720000CE017400110021820000E03182000\
10081820000E09182000050B186000070E182000050F1820000C101840010B2018200B0B8018A000\
05851840000B8718400405A91820000BAA1820000BB018C0080B0019E00305201980010530198001\
0E441940000C461940010B5019C0030B7019A0000B801980050BB01940030CD01940010B001AE002\
05171AA0000B201AA00605551A400105601AA003057F1A20000C801A40010C901A40010BA71A2000\
0EA81A800005B01AE00305001BA0000B051BE00505341B20020B451B00010C501B40010E5A1B4000\
0E5E1B4000056B1B20010E7D1B400005801B60000B831BC00305A11BA0010BAE1B40000CB01B4001\
0BBA1B800505E61BC0010B001C800405241C80020E3B1C40000C401C40010B4D1C60000C501C4001\
0B5A1C80040E7E1C400009801C20010B901C60050BBD1C600005D01C600005D41CA0020BE91C8000\
05ED1C20000BEE1CC00005F41C20000BF51C400005F71C60000BFA1C200009001D001805C01D0008\
0A001E200009011E20000A021E200009031E20000A041E200009051E20000A061E200009071E2000\
0A081E200009091E20000A0A1E2000090B1E20000A0C1E2000090D1E20000A0E1E2000090F1E2000\
0A101E200009111E20000A121E200009131E20000A141E200009151E20000A161E200009171E2000\
0A181E200009191E20000A1A1E2000091B1E20000A1C1E2000091D1E20000A1E1E2000091F1E2000\
0A201E200009211E20000A221E200009231E20000A241E200009251E20000A261E200009271E2000\
0A281E200009291E20000A2A1E2000092B1E20000A2C1E2000092D1E20000A2E1E2000092F1E2000\
0A301E200009311E20000A321E200009331E20000A341E200009351E20000A361E200009371E2000\
0A381E200009391E20000A3A1E2000093B1E20000A3C1E2000093D1E20000A3E1E2000093F1E2000\
0A401E200009411E20000A421E200009431E20000A441E200009451E20000A461E200009471E2000\
0A481E200009491E20000A4A1E2000094B1E20000A4C1E2000094D1E20000A4E1E2000094F1E2000\
0A501E200009511E20000A521E200009531E20000A541E200009551E20000A561E200009571E2000\
0A581E200009591E20000A5A1E2000095B1E20000A5C1E2000095D1E20000A5E1E2000095F1E2000\
0A601E200009611E20000A621E200009631E20000A641E200009651E20000A661E200009671E2000\
0A681E200009691E20000A6A1E2000096B1E20000A6C1E2000096D1E20000A6E1E2000096F1E2000\
0A701E200009711E20000A721E200009731E20000A741E200009751E20000A761E200009771E2000\
0A781E200009791E20000A7A1E2000097B1E20000A7C1E2000097D1E20000A7E1E2000097F1E2000\
0A801E200009811E20000A821E200009831E20000A841E200009851E20000A861E200009871E2000\
0A881E200009891E20000A8A1E2000098B1E20000A8C1E2000098D1E20000A8E1E2000098F1E2000\
0A901E200009911E20000A921E200009931E20000A941E200009951E20010A9E1E2000099F1E2000\
0AA01E200009A11E20000AA21E200009A31E20000AA41E200009A51E20000AA61E200009A71E2000\
0AA81E200009A91E20000AAA1E200009AB1E20000AAC1E200009AD1E20000AAE1E200009AF1E2000\
0AB01E200009B11E20000AB21E200009B31E20000AB41E200009B51E20000AB61E200009B71E2000\
0AB81E200009B91E20000ABA1E200009BB1E20000ABC1E200009BD1E20000ABE1E200009BF1E2000\
0AC01E200009C11E20000AC21E200009C31E20000AC41E200009C51E20000AC61E200009C71E2000\
0AC81E200009C91E20000ACA1E200009CB1E20000ACC1E200009CD1E20000ACE1E200009CF1E2000\
0AD01E200009D11E20000AD21E200009D31E20000AD41E200009D51E20000AD61E200009D71E2000\
0AD81E200009D91E20000ADA1E200009DB1E20000ADC1E200009DD1E20000ADE1E200009DF1E2000\
0AE01E200009E11E20000AE21E200009E31E20000AE41E200009E51E20000AE61E200009E71E2000\
0AE81E200009E91E20000AEA1E200009EB1E20000AEC1E200009ED1E20000AEE1E200009EF1E2000\
0AF01E200009F11E20000AF21E200009F31E20000AF41E200009F51E20000AF61E200009F71E2000\
0AF81E200009F91E20000AFA1E200009FB1E20000AFC1E200009FD1E20000AFE1E200009FF1E2001\
0A081F000109101FC0000A181FC00009201F00010A281F000109301F00010A381F000109401FC000\
0A481FC00009501F00010A591F20000A5B1F20000A5D1F20000A5F1F200009601F00010A681F0001\
09701FC00109801F00010A881F000109901F00010A981F000109A01F00010AA81F000109B01FA000\
09B61F40000AB81FA00009BE1F200009C21F600009C61F40000AC81FA00009D01F800009D61F4000\
0AD81F800009E01F00010AE81FA00009F21F600009F61F40000AF81FA0000800206001070B202000\
050C204000070E20400010132040000F182000010D242020000628204000072A20A000082F202000\
0F392040000E3C2040000F452040000E47206000085F202000076020A00007662040010971202000\
0F7D204000097F2020000F8D204000099020A00105D02020040A022120000A07212000090A212000\
0A0B216000090E2140000A1021600009132120000A152120000A1921A0000A242120000A26212000\
0A282120000A2A218000092F2120000A3021800009342120000B352180000939212000093C214000\
0A3E2140000A452120000946218000094E2120000A6021000209702100020B802160000A83212000\
09842120000B852180000F082380000F292340000AB624400309D02440030F5B27C0000F6827C001\
0FC52740000FE62740010F8329C0020FD82980000FFC2940000A002C000609302C00060A602C2000\
09612C20000A622C600009652C40000A672C200009682C20000A692C2000096A2C20000A6B2C2000\
096C2C20000A6D2C800009712C20000A722C200009732C40000A752C200009762C00010A7E2C6000\
09812C20000A822C200009832C20000A842C200009852C20000A862C200009872C20000A882C2000\
09892C20000A8A2C2000098B2C20000A8C2C2000098D2C20000A8E2C2000098F2C20000A902C2000\
09912C20000A922C200009932C20000A942C200009952C20000A962C200009972C20000A982C2000\
09992C20000A9A2C2000099B2C20000A9C2C2000099D2C20000A9E2C2000099F2C20000AA02C2000\
09A12C20000AA22C200009A32C20000AA42C200009A52C20000AA62C200009A72C20000AA82C2000\
09A92C20000AAA2C200009AB2C20000AAC2C200009AD2C20000AAE2C200009AF2C20000AB02C2000\
09B12C20000AB22C200009B32C20000AB42C200009B52C20000AB62C200009B72C20000AB82C2000\
09B92C20000ABA2C200009BB2C20000ABC2C200009BD2C20000ABE2C200009BF2C20000AC02C2000\
09C12C20000AC22C200009C32C20000AC42C200009C52C20000AC62C200009C72C20000AC82C2000\
09C92C20000ACA2C200009CB2C20000ACC2C200009CD2C20000ACE2C200009CF2C20000AD02C2000\
09D12C20000AD22C200009D32C20000AD42C200009D52C20000AD62C200009D72C20000AD82C2000\
09D92C20000ADA2C200009DB2C20000ADC2C200009DD2C20000ADE2C200009DF2C20000AE02C2000\
09E12C20000AE22C200009E32C40000AEB2C200009EC2C20000AED2C200009EE2C200005EF2C6000\
0AF22C200009F32C200009002DC00409272D2000092D2D20000B302D00070B6F2D2000057F2D2000\
0B802DE0020BA02DE0000BA82DE0000BB02DE0000BB82DE0000BC02DE0000BC82DE0000BD02DE000\
0BD82DE00005E02D00040F002EC0010F1C2E40000F202E40010E2E2E20000B2F2E20000E3C2E2000\
0F422E20000E532E40000F552E0001080030200010013020000E023020000B053060000F08304001\
0F143000010F1D3060000B21302001052A30C0000B3130A0000B3830A0000B4130C00A0599304000\
0B9D3060000BA130400B0BFC3080000B053160050B3131C00B0BA03100040BF03100020B0034E0FF\
0BFF3BE0FF0BFE43E0FF0BFD4B60380B004EE0FF0BFF55E0FF0BFE5DE0FF0BFD65E0FF0BFC6DE0FF\
0BFB75E0FF0BFA7DE0FF0BF985E0FF0BF88DE0FF0BF795E0FF0BF69DE0D20BD0A4C0050EFFA42000\
0B00A5A0210E0EA640000B10A600020C20A640010B2AA640000A40A620000941A620000A42A62000\
0943A620000A44A620000945A620000A46A620000947A620000A48A620000949A620000A4AA62000\
094BA620000A4CA62000094DA620000A4EA62000094FA620000A50A620000951A620000A52A62000\
0953A620000A54A620000955A620000A56A620000957A620000A58A620000959A620000A5AA62000\
095BA620000A5CA62000095DA620000A5EA62000095FA620000A60A620000961A620000A62A62000\
0963A620000A64A620000965A620000A66A620000967A620000A68A620000969A620000A6AA62000\
096BA620000A6CA62000096DA620000B6EA62000056FA680000574A640010B7FA620000A80A62000\
0981A620000A82A620000983A620000A84A620000985A620000A86A620000987A620000A88A62000\
0989A620000A8AA62000098BA620000A8CA62000098DA620000A8EA62000098FA620000A90A62000\
0991A620000A92A620000993A620000A94A620000995A620000A96A620000997A620000A98A62000\
0999A620000A9AA62000099BA66000059EA640000BA0A6000A05F0A640000EF3A620000EF7A62000\
0B17A720010A22A720000923A720000A24A720000925A720000A26A720000927A720000A28A72000\
0929A720000A2AA72000092BA720000A2CA72000092DA720000A2EA72000092FA760000A32A72000\
0933A720000A34A720000935A720000A36A720000937A720000A38A720000939A720000A3AA72000\
093BA720000A3CA72000093DA720000A3EA72000093FA720000A40A720000941A720000A42A72000\
0943A720000A44A720000945A720000A46A720000947A720000A48A720000949A720000A4AA72000\
094BA720000A4CA72000094DA720000A4EA72000094FA720000A50A720000951A720000A52A72000\
0953A720000A54A720000955A720000A56A720000957A720000A58A720000959A720000A5AA72000\
095BA720000A5CA72000095DA720000A5EA72000095FA720000A60A720000961A720000A62A72000\
0963A720000A64A720000965A720000A66A720000967A720000A68A720000969A720000A6AA72000\
096BA720000A6CA72000096DA720000A6EA72000096FA740010A79A72000097AA720000A7BA72000\
097CA720000A7DA74000097FA720000A80A720000981A720000A82A720000983A720000A84A72000\
0985A720000A86A720000987A720000B88A720000A8BA72000098CA720000A8DA72000098EA72000\
0B8FA720000A90A720000991A720000A92A720000993A760000A96A720000997A720000A98A72000\
0999A720000A9AA72000099BA720000A9CA72000099DA720000A9EA72000099FA720000AA0A72000\
09A1A720000AA2A7200009A3A720000AA4A7200009A5A720000AA6A7200009A7A720000AA8A72000\
09A9A720000AAAA7A00009AFA720000AB0A7A00009B5A720000AB6A7200009B7A720000AB8A72000\
09B9A720000ABAA7200009BBA720000ABCA7200009BDA720000ABEA7200009BFA720000AC0A72000\
09C1A720000AC2A7200009C3A720000AC4A7800009C8A720000AC9A7200009CAA720000AD0A72000\
09D1A7200009D3A7200009D5A720000AD6A7200009D7A720000AD8A7200009D9A720000BF2A76000\
0AF5A7200009F6A720000BF7A7200009F8A760000BFBA7E0000502A820000B03A860000506A82000\
0B07A88000050BA820000B0CA8E0020523A8A000052CA820000B40A880060E76A840000580A84000\
0B82A8400605B4A840020ECEA840000CD0A8400105E0A840020BF2A8C0000BFBA820000BFDA84000\
05FFA820000C00A940010B0AA980030526A900010E2FA920000B30A9E0020547A9A0010B60A9A003\
0580A980000B84A9E00505B3A9C0010EC8A940000BCFA920000CD0A940010BE0A9A00005E5A92000\
0BE6A940010CF0A940010BFAA9A0000B00AA20050529AAC0010B40AA60000543AA20000B44AA0001\
054CAA40000C50AA40010E5DAA60000B60AAE0020B7AAA2000057BAA60000B7EAA400605B0AA2000\
0BB1AA200005B2AA60000BB5AA400005B7AA40000BB9AAA00005BEAA40000BC0AA200005C1AA2000\
0BC2AA20000BDBAA60000BE0AA600105EBAAA0000EF0AA40000BF2AA600005F5AA40000B01ABC000\
0B09ABC0000B11ABC0000B20ABE0000B28ABE0000930AB6005095CABA0010B69AB20000970AB000A\
0BC0AB600405E3AB00010EEBAB200005ECAB40000CF0AB40010B00ACE0FF0BFFB3E0FF0BFEBBE0FF\
0BFDC3E0FF0BFCCBE0FF0BFBD320750BB0D7E0020BCBD720060B00F9C02D0B70FA400D0900FBE000\
0913FBA0000B1DFB2000051EFB20000B1FFB40010B2AFBA0010B38FBA0000B3EFB20000B40FB4000\
0B43FB40000B46FB800D0BD3FB602D0F3EFD40000B50FD00080B92FDC0060BF0FD80010500FE0002\
1010FE40001013FE20000F17FE40000520FE00021031FE40000F35FE00020F47FE40001050FE4000\
0D52FE20001055FE20000E56FE40001058FE20000F59FEC0001063FE20000B70FEA0000B76FEE010\
07FFFE20000E01FF20000F08FF4000100CFF40000D0EFF20000C10FF4001101AFF20000E1FFF2000\
0A21FF40030F3BFF20000F3DFF20000941FF40030F5BFF20000F5DFF20000F5FFF40000E61FF2000\
0F62FF40001064FF20000B66FF0007059EFF40000BA0FFE0030BC2FFC0000BCAFFC0000BD2FFC000\
0BDAFF600007F9FF60000B000081010B0D0041030B280061020B3C0041000B3F00E1010B5000C101\
0B8000610F0B4001A10605FD0121000B8002A1030BA002210605E00221000B000301040B2D03C103\
0B5003C104057603A1000B8003C1030BA00381040BC80301010BD103A1000A000401050928040105\
0B5004C1090CA00441010AB004810409D80481040B000501050B300581060A700561010A7C05E101\
0A8C05E1000A94054100099705610109A305E10109B305E10009BB0541000B0006E1260B4007C102\
0B6007010109800721000B810741000983076100098707410509B20721010B0008C1000B08082100\
0B0A0881050B370841000B3C0821000B3F08E1020B6008E1020B8008E1030BE00861020BF4084100\
0B0009C1020B200941030B800901070BBE0941000B000A210005010A610005050A4100050C0A8100\
0B100A81000B150A61000B190AA10305380A6100053F0A21000E560A41000B600AA1030B800AA103\
0BC00A01010BC90A810305E50A41000B000BC1060B400BC1020B600B61020B800B41020B000C2109\
0A800C610609C00C61060B000D810405240D81000C300D41010B800E410505AB0E41000BB00E4100\
0B000FA1030B270F21000B300FC10205460F61010E550FA1000B700F410205820F81000E860F8100\
0BB00FA1020BE00FE10205001061000B0310A106053810E1010E471041000C661041010570102100\
0B7110410005731041000B75102100057F1081000B8310A10505B010610107BD1021000EBE108100\
05C210210007CD1021000BD01021030CF010410105001161000B03118104052711C1010C36114101\
0E411161000B4411210005451141000B471121000B5011610405731121000B761121000580116100\
0B8311010605B311C1010BC11181000EC511410005C91181000ECD11210005CE1141000CD0114101\
0BDA1121000BDC1121000EDE1141000B001241020B13122103052C1281010E381241000E3B124100\
053E1221000B8012E1000B881221000B8A1281000B8F12E1010B9F1241010EA91221000BB012E105\
05DF1281010CF012410105001381000B051301010B0F1341000B1313C1020B2A13E1000B32134100\
0B3513A100053B1341000B3D132100053E13E1000547134100054B1361000B501321000557132100\
0B5D13A1000562134100056613E100057013A1000B0014A10605351441020B471481000E4B144100\
0C50144101055E1421000B5F1461000B8014010605B01481020BC41441000BC71421000CD0144101\
0B8015E10505AF15E10005B81521010EC21541000EC915E1010BD815810005DC1541000B00160106\
05301621020E411641000B441621000C501641010B8016610505AB16A1010BB81621000CC0164101\
0B00176103051D17E1010C301741010E3C1761000B4017E1000B00188105052C18E1010AA0180104\
09C01801040CE01841010BFF1801010B091921000B0C1901010B151941000B18190103053019C100\
0537194100053B1981000B3F19210005401921000B4119210005421941000E441921000E46192100\
0C501941010BA01901010BAA19E10405D119E10005DA19E1000BE11921000BE319210005E4192100\
0B001A210005011A41010B0B1A010505331AE1000B3A1A2100053B1A81000E421A410005471A2100\
0B501A210005511A61010B5C1AC105058A1A01020E9B1A41000B9D1A21000BB01A21090B001C2101\
0B0A1CA104052F1C010105381C01010B401C21000E411C41000C501C41010B721CC10305921CC102\
05A91CC1010B001DE1000B081D41000B0B1DC10405311DC100053A1D2100053C1D4100053F1DE100\
0B461D210005471D21000C501D41010B601DC1000B671D41000B6A1D0104058A1DA10005901D4100\
05931DA1000B981D21000CA01D41010BE01E610205F31E81000EF71E41000BB01F21000B00204173\
0B0024E10D0B802481180B902F210C0B0030E18507303421010B0044E1480B006821470B406AE103\
0C606A41010E6E6A41000B706AE1090CC06A41010BD06AC10305F06AA1000EF56A21000B006B0106\
05306BE1000E376B41000B406B81000E446B21000C506B41010B636BA1020B7D6B61020A406E0104\
09606E01040E986E21000B006F6109054F6F21000B506F210005516FE106058F6F81000B936FA101\
0BE06F41000BE36F210005E46F210005F06F41000B0070E1FF0BFF77E1FF0BFE7F41FF0B0088C19A\
0B008D21010BF0AF81000BF5AFE1000BFDAF41000B00B061240B50B161000B64B181000B70B18131\
0B00BC610D0B70BCA1010B80BC21010B90BC4101059DBC41000E9FBC210007A0BC81000500CFC105\
0530CFE1020565D1A100056DD1C1000773D10101057BD101010585D1E10005AAD181000542D26100\
0A00D44103091AD441030A34D44103094ED4E1000956D441020A68D441030982D441030A9CD42100\
0A9ED441000AA2D421000AA5D441000AA9D481000AAED4010109B6D4810009BBD4210009BDD4E100\
09C5D461010AD0D4410309EAD441030A04D541000A07D581000A0DD501010A16D5E100091ED54103\
0A38D541000A3BD581000A40D5A1000A46D521000A4AD5E1000952D541030A6CD541030986D54103\
0AA0D5410309BAD541030AD4D5410309EED541030A08D641030922D641030A3CD641030956D64103\
0A70D64103098AD681030AA8D6210309C2D6210309DCD6C1000AE2D6210309FCD621030916D7C100\
0A1CD721030936D721030950D7C1000A56D721030970D72103098AD7C1000A90D7210309AAD72103\
09C4D7C1000ACAD7210009CBD721000CCED741060500DAE106053BDA41060575DA21000584DA2100\
0E88DA2100059BDAA10005A1DAE1010900DF41010B0ADF2100090BDF81020500E0E1000508E02102\
051BE0E1000523E041000526E0A1000B00E1A1050530E1E1000B37E1E1000C40E141010B4EE12100\
0B90E2C10305AEE221000BC0E2810505ECE281000CF0E241010BE0E7E1000BE8E781000BEDE74100\
0BF0E7E1010B00E8A11805D0E8E1000A00E941040922E941040544E9E1000B4BE921000C50E94101\
0B00EE81000B05EE61030B21EE41000B24EE21000B27EE21000B29EE41010B34EE81000B39EE2100\
0B3BEE21000B42EE21000B47EE21000B49EE21000B4BEE21000B4DEE61000B51EE41000B54EE2100\
0B57EE21000B59EE21000B5BEE21000B5DEE21000B5FEE21000B61EE41000B64EE21000B67EE8100\
0B6CEEE1000B74EE81000B79EE81000B7EEE21000B80EE41010B8BEE21020BA1EE61000BA5EEA100\
0BABEE21020A30F141030A50F141030A70F141030F76F661000CF0FB41010B0000E2FF0BFF07E2FF\
0BFE0FE2FF0BFD17E2FF0BFC1FE2FF0BFB27E2FF0BFA2FE2FF0BF937E2FF0BF83FE2FF0BF747E2FF\
0BF64FE2FF0BF557E2FF0BF45FE2FF0BF367E2FF0BF26FE2FF0BF177E2FF0BF07FE2FF0BEF87E2FF\
0BEE8FE2FF0BED97E2FF0BEC9F82DE0B00A7E2FF0BFFAEE2FF0BFEB662070B40B7C21B0B20B8E2FF\
0B1FC0E2FF0B1EC882D00BB0CEE2FF0BAFD6E2FF0BAEDEE2FF0BADE682A60B00F8C2430B0000E3FF\
0BFF07E3FF0BFE0FA3690701002E000520000E0C0500010E1E';

const SENTENCE_BREAK_PROP_UNIT_LENGTH = 5;
const SBP = {
	/* ` */'Other': 0,
	/* a */'SOT': 1,
	/* b */'EOT': 2,
	/* c */'CR': 3,
	/* d */'LF': 4,
	/* e */'Extend': 5,
	/* f */'Sep': 6,
	/* g */'Format': 7,
	/* h */'Sp': 8,
	/* i */'Lower': 9,
	/* j */'Upper': 10,
	/* k */'OLetter': 11,
	/* l */'Numeric': 12,
	/* m */'ATerm': 13,
	/* n */'STerm': 14,
	/* o */'Close': 15,
	/* p */'SContinue': 16
};
const SBP_NAMES = Object.keys(SBP);

// GENERATED CODE END
// >>>

/*
 * data table, taken from:
 * http://www.unicode.org/Public/14.0.0/ucd/Scripts.txt
 */

// GENERATED CODE START <<<1
// This data was generated by the command 'node mkdata.js -s'.
const SCRIPTS = '\
01000020080241004003015B00C0000261004003017B00E00502AA00200001AB00E00102BA002000\
01BB00A00002C000E00201D700200002D800E00301F700200002F800203801B902E00402E002A000\
01E502A00023EA02400001EC028002290003000E037003800001740320000375036000037A038000\
017E032000037F03200003840320000185032000038603200001870320000388036000038C032000\
038E03800203A303E00737E203C00103F0030002040004A01029850440000487042015053105C004\
0559054006058D056000069105E00606D005600306EF05C000070006A0000105062000070606C000\
010C062000070D06C001011B062000071C066000011F062000072006000401400620000741064001\
294B06600107560640032970062000077106800D01DD06200007DE064004080007C001080F078007\
084D0760000750070006098007400642C007600742FD076000520008C005523008E0015F40088003\
5F5E0820000860086001077008E0030790084000079808400901E208200007E308A0030A0009200A\
29510980000A5509E00101640940000A660940030B800980000B850900010B8F0940000B9309C002\
0BAA09E0000BB20920000BB60980000BBC0920010BC70940000BCB0980000BD70920000BDC094000\
0BDF09A0000BE60920030C010A60000C050AC0000C0F0A40000C130AC0020C2A0AE0000C320A4000\
0C350A40000C380A40000C3C0A20000C3E0AA0000C470A40000C4B0A60000C510A20000C590A8000\
0C5E0A20000C660A20020D810A60000D850A20010D8F0A60000D930AC0020DAA0AE0000DB20A4000\
0DB50AA0000DBC0A40010DC70A60000DCB0A60000DD00A20000DE00A80000DE60A80010DF90AE000\
0E010B60000E050B00010E0F0B40000E130BC0020E2A0BE0000E320B40000E350BA0000E3C0B2001\
0E470B40000E4B0B60000E550B60000E5C0B40000E5F0BA0000E660B40020F820B40000F850BC000\
0F8E0B60000F920B80000F990B40000F9C0B20000F9E0B40000FA30B40000FA80B60000FAE0B8001\
0FBE0BA0000FC60B60000FCA0B80000FD00B20000FD70B20000FE60BA00210000CA001100E0C6000\
10120CE002102A0C0002103C0C200110460C6000104A0C800010550C400010580C6000105D0C2000\
10600C800010660C400110770C200111800CA001118E0C600011920CE00211AA0C400111B50CA000\
11BC0C200111C60C600011CA0C800011D50C400011DD0C400011E00C800011E60C400111F10C4000\
12000DA001120E0D600012120D600612460D6000124A0DC00012540D000212660D400313810D6000\
13850D4002139A0D000313B30D200113BD0D200013C00DE00013CA0D200013CF0DC00013D60D2000\
13D80D000113E60D400113F20D600014010E4007013F0E200014400E800315810E400015840E2000\
15860EA000158C0E000315A50E200015A70EE00215C00EA00015C60E200015C80EC00015D00E4001\
15DC0E800016000F000916490F800416710FE00416990F800416BE0FE00116CE0FE00001D50F8000\
16D90F4000170010001418A010C00418C710200018CD10200018D010600501FB10200018FC108000\
19001100201A001220091A4A1280001A5012E0001A581220001A5A1280001A601220051A8A128000\
1A901220041AB21280001AB812E0001AC01220001AC21280001AC812E0011AD81220071A12138000\
1A181360081A5D1300041A801340031BA013C00A1BF813C0001C001400501D8016A0031EA0166009\
01EB1660001EEE1660012A0017C0022A1F1720002B2017A00201351740002C401780022D6017A001\
2D6E1760002D721740001F8017C00B1FE01740011FF0174001200018400001021840002004182000\
01051820002006188002202018200B20801860051CB018C0082E0019E0032E201980012E30198001\
2E401920002E441980012F5019C0032F7019A000388019800538B019400338D019600138DE194000\
1FE019000436001A8003361E1A40004E201AE0074E601AA0034E7F1A60014E901A40014EA01AC001\
29B01AE0033E001BA0093E501BE00543801B00085DC01B80065DFC1B800044001C0007443B1CE001\
444D1C600045501C000604801C200118901C600518BD1C600043C01C000129D01C600001D31C2000\
29D41CA00101E11C200029E21CE00001E91C800029ED1C200001EE1CC00029F41C200001F51C6000\
29F81C400001FA1C200002001DC00403261DA000042B1D2000022C1D2006035D1DA00002621D8000\
03661DA000026B1DA00104781D200002791DC00803BF1D200029C01D000802001E002003001FC002\
03181FC00003201FC00403481FC00003501F000103591F2000035B1F2000035D1F2000035F1FE003\
03801FA00603B61FE00103C61FC00103D61FC00003DD1F600203F21F600003F61F20010100208001\
290C204000010E20E00A016620600102712020000174206001027F202000018020E001029020A001\
01A020200429D0202004010021C00403262120000127216000022A214000012C21C0000232212000\
0133216003024E212000014F21200202602120050189216000019021E05201402460010160240074\
3500280020010029804E01762B000401972B200D39002C000C02602C000437802C800E37F92CE000\
18002DC00418272D2000182D2D20003A302D00073A6F2D40003A7F2D20001A802DE0021AA02DE000\
1AA82DE0001AB02DE0001AB82DE0001AC02DE0001AC82DE0001AD02DE0001AD82DE00004E02D0004\
01002EC00B24802E4003249B2E200B24002FC01A01F02F8001010030A00024053020000106302000\
240730200001083020032421302001292A308000192E30400001303000012438308000013C308000\
214130C00A2999304000019B304000219D30600001A030200022A130400B01FB30400022FD306000\
2305316005193131C00B019031000223A031000401C031800422F0310002190032E0030120320008\
196032E003017F32200A22D032E00501FF322000220033000B0158330015240034E0FF24FF3BE0FF\
24FE43E0FF24FD4B603801C04D000824004EE0FF24FF55E0FF24FE5DE0FF24FD65E0FF24FC6DE0FF\
24FB75E0FF24FA7DE0FF24F985E0FF24F88DE0FF24F795E0FF24F69D40412500A0A0912590A4E006\
53D0A400064600A580250440A6000C54A0A6000B0100A740040222A7C00C0188A76000028BA70008\
02D0A7400002D3A7200002D5A7A00002F2A7C0013B00A8A0050130A840014140A800074780A8C008\
47CEA880010AE0A800044800A9C005012EA92000482FA920004930A98004495FA920001960A9A003\
5580A9C00901CFA9200055D0A9400155DEA9400017E0A9E0034D00AAE0064D40AAC0014D50AA4001\
4D5CAA80001760AA00044F80AA60084FDBAAA00056E0AAE0021A01ABC0001A09ABC0001A11ABC000\
1A20ABE0001A28ABE0000230AB6005015BAB2000025CAB20010365AB20000266AB8000016AAB4000\
1B70AB000A56C0ABC00556F0AB40011900ACE0FF19FFB3E0FF19FEBBE0FF19FDC3E0FF19FCCBE0FF\
19FBD3207519B0D7E00219CBD720062400F9C02D2470FA400D0200FBE0000513FBA000061DFB4003\
0638FBA000063EFB20000640FB40000643FB40000646FB40010750FB600E07D3FB602D013EFD4000\
0740FD000A0792FDC00607CFFD200007F0FD00022900FE00020110FE40012920FEC001042EFE4000\
0130FE60040154FE60020168FE80000770FEA0000776FEE01001FFFE20000101FF00040221FF4003\
013BFFC0000241FF4003015BFF60012266FF40010170FF20002271FFA005019EFF400019A0FFE003\
19C2FFC00019CAFFC00019D2FFC00019DAFF600001E0FFE00001E8FFE00001F9FFA0003000008101\
300D0041033028006102303C004100303F00E101305000C101308000610F0100016100010701A105\
0137012101034001E109019001A10103A001210001D001A10529FD0121004A8002A1034BA0022106\
29E002210001E10261032600038104262D03610027300361037850036105318003C103319F032100\
3CA00381043CC803C101280004010A3250040106338004C10333A004410188B004810488D8048104\
6A000501056730058106676F052100A170056101A17C05E101A18C05E100A194054100A197056101\
A1A305E101A1B305E100A1BB0541006E0006E1266E4007C1026E60070101028007C1000287074105\
02B2072101340008C1003408082100340A0881053437084100343C082100343F082100574008C102\
57570821017660080104758008E10375A708210180E008610280F408410080FB08A1004000098103\
401F0921004C200941034C3F092100628009010461A009010361BC09810261D209C1053D000A8100\
3D050A41003D0C0A01013D150A61003D190AA1033D380A61003D3F0A41013D500A210158600A0104\
74800A010470C00AE10470EB0A810150000BC10650390BE10059400BC10259580B01015A600B6102\
5A780B010179800B410279990B810079A90BE1005B000C210982800C610682C00C610682FA0CC100\
92000D010592300D410107600EE1039C800E41059CAB0E61009CB00E410094000F010593300F4105\
9E700F410399B00F810395E00FE1025E0010C1095E521081045E7F1021005C801061085CCD102100\
65D010210365F0104101600011A10660361141026F5011E104648011010C13E11181026D00124102\
6D13128105818012E1008188122100818A128100818F12E101819F1261017BB01261077BF0124101\
6B001381006B051301016B0F1341006B1313C1026B2A13E1006B321341006B3513A100293B132100\
6B3C1321016B471341006B4B1361006B501321006B571321006B5D13E1006B6613E1006B7013A100\
870014810B875D14A1007C801401097CD01441017A8015C1067AB815C104720016A1087250164101\
206016A101668016410766C01641017E001761037E1D17E1017E3017E1028E001881077DA018610A\
7DFF1821009A0019E1009A091921009A0C1901019A151941009A1819C1039A371941009A3B198101\
9A5019410196A019010196AA19C10596DA1961018D001A01098C501A610A1CB01A010277C01A2107\
85001C2101850A1CA10585381CC10185501CA10386701C010486921CC10286A91CC1018A001DE100\
8A081D41008A0B1D81058A3A1D21008A3C1D41008A3F1D21018A501D41018F601DC1008F671D4100\
8F6A1DA1048F901D41008F931DC1008FA01D410190E01E210353B01F21000FC01F41060FFF1F2100\
3F002041733F0024E10D3F7024A1003F802481189D902F610C510030E18551303421017F0044E148\
540068214773406AE10373606A4101736E6A41009F706AE1099FC06A410168D06AC10368F06AC100\
6C006BC1086C506B41016C5B6BE1006C636BA1026C7D6B610291406E610B63006F6109634F6F2107\
638F6F210289E06F21008BE16F210024E26F41009BE46F210024F06F4100890070E1FF89FF77E1FF\
89FE7F41FF89008801609B008BC13A89008D210122F0AF810022F5AFE10022FDAF41002200B02100\
2101B0E1232220B161002150B161002264B181008B70B181316900BC610D6970BCA1016980BC2101\
6990BC4101699CBC810001A0BC81002900CFC1052930CFE1020150CF810E0100D0C11E0100D1E104\
0129D1C1072967D16100016AD12102297BD101010183D141002985D1E100018CD1C10329AAD18100\
01AED1A1070300D2C10801E0D281020100D3E10A0160D321030100D4A10A0156D4E108019ED44100\
01A2D4210001A5D4410001A9D4810001AED4810101BBD4210001BDD4E10001C5D421080107D58100\
010DD501010116D5E100011ED58103013BD581000140D5A1000146D52100014AD5E1000152D5812A\
01A8D6812401CED741068300D88151839BDAA10083A1DAE1010200DFE1033900E0E1003908E02102\
391BE0E1003923E041003926E0A1009700E1A1059730E1C1019740E14101974EE14100A090E2E103\
98C0E2410798FFE221001AE0E7E1001AE8E781001AEDE741001AF0E7E1017100E8A11871C7E80102\
8400E981098450E94101845EE941000171EC81080101EDA1070700EE81000705EE61030721EE4100\
0724EE21000727EE21000729EE41010734EE81000739EE2100073BEE21000742EE21000747EE2100\
0749EE2100074BEE2100074DEE61000751EE41000754EE21000757EE21000759EE2100075BEE2100\
075DEE2100075FEE21000761EE41000764EE21000767EE8100076CEEE1000774EE81000779EE8100\
077EEE21000780EE4101078BEE210207A1EE610007A5EEA10007ABEE210207F0EE41000100F08105\
0130F0810C01A0F0E10101B1F0E10101C1F0E10101D1F0A1040100F1C11501E6F141032100F22100\
0101F241000110F281050140F221010150F241000160F2C1000100F3017B01DDF6010201F0F6A101\
0100F7810E0180F7210B01E0F7810101F0F721000100F881010110F801070150F841010160F80105\
0190F8C10301B0F841000100F9812A0160FAC1010170FAA1000178FAA1000180FAE1000190FAA103\
01B0FA610101C0FAC10001D0FA410101E0FA010101F0FAE1000100FB61120194FBE10601F0FB4101\
240000E2FF24FF07E2FF24FE0FE2FF24FD17E2FF24FC1FE2FF24FB27E2FF24FA2FE2FF24F937E2FF\
24F83FE2FF24F747E2FF24F64FE2FF24F557E2FF24F45FE2FF24F367E2FF24F26FE2FF24F177E2FF\
24F07FE2FF24EF87E2FF24EE8FE2FF24ED97E2FF24EC9F82DE2400A7E2FF24FFAEE2FF24FEB66207\
2440B7C21B2420B8E2FF241FC0E2FF241EC882D024B0CEE2FF24AFD6E2FF24AEDEE2FF24ADE682A6\
2400F8C243240000E3FF24FF07E3FF24FE0FA3690101002E000120000E0C2900010E1E';

const SCRIPTS_PROP_UNIT_LENGTH = 5;
const SCRIPT = {
	'Unknown': 0,
	'Common': 1,
	'Latin': 2,
	'Greek': 3,
	'Cyrillic': 4,
	'Armenian': 5,
	'Hebrew': 6,
	'Arabic': 7,
	'Syriac': 8,
	'Thaana': 9,
	'Devanagari': 10,
	'Bengali': 11,
	'Gurmukhi': 12,
	'Gujarati': 13,
	'Oriya': 14,
	'Tamil': 15,
	'Telugu': 16,
	'Kannada': 17,
	'Malayalam': 18,
	'Sinhala': 19,
	'Thai': 20,
	'Lao': 21,
	'Tibetan': 22,
	'Myanmar': 23,
	'Georgian': 24,
	'Hangul': 25,
	'Ethiopic': 26,
	'Cherokee': 27,
	'Canadian_Aboriginal': 28,
	'Ogham': 29,
	'Runic': 30,
	'Khmer': 31,
	'Mongolian': 32,
	'Hiragana': 33,
	'Katakana': 34,
	'Bopomofo': 35,
	'Han': 36,
	'Yi': 37,
	'Old_Italic': 38,
	'Gothic': 39,
	'Deseret': 40,
	'Inherited': 41,
	'Tagalog': 42,
	'Hanunoo': 43,
	'Buhid': 44,
	'Tagbanwa': 45,
	'Limbu': 46,
	'Tai_Le': 47,
	'Linear_B': 48,
	'Ugaritic': 49,
	'Shavian': 50,
	'Osmanya': 51,
	'Cypriot': 52,
	'Braille': 53,
	'Buginese': 54,
	'Coptic': 55,
	'New_Tai_Lue': 56,
	'Glagolitic': 57,
	'Tifinagh': 58,
	'Syloti_Nagri': 59,
	'Old_Persian': 60,
	'Kharoshthi': 61,
	'Balinese': 62,
	'Cuneiform': 63,
	'Phoenician': 64,
	'Phags_Pa': 65,
	'Nko': 66,
	'Sundanese': 67,
	'Lepcha': 68,
	'Ol_Chiki': 69,
	'Vai': 70,
	'Saurashtra': 71,
	'Kayah_Li': 72,
	'Rejang': 73,
	'Lycian': 74,
	'Carian': 75,
	'Lydian': 76,
	'Cham': 77,
	'Tai_Tham': 78,
	'Tai_Viet': 79,
	'Avestan': 80,
	'Egyptian_Hieroglyphs': 81,
	'Samaritan': 82,
	'Lisu': 83,
	'Bamum': 84,
	'Javanese': 85,
	'Meetei_Mayek': 86,
	'Imperial_Aramaic': 87,
	'Old_South_Arabian': 88,
	'Inscriptional_Parthian': 89,
	'Inscriptional_Pahlavi': 90,
	'Old_Turkic': 91,
	'Kaithi': 92,
	'Batak': 93,
	'Brahmi': 94,
	'Mandaic': 95,
	'Chakma': 96,
	'Meroitic_Cursive': 97,
	'Meroitic_Hieroglyphs': 98,
	'Miao': 99,
	'Sharada': 100,
	'Sora_Sompeng': 101,
	'Takri': 102,
	'Caucasian_Albanian': 103,
	'Bassa_Vah': 104,
	'Duployan': 105,
	'Elbasan': 106,
	'Grantha': 107,
	'Pahawh_Hmong': 108,
	'Khojki': 109,
	'Linear_A': 110,
	'Mahajani': 111,
	'Manichaean': 112,
	'Mende_Kikakui': 113,
	'Modi': 114,
	'Mro': 115,
	'Old_North_Arabian': 116,
	'Nabataean': 117,
	'Palmyrene': 118,
	'Pau_Cin_Hau': 119,
	'Old_Permic': 120,
	'Psalter_Pahlavi': 121,
	'Siddham': 122,
	'Khudawadi': 123,
	'Tirhuta': 124,
	'Warang_Citi': 125,
	'Ahom': 126,
	'Anatolian_Hieroglyphs': 127,
	'Hatran': 128,
	'Multani': 129,
	'Old_Hungarian': 130,
	'SignWriting': 131,
	'Adlam': 132,
	'Bhaiksuki': 133,
	'Marchen': 134,
	'Newa': 135,
	'Osage': 136,
	'Tangut': 137,
	'Masaram_Gondi': 138,
	'Nushu': 139,
	'Soyombo': 140,
	'Zanabazar_Square': 141,
	'Dogra': 142,
	'Gunjala_Gondi': 143,
	'Makasar': 144,
	'Medefaidrin': 145,
	'Hanifi_Rohingya': 146,
	'Sogdian': 147,
	'Old_Sogdian': 148,
	'Elymaic': 149,
	'Nandinagari': 150,
	'Nyiakeng_Puachue_Hmong': 151,
	'Wancho': 152,
	'Chorasmian': 153,
	'Dives_Akuru': 154,
	'Khitan_Small_Script': 155,
	'Yezidi': 156,
	'Cypro_Minoan': 157,
	'Old_Uyghur': 158,
	'Tangsa': 159,
	'Toto': 160,
	'Vithkuqi': 161
};
const SCRIPT_NAMES = Object.keys(SCRIPT);

// GENERATED CODE END
// >>>

/*
 * data table, taken from:
 * http://www.unicode.org/Public/14.0.0/ucd/LineBreak.txt
 */

// GENERATED CODE START <<<1
// This data was generated by the command 'node mkdata.js -u 14.0.0 -i'.
const LINE_BREAK_PROPS = '\
03000020010409002000050A002000060B004000070D002000030E00400208200020000921002000\
0A220020000B230020000C240020000D250020000B260020000A270020000E280020000F29002000\
0B2A0020000C2B002000102C002000112D002000102E002000122F0020001330004001103A004000\
0B3C006000093F0020000B400060030E5B0020000C5C0020000F5D0020000B5E00A0030E7B002000\
047C002000147D0020000B7E002000037F00C0001585002000038600400316A00020000EA1002000\
0DA20020000CA30060000BA600200017A70040000BA900200017AA0020000AAB0020000BAC002000\
04AD0020000BAE0040000DB00020000CB100200017B200400018B40020000BB500200017B600A000\
0ABB00200017BC0060000EBF0020000BC000E00217D70020000BD800E00317F70020000BF800E039\
17C702200018C802200017C902600018CC02200017CD0220000BCE02400017D00220000BD102E000\
17D80280000BDC02200017DD0220000BDE02200018DF0220000BE0020004030003E009164F032000\
0350038001165C03E000036303A0010B700300010B7A038000107E0320000B7F0320000B8403E000\
0B8C0320000B8E0380020BA303001C038304E0000B8A04C0140B3105C0040B590500061089052000\
048A0520000B8D0540000C8F052000039105A00504BE05200003BF0520000BC005200003C1054000\
0BC305200003C405400009C605200003C705200019D005600319EF0580000BF30540000B00062001\
0D09066000100C0640000B0E0640000310066001091B062000031C062000091D0660000B20066005\
034B06A00213600640010D6A062000136B0640000B6D06600003700620000B7106600C09D4062000\
0BD506200003D606E0000BDD06400003DF06C0000BE506400003E70640000BE906200003EA068000\
0BEE06400013F00640010BFA0680020B0F07400003110720000B1207C00303300760030B4D07200B\
03A60760010BB107200013C00740010BCA07200403EB0720010BF407800010F807200009F9072000\
0BFA07200003FD0720000CFE0740000B0008C00203160880000B1A082000031B0820010B24082000\
03250860000B28082000032908A0000B3008E0010B4008200303590860000B5E0820000B60086001\
0B7008E0030B9008400003980800010BA008400503CA0800030BE208200003E30820040B0409C006\
033A0960000B3D092000033E0940020B50092000035109E0000B5809400103620940000464094000\
13660940010B7009200203810960000B850900010B8F0940000B9309C0020BAA09E0000BB2092000\
0BB609800003BC0920000BBD09200003BE09E00003C709400003CB0960000BCE09200003D7092000\
0BDC0940000BDF09600003E209400013E60940010BF00940000DF20940000BF409A0000DF9092000\
0BFA0920000CFB0920000BFC09400003FE09200003010A60000B050AC0000B0F0A40000B130AC002\
0B2A0AE0000B320A40000B350A40000B380A4000033C0A2000033E0AA00003470A4000034B0A6000\
03510A20000B590A80000B5E0A200013660A400103700A40000B720A600003750A20000B760A2000\
03810A60000B850A20010B8F0A60000B930AC0020BAA0AE0000BB20A40000BB50AA00003BC0A2000\
0BBD0A200003BE0A000103C70A600003CB0A60000BD00A20000BE00A400003E20A400013E60A4001\
0BF00A20000CF10A20000BF90A200003FA0AC00003010B60000B050B00010B0F0B40000B130BC002\
0B2A0BE0000B320B40000B350BA000033C0B20000B3D0B2000033E0BE00003470B4000034B0B6000\
03550B60000B5C0B40000B5F0B600003620B400013660B40010B700B000103820B20000B830B2000\
0B850BC0000B8E0B60000B920B80000B990B40000B9C0B20000B9E0B40000BA30B40000BA80B6000\
0BAE0B800103BE0BA00003C60B600003CA0B80000BD00B200003D70B200013E60B40010BF00B2001\
0CF90B20000BFA0B200003000CA0000B050C00010B0E0C60000B120CE0020B2A0C0002033C0C2000\
0B3D0C2000033E0CE00003460C6000034A0C800003550C40000B580C60000B5D0C20000B600C4000\
03620C400013660C400118770C20000B780C200103810C600018840C20000B850C00010B8E0C6000\
0B920CE0020BAA0C40010BB50CA00003BC0C20000BBD0C200003BE0CE00003C60C600003CA0C8000\
03D50C40000BDD0C40000BE00C400003E20C400013E60C40010BF10C400003000D80000B040D2001\
0B0E0D60000B120D2005033B0D40000B3D0D2000033E0DE00003460D6000034A0D80000B4E0D4000\
0B540D600003570D20000B580D400103620D400013660D40010B700D20010D790D20000B7A0DC000\
03810D60000B850D40020B9A0D00030BB30D20010BBD0D20000BC00DE00003CA0D200003CF0DC000\
03D60D200003D80D000113E60D400103F20D40000BF40D20001A010E40070C3F0E20001A400EE001\
0B4F0E200013500E4001045A0E40001A810E40001A840E20001A860EA0001A8C0E00031AA50E2000\
1AA70EE0021AC00EA0001AC60E20001AC80EC00013D00E40011ADC0E80000B000F200018010F8000\
0B050F200018060F400016080F200018090F4000040B0F2000160C0F2000090D0FA00016120F2000\
0B130F200009140F20000B150F600003180F40000B1A0FC00013200F40010B2A0F400104340F2000\
03350F20000B360F200003370F20000B380F200003390F20000E3A0F2000143B0F20000E3C0F2000\
143D0F2000033E0F40000B400F00010B490F800403710FC001047F0F200003800FA00004850F2000\
03860F40000B880FA000038D0F600103990F800404BE0F40000BC00FC00003C60F20000BC70FC000\
0BCE0F400018D00F400004D20F200018D30F20000BD40FA00016D90F40001A001000081340104001\
044A1040000B4C1080001A5010000813901040011A9A10C0000BA010C0040BC71020000BCD102000\
0BD01000061B0011000C1C601100091DA811000B0B001220090B4A1280000B5012E0000B58122000\
0B5A1280000B601220050B8A1280000B901220040BB21280000BB812E0000BC01220000BC2128000\
0BC812E0010BD81220070B121380000B18136008035D1360000B6013200004611320000B62136003\
0B801340030BA013C00A0BF813C00004001420000B0114E04F04801620000B811640030E9B162000\
149C1620000BA016600904EB1660000BEE1660010B0017400203121780000B1F1760020332176000\
04351740000B4017400203521740000B6017A0010B6E17600003721740001A8017800A04D4174000\
1ED61720001AD717200004D81720000BD917200004DA1720000CDB1720001ADC17400013E0174001\
0BF01740010B001840000902184000040418400018061820000B0718200009081840000B0A182000\
030B186000160E182000030F18200013101840010B2018200B0B8018A00003851840000B87184004\
03A91820000BAA1820000BB018C0080B0019E003032019800103301980010B401920000944194000\
13461940011A5019C0031A7019A0001A801980051AB019400313D01940011ADA1920001ADE194000\
0BE019E00603171AA0000B1E1A40001A201AE0071A601AA003037F1A200013801A400113901A4001\
1AA01AC00103B01AE00303001BA0000B051BE00503341B20020B451B000113501B4001045A1B4000\
0B5C1B2000045D1B80000B611B4001036B1B20010B741B2001047D1B400003801B60000B831BC003\
03A11BA0010BAE1B400013B01B40010BBA1B800503E61BC0010BFC1B000503241C8002043B1CA000\
13401C40010B4D1C600013501C40010B5A1C8004047E1C40000B801C20010B901C60050BBD1C6001\
03D01C60000BD31C200003D41CA0020BE91C800003ED1C20000BEE1CC00003F41C20000BF51C4000\
03F71C60000BFA1C20000B001D001803C01D00080B001EC0220B181FC0000B201FC0040B481FC000\
0B501F00010B591F20000B5B1F20000B5D1F20000B5F1FE0030B801FA0060BB61FE0010BC61FC001\
0BD61FC0000BDD1F60020BF21F60000BF61FE00018FD1F20000BFE1F2000040020E0001607202000\
04082060001F0B202000030C202000200D202000030E204000041020200016112020000412204000\
211420200017152040000B172020000A182040000E1A2020000A1B2060000E1E2020000A1F202000\
17202040000B22204000222420600004272020000628204000032A20A000162F2020000D30200001\
0B382020000A39204000173B2020001E3C2040000B3E20C00010442020000E452020001446202000\
1E472060000B4A20800104562020000B5720200004582080000B5C202000045D2060002360202000\
0B6120800003662040010B7020400017742020000B752000010E7D202000147E202000177F202000\
0B8020200017812080000B852000010E8D202000148E2020000B9020A0010CA020E0000DA7202000\
0CA820C0010DB62020000CB72080000DBB2020000CBC2040000DBE2020000CBF2020000DC0202000\
0CC120E00103D02020040B002160000D032120000B0421200017052120000B062160000D09212000\
0B0A21200117132120000B142140000C162120000B1721400117212140000B23210001172B212000\
0B2C21000517542140000B5621A000175B2120000B5C214000175E2120000B5F2120001760218001\
0B6C21800017702140010B7A21E00117892120000B8A21400017902140010B9A21000717D2212000\
0BD321200017D42120000BD521600517002220000B0122200017022240000B042260001707224000\
0B09224000170B2220000B0C226000170F2220000B1022200017112220000C122240000B14222000\
17152220000B16228000171A2220000B1B224000171D2280000B2122400017232220000B24222000\
17252220000B26222000172722C0000B2D222000172E2220000B2F22A00017342280000B38228000\
173C2240000B3E22400117482220000B49226000174C2220000B4D22A00017522220000B5322A001\
17602240000B6222400017642280000B68224000176A2240000B6C224000176E2240000B70224002\
17822240000B8422400017862240000B8822A00117952220000B9622600017992220000B9A226001\
17A52220000BA622200317BF2220000BC022E00522EF2220000BF02200030E082320001409232000\
0E0A232000140B2320000B0C23C00017122320000B1323E000241A2340000B1C23A0010E29232000\
142A2320000B2B23A01824F02380000BF42360060B40246001176024E0130BFF2420001700258009\
0B4C258000175025A0040B7525600117802500020B9025400017922580000B9625400117A0254000\
0BA225200017A325E0000BAA25000117B22540000BB425400017B62540000BB825800017BC254000\
0BBE25400017C02540000BC225800017C62560000BC925400017CB2520000BCC25400017CE258000\
0BD225000217E22580000BE625200117EF2520000BF025000224002680000B042620001705264000\
0B0726400017092620000B0A268000170E2640000B10268000241426400017162640002418262000\
0B19262000241A266000251D262000241E2640000B2026200324392660000B3C2680001740262000\
0B4126200017422620000B4326A00317602640000B6226200017632660000B662620001767262000\
246826200017692640000B6B262000176C2640000B6E262000176F2620000B7026E001247F262000\
0B8026C003179E2640000BA026A00324BD26800117C926800024CD2620000BCE26200024CF266000\
17D226200024D326400017D526600024D826400017DA26400024DC26200017DD26400024DF266000\
0BE226200017E32620000BE426800017E826400024EA26200017EB26C00024F126A00017F6262000\
24F726400025F926200024FA26200017FB26400024FD2600010B052760002408274000250A278000\
0B0E27200917572720000B582760000A5B27C0000B61272000096227400024642720000B65276000\
0E6827200014692720000E6A272000146B2720000E6C272000146D2720000E6E272000146F272000\
0E7027200014712720000E7227200014732720000E742720001475272000177627C0030B94272006\
0EC527200014C62720000BC727E0030EE627200014E72720000EE827200014E92720000EEA272000\
14EB2720000EEC27200014ED2720000EEE27200014EF2720000BF02760320E832920001484292000\
0E8529200014862920000E8729200014882920000E89292000148A2920000E8B292000148C292000\
0E8D292000148E2920000E8F29200014902920000E9129200014922920000E932920001494292000\
0E9529200014962920000E9729200014982920000B9929E0070ED829200014D92920000EDA292000\
14DB2920000BDC2900040EFC29200014FD2920000BFE29E02A17552BA0000B5A2B40030B762B0004\
0B972B002B03EF2C60000BF22C400009F92C200004FA2C60000BFD2C200009FE2C200004FF2C2000\
0B002DC0040B272D20000B2D2D20000B302D00070B6F2D200004702D2000037F2D20000B802DE002\
0BA02DE0000BA82DE0000BB02DE0000BB82DE0000BC02DE0000BC82DE0000BD02DE0000BD82DE000\
03E02D00040A002EC001040E2E00010B162E200004172E20000E182E200004192E20000B1A2E4000\
0A1C2E40000B1E2E40000A202E40000E222E200014232E20000E242E200014252E20000E262E2000\
14272E20000E282E200014292E2000042A2E8000092E2E20000B2F2E200004302E40000B322E2000\
04332E40000B352EA000213A2E4000043C2E60000B3F2E200004402E40000E422E200004432E0001\
0B4B2E2000044C2E20000B4D2E2000044E2E40000B502E600009532E40000E552E200014562E2000\
0E572E200014582E20000E592E2000145A2E20000E5B2E2000145C2E2000045D2E200024802E4003\
249B2E200B24002FC01A24F02F80010400302000140130400024033040001E053020002406304000\
0E0830200014093020000E0A302000140B3020000E0C302000140D3020000E0E302000140F302000\
0E10302000141130200024123040000E1430200014153020000E1630200014173020000E18302000\
14193020000E1A302000141B3020001E1C3020000E1D302000141E3040002420304001032A30C000\
243030A0000335302000243630A0001E3B304000243D306000264130200024423020002643302000\
244430200026453020002446302000264730200024483020002649302000244A3020032663302000\
246430E00326833020002484302000268530200024863020002687302000248830C000268E302000\
248F30C000269530400003993040001E9B308000249F3020001EA030200026A130200024A2302000\
26A330200024A430200026A530200024A630200026A730200024A830200026A930200024AA302003\
26C330200024C430E00326E330200024E430200026E530200024E630200026E730200024E830C000\
26EE30200024EF30C00026F530400024F73080001EFB30200026FC3020001EFD30400024FF302000\
2405316005243131C00B249031800A26F0310002240032E00324203200051748320001245032E0FF\
244F3AE0FF244E42E0FF244D4A606E0BC04D000824004EE0FF24FF55E0FF24FE5DE0FF24FD65E0FF\
24FC6DE0FF24FB75E0FF24FA7DE0FF24F985E0FF24F88DE0FF24F795E0FF24F69DE0431E15A02000\
2416A0E08E2490A4E0060BD0A4C00504FEA440000B00A5A021040DA62000090EA62000040FA62000\
0B10A600021320A640010B2AA640000B40A6E005036FA680000B73A620000374A640010B7EA60004\
039EA640000BA0A6000A03F0A640000BF2A6200004F3A6A0000B00A760190BD0A740000BD3A72000\
0BD5A7A0000BF2A700020302A820000B03A860000306A820000B07A88000030BA820000B0CA8E002\
0323A8A0000B28A88000032CA820000B30A800010D38A820000B39A820000B40A880061874A84000\
0976A840000380A840000B82A8400603B4A8400204CEA8400013D0A8400103E0A840020BF2A84001\
18FCA820000BFDA8400003FFA820001300A940010B0AA980030326A90001042EA940000B30A9E002\
0347A9A0010B5FA920001B60A9A0030380A980000B84A9E00503B3A9C0010BC1A9C00004C7A96000\
0BCAA980000BCFA9200013D0A940010BDEA940001AE0A9000213F0A940011AFAA9A0000B00AA2005\
0329AAC0010B40AA60000343AA20000B44AA0001034CAA40001350AA40010B5CAA2000045DAA6000\
1A60AA600C1ADBAAA0000BE0AA600103EBAAA00004F0AA40000BF2AA600003F5AA40000B01ABC000\
0B09ABC0000B11ABC0000B20ABE0000B28ABE0000B30AB80070B70AB600E03E3AB000104EBAB2000\
03ECAB400013F0AB40012700AC20002801AC6003271CAC2000281DAC60032738AC20002839AC6003\
2754AC20002855AC60032770AC20002871AC6003278CAC2000288DAC600327A8AC200028A9AC6003\
27C4AC200028C5AC600327E0AC200028E1AC600327FCAC200028FDAC60032718AD20002819AD6003\
2734AD20002835AD60032750AD20002851AD6003276CAD2000286DAD60032788AD20002889AD6003\
27A4AD200028A5AD600327C0AD200028C1AD600327DCAD200028DDAD600327F8AD200028F9AD6003\
2714AE20002815AE60032730AE20002831AE6003274CAE2000284DAE60032768AE20002869AE6003\
2784AE20002885AE600327A0AE200028A1AE600327BCAE200028BDAE600327D8AE200028D9AE6003\
27F4AE200028F5AE60032710AF20002811AF6003272CAF2000282DAF60032748AF20002849AF6003\
2764AF20002865AF60032780AF20002881AF6003279CAF2000289DAF600327B8AF200028B9AF6003\
27D4AF200028D5AF600327F0AF200028F1AF6003270CB02000280DB060032728B020002829B06003\
2744B020002845B060032760B020002861B06003277CB02000287DB060032798B020002899B06003\
27B4B0200028B5B0600327D0B0200028D1B0600327ECB0200028EDB060032708B120002809B16003\
2724B120002825B160032740B120002841B16003275CB12000285DB160032778B120002879B16003\
2794B120002895B1600327B0B1200028B1B1600327CCB1200028CDB1600327E8B1200028E9B16003\
2704B220002805B260032720B220002821B26003273CB22000283DB260032758B220002859B26003\
2774B220002875B260032790B220002891B2600327ACB2200028ADB2600327C8B2200028C9B26003\
27E4B2200028E5B260032700B320002801B36003271CB32000281DB360032738B320002839B36003\
2754B320002855B360032770B320002871B36003278CB32000288DB3600327A8B3200028A9B36003\
27C4B3200028C5B3600327E0B3200028E1B3600327FCB3200028FDB360032718B420002819B46003\
2734B420002835B460032750B420002851B46003276CB42000286DB460032788B420002889B46003\
27A4B4200028A5B4600327C0B4200028C1B4600327DCB4200028DDB4600327F8B4200028F9B46003\
2714B520002815B560032730B520002831B56003274CB52000284DB560032768B520002869B56003\
2784B520002885B5600327A0B5200028A1B5600327BCB5200028BDB5600327D8B5200028D9B56003\
27F4B5200028F5B560032710B620002811B66003272CB62000282DB660032748B620002849B66003\
2764B620002865B660032780B620002881B66003279CB62000289DB6600327B8B6200028B9B66003\
27D4B6200028D5B6600327F0B6200028F1B66003270CB72000280DB760032728B720002829B76003\
2744B720002845B760032760B720002861B76003277CB72000287DB760032798B720002899B76003\
27B4B7200028B5B7600327D0B7200028D1B7600327ECB7200028EDB760032708B820002809B86003\
2724B820002825B860032740B820002841B86003275CB82000285DB860032778B820002879B86003\
2794B820002895B8600327B0B8200028B1B8600327CCB8200028CDB8600327E8B8200028E9B86003\
2704B920002805B960032720B920002821B96003273CB92000283DB960032758B920002859B96003\
2774B920002875B960032790B920002891B9600327ACB9200028ADB9600327C8B9200028C9B96003\
27E4B9200028E5B960032700BA20002801BA6003271CBA2000281DBA60032738BA20002839BA6003\
2754BA20002855BA60032770BA20002871BA6003278CBA2000288DBA600327A8BA200028A9BA6003\
27C4BA200028C5BA600327E0BA200028E1BA600327FCBA200028FDBA60032718BB20002819BB6003\
2734BB20002835BB60032750BB20002851BB6003276CBB2000286DBB60032788BB20002889BB6003\
27A4BB200028A5BB600327C0BB200028C1BB600327DCBB200028DDBB600327F8BB200028F9BB6003\
2714BC20002815BC60032730BC20002831BC6003274CBC2000284DBC60032768BC20002869BC6003\
2784BC20002885BC600327A0BC200028A1BC600327BCBC200028BDBC600327D8BC200028D9BC6003\
27F4BC200028F5BC60032710BD20002811BD6003272CBD2000282DBD60032748BD20002849BD6003\
2764BD20002865BD60032780BD20002881BD6003279CBD2000289DBD600327B8BD200028B9BD6003\
27D4BD200028D5BD600327F0BD200028F1BD6003270CBE2000280DBE60032728BE20002829BE6003\
2744BE20002845BE60032760BE20002861BE6003277CBE2000287DBE60032798BE20002899BE6003\
27B4BE200028B5BE600327D0BE200028D1BE600327ECBE200028EDBE60032708BF20002809BF6003\
2724BF20002825BF60032740BF20002841BF6003275CBF2000285DBF60032778BF20002879BF6003\
2794BF20002895BF600327B0BF200028B1BF600327CCBF200028CDBF600327E8BF200028E9BF6003\
2704C020002805C060032720C020002821C06003273CC02000283DC060032758C020002859C06003\
2774C020002875C060032790C020002891C0600327ACC0200028ADC0600327C8C0200028C9C06003\
27E4C0200028E5C060032700C120002801C16003271CC12000281DC160032738C120002839C16003\
2754C120002855C160032770C120002871C16003278CC12000288DC1600327A8C1200028A9C16003\
27C4C1200028C5C1600327E0C1200028E1C1600327FCC1200028FDC160032718C220002819C26003\
2734C220002835C260032750C220002851C26003276CC22000286DC260032788C220002889C26003\
27A4C2200028A5C2600327C0C2200028C1C2600327DCC2200028DDC2600327F8C2200028F9C26003\
2714C320002815C360032730C320002831C36003274CC32000284DC360032768C320002869C36003\
2784C320002885C3600327A0C3200028A1C3600327BCC3200028BDC3600327D8C3200028D9C36003\
27F4C3200028F5C360032710C420002811C46003272CC42000282DC460032748C420002849C46003\
2764C420002865C460032780C420002881C46003279CC42000289DC4600327B8C4200028B9C46003\
27D4C4200028D5C4600327F0C4200028F1C46003270CC52000280DC560032728C520002829C56003\
2744C520002845C560032760C520002861C56003277CC52000287DC560032798C520002899C56003\
27B4C5200028B5C5600327D0C5200028D1C5600327ECC5200028EDC560032708C620002809C66003\
2724C620002825C660032740C620002841C66003275CC62000285DC660032778C620002879C66003\
2794C620002895C6600327B0C6200028B1C6600327CCC6200028CDC6600327E8C6200028E9C66003\
2704C720002805C760032720C720002821C76003273CC72000283DC760032758C720002859C76003\
2774C720002875C760032790C720002891C7600327ACC7200028ADC7600327C8C7200028C9C76003\
27E4C7200028E5C760032700C820002801C86003271CC82000281DC860032738C820002839C86003\
2754C820002855C860032770C820002871C86003278CC82000288DC8600327A8C8200028A9C86003\
27C4C8200028C5C8600327E0C8200028E1C8600327FCC8200028FDC860032718C920002819C96003\
2734C920002835C960032750C920002851C96003276CC92000286DC960032788C920002889C96003\
27A4C9200028A5C9600327C0C9200028C1C9600327DCC9200028DDC9600327F8C9200028F9C96003\
2714CA20002815CA60032730CA20002831CA6003274CCA2000284DCA60032768CA20002869CA6003\
2784CA20002885CA600327A0CA200028A1CA600327BCCA200028BDCA600327D8CA200028D9CA6003\
27F4CA200028F5CA60032710CB20002811CB6003272CCB2000282DCB60032748CB20002849CB6003\
2764CB20002865CB60032780CB20002881CB6003279CCB2000289DCB600327B8CB200028B9CB6003\
27D4CB200028D5CB600327F0CB200028F1CB6003270CCC2000280DCC60032728CC20002829CC6003\
2744CC20002845CC60032760CC20002861CC6003277CCC2000287DCC60032798CC20002899CC6003\
27B4CC200028B5CC600327D0CC200028D1CC600327ECCC200028EDCC60032708CD20002809CD6003\
2724CD20002825CD60032740CD20002841CD6003275CCD2000285DCD60032778CD20002879CD6003\
2794CD20002895CD600327B0CD200028B1CD600327CCCD200028CDCD600327E8CD200028E9CD6003\
2704CE20002805CE60032720CE20002821CE6003273CCE2000283DCE60032758CE20002859CE6003\
2774CE20002875CE60032790CE20002891CE600327ACCE200028ADCE600327C8CE200028C9CE6003\
27E4CE200028E5CE60032700CF20002801CF6003271CCF2000281DCF60032738CF20002839CF6003\
2754CF20002855CF60032770CF20002871CF6003278CCF2000288DCF600327A8CF200028A9CF6003\
27C4CF200028C5CF600327E0CF200028E1CF600327FCCF200028FDCF60032718D020002819D06003\
2734D020002835D060032750D020002851D06003276CD02000286DD060032788D020002889D06003\
27A4D0200028A5D0600327C0D0200028C1D0600327DCD0200028DDD0600327F8D0200028F9D06003\
2714D120002815D160032730D120002831D16003274CD12000284DD160032768D120002869D16003\
2784D120002885D1600327A0D1200028A1D1600327BCD1200028BDD1600327D8D1200028D9D16003\
27F4D1200028F5D160032710D220002811D26003272CD22000282DD260032748D220002849D26003\
2764D220002865D260032780D220002881D26003279CD22000289DD2600327B8D2200028B9D26003\
27D4D2200028D5D2600327F0D2200028F1D26003270CD32000280DD360032728D320002829D36003\
2744D320002845D360032760D320002861D36003277CD32000287DD360032798D320002899D36003\
27B4D3200028B5D3600327D0D3200028D1D3600327ECD3200028EDD360032708D420002809D46003\
2724D420002825D460032740D420002841D46003275CD42000285DD460032778D420002879D46003\
2794D420002895D4600327B0D4200028B1D4600327CCD4200028CDD4600327E8D4200028E9D46003\
2704D520002805D560032720D520002821D56003273CD52000283DD560032758D520002859D56003\
2774D520002875D560032790D520002891D5600327ACD5200028ADD5600327C8D5200028C9D56003\
27E4D5200028E5D560032700D620002801D66003271CD62000281DD660032738D620002839D66003\
2754D620002855D660032770D620002871D66003278CD62000288DD6600327A8D6200028A9D66003\
27C4D6200028C5D6600327E0D6200028E1D6600327FCD6200028FDD660032718D720002819D76003\
2734D720002835D760032750D720002851D76003276CD72000286DD760032788D720002889D76003\
1CB0D7E0021DCBD720062900D8E0FF29FFDF20000000E0E0FF00FFE7E0FF00FEEFE0FF00FDF76020\
2400F900400B00FBE0000B13FBA000191DFB2000031EFB2000191FFB40010B29FB2000192AFBA001\
1938FBA000193EFB20001940FB40001943FB40001946FB40010B50FB600E0BD3FB602D143EFD2000\
0E3FFD20000B40FD000A0B92FDC0060BCFFD20000BF0FD80010DFCFD20000BFDFD60000300FE0002\
1010FE20001411FE40001013FE40000915FE40000E17FE20001418FE20002219FE20000320FE0002\
2430FEA0000E35FE20001436FE20000E37FE20001438FE20000E39FE2000143AFE20000E3BFE2000\
143CFE20000E3DFE2000143EFE20000E3FFE20001440FE20000E41FE20001442FE20000E43FE2000\
1444FE20002445FE40000E47FE20001448FE20002449FEE0001450FE20002451FE20001452FE2000\
1E54FE40000956FE40002458FE20000E59FE2000145AFE20000E5BFE2000145CFE20000E5DFE2000\
145EFE2000245FFE00012468FE20000C69FE20000D6AFE2000246BFE20000B70FEA0000B76FEE010\
23FFFE20000901FF20002402FF40000C04FF20000D05FF20002406FF40000E08FF20001409FF2000\
240AFF4000140CFF2000240DFF2000140EFF2000240FFF60011E1AFF4000241CFF6000091FFF2000\
2420FF60030E3BFF2000243CFF2000143DFF2000243EFFA0030E5BFF2000245CFF2000145DFF2000\
245EFF20000E5FFF20001460FF40000E62FF20001463FF40001E65FF20002466FF20002667FF4001\
2471FFA0051E9EFF400024A0FFE00324C2FFC00024CAFFC00024D2FFC00024DAFF60000DE0FF2000\
0CE1FF200024E2FF60000CE5FF40000BE8FFE00003F9FF60002AFCFF200017FDFF20000B00008101\
0B0D0041030B280061020B3C0041000B3F00E1010B5000C1010B8000610F04000161000B0701A105\
0B3701010B0B9001A1010BA00121000BD001A10503FD0121000B8002A1030BA002210603E0022100\
0BE10261030B000381040B2D03C1030B5003C104037603A1000B8003C103049F0321000BA0038104\
0BC803010104D00321000BD103A1000B0004C11313A00441010BB00481040BD80481040B00050105\
0B300581060B6F0581010B7C05E1010B8C05E1000B940541000B970561010BA305E1010BB305E100\
0BBB0541000B0006E1260B4007C1020B600701010B8007C1000B870741050BB20721010B0008C100\
0B080821000B0A0881050B370841000B3C0821000B3F08E10204570821000B5808E1080BA7082101\
0BE00861020BF40841000BFB082104041F0921000B200941030B3F0921000B800901070BBC098102\
0BD209E10503010A610003050A4100030C0A81000B100A81000B150A61000B190AA10303380A6100\
033F0A21000B400A210104500A01010B580A21000B600A01080BC00AA10403E50A41000BEB0AA100\
04F00AC10022F60A21000B000BC10604390BE1000B400BC1020B580B61030B780B41030B990B8100\
0BA90BE1000B000C21090B800C61060BC00C61060BFA0C410503240D810013300D41010B600EE103\
0B800E410503AB0E410004AD0E21000BB00E41000B000F01050B300FC10203460F61010B510F2101\
0B700F410203820F81000B860F81000BB00F81030BE00FE10203001061000B0310A106033810E101\
04471041000B4910A1000B52108102136610410103701021000B7110410003731041000B75102100\
037F1081000B8310A10503B01061010BBB10610004BE10810003C21021000BCD1021000BD0102103\
13F010410103001161000B03118104032711C101133611410104401181000B441121000345114100\
0B471121000B5011610403731121000B7411210018751121000B7611210003801161000B83110106\
03B311C1010BC111810004C51141000BC711210004C811210003C91181000BCD11210003CE114100\
13D01141010BDA11210018DB1121000BDC11210004DD1161000BE11181020B001241020B13122103\
032C12810104381241000B3A122100043B1241000B3D122100033E1221000B8012E1000B88122100\
0B8A1281000B8F12E1010B9F12410104A91221000BB012E10503DF12810113F01241010300138100\
0B051301010B0F1341000B1313C1020B2A13E1000B321341000B3513A100033B1341000B3D132100\
033E13E1000347134100034B1361000B5013210003571321000B5D13A1000362134100036613E100\
037013A1000B0014A10603351441020B47148100044B1481000B4F1421001350144101045A144100\
0B5D142100035E1421000B5F1461000B8014010603B01481020BC414810013D01441010B8015E105\
03AF15E10003B815210118C115210004C215410009C41541000BC615610004C915E1010BD8158100\
03DC1541000B00160106033016210204411641000B431641001350164101186016A1010B80166105\
03AB16A1010BB816410013C01641011A001761031A1D17E10113301741011A3A174100043C176100\
1A3F1701010B00188105032C18E1010B3B1821000BA018010813E01841010BEA1821010BFF180101\
0B091921000B0C1901010B151941000B18190103033019C1000337194100033B1981000B3F192100\
03401921000B411921000342194100044419610013501941010BA01901010BAA19E10403D119E100\
03DA19E1000BE119210018E21921000BE319210003E41921000B001A210003011A41010B0B1A0105\
03331AE1000B3A1A2100033B1A8100183F1A21000B401A210004411A810018451A21000B461A2100\
03471A21000B501A210003511A61010B5C1AC105038A1A0102049A1A61000B9D1A2100189E1A6100\
04A11A41000BB01A21090B001C21010B0A1CA104032F1C010103381C01010B401C210004411CA100\
13501C41010B5A1C610218701C210009711C21000B721CC10303921CC10203A91CC1010B001DE100\
0B081D41000B0B1DC10403311DC100033A1D2100033C1D4100033F1DE1000B461D210003471D2100\
13501D41010B601DC1000B671D41000B6A1D0104038A1DA10003901D410003931DA1000B981D2100\
13A01D41010BE01E610203F31E81000BF71E41000BB01F21000BC01FA1030DDD1F81000BE11F2102\
04FF1F21000B002041730B0024E10D047024A1000B802481180B902F610C0B0030014B0E58326100\
145B3261000B5E32810414823221000B833261000E8632210014873221000E883221001489322100\
0B8A32E11D0E79332100147A3341000B7C336116163034E1000E3734210014383421000B0044C139\
0ECE45210014CF4521000BD045E10E0B006821470B406AE10313606A4101046E6A41000B706AE109\
13C06A41010BD06AC10303F06AA10004F56A21000B006B010603306BE10004376B61000B3A6B4101\
04446B21000B456B210013506B41010B5B6BE1000B636BA1020B7D6B61020B406EE10A04976E4100\
0B996E41000B006F6109034F6F21000B506F210003516FE106038F6F81000B936FA1011EE06F8100\
16E46F210003F06F4100240070E1FF24FF77E1FF24FE7F41FF24008801600B008BC13A24008D2101\
0BF0AF81000BF5AFE1000BFDAF41002400B061242650B161002664B181002470B181310B00BC610D\
0B70BCA1010B80BC21010B90BC41010B9CBC2100039DBC4100049FBC210003A0BC81000300CFC105\
0330CFE1020B50CF810E0B00D0C11E0B00D1E1040B29D181070365D1A1000B6AD16100036DD1C102\
0B83D141000385D1E1000B8CD1C10303AAD181000BAED1A1070B00D241080342D261000B45D22100\
0BE0D281020B00D3E10A0B60D321030B00D4A10A0B56D4E1080B9ED441000BA2D421000BA5D44100\
0BA9D481000BAED481010BBBD421000BBDD4E1000BC5D421080B07D581000B0DD501010B16D5E100\
0B1ED581030B3BD581000B40D5A1000B46D521000B4AD5E1000B52D5812A0BA8D6812413CED74106\
0B00D801400300DAE1060B37DA8100033BDA41060B6DDA01010375DA21000B76DAC1010384DA2100\
0B85DA41000487DA81000B8BDA2100039BDAA10003A1DAE1010B00DFE1030300E0E1000308E02102\
031BE0E1000323E041000326E0A1000B00E1A1050330E1E1000B37E1E1001340E141010B4EE14100\
0B90E2C10303AEE221000BC0E2810503ECE2810013F0E241010CFFE221000BE0E7E1000BE8E78100\
0BEDE741000BF0E7E1010B00E8A1180BC7E8210103D0E8E1000B00E981080344E9E1000B4BE92100\
1350E941010E5EE941000B71EC61070DACEC21000BADEC61000DB0EC21000BB1EC81000B01EDA107\
0B00EE81000B05EE61030B21EE41000B24EE21000B27EE21000B29EE41010B34EE81000B39EE2100\
0B3BEE21000B42EE21000B47EE21000B49EE21000B4BEE21000B4DEE61000B51EE41000B54EE2100\
0B57EE21000B59EE21000B5BEE21000B5DEE21000B5FEE21000B61EE41000B64EE21000B67EE8100\
0B6CEEE1000B74EE81000B79EE81000B7EEE21000B80EE41010B8BEE21020BA1EE61000BA5EEA100\
0BABEE21020BF0EE41002400F001201700F1A101240DF161001710F1C1030B2EF141001730F14107\
0B6AF16100246DF161001770F1A10724ADF121072BE6F141032400F2A1302585F321002486F3C102\
0B9CF34100249EF3E1020BB5F3410024B7F3A1000BBCF3210024BDF3A10025C2F3610024C5F34100\
25C7F3210024C8F3410025CAF3610024CDF3C1052CFBF3A1002400F441082542F441002444F44100\
2546F461012451F4A1022566F461022479F46100257CF42100247DF481002581F461002484F42100\
2585F461002488F4E100258FF421002490F421002591F421002492F4C1010BA0F4210024A1F42100\
0BA2F4210024A3F421000BA4F4210024A5F4A10025AAF4210024ABF481000BAFF4210024B0F42100\
0BB1F4410024B3F4A1090B00F5E1002407F501020B17F5C1012425F5A1010B32F50103244AF54105\
2574F541002476F58100257AF52100247BF5A1022590F521002491F581002595F541002497F5A107\
0BD4F5010124DCF501030BF4F5C10024FAF561092545F661002448F66100254BF6A1000B50F6C104\
0A76F661001E79F661000B7CF681002480F6610425A3F6210024A4F6010225B4F6610024B7F62101\
25C0F6210024C1F6610125CCF6210024CDF661060B00F7810E2474F781010B80F7A10A24D5F76105\
0B00F88101240CF881000B10F801072448F801010B50F84101245AF8C1000B60F801052488F80101\
0B90F8C10324AEF8410A0B00F98101250CF92100240DF94100250FF921002410F901012518F90101\
2420F9C1002526F921002427F921012530F94101243AF94100253CF96100243FF901072577F92100\
2478F9A10725B5F9410024B7F9210025B8F9410024BAF9210025BBF9210024BCF9210225CDF96100\
24D0F9210025D1F9A10124DEF941040B00FA810A2454FAE10D25C3FA610024C6FA410525F0FAE100\
24F7FA21010B00FB61120B94FBE10613F0FB41012400FCC17F240000E2FF24FF07E2FF24FE0FE2FF\
24FD17E2FF24FC1FE2FF24FB27E2FF24FA2FE2FF24F937E2FF24F83FE2FF24F747E2FF24F64FE2FF\
24F557E2FF24F45FE2FF24F367E2FF24F26FE2FF24F177E2FF24F07FE2FF24EF87E2FF24EE8FE2FF\
24ED97E2FF24EC9FE2FF24EBA7E2FF24EAAFE2FF24E9B7E2FF24E8BFE2FF24E7C7E2FF24E6CFE2FF\
24E5D7E2FF24E4DFE2FF24E3E7E2FF24E2EFE2FF24E1F7E2FF24E0FFC203240000E3FF24FF07E3FF\
24FE0FE3FF24FD17E3FF24FC1FE3FF24FB27E3FF24FA2FE3FF24F937E3FF24F83FE3FF24F747E3FF\
24F64FE3FF24F557E3FF24F45FE3FF24F367E3FF24F26FE3FF24F177E3FF24F07FE3FF24EF87E3FF\
24EE8FE3FF24ED97E3FF24EC9FE3FF24EBA7E3FF24EAAFE3FF24E9B7E3FF24E8BFE3FF24E7C7E3FF\
24E6CFE3FF24E5D7E3FF24E4DFE3FF24E3E7E3FF24E2EFE3FF24E1F7E3FF24E0FFC3030301002E00\
0320000E0C0300010E1E000000EFFF00FF07EFFF00FE0FEFFF00FD17EFFF00FC1FEFFF00FB27EFFF\
00FA2FEFFF00F937EFFF00F83FEFFF00F747EFFF00F64FEFFF00F557EFFF00F45FEFFF00F367EFFF\
00F26FEFFF00F177EFFF00F07FEFFF00EF87EFFF00EE8FEFFF00ED97EFFF00EC9FEFFF00EBA7EFFF\
00EAAFEFFF00E9B7EFFF00E8BFEFFF00E7C7EFFF00E6CFEFFF00E5D7EFFF00E4DFEFFF00E3E7EFFF\
00E2EFEFFF00E1F7EFFF00E0FFCF03000000F0FF00FF07F0FF00FE0FF0FF00FD17F0FF00FC1FF0FF\
00FB27F0FF00FA2FF0FF00F937F0FF00F83FF0FF00F747F0FF00F64FF0FF00F557F0FF00F45FF0FF\
00F367F0FF00F26FF0FF00F177F0FF00F07FF0FF00EF87F0FF00EE8FF0FF00ED97F0FF00EC9FF0FF\
00EBA7F0FF00EAAFF0FF00E9B7F0FF00E8BFF0FF00E7C7F0FF00E6CFF0FF00E5D7F0FF00E4DFF0FF\
00E3E7F0FF00E2EFF0FF00E1F7F0FF00E0FFD003';

const LINE_BREAK_PROP_UNIT_LENGTH = 5;
const LBP = {
	/* @ */'XX': 0,
	/* A */'SOT': 1,
	/* B */'EOT': 2,
	/* C */'CM': 3,
	/* D */'BA': 4,
	/* E */'LF': 5,
	/* F */'BK': 6,
	/* G */'CR': 7,
	/* H */'SP': 8,
	/* I */'EX': 9,
	/* J */'QU': 10,
	/* K */'AL': 11,
	/* L */'PR': 12,
	/* M */'PO': 13,
	/* N */'OP': 14,
	/* O */'CP': 15,
	/* P */'IS': 16,
	/* Q */'HY': 17,
	/* R */'SY': 18,
	/* S */'NU': 19,
	/* T */'CL': 20,
	/* U */'NL': 21,
	/* V */'GL': 22,
	/* W */'AI': 23,
	/* X */'BB': 24,
	/* Y */'HL': 25,
	/* Z */'SA': 26,
	/* [ */'JL': 27,
	/* \ */'JV': 28,
	/* ] */'JT': 29,
	/* ^ */'NS': 30,
	/* _ */'ZW': 31,
	/* ` */'ZWJ': 32,
	/* a */'B2': 33,
	/* b */'IN': 34,
	/* c */'WJ': 35,
	/* d */'ID': 36,
	/* e */'EB': 37,
	/* f */'CJ': 38,
	/* g */'H2': 39,
	/* h */'H3': 40,
	/* i */'SG': 41,
	/* j */'CB': 42,
	/* k */'RI': 43,
	/* l */'EM': 44
};
const LBP_NAMES = Object.keys(LBP);

// GENERATED CODE END
// >>>

/*
 * data table, taken from:
 * http://www.unicode.org/Public/14.0.0/ucd/EastAsianWidth.txt
 */

// GENERATED CODE START <<<1
// This data was generated by the command 'node mkdata.js -a'.
const EAST_ASIAN_WIDTH_PROPS = '\
0000000004012000E00B007F00400402A100200001A200400002A400200001A500400002A7004000\
00A900200002AA00200000AB00200001AC00200002AD00400001AF00200002B000A00000B5002000\
02B600A00000BB00200002BC00800000C000C00002C600200000C700200102D000200000D100C000\
02D700400000D900A00002DE00800000E200800002E600200000E700200002E800600000EB002000\
02EC00400000EE00400002F000200000F100200002F200400000F400600002F700800000FB002000\
02FC00200000FD00200002FE00200000FF0040000201012000000201E00102110120000012012000\
0213012000001401E000021B012000001C01400102260140000028016000022B012000002C01A000\
023101600000340180000238012000003901C000023F018000004301200002440120000045016000\
0248018000004C012000024D012000004E0180000252014000005401400202660140000068016000\
026B012000006C01400C02CE01200000CF01200002D001200000D101200002D201200000D3012000\
02D401200000D501200002D601200000D701200002D801200000D901200002DA01200000DB012000\
02DC01200000DD01800E0251022000005202E0010261022000006202400C02C402200000C5024000\
02C702200000C802200002C902600000CC02200002CD02200000CE02400002D002200000D102E000\
02D802800000DC02200002DD02200000DE02200002DF02200000E0020004020003000E0070030001\
007A03C000008403E000008C032000008E036000029103200202A303E00000AA03E00002B1032002\
00C203200002C303E00000CA03E0060201042000000204C001021004000800500420000251042000\
005204C01B003105C0040059054006008D056000009105E00600D005600300EF05C000000006C021\
000F078007004D07A00C00C007600700FD072006003008E0010040088003005E0820000060086001\
007008E0030090084000009808801D0085090001008F094000009309C00200AA09E00000B2092000\
00B609800000BC09200100C709400000CB09800000D709200000DC09400000DF09A00000E6092003\
00010A600000050AC000000F0A400000130AC002002A0AE00000320A400000350A400000380A4000\
003C0A2000003E0AA00000470A4000004B0A600000510A200000590A8000005E0A200000660A2002\
00810A600000850A2001008F0A600000930AC00200AA0AE00000B20A400000B50AA00000BC0A4001\
00C70A600000CB0A600000D00A200000E00A800000E60A800100F90AE00000010B600000050B0001\
000F0B400000130BC002002A0BE00000320B400000350BA000003C0B200100470B4000004B0B6000\
00550B6000005C0B4000005F0BA00000660B400200820B400000850BC000008E0B600000920B8000\
00990B4000009C0B2000009E0B400000A30B400000A80B600000AE0B800100BE0BA00000C60B6000\
00CA0B800000D00B200000D70B200000E60BA00200000CA001000E0C600000120CE002002A0C0002\
003C0C200100460C6000004A0C800000550C400000580C6000005D0C200000600C800000660C4001\
00770CC002008E0C600000920CE00200AA0C400100B50CA00000BC0C200100C60C600000CA0C8000\
00D50C400000DD0C400000E00C800000E60C400100F10C400000000DA001000E0D600000120D6006\
00460D6000004A0DC00000540D000200660D400300810D600000850D4002009A0D000300B30D2001\
00BD0D200000C00DE00000CA0D200000CF0DC00000D60D200000D80D000100E60D400100F20D6000\
00010E4007003F0EA00300810E400000840E200000860EA000008C0E000300A50E200000A70EE002\
00C00EA00000C60E200000C80EC00000D00E400100DC0E800000000F000900490F800400710FE004\
00990F800400BE0FE00100CE0FA001000010C01800C710200000CD10200000D0100006030011000C\
006011201D004A128000005012E0000058122000005A1280000060122005008A1280000090122004\
00B212800000B812E00000C012200000C212800000C812E00100D812200700121380000018136008\
005D130004008013400300A013C00A00F813C000000014A05300A016200B000017C002001F170003\
0040178002006017A001006E1760000072174000008017C00B00E017400100F01740010000184003\
002018200B008018600500B018C008000019E0030020198001003019800100401920000044194005\
007019A000008019800500B019400300D019600100DE19C007001E1A200800601AA003007F1A6001\
00901A400100A01AC00100B01AE00300001BA00900501BE00500801B800E00FC1B8007003B1CE001\
004D1C800700901C600500BD1C600100D01C600500001DC04200181FC00000201FC00400481FC000\
00501F000100591F2000005B1F2000005D1F2000005F1FE00300801FA00600B61FE00100C61FC001\
00D61FC00000DD1F600200F21F600000F61F20010000200002021020200000112040000213208000\
00172020000218204000001A204000021C204000001E204000022020600000232020000224208000\
002820000102302020000031202000023220400000342020000235202000003620A000023B202000\
003C204000023E202000003F20C004006620800102742020000075204001027F2020000080202000\
02812080000085204001009020A00100A020200104A920200000AA20400002AC20200000AD208002\
00D0202004000021600002032120000004212000020521200000062160000209212000000A212001\
02132120000014214000021621200000172140010221214000002321600002262120000027218000\
022B212000002C21E0040253214000005521C000025B218000005F2120000260218001006C218000\
0270214001007A21E0010289212000008A2140000290214001009A21C00302B821400000BA210003\
02D221200000D321200002D421200000D521400202E721200000E821000302002220000001222000\
0202224000000422600002072240000009224000020B222000000C226000020F2220000010222000\
0211222000001222600002152220000016228000021A222000001B224000021D2280000021224000\
0223222000002422200002252220000026222000022722C000002D222000022E222000002F22A000\
02342280000038228000023C224000003E22400102482220000049226000024C222000004D22A000\
0252222000005322A0010260224000006222400002642280000068224000026A224000006C224000\
026E2240000070224002028222400000842240000286224000008822A00102952220000096226000\
0299222000009A22600102A522200000A622200302BF22200000C022400A0212232000001323E000\
031A234000001C23A0010329234000002B23C01703E923800000ED23600003F023200000F1234000\
03F323200000F42360060040246001026024401100EA24200002EB24200C004C2580000250258004\
0074258001028025000200902540000292258000009625400102A025400000A225200002A325E000\
00AA25000102B225400000B425400002B625400000B825800002BC25400000BE25400002C0254000\
00C225800002C625600000C925400002CB25200000CC25400002CE25800000D225000202E2258000\
00E625200102EF25200000F025A00103FD25400000FF25C000020526400000072640000209262000\
000A268000020E26400000102680000314264000001626C000021C262000001D262000021E262000\
001F262004024026200000412620000242262000004326A000034826800100542680010260264000\
0062262000026326600000662620000267268000006B262000026C264000006E262000026F262000\
007026E001037F262000008026600203932620000094264001029E26400000A026200003A1262000\
00A226000103AA26400000AC26200203BD26400002BF26200000C026800003C426400002C6260001\
03CE26200002CF26A00003D426200002D526A00100E226200002E326200000E426800002E8264000\
03EA26200002EB26E00003F226400002F426200003F526200002F626800003FA26200002FB264000\
03FD26200002FE264000000027A00003052720000006278000030A274000000C2780030328272000\
0029278002023D272000003E27C001034C272000004D272000034E272000004F2780000353276000\
00562720000357272000005827C0030276274001008027A0020395276000009827000303B0272000\
00B127C00103BF27200000C027C00401E627000100EE27E03201852940000087298032031B2B4000\
001D2B600603502B200000512B800003552B200002562B8000005A2B400300762B000400972BA02B\
00F92CA00500272D2000002D2D200000302D0007006F2D4000007F2D000300A02DE00000A82DE000\
00B02DE00000B82DE00000C02DE00000C82DE00000D02DE00000D82DE00000E02DC00F03802E4003\
039B2E200B03002FC01A03F02F80010500302000030130C007003F302000034130C00A039930E00C\
0305316005033131C00B039031800A03F031E00503203200050248320001035032E0FF034F3AE0FF\
034E42E0FF034D4A606E00C04D000803004EE0FF03FF55E0FF03FE5DE0FF03FD65E0FF03FC6DE0FF\
03FB75E0FF03FA7DE0FF03F985E0FF03F88DE0FF03F795E0FF03F69DE0D20390A4E00600D0A4802B\
0040A600170000A7601900D0A7400000D3A7200000D5A7A00000F2A760070030A840010040A80007\
0080A8C00800CEA8800100E0A8800E005FA920000360A9A0030080A9C00900CFA9600100DEA92004\
0000AAE0060040AAC0010050AA4001005CAAE00C00DBAA80030001ABC0000009ABC0000011ABC000\
0020ABE0000028ABE0000030AB80070070ABC00F00F0AB40010300ACE0FF03FFB3E0FF03FEBBE0FF\
03FDC3E0FF03FCCBE0FF03FBD3207500B0D7E00200CBD720060000D8E0FF00FFDF20000200E0E0FF\
02FFE7E0FF02FEEFE0FF02FDF760200300F900400000FBE0000013FBA000001DFB40030038FBA000\
003EFB20000040FB40000043FB40000046FBA00F00D3FBA0370092FDC00600CFFD200000F0FD0002\
0200FE00020310FE40010020FE00020330FE60040354FE60020368FE80000070FEA0000076FEE010\
00FFFE20000501FF000C0461FFC00B04C2FFC00004CAFFC00004D2FFC00004DAFF600005E0FFE000\
04E8FFE00000F9FF800002FDFF20000000008101000D0041030028006102003C004100003F00E101\
005000C101008000610F0000016100000701A105003701010B009001A10100A001210000D001C105\
008002A10300A002210600E00281030000038104002D03C1030050036105008003C103009F03A104\
00C803C101000004C11300A004410100B004810400D804810400000501050030058106006F058101\
007C05E101008C05E1000094054100009705610100A305E10100B305E10000BB054100000006E126\
004007C1020060070101008007C100008707410500B2072101000008C1000008082100000A088105\
0037084100003C082100003F08E102005708010900A708210100E008610200F408410000FB082104\
001F096103003F092100008009010700BC09810200D209410600050A4100000C0A010100150A6100\
00190AA10300380A6100003F0A410100500A210100600A010800C00AE10400EB0A810100000BC106\
00390BA10300580B610300780B410300990B810000A90BE10000000C210900800C610600C00C6106\
00FA0CC10500300D410100600EE10300800E410500AB0E610000B00E410000000F010500300F4105\
00700F410300B00F810300E00FE102000010C1090052108104007F10810800CD10210000D0102103\
00F0104101000011A1060036114102005011E104008011010C00E111810200001241020013128105\
008012E1000088122100008A128100008F12E101009F12610100B012610700F01241010000138100\
0005130101000F134100001313C102002A13E1000032134100003513A100003B1341010047134100\
004B13610000501321000057132100005D13E100006613E100007013A100000014810B005D14A100\
008014010900D0144101008015C10600B815C104000016A1080050164101006016A1010080164107\
00C01641010000176103001D17E101003017E102000018810700A018610A00FF1801010009192100\
000C1901010015194100001819C1030037194100003B198101005019410100A019010100AA19C105\
00DA19610100001A010900501A610A00B01A210900001C2101000A1CA10500381CC10100501CA103\
00701C010400921CC10200A91CC10100001DE10000081D4100000B1D8105003A1D2100003C1D4100\
003F1D210100501D410100601DC10000671D4100006A1DA10400901D410000931DC10000A01D4101\
00E01E210300B01F210000C01F410600FF1F6173000024E10D007024A100008024811800902F610C\
000030E1850030342101000044E148000068214700406AE10300606A4101006E6A210A00C06A4101\
00D06AC10300F06AC10000006BC10800506B4101005B6BE10000636BA102007D6B610200406E610B\
00006F6109004F6F2107008F6F210203E06FA10003F06F4100030070E1FF03FF77E1FF03FE7F41FF\
030088C19A03008D210103F0AF810003F5AFE10003FDAF41000300B061240350B161000364B18100\
0370B181310000BC610D0070BCA1010080BC21010090BC4101009CBC01010000CFC1050030CFE102\
0050CF810E0000D0C11E0000D1E1040029D141180000D2C10800E0D281020000D3E10A0060D32103\
0000D4A10A0056D4E108009ED4410000A2D4210000A5D4410000A9D4810000AED4810100BBD42100\
00BDD4E10000C5D421080007D58100000DD501010016D5E100001ED58103003BD581000040D5A100\
0046D52100004AD5E1000052D5812A00A8D6812400CED7C157009BDAA10000A1DAE1010000DFE103\
0000E0E1000008E02102001BE0E1000023E041000026E0A1000000E1A1050030E1C1010040E14101\
004EE141000090E2E10300C0E2410700FFE2210000E0E7E10000E8E7810000EDE7410000F0E7E101\
0000E8A11800C7E801020000E981090050E94101005EE941000071EC81080001EDA1070000EE8100\
0005EE61030021EE41000024EE21000027EE21000029EE41010034EE81000039EE2100003BEE2100\
0042EE21000047EE21000049EE2100004BEE2100004DEE61000051EE41000054EE21000057EE2100\
0059EE2100005BEE2100005DEE2100005FEE21000061EE41000064EE21000067EE8100006CEEE100\
0074EE81000079EE8100007EEE21000080EE4101008BEE210200A1EE610000A5EEA10000ABEE2102\
00F0EE41000000F081000304F021000005F0E1040030F0810C00A0F0E10100B1F0E10100C1F0C101\
03CFF0210000D1F0A1040200F16101000BF1A1000210F1C103002EF141000230F14107006AF1C100\
0270F1C103038EF12100028FF141000391F14101029BF1410200ADF1210000E6F141030300F26100\
0310F281050340F221010350F241000360F2C1000300F321040021F38101032DF321010036F32100\
0337F3C108007DF32100037EF3C1020094F3810103A0F3610500CBF3810003CFF3A10000D4F38101\
03E0F3210200F1F3610003F4F3210000F5F3610003F8F3E108003FF421000340F421000041F42100\
0342F4611700FDF4410003FFF4E107003EF5A101034BF58100004FF521000350F501030068F54102\
037AF52100007BF541030395F541000097F5A10103A4F5210000A5F5C10A03FBF5A10A0050F60106\
0380F6C10800C6F6C10003CCF6210000CDF6610003D0F6610000D3F6410003D5F6610003DDF66100\
00E0F6610103EBF6410000F0F6810003F4F621010000F7810E0080F7210B03E0F7810103F0F72100\
0000F881010010F801070050F841010060F801050090F8C10300B0F841000000F98101030CF9E105\
003BF92100033CF941010046F921000347F921170000FA810A0060FAC1010370FAA1000378FAA100\
0380FAE1000390FAA10303B0FA610103C0FAC10003D0FA410103E0FA010103F0FAE1000000FB6112\
0094FBE10600F0FB4101030000E2FF03FF07E2FF03FE0FE2FF03FD17E2FF03FC1FE2FF03FB27E2FF\
03FA2FE2FF03F937E2FF03F83FE2FF03F747E2FF03F64FE2FF03F557E2FF03F45FE2FF03F367E2FF\
03F26FE2FF03F177E2FF03F07FE2FF03EF87E2FF03EE8FE2FF03ED97E2FF03EC9FE2FF03EBA7E2FF\
03EAAFE2FF03E9B7E2FF03E8BFE2FF03E7C7E2FF03E6CFE2FF03E5D7E2FF03E4DFE2FF03E3E7E2FF\
03E2EFE2FF03E1F7E2FF03E0FFC203030000E3FF03FF07E3FF03FE0FE3FF03FD17E3FF03FC1FE3FF\
03FB27E3FF03FA2FE3FF03F937E3FF03F83FE3FF03F747E3FF03F64FE3FF03F557E3FF03F45FE3FF\
03F367E3FF03F26FE3FF03F177E3FF03F07FE3FF03EF87E3FF03EE8FE3FF03ED97E3FF03EC9FE3FF\
03EBA7E3FF03EAAFE3FF03E9B7E3FF03E8BFE3FF03E7C7E3FF03E6CFE3FF03E5D7E3FF03E4DFE3FF\
03E3E7E3FF03E2EFE3FF03E1F7E3FF03E0FFC3030001002E000020000E0C0200010E1E020000EFFF\
02FF07EFFF02FE0FEFFF02FD17EFFF02FC1FEFFF02FB27EFFF02FA2FEFFF02F937EFFF02F83FEFFF\
02F747EFFF02F64FEFFF02F557EFFF02F45FEFFF02F367EFFF02F26FEFFF02F177EFFF02F07FEFFF\
02EF87EFFF02EE8FEFFF02ED97EFFF02EC9FEFFF02EBA7EFFF02EAAFEFFF02E9B7EFFF02E8BFEFFF\
02E7C7EFFF02E6CFEFFF02E5D7EFFF02E4DFEFFF02E3E7EFFF02E2EFEFFF02E1F7EFFF02E0FFCF03\
020000F0FF02FF07F0FF02FE0FF0FF02FD17F0FF02FC1FF0FF02FB27F0FF02FA2FF0FF02F937F0FF\
02F83FF0FF02F747F0FF02F64FF0FF02F557F0FF02F45FF0FF02F367F0FF02F26FF0FF02F177F0FF\
02F07FF0FF02EF87F0FF02EE8FF0FF02ED97F0FF02EC9FF0FF02EBA7F0FF02EAAFF0FF02E9B7F0FF\
02E8BFF0FF02E7C7F0FF02E6CFF0FF02E5D7F0FF02E4DFF0FF02E3E7F0FF02E2EFF0FF02E1F7F0FF\
02E0FFD003';

const EAST_ASIAN_WIDTH_PROP_UNIT_LENGTH = 5;
const EAW = {
	/* ` */'N': 0,
	/* a */'Na': 1,
	/* b */'A': 2,
	/* c */'W': 3,
	/* d */'H': 4,
	/* e */'F': 5
};
const EAW_NAMES = Object.keys(EAW);

// GENERATED CODE END
// >>>

/*
 * classes
 */
function TimelimitCache () {
	this.lastCleared = Date.now();
	this.cache = new Map;
}

TimelimitCache.prototype = {
	TTL_MSECS: 1000 * 60,

	has: function (key) {
		return this.cache.has(key);
	},
	get: function (key) {
		const result = this.cache.get(key);

		if (Date.now() - this.lastCleared >= this.TTL_MSECS) {
			this.cache.clear;
			this.lastCleared = Date.now();
		}

		return result;
	},
	set: function (key, value) {
		this.cache.set(key, value);
	}
};

/*
 * variables
 */

function stub (label, creator) {
	return new Proxy(() => {}, {
		apply: (obj, thisArg, args) => {
			return creator().apply(thisArg, args);
		}
	});
}

let graphemeFinder = stub('grapheme', () => {
	return graphemeFinder = createFinderWithEmoji(
		Uint8Array.from(
			GRAPHEME_BREAK_PROPS.match(/[0-9A-F]{2}/g),
			a => parseInt(a, 16)),
		GRAPHEME_BREAK_PROP_UNIT_LENGTH,
		GBP.Other, GBP_NAMES.length
	);
});

let wordFinder = stub('word', () => {
	return wordFinder = createFinderWithEmoji(
		Uint8Array.from(
			WORD_BREAK_PROPS.match(/[0-9A-F]{2}/g),
			a => parseInt(a, 16)),
		WORD_BREAK_PROP_UNIT_LENGTH,
		WBP.Other, WBP_NAMES.length
	);
});

let sentenceFinder = stub('sentence', () => {
	return sentenceFinder = createFinder(
		Uint8Array.from(
			SENTENCE_BREAK_PROPS.match(/[0-9A-F]{2}/g),
			a => parseInt(a, 16)),
		SENTENCE_BREAK_PROP_UNIT_LENGTH,
		SBP.Other
	);
});

let scriptFinder = stub('script', () => {
	return scriptFinder = createFinder(
		Uint8Array.from(
			SCRIPTS.match(/[0-9A-F]{2}/g),
			a => parseInt(a, 16)),
		SCRIPTS_PROP_UNIT_LENGTH,
		SCRIPT.Unknown
	);
});

let lineBreakFinder = stub('script', () => {
	return lineBreakFinder = createFinder(
		Uint8Array.from(
			LINE_BREAK_PROPS.match(/[0-9A-F]{2}/g),
			a => parseInt(a, 16)),
		LINE_BREAK_PROP_UNIT_LENGTH,
		LBP.XX
	);
});

let eastAsianWidthFinder = stub('script', () => {
	return eastAsianWidthFinder = createFinder(
		Uint8Array.from(
			EAST_ASIAN_WIDTH_PROPS.match(/[0-9A-F]{2}/g),
			a => parseInt(a, 16)),
		EAST_ASIAN_WIDTH_PROP_UNIT_LENGTH,
		EAW.N);
});

let linkCount = 0;

let graphemeClusterCache = new TimelimitCache;
let wordClusterCache = new Map([[false, new TimelimitCache], [true, new TimelimitCache]]);
let lineBreakableClusterCache = new TimelimitCache;

const eawMap = [
	/* Neutral */    1,
	/* Narrow */     1,
	/* Ambiguous */  2,
	/* Wide */       2,
	/* Half Width */ 1,
	/* Full Width */ 2,
];

/*
 * utility functions
 */

function pick2 (data, index) {
	return data[index]
		|  data[index + 1] << 8;
}

function pick3 (data, index) {
	return data[index]
		|  data[index + 1] << 8
		|  data[index + 2] << 16;
}

function pick4 (data, index) {
	return data[index]
		|  data[index + 1] << 8
		|  data[index + 2] << 16
		|  data[index + 3] << 24;
}

function resolveSurrogates (s) {
	return Array.from(s, ch => ch.codePointAt(0));
}

function find (cp, table, units, otherValue) {
	let left = 0, right = ((table.length / units) >> 0) - 1;
	let middle, index, middlecp, length;

	while (left <= right) {
		middle = ((left + right) / 2) >> 0;
		index = middle * units;

		middlecp = pick4(table, index + 1);
		length = (middlecp >> 21) & 0x7ff;
		middlecp = middlecp & 0x1fffff;

		if (middlecp + length - 1 < cp) {
			left = middle + 1;
		}
		else if (cp < middlecp) {
			right = middle - 1;
		}
		else {
			return table[index];
		}
	}

	return otherValue;
}

function createFinder (table, units, otherValue) {
	const cache = {};
	return cp => {
		if (cp in cache) {
			return cache[cp];
		}
		else {
			return cache[cp] = find(cp, table, units, otherValue);
		}
	};
}

function createFinderWithEmoji (table, units, otherValue, emojiValue) {
	const cache = {};
	return cp => {
		if (cp in cache) {
			return cache[cp];
		}
		else {
			if (/^\p{Extended_Pictographic}$/u.test(String.fromCodePoint(cp))) {
				return cache[cp] = emojiValue;
			}
			else {
				return cache[cp] = find(cp, table, units, otherValue);
			}
		}
	};
}

function startsWith (subject, candidates) {
	return candidates.includes(subject.substr(0, 1));
}

function endsWith (subject, candidates) {
	return candidates.includes(subject.substr(-1));
}

function getUTF16FromCodePoint (cp) {
	const p = (cp & 0x1f0000) >> 16;
	const o = cp & 0xffff;
	if (p) {
		return String.fromCharCode(0xd800 | ((p - 1) << 6) | ((o & 0xfc00) >> 10)) +
			String.fromCharCode(0xdc00 | (o & 0x03ff));
	}
	else {
		return String.fromCharCode(o);
	}
}

function getCodePointString (cp, type) {
	let result = '';
	if (cp < 0x10000) {
		result = ('0000' + cp.toString(16).toUpperCase()).substr(-4);
	}
	else {
		result = cp.toString(16).toUpperCase();
	}
	switch (type) {
	case 'entity':
		result = '&#x' + result + ';'
		break;
	case 'unicode':
		result = 'U+' + result;
		break;
	}
	return result;
}

/*
 * grapheme cluster handling functions
 */

function buildGraphemeClusters (codePoints) {
	const CODE_OFFSET = 96;

	const result = [];
	let propString = '';
	let prevIndex = 0;
	let rawIndex = 0;
	let i = 0;
	for (let goal = codePoints.length; i < goal; i++) {
		const nextProp = String.fromCharCode(CODE_OFFSET + graphemeFinder(codePoints[i]));
		if (canBreak(propString, nextProp) > 0) {
			if (prevIndex < i) {
				const grapheme = new Grapheme(codePoints.slice(prevIndex, i), rawIndex);
				result.push(grapheme);
				rawIndex += grapheme.rawString.length;
			}
			prevIndex = i;
		}
		propString += nextProp;
	}

	if (canBreak(propString, String.fromCharCode(CODE_OFFSET + GBP.EOT)) > 0) {
		if (prevIndex < i) {
			result.push(
				new Grapheme(codePoints.slice(prevIndex, i), rawIndex)
			);
		}
	}

	return result;
}

function canBreak (prev, next) {
	/*
	 * This rules are taken from:
	 * http://unicode.org/reports/tr29/, Version 14.0.0, 2021-08-24
	 * ============================================================
	 */

	// Break at the start and end of text.
	//   GB1: sot  ÷
	if (prev == '') return 1;

	//   GB2: ÷  eot
	if (next == 'b') return 2;

	// Do not break between a CR and LF.
	// Otherwise, break before and after controls.
	//   GB3: CR  ×  LF
	if (endsWith(prev, 'd') && next == 'e') return -3;

	//   GB4: ( Control | CR | LF )  ÷
	if (endsWith(prev, 'fde')) return 4;

	//   GB5: ÷  ( Control | CR | LF )
	if (startsWith(next, 'fde')) return 5;

	// Do not break Hangul syllable sequences.
	//   GB6: L  ×  ( L | V | LV | LVT )
	if (endsWith(prev, 'j') && startsWith(next, 'jkmn')) return -6;

	//   GB7: ( LV | V )  ×  ( V | T )
	if (endsWith(prev, 'mk') && startsWith(next, 'kl')) return -7;

	//   GB8: ( LVT | T)  ×  T
	if (endsWith(prev, 'nl') && next == 'l') return -8;

	// Do not break before extending characters.
	//   GB9: ×  ( Extend | ZWJ )
	if (startsWith(next, 'go')) return -9;

	// The GB9a and GB9b rules only apply to extended grapheme clusters:
	// Do not break before SpacingMarks, or after Prepend characters.
	//   GB9a:          ×  SpacingMark
	if (next == 'i') return -9.1;

	//   GB9b: Prepend  ×
	if (endsWith(prev, 'c')) return -9.2;

	// GB10 is removed.

	// Do not break within emoji modifier sequences or emoji zwj sequences.
	//   GB11: \p{Extended_Pictographic} Extend* ZWJ  ×  \p{Extended_Pictographic}
	if (/pg*o$/u.test(prev) && next == 'p') return -11;

	// Do not break within emoji flag sequences. That is, do not break
	// between regional indicator (RI) symbols if there is an odd number of
	// RI characters before the break point.
	//   GB12: ^ ( RI RI )* RI  ×  RI
	if (/^(hh)*h$/.test(prev) && next == 'h') return -12;

	//   GB13: [^RI] ( RI RI )* RI  ×  RI
	if (/[^h](hh)*h$/.test(prev) && next == 'h') return -13;

	// Otherwise, break everywhere.
	//   GB999: Any  ÷  Any
	return 999;
}

/*
 * word boundary handling functions
 */

function buildWordClusters (codePoints, useScripts) {
	const CODE_OFFSET = 96;

	const result = [];
	let prevIndex = 0;
	let prevProps = '';
	let nextProps = codePoints.map(cp => {
		return String.fromCharCode(CODE_OFFSET + wordFinder(cp));
	}).join('') + String.fromCharCode(CODE_OFFSET + WBP.EOT);
	let rawIndex = 0;

	for (
		let i = 0, goal = nextProps.length;
		i < goal;
		i++, prevProps += nextProps.charAt(0), nextProps = nextProps.substring(1)
	) {
		if (canBreakWord(prevProps, nextProps) < 0) continue;
		if (useScripts && i > 0 && isInScriptWord(prevProps, nextProps, codePoints[i - 1], codePoints[i])) continue;

		if (prevIndex < i) {
			const text = codePoints.slice(prevIndex, i).map(getUTF16FromCodePoint).join('');
			result.push({
				text,
				index: prevIndex,
				rawIndex,
				length: i - prevIndex,
				type: prevProps.charCodeAt(prevIndex) - CODE_OFFSET
			});
			rawIndex += text.length;
		}

		prevIndex = i;
	}

	return result;
}

function canBreakWord (prev, next) {
	/*
	 * This rules are taken from:
	 * http://unicode.org/reports/tr29/, Version 14.0.0, 2021-08-24
	 * ============================================================
	 */

	// Break at the start and end of text.
	//   WB1: sot  ÷
	if (prev == '') return 1;

	//   WB2:  ÷  eot
	if (startsWith(next, 'b')) return 2;

	// Do not break within CRLF.
	//   WB3: CR  ×  LF
	if (endsWith(prev, 'f') && startsWith(next, 'g')) return -3;

	// Otherwise break before and after Newlines (including CR and LF)
	//   WB3a: (Newline | CR | LF)  ÷
	if (endsWith(prev, 'hfg')) return 3.1;

	//   WB3b:  ÷  (Newline | CR | LF)
	if (startsWith(next, 'hfg')) return 3.2;

	// Do not break within emoji zwj sequences.
	//   WB3c: ZWJ  ×  \p{Extended_Pictographic}
	if (endsWith(prev, 'r') && startsWith(next, 'w')) return -3.3;

	// Keep horizontal whitespace together.
	//   WB3d: WSegSpace  ×  WSegSpace
	if (endsWith(prev, 's') && startsWith(next, 's')) return -3.4;

	// Ignore Format and Extend characters, except after sot, CR, LF, and
	// Newline. (See Section 6.2, Replacing Ignore Rules.) This also has
	// the effect of: Any × (Format | Extend | ZWJ)
	//   WB4: X (Extend | Format | ZWJ)*  →  X
	if (startsWith(next, 'ikr')) return -4;
	prev = prev.replace(/([^afgh])[ikr]+/g, '$1');
	next = next.replace(/([^afgh])[ikr]+/g, '$1');

	// Do not break between most letters.
	//   WB5: AHLetter  ×  AHLetter
	//   * AHLetter represents (ALetter | Hebrew_Letter)
	if (endsWith(prev, 'le') && startsWith(next, 'le')) return -5;

	// Do not break letters across certain punctuation.
	//   WB6: AHLetter  ×  (MidLetter | MidNumLetQ) AHLetter
	//   * MidNumLetQ represents (MidNumLet | Single_Quote)
	if (endsWith(prev, 'le') && /^[mod][le]/.test(next)) return -6;

	//   WB7: AHLetter (MidLetter | MidNumLetQ)  ×  AHLetter
	if (/[le][mod]$/.test(prev) && startsWith(next, 'le')) return -7;

	//   WB7a: Hebrew_Letter  ×  Single_Quote
	if (endsWith(prev, 'e') && startsWith(next, 'd')) return -7.1;

	//   WB7b: Hebrew_Letter  ×  Double_Quote Hebrew_Letter
	if (endsWith(prev, 'e') && /^ce/.test(next)) return -7.2;

	//   WB7c: Hebrew_Letter Double_Quote  ×  Hebrew_Letter
	if (/ec$/.test(prev) && startsWith(next, 'e')) return -7.3;

	// Do not break within sequences of digits, or digits adjacent to
	// letters (“3a”, or “A3”).
	//   WB8: Numeric  ×  Numeric
	if (endsWith(prev, 'p') && startsWith(next, 'p')) return -8;

	//   WB9: AHLetter  ×  Numeric
	if (endsWith(prev, 'le') && startsWith(next, 'p')) return -9;

	//   WB10: Numeric  ×  AHLetter
	if (endsWith(prev, 'p') && startsWith(next, 'le')) return -10;

	// Do not break within sequences, such as “3.2” or “3,456.789”.
	//   WB11: Numeric (MidNum | MidNumLetQ)  ×  Numeric
	if (/p[nod]$/.test(prev) && startsWith(next, 'p')) return -11;

	//   WB12: Numeric  ×  (MidNum | MidNumLetQ) Numeric
	if (endsWith(prev, 'p') && /^[nod]p/.test(next)) return -12;

	// Do not break between Katakana.
	//   WB13: Katakana  ×  Katakana
	//   [unistring extension]: do not use this rule. use WB13-unistring-1 instead of.
	//if (endsWith(prev, 't') && startsWith(next, 't')) return -13;

	// [unistring extension]: Do not break between Katakana, Hiragana, KanaExtension
	//   WB13-unistring-1: Katakana       ×  Katakana
	//                     Hiragana       ×  Hiragana
	//                     KanaExtension  ×  KanaExtension
	if (endsWith(prev, 'tuv') && prev.substr(-1) == next.charAt(0)) return -13.1;

	// [unistring extension]: Do not break between Kana and its extension
	//   WB13-unistring-2: (Katakana | Hiragana)  ×  KanaExtension
	if (endsWith(prev, 'tu') && startsWith(next, 'v')) return -13.2;

	// [unistring extension]: Do not break between Kana and its extension
	//   WB13-unistring-3: KanaExtension  ×  (Katakana | Hiragana)
	if (endsWith(prev, 'v') && startsWith(next, 'tu')) return -13.3;

	// Do not break from extenders.
	//   WB13a: (AHLetter | Numeric | Katakana | Hiragana | KanaExtension | ExtendNumLet)  ×  ExtendNumLet
	//   [unistring extension]: added Hiragana and KanaExtension
	if (endsWith(prev, 'leptuvq') && startsWith(next, 'q')) return -13.4;

	//   WB13b: ExtendNumLet  ×  (AHLetter | Numeric | Katakana | Hiragana | KanaExtension)
	//   [unistring extension]: added Hiragana and KanaExtension
	if (endsWith(prev, 'q') && startsWith(next, 'leptuvq')) return -13.5;

	// WB14 is removed

	// Do not break within emoji flag sequences. That is, do not break
	// between regional indicator (RI) symbols if there is an odd number of
	// RI characters before the break point.
	//   WB15: ^ (RI RI)* RI  ×  RI
	if (/^(jj)*j$/.test(prev) && startsWith(next, 'j')) return -15;

	//   WB16: [^RI] (RI RI)* RI  ×  RI
	if (/[^j](jj)*j$/.test(prev) && startsWith(next, 'j')) return -16;

	// Otherwise, break everywhere (including around ideographs).
	//   WB999: Any  ÷  Any
	return 999;
}

function wordIndexOf (utf16Index) {
	let left = 0, right = this.length - 1;
	let middle, rawIndex, length;

	while (left <= right) {
		middle = ((left + right) / 2) >> 0;

		rawIndex = this[middle].rawIndex;
		length = this[middle].text.length;

		if (rawIndex + length - 1 < utf16Index) {
			left = middle + 1;
		}
		else if (utf16Index < rawIndex) {
			right = middle - 1;
		}
		else {
			return middle;
		}
	}

	return -1;
}

function getWords (s, useScripts) {
	const cache = wordClusterCache.get(!!useScripts);
	let result;

	if (cache.has(s)) {
		result = cache.get(s).map(c => {return {...c}});
	}
	else {
		result = buildWordClusters(resolveSurrogates(s), useScripts);
		cache.set(s, result);
	}

	Object.defineProperty(result, 'wordIndexOf', {
		value: wordIndexOf
	});

	return result;
}

function isInScriptWord (prev, next, prevcp, nextcp) {
	prev = prev.substr(-1);
	next = next.charAt(0);

	//  Space  ×  Space
	if (prev == 's' && next == 's') return true;
	//  !Space  ÷   Space
	if (prev != 's' && next == 's') return false;
	//  Space  ÷  !Space
	if (prev == 's' && next != 's') return false;

	if (/[ab]/.test(prev) || /[ab]/.test(next)) return false;

	return scriptFinder(prevcp) == scriptFinder(nextcp);
}

/*
 * sentence boundary handling functions/
 */

function buildSentenceClusters (codePoints) {
	const CODE_OFFSET = 96;

	const result = [];
	let prevIndex = 0;
	let prevProps = '';
	let nextProps = codePoints.map(cp => {
		return String.fromCharCode(CODE_OFFSET + sentenceFinder(cp));
	}).join('') + String.fromCharCode(CODE_OFFSET + SBP.EOT);
	let rawIndex = 0;

	for (
		let i = 0, goal = nextProps.length;
		i < goal;
		i++, prevProps += nextProps.charAt(0), nextProps = nextProps.substring(1)
	) {
		if (canBreakSentence(prevProps, nextProps) < 0) continue;

		if (prevIndex < i) {
			const text = codePoints.slice(prevIndex, i).map(getUTF16FromCodePoint).join('');
			result.push({
				text,
				index: prevIndex,
				rawIndex,
				length: i - prevIndex,
				type: prevProps.charCodeAt(prevIndex) - CODE_OFFSET,
				punctuated: /[mn]o*h*[fcd]?$/.test(prevProps.substring(prevIndex).replace(/([^afcd])[ge]+/g, '$1'))
			});
			rawIndex += text.length;
		}

		prevIndex = i;
	}

	return result;
}

function canBreakSentence (prev, next) {
	/*
	 * This rules are taken from:
	 * http://unicode.org/reports/tr29/, Version 14.0.0, 2021-08-24
	 * ============================================================
	 */

	// Break at the start and end of text, unless the text is empty.
	//   SB1  sot  ÷  Any
	if (prev == '' && next != '') return 1;

	//   SB2  Any  ÷  eot
	if (prev != '' && startsWith(next, 'b')) return 2;

	// Do not break within CRLF.
	//   SB3  CR  ×  LF
	if (endsWith(prev, 'c') && startsWith(next, 'd')) return -3;

	// Break after paragraph separators.
	//   SB4  ParaSep  ÷
	if (endsWith(prev, 'fcd')) return 4;

	// Ignore Format and Extend characters, except after sot, ParaSep, and
	// within CRLF. (See Section 6.2, Replacing Ignore Rules.) This also
	// has the effect of: Any × (Format | Extend)
	//   SB5  X (Extend | Format)*  →  X
	if (startsWith(next, 'ge')) return -5;
	next = next.replace(/([^afcd])[ge]+/g, '$1');
	prev = prev.replace(/([^afcd])[ge]+/g, '$1');

	// Do not break after full stop in certain contexts. [See note below.]
	//   SB6  ATerm  ×  Numeric
	if (endsWith(prev, 'm') && startsWith(next, 'l')) return -6;

	//   SB7  (Upper | Lower) ATerm  ×  Upper
	if (/[ij]m$/.test(prev) && startsWith(next, 'j')) return -7;

	//   SB8  ATerm Close* Sp*  ×  ( ¬(OLetter | Upper | Lower | ParaSep | SATerm) )* Lower
	if (/mo*h*$/.test(prev) && /^[^kjifcdmn]*i/.test(next)) return -8;

	//   SB8a  SATerm Close* Sp*  ×  (SContinue | SATerm)
	if (/[mn]o*h*$/.test(prev) && startsWith(next, 'pmn')) return -8.1;

	// Break after sentence terminators, but include closing punctuation,
	// trailing spaces, and any paragraph separator. [See note below.]
	//   SB9  SATerm Close*  ×  (Close | Sp | ParaSep)
	if (/[mn]o*$/.test(prev) && startsWith(next, 'ohfcd')) return -9;

	//   SB10  SATerm Close* Sp*  ×  (Sp | ParaSep)
	if (/[mn]o*h*$/.test(prev) && startsWith(next, 'hfcd')) return -10;

	//   SB11  SATerm Close* Sp* ParaSep?  ÷
	if (/[mn]o*h*[fcd]?$/.test(prev)) return 11;

	// Otherwise, do not break.
	//   SB998  Any  ×  Any
	return -998;
}

function getSentences (s) {
	const result = buildSentenceClusters(resolveSurrogates(s));

	Object.defineProperty(result, 'sentenceIndexOf', {
		value: wordIndexOf
	});

	return result;
}

/*
 * line breaking handling functions
 */

function buildLineBreakableClusters (codePoints) {
	const CODE_OFFSET = 64;

	const result = [];
	let prevIndex = 0;
	let prevProps = '';
	let nextProps = codePoints.map(cp => {
		let prop = lineBreakFinder(cp);
		// Assign a line breaking class to each code point of the input.
		// Resolve AI, CB, CJ, SA, SG, and XX into other line breaking classes
		// depending on criteria outside the scope of this algorithm.
		//
		//   AI, SG, XX           -> AL
		//   SA (Only Mn or Mc)   -> CM
		//   SA (Except Mn or MC) -> AL
		//   CJ                   -> NS
		switch (prop) {
		case 23: case 41: case 0:
			prop = 11;
			break;
		case 26:
			prop = /\p{gc=Mn}|\p{gc=Mc}/u.test(String.fromCodePoint(cp)) ? 3 : 11;
			break;
		case 38:
			prop = 30;
			break;
		}
		return String.fromCharCode(CODE_OFFSET + prop);
	}).join('') + String.fromCharCode(CODE_OFFSET + LBP.EOT);
	let rawIndex = 0;

	for (
		let i = 0, goal = nextProps.length;
		i < goal;
		i++, prevProps += nextProps.charAt(0), nextProps = nextProps.substring(1)
	) {
		if (canBreakLine(prevProps, nextProps, codePoints[i - 1], codePoints[i]) < 0) continue;

		if (prevIndex < i) {
			const text = codePoints.slice(prevIndex, i).map(getUTF16FromCodePoint).join('');
			result.push({
				text,
				index: prevIndex,
				rawIndex,
				length: i - prevIndex,
				type: prevProps.charCodeAt(prevIndex) - CODE_OFFSET
			});
			rawIndex += text.length;
		}

		prevIndex = i;
	}

	return result;
}

function canBreakLine (prev, next, prevcp, nextcp) {
	/*
	 * This rules are taken from:
	 * https://www.unicode.org/reports/tr14/tr14.html, Version 14.0.0, 2021-08-24
	 * ============================================================
	 */

	// LB2  Never break at the start of text.
	//   sot ×
	if (prev == '') return -2;

	// LB3  Always break at the end of text.
	//   ! eot
	if (startsWith(next, 'B')) return 3;

	// LB4  Always break after hard line breaks.
	//   BK !
	if (endsWith(prev, 'F')) return 4;

	// LB5  Treat CR followed by LF, as well as CR, LF, and NL as hard line breaks.
	//   CR × LF
	//   CR !
	//   LF !
	//   NL !
	if (endsWith(prev, 'G') && startsWith(next, 'E')) return -5.1;
	if (endsWith(prev, 'GEU')) return 5.2;

	// LB6  Do not break before hard line breaks.
	//   × ( BK | CR | LF | NL )
	if (startsWith(next, 'FGEU')) return -6;

	// LB7  Do not break before spaces or zero width space.
	//   × SP
	//   × ZW
	if (startsWith(next, 'H_')) return -7;

	// LB8  Break before any character following a zero-width space,
	//      even if one or more spaces intervene.
	//   ZW SP* ÷
	if (/_H*$/.test(prev)) return 8;

	// LB8a  Do not break after a zero width joiner.
	//   ZWJ ×
	//
	// A ZWJ will prevent breaks between most pairs of characters.
	// This behavior is used to prevent breaks within emoji zwj sequences.
	if (endsWith(prev, '`')) return -8.1;

	// LB9  Do not break a combining character sequence; treat it as if it has
	//      the line breaking class of the base character in all of the
	//      following rules. Treat ZWJ as if it were CM.
	//   Treat X (CM | ZWJ)* as if it were X.
	//   where X is any line break class except BK, CR, LF, NL, SP, or ZW.
	//
	// At any possible break opportunity between CM and a following character,
	// CM behaves as if it had the type of its base character. Note that
	// despite the summary title, this rule is not limited to standard combining
	// character sequences. For the purposes of line breaking, sequences
	// containing most of the control codes or layout control characters are
	// treated like combining sequences.
	next = next.replace(/([^FGEUH_])[C`]+/g, '$1');
	prev = prev.replace(/([^FGEUH_])[C`]+/g, '$1');
	if (/[^FGEUH_]$/.test(prev) && /^[C`]+/.test(next)) {
		return -9;
	}

	// LB10  Treat any remaining combining mark or ZWJ as AL.
	//   Treat any remaining CM or ZWJ as it if were AL.
	//
	// This catches the case where a CM is the first character on the line or
	// follows SP, BK, CR, LF, NL, or ZW.
	next = next.replace(/[C`]/g, 'K');
	prev = prev.replace(/[C`]/g, 'K');

	// LB11  Do not break before or after Word joiner and related characters.
	//   × WJ
	//   WJ ×
	if (startsWith(next, 'c')) return -11;
	if (endsWith(prev, 'c')) return -11.1;
	
	// LB12  Do not break after NBSP and related characters.
	//   GL ×
	if (endsWith(prev, 'V')) return -12;

	// LB12a  Do not break before NBSP and related characters, except after
	//        spaces and hyphens.
	//   [^SP BA HY] × GL
	//
	// The expression [^SP, BA, HY] designates any line break class other
	// than SP, BA or HY. The symbol ^ is used, instead of !, to avoid
	// confusion with the use of ! to indicate an explicit break. Unlike the
	// case for WJ, inserting a SP overrides the non-breaking nature of a GL.
	// Allowing a break after BA or HY matches widespread implementation
	// practice and supports a common way of handling special line breaking of
	// explicit hyphens, such as in Polish and Portuguese. See Section 5.3,
	// Use of Hyphen.
	if (/[^HDQ]$/.test(prev) && startsWith(next, 'V')) return -12.1;

	/*
	// LB13  Do not break before ‘]’ or ‘!’ or ‘;’ or ‘/’, even after spaces.
	//   × CL
	//   × CP
	//   × EX
	//   × IS
	//   × SY
	if (startsWith(next, 'TOIPR')) return -13;
	*/
	// LB13  Rules modified according to regular expression-based LB25
	//   [^NU] × CL
	//   [^NU] × CP
	//   × EX
	//   [^NU] × IS
	//   [^NU] × SY
	if (/[^S]$/.test(prev) && startsWith(next, 'TOPR')) return -13;
	if (startsWith(next, 'I')) return -13.1;
	
	// LB14  Do not break after ‘[’, even after spaces.
	//   OP SP* ×
	if (/NH*$/.test(prev)) return -14;

	// LB15  Do not break within ‘”[’, even with intervening spaces.
	//   QU SP* × OP
	//
	// For more information on this rule, see the note in the description for
	// the QU class.
	if (/JH*$/.test(prev) && startsWith(next, 'N')) return -15;

	// LB16  Do not break between closing punctuation and a nonstarter (lb=NS),
	//       even with intervening spaces.
	//   (CL | CP) SP* × NS
	if (/[TO]H*$/.test(prev) && startsWith(next, '^')) return -16;

	// LB17  Do not break within ‘——’, even with intervening spaces.
	//   B2 SP* × B2
	if (/aH*$/.test(prev) && startsWith(next, 'a')) return -17;

	// LB18  Break after spaces.
	//   SP ÷
	if (endsWith(prev, 'H')) return 18;

	// LB19  Do not break before or after quotation marks, such as ‘ ” ’.
	//   × QU
	//   QU ×
	if (startsWith(next, 'J')) return -19;
	if (endsWith(prev, 'J')) return -19.1;

	// LB20  Break before and after unresolved CB.
	//   ÷ CB
	//   CB ÷
	//
	// Conditional breaks should be resolved external to the line breaking
	// rules. However, the default action is to treat unresolved CB as breaking
	// before and after.
	if (startsWith(next, 'j')) return 20;
	if (endsWith(prev, 'j')) return 20.1;

	// LB21  Do not break before hyphen-minus, other hyphens, fixed-width
	//       spaces, small kana, and other non-starters, or after acute accents.
	//   × BA
	//   × HY
	//   × NS
	//   BB ×
	if (startsWith(next, 'DQ^')) return -21;
	if (endsWith(prev, 'X')) return -21.1;

	// LB21a  Don't break after Hebrew + Hyphen.
	//   HL (HY | BA) ×
	if (/Y[QD]$/.test(prev)) return -21.2;

	// LB21b  Don’t break between Solidus and Hebrew letters.
	//   SY × HL
	if (endsWith(prev, 'R') && startsWith(next, 'Y')) return -21.3;

	// LB22  Do not break before ellipses.
	//   × IN
	//
	// Examples: ‘9...’, ‘a...’, ‘H...’
	if (startsWith(next, 'b')) return -22;

	// LB23  Do not break between digits and letters.
	//   (AL | HL) × NU
	//   NU × (AL | HL)
	if (endsWith(prev, 'KY') && startsWith(next, 'S')) return -23;
	if (endsWith(prev, 'S') && startsWith(next, 'KY')) return -23.1;

	// LB23a  Do not break between numeric prefixes and ideographs, or between
	//        ideographs and numeric postfixes.
	//   PR × (ID | EB | EM)
	//   (ID | EB | EM) × PO
	if (endsWith(prev, 'L') && startsWith(next, 'del')) return -23.2;
	if (endsWith(prev, 'del') && startsWith(next, 'M')) return -23.3;

	// LB24  Do not break between numeric prefix/postfix and letters, or
	//       between letters and prefix/postfix.
	//   (PR | PO) × (AL | HL)
	//   (AL | HL) × (PR | PO)
	//
	// In general, it is recommended to not break lines inside numbers of the
	// form described by the following regular expression:
	//
	// (PR | PO)? (OP | HY )? NU (NU | SY | IS)* (CL | CP)? (PR | PO)?
	//
	// Examples: $(12.35)    2,1234    (12)¢    12.54¢
	//
	// The default line breaking algorithm approximates this with the following
	// rule. Note that some cases have already been handled, such as ‘9,’, ‘[9’.
	// For a tailoring that supports the regular expression directly, as well
	// as a key to the notation see Section 8.2, Examples of Customization.
	if (endsWith(prev, 'LM') && startsWith(next, 'KY')) return -24;
	if (endsWith(prev, 'KY') && startsWith(next, 'LM')) return -24.1;

	/*
	// LB25  Do not break between the following pairs of classes relevant to
	//       numbers:
	//   CL × PO
	//   CP × PO
	//   CL × PR
	//   CP × PR
	//   NU × PO
	//   NU × PR
	//   PO × OP
	//   PO × NU
	//   PR × OP
	//   PR × NU
	//   HY × NU
	//   IS × NU
	//   NU × NU
	//   SY × NU
	//
	// Example pairs: ‘$9’, ‘$[’, ‘$-’, ‘-9’, ‘/9’, ‘99’, ‘,9’, ‘9%’ ‘]%’
	switch (prev.substr(-1) + next.substr(0, 1)) {
	case 'TM': return -25.00;
	case 'OM': return -25.01;
	case 'TL': return -25.02;
	case 'OL': return -25.03;
	case 'SM': return -25.04;
	case 'SL': return -25.05;
	case 'MN': return -25.06;
	case 'MS': return -25.07;
	case 'LN': return -25.08;
	case 'LS': return -25.09;
	case 'QS': return -25.10;
	case 'PS': return -25.11;
	case 'SS': return -25.12;
	case 'RS': return -25.13;
	}
	*/
	// LB25  Regex-Number: Do not break numbers.
	//   (PR | PO) × ( OP | HY )? NU
	//   ( OP | HY ) × NU
	//   NU × (NU | SY | IS)
	//   NU (NU | SY | IS)* × (NU | SY | IS | CL | CP )
	//   NU (NU | SY | IS)* (CL | CP)? × (PO | PR)
	if (endsWith(prev, 'LM') && /^[NQ]?S/.test(next)) return -25;
	if (endsWith(prev, 'NQ') && startsWith(next, 'S')) return -25.1;
	if (endsWith(prev, 'S') && startsWith(next, 'SRP')) return -25.2;
	if (/S[SRP]*$/.test(prev) && startsWith(next, 'SRPTO')) return -25.3;
	if (/S[SRP]*[TO]?$/.test(prev) && startsWith(next, 'ML')) return -25.4;

	// LB26  Do not break a Korean syllable.
	//   JL × (JL | JV | H2 | H3)
	//   (JV | H2) × (JV | JT)
	//   (JT | H3) × JT
	//
	// where the notation (JT | H3) means JT or H3. The effective line breaking
	// class for the syllable block matches the line breaking class for Hangul
	// syllables, which is ID by default. This is achieved by the following
	// rule:
	if (endsWith(prev, '[') && startsWith(next, '[\\gh')) return -26;
	if (endsWith(prev, '\\g') && startsWith(next, '\\]')) return -26.1;
	if (endsWith(prev, ']h') && startsWith(next, ']')) return -26.2;

	// LB27  Treat a Korean Syllable Block the same as ID.
	//   (JL | JV | JT | H2 | H3) × PO
	//   PR × (JL | JV | JT | H2 | H3)
	//
	// When Korean uses SPACE for line breaking, the classes in rule LB26, as
	// well as characters of class ID, are often tailored to AL; see Section 8,
	// Customization.
	if (endsWith(prev, '[\\]gh') && startsWith(next, 'M')) return -27;
	if (endsWith(prev, 'L') && startsWith(next, '[\\]gh')) return -27.1;

	// LB28  Do not break between alphabetics (“at”).
	//   (AL | HL) × (AL | HL)
	if (endsWith(prev, 'KY') && startsWith(next, 'KY')) return -28;

	// LB29  Do not break between numeric punctuation and alphabetics (“e.g.”).
	//   IS × (AL | HL)
	if (endsWith(prev, 'P') && startsWith(next, 'KY')) return -29;

	// LB30  Do not break between letters, numbers, or ordinary symbols and
	//       opening or closing parentheses.
	//   (AL | HL | NU) × [OP-[\p{ea=F}\p{ea=W}\p{ea=H}]]
	//   [CP-[\p{ea=F}\p{ea=W}\p{ea=H}]] × (AL | HL | NU)
	//
	// The purpose of this rule is to prevent breaks in common cases where a
	// part of a word appears between delimiters—for example, in “person(s)”.
	//
	// The excluded set ([\p{ea=F}\p{ea=W}\p{ea=H}]) refines the behavior of
	// this rule, to enable a break before an East Asian OP or after an East
	// Asian CP. Those cases are identified by excluding East_Asian_Width
	// values of Fullwidth, Wide, or Halfwidth. This is illustrated by the
	// following example, which shows East Asian corner brackets immediately
	// following a Latin letter in Japanese text. In such a case, the preferred
	// line break is between the Latin letter and the opening angle bracket.
	//
	//   Preferred              Bad Break
	//   -------------------    ------------------
	//   日中韓統合漢字拡張G    日中韓統合漢字拡張
	//   「ユニコード」         G「ユニコード」
	if (endsWith(prev, 'KYS') && startsWith(next, 'N')) {
		const eaw = eastAsianWidthFinder(nextcp);
		if (eaw != 5 && eaw != 3 && eaw != 4) return -30;
	}
	if (endsWith(prev, 'O') && startsWith(next, 'KYS')) {
		const eaw = eastAsianWidthFinder(prevcp);
		if (eaw != 5 && eaw != 3 && eaw != 4) return -30.1;
	}
	
	// LB30a  Break between two regional indicator symbols if and only if there
	//        are an even number of regional indicators preceding the position
	//        of the break.
	//   sot (RI RI)* RI × RI
	//   [^RI] (RI RI)* RI × RI
	if (/^(kk)*k$/.test(prev) && startsWith(next, 'k')) return -30.2;
	if (/[^k](kk)*k$/.test(prev) && startsWith(next, 'k')) return -30.3;

	// LB30b  Do not break between an emoji base (or potential emoji) and an
	//        emoji modifier.
	//   EB × EM
	//   [\p{Extended_Pictographic}&\p{Cn}] × EM
	if (endsWith(prev, 'e') && startsWith(next, 'l')) return -30.4;
	if (/\p{Extended_Pictographic}/u.test(String.fromCodePoint(prevcp))
	 && /\p{Cn}/u.test(String.fromCodePoint(prevcp))
	 && startsWith(next, 'l')) return -30.5;

	// LB31  Break everywhere else.
	//   ALL ÷
	//   ÷ ALL
	return 999;
}

function getColumnsFor (s, options = {}) {
	let result = 0;

	if (options.characterReference) {
		s = s.replace(/&#([xX])?([^;]+);/g, ($0, $1, $2) => {
			return String.fromCodePoint(parseInt($2, /^x/i.test($1) ? 16 : 10));
		})
	}

	if (options.ansi) {
		const pattern = /\u001b\[.*?[\u0040-\u007e]|\u001b[\]P].+?(?:\u0007|\u001b\\)|\u001b[\u0040-\u005f]/g;
		let re, plainIndex = 0;

		while ((re = pattern.exec(s)) !== null) {
			if (re.index > plainIndex) {
				result += getColumnsFor.plain(s.substring(plainIndex, re.index), options.awidth);
			}
			plainIndex = re.index + re[0].length;
		}

		if (plainIndex < s.length) {
			result += getColumnsFor.plain(s.substring(plainIndex), options.awidth);
		}
	}
	else {
		result += getColumnsFor.plain(s, options.awidth);
	}

	return result;
}

getColumnsFor.plain = (s, awidth) => {
	/*
	 * special handling of halfwidth katakana voiced/semi-voiced marks:
	 * should be considered as a single grapheme, not a modifier.
	 *
	 * TBD: there may be other characters that require special handling
	 */
	s = s.replace(/[\uff9e\uff9f]/g, '_');

	const oldawidth = eawMap[2];
	let result = 0;
	if (awidth) {
		eawMap[2] = awidth;
	}
	Unistring(s).forEach(clusters => {
		result += eawMap[eastAsianWidthFinder(clusters.codePoints[0])] || 0;
	});
	eawMap[2] = oldawidth;
	return result;
};

function normalizeHyperlinks (lines) {
	const pattern = /\x1b\]8;([^;]*);([^\x07]*)\x07/g;
	const lastLinkStart = {
		line: -1,
		index: -1,
		length: -1,
		p2: null,
		p3: null
	};

	for (let i = 0; i < lines.length; i++) {
		pattern.lastIndex = 0;

		let re;
		while ((re = pattern.exec(lines[i]))) {
			// found link start
			if (re[2] != '') {
				lastLinkStart.line = i;
				lastLinkStart.index = re.index;
				lastLinkStart.length = re[0].length;
				lastLinkStart.p2 = re[1].length ? re[1] : null;
				lastLinkStart.p3 = re[2].length ? re[2] : null;
			}

			// found link end
			else if (lastLinkStart.line >= 0) {
				// single line link
				if (lastLinkStart.line == i) {
					;
				}

				// multiple line link
				else {
					const {line, index, length, p2, p3} = lastLinkStart;
					const linkId = p2 || `id=_${Date.now()}_${linkCount++}`;
					const linkStart = `\x1b]8;${linkId};${p3}\x07`;
					const linkEnd = `\x1b]8;;\x07`;

					// update middle lines
					for (let j = i - 1; j > line; j--) {
						lines[j] = `${linkStart}${lines[j]}${linkEnd}`;
					}

					// update head line
					lines[line] =
						`${lines[line].substring(0, index)}${linkStart}${lines[line].substring(index + length)}${linkEnd}`;

					// update bottom line
					lines[i] = `${linkStart}${lines[i]}`;
					pattern.lastIndex += linkStart.length;
				}

				lastLinkStart.line = -1;
				lastLinkStart.index = -1;
				lastLinkStart.length = -1;
				lastLinkStart.p2 = null;
				lastLinkStart.p3 = null;
			}
		}
	}

	return lines;
}

function divideByColumns (s, columns, options = {}) {
	if (options.characterReference) {
		s = s.replace(/&#([xX])?([^;]+);/g, ($0, $1, $2) => {
			return String.fromCodePoint(parseInt($2, /^x/i.test($1) ? 16 : 10));
		})
	}

	if (columns <= 0) {
		return ['', s];
	}

	if (options.ansi) {
		const clusters = [];
		const pattern = /\u001b\[.*?[\u0040-\u007e]|\u001b[\]P].+?(?:\u0007|\u001b\\)|\u001b[\u0040-\u005f]/g;
		let re, plainIndex = 0;

		while ((re = pattern.exec(s)) !== null) {
			if (re.index > plainIndex) {
				Unistring(s.substring(plainIndex, re.index)).forEach(cluster => {
					clusters.push([
						cluster.rawString,
						getColumnsFor.plain(cluster.rawString, options.awidth)
					]);
				});
			}
			clusters.push([re[0], 0]);
			plainIndex = re.index + re[0].length;
		}

		if (plainIndex < s.length) {
			Unistring(s.substring(plainIndex)).forEach(cluster => {
				clusters.push([
					cluster.rawString,
					getColumnsFor.plain(cluster.rawString, options.awidth)
				]);
			});
		}

		let result = '';
		let leftColumns = 0;
		for (let i = 0; i < clusters.length; i++) {
			const graphemeColumn = clusters[i][1];
			if (leftColumns + graphemeColumn > columns) {
				return normalizeHyperlinks([
					clusters.slice(0, i).map(c => c[0]).join(''),
					clusters.slice(i).map(c => c[0]).join('')
				]);
			}
			leftColumns += graphemeColumn;
		}

		return [s, ''];
	}
	else {
		return divideByColumns.plain(s, columns, options.awidth);
	}
}

divideByColumns.plain = (s, columns, awidth) => {
	if (columns <= 0) {
		return ['', s];
	}

	let result = '';
	let leftColumns = 0;
	const u = Unistring(s);
	for (let i = 0; i < u.clusters.length; i++) {
		const grapheme = u.clusters[i];
		const graphemeColumn = getColumnsFor.plain(grapheme.rawString, awidth);
		if (leftColumns + graphemeColumn > columns) {
			return [
				u.slice(0, i).toString(),
				u.slice(i).toString()
			];
		}
		leftColumns += graphemeColumn;
	}

	return [s, ''];
};

function getLineBreakableClusters (s) {
	if (lineBreakableClusterCache.has(s)) {
		return lineBreakableClusterCache.get(s).map(c => {return {...c}});
	}
	else {
		const result = buildLineBreakableClusters(resolveSurrogates(s));
		lineBreakableClusterCache.set(s, result);
		return result;
	}
}

function getFoldedLines (s, options = {}) {
	function fetchPlainClusters (line) {
		const result = [];
		const clusters = getLineBreakableClusters(line);
		for (const cluster of clusters) {
			result.push([cluster.text, getColumnsFor.plain(cluster.text, options.awidth)]);
		}
		return result;
	}

	function fetchAnsiClusters (line) {
		const result = [];
		/*
		 * group 1: SGR reset sequence
		 *     ESC [ m
		 *
		 * group 2: SGR (Select Graphics Rendition) sequences
		 *     ESC [ ... m
		 *
		 * group 3-1: Other CSI (Control Sequence Introducer) sequences, except SGR
		 *     ESC [ ... <final byte>
		 *
		 * group 3-2: OSC (Operation System Command) sequences
		 *         or DCS (Device Control String) sequences
		 *   ST (String Terminator):
		 *     BEL | ( ESC \ )
		 *   OSC sequences
		 *     ESC ] ... ST
		 *   DCS sequences
		 *     ESC P ... ST
		 *
		 * group 3-3: Other Fe sequences, except OSC,DCS
		 *     ESC ... <final byte>
		 */
		const pattern = /(\u001b\[0*m)|(\u001b\[.*?m)|(\u001b\[.*?[\u0040-\u007e]|\u001b[\]P].+?(?:\u0007|\u001b\\)|\u001b[\u0040-\u005f])/g;
		let re, plainIndex = 0;

		while ((re = pattern.exec(line)) !== null) {
			if (re.index > plainIndex) {
				const clusters = getLineBreakableClusters(line.substring(plainIndex, re.index));
				for (const cluster of clusters) {
					result.push([cluster.text, getColumnsFor.plain(cluster.text, options.awidth)]);
				}
			}

			if (re[1]) {
				result.push([re[1], 0, 2]);
			}
			else if (re[2]) {
				result.push([re[2], 0, 1]);
			}
			else {
				result.push([re[3], 0]);
			}

			plainIndex = re.index + re[0].length;
		}

		if (plainIndex < line.length) {
			const clusters = getLineBreakableClusters(line.substring(plainIndex));
			for (const cluster of clusters) {
				result.push([cluster.text, getColumnsFor.plain(cluster.text, options.awidth)]);
			}
		}

		return result;
	}

	function fetchCharRefClusters (line) {
		return fetchPlainClusters(
			line.replace(/&#([xX])?([^;]+);/g, ($0, $1, $2) => {
				return String.fromCodePoint(parseInt($2, /^x/i.test($1) ? 16 : 10));
			})
		);
	}

	function fetchAnsiCharRefClusters (line) {
		return fetchAnsiClusters(
			line.replace(/&#([xX])?([^;]+);/g, ($0, $1, $2) => {
				return String.fromCodePoint(parseInt($2, /^x/i.test($1) ? 16 : 10));
			})
		);
	}

	function esc (s) {
		return s
			.replace(/[\x00-\x1f]/g, $0 => {
				return '\x1b[1;36m^' + String.fromCharCode($0.charCodeAt(0) + 64) + '\x1b[m';
			});
	}

	const columnsSource = options.columns || 80;
	const result = [];
	let fetchClusters = fetchPlainClusters;
	let fetchColumns;

	if (Array.isArray(columnsSource) && columnsSource.length) {
		fetchColumns = () => {
			const index = result.length;
			const columns = index < columnsSource.length ?
				columnsSource[index] :
				columnsSource[columnsSource.length - 1];
			return columns || options.fallbackColumns || 80;
		};
	}
	else {
		fetchColumns = () => columnsSource;
	}

	if (options.ansi && options.characterReference) {
		fetchClusters = fetchAnsiCharRefClusters;
	}
	else if (options.ansi) {
		fetchClusters = fetchAnsiClusters;
	}
	else if (options.characterReference) {
		fetchClusters = fetchCharRefClusters;
	}

	while (s != '') {
		let line = /^(.*?)(\r?\n)/.exec(s), newline;
		if (line) {
			s = s.substring(line[0].length);
			newline = line[2];
			line = line[1];
		}
		else {
			newline = '';
			line = s;
			s = '';
		}

		const breakableClusters = fetchClusters(line);
		let lineColumns = 0;
		let lineFragment = '';
		let sgrSequence = '';
		let columns = fetchColumns();
		for (let i = 0; i < breakableClusters.length; i++) {
			let [clusterText, clusterColumns] = breakableClusters[i];
			//console.log(`lineFragment: "${esc(lineFragment)}", clusterText: "${esc(clusterText)}", lineColumns: ${lineColumns}, clusterColumns: ${clusterColumns}`);

			if (clusterColumns == 0) {
				switch (breakableClusters[i][2]) {
				case 1:
					sgrSequence += clusterText;
					break;
				case 2:
					sgrSequence = '';
					break;
				}
			}
			if (lineColumns + clusterColumns > columns) {
				if (clusterColumns > columns) {
					let [lead, rest] = divideByColumns.plain(
						clusterText,
						columns - lineColumns, options.awidth);
					if (sgrSequence !== '') {
						result.push(lineFragment + lead + '\u001b[m');
					}
					else {
						result.push(lineFragment + lead);
					}
					if (rest != '') {
						breakableClusters.splice(
							i + 1, 0,
							[rest, getColumnsFor.plain(rest, options.awidth)]);
					}
					lineColumns = 0;
					lineFragment = sgrSequence;
				}
				else {
					if (sgrSequence !== '') {
						result.push(lineFragment + '\u001b[m');
					}
					else {
						result.push(lineFragment);
					}
					lineColumns = clusterColumns;
					lineFragment = sgrSequence + clusterText;
				}
				columns = fetchColumns();
			}
			else {
				lineColumns += clusterColumns;
				lineFragment += clusterText;
			}
		}

		if (lineFragment !== '') {
			result.push(lineFragment);
		}

		if (newline !== '') {
			if (result.length && breakableClusters.length) {
				result[result.length - 1] += newline;
			}
			else {
				result.push(newline);
			}
		}
	}

	return options.ansi ? normalizeHyperlinks(result) : result;
}

/*
 * Grapheme class
 */

function Grapheme (codePoints, rawIndex) {
	if (codePoints != undefined) {
		this.codePoints = codePoints;
		this.updateRawString();
	}
	if (rawIndex != undefined) {
		this.rawIndex = rawIndex;
	}
}

Grapheme.prototype = {
	toString: function () {
		return this.rawString;
	},
	clone: function () {
		const result = new Grapheme;
		result.codePoints = this.codePoints.slice();
		result.rawString = this.rawString;
		result.rawIndex = this.rawIndex;
		return result;
	},
	updateRawString: function () {
		this.rawString = this.codePoints.reduce((result, cp) => {
			return result + getUTF16FromCodePoint(cp);
		}, '');
	},
	dump: function (detail) {
		if (detail) {
			const log = [];
			log.push('codePoints: [' + this.codePoints.map(cp => {
				return getCodePointString(cp, 'unicode');
			}).join(', ') + ']');
			log.push('  rawIndex: ' + this.rawIndex);
			log.push(' rawString: (' + this.rawString.length + ') "' + this.rawString + '"');
			return log.join('\n');
		}
		else {
			return this.codePoints
				.map(getCodePointString)
				.join(' × ');
		}
	}
};

/*
 * Unistring class
 */

function Unistring (s) {
	if (!(this instanceof Unistring)) {
		return new Unistring(s);
	}
	if (typeof s == 'string') {
		if (graphemeClusterCache.has(s)) {
			this.clusters = graphemeClusterCache.get(s).map(g => g.clone());
		}
		else {
			graphemeClusterCache.set(
				s, this.clusters = buildGraphemeClusters(resolveSurrogates(s)));
		}
	}
	else if (s instanceof Array) {
		this.clusters = [];
		let rawIndex = 0;
		for (let i = 0, goal = s.length; i < goal; i++) {
			if (!(s[i] instanceof Grapheme)) {
				throw new Error(
					'Unistring: invalid cluster class: ' +
					Object.prototype.toString.call(s[i]));
			}
			this.clusters[i] = s[i].clone();
			this.clusters[i].rawIndex = rawIndex;
			rawIndex += this.clusters[i].rawString.length;
		}
	}
	else {
		throw new Error('Unistring: invalid argument');
	}
}

Unistring.prototype = {
	_ensureIndex: function (index, isEnd) {
		if (index == undefined) {
			index = isEnd ? this.clusters.length : 0;
		}
		if (index < 0) {
			index = this.clusters.length + index;
		}
		return Math.max(0, Math.min(index, this.clusters.length));
	},
	_toUnistring: function (s, caller) {
		if (typeof s == 'string') {
			return new Unistring(s);
		}
		else if (s instanceof Unistring) {
			return s;
		}
		else {
			throw new Error(
				'Unistring#' + (caller || '') + ': invalid argument');
		}
	},

	/*
	 * methods
	 */

	clone: function () {
		return new Unistring(this.clusters.slice());
	},
	dump: function (detail) {
		const log = [];
		if (detail) {
			this.clusters.forEach((g, index) => {
				log.push('*** Grapheme Cluster #' + index + ' ***');
				log.push(g.dump(detail));
			});
			return log.join('\n');
		}
		else {
			return '÷ ' + this.clusters
				.map(g => g.dump(detail))
				.join(' ÷ ') + ' ÷';
		}
	},
	toString: function () {
		return this.clusters.reduce((result, g) => result + g.toString(), '');
	},
	delete: function (start, length) {
		start = this._ensureIndex(start);
		if (length == undefined || start + length > this.clusters.length) {
			length = this.clusters.length - start;
		}
		length = Math.max(0, length);

		let delta = 0;
		for (let i = start, goal = start + length; i < goal; i++) {
			delta += this.clusters[i].rawString.length;
		}
		for (let i = start + length, goal = this.clusters.length; i < goal; i++) {
			this.clusters[i].rawIndex -= delta;
		}

		this.clusters.splice(start, length);
		return this;
	},
	insert: function (s, start) {
		start = this._ensureIndex(start);
		s = this._toUnistring(s, 'insert').clusters.slice();

		let srcDelta = 0;
		let dstDelta = 0;
		if (start == this.clusters.length) {
			if (this.clusters.length) {
				const last = this.clusters.length - 1;
				srcDelta = this.clusters[last].rawIndex +
					this.clusters[last].rawString.length;
			}
		}
		else {
			srcDelta = this.clusters[start].rawIndex;
		}

		for (let i = 0, goal = s.length; i < goal; i++) {
			s[i].rawIndex += srcDelta;
			dstDelta += s[i].rawString.length;
		}
		for (let i = start, goal = this.clusters.length; i < goal; i++) {
			this.clusters[i].rawIndex += dstDelta;
		}

		s.unshift(start, 0);
		this.clusters.splice.apply(this.clusters, s);
		return this;
	},
	append: function (s) {
		return this.insert(s, this.clusters.length);
	},
	codePointsAt: function (index) {
		index = this._ensureIndex(index);
		if (index < 0 || index >= this.clusters.length) return undefined;
		return this.clusters[index].codePoints;
	},
	clusterAt: function (index) {
		return this.rawStringAt.apply(this, arguments);
	},
	rawStringAt: function (index) {
		index = this._ensureIndex(index);
		if (index < 0 || index >= this.clusters.length) return '';
		return this.clusters[index].rawString;
	},
	rawIndexAt: function (index) {
		index = this._ensureIndex(index);
		if (index < 0 || this.clusters.length == 0 || index > this.clusters.length) return NaN;
		if (index == this.clusters.length) {
			return this.clusters[index - 1].rawIndex +
				this.clusters[index - 1].rawString.length;
		}
		return this.clusters[index].rawIndex;
	},
	forEach: function () {
		this.clusters.forEach.apply(this.clusters, arguments);
	},
	map: function () {
		return this.clusters.map.apply(this.clusters, arguments);
	},
	getClusterIndexFromUTF16Index: function (index) {
		let left = 0, right = this.clusters.length - 1;
		let middle, rawIndex, length;

		if (right >= 0 && index == this.clusters[right].rawIndex + this.clusters[right].rawString.length) {
			return right + 1;
		}

		while (left <= right) {
			middle = ((left + right) / 2) >> 0;

			rawIndex = this.clusters[middle].rawIndex;
			length = this.clusters[middle].rawString.length;

			if (rawIndex + length - 1 < index) {
				left = middle + 1;
			}
			else if (index < rawIndex) {
				right = middle - 1;
			}
			else {
				return middle;
			}
		}

		return -1;
	},

	/*
	 * string like properties and methods
	 */

	get length () {
		return this.clusters.length;
	},
	charAt: function (index) {
		if (index < 0 || index >= this.clusters.length) return '';
		return this.clusters[index].rawString.charAt(0);
	},
	charCodeAt: function (index) {
		if (index < 0 || index >= this.clusters.length) return NaN;
		return this.clusters[index].codePoints[0];
	},
	substring: function (start, end) {
		if (start == undefined) {
			start = 0;
		}
		if (end == undefined) {
			end = this.clusters.length;
		}
		start = Math.max(0, Math.min(start, this.clusters.length));
		end = Math.max(0, Math.min(end, this.clusters.length));
		if (start > end) {
			const tmp = start;
			start = end;
			end = tmp;
		}
		return new Unistring(this.clusters.slice(start, end));
	},
	substr: function (start, length) {
		start = this._ensureIndex(start);
		if (length == undefined || start + length > this.clusters.length) {
			length = this.clusters.length - start;
		}
		if (length < 0) {
			length = 0;
		}
		return new Unistring(this.clusters.slice(start, start + length));
	},
	slice: function (start, end) {
		start = this._ensureIndex(start);
		end = this._ensureIndex(end, true);
		return new Unistring(this.clusters.slice(start, end));
	},
	concat: function (s) {
		return this.insert(s, this.clusters.length);
	},
	indexOf: function (s) {
		s = this._toUnistring(s, 'indexOf');

		const whole = this.toString();
		const part = s.toString();
		let rawIndex = 0;
		let clusterIndex = 0;

		while ((rawIndex = whole.indexOf(part, rawIndex)) >= 0) {
			while (clusterIndex < this.clusters.length
				   && this.clusters[clusterIndex].rawIndex < rawIndex) {
				clusterIndex++;
			}

			if (clusterIndex >= this.clusters.length) {
				return -1;
			}

			if (this.substr(clusterIndex, s.length).toString() == part) {
				return clusterIndex;
			}

			rawIndex++;
		}

		return -1;
	},
	lastIndexOf: function (s) {
		s = this._toUnistring(s, 'lastIndexOf');

		const whole = this.toString();
		const part = s.toString();
		let rawIndex = whole.length - 1;
		let clusterIndex = this.clusters.length - 1;

		while (rawIndex >= 0
			   && (rawIndex = whole.lastIndexOf(part, rawIndex)) >= 0) {
			while (clusterIndex >= 0
				   && this.clusters[clusterIndex].rawIndex > rawIndex) {
				clusterIndex--;
			}

			if (clusterIndex < 0) {
				return -1;
			}

			if (this.substr(clusterIndex, s.length).toString() == part) {
				return clusterIndex;
			}

			rawIndex--;
		}

		return -1;
	},
	toLowerCase: function (useLocale) {
		const method = useLocale && 'toLocaleLowerCase' in String.prototype ?
			'toLocaleLowerCase' : 'toLowerCase';
		return new Unistring(this.toString()[method]());
	},
	toUpperCase: function (useLocale) {
		const method = useLocale && 'toLocaleUpperCase' in String.prototype ?
			'toLocaleUpperCase' : 'toUpperCase';
		return new Unistring(this.toString()[method]());
	}
};

/*
 * exporting
 */

Object.defineProperties(Unistring, {
	getCodePointArray: {value: resolveSurrogates},
	getUTF16FromCodePoint: {value: getUTF16FromCodePoint},
	getCodePointString: {value: getCodePointString},

	getGraphemeBreakProp: {value: graphemeFinder},
	getWordBreakProp: {value: wordFinder},
	getSentenceBreakProp: {value: sentenceFinder},
	getScriptProp: {value: scriptFinder},
	getLineBreakProp: {value: lineBreakFinder},
	getEAWProp: {value: eastAsianWidthFinder},

	getWords: {value: getWords},
	getSentences: {value: getSentences},
	getLineBreakableClusters: {value: getLineBreakableClusters},

	getColumnsFor: {value: getColumnsFor},
	divideByColumns: {value: divideByColumns},
	getFoldedLines: {value: getFoldedLines},

	GBP: {value: GBP},
	WBP: {value: WBP},
	SBP: {value: SBP},
	SCRIPT: {value: SCRIPT},
	LBP: {value: LBP},
	EAW: {value: EAW},

	GBP_NAMES: {value: GBP_NAMES},
	WBP_NAMES: {value: WBP_NAMES},
	SBP_NAMES: {value: SBP_NAMES},
	SCRIPT_NAMES: {value: SCRIPT_NAMES},
	LBP_NAMES: {value: LBP_NAMES},
	EAW_NAMES: {value: EAW_NAMES},

	awidth: {
		get: () => {
			return eawMap[2];
		},
		set: value => {
			if (value === 1 || value === 2) {
				eawMap[2] = value;
			}
		}
	},
	printCacheStatus: {
		value: () => {
			console.log([
				`clusterCache.size: ${clusterCache.size}`,
				`    request count: ${clusterCacheRequestCount}`,
				`        hit count: ${clusterCacheHitCount}`,
				`       miss count: ${clusterCacheMissCount}`
			].join('\n'));
		}
	}
});

export default Unistring;

// vim:set ts=4 sw=4 fenc=UTF-8 ff=unix ft=javascript fdm=marker fmr=<<<,>>> :
