enum MetadataSyntheticField {
  aperture,
  description,
  exposureTime,
  focalLength,
  iso,
}

enum MetadataField {
  // exif
  exifDate,
  exifDateOriginal,
  exifDateDigitized,
  exifGpsAltitude,
  exifGpsAltitudeRef,
  exifGpsAreaInformation,
  exifGpsDatestamp,
  exifGpsDestBearing,
  exifGpsDestBearingRef,
  exifGpsDestDistance,
  exifGpsDestDistanceRef,
  exifGpsDestLatitude,
  exifGpsDestLatitudeRef,
  exifGpsDestLongitude,
  exifGpsDestLongitudeRef,
  exifGpsDifferential,
  exifGpsDOP,
  exifGpsHPositioningError,
  exifGpsImgDirection,
  exifGpsImgDirectionRef,
  exifGpsLatitude,
  exifGpsLatitudeRef,
  exifGpsLongitude,
  exifGpsLongitudeRef,
  exifGpsMapDatum,
  exifGpsMeasureMode,
  exifGpsProcessingMethod,
  exifGpsSatellites,
  exifGpsSpeed,
  exifGpsSpeedRef,
  exifGpsStatus,
  exifGpsTimestamp,
  exifGpsTrack,
  exifGpsTrackRef,
  exifGpsVersionId,
  exifImageDescription,
  exifMake,
  exifModel,
  exifUserComment,
  // mp4
  mp4GpsCoordinates,
  mp4RotationDegrees,
  mp4Xmp,
  // xmp
  xmpXmpCreateDate,
  // file
  hashMd5,
  hashSha1,
  hashSha256,
}

class MetadataFields {
  static const Set<MetadataField> exifGpsFields = {
    MetadataField.exifGpsAltitude,
    MetadataField.exifGpsAltitudeRef,
    MetadataField.exifGpsAreaInformation,
    MetadataField.exifGpsDatestamp,
    MetadataField.exifGpsDestBearing,
    MetadataField.exifGpsDestBearingRef,
    MetadataField.exifGpsDestDistance,
    MetadataField.exifGpsDestDistanceRef,
    MetadataField.exifGpsDestLatitude,
    MetadataField.exifGpsDestLatitudeRef,
    MetadataField.exifGpsDestLongitude,
    MetadataField.exifGpsDestLongitudeRef,
    MetadataField.exifGpsDifferential,
    MetadataField.exifGpsDOP,
    MetadataField.exifGpsHPositioningError,
    MetadataField.exifGpsImgDirection,
    MetadataField.exifGpsImgDirectionRef,
    MetadataField.exifGpsLatitude,
    MetadataField.exifGpsLatitudeRef,
    MetadataField.exifGpsLongitude,
    MetadataField.exifGpsLongitudeRef,
    MetadataField.exifGpsMapDatum,
    MetadataField.exifGpsMeasureMode,
    MetadataField.exifGpsProcessingMethod,
    MetadataField.exifGpsSatellites,
    MetadataField.exifGpsSpeed,
    MetadataField.exifGpsSpeedRef,
    MetadataField.exifGpsStatus,
    MetadataField.exifGpsTimestamp,
    MetadataField.exifGpsTrack,
    MetadataField.exifGpsTrackRef,
    MetadataField.exifGpsVersionId,
  };
}
