class Language {
  final String iso639_2, name;
  final String? native;

  const Language({
    required this.iso639_2,
    required this.name,
    this.native,
  });

  // subset of ISO 639-2 codes for living languages (including macrolanguages, excluding constructed and collective ones)
  // synonyms for terminology and bibliographic applications (ISO 639-2/T and ISO 639-2/B) are separate entries
  // some entries have been simplified to keep only one name for one code
  static const living639_2 = [
    Language(iso639_2: 'aar', name: 'Afar', native: 'Qafaraf; ’Afar Af; Afaraf; Qafar af'),
    Language(iso639_2: 'abk', name: 'Abkhazian', native: 'Аҧсуа бызшәа Aƥsua bızšwa; Аҧсшәа Aƥsua'),
    Language(iso639_2: 'ace', name: 'Achinese', native: 'بهسا اچيه'),
    Language(iso639_2: 'ach', name: 'Acoli', native: 'Lwo'),
    Language(iso639_2: 'ada', name: 'Adangme', native: 'Dangme'),
    Language(iso639_2: 'ady', name: 'Adyghe; Adygei', native: 'Адыгабзэ; Кӏахыбзэ'),
    Language(iso639_2: 'afr', name: 'Afrikaans', native: 'Afrikaans'),
    Language(iso639_2: 'ain', name: 'Ainu', native: 'アイヌ・イタㇰ Ainu-itak'),
    Language(iso639_2: 'aka', name: 'Akan', native: 'Akan'),
    Language(iso639_2: 'ale', name: 'Aleut', native: 'Уна́ӈам тунуу́; Унаӈан умсуу'),
    Language(iso639_2: 'alt', name: 'Southern Altai', native: 'Алтай тили'),
    Language(iso639_2: 'amh', name: 'Amharic', native: 'አማርኛ Amârıñâ'),
    Language(iso639_2: 'anp', name: 'Angika'),
    Language(iso639_2: 'ara', name: 'Arabic', native: 'العربية'),
    Language(iso639_2: 'arg', name: 'Aragonese', native: 'aragonés'),
    Language(iso639_2: 'arn', name: 'Mapudungun; Mapuche'),
    Language(iso639_2: 'arp', name: 'Arapaho', native: 'Hinónoʼeitíít'),
    Language(iso639_2: 'arw', name: 'Arawak', native: 'Lokono'),
    Language(iso639_2: 'asm', name: 'Assamese', native: 'অসমীয়া'),
    Language(iso639_2: 'ast', name: 'Asturian', native: 'asturianu'),
    Language(iso639_2: 'ava', name: 'Avaric', native: 'Магӏарул мацӏ; Авар мацӏ'),
    Language(iso639_2: 'awa', name: 'Awadhi', native: 'अवधी'),
    Language(iso639_2: 'aym', name: 'Aymara', native: 'Aymar aru'),
    Language(iso639_2: 'aze', name: 'Azerbaijani', native: 'Azərbaycan dili; آذربایجان دیلی; Азәрбајҹан дили'),
    Language(iso639_2: 'bak', name: 'Bashkir', native: 'Башҡорт теле; Başqort tele'),
    Language(iso639_2: 'bal', name: 'Baluchi', native: 'بلوچی'),
    Language(iso639_2: 'bam', name: 'Bambara', native: 'ߓߊߡߊߣߊߣߞߊߣ'),
    Language(iso639_2: 'ban', name: 'Balinese', native: 'ᬪᬵᬱᬩᬮᬶ; ᬩᬲᬩᬮᬶ; Basa Bali'),
    Language(iso639_2: 'bas', name: 'Basa', native: 'Mbene; Ɓasaá'),
    Language(iso639_2: 'bej', name: 'Beja; Bedawiyet', native: 'Bidhaawyeet'),
    Language(iso639_2: 'bel', name: 'Belarusian', native: 'Беларуская мова Belaruskaâ mova'),
    Language(iso639_2: 'bem', name: 'Bemba', native: 'Chibemba'),
    Language(iso639_2: 'ben', name: 'Bengali', native: 'বাংলা Bāŋlā'),
    Language(iso639_2: 'bho', name: 'Bhojpuri', native: 'भोजपुरी'),
    Language(iso639_2: 'bik', name: 'Bikol'),
    Language(iso639_2: 'bin', name: 'Bini; Edo', native: 'Ẹ̀dó'),
    Language(iso639_2: 'bis', name: 'Bislama'),
    Language(iso639_2: 'bla', name: 'Siksika', native: 'ᓱᖽᐧᖿ'),
    Language(iso639_2: 'bod', name: 'Tibetan', native: 'བོད་སྐད་; ལྷ་སའི་སྐད་'),
    Language(iso639_2: 'tib', name: 'Tibetan', native: 'བོད་སྐད་; ལྷ་སའི་སྐད་'),
    Language(iso639_2: 'bos', name: 'Bosnian', native: 'bosanski'),
    Language(iso639_2: 'bra', name: 'Braj'),
    Language(iso639_2: 'bre', name: 'Breton', native: 'Brezhoneg'),
    Language(iso639_2: 'bua', name: 'Buriat', native: 'буряад хэлэн'),
    Language(iso639_2: 'bug', name: 'Buginese', native: 'ᨅᨔ ᨕᨘᨁᨗ'),
    Language(iso639_2: 'bul', name: 'Bulgarian', native: 'български'),
    Language(iso639_2: 'byn', name: 'Blin; Bilin', native: 'ብሊና; ብሊን'),
    Language(iso639_2: 'cad', name: 'Caddo', native: 'Hasí:nay'),
    Language(iso639_2: 'car', name: 'Galibi Carib', native: 'Kari\'nja'),
    Language(iso639_2: 'cat', name: 'Catalan', native: 'català'),
    Language(iso639_2: 'ceb', name: 'Cebuano', native: 'Sinugbuanong Binisayâ'),
    Language(iso639_2: 'ces', name: 'Czech', native: 'čeština'),
    Language(iso639_2: 'cze', name: 'Czech', native: 'čeština'),
    Language(iso639_2: 'cha', name: 'Chamorro', native: 'Finu\' Chamoru'),
    Language(iso639_2: 'che', name: 'Chechen', native: 'Нохчийн мотт; نَاخچیین موٓتت; ნახჩიე მუოთთ'),
    Language(iso639_2: 'chk', name: 'Chuukese'),
    Language(iso639_2: 'chm', name: 'Mari', native: 'марий йылме'),
    Language(iso639_2: 'chn', name: 'Chinook jargon', native: 'chinuk wawa; wawa; chinook lelang; lelang'),
    Language(iso639_2: 'cho', name: 'Choctaw', native: 'Chahta\''),
    Language(iso639_2: 'chp', name: 'Chipewyan; Dene Suline', native: 'ᑌᓀᓱᒼᕄᓀ (Dënesųłiné)'),
    Language(iso639_2: 'chr', name: 'Cherokee', native: 'ᏣᎳᎩ ᎦᏬᏂᎯᏍᏗ Tsalagi gawonihisdi'),
    Language(iso639_2: 'chv', name: 'Chuvash', native: 'Чӑвашла'),
    Language(iso639_2: 'chy', name: 'Cheyenne', native: 'Tsėhésenėstsestȯtse'),
    Language(iso639_2: 'cnr', name: 'Montenegrin', native: 'crnogorski / црногорски'),
    Language(iso639_2: 'cor', name: 'Cornish', native: 'Kernowek'),
    Language(iso639_2: 'cos', name: 'Corsican', native: 'Corsu; Lingua corsa'),
    Language(iso639_2: 'cre', name: 'Cree'),
    Language(iso639_2: 'crh', name: 'Crimean Tatar; Crimean Turkish', native: 'Къырымтатарджа; Къырымтатар тили; Ҡырымтатарҗа; Ҡырымтатар тили'),
    Language(iso639_2: 'csb', name: 'Kashubian', native: 'Kaszëbsczi jãzëk'),
    Language(iso639_2: 'cym', name: 'Welsh', native: 'Cymraeg; y Gymraeg'),
    Language(iso639_2: 'wel', name: 'Welsh', native: 'Cymraeg; y Gymraeg'),
    Language(iso639_2: 'dak', name: 'Dakota', native: 'Dakhótiyapi; Dakȟótiyapi'),
    Language(iso639_2: 'dan', name: 'Danish', native: 'dansk'),
    Language(iso639_2: 'dar', name: 'Dargwa', native: 'дарган мез'),
    Language(iso639_2: 'del', name: 'Delaware'),
    Language(iso639_2: 'den', name: 'Slave (Athapascan)', native: 'Dene K\'e'),
    Language(iso639_2: 'deu', name: 'German', native: 'Deutsch'),
    Language(iso639_2: 'ger', name: 'German', native: 'Deutsch'),
    Language(iso639_2: 'dgr', name: 'Dogrib'),
    Language(iso639_2: 'din', name: 'Dinka', native: 'Thuɔŋjäŋ'),
    Language(iso639_2: 'div', name: 'Divehi; Dhivehi; Maldivian', native: 'ދިވެހި; ދިވެހިބަސް Divehi'),
    Language(iso639_2: 'doi', name: 'Dogri', native: '𑠖𑠵𑠌𑠤𑠮; डोगरी; ڈوگرى'),
    Language(iso639_2: 'dsb', name: 'Lower Sorbian', native: 'Dolnoserbski; Dolnoserbšćina'),
    Language(iso639_2: 'dua', name: 'Duala'),
    Language(iso639_2: 'dyu', name: 'Dyula', native: 'Julakan'),
    Language(iso639_2: 'dzo', name: 'Dzongkha', native: 'རྫོང་ཁ་ Ĵoŋkha'),
    Language(iso639_2: 'efi', name: 'Efik'),
    Language(iso639_2: 'eka', name: 'Ekajuk'),
    Language(iso639_2: 'ell', name: 'Greek', native: 'Ελληνικά'),
    Language(iso639_2: 'gre', name: 'Greek', native: 'Ελληνικά'),
    Language(iso639_2: 'eng', name: 'English', native: 'English'),
    Language(iso639_2: 'est', name: 'Estonian', native: 'eesti'),
    Language(iso639_2: 'eus', name: 'Basque', native: 'euskara'),
    Language(iso639_2: 'baq', name: 'Basque', native: 'euskara'),
    Language(iso639_2: 'ewe', name: 'Ewe', native: 'Èʋegbe'),
    Language(iso639_2: 'ewo', name: 'Ewondo'),
    Language(iso639_2: 'fan', name: 'Fang'),
    Language(iso639_2: 'fao', name: 'Faroese', native: 'føroyskt'),
    Language(iso639_2: 'fas', name: 'Persian', native: 'فارسی'),
    Language(iso639_2: 'per', name: 'Persian', native: 'فارسی'),
    Language(iso639_2: 'fat', name: 'Fanti', native: 'Mfantse; Fante; Fanti'),
    Language(iso639_2: 'fij', name: 'Fijian', native: 'Na Vosa Vakaviti'),
    Language(iso639_2: 'fil', name: 'Filipino; Pilipino', native: 'Wikang Filipino'),
    Language(iso639_2: 'fin', name: 'Finnish', native: 'suomi'),
    Language(iso639_2: 'fon', name: 'Fon', native: 'Fon gbè'),
    Language(iso639_2: 'fra', name: 'French', native: 'français'),
    Language(iso639_2: 'fre', name: 'French', native: 'français'),
    Language(iso639_2: 'frr', name: 'Northern Frisian', native: 'Frasch; Fresk; Freesk; Friisk'),
    Language(iso639_2: 'frs', name: 'East Frisian Low Saxon', native: 'Oostfreesk; Plattdüütsk'),
    Language(iso639_2: 'fry', name: 'Western Frisian', native: 'Frysk'),
    Language(iso639_2: 'ful', name: 'Fulah', native: 'Fulfulde; Pulaar; Pular'),
    Language(iso639_2: 'fur', name: 'Friulian', native: 'Furlan'),
    Language(iso639_2: 'gaa', name: 'Ga', native: 'Gã'),
    Language(iso639_2: 'gay', name: 'Gayo', native: 'Basa Gayo'),
    Language(iso639_2: 'gba', name: 'Gbaya'),
    Language(iso639_2: 'gil', name: 'Gilbertese', native: 'Taetae ni Kiribati'),
    Language(iso639_2: 'gla', name: 'Gaelic; Scottish Gaelic', native: 'Gàidhlig'),
    Language(iso639_2: 'gle', name: 'Irish', native: 'Gaeilge'),
    Language(iso639_2: 'glg', name: 'Galician', native: 'galego'),
    Language(iso639_2: 'glv', name: 'Manx', native: 'Gaelg; Gailck'),
    Language(iso639_2: 'gon', name: 'Gondi'),
    Language(iso639_2: 'gor', name: 'Gorontalo', native: 'Bahasa Hulontalo'),
    Language(iso639_2: 'grb', name: 'Grebo'),
    Language(iso639_2: 'grn', name: 'Guarani', native: 'Avañe\'ẽ'),
    Language(iso639_2: 'gsw', name: 'Swiss German; Alemannic; Alsatian', native: 'Schwiizerdütsch'),
    Language(iso639_2: 'guj', name: 'Gujarati', native: 'ગુજરાતી Gujarātī'),
    Language(iso639_2: 'gwi', name: 'Gwich\'in', native: 'Dinjii Zhu’ Ginjik'),
    Language(iso639_2: 'hai', name: 'Haida', native: 'X̱aat Kíl; X̱aadas Kíl; X̱aayda Kil; Xaad kil'),
    Language(iso639_2: 'hat', name: 'Haitian; Haitian Creole', native: 'kreyòl ayisyen'),
    Language(iso639_2: 'hau', name: 'Hausa', native: 'Harshen Hausa; هَرْشَن'),
    Language(iso639_2: 'haw', name: 'Hawaiian', native: 'ʻŌlelo Hawaiʻi'),
    Language(iso639_2: 'heb', name: 'Hebrew', native: 'עברית'),
    Language(iso639_2: 'her', name: 'Herero', native: 'Otjiherero'),
    Language(iso639_2: 'hil', name: 'Hiligaynon', native: 'Ilonggo'),
    Language(iso639_2: 'hin', name: 'Hindi', native: 'हिन्दी Hindī'),
    Language(iso639_2: 'hmn', name: 'Hmong; Mong', native: 'lus Hmoob; lug Moob; lol Hmongb; 𖬇𖬰𖬞 𖬌𖬣𖬵'),
    Language(iso639_2: 'hmo', name: 'Hiri Motu'),
    Language(iso639_2: 'hrv', name: 'Croatian', native: 'hrvatski'),
    Language(iso639_2: 'hsb', name: 'Upper Sorbian', native: 'hornjoserbšćina'),
    Language(iso639_2: 'hun', name: 'Hungarian', native: 'magyar'),
    Language(iso639_2: 'hup', name: 'Hupa', native: 'Na:tinixwe Mixine:whe\''),
    Language(iso639_2: 'hye', name: 'Armenian', native: 'Հայերէն; Հայերեն'),
    Language(iso639_2: 'arm', name: 'Armenian', native: 'Հայերէն; Հայերեն'),
    Language(iso639_2: 'iba', name: 'Iban', native: 'Jaku Iban'),
    Language(iso639_2: 'ibo', name: 'Igbo', native: 'Asụsụ Igbo'),
    Language(iso639_2: 'iii', name: 'Sichuan Yi; Nuosu', native: 'ꆈꌠꉙ'),
    Language(iso639_2: 'iku', name: 'Inuktitut', native: 'ᐃᓄᒃᑎᑐᑦ'),
    Language(iso639_2: 'ilo', name: 'Iloko', native: 'Pagsasao nga Ilokano; Ilokano'),
    Language(iso639_2: 'ind', name: 'Indonesian', native: 'Bahasa Indonesia'),
    Language(iso639_2: 'inh', name: 'Ingush', native: 'ГӀалгӀай мотт'),
    Language(iso639_2: 'ipk', name: 'Inupiaq', native: 'Iñupiaq'),
    Language(iso639_2: 'isl', name: 'Icelandic', native: 'íslenska'),
    Language(iso639_2: 'ice', name: 'Icelandic', native: 'íslenska'),
    Language(iso639_2: 'ita', name: 'Italian', native: 'italiano'),
    Language(iso639_2: 'jav', name: 'Javanese', native: 'ꦧꦱꦗꦮ / Basa Jawa'),
    Language(iso639_2: 'jpn', name: 'Japanese', native: '日本語'),
    Language(iso639_2: 'jpr', name: 'Judeo-Persian', native: 'Dzhidi'),
    Language(iso639_2: 'jrb', name: 'Judeo-Arabic', native: 'عربية يهودية / ערבית יהודית'),
    Language(iso639_2: 'kaa', name: 'Kara-Kalpak', native: 'Qaraqalpaq tili; Қарақалпақ тили'),
    Language(iso639_2: 'kab', name: 'Kabyle', native: 'Tamaziɣt Taqbaylit; Tazwawt'),
    Language(iso639_2: 'kac', name: 'Kachin; Jingpho', native: 'Jingpho'),
    Language(iso639_2: 'kal', name: 'Kalaallisut; Greenlandic'),
    Language(iso639_2: 'kam', name: 'Kamba'),
    Language(iso639_2: 'kan', name: 'Kannada', native: 'ಕನ್ನಡ Kannađa'),
    Language(iso639_2: 'kas', name: 'Kashmiri', native: 'कॉशुर / كأشُر'),
    Language(iso639_2: 'kat', name: 'Georgian', native: 'ქართული'),
    Language(iso639_2: 'geo', name: 'Georgian', native: 'ქართული'),
    Language(iso639_2: 'kau', name: 'Kanuri'),
    Language(iso639_2: 'kaz', name: 'Kazakh', native: 'қазақ тілі qazaq tili; қазақша qazaqşa'),
    Language(iso639_2: 'kbd', name: 'Kabardian', native: 'Адыгэбзэ (Къэбэрдейбзэ) Adıgăbză (Qăbărdeĭbză)'),
    Language(iso639_2: 'kha', name: 'Khasi', native: 'কা কতিয়েন খাশি'),
    Language(iso639_2: 'khm', name: 'Central Khmer', native: 'ភាសាខ្មែរ Phiəsaakhmær'),
    Language(iso639_2: 'kik', name: 'Kikuyu; Gikuyu', native: 'Gĩkũyũ'),
    Language(iso639_2: 'kin', name: 'Kinyarwanda', native: 'Ikinyarwanda'),
    Language(iso639_2: 'kir', name: 'Kirghiz; Kyrgyz', native: 'кыргызча kırgızça; кыргыз тили kırgız tili'),
    Language(iso639_2: 'kmb', name: 'Kimbundu'),
    Language(iso639_2: 'kok', name: 'Konkani', native: 'कोंकणी'),
    Language(iso639_2: 'kom', name: 'Komi', native: 'Коми кыв'),
    Language(iso639_2: 'kon', name: 'Kongo'),
    Language(iso639_2: 'kor', name: 'Korean', native: '한국어'),
    Language(iso639_2: 'kos', name: 'Kosraean'),
    Language(iso639_2: 'kpe', name: 'Kpelle', native: 'Kpɛlɛwoo'),
    Language(iso639_2: 'krc', name: 'Karachay-Balkar', native: 'Къарачай-Малкъар тил; Таулу тил'),
    Language(iso639_2: 'krl', name: 'Karelian', native: 'karjal; kariela; karjala'),
    Language(iso639_2: 'kru', name: 'Kurukh', native: 'कुड़ुख़'),
    Language(iso639_2: 'kua', name: 'Kuanyama; Kwanyama'),
    Language(iso639_2: 'kum', name: 'Kumyk', native: 'къумукъ тил/qumuq til'),
    Language(iso639_2: 'kur', name: 'Kurdish', native: 'kurdî / کوردی'),
    Language(iso639_2: 'kut', name: 'Kutenai'),
    Language(iso639_2: 'lad', name: 'Ladino', native: 'Judeo-español'),
    Language(iso639_2: 'lah', name: 'Lahnda', native: 'بھارت کا'),
    Language(iso639_2: 'lam', name: 'Lamba'),
    Language(iso639_2: 'lao', name: 'Lao', native: 'ພາສາລາວ Phasalaw'),
    Language(iso639_2: 'lav', name: 'Latvian', native: 'latviešu'),
    Language(iso639_2: 'lez', name: 'Lezghian', native: 'Лезги чӏал'),
    Language(iso639_2: 'lim', name: 'Limburgan; Limburger; Limburgish', native: 'Lèmburgs'),
    Language(iso639_2: 'lin', name: 'Lingala'),
    Language(iso639_2: 'lit', name: 'Lithuanian', native: 'lietuvių'),
    Language(iso639_2: 'lol', name: 'Mongo', native: 'Lomongo'),
    Language(iso639_2: 'loz', name: 'Lozi'),
    Language(iso639_2: 'ltz', name: 'Luxembourgish; Letzeburgesch', native: 'Lëtzebuergesch'),
    Language(iso639_2: 'lua', name: 'Luba-Lulua', native: 'Tshiluba'),
    Language(iso639_2: 'lub', name: 'Luba-Katanga', native: 'Kiluba'),
    Language(iso639_2: 'lug', name: 'Ganda', native: 'Luganda'),
    Language(iso639_2: 'lun', name: 'Lunda', native: 'Chilunda'),
    Language(iso639_2: 'luo', name: 'Luo (Kenya and Tanzania)', native: 'Dholuo'),
    Language(iso639_2: 'lus', name: 'Lushai', native: 'Mizo ṭawng'),
    Language(iso639_2: 'mad', name: 'Madurese', native: 'Madhura'),
    Language(iso639_2: 'mag', name: 'Magahi', native: 'मगही'),
    Language(iso639_2: 'mah', name: 'Marshallese', native: 'Kajin M̧ajeļ'),
    Language(iso639_2: 'mai', name: 'Maithili', native: 'मैथिली; মৈথিলী'),
    Language(iso639_2: 'mak', name: 'Makasar', native: 'Basa Mangkasara\' / ᨅᨔ ᨆᨀᨔᨑ'),
    Language(iso639_2: 'mal', name: 'Malayalam', native: 'മലയാളം'),
    Language(iso639_2: 'man', name: 'Mandingo', native: 'Mandi\'nka kango'),
    Language(iso639_2: 'mar', name: 'Marathi', native: 'मराठी Marāţhī'),
    Language(iso639_2: 'mas', name: 'Masai', native: 'ɔl'),
    Language(iso639_2: 'mdf', name: 'Moksha', native: 'мокшень кяль'),
    Language(iso639_2: 'mdr', name: 'Mandar'),
    Language(iso639_2: 'men', name: 'Mende', native: 'Mɛnde yia'),
    Language(iso639_2: 'mic', name: 'Mi\'kmaq; Micmac', native: 'Míkmawísimk'),
    Language(iso639_2: 'min', name: 'Minangkabau', native: 'Baso Minang'),
    Language(iso639_2: 'mkd', name: 'Macedonian', native: 'македонски'),
    Language(iso639_2: 'mac', name: 'Macedonian', native: 'македонски'),
    Language(iso639_2: 'mlg', name: 'Malagasy'),
    Language(iso639_2: 'mlt', name: 'Maltese', native: 'Malti'),
    Language(iso639_2: 'mnc', name: 'Manchu', native: 'ᠮᠠᠨᠵᡠ ᡤᡳᠰᡠᠨ Manju gisun'),
    Language(iso639_2: 'mni', name: 'Manipuri'),
    Language(iso639_2: 'moh', name: 'Mohawk', native: 'Kanien’kéha'),
    Language(iso639_2: 'mon', name: 'Mongolian', native: 'монгол хэл mongol xel; ᠮᠣᠩᠭᠣᠯ ᠬᠡᠯᠡ'),
    Language(iso639_2: 'mos', name: 'Mossi', native: 'Mooré'),
    Language(iso639_2: 'mri', name: 'Māori', native: 'Te Reo Māori'),
    Language(iso639_2: 'mao', name: 'Māori', native: 'Te Reo Māori'),
    Language(iso639_2: 'msa', name: 'Malay', native: 'Bahasa Melayu'),
    Language(iso639_2: 'may', name: 'Malay', native: 'Bahasa Melayu'),
    Language(iso639_2: 'mus', name: 'Creek', native: 'Mvskoke'),
    Language(iso639_2: 'mwl', name: 'Mirandese', native: 'mirandés; lhéngua mirandesa'),
    Language(iso639_2: 'mwr', name: 'Marwari', native: 'मारवाड़ी'),
    Language(iso639_2: 'mya', name: 'Burmese', native: 'မြန်မာစာ; မြန်မာစကား'),
    Language(iso639_2: 'bur', name: 'Burmese', native: 'မြန်မာစာ; မြန်မာစကား'),
    Language(iso639_2: 'myv', name: 'Erzya', native: 'эрзянь кель'),
    Language(iso639_2: 'nap', name: 'Neapolitan', native: 'napulitano'),
    Language(iso639_2: 'nau', name: 'Nauru', native: 'dorerin Naoero'),
    Language(iso639_2: 'nav', name: 'Navajo; Navaho', native: 'Diné bizaad; Naabeehó bizaad'),
    Language(iso639_2: 'nbl', name: 'Ndebele, South; South Ndebele', native: 'isiNdebele seSewula'),
    Language(iso639_2: 'nde', name: 'Ndebele, North; North Ndebele', native: 'siNdebele saseNyakatho'),
    Language(iso639_2: 'ndo', name: 'Ndonga', native: 'ndonga'),
    Language(iso639_2: 'nds', name: 'Low German; Low Saxon; German, Low; Saxon, Low', native: 'Plattdütsch; Plattdüütsch'),
    Language(iso639_2: 'nep', name: 'Nepali', native: 'नेपाली भाषा Nepālī bhāśā'),
    Language(iso639_2: 'new', name: 'Nepal Bhasa; Newari', native: 'नेपाल भाषा; नेवाः भाय्'),
    Language(iso639_2: 'nia', name: 'Nias', native: 'Li Niha'),
    Language(iso639_2: 'niu', name: 'Niuean', native: 'ko e vagahau Niuē'),
    Language(iso639_2: 'nld', name: 'Dutch', native: 'Nederlands'),
    Language(iso639_2: 'dut', name: 'Dutch', native: 'Nederlands'),
    Language(iso639_2: 'nno', name: 'Nynorsk', native: 'nynorsk'),
    Language(iso639_2: 'nob', name: 'Bokmål', native: 'bokmål'),
    Language(iso639_2: 'nog', name: 'Nogai', native: 'Ногай тили'),
    Language(iso639_2: 'nor', name: 'Norwegian', native: 'Norsk'),
    Language(iso639_2: 'nqo', name: 'N\'Ko'),
    Language(iso639_2: 'nso', name: 'Pedi; Sepedi; Northern Sotho', native: 'Sesotho sa Leboa'),
    Language(iso639_2: 'nya', name: 'Chichewa; Chewa; Nyanja', native: 'Chichewa; Chinyanja'),
    Language(iso639_2: 'nym', name: 'Nyamwezi'),
    Language(iso639_2: 'nyn', name: 'Nyankole'),
    Language(iso639_2: 'nyo', name: 'Nyoro', native: 'Runyoro'),
    Language(iso639_2: 'nzi', name: 'Nzima'),
    Language(iso639_2: 'oci', name: 'Occitan (post 1500)', native: 'occitan; lenga d\'òc'),
    Language(iso639_2: 'oji', name: 'Ojibwa'),
    Language(iso639_2: 'ori', name: 'Oriya', native: 'ଓଡ଼ିଆ'),
    Language(iso639_2: 'orm', name: 'Oromo', native: 'Afaan Oromoo'),
    Language(iso639_2: 'osa', name: 'Osage', native: 'Wazhazhe ie / 𐓏𐓘𐓻𐓘𐓻𐓟 𐒻𐓟'),
    Language(iso639_2: 'oss', name: 'Ossetian; Ossetic', native: 'Ирон æвзаг Iron ævzag'),
    Language(iso639_2: 'pag', name: 'Pangasinan', native: 'Salitan Pangasinan'),
    Language(iso639_2: 'pam', name: 'Pampanga; Kapampangan', native: 'Amánung Kapampangan; Amánung Sísuan'),
    Language(iso639_2: 'pan', name: 'Panjabi; Punjabi', native: 'ਪੰਜਾਬੀ / پنجابی Pãjābī'),
    Language(iso639_2: 'pap', name: 'Papiamento', native: 'Papiamentu'),
    Language(iso639_2: 'pau', name: 'Palauan', native: 'a tekoi er a Belau'),
    Language(iso639_2: 'pol', name: 'Polish', native: 'polski'),
    Language(iso639_2: 'pon', name: 'Pohnpeian'),
    Language(iso639_2: 'por', name: 'Portuguese', native: 'português'),
    Language(iso639_2: 'pus', name: 'Pushto; Pashto', native: 'پښتو Pax̌tow'),
    Language(iso639_2: 'que', name: 'Quechua', native: 'Runa simi; kichwa simi; Nuna shimi'),
    Language(iso639_2: 'raj', name: 'Rajasthani', native: 'राजस्थानी'),
    Language(iso639_2: 'rap', name: 'Rapanui', native: 'Vananga rapa nui'),
    Language(iso639_2: 'rar', name: 'Rarotongan; Cook Islands Māori', native: 'Māori Kūki \'Āirani'),
    Language(iso639_2: 'roh', name: 'Romansh', native: 'Rumantsch; Rumàntsch; Romauntsch; Romontsch'),
    Language(iso639_2: 'rom', name: 'Romany', native: 'romani čhib'),
    Language(iso639_2: 'ron', name: 'Romanian', native: 'română'),
    Language(iso639_2: 'rum', name: 'Romanian', native: 'română'),
    Language(iso639_2: 'run', name: 'Rundi', native: 'Ikirundi'),
    Language(iso639_2: 'rup', name: 'Aromanian; Arumanian; Macedo-Romanian', native: 'armãneashce; armãneashti; rrãmãneshti'),
    Language(iso639_2: 'rus', name: 'Russian', native: 'русский'),
    Language(iso639_2: 'sad', name: 'Sandawe', native: 'Sandaweeki'),
    Language(iso639_2: 'sag', name: 'Sango', native: 'yângâ tî sängö'),
    Language(iso639_2: 'sah', name: 'Yakut', native: 'Сахалыы'),
    Language(iso639_2: 'sas', name: 'Sasak'),
    Language(iso639_2: 'sat', name: 'Santali', native: 'ᱥᱟᱱᱛᱟᱲᱤ'),
    Language(iso639_2: 'scn', name: 'Sicilian', native: 'Sicilianu'),
    Language(iso639_2: 'sco', name: 'Scots', native: 'Braid Scots; Lallans'),
    Language(iso639_2: 'sel', name: 'Selkup'),
    Language(iso639_2: 'shn', name: 'Shan', native: 'ၵႂၢမ်းတႆးယႂ်'),
    Language(iso639_2: 'sid', name: 'Sidamo', native: 'Sidaamu Afoo'),
    Language(iso639_2: 'sin', name: 'Sinhala; Sinhalese', native: 'සිංහල Sĩhala'),
    Language(iso639_2: 'slk', name: 'Slovak', native: 'slovenčina'),
    Language(iso639_2: 'slo', name: 'Slovak', native: 'slovenčina'),
    Language(iso639_2: 'slv', name: 'Slovenian', native: 'slovenščina'),
    Language(iso639_2: 'sma', name: 'Southern Sami', native: 'Åarjelsaemien gïele'),
    Language(iso639_2: 'sme', name: 'Northern Sami', native: 'davvisámegiella'),
    Language(iso639_2: 'smj', name: 'Lule Sami', native: 'julevsámegiella'),
    Language(iso639_2: 'smn', name: 'Inari Sami', native: 'anarâškielâ'),
    Language(iso639_2: 'smo', name: 'Samoan', native: 'Gagana faʻa Sāmoa'),
    Language(iso639_2: 'sms', name: 'Skolt Sami', native: 'sääʹmǩiõll'),
    Language(iso639_2: 'sna', name: 'Shona', native: 'chiShona'),
    Language(iso639_2: 'snd', name: 'Sindhi', native: 'سنڌي / सिन्धी / ਸਿੰਧੀ'),
    Language(iso639_2: 'snk', name: 'Soninke', native: 'Sooninkanxanne'),
    Language(iso639_2: 'som', name: 'Somali', native: 'af Soomaali'),
    Language(iso639_2: 'sot', name: 'Sotho, Southern', native: 'Sesotho [southern]'),
    Language(iso639_2: 'spa', name: 'Spanish', native: 'español'),
    Language(iso639_2: 'sqi', name: 'Albanian', native: 'Shqip'),
    Language(iso639_2: 'alb', name: 'Albanian', native: 'Shqip'),
    Language(iso639_2: 'srd', name: 'Sardinian', native: 'sardu; limba sarda; lingua sarda'),
    Language(iso639_2: 'srn', name: 'Sranan Tongo'),
    Language(iso639_2: 'srp', name: 'Serbian', native: 'српски / srpski'),
    Language(iso639_2: 'srr', name: 'Serer', native: 'Seereer'),
    Language(iso639_2: 'ssw', name: 'Swati', native: 'siSwati'),
    Language(iso639_2: 'suk', name: 'Sukuma', native: 'Kɪsukuma'),
    Language(iso639_2: 'sun', name: 'Sundanese', native: 'ᮘᮞ ᮞᮥᮔ᮪ᮓ / Basa Sunda'),
    Language(iso639_2: 'sus', name: 'Susu', native: 'Sosoxui'),
    Language(iso639_2: 'swa', name: 'Swahili', native: 'Kiswahili'),
    Language(iso639_2: 'swe', name: 'Swedish', native: 'svenska'),
    Language(iso639_2: 'syr', name: 'Syriac', native: 'ܠܫܢܐ ܣܘܪܝܝܐ Lešānā Suryāyā'),
    Language(iso639_2: 'tah', name: 'Tahitian', native: 'Reo Tahiti; Reo Mā\'ohi'),
    Language(iso639_2: 'tam', name: 'Tamil', native: 'தமிழ் Tamił'),
    Language(iso639_2: 'tat', name: 'Tatar', native: 'татар теле / tatar tele / تاتار'),
    Language(iso639_2: 'tel', name: 'Telugu', native: 'తెలుగు Telugu'),
    Language(iso639_2: 'tem', name: 'Timne', native: 'KʌThemnɛ'),
    Language(iso639_2: 'ter', name: 'Tereno', native: 'Terêna'),
    Language(iso639_2: 'tet', name: 'Tetum', native: 'Lia-Tetun'),
    Language(iso639_2: 'tgk', name: 'Tajik', native: 'тоҷикӣ toçikī'),
    Language(iso639_2: 'tgl', name: 'Tagalog', native: 'Wikang Tagalog'),
    Language(iso639_2: 'tha', name: 'Thai', native: 'ไทย'),
    Language(iso639_2: 'tig', name: 'Tigre', native: 'ትግረ; ትግሬ; ኻሳ; ትግራይት'),
    Language(iso639_2: 'tir', name: 'Tigrinya', native: 'ትግርኛ'),
    Language(iso639_2: 'tiv', name: 'Tiv'),
    Language(iso639_2: 'tkl', name: 'Tokelau'),
    Language(iso639_2: 'tli', name: 'Tlingit', native: 'Lingít'),
    Language(iso639_2: 'tmh', name: 'Tamashek'),
    Language(iso639_2: 'tog', name: 'Tonga (Nyasa)', native: 'chiTonga'),
    Language(iso639_2: 'ton', name: 'Tonga (Tonga Islands)', native: 'lea faka-Tonga'),
    Language(iso639_2: 'tpi', name: 'Tok Pisin'),
    Language(iso639_2: 'tsi', name: 'Tsimshian'),
    Language(iso639_2: 'tsn', name: 'Tswana', native: 'Setswana'),
    Language(iso639_2: 'tso', name: 'Tsonga', native: 'Xitsonga'),
    Language(iso639_2: 'tuk', name: 'Turkmen', native: 'Türkmençe / Түркменче / تورکمن تیلی تورکمنچ; türkmen dili / түркмен дили'),
    Language(iso639_2: 'tum', name: 'Tumbuka', native: 'chiTumbuka'),
    Language(iso639_2: 'tur', name: 'Turkish', native: 'Türkçe'),
    Language(iso639_2: 'tvl', name: 'Tuvalu', native: 'Te Ggana Tuuvalu; Te Gagana Tuuvalu'),
    Language(iso639_2: 'twi', name: 'Twi'),
    Language(iso639_2: 'tyv', name: 'Tuvinian', native: 'тыва дыл'),
    Language(iso639_2: 'udm', name: 'Udmurt', native: 'удмурт кыл'),
    Language(iso639_2: 'uig', name: 'Uighur; Uyghur', native: 'ئۇيغۇرچە  ; ئۇيغۇر تىلى'),
    Language(iso639_2: 'ukr', name: 'Ukrainian', native: 'українська'),
    Language(iso639_2: 'umb', name: 'Umbundu', native: 'Úmbúndú'),
    Language(iso639_2: 'urd', name: 'Urdu', native: 'اُردُو Urduw'),
    Language(iso639_2: 'uzb', name: 'Uzbek', native: 'Oʻzbekcha / Ózbekça / ўзбекча / ئوزبېچه; oʻzbek tili / ўзбек тили / ئوبېک تیلی'),
    Language(iso639_2: 'vai', name: 'Vai', native: 'ꕙꔤ'),
    Language(iso639_2: 'ven', name: 'Venda', native: 'Tshivenḓa'),
    Language(iso639_2: 'vie', name: 'Vietnamese', native: 'Tiếng Việt'),
    Language(iso639_2: 'vot', name: 'Votic', native: 'vađđa ceeli'),
    Language(iso639_2: 'wal', name: 'Wolaitta; Wolaytta'),
    Language(iso639_2: 'war', name: 'Waray', native: 'Winaray; Samareño; Lineyte-Samarnon; Binisayâ nga Winaray; Binisayâ nga Samar-Leyte; “Binisayâ nga Waray”'),
    Language(iso639_2: 'was', name: 'Washo', native: 'wá:šiw ʔítlu'),
    Language(iso639_2: 'wln', name: 'Walloon', native: 'Walon'),
    Language(iso639_2: 'wol', name: 'Wolof'),
    Language(iso639_2: 'xal', name: 'Kalmyk; Oirat', native: 'Хальмг келн / Xaľmg keln'),
    Language(iso639_2: 'xho', name: 'Xhosa', native: 'isiXhosa'),
    Language(iso639_2: 'yao', name: 'Yao'),
    Language(iso639_2: 'yap', name: 'Yapese'),
    Language(iso639_2: 'yid', name: 'Yiddish', native: 'ייִדיש; יידיש; אידיש Yidiš'),
    Language(iso639_2: 'yor', name: 'Yoruba', native: 'èdè Yorùbá'),
    Language(iso639_2: 'zap', name: 'Zapotec', native: 'Diidxazá'),
    Language(iso639_2: 'zen', name: 'Zenaga', native: 'Tuḍḍungiyya'),
    Language(iso639_2: 'zgh', name: 'Standard Moroccan Tamazight', native: 'ⵜⴰⵎⴰⵣⵉⵖⵜ ⵜⴰⵏⴰⵡⴰⵢⵜ'),
    Language(iso639_2: 'zha', name: 'Zhuang; Chuang', native: 'Vahcuengh / 話僮'),
    Language(iso639_2: 'zho', name: 'Chinese', native: '中文'),
    Language(iso639_2: 'chi', name: 'Chinese', native: '中文'),
    Language(iso639_2: 'zul', name: 'Zulu', native: 'isiZulu'),
    Language(iso639_2: 'zun', name: 'Zuni', native: 'Shiwi\'ma'),
    Language(iso639_2: 'zza', name: 'Zaza; Dimili; Dimli; Kirdki; Kirmanjki; Zazaki', native: 'kirmanckî; dimilkî; kirdkî; zazakî'),
  ];
}
