// Copyright (c) 2023, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

import 'dart:async';

import 'common/service_test_common.dart';
import 'common/test_helper.dart';

// AUTOGENERATED START
//
// Update these constants by running:
//
// dart pkg/vm_service/test/update_line_numbers.dart <test.dart>
//
const LINE_A = 26;
const LINE_B = 44;
// AUTOGENERATED END

late A _lock;
bool _lockEnabled = true;

String flutterRoot = 'abc';

A foo(String a, String b, String c, String d) {
  return A(); // LINE_A
}

class A {
  Future lock() => Future.microtask(() => print('lock'));
  final path = 'path';
}

class FileSystemException {}

Future<void> testCode() async {
  if (!_lockEnabled) return;
  _lock = foo(flutterRoot, 'bin', 'cache', 'lockfile');
  bool locked = false;
  bool printed = false;
  while (!locked) {
    try {
      await _lock.lock();
      locked = true; // LINE_B
    } on FileSystemException {
      if (!printed) {
        print('Print path: ${_lock.path}');
        print('Just another line...');
        printed = true;
      }
      await Future<void>.delayed(const Duration(milliseconds: 50));
    }
  }
}

final tests = <IsolateTest>[
  hasPausedAtStart,
  markDartColonLibrariesDebuggable,
  setBreakpointAtLine(LINE_A),
  resumeIsolate,
  hasStoppedAtBreakpoint,
  setBreakpointAtLine(LINE_B),
  resumeIsolate,
  hasStoppedAtBreakpoint,
  stepInto,
  stepInto,
  stepInto,
  resumeIsolate,
];

void main([args = const <String>[]]) => runIsolateTests(
      args,
      tests,
      'regress_28980_test.dart',
      testeeConcurrent: testCode,
      pauseOnStart: true,
      pauseOnExit: false,
    );
