// GENERATED FILE. DO NOT EDIT.
//
// To edit this file modify the generator file `generator/update_package.dart` and
// re-generate.
// This file was generated 2025-11-27 10:34:03.819551 by the dart file
// `generator/update_package.dart`.
//
// Copyright 2025. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

/// These data tables provide metadata for the Material Symbols icons.
///  The data was derived from the official Material Symbols metadata file
/// downloaded from `http://fonts.google.com/metadata/icons?incomplete=1&key=material_symbols`
/// 
library symbols;

import 'dart:convert';

/// This class represents the metadata for an icon in the Material Symbols collection.
class SymbolsMetadata {
  String? originalName;  // This is set if the icon was renamed from the original name (to create a valid Dart symbol name). Otherwise it is null.
  int popularity;
  int codepoint;
  List<int> categories;
  List<int> tags;
  bool rtlAutoMirrored = false; // Default to false
  List<int> codePointsFromCodePointsFiles = [];
  
  SymbolsMetadata(
      {
      this.originalName,
      required this.popularity,
      required this.codepoint,
      required this.categories,
      required this.tags,
      this.rtlAutoMirrored = false}); // Default to false

  factory SymbolsMetadata.fromJson(Map<String, dynamic> json) {
    return SymbolsMetadata(
      originalName: (json['originalName']!=null && json['originalName']!.isNotEmpty && json['originalName']!=json['name']) ? json['originalName'] : null,
      popularity: json['popularity'] ?? 0,
      codepoint: json['codepoint'] ?? 0,
      categories:
          (json['categories'] as List<dynamic>?)?.cast<int>() ?? [],
      tags: (json['tags'] as List<dynamic>?)?.cast<int>() ?? [],
      rtlAutoMirrored: json['rtlAutoMirrored'] ?? false,
    );
  }

  String toJson() {
    return json.encode({
      if(originalName!=null && originalName!.isNotEmpty) 'originalName': originalName!,
      if(rtlAutoMirrored) 'rtlAutoMirrored': rtlAutoMirrored,
      'popularity': popularity,
      'codepoint': codepoint,
      'categories': categories,
      'tags': tags,
    });
  }
}

/// List of all Categories - SymbolsMetadata() objects reference categories by their INDEX this table.
/// To get the category name, use `categoryMap[categoryIndexFromSymbolsMetadata]`
List<String> categoryMap = [
  "Audio&Video",
  "Images",
  "UI actions",
  "Social",
  "Android",
  "Maps",
  "Actions",
  "Communicate",
  "Household",
  "Business",
  "Home",
  "Hardware",
  "Text",
  "Privacy",
  "Transit",
  "Activities",
  "Travel",
];

/// List of all Tags - SymbolsMetadata() objects reference tags by their INDEX this table.
/// To get the tag name, use `tagMap[tagIndexFromSymbolsMetadata]`
List<String> tagMap = [
  "10000",
  "10K",
  "10k",
  "achievement",
  "alphabet",
  "character",
  "competition",
  "digit",
  "display",
  "distance",
  "event",
  "exercise",
  "font",
  "goal",
  "k",
  "letter",
  "letters",
  "measurement",
  "metric",
  "metric prefix",
  "milestone",
  "number",
  "numbers",
  "numerical",
  "pixel",
  "pixels",
  "quantity",
  "race",
  "resolution",
  "running",
  "sport",
  "symbol",
  "ten",
  "text",
  "thousand",
  "type",
  "value",
  "video",
  "10",
  "10mp",
  "camera",
  "camera specifications",
  "capture",
  "detail",
  "digital",
  "digits",
  "equipment",
  "file size",
  "high resolution",
  "image",
  "image size",
  "indicator",
  "label",
  "lens",
  "megapixel",
  "megapixels",
  "mp",
  "photo",
  "photo quality",
  "photography",
  "photography gear",
  "photography settings",
  "picture",
  "quality",
  "sensor",
  "technology",
  "11",
  "eleven",
  "information",
  "numeric",
  "options",
  "settings",
  "1",
  "123",
  "2",
  "3",
  "arrange",
  "arrow",
  "ascending",
  "ascending sort",
  "count",
  "data",
  "digit order",
  "filter",
  "increasing",
  "increasing order",
  "items",
  "line",
  "list",
  "number order",
  "one two three",
  "order",
  "organize",
  "pointing up",
  "sequence",
  "sort",
  "sort ascending",
  "three lines",
  "up arrow",
  "12",
  "12 megapixels",
  "12mp",
  "camera icon",
  "camera quality",
  "definition",
  "digital camera",
  "image quality",
  "imaging",
  "media settings",
  "photo resolution",
  "photo settings",
  "picture settings",
  "video camera icon",
  "video quality",
  "video quality.",
  "video resolution",
  "13",
  "13 megapixel",
  "camera information",
  "camera resolution",
  "camera settings",
  "digital image",
  "image details",
  "image metadata",
  "image settings",
  "photo details",
  "photo size",
  "picture quality",
  "picture size",
  "resolution indicator",
  "technical details",
  "thirteen",
  "thirteen megapixels",
  "14",
  "14mp",
  "clarity",
  "fourteen megapixels",
  "graphic",
  "icon",
  "specification",
  "technical",
  "ui",
  "15",
  "15mp",
  "attributes",
  "details",
  "fifteen",
  "file",
  "metadata",
  "numeral",
  "properties",
  "setting",
  "unit",
  "16",
  "16 megapixels",
  "camera mode",
  "camera specs",
  "digital photography",
  "image information",
  "image resolution",
  "megapixel count",
  "mp indicator.",
  "photo information",
  "photo specs",
  "picture information",
  "sixteen",
  "sixteen megapixels",
  "sixteen mp",
  "17",
  "counting",
  "designation",
  "double digit",
  "identifier",
  "index",
  "marker",
  "number 17",
  "numbering",
  "numbers 17",
  "one",
  "reference",
  "seven",
  "seventeen",
  "tag",
  "18 plus",
  "18+",
  "access restriction",
  "adult content",
  "age limit",
  "age rating",
  "age restriction",
  "age verification",
  "censorship",
  "certification",
  "circle",
  "content rating",
  "content warning",
  "eighteen plus",
  "eighteen+",
  "explicit content",
  "filtering",
  "mature content",
  "number 18",
  "parental advisory",
  "rating",
  "restricted content",
  "sensitive content",
  "warning",
  "18",
  "18mp",
  "alphanumeric.",
  "camera sensor",
  "eighteen",
  "eighteen megapixels",
  "eighteen mp",
  "19",
  "19mp",
  "feature",
  "nineteen",
  "numerical.",
  "1000",
  "1K",
  "1k",
  "abbreviation",
  "amount",
  "counter",
  "figure",
  "measure",
  "result",
  "score",
  "statistic",
  "total",
  "+",
  "addition",
  "followers",
  "growth",
  "increase",
  "likes",
  "more",
  "one thousand.",
  "plus",
  "plus sign",
  "popularity",
  "positive",
  "social media",
  "subscribers",
  "success",
  "thousand plus",
  "views",
  "1x",
  "1x signal",
  "cell signal",
  "cellular",
  "cellular data",
  "connection status",
  "connectivity",
  "connectivity indicator",
  "data connection",
  "data technology",
  "data type",
  "internet",
  "limited connectivity",
  "low speed",
  "mobile",
  "mobile data",
  "mobile internet",
  "mobile network",
  "mobiledata",
  "network",
  "network speed",
  "network status",
  "network type",
  "phone",
  "reception",
  "signal",
  "slow connection",
  "speed",
  "telecommunications",
  "wifi",
  "wireless",
  "wireless data",
  "wireless signal",
  "badge",
  "cell phone",
  "communication",
  "connection",
  "coverage",
  "data plan",
  "data speed",
  "device",
  "outline",
  "signal strength",
  "status",
  "20",
  "info",
  "parameter",
  "photography feature",
  "photography parameter",
  "photography setting",
  "size",
  "twenty",
  "21",
  "21mp",
  "camera setting",
  "detailed",
  "high detail",
  "photo setting",
  "twenty-one",
  "22",
  "center",
  "compass",
  "coordinates",
  "crosshair",
  "destination",
  "direction",
  "discovery",
  "earth",
  "explore",
  "find",
  "geography",
  "global",
  "globe",
  "gps",
  "international",
  "location",
  "map",
  "navigation",
  "pin",
  "place",
  "point",
  "position",
  "round",
  "sphere",
  "travel",
  "web",
  "world",
  "23",
  "23mp",
  "spec",
  "typography",
  "24fps",
  "30",
  "animation",
  "chosen",
  "chosen speed",
  "cinema",
  "control",
  "film",
  "fps",
  "frame",
  "frame rate",
  "frames per second",
  "frequency",
  "media control",
  "motion",
  "movie",
  "option",
  "per",
  "playback speed",
  "preference",
  "rate",
  "second",
  "seconds",
  "select",
  "selection",
  "video editing",
  "video frame",
  "video playback",
  "video settings",
  "video speed",
  "24",
  "format",
  "twentyfour",
  "2d",
  "chart",
  "coordinate",
  "diagram",
  "dimensional",
  "dimensions",
  "drawing",
  "flat",
  "flat design",
  "geometry",
  "grid",
  "height",
  "illustration",
  "layout",
  "perspective",
  "plane",
  "projection",
  "render",
  "representation",
  "scale",
  "shape",
  "surface",
  "two",
  "two dimensional",
  "view",
  "width",
  "x-axis",
  "y-axis",
  "2000",
  "2K",
  "2k",
  "characters",
  "high quality",
  "higher resolution",
  "media",
  "media controls",
  "playback",
  "player",
  "screen",
  "streaming",
  "television",
  "toggle",
  "2000 plus",
  "2000+",
  "2k plus",
  "2k+",
  "hd",
  "high definition",
  "movie quality",
  "quality settings",
  "screen resolution",
  "streaming quality",
  "tv quality",
  "two thousand k",
  "two thousand plus",
  "uhd",
  "ultra hd",
  "video standard",
  "2mp",
  "number 2",
  "rectangle",
  "square",
  "videography",
  "30fps",
  "frame rate setting",
  "frames",
  "media information",
  "multimedia",
  "recording",
  "thirty fps",
  "thirty frames per second",
  "video capture",
  "video control",
  "video display",
  "video frame rate",
  "video information",
  "video options",
  "video playback quality",
  "choose",
  "digital video",
  "frame.",
  "record",
  "stream",
  "video option",
  "video rate",
  "video setting",
  "360",
  "360 degrees",
  "around",
  "av",
  "circular",
  "complete",
  "degree",
  "full view",
  "immersive",
  "interactive",
  "movement",
  "panoramic",
  "rotate",
  "rotation",
  "spin",
  "turn",
  "user interface",
  "virtual reality",
  "visual",
  "vr",
  "3d",
  "D",
  "abstract",
  "block",
  "box",
  "cube",
  "depth",
  "design",
  "dimension",
  "effect",
  "form",
  "future",
  "graphics",
  "model",
  "object",
  "realistic",
  "rendering",
  "simulation",
  "spatial",
  "three-dimensional",
  "virtual",
  "virtual_reality",
  "angle",
  "application",
  "arrows",
  "axis",
  "button",
  "manipulation",
  "menu",
  "orientation",
  "revolve",
  "software",
  "tilt",
  "tool",
  "transform",
  "turning",
  "visualization",
  "3g",
  "bandwidth",
  "bars",
  "broadband",
  "computer",
  "download",
  "full bars",
  "high speed",
  "online",
  "strong signal",
  "tablet",
  "transfer",
  "upload",
  "connection type",
  "data network",
  "generation",
  "internet speed",
  "speed indicator",
  "telecom",
  "3000",
  "3K",
  "3k",
  "high quality video",
  "playback setting",
  "stream quality",
  "streaming service",
  "three k",
  "tv show",
  "video player",
  "3000 plus",
  "3000+",
  "3k plus",
  "3k+",
  "greater than",
  "k.",
  "limit",
  "three",
  "three thousand",
  "threshold",
  "volume",
  "3mp",
  "digital media",
  "file format",
  "file information",
  "format indicator",
  "media file",
  "quality setting",
  "standard definition",
  "video file",
  "3p",
  "account",
  "avatar",
  "bubble",
  "burger menu",
  "chat",
  "collapsed menu",
  "comment",
  "communicate",
  "configure",
  "customize",
  "drag",
  "face",
  "grip",
  "hamburger",
  "hamburger menu",
  "handle",
  "horizontal",
  "horizontal lines",
  "human",
  "lines",
  "message",
  "move",
  "organized",
  "party",
  "people",
  "person",
  "profile",
  "reorder",
  "speech",
  "stack",
  "stacked",
  "three horizontal lines",
  "user",
  "4g",
  "edge",
  "four g",
  "gprs",
  "hspa",
  "lte",
  "network strength",
  "telecommunication",
  "umts",
  "communication.",
  "data transfer",
  "notification",
  "4g plus",
  "4g+",
  "advanced data",
  "carrier",
  "data usage",
  "fast speed",
  "upgraded network",
  "4000",
  "4K",
  "4k",
  "alphanumeric",
  "content",
  "equation",
  "monitor",
  "4",
  "4mp",
  "aspect ratio",
  "four",
  "mega",
  "watermark",
  "50",
  "50mp",
  "crisp",
  "fifty",
  "fifty megapixel",
  "mode",
  "photo mode",
  "sharp",
  "5g",
  "fifth generation",
  "modern",
  "performance",
  "strength",
  "wireless network",
  "modem",
  "service",
  "5000",
  "5K",
  "5k",
  "crispness",
  "display setting",
  "five k",
  "five thousand",
  "playback quality",
  "quality indicator",
  "ultra high definition",
  "video clarity",
  "visual quality",
  "count display.",
  "data point",
  "five",
  "limit reached",
  "metric display",
  "more than",
  "number symbol",
  "numerical value",
  "over",
  "quantity indicator",
  "sum",
  "5",
  "5mp",
  "five megapixels",
  "60fps",
  "editing",
  "production",
  "smooth",
  "60",
  "choice",
  "configuration",
  "media player",
  "6",
  "6 feet",
  "apart",
  "apart rule",
  "body",
  "coronavirus",
  "covid",
  "covid-19",
  "distancing",
  "feet",
  "ft",
  "guideline",
  "health",
  "keeping distance",
  "pandemic",
  "precaution",
  "protection",
  "public health",
  "recommended distance",
  "regulation",
  "requirement",
  "rule",
  "safety",
  "separation",
  "six feet",
  "social",
  "social distancing",
  "space",
  "stay apart",
  "stick figure",
  "6000",
  "6K",
  "6k",
  "enhanced",
  "premium",
  "approximation",
  "estimate",
  "minimum",
  "six thousand",
  "camera info",
  "detail level",
  "image options",
  "photo data",
  "photo options",
  "picture detail",
  "picture info",
  "resolution info",
  "7000",
  "7K",
  "broadcast",
  "channel",
  "film rating",
  "movie rating",
  "numbers 7k",
  "seven thousand",
  "source",
  "television rating",
  "text 7k",
  "title",
  "tv rating",
  "7000 plus",
  "7000+",
  "7k+",
  "add",
  "statistics",
  "7",
  "action",
  "active",
  "buffering",
  "busy",
  "continuous",
  "cycle",
  "dashed",
  "dotted",
  "loading",
  "loop",
  "processing",
  "progress",
  "refresh",
  "reload",
  "ring",
  "spinning",
  "sync",
  "synchronize",
  "waiting",
  "8000",
  "8K",
  "8k",
  "cinema quality",
  "display settings",
  "media quality",
  "multimedia settings",
  "playback settings",
  "screen settings",
  "uhd 8k",
  "video definition",
  "video stream",
  "advanced",
  "clear",
  "entertainment",
  "viewing experience",
  "8",
  "8mp",
  "9000",
  "9K",
  "9k",
  "marking",
  "nine k",
  "analytic",
  "calculation",
  "level",
  "math",
  "quantitative",
  "ranking",
  "9",
  "9 megapixel",
  "9 mp",
  "9mp",
  "image format",
  "image icon",
  "nine",
  "nine megapixel",
  "photo icon",
  "resolution setting",
  "video size",
  "absent",
  "bare",
  "blank",
  "clean",
  "empty",
  "featureless",
  "invisible",
  "minimal",
  "neutral",
  "no icon",
  "no image",
  "nothing",
  "null",
  "placeholder",
  "plain",
  "pristine",
  "transparent",
  "undefined",
  "undepicted",
  "unillustrated",
  "unimaged",
  "unrepresented",
  "unseen",
  "unstyled",
  "untouched",
  "unvisualized",
  "void",
  "white",
  "ac",
  "air",
  "air conditioning",
  "asterisk",
  "climate",
  "cold",
  "condition",
  "conditioner",
  "cool",
  "cooling",
  "crystal",
  "flake",
  "frost",
  "frozen",
  "ice",
  "points",
  "polygon",
  "six pointed star",
  "six points",
  "snow",
  "snowflake",
  "star",
  "temperature",
  "weather",
  "winter",
  "access",
  "access for all",
  "accessibility",
  "accessible",
  "adjustments",
  "arm",
  "arms",
  "assistance",
  "disability",
  "disabled",
  "ease of use",
  "everyone",
  "features",
  "handicap",
  "head",
  "help",
  "inclusive",
  "needs",
  "reaching",
  "standing",
  "support",
  "universal",
  "accessibility features",
  "added",
  "brand new",
  "impairments",
  "inclusive design",
  "latest",
  "new",
  "new accessibility",
  "special needs",
  "universal design",
  "update",
  "user needs",
  "user support",
  "version",
  "inclusion",
  "medical",
  "mobility",
  "ramp",
  "special",
  "wheelchair",
  "assist",
  "entrance",
  "forward",
  "go",
  "next",
  "person walking",
  "pictogram",
  "right",
  "walker",
  "walking",
  "accessible menu",
  "personal",
  "preferences",
  "accounting",
  "balance",
  "bank",
  "banking",
  "bill",
  "building",
  "business",
  "card",
  "cash",
  "coin",
  "columns",
  "commerce",
  "courthouse",
  "credit",
  "currency",
  "dollars",
  "economic",
  "federal",
  "finance",
  "financial",
  "financial institution",
  "government",
  "institution",
  "investment",
  "loan",
  "money",
  "mortgage",
  "pay",
  "payment",
  "pillars",
  "prosperity",
  "savings",
  "structure",
  "transaction",
  "treasury",
  "wealth",
  "billfold",
  "budget",
  "credit card",
  "debit card",
  "earn",
  "economy",
  "finances",
  "funds",
  "invest",
  "ledger",
  "pocketbook",
  "purse",
  "receive",
  "spend",
  "wallet",
  "account icon",
  "contact",
  "contact icon",
  "contacts",
  "filled",
  "identity",
  "inbox",
  "login",
  "member",
  "person icon",
  "portrait",
  "private",
  "profile picture",
  "register",
  "silhouette",
  "solid",
  "thumbnail",
  "user icon",
  "account child",
  "avatar child",
  "child",
  "child profile",
  "child user",
  "children",
  "dependent",
  "family account",
  "guardian",
  "kid",
  "kids account",
  "minor account",
  "parent account",
  "profile child",
  "restricted account",
  "sub account",
  "user child",
  "young",
  "youth account",
  "family",
  "individual",
  "kids",
  "management",
  "membership",
  "minor",
  "parent",
  "personalization",
  "privacy",
  "rounded",
  "security",
  "shoulders",
  "single person",
  "account details",
  "account information",
  "account management",
  "account page",
  "account settings",
  "authentication",
  "bust",
  "my account",
  "secure",
  "signed in",
  "signed up",
  "signup",
  "user account",
  "user profile",
  "access denied",
  "account disabled",
  "authorization",
  "delete",
  "disconnected",
  "enabled",
  "logout",
  "off",
  "offline",
  "on",
  "profile circle",
  "remove",
  "restriction",
  "slash",
  "unavailable",
  "user circle",
  "account structure",
  "analytics",
  "branches",
  "connect",
  "connected",
  "connections",
  "corporate structure",
  "flow",
  "graph",
  "grouped",
  "hierarchy",
  "infographic",
  "layers",
  "levels",
  "linked",
  "mapping",
  "metrics",
  "nested",
  "nodes",
  "organization",
  "organizational chart",
  "process",
  "project structure",
  "relationships",
  "system",
  "team structure",
  "tracking",
  "tree",
  "tree structure",
  "visual hierarchy",
  "argument",
  "buttons",
  "circles",
  "code",
  "command",
  "continue",
  "development",
  "dots",
  "enter",
  "execute",
  "function",
  "glass",
  "hardware",
  "input",
  "key",
  "keyboard",
  "keypad",
  "look",
  "magnify",
  "magnifying",
  "method",
  "operation",
  "press",
  "proceed",
  "program",
  "programming",
  "return",
  "run",
  "search",
  "see",
  "shortcut",
  "activity ",
  "activity zone",
  "area",
  "border",
  "boundary",
  "confined area",
  "designated area",
  "division",
  "enclosed area",
  "focus area",
  "highlight",
  "home",
  "limits",
  "map area",
  "nest",
  "operating area",
  "performance zone",
  "perimeter",
  "portion",
  "range",
  "region",
  "restricted area",
  "section",
  "segment",
  "territory",
  "workspace",
  "zone",
  "zone selection",
  "accent",
  "acute",
  "clock",
  "date",
  "decoration",
  "diagonal line",
  "divider",
  "element",
  "fast",
  "geometric",
  "mark",
  "pointer",
  "schedule",
  "separator",
  "stroke",
  "time",
  "timer",
  "ui component",
  "a",
  "ad",
  "advertisement",
  "announcement",
  "banner",
  "browser",
  "commercial",
  "d",
  "marketing",
  "notice",
  "promotion",
  "sign",
  "sponsored",
  "website",
  "window",
  "ad group",
  "advertising group",
  "audience",
  "banner multiple",
  "bundle",
  "campaign",
  "campaign group",
  "category",
  "cluster",
  "collection",
  "group",
  "grouping",
  "marketing group",
  "segmentation",
  "set",
  "target audience",
  "targeting",
  "Ads",
  "ad group off",
  "block group",
  "block user",
  "cancel",
  "close",
  "deny",
  "exit",
  "forbidden",
  "group audience",
  "group block",
  "group disable",
  "group off",
  "group remove",
  "group stop",
  "group target",
  "hidden",
  "inactive",
  "pause",
  "restrictions",
  "stop",
  "target",
  "user group",
  "users",
  "windows",
  "ad free",
  "adblock",
  "advertising",
  "ban",
  "block ad",
  "cross",
  "disable ad",
  "filter ad",
  "hide ad",
  "mute ad",
  "no ad",
  "opt out",
  "popup",
  "remove ad",
  "stop ad",
  "Android",
  "OS",
  "ad management",
  "ad unit",
  "cell",
  "digital marketing",
  "edit",
  "iOS",
  "message ad",
  "minus",
  "mobile ad",
  "mobile marketing",
  "mobile text ad",
  "notifications",
  "sms",
  "subtract",
  "text ad",
  "top",
  "units",
  "accounts",
  "adaptive",
  "adjustable",
  "assistant",
  "audio",
  "audio mesh",
  "call",
  "committee",
  "communications",
  "dictation",
  "dynamic",
  "flexible",
  "friends",
  "google meet",
  "hear",
  "hearing",
  "humans",
  "intelligent",
  "live",
  "meet",
  "mic",
  "microphone",
  "noise",
  "persons",
  "profiles",
  "recognition",
  "recorder",
  "responsive",
  "smart",
  "sound",
  "speaker",
  "speaking",
  "talk",
  "team",
  "tech",
  "voice",
  "crossed out",
  "disable",
  "listen",
  "mute",
  "muted",
  "silence",
  "toggle.",
  "adb",
  "android",
  "android debug bridge",
  "app",
  "bridge",
  "debug",
  "debugging",
  "develop",
  "developer",
  "link",
  "terminal",
  "tools",
  "usb",
  "append",
  "arithmetic",
  "attach",
  "combine",
  "create",
  "expand",
  "grow",
  "insert",
  "join",
  "mathematical symbol",
  "merge",
  "two lines",
  "basic",
  "container",
  "elaborate",
  "extend",
  "include",
  "increase size",
  "rounded square",
  "simple",
  "supplement",
  "a photo",
  "album",
  "gallery",
  "interface",
  "library",
  "photograph",
  "shutter",
  "ui element",
  "ux",
  "ad campaign",
  "generate",
  "placard",
  "post",
  "publish",
  "add attention",
  "add important",
  "add notification",
  "add reminder",
  "add warning",
  "alarm",
  "alert",
  "attention",
  "bell",
  "caution",
  "chime",
  "create alarm",
  "danger",
  "exclamation",
  "important",
  "notify",
  "remind",
  "reminder",
  "set reminder",
  "subscribe",
  "subscribe to alerts",
  "build",
  "construct",
  "item",
  "new square",
  "add building",
  "add business",
  "add business location",
  "add location",
  "building and plus",
  "building with plus",
  "business location",
  "company",
  "corporate",
  "enterprise",
  "establishment",
  "map marker",
  "market",
  "marketplace",
  "office",
  "point of interest",
  "retail",
  "shop",
  "shopping",
  "store",
  "storefront",
  "add call",
  "app icon",
  "dial",
  "isolated",
  "make call",
  "minimalist",
  "mobile icon",
  "new call",
  "telephone",
  "ui icon",
  "ux icon",
  "vector",
  "web icon",
  "add card",
  "add credit card",
  "add debit card",
  "add payment",
  "billing",
  "checkout",
  "cost",
  "new card",
  "payment method",
  "price",
  "analysis",
  "bar",
  "bar chart",
  "dashboard",
  "line graph",
  "presentation",
  "report",
  "trend",
  "add circle",
  "circle add",
  "hollow",
  "thin",
  "unknown 3",
  "add column",
  "add left",
  "add to table",
  "adjust columns",
  "column",
  "column management",
  "data column",
  "database column",
  "edit columns",
  "grid column",
  "insert column",
  "insert into table",
  "insert left",
  "layout column",
  "left column",
  "modify columns",
  "new column",
  "new left",
  "new symbol",
  "new table column",
  "organize columns",
  "plus column",
  "plus left",
  "plus table column",
  "reorder columns",
  "rows",
  "spreadsheet",
  "spreadsheet column",
  "structure columns",
  "table column",
  "vertical",
  "add right",
  "arrangement",
  "database",
  "edit table",
  "insert right",
  "modify table",
  "side",
  "table",
  "annotation",
  "conversation",
  "dialog",
  "discourse",
  "discuss",
  "feedback",
  "note",
  "notetaking",
  "reply",
  "response",
  "speech bubble",
  "writing",
  "brilliant",
  "diamond",
  "expensive",
  "gem",
  "jewel",
  "luxury",
  "precious",
  "rhombus",
  "valuable",
  "accommodation",
  "architecture",
  "construction",
  "dwelling",
  "house",
  "property",
  "real estate",
  "residence",
  "residential",
  "shelter",
  "suburban",
  "urban",
  "add home",
  "add house",
  "add office",
  "add project",
  "add task",
  "add work",
  "address",
  "briefcase",
  "job",
  "project",
  "task",
  "work",
  "add link",
  "anchor",
  "associate",
  "chain",
  "clip",
  "hyperlink",
  "joint",
  "link symbol",
  "plus symbol",
  "share",
  "tie",
  "url",
  "add pin",
  "add point",
  "geo tag",
  "geo tagging",
  "geographic location",
  "latitude",
  "location marker",
  "longitude",
  "map pin",
  "maps",
  "new location",
  "pin location",
  "pin marker",
  "place marker",
  "place pin",
  "poi",
  "alt",
  "geo",
  "geolocate",
  "landmark",
  "street",
  "add administrator",
  "add member",
  "add moderator",
  "add person",
  "add profile",
  "add user",
  "administrator",
  "certified",
  "human icon",
  "invite member",
  "invite person",
  "invite user",
  "man icon",
  "member icon",
  "moderator",
  "new administrator",
  "new member",
  "new moderator",
  "new person",
  "new profile",
  "new user",
  "plus administrator",
  "plus member",
  "plus moderator",
  "plus person",
  "plus profile",
  "plus user",
  "profile icon",
  "protect",
  "shield",
  "verified",
  "woman icon",
  "compose",
  "create note",
  "doc",
  "document",
  "entry",
  "jot",
  "jotting",
  "memo",
  "notepad",
  "notes",
  "page",
  "paper",
  "sheet",
  "stationery",
  "write",
  "alternate",
  "art",
  "creation",
  "import",
  "landscape",
  "mountain",
  "mountains",
  "sun",
  "add emoji",
  "add feeling",
  "add reaction",
  "emoji",
  "emotion",
  "emotion picker",
  "emotions",
  "express",
  "expressions",
  "facial expression",
  "feeling",
  "feelings",
  "glad",
  "happiness",
  "happy",
  "icons",
  "interaction",
  "like",
  "mood",
  "new reaction",
  "pleased",
  "plus reaction",
  "respond",
  "smile",
  "smiley",
  "smiling",
  "survey",
  "add new",
  "highway",
  "infrastructure",
  "journey",
  "navigate",
  "path",
  "road",
  "route",
  "traffic",
  "transportation",
  "way",
  "above",
  "before",
  "data entry",
  "horizontal line",
  "populate",
  "row",
  "add record",
  "add row",
  "below",
  "downwards",
  "insert row",
  "modify",
  "new row",
  "spreadsheet data",
  "add icon",
  "add to cart",
  "bag",
  "basket",
  "buy",
  "cart",
  "cart icon",
  "e-commerce",
  "new item",
  "online shop",
  "online shopping",
  "online store",
  "plus icon",
  "product",
  "purchase",
  "shopping cart",
  "shopping cart icon",
  "trolley",
  "appointment",
  "approve",
  "assignment",
  "check",
  "checklist",
  "completed",
  "ok",
  "plan",
  "tick",
  "to do",
  "todo",
  "yes",
  "add document",
  "add file",
  "add to cloud",
  "backup",
  "cloud",
  "cloud storage",
  "drive",
  "drive storage",
  "files",
  "folders",
  "gdrive",
  "google",
  "google drive",
  "recovery",
  "save",
  "save to cloud",
  "storage",
  "add to",
  "add to home screen",
  "bookmark",
  "diagonal arrow",
  "export",
  "fullscreen",
  "install",
  "mobile device",
  "right arrow",
  "smartphone",
  "up",
  "add to queue",
  "chrome",
  "desktop",
  "mac",
  "music",
  "ordering",
  "play next",
  "playlist",
  "queue",
  "to",
  "upcoming",
  "watch next",
  "contribute",
  "expansion",
  "mid trip",
  "obstacle",
  "polygonal",
  "produce",
  "slowdown",
  "three sides",
  "tip",
  "triangle",
  "upward",
  "adf",
  "adf scanner",
  "automatic document feeder",
  "copier",
  "copy",
  "digitization",
  "feed",
  "feeder",
  "hardcopy",
  "machine",
  "multiple pages",
  "office equipment",
  "output",
  "parallel lines",
  "print",
  "printer",
  "scan",
  "scanner",
  "adjust",
  "alter",
  "auto click",
  "control panel",
  "controls",
  "dot",
  "fine-tune",
  "fix",
  "focus",
  "horizontal bars",
  "levers",
  "panel",
  "parameters",
  "personalize",
  "setup",
  "sliders",
  "tune",
  "admin",
  "administration",
  "blister pack",
  "capsule",
  "care",
  "clinic",
  "doctor",
  "dosage",
  "drugs",
  "health care",
  "healthcare",
  "hospital",
  "med",
  "medication",
  "medicine",
  "meds",
  "pharma",
  "pharmaceuticals",
  "pharmacy",
  "pharmacy bag",
  "pills",
  "prescription",
  "treatment",
  "cog",
  "executive",
  "gear",
  "manager",
  "moderation",
  "permissions",
  "privileges",
  "supervision",
  "wrench",
  "ads",
  "ads click",
  "call to action",
  "click",
  "clicks",
  "conversion",
  "cursor",
  "engagement",
  "finger",
  "reach",
  "tap",
  "touch",
  "agender",
  "community",
  "diversity",
  "equality",
  "female",
  "gender",
  "gender neutral",
  "genderfree",
  "genderless",
  "lgbt",
  "lgbtq+",
  "male",
  "non-binary",
  "pronoun",
  "self identification",
  "sex",
  "agriculture",
  "automobile",
  "botany",
  "car",
  "cars",
  "crop",
  "cultivated",
  "cultivation",
  "environment",
  "farm",
  "farming",
  "field",
  "garden",
  "green",
  "ground",
  "harvest",
  "land",
  "leaf",
  "natural",
  "nature",
  "organic",
  "outdoor",
  "plant",
  "rural",
  "season",
  "seedling",
  "spring",
  "sprout",
  "stalk",
  "stem",
  "summer",
  "sustainability",
  "tractor",
  "transport",
  "truck",
  "vehicle",
  "atmospheric",
  "blowing",
  "breath",
  "breeze",
  "current",
  "environmental",
  "fragrance",
  "fresh",
  "heating",
  "hvac",
  "scent",
  "smell",
  "swirl",
  "swoosh",
  "ventilation",
  "wave",
  "waves",
  "wind",
  "accessory",
  "aerosol",
  "air freshener",
  "aroma",
  "bottle",
  "bottler",
  "can",
  "deodorant",
  "diffuser",
  "eliminate",
  "freshener",
  "household",
  "hygiene",
  "odor",
  "purify",
  "room",
  "spray",
  "air filter",
  "air purifier",
  "airflow",
  "appliance",
  "automation",
  "clean air",
  "electrical appliance",
  "fresh air",
  "gadget",
  "healthy home",
  "home appliance",
  "purification",
  "purifier",
  "smart home",
  "upward arrow",
  "vent",
  "air quality",
  "breathe",
  "circulation",
  "cleaner",
  "fan",
  "healthy living",
  "indoors",
  "pollution",
  "smart control",
  "smart device",
  "airline",
  "airplane",
  "amenity",
  "bed",
  "booking",
  "business class",
  "cabin",
  "chair",
  "class",
  "comfort",
  "first",
  "first class",
  "flight",
  "lay flat",
  "lie flat",
  "lounge",
  "passenger",
  "recline",
  "relaxation",
  "reservation",
  "rest",
  "seat",
  "seating",
  "sleep",
  "sleeping",
  "travel class",
  "aircraft",
  "angled",
  "bus",
  "comfortable",
  "lie",
  "reclining",
  "train",
  "trip",
  "enclosed",
  "flying",
  "legroom",
  "recliner",
  "relax",
  "suite",
  "vacation",
  "extended",
  "extra",
  "large",
  "leg",
  "long",
  "sitting",
  "stretch",
  "upgrade",
  "aviation",
  "normal",
  "standard",
  "cramped",
  "diminished",
  "less",
  "limited",
  "low",
  "reduced",
  "restricted",
  "shrunk",
  "small",
  "tight",
  "holiday",
  "leisure",
  "airline diagram",
  "airline layout",
  "economy class",
  "normal position",
  "passenger seat",
  "recline normal",
  "seating arrangement",
  "standard seat",
  "travel icon",
  "upright position",
  "upright seat",
  "airport",
  "destination.",
  "itinerary",
  "journey stops",
  "layover",
  "points of interest",
  "stops",
  "transit",
  "travel plans",
  "travel route",
  "air travel",
  "airlines",
  "airlines icon",
  "airplane mode",
  "airplanes",
  "booking app",
  "flight app",
  "flights",
  "fly",
  "plane icon",
  "planes",
  "sky",
  "travel app",
  "wings",
  "admit",
  "air ticket",
  "airplane ticket",
  "boarding",
  "boarding pass",
  "dotted line",
  "flight ticket",
  "identification",
  "pass",
  "perforations",
  "plane ticket",
  "show",
  "stub",
  "tear line",
  "ticket",
  "travel document",
  "deactivated",
  "flight mode",
  "mobile settings",
  "network off",
  "not active",
  "not enabled",
  "signal off",
  "wireless off",
  "airplay",
  "cast screen",
  "casting",
  "content sharing",
  "external display",
  "media sharing",
  "screen mirroring",
  "screen share",
  "send to tv",
  "sharing",
  "tv",
  "wireless display",
  "airport shuttle",
  "auto",
  "bus icon",
  "delivery",
  "driving",
  "drop off",
  "ground transportation",
  "logistics",
  "mini",
  "pick up",
  "public",
  "public transport",
  "ride",
  "road travel",
  "shuttle",
  "shuttle bus",
  "shuttle service",
  "transport icon",
  "travel arrangements",
  "van",
  "airware",
  "airwave",
  "curved lines",
  "oscillation",
  "radio",
  "ripple",
  "signals",
  "transmission",
  "vibration",
  "audio settings",
  "audio waves",
  "data transmission",
  "equalizer",
  "internet signal",
  "radio waves",
  "router",
  "signal lines",
  "sound waves",
  "thermostat",
  "wave lines",
  "alerts",
  "analog",
  "buzzer",
  "chimes",
  "chronometer",
  "countdown",
  "hands",
  "manage",
  "ringing",
  "schedules",
  "snooze",
  "timekeeping",
  "timepiece",
  "traditional",
  "wake up",
  "watch",
  "指针",
  "calendar",
  "deadline",
  "pendulum",
  "rings",
  "vertical line",
  "alarm off",
  "bell disabled",
  "bell muted",
  "bell off",
  "checkmark",
  "disable alarm",
  "disable notification",
  "disable sound",
  "duration",
  "mute alarm",
  "mute notification",
  "mute sound",
  "no alarm",
  "no bell",
  "no notification",
  "no sound",
  "notification off",
  "quiet",
  "silence alarm",
  "silent",
  "sound off",
  "stop alarm",
  "turn off alarm",
  "alarm on",
  "awake",
  "hour",
  "minute",
  "scheduled",
  "siren",
  "break",
  "delay",
  "hold",
  "interrupt",
  "postpone",
  "standby",
  "suspend",
  "temporal",
  "temporary",
  "bell shape",
  "intelligent alarm",
  "morning",
  "personalized",
  "smart alarm",
  "smart wake",
  "wake assist",
  "archive",
  "artist",
  "bvb",
  "cd",
  "cover",
  "disc",
  "disk",
  "folder",
  "multiple",
  "songs",
  "track",
  "tracks",
  "align",
  "alignment",
  "centered",
  "centering",
  "document editing",
  "document layout",
  "editor",
  "formatting",
  "justified",
  "lines of text",
  "middle",
  "paragraph",
  "paragraph style",
  "rules",
  "style",
  "text alignment",
  "text editing",
  "text style",
  "align end",
  "align right",
  "align text",
  "arrange text",
  "content alignment",
  "format text",
  "justification",
  "organize text",
  "paragraph alignment",
  "right justify",
  "text editor",
  "text formatting",
  "text layout",
  "text options",
  "word processing",
  "distribute",
  "distribution",
  "flex",
  "justify",
  "object alignment",
  "bottom",
  "css",
  "elements",
  "end",
  "flexbox",
  "positioning",
  "web design",
  "align flex start",
  "align items",
  "beginning",
  "flex start",
  "horizontal alignment",
  "left",
  "placement",
  "start",
  "styling",
  "ui control",
  "vertical alignment",
  "web development",
  "word processor",
  "align horizontal",
  "align left",
  "arrange elements",
  "document alignment",
  "horizontal align",
  "left align",
  "position text",
  "spacing",
  "text align",
  "adjustment",
  "formatting options",
  "indent",
  "parallel",
  "text tools",
  "align items stretch",
  "coding",
  "fill",
  "fit",
  "objects",
  "resize",
  "center align",
  "document formatting",
  "four bars",
  "four lines",
  "justify center",
  "short line",
  "align start",
  "bullet points",
  "content icon",
  "format icon",
  "justify left",
  "list icon",
  "multiple lines",
  "paragraph icon",
  "paragraph lines",
  "text block",
  "text icon",
  "word block",
  "distributed",
  "equal",
  "proportional",
  "composition",
  "document editor",
  "even spacing",
  "line alignment",
  "page layout",
  "space between",
  "text lines",
  "visual spacing",
  "equal space",
  "even",
  "evenly distributed",
  "graphic design",
  "text justification",
  "uniform spacing",
  "evenly",
  "downward arrow",
  "self",
  "across",
  "between",
  "blocks",
  "divide",
  "spread",
  "dashes",
  "distribute evenly",
  "equal distribution",
  "equal spacing",
  "horizontal spacing",
  "bullet list",
  "directional",
  "ruler",
  "fillscreen",
  "full",
  "paragraphs",
  "wordprocessor",
  "creative",
  "three bars",
  "Inbox",
  "all",
  "all mail",
  "comprehensive",
  "correspondence",
  "delivered",
  "digital mail",
  "email",
  "entirety",
  "envelope",
  "incoming",
  "mail",
  "mail folder",
  "mailbox",
  "messaging",
  "postal",
  "received",
  "send",
  "totality",
  "boundless",
  "concept",
  "encompassing",
  "endless",
  "eternal",
  "everything",
  "figure eight",
  "forever",
  "infinite",
  "infinity",
  "lemniscate",
  "mobius",
  "neverending",
  "strip",
  "sustainable",
  "unbroken",
  "unlimited",
  "whole",
  "accurate",
  "binoculars",
  "correct",
  "discover",
  "done",
  "exact",
  "investigate",
  "locate",
  "look up",
  "loupe",
  "magnifying glass",
  "match",
  "optical",
  "precise",
  "query",
  "results",
  "seek",
  "validate",
  "zoom",
  "corner",
  "diagonal",
  "enlarge",
  "maximize",
  "out",
  "outside",
  "outward",
  "allergen",
  "allergic",
  "allergies",
  "allergy",
  "diet",
  "floral",
  "food",
  "healthy",
  "ingredient",
  "intolerance",
  "leaves",
  "pollen",
  "raw",
  "sensitivity",
  "vegan",
  "vegetarian",
  "bacteria",
  "discomfort",
  "disease",
  "germ",
  "illness",
  "infection",
  "microbe",
  "rash",
  "reaction",
  "sickness",
  "symptom",
  "unwell",
  "virus",
  "alternate routes",
  "alternative",
  "bifurcate",
  "branching",
  "change",
  "choices",
  "dash",
  "detour",
  "different",
  "directions",
  "diversion",
  "multiple routes",
  "other",
  "route options",
  "routes",
  "split",
  "switch",
  "variety",
  "@",
  "at sign",
  "electronic mail",
  "typing",
  "altitude",
  "elevation",
  "growing",
  "rise",
  "sea",
  "accident",
  "aid",
  "ambulance",
  "emergency",
  "patient",
  "rescue",
  "sos",
  "swift",
  "urgent",
  "administrative",
  "agreement",
  "amend",
  "article",
  "back",
  "contract",
  "document icon",
  "file icon",
  "form icon",
  "legal",
  "manuscript",
  "proposal",
  "renew",
  "revise",
  "accelerated mobile pages",
  "amp",
  "articles",
  "news",
  "rectangular",
  "rectangular bars",
  "sections",
  "segments",
  "series",
  "stories",
  "timeline",
  "assessment",
  "insights",
  "intelligence",
  "sales",
  "trends",
  "vertical bars",
  "boat",
  "dropped",
  "harbor",
  "heavy",
  "holding",
  "hook",
  "logo",
  "marine",
  "maritime",
  "metal",
  "mooring",
  "nautical",
  "navy",
  "ocean",
  "port",
  "pulled up",
  "sailing",
  "ship",
  "stability",
  "strong",
  "water",
  "antennae",
  "app development",
  "bot",
  "brand",
  "bugdroid",
  "computing",
  "ears",
  "futuristic",
  "internet of things",
  "mascot",
  "mobile development",
  "open source",
  "operating system",
  "platform",
  "robot",
  "toy",
  "gemini",
  "gifs",
  "images",
  "play",
  "prints",
  "reel",
  "videos",
  "activity",
  "activity indicator",
  "concentric",
  "fluid",
  "loading spinner",
  "looping",
  "progress indicator",
  "refreshing",
  "visualizer",
  "wait",
  "working",
  "always",
  "always on display",
  "aod",
  "cellphone",
  "content display",
  "homescreen",
  "mobile content",
  "mobile info",
  "mobile message",
  "mobile notification",
  "mobile text",
  "rounded rectangle",
  "electronic",
  "portable",
  "wide",
  "ar",
  "band",
  "electronics",
  "fitness",
  "smartwatch",
  "strap",
  "tracker",
  "wearable",
  "wearable tech",
  "wearables",
  "wrist",
  "wristband",
  "wristwatch",
  "apartment",
  "city",
  "complex",
  "downtown",
  "estate",
  "housing",
  "places",
  "real",
  "skyscraper",
  "tower",
  "workplace",
  "api",
  "backend",
  "frontend",
  "integration",
  "programming interface",
  "web service",
  "apk",
  "extension",
  "installer",
  "package",
  "app badge",
  "apps",
  "badging",
  "new message",
  "notification badge",
  "pending",
  "pending item",
  "pending update",
  "unread",
  "unread item",
  "unread message",
  "update available",
  "app block",
  "app management",
  "app security",
  "blocking",
  "deactivate",
  "device block",
  "device lock",
  "device management",
  "lock",
  "mobile block",
  "mobile management",
  "mobile security",
  "no access",
  "no mobile",
  "no phone",
  "no symbol",
  "parental control",
  "phone lock",
  "prohibition",
  "stopped",
  "app registration",
  "create account",
  "id",
  "pencil",
  "registration",
  "sign in",
  "sign up",
  "user management",
  "apparel",
  "attire",
  "blouse",
  "closet",
  "clothes",
  "clothing",
  "clothing tag",
  "coat",
  "dress",
  "ecommerce",
  "fabric",
  "fashion",
  "garment",
  "jacket",
  "outfit",
  "pants",
  "price tag",
  "shirt",
  "tailoring",
  "tee",
  "textile",
  "uniform",
  "wardrobe",
  "wear",
  "accept",
  "accepted",
  "acknowledge",
  "affirmative",
  "agree",
  "apply",
  "approval",
  "approvals",
  "certificate",
  "confirm",
  "disapproval",
  "finished",
  "impression",
  "ink",
  "okay",
  "okey dokey",
  "permission",
  "permitted",
  "postage",
  "stamp",
  "true",
  "valid",
  "validated",
  "agent",
  "appoint",
  "approved",
  "assign",
  "assignee",
  "authorize",
  "confirmed",
  "delegate",
  "delegation",
  "depute",
  "empower",
  "entitle",
  "fingers",
  "gesture",
  "giving",
  "hand",
  "handoff",
  "nominate",
  "proxy",
  "selected",
  "sign off",
  "applications",
  "browse",
  "categories",
  "components",
  "devices",
  "four dots",
  "four squares",
  "launcher",
  "program menu",
  "programs",
  "service menu",
  "services",
  "squares",
  "app error",
  "app outage",
  "application error",
  "application failure",
  "apps error",
  "apps outage",
  "apps unavailable",
  "broken",
  "broken connection",
  "error",
  "failure",
  "network error",
  "nine squares",
  "outage",
  "server error",
  "service error",
  "service outage",
  "system failure",
  "unavailable apps",
  "atmosphere",
  "bismuth",
  "chat bubble",
  "citation",
  "conversation bubble",
  "dialogue",
  "discussion",
  "double quotes",
  "pollutants",
  "quotation",
  "quote marks",
  "quotes",
  "spoken words",
  "hotel",
  "indoor",
  "inside",
  "interior",
  "internal",
  "school",
  "augmented reality",
  "augmented view",
  "camera effect",
  "digital overlay",
  "experience",
  "face tracking",
  "interactive view",
  "layer",
  "live view",
  "overlay",
  "perception",
  "real world",
  "vision",
  "you",
  "creativity",
  "decorative",
  "effects",
  "embellish",
  "fun",
  "illustrations",
  "playful",
  "playground",
  "stickers",
  "symbols",
  "visuals",
  "draw",
  "engineering",
  "lineal",
  "resident",
  "town",
  "archive box",
  "bin",
  "categorize",
  "filing",
  "history",
  "memory",
  "past",
  "repository",
  "retrieve",
  "area chart",
  "area filled",
  "area graph",
  "chart filled",
  "filled area",
  "plot",
  "progress chart",
  "shaded area",
  "visual data",
  "arming",
  "incomplete circle",
  "ongoing",
  "partial circle",
  "progress bar",
  "barrier",
  "demarcation",
  "down",
  "extent",
  "guide",
  "scope",
  "straight",
  "DISABLE_IOS",
  "chevron",
  "disable_ios",
  "go back",
  "previous",
  "reverse",
  "shape.",
  "site",
  "undo",
  "indicate",
  "apple",
  "ios",
  "paginate",
  "pointy",
  "slide",
  "swipe",
  "collapse",
  "contained",
  "mover",
  "scroll",
  "within",
  "circle arrow",
  "circular arrow",
  "enclosed arrow",
  "inside circle",
  "pointing",
  "replay",
  "rounded arrow",
  "within circle",
  "arrow in circle",
  "directional arrow",
  "interface element",
  "direction up",
  "file upload",
  "go to top",
  "move forward",
  "move up",
  "navigate up",
  "positive direction",
  "progress up",
  "return to top",
  "scroll up",
  "conditions",
  "cool down",
  "cool off",
  "decrease",
  "decrease temperature",
  "down arrow",
  "fitbit",
  "forecast",
  "pointing down",
  "reading",
  "routine",
  "slow down",
  "thermometer",
  "descending",
  "downward",
  "dropdown",
  "minimize",
  "next step",
  "reveal",
  "show more",
  "go down",
  "outlined",
  "carat",
  "caret",
  "drop",
  "expand/collapse",
  "expander",
  "selector",
  "triangle down",
  "circled arrow",
  "circled down arrow",
  "disclosure",
  "expand down",
  "caret up",
  "collapse button",
  "directional indicator",
  "drop up",
  "fold",
  "fold up",
  "hide",
  "point up",
  "shrink",
  "sort button",
  "sort up",
  "triangle up",
  "direction indicator",
  "interface control",
  "advance",
  "disclose",
  "drilldown",
  "increment",
  "open",
  "pointing right",
  "step",
  "arrival",
  "inject",
  "pinpoint",
  "relocate",
  "triangular",
  "backward",
  "curve",
  "directionality",
  "angular",
  "backwards",
  "move left",
  "pointed",
  "step back",
  "variation",
  "linear",
  "narrow",
  "nav",
  "sidebar",
  "drawer",
  "reveal menu",
  "submenu",
  "unfold",
  "unhide",
  "orient",
  "direct",
  "exit button",
  "external",
  "follow link",
  "go to",
  "launch",
  "launch link",
  "leave",
  "new tab",
  "new window",
  "open link",
  "outbound",
  "redirect",
  "view more",
  "bidirectional",
  "bounds",
  "distance measurement",
  "double arrow",
  "extremes",
  "forth",
  "length",
  "opposite",
  "range indicator",
  "range limit",
  "span",
  "continuation",
  "cue",
  "arrow symbol",
  "east",
  "follow",
  "learn more",
  "read more",
  "manipulate",
  "mouse",
  "pick",
  "branch",
  "decision",
  "divergence",
  "fork",
  "one arrow",
  "paths",
  "routing",
  "splitting",
  "two arrows",
  "two directions",
  "two tails",
  "workflow",
  "northeast",
  "reposition",
  "top left",
  "west",
  "external link",
  "jump to",
  "open in new tab",
  "top right",
  "cloud upload",
  "file transfer",
  "loading bar",
  "sending",
  "sending data",
  "sending file",
  "status bar",
  "transferring",
  "uploading",
  "uploads",
  "document upload",
  "prepare",
  "ready",
  "server",
  "upload ready",
  "ascend",
  "elevate",
  "go up",
  "to top",
  "advancement",
  "higher",
  "top of page",
  "acceleration",
  "boost",
  "heat",
  "heating up",
  "hot",
  "improve",
  "lift",
  "readiness",
  "training",
  "warm up",
  "warmth",
  "arrow pointing down",
  "download file",
  "import data",
  "in",
  "ingress",
  "ingress data",
  "input data",
  "load",
  "receive data",
  "additional",
  "double",
  "collapsible",
  "expanding",
  "scrolling",
  "subtle",
  "subtle arrow",
  "escape",
  "corners",
  "diagonal arrows",
  "fit to screen",
  "strech",
  "zoom out",
  "album art",
  "song",
  "basic file",
  "document outline",
  "drive document",
  "file management",
  "office suite",
  "plain text",
  "productivity",
  "script",
  "simple document",
  "text file",
  "author",
  "biography",
  "blog",
  "profile page",
  "publication",
  "resume",
  "story",
  "writer",
  "excerpt",
  "magazine",
  "newspaper",
  "query reference",
  "quick access",
  "shortcut icon",
  "summary",
  "artist profile",
  "artistic expression",
  "creative person",
  "creator",
  "human figure",
  "musical",
  "musician",
  "painter",
  "performer",
  "persona",
  "producer",
  "sculptor",
  "singer",
  "aspect",
  "proportion",
  "ratio",
  "scaling",
  "widescreen",
  "clipboard",
  "education",
  "exam",
  "objective",
  "pen",
  "test",
  "academic",
  "course",
  "homework",
  "quick",
  "student",
  "teacher",
  "ID",
  "curriculum vitae",
  "ind",
  "portfolio",
  "!",
  "assignment late",
  "critical",
  "exception",
  "issue",
  "late",
  "overdue",
  "problem",
  "assignment return",
  "correction",
  "coursework",
  "give back",
  "learning",
  "left arrow",
  "redo",
  "resubmit",
  "retun",
  "revision",
  "submission",
  "submit",
  "assignment returned",
  "checked",
  "classwork",
  "grade",
  "graded",
  "marked",
  "returned",
  "review",
  "classroom",
  "handed in",
  "submitted",
  "turned in",
  "assisted living",
  "assistive device",
  "elderly",
  "injured",
  "injury",
  "nursing home",
  "physical therapy",
  "rehabilitation",
  "retirement",
  "senior",
  "therapy",
  "walk",
  "walking aid",
  "IoT",
  "ai",
  "artificial intelligence",
  "audio device",
  "connected device",
  "digital assistant",
  "home automation",
  "iot",
  "speaker device",
  "virtual assistant",
  "voice assistant",
  "advising",
  "angled arrow",
  "guide me",
  "leading",
  "left turn",
  "navigation assistant",
  "signage",
  "street sign",
  "suggesting direction",
  "turn by turn",
  "wayfinding",
  "assistant navigation",
  "chatbot",
  "direction arrow",
  "guidance",
  "AI",
  "hub",
  "on device",
  "assurance",
  "assured",
  "authenticated",
  "authorized",
  "certainty",
  "compliance",
  "confidential",
  "duty",
  "guarantee",
  "guard",
  "integrity",
  "protected",
  "reliability",
  "safe",
  "safeguard",
  "secured",
  "sensitive regulatory",
  "trust",
  "workload",
  "eight points",
  "emphasis",
  "five points",
  "footnote",
  "mandatory",
  "multiplication",
  "radial",
  "radial lines",
  "required",
  "seven points",
  "wildcard",
  "atm",
  "automated",
  "automated teller machine",
  "cash machine",
  "deposit",
  "finding",
  "keypads",
  "money machine",
  "slot",
  "teller",
  "withdrawal",
  "award",
  "best",
  "collaboration",
  "evaluation",
  "excellence",
  "favorite",
  "glitter",
  "gold star",
  "importance",
  "magic",
  "popular",
  "shine",
  "sparkle",
  "trending",
  "vote",
  "wish",
  "wish list",
  "add attachment",
  "attach file",
  "attach paper clip",
  "attachment",
  "compose email",
  "compose mail",
  "envelop",
  "include attachment",
  "include file",
  "link file",
  "paper clip",
  "paperclip",
  "document link",
  "email attachment",
  "fasten",
  "file connection",
  "file link",
  "paperclip symbol",
  "send file",
  "share file",
  "shared file",
  "upload file",
  "add button",
  "attach document",
  "attach file add",
  "attach media",
  "create button",
  "link document",
  "new attachment",
  "new document",
  "new file",
  "plus button",
  "upload attachment",
  "upload button",
  "upload document",
  "upload media",
  "attach file off",
  "attachment disabled",
  "broken link",
  "chain link",
  "connection off",
  "disconnect",
  "document link off",
  "file attachment",
  "file not attached",
  "file off",
  "link break",
  "link off",
  "no",
  "no attachment",
  "restrict",
  "unlink",
  "unlinked",
  "add money",
  "dollar sign",
  "exchange",
  "income",
  "monetization",
  "profit",
  "revenue",
  "sell",
  "connect file",
  "document management",
  "insert document",
  "insert file",
  "office supplies",
  "paperclip icon",
  "share document",
  "Ferris wheel",
  "amusement",
  "amusement park",
  "attractions",
  "excitement",
  "ferris",
  "park",
  "pleasure",
  "recreation",
  "spot",
  "theme park",
  "thrill",
  "tourism",
  "wheel",
  "allowed",
  "attribute",
  "attribution",
  "cc attribution",
  "copyright",
  "copywriter",
  "creative commons",
  "granted",
  "license",
  "licensed",
  "ownership",
  "public domain",
  "rights",
  "seal",
  "usage",
  "youtube",
  "youtube attribution",
  "audio description",
  "audio level",
  "blind",
  "commentary",
  "descriptive",
  "graphic equalizer",
  "narrated",
  "narration",
  "sound description",
  "sound level",
  "visually impaired",
  "voiceover",
  "vertical lines",
  "waveform",
  "amplifier",
  "audio equipment",
  "avr",
  "component",
  "home theater",
  "knobs",
  "receiver",
  "renderer",
  "stereo",
  "surround sound",
  "theater",
  "video equipment",
  "automatic",
  "awesome",
  "collage",
  "enhance",
  "mosaic",
  "pattern",
  "pieces",
  "rectangles",
  "tile",
  "burst",
  "decorate",
  "glow",
  "shimmer",
  "sparkles",
  "stylize",
  "auto delete",
  "automatic removal",
  "clean up",
  "content management",
  "data retention",
  "destroy",
  "erase",
  "expiration",
  "expiry",
  "garbage",
  "manage data",
  "self destruct",
  "timed",
  "timed deletion",
  "trash",
  "audio playback",
  "auto read",
  "halt",
  "pause button",
  "play button",
  "read",
  "read aloud",
  "text to speech",
  "audio control",
  "continuous play",
  "listen to text",
  "sound icon",
  "speech synthesis",
  "triangle and lines",
  "book",
  "books",
  "documentation",
  "flipping",
  "knowledge",
  "literature",
  "manual",
  "novel",
  "open book",
  "pages",
  "research",
  "stacked books",
  "study",
  "textbook",
  "two books",
  "wisdom",
  "breakdown",
  "flatbed",
  "garage",
  "hauling",
  "mechanic",
  "pull",
  "roadside",
  "tow",
  "tow truck",
  "towing",
  "winch",
  "automatic transmission",
  "automotive",
  "clutch",
  "gearbox",
  "gears",
  "manual transmission",
  "p r n d",
  "shifting",
  "stick shift",
  "A",
  "optimize",
  "automations",
  "efficiency",
  "industry",
  "mechanical",
  "mechanism",
  "node",
  "automatic pause",
  "autopause",
  "behavior",
  "playback control",
  "always play",
  "autoplay",
  "circle with arrow",
  "repeat",
  "autorenew",
  "cache",
  "cached",
  "curved",
  "inprogress",
  "loading refresh",
  "recycle",
  "rotating",
  "synchronization",
  "autostop",
  "cease",
  "filled square",
  "finish",
  "terminate",
  "transport controls",
  "anonymity",
  "avatar placeholder",
  "codec",
  "facial features",
  "head and shoulders",
  "high",
  "movies",
  "unknown user",
  "user settings",
  "elapsed time",
  "hours",
  "minutes",
  "set time",
  "stopclock",
  "stopwatch",
  "ticking",
  "timing",
  "advanced video coding",
  "avc",
  "decibel",
  "loudness",
  "meter",
  "mixer",
  "slider",
  "unmute",
  "volume control",
  "average",
  "lap",
  "monitoring",
  "pace",
  "sports",
  "workout",
  "mean",
  "wellness",
  "contest",
  "emblem",
  "first place",
  "medal",
  "prize",
  "reward",
  "ribbon",
  "trophy",
  "win",
  "winner",
  "active zone minutes",
  "ajax",
  "ajax loader",
  "ajax spinner",
  "animated",
  "background",
  "fetch",
  "incomplete",
  "spinner",
  "updating",
  "amenities",
  "babies",
  "baby",
  "bathroom",
  "changing",
  "changing station",
  "diaper",
  "facilities",
  "father",
  "infant",
  "lavatory",
  "mother",
  "nappy",
  "newborn",
  "nursery",
  "parent and child room",
  "parents room",
  "public restrooms",
  "rest area",
  "restroom",
  "station",
  "toddler",
  "toilets",
  "w.c.",
  "wc",
  "anatomy",
  "appendage",
  "back of hand",
  "backhand",
  "body part",
  "five fingers",
  "high five",
  "index finger",
  "knuckles",
  "limb",
  "middle finger",
  "open hand",
  "palm",
  "palm facing away",
  "pinky",
  "raised",
  "ring finger",
  "talk to the hand",
  "thumb",
  "leftward",
  "mono",
  "previous page",
  "previous step",
  "single",
  "basic shape",
  "bullet point",
  "design element",
  "elemental",
  "filled circle",
  "graphic element",
  "large circle",
  "large dot",
  "large point",
  "simple shape",
  "single dot",
  "single point",
  "solid circle",
  "small dot",
  "tiny",
  "ux element",
  "visual element",
  "4x4",
  "background grid",
  "cells",
  "customization",
  "drafting",
  "grid lines",
  "planning",
  "small grid",
  "texture",
  "tiling",
  "add background",
  "alpha channel",
  "backdrop",
  "background replace",
  "cut out",
  "image editing",
  "isolation",
  "photo editing",
  "remove background",
  "replace",
  "stripes",
  "subject",
  "swap",
  "transformation",
  "webcam",
  "backlight",
  "backlit",
  "bright",
  "brightness",
  "exposure",
  "glare",
  "intensity",
  "light",
  "luminous",
  "ray",
  "system settings",
  "visibility",
  "dimmed",
  "high brightness",
  "dim",
  "dimmer",
  "faint",
  "half",
  "illuminated",
  "partial",
  "adventure",
  "backpack",
  "bookbag",
  "camping",
  "camping bag",
  "carry",
  "college",
  "daypack",
  "hiking",
  "hiking bag",
  "knapsack",
  "luggage",
  "pack",
  "rucksack",
  "satchel",
  "supplies",
  "travel bag",
  "backspace",
  "input field",
  "duplicate",
  "files folders",
  "restore",
  "migration",
  "employee",
  "heraldic",
  "heraldry",
  "honor",
  "id card",
  "name",
  "rank",
  "battery",
  "charge",
  "depleted",
  "electric",
  "energy",
  "exhausted",
  "laptop",
  "percentage",
  "power",
  "zero",
  "baked goods",
  "bakery",
  "baking",
  "bread",
  "breakfast",
  "brunch",
  "cafe",
  "catering",
  "croissant",
  "cuisine",
  "dessert",
  "dining",
  "eat",
  "food service",
  "meal",
  "oven",
  "pastry",
  "patisserie",
  "restaurant",
  "savory",
  "serving",
  "snack",
  "sweet",
  "treat",
  "compare",
  "compare and contrast",
  "court",
  "equilibrium",
  "equity",
  "fair",
  "impartiality",
  "judgment",
  "justice",
  "law",
  "parity",
  "scales",
  "stability. equilibrium",
  "steadiness",
  "symmetry",
  "two pans",
  "two sides",
  "weighing",
  "weight",
  "balcony",
  "doors",
  "exterior",
  "living space",
  "loggia",
  "open air",
  "outdoor space",
  "railing",
  "residential building",
  "stay",
  "terrace",
  "veranda",
  "ballot",
  "bullet",
  "checkbox",
  "democracy",
  "election",
  "political",
  "poll",
  "polling",
  "vote box",
  "voting",
  "x",
  "data analysis",
  "financial data",
  "growth icon",
  "report icon",
  "statistics icon",
  "visual representation",
  "comparison",
  "health dashboard",
  "health metric dashboard",
  "health monitoring",
  "oxygen",
  "bar chart off",
  "bar graph",
  "blocked",
  "excluded",
  "strike",
  "barcode",
  "inventory",
  "merchandise",
  "qr code",
  "stripe",
  "universal product code",
  "upc",
  "handheld",
  "reader",
  "machine readable",
  "optic",
  "quick response",
  "bare feet",
  "floor",
  "foot",
  "footmark",
  "footprint",
  "footprint trail",
  "footstep",
  "footsteps",
  "left foot",
  "right foot",
  "sole",
  "stepping",
  "steps",
  "toes",
  "trace",
  "trail",
  "algorithms",
  "batch",
  "bulb",
  "bulk",
  "computations",
  "documents",
  "idea",
  "large scale",
  "machine learning",
  "prediction",
  "predictions",
  "backyard",
  "bath",
  "bathe",
  "bathhouse",
  "bathing",
  "bubbles",
  "hot spring",
  "hot springs",
  "hot tub",
  "hydrotherapy",
  "jacuzzi",
  "onsen",
  "patio",
  "pool",
  "resort",
  "spa",
  "steam",
  "swimming",
  "warm",
  "bathtub",
  "cleaning",
  "couple",
  "exclusive",
  "hotel amenities",
  "limited access",
  "lodging",
  "sanitary",
  "soaking",
  "tub",
  "washing",
  "facility",
  "sanitation",
  "shower",
  "toilet",
  "washroom",
  "male and female",
  "men",
  "plumbing",
  "public access",
  "public toilet",
  "sprinkler",
  "universal sign",
  "wash",
  "water closet",
  "women",
  "bathroom fixture",
  "body care",
  "hygiene product",
  "pamper",
  "self care",
  "self-care",
  "soak",
  "soak in",
  "washing up",
  "1 bar",
  "20 percent",
  "20%",
  "charging",
  "electrical",
  "gauge",
  "one bar",
  "twenty percent",
  "2 bars",
  "30 percent",
  "battery indicator",
  "battery level",
  "charge level",
  "medium",
  "power status",
  "segmented",
  "thirty percent",
  "two bars",
  "50%",
  "battery gauge",
  "battery icon",
  "battery meter",
  "battery status",
  "charge status",
  "energy level",
  "intermediate",
  "power icon",
  "power level",
  "remaining energy",
  "remaining power",
  "almost full",
  "capacity",
  "five bars",
  "remaining",
  "six bars",
  "80%",
  "five segments",
  "four fifths",
  "high level",
  "notification icon",
  "rechargeable",
  "system icon",
  "90",
  "charged",
  "full battery",
  "high battery",
  "nearly full",
  "ninety",
  "device status",
  "exclamation point",
  "low battery",
  "system status",
  "dead",
  "power source",
  "power management",
  "rounded corners",
  "battery life",
  "electricity",
  "empty battery",
  "interface icon",
  "recharger",
  "third",
  "25 percent",
  "battery charge",
  "battery percentage",
  "device battery",
  "mobile power",
  "phone battery",
  "quarter",
  "six",
  "notification bar",
  "bolt",
  "instant",
  "lightning",
  "thunderbolt",
  "saver",
  "?",
  "charging status",
  "low power",
  "punctuation",
  "question",
  "question mark",
  "troubleshooting",
  "unknown",
  "unknown battery",
  "android share",
  "battery power",
  "battery share",
  "connected dots",
  "three dots",
  "three points",
  "android battery",
  "defense",
  "health status",
  "mobile battery",
  "protected battery",
  "safe battery",
  "life",
  "maintenance",
  "recharge",
  "surge",
  "electric charge",
  "plugged in",
  "lightning bolt",
  "percent",
  "plug",
  "remaining battery",
  "sạc",
  "thirty",
  "điện",
  "50 percent",
  "60%",
  "charge icon",
  "partially full",
  "sixty percent",
  "80 percent",
  "accumulator",
  "charging station",
  "eighty",
  "electric vehicle",
  "charge indicator",
  "energy status",
  "nine zero",
  "charging up",
  "power supply",
  "power up",
  "thunder",
  "depleted battery",
  "malfunction",
  "x mark",
  "full charge",
  "max charge",
  "power indicator",
  "standard battery",
  "available",
  "full power",
  "fully charged",
  "discharged",
  "drained",
  "fifty percent",
  "half charge",
  "half full",
  "halfway",
  "75%",
  "75% battery",
  "three quarters",
  "battery low",
  "deplete",
  "weak battery",
  "consumption",
  "add battery",
  "battery boost",
  "battery optimization",
  "battery plus",
  "battery saver",
  "conserve battery",
  "device settings",
  "energy saver",
  "energy saving",
  "extend battery",
  "low power mode",
  "optimize battery",
  "power save",
  "power saving",
  "save battery",
  "give",
  "pair",
  "utility",
  "good",
  "resource",
  "beach",
  "coastal",
  "coastline",
  "getaway",
  "outdoors",
  "parasol",
  "sand",
  "shade",
  "sunny",
  "sunshade",
  "tropical",
  "umbrella",
  "bedroom",
  "bedtime",
  "blanket",
  "dreaming",
  "furniture",
  "hostel",
  "inn",
  "king",
  "mattress",
  "motel",
  "nap",
  "night",
  "pillow",
  "pillows",
  "queen",
  "siesta",
  "childhood",
  "cradle",
  "crib",
  "domestic",
  "horse",
  "rocking",
  "room type",
  "cot",
  "twin",
  "adult",
  "parents",
  "sizem master",
  "astronomy",
  "calm",
  "celestial",
  "celestial bodies",
  "clear night",
  "clear sky",
  "cosmos",
  "crescent moon",
  "dark",
  "evening",
  "evening sky",
  "galaxy",
  "lunar",
  "midnight",
  "moon",
  "nightime",
  "nocturnal",
  "peaceful",
  "quiet time",
  "slumber",
  "stars",
  "crescent",
  "dream",
  "zzz",
  "acknowledgement",
  "been",
  "beenhere",
  "check-in",
  "geographic",
  "here",
  "previously",
  "remember",
  "seen",
  "visited",
  "visited place",
  "bento",
  "compartments",
  "dinner",
  "lunch",
  "matrix",
  "modules",
  "shortcuts",
  "takeout",
  "tiles",
  "blinking",
  "bodies",
  "body composition",
  "bone",
  "fat",
  "input box",
  "muscle",
  "text box",
  "bid",
  "fusion",
  "integrate",
  "interconnected",
  "records",
  "relation",
  "relationship",
  "grayed out",
  "bigtop",
  "bigtop updates",
  "bulletin",
  "ping",
  "subscription",
  "updates",
  "bicycle",
  "bicycle parking",
  "bike",
  "bike dock",
  "bike rack",
  "bike stand",
  "bike station",
  "commute",
  "cycling",
  "dock",
  "parking",
  "rack",
  "rent",
  "stand",
  "bike lane",
  "bike riding",
  "lane",
  "pictograph",
  "riding",
  "road sign",
  "glyph",
  "handlebars",
  "micromobility",
  "outdoor activity",
  "pedal",
  "personal transport",
  "scooter",
  "short trip",
  "two wheels",
  "urban transport",
  "vespa",
  "wheels",
  "bio",
  "biology",
  "biotech",
  "biotechnology",
  "chemistry",
  "chromosome",
  "dna",
  "experiment",
  "gene",
  "genetic engineering",
  "genetics",
  "helix",
  "innovation",
  "laboratory",
  "microscope",
  "molecular",
  "pharmaceutical",
  "science",
  "spiral",
  "strand",
  "bed covering",
  "bedding",
  "comforter",
  "covering",
  "cozy",
  "cozy object",
  "curves",
  "folded",
  "furnishing",
  "home goods",
  "linen",
  "material",
  "quilt",
  "rippled",
  "soft",
  "throw",
  "wrap",
  "appliance icon",
  "beverage",
  "blade",
  "blend",
  "blend icon",
  "blender",
  "blending",
  "cook",
  "cooking",
  "crushed",
  "culinary",
  "drink",
  "food preparation",
  "ingredients",
  "jug",
  "juicer",
  "kitchen",
  "kitchen appliance",
  "kitchen icon",
  "liquid",
  "mix",
  "mixing",
  "smoothie",
  "smoothie icon",
  "vitamix",
  "cane",
  "inaccessible",
  "obscured",
  "secret",
  "blinds",
  "curtains",
  "home decor",
  "light control",
  "shades",
  "venetian blinds",
  "window covering",
  "block light",
  "closed",
  "darkness",
  "opaque",
  "room darkener",
  "shutters",
  "sunblock",
  "window blinds",
  "avoid",
  "disturb",
  "do not disturb",
  "limitation",
  "negative",
  "not interested",
  "off limits",
  "prohibit",
  "prohibited",
  "quit",
  "reject",
  "arterial pressure",
  "blood flow",
  "blood pressure",
  "cardiogram",
  "cardiograph",
  "ecg",
  "ekg",
  "heart",
  "heartbeat",
  "medical device",
  "pressure",
  "pulse",
  "vital signs",
  "vital stats",
  "blood",
  "blood drop",
  "blood type",
  "bloodtype",
  "donate",
  "droplet",
  "health data",
  "medical records",
  "personal data",
  "bluetooth",
  "cast",
  "pairing",
  "paring",
  "zig-zag",
  "headphones",
  "peripheral",
  "hard drive",
  "pc",
  "transfer data",
  "connecting",
  "searching",
  "blur",
  "bokeh",
  "distortion",
  "gaussian",
  "out of focus",
  "radial blur",
  "softening",
  "unfocused",
  "diffused",
  "fade",
  "fuzzy",
  "gaussian blur",
  "gradient",
  "gradual",
  "graphic editing",
  "graphic effect",
  "hazy",
  "image effect",
  "left to right",
  "linear blur",
  "photo effect",
  "soft blur",
  "soften",
  "unfocus",
  "blur effect",
  "blurry",
  "depth of field",
  "masking",
  "medium blur",
  "obscuring",
  "photo filter",
  "soft focus",
  "visual effect",
  "blur off",
  "dashed lines",
  "deblur",
  "disable blur",
  "image processing",
  "no blur",
  "remove blur",
  "switch off",
  "toggle off",
  "turn off",
  "unblur",
  "activate",
  "dot pattern",
  "effect on",
  "enable",
  "state",
  "turn on",
  "conceal",
  "horizontal blur",
  "level indicator",
  "short",
  "short blur",
  "aquatic",
  "aquatic transport",
  "boat and bus",
  "ferry",
  "freight",
  "land transport",
  "shipping",
  "voyage",
  "water taxi",
  "wheeled",
  "cargo",
  "connection point",
  "intermodal",
  "monorail",
  "point to point",
  "rail",
  "railway",
  "subway",
  "tram",
  "biometric data",
  "bmi",
  "body fat",
  "body mass",
  "body metrics",
  "caliper",
  "data visualization",
  "fat percentage",
  "fitness app",
  "health app",
  "health tracking",
  "lifestyle",
  "medical data",
  "nutrition",
  "personal health",
  "anatomical",
  "biological",
  "diagrammatic",
  "human body",
  "organ systems",
  "organism",
  "physiology",
  "scientific",
  "flash",
  "storm",
  "zap",
  "atomic",
  "attack",
  "blast",
  "blasts",
  "bomb",
  "boom",
  "breach",
  "bursts",
  "crisis",
  "critical error",
  "danger symbol",
  "destruction",
  "disaster",
  "explode",
  "explosion",
  "explosive",
  "hazard",
  "loud",
  "mine",
  "risk",
  "sabotage",
  "security risk",
  "threat",
  "threat icon",
  "urgent alert",
  "warning sign",
  "academy",
  "book icon",
  "class icon",
  "education icon",
  "knowledge icon",
  "learning icon",
  "literature icon",
  "open book icon",
  "reading icon",
  "reading material",
  "school icon",
  "university",
  "university icon",
  "learn",
  "learn icon",
  "library icon",
  "sheets",
  "study icon",
  "two pages",
  "bound",
  "encyclopedia",
  "spine",
  "dictionary",
  "teach",
  "chapters",
  "poetry",
  "academia",
  "narrative",
  "admission",
  "concert",
  "digital ticket",
  "e-ticket",
  "entry pass",
  "event ticket",
  "mobile ticket",
  "museum",
  "travel ticket",
  "validation",
  "saved",
  "keep",
  "tutorial",
  "web page",
  "reading list",
  "marker_add",
  "marker_plus",
  "placeholder_add",
  "placeholder_plus",
  "reading_list",
  "saved_item",
  "saved_location",
  "saved_page",
  "tab",
  "tagging",
  "tagging_add",
  "tagging_plus",
  "baggage",
  "bookmark list",
  "classify",
  "registry",
  "saved list",
  "suitcase",
  "bookmark confirmed",
  "confirmation",
  "confirmed bookmark",
  "fulfilled",
  "saved bookmark",
  "contour",
  "country",
  "flag",
  "flags",
  "highlighted",
  "interest",
  "milepost",
  "nation",
  "pole",
  "save for later",
  "save page",
  "appreciate",
  "love",
  "bookmark manager",
  "bookmarking",
  "draft",
  "favorites",
  "filled shape",
  "filled star",
  "five point star",
  "managing bookmarks",
  "pointed star",
  "sharp star",
  "solid shape",
  "solid star",
  "unfavorite",
  "unmark",
  "unsave",
  "bookmarks",
  "arts",
  "culture",
  "hobbies",
  "interests",
  "listening",
  "resources",
  "watching",
  "entire",
  "separate",
  "add border",
  "apply border",
  "border bottom",
  "border style",
  "bottom edge",
  "bottom line",
  "cell border",
  "delete border",
  "element border",
  "line below",
  "page border",
  "remove border",
  "row border",
  "table border",
  "table formatting",
  "text border",
  "text decoration",
  "underline",
  "border clear",
  "border none",
  "borderless",
  "clear border",
  "no border",
  "remove frame",
  "remove line",
  "remove outline",
  "border color",
  "color",
  "colour",
  "sketch",
  "UI element",
  "content break",
  "delineation",
  "document break",
  "horizontal border",
  "hr",
  "layout control",
  "line break",
  "rule line",
  "section break",
  "visual separation",
  "border inner",
  "define",
  "divisions",
  "inner",
  "border left",
  "indentation",
  "margin",
  "publishing",
  "border outer",
  "boundaries",
  "outer",
  "border right",
  "right border",
  "right edge",
  "thin line",
  "appearance",
  "thickness",
  "border top",
  "line segment",
  "thick line",
  "top line",
  "visual aid",
  "column break",
  "divide vertically",
  "edges",
  "pane",
  "split vertically",
  "vertical border",
  "assimilation",
  "borg",
  "collective",
  "cybernetic",
  "cyborg",
  "deep space nine",
  "drone",
  "entity",
  "fictional",
  "hive mind",
  "next generation",
  "sci-fi",
  "science fiction",
  "star trek",
  "unity",
  "voyager",
  "actions",
  "app bar",
  "bottom app bar",
  "bottom bar",
  "control bar",
  "footer",
  "footer bar",
  "horizontal bar",
  "menu bar",
  "mobile ui",
  "navigation bar",
  "primary actions",
  "bottom drawer",
  "pull up",
  "thin rectangle",
  "bottom aligned",
  "bottom navigation",
  "full bleed",
  "full width",
  "mobile navigation",
  "tab bar",
  "discard",
  "dismiss",
  "panels",
  "retract",
  "spaces",
  "arrow head",
  "bottom right",
  "quadrant",
  "south",
  "additional options",
  "bottom sheet",
  "expanded view",
  "modal",
  "closed box",
  "metaphor",
  "parcel",
  "shipment",
  "carton",
  "crate",
  "stock",
  "rearrange",
  "avatar icon",
  "boy",
  "default avatar",
  "man",
  "awareness",
  "line chart",
  "reporting",
  "bond",
  "branding",
  "fonts",
  "members",
  "styles",
  "tester",
  "typefaces",
  "asset",
  "branding watermark",
  "imprint",
  "trademark",
  "transparency",
  "butter",
  "delicious",
  "diner",
  "dish",
  "edible",
  "egg",
  "fried egg",
  "plate",
  "protein",
  "sunny side up",
  "tasty",
  "toast",
  "yolk",
  "alert icon",
  "breaking news",
  "broadcasting",
  "communication icon",
  "headline",
  "headlines",
  "important icon",
  "media icon",
  "news flash",
  "news icon",
  "update icon",
  "urgent news",
  "breaking",
  "exclamation mark",
  "breast",
  "breastfed",
  "breastfeed",
  "breastfeeding",
  "cuddle",
  "feeding",
  "hug",
  "lactation",
  "mama",
  "maternity",
  "milk",
  "mom",
  "mommy",
  "motherhood",
  "nourishment",
  "nursing",
  "pediatrician",
  "woman",
  "brick",
  "building block",
  "cement",
  "establish",
  "foundation",
  "games",
  "masonry",
  "module",
  "mortar",
  "part",
  "piece",
  "stone",
  "sturdy",
  "wall",
  "centralized",
  "focused",
  "lone",
  "orb",
  "perfect",
  "unified",
  "contrast",
  "theme",
  "celestial body",
  "low light",
  "phases",
  "satellite",
  "dark mode",
  "illumination",
  "luminance",
  "adjust icon",
  "calibrate",
  "control icon",
  "five point",
  "rays",
  "setting icon",
  "solar",
  "visible",
  "day",
  "spokes",
  "dazzling",
  "intense",
  "radiant",
  "shiny",
  "viewing",
  "vivid",
  "overexposed",
  "white sun",
  "yellow triangle",
  "ambient light",
  "auto adjust",
  "automatic brightness",
  "brightness auto",
  "screen brightness",
  "sensing",
  "0",
  "bring",
  "bring your own",
  "custom",
  "digital address",
  "internet protocol",
  "ip",
  "ip address",
  "network address",
  "own",
  "protocol",
  "your",
  "remote",
  "transmit",
  "wireless communication",
  "antenna",
  "me",
  "radiating",
  "broken file",
  "broken image",
  "broken picture",
  "corrupt",
  "corrupt file",
  "corrupted image",
  "failed to load",
  "image error",
  "image not found",
  "image placeholder",
  "image unavailable",
  "invalid image",
  "missing content",
  "missing image",
  "picture error",
  "placeholder image",
  "torn",
  "catalog",
  "categorized",
  "directory",
  "paper stack",
  "papers",
  "reports",
  "activity feed",
  "browsing",
  "chronological",
  "entries",
  "events",
  "history list",
  "log",
  "log entries",
  "recent",
  "albums",
  "browse albums",
  "browse gallery",
  "browse images",
  "browse photos",
  "collection of images",
  "collection of photos",
  "explore gallery",
  "grid view",
  "media library",
  "photos",
  "pictures",
  "visual media",
  "green tick",
  "installed",
  "new version",
  "updated",
  "verification",
  "web browser",
  "bistro",
  "champagne",
  "cutlery",
  "dining room",
  "diningware",
  "eatery",
  "eating",
  "knife",
  "mealtime",
  "nourish",
  "repast",
  "silverware",
  "spoon",
  "utensils",
  "artistic",
  "bristle",
  "brush",
  "designer",
  "drawing tool",
  "instrument",
  "paint",
  "painting",
  "painting tool",
  "balloon",
  "comic",
  "comic strip",
  "communication bubble",
  "speak",
  "talk bubble",
  "talking",
  "text bubble",
  "texting",
  "thinking",
  "thought",
  "thought bubble",
  "white space",
  "bubble chart",
  "clusters",
  "data points",
  "scatter plot",
  "spheres",
  "statistical",
  "airy",
  "carbonation",
  "effervescence",
  "fizzy",
  "floating",
  "foam",
  "soap bubbles",
  "soda",
  "animal",
  "bug",
  "bug icon",
  "circle with legs",
  "error report",
  "eyes",
  "feedback report",
  "insect",
  "insect icon",
  "issue report",
  "legs",
  "problem report",
  "six legs",
  "solve",
  "suggestion",
  "suggestion report",
  "technical issue",
  "testing",
  "fixing",
  "general",
  "industrial",
  "machinery",
  "repair",
  "spanner",
  "toolkit",
  "engineer",
  "bungalow",
  "chimney",
  "cottage",
  "home icon",
  "house icon",
  "property listing",
  "roof",
  "simple house",
  "small house",
  "traveling",
  "burst mode",
  "many",
  "rapid",
  "repeating",
  "shoot",
  "shooting",
  "snapping",
  "taking",
  "carriage",
  "locomotive",
  "metro",
  "wagon",
  "assets",
  "belongings",
  "career",
  "carrying",
  "case",
  "goods",
  "professional",
  "agency",
  "business card",
  "chip",
  "chip card",
  "corporation",
  "firm",
  "headquarters",
  "operations",
  "profile card",
  "communication channel",
  "consultation",
  "message bubble",
  "messages",
  "online chat",
  "receive message",
  "send message",
  "trade",
  "UI",
  "door",
  "log cabin",
  "walls",
  "wood",
  "cable",
  "connector",
  "cord",
  "network cable",
  "socket",
  "wire",
  "aerial",
  "alpine",
  "cable car",
  "gondola",
  "mountain transportation",
  "skiing",
  "suspended",
  "audio bars",
  "audio graph",
  "beat",
  "beat per minute",
  "beats per minute",
  "bpm",
  "cadence",
  "consistent",
  "frequency bars",
  "music bars",
  "rhythm",
  "steps per minute",
  "tempo",
  "volume bars",
  "anniversary",
  "baked",
  "birthday",
  "cake",
  "candle",
  "candles",
  "celebration",
  "confection",
  "festive",
  "frosting",
  "happy birthday",
  "occasion",
  "pastries",
  "slice",
  "special occasion",
  "sugar",
  "adding item",
  "bake",
  "dessert item",
  "icing",
  "make",
  "sugary",
  "-",
  "=",
  "calculate",
  "calculator",
  "equals",
  "finance calculator",
  "math operations",
  "number pad",
  "numpad",
  "subtraction",
  "agenda",
  "month",
  "planner",
  "today",
  "year",
  "add-on",
  "apps script",
  "plugin",
  "later",
  "timetable",
  "meeting",
  "organizer",
  "period",
  "scheduling",
  "week",
  "calendaricon",
  "calendartoday",
  "daily",
  "dating",
  "diary",
  "monthly",
  "punctual",
  "todaycalendar",
  "yearly",
  "appointments",
  "day view",
  "list view",
  "scheduler",
  "weekly",
  "dates",
  "days",
  "overview",
  "seven days",
  "audio call",
  "call icon",
  "contact us",
  "handset",
  "helpline",
  "incoming call",
  "local phone",
  "outgoing call",
  "phone alt",
  "phone icon",
  "decline",
  "hang up",
  "outgoing",
  "call history",
  "call log",
  "communication history",
  "missed calls",
  "phone call",
  "telephone history",
  "call made",
  "line arrow",
  "made",
  "top right arrow",
  "connect points",
  "connecting points",
  "consolidate",
  "consolidate lines",
  "converge",
  "converging lines",
  "flowchart",
  "union",
  "angle down",
  "call status",
  "declined call",
  "diagonal down",
  "dialing",
  "dropped call",
  "missed",
  "missed call",
  "phone symbol",
  "recent calls",
  "telephony",
  "attempted",
  "failed",
  "unfinished",
  "i",
  "answering",
  "call received",
  "inbound call",
  "call split",
  "diverge",
  "multiply",
  "clicking",
  "cta",
  "cursor hand",
  "fingertip",
  "interacting",
  "touch screen",
  "aperture",
  "capture device",
  "snapshot",
  "viewfinder",
  "camera flip",
  "conference",
  "facing",
  "flip",
  "front",
  "front camera",
  "mobile camera",
  "portrait mode",
  "self portrait",
  "selfie",
  "switch camera",
  "user facing camera",
  "video call",
  "cctv",
  "dome camera",
  "filming",
  "home security",
  "indoor camera",
  "interior camera",
  "ip camera",
  "live feed",
  "network camera",
  "security camera",
  "surveillance",
  "surveillance camera",
  "video feed",
  "footage",
  "outdoor camera",
  "camera app",
  "content creation",
  "image capture",
  "rear",
  "rear camera",
  "camera roll",
  "digital photos",
  "image collection",
  "image gallery",
  "memories",
  "photo album",
  "photo collection",
  "photo storage",
  "photography collection",
  "roll",
  "saved photos",
  "view photos",
  "cam",
  "desk",
  "back camera",
  "camera switch",
  "camera toggle",
  "cameraswitch",
  "change camera",
  "circular arrows",
  "flip camera",
  "photo camera",
  "rotate camera",
  "selfie camera",
  "video camera",
  "video chat",
  "megaphone",
  "pennant",
  "victory",
  "camp",
  "exploration",
  "forest",
  "hike",
  "peak",
  "tent",
  "wilderness",
  "highlight off",
  "incorrect",
  "invalid",
  "abort",
  "denial",
  "diagonal lines",
  "exclude",
  "present",
  "projector",
  "rejection",
  "revoke",
  "slideshow",
  "cancel schedule send",
  "delayed",
  "scheduled email",
  "scheduled mail",
  "scheduled message",
  "unschedule",
  "burn",
  "candelabra",
  "candlestick",
  "christmas",
  "fire",
  "flame",
  "ideology",
  "lighting",
  "line art",
  "meditation",
  "memorial",
  "religion",
  "religious",
  "rounded top",
  "slender",
  "spiritual",
  "tapered",
  "torch",
  "wax",
  "wick",
  "worship",
  "chart bars",
  "economic analysis",
  "economics",
  "investment chart",
  "stock analysis",
  "stock data",
  "stock market",
  "trading",
  "trading chart",
  "bud",
  "cannabis",
  "cbd",
  "drug",
  "hemp",
  "herbal",
  "illegal",
  "indica",
  "marijuana",
  "medicinal",
  "plant life",
  "sativa",
  "smoke",
  "thc",
  "weed",
  "authentication required",
  "captive",
  "captive portal",
  "connect to network",
  "gateway",
  "internet connection",
  "language",
  "login required",
  "network access",
  "network gateway",
  "network login",
  "northwest",
  "planet",
  "portal",
  "restricted access",
  "wifi access",
  "www",
  "area selection",
  "moment",
  "picture in picture",
  "screengrab",
  "screenshot",
  "still",
  "collision",
  "crash",
  "damage",
  "damaged",
  "dangerous",
  "impact",
  "incident",
  "insurance",
  "motor vehicle",
  "wreck",
  "blow",
  "car feature",
  "car settings",
  "climate control",
  "climate settings",
  "defog",
  "defrost",
  "defroster",
  "rear window",
  "rear windshield",
  "window heating",
  "windshield",
  "condensation",
  "fog",
  "air flow",
  "lower",
  "wavy lines",
  "auto climate",
  "automotive controls",
  "car climate",
  "car icons",
  "car symbols",
  "driver side",
  "heated mirrors",
  "heated seats",
  "rear window defrost",
  "window defrost",
  "windshield defrost",
  "mid right",
  "mist",
  "side window",
  "temperature.",
  "thaw",
  "un-fog",
  "un-ice",
  "melt",
  "air circulation",
  "blower",
  "left direction",
  "air vent",
  "air direction",
  "automotive control",
  "automotive setting",
  "car vent",
  "fan control",
  "fan direction",
  "low setting",
  "right direction",
  "vehicle control",
  "mid",
  "air flow direction",
  "ventilation direction",
  "air intake",
  "clockwise",
  "inside air",
  "internal air",
  "recirculate",
  "application settings",
  "car gear",
  "access control",
  "car door",
  "latch",
  "locked",
  "password",
  "release",
  "unlock",
  "unlocked",
  "auto heat",
  "car controls",
  "car defrost",
  "car features",
  "car heating",
  "mirror",
  "rear view mirror",
  "side mirror",
  "sideview",
  "window heat",
  "wing mirror",
  "car sharing",
  "hire",
  "lease",
  "rent a car",
  "rental",
  "diagnostics",
  "engine",
  "trouble",
  "tuning",
  "workshop",
  "allowance",
  "auto tag",
  "car label",
  "id tag",
  "identification tag",
  "license plate",
  "number plate",
  "permit",
  "permit tag",
  "security tag",
  "sticker",
  "vehicle identification",
  "club",
  "club card",
  "enrollment",
  "loyalty",
  "loyalty card",
  "vip",
  "miles",
  "packing",
  "biometric",
  "cardio",
  "cardiovascular",
  "exertion",
  "heart rate",
  "physiological",
  "training effort",
  "training load",
  "cardiology",
  "health monitor",
  "heart health",
  "physician",
  "tracing",
  "cards",
  "deck",
  "cards star",
  "game",
  "layered",
  "overlapping",
  "scratchcard",
  "carpenter",
  "craft",
  "cutting",
  "handyman",
  "labor",
  "manual labor",
  "occupation",
  "profession",
  "saw",
  "skill",
  "woodworking",
  "worker",
  "airport icon",
  "bag icon",
  "carry on",
  "luggage bag",
  "moving",
  "suitcase icon",
  "travel case",
  "travel gear",
  "carry-on",
  "greyed out",
  "not selected",
  "overhead bin",
  "overhead compartment",
  "bag allowance",
  "bag size",
  "baggage allowance",
  "inquiry",
  "policy",
  "regulations",
  "travel policy",
  "travel question",
  "briefcases",
  "bureaucracy",
  "cases",
  "file cabinet",
  "structured",
  "betting",
  "betting game",
  "casino",
  "casino chip",
  "chance",
  "chance game",
  "chips",
  "dice",
  "gamble",
  "gambling",
  "gambling game",
  "jackpot",
  "leisure activity",
  "luck",
  "luck game",
  "nightlife",
  "payout",
  "slot machine",
  "tokens",
  "triple bar",
  "winning",
  "chromecast",
  "push",
  "screencast",
  "beaming",
  "cast connected",
  "link established",
  "mirroring",
  "projecting",
  "smart tv",
  "for",
  "lecture",
  "lessons teaching",
  "interruption",
  "screen casting",
  "disconnection",
  "fail",
  "triangle with exclamation",
  "abode",
  "ancient",
  "battlement",
  "castle",
  "domain",
  "fairytale",
  "fort",
  "fortress",
  "historical",
  "kingdom",
  "mansion",
  "medieval",
  "monument",
  "palace",
  "royal",
  "stronghold",
  "turrets",
  "chains",
  "charts",
  "concepts",
  "diagrams",
  "hierarchical",
  "ideas",
  "links",
  "networks",
  "orbs",
  "relate",
  "related",
  "shapes",
  "structures",
  "three circles",
  "trees",
  "classification",
  "inspect",
  "investigation",
  "look for",
  "narrow down",
  "products",
  "refine",
  "zoom in",
  "confetti",
  "congratulations",
  "fireworks",
  "joy",
  "surprise",
  "cell merge",
  "cells together",
  "column merge",
  "combine cells",
  "data grid",
  "data merge",
  "inward",
  "join cells",
  "merge cells",
  "row merge",
  "table merge",
  "two cells",
  "unite cells",
  "worksheet",
  "cell tower",
  "gsm",
  "mast",
  "radio tower",
  "transmission tower",
  "transmitting",
  "crosshairs",
  "precision",
  "accuracy",
  "aim",
  "bulls-eye",
  "center focus weak",
  "cross hairs",
  "four corners",
  "reticle",
  "weak",
  "couch",
  "living",
  "living room",
  "lounging",
  "loveseat",
  "sofa",
  "cahir",
  "A-frame",
  "chalet",
  "countryside",
  "dwelling place",
  "lodge",
  "retreat",
  "modification",
  "transition",
  "audit trail",
  "change history",
  "chronology",
  "edits",
  "evolution",
  "journal",
  "modifications",
  "progression",
  "revisions",
  "track changes",
  "version history",
  "adapter",
  "batteries",
  "charger",
  "electric current",
  "ev",
  "outlet",
  "power cord",
  "refill",
  "refill energy",
  "supply",
  "fill up",
  "juice",
  "mobile charging",
  "power station",
  "top up",
  "wireless charging",
  "figures",
  "chat balloon",
  "forum",
  "square with tail",
  "tail",
  "add on",
  "addon",
  "dialog bubble",
  "app bubble",
  "code bubble",
  "dialogue bubble",
  "script bubble",
  "comment box",
  "converse",
  "text message",
  "mistake",
  "pointed.",
  "pointy bubble",
  "about",
  "dialog box",
  "letter i",
  "filled arrow",
  "paste",
  "prompt",
  "fast input",
  "quick send",
  "ui action",
  "task complete",
  "check box",
  "consent",
  "deselected",
  "unchecked",
  "unselected",
  "access in",
  "access out",
  "check in",
  "check out",
  "departure",
  "hospitality",
  "reciprocal",
  "reciprocal arrows",
  "sauna",
  "indeterminate",
  "mixed",
  "multiple choice",
  "neither",
  "not sure",
  "partially selected",
  "chose",
  "list item",
  "smaller",
  "bookkeeping",
  "business finance",
  "cash flow",
  "checkbook",
  "expenses",
  "paperwork",
  "payments",
  "personal finance",
  "signature",
  "transactions",
  "booked",
  "buckle",
  "packed",
  "baggage claim",
  "baggage question",
  "check bag",
  "checked luggage",
  "doubt",
  "help with luggage",
  "luggage inquiry",
  "luggage question",
  "query bag",
  "travel help",
  "travel information",
  "check marks",
  "list items",
  "project management",
  "task list",
  "tick mark",
  "tick marks",
  "ticks",
  "to do list",
  "content list",
  "lined list",
  "numbered list",
  "right-to-left",
  "rtl",
  "tasks",
  "to-do",
  "boutique",
  "changing room",
  "checkroom",
  "cloakroom",
  "coat check",
  "dressing room",
  "fitting room",
  "hanger",
  "hanging",
  "visitor",
  "achievement icon",
  "applaud",
  "award icon",
  "celebrate",
  "celebration icon",
  "cheer",
  "confetti burst",
  "encourage",
  "exciting",
  "festive elements",
  "festive icon",
  "hype",
  "joy icon",
  "party elements",
  "party icon",
  "success icon",
  "winning icon",
  "baker",
  "baking hat",
  "cap",
  "chef",
  "chef uniform",
  "chef's hat",
  "cooking hat",
  "cooking icon",
  "culinary arts",
  "food icon",
  "gastronomy",
  "hat",
  "kitchen professional",
  "professional chef",
  "recipe",
  "restaurant industry",
  "toque",
  "bishop",
  "board",
  "board game",
  "challenge",
  "chess",
  "chess piece",
  "google play",
  "knight",
  "logic",
  "mental",
  "moves",
  "pawn",
  "puzzle",
  "rook",
  "strategy",
  "tactic",
  "game piece",
  "tabletop game",
  "rewind",
  "v-shape",
  "wedge",
  "breadcrumbs",
  "carousel",
  "pagination",
  "wizard",
  "angle bracket",
  "childcare",
  "feeding bottle",
  "nipple",
  "pacifier",
  "parenting",
  "friendly",
  "little",
  "stroller",
  "suitable",
  "assembly",
  "circuit",
  "detach",
  "extract",
  "extraction",
  "manufacturing",
  "microchip",
  "processor",
  "pulling out",
  "semiconductor",
  "uninstall",
  "criteria",
  "filter bar",
  "options list",
  "tags",
  "google cast",
  "audio visual",
  "dongle",
  "home entertainment",
  "chronic",
  "cyclical",
  "lasting",
  "long-term",
  "persistent",
  "recurring",
  "catholic",
  "christian",
  "christianity",
  "church",
  "faith",
  "gathering",
  "god",
  "holy",
  "mosque",
  "praying",
  "protestant",
  "sacred",
  "spire",
  "steeple",
  "synagogue",
  "temple",
  "cinematic",
  "cinematic effect",
  "dof",
  "film effect",
  "photography effect",
  "video effect",
  "confine",
  "elementary",
  "enclosure",
  "eye",
  "fish",
  "panorama",
  "signifier",
  "spheroid",
  "token",
  "announcements",
  "circle outline",
  "reminders",
  "circles ext",
  "circles extending",
  "expandable",
  "ext",
  "extending",
  "linked circles",
  "network node",
  "examine",
  "lookup",
  "magnifier",
  "clean hands",
  "cleanliness",
  "disinfect",
  "epidemic",
  "germs",
  "handwashing",
  "hygiene education",
  "hygiene practices",
  "hygiene standards",
  "hygiene symbols",
  "prevention",
  "sanitize",
  "sanitizer",
  "sink",
  "soap",
  "sterile",
  "wash hands",
  "bleach",
  "bristles",
  "broom",
  "chores",
  "debris",
  "dust",
  "housekeeping",
  "implement",
  "janitorial",
  "slanted",
  "straw",
  "sweep",
  "sweepings",
  "tidy",
  "tidying",
  "bucket",
  "housework",
  "mop",
  "neat",
  "pail",
  "reset",
  "scrub",
  "wipe",
  "chore",
  "polish",
  "squeaky clean",
  "clear all",
  "delete all",
  "erase all",
  "remove all",
  "sweeping",
  "beams",
  "glowing",
  "meteorology",
  "sunshine",
  "air conditioner",
  "air handler",
  "air system",
  "environmental control",
  "indoor climate",
  "mini split",
  "room temperature",
  "temperature control",
  "wall unit",
  "clinical",
  "diagnosis",
  "medic",
  "nurse",
  "accelerate",
  "faster",
  "quicken",
  "10%",
  "hourglass",
  "loader",
  "ten percent",
  "background task",
  "circle loader",
  "completion",
  "data loading",
  "partial fill",
  "partial ring",
  "percentage display",
  "twenty percent progress",
  "curved arrow",
  "syncing",
  "progress ring",
  "eighty percent",
  "90%",
  "circle progress",
  "circling",
  "loading indicator",
  "ninety percent",
  "cancel button",
  "delete button",
  "dialog close",
  "modal close",
  "remove item",
  "times",
  "window close",
  "arrows inward",
  "exit fullscreen",
  "reduce",
  "denied",
  "multiplication sign",
  "shut down",
  "wrong",
  "caption",
  "captions",
  "cc",
  "closed captions",
  "decoder",
  "spoken",
  "subtitle",
  "subtitles",
  "translation",
  "hearing impaired",
  "speech to text",
  "transcript",
  "closed captioning",
  "exclusion",
  "slashed",
  "struck through",
  "cloudy",
  "overcast",
  "rain",
  "synchronisation",
  "cloud computing",
  "get",
  "transfer file",
  "encryption",
  "padlock",
  "secure cloud",
  "failed connection",
  "not available",
  "not connected",
  "not synced",
  "service disabled",
  "service offline",
  "storage offline",
  "storage unavailable",
  "unavailable service",
  "two-way",
  "image upload",
  "remote storage",
  "send data",
  "video upload",
  "atom",
  "carbon",
  "carbon dioxide",
  "chemical",
  "chemical compound",
  "chemical formula",
  "climate change",
  "co2",
  "dioxide",
  "emissions",
  "gas",
  "greenhouse gas",
  "molecule",
  "co present",
  "co-present",
  "live stream",
  "livestreaming",
  "multiple users",
  "online meeting",
  "remote meeting",
  "remote work",
  "share screen",
  "slides",
  "togather",
  "video conference",
  "angle brackets",
  "bracket pairs",
  "brackets",
  "html",
  "ide",
  "javascript",
  "left angle bracket",
  "less than",
  "markup",
  "pointy brackets",
  "programming language",
  "right angle bracket",
  "snippet",
  "source code",
  "builder",
  "functions",
  "scripting",
  "visual programming",
  "brackets off",
  "chevron off",
  "code off",
  "development off",
  "programming disabled",
  "barista",
  "cafe culture",
  "cafe menu",
  "caffeine",
  "chocolate",
  "coffee",
  "coffee cup",
  "cup",
  "hot beverage",
  "hot drink",
  "menu item",
  "mug",
  "refreshments",
  "steaming",
  "tea",
  "appliances",
  "brewing",
  "carafe",
  "coffee maker",
  "drip coffee",
  "food and drink",
  "maker",
  "percolator",
  "pot",
  "brain",
  "cognitive",
  "mind",
  "psychology",
  "thoughts",
  "understanding",
  "brain shape",
  "cognition",
  "consciousness",
  "insight",
  "mental processing",
  "problem solving",
  "reasoning",
  "bundle all",
  "close all",
  "collapse all",
  "compact",
  "compress",
  "consolidate all",
  "contract all",
  "down arrows",
  "fold all",
  "group all",
  "hide all",
  "inward arrows",
  "minimize all",
  "multiple arrows",
  "reduce all",
  "shrink all",
  "arrow up and down",
  "collapse content",
  "collapse information",
  "collapse section",
  "content area",
  "expand content",
  "expand information",
  "expand section",
  "information section",
  "section collapse",
  "section expand",
  "section toggle",
  "collections",
  "notebook",
  "piled",
  "readings",
  "color fill",
  "color options",
  "color palette",
  "color picker",
  "color settings",
  "color swatches",
  "color wheel",
  "colorize",
  "colors",
  "dropper",
  "filters",
  "hues",
  "palette",
  "picker",
  "rainbow",
  "spectrum",
  "swatches",
  "tints",
  "visual effects",
  "hue",
  "saturation",
  "swatch",
  "boxes",
  "combine columns",
  "data management",
  "data manipulation",
  "data organization",
  "data transformation",
  "join columns",
  "join data",
  "merge columns",
  "merge data",
  "multiple columns",
  "restructure",
  "two columns",
  "acting",
  "amused",
  "anonymous",
  "broadway",
  "carnival",
  "cheerful",
  "comedic mask",
  "comedy",
  "drama",
  "expression",
  "funny",
  "grin",
  "jovial",
  "joyful",
  "laughter",
  "lighthearted",
  "mask",
  "masks",
  "stage",
  "standup",
  "theatre",
  "theatre mask",
  "theatrical",
  "tour",
  "anime",
  "cartoon",
  "cartoon bubble",
  "cartoons",
  "comic balloon",
  "comic book",
  "comics",
  "graphic novels",
  "text balloon",
  "add comment",
  "create comment",
  "new comment",
  "square bubble",
  "write comment",
  "cchat",
  "sorted",
  "stacking",
  "chat bubble with line",
  "chat disabled",
  "comment off",
  "comments",
  "comments blocked",
  "comments disabled",
  "communication restricted",
  "conversation disabled",
  "dialogue restricted",
  "message balloon with bar",
  "messaging disabled",
  "muted comments",
  "no comments",
  "restricted comments",
  "speech bubble with slash",
  "accomplish",
  "bind",
  "changes",
  "commit",
  "dedicate",
  "git",
  "perform",
  "pledge",
  "software development",
  "source control",
  "version control",
  "chatbox",
  "communities",
  "crowd",
  "groups",
  "overlapping circles",
  "population",
  "society",
  "two circles",
  "daily travel",
  "driving direction",
  "driving route",
  "analyze",
  "comparison tool",
  "competing",
  "data comparison",
  "difference",
  "feature comparison",
  "opposing",
  "product comparison",
  "side by side",
  "versus",
  "vs",
  "collide",
  "left and right",
  "opposing arrows",
  "parallel arrows",
  "together",
  "calibration",
  "magnetic",
  "needle",
  "north",
  "circulate",
  "data exchange",
  "horizontal arrows",
  "interchange",
  "shift",
  "transfer arrows",
  "compost",
  "compostable",
  "composting",
  "decomposable",
  "decompose",
  "dirt",
  "disposal",
  "eco",
  "eco-friendly",
  "leafs",
  "organic waste",
  "recycling",
  "refuse",
  "renewable",
  "reuse",
  "soil",
  "trash can",
  "waste management",
  "adjust size",
  "compress file",
  "opposite arrows",
  "outward arrows",
  "scale down",
  "scale up",
  "electronic device",
  "personal computer",
  "technology device",
  "workstation",
  "arrow up",
  "send to desktop",
  "share with device",
  "technology icon",
  "upload to computer",
  "upload to screen",
  "not allowed",
  "attendant",
  "bag cart",
  "bellboy",
  "concierge",
  "doorman",
  "local",
  "porter",
  "welcome",
  "celsius",
  "fahrenheit",
  "partly cloudy",
  "partly sunny",
  "rainy",
  "seasonal",
  "snowy",
  "stormy",
  "weather conditions",
  "weather symbols",
  "windy",
  "credential",
  "receipt",
  "unique",
  "anonymized",
  "cleft",
  "congenital",
  "default user",
  "generic person",
  "human anatomy",
  "lip",
  "lips",
  "mouth",
  "palate",
  "upper body",
  "communicating",
  "contactless",
  "proximity",
  "rf",
  "ripples",
  "socialize",
  "without",
  "aviation route",
  "connecting flights",
  "flight path",
  "developing",
  "hammer",
  "improvement",
  "in progress",
  "maintain",
  "renovate",
  "renovation",
  "site work",
  "technician",
  "tradesman",
  "tradesperson",
  "under construction",
  "address book",
  "contact card",
  "contact information",
  "medical alert",
  "medical contact",
  "medical emergency",
  "medical help",
  "common",
  "essential",
  "reaching out",
  "answer",
  "ask",
  "ask question",
  "customer service",
  "faq",
  "faqs",
  "frequently asked questions",
  "get help",
  "speech balloon",
  "stroke circle",
  "support bubble",
  "card reader",
  "mastercard",
  "mobile payment",
  "near field communication",
  "nfc",
  "paypass",
  "visa",
  "cancelled",
  "contactless off",
  "contactless payment off",
  "nfc off",
  "no contactless",
  "no signal",
  "payment off",
  "tap and pay",
  "waves off",
  "addressbook",
  "half circle",
  "menu icon",
  "navigation icon",
  "contact list",
  "group of people",
  "people list",
  "cut",
  "overlap",
  "printing",
  "replicate",
  "audio editing",
  "clipping",
  "content cut",
  "scissors",
  "snip",
  "toolbar",
  "trim",
  "square corners",
  "clipboard content",
  "content transfer",
  "document action",
  "file operation",
  "move data",
  "paste action",
  "cannot",
  "clipboard disabled",
  "clipboard restricted",
  "content disabled",
  "content restricted",
  "copy paste disabled",
  "data restricted",
  "no paste",
  "paste disabled",
  "paste off",
  "pasting restricted",
  "permission denied",
  "strike through",
  "unallowed",
  "unpasteable",
  "begin",
  "engage",
  "initiate",
  "aggregate",
  "combined",
  "combined total",
  "mathematical",
  "mathematical operation",
  "united",
  "binding",
  "deal",
  "formal",
  "official",
  "paper icon",
  "signing",
  "terms",
  "agreement delete",
  "cancel contract",
  "cancel file",
  "contract delete",
  "delete document",
  "delete file",
  "document delete",
  "document trash",
  "file delete",
  "file trash",
  "page delete",
  "paperwork delete",
  "record delete",
  "remove contract",
  "remove document",
  "remove file",
  "trash document",
  "trash file",
  "agreement editing",
  "contract modification",
  "contract signing",
  "file editing",
  "form editing",
  "black",
  "curved shape",
  "dark theme",
  "divided",
  "grayscale",
  "editier",
  "increases",
  "light mode",
  "right to left",
  "partition",
  "apparatus",
  "add item",
  "clone",
  "control point",
  "copy and paste",
  "make a copy",
  "multi",
  "console",
  "controller",
  "d-pad",
  "gamepad",
  "gaming",
  "joystick",
  "regulator",
  "retro",
  "trigger",
  "video game",
  "conversion path",
  "customer journey",
  "funnel",
  "roadmap",
  "user flow",
  "broken path",
  "conversion path off",
  "deactivation",
  "deactive",
  "disabled connection",
  "disconnect path",
  "discontinued",
  "no connection",
  "no path",
  "not working",
  "path off",
  "alteration",
  "convert",
  "document type",
  "file conversion",
  "file type",
  "format conversion",
  "string",
  "text document",
  "to text",
  "unformatted text",
  "automation process",
  "belt",
  "conveyor",
  "conveyor system",
  "factory",
  "factory floor",
  "logistic",
  "manufactory",
  "manufacturing line",
  "material handling",
  "production line",
  "biscuit",
  "chocolate chip cookie",
  "circle with dots",
  "cookie",
  "cookies",
  "crumbs",
  "dotted circle",
  "gdpr",
  "privacy settings",
  "wafer",
  "website data",
  "boiling",
  "braiser",
  "cast iron",
  "cookery",
  "cooktop",
  "cookware",
  "dutch oven",
  "eating habits",
  "gourmet",
  "healthy eating",
  "induction",
  "meals",
  "pan",
  "serve",
  "stockpot",
  "stove",
  "stovetop",
  "cool ",
  "dry",
  "humidity",
  "copy all",
  "reproduce",
  "select all",
  "select content",
  "c",
  "disclaimer",
  "intellectual property",
  "letter c",
  "licensing",
  "owner",
  "registered",
  "surrounding circle",
  "flu",
  "microscopic",
  "outbreak",
  "pathogen",
  "sick",
  "spiky",
  "fare",
  "lake",
  "lodging.",
  "village",
  "initial",
  "looks",
  "none",
  "tally",
  "zero state",
  "counter 1",
  "digit 1",
  "item 1",
  "list item 1",
  "number 1",
  "ordinal",
  "quantity 1",
  "number badge",
  "number two",
  "enumeration",
  "digit 4",
  "item count",
  "number 4",
  "number of items",
  "sequential",
  "number five",
  "counter 6",
  "number six",
  "sixth",
  "sixths",
  "count 7",
  "counter 7",
  "digit 7",
  "figure 7",
  "number 7",
  "numeral 7",
  "quantity 7",
  "score 7",
  "symbolic",
  "value 7",
  "eight",
  "mathematics",
  "octagonal",
  "count value",
  "counter number",
  "integer",
  "notification count",
  "single digit",
  "whole number",
  "countertops",
  "decor",
  "interior design",
  "laminate",
  "slab",
  "tops",
  "amex",
  "funding",
  "plastic",
  "american express",
  "bnpl",
  "pay later",
  "pay over time",
  "liked",
  "preferred",
  "romance",
  "saved card",
  "valentine",
  "payment card",
  "rejected",
  "credit score",
  "debt",
  "ficoscore",
  "three digits",
  "baby bed",
  "bassinet",
  "child bed",
  "infant bed",
  "bullseye",
  "artboard",
  "vignette",
  "16:9",
  "adjust ratio",
  "by",
  "framing",
  "sixteen by nine",
  "tv screen",
  "video format",
  "wide screen",
  "3 by 2",
  "3:2",
  "3x2",
  "overlapping squares",
  "two squares",
  "5:4",
  "editing settings",
  "editing tools",
  "five by four",
  "7:5 ratio",
  "bounding box",
  "seven by five",
  "9:16",
  "nine sixteen",
  "crop free",
  "exit full screen",
  "free",
  "full screen",
  "crop landscape",
  "edit tool",
  "landscape mode",
  "media editing",
  "picture editing",
  "reframe",
  "wide ratio",
  "canvas",
  "counter-clockwise",
  "reorient",
  "square crop",
  "clue",
  "crossword",
  "linguistics",
  "vocabulary",
  "word puzzle",
  "words",
  "contribution",
  "crowdsource",
  "participate",
  "partnership",
  "teamwork",
  "volunteer",
  "bonus",
  "crown",
  "leaderboard",
  "royalty",
  "tiara",
  "animal friendly",
  "animal testing",
  "animal welfare",
  "beauty",
  "bunny",
  "cosmetics",
  "cruelty",
  "cruelty free",
  "ethical",
  "ethical products",
  "ethical shopping",
  "humane",
  "jump",
  "jumping",
  "leaping",
  "leaping bunny",
  "no animal testing",
  "personal care",
  "rabbit",
  "responsible",
  "toiletries",
  "cascading stylesheets",
  "computer language",
  "stylesheets",
  "web code",
  "web standards",
  "comma",
  "comma separated values",
  "computer file",
  "csv",
  "data file",
  "data format",
  "numerical data",
  "separated",
  "spreadsheets",
  "tabular",
  "tabular data",
  "text format",
  "values",
  "bitcoin",
  "blockchain",
  "crypto",
  "cryptocurrency",
  "digital asset",
  "digital currency",
  "dollar",
  "financial symbol",
  "franc",
  "letter b",
  "online payment",
  "oval",
  "virtual currency",
  "currency exchange",
  "euro",
  "foreign exchange",
  "forex",
  "international money",
  "money transfer",
  "pound",
  "yen",
  "capital",
  "foreign",
  "monetary",
  "swiss",
  "capital letter",
  "foreign currency",
  "international currency",
  "l",
  "lira",
  "t",
  "tl symbol",
  "turkish lira",
  "british pound",
  "gbp",
  "great britain",
  "sterling",
  "united kingdom",
  "fiat currency",
  "payment methods",
  "rouble",
  "ruble",
  "russian currency",
  "sale",
  "india",
  "indian currency",
  "indian money",
  "indian rupee",
  "rupee",
  "currency symbol",
  "expenditure",
  "fund",
  "indian",
  "japan",
  "japanese",
  "china",
  "chinese",
  "renminbi",
  "rmb",
  "yuan",
  "drapes",
  "drawn",
  "pleated",
  "cloth",
  "darken",
  "hang",
  "sunlight",
  "typeface",
  "perpetual",
  "recurrent",
  "reiterate",
  "restart",
  "unending",
  "chaotic",
  "cyclone",
  "force",
  "funnel cloud",
  "hurricane",
  "natural disaster",
  "powerful",
  "rotational",
  "severe weather",
  "spiraling",
  "tornado",
  "turbulent",
  "twister",
  "vortex",
  "weather alert",
  "winds",
  "alarming",
  "be careful",
  "watch out",
  "ambient",
  "eye strain",
  "speedometer",
  "tachometer",
  "main",
  "starting point",
  "reorganize",
  "tailor",
  "widget",
  "data alert",
  "lists",
  "array",
  "coder",
  "data structure",
  "it",
  "parentheses",
  "square brackets",
  "syntax",
  "bi",
  "business intelligence",
  "data exploration",
  "data loss prevention",
  "data protection",
  "digital security",
  "firewall",
  "internet security",
  "loss",
  "network security",
  "no entry",
  "results about you",
  "sensitive data",
  "data object",
  "dataset",
  "bandwidth saver",
  "conserve data",
  "data saver",
  "limit data",
  "network data",
  "reduce data",
  "data control",
  "data filter",
  "data limits",
  "data range",
  "data representation",
  "data selection",
  "data settings",
  "data thresholding",
  "thresholding",
  "thresold",
  "canceled",
  "data saver off",
  "data saving",
  "data center",
  "server rack",
  "cross out",
  "cylinder",
  "database off",
  "ellipse",
  "server status",
  "find data",
  "find database",
  "find records",
  "cloud data",
  "database transfer",
  "server data",
  "server transfer",
  "storage data",
  "storage upload",
  "digital data",
  "electronic data",
  "flat data",
  "organized data",
  "structured data",
  "web link",
  "world wide web",
  "wwww",
  "defined",
  "enhancement",
  "sharpen",
  "sharpness",
  "death",
  "expanse",
  "flower",
  "flowers",
  "yard",
  "decimal",
  "fraction",
  "fractions",
  "decimal point",
  "aligned",
  "cards deck",
  "chairs",
  "deck of cards",
  "layered squares",
  "pile",
  "playing cards",
  "poker",
  "solitaire",
  "dehaze",
  "haze",
  "unfog",
  "abolish",
  "delete forever",
  "dispose",
  "get rid of",
  "obliterate",
  "purge",
  "wipe out",
  "zero out",
  "clear data",
  "clear history",
  "clear information",
  "delete data",
  "delete history",
  "delete information",
  "remove data",
  "remove history",
  "remove information",
  "batch delete",
  "batch remove",
  "bulk delete",
  "bulk remove",
  "delete sweep",
  "mass delete",
  "mass remove",
  "multiple delete",
  "multiple remove",
  "permanently delete",
  "waste",
  "commercial vehicle",
  "delivery truck",
  "fast delivery",
  "quick delivery",
  "speedy delivery",
  "delivery speed",
  "delivery van",
  "express delivery",
  "moving truck",
  "road transport",
  "shipping speed",
  "age",
  "demographic",
  "demography",
  "user base",
  "density",
  "density large",
  "more space",
  "thick",
  "thick lines",
  "wide lines",
  "content density",
  "default",
  "density medium",
  "line spacing",
  "medium spacing",
  "paragraph spacing",
  "text density",
  "condensed",
  "dense",
  "more density",
  "small density",
  "tight spacing",
  "canine",
  "checkup",
  "dental",
  "dentist",
  "dentistry",
  "filling",
  "implant",
  "incisor",
  "molar",
  "oral",
  "orthodontics",
  "root canal",
  "teeth",
  "tooth",
  "arrival times",
  "arrivals",
  "bus station",
  "departure board",
  "departure times",
  "destinations",
  "flight information",
  "real-time",
  "train station",
  "transport information",
  "trips",
  "algorithm",
  "bracket",
  "deploy",
  "deployed",
  "deployment",
  "greater than sign",
  "less than sign",
  "packet",
  "angled brackets",
  "chevrons",
  "code profile",
  "developer account",
  "programming error",
  "system alert",
  "application log",
  "code history",
  "deploy history",
  "development history",
  "development timeline",
  "revision history",
  "server log",
  "timeline view",
  "versions",
  "web log",
  "computer programming",
  "devops",
  "patch",
  "care symbol",
  "cosmetic",
  "derm",
  "dermatology",
  "dermatology icon",
  "dermatology symbol",
  "face icon",
  "follicle",
  "hair",
  "hand icon",
  "health symbol",
  "medical icon",
  "medical symbol",
  "skin",
  "skincare",
  "specialist",
  "description",
  "readme",
  "deselect",
  "uncheck",
  "untick",
  "implements",
  "computer desk",
  "flat surface",
  "four legs",
  "home office",
  "analog phone",
  "deskphone",
  "dialer",
  "landline",
  "old phone",
  "traditional phone",
  "vintage phone",
  "wired phone",
  "barring",
  "cancellation",
  "hindering",
  "obstruction",
  "instance",
  "multitasking",
  "splitscreen",
  "diagonal cross",
  "insert button",
  "new button",
  "all-in-one",
  "base",
  "imac",
  "macintosh",
  "breakup",
  "disintegrate",
  "dissolve",
  "fragment",
  "matter",
  "nuclear",
  "nucleus",
  "particle",
  "physics",
  "radiation",
  "shatter",
  "smash",
  "data icon",
  "ellipsis",
  "expand details",
  "further details",
  "horizontal dots",
  "information icon",
  "more menu",
  "options icon",
  "overflow icon",
  "overflow menu",
  "settings icon",
  "three dot menu",
  "confined",
  "designated",
  "detection",
  "scanning",
  "co",
  "cone",
  "detector",
  "radar",
  "carbon monoxide detector",
  "fire alarm",
  "smoke detector",
  "power meter",
  "voltage",
  "carbon monoxide",
  "poisoning",
  "toxic",
  "detector offline",
  "not communicating",
  "out of service",
  "alert system",
  "fire safety",
  "home safety",
  "circuit board",
  "cpu",
  "developer board",
  "development board",
  "development tool",
  "electronic board",
  "integrated circuit",
  "mainboard",
  "motherboard",
  "pcb",
  "prototype",
  "tech board",
  "technology board",
  "booklet",
  "instruction",
  "developer mode",
  "developer tools",
  "mobile code",
  "activity monitor",
  "activity tracker",
  "bracelet",
  "digital accessory",
  "fitness band",
  "fitness tracker",
  "fitness wearable",
  "health and fitness",
  "health tracker",
  "health wearable",
  "personal device",
  "smart accessory",
  "smart band",
  "smart bracelet",
  "tracking device",
  "wearable technology",
  "wellness tracker",
  "wrist accessory",
  "wrist device",
  "central point",
  "connected devices",
  "connection points",
  "device hub",
  "networking",
  "temp",
  "device_unknown",
  "how",
  "lost",
  "missing",
  "mobile_question",
  "unidentified",
  "what",
  "why",
  "multiple devices",
  "remote control",
  "dual screen",
  "foldable",
  "hinge",
  "Gadget",
  "bent",
  "foldable device",
  "devices off",
  "pairing off",
  "phonelink",
  "phonelink off",
  "unpair",
  "casting devices",
  "gadgets",
  "ipad",
  "other devices",
  "peripherals",
  "screensharing",
  "smart devices",
  "condense",
  "dew",
  "dew point",
  "droplets",
  "moisture",
  "water drop",
  "examination",
  "health check",
  "zigzag",
  "oblique",
  "slant",
  "initiation",
  "internet icon",
  "network icon",
  "session",
  "sip",
  "sip call",
  "telephone icon",
  "voip",
  "voip call",
  "chatting",
  "dialogs",
  "dialogue box",
  "direct message",
  "dm",
  "im",
  "instant message",
  "message box",
  "dialpad",
  "entering numbers",
  "grid layout",
  "pad",
  "ten keys",
  "facet",
  "gems",
  "jewelry",
  "valuables",
  "antonym",
  "glossary",
  "lexicon",
  "meaning",
  "spell",
  "synonym",
  "teaching",
  "thesaurus",
  "translate",
  "word",
  "diff",
  "variations",
  "billboard",
  "digital signage",
  "dooh",
  "out of home",
  "public space",
  "app usage",
  "concentration",
  "digital health",
  "digital wellbeing",
  "phone usage",
  "screen time",
  "self control",
  "time management",
  "time usage",
  "usage data",
  "usage limits",
  "wellbeing",
  "cafeteria",
  "canteen",
  "fine dining",
  "hunger",
  "plateware",
  "satisfy",
  "taste",
  "pasta",
  "place setting",
  "spaghetti",
  "find my way",
  "how to get there",
  "lead",
  "where am i",
  "alternative route",
  "bend",
  "next turn",
  "re-route",
  "right turn",
  "turn right",
  "arrowhead",
  "no directions",
  "eco friendly",
  "rider",
  "boating",
  "cruise",
  "speedboat",
  "vessel",
  "yacht",
  "bus route",
  "public transportation",
  "transport public",
  "travel by bus",
  "car symbol",
  "drive time",
  "estimated time",
  "eta",
  "passenger vehicle",
  "sedan",
  "transport symbol",
  "travel time",
  "vehicle icon",
  "circle with slash",
  "clear route",
  "directions off",
  "disable directions",
  "gps off",
  "guidance off",
  "line with slash",
  "location off",
  "map off",
  "navigation off",
  "remove route",
  "route off",
  "stop navigation",
  "travel off",
  "railroad",
  "athletics",
  "jogging",
  "marathon",
  "commuter",
  "railcar",
  "transport mode",
  "underground",
  "pedestrian",
  "strides",
  "two way",
  "dirty",
  "flawed",
  "imperfect",
  "optics",
  "smudge",
  "splat",
  "crossed eye",
  "disallowed",
  "eye with slash",
  "turned off",
  "unsee",
  "dvd",
  "maximum",
  "optical disc",
  "overloaded",
  "equalization",
  "find tunes",
  "specifications",
  "streams",
  "tunes",
  "cups",
  "dishes",
  "dishwasher",
  "glasses",
  "line icon",
  "plates",
  "rinse",
  "utensil",
  "washer",
  "tableware",
  "hdmi",
  "hdtv",
  "vga",
  "display adjustments",
  "display control",
  "monitor settings",
  "screen options",
  "far",
  "gap",
  "two points",
  "diverse",
  "faces",
  "individuals",
  "team building",
  "avatars",
  "demographics",
  "heads",
  "humanity",
  "multicultural",
  "tolerance",
  "community icon",
  "different people",
  "diversity icon",
  "ethnicity",
  "group icon",
  "people icon",
  "team members",
  "users icon",
  "varied",
  "cooperation",
  "diverse group",
  "four figures",
  "four people",
  "huddle",
  "social group",
  "dns",
  "domain name system",
  "hostname",
  "allow notifications",
  "disturb off",
  "dnd off",
  "do",
  "do not disturb off",
  "focus off",
  "no alerts",
  "not silenced",
  "notifications off",
  "off state",
  "quiet mode off",
  "receive alerts",
  "silent mode off",
  "sound on",
  "turn off dnd",
  "turn off quiet mode",
  "turn off silent",
  "uninterrupted",
  "volume on",
  "disable notifications",
  "quiet mode",
  "silent mode",
  "all silent",
  "calls",
  "dnd",
  "interruptions",
  "not",
  "on total",
  "total silence",
  "boot",
  "do not step",
  "no stepping",
  "shoe",
  "shoe print",
  "sneaker",
  "beware",
  "constraint",
  "delicate",
  "don't touch",
  "no touching",
  "prevented",
  "sensitive",
  "docking station",
  "affix",
  "box outline",
  "dock to bottom",
  "move down",
  "place at bottom",
  "rectangle outline",
  "shelf",
  "snap",
  "stick",
  "arrow right",
  "dock to right",
  "move right",
  "panel right",
  "position right",
  "right justified",
  "sidebar right",
  "tab right",
  "window right",
  "document filled",
  "document line",
  "document single",
  "document solid",
  "documentstroke",
  "document add-on",
  "file add-on",
  "page add-on",
  "paper add-on",
  "google apps script",
  "document find",
  "find in file",
  "magnifying glass with document",
  "search bar",
  "search results",
  "web address",
  "add domain",
  "add site",
  "add website",
  "host",
  "hosting",
  "domain access denied",
  "domain block",
  "domain disabled",
  "domain privacy",
  "domain restricted",
  "domain security",
  "domain unauthorized",
  "internet access denied",
  "internet block",
  "internet disabled",
  "internet restricted",
  "internet unauthorized",
  "unauthorized",
  "web access disabled",
  "web privacy",
  "web security",
  "website disabled",
  "application desktop",
  "trusted",
  "verify",
  "not verified",
  "unverified",
  "costume",
  "detective",
  "disguise",
  "domino mask",
  "eye holes",
  "eye mask",
  "facial covering",
  "hero",
  "masquerade mask",
  "roleplay",
  "secret identity",
  "spy",
  "superhero",
  "superhero mask",
  "villain",
  "all done",
  "checkmarks",
  "double check",
  "sent",
  "two checks",
  "green light",
  "donut",
  "donut large",
  "pie",
  "pie chart",
  "status indicator",
  "visualize",
  "donut chart",
  "hole",
  "doorway",
  "egress",
  "knob",
  "move backward",
  "navigate back",
  "opening",
  "passage",
  "shut",
  "way out",
  "access point",
  "entry point",
  "front door",
  "rectangle with handle",
  "logoff",
  "contact sensor",
  "door sensor",
  "entryway",
  "sliding",
  "sliding door",
  "digital doorbell",
  "door access",
  "doorbell",
  "notification bell",
  "notification sound",
  "ring bell",
  "smart security",
  "video doorbell",
  "auditory signal",
  "entrance icon",
  "ring button",
  "ringer",
  "security system",
  "sound device",
  "acoustic",
  "ding dong",
  "jingle",
  "melody",
  "sound wave",
  "tone",
  "arrowheads",
  "athlete",
  "athletic",
  "downhill",
  "downhill skiing",
  "hobby",
  "ski",
  "ski social",
  "skier",
  "slope",
  "acquire",
  "downloads",
  "obtain",
  "underscore",
  "arrow and check",
  "completed download",
  "completed file download",
  "document and check",
  "down arrow and check",
  "download complete",
  "download done",
  "download finished",
  "download successful",
  "file download complete",
  "file download done",
  "file download finished",
  "file download successful",
  "finished download",
  "finished file download",
  "paper and check",
  "successful download",
  "successful file download",
  "available offline",
  "caching",
  "cloud arrow",
  "cloud icon",
  "download cloud",
  "download icon",
  "for offline",
  "get file",
  "no internet",
  "offline icon",
  "retrieve data",
  "save icon",
  "cloud download",
  "download data",
  "download indicator",
  "downloading",
  "downloading progress",
  "internet download",
  "web download",
  "blank document",
  "blank page",
  "create document",
  "digital document",
  "digital file",
  "empty file",
  "office file",
  "composing",
  "creating",
  "drafts",
  "unfiled",
  "unsent",
  "selects",
  "application ui",
  "handle.",
  "reordering",
  "sortable",
  "grab",
  "indicators",
  "adjust position",
  "all directions",
  "displace",
  "dragging",
  "four directions",
  "move content",
  "panning",
  "with",
  "crayon",
  "doodle",
  "freehand",
  "hand drawn",
  "scribble",
  "abstraction",
  "freeform",
  "imagination",
  "random",
  "squiggle",
  "art piece",
  "combine pictures",
  "create collage",
  "montage",
  "photo collage",
  "photo editor",
  "picture arrangement",
  "picture frame",
  "scrapbook",
  "visual mix",
  "cabinet",
  "chest",
  "drawers",
  "dresser",
  "migrate",
  "deliver",
  "dose",
  "eyedropper",
  "oculist",
  "ophthalmology",
  "optometrist",
  "pipette",
  "sight",
  "solution",
  "air dry",
  "dryer",
  "drying",
  "hang dry",
  "laundry",
  "laundry machine",
  "no heat",
  "tumble",
  "washing machine",
  "dry cleaning",
  "ironing",
  "pressing",
  "towel",
  "duo",
  "extend display",
  "folding",
  "multiple screens",
  "parallel screens",
  "screens",
  "side by side screens",
  "split screen",
  "two screens",
  "dvr",
  "video recording",
  "'mail_outline'",
  "'markunread'. Keep 'mail' and remove others.",
  "Duplicate of 'email'",
  "flowing",
  "posts",
  "summaries",
  "adaptable",
  "configurations",
  "dynamic form",
  "fields",
  "questionnaire",
  "variable",
  "911",
  "first aid",
  "hospital services",
  "medical services",
  "distress",
  "police",
  "cell service",
  "cellular network",
  "data connectivity",
  "data signal",
  "e",
  "e network",
  "edge network",
  "mobile connectivity",
  "uppercase",
  "aids",
  "audiogram",
  "audiologist",
  "audiometry",
  "auditory",
  "deaf",
  "decibels",
  "ear",
  "haptic",
  "hearing aid",
  "hearing aids",
  "impaired",
  "sense",
  "sensory",
  "closed.",
  "earbud case",
  "earbuds",
  "earphone",
  "earphones",
  "headphone",
  "holder",
  "lid",
  "audio output",
  "earbud",
  "earbud left",
  "earpiece",
  "headset",
  "individual earbud",
  "left earbud",
  "one earbud",
  "personal audio",
  "portable audio",
  "single earbud",
  "wired",
  "right side",
  "listening device",
  "media device",
  "audio accessory",
  "earbud icon",
  "entertainment device",
  "sound output",
  "early",
  "early access",
  "early start",
  "fast forward",
  "fast forward time",
  "jump back",
  "jump forward",
  "playback position",
  "rewind time",
  "skip back",
  "skip forward",
  "time manipulation",
  "time travel",
  "transport control",
  "aftershock",
  "catastrophe",
  "disaster preparedness",
  "disturbance",
  "earth icon",
  "earthquake",
  "fault line",
  "geology",
  "geology icon",
  "jolt",
  "natural phenomena",
  "seismic",
  "seismic activity",
  "seismograph",
  "shake",
  "shaking",
  "shockwave",
  "temblor",
  "tremor",
  "diagnostic",
  "electrocardiogram",
  "heart rhythm",
  "medical line",
  "biodegradable",
  "carbon footprint",
  "conservation",
  "ecological",
  "ecology",
  "economical",
  "save the planet",
  "electrodermal",
  "electrodermal activity responses",
  "electrodermal responses",
  "edge sensor",
  "high alert",
  "mobile sensor",
  "signal bars",
  "vibrate",
  "auxiliary",
  "auxiliary sensor",
  "flanking",
  "flanking sensors",
  "limited range",
  "low signal",
  "short range",
  "side bars",
  "side sensors",
  "supplementary",
  "supplementary sensor",
  "weak signal",
  "mode_edit",
  "mode_edit_outline",
  "arrow edit",
  "arrow upward",
  "edit arrow",
  "raise",
  "edit attributes",
  "fine tune",
  "adjust volume",
  "audio analysis",
  "clip editing",
  "detect",
  "eq",
  "modify sound",
  "sound controls",
  "track editing",
  "annotate",
  "reschedule",
  "timestamp",
  "slant line",
  "geotag",
  "locale",
  "where",
  "whereabouts",
  "compose note",
  "corrections",
  "edit document",
  "edit file",
  "edit text",
  "writing tool",
  "bell with pencil",
  "edit alert",
  "modify notification",
  "notification settings",
  "sounds",
  "can't edit",
  "disabled edit",
  "edit blocked",
  "edit off",
  "editing disabled",
  "lock edit",
  "no edit",
  "no pen",
  "no pencil",
  "pen off",
  "pencil off",
  "restricted edit",
  "slashes",
  "winding",
  "redesign",
  "rephrase",
  "champion",
  "check mark",
  "editor's pick",
  "featured",
  "recommended",
  "animal product",
  "cooking ingredient",
  "poultry",
  "crack",
  "easter",
  "livestock",
  "shell",
  "eject",
  "physical media",
  "removal",
  "upward pointing",
  "account representation",
  "old",
  "old person",
  "older",
  "profile representation",
  "profile view",
  "user representation",
  "aged",
  "girl",
  "lady",
  "battery bicycle",
  "battery bike",
  "e-bike",
  "ebike",
  "electric bicycle",
  "electric bike",
  "electric scooter",
  "motor",
  "pedal assist",
  "powered bike",
  "electric bolt",
  "high voltage",
  "sudden",
  "refuel",
  "zero emission",
  "analog meter",
  "electric meter",
  "smart meter",
  "volts",
  "electric moped",
  "moped",
  "alternative transport",
  "asian",
  "conveyance",
  "electric rickshaw",
  "last mile",
  "rickshaw",
  "taxi",
  "three wheeler",
  "vehicle type",
  "convenient",
  "e-scooter",
  "green transport",
  "micro-mobility",
  "recreational",
  "two-wheeled",
  "electrical services",
  "energy savings",
  "home services",
  "installation",
  "power lines",
  "spark",
  "wiring",
  "arranging",
  "elevated",
  "foreground",
  "hill",
  "hills",
  "incline",
  "inclines",
  "materials",
  "overlaying",
  "shadow",
  "shadows",
  "surfaces",
  "visual depth",
  "z-index",
  "arrow down",
  "ascent",
  "building access",
  "descent",
  "elevator",
  "floor indicator",
  "crucial",
  "boiler",
  "furnace",
  "warming",
  "indication",
  "sharp point",
  "panic",
  "safe house",
  "communication off",
  "emergency disabled",
  "share disabled",
  "sharing off",
  "ceramic",
  "saucer",
  "steam lines",
  "change language",
  "different languages",
  "keyboards",
  "language settings",
  "multilingual",
  "bee",
  "botanical",
  "daisy",
  "foliage",
  "grove",
  "ladybug",
  "petals",
  "preserve",
  "sanctuary",
  "scenic",
  "tranquil",
  "woods",
  "emoticon",
  "greeting",
  "personal information",
  "waving",
  "The image is completely blank",
  "ampersand",
  "hieroglyph",
  "therefore I cannot analyze it to generate relevant tags. Please provide a visible image of the icon.",
  "coach",
  "mass transit",
  "transportation icon",
  "happy face",
  "smiley face",
  "blank state",
  "first time",
  "graphs",
  "initial state",
  "no data",
  "activated",
  "activated state",
  "enabled state",
  "pill shape",
  "switch on",
  "toggle on",
  "visual indicator",
  "encrypted",
  "skip",
  "controlled",
  "guarded",
  "create new",
  "decrypt",
  "decryption",
  "encrypt",
  "access open",
  "broken lock",
  "communication unencrypted",
  "data unprotected",
  "disabled encryption",
  "encryption disabled",
  "encryption off",
  "insecure connection",
  "lock symbol",
  "locked off",
  "not encrypted",
  "not private",
  "open lock",
  "padlock open",
  "privacy off",
  "security disabled",
  "security off",
  "unlocked lock",
  "unsealed",
  "unsecure",
  "vulnerable",
  "ancient symbol",
  "caduceus",
  "diabetes",
  "endocrinologist",
  "gland",
  "glands",
  "healthcare provider",
  "hormone",
  "internal medicine",
  "metabolic",
  "neck",
  "snake",
  "staff",
  "throat",
  "thyroid",
  "battery charging",
  "bolt symbol",
  "electric power",
  "electrical energy",
  "electrical power",
  "energy symbol",
  "generator",
  "lightning symbol",
  "power symbol",
  "turbine",
  "windmill",
  "electricity bill",
  "program setting",
  "saving",
  "circle with pie chart",
  "clock hands",
  "energy usage analysis",
  "program usage",
  "time analysis",
  "time tracking",
  "resource management",
  "savings mode",
  "automate",
  "cogs",
  "cogwheel",
  "helmet",
  "mechanics",
  "breaking encryption",
  "cipher",
  "decoding",
  "open padlock",
  "scrambling",
  "unscrambling",
  "audio icon",
  "clef",
  "entertainment icon",
  "music icon",
  "music note",
  "musical icon",
  "musical note",
  "nose",
  "sheet music",
  "treble clef",
  "building off",
  "business off",
  "company off",
  "enterprise off",
  "office off",
  "algebra",
  "conclusion",
  "equals sign",
  "equivalent",
  "identical",
  "mathmatical",
  "same",
  "sound adjustment",
  "static",
  "brush size",
  "eraser",
  "line thickness",
  "line weight",
  "line width",
  "strokes",
  "size control",
  "broad",
  "chunky",
  "editing tool",
  "paint tool",
  "substantial",
  "weighty",
  "cleaning tool",
  "graphic editor",
  "alert triangle",
  "attention symbol",
  "error symbol",
  "exclamation triangle",
  "warning symbol",
  "convenience",
  "descend",
  "disabled access",
  "escalator",
  "mall",
  "moving walkway",
  "staircase",
  "stairs",
  "caution symbol",
  "hazard symbol",
  "moving stairs",
  "safety symbol.",
  "triangle with exclamation mark",
  "europe",
  "european",
  "european currency",
  "euros",
  "money symbol",
  "cellular signal",
  "data strength",
  "greyscale",
  "tonality",
  "reduction",
  "charging port",
  "electric car",
  "electric vehicle charging station",
  "energy source",
  "ev charger",
  "fuel",
  "green energy",
  "petrol",
  "pump",
  "refueling",
  "datetime",
  "due date",
  "invitation",
  "invite",
  "availability",
  "availability icon",
  "calendar icon",
  "check icon",
  "confirmed appointment",
  "confirmed event",
  "date available",
  "date confirmed",
  "date icon",
  "event icon",
  "event planning",
  "scheduled date",
  "scheduled event",
  "out of office",
  "time off",
  "camerazilla",
  "event list",
  "list of items",
  "ordered list",
  "unordered list",
  "vertical list",
  "add event",
  "create event",
  "date picker",
  "tickler",
  "constant",
  "event repeat",
  "recurrence",
  "revisit",
  "schedule management",
  "airplane seat",
  "allocate seat",
  "assigned",
  "assigned seat",
  "attend",
  "attending",
  "auditorium",
  "book seat",
  "choose seat",
  "event seating",
  "pick seat",
  "select seat",
  "sit",
  "stadium",
  "tickets",
  "venue",
  "event management",
  "ticketing",
  "timeline events",
  "upcoming events",
  "alert symbol",
  "caution triangle",
  "information symbol",
  "problem triangle",
  "warning triangle",
  "agility",
  "bodybuilding",
  "calisthenics",
  "conditioning",
  "drill",
  "dumbbell",
  "exercise routine",
  "flexibility",
  "gym",
  "physical activity",
  "practice",
  "regimen",
  "stamina",
  "vitality",
  "weights",
  "abandon",
  "depart",
  "gate",
  "log off",
  "sign out",
  "bigger",
  "four arrows",
  "view area",
  "expand all",
  "maximize window",
  "stretching",
  "circle button",
  "collapse down",
  "down arrow button",
  "dropdown indicator",
  "more options",
  "more info",
  "hide details",
  "less info",
  "show details",
  "accordions",
  "disclosure indicator",
  "item expand",
  "list expand",
  "panel collapse",
  "show less",
  "view details",
  "beaker",
  "conical",
  "flask",
  "invention",
  "lab",
  "test tube",
  "tube",
  "e symbol",
  "explicit",
  "inappropriate",
  "mature",
  "p symbol",
  "travel guide",
  "wander",
  "explore_nearby",
  "locartion",
  "nearby",
  "adventure off",
  "compass blocked",
  "compass off",
  "disable exploration",
  "discover blocked",
  "discover off",
  "explore blocked",
  "explore off",
  "find blocked",
  "find off",
  "geo off",
  "globe off",
  "guidance blocked",
  "guidance disabled",
  "journey off",
  "location disabled",
  "navigation blocked",
  "navigation disabled",
  "orientation off",
  "pinpoint off",
  "route blocked",
  "satellite off",
  "search off",
  "tag off",
  "world off",
  "catastrophic",
  "demolish",
  "ignite",
  "pop",
  "special effect",
  "spike",
  "starburst",
  "volatile",
  "Save",
  "Save notes",
  "save document",
  "save file",
  "save text",
  "upload arrow",
  "iso",
  "brightness adjustment",
  "camera control",
  "darker",
  "exposure level",
  "image adjustment",
  "light adjustment",
  "minus one",
  "neg",
  "photography editing",
  "decrement",
  "photographic",
  "exposure plus one",
  "increment value",
  "numerical increment",
  "plus one",
  "darkroom",
  "plus 2",
  "zeroed",
  "jigsaw",
  "plugin add",
  "quadrilateral",
  "unfilled",
  "extension off",
  "plug-in",
  "turn off extension",
  "unavailable add-on",
  "unavailable extension",
  "unavailable plug-in",
  "biometrics",
  "eyeball",
  "gaze",
  "iris",
  "motion sensor",
  "observation",
  "pupil",
  "rounded shape",
  "connecting line",
  "eyeglasses",
  "specs",
  "spectacles",
  "sunglasses",
  "eyewear",
  "lenses",
  "personal item",
  "symmetric",
  "facial",
  "guest",
  "head outline",
  "headshot",
  "incognito",
  "profile outline",
  "head icon",
  "head profile",
  "identity icon",
  "side view",
  "smile icon",
  "generic",
  "brokenhearted",
  "crestfallen",
  "crying",
  "dejected",
  "depressed",
  "despair",
  "disappointment",
  "distressed",
  "downturned",
  "face down",
  "frown",
  "gestures",
  "glum",
  "grief",
  "grimace",
  "head down",
  "lament",
  "melancholy",
  "misery",
  "sadness",
  "somber",
  "sorrow",
  "tearful",
  "teary",
  "unhappy",
  "upset",
  "looking left",
  "no editing",
  "retouch",
  "retouching",
  "face right",
  "facing right",
  "head right",
  "person right",
  "profile right",
  "view right",
  "anxious",
  "bewildered",
  "bobble",
  "confused",
  "disagreement",
  "shocked",
  "startled",
  "stressed",
  "surprised",
  "uncertain",
  "unsure",
  "wobble",
  "likeness",
  "pleasant",
  "approval status",
  "authenticity",
  "fact",
  "fact check",
  "fabrication",
  "smokestack",
  "warehouse",
  "fall",
  "falling",
  "going down",
  "instability",
  "losing",
  "losing value",
  "setback",
  "allowed entry",
  "area monitoring",
  "authorized access",
  "authorized zone",
  "biometric zone",
  "controlled access",
  "detection zone",
  "face detection",
  "face recognition",
  "facial recognition",
  "familiar",
  "familiar faces",
  "familiar person zone",
  "guided frame",
  "identification zone",
  "identity zone",
  "known face zone",
  "monitored zone",
  "person detection",
  "protected area",
  "safe zone",
  "secure area",
  "security area",
  "security zone",
  "ancestor",
  "ancestry",
  "bonds",
  "family tree",
  "genealogy",
  "heritage",
  "legacy",
  "lineage",
  "pedigree",
  "relative",
  "relatives",
  "roots",
  "family home",
  "association",
  "family group",
  "family members",
  "kite",
  "kiting",
  "linked profiles",
  "linked users",
  "person icons",
  "profile icons",
  "family restroom",
  "public restroom",
  "relief",
  "unisex",
  "blades",
  "propeller",
  "air movement",
  "cool air",
  "indirect",
  "oscillating fan",
  "standing fan",
  "binocular",
  "farsight",
  "observe",
  "telescope",
  "double arrows",
  "left arrows",
  "move back",
  "quickly",
  "american food",
  "bun",
  "burger",
  "burger icon",
  "cheeseburger",
  "circle with rectangle",
  "fast food",
  "fast food icon",
  "fastfood",
  "food and drink icon",
  "order food",
  "patty",
  "restaurant icon",
  "sandwich",
  "sesame seeds",
  "takeaway",
  "faucet",
  "lever",
  "plumbing fixture",
  "spout",
  "valve",
  "affection",
  "appreciation",
  "fax",
  "vintage",
  "feature search",
  "find feature",
  "search feature",
  "search icon",
  "episodes",
  "shows",
  "and",
  "bow",
  "gift",
  "gifts",
  "offering",
  "wrapping",
  "advertised",
  "spotlight",
  "delivery failed",
  "public address",
  "send failed",
  "bones",
  "femur",
  "femur bone",
  "hip",
  "knee",
  "leg bone",
  "orthopedic",
  "skeletal",
  "skeletal system",
  "skeleton",
  "thigh bone",
  "fracture",
  "single object",
  "x-ray",
  "boundary line",
  "fence",
  "grass",
  "picket fence",
  "wooden",
  "cultivate",
  "gardening",
  "menstrual",
  "new life",
  "ovulation",
  "circus",
  "dance",
  "festival",
  "fiber",
  "fiber dvr",
  "cutting edge",
  "fiber new",
  "communication link",
  "fiber optic",
  "fiber pin",
  "network connection",
  "optic cable",
  "signal transmission",
  "pvr",
  "smart record",
  "create copy",
  "record book",
  "save a copy",
  "not copied",
  "red",
  "removed",
  "cannot download",
  "document access",
  "download blocked",
  "download disabled",
  "download error",
  "download off",
  "download problem",
  "download restricted",
  "download unavailable",
  "file access",
  "file download blocked",
  "file download disabled",
  "file download off",
  "file download restricted",
  "file download unavailable",
  "file error",
  "not downloadable",
  "API",
  "brackets.",
  "curly braces",
  "curly bracket",
  "gif",
  "json",
  "viewer",
  "cartography",
  "data sheets",
  "documents stack",
  "stack of papers",
  "access file",
  "file open",
  "folder open",
  "open document",
  "open file",
  "view file",
  "document file",
  "interface object",
  "raster",
  "keynote",
  "floppy",
  "floppy disk",
  "save data",
  "crossout",
  "do not save",
  "no save",
  "not saved",
  "saving blocked",
  "saving disabled",
  "saving off",
  "saving prohibited",
  "saving restricted",
  "saving unavailable",
  "barred",
  "strikethrough",
  "layered documents",
  "layered papers",
  "papers stack",
  "categorization",
  "narrowing",
  "refinement",
  "sorting",
  "refined",
  "specific",
  "filter 2",
  "filter by 2",
  "level 2",
  "restriction.",
  "sieve",
  "constraints",
  "digit five",
  "filtering data",
  "five items",
  "apply filter",
  "count filter",
  "data refinement",
  "filter by number",
  "filter count",
  "filter results",
  "list filter",
  "max items",
  "number 6",
  "numbered filter",
  "numeric filter",
  "quantity filter",
  "refine results",
  "six items",
  "constrain",
  "criterion",
  "digit 8",
  "filtration",
  "number 8",
  "number.",
  "sifter",
  "nine items",
  "9 plus",
  "9+",
  "limit results",
  "nine plus",
  "search filter",
  "search options",
  "select criteria",
  "selection limit",
  "sort data",
  "inverted triangle",
  "sift",
  "clear criteria",
  "clear filter",
  "clear selection",
  "data options",
  "disable filter",
  "filter alt off",
  "filter disabled",
  "filter off",
  "filter removed",
  "filter state",
  "filtering off",
  "filtering state off",
  "funnel disabled",
  "funnel off",
  "list options",
  "menu filter",
  "no filter",
  "options filter",
  "remove criteria",
  "remove filter",
  "remove selection",
  "reset filter",
  "reset selection",
  "selection filter",
  "sort off",
  "sorting disabled",
  "turn off filter",
  "undo filter",
  "b",
  "b&w",
  "black and white",
  "classic",
  "color correction",
  "monochrome",
  "photo effects",
  "w",
  "center focus",
  "ominous",
  "scene",
  "sky camera",
  "special effects",
  "boarders",
  "frames.",
  "layering",
  "hdr",
  "high dynamic range",
  "scenery",
  "triangles",
  "options menu",
  "preferences menu",
  "settings menu",
  "disabled filter",
  "not filtering",
  "unfilter",
  "no change",
  "no effect",
  "original",
  "pure",
  "revert",
  "unapplied",
  "unedited",
  "unenhanced",
  "unfiltered",
  "unfiltered data",
  "unfiltered image",
  "unfiltered results",
  "pyramid",
  "retrolux",
  "tilt shift",
  "antique",
  "faded",
  "grain",
  "instagram",
  "preset",
  "snapchat",
  "bills",
  "cash stack",
  "currency stack",
  "earnings",
  "greenback",
  "paper money",
  "tender",
  "wad",
  "rfid",
  "smart card",
  "stocks",
  "find in page",
  "scrutiny",
  "search box",
  "fingerprint",
  "log in",
  "swirls",
  "thumbprint",
  "touch id",
  "scanned",
  "security feature",
  "extinguish",
  "extinguisher",
  "fire extinguisher",
  "flammable",
  "nozzle",
  "suppression",
  "department",
  "fire hydrant",
  "fire protection",
  "firefighter",
  "hose",
  "hydrant",
  "municipal",
  "pipe",
  "spigot",
  "standpipe",
  "emergency vehicle",
  "fire engine",
  "fire station",
  "fire truck",
  "land vehicle",
  "lights",
  "public service",
  "barbecue",
  "burning",
  "ember",
  "fireplace",
  "grill",
  "hearth",
  "ignition",
  "logs",
  "pit",
  "survival",
  "content view",
  "document view",
  "fit screen",
  "fit to page",
  "optimal view",
  "zoom to page",
  "adjust height",
  "adjust view",
  "content height",
  "document height",
  "expand height",
  "fit height",
  "fit page",
  "fit to view",
  "full height",
  "height adjustment",
  "height control",
  "height fit",
  "height icon",
  "page height",
  "page scale",
  "page view",
  "resize height",
  "scale height",
  "scale view",
  "screen height",
  "tall",
  "vertical fit",
  "vertical scale",
  "vertical view",
  "view height",
  "window height",
  "zoom height",
  "fit width",
  "page width",
  "viewport",
  "zoom to width",
  "document width",
  "expand horizontal",
  "resizing",
  "screen size",
  "view settings",
  "barbell",
  "fitness center",
  "fitness club",
  "gym class",
  "gym equipment",
  "health club",
  "lifting",
  "personal training",
  "training equipment",
  "weightlifting",
  "workout center",
  "fitness data",
  "goals",
  "pedometer",
  "step counter",
  "national",
  "finish line",
  "patriotism",
  "app menu",
  "close menu",
  "expanded menu",
  "flaky",
  "hide menu",
  "mobile menu",
  "open menu",
  "primary menu",
  "show menu",
  "side navigation",
  "stacked lines",
  "website navigation",
  "beam",
  "flare",
  "four points",
  "lens flare",
  "auto mode",
  "choosing",
  "camera flash",
  "camera option",
  "disable flash",
  "disable light",
  "flash disabled",
  "flash off",
  "flash setting",
  "light off",
  "lighting off",
  "mode off",
  "no flash",
  "not lit",
  "photography icon",
  "photography tool",
  "setting disabled",
  "visual setting",
  "illuminate",
  "photo flash",
  "beam off",
  "brightness.",
  "flashlight",
  "flashlight off",
  "lamp off",
  "portable light",
  "power off",
  "torch off",
  "dishware",
  "flatware",
  "table setting",
  "layouts",
  "3x3",
  "no wrap",
  "6x6",
  "flex wrap",
  "new line",
  "text flow",
  "text wrap",
  "wraparound",
  "flying mode",
  "jet",
  "aisle",
  "passenger experience",
  "window seat",
  "arriving",
  "departing",
  "flight arrival",
  "flight landing",
  "land flight",
  "land plane",
  "landing",
  "travel arrival",
  "travel landing",
  "air transport",
  "moving forward",
  "takeoff",
  "takeoff runway",
  "wing",
  "hotels",
  "travel planning",
  "change direction",
  "commands",
  "horizontal flip",
  "pivot",
  "reflect",
  "scan scanning",
  "vertical flip",
  "arrows pointing opposite directions",
  "camera button",
  "camera direction",
  "change perspective",
  "change view",
  "device camera",
  "mobile photography",
  "phone camera",
  "video conferencing",
  "bring forward",
  "bring to front",
  "move front",
  "send backward",
  "send to back",
  "bring to top",
  "flip over",
  "flip to front",
  "send to front",
  "two cards",
  "floating window",
  "miniaturize",
  "multi window",
  "picture-in-picture",
  "pip",
  "popout",
  "screen sharing",
  "small window",
  "float",
  "abstract waves",
  "deluge",
  "drowning",
  "extreme weather",
  "flood",
  "flooding",
  "flowing water",
  "heavy rain",
  "high water",
  "inundation",
  "rising water",
  "horizontal rule",
  "single line",
  "ambiance",
  "electric light",
  "fixture",
  "floor ",
  "floor lamp",
  "lamp",
  "reading lamp",
  "standing lamp",
  "stages",
  "blueprint",
  "data flow",
  "dependencies",
  "flowsheet",
  "information flow",
  "procedure",
  "relations",
  "blob",
  "curvy",
  "fluids",
  "plasma",
  "river",
  "tear",
  "glassware",
  "ph",
  "pour",
  "sample",
  "substance",
  "titration",
  "glass bottle",
  "potion",
  "serum",
  "vial",
  "fluorescent",
  "gleam",
  "incandescent",
  "iridescent",
  "light bulb",
  "lightbulb",
  "tungsten",
  "wb",
  "white balance",
  "cross platform",
  "dart",
  "flutter",
  "framework",
  "ui framework",
  "alien",
  "bird",
  "creature",
  "cute",
  "humanoid",
  "stylized",
  "bird's eye view",
  "freeway",
  "intersection",
  "overpass",
  "road bridge",
  "bad",
  "fmd",
  "geo marker",
  "geo pin",
  "geolocation off",
  "geotagging off",
  "location denied",
  "location error",
  "location pin",
  "location unavailable",
  "map denied",
  "map disabled",
  "map error",
  "map unavailable",
  "clouds",
  "foggy",
  "low visibility",
  "natural phenomenon",
  "poor visibility",
  "unclear",
  "blessing",
  "blessings",
  "charity",
  "gratitude",
  "hands together",
  "hope",
  "kindness",
  "meditate",
  "peace",
  "pleading",
  "please",
  "pray",
  "prayer",
  "praying hands",
  "solidarity",
  "spirituality",
  "thank you",
  "thanks",
  "data records",
  "digital storage",
  "document archive",
  "file storage",
  "file system",
  "filled folder",
  "full folder",
  "organized files",
  "processed",
  "stored",
  "finalized",
  "code development",
  "development folder",
  "directory code",
  "files and folders",
  "programming folder",
  "generate copy",
  "save as",
  "save copy",
  "folder management",
  "recycle bin",
  "repository.",
  "contents",
  "folder explore",
  "folder view",
  "folder with eye",
  "uncover",
  "explanation",
  "closed folder",
  "private folder",
  "restricted folder",
  "secured folder",
  "compartment",
  "locating",
  "close folder",
  "data folder off",
  "delete folder",
  "directory off",
  "document folder off",
  "file folder off",
  "folder access denied",
  "folder blocked",
  "folder disable",
  "folder disabled",
  "folder off",
  "folder restricted",
  "folder unavailable",
  "no folder",
  "private folder off",
  "remove folder",
  "secret folder off",
  "storage folder off",
  "file explorer",
  "tabbed",
  "data sharing",
  "folder icon",
  "folder shared",
  "share documents",
  "share files",
  "shared",
  "shared folder",
  "shared icon",
  "favorite folder",
  "important folder",
  "marked folder",
  "saved folder",
  "special folder",
  "starred",
  "starred folder",
  "managed",
  "oversight",
  "protector",
  "supervised",
  "archive file",
  "compressed file",
  "file folder",
  "file zip",
  "folder archive",
  "folder compress",
  "folder zip",
  "storage icon",
  "storage management",
  "zip",
  "zip icon",
  "crossroads",
  "junction",
  "signpost",
  "signs",
  "the",
  "turn indicator",
  "cancel download",
  "disabled font download",
  "download font",
  "download text",
  "download typography",
  "font download blocked",
  "font download off",
  "font download unavailable",
  "glyph download off",
  "letter download off",
  "no access.",
  "no download",
  "stop download",
  "text download off",
  "typography download disabled",
  "donation",
  "food bank",
  "non-profit",
  "provisions",
  "welfare",
  "ankle",
  "heel",
  "orthopedics",
  "podiatry",
  "toe",
  "animal track",
  "bare foot",
  "evidence",
  "footprints",
  "human footprint",
  "paw print",
  "trekking",
  "wildlife",
  "curated",
  "customized",
  "profile.",
  "recommendations",
  "suggestions",
  "tailored",
  "flora",
  "jungle",
  "plantation",
  "plants",
  "woodland",
  "branch left",
  "branching path",
  "deviation",
  "fork left",
  "pathway",
  "sidetrack",
  "split left",
  "veer",
  "branch right",
  "curve right",
  "direction right",
  "diverge right",
  "divide right",
  "drive right",
  "fork right",
  "journey right",
  "junction right",
  "merge right",
  "movement right",
  "navigate right",
  "path right",
  "right bend",
  "rightward",
  "route right",
  "side right",
  "split right",
  "travel right",
  "eating utensil",
  "forklift",
  "heavy lifting",
  "industrial vehicle",
  "lift truck",
  "supply chain",
  "align middle",
  "centered alignment",
  "centered text",
  "equal lines",
  "symmetric lines",
  "blocks of text",
  "document format",
  "full align",
  "line breaks",
  "right align",
  "align document",
  "left justified",
  "uneven lines",
  "writing editor",
  "adjust text",
  "justified right",
  "justify right",
  "multi-line",
  "paragraph align",
  "right aligned",
  "text justify",
  "B",
  "bold",
  "rich text",
  "T",
  "document cleaning",
  "document tools",
  "editor tools",
  "paint brush",
  "style cleaner",
  "style removal",
  "text cleaning",
  "background fill",
  "bucket fill",
  "design tools",
  "fill tool",
  "format brush",
  "paint bucket",
  "paint can",
  "shape fill",
  "angled line",
  "choose color",
  "clear color",
  "color swatch",
  "default color",
  "initial color",
  "original color",
  "remove color",
  "reset color",
  "select color",
  "ab",
  "abc",
  "change color",
  "font style",
  "letter t",
  "t symbol",
  "text color",
  "article writing",
  "bold text",
  "h1",
  "header",
  "heading",
  "large text",
  "paragraph styling",
  "big text",
  "h tag",
  "h2",
  "semantic tag",
  "h3",
  "header level 3",
  "letter h",
  "numeral 3",
  "h4",
  "heading 4",
  "markdown",
  "h5",
  "level 5",
  "h",
  "h6",
  "smallest",
  "align image",
  "image left",
  "wrap text",
  "article layout",
  "blog post",
  "content arrangement",
  "format image right",
  "image placement",
  "media placement",
  "right alignment",
  "text with image",
  "visual formatting",
  "alignment control",
  "decrease indent",
  "decrease indentation",
  "document control",
  "indent decrease",
  "left alignment",
  "text control",
  "writing assistant",
  "writing tools",
  "block quote",
  "formatting control",
  "increase indent",
  "indent right",
  "nested text",
  "paragraph formatting",
  "paragraph layout",
  "text adjustment",
  "text display",
  "text indent",
  "text styling",
  "digital pen",
  "highlighter",
  "highlighting",
  "marker pen",
  "stylus",
  "text marker",
  "emphasize",
  "italic",
  "leaning",
  "slant right",
  "letter spacing",
  "text spacing",
  "expand spacing",
  "glyphs",
  "increase spacing",
  "widen",
  "padding",
  "three dashes",
  "adjust spacing",
  "decrease spacing",
  "typography control",
  "vertical spacing",
  "bulleted",
  "bullets",
  "add to list",
  "formatted",
  "new entry",
  "new list item",
  "ordered",
  "unordered",
  "format options",
  "numbered",
  "numbering style",
  "ordered items",
  "organizing",
  "sequence order",
  "arabic",
  "bulleted list",
  "hebrew",
  "list number",
  "line above text",
  "overline",
  "strike above",
  "strikeline",
  "strikeline above",
  "strikethrough above",
  "text effect",
  "under",
  "upper line",
  "coloring",
  "fill color",
  "roller",
  "tint",
  "straight lines",
  "blockquote",
  "double quote",
  "marks",
  "quotations",
  "quote",
  "testimonial",
  "unquote",
  "format shapes",
  "a a",
  "alphabet size",
  "big a little a",
  "character size",
  "document scale",
  "font size",
  "letter size",
  "text scale",
  "text size",
  "uppercase lowercase",
  "crossed",
  "formatting option",
  "line through text",
  "strikethru",
  "through",
  "textdirection",
  "truncate",
  "overflow",
  "auto wrap",
  "break lines",
  "break text",
  "rearrange text",
  "reformat text",
  "text arrangement",
  "word wrap",
  "writing aid",
  "writing lines",
  "bidirectional text",
  "formatting tools",
  "ltr",
  "paragraph direction",
  "writing direction",
  "alignment direction",
  "internationalization",
  "localization",
  "writing mode",
  "text direction",
  "up down",
  "decorative line",
  "underlined",
  "understrike",
  "font styles",
  "grammar error",
  "spelling error",
  "text correction",
  "text styles",
  "underline squiggle",
  "wavy",
  "wavy line",
  "wavy underline",
  "forms",
  "execution",
  "battlements",
  "military",
  "answers",
  "debate",
  "qa",
  "question_answer",
  "questions",
  "forward icon",
  "google plus",
  "google plus share",
  "reshare",
  "reshare icon",
  "send icon",
  "send to",
  "share arrow",
  "share content",
  "share icon",
  "share link",
  "share post",
  "share to",
  "share with",
  "social icon",
  "social share",
  "10 seconds",
  "podcast",
  "arrow 30",
  "arrow with number",
  "forward 30",
  "jump ahead",
  "media playback",
  "move ahead",
  "rewind forward",
  "skip ahead",
  "5 seconds forward",
  "adjust playback",
  "audio player",
  "media buttons",
  "playback controls",
  "plus 5 seconds",
  "scrub forward",
  "seek forward",
  "step forward",
  "time skip",
  "advance track",
  "quick skip",
  "skip track",
  "arrow icon",
  "envelope icon",
  "inbox icon",
  "letter icon",
  "mail icon",
  "message forwarding",
  "message transfer",
  "send mail",
  "architectural element",
  "base icon",
  "basis",
  "construction icon",
  "core",
  "establishing",
  "fundamental",
  "pillar",
  "root",
  "stable",
  "atomiser",
  "body spray",
  "cologne",
  "eau de parfum",
  "essence",
  "fragrance spray",
  "perfume",
  "perfume bottle",
  "borders",
  "frame person",
  "frame profile",
  "frame selection",
  "frame user",
  "framed person",
  "framed portrait",
  "framed profile",
  "framed user",
  "photo frame",
  "interview",
  "frame off",
  "person off",
  "user off",
  "arrow circle",
  "cycle icon",
  "refresh button",
  "refresh icon",
  "refresh symbol",
  "reload button",
  "reload icon",
  "reload symbol",
  "retry",
  "round arrow",
  "data source",
  "empty frame",
  "origin",
  "back out",
  "override",
  "refusal",
  "hello",
  "outstretched hand",
  "cab",
  "digging",
  "earthwork",
  "excavation",
  "front loader",
  "gravel",
  "heavy equipment",
  "tires",
  "embrace",
  "enclose",
  "propaganda",
  "surround",
  "full hd",
  "optimal",
  "enlarge view",
  "enlarge window",
  "expand view",
  "increase view",
  "presentation mode",
  "scale window",
  "size view",
  "viewing area",
  "window size",
  "blow up",
  "formula",
  "fx",
  "capabilities",
  "cogwheels",
  "mechanisms",
  "escalator.",
  "funicular",
  "ropeway",
  "ski resort",
  "g",
  "g_mobiledata",
  "letter g",
  "a icon",
  "babel",
  "convert language",
  "foreign language",
  "g icon",
  "language barrier",
  "language change",
  "linguistic",
  "multiple languages",
  "switch language",
  "translator",
  "two languages",
  "display options",
  "gallery thumbnail",
  "graphic view",
  "image grid",
  "image squares",
  "layout options",
  "media collection",
  "media grid",
  "photo gallery",
  "photo squares",
  "picture gallery",
  "picture squares",
  "preview",
  "square grid",
  "thumbnail view",
  "tiled images",
  "tiled photos",
  "tiled pictures",
  "view options",
  "visual grid",
  "visual layout",
  "playstation",
  "video games",
  "shed",
  "car storage",
  "closing",
  "garage door",
  "vehicle storage",
  "garden cart",
  "heavy duty",
  "landscaping",
  "outdoor equipment",
  "transportation device",
  "wheelbarrow",
  "analog indicator",
  "circular gauge",
  "circular meter",
  "dashboard element",
  "energy meter",
  "fuel gauge",
  "fuel level",
  "gas meter",
  "measurement device",
  "usage indicator",
  "abdominal",
  "colon",
  "digest",
  "digestive",
  "digestive system",
  "digestive tract",
  "esophagus",
  "gastro",
  "gi",
  "gut",
  "guts",
  "internal organs",
  "intestine",
  "intestines",
  "medical test",
  "organ",
  "stomach",
  "tract",
  "allow",
  "attorney",
  "auction",
  "authority",
  "courtroom",
  "gavel",
  "judge",
  "judgment call",
  "judiciary",
  "lawyer",
  "legal proceedings",
  "legislation",
  "mallet",
  "trial",
  "verdict",
  "wood object",
  "general device",
  "rectanglar",
  "double helix",
  "genetic",
  "genetic code",
  "hereditary",
  "science icon",
  "genre",
  "genres",
  "musical notes",
  "themes",
  "types",
  "thread",
  "bitmap",
  "three letters",
  "asynchronous",
  "fetching",
  "requesting",
  "f",
  "moving image",
  "generic user",
  "gite",
  "pipeline",
  "pull request",
  "repository manager",
  "drinking",
  "drinkware",
  "waterglass",
  "meridians",
  "orbit",
  "parallels",
  "worldwide",
  "asia",
  "continent",
  "southeast",
  "atlas",
  "britain",
  "england",
  "northern ireland",
  "scotland",
  "uk",
  "wales",
  "blood sugar",
  "blood test",
  "diabetic",
  "glucose",
  "purpose",
  "goto",
  "ball",
  "fairway",
  "golf",
  "golf course",
  "golfer",
  "golfing",
  "grounds",
  "putt",
  "aerial tramway",
  "passengers",
  "ski lift",
  "urban transit",
  "device control",
  "device list",
  "google home devices",
  "home control",
  "home network",
  "network devices",
  "paired devices",
  "registered devices",
  "oblong",
  "broadcast signal",
  "gale",
  "google wifi",
  "internet access",
  "mesh network",
  "nest wifi",
  "gpp",
  "sim",
  "insecure",
  "maybe",
  "possible",
  "potential",
  "unsafe",
  "vulnerability",
  "'favorite'_new'.  ' Remove this icon & keep 'star'.",
  "'star_boarder'",
  "'star_border_purple500'",
  "'star_outline'",
  "'star_purple500'",
  "'star_rate'",
  "Same as 'star'",
  "assess",
  "grading",
  "quality control",
  "digital art",
  "imperfection",
  "picture effect",
  "speckles",
  "gain",
  "level up",
  "rectangular shape",
  "three columns",
  "vertical columns",
  "histogram",
  "data tracking",
  "line plot",
  "outcome",
  "upward trend",
  "audio customization",
  "audio effect",
  "audio mixer",
  "audio spectrum",
  "audio tuning",
  "audio visualization",
  "equalizer bars",
  "frequency bands",
  "music player",
  "music settings",
  "sound analysis",
  "sound customization",
  "sound effect",
  "sound levels",
  "sound mixer",
  "sound tuning",
  "fodder",
  "lawn",
  "meadow",
  "pasture",
  "turf",
  "wild",
  "3x3 grid",
  "album view",
  "gallery view",
  "nine blocks",
  "nine cells",
  "ungrid",
  "four by four",
  "aesthetic",
  "composition guide",
  "fibonacci",
  "golden",
  "golden ratio",
  "goldenratio",
  "harmony",
  "layout guide",
  "rule of thirds",
  "grids",
  "guide lines",
  "guidelines",
  "guides",
  "helping",
  "layout guides",
  "showing",
  "template",
  "grid off",
  "no grid",
  "remove grid",
  "application square",
  "block layout",
  "data display",
  "information display",
  "multiple items",
  "tile view",
  "visual display",
  "commerce cart",
  "consumer",
  "e-tail",
  "fruit",
  "general store",
  "grocery",
  "retail cart",
  "retail store",
  "supermarket",
  "human figures",
  "silhouettes",
  "torsos",
  "collaborate",
  "collection of people",
  "association off",
  "cancel group",
  "cluster off",
  "collection off",
  "community off",
  "crew off",
  "delete group",
  "disband",
  "gathering off",
  "group disabled",
  "members off",
  "people disabled",
  "people off",
  "remove group",
  "society off",
  "squad off",
  "team disabled",
  "team off",
  "teams",
  "ungroup",
  "unit off",
  "users disabled",
  "users off",
  "account delete",
  "account minus",
  "account remove",
  "add remove",
  "delete person",
  "delete user",
  "group delete",
  "minus group",
  "minus person",
  "minus user",
  "person delete",
  "person group",
  "person minus",
  "person remove",
  "profile delete",
  "profile minus",
  "profile remove",
  "remove person",
  "remove user",
  "social delete",
  "social minus",
  "social remove",
  "subtract group",
  "subtract person",
  "subtract user",
  "team delete",
  "team minus",
  "team remove",
  "user delete",
  "user minus",
  "user remove",
  "find group",
  "find people",
  "find team",
  "find users",
  "group search",
  "people search",
  "search group",
  "search people",
  "search team",
  "search user",
  "team search",
  "user search",
  "users search",
  "alliance",
  "colleagues",
  "employees",
  "workforce",
  "grouped bar chart",
  "grouped data",
  "report generation",
  "joined",
  "participants",
  "crowd icon",
  "members icon",
  "profiles icon",
  "team icon",
  "many people",
  "multiple people",
  "three people",
  "three users",
  "aegis",
  "armor",
  "bulwark",
  "custodian",
  "parental",
  "supervisor",
  "cervix",
  "fallopian",
  "feminine",
  "fertility",
  "gynaecology",
  "gynecology",
  "gyno",
  "obgyn",
  "obstetrics",
  "ovaries",
  "ovary",
  "pregnancy",
  "reproductive",
  "reproductive health",
  "uterus",
  "womb",
  "womb shape",
  "women's health",
  "cellular connection",
  "h symbol",
  "h+",
  "high speed data",
  "mobile signal",
  "fast connection",
  "h letter",
  "network signal",
  "h plus",
  "hplus",
  "bad weather",
  "hail",
  "precipitation",
  "sleet",
  "weather forecast",
  "corridor",
  "hallway",
  "tunnel",
  "vanishing point",
  "xray",
  "flat hand",
  "gesture recognition",
  "hand shape",
  "hand sign",
  "hand symbol",
  "do not",
  "nope",
  "paused",
  "silenced",
  "analog stick",
  "arcade",
  "digital game",
  "flight stick",
  "game controller",
  "game input",
  "gaming device",
  "handheld controller",
  "input device",
  "mobile game",
  "online game",
  "video game controller",
  "videogame",
  "accord",
  "handshake",
  "joining hands",
  "negotiation",
  "two hands",
  "craftsman",
  "screw",
  "screwdriver",
  "hangout",
  "call button",
  "camera disabled",
  "camera mute",
  "camera off",
  "camera turned off",
  "conferencing icon",
  "disable camera",
  "end video",
  "mute camera",
  "video button",
  "video communication",
  "video disabled",
  "video mute",
  "video off",
  "video turned off",
  "web conferencing",
  "disk drive",
  "external drive",
  "internal drive",
  "slots",
  "nail",
  "letter d",
  "capital a",
  "hdr auto",
  "letter a",
  "advanced settings",
  "editing controls",
  "highlights",
  "image adjustments",
  "image enhancement",
  "tone mapping",
  "visual settings",
  "hdr disabled",
  "hdr off",
  "high dynamic range disabled",
  "high dynamic range off",
  "letters h d r",
  "letters hdr",
  "text cancel",
  "text disabled",
  "text off",
  "no hdr",
  "three characters",
  "applied",
  "hdr plus",
  "hdr plus on",
  "improve image",
  "picture enhancement",
  "video enhancement",
  "augmented",
  "daydream",
  "goggles",
  "head mounted display",
  "hmd",
  "metaverse",
  "mixed reality",
  "mr",
  "ear cups",
  "headband",
  "headphones icon",
  "headset icon",
  "over ear",
  "symbol.",
  "boom mic",
  "double earpiece",
  "earpieces",
  "listen and talk",
  "speak and listen",
  "audio off",
  "headphones muted",
  "headphones off",
  "headset muted",
  "muted audio",
  "bandage",
  "cure",
  "healing",
  "hospital cross",
  "infirmary",
  "lifeline",
  "medical cross",
  "comb",
  "doctors",
  "heart with pulse",
  "makeup",
  "patient care",
  "well-being",
  "cross symbol",
  "health shield",
  "immune",
  "medical shield",
  "medicare",
  "preventative",
  "reliable",
  "safety shield",
  "safety symbol",
  "shield symbol",
  "blood oxygen saturation",
  "breathing rate",
  "heart rate variability",
  "resting heart rate",
  "skin temperature",
  "vital",
  "heap",
  "java",
  "document stack",
  "file stack",
  "heap dump",
  "heap snapshot",
  "memory dump",
  "programming memory",
  "stack of documents",
  "column chart",
  "statistical chart",
  "ability",
  "audible",
  "fidelity",
  "amplify",
  "ear health",
  "hearing loss",
  "prosthetics",
  "impairment",
  "left side",
  "accessibility feature",
  "health technology",
  "left ear",
  "sound amplification",
  "hard of hearing",
  "hearing disabled",
  "hearing impairment",
  "bad review",
  "broken heart",
  "crush",
  "dislike",
  "favourite",
  "not liked",
  "not loved",
  "unfavorite button",
  "unfavourite",
  "unlike",
  "unlike button",
  "unloved",
  "two-dimensional",
  "arc",
  "furnance",
  "heat pump",
  "dimension tool",
  "double ended arrow",
  "length measurement",
  "measurement tool",
  "scale indicator",
  "size indicator",
  "size tool",
  "straight line",
  "vertical dimension",
  "vertical measurement",
  "chopper",
  "helicopter",
  "rotorcraft",
  "clover",
  "genai",
  "instructions",
  "pointers",
  "puzzled",
  "query bubble",
  "tips",
  "help center",
  "online support",
  "support agent",
  "support chat",
  "blood analysis",
  "blood cells",
  "healthcare icon",
  "hematology",
  "laboratory test",
  "medical lab",
  "medical testing",
  "pathology",
  "vein",
  "veins",
  "acronym",
  "compression",
  "encoding",
  "h.265",
  "hevc",
  "high efficiency video coding",
  "hexagon",
  "six sides",
  "six-sided",
  "concealed",
  "strikeout",
  "unseeable",
  "censored",
  "concealment",
  "hiding",
  "private mode",
  "unreveal",
  "unviewable",
  "bundled",
  "concentrated",
  "crowded",
  "numerous",
  "potent",
  "rich",
  "excellent",
  "five star",
  "gold",
  "hq",
  "quality mark",
  "seal of approval",
  "winner's medal",
  "fhd",
  "emphasizing",
  "yellow",
  "I",
  "chromeos",
  "pointer arrow",
  "blinking cursor",
  "blinking indicator",
  "blinking line",
  "code editor",
  "focus indicator",
  "insertion point",
  "text area",
  "text cursor",
  "text field",
  "text input",
  "angled bar",
  "diagonal bar",
  "sketching",
  "slanted bar",
  "slanted line",
  "emphasize text",
  "wide stroke",
  "backpacking",
  "climb",
  "climbing",
  "duffle",
  "ramble",
  "trek",
  "uphill",
  "factory reset",
  "history.",
  "initialization",
  "start over",
  "elapsed",
  "diploma",
  "edu",
  "feather",
  "graduation",
  "lesson",
  "quill",
  "logging",
  "disable history",
  "disabled.",
  "history toggle off",
  "turn off history",
  "apiary",
  "beehive",
  "colony",
  "hexagonal",
  "hive",
  "honey",
  "honeycomb",
  "hls",
  "http live streaming",
  "technology standard",
  "video streaming",
  "hls off",
  "video controls",
  "buildings",
  "cityscape",
  "holiday village",
  "houses",
  "neighborhood",
  "settlement",
  "skyline",
  "application--house",
  "domicile",
  "homepage",
  "startup",
  "condo",
  "facade",
  "home care",
  "medical building",
  "DIY",
  "home improvement",
  "toolbox",
  "max",
  "things",
  "landing page",
  "Internet",
  "favorite home",
  "favorite place",
  "pinned home",
  "pinned location",
  "saved home",
  "saved location",
  "saved place",
  "adjustable wrench",
  "kit",
  "pliers",
  "repairing",
  "pod",
  "building outline",
  "home storage",
  "house outline",
  "server room",
  "storage building",
  "storage house",
  "technology center",
  "employment",
  "content separator",
  "gmail",
  "novitas",
  "visual break",
  "content organization",
  "double panel",
  "dual view",
  "horizontal division",
  "horizontal split",
  "interface layout",
  "layout management",
  "multi-panel",
  "multiple panels",
  "screen division",
  "screen split",
  "two panels",
  "user interface element",
  "endpoint",
  "guesthouse",
  "star rating",
  "measuring",
  "old fashioned",
  "sand timer",
  "time based",
  "sort by time",
  "time ascending",
  "interval",
  "expired",
  "measure time",
  "passing time",
  "sandglass",
  "or",
  "symmetrical",
  "two-part",
  "epoch",
  "era",
  "aluminum",
  "architectural",
  "building material",
  "house siding",
  "paneling",
  "siding",
  "textured",
  "vinyl",
  "defend",
  "fortified",
  "houseboat",
  "travel industry",
  "watercraft",
  "cleaning supplies",
  "disinfecting",
  "household supplies",
  "rectangular shapes",
  "simplified",
  "spray bottle",
  "squeegee",
  "carpool",
  "high occupancy vehicle",
  "hover",
  "onhover",
  "tooltip",
  "subscribe button",
  "subscribed",
  "to reg",
  "ballot box",
  "ballot paper",
  "casting a vote",
  "civic duty",
  "deciding",
  "hand with x mark",
  "how to vote",
  "participation",
  "polling station",
  "selection process",
  "voting guide",
  "voting process",
  "downtime",
  "exhaustion",
  "fatigue",
  "hospital bed",
  "ill",
  "laying down",
  "lying down",
  "resting",
  "tired",
  "unconscious",
  "development tools",
  "internet code",
  "markup language",
  "address bar",
  "client",
  "http",
  "http protocol",
  "central",
  "convergence",
  "data hub",
  "focal point",
  "linking",
  "resource center",
  "shared resource",
  "topology",
  "forelimb",
  "humerus",
  "upper arm",
  "arm bone",
  "educational",
  "medical imaging",
  "radiology",
  "damp",
  "humidity high",
  "vapor",
  "wet",
  "hygrometer",
  "atmospheric conditions",
  "dry air",
  "environmental conditions",
  "fewer drops",
  "humidity low",
  "less humid",
  "low humidity",
  "menstruation",
  "meteorological",
  "minimal humidity",
  "minimal moisture",
  "air icon",
  "climate data",
  "climate icon",
  "dampness",
  "drop icon",
  "environmental data",
  "humidity sensor",
  "raindrop",
  "raindrop icon",
  "water icon",
  "weather icon",
  "weather station",
  "wetness",
  "droplet shape",
  "filled droplet",
  "regulate",
  "car icon",
  "clear window",
  "defrost icon",
  "defrosting",
  "fan symbol",
  "max defrost",
  "maximum defrost",
  "window symbol",
  "figure skating",
  "footwear",
  "hockey skate",
  "ice skate",
  "olympics",
  "skate",
  "skates",
  "skating",
  "speed skating",
  "winter sport",
  "cream",
  "ice cream",
  "icecream",
  "indulgence",
  "picnic",
  "scoop",
  "access card",
  "credentials",
  "driver's license",
  "employee id",
  "id_card",
  "identity card",
  "name tag",
  "passport",
  "visitor pass",
  "authenticate",
  "aware",
  "iap",
  "collapsed",
  "die",
  "i'm",
  "ifl",
  "lucky",
  "triple lines",
  "embed",
  "iframe",
  "inline",
  "area off",
  "block iframe",
  "box off",
  "component off",
  "deactivate iframe",
  "disable iframe",
  "embed off",
  "external content off",
  "hide iframe",
  "iframe off",
  "object off",
  "rectangle off",
  "remove iframe",
  "screen off",
  "section off",
  "un-embed",
  "web content off",
  "web element off",
  "window off",
  "sunrise",
  "sunset",
  "send image",
  "bing visual search",
  "camera search",
  "content search",
  "database search",
  "digital eye",
  "discover image",
  "find image",
  "find similar",
  "google lens",
  "identify",
  "image input",
  "image search",
  "internet search",
  "media search",
  "object recognition",
  "online search",
  "photo search",
  "picture search",
  "reverse image search",
  "visual search",
  "web search",
  "applicator",
  "coating",
  "house painting",
  "imagesearch",
  "paint roller",
  "resurface",
  "wall painting",
  "antibody",
  "dna helix",
  "immune system",
  "immunology",
  "infectious",
  "science and technology",
  "vaccine",
  "viruses",
  "opened book",
  "at home",
  "building icon",
  "home mode",
  "house mode",
  "in home",
  "in_home_mode",
  "location icon",
  "on property",
  "place icon",
  "shelter icon",
  "disabled state",
  "inactive order",
  "inactive state",
  "liste",
  "noninteractive",
  "numaralandÄ±rma",
  "order icon",
  "orders",
  "receipts",
  "sequence icon",
  "sÄ±ralÄ± liste",
  "sıralama",
  "communication center",
  "container box",
  "digital inbox",
  "message center",
  "new mail",
  "new messages",
  "received items",
  "storage box",
  "virtual inbox",
  "customize inbox",
  "email preferences",
  "inbox settings",
  "mail settings",
  "message options",
  "personal settings",
  "sprockets",
  "outstanding",
  "inbox with person",
  "mail with person",
  "message with user",
  "personal inbox",
  "private message",
  "profile inbox",
  "receiving",
  "recipient",
  "recipient mail",
  "text in box",
  "user inbox",
  "communication symbol",
  "document box",
  "inbox share",
  "information sharing",
  "share text",
  "broken circle",
  "open circle",
  "refresh spinner",
  "box with line",
  "checkbox with line",
  "form control",
  "indeterminate state",
  "option box",
  "selection box",
  "toggle box",
  "undetermined",
  "mysterious",
  "puzzling",
  "advice",
  "explain",
  "electromagnetic",
  "infrared",
  "ir",
  "thermal",
  "wavelength",
  "art supplies",
  "remove drawing",
  "remove ink",
  "remove pen",
  "remove pencil",
  "rub out",
  "digital ink",
  "annotating",
  "highlighting tool",
  "scribbling",
  "hand tool",
  "writing implement",
  "authorship",
  "fountain pen",
  "ink pen",
  "designate",
  "ink selection",
  "range selection",
  "text highlight",
  "text select",
  "word select",
  "inpatient",
  "lying",
  "ward",
  "input circle",
  "into",
  "dashed line",
  "formatting break",
  "horizontal divider",
  "insert break",
  "line divider",
  "new page",
  "page break",
  "text division",
  "abstract art",
  "progressive web app",
  "pwa",
  "web app",
  "automatic playlist",
  "generate playlist",
  "instant mix",
  "music playback",
  "quick mix",
  "shuffle",
  "switches",
  "wand",
  "engineering clipboard",
  "merging",
  "systems",
  "dome",
  "extended reality",
  "interact",
  "interactive space",
  "reality",
  "three dimensional",
  "wireframe",
  "xr",
  "awards",
  "reviews",
  "significance",
  "interpreter",
  "understand",
  "fulfillment",
  "listing",
  "packages",
  "packaging",
  "items.",
  "accessibility settings",
  "adjust colors",
  "color inversion",
  "invert",
  "invert colors",
  "inverted",
  "color scheme",
  "high contrast",
  "invert colors off",
  "opacity",
  "visual impairment",
  "app store",
  "iphone",
  "ipod",
  "operating",
  "spreading",
  "clothes iron",
  "electric iron",
  "garment care",
  "home.",
  "household appliance",
  "iron",
  "pressing iron",
  "steam iron",
  "textile care",
  "wrinkles",
  "brainstorm",
  "jamboard",
  "kiosk",
  "standalone",
  "whiteboard",
  "back end",
  "front end",
  "js",
  "scripting language",
  "technology symbol",
  "invite full",
  "join meeting",
  "meeting full",
  "sql",
  "start meeting",
  "combine data",
  "combine icon",
  "connect data",
  "connection icon",
  "data linking",
  "data table",
  "inner join",
  "join icon",
  "join inner",
  "link data",
  "link icon",
  "matching",
  "merge icon",
  "table join",
  "union icon",
  "venn diagram",
  "join left",
  "combining",
  "connect right",
  "data alignment",
  "database join",
  "forward arrow",
  "join right",
  "joining",
  "link right",
  "process flow",
  "two links",
  "navigate to",
  "canoe",
  "expedition",
  "kayak",
  "kayaking",
  "oar",
  "paddle",
  "paddling",
  "rafting",
  "context menu",
  "dining options",
  "food choices",
  "food menu",
  "kebab",
  "meat",
  "restaurant menu",
  "skewer",
  "vertical dots",
  "pushpin",
  "tack",
  "disable item",
  "disable keep",
  "disable pin",
  "keep note off",
  "keep off",
  "remove keep",
  "remove pin",
  "unkeep",
  "unpin",
  "unpin item",
  "unpin note",
  "pinned",
  "unrestricted",
  "brew",
  "kettle",
  "steamer",
  "tea kettle",
  "combination",
  "fob",
  "keychain",
  "safekeeping",
  "keyhole",
  "lock icon",
  "private access",
  "authentication key",
  "passkey",
  "secure access",
  "secure login",
  "vertical key",
  "vertical orientation",
  "heatmap",
  "introspection",
  "music visualizer",
  "sound visualizer",
  "device input",
  "keys",
  "virtual keyboard",
  "alternate keyboard",
  "computer hardware",
  "chevron down",
  "direction down",
  "drop down",
  "expand less",
  "expand menu",
  "expand more",
  "indicator down",
  "keyboard key down",
  "menu indicator",
  "navigation down",
  "next item",
  "next page",
  "pointer down",
  "scroll down",
  "toggle down",
  "v shape down",
  "sideways",
  "angular arrow",
  "basic arrow",
  "chevron right",
  "keyboard arrow",
  "right chevron",
  "simple arrow",
  "thin arrow",
  "triangular arrow",
  "capslock",
  "capitalization",
  "caps",
  "circular button",
  "keyboard key",
  "lowercase",
  "command key",
  "computer key",
  "macos",
  "special key",
  "control key",
  "function key",
  "dive",
  "submerge",
  "angle left",
  "arrow left",
  "back button",
  "chevron left",
  "direction left",
  "fast backward",
  "fast reverse",
  "pointing left",
  "rewind button",
  "double chevron",
  "double caret",
  "double up arrow",
  "fast up",
  "jump up",
  "keyboard icon",
  "page up",
  "skip up",
  "connect external keyboard",
  "external device",
  "external input",
  "external keyboard",
  "hookup",
  "input method",
  "keyboard connection",
  "full keyboard",
  "function keys",
  "numeric keypad",
  "spacebar",
  "onscreen",
  "soft keyboard",
  "unprotect",
  "access denied keyboard",
  "computer input off",
  "data entry off",
  "device off",
  "disable keyboard",
  "disconnect keyboard",
  "input device disabled",
  "input disabled",
  "input mode off",
  "key off",
  "keyboard control",
  "keyboard mute",
  "keyboard off",
  "keyboard setting",
  "keyboard unavailable",
  "lock keyboard",
  "mute keyboard",
  "no keyboard",
  "peripheral off",
  "text input off",
  "toggle keyboard",
  "turn off keyboard",
  "typing disabled",
  "unlock keyboard",
  "writing disabled",
  "alternate input",
  "touch keyboard",
  "alt key",
  "modifier key",
  "break line",
  "carriage return",
  "enter key",
  "keyboard return",
  "keyboard symbol",
  "newline",
  "return key",
  "text entry",
  "keyboard tab",
  "tab key",
  "keyboard tab rtl",
  "favorite child",
  "kindergarten",
  "youth",
  "double bed",
  "king bed",
  "king size",
  "large bed",
  "master bedroom",
  "building structure",
  "cabinets",
  "cooking area",
  "cooking space",
  "fridge",
  "refrigerator",
  "extreme sport",
  "freedom",
  "kiteboard",
  "kitesurfing",
  "surf",
  "surfer",
  "surfing",
  "experiment panel",
  "lab results",
  "labs",
  "research panel",
  "samples",
  "science equipment",
  "test results",
  "lab equipment",
  "research and development",
  "science lab",
  "scientific research",
  "angled shape",
  "pointed shape",
  "information.",
  "angles",
  "badge off",
  "deactivate label",
  "disable label",
  "flag off",
  "hide label",
  "identifier off",
  "indicator off",
  "label off",
  "marker off",
  "name tag off",
  "price tag off",
  "remove label",
  "sticker off",
  "unlabel",
  "untag",
  "chemistry lab",
  "conical flask",
  "flask and beaker",
  "laboratory experiment",
  "round bottom flask",
  "computers",
  "lan",
  "local area network",
  "servers",
  "terrain",
  "horizon",
  "vista",
  "earth movement",
  "falling rocks",
  "geological",
  "landslide",
  "rockfall",
  "unstable",
  "article icon",
  "storytelling",
  "dialect",
  "languages",
  "translations",
  "asian language",
  "cangjie",
  "chinese input method",
  "globe with language symbol",
  "language input method",
  "multi language",
  "regional",
  "character input",
  "chinese characters",
  "dayi",
  "east asian",
  "ideogram",
  "input mode",
  "writing system",
  "pinyin",
  "immediate",
  "wubi",
  "france",
  "francophone",
  "french",
  "british flag",
  "multinational",
  "nationality",
  "uk flag",
  "union jack",
  "globalization",
  "interpret",
  "hiragana",
  "kana",
  "katakana",
  "bilingual",
  "interpretation",
  "korean",
  "latin",
  "roman",
  "multi-language",
  "language button",
  "language icon",
  "language selection",
  "spain",
  "spanish",
  "spanish flag",
  "speaking language",
  "translation tool",
  "language option",
  "language preference",
  "language setting",
  "america",
  "colemak",
  "united states",
  "us",
  "dvorak",
  "english",
  "usa",
  "start line",
  "on the go",
  "chromebook",
  "mac chromebook",
  "laptop mac",
  "macbook",
  "portable computer",
  "choose area",
  "freeform selection",
  "freehand area",
  "lasso",
  "mark tool",
  "pick area",
  "selection tool",
  "vector graphics",
  "double lines",
  "final",
  "last",
  "last page",
  "detergent",
  "wash cycle",
  "delete layers",
  "layers clear",
  "offset",
  "remove layers",
  "airway",
  "capability",
  "data extraction",
  "document analysis",
  "drain",
  "lda",
  "natural language processing",
  "ocr",
  "optical character recognition",
  "text recognition",
  "achievements",
  "competitive",
  "high score",
  "highscores",
  "podium",
  "scores",
  "stats",
  "tiers",
  "winners",
  "drip",
  "leak",
  "synce",
  "anti leak",
  "fix leak",
  "leak detection",
  "leak prevention",
  "no leak",
  "no pipe leak",
  "no plumbing issue",
  "no water leak",
  "plug leak",
  "plumbing repair",
  "remove leak",
  "seal leak",
  "stop leak",
  "water damage prevention",
  "computer graphics",
  "left click",
  "left panel",
  "labels",
  "legend",
  "stackdriver",
  "circle pattern",
  "image editor",
  "lens blur",
  "Aa",
  "a/a",
  "ab/AB",
  "abcdefg",
  "alter case",
  "case sensitivity",
  "casing",
  "character case",
  "flips",
  "letter case",
  "modify case",
  "swaps",
  "text case",
  "archives",
  "bibliography",
  "bookstore",
  "publications",
  "audio collection",
  "audio files",
  "audio library",
  "music archive",
  "music collection",
  "music library",
  "music symbol",
  "authorized user",
  "bestow",
  "document legal",
  "document security",
  "entitlement",
  "grant",
  "license key",
  "official document",
  "permission granted",
  "ceiling",
  "pendent",
  "automation system",
  "lamps",
  "light group",
  "multiple lights",
  "smart lighting",
  "ambience",
  "daytime",
  "natural light",
  "radiance",
  "shining",
  "visible light",
  "filament",
  "glass bulb",
  "hint",
  "inspiration",
  "led",
  "screw base",
  "teardrop",
  "circle frame",
  "enlighten",
  "coordinate system",
  "gridline",
  "plotting",
  "quantitative data",
  "x axis",
  "y axis",
  "bezier",
  "curved line",
  "flowing line",
  "spline",
  "content divider",
  "end line",
  "endcap",
  "horizontal stroke",
  "line end",
  "line separator",
  "paragraph break",
  "paragraph separator",
  "text break",
  "text separator",
  "thick rule",
  "thin rule",
  "visual separator",
  "termination",
  "arrow end",
  "arrow on line",
  "notch",
  "path end",
  "line end circle",
  "vertex",
  "square block",
  "stop button",
  "ui symbol",
  "beginning line",
  "line start",
  "point of origin",
  "start of journey",
  "start point",
  "back arrow",
  "progress track",
  "waypoint",
  "beginning point",
  "start button",
  "different sizes",
  "paragraph rules",
  "varying thickness",
  "adjustment bar",
  "linear scale",
  "markers",
  "notches",
  "attached",
  "broken chain",
  "broken hyperlink",
  "broken link icon",
  "connection broken",
  "disable hyperlink",
  "disable link",
  "disconnect icon",
  "disconnect web link",
  "link broken",
  "link disabled",
  "link removed",
  "remove hyperlink",
  "remove link",
  "remove web link",
  "linked camera",
  "linked media",
  "multimedia connection",
  "photography equipment",
  "chain links",
  "digital markets act",
  "dma",
  "external services",
  "federation",
  "link building",
  "linked accounts",
  "linked data",
  "relationships icon",
  "services icon",
  "alcohol",
  "cheers",
  "cocktail",
  "liquor",
  "pub",
  "spirits",
  "stemware",
  "wine",
  "expandable menu",
  "itemize",
  "navigation menu",
  "organized list",
  "table of contents",
  "to-do list",
  "chat window",
  "live chat",
  "online help",
  "support center",
  "two bubbles",
  "antennas hardware",
  "live tv",
  "on demand",
  "ondemand video",
  "living being",
  "attendance",
  "coupon",
  "cutout",
  "entertainment pass",
  "event pass",
  "movie ticket",
  "perforation",
  "tear-off",
  "ticket stub",
  "voucher",
  "brick and mortar",
  "debit",
  "beer",
  "cocktails",
  "going out",
  "happy hour",
  "unwind",
  "refreshment",
  "auto service",
  "detailing",
  "--",
  "awning",
  "buying",
  "convenience store",
  "corner store",
  "selling",
  "small business",
  "dining experience",
  "dining out",
  "eating utensils",
  "restaurant finder",
  "cheers emoji",
  "cheersing",
  "glass of water",
  "soda glass",
  "toasting",
  "blaze",
  "fire department",
  "fire icon",
  "flame icon",
  "hot topics",
  "inferno",
  "top videos",
  "trending topics",
  "trending videos",
  "viral",
  "beautiful",
  "bloom",
  "blossom",
  "florist",
  "petal",
  "diesel",
  "dispenser",
  "filling up",
  "gas nozzle",
  "gas station",
  "gasoline",
  "oil",
  "petrol station",
  "road trip",
  "laundromat",
  "local services",
  "nearest",
  "book stack",
  "bookshelf",
  "bookshelf icon",
  "community learning",
  "educational resources",
  "information archive",
  "knowledge base",
  "local library",
  "stack of books",
  "acquisition",
  "department store",
  "handbag",
  "point of sale",
  "shopping bag",
  "vendor",
  "find parking",
  "letter p",
  "parking area",
  "parking lot",
  "parking spot",
  "drugstore",
  "rx",
  "cheese",
  "italian",
  "pepperoni",
  "pizza",
  "take out",
  "authority symbol",
  "crime",
  "identification badge",
  "law and order",
  "law enforcement",
  "local police",
  "officer",
  "police department",
  "police emblem",
  "police star",
  "building exterior",
  "post office",
  "camcorder",
  "driver",
  "lyft",
  "uber",
  "absent from location",
  "away",
  "exited",
  "gone",
  "not here",
  "district",
  "apartments",
  "metropolis",
  "geolocation",
  "not found",
  "disabled gps",
  "disabled location",
  "disabled map pin",
  "disabled marker",
  "disabled navigation",
  "disabled pin",
  "disabled pointer",
  "gps disabled",
  "map pin disabled",
  "map pin off",
  "marker disabled",
  "pin disabled",
  "pin off",
  "pointer disabled",
  "pointer off",
  "presence",
  "radius",
  "vicinity",
  "pulsating",
  "pulsing",
  "unfixed",
  "https",
  "secure connection",
  "website security",
  "access allowed",
  "access granted",
  "lock open",
  "open access",
  "open lock symbol",
  "open state",
  "privacy open",
  "security open",
  "security state",
  "unlocked symbol",
  "unprotected",
  "authenticate open",
  "lock and key",
  "secure open",
  "unlock lock",
  "open right",
  "unauthenticated",
  "unchained",
  "unlocked right",
  "🔓",
  "🔓 open",
  "🔓 open right",
  "🔓 unlocked",
  "humana",
  "sign on",
  "dev",
  "dev.to",
  "arrow pointing right",
  "door icon",
  "exit symbol",
  "log out",
  "open door",
  "signing off",
  "looking",
  "reading glasses",
  "seeing",
  "number 3",
  "priority",
  "block four",
  "digit four",
  "four square",
  "looks 4",
  "number four",
  "numeral four",
  "find icon",
  "find symbol",
  "inspection",
  "look through",
  "magnifying glass symbol",
  "search field",
  "search symbol",
  "endorse",
  "evaluate",
  "recommend",
  "major",
  "number one",
  "primary",
  "principal",
  "ranked",
  "opthalmology",
  "perceive",
  "probe",
  "distant",
  "fewer",
  "gaps",
  "low density",
  "sparse",
  "spread out",
  "decrease priority",
  "demote",
  "down direction",
  "down priority",
  "less important",
  "low priority",
  "lower priority",
  "minimum priority",
  "non-critical",
  "not urgent",
  "re-sort",
  "task priority",
  "unimportant",
  "text transformation",
  "title case",
  "benefit",
  "benefits",
  "customer",
  "perk",
  "points system",
  "increasing strength",
  "lte+",
  "essentials",
  "personal items",
  "travel essentials",
  "trunk",
  "vacation items",
  "eating place",
  "food court",
  "mess hall",
  "display lyrics",
  "lyrics",
  "show lyrics",
  "singing",
  "view lyrics",
  "vocal",
  "writing icon",
  "macro",
  "close up",
  "cross.",
  "macro off",
  "magnification",
  "micro",
  "lessen",
  "reduce size",
  "docked",
  "navigation element",
  "view mode",
  "message icon",
  "closed mail",
  "confidential mail",
  "email security",
  "locked mail",
  "protected message",
  "sealed",
  "secure communication",
  "security lock",
  "block icon",
  "blocked mail",
  "communication blocked",
  "communication turned off",
  "deactivated mail",
  "digital mail off",
  "disable icon",
  "disabled message",
  "email off",
  "envelope disabled",
  "envelope with line",
  "internet off",
  "letter off",
  "line through",
  "mail control",
  "mail management",
  "mail off",
  "message off",
  "no mail",
  "off icon",
  "online communication off",
  "private message off",
  "unable to send",
  "webmail off",
  "guy",
  "torso",
  "member profile",
  "personal details",
  "single user",
  "user data",
  "manage accounts",
  "people settings",
  "profile settings",
  "settings cog",
  "settings gear",
  "find and manage",
  "search and organize",
  "search filters",
  "fiction",
  "graphic novel",
  "japanese book",
  "japanese comic",
  "manga",
  "non-fiction",
  "sequential art",
  "clockwork",
  "refinery",
  "find location",
  "location search",
  "search map",
  "add data",
  "destination pin",
  "ugc",
  "user contribution",
  "block spacing",
  "design tool",
  "element spacing",
  "visual guide",
  "as",
  "chat icon",
  "checkmark icon",
  "complete icon",
  "conversation icon",
  "done check",
  "done icon",
  "email icon",
  "mark read",
  "mark read icon",
  "read message",
  "indicator dot",
  "mark as unread",
  "mark unread",
  "message unread",
  "unread count",
  "correspondence.",
  "mark as read",
  "opened",
  "reviewed",
  "alert dot",
  "unread dot",
  "unread indicator",
  "mark up",
  "copy paste",
  "functionality",
  "pasteboard",
  "incoming mail",
  "markunread",
  "postbox",
  "status.",
  "unopened",
  "masked",
  "transitions",
  "post-production",
  "ancient greece",
  "classical",
  "comedy and tragedy",
  "happy and sad",
  "respirator",
  "tragedy",
  "two masks",
  "aaa",
  "bbb",
  "case matching",
  "case sensitive search",
  "ccc",
  "exact match",
  "find and replace",
  "match case",
  "text search",
  "alphabet case",
  "grammar",
  "spell check",
  "flagged",
  "remember me",
  "carpentry",
  "crafting",
  "dimensioning",
  "diy",
  "imperial",
  "linear measurement",
  "measuring tape",
  "sewing",
  "tape",
  "tape measure",
  "pairing mode",
  "technology off",
  "unpaired",
  "audio input",
  "rhomboid",
  "corner arrow",
  "internet link",
  "open window",
  "outgoing link",
  "device output",
  "speaker icon",
  "tv icon",
  "audio mute",
  "audio output off",
  "casting off",
  "disable casting",
  "disable media output",
  "disable screen mirroring",
  "media off",
  "media output off",
  "output off",
  "screen mirroring off",
  "sound control",
  "sound output off",
  "speaker mute",
  "speaker off",
  "stop casting",
  "stop sharing",
  "video output off",
  "binding agreement",
  "compromise",
  "mediation",
  "health information",
  "health record",
  "medical chart",
  "medical file",
  "medical record",
  "patient data",
  "patient history",
  "patient record",
  "personal protective equipment",
  "ppe",
  "protective",
  "quarantine",
  "respiratory",
  "social distance",
  "surgical",
  "doctor's bag",
  "health services",
  "healthcare services",
  "medical facility",
  "medical kit",
  "drug icon",
  "healthcare item",
  "medical treatment",
  "medication icon",
  "medicine icon",
  "pharmacy icon",
  "pill",
  "pill icon",
  "treatment and cure",
  "treatment icon",
  "dropper bottle",
  "medical liquid",
  "medications",
  "medicine bottle",
  "vial with liquid",
  "conference room",
  "meeting room",
  "pins",
  "ram",
  "sd",
  "computer chip",
  "datacenter",
  "electronic component",
  "hardware component",
  "memory module",
  "cycle calendar",
  "cycle tracking",
  "female health",
  "gynecology icon",
  "health and wellness",
  "medical app",
  "menstrual health",
  "period app",
  "period cycle",
  "period tracking",
  "woman's health",
  "action menu",
  "application menu",
  "main menu",
  "side menu",
  "stacked bars",
  "literary",
  "bar menu",
  "menu open",
  "bring together",
  "confluence",
  "file operations",
  "two into one",
  "combine branches",
  "combine content",
  "combine documents",
  "join points",
  "link branches",
  "merge content",
  "merge documents",
  "merge type",
  "metabolism",
  "M",
  "rapid transit",
  "digital lock",
  "electronic lock",
  "mfg",
  "passcode",
  "security device",
  "yale",
  "mics",
  "studio",
  "connected mic",
  "external mic",
  "sound input",
  "eyepiece",
  "microbes",
  "specimen",
  "easy",
  "microwave",
  "reheat",
  "appliance.",
  "accomplishment",
  "air force",
  "army",
  "insignia",
  "marines",
  "merit",
  "privilege",
  "soldier",
  "veteran",
  "warfare",
  "hangouts",
  "mimo",
  "breathing",
  "lotus position",
  "mindfulness",
  "posture",
  "seated",
  "spirit",
  "tranquility",
  "yoga",
  "zen",
  "banking icon",
  "economic indicator",
  "financial planning",
  "financial services",
  "fiscal",
  "investment icon",
  "mint",
  "mintmark",
  "riches",
  "treasure",
  "declined",
  "ended",
  "teleconference",
  "connection error",
  "gaming hardware",
  "joysticks",
  "pairing issue",
  "atmospheric obstruction",
  "hazy conditions",
  "misty",
  "cropping",
  "cyber attacks",
  "diagonal cut",
  "schema",
  "slicing",
  "alchemy",
  "bandaid",
  "boil",
  "booster",
  "compound",
  "immunization",
  "mixture",
  "shot",
  "syringe",
  "image message",
  "mms",
  "multimedia message",
  "photo message",
  "picture message",
  "using",
  "no touch",
  "not permitted",
  "seamless",
  "checking",
  "mobile application",
  "mobile screen share",
  "mobile share",
  "screensaver",
  "wallpaper",
  "louder",
  "announce",
  "communication device",
  "cellular connection off",
  "cellular data off",
  "cellular network off",
  "connection lost",
  "connectivity off",
  "data disabled",
  "data disconnected",
  "mobile data off",
  "mobile network off",
  "network disconnected",
  "phone signal off",
  "comment bubble",
  "communication mode",
  "conversation mode",
  "mode comment",
  "rounded corner",
  "chill",
  "cooling mode off",
  "freeze",
  "application layout",
  "double screen",
  "dual mode",
  "mode switch",
  "screen mode",
  "two panel",
  "vertical split",
  "electric fan",
  "exhaust",
  "rotating blades",
  "ventilation system",
  "nonoperational",
  "combustion",
  "heating system",
  "climate symbol",
  "cool setting",
  "cooling symbol",
  "heat setting",
  "heating and cooling",
  "heating symbol",
  "hvac mode",
  "radiator",
  "temperature mode",
  "temperature symbol",
  "weather symbol",
  "disabled mode",
  "heating off",
  "regulate temperature",
  "system off",
  "driving icon",
  "four wheels",
  "of",
  "activation",
  "binary switch",
  "boolean",
  "functional state",
  "mode selection",
  "on off",
  "setting toggle",
  "state change",
  "put to sleep",
  "standby mode",
  "suspend activity",
  "computation",
  "data modeling",
  "data science",
  "deep learning",
  "ml",
  "neural network",
  "cad",
  "computer aided design",
  "digital modeling",
  "modeling",
  "100",
  "dollar bag",
  "lend",
  "loans",
  "money bag",
  "money sack",
  "sack of money",
  "cheap",
  "discount",
  "expense",
  "no cash",
  "no money",
  "paid",
  "baseline",
  "ecc",
  "health tech",
  "remote monitoring",
  "teleheath",
  "grams",
  "kg",
  "kilogram",
  "lbs",
  "pounds",
  "body weight",
  "lose weight",
  "monitor weight",
  "weight loss",
  "multiple photos",
  "dissatisfaction",
  "sad",
  "unhappiness",
  "unpleased",
  "unsmile",
  "unsmiling",
  "cleaning equipment",
  "house cleaning",
  "janitor",
  "mess",
  "sweeper",
  "threads",
  "courier",
  "delivery service",
  "motorcycle",
  "contextual menu",
  "etc",
  "further",
  "item menu",
  "secondary menu",
  "context",
  "omni",
  "horiz",
  "more information",
  "three dots horizontal",
  "add time",
  "extend time",
  "extra time",
  "increase time",
  "more time",
  "time symbol",
  "configuration menu",
  "dot menu",
  "extra options",
  "supplemental options",
  "three vertical dots",
  "vertical ellipsis",
  "detail menu",
  "dropdown menu",
  "hidden options",
  "list menu",
  "more actions",
  "pop-up menu",
  "tertiary actions",
  "vert",
  "holy place",
  "islam",
  "islamic",
  "islamic architecture",
  "islamic art",
  "islamic culture",
  "islamic history",
  "masjid",
  "middle east",
  "minaret",
  "muslim",
  "pilgrimage",
  "ramadan",
  "religious building",
  "ghosting",
  "motion blur",
  "motionblur",
  "streaking",
  "trailing",
  "filmstrip",
  "animated photo",
  "burst photo",
  "capture mode",
  "enhanced photo",
  "live photo",
  "motion capture",
  "motion photo",
  "motion photos",
  "smart photo",
  "circle with line",
  "disable motion photo",
  "line through circle",
  "live picture",
  "motion photos off",
  "motion picture",
  "no motion",
  "no motion photos",
  "no photos",
  "motion photos on",
  "freeze frame",
  "triangle right",
  "detection icon",
  "intrusion",
  "motion ",
  "motion icon",
  "sensor icon",
  "idle",
  "inactivity",
  "passive",
  "biking",
  "commuting",
  "motorbike",
  "racing",
  "mountain top",
  "self help",
  "summit",
  "pointing device",
  "touchscreen",
  "trackpad",
  "capture pointer",
  "confine pointer",
  "limit cursor",
  "lock cursor",
  "movement restriction",
  "pointer control",
  "prevent movement",
  "restrict cursor",
  "directional arrows",
  "transpose",
  "navigate down",
  "change group",
  "edit group",
  "group management",
  "modify group",
  "move selection",
  "multiple selection",
  "tabs",
  "change location",
  "drag and drop",
  "move destination",
  "move location",
  "move pin",
  "set location",
  "update location",
  "change order",
  "element move",
  "item move",
  "list reorder",
  "row move",
  "selection move",
  "adjust left",
  "selection mover",
  "shift left",
  "change position",
  "choose right",
  "horizontal move",
  "horizontal right",
  "section right",
  "select right",
  "elevate item",
  "increase order",
  "indicate up",
  "list order",
  "move selected item",
  "priority up",
  "promote",
  "reorder list",
  "shift up",
  "sort order",
  "move to",
  "dropped pin",
  "move marker",
  "move point",
  "moved",
  "moved pin",
  "relocated location",
  "relocated marker",
  "relocated pin",
  "reposition location",
  "reposition marker",
  "reposition pin",
  "updated location",
  "movie file",
  "play movie",
  "play video",
  "slate",
  "videotape",
  "filmmaking",
  "production house",
  "sprocket",
  "details button",
  "facts",
  "film reel",
  "film strip",
  "info button",
  "information button",
  "movie reel",
  "movie strip",
  "synopsis",
  "clapperboard",
  "disabled media",
  "movie muted",
  "movie off",
  "no movie",
  "no video",
  "slasher",
  "video muted",
  "video recorder",
  "visual media disabled",
  "advancing",
  "alive",
  "animate",
  "based *solely* on the title [moving]",
  "evolving",
  "going",
  "moving object",
  "onward",
  "moving",
  "proceeding",
  "bed transfer",
  "critical care",
  "healthcare facility",
  "hospital room",
  "hospital ward",
  "icu",
  "intensive care",
  "medical bed",
  "patient room",
  "patient transfer",
  "figure moving",
  "jog",
  "person on the move",
  "silhouette walking",
  "stride",
  "stroll",
  "cooking equipment",
  "digital cooker",
  "domestic appliance",
  "electric cooker",
  "electric pot",
  "kitchen gadget",
  "meal preparation",
  "multicooker",
  "pressure cooker",
  "programmable cooker",
  "rice cooker",
  "slow cooker",
  "smart cooker",
  "graph paper",
  "multiline chart",
  "human-computer interaction",
  "multimodal",
  "senses",
  "airports",
  "airways",
  "runway",
  "double stop",
  "multiple stop",
  "player control",
  "skip to end",
  "artifact",
  "attraction",
  "corinthian",
  "doric",
  "exhibit",
  "exhibition",
  "historic",
  "ionic",
  "neoclassical",
  "music cast",
  "music casting",
  "audiotrack",
  "mp3",
  "sing",
  "quaver",
  "stave",
  "blocked music",
  "disabled music",
  "forbid",
  "forbidden music",
  "music control",
  "music disabled",
  "music off",
  "mute audio",
  "mute music",
  "mute volume",
  "no audio",
  "no music",
  "slashed music",
  "volume off",
  "clapper",
  "film slate",
  "movie player",
  "music video",
  "current location",
  "find me",
  "geographic position",
  "my location",
  "calculations",
  "magnify glass",
  "thrillers",
  "geopolitical",
  "nat",
  "flourish",
  "vegetation",
  "exploring",
  "geotagging",
  "locate me",
  "locate user",
  "near",
  "precise location",
  "compass disabled",
  "direction blocked",
  "direction disabled",
  "direction off",
  "geo blocked",
  "geo disabled",
  "gps blocked",
  "location blocked",
  "map blocked",
  "near me blocked",
  "near me disabled",
  "near me off",
  "position blocked",
  "position disabled",
  "position off",
  "businesses",
  "diamonds",
  "explore nearby",
  "find nearby",
  "search nearby",
  "connected off",
  "nearby off",
  "proximity off",
  "range off",
  "scanner off",
  "searching off",
  "human organ",
  "internal organ",
  "kidney",
  "kidney disease",
  "kidneys",
  "nephrology",
  "renal",
  "transplant",
  "urology",
  "smart speaker",
  "floodlight",
  "nest cam",
  "night vision",
  "wall mount",
  "weatherproof",
  "wide angle",
  "connected home",
  "iq",
  "mount",
  "protext",
  "mobile app",
  "remote access",
  "wireless camera",
  "camera lens",
  "smart camera",
  "magnet",
  "magnetic mount",
  "camera on stand",
  "desk camera",
  "mounting",
  "wall ",
  "wifi camera",
  "desk clock",
  "mechanical clock",
  "pointer object",
  "round object",
  "time display",
  "wall clock",
  "nest hub",
  "smart display",
  "home display",
  "porch",
  "ring doorbell",
  "someone's here",
  "greenhouse",
  "renewable energy",
  "temperature unit",
  "coin bag",
  "found",
  "nest found savings",
  "nest savings",
  "pouch",
  "sack",
  "gen",
  "generation 3",
  "heat link",
  "smart doorbell",
  "google home",
  "google nest",
  "nest mini",
  "smart audio",
  "speaker system",
  "voice command",
  "audio system",
  "multiple rooms",
  "multiroom",
  "rooms",
  "speakers",
  "nest protect",
  "residential safety",
  "smarthouse",
  "av remote",
  "channel changer",
  "clicker",
  "google tv remote",
  "media remote",
  "nest remote",
  "six dots",
  "smart remote",
  "streaming remote",
  "television remote",
  "tv remote",
  "armed",
  "block sun",
  "environmental sensor",
  "hot weather",
  "solar radiation",
  "sun protection",
  "uv",
  "uv protection",
  "geofence",
  "locator",
  "70",
  "frostat",
  "appliance control",
  "cooling system",
  "eu",
  "wall mounted",
  "hvac control",
  "nest thermostat",
  "smart living",
  "energy.",
  "smart thermostat",
  "true radiant",
  "approach",
  "motion detection",
  "wake",
  "wake on approach",
  "concentric shapes",
  "nested shapes",
  "wake on press",
  "nest wifi point",
  "range extender",
  "repeater",
  "vento",
  "mesh",
  "network settings",
  "pro",
  "internet access point",
  "mistral",
  "full signal",
  "increasing signal",
  "stepped",
  "tiered",
  "connection check",
  "internet check",
  "network test",
  "signal check",
  "valid connection",
  "wireless connection",
  "clever",
  "intel",
  "network analysis",
  "network intelligence",
  "system diagram",
  "data processing",
  "information processing",
  "intelligence analysis",
  "network activity",
  "network traffic",
  "synchronise",
  "data locked",
  "network problem",
  "wi-fi",
  "wifi locked",
  "ethernet",
  "gear symbol",
  "conceptual",
  "latency",
  "network connectivity",
  "arcs",
  "hotspot",
  "private wifi",
  "public wifi",
  "connectivity status",
  "less strength",
  "low signal strength",
  "low strength",
  "signal indicator",
  "single bar",
  "wifi network",
  "wifi symbol",
  "hot spot",
  "limited signal",
  "partial signal",
  "wlan",
  "locked network",
  "secured connection",
  "secured wifi",
  "wpa",
  "brain function",
  "nerve",
  "nervous system",
  "neurology",
  "offer",
  "topic",
  "browser window",
  "direct link",
  "new browser",
  "open externally",
  "pop out",
  "current events",
  "newspaper icon",
  "journalism",
  "magazines",
  "media.",
  "newspapers",
  "newsstand",
  "periodicals",
  "publications stand",
  "shelves",
  "homeless",
  "overnight",
  "refuge",
  "auto off",
  "automatic off",
  "night mode disabled",
  "night mode off",
  "nighttime",
  "rising",
  "adult entertainment",
  "dancing",
  "disco",
  "night out",
  "dusk",
  "nightlight",
  "honeymoon",
  "night time",
  "nights",
  "nights_stay",
  "romantic",
  "banned",
  "deleted",
  "no accounts",
  "unidentifiable",
  "content restriction",
  "inappropriate content",
  "not suitable for minors",
  "eight sides",
  "no crash",
  "octagon",
  "red light",
  "stop sign",
  "alcoholic beverages",
  "beverages",
  "drinks",
  "no drinks",
  "non-alcoholic beverages",
  "data breach",
  "data security",
  "no encryption",
  "security breach",
  "unauthorized access",
  "no light",
  "eating restriction",
  "food restricted",
  "forbidden symbol",
  "no food",
  "unavailable food",
  "bags",
  "no bags",
  "no luggage",
  "no eating",
  "no meals",
  "sustenance",
  "unavailable meeting room",
  "unavailable room",
  "do not record",
  "filming prohibited",
  "no camera",
  "no photo",
  "no photography",
  "photography forbidden",
  "red circle",
  "no service",
  "no sim",
  "not inserted",
  "sim card",
  "Volume",
  "disable volume",
  "volume down",
  "baby carriage",
  "infant transport",
  "no children",
  "no stroller",
  "perambulator",
  "pram",
  "public area",
  "blocked access",
  "forbidden access",
  "forbidden sign",
  "no transfer",
  "prohibition sign",
  "restriction sign",
  "transfer blocked",
  "sonic",
  "audio processing off",
  "cancel off",
  "environmental sound off",
  "listening off",
  "noise cancellation off",
  "noise reduction off",
  "reduce noise off",
  "sound control off",
  "noise cancellation",
  "noise reduction",
  "prevent",
  "toggle sound",
  "turn off sound",
  "volume icon",
  "nordic",
  "nordic walking",
  "poles",
  "sticks",
  "two poles",
  "walking stick",
  "geomagnetic",
  "geospatial",
  "guidepost",
  "magnetic north",
  "orientation marker",
  "true north",
  "upwards",
  "link arrow",
  "north east",
  "noth",
  "visit",
  "not accessible",
  "listed",
  "not listed",
  "unknown location",
  "not started",
  "started",
  "add note",
  "document add",
  "form add",
  "new note",
  "plus document",
  "plus note",
  "status update",
  "timely",
  "urgent message",
  "alarms",
  "bell icon",
  "several",
  "config",
  "ringtone",
  "alert sound",
  "ding",
  "tones",
  "engaged",
  "ringing bell",
  "alert off",
  "chime off",
  "disarm",
  "no notifications",
  "ignore",
  "remind later",
  "ring --- pause",
  "z",
  "radio button",
  "groceries",
  "orange",
  "supplements",
  "vitamins",
  "drag handle",
  "list style",
  "ods",
  "electronic document",
  "libreoffice",
  "ode file",
  "odt",
  "odt format",
  "open document text",
  "openoffice",
  "word document",
  "internet down",
  "offline access",
  "offline map",
  "offline mode",
  "placed",
  "saved pin",
  "no pin",
  "not pinned",
  "offline pin",
  "offline pin off",
  "unpinned",
  "device to device",
  "l shape",
  "offline share",
  "barrel",
  "crude oil",
  "cylindrical",
  "drum",
  "fossil fuels",
  "oil barrel",
  "oil drum",
  "petroleum",
  "tank",
  "cancer",
  "chemotherapy",
  "oncology",
  "surgery",
  "online prediction",
  "mineral",
  "layer opacity",
  "transparency level",
  "external window",
  "hypertext",
  "online content",
  "open in browser",
  "open url",
  "view online",
  "open in new",
  "outbound link",
  "up-right arrow",
  "blocked link",
  "broken arrow",
  "outward arrow",
  "restricted link",
  "unavailable link",
  "jam",
  "arrows pointing out",
  "cornea",
  "eyeball outline",
  "retina",
  "ailment",
  "gums",
  "inflammation",
  "pain",
  "tongue",
  "astronomical",
  "circular path",
  "dv360",
  "electron",
  "elliptical",
  "gravity",
  "outer space",
  "revolution",
  "trajectory",
  "line items",
  "triangle pointing right",
  "packaged",
  "bone health",
  "ribcage",
  "skull",
  "pend",
  "secondary",
  "abodes",
  "collection of homes",
  "group of houses",
  "habitations",
  "homes",
  "housing development",
  "multiple houses",
  "residences",
  "residential area",
  "leaving",
  "outbox",
  "tray",
  "plantlife",
  "bbq",
  "charcoal",
  "cooking appliance",
  "cookout",
  "grilling",
  "grilling equipment",
  "outdoor grill",
  "propane",
  "smoking",
  "vegetables",
  "charging point",
  "connecter",
  "electrical outlet",
  "electricity symbol",
  "energy supply",
  "plug in",
  "power connection",
  "wall socket",
  "expand control",
  "maximize button",
  "screen control",
  "conclusive",
  "definite",
  "end point",
  "ultimate",
  "bake food",
  "broil",
  "cooker",
  "electric oven",
  "gas oven",
  "heet",
  "roast",
  "convection oven",
  "smart oven",
  "big picture",
  "brief",
  "glance",
  "high-level",
  "overall",
  "principle",
  "owl",
  "wise",
  "nostril",
  "pulse wave",
  "spo2",
  "vital data",
  "chaining",
  "connection lines",
  "decentralized",
  "distributed network",
  "linked nodes",
  "p2p",
  "peer",
  "peer network",
  "peer to peer",
  "peer-to-peer",
  "sharing data",
  "buffering circle",
  "circular loading",
  "circular progress",
  "progress circle",
  "spinning circle",
  "spinning wheel",
  "cardiac",
  "jagged line",
  "medical equipment",
  "pacemaker",
  "open box",
  "unpack",
  "warehousing",
  "unboxing",
  "inset",
  "current page",
  "steppers",
  "total pages",
  "file manager",
  "gplus",
  "squared",
  "add page",
  "create file",
  "page icon",
  "art palette",
  "color selection",
  "paint palette",
  "thumb hole",
  "handling",
  "pallet",
  "glove",
  "digital hand",
  "grab hand",
  "grasp",
  "interface hand",
  "move hand",
  "tool icon",
  "zooms",
  "elongated",
  "stretched",
  "wide shot",
  "degrees",
  "expansive",
  "photosphere",
  "spherical",
  "field of view",
  "panorama vertical",
  "stitch",
  "capture setting",
  "panoramic view",
  "photo view",
  "photography mode",
  "viewpoint",
  "wide field",
  "wide lens",
  "extreme",
  "gliding",
  "parachute",
  "paragliding",
  "sail",
  "skydiving",
  "thrilling",
  "green space",
  "cloud and sun",
  "day sky",
  "half cloud",
  "half sun",
  "partly obscured",
  "sky condition",
  "sun behind cloud",
  "weather app",
  "dreams",
  "partly",
  "connect partners",
  "link partners",
  "partner",
  "partner link",
  "side to side",
  "affiliates",
  "partner analysis",
  "partners",
  "performance reporting",
  "celebration mode",
  "energetic",
  "enjoy",
  "festive mode",
  "fun picture",
  "party night",
  "party picture",
  "party setting",
  "social event",
  "special event",
  "vibrant",
  "security key",
  "access code",
  "key symbol",
  "password protection",
  "authorization key",
  "secure key",
  "vault",
  "crossed out eye",
  "show off",
  "view off",
  "visibility off",
  "attendees",
  "lined",
  "roster",
  "bricks",
  "interlude",
  "presentation software",
  "two vertical lines",
  "pedaling",
  "children's health",
  "healthcare professional",
  "pediatrics",
  "pulse line",
  "stethoscope",
  "nib",
  "drawing tools",
  "line options",
  "line size",
  "stroke size",
  "stroke weight",
  "thickness options",
  "variable line",
  "note taking",
  "choose size",
  "select size",
  "incomplete task",
  "pending actions",
  "pending tasks",
  "task queue",
  "five sides",
  "five-sided",
  "pentagon",
  "arbor",
  "canopy",
  "outdoor living",
  "outdoor structure",
  "pergola",
  "min",
  "perm",
  "appointment scheduling",
  "date and time",
  "database settings",
  "hard drive settings",
  "permanent data",
  "persistent data",
  "persistent settings",
  "storage settings",
  "about device",
  "about phone",
  "device details",
  "device info",
  "handset information",
  "mobile device information",
  "mobile information",
  "mobile specs",
  "phone details",
  "digital library",
  "layers of files",
  "paper documents",
  "perm media",
  "sheets of paper",
  "stacked documents",
  "chat support",
  "msg",
  "permanent",
  "group chat",
  "user accounts",
  "person silhouette",
  "user silhouette",
  "user symbol",
  "add contact",
  "add friend",
  "friend",
  "apron",
  "bib",
  "memoir",
  "scholar",
  "unfollow",
  "ecstatic",
  "excited",
  "hands up",
  "juggle",
  "raising arms",
  "account check",
  "approved user",
  "check person",
  "human check",
  "identity check",
  "profile check",
  "user check",
  "verified person",
  "profile edit",
  "drop pin",
  "account action",
  "profile action",
  "raised hand",
  "request",
  "exclude person",
  "exclude user",
  "unfriend",
  "address book search",
  "contact search",
  "directory search",
  "find contact",
  "find friend",
  "find person",
  "find profile",
  "find user",
  "friend search",
  "human search",
  "locate person",
  "locate profile",
  "person search",
  "profile lookup",
  "profile search",
  "search contact",
  "search friend",
  "search profile",
  "user lookup",
  "person symbol",
  "personal safety",
  "private account",
  "secured account",
  "shield icon",
  "user security",
  "tote",
  "bag with slash",
  "no personal bags",
  "not included",
  "personal bag",
  "bag question",
  "mystery",
  "uncertainty",
  "accident claim",
  "broke",
  "broken bone",
  "broken leg",
  "crutches",
  "fractured leg",
  "lower limb",
  "personal injury",
  "shin",
  "sling",
  "trauma",
  "neighbourhood",
  "saved locations",
  "exterminate",
  "exterminator",
  "insects",
  "kill",
  "mosquito",
  "pest",
  "pest control",
  "poison",
  "repellent",
  "animal control",
  "extermination",
  "infestation",
  "mammal",
  "mice",
  "rat",
  "rodent",
  "rodent control",
  "trapping",
  "vermin",
  "wildlife control",
  "accessories",
  "animal care",
  "animal store",
  "animals",
  "cat",
  "cat food",
  "chew toy",
  "collar",
  "dog",
  "dog food",
  "grooming",
  "leash",
  "paw",
  "pet",
  "pet food",
  "pet store",
  "pet supplies",
  "animal lover",
  "bear",
  "domestic animals",
  "groomer",
  "pet care",
  "pet friendly",
  "pets",
  "veterinary",
  "criminal",
  "cybercrime",
  "fishing",
  "fraud",
  "malicious",
  "online safety",
  "phishing",
  "scam",
  "suspicious",
  "android phone",
  "android phone icon",
  "button icon",
  "cellular icon",
  "circle icon",
  "device icon",
  "digital icon",
  "display icon",
  "dot icon",
  "electronics icon",
  "gadget icon",
  "handheld icon",
  "mobile phone",
  "mobile phone icon",
  "portable icon",
  "rectangle icon",
  "rounded rectangle icon",
  "screen icon",
  "audio connection",
  "bluetooth device",
  "bluetooth icon",
  "pairing device",
  "speakerphone",
  "wireless speaker",
  "callback",
  "no call",
  "not reachable",
  "unreachable",
  "pickup",
  "forwarded",
  "active call",
  "call in progress",
  "calling",
  "line active",
  "ongoing call",
  "talk line",
  "telephone call",
  "voice communication",
  "secure device",
  "missed communication",
  "outbound call",
  "telephone communication",
  "tilted",
  "unanswered call",
  "voice call",
  "interrupted",
  "on hold",
  "break link",
  "disable mobile",
  "disable phone",
  "mobile connection",
  "mobile off",
  "phone management",
  "phone off",
  "call mute",
  "call silence",
  "no mobile signal",
  "no ring",
  "no wifi",
  "notification mute",
  "notification silence",
  "ringer off",
  "wifi off",
  "app settings",
  "app_settings_alt",
  "mobile gear",
  "mobile_gear",
  "phone settings",
  "phonelink_setup",
  "photo library",
  "picture library",
  "digital album",
  "memories album",
  "snapshots",
  "stacked rectangles",
  "stacked squares",
  "visual archive",
  "visual content",
  "visual library",
  "best take",
  "multimedia input",
  "artwork",
  "keepsake",
  "wall art",
  "compilation",
  "data.",
  "photo prints",
  "thumbnails",
  "hypertext preprocessor",
  "hypertext.",
  "php",
  "server-side",
  "web language",
  "web programming",
  "expert",
  "black keys",
  "classical music",
  "piano",
  "white keys",
  "music app",
  "musical instrument",
  "not playing",
  "adobe",
  "adobe acrobat",
  "document preview",
  "document representation",
  "document symbol",
  "document viewer",
  "electronic file",
  "electronic file icon",
  "file symbol",
  "pdf",
  "pdf file",
  "pdf icon",
  "pdf symbol",
  "portable document format",
  "show document",
  "show file",
  "view document",
  "cropped",
  "display within display",
  "displays",
  "embedded video",
  "miniature",
  "secondary display",
  "sizes",
  "small screen",
  "talktrack",
  "video box",
  "video viewing",
  "video window",
  "viewing mode",
  "embedded",
  "smaller window",
  "sub window",
  "picture within picture",
  "pop up",
  "compact view",
  "mini player",
  "smaller rectangle",
  "picture in picture off",
  "pip off",
  "minimized",
  "remedy",
  "illicit",
  "favorite location",
  "address pin",
  "marker pin",
  "pin end",
  "pin mark",
  "invoke",
  "select location",
  "corkboard",
  "pinboard",
  "sticky",
  "thumbtacks",
  "thumbtack",
  "nip",
  "pinch",
  "squeeze",
  "tweak",
  "two fingers",
  "gesture control",
  "decrease size",
  "magnify out",
  "reduce view",
  "close window",
  "corner icon",
  "cross mark",
  "minimize window",
  "picture in picture exit",
  "key performance indicators",
  "pivot table",
  "summarize",
  "put",
  "checker",
  "infringement",
  "piracy",
  "plagiarism",
  "theft",
  "violation",
  "globe icon",
  "orbital lines",
  "universe",
  "world icon",
  "pt",
  "planner review",
  "episode",
  "cannot play",
  "not playable",
  "ebook",
  "play lesson",
  "point right",
  "double bar",
  "blackjack",
  "card deck",
  "card game",
  "cards icon",
  "casino icon",
  "game icon",
  "game pieces",
  "leisure icon",
  "magician",
  "spade",
  "suit",
  "trick",
  "add to playlist",
  "audio list",
  "create list",
  "media list",
  "music list",
  "new playlist",
  "playlist add",
  "song list",
  "appended",
  "included",
  "integrated",
  "play media",
  "queue playback",
  "track list",
  "unselect",
  "coupling",
  "drainage",
  "fitting",
  "pipes",
  "schematic",
  "listen now",
  "podcasts",
  "ceremony",
  "championship",
  "presenter",
  "pulpit",
  "second place",
  "standings",
  "third place",
  "victor",
  "cash register",
  "merchant",
  "payment terminal",
  "point of purchase",
  "pos",
  "retail point of sale",
  "till",
  "till machine",
  "till register",
  "bet",
  "gambling chip",
  "poker chip",
  "wager",
  "directive",
  "governance",
  "ordinance",
  "standards",
  "statute",
  "tenet",
  "polyline",
  "atoms",
  "inorganic",
  "molecules",
  "nodes and links",
  "polymer",
  "dip",
  "plunge",
  "swim",
  "swimming pool",
  "connection disabled",
  "data off",
  "hotspot off",
  "mobile hotspot off",
  "network disabled",
  "no network",
  "portable hotspot off",
  "portable wifi off",
  "signal disabled",
  "tethering disabled",
  "tethering off",
  "wifi disabled",
  "bottom-left",
  "sector",
  "fixation",
  "add post",
  "adding content",
  "compose new",
  "create post",
  "new post",
  "post add",
  "publish new",
  "flower pot",
  "horticulture",
  "houseplant",
  "indoor plant",
  "plant care",
  "potted",
  "potted plant",
  "reboot",
  "shutdown",
  "amperage",
  "power input",
  "power outlet",
  "wall plug",
  "watts",
  "end session",
  "power button",
  "off switch",
  "on switch",
  "power options",
  "power settings",
  "arab",
  "islamic landmark",
  "islamic monument",
  "place of worship",
  "sacred place",
  "salah",
  "spiritual building",
  "assembly line",
  "crane",
  "fine",
  "high tech",
  "industrial building",
  "intricate",
  "precision work",
  "robotic",
  "sophisticated",
  "birth",
  "dad",
  "expecting",
  "paternity",
  "pregnant",
  "pregnant woman",
  "ellipses",
  "capsules",
  "consult",
  "health history",
  "health management",
  "healthcare management",
  "medical history",
  "medical management",
  "pill bottle",
  "prescription bottle",
  "demonstrate",
  "present content",
  "present display",
  "present screen",
  "present to all",
  "seminar",
  "share display",
  "show content",
  "show display",
  "show screen",
  "webinar",
  "examine closely",
  "see more",
  "block view",
  "cannot see",
  "disabled preview",
  "no preview",
  "no view",
  "not visible",
  "preview off",
  "restrict preview",
  "restrict view",
  "show disabled",
  "sight disabled",
  "slashed eye",
  "stop view",
  "view disabled",
  "price change",
  "barcode scanner",
  "check price",
  "compare price",
  "price check",
  "scan price",
  "search price",
  "printing press",
  "printshop",
  "linkage",
  "network device",
  "network printer",
  "print device",
  "wireless device",
  "action denied",
  "cannot print",
  "no action",
  "no print",
  "not printable",
  "print disabled",
  "print icon",
  "printer disabled",
  "printer icon",
  "printing forbidden",
  "printing restricted",
  "restricted action",
  "unavailable action",
  "authorized printing",
  "confidential printing",
  "print job",
  "print security",
  "private printing",
  "secure printing",
  "high priority",
  "significant",
  "urgency",
  "account security",
  "cyber security",
  "secure lock",
  "sensitive information",
  "data lock",
  "network lock",
  "private network",
  "difficulty",
  "slants",
  "maximum production",
  "maximum quantity",
  "maximum stock",
  "out of stock",
  "production restriction",
  "quantity limits",
  "quantity restriction",
  "restricted production",
  "restricted quantity",
  "restricted stock",
  "stock restriction",
  "stockout",
  "unavailable production",
  "unavailable quantity",
  "unavailable stock",
  "performing",
  "artificial",
  "brainstorming",
  "bright idea",
  "reserve",
  "human head",
  "knowledge sharing",
  "mental health",
  "psychiatry",
  "thinking cap",
  "intellectual",
  "philosophy",
  "psychiatric",
  "expertise",
  "everybody",
  "continents",
  "disseminate",
  "send to cloud",
  "upload to cloud",
  "finalize",
  "published",
  "alveoli",
  "bronchi",
  "lung",
  "lungs",
  "pulmonology",
  "respiratory care",
  "respiratory system",
  "trachea",
  "windpipe",
  "heart issue",
  "loss of pulse",
  "attendance tracking",
  "clock in",
  "clock out",
  "employee tracking",
  "labor tracking",
  "punch",
  "punch clock",
  "punch in",
  "punch out",
  "punching",
  "record time",
  "time clock",
  "time record",
  "time sheet",
  "timesheet",
  "work hours",
  "work log",
  "2d barcode",
  "data matrix",
  "decode",
  "digital code",
  "qr",
  "quick response code",
  "scannable",
  "urls",
  "matrix code",
  "square code",
  "optical code",
  "q&a",
  "curious",
  "inquire",
  "interrogation",
  "queue list",
  "enqueue",
  "queued",
  "bubble icon",
  "canned responses",
  "chat bubbles",
  "comic bubbles",
  "common phrases",
  "communication bubbles",
  "instant messaging",
  "message bubbles",
  "phrases",
  "predefined text",
  "preset messages",
  "prewritten text",
  "quick responses",
  "ready messages",
  "saved messages",
  "speech bubbles",
  "speech icon",
  "talk bubbles",
  "templates",
  "text bubbles",
  "thought bubbles",
  "action items",
  "key points",
  "quick reference",
  "sitemap",
  "topics",
  "move items",
  "organize list",
  "rearrange items",
  "sort list",
  "up and down",
  "vertical arrows",
  "engaging",
  "fast reply",
  "instant reply",
  "quick reply",
  "quickreply",
  "reply icon",
  "short reply",
  "brain teaser",
  "quiz",
  "r",
  "wifi bars",
  "sonar",
  "analogue",
  "active choice",
  "checked radio button",
  "form field",
  "input control",
  "option picker",
  "selected option",
  "filled dot",
  "form element",
  "blank radio button",
  "empty radio button",
  "outlined circle",
  "radiologists",
  "drizzle",
  "drops",
  "falling water",
  "rainfall",
  "showers",
  "water drops",
  "weather condition",
  "weather icons",
  "weather status",
  "cloud and rain",
  "downpour",
  "pouring",
  "thunderstorm",
  "light rain",
  "rain symbol",
  "weather widget",
  "freezing",
  "snowing",
  "asian food",
  "bowl",
  "chinese food",
  "chopsticks",
  "chopsticks in bowl",
  "eating out",
  "hot meal",
  "japanese food",
  "korean food",
  "noodle dish",
  "noodle soup",
  "noodles",
  "ramen",
  "ramen bowl",
  "soup",
  "steaming food",
  "above stove",
  "air purification",
  "exhaust hood",
  "fume extractor",
  "hood",
  "kitchen vent",
  "over stove",
  "range hood",
  "restaurants",
  "ventilation icon",
  "opinion",
  "animal icon",
  "avian",
  "bird icon",
  "blackbird",
  "corvid",
  "corvid icon",
  "crow",
  "mascot icon",
  "nature icon",
  "raven",
  "wildlife icon",
  "image file",
  "photo format",
  "raw image",
  "unprocessed",
  "operational",
  "additional info",
  "augment",
  "extra info",
  "azm",
  "hrv",
  "slow",
  "velocity",
  "broker",
  "counsel",
  "for sale",
  "realtor",
  "backside",
  "reversal",
  "rebase",
  "invoice",
  "itemized",
  "bill icon",
  "expense icon",
  "financial icon",
  "long receipt",
  "long receipt icon",
  "payment icon",
  "receipt icon",
  "transaction icon",
  "actors",
  "director",
  "recent actors",
  "realign",
  "recenter",
  "reset location",
  "reset view",
  "affirm",
  "thumbs",
  "thumbs up",
  "upvote",
  "well",
  "audio message",
  "live audio",
  "public speaking",
  "speaking aloud",
  "voice memo",
  "enclosed space",
  "four sides",
  "fundamental form",
  "fundamental shape",
  "geometric shape",
  "outline shape",
  "parallelograms",
  "polygons",
  "quadrilaterals",
  "recangle",
  "solid line",
  "arrows in a loop",
  "recyclable",
  "remake",
  "remanufacture",
  "renewal",
  "three arrows",
  "gift card",
  "giftcard",
  "redeem",
  "special offer",
  "go again",
  "reverse undo",
  "turnaround",
  "capacity reduction",
  "de-emphasize",
  "decrease capacity",
  "fewer items",
  "less space",
  "lessen amount",
  "lessen quantity",
  "reduce count",
  "reduce load",
  "reduce quantity",
  "reduce volume",
  "save space",
  "scale back",
  "filter pattern",
  "find pattern",
  "pattern matching",
  "patterns",
  "regex",
  "regular expression",
  "search pattern",
  "string pattern",
  "strings",
  "chillout",
  "contemplation",
  "de-stress",
  "destress",
  "lax",
  "loosen up",
  "pose",
  "relaxed",
  "repose",
  "selfcare",
  "serene",
  "stay loose",
  "stress relief",
  "timeout",
  "releases",
  "automatic login",
  "stay logged in",
  "bell ringing",
  "TV",
  "media controller",
  "dissociate",
  "sever",
  "substract",
  "invalidate",
  "rubbish",
  "scrap",
  "from",
  "remove from queue",
  "priviledge",
  "profile management",
  "unset",
  "multiplication symbol",
  "withdraw",
  "cancel cart",
  "delete item",
  "minus item",
  "minus sign",
  "oblique line",
  "shopping basket",
  "strike-through",
  "subtract item",
  "expand window",
  "reopen window",
  "restore window",
  "allocation",
  "dashboard item",
  "repartition",
  "multimedia icon",
  "play again",
  "curving arrows",
  "never ending",
  "loop button",
  "loop one",
  "loop playback",
  "loop single",
  "loop track",
  "repeat button",
  "repeat forever",
  "repeat one",
  "repeat single",
  "repeat track",
  "single item",
  "single song",
  "single video",
  "again",
  "audio file",
  "audio replacement",
  "audio swap",
  "change audio",
  "edit audio",
  "exchange audio",
  "modify audio",
  "music editing",
  "music file",
  "music replacement",
  "music swap",
  "recover",
  "replace audio",
  "sound editing",
  "sound file",
  "sound replacement",
  "sound swap",
  "swap audio",
  "switch audio",
  "track file",
  "track replacement",
  "track swap",
  "update audio",
  "voice editing",
  "voice file",
  "voice replacement",
  "voice swap",
  "angle bracket left",
  "caret left",
  "history back",
  "left indicator",
  "less than symbol",
  "pagination previous",
  "point left",
  "stern",
  "triangle pointing left",
  "westward",
  "new video",
  "play symbol",
  "replace video",
  "upload video",
  "repeat item",
  "replay media",
  "rewind media",
  "rewind 10",
  "rewind ten seconds",
  "skip back 10",
  "skip back ten seconds",
  "30 seconds back",
  "jump 30 seconds",
  "rewind 30",
  "step backward",
  "chat box",
  "messenger",
  "boomerang",
  "inform",
  "reply all",
  "abuse",
  "complaint",
  "spam",
  "block report",
  "cancel report",
  "disable report",
  "hide report",
  "ignore report",
  "mute report",
  "no report",
  "remove report",
  "report blocked",
  "report disabled",
  "report muted",
  "report off",
  "report off state",
  "report toggle off",
  "stop report",
  "turn off report",
  "form submission",
  "request form",
  "request page",
  "require",
  "ask for a quote",
  "asking",
  "pricing",
  "request a quote",
  "crosshairs icon",
  "re-center",
  "recenter view",
  "target icon",
  "counter clockwise",
  "clear filters",
  "remove changes",
  "restore default",
  "return to previous",
  "shutter speed",
  "default settings",
  "image.",
  "defaults",
  "troubleshoot",
  "change size",
  "diagonally",
  "sizing",
  "respiration",
  "respiratory rate",
  "ventilate",
  "ventilating",
  "breakpoints",
  "different screens",
  "display modes",
  "form factor",
  "layout switcher",
  "media query",
  "refresh data",
  "reload data",
  "resync",
  "resynchronize",
  "breakfast place",
  "dine",
  "dining establishment",
  "dinner place",
  "food place",
  "lunch place",
  "archive management",
  "bring back",
  "data recovery",
  "restore from trash",
  "un-delete",
  "previous state",
  "restore page",
  "cv",
  "personal file",
  "qualifications",
  "attempt",
  "recommendation",
  "try",
  "trying",
  "valued",
  "chalice",
  "earning",
  "earning money",
  "giveaway",
  "incentive",
  "rewarded",
  "arthritis",
  "human silhouette",
  "joints",
  "medical care",
  "musculoskeletal",
  "rheumatic",
  "rheumatism",
  "rheumatologists",
  "rheumatology",
  "rib cage",
  "ribs",
  "vital organs",
  "asian cuisine",
  "carbohydrate",
  "ceramic bowl",
  "dinnerware",
  "grains",
  "oriental food",
  "rice",
  "rounded bowl",
  "serving dish",
  "staple food",
  "mouse click",
  "popup menu",
  "right click",
  "expand right",
  "show right",
  "slide open",
  "reveal right",
  "concentric circles",
  "rounded lines",
  "avenue",
  "boulevard",
  "pavement",
  "point a to b",
  "roadway",
  "street line",
  "travel path",
  "droid",
  "helper",
  "astronaut",
  "projectile",
  "propulsion",
  "rocket",
  "spacecraft",
  "spaceship",
  "lift off",
  "mission",
  "thrust",
  "coverings",
  "pull down",
  "retractable",
  "roller shades",
  "rolling",
  "blinds closed",
  "building control",
  "curtains closed",
  "fully closed",
  "light blocking",
  "lowered",
  "roller blinds closed",
  "roller shades closed",
  "shades closed",
  "window blinds closed",
  "window covering closed",
  "window treatment closed",
  "inline skating",
  "roller skating",
  "rollerblading",
  "apex",
  "contractor",
  "gable",
  "roof structure",
  "roofing",
  "roofline",
  "shingle",
  "realty",
  "cloche",
  "food delivery",
  "room service",
  "silver",
  "90 degrees",
  "ccw",
  "circle section",
  "curve arrow",
  "90 degree turn",
  "swiveling",
  "accelerometer",
  "auto rotate",
  "automatic rotation",
  "device orientation",
  "orientation lock",
  "rotate auto",
  "screen orientation",
  "rotate left",
  "turn back",
  "rotate right",
  "spin right",
  "circular intersection",
  "roundabout",
  "traffic circle",
  "u-turn",
  "traffic management",
  "transport infrastructure",
  "chamfer",
  "fillet",
  "shape editor",
  "antennas",
  "appliance off",
  "broken signal",
  "dashed signal",
  "disabled router",
  "router off",
  "consistency",
  "display mode",
  "habit",
  "regularity",
  "repeated",
  "ui theme",
  "oars",
  "rowing",
  "blogging",
  "digital.",
  "rss",
  "syndication",
  "acknowledged",
  "affirmed",
  "attended",
  "plaît",
  "replied",
  "rsvp",
  "répondez",
  "sil",
  "vous",
  "live captions",
  "live text",
  "real time",
  "relay",
  "rrt",
  "rtt",
  "rubric",
  "scoring",
  "benchmark",
  "canon",
  "decree",
  "dictate",
  "precept",
  "stipulation",
  "archive folder",
  "document folder",
  "organization folder",
  "policy folder",
  "sprint",
  "errors",
  "runner",
  "campsite",
  "link.",
  "recreation vehicle",
  "rv",
  "sewer",
  "trailer",
  "antivirus",
  "not safe",
  "safety check off",
  "delineate",
  "fenced",
  "isolate",
  "rule off",
  "hull",
  "sailboat",
  "social sports",
  "aquarium",
  "conductivity",
  "dissolved solids",
  "saline",
  "salinity",
  "salt",
  "anti-bacterial",
  "disinfectant",
  "dispense",
  "gel",
  "handwash",
  "lotion",
  "pump bottle",
  "orbital",
  "solar panel",
  "space station",
  "evaporate",
  "diskette",
  "rename",
  "saved search",
  "coins",
  "pig",
  "piggy",
  "piggy bank",
  "counterpoise",
  "fairness",
  "magnitude",
  "document actions",
  "remove scan",
  "scan delete",
  "digitize",
  "qrcode",
  "analytical tool",
  "charting",
  "correlation",
  "graphing",
  "points on graph",
  "scatter",
  "statistical graph",
  "mountain range",
  "peaks",
  "hour hand",
  "minute hand",
  "query builder",
  "second hand",
  "watch later",
  "clock with arrow",
  "delayed send",
  "dispatch",
  "envelope send",
  "future send",
  "letter send",
  "mail send",
  "message send",
  "schedule send",
  "send time",
  "timed send",
  "academics",
  "building facade",
  "campus",
  "college building",
  "educational institution",
  "entrance way",
  "learning institution",
  "public building",
  "studying",
  "university building",
  "beaker icon",
  "chemistry icon",
  "experiment icon",
  "lab icon",
  "research icon",
  "academic off",
  "analysis off",
  "beaker off",
  "chemistry off",
  "disabled science",
  "discovery off",
  "education off",
  "experiment off",
  "flask off",
  "innovation off",
  "knowledge off",
  "laboratory off",
  "learn off",
  "muted science",
  "no science",
  "research off",
  "science off",
  "scientific off",
  "study off",
  "test tube off",
  "city transport",
  "micro mobility",
  "quick transport",
  "recreational vehicle",
  "wheeled vehicle",
  "leader",
  "scoreboard",
  "lock screen",
  "mobile lock",
  "screen lock",
  "screen rotation",
  "device security",
  "lock portrait",
  "mobile device security",
  "padlock symbol",
  "phone portrait",
  "screen security",
  "screenlock",
  "security settings",
  "smartphone security",
  "auto-rotate",
  "autorotation",
  "disable rotation",
  "fixed",
  "fixed orientation",
  "immobile",
  "locked rotation",
  "prevent rotation",
  "rotation lock",
  "screen record",
  "device rotation",
  "mobile setting",
  "screen orientation lock",
  "screen rotation lock",
  "counterclockwise",
  "auto lock",
  "display lock",
  "display orientation",
  "display rotation",
  "lock orientation",
  "lock vertically",
  "mobile rotation",
  "phone rotation",
  "portrait lock",
  "portrait orientation",
  "rotate screen",
  "rotate up",
  "rotate vertically",
  "rotation control",
  "screen direction",
  "screen turn",
  "turn screen",
  "up rotation",
  "upward rotation",
  "vertical display",
  "vertical mode",
  "screen search desktop",
  "projection screen",
  "print screen",
  "screen capture",
  "screenshot frame 2",
  "mobile keyboard",
  "on-screen keyboard",
  "boxed selection",
  "defined area",
  "graphic capture",
  "partial screenshot",
  "polygonal selection",
  "screenshot area",
  "screenshot region",
  "select area",
  "select region",
  "snipping tool",
  "window selection",
  "scrollable",
  "deep sea",
  "diver",
  "diving",
  "fins",
  "flippers",
  "scuba",
  "scuba diving",
  "snorkel",
  "underwater",
  "water sport",
  "circle lock",
  "data storage",
  "document with lock",
  "safebox",
  "angled corner",
  "external storage",
  "memory card",
  "micro sd",
  "music storage",
  "portable storage",
  "removable storage",
  "sd card",
  "trapezoid",
  "video storage",
  "puzzle piece",
  "sdk",
  "websites",
  "discover icon",
  "explore icon",
  "locate icon",
  "query icon",
  "search button",
  "discovering",
  "reviewing",
  "seeking",
  "checked search",
  "confirmed search",
  "search complete",
  "search success",
  "validated search",
  "good search",
  "audio search",
  "hands free",
  "hands free search",
  "microphone icon",
  "speech search",
  "spoken search",
  "steering",
  "steering wheel",
  "voice recognition",
  "voice search",
  "dataform",
  "cancel search",
  "clear search",
  "end search",
  "find disabled",
  "magnify blocked",
  "magnify disabled",
  "magnify off",
  "remove search",
  "search blocked",
  "search disabled",
  "stop search",
  "heated",
  "ventilated",
  "cooling seat",
  "right seat",
  "seat ventilation",
  "car seat",
  "cold weather",
  "heated seat",
  "comfort control",
  "cooled",
  "seat control",
  "vehicle features",
  "privacy policy",
  "secure data",
  "ssl",
  "system security",
  "vpn",
  "2-step",
  "access key",
  "ldap",
  "reauth",
  "thumb drive",
  "yubi",
  "yubi key",
  "mobile friendly",
  "mobile update",
  "passed",
  "security check",
  "system update",
  "mobile alert",
  "security warning",
  "chunk",
  "modular",
  "modularity",
  "subset",
  "marquee",
  "assistive technology",
  "disabilities",
  "highlight text",
  "screen reader",
  "select text",
  "sentence",
  "speak out",
  "active window",
  "multiple windows",
  "taskbar",
  "webpages",
  "This is a blank canvas",
  "chi",
  "it does not contain any visual information to generate tags from. Please provide an image to analyze.",
  "lotus",
  "bargain",
  "tag shape",
  "paper airplane",
  "file away",
  "move to archive",
  "digital wallet",
  "mobile pay",
  "move money",
  "remittance",
  "send money",
  "transfer funds",
  "paper plane",
  "send button",
  "send later",
  "open in",
  "open on",
  "porting",
  "push notification",
  "status indication",
  "active status",
  "body response",
  "human presence",
  "monitoring icon",
  "occupied",
  "occupied sensor",
  "occupied status",
  "presence detection",
  "security icon",
  "security status",
  "sensors",
  "smart body scan sensor",
  "sensor window",
  "data feed",
  "instrumentation",
  "sensor data",
  "telemetry",
  "control off",
  "disabled sensor",
  "krx",
  "sensor off",
  "sensors off",
  "settings off",
  "detection off",
  "measurement disabled",
  "measurement off",
  "no detection",
  "no measurement",
  "no sensors",
  "emotion indicator",
  "satisfied",
  "sentiment",
  "content analysis",
  "content emotion",
  "content feeling",
  "content mood",
  "critique",
  "emotional content",
  "expressive content",
  "feedback form",
  "sentiment analysis",
  "sentiment rating",
  "text analysis",
  "angry",
  "disappointed",
  "dissatisfied",
  "poor",
  "sad face",
  "unsatisfied",
  "astonish",
  "excite",
  "grinning",
  "passionate",
  "thrilled",
  "wow",
  "crying face",
  "extremely",
  "frowny",
  "frowny face",
  "frustrated",
  "furious",
  "mad",
  "negative feedback",
  "poor rating",
  "tears",
  "teary face",
  "unhappy face",
  "upset face",
  "displeased",
  "frustration",
  "emotionless",
  "indifference",
  "indifferent",
  "so-so",
  "straight face",
  "unamused",
  "visage",
  "frowning",
  "mournful",
  "sorrowful",
  "feedback icon",
  "rating icon",
  "satisfaction",
  "satisfied face",
  "smiling face",
  "difficult",
  "eyebrows",
  "stress",
  "tense",
  "worried",
  "discouraged",
  "moody",
  "terrible",
  "very",
  "contented",
  "delighted",
  "laughing",
  "pleasing",
  "very happy",
  "very satisfied",
  "concerned",
  "nervous",
  "scared",
  "worry",
  "capital t",
  "character t",
  "serif",
  "t icon",
  "uppercase t",
  "sole tenancy",
  "sole tenant",
  "adjusting",
  "customizing",
  "dining etiquette",
  "fork and knife",
  "teishoku",
  "administration panel",
  "customization settings",
  "gear wheel",
  "management tools",
  "options button",
  "preference settings",
  "adaptation",
  "restore defaults",
  "mobile options",
  "phone menu",
  "jack",
  "rj45",
  "general settings",
  "dish antenna",
  "parabole",
  "parabolic",
  "radio signal",
  "receiver dish",
  "satellite dish",
  "satellite signal",
  "tv antenna",
  "cables",
  "composite",
  "jacks",
  "ports",
  "cable port",
  "media input",
  "s-video",
  "svideo",
  "video input",
  "video port",
  "overscan",
  "picture adjustment",
  "screen display",
  "settings overscan",
  "vrpano",
  "settings phone",
  "access settings",
  "connection manager",
  "connection settings",
  "remote control settings",
  "remote device",
  "wireless control",
  "gear shape",
  "slow motion",
  "timelapse",
  "button.",
  "input settings",
  "mic settings",
  "sound settings",
  "speech recognition",
  "voice input",
  "entertainment system",
  "set top box",
  "settop",
  "blizzard",
  "icicle",
  "severe",
  "digital effect",
  "drop shadow",
  "illusion",
  "semi-transparent",
  "shading",
  "translucent",
  "visual design",
  "add shadow",
  "layer effect",
  "light effect",
  "delimiter",
  "em dash",
  "en dash",
  "hyphen",
  "rule-off",
  "shorten",
  "building blocks",
  "contect",
  "outreach",
  "arrival time",
  "estimated time of arrival",
  "send eta",
  "share eta",
  "location sharing",
  "send location",
  "share location",
  "action off",
  "action unavailable",
  "arrow and dots",
  "connect off",
  "connect unavailable",
  "connecting dots",
  "disallowed sharing",
  "feature disabled",
  "feature off",
  "link unavailable",
  "not shareable",
  "outgoing arrow",
  "share blocked",
  "share off",
  "share unavailable",
  "sharing disabled",
  "social off",
  "social unavailable",
  "publicize",
  "ratings",
  "share reviews",
  "testimonials",
  "disperse",
  "microsoft",
  "os",
  "outflow",
  "sharepoint",
  "show/hide",
  "infographic grid",
  "position icon",
  "shelf icon",
  "shelf position",
  "storage location",
  "catalogue",
  "online security",
  "tls",
  "protection icon",
  "moonlight",
  "night mode",
  "privacy mode",
  "private browsing",
  "security shield",
  "shield with moon",
  "help desk",
  "protected information",
  "safe search",
  "security question",
  "unknown risk",
  "security watch",
  "health insurance",
  "heart symbol",
  "digital safety",
  "privacy shield",
  "residential security",
  "safeguarding",
  "capital letters",
  "keyboard layout",
  "shift lock",
  "caps lock",
  "pointing up.",
  "shift lock off",
  "shopping center",
  "shop 2",
  "carry bag",
  "handle bag",
  "buy now",
  "express checkout",
  "fast shopping",
  "quick purchase",
  "quick shop",
  "retail therapy",
  "shopping online",
  "speed shopping",
  "grocery store",
  "e-shop",
  "purchasing",
  "clear cart",
  "delete items",
  "empty cart",
  "no shopping",
  "remove items",
  "unavailability",
  "cart with handle",
  "full cart",
  "line drawing",
  "shoppingmode",
  "stroke icon",
  "view cart",
  "lot",
  "p",
  "parking icon",
  "parking space",
  "street parking",
  "block of text",
  "editorial",
  "lorem ipsum",
  "placeholder text",
  "sample text",
  "short text",
  "show chart",
  "alter order",
  "change sequence",
  "crisscross",
  "crossed lines",
  "different order",
  "jumble",
  "mixed up",
  "random play",
  "re-arrange",
  "unpredictable",
  "criss-cross",
  "disordered",
  "jumbled",
  "overlapping arrows",
  "play order",
  "randomization",
  "shuffle mode",
  "shuffle on",
  "shuffled",
  "aperture control",
  "camera controls",
  "exposure time",
  "manual mode",
  "blades.",
  "metering",
  "slower",
  "contagion",
  "diagnose",
  "fever",
  "infection control",
  "medical condition",
  "symptoms",
  "virus outbreak",
  "collapsible menu",
  "hidden menu",
  "three stacked lines",
  "website menu",
  "asl",
  "body language",
  "bsl",
  "sign language",
  "visual language",
  "0 bars",
  "bad signal",
  "bars indicator",
  "towers",
  "zero bars",
  "mobile strength",
  "phone signal",
  "phone strength",
  "3 bars",
  "bars increasing",
  "cellular tower",
  "strength indicator",
  "ascending bars",
  "good signal",
  "bars up",
  "half strength",
  "increasing bars",
  "medium strength",
  "lost connection",
  "poor signal",
  "unavailable internet",
  "4 bars",
  "limited data",
  "nodata",
  "communication status",
  "mobile status",
  "no cellular",
  "unavailable signal",
  "wifi icon",
  "connection quality",
  "signal strength.",
  "unconnected",
  "connection symbol",
  "internet symbol",
  "network symbol",
  "signal symbol",
  "wireless symbol",
  "signal level",
  "statusbar",
  "autograph",
  "cursive",
  "digital signature",
  "handwriting",
  "signatory",
  "upright",
  "cellular service",
  "corner cut",
  "subscriber",
  "subscriber identity module",
  "theory",
  "accommodations",
  "bed silhouette",
  "furniture outline",
  "guest room",
  "hotel icon",
  "room icon",
  "single bed",
  "VoIP",
  "call control",
  "internet call",
  "softphone",
  "beacon",
  "circular base",
  "flashing",
  "sound wave.",
  "cleared",
  "resolved",
  "successful.",
  "horn",
  "confusion",
  "extreme sports",
  "freestyle",
  "skateboard",
  "skateboarder",
  "skateboarding",
  "Jolly Roger",
  "cage",
  "creepy",
  "ghost",
  "grim reaper",
  "halloween",
  "horror",
  "limbs",
  "pelvis",
  "pirate",
  "rib",
  "scary",
  "fry",
  "fry pan",
  "frying",
  "kitchen equipment",
  "kitchenware",
  "preparation",
  "saucepan",
  "saute",
  "sauteing",
  "skillet",
  "burner",
  "media button",
  "next track",
  "skip next",
  "vertical bar",
  "double line",
  "previous song",
  "previous track",
  "skip previous",
  "cranium",
  "crossbones",
  "evil",
  "eye sockets",
  "game over",
  "memento mori",
  "mortality",
  "spooky",
  "blacklist",
  "gothic",
  "macabre",
  "slab serif",
  "sled",
  "sledding",
  "sledge",
  "snow day",
  "snowy hill",
  "snowy slope",
  "winter activity",
  "stat",
  "asset library",
  "content library",
  "document library",
  "file library",
  "gallery library",
  "multiple documents",
  "presentation slides",
  "stacked slides",
  "image sequence",
  "movie screen",
  "photo display",
  "projector screen",
  "show images",
  "adjust speed",
  "edit video",
  "enhance video",
  "speed control",
  "insert card",
  "pc/sc",
  "secure.",
  "smart card reader",
  "voice control",
  "holes",
  "smart outlet",
  "wall outlet",
  "smart menu",
  "smart screen",
  "smart settings",
  "digital toy",
  "smart toy",
  "front-facing camera",
  "stay current",
  "mobile camera app",
  "smartphone camera app",
  "smartphone photography",
  "take photo",
  "take picture",
  "take video",
  "video icon",
  "connect dots",
  "connected points",
  "distribute data",
  "file sharing",
  "network nodes",
  "network share",
  "smb",
  "spreading data",
  "spreading information",
  "addiction",
  "cigar",
  "cigarette",
  "never",
  "no smoking",
  "smoke free",
  "smoking prohibited",
  "tobacco",
  "message thread",
  "messaging app",
  "textsms",
  "triangle tail",
  "indexed",
  "alarm icon",
  "clock face",
  "postpone alarm",
  "postpone reminder",
  "prolong",
  "sleep icon",
  "time icon",
  "carve",
  "maneuver",
  "snowboarder",
  "snowboarding",
  "icy",
  "particles",
  "flurry",
  "forecast icon",
  "heavy snow",
  "icicles",
  "snow fall",
  "snow shower",
  "snow storm",
  "snow symbol",
  "snowflakes",
  "winter weather",
  "skimobile",
  "skis",
  "snowmobile",
  "boots",
  "snowshoe",
  "snowshoeing",
  "snowshoes",
  "cleansing",
  "lather",
  "distance between people",
  "two people",
  "best users",
  "medallion",
  "medals",
  "ribbons",
  "top users",
  "user points",
  "user rank",
  "user score",
  "alternative energy",
  "clean energy",
  "electricity generation",
  "energy production",
  "light energy",
  "photovoltaic",
  "power generation",
  "pv",
  "solar array",
  "solar cell",
  "solar farm",
  "solar power",
  "sustainable energy",
  "alphabetize",
  "a to z",
  "alphabetical list",
  "alphabetical order",
  "alphabetically",
  "az",
  "by alpha",
  "character order",
  "letter order",
  "order symbols",
  "order text",
  "sort alphabetically",
  "sort text",
  "text list",
  "z to a",
  "bark",
  "barking",
  "hound",
  "fragile",
  "acoustic wave",
  "environmental sound",
  "loud sound",
  "sound detection",
  "sound signal",
  "sound wave icon",
  "audio levels",
  "digital audio",
  "music production",
  "sampler",
  "sound design",
  "sound monitoring",
  "sound sampler",
  "soundwave",
  "helping hand",
  "human services",
  "poverty",
  "social services",
  "soup kitchen",
  "origin point",
  "source environment",
  "notes file",
  "notes icon",
  "notes page",
  "landmass",
  "physical",
  "south america",
  "bottom right arrow",
  "southeast arrow",
  "angle icon",
  "direction icon",
  "movement icon",
  "south west",
  "south-west",
  "southwest arrow",
  "aromatherapy",
  "massage",
  "rejuvenation",
  "steam room",
  "dashboard view",
  "layout arrangement",
  "3d audio",
  "audio effects",
  "audio processing",
  "audio rendering",
  "enhanced audio",
  "environment audio",
  "headphone icon",
  "immersive audio",
  "positional audio",
  "sound waves radiating",
  "spatial audio",
  "virtual sound",
  "3d audio off",
  "audio disabled",
  "circle slash",
  "no 3d audio",
  "no spatial audio",
  "no surround sound",
  "slashed circle",
  "sound disabled",
  "sound symbol",
  "spatial audio off",
  "surround sound off",
  "virtual surround off",
  "audio controls",
  "speaker cone",
  "speaker waves",
  "spatial tracking",
  "aural",
  "audio devices",
  "audio group",
  "connect devices",
  "multiple speakers",
  "sound devices",
  "sound group",
  "speaker group",
  "volume group",
  "add notes",
  "edit notes",
  "speaker notes",
  "sticky notes",
  "talking points",
  "view notes",
  "audio notes",
  "no speaking",
  "no speech",
  "presentation notes",
  "speaker notes off",
  "handsfree",
  "six-pointed star",
  "graduate cylinder",
  "specific gravity",
  "volume indicator",
  "audio to text",
  "record voice",
  "transcribe",
  "transcription",
  "voice notes",
  "voice to text",
  "indicator needle",
  "performance indicator",
  "performance meter",
  "speed dial",
  "speed gauge",
  "0.25",
  "guage",
  "snail",
  "tortoise",
  "minimal speed",
  "0.5 speed",
  "half rate",
  "half speed",
  "half speed icon",
  "media control icon",
  "playback rate",
  "playback speed icon",
  "rate control",
  "rate icon",
  "slow motion icon",
  "slow speed",
  "speed adjustment",
  "speed control icon",
  "speed icon",
  "speed settings",
  "0.5x speed",
  "audio speed",
  "speed setting",
  "0.7x speed",
  "slower playback",
  "slower speed",
  "1/2",
  "limiter",
  "speed limit",
  "speed restriction",
  "1.25x",
  "fast playback",
  "increase speed",
  "label.",
  "multiplier",
  "one point two five",
  "play faster",
  "speed up",
  "1.2 times",
  "1.2x",
  "double speed",
  "numerical indicator",
  "1.5x speed",
  "audio rate",
  "numerals",
  "one point five",
  "reduced speed",
  "1.5",
  "1.5x",
  "1_5x",
  "play rate",
  "x factor",
  "1.75",
  "1.75x",
  "content consumption",
  "multimedia player",
  "playback faster",
  "playback speed control",
  "rate setting",
  "1.7",
  "factor",
  "2x",
  "time warp",
  "two times",
  "x2",
  "enforcement",
  "speed camera",
  "speeding",
  "proofread",
  "proofreading",
  "spellcheck",
  "split view",
  "content separation",
  "dividing line",
  "dual panel",
  "multi-view",
  "scenes",
  "screen layout",
  "side-by-side",
  "split down",
  "two views",
  "dual",
  "left pane",
  "right pane",
  "multiple views",
  "panes",
  "split pane",
  "split scene",
  "two panes",
  "workspace layout",
  "arrangement of elements",
  "multi-window",
  "user interface view",
  "two windows",
  "application view",
  "multi-tasking",
  "adjacent",
  "divide screen",
  "adjust layout",
  "parallel view",
  "window management",
  "multitask",
  "right panel",
  "right section",
  "right split",
  "top screen",
  "top view",
  "upper section",
  "add split",
  "app layout",
  "create split",
  "layout add",
  "multi view",
  "multiple panes",
  "new split",
  "pane add",
  "view add",
  "window add",
  "oximeter",
  "oxygen saturation",
  "pulse rate",
  "emanating",
  "spoke",
  "referee",
  "striped",
  "whistle",
  "and outdoors",
  "arena",
  "soccer",
  "casual",
  "pint",
  "sports bar",
  "tavern",
  "baseball",
  "batting",
  "catcher",
  "home run",
  "infielder",
  "league",
  "outfield",
  "pitcher",
  "basketball",
  "dribble",
  "hoop",
  "net",
  "orange ball",
  "seams",
  "bat",
  "batsman",
  "bowler",
  "cricket",
  "fielding",
  "pitch",
  "umpire",
  "wicket",
  "wicket-keeper",
  "competitive gaming",
  "directional pad",
  "electronic sport",
  "esports",
  "stadia",
  "xbox",
  "football",
  "pastime",
  "stitching",
  "tournament",
  "birdie",
  "bogey",
  "eagle",
  "flagstick",
  "par",
  "putting",
  "swing",
  "gymnastics",
  "athletic event",
  "handball",
  "indoor sport",
  "seam",
  "sports and recreation",
  "sports equipment",
  "team sport",
  "athletic activity",
  "athletic game",
  "athletic sports",
  "hockey",
  "puck",
  "rink",
  "scoreboard icon",
  "stats icon",
  "winter sports",
  "attacking",
  "combat",
  "defender",
  "defending",
  "fighting",
  "kabaddi",
  "players",
  "raider",
  "wrestle",
  "wrestling",
  "discipline",
  "dojo",
  "karate",
  "kick",
  "martial",
  "martial arts",
  "self-defense",
  "stance",
  "technique",
  "aggression",
  "boxing",
  "mma",
  "automotive industry",
  "go-kart",
  "kart",
  "motorsport",
  "motorsport event",
  "motorsports",
  "race car",
  "sports car",
  "athletic gear",
  "game object",
  "laces",
  "leather",
  "oval object",
  "recreational activity",
  "rugby",
  "sports gear",
  "stitched",
  "final score",
  "game score",
  "live score",
  "score board",
  "sport competition",
  "sport results",
  "sport scores",
  "sport stats",
  "sports score",
  "team score",
  "soccer ball",
  "tessellation",
  "amateur",
  "athletic equipment",
  "hit",
  "racket",
  "tennis",
  "volley",
  "dig",
  "volleyball",
  "hydration",
  "irrigation",
  "watering",
  "quadrangle",
  "sides",
  "lacto",
  "lacto-vegetarian",
  "floor plan",
  "inches",
  "square footage",
  "ssid",
  "aggregation",
  "piles",
  "geometric shapes",
  "arrange off",
  "content off",
  "disable stack",
  "documents off",
  "files off",
  "hide stack",
  "information off",
  "layers off",
  "organize off",
  "remove stack",
  "stack off",
  "toggle stack off",
  "unstack",
  "chart-chart",
  "results graph",
  "stacked graph",
  "envelopes",
  "mass",
  "layers of",
  "moma search",
  "records management",
  "stacked up",
  "teamgraph",
  "game device",
  "gaming system",
  "multiplayer",
  "single player",
  "amphitheater",
  "bleachers",
  "coliseum",
  "grandstand",
  "seats",
  "ladder",
  "stairway",
  "stairwell",
  "floors",
  "levels.",
  "add to favorite",
  "empty star",
  "five pointed star",
  "hollow star",
  "not filled",
  "rating symbol",
  "favorite icon",
  "half filled star",
  "half star",
  "incomplete star",
  "mark icon",
  "partial star",
  "rating rank",
  "rating system",
  "review icon",
  "score icon",
  "user rating",
  "star shape",
  "astral",
  "celestial object",
  "1 arrow",
  "stat_3",
  "decreasing",
  "doward",
  "rectangle with rounded corners",
  "heater",
  "steering wheel heat",
  "growth stages",
  "multistep",
  "sequence of steps",
  "stages of a process",
  "tier",
  "step into",
  "move out",
  "step out",
  "control flow",
  "debugger",
  "programming control",
  "skip to next",
  "step over",
  "guide flow",
  "multi-step",
  "numbered steps",
  "ordered steps",
  "sequence flow",
  "sequential process",
  "sequential steps",
  "step indicator",
  "task flow",
  "task sequence",
  "workflow sequence",
  "following",
  "shoeprints",
  "audiology",
  "medical tool",
  "poa",
  "examined",
  "good health",
  "corner fold",
  "digital note",
  "flat icon",
  "folded corner",
  "message pad",
  "paper pad",
  "personal note",
  "post-it",
  "quick note",
  "reminder note",
  "sticky note",
  "temporary note",
  "peel",
  "post it",
  "clip art",
  "broth",
  "cooking pot",
  "meal planning",
  "meal prep",
  "simmering",
  "stew",
  "circle shape",
  "conclude",
  "square shape",
  "end share",
  "online communication",
  "stop screen share",
  "retail building",
  "shop building",
  "shop icon",
  "store building",
  "storefront icon",
  "dark clouds",
  "abstract shape",
  "separator bar",
  "perpendicular",
  "right angle",
  "straighten",
  "tactics",
  "app streaming",
  "chat app",
  "message app",
  "mobile chat",
  "mobile streaming",
  "phone app",
  "streaming app",
  "street view",
  "streetview",
  "anxiety",
  "deep breathing",
  "emotional",
  "psychological",
  "serenity",
  "soul",
  "letter s",
  "s",
  "typo",
  "full line",
  "full stroke",
  "graphical element",
  "graphical rule",
  "heavy line",
  "layout element",
  "long dash",
  "text element",
  "arc segment",
  "arch",
  "broken arch",
  "circle segment",
  "graphical",
  "incomplete arch",
  "partial shape",
  "partial stroke",
  "baby transport",
  "child transport",
  "family friendly",
  "fatherhood",
  "handles",
  "infant care",
  "outing",
  "pushchair",
  "appearance options",
  "visual elements",
  "hairdresser",
  "styler",
  "art tool",
  "creative tool",
  "electronic pen",
  "smart pen",
  "tablet pen",
  "touch pen",
  "brush stroke",
  "creative tools",
  "digital brush",
  "fine tip",
  "illustrate",
  "pointed tool",
  "stylus pen",
  "calligraphy",
  "graphic tablet",
  "laser pointer",
  "pointer tool",
  "presentation tool",
  "selecting",
  "digital writing",
  "fine point",
  "writing utensil",
  "signature input",
  "sub",
  "subdirectory",
  "subheader",
  "help bubble",
  "information bubble",
  "subscript",
  "typesetting",
  "channels",
  "enroll",
  "subscriptions",
  "live caption",
  "closed caption",
  "written",
  "captions disabled",
  "captions off",
  "cc off",
  "closed captioning disabled",
  "closed captioning off",
  "subtitles disabled",
  "subtitles off",
  "mta",
  "transit system",
  "daylight",
  "mixed precipitation",
  "mixed weather",
  "snow falling",
  "snowy weather",
  "sun and snow",
  "exponent",
  "notation",
  "small text",
  "superior",
  "superscript",
  "family link",
  "restricted profile",
  "supervised user circle",
  "supervised user",
  "parental controls",
  "buoy",
  "customer care",
  "lifebuoy",
  "representative",
  "incision",
  "operate",
  "scalpel",
  "acoustics",
  "immersive sound",
  "multi-channel audio",
  "sound field",
  "speaker placement",
  "volumn",
  "up down arrows",
  "app switcher",
  "driving mode",
  "multi-app",
  "swap apps",
  "two apps",
  "double-ended arrow",
  "horizontal swap",
  "back and forth",
  "exchange rate",
  "direction change",
  "content loading",
  "drag down",
  "pull to refresh",
  "swipe down",
  "swpie",
  "take",
  "vertical movement",
  "feed navigation",
  "finger gesture",
  "list navigation",
  "mobile interaction",
  "screen interaction",
  "touch gesture",
  "touch interaction",
  "vertical gesture",
  "swipe left",
  "drag left",
  "hand gesture",
  "horizontal swipe",
  "leftwards movement",
  "scroll left",
  "slide left",
  "user input",
  "horizontal movement",
  "swipe right",
  "user control",
  "mobile gesture",
  "swipe up",
  "digital gesture",
  "drag up",
  "pointer up",
  "screen action",
  "slide up",
  "flick",
  "ui gesture",
  "up/down",
  "vertical swipe",
  "verticle",
  "setting control",
  "accessibility services",
  "alternative control",
  "paired device",
  "switch access",
  "system control",
  "alternative input",
  "enabling",
  "on/off",
  "account change",
  "account switch",
  "alter user",
  "change profile",
  "change user",
  "multiple accounts",
  "profile change",
  "profile switch",
  "switch account",
  "user switch",
  "toggle camera",
  "directional switch",
  "preference switch",
  "state control",
  "switch left",
  "toggle left",
  "camera rotation",
  "camera view",
  "reverse camera",
  "switch video",
  "video switch",
  "view camera",
  "toggles",
  "battle",
  "dagger",
  "fantasy",
  "mythical",
  "rose",
  "sword",
  "war",
  "warrior",
  "weapon",
  "young adult",
  "clash",
  "conflict",
  "crossed blades",
  "crossed swords",
  "duel",
  "fencing",
  "fight",
  "rivalry",
  "swords",
  "weapons",
  "israel",
  "jerusalem",
  "jew",
  "jewish",
  "judaism",
  "shul",
  "star of david",
  "curved arrows",
  "sync icon",
  "synchronize icon",
  "bidirectional arrows",
  "data synchronization",
  "data update",
  "rotating arrows",
  "synchronization icon",
  "cloud sync",
  "data sync",
  "device sync",
  "cancel sync",
  "data transfer disabled",
  "no sync",
  "not syncing",
  "pause sync",
  "refresh disabled",
  "stop sync",
  "sync disabled",
  "synchronization off",
  "update disabled",
  "encryption lock",
  "sync lock",
  "broken sync",
  "cloud sync error",
  "cloud sync issue",
  "cloud sync problem",
  "failed to sync",
  "failed to synchronize",
  "refresh error",
  "refresh issue",
  "refresh problem",
  "sync error",
  "sync fail",
  "sync failed",
  "sync issue",
  "sync problem",
  "synchronization error",
  "synchronization issue",
  "synchronization problem",
  "available locally",
  "local drive",
  "local storage",
  "saved locally",
  "sync locally",
  "injection",
  "inoculation",
  "vaccination",
  "vaccines",
  "download app",
  "get app",
  "install app",
  "mobile download",
  "security update",
  "software update",
  "add tab",
  "add window",
  "application management",
  "application window",
  "browser control",
  "browser tab",
  "document tab",
  "file tab",
  "internet browser",
  "layering windows",
  "program window",
  "project tab",
  "software window",
  "stacking windows",
  "unactive",
  "unhighlighted",
  "arrow graphic",
  "next tab",
  "shift tab",
  "tab direction",
  "tab movement",
  "open tab",
  "web tab",
  "web window",
  "This is a blank white image. I cannot analyze the content of the icon based on this. Please provide an image with the actual icon.",
  "inactive tab",
  "unselected tab",
  "cell grid",
  "data conversion",
  "format change",
  "grid table",
  "layout change",
  "organize data",
  "reformat",
  "restructure data",
  "database edit",
  "document edit",
  "edit entry",
  "form edit",
  "modify data",
  "spreadsheet edit",
  "table data",
  "bedroom lamp",
  "desk lamp",
  "light source",
  "study lamp",
  "table lamp",
  "bistro table",
  "book table",
  "cafe table",
  "dining table",
  "restaurant table",
  "data view",
  "lenovo",
  "nexus",
  "samsung",
  "square corner",
  "tablet mac",
  "browser tabs",
  "layers of rectangles",
  "layers of windows",
  "stacked objects",
  "two objects",
  "flow chart",
  "gameplan",
  "scheme",
  "hash",
  "hashtag",
  "organise",
  "food box",
  "food container",
  "meal box",
  "meal container",
  "meal delivery",
  "restaurant delivery",
  "restaurant take out",
  "takeout box",
  "to go",
  "lock off",
  "padlock off",
  "protection off",
  "setting off",
  "shield off",
  "status off",
  "tamper detection",
  "tamper detection off",
  "tamper",
  "OS wifi",
  "mobile cast",
  "mobile hotspot",
  "tap and play",
  "appetizer",
  "calculating",
  "executing",
  "retrieving",
  "tapas",
  "archery",
  "bulls",
  "center point",
  "correctness",
  "call attention",
  "callout",
  "taunt",
  "tease",
  "group dashboard",
  "performance tracking",
  "team management",
  "team metrics",
  "save energy",
  "save resources",
  "buddha",
  "buddhism",
  "buddhist",
  "cultural",
  "eastern",
  "monastery",
  "pagoda",
  "shrine",
  "hindu",
  "hinduism",
  "hindus",
  "historical site",
  "mandir",
  "landlord",
  "letting",
  "renter",
  "tenancy",
  "tenancy agreement",
  "tenant",
  "IT",
  "command line",
  "command prompt",
  "emulator",
  "run code",
  "advert",
  "paid promotion",
  "sponsored content",
  "sponsored post",
  "text advertising",
  "text frame",
  "prose",
  "synch",
  "text compare",
  "decrease text",
  "diminish",
  "reduce text",
  "scale text",
  "shrink text",
  "text smaller",
  "zoom out text",
  "add text",
  "edit field",
  "enter text",
  "text fields",
  "square A",
  "readability",
  "change orientation",
  "angledown",
  "down indicator",
  "manipulate text",
  "text orientation",
  "angleup",
  "skew",
  "dow",
  "choose text",
  "end selection",
  "finish selection",
  "selection range",
  "text manipulation",
  "text selection",
  "prior",
  "move cursor",
  "previous word",
  "triangular pointer",
  "typing cursor",
  "typing indicator",
  "word selection",
  "blinker",
  "character position",
  "character select",
  "insert cursor",
  "next character",
  "text indicator",
  "text position",
  "articulation",
  "doc data",
  "elocution",
  "enunciation",
  "machine reading",
  "pronounce",
  "tts",
  "verbal",
  "vocalize",
  "ascendant",
  "capitalize",
  "text up",
  "unknow",
  "bumpy",
  "crosshatch",
  "grit",
  "matte",
  "rough",
  "surface finish",
  "texture add",
  "applause",
  "performing arts",
  "box office",
  "documentary",
  "independent",
  "screening",
  "showtimes",
  "theaters",
  "mercury",
  "tool.",
  "digital display",
  "heat and air",
  "lower temperature",
  "point down",
  "warmer",
  "programmable",
  "objectives",
  "message dot",
  "notification dot",
  "unread badge",
  "cyberattack",
  "cybersecurity",
  "cyberthreat",
  "threat intelligence",
  "ate",
  "disagree",
  "hate",
  "thumbs down",
  "vote down",
  "content interaction",
  "endorsement",
  "hand signal",
  "meteorological event",
  "raincloud",
  "rainstorm",
  "lower leg",
  "tibia",
  "fibula",
  "osteology",
  "shin bone",
  "content block",
  "large tile",
  "partitioning",
  "sectioning",
  "auto timer",
  "filmography",
  "milestones",
  "points in time",
  "countdown clock",
  "countdown timer",
  "time limit",
  "number 10",
  "ten seconds",
  "lapse",
  "end time",
  "number 5",
  "remaining time",
  "start time",
  "self-timer",
  "adjust time",
  "count up",
  "time adjustment",
  "time up",
  "alarm disabled",
  "chronometer off",
  "clock canceled",
  "clock disabled",
  "clock off",
  "disable timer",
  "no time clock",
  "no timer",
  "remove timer",
  "stop timer",
  "stopwatch off",
  "time clock disabled",
  "time clock off",
  "timer canceled",
  "timer disabled",
  "timer off",
  "break time",
  "time out",
  "timer pause",
  "triangular play button",
  "inflate",
  "puncture",
  "spare",
  "tire",
  "basic minus",
  "decrease box",
  "less box",
  "minimal minus",
  "minimize box",
  "minus square",
  "negative box",
  "remove box",
  "simple minus",
  "subtract box",
  "access restricted",
  "out of bounds",
  "traffic sign",
  "brief message",
  "ephemeral",
  "info bubble",
  "message display",
  "notification message",
  "popup message",
  "quick message",
  "system message",
  "temporary message",
  "transient",
  "user feedback",
  "chapter list",
  "document navigation",
  "document sections",
  "index list",
  "section list",
  "structure of a document",
  "titles",
  "toc",
  "now",
  "button off",
  "control button",
  "deactivated state",
  "inable",
  "slider control",
  "toggle button",
  "toggle state",
  "activate control",
  "booth",
  "charges",
  "collect",
  "fee",
  "toll",
  "action bar",
  "command bar",
  "configuration panel",
  "customisation",
  "feature bar",
  "utility bar",
  "assemble",
  "craftsmanship",
  "flat head",
  "loosen",
  "slotted",
  "tighten",
  "instruments",
  "inclined",
  "bubble level",
  "plumb",
  "spirit level",
  "crosshead",
  "fastener",
  "fastening",
  "phillips",
  "gripping",
  "handicraft",
  "stripper",
  "stripping",
  "wire stripper",
  "bore",
  "bore hole",
  "building tools",
  "construction tools",
  "electric drill",
  "power drill",
  "power tool",
  "bubbletool",
  "clarification",
  "say",
  "explainer",
  "lowercase i",
  "top panel",
  "concern",
  "subject matter",
  "destructive",
  "swirling",
  "weather warning",
  "windstorm",
  "dissolved",
  "flat bottom",
  "purity",
  "solids",
  "substances",
  "extended press",
  "gesture icon",
  "hold icon",
  "long touch",
  "press and hold",
  "press icon",
  "prolonged touch",
  "touch control",
  "user interaction",
  "multi-touch",
  "triple",
  "touchpad",
  "onboarding",
  "walkthrough",
  "parts",
  "toys",
  "activities",
  "juggling",
  "playing",
  "puzzles",
  "electric device",
  "household item",
  "office appliance",
  "pinwheel",
  "spinning blades",
  "document history",
  "evolve",
  "rectange",
  "computer input",
  "cursor control",
  "tapping",
  "multiple touch",
  "three fingers",
  "congestion",
  "road network",
  "vehicles",
  "bumper-to-bumper",
  "gridlock",
  "roadwork",
  "traffic jam",
  "medium distance",
  "city travel",
  "streetcar",
  "urban journey",
  "urban rail",
  "anchors",
  "biological sex",
  "gender identity",
  "pronouns",
  "queer",
  "transgender",
  "enterexit",
  "transit information",
  "travel stop",
  "perforated",
  "ticket icon",
  "transit icon",
  "chop",
  "director's cut",
  "film cut",
  "flix",
  "blend effect",
  "crossfade",
  "dissolve effect",
  "dissolve transition",
  "media effect",
  "media production",
  "transition effect",
  "video transition",
  "fade to black",
  "graphical effect",
  "slide transition",
  "phrase",
  "drop-off",
  "metropolitan",
  "airborne",
  "commercial flight",
  "fuselage",
  "private jet",
  "earth search",
  "explore world",
  "find on map",
  "find place",
  "globe and magnifying glass",
  "globe search",
  "map search",
  "search world",
  "travel and explore",
  "packing list",
  "travel accessories",
  "decrease icon",
  "downtrend",
  "lowering",
  "negative trend",
  "slump",
  "trend icon",
  "trending down",
  "horizontal arrow",
  "steady",
  "straight arrow",
  "trending flat",
  "trending up",
  "point a",
  "point b",
  "journey start",
  "locus",
  "trip origin",
  "adding to cart",
  "pushing",
  "aerial tram",
  "iconic vehicle",
  "mountain transport",
  "public transit",
  "tourist attraction",
  "transport system",
  "travel mode",
  "bronze",
  "leadership",
  "tool bar",
  "breaking wave",
  "cresting wave",
  "disaster warning",
  "force of nature",
  "high wave",
  "large wave",
  "ocean wave",
  "powerful wave",
  "swell",
  "tsunami",
  "turbulent water",
  "spreadsheet file",
  "spreasheet",
  "tab separated values",
  "tsv",
  "teletype",
  "terminal emulator",
  "tty",
  "bass",
  "treble",
  "bend right",
  "changing direction",
  "forward and right",
  "forward direction",
  "future direction",
  "sharp turn",
  "acute turn",
  "go left",
  "slight",
  "slight right",
  "slight turn",
  "entertainment center",
  "solid fill",
  "squared corners",
  "display device",
  "display output",
  "monitor screen",
  "monitors",
  "multiple displays",
  "television screen",
  "video out",
  "broadcast schedule",
  "channel guide",
  "digital tv guide",
  "epg",
  "program guide",
  "show times",
  "television guide",
  "television schedule",
  "tv guide",
  "tv schedule",
  "broadcasts",
  "av input",
  "select input",
  "source select",
  "video source",
  "google connect",
  "google tv",
  "signin",
  "folded pages",
  "folded paper",
  "layout view",
  "open pages",
  "view pages",
  "paired",
  "two wheeler",
  "example",
  "showcase",
  "driving directions",
  "turn around",
  "reverse direction",
  "arm bones",
  "elbow",
  "forearm",
  "health scan",
  "radius bone",
  "ulna",
  "ulna bone",
  "open umbrella",
  "open folder",
  "unarchive",
  "less data",
  "less detail",
  "unfold less",
  "arrows down",
  "arrows pointing in",
  "minimize application",
  "fold less",
  "fold more",
  "break apart",
  "disassociate",
  "dissolve group",
  "scattered",
  "split group",
  "ungrouping",
  "cent",
  "alert bell",
  "audio indicator",
  "incoming message",
  "sound indicator",
  "missing document",
  "missing file",
  "paper document",
  "unknown content",
  "unknown file type",
  "unknown format",
  "miss",
  "slim",
  "free software",
  "free use",
  "infinity symbol",
  "limitless",
  "no copyright",
  "no restrictions",
  "unbound",
  "unconstrained",
  "unlicense",
  "unrestricted.",
  "dirt road",
  "unpaved",
  "unpublished",
  "newsletter",
  "unregister",
  "unsubscribe",
  "anticipation",
  "coming",
  "coming soon",
  "events list",
  "forthcoming",
  "future events",
  "later date",
  "new events",
  "not yet",
  "plans",
  "still to come",
  "loading disabled",
  "no update",
  "not loading",
  "not updating",
  "refresh off",
  "sync off",
  "better",
  "instal",
  "digital payment",
  "gpay",
  "unified payments interface",
  "upi",
  "upi pay",
  "virtual payment",
  "computer to cloud",
  "data upload",
  "folder arrow",
  "upload image",
  "outwards",
  "anatomy illustration",
  "bladder",
  "organs",
  "urinary",
  "urinary system",
  "urinary tract",
  "universal serial bus",
  "remove device",
  "safely remove",
  "unplug",
  "usb off",
  "flu shot",
  "immunity",
  "jab",
  "canister",
  "carpet",
  "suction",
  "vacuum",
  "vacuuming",
  "do not vape",
  "e-cigarette",
  "e-cigarette free",
  "nicotine",
  "no electronic cigarettes",
  "no vaping",
  "prohibition symbol",
  "vape",
  "vape free",
  "vaping",
  "electronic cigarette",
  "puff",
  "docs",
  "variables",
  "absence",
  "blank area",
  "blank space",
  "clean space",
  "clear space",
  "empty space",
  "invisible icon",
  "negative space",
  "unobtrusive",
  "vacant",
  "void area",
  "nullify",
  "remove variable",
  "variable remove",
  "specify",
  "artificial respiration",
  "life support",
  "medical instrument",
  "pulmonary",
  "ventilator",
  "ventilator machine",
  "accreditation",
  "approval icon",
  "authentic",
  "checkmark in circle",
  "green checkmark",
  "legitimacy",
  "stamp of approval",
  "verified account",
  "verified user",
  "validity",
  "verification disabled",
  "verified off",
  "endorsed",
  "exemption",
  "textbox",
  "vertical align bottom",
  "middle align",
  "vertically",
  "distribute objects",
  "layout tools",
  "curtain",
  "drapery",
  "slats",
  "vertical blinds",
  "window shades",
  "strips",
  "vertical shades",
  "window treatment",
  "content layout",
  "side-by-side layout",
  "ui layout",
  "window layout",
  "oscillate",
  "tremble",
  "distance learning",
  "group call",
  "remote communication",
  "telehealth",
  "videocall",
  "virtual meeting",
  "recording device",
  "add video",
  "film recording",
  "media creation",
  "record video",
  "video content",
  "video creation",
  "video library",
  "video management",
  "video production",
  "movie recording",
  "vlogging",
  "stop video",
  "facetime",
  "format type",
  "media format",
  "multimedia file",
  "watch file",
  "film search",
  "find film",
  "find media",
  "find movie",
  "find multimedia",
  "find video",
  "look for video",
  "movie search",
  "video search",
  "film settings",
  "movie settings",
  "streaming settings",
  "video adjust",
  "video cogwheel",
  "video configuration",
  "video gear",
  "video preferences",
  "video setup",
  "anti-shake",
  "gyroscope",
  "taping",
  "video stable",
  "videocam",
  "electronic entertainment",
  "gaming console",
  "gaming controller",
  "triggers",
  "agenda view",
  "list format",
  "stacked list",
  "view agenda",
  "three by three",
  "view array",
  "table layout",
  "table view",
  "view column",
  "view display",
  "duality",
  "comfy",
  "view comfy alt",
  "element.",
  "layout dense",
  "clustered",
  "view cozy",
  "3d model",
  "ar experience",
  "hologram",
  "immersive view",
  "reality view",
  "scifi",
  "view in",
  "view in ar",
  "ar off",
  "ar view",
  "no ar",
  "agile",
  "kanban",
  "kanban board",
  "task board",
  "visual board",
  "workflow management",
  "surveil",
  "100%",
  "actual size",
  "full size",
  "one to one",
  "original size",
  "real size",
  "view image",
  "navigation panel",
  "options panel",
  "content blocks",
  "sectioned",
  "stream view",
  "view layout",
  "calendar view",
  "chronicle",
  "chronicle view",
  "daily view",
  "days of the week",
  "vacation stay",
  "villa",
  "eye icon",
  "visibility control",
  "protected view",
  "restricted view",
  "secured view",
  "unlock eye",
  "visible lock",
  "disabled view",
  "password field",
  "unwatch",
  "aerobic",
  "cardiorespiratory",
  "maximal oxygen consumption",
  "vo2 max",
  "audio chat",
  "voice chat",
  "voice message",
  "accessibility off",
  "assistance disabled",
  "disabled feature",
  "narration off",
  "no voice",
  "screen reader disabled",
  "screen reader off",
  "speaking off",
  "speech off",
  "text to speech off",
  "voice icon",
  "voice over disabled",
  "voice over off",
  "circle with exclamation",
  "sound message",
  "voicemail",
  "answering machine",
  "left message",
  "voice recording",
  "ash",
  "eruption",
  "lava",
  "magma",
  "volcano",
  "audio adjustment",
  "decrease volume",
  "lower volume",
  "quieter",
  "speaker symbol",
  "lower sound",
  "sound down",
  "volume decrease",
  "volume down alt",
  "high volume",
  "increase volume",
  "sound bars",
  "sound setting",
  "volume up",
  "activism",
  "cause",
  "compassion",
  "donation box",
  "philanthropy",
  "decide",
  "dispute",
  "oppose",
  "restricted.",
  "virtual private network",
  "closed lock",
  "secure tunnel",
  "online privacy",
  "protected connection",
  "180",
  "180 degrees",
  "convert to 2d",
  "create2d",
  "flatten",
  "vr180",
  "non-vr",
  "pano",
  "decorative light",
  "home lighting",
  "indoor light",
  "interior lighting",
  "luminaire",
  "modern lamp",
  "sconce",
  "wall lamp",
  "wall light",
  "mobile wallet",
  "spending",
  "enchantment",
  "magic wand",
  "sorcerer",
  "twinkle",
  "fairy",
  "miracle",
  "mystical",
  "supernatural",
  "defended",
  "shielded",
  "square with rounded corners",
  "depot",
  "alert disabled",
  "blocked warning",
  "cancelled warning",
  "disabled warning",
  "exclamation mark with slash",
  "muted alert",
  "muted warning",
  "no alert",
  "no security",
  "no warning",
  "security threat off",
  "silenced alert",
  "silenced warning",
  "stopped warning",
  "triangle with slash",
  "warning disabled",
  "warning off",
  "laundry basket",
  "successful",
  "watch off",
  "screentime",
  "smart watch",
  "buzz",
  "haptics",
  "awaken",
  "aqua",
  "single drop",
  "tear drop",
  "drinking vessel",
  "health indicator",
  "hydrate",
  "hydration reminder",
  "liquid container",
  "personal container",
  "reusable bottle",
  "sport bottle",
  "thirst",
  "water bottle",
  "plastic bottle",
  "reusable",
  "water storage",
  "leaking",
  "liquid damage",
  "soaked",
  "spill",
  "spilling",
  "water damage",
  "h2o",
  "ec",
  "rain drop",
  "rain droplet",
  "tear droplet",
  "water droplet",
  "hot water",
  "water heater",
  "blocked water",
  "locked drop",
  "locked water",
  "protected water",
  "secure water",
  "water access",
  "water resistant",
  "water safety",
  "water security",
  "waterproof",
  "deficit",
  "dripping",
  "evaporation",
  "plumbing issue",
  "scarcity",
  "water usage",
  "aqua drop",
  "clean water",
  "fluid drop",
  "reflection",
  "refraction",
  "simple drop",
  "teardrop shape",
  "💧",
  "splash",
  "hydro",
  "orp",
  "oxidation",
  "oxidation reduction potential",
  "acidic",
  "acidity",
  "alkaline",
  "hydrogen",
  "potable",
  "groundwater intake",
  "pumping",
  "rainwater harvesting",
  "wastewater",
  "water pressure",
  "water pressure boosting",
  "water pump",
  "chemicals",
  "compounds",
  "contamination",
  "environmental monitoring",
  "indoor air quality",
  "voc",
  "volatile organic compounds",
  "waterfall",
  "waterfall chart",
  "sine wave",
  "bye",
  "goodbye",
  "greetings",
  "hi",
  "waving hand",
  "W",
  "auto brightness",
  "auto light",
  "auto settings",
  "automatic mode",
  "wp",
  "eureka",
  "window blind",
  "window shade",
  "dawn",
  "dimming",
  "fading",
  "noon",
  "twilight",
  "gender symbols",
  "men and women",
  "p.o.i.",
  "public facilities",
  "hailstones",
  "hailstorm",
  "blended",
  "mixed conditions",
  "chilly",
  "cold temperature",
  "flurries",
  "frozen precipitation",
  "snow forecast",
  "snow icon",
  "weather information",
  "weather report",
  "weather state",
  "find us",
  "spot marker",
  "-website",
  "computer screen",
  "web asset",
  "not supported",
  "webpage",
  "short video",
  "vertical video",
  "web stories",
  "data traffic",
  "global network",
  "internet activity",
  "internet traffic",
  "online activity",
  "online presence",
  "web analytics",
  "web traffic",
  "website traffic",
  "world network",
  "webhook",
  "business trip",
  "leisure travel",
  "overnight bag",
  "travel goods",
  "vacation planning",
  "weekend",
  "weekender",
  "pood",
  "stones",
  "tonne",
  "hot icon",
  "lively",
  "popular icon",
  "spicy",
  "trending icon",
  "what's hot",
  "whatshot",
  "dropoff",
  "handicapped",
  "special assistance",
  "civic",
  "election day",
  "polling place",
  "validate election",
  "subdivision",
  "applet",
  "widget size",
  "widget width",
  "widgets",
  "adjust width",
  "canvas size",
  "content width",
  "display width",
  "normal width",
  "proportions",
  "width wide",
  "connection indicator",
  "connection strength",
  "high signal",
  "limited connection",
  "low connection",
  "minimal signal",
  "minimal strength",
  "one bar signal",
  "poor connection",
  "internet calling",
  "wifi signal",
  "wireless call",
  "voice over ip",
  "wifi calling",
  "wireless calling",
  "network channel",
  "wifi channel",
  "wireless channel",
  "semicircle",
  "maximum signal",
  "network access.",
  "system tray",
  "network key",
  "wireless password",
  "wpa2",
  "WPS",
  "network setup",
  "protected setup",
  "three arcs",
  "network configuration",
  "proxy server",
  "proxy settings",
  "tethering",
  "internet sharing",
  "wind power",
  "wind turbine",
  "computer window",
  "modal window",
  "pop-up",
  "closed window",
  "display area",
  "screen view",
  "inside car",
  "windscreen",
  "drink menu",
  "wine glass",
  "attache",
  "heads up",
  "heads-up",
  "skills",
  "distinguished",
  "cascade",
  "workspaces",
  "band aid",
  "staples",
  "stitches",
  "wound",
  "arrow writing",
  "failed location",
  "invalid location",
  "Rich text editor",
  "basic editor",
  "composer",
  "plain text editor",
  "simple editor",
  "what you see is what you get",
  "wysiwyg",
  "land area",
  "land plot",
  "pettle",
  "property line",
  "navigation history",
  "past trips",
  "saved trips",
  "travel history",
  "trip history",
  "trip management",
  "trip planner",
  "waypoints",
  "your trips",
  "searched",
  "big",
  "interface tool",
  "ui tool",
  "image view",
  "map view",
  "pull back",
  "telescopic",
  "zoom out map",
  "Chinese medicine",
  "TCM",
  "acupuncture",
  "alternative medicine",
  "holistic",
  "meridian",
  "natural healing",
  "needles",
  "pain relief",
  "therapy room",
  "traditional chinese medicine",
  "certify",
  "auto stories disabled",
  "auto stories off",
  "auto story off",
  "automated stories disabled",
  "automatic stories off",
  "stories disabled",
  "stories off",
  "badminton",
  "birdy",
  "feathered ball",
  "game equipment",
  "racquet",
  "recreation equipment",
  "shuttlecock",
  "shuttlecock feather",
  "ablution",
  "bedrock",
  "ale",
  "izakaya",
  "pictogram.",
  "bar stool",
  "stool",
  "armchair",
  "fireplace lounge",
  "flames",
  "home interior",
  "relaxing",
  "classic game",
  "mind game",
  "tabletop",
  "monarch",
  "playing piece",
  "l-shape",
  "opponent",
  "strategy game",
  "black chess piece",
  "chessboard",
  "white chess piece",
  "checkmate",
  "faceted",
  "enjoyment",
  "dine in",
  "aerial vehicle",
  "civilian",
  "remote piloted vehicle",
  "robotics",
  "rotor",
  "uas",
  "uav",
  "unmanned aerial vehicle",
  "aerial photography",
  "aerial video",
  "flying camera",
  "propellers",
  "quadcopter",
  "unmanned",
  "amplification",
  "auditory aid",
  "auto repair",
  "waiter",
  "hand over",
  "receive package",
  "unbox",
  "aid symbol",
  "emergency symbol",
  "valentines day",
  "baby seat",
  "high chair",
  "comfort food",
  "curry rice",
  "japanese curry",
  "meal time",
  "sauce",
  "citizenship",
  "hinomaru",
  "overseas",
  "rising sun",
  "important place",
  "memorable",
  "sentimental",
  "wedding",
  "assess location",
  "business rating",
  "evaluate location",
  "place rating",
  "review location",
  "service rating",
  "bodywork",
  "deep tissue",
  "knead",
  "muscles",
  "reflexology",
  "reiki",
  "relieve",
  "rub",
  "shiatsu",
  "soft tissue",
  "sports massage",
  "curriculum",
  "syllabus",
  "device display",
  "stay_current_portrait",
  "home button",
  "gadgetry",
  "app install",
  "app promo",
  "install mobile",
  "phone download",
  "system upgrade",
  "open in phone",
  "open on device",
  "push to device",
  "send to mobile",
  "add to homescreen",
  "home screen",
  "homescreen add",
  "phone screen",
  "app blocking",
  "disallow",
  "capture media",
  "front facing camera",
  "fueling",
  "mobile charge",
  "communication app",
  "mobile check",
  "angled lines",
  "computer science",
  "function call",
  "... button",
  "device ui",
  "phone ui",
  "connection issue",
  "device unknown",
  "hand held device",
  "information needed",
  "mobile question",
  "portable device",
  "question mark inside rectangle",
  "status unknown",
  "unknown device",
  "edge detection",
  "screen edge",
  "screen sensitivity",
  "sensitivity levels",
  "touch edge",
  "touch sensitivity",
  "tactile",
  "instant access",
  "quick launch",
  "local share",
  "nearby sharing",
  "sharing content",
  "sharing files",
  "ad units",
  "body text",
  "message content",
  "ambient display",
  "ambient mode",
  "electronic ticket",
  "geyser",
  "topography",
  "clapboard",
  "showtime",
  "audio history",
  "played",
  "sounds played",
  "track history",
  "temperature setting",
  "far sight",
  "eco mode",
  "leaf shape",
  "griddle",
  "main course",
  "okonomiyaki",
  "pancake",
  "ball game",
  "outdoor sport",
  "padel",
  "padel tennis",
  "parking meter",
  "penalty",
  "uppercase p",
  "automative",
  "capital p",
  "valet",
  "transaction history",
  "financial instrument",
  "pickleball",
  "contrail",
  "vapour trail",
  "development environment",
  "play_area",
  "sandbox",
  "sandbox environment",
  "seesaw",
  "initialize",
  "reset all",
  "reset progress",
  "reset settings",
  "reset to default",
  "reset value",
  "revert changes",
  "synchronize data",
  "defence",
  "data transfer off",
  "local save off",
  "clock icon",
  "time elapsed",
  "timer icon",
  "audio bar",
  "sound bar",
  "indo",
  "bowl and chopsticks",
  "eating icon",
  "rice bowl",
  "sushi",
  "washoku",
  "dumpling",
  "salad",
  "western food",
  "full strength",
  "max bars",
  "bars icon",
  "connectivity icon",
  "mobile data icon",
  "signal icon",
  "signal strength icon",
  "wireless icon",
  "cell bars",
  "phone status",
  "5 bars",
  "full reception",
  "indicator bar",
  "signal bar",
  "communication signal",
  "excellent signal",
  "lost signal",
  "dual sim",
  "two sim",
  "phone bars",
  "connectivity bars",
  "dual network",
  "multi network",
  "multi sim",
  "network bars",
  "two network",
  "three bars signal",
  "private connection",
  "secured network",
  "transmitter",
  "public network",
  "system icons",
  "move to top",
  "layers up",
  "move layer up",
  "multiple layers",
  "stack up",
  "battery empty",
  "fifth",
  "frame six",
  "framed",
  "horizontal rectangle",
  "loaded",
  "add charge",
  "add energy",
  "add power",
  "no battery",
  "lunchbox",
  "packed lunch",
  "approved date",
  "calendar with check",
  "confirmed date",
  "date with check",
  "event date",
  "schedule date",
  "adorable",
  "headwear",
  "innocence",
  "speak bubble",
  "cherry blossom",
  "dango",
  "dumplings",
  "hanami",
  "mitarashi",
  "sweet treat",
  "add image",
  "add media",
  "add photo",
  "add picture",
  "add to gallery",
  "embed image",
  "embed photo",
  "embed picture",
  "image inset",
  "media embed",
  "media inset",
  "upload photo",
  "upload picture",
  "kanji",
  "logogram",
  "sake",
  "encrypted email",
  "guarded mail",
  "message security",
  "secure mail",
  "banquet",
  "dining icon",
  "supper",
  "catering service",
  "midday meal",
  "baby dining",
  "baby friendly",
  "child dining",
  "family dining",
  "filled icon",
  "parent dining",
  "two adults and one child",
  "money saving",
  "percent sign",
  "percentage symbol",
  "price reduction",
  "reduced price",
  "bench",
  "eating area",
  "expressway",
  "motorway",
  "picnic table",
  "pull over",
  "relaxation spot",
  "rest stop",
  "roadside stop",
  "serve area",
  "stopover",
  "toothed wheel",
  "shaved ice",
  "snow cone",
  "adjustment icon",
  "apparatus icon",
  "cog icon",
  "configuration icon",
  "gear icon",
  "management icon",
  "mechanical icon",
  "preferences icon",
  "tools icon",
  "one person",
  "solo dining",
  "reserved",
  "table sign",
  "order online",
  "prepared food",
  "take away",
  "cushion",
  "floor cushion",
  "floor seating",
  "furniture layout",
  "mat",
  "tatami",
  "appraisal",
  "great",
  "two thumbs up",
  "asian noodles",
  "asian restaurant",
  "hot food",
  "japanese restaurant",
  "noodle bowl",
  "udon noodles",
  "clear visibility",
  "front window",
  "grilled beef",
  "grilled chicken",
  "grilled meat",
  "grilled vegetables",
  "kushiyaki",
  "meat on a stick",
  "street food",
  "three pieces",
  "yakitori",
  "handheld device",
  "prohibited symbol",
  "robbery",
  "steal",
  "stealing",
  "stolen",
  "broken line",
  "frame bug",
  "glitch",
  "quality assurance",
  "succeed",
  "archived",
  "stacks",
  "aiming",
  "cupid",
  "relove",
  "locked watch",
  "left right",
  "round button",
  "L1",
  "L2",
  "bumper",
  "shoulder button",
  "game pad",
  "top button",
  "controller button",
  "game control",
  "gamer",
  "gaming accessory",
  "l1",
  "left button",
  "left trigger",
  "shoulder trigger",
  "trigger button",
  "dualsense",
  "dualshock",
  "gaming button",
  "l2",
  "r button",
  "right button",
  "game button",
  "gameplay",
  "r1",
  "r1 button",
  "right trigger",
  "r2",
  "action button",
  "zl",
  "electronic game",
  "zr",
  "console button",
  "console controller",
  "console trigger",
  "game trigger",
  "gaming trigger",
  "gaming controls",
  "bordered",
  "digital pad",
  "control pad",
  "cross button",
  "directional button",
  "directional control",
  "crossing",
  "immigration",
  "passbook",
  "add element",
  "add object",
  "circle in square",
  "juxtaposition",
  "layered shapes",
  "square and circle",
  "circle in triangle",
  "circle inside",
  "monogram",
  "y",
  "eyebrow",
  "behind",
  "bring to back",
  "image alignment",
  "image layout",
  "image position",
  "rich text editor",
  "visual structure",
  "format image",
  "l axis",
  "l3",
  "left stick",
  "nintendo",
  "thumbstick",
  "directional input",
  "left controller",
  "r3",
  "r3 button",
  "r3 input",
  "right stick",
  "gui",
  "flirt",
  "kiss",
  "sensual",
  "sexy",
  "audio alert",
  "audio notification",
  "mute icon",
  "notification speaker",
  "ring icon",
  "ring sound",
  "silent icon",
  "sound notification",
  "alert control",
  "alert mute",
  "bell with cross",
  "no volume",
  "ring off",
  "ringtone off",
  "speaker disabled",
  "speaker with cross",
  "volume disabled",
  "adhesive",
  "corner down",
  "corner lift",
  "corner peel",
  "corner up",
  "curled corner",
  "curled up",
  "decal",
  "lifted corner",
  "peeling",
  "pointed corner",
  "bent corner",
  "peel sticker",
  "blink",
  "closed eye",
  "eyelashes",
  "eyelid",
  "facial feature",
  "open eye",
  "wink",
  "call disabled",
  "conversation off",
  "disabled voice call",
  "disabled voice chat",
  "microphone disabled",
  "muted conversation",
  "muted voice call",
  "muted voice chat",
  "no voice call",
  "no voice chat",
  "speech disabled",
  "voice call off",
  "voice chat off",
  "general menu",
  "widget menu",
  "valley",
];


/// This map contains the metadata for all Material Symbols icons.
/// The keys are the icon's dart symbol name and the values are SymbolsMetadata objects that contain the metadata.
/// The metadata includes the original name, popularity, codepoint, categories, tags, and whether the icon is RTL auto-mirrored.
Map<String, SymbolsMetadata> iconMap = {
  "ten_k": SymbolsMetadata(
    originalName: "10k",
    popularity: 208,
    codepoint: 0xe951,
    categories: [0],
    tags: [
      0,
      1,
      2,
      3,
      4,
      5,
      6,
      7,
      8,
      9,
      10,
      11,
      12,
      13,
      14,
      15,
      16,
      17,
      18,
      19,
      20,
      21,
      22,
      23,
      24,
      25,
      26,
      27,
      28,
      29,
      30,
      31,
      32,
      33,
      34,
      35,
      36,
      37
    ],
  ),
  "ten_mp": SymbolsMetadata(
    originalName: "10mp",
    popularity: 116,
    codepoint: 0xe952,
    categories: [1],
    tags: [
      38,
      39,
      40,
      41,
      42,
      43,
      44,
      45,
      8,
      46,
      47,
      12,
      48,
      49,
      50,
      51,
      52,
      53,
      16,
      54,
      55,
      56,
      22,
      23,
      57,
      58,
      59,
      60,
      61,
      62,
      24,
      25,
      63,
      28,
      64,
      31,
      65,
      32,
      33,
      35
    ],
  ),
  "eleven_mp": SymbolsMetadata(
    originalName: "11mp",
    popularity: 91,
    codepoint: 0xe953,
    categories: [1],
    tags: [
      66,
      40,
      43,
      44,
      45,
      8,
      67,
      12,
      49,
      51,
      68,
      15,
      16,
      17,
      54,
      55,
      18,
      56,
      21,
      22,
      69,
      70,
      57,
      59,
      24,
      25,
      63,
      28,
      71,
      31,
      33,
      35
    ],
  ),
  "onetwothree": SymbolsMetadata(
    originalName: "123",
    popularity: 2282,
    codepoint: 0xeb8d,
    categories: [2],
    tags: [
      72,
      73,
      74,
      75,
      76,
      77,
      78,
      79,
      80,
      81,
      7,
      82,
      83,
      84,
      85,
      86,
      87,
      88,
      89,
      22,
      23,
      90,
      91,
      92,
      93,
      94,
      95,
      96,
      31,
      97,
      98
    ],
  ),
  "twelve_mp": SymbolsMetadata(
    originalName: "12mp",
    popularity: 112,
    codepoint: 0xe954,
    categories: [1],
    tags: [
      99,
      100,
      101,
      40,
      102,
      103,
      104,
      7,
      105,
      45,
      12,
      48,
      49,
      106,
      107,
      68,
      52,
      16,
      108,
      54,
      55,
      56,
      21,
      22,
      23,
      109,
      110,
      59,
      61,
      111,
      24,
      25,
      63,
      28,
      31,
      33,
      35,
      112,
      113,
      114,
      115
    ],
  ),
  "thirteen_mp": SymbolsMetadata(
    originalName: "13mp",
    popularity: 98,
    codepoint: 0xe955,
    categories: [1],
    tags: [
      116,
      117,
      40,
      118,
      119,
      120,
      121,
      45,
      47,
      12,
      48,
      49,
      122,
      123,
      124,
      50,
      16,
      54,
      55,
      56,
      22,
      125,
      58,
      126,
      59,
      127,
      128,
      24,
      25,
      63,
      28,
      129,
      31,
      130,
      33,
      131,
      132,
      35
    ],
  ),
  "fourteen_mp": SymbolsMetadata(
    originalName: "14mp",
    popularity: 92,
    codepoint: 0xe956,
    categories: [1],
    tags: [
      133,
      134,
      40,
      120,
      135,
      43,
      44,
      45,
      12,
      136,
      137,
      48,
      138,
      49,
      106,
      50,
      53,
      16,
      54,
      55,
      56,
      22,
      57,
      58,
      59,
      62,
      24,
      25,
      63,
      28,
      64,
      139,
      31,
      140,
      33,
      35,
      141
    ],
  ),
  "fifteen_mp": SymbolsMetadata(
    originalName: "15mp",
    popularity: 96,
    codepoint: 0xe957,
    categories: [1],
    tags: [
      142,
      143,
      144,
      40,
      81,
      145,
      44,
      45,
      8,
      146,
      147,
      12,
      49,
      51,
      68,
      52,
      15,
      16,
      54,
      55,
      148,
      18,
      56,
      21,
      22,
      149,
      57,
      59,
      24,
      25,
      150,
      63,
      28,
      64,
      151,
      139,
      31,
      33,
      35,
      152,
      36
    ],
  ),
  "sixteen_mp": SymbolsMetadata(
    originalName: "16mp",
    popularity: 94,
    codepoint: 0xe958,
    categories: [1],
    tags: [
      153,
      154,
      40,
      155,
      119,
      120,
      156,
      121,
      157,
      45,
      12,
      49,
      122,
      158,
      106,
      159,
      16,
      54,
      160,
      55,
      56,
      161,
      22,
      162,
      109,
      110,
      163,
      59,
      164,
      127,
      24,
      25,
      63,
      28,
      129,
      165,
      166,
      167,
      31,
      33,
      35
    ],
  ),
  "seventeen_mp": SymbolsMetadata(
    originalName: "17mp",
    popularity: 87,
    codepoint: 0xe959,
    categories: [1],
    tags: [
      168,
      40,
      169,
      170,
      45,
      171,
      12,
      172,
      49,
      173,
      52,
      16,
      174,
      17,
      54,
      55,
      56,
      175,
      176,
      22,
      177,
      149,
      69,
      178,
      24,
      25,
      63,
      26,
      179,
      28,
      180,
      181,
      31,
      182,
      33,
      35,
      152,
      36
    ],
  ),
  "eighteen_up_rating": SymbolsMetadata(
    originalName: "18_up_rating",
    popularity: 452,
    codepoint: 0xf8fd,
    categories: [3],
    tags: [
      183,
      184,
      185,
      186,
      187,
      188,
      189,
      190,
      191,
      192,
      193,
      194,
      195,
      196,
      197,
      198,
      199,
      200,
      201,
      202,
      203,
      204,
      205,
      33,
      206
    ],
  ),
  "eighteen_mp": SymbolsMetadata(
    originalName: "18mp",
    popularity: 108,
    codepoint: 0xe95a,
    categories: [1],
    tags: [
      207,
      208,
      209,
      40,
      118,
      210,
      120,
      43,
      105,
      45,
      211,
      212,
      213,
      12,
      48,
      49,
      158,
      106,
      16,
      54,
      55,
      56,
      21,
      22,
      23,
      58,
      59,
      127,
      24,
      25,
      63,
      28,
      64,
      31,
      33,
      35
    ],
  ),
  "nineteen_mp": SymbolsMetadata(
    originalName: "19mp",
    popularity: 96,
    codepoint: 0xe95b,
    categories: [1],
    tags: [
      214,
      215,
      40,
      81,
      43,
      44,
      45,
      216,
      12,
      49,
      51,
      68,
      52,
      15,
      16,
      17,
      54,
      55,
      18,
      56,
      217,
      21,
      22,
      218,
      57,
      59,
      62,
      24,
      25,
      63,
      28,
      151,
      139,
      31,
      140,
      33,
      35,
      36
    ],
  ),
  "one_k": SymbolsMetadata(
    originalName: "1k",
    popularity: 137,
    codepoint: 0xe95c,
    categories: [0],
    tags: [
      219,
      220,
      221,
      222,
      4,
      223,
      5,
      80,
      224,
      81,
      7,
      8,
      225,
      12,
      51,
      14,
      52,
      16,
      226,
      18,
      21,
      22,
      69,
      23,
      24,
      25,
      26,
      203,
      28,
      227,
      228,
      229,
      31,
      33,
      34,
      230,
      35,
      152,
      36,
      37
    ],
  ),
  "one_k_plus": SymbolsMetadata(
    originalName: "1k_plus",
    popularity: 104,
    codepoint: 0xe95d,
    categories: [0],
    tags: [
      231,
      219,
      220,
      221,
      3,
      232,
      4,
      5,
      80,
      7,
      8,
      225,
      233,
      12,
      234,
      235,
      16,
      236,
      18,
      20,
      237,
      21,
      22,
      149,
      23,
      238,
      24,
      25,
      239,
      240,
      241,
      242,
      26,
      28,
      243,
      229,
      244,
      245,
      31,
      33,
      34,
      246,
      35,
      36,
      37,
      247
    ],
  ),
  "one_x_mobiledata": SymbolsMetadata(
    originalName: "1x_mobiledata",
    popularity: 352,
    codepoint: 0xefcd,
    categories: [4],
    tags: [
      248,
      249,
      4,
      250,
      251,
      252,
      5,
      253,
      254,
      255,
      256,
      257,
      258,
      7,
      12,
      259,
      16,
      260,
      261,
      262,
      263,
      264,
      265,
      266,
      267,
      268,
      269,
      270,
      22,
      271,
      272,
      273,
      274,
      275,
      31,
      276,
      33,
      35,
      277,
      278,
      279,
      280
    ],
  ),
  "one_x_mobiledata_badge": SymbolsMetadata(
    originalName: "1x_mobiledata_badge",
    popularity: 15,
    codepoint: 0xf7f1,
    categories: [4],
    tags: [
      248,
      4,
      281,
      282,
      251,
      252,
      5,
      193,
      283,
      284,
      254,
      285,
      286,
      287,
      288,
      7,
      12,
      172,
      51,
      259,
      52,
      15,
      16,
      262,
      263,
      266,
      267,
      21,
      22,
      289,
      271,
      273,
      290,
      275,
      291,
      31,
      65,
      276,
      33,
      35,
      277,
      278
    ],
  ),
  "twenty_mp": SymbolsMetadata(
    originalName: "20mp",
    popularity: 97,
    codepoint: 0xe95e,
    categories: [1],
    tags: [
      292,
      40,
      43,
      44,
      45,
      8,
      12,
      49,
      51,
      293,
      68,
      52,
      16,
      54,
      55,
      18,
      56,
      22,
      69,
      294,
      57,
      59,
      295,
      296,
      297,
      62,
      24,
      25,
      63,
      28,
      151,
      298,
      139,
      31,
      33,
      299,
      35,
      36
    ],
  ),
  "twenty_one_mp": SymbolsMetadata(
    originalName: "21mp",
    popularity: 87,
    codepoint: 0xe95f,
    categories: [1],
    tags: [
      300,
      301,
      40,
      302,
      135,
      43,
      303,
      45,
      12,
      304,
      48,
      49,
      50,
      51,
      52,
      16,
      54,
      55,
      56,
      22,
      58,
      305,
      59,
      127,
      24,
      25,
      63,
      28,
      151,
      31,
      33,
      306,
      35
    ],
  ),
  "twenty_two_mp": SymbolsMetadata(
    originalName: "22mp",
    popularity: 117,
    codepoint: 0xe960,
    categories: [1],
    tags: [
      307,
      40,
      308,
      193,
      309,
      284,
      310,
      311,
      81,
      312,
      45,
      313,
      314,
      315,
      316,
      317,
      12,
      318,
      319,
      320,
      321,
      49,
      322,
      259,
      16,
      323,
      324,
      174,
      54,
      55,
      56,
      325,
      267,
      22,
      326,
      24,
      25,
      327,
      328,
      329,
      63,
      28,
      330,
      331,
      31,
      33,
      332,
      35,
      333,
      334
    ],
  ),
  "twenty_three_mp": SymbolsMetadata(
    originalName: "23mp",
    popularity: 95,
    codepoint: 0xe961,
    categories: [1],
    tags: [
      335,
      336,
      40,
      135,
      43,
      44,
      45,
      12,
      48,
      49,
      68,
      16,
      54,
      55,
      56,
      22,
      69,
      57,
      59,
      62,
      24,
      25,
      63,
      28,
      64,
      151,
      337,
      31,
      140,
      33,
      35,
      338
    ],
  ),
  "twenty_four_fps_select": SymbolsMetadata(
    originalName: "24fps_select",
    popularity: 7,
    codepoint: 0xf3f2,
    categories: [1],
    tags: [
      339,
      340,
      341,
      40,
      342,
      343,
      344,
      345,
      45,
      346,
      347,
      348,
      349,
      350,
      351,
      49,
      352,
      353,
      354,
      22,
      355,
      356,
      357,
      358,
      359,
      360,
      361,
      362,
      363,
      151,
      37,
      364,
      365,
      366,
      113,
      115,
      367,
      368
    ],
  ),
  "twenty_four_mp": SymbolsMetadata(
    originalName: "24mp",
    popularity: 125,
    codepoint: 0xe962,
    categories: [1],
    tags: [
      369,
      40,
      81,
      43,
      44,
      45,
      8,
      147,
      12,
      370,
      49,
      68,
      52,
      16,
      17,
      54,
      55,
      18,
      56,
      21,
      22,
      355,
      57,
      59,
      24,
      25,
      63,
      28,
      151,
      298,
      139,
      31,
      140,
      33,
      371,
      35
    ],
  ),
  "twod": SymbolsMetadata(
    originalName: "2d",
    popularity: 21,
    codepoint: 0xef37,
    categories: [0],
    tags: [
      372,
      4,
      5,
      373,
      374,
      375,
      7,
      376,
      377,
      378,
      379,
      380,
      12,
      381,
      137,
      382,
      383,
      384,
      385,
      16,
      324,
      17,
      22,
      386,
      387,
      388,
      389,
      390,
      391,
      392,
      393,
      31,
      33,
      394,
      395,
      35,
      396,
      397,
      398,
      399
    ],
  ),
  "two_k": SymbolsMetadata(
    originalName: "2k",
    popularity: 114,
    codepoint: 0xe963,
    categories: [0],
    tags: [
      400,
      401,
      402,
      222,
      4,
      5,
      403,
      7,
      8,
      12,
      404,
      405,
      14,
      15,
      16,
      406,
      407,
      354,
      21,
      22,
      23,
      355,
      24,
      25,
      408,
      409,
      63,
      28,
      410,
      71,
      411,
      31,
      412,
      33,
      413,
      35,
      37,
      113,
      115,
      367
    ],
  ),
  "two_k_plus": SymbolsMetadata(
    originalName: "2k_plus",
    popularity: 94,
    codepoint: 0xe964,
    categories: [0],
    tags: [
      231,
      414,
      415,
      402,
      416,
      417,
      4,
      5,
      135,
      104,
      7,
      44,
      8,
      12,
      370,
      418,
      419,
      16,
      407,
      420,
      22,
      127,
      408,
      239,
      421,
      28,
      422,
      411,
      423,
      31,
      33,
      424,
      425,
      426,
      35,
      427,
      428,
      113,
      367,
      429
    ],
  ),
  "two_mp": SymbolsMetadata(
    originalName: "2mp",
    popularity: 95,
    codepoint: 0xe965,
    categories: [1],
    tags: [
      74,
      430,
      40,
      210,
      43,
      7,
      44,
      12,
      348,
      49,
      68,
      16,
      17,
      54,
      55,
      18,
      56,
      21,
      431,
      22,
      57,
      59,
      24,
      25,
      63,
      432,
      28,
      298,
      139,
      433,
      31,
      33,
      394,
      35,
      152,
      37,
      434
    ],
  ),
  "thirty_fps": SymbolsMetadata(
    originalName: "30fps",
    popularity: 170,
    codepoint: 0xefce,
    categories: [0],
    tags: [
      435,
      4,
      40,
      5,
      7,
      346,
      12,
      347,
      349,
      436,
      437,
      16,
      438,
      108,
      439,
      22,
      408,
      63,
      440,
      28,
      71,
      31,
      33,
      441,
      442,
      35,
      37,
      443,
      444,
      445,
      446,
      447,
      448,
      449,
      113,
      367,
      368
    ],
  ),
  "thirty_fps_select": SymbolsMetadata(
    originalName: "30fps_select",
    popularity: 160,
    codepoint: 0xefcf,
    categories: [1],
    tags: [
      340,
      435,
      40,
      42,
      450,
      451,
      45,
      347,
      348,
      349,
      452,
      350,
      351,
      49,
      406,
      353,
      22,
      355,
      356,
      408,
      63,
      359,
      453,
      440,
      360,
      361,
      362,
      363,
      151,
      71,
      275,
      454,
      411,
      37,
      455,
      113,
      456,
      457,
      368
    ],
  ),
  "threesixty": SymbolsMetadata(
    originalName: "360",
    popularity: 1891,
    codepoint: 0xe577,
    categories: [5],
    tags: [
      458,
      459,
      460,
      77,
      461,
      40,
      193,
      462,
      463,
      345,
      464,
      44,
      313,
      465,
      466,
      467,
      468,
      439,
      325,
      469,
      386,
      57,
      470,
      471,
      331,
      472,
      473,
      474,
      37,
      396,
      475,
      476,
      477,
      333
    ],
    rtlAutoMirrored: true,
  ),
  "threed": SymbolsMetadata(
    originalName: "3d",
    popularity: 17,
    codepoint: 0xed38,
    categories: [0],
    tags: [
      75,
      478,
      479,
      480,
      4,
      481,
      482,
      5,
      483,
      484,
      485,
      7,
      486,
      487,
      12,
      488,
      489,
      381,
      137,
      490,
      16,
      491,
      22,
      492,
      386,
      388,
      493,
      389,
      494,
      392,
      495,
      496,
      31,
      65,
      33,
      497,
      35,
      396,
      498,
      499,
      476,
      477
    ],
  ),
  "threed_rotation": SymbolsMetadata(
    originalName: "3d_rotation",
    popularity: 1222,
    codepoint: 0xe84d,
    categories: [6],
    tags: [
      75,
      478,
      479,
      4,
      500,
      501,
      77,
      502,
      461,
      503,
      504,
      40,
      5,
      345,
      7,
      12,
      137,
      16,
      505,
      506,
      491,
      22,
      492,
      355,
      507,
      386,
      494,
      508,
      470,
      471,
      392,
      509,
      496,
      472,
      31,
      33,
      497,
      510,
      511,
      512,
      513,
      35,
      396,
      499,
      514,
      477
    ],
  ),
  "three_g_mobiledata": SymbolsMetadata(
    originalName: "3g_mobiledata",
    popularity: 194,
    codepoint: 0xefd0,
    categories: [4],
    tags: [
      515,
      4,
      516,
      517,
      518,
      251,
      5,
      283,
      519,
      284,
      254,
      81,
      288,
      7,
      44,
      520,
      12,
      521,
      522,
      259,
      16,
      262,
      263,
      266,
      267,
      22,
      523,
      271,
      273,
      275,
      524,
      31,
      525,
      65,
      276,
      33,
      526,
      35,
      527,
      277,
      278
    ],
  ),
  "three_g_mobiledata_badge": SymbolsMetadata(
    originalName: "3g_mobiledata_badge",
    popularity: 6,
    codepoint: 0xf7f0,
    categories: [4],
    tags: [
      515,
      4,
      281,
      518,
      251,
      5,
      283,
      528,
      254,
      81,
      529,
      287,
      7,
      12,
      530,
      522,
      259,
      531,
      16,
      262,
      263,
      264,
      265,
      266,
      267,
      270,
      22,
      271,
      273,
      290,
      275,
      532,
      31,
      65,
      533,
      276,
      33,
      35,
      277,
      278
    ],
  ),
  "three_k": SymbolsMetadata(
    originalName: "3k",
    popularity: 86,
    codepoint: 0xe966,
    categories: [0],
    tags: [
      534,
      535,
      536,
      4,
      5,
      344,
      104,
      7,
      44,
      8,
      346,
      12,
      537,
      16,
      406,
      354,
      22,
      24,
      25,
      538,
      28,
      410,
      539,
      411,
      540,
      31,
      65,
      412,
      33,
      541,
      542,
      35,
      37,
      366,
      543,
      113,
      115,
      457
    ],
  ),
  "three_k_plus": SymbolsMetadata(
    originalName: "3k_plus",
    popularity: 88,
    codepoint: 0xe967,
    categories: [0],
    tags: [
      231,
      534,
      544,
      545,
      535,
      546,
      547,
      3,
      232,
      4,
      223,
      5,
      224,
      81,
      7,
      8,
      12,
      548,
      51,
      549,
      16,
      550,
      18,
      20,
      237,
      21,
      22,
      149,
      24,
      25,
      239,
      26,
      28,
      229,
      31,
      33,
      34,
      551,
      552,
      553,
      35,
      36,
      37,
      554
    ],
  ),
  "three_mp": SymbolsMetadata(
    originalName: "3mp",
    popularity: 97,
    codepoint: 0xe968,
    categories: [1],
    tags: [
      75,
      555,
      40,
      135,
      104,
      7,
      556,
      8,
      557,
      558,
      12,
      559,
      419,
      49,
      106,
      16,
      406,
      560,
      54,
      55,
      56,
      22,
      355,
      59,
      127,
      24,
      25,
      358,
      63,
      561,
      28,
      151,
      562,
      31,
      33,
      35,
      37,
      563,
      115
    ],
  ),
  "three_p": SymbolsMetadata(
    originalName: "3p",
    popularity: 1354,
    codepoint: 0xefd1,
    categories: [7],
    tags: [
      75,
      564,
      565,
      566,
      567,
      568,
      569,
      570,
      571,
      572,
      573,
      574,
      575,
      576,
      577,
      578,
      579,
      580,
      581,
      582,
      583,
      86,
      584,
      88,
      506,
      585,
      237,
      586,
      325,
      70,
      587,
      588,
      589,
      590,
      591,
      592,
      71,
      95,
      593,
      594,
      595,
      596,
      97,
      597
    ],
  ),
  "four_g_mobiledata": SymbolsMetadata(
    originalName: "4g_mobiledata",
    popularity: 340,
    codepoint: 0xefd2,
    categories: [4],
    tags: [
      598,
      4,
      516,
      251,
      252,
      5,
      283,
      284,
      254,
      81,
      7,
      599,
      12,
      600,
      601,
      522,
      602,
      51,
      259,
      16,
      603,
      262,
      263,
      266,
      267,
      604,
      22,
      271,
      273,
      275,
      291,
      31,
      605,
      33,
      35,
      606,
      277,
      278
    ],
  ),
  "four_g_mobiledata_badge": SymbolsMetadata(
    originalName: "4g_mobiledata_badge",
    popularity: 11,
    codepoint: 0xf7ef,
    categories: [4],
    tags: [
      598,
      4,
      281,
      282,
      251,
      5,
      607,
      284,
      608,
      288,
      7,
      44,
      8,
      12,
      138,
      51,
      68,
      259,
      52,
      16,
      603,
      262,
      263,
      266,
      267,
      609,
      22,
      271,
      359,
      273,
      275,
      291,
      31,
      65,
      605,
      33,
      35,
      277,
      278
    ],
  ),
  "four_g_plus_mobiledata": SymbolsMetadata(
    originalName: "4g_plus_mobiledata",
    popularity: 226,
    codepoint: 0xefd3,
    categories: [4],
    tags: [
      598,
      610,
      611,
      612,
      4,
      613,
      282,
      251,
      252,
      5,
      283,
      284,
      254,
      256,
      529,
      614,
      7,
      615,
      12,
      259,
      16,
      262,
      263,
      266,
      267,
      268,
      269,
      22,
      271,
      239,
      273,
      290,
      275,
      31,
      65,
      276,
      33,
      35,
      616,
      277,
      278,
      279
    ],
  ),
  "four_k": SymbolsMetadata(
    originalName: "4k",
    popularity: 363,
    codepoint: 0xe072,
    categories: [0],
    tags: [
      617,
      618,
      619,
      4,
      620,
      5,
      344,
      621,
      104,
      7,
      44,
      8,
      346,
      12,
      137,
      48,
      51,
      52,
      16,
      406,
      354,
      22,
      24,
      25,
      408,
      63,
      561,
      28,
      410,
      411,
      31,
      65,
      412,
      33,
      35,
      428,
      37
    ],
  ),
  "four_k_plus": SymbolsMetadata(
    originalName: "4k_plus",
    popularity: 164,
    codepoint: 0xe969,
    categories: [0],
    tags: [
      231,
      617,
      618,
      619,
      232,
      4,
      5,
      7,
      44,
      8,
      622,
      12,
      419,
      16,
      406,
      623,
      439,
      22,
      24,
      25,
      239,
      63,
      28,
      410,
      411,
      31,
      65,
      412,
      33,
      35,
      37
    ],
  ),
  "four_mp": SymbolsMetadata(
    originalName: "4mp",
    popularity: 87,
    codepoint: 0xe96a,
    categories: [1],
    tags: [
      624,
      625,
      626,
      40,
      135,
      81,
      43,
      7,
      486,
      8,
      12,
      627,
      49,
      51,
      68,
      52,
      16,
      17,
      628,
      54,
      55,
      148,
      18,
      56,
      22,
      57,
      59,
      62,
      24,
      25,
      63,
      28,
      151,
      298,
      139,
      31,
      33,
      35,
      476,
      629
    ],
  ),
  "five_0mp": SymbolsMetadata(
    originalName: "50mp",
    popularity: 30,
    codepoint: 0xf6f3,
    categories: [1],
    tags: [
      630,
      631,
      40,
      155,
      302,
      632,
      43,
      7,
      45,
      633,
      634,
      12,
      404,
      48,
      49,
      106,
      50,
      52,
      16,
      54,
      55,
      635,
      56,
      21,
      22,
      636,
      59,
      297,
      24,
      25,
      63,
      28,
      151,
      637,
      31,
      33,
      35
    ],
  ),
  "five_g": SymbolsMetadata(
    originalName: "5g",
    popularity: 605,
    codepoint: 0xef38,
    categories: [4],
    tags: [
      638,
      4,
      251,
      5,
      283,
      284,
      254,
      81,
      256,
      7,
      639,
      12,
      489,
      522,
      138,
      51,
      259,
      16,
      262,
      263,
      265,
      640,
      267,
      269,
      22,
      641,
      271,
      273,
      275,
      291,
      642,
      31,
      65,
      276,
      33,
      35,
      277,
      278,
      643
    ],
  ),
  "five_g_mobiledata_badge": SymbolsMetadata(
    originalName: "5g_mobiledata_badge",
    popularity: 17,
    codepoint: 0xf7ee,
    categories: [4],
    tags: [
      638,
      4,
      281,
      516,
      518,
      251,
      5,
      283,
      284,
      254,
      81,
      7,
      8,
      12,
      522,
      138,
      51,
      259,
      16,
      262,
      644,
      267,
      269,
      22,
      271,
      645,
      273,
      275,
      291,
      31,
      65,
      33,
      35,
      277,
      278
    ],
  ),
  "five_k": SymbolsMetadata(
    originalName: "5k",
    popularity: 98,
    codepoint: 0xe96b,
    categories: [0],
    tags: [
      646,
      647,
      648,
      4,
      5,
      135,
      649,
      104,
      43,
      7,
      8,
      650,
      651,
      652,
      12,
      370,
      419,
      404,
      16,
      420,
      22,
      24,
      25,
      653,
      654,
      28,
      422,
      423,
      31,
      33,
      35,
      427,
      655,
      37,
      656,
      113,
      115,
      367,
      657
    ],
  ),
  "five_k_plus": SymbolsMetadata(
    originalName: "5k_plus",
    popularity: 91,
    codepoint: 0xe96c,
    categories: [0],
    tags: [
      231,
      646,
      647,
      648,
      232,
      4,
      223,
      5,
      80,
      658,
      81,
      659,
      7,
      8,
      660,
      652,
      12,
      16,
      550,
      661,
      18,
      662,
      663,
      21,
      664,
      22,
      23,
      665,
      666,
      24,
      25,
      239,
      240,
      26,
      667,
      28,
      229,
      668,
      31,
      33,
      34,
      553,
      35,
      36,
      37
    ],
  ),
  "five_mp": SymbolsMetadata(
    originalName: "5mp",
    popularity: 98,
    codepoint: 0xe96d,
    categories: [1],
    tags: [
      669,
      670,
      40,
      42,
      135,
      43,
      7,
      44,
      660,
      671,
      12,
      49,
      51,
      68,
      16,
      54,
      55,
      56,
      21,
      22,
      355,
      641,
      57,
      59,
      62,
      24,
      25,
      63,
      28,
      64,
      151,
      298,
      139,
      433,
      31,
      65,
      33,
      35,
      37,
      434
    ],
  ),
  "sixty_fps": SymbolsMetadata(
    originalName: "60fps",
    popularity: 194,
    codepoint: 0xefd4,
    categories: [0],
    tags: [
      672,
      40,
      42,
      344,
      345,
      104,
      7,
      8,
      673,
      346,
      347,
      349,
      437,
      522,
      51,
      52,
      406,
      21,
      22,
      69,
      355,
      641,
      408,
      674,
      63,
      440,
      28,
      71,
      675,
      411,
      31,
      33,
      37,
      113
    ],
  ),
  "sixty_fps_select": SymbolsMetadata(
    originalName: "60fps_select",
    popularity: 166,
    codepoint: 0xefd5,
    categories: [1],
    tags: [
      676,
      672,
      40,
      677,
      193,
      462,
      678,
      345,
      45,
      346,
      347,
      348,
      349,
      350,
      351,
      51,
      52,
      406,
      679,
      354,
      21,
      22,
      69,
      355,
      356,
      641,
      408,
      358,
      63,
      359,
      360,
      361,
      362,
      363,
      71,
      275,
      33,
      37,
      366,
      367
    ],
  ),
  "six_ft_apart": SymbolsMetadata(
    originalName: "6_ft_apart",
    popularity: 445,
    codepoint: 0xf21e,
    categories: [3],
    tags: [
      680,
      681,
      682,
      683,
      684,
      685,
      686,
      687,
      9,
      688,
      689,
      690,
      691,
      692,
      583,
      693,
      226,
      694,
      589,
      590,
      695,
      696,
      697,
      698,
      699,
      700,
      701,
      702,
      703,
      704,
      705,
      706,
      707,
      708,
      709
    ],
  ),
  "six_k": SymbolsMetadata(
    originalName: "6k",
    popularity: 93,
    codepoint: 0xe96e,
    categories: [0],
    tags: [
      710,
      711,
      712,
      4,
      5,
      135,
      104,
      43,
      7,
      44,
      8,
      713,
      12,
      370,
      419,
      48,
      51,
      16,
      406,
      354,
      439,
      22,
      355,
      24,
      25,
      408,
      714,
      63,
      28,
      410,
      151,
      411,
      31,
      412,
      33,
      35,
      37,
      113,
      476
    ],
  ),
  "six_k_plus": SymbolsMetadata(
    originalName: "6k_plus",
    popularity: 88,
    codepoint: 0xe96f,
    categories: [0],
    tags: [
      231,
      710,
      711,
      712,
      3,
      4,
      223,
      715,
      281,
      5,
      224,
      81,
      7,
      8,
      716,
      12,
      548,
      51,
      52,
      16,
      17,
      18,
      20,
      717,
      663,
      21,
      22,
      149,
      666,
      24,
      25,
      239,
      240,
      26,
      28,
      718,
      229,
      31,
      33,
      553,
      35,
      36,
      37
    ],
  ),
  "six_mp": SymbolsMetadata(
    originalName: "6mp",
    popularity: 92,
    codepoint: 0xe970,
    categories: [1],
    tags: [
      680,
      40,
      719,
      155,
      120,
      720,
      7,
      157,
      558,
      12,
      48,
      49,
      158,
      721,
      106,
      50,
      16,
      54,
      55,
      148,
      56,
      22,
      70,
      722,
      723,
      109,
      126,
      59,
      724,
      725,
      24,
      25,
      63,
      654,
      561,
      28,
      726,
      151,
      31,
      33,
      35
    ],
  ),
  "seven_k": SymbolsMetadata(
    originalName: "7k",
    popularity: 106,
    codepoint: 0xe971,
    categories: [0],
    tags: [
      727,
      728,
      222,
      4,
      729,
      730,
      5,
      621,
      194,
      104,
      7,
      8,
      731,
      12,
      419,
      48,
      16,
      406,
      732,
      22,
      733,
      24,
      25,
      63,
      28,
      734,
      735,
      562,
      411,
      31,
      736,
      33,
      737,
      738,
      739,
      35,
      37,
      115
    ],
  ),
  "seven_k_plus": SymbolsMetadata(
    originalName: "7k_plus",
    popularity: 88,
    codepoint: 0xe972,
    categories: [0],
    tags: [
      231,
      727,
      740,
      741,
      728,
      742,
      3,
      743,
      232,
      4,
      223,
      5,
      80,
      224,
      81,
      7,
      8,
      12,
      235,
      51,
      52,
      16,
      174,
      17,
      18,
      20,
      663,
      21,
      22,
      24,
      25,
      239,
      26,
      203,
      28,
      228,
      744,
      31,
      33,
      553,
      230,
      35,
      36,
      37
    ],
  ),
  "seven_mp": SymbolsMetadata(
    originalName: "7mp",
    popularity: 96,
    codepoint: 0xe973,
    categories: [1],
    tags: [
      745,
      746,
      747,
      341,
      748,
      749,
      40,
      193,
      462,
      284,
      750,
      751,
      752,
      81,
      7,
      753,
      12,
      49,
      51,
      259,
      16,
      754,
      755,
      54,
      55,
      56,
      267,
      22,
      24,
      25,
      756,
      757,
      63,
      758,
      759,
      28,
      760,
      330,
      761,
      31,
      762,
      763,
      33,
      35,
      764
    ],
  ),
  "eight_k": SymbolsMetadata(
    originalName: "8k",
    popularity: 150,
    codepoint: 0xe974,
    categories: [0],
    tags: [
      765,
      766,
      767,
      4,
      5,
      768,
      7,
      8,
      769,
      12,
      419,
      16,
      770,
      420,
      771,
      22,
      69,
      24,
      25,
      772,
      63,
      28,
      773,
      423,
      31,
      33,
      35,
      427,
      774,
      655,
      37,
      775,
      113,
      115,
      367,
      776,
      657
    ],
  ),
  "eight_k_plus": SymbolsMetadata(
    originalName: "8k_plus",
    popularity: 113,
    codepoint: 0xe975,
    categories: [0],
    tags: [
      231,
      727,
      766,
      767,
      777,
      4,
      5,
      344,
      778,
      104,
      7,
      44,
      8,
      713,
      779,
      12,
      419,
      49,
      16,
      406,
      623,
      22,
      62,
      24,
      25,
      408,
      239,
      63,
      28,
      410,
      637,
      411,
      31,
      65,
      412,
      33,
      35,
      427,
      655,
      37,
      113,
      780,
      476
    ],
  ),
  "eight_mp": SymbolsMetadata(
    originalName: "8mp",
    popularity: 94,
    codepoint: 0xe976,
    categories: [1],
    tags: [
      781,
      782,
      40,
      42,
      43,
      288,
      7,
      44,
      46,
      12,
      49,
      53,
      16,
      54,
      55,
      56,
      21,
      22,
      641,
      57,
      59,
      24,
      25,
      63,
      28,
      64,
      139,
      31,
      33,
      35
    ],
  ),
  "nine_k": SymbolsMetadata(
    originalName: "9k",
    popularity: 104,
    codepoint: 0xe977,
    categories: [0],
    tags: [
      783,
      784,
      785,
      4,
      5,
      135,
      621,
      104,
      7,
      44,
      8,
      12,
      419,
      51,
      52,
      16,
      786,
      406,
      623,
      354,
      787,
      22,
      641,
      24,
      25,
      408,
      63,
      203,
      28,
      410,
      139,
      454,
      31,
      182,
      140,
      412,
      33,
      35,
      37
    ],
  ),
  "nine_k_plus": SymbolsMetadata(
    originalName: "9k_plus",
    popularity: 104,
    codepoint: 0xe978,
    categories: [0],
    tags: [
      231,
      783,
      784,
      785,
      3,
      4,
      223,
      788,
      789,
      5,
      80,
      81,
      7,
      8,
      622,
      12,
      51,
      16,
      790,
      550,
      791,
      17,
      18,
      20,
      663,
      21,
      22,
      666,
      641,
      24,
      25,
      239,
      792,
      793,
      203,
      28,
      31,
      33,
      553,
      35,
      36,
      37
    ],
  ),
  "nine_mp": SymbolsMetadata(
    originalName: "9mp",
    popularity: 102,
    codepoint: 0xe979,
    categories: [1],
    tags: [
      794,
      795,
      796,
      797,
      40,
      102,
      119,
      120,
      7,
      105,
      557,
      47,
      12,
      370,
      49,
      798,
      799,
      106,
      16,
      54,
      55,
      56,
      800,
      801,
      22,
      802,
      109,
      126,
      59,
      127,
      24,
      25,
      63,
      654,
      561,
      28,
      129,
      803,
      31,
      33,
      35,
      113,
      115,
      804,
      434
    ],
  ),
  "abc": SymbolsMetadata(
    popularity: 1502,
    codepoint: 0xeb94,
    categories: [2],
    tags: [
      805,
      4,
      806,
      807,
      5,
      808,
      778,
      809,
      810,
      12,
      811,
      16,
      812,
      813,
      814,
      815,
      816,
      817,
      818,
      819,
      820,
      707,
      31,
      33,
      821,
      35,
      822,
      823,
      824,
      825,
      826,
      827,
      828,
      829,
      830,
      831,
      832
    ],
  ),
  "ac_unit": SymbolsMetadata(
    popularity: 3165,
    codepoint: 0xeb3b,
    categories: [8],
    tags: [
      833,
      834,
      835,
      836,
      837,
      838,
      839,
      840,
      345,
      841,
      842,
      843,
      844,
      845,
      846,
      847,
      328,
      848,
      849,
      850,
      851,
      852,
      853,
      854,
      855,
      152,
      856,
      857
    ],
  ),
  "accessibility": SymbolsMetadata(
    popularity: 1983,
    codepoint: 0xe84e,
    categories: [6],
    tags: [
      858,
      859,
      860,
      861,
      862,
      863,
      864,
      865,
      684,
      866,
      867,
      868,
      869,
      870,
      225,
      871,
      872,
      873,
      583,
      138,
      874,
      875,
      70,
      589,
      590,
      876,
      71,
      877,
      878,
      31,
      879
    ],
  ),
  "accessibility_new": SymbolsMetadata(
    popularity: 3583,
    codepoint: 0xe92c,
    categories: [6],
    tags: [
      858,
      860,
      880,
      861,
      881,
      865,
      684,
      882,
      678,
      866,
      867,
      225,
      871,
      873,
      583,
      138,
      883,
      884,
      68,
      885,
      506,
      886,
      887,
      70,
      289,
      589,
      590,
      71,
      888,
      31,
      889,
      890,
      891,
      892,
      893
    ],
  ),
  "accessible": SymbolsMetadata(
    popularity: 2280,
    codepoint: 0xe914,
    categories: [6],
    tags: [
      858,
      860,
      861,
      865,
      684,
      485,
      866,
      867,
      216,
      225,
      871,
      692,
      873,
      583,
      138,
      894,
      874,
      895,
      896,
      325,
      875,
      70,
      589,
      590,
      591,
      897,
      71,
      898,
      878,
      31,
      879,
      597,
      899
    ],
  ),
  "accessible_forward": SymbolsMetadata(
    popularity: 1142,
    codepoint: 0xe934,
    categories: [6],
    tags: [
      860,
      861,
      77,
      900,
      684,
      313,
      866,
      867,
      901,
      225,
      902,
      903,
      871,
      873,
      583,
      138,
      896,
      586,
      468,
      904,
      589,
      590,
      905,
      906,
      757,
      897,
      907,
      888,
      31,
      597,
      908,
      909,
      899
    ],
  ),
  "accessible_menu": SymbolsMetadata(
    popularity: 19,
    codepoint: 0xf34e,
    categories: [2],
    tags: [
      860,
      910,
      684,
      482,
      193,
      145,
      866,
      870,
      225,
      578,
      583,
      68,
      88,
      506,
      325,
      70,
      589,
      590,
      911,
      912,
      591,
      71,
      433,
      97,
      597
    ],
  ),
  "account_balance": SymbolsMetadata(
    popularity: 11723,
    codepoint: 0xe84f,
    categories: [9],
    tags: [
      565,
      913,
      914,
      915,
      916,
      917,
      918,
      919,
      920,
      921,
      922,
      923,
      924,
      925,
      926,
      927,
      928,
      929,
      930,
      931,
      932,
      933,
      934,
      935,
      936,
      937,
      938,
      939,
      523,
      940,
      941,
      942,
      943,
      944,
      945,
      946,
      947,
      948
    ],
  ),
  "account_balance_wallet": SymbolsMetadata(
    popularity: 10305,
    codepoint: 0xe850,
    categories: [9],
    tags: [
      565,
      913,
      914,
      915,
      916,
      917,
      949,
      950,
      920,
      921,
      922,
      924,
      926,
      951,
      927,
      952,
      928,
      953,
      954,
      931,
      955,
      932,
      956,
      957,
      958,
      938,
      523,
      940,
      941,
      959,
      960,
      961,
      944,
      962,
      946,
      963,
      948
    ],
  ),
  "account_box": SymbolsMetadata(
    popularity: 5325,
    codepoint: 0xe851,
    categories: [6],
    tags: [
      565,
      964,
      566,
      482,
      965,
      966,
      967,
      576,
      225,
      968,
      583,
      969,
      970,
      971,
      972,
      289,
      589,
      590,
      973,
      911,
      974,
      975,
      591,
      976,
      432,
      977,
      392,
      978,
      979,
      433,
      980,
      597,
      981
    ],
  ),
  "account_child": SymbolsMetadata(
    popularity: 57,
    codepoint: 0xe852,
    categories: [6],
    tags: [
      565,
      982,
      566,
      983,
      684,
      984,
      985,
      986,
      987,
      193,
      988,
      989,
      990,
      872,
      583,
      991,
      992,
      993,
      994,
      589,
      590,
      591,
      995,
      996,
      978,
      997,
      597,
      998,
      999,
      1000
    ],
  ),
  "account_child_invert": SymbolsMetadata(
    popularity: 99,
    codepoint: 0xe659,
    categories: [6],
    tags: [
      858,
      565,
      566,
      684,
      984,
      987,
      193,
      678,
      1001,
      990,
      872,
      583,
      969,
      1002,
      991,
      1003,
      971,
      1004,
      1005,
      1006,
      289,
      1007,
      589,
      590,
      1008,
      1009,
      591,
      1010,
      1011,
      71,
      1012,
      978,
      1013,
      597,
      999
    ],
  ),
  "account_circle": SymbolsMetadata(
    popularity: 67766,
    codepoint: 0xe853,
    categories: [6],
    tags: [
      565,
      1014,
      1015,
      1016,
      1017,
      1018,
      1019,
      566,
      1020,
      193,
      576,
      872,
      583,
      969,
      971,
      1021,
      589,
      590,
      911,
      975,
      591,
      976,
      1022,
      1012,
      1023,
      1024,
      1025,
      978,
      980,
      597,
      1026,
      1027
    ],
  ),
  "account_circle_off": SymbolsMetadata(
    popularity: 74,
    codepoint: 0xf7b3,
    categories: [6],
    tags: [
      858,
      1028,
      565,
      1029,
      1019,
      1030,
      566,
      1020,
      193,
      1031,
      867,
      1032,
      1033,
      576,
      872,
      583,
      969,
      971,
      1034,
      1035,
      1036,
      1037,
      289,
      589,
      590,
      975,
      591,
      1038,
      1039,
      1040,
      1022,
      1012,
      978,
      1041,
      980,
      1042,
      597,
      1043
    ],
  ),
  "account_tree": SymbolsMetadata(
    popularity: 7478,
    codepoint: 0xe97a,
    categories: [9],
    tags: [
      565,
      1044,
      1045,
      1046,
      373,
      1047,
      1048,
      1049,
      1050,
      81,
      375,
      1051,
      1052,
      1053,
      1054,
      1055,
      1056,
      1057,
      1058,
      1004,
      1059,
      226,
      1060,
      1061,
      267,
      1062,
      1063,
      1064,
      289,
      1065,
      1066,
      1067,
      433,
      744,
      945,
      1068,
      1069,
      1070,
      1071,
      1072,
      1073
    ],
  ),
  "action_key": SymbolsMetadata(
    popularity: 171,
    codepoint: 0xf502,
    categories: [2],
    tags: [
      746,
      501,
      1074,
      504,
      1075,
      1076,
      1077,
      1078,
      519,
      1079,
      345,
      1080,
      288,
      1081,
      1082,
      1083,
      83,
      317,
      1084,
      1085,
      382,
      1086,
      1087,
      1088,
      1089,
      1090,
      1091,
      1092,
      1093,
      1094,
      904,
      1095,
      294,
      1096,
      1097,
      1098,
      1099,
      1100,
      1101,
      1102,
      1103,
      362,
      1104,
      509,
      65
    ],
  ),
  "activity_zone": SymbolsMetadata(
    popularity: 456,
    codepoint: 0xe1e6,
    categories: [10],
    tags: [
      1105,
      1106,
      1107,
      1108,
      1109,
      482,
      1110,
      1111,
      1112,
      1113,
      1114,
      348,
      1115,
      1116,
      1117,
      1118,
      786,
      1119,
      1120,
      289,
      1121,
      1122,
      1123,
      1124,
      432,
      1125,
      1126,
      1127,
      1011,
      1128,
      363,
      1129,
      1130,
      1131,
      1132
    ],
  ),
  "acute": SymbolsMetadata(
    popularity: 332,
    codepoint: 0xe4cb,
    categories: [2],
    tags: [
      480,
      1133,
      1134,
      500,
      77,
      1135,
      1136,
      1137,
      1138,
      313,
      1139,
      1140,
      1141,
      1142,
      692,
      51,
      87,
      1143,
      791,
      1144,
      1145,
      1146,
      392,
      1041,
      275,
      1147,
      31,
      1148,
      1149,
      1150
    ],
  ),
  "ad": SymbolsMetadata(
    popularity: 141,
    codepoint: 0xe65a,
    categories: [6],
    tags: [
      1151,
      1152,
      1153,
      1154,
      1155,
      1156,
      1157,
      283,
      621,
      1158,
      44,
      1140,
      138,
      172,
      51,
      68,
      259,
      52,
      16,
      1159,
      406,
      1160,
      523,
      1161,
      432,
      1162,
      1163,
      31,
      182,
      33,
      333,
      1164,
      1165
    ],
  ),
  "ad_group": SymbolsMetadata(
    popularity: 131,
    codepoint: 0xe65b,
    categories: [6],
    tags: [
      1152,
      1166,
      1153,
      1167,
      1168,
      1169,
      1156,
      1170,
      919,
      1171,
      1172,
      1173,
      1174,
      1175,
      924,
      1176,
      1177,
      1054,
      259,
      88,
      1004,
      1159,
      1178,
      1063,
      1161,
      1128,
      1179,
      1180,
      945,
      1181,
      1182,
      152,
      1164,
      1165
    ],
  ),
  "ad_group_off": SymbolsMetadata(
    popularity: 45,
    codepoint: 0xeae5,
    categories: [6],
    tags: [
      1183,
      1184,
      1168,
      481,
      1185,
      1186,
      1187,
      1188,
      1031,
      1189,
      867,
      1190,
      1191,
      1176,
      1192,
      1193,
      1194,
      1195,
      1196,
      1197,
      1198,
      1199,
      1200,
      1035,
      1201,
      589,
      1039,
      1202,
      71,
      1203,
      1204,
      1205,
      1206,
      1207
    ],
  ),
  "ad_off": SymbolsMetadata(
    popularity: 31,
    codepoint: 0xf7b2,
    categories: [6],
    tags: [
      1152,
      1208,
      1209,
      1153,
      1210,
      1211,
      1155,
      1212,
      1156,
      1157,
      345,
      1213,
      574,
      1138,
      1214,
      867,
      1033,
      1215,
      1216,
      259,
      1159,
      1217,
      1218,
      1035,
      1036,
      1037,
      1219,
      1220,
      912,
      1009,
      1161,
      1221,
      71,
      1041,
      1222,
      333,
      1164,
      1165
    ],
  ),
  "ad_units": SymbolsMetadata(
    popularity: 791,
    codepoint: 0xef39,
    categories: [11],
    tags: [
      1223,
      1224,
      1152,
      1225,
      1226,
      1210,
      1155,
      1171,
      1227,
      251,
      569,
      283,
      621,
      1031,
      288,
      1228,
      1229,
      1086,
      1230,
      1159,
      585,
      1231,
      1232,
      262,
      1233,
      1234,
      1235,
      609,
      1236,
      271,
      432,
      1039,
      1237,
      1238,
      525,
      33,
      1239,
      1240,
      1241
    ],
  ),
  "adaptive_audio_mic": SymbolsMetadata(
    popularity: 186,
    codepoint: 0xf4cc,
    categories: [0],
    tags: [
      565,
      1242,
      1243,
      1244,
      1245,
      1246,
      1247,
      1248,
      569,
      1249,
      283,
      1250,
      345,
      1251,
      1252,
      576,
      1001,
      1253,
      1254,
      1255,
      1176,
      1256,
      1257,
      583,
      1258,
      1087,
      1259,
      1089,
      1260,
      1261,
      1262,
      1263,
      267,
      1264,
      589,
      590,
      1265,
      591,
      1266,
      1267,
      453,
      1268,
      440,
      1269,
      64,
      71,
      1270,
      705,
      1271,
      1272,
      1273,
      593,
      1274,
      1275,
      1276,
      65,
      597,
      1206,
      1277
    ],
  ),
  "adaptive_audio_mic_off": SymbolsMetadata(
    popularity: 43,
    codepoint: 0xf4cb,
    categories: [0],
    tags: [
      565,
      1242,
      1246,
      1247,
      504,
      1249,
      283,
      345,
      1278,
      1138,
      1251,
      1279,
      867,
      576,
      1001,
      1191,
      1254,
      1255,
      1176,
      1256,
      1257,
      583,
      1258,
      138,
      1087,
      1089,
      1280,
      1261,
      1262,
      1263,
      439,
      1281,
      1282,
      267,
      1264,
      1035,
      589,
      590,
      1265,
      1009,
      591,
      1266,
      453,
      1268,
      440,
      1283,
      1041,
      705,
      1271,
      1272,
      1273,
      31,
      1274,
      1275,
      1284,
      597,
      1206,
      1277,
      554
    ],
  ),
  "adb": SymbolsMetadata(
    popularity: 919,
    codepoint: 0xe60e,
    categories: [4],
    tags: [
      1285,
      1286,
      1287,
      1288,
      501,
      1289,
      1078,
      283,
      519,
      1047,
      284,
      81,
      1290,
      1291,
      1292,
      1293,
      288,
      44,
      1294,
      262,
      271,
      1099,
      509,
      762,
      1068,
      525,
      65,
      1295,
      1296,
      1297,
      278
    ],
  ),
  "add": SymbolsMetadata(
    popularity: 72783,
    codepoint: 0xe145,
    categories: [2],
    tags: [
      231,
      743,
      232,
      1298,
      1299,
      1300,
      1301,
      1302,
      1213,
      1303,
      1304,
      235,
      1305,
      1306,
      1307,
      1308,
      237,
      886,
      239,
      242,
      668,
      31,
      230,
      1309
    ],
  ),
  "add_2": SymbolsMetadata(
    popularity: 230,
    codepoint: 0xf3dd,
    categories: [2],
    tags: [
      231,
      743,
      232,
      1298,
      1300,
      1310,
      482,
      1301,
      1311,
      1302,
      1080,
      1312,
      1313,
      530,
      381,
      234,
      1314,
      235,
      1315,
      1305,
      1306,
      237,
      886,
      289,
      239,
      242,
      1316,
      392,
      1317,
      433,
      1147,
      1318,
      31
    ],
  ),
  "add_a_photo": SymbolsMetadata(
    popularity: 6348,
    codepoint: 0xe439,
    categories: [1],
    tags: [
      231,
      1319,
      743,
      1320,
      504,
      40,
      42,
      1302,
      147,
      1321,
      137,
      138,
      49,
      1087,
      1305,
      1322,
      53,
      1323,
      406,
      886,
      57,
      1324,
      59,
      62,
      239,
      1325,
      31,
      141,
      1326,
      527,
      1327,
      476
    ],
  ),
  "add_ad": SymbolsMetadata(
    popularity: 89,
    codepoint: 0xe72a,
    categories: [6],
    tags: [
      231,
      1152,
      1328,
      743,
      1153,
      1154,
      1155,
      1108,
      482,
      1156,
      1171,
      1157,
      621,
      1302,
      44,
      8,
      1329,
      259,
      1159,
      406,
      585,
      886,
      609,
      523,
      289,
      1330,
      239,
      1331,
      1161,
      1332,
      432,
      1162,
      1163,
      433,
      1164,
      1165
    ],
  ),
  "add_alert": SymbolsMetadata(
    popularity: 1143,
    codepoint: 0xe003,
    categories: [6],
    tags: [
      231,
      747,
      743,
      1333,
      1334,
      1335,
      1336,
      1337,
      1338,
      1339,
      1340,
      1341,
      1342,
      1343,
      1302,
      1344,
      1345,
      1346,
      1347,
      585,
      886,
      1160,
      609,
      1236,
      1348,
      239,
      1349,
      1350,
      760,
      1351,
      1271,
      1352,
      1353,
      31,
      206
    ],
  ),
  "add_box": SymbolsMetadata(
    popularity: 10904,
    codepoint: 0xe146,
    categories: [2],
    tags: [
      746,
      743,
      232,
      1108,
      482,
      1354,
      504,
      1355,
      1311,
      621,
      345,
      1302,
      1140,
      809,
      216,
      488,
      348,
      1084,
      1142,
      381,
      1305,
      1356,
      886,
      1357,
      492,
      289,
      239,
      392,
      433,
      1147,
      31
    ],
  ),
  "add_business": SymbolsMetadata(
    popularity: 2132,
    codepoint: 0xe729,
    categories: [9],
    tags: [
      231,
      743,
      1358,
      1359,
      1360,
      1361,
      917,
      918,
      1362,
      1363,
      919,
      1364,
      920,
      921,
      922,
      924,
      1365,
      1366,
      1302,
      926,
      927,
      928,
      1367,
      1368,
      935,
      323,
      1369,
      1370,
      1371,
      938,
      886,
      1372,
      523,
      1063,
      940,
      941,
      326,
      239,
      1373,
      1374,
      1375,
      1376,
      1377,
      1378,
      945,
      31
    ],
  ),
  "add_call": SymbolsMetadata(
    popularity: 842,
    codepoint: 0xe0e8,
    categories: [7],
    tags: [
      231,
      746,
      743,
      1379,
      1380,
      1310,
      504,
      1248,
      1227,
      1250,
      965,
      1302,
      288,
      1381,
      137,
      1086,
      138,
      1322,
      1382,
      87,
      1383,
      1384,
      262,
      1385,
      886,
      1386,
      289,
      271,
      239,
      1317,
      31,
      1387,
      1388,
      1389,
      1390,
      1391
    ],
  ),
  "add_card": SymbolsMetadata(
    popularity: 2085,
    codepoint: 0xeb86,
    categories: [9],
    tags: [
      231,
      565,
      743,
      1392,
      1393,
      1394,
      1395,
      916,
      917,
      1396,
      1108,
      920,
      921,
      1397,
      922,
      924,
      1398,
      1302,
      926,
      951,
      927,
      952,
      928,
      931,
      932,
      938,
      886,
      1399,
      523,
      289,
      940,
      941,
      1400,
      239,
      240,
      1401,
      432,
      392,
      1376,
      433,
      31,
      946,
      963
    ],
  ),
  "add_chart": SymbolsMetadata(
    popularity: 985,
    codepoint: 0xe97b,
    categories: [9],
    tags: [
      231,
      743,
      1402,
      1045,
      1403,
      1404,
      517,
      919,
      373,
      1302,
      1405,
      81,
      375,
      932,
      1052,
      234,
      235,
      1055,
      68,
      1305,
      1406,
      226,
      18,
      1060,
      886,
      641,
      239,
      1407,
      1408,
      390,
      744,
      31,
      1070,
      1409,
      476
    ],
  ),
  "add_circle": SymbolsMetadata(
    popularity: 41208,
    codepoint: 0xe147,
    categories: [2],
    tags: [
      231,
      746,
      743,
      1410,
      1298,
      504,
      193,
      1411,
      1076,
      1078,
      345,
      224,
      1302,
      1084,
      1412,
      1314,
      235,
      1087,
      1305,
      467,
      1306,
      886,
      355,
      289,
      239,
      328,
      363,
      1147,
      1413,
      511,
      1326,
      1414
    ],
  ),
  "add_column_left": SymbolsMetadata(
    popularity: 6,
    codepoint: 0xf425,
    categories: [12],
    tags: [
      231,
      743,
      1415,
      1416,
      1417,
      1418,
      1419,
      1420,
      923,
      1421,
      1422,
      485,
      1423,
      370,
      382,
      1424,
      1425,
      1426,
      1427,
      385,
      1428,
      1429,
      1430,
      1431,
      1432,
      1433,
      1434,
      1435,
      239,
      1436,
      1437,
      1438,
      1439,
      1440,
      1441,
      1442,
      1443,
      31,
      1444,
      1445,
      396,
      1164
    ],
  ),
  "add_column_right": SymbolsMetadata(
    popularity: 34,
    codepoint: 0xf424,
    categories: [12],
    tags: [
      231,
      743,
      1415,
      1446,
      1447,
      517,
      1419,
      923,
      81,
      1448,
      485,
      1449,
      488,
      370,
      382,
      1425,
      1450,
      385,
      584,
      1451,
      1433,
      1063,
      239,
      432,
      907,
      1440,
      1452,
      1441,
      433,
      945,
      31,
      1453,
      1445,
      396,
      1164
    ],
  ),
  "add_comment": SymbolsMetadata(
    popularity: 2198,
    codepoint: 0xe266,
    categories: [7],
    tags: [
      231,
      743,
      1454,
      1298,
      567,
      569,
      571,
      572,
      283,
      1455,
      1302,
      1456,
      1457,
      1458,
      1459,
      1314,
      1087,
      1305,
      1306,
      585,
      886,
      1460,
      1461,
      239,
      1462,
      1463,
      705,
      593,
      1464,
      31,
      1274,
      33,
      1465
    ],
  ),
  "add_diamond": SymbolsMetadata(
    popularity: 38,
    codepoint: 0xf49c,
    categories: [11],
    tags: [
      231,
      743,
      1466,
      1301,
      1302,
      843,
      1467,
      1468,
      1469,
      1329,
      381,
      1314,
      1305,
      1470,
      1306,
      1471,
      1308,
      886,
      1433,
      239,
      1472,
      1473,
      392,
      31,
      1474,
      948
    ],
  ),
  "add_home": SymbolsMetadata(
    popularity: 395,
    codepoint: 0xf8eb,
    categories: [5],
    tags: [
      1475,
      743,
      1298,
      1476,
      1300,
      918,
      504,
      1477,
      1302,
      1213,
      1478,
      1082,
      1116,
      1479,
      1314,
      235,
      1305,
      323,
      325,
      886,
      239,
      1480,
      1481,
      977,
      1482,
      1483,
      1484,
      945,
      1485,
      1486
    ],
  ),
  "add_home_work": SymbolsMetadata(
    popularity: 332,
    codepoint: 0xf8ed,
    categories: [5],
    tags: [
      743,
      1358,
      1359,
      1487,
      1488,
      1489,
      1490,
      1491,
      1492,
      1493,
      1494,
      918,
      919,
      1477,
      1302,
      1116,
      1479,
      1495,
      323,
      1004,
      886,
      1372,
      239,
      1496,
      1480,
      1481,
      1483,
      1497,
      1498
    ],
  ),
  "add_link": SymbolsMetadata(
    popularity: 1485,
    codepoint: 0xe178,
    categories: [12],
    tags: [
      743,
      1499,
      1500,
      1501,
      1300,
      1354,
      1502,
      1503,
      1301,
      1047,
      284,
      1302,
      1213,
      488,
      1504,
      259,
      1306,
      1505,
      1294,
      1506,
      1308,
      267,
      886,
      239,
      1507,
      1508,
      243,
      31,
      1509,
      1510,
      333,
      1164
    ],
  ),
  "add_location": SymbolsMetadata(
    popularity: 2811,
    codepoint: 0xe567,
    categories: [5],
    tags: [
      231,
      743,
      1361,
      1511,
      1512,
      1302,
      1213,
      312,
      313,
      1513,
      1514,
      1515,
      318,
      321,
      1516,
      323,
      1517,
      1518,
      324,
      1369,
      1519,
      1520,
      174,
      325,
      886,
      1521,
      326,
      1522,
      1523,
      327,
      1524,
      1525,
      239,
      1526,
      1373,
      329,
      1203,
      31,
      332
    ],
  ),
  "add_location_alt": SymbolsMetadata(
    popularity: 1732,
    codepoint: 0xef3a,
    categories: [5],
    tags: [
      231,
      743,
      1493,
      1527,
      310,
      1302,
      312,
      313,
      1528,
      1529,
      1530,
      323,
      324,
      1520,
      1143,
      174,
      325,
      886,
      326,
      327,
      239,
      328,
      329,
      1203,
      1531,
      31
    ],
  ),
  "add_moderator": SymbolsMetadata(
    popularity: 621,
    codepoint: 0xe97d,
    categories: [13],
    tags: [
      231,
      743,
      1532,
      1533,
      1534,
      1535,
      1536,
      1537,
      1538,
      1539,
      1540,
      1541,
      1542,
      1543,
      1544,
      1545,
      1546,
      886,
      1547,
      1548,
      1549,
      1550,
      1551,
      1552,
      973,
      239,
      1553,
      1554,
      1555,
      1556,
      1557,
      1558,
      1009,
      975,
      1559,
      1560,
      696,
      1011,
      1561,
      31,
      981,
      1562,
      1563
    ],
  ),
  "add_notes": SymbolsMetadata(
    popularity: 140,
    codepoint: 0xe091,
    categories: [12],
    tags: [
      231,
      743,
      232,
      1454,
      1564,
      1302,
      1565,
      1566,
      1567,
      1568,
      147,
      1305,
      1569,
      1570,
      88,
      1571,
      585,
      886,
      1460,
      1572,
      1573,
      1574,
      1575,
      239,
      453,
      1350,
      1576,
      1577,
      33,
      1578,
      1465
    ],
  ),
  "add_photo_alternate": SymbolsMetadata(
    popularity: 4209,
    codepoint: 0xe43e,
    categories: [1],
    tags: [
      231,
      743,
      232,
      1320,
      1579,
      1580,
      42,
      450,
      1175,
      1581,
      147,
      1321,
      137,
      49,
      1582,
      1305,
      1583,
      406,
      1584,
      1585,
      886,
      57,
      59,
      62,
      239,
      432,
      362,
      433,
      1586,
      31,
      527,
      476
    ],
  ),
  "add_reaction": SymbolsMetadata(
    popularity: 2620,
    codepoint: 0xe1d3,
    categories: [3],
    tags: [
      231,
      743,
      1587,
      1588,
      1589,
      569,
      193,
      571,
      572,
      1302,
      1590,
      1591,
      1592,
      1593,
      1594,
      1595,
      576,
      1596,
      1459,
      1597,
      1598,
      1599,
      1600,
      1601,
      138,
      1602,
      1305,
      1603,
      1604,
      1605,
      886,
      1606,
      590,
      1607,
      239,
      1608,
      240,
      242,
      1609,
      1610,
      1611,
      1612,
      705,
      243,
      1613,
      31
    ],
  ),
  "add_road": SymbolsMetadata(
    popularity: 760,
    codepoint: 0xef3b,
    categories: [5],
    tags: [
      231,
      743,
      1614,
      1354,
      1302,
      312,
      313,
      137,
      1615,
      138,
      1616,
      1617,
      87,
      323,
      324,
      1520,
      174,
      1618,
      886,
      1619,
      239,
      1620,
      1621,
      1162,
      1203,
      1531,
      31,
      1622,
      1623,
      332,
      141,
      1327,
      1624
    ],
  ),
  "add_row_above": SymbolsMetadata(
    popularity: 7,
    codepoint: 0xf423,
    categories: [12],
    tags: [
      231,
      1625,
      743,
      1626,
      373,
      1419,
      923,
      1302,
      81,
      1627,
      1448,
      485,
      1567,
      1568,
      1303,
      1313,
      488,
      370,
      1052,
      382,
      1628,
      1305,
      385,
      87,
      886,
      1433,
      1063,
      239,
      1629,
      453,
      1630,
      1440,
      1441,
      945,
      31,
      1453,
      1445,
      396,
      1164
    ],
  ),
  "add_row_below": SymbolsMetadata(
    popularity: 19,
    codepoint: 0xf422,
    categories: [12],
    tags: [
      231,
      743,
      1631,
      1632,
      1417,
      77,
      1633,
      1419,
      923,
      1302,
      1213,
      81,
      485,
      1567,
      1634,
      1229,
      1568,
      1303,
      488,
      370,
      382,
      581,
      1426,
      1635,
      385,
      87,
      1636,
      886,
      1637,
      1433,
      92,
      239,
      1440,
      1441,
      1638,
      945,
      31,
      1453,
      1445,
      396,
      1164
    ],
  ),
  "add_shopping_cart": SymbolsMetadata(
    popularity: 7046,
    codepoint: 0xe854,
    categories: [9],
    tags: [
      743,
      1639,
      1640,
      232,
      1641,
      1642,
      1643,
      920,
      1644,
      1645,
      921,
      1397,
      922,
      924,
      926,
      1213,
      927,
      928,
      1646,
      1356,
      938,
      1647,
      523,
      1648,
      1649,
      1650,
      940,
      941,
      239,
      1651,
      1652,
      1653,
      1374,
      1375,
      1376,
      1654,
      1655,
      1377,
      1656
    ],
  ),
  "add_task": SymbolsMetadata(
    popularity: 4261,
    codepoint: 0xf23a,
    categories: [2],
    tags: [
      231,
      743,
      232,
      1288,
      1657,
      1658,
      1659,
      504,
      1660,
      1661,
      193,
      1662,
      519,
      1302,
      44,
      10,
      137,
      138,
      235,
      1322,
      88,
      1143,
      262,
      886,
      1663,
      906,
      1664,
      239,
      1496,
      1145,
      362,
      31,
      1497,
      1665,
      1666,
      1667,
      141,
      1327,
      333,
      1498,
      1668
    ],
  ),
  "add_to_drive": SymbolsMetadata(
    popularity: 768,
    codepoint: 0xe65c,
    categories: [12],
    tags: [
      743,
      1669,
      1670,
      1671,
      232,
      1288,
      501,
      1672,
      1673,
      1674,
      1302,
      81,
      1567,
      1675,
      1676,
      147,
      1677,
      1678,
      1679,
      1680,
      1681,
      259,
      267,
      886,
      523,
      239,
      1507,
      1682,
      1683,
      1684,
      1104,
      1685,
      763,
      527
    ],
  ),
  "add_to_home_screen": SymbolsMetadata(
    popularity: 322,
    codepoint: 0xe1fe,
    categories: [11],
    tags: [
      1223,
      1224,
      746,
      743,
      1686,
      1687,
      1288,
      501,
      77,
      1688,
      1227,
      288,
      1689,
      313,
      1303,
      1690,
      1691,
      1086,
      1116,
      1230,
      1692,
      262,
      1693,
      325,
      271,
      326,
      432,
      1694,
      1683,
      410,
      1508,
      1104,
      1695,
      433,
      31,
      525,
      1696,
      98,
      527
    ],
    rtlAutoMirrored: true,
  ),
  "add_to_queue": SymbolsMetadata(
    popularity: 541,
    codepoint: 0xe05c,
    categories: [0],
    tags: [
      231,
      1223,
      1224,
      743,
      1697,
      1298,
      1447,
      1246,
      1698,
      1699,
      288,
      8,
      779,
      1086,
      1230,
      1314,
      1305,
      87,
      88,
      1700,
      1004,
      406,
      623,
      439,
      1701,
      886,
      904,
      91,
      1702,
      1703,
      408,
      1704,
      239,
      1705,
      410,
      94,
      594,
      31,
      1706,
      1707,
      37,
      543,
      1708,
      333,
      1165
    ],
  ),
  "add_triangle": SymbolsMetadata(
    popularity: 40,
    codepoint: 0xf48e,
    categories: [5],
    tags: [
      231,
      743,
      232,
      1298,
      77,
      1300,
      1354,
      1564,
      1709,
      345,
      1302,
      313,
      1710,
      488,
      902,
      1329,
      381,
      1314,
      235,
      1305,
      1711,
      325,
      886,
      1433,
      1712,
      239,
      328,
      1713,
      1714,
      392,
      1715,
      31,
      1716,
      1717,
      1622,
      1718,
      1719
    ],
  ),
  "adf_scanner": SymbolsMetadata(
    popularity: 247,
    codepoint: 0xeada,
    categories: [11],
    tags: [
      1720,
      1721,
      1722,
      919,
      1723,
      1724,
      288,
      1725,
      1567,
      1726,
      1727,
      1728,
      582,
      107,
      1087,
      1729,
      1730,
      1372,
      1731,
      1732,
      1575,
      1733,
      1734,
      1735,
      756,
      432,
      1736,
      1737,
      1576,
      594,
      65,
      1498
    ],
  ),
  "adjust": SymbolsMetadata(
    popularity: 1694,
    codepoint: 0xe39e,
    categories: [1],
    tags: [
      1738,
      1739,
      1740,
      517,
      308,
      193,
      1076,
      678,
      573,
      1741,
      1742,
      574,
      1405,
      1743,
      1229,
      83,
      1744,
      1745,
      1746,
      1747,
      49,
      1748,
      584,
      506,
      1636,
      586,
      70,
      1749,
      1733,
      1750,
      1751,
      912,
      71,
      1752,
      1753,
      1068,
      1204,
      97,
      1296,
      1754
    ],
  ),
  "admin_meds": SymbolsMetadata(
    popularity: 22,
    codepoint: 0xe48d,
    categories: [3],
    tags: [
      1755,
      1756,
      1641,
      1757,
      1758,
      1759,
      1760,
      1761,
      1762,
      1763,
      692,
      1764,
      1765,
      1766,
      1767,
      895,
      1768,
      1769,
      1770,
      1771,
      1772,
      1773,
      1774,
      1775,
      1776,
      432,
      1376,
      433,
      525,
      1777
    ],
  ),
  "admin_panel_settings": SymbolsMetadata(
    popularity: 8034,
    codepoint: 0xef3d,
    categories: [13],
    tags: [
      858,
      565,
      862,
      1755,
      1538,
      566,
      1539,
      1778,
      678,
      345,
      1405,
      1779,
      576,
      1780,
      583,
      1004,
      1781,
      1782,
      70,
      1749,
      589,
      1783,
      590,
      1008,
      912,
      1009,
      975,
      1784,
      591,
      1560,
      696,
      1011,
      71,
      1561,
      1785,
      1068,
      1296,
      597,
      1562,
      1786
    ],
  ),
  "ads_click": SymbolsMetadata(
    popularity: 7143,
    codepoint: 0xe762,
    categories: [6],
    tags: [
      1787,
      1788,
      1153,
      1045,
      77,
      1156,
      504,
      1789,
      1171,
      1790,
      1791,
      1792,
      1793,
      312,
      44,
      1794,
      1795,
      1603,
      259,
      1294,
      1159,
      17,
      267,
      523,
      641,
      1144,
      1161,
      1796,
      362,
      1797,
      1204,
      1798,
      1070,
      1622,
      333
    ],
  ),
  "agender": SymbolsMetadata(
    popularity: 175,
    codepoint: 0xf888,
    categories: [3],
    tags: [
      1799,
      193,
      1800,
      1213,
      1801,
      1802,
      1803,
      1804,
      1805,
      1806,
      1807,
      583,
      138,
      969,
      894,
      1808,
      1809,
      87,
      1810,
      813,
      1811,
      589,
      590,
      239,
      591,
      1812,
      390,
      1813,
      1814,
      1041,
      705,
      31,
      597
    ],
  ),
  "agriculture": SymbolsMetadata(
    popularity: 1713,
    codepoint: 0xea79,
    categories: [14],
    tags: [
      1815,
      1816,
      1817,
      1818,
      1819,
      1820,
      1821,
      1822,
      315,
      1823,
      1824,
      1825,
      1826,
      1827,
      1828,
      1829,
      234,
      1830,
      1831,
      1832,
      1520,
      1833,
      1834,
      1835,
      1836,
      1837,
      1838,
      1839,
      1840,
      1841,
      1842,
      1843,
      1844,
      1845,
      1846,
      1847,
      1848,
      332,
      1849,
      1850
    ],
  ),
  "air": SymbolsMetadata(
    popularity: 2752,
    codepoint: 0xefd8,
    categories: [15],
    tags: [
      480,
      834,
      1851,
      1852,
      1853,
      1854,
      837,
      842,
      1855,
      1140,
      1823,
      1856,
      1051,
      1857,
      1858,
      1859,
      1860,
      87,
      584,
      353,
      468,
      63,
      1861,
      1862,
      454,
      1863,
      1864,
      1865,
      1866,
      1867,
      856,
      1868
    ],
  ),
  "air_freshener": SymbolsMetadata(
    popularity: 420,
    codepoint: 0xe2ca,
    categories: [8],
    tags: [
      1869,
      1870,
      834,
      1871,
      1872,
      1873,
      1874,
      1875,
      1818,
      808,
      1876,
      1877,
      1878,
      1857,
      1858,
      1879,
      1116,
      1880,
      1881,
      1356,
      1119,
      492,
      1882,
      1652,
      1883,
      1039,
      1884,
      1861,
      1862,
      1885,
      1850
    ],
  ),
  "air_purifier": SymbolsMetadata(
    popularity: 38,
    codepoint: 0xe97e,
    categories: [8],
    tags: [
      834,
      1886,
      1887,
      1888,
      1889,
      77,
      1890,
      808,
      1891,
      345,
      288,
      1892,
      1823,
      1857,
      1858,
      1893,
      1879,
      1894,
      692,
      1895,
      1116,
      1896,
      1479,
      1880,
      584,
      1729,
      1897,
      1898,
      1883,
      432,
      71,
      1899,
      65,
      97,
      1900,
      1901,
      1865,
      1445
    ],
  ),
  "air_purifier_gen": SymbolsMetadata(
    popularity: 329,
    codepoint: 0xe829,
    categories: [8],
    tags: [
      834,
      1886,
      1887,
      1902,
      1888,
      1889,
      1903,
      1904,
      1891,
      1905,
      345,
      288,
      1823,
      1906,
      1893,
      692,
      1907,
      1896,
      1908,
      584,
      635,
      1119,
      1909,
      432,
      71,
      1910,
      1911,
      1899,
      1900,
      1901,
      1865,
      1868
    ],
  ),
  "airline_seat_flat": SymbolsMetadata(
    popularity: 274,
    codepoint: 0xe630,
    categories: [16],
    tags: [
      1912,
      1913,
      1914,
      1915,
      684,
      1916,
      919,
      1917,
      1918,
      1919,
      1920,
      1921,
      1922,
      1923,
      379,
      1924,
      583,
      1617,
      1925,
      1926,
      1927,
      1928,
      589,
      590,
      387,
      1929,
      1930,
      1931,
      1932,
      1933,
      1934,
      645,
      1935,
      1936,
      1623,
      332,
      1937
    ],
  ),
  "airline_seat_flat_angled": SymbolsMetadata(
    popularity: 146,
    codepoint: 0xe631,
    categories: [16],
    tags: [
      1938,
      1912,
      1913,
      500,
      1939,
      1915,
      684,
      1940,
      919,
      1919,
      1920,
      1921,
      1941,
      1922,
      379,
      1924,
      583,
      1617,
      1942,
      1928,
      589,
      590,
      329,
      1929,
      1943,
      1932,
      1933,
      1934,
      1935,
      1944,
      1848,
      1623,
      332,
      1945,
      1850
    ],
  ),
  "airline_seat_individual_suite": SymbolsMetadata(
    popularity: 223,
    codepoint: 0xe632,
    categories: [16],
    tags: [
      1938,
      1912,
      1107,
      684,
      919,
      1918,
      1919,
      1920,
      1921,
      1946,
      1922,
      1923,
      1924,
      1947,
      583,
      1002,
      1617,
      1948,
      1927,
      1471,
      589,
      590,
      911,
      387,
      714,
      975,
      1949,
      1950,
      1932,
      1933,
      1934,
      1127,
      1935,
      1951,
      1848,
      1623,
      332,
      1945,
      1952
    ],
  ),
  "airline_seat_legroom_extra": SymbolsMetadata(
    popularity: 160,
    codepoint: 0xe633,
    categories: [16],
    tags: [
      1912,
      1913,
      684,
      1916,
      1919,
      1921,
      1941,
      1953,
      1954,
      689,
      1947,
      583,
      1617,
      1955,
      1956,
      1948,
      1957,
      1928,
      589,
      590,
      387,
      714,
      1931,
      1630,
      1933,
      1958,
      707,
      1959,
      1623,
      332,
      1960,
      1850
    ],
  ),
  "airline_seat_legroom_normal": SymbolsMetadata(
    popularity: 143,
    codepoint: 0xe634,
    categories: [16],
    tags: [
      1912,
      1913,
      1107,
      1447,
      1961,
      684,
      1918,
      1919,
      1921,
      689,
      1924,
      583,
      1617,
      385,
      1956,
      1948,
      17,
      1962,
      1928,
      589,
      590,
      387,
      1884,
      1933,
      1934,
      1958,
      707,
      1963,
      1848,
      1623,
      332,
      1850
    ],
  ),
  "airline_seat_legroom_reduced": SymbolsMetadata(
    popularity: 141,
    codepoint: 0xe635,
    categories: [16],
    tags: [
      1938,
      1912,
      1913,
      684,
      1918,
      1921,
      1964,
      1965,
      954,
      689,
      1947,
      583,
      1617,
      1956,
      1948,
      1966,
      1967,
      1968,
      812,
      1928,
      589,
      590,
      387,
      1969,
      1970,
      1630,
      1933,
      1934,
      1971,
      1958,
      1972,
      707,
      1973,
      1848,
      1623,
      332,
      1945
    ],
  ),
  "airline_seat_recline_extra": SymbolsMetadata(
    popularity: 571,
    codepoint: 0xe636,
    categories: [16],
    tags: [
      1912,
      1913,
      1961,
      684,
      1916,
      1919,
      1921,
      1941,
      1954,
      689,
      1924,
      1947,
      1974,
      583,
      1617,
      1956,
      1948,
      1975,
      1927,
      1928,
      589,
      590,
      387,
      714,
      1929,
      1950,
      1930,
      1931,
      1933,
      1958,
      707,
      1848,
      1623,
      332,
      1945,
      1960,
      1952
    ],
  ),
  "airline_seat_recline_normal": SymbolsMetadata(
    popularity: 670,
    codepoint: 0xe637,
    categories: [16],
    tags: [
      1912,
      1976,
      1977,
      1913,
      684,
      1919,
      1921,
      1941,
      375,
      1978,
      1954,
      689,
      1924,
      583,
      1617,
      385,
      1956,
      1948,
      1962,
      1979,
      1928,
      1980,
      589,
      590,
      1929,
      1981,
      1950,
      1933,
      1934,
      1982,
      1958,
      707,
      1983,
      1848,
      332,
      1984,
      1985,
      1986,
      1850
    ],
  ),
  "airline_stops": SymbolsMetadata(
    popularity: 386,
    codepoint: 0xe7d0,
    categories: [5],
    tags: [
      1912,
      1913,
      1987,
      77,
      1961,
      1076,
      284,
      312,
      1988,
      313,
      1081,
      1924,
      1989,
      1617,
      1990,
      1991,
      87,
      323,
      1520,
      325,
      1619,
      327,
      387,
      848,
      1992,
      1621,
      1993,
      1994,
      1623,
      332,
      1995,
      1996,
      1945
    ],
  ),
  "airlines": SymbolsMetadata(
    popularity: 446,
    codepoint: 0xe7ca,
    categories: [14],
    tags: [
      834,
      1997,
      1938,
      1998,
      1999,
      1913,
      2000,
      2001,
      1987,
      1961,
      1916,
      2002,
      312,
      1924,
      2003,
      2004,
      2005,
      1947,
      1617,
      635,
      1037,
      387,
      2006,
      2007,
      273,
      2008,
      1848,
      1623,
      332,
      2009,
      1984,
      1945,
      2010
    ],
  ),
  "airplane_ticket": SymbolsMetadata(
    popularity: 1641,
    codepoint: 0xefd9,
    categories: [16],
    tags: [
      2011,
      834,
      2012,
      1938,
      1913,
      2013,
      2001,
      1987,
      2014,
      2015,
      1916,
      1567,
      2016,
      1568,
      1924,
      2017,
      2004,
      2005,
      1947,
      2018,
      1617,
      1520,
      1575,
      2019,
      2020,
      387,
      2021,
      2007,
      432,
      1931,
      1736,
      2022,
      273,
      2023,
      2024,
      2025,
      1848,
      1623,
      332,
      2026,
      1945,
      1952
    ],
    rtlAutoMirrored: true,
  ),
  "airplanemode_inactive": SymbolsMetadata(
    popularity: 259,
    codepoint: 0xe194,
    categories: [4],
    tags: [
      834,
      1938,
      1913,
      2000,
      2001,
      1987,
      1961,
      1250,
      254,
      1278,
      2027,
      1138,
      867,
      1033,
      1924,
      2028,
      2004,
      2005,
      1947,
      1200,
      87,
      1520,
      2029,
      635,
      2030,
      2031,
      2032,
      1035,
      1036,
      1037,
      387,
      2007,
      273,
      2033,
      1041,
      1623,
      332,
      1718,
      1945,
      2034
    ],
  ),
  "airplay": SymbolsMetadata(
    popularity: 374,
    codepoint: 0xe055,
    categories: [0],
    tags: [
      2035,
      77,
      1246,
      729,
      2036,
      2037,
      1047,
      284,
      2038,
      345,
      1699,
      288,
      8,
      2039,
      406,
      2040,
      623,
      439,
      1732,
      408,
      388,
      410,
      2041,
      2042,
      2043,
      2044,
      273,
      411,
      1718,
      2045,
      37,
      278,
      2046
    ],
  ),
  "airport_shuttle": SymbolsMetadata(
    popularity: 2258,
    codepoint: 0xeb3c,
    categories: [14],
    tags: [
      1987,
      2047,
      2048,
      1816,
      1940,
      2049,
      1818,
      1819,
      1157,
      2050,
      313,
      2051,
      2052,
      2053,
      1617,
      2054,
      1520,
      2055,
      896,
      468,
      1928,
      2056,
      2057,
      2058,
      2059,
      2060,
      2061,
      2062,
      2063,
      526,
      1994,
      1848,
      2064,
      1623,
      332,
      2065,
      1984,
      1945,
      1849,
      2066,
      1850
    ],
    rtlAutoMirrored: true,
  ),
  "airware": SymbolsMetadata(
    popularity: 441,
    codepoint: 0xf154,
    categories: [8],
    tags: [
      2067,
      2068,
      1246,
      729,
      254,
      2069,
      81,
      1051,
      351,
      582,
      259,
      353,
      1701,
      267,
      2070,
      2071,
      2072,
      273,
      2073,
      1271,
      411,
      97,
      2074,
      2075,
      1866,
      1867,
      277,
      278
    ],
  ),
  "airwave": SymbolsMetadata(
    popularity: 678,
    codepoint: 0xe29c,
    categories: [10],
    tags: [
      834,
      2067,
      2068,
      1246,
      2076,
      2077,
      1852,
      1854,
      729,
      837,
      283,
      284,
      2069,
      2078,
      2079,
      1051,
      351,
      1116,
      2080,
      644,
      1701,
      1119,
      267,
      1733,
      2081,
      2082,
      273,
      2083,
      1271,
      2084,
      2085,
      97,
      2074,
      554,
      1866,
      2086,
      1867,
      856,
      1868
    ],
  ),
  "alarm": SymbolsMetadata(
    popularity: 4717,
    codepoint: 0xe855,
    categories: [6],
    tags: [
      858,
      1338,
      1339,
      2087,
      2088,
      1341,
      2089,
      2090,
      2091,
      193,
      1135,
      2092,
      1136,
      1081,
      2093,
      2094,
      609,
      1350,
      2095,
      1145,
      2096,
      1180,
      2097,
      1271,
      1148,
      2098,
      2099,
      1149,
      2100,
      2101,
      2102,
      2103
    ],
  ),
  "alarm_add": SymbolsMetadata(
    popularity: 739,
    codepoint: 0xe856,
    categories: [6],
    tags: [
      231,
      743,
      1338,
      1339,
      1657,
      1341,
      2104,
      1343,
      193,
      1135,
      2092,
      1302,
      1213,
      1136,
      2105,
      2093,
      1628,
      87,
      584,
      886,
      609,
      2106,
      239,
      1144,
      1350,
      2107,
      1145,
      273,
      31,
      1148,
      2108,
      2102
    ],
  ),
  "alarm_off": SymbolsMetadata(
    popularity: 486,
    codepoint: 0xe857,
    categories: [6],
    tags: [
      1338,
      2109,
      1339,
      1341,
      2110,
      2111,
      2112,
      1660,
      2113,
      1135,
      1138,
      2114,
      2115,
      2116,
      867,
      2117,
      1033,
      2118,
      2119,
      2120,
      1282,
      2121,
      2122,
      2123,
      2124,
      609,
      2125,
      1035,
      1037,
      2126,
      2127,
      2128,
      1041,
      2129,
      2130,
      1148,
      1149,
      2131,
      2102
    ],
  ),
  "alarm_on": SymbolsMetadata(
    popularity: 1968,
    codepoint: 0xe858,
    categories: [6],
    tags: [
      747,
      1338,
      2132,
      1339,
      2133,
      1341,
      1660,
      2113,
      1343,
      193,
      1135,
      2117,
      1033,
      2093,
      2134,
      2135,
      609,
      1037,
      1144,
      1350,
      760,
      2136,
      360,
      1180,
      273,
      2137,
      1271,
      1148,
      2099,
      1149,
      2101,
      2102
    ],
  ),
  "alarm_pause": SymbolsMetadata(
    popularity: 19,
    codepoint: 0xf35b,
    categories: [6],
    tags: [
      1338,
      1339,
      1341,
      2138,
      1135,
      345,
      2139,
      2117,
      2140,
      2141,
      352,
      609,
      1201,
      2142,
      2126,
      1350,
      1145,
      1283,
      2097,
      2143,
      1203,
      2144,
      2145,
      2146,
      1148,
      1149,
      764,
      2102
    ],
  ),
  "alarm_smart_wake": SymbolsMetadata(
    popularity: 28,
    codepoint: 0xf6b0,
    categories: [6],
    tags: [
      1244,
      1338,
      1339,
      1288,
      1341,
      2147,
      1343,
      193,
      1135,
      678,
      2148,
      584,
      262,
      2149,
      609,
      70,
      2150,
      1350,
      760,
      1145,
      71,
      1935,
      2151,
      2152,
      1271,
      65,
      1148,
      1296,
      2153,
      2101
    ],
  ),
  "album": SymbolsMetadata(
    popularity: 1463,
    codepoint: 0xe019,
    categories: [0],
    tags: [
      1320,
      2154,
      1580,
      2155,
      1246,
      2156,
      2157,
      1175,
      519,
      2158,
      81,
      2159,
      2160,
      779,
      147,
      2161,
      382,
      1056,
      1323,
      88,
      406,
      2162,
      1701,
      1063,
      1704,
      453,
      2163,
      1271,
      433,
      594,
      595,
      1685,
      2164,
      2165,
      396
    ],
  ),
  "align_center": SymbolsMetadata(
    popularity: 11,
    codepoint: 0xe356,
    categories: [12],
    tags: [
      2166,
      2167,
      1447,
      517,
      308,
      2168,
      2169,
      1567,
      2170,
      2171,
      2172,
      370,
      2173,
      581,
      2174,
      385,
      584,
      2175,
      2176,
      91,
      2177,
      2178,
      329,
      701,
      2179,
      2180,
      33,
      2181,
      2182,
      2183,
      1465
    ],
  ),
  "align_end": SymbolsMetadata(
    popularity: 3,
    codepoint: 0xf797,
    categories: [12],
    tags: [
      2184,
      2185,
      2186,
      2167,
      2187,
      2188,
      1567,
      2171,
      2172,
      2189,
      2173,
      2190,
      385,
      2191,
      2192,
      2193,
      33,
      2181,
      2194,
      2195,
      2196,
      2197,
      2198
    ],
  ),
  "align_flex_center": SymbolsMetadata(
    popularity: 11,
    codepoint: 0xf796,
    categories: [12],
    tags: [
      2166,
      2167,
      1447,
      481,
      308,
      621,
      2199,
      2200,
      1140,
      2201,
      1253,
      370,
      2173,
      382,
      581,
      2202,
      385,
      584,
      2176,
      2203,
      329,
      701,
      2180,
      2181,
      1445
    ],
  ),
  "align_flex_end": SymbolsMetadata(
    popularity: 2,
    codepoint: 0xf795,
    categories: [12],
    tags: [
      1738,
      2166,
      2167,
      1447,
      2204,
      308,
      1419,
      621,
      345,
      2205,
      8,
      2199,
      2206,
      2207,
      2208,
      1253,
      370,
      382,
      581,
      86,
      2202,
      385,
      584,
      92,
      2209,
      1269,
      907,
      1630,
      701,
      707,
      945,
      2180,
      1445,
      2210
    ],
  ),
  "align_flex_start": SymbolsMetadata(
    popularity: 3,
    codepoint: 0xf794,
    categories: [12],
    tags: [
      2166,
      2211,
      2212,
      2167,
      1447,
      2213,
      481,
      482,
      308,
      2205,
      2199,
      2206,
      2214,
      2208,
      1253,
      370,
      2215,
      86,
      2202,
      385,
      2216,
      584,
      1063,
      2217,
      2209,
      432,
      701,
      392,
      2218,
      945,
      2180,
      2219,
      1240,
      2220,
      1445,
      2221,
      2222
    ],
  ),
  "align_horizontal_center": SymbolsMetadata(
    popularity: 347,
    codepoint: 0xe00f,
    categories: [12],
    tags: [
      2166,
      2167,
      76,
      517,
      308,
      621,
      81,
      485,
      2200,
      1567,
      2172,
      370,
      2173,
      382,
      581,
      385,
      584,
      92,
      2177,
      2217,
      2209,
      432,
      701,
      2179,
      392,
      945,
      2180,
      33,
      2223
    ],
  ),
  "align_horizontal_left": SymbolsMetadata(
    popularity: 470,
    codepoint: 0xe00d,
    categories: [12],
    tags: [
      2166,
      2224,
      2225,
      2167,
      76,
      2226,
      517,
      313,
      1567,
      2227,
      2171,
      2172,
      370,
      2189,
      581,
      2228,
      2174,
      385,
      2216,
      2229,
      584,
      91,
      92,
      2177,
      329,
      2230,
      701,
      2179,
      2231,
      2180,
      33,
      2232
    ],
    rtlAutoMirrored: true,
  ),
  "align_horizontal_right": SymbolsMetadata(
    popularity: 309,
    codepoint: 0xe010,
    categories: [12],
    tags: [
      2233,
      2166,
      2167,
      76,
      517,
      621,
      1567,
      2170,
      2172,
      370,
      2234,
      581,
      2235,
      385,
      584,
      91,
      2177,
      2236,
      329,
      432,
      907,
      701,
      2179,
      2231,
      2180,
      33,
      2237,
      338,
      2198,
      1465
    ],
    rtlAutoMirrored: true,
  ),
  "align_items_stretch": SymbolsMetadata(
    popularity: 14,
    codepoint: 0xf793,
    categories: [12],
    tags: [
      2166,
      2238,
      2167,
      1447,
      482,
      308,
      2239,
      1311,
      2205,
      485,
      1080,
      2199,
      2200,
      2206,
      1303,
      2240,
      2241,
      2208,
      370,
      382,
      1176,
      581,
      2215,
      86,
      385,
      584,
      2242,
      92,
      432,
      2243,
      701,
      2179,
      95,
      433,
      1959,
      2180,
      1445,
      2221
    ],
  ),
  "align_justify_center": SymbolsMetadata(
    popularity: 3,
    codepoint: 0xf792,
    categories: [12],
    tags: [
      2166,
      2167,
      1447,
      308,
      2244,
      2168,
      621,
      1742,
      2199,
      1567,
      2245,
      2172,
      370,
      2173,
      2246,
      2247,
      581,
      582,
      2190,
      2248,
      385,
      584,
      506,
      2176,
      70,
      1574,
      2177,
      2209,
      701,
      2249,
      2180,
      33,
      2232,
      1465
    ],
  ),
  "align_justify_flex_end": SymbolsMetadata(
    popularity: 5,
    codepoint: 0xf791,
    categories: [12],
    tags: [
      1738,
      2166,
      2167,
      1447,
      481,
      2204,
      308,
      621,
      574,
      81,
      2199,
      2207,
      2201,
      1253,
      370,
      2247,
      581,
      68,
      2202,
      385,
      584,
      88,
      506,
      1636,
      70,
      91,
      92,
      2177,
      329,
      432,
      907,
      701,
      71,
      2231,
      945,
      2180,
      33,
      1445
    ],
  ),
  "align_justify_flex_start": SymbolsMetadata(
    popularity: 9,
    codepoint: 0xf790,
    categories: [12],
    tags: [
      2166,
      2250,
      2167,
      2213,
      2251,
      308,
      621,
      2252,
      2199,
      1253,
      370,
      2253,
      2173,
      2190,
      2202,
      2254,
      385,
      2229,
      584,
      88,
      2255,
      506,
      2256,
      2177,
      2257,
      2258,
      1733,
      701,
      2218,
      2180,
      33,
      2259,
      2260,
      1445,
      2261
    ],
  ),
  "align_justify_space_around": SymbolsMetadata(
    popularity: 10,
    codepoint: 0xf78f,
    categories: [12],
    tags: [
      2166,
      2167,
      460,
      1447,
      914,
      308,
      923,
      485,
      2199,
      2262,
      2200,
      1567,
      2172,
      2263,
      370,
      2173,
      382,
      581,
      2174,
      2202,
      385,
      584,
      1063,
      92,
      2177,
      2264,
      1440,
      701,
      707,
      2231,
      2180,
      33,
      1465
    ],
  ),
  "align_justify_space_between": SymbolsMetadata(
    popularity: 19,
    codepoint: 0xf78e,
    categories: [12],
    tags: [
      2166,
      2167,
      308,
      2265,
      2188,
      2199,
      2200,
      1567,
      2266,
      673,
      2267,
      370,
      2173,
      581,
      582,
      2190,
      2202,
      385,
      2268,
      584,
      506,
      70,
      2269,
      2177,
      1733,
      701,
      71,
      2270,
      2231,
      2180,
      2181,
      2194,
      2271,
      97,
      2272,
      1465
    ],
  ),
  "align_justify_space_even": SymbolsMetadata(
    popularity: 18,
    codepoint: 0xf78d,
    categories: [12],
    tags: [
      2166,
      2167,
      1447,
      308,
      621,
      2199,
      1567,
      2172,
      2273,
      2274,
      2275,
      370,
      2173,
      2276,
      581,
      2215,
      582,
      2202,
      385,
      584,
      91,
      92,
      2177,
      701,
      707,
      2231,
      945,
      2180,
      33,
      2259,
      2277,
      2278,
      2223,
      1465
    ],
  ),
  "align_justify_stretch": SymbolsMetadata(
    popularity: 6,
    codepoint: 0xf78c,
    categories: [12],
    tags: [
      2166,
      2167,
      1447,
      517,
      308,
      923,
      621,
      2199,
      1567,
      1229,
      2263,
      2279,
      1303,
      370,
      2173,
      1691,
      382,
      581,
      2202,
      385,
      584,
      88,
      506,
      91,
      92,
      2177,
      1407,
      1440,
      701,
      707,
      2231,
      1959,
      2180,
      33,
      1445
    ],
  ),
  "align_self_stretch": SymbolsMetadata(
    popularity: 6,
    codepoint: 0xf78b,
    categories: [12],
    tags: [
      1738,
      2166,
      2167,
      502,
      144,
      482,
      308,
      1311,
      621,
      377,
      2199,
      2280,
      1140,
      1303,
      2240,
      2241,
      370,
      1304,
      383,
      2202,
      385,
      584,
      492,
      150,
      390,
      2243,
      701,
      2179,
      2281,
      71,
      298,
      1959,
      2180,
      1900,
      1445,
      476
    ],
  ),
  "align_space_around": SymbolsMetadata(
    popularity: 1,
    codepoint: 0xf78a,
    categories: [12],
    tags: [
      2282,
      2166,
      2167,
      460,
      1447,
      2283,
      2284,
      308,
      621,
      2200,
      2285,
      2206,
      2263,
      370,
      581,
      2202,
      385,
      87,
      2242,
      92,
      2177,
      2209,
      1630,
      707,
      2231,
      2286,
      33,
      551,
      338
    ],
  ),
  "align_space_between": SymbolsMetadata(
    popularity: 5,
    codepoint: 0xf789,
    categories: [12],
    tags: [
      2166,
      2167,
      76,
      1447,
      517,
      2283,
      2287,
      485,
      2200,
      1567,
      2172,
      370,
      2173,
      2276,
      581,
      2190,
      2202,
      385,
      2216,
      584,
      2177,
      329,
      2209,
      907,
      707,
      2231,
      33,
      2194
    ],
  ),
  "align_space_even": SymbolsMetadata(
    popularity: 4,
    codepoint: 0xf788,
    categories: [12],
    tags: [
      1738,
      2233,
      2166,
      2167,
      76,
      1447,
      345,
      2199,
      2288,
      1229,
      2172,
      2289,
      2290,
      2274,
      2173,
      382,
      581,
      2215,
      2291,
      2202,
      385,
      91,
      2177,
      329,
      2209,
      592,
      707,
      2231,
      33,
      1296
    ],
  ),
  "align_start": SymbolsMetadata(
    popularity: 2,
    codepoint: 0xf787,
    categories: [12],
    tags: [
      2166,
      2250,
      1447,
      2292,
      2251,
      621,
      81,
      313,
      2293,
      1567,
      1229,
      2172,
      2173,
      2190,
      2202,
      385,
      2216,
      2229,
      584,
      88,
      2177,
      329,
      2294,
      2179,
      2218,
      33,
      2232,
      1465
    ],
  ),
  "align_stretch": SymbolsMetadata(
    popularity: 5,
    codepoint: 0xf786,
    categories: [12],
    tags: [
      2166,
      1447,
      2284,
      621,
      345,
      313,
      2200,
      1567,
      2172,
      1140,
      2263,
      1303,
      2295,
      2173,
      2296,
      581,
      2202,
      385,
      492,
      1574,
      2297,
      2243,
      391,
      2231,
      1959,
      33,
      397,
      2298
    ],
  ),
  "align_vertical_bottom": SymbolsMetadata(
    popularity: 322,
    codepoint: 0xe015,
    categories: [12],
    tags: [
      2166,
      2167,
      76,
      1403,
      2204,
      2299,
      2199,
      1567,
      2266,
      2172,
      147,
      370,
      2173,
      2276,
      385,
      87,
      584,
      1574,
      2177,
      329,
      1407,
      432,
      701,
      2179,
      2180,
      33,
      2300,
      97,
      1445,
      2223
    ],
  ),
  "align_vertical_center": SymbolsMetadata(
    popularity: 258,
    codepoint: 0xe011,
    categories: [12],
    tags: [
      2166,
      2167,
      1447,
      2284,
      308,
      2168,
      923,
      621,
      2199,
      1567,
      2172,
      2279,
      370,
      2173,
      382,
      385,
      584,
      2176,
      2177,
      329,
      1440,
      701,
      2179,
      2231,
      2180,
      33,
      338,
      1445,
      1465
    ],
  ),
  "align_vertical_top": SymbolsMetadata(
    popularity: 255,
    codepoint: 0xe00c,
    categories: [12],
    tags: [
      1738,
      2166,
      2167,
      76,
      1403,
      517,
      345,
      485,
      2199,
      1567,
      1229,
      2172,
      370,
      2173,
      137,
      382,
      385,
      584,
      2242,
      91,
      92,
      2177,
      2236,
      329,
      1407,
      432,
      701,
      2179,
      95,
      2180,
      33,
      97,
      1240,
      1326,
      1445
    ],
  ),
  "all_inbox": SymbolsMetadata(
    popularity: 818,
    codepoint: 0xe97f,
    categories: [7],
    tags: [
      2301,
      2302,
      2303,
      2154,
      482,
      1170,
      1175,
      283,
      463,
      2304,
      1311,
      2305,
      2306,
      2050,
      2307,
      2308,
      2309,
      2310,
      2296,
      970,
      2311,
      15,
      2312,
      2313,
      2314,
      585,
      2315,
      2316,
      961,
      2317,
      2318,
      1685,
      2319
    ],
  ),
  "all_inclusive": SymbolsMetadata(
    popularity: 3214,
    codepoint: 0xeb3d,
    categories: [6],
    tags: [
      480,
      2302,
      2320,
      463,
      2304,
      2321,
      1048,
      750,
      751,
      2322,
      2323,
      2324,
      2325,
      2326,
      2327,
      2296,
      319,
      874,
      2328,
      2329,
      2330,
      755,
      791,
      2331,
      2332,
      2333,
      1846,
      2334,
      31,
      2319,
      2335,
      879,
      2336,
      2337
    ],
  ),
  "all_match": SymbolsMetadata(
    popularity: 92,
    codepoint: 0xe093,
    categories: [2],
    tags: [
      2338,
      2302,
      1658,
      2339,
      1660,
      463,
      2340,
      43,
      2341,
      2342,
      2325,
      2343,
      316,
      83,
      317,
      1746,
      2296,
      2344,
      52,
      2345,
      2346,
      2347,
      2348,
      1143,
      2349,
      1663,
      2350,
      2351,
      2352,
      2353,
      1736,
      1102,
      2354,
      362,
      182,
      1665,
      2355,
      1562,
      396,
      1668,
      2356
    ],
  ),
  "all_out": SymbolsMetadata(
    popularity: 422,
    codepoint: 0xe90b,
    categories: [6],
    tags: [
      746,
      2302,
      502,
      504,
      193,
      345,
      2357,
      2358,
      313,
      8,
      1140,
      2359,
      1303,
      1691,
      138,
      1322,
      2360,
      355,
      2361,
      2362,
      2363,
      410,
      151,
      392,
      31,
      413,
      396,
      1165,
      2356
    ],
  ),
  "allergies": SymbolsMetadata(
    popularity: 22,
    codepoint: 0xe094,
    categories: [3],
    tags: [
      1339,
      2364,
      2365,
      2366,
      2367,
      1817,
      2368,
      1823,
      2369,
      2370,
      1828,
      692,
      2371,
      138,
      2372,
      2373,
      1832,
      2374,
      895,
      1833,
      1834,
      1835,
      1837,
      2375,
      1714,
      2376,
      1040,
      2377,
      1841,
      1845,
      2378,
      2379,
      206
    ],
  ),
  "allergy": SymbolsMetadata(
    popularity: 33,
    codepoint: 0xe64e,
    categories: [3],
    tags: [
      1339,
      2364,
      2365,
      2366,
      2367,
      2380,
      1342,
      1760,
      1345,
      2381,
      2382,
      1761,
      2370,
      2383,
      692,
      1765,
      1766,
      2384,
      2385,
      2373,
      895,
      1769,
      2386,
      1773,
      2375,
      2387,
      2388,
      2377,
      2389,
      2390,
      2391,
      2392,
      206
    ],
  ),
  "alt_route": SymbolsMetadata(
    popularity: 1453,
    codepoint: 0xf184,
    categories: [5],
    tags: [
      1527,
      1579,
      2393,
      2394,
      502,
      2395,
      2396,
      2397,
      677,
      2398,
      2399,
      752,
      2400,
      2401,
      313,
      2402,
      2403,
      1989,
      1617,
      324,
      1059,
      1520,
      2404,
      325,
      70,
      2405,
      1619,
      1620,
      1621,
      2406,
      2407,
      363,
      2408,
      1531,
      2409,
      31,
      1994,
      1623,
      332,
      2410,
      1624
    ],
    rtlAutoMirrored: true,
  ),
  "alternate_email": SymbolsMetadata(
    popularity: 7883,
    codepoint: 0xe0e6,
    categories: [7],
    tags: [
      2411,
      565,
      1493,
      1579,
      2412,
      283,
      965,
      2305,
      44,
      2413,
      2308,
      2310,
      1087,
      259,
      15,
      585,
      523,
      591,
      432,
      433,
      31,
      182,
      2414,
      597,
      333
    ],
  ),
  "altitude": SymbolsMetadata(
    popularity: 107,
    codepoint: 0xf873,
    categories: [3],
    tags: [
      2415,
      1045,
      77,
      78,
      1403,
      1404,
      517,
      373,
      81,
      313,
      2416,
      1052,
      2417,
      234,
      383,
      235,
      51,
      790,
      87,
      226,
      1060,
      1585,
      641,
      242,
      757,
      2418,
      2419,
      1409,
      1696,
      1445
    ],
  ),
  "ambulance": SymbolsMetadata(
    popularity: 30,
    codepoint: 0xf803,
    categories: [14],
    tags: [
      2420,
      2421,
      2422,
      1658,
      865,
      2048,
      1816,
      1818,
      1660,
      2113,
      463,
      1213,
      2342,
      2423,
      137,
      692,
      1765,
      873,
      1766,
      138,
      87,
      1143,
      895,
      1663,
      2424,
      906,
      2425,
      362,
      645,
      392,
      2137,
      979,
      2426,
      2427,
      31,
      1665,
      1994,
      1848,
      1849,
      2428,
      2355,
      1850,
      1562,
      1668
    ],
  ),
  "amend": SymbolsMetadata(
    popularity: 48,
    codepoint: 0xf802,
    categories: [2],
    tags: [
      2429,
      2430,
      2431,
      77,
      502,
      2432,
      2433,
      919,
      2397,
      2434,
      313,
      1567,
      2170,
      2435,
      1229,
      147,
      2436,
      488,
      2437,
      2216,
      2438,
      2439,
      1636,
      325,
      1372,
      1574,
      1575,
      2440,
      758,
      2441,
      1408,
      2442,
      470,
      33,
      2182,
      890,
      1498,
      1465
    ],
  ),
  "amp_stories": SymbolsMetadata(
    popularity: 187,
    codepoint: 0xea13,
    categories: [12],
    tags: [
      2443,
      2444,
      2445,
      517,
      1175,
      621,
      8,
      1726,
      1176,
      584,
      88,
      406,
      2162,
      325,
      2446,
      2447,
      2448,
      2449,
      2450,
      94,
      2451,
      243,
      594,
      595,
      2452,
      2453,
      1445,
      396
    ],
  ),
  "analytics": SymbolsMetadata(
    popularity: 11074,
    codepoint: 0xef3e,
    categories: [9],
    tags: [
      1402,
      1045,
      2454,
      1403,
      1404,
      517,
      919,
      373,
      1405,
      81,
      375,
      929,
      931,
      1052,
      234,
      1055,
      68,
      2455,
      2456,
      226,
      17,
      1060,
      641,
      757,
      2448,
      1408,
      2353,
      2457,
      744,
      1613,
      1070,
      2458,
      2459,
      514
    ],
  ),
  "anchor": SymbolsMetadata(
    popularity: 1268,
    codepoint: 0xf1cd,
    categories: [6],
    tags: [
      1500,
      2460,
      1502,
      284,
      2461,
      1680,
      2462,
      2463,
      2464,
      2465,
      1294,
      2466,
      2467,
      2468,
      2469,
      2470,
      2471,
      325,
      2472,
      2473,
      2474,
      2475,
      2476,
      2419,
      1022,
      1011,
      2477,
      979,
      2478,
      2479,
      332,
      2480
    ],
  ),
  "android": SymbolsMetadata(
    popularity: 3597,
    codepoint: 0xe859,
    categories: [4],
    tags: [
      1286,
      2481,
      2482,
      2483,
      2484,
      2485,
      5,
      2486,
      284,
      288,
      44,
      2487,
      2488,
      1680,
      872,
      2489,
      2466,
      2490,
      262,
      2491,
      2492,
      2493,
      2494,
      1099,
      2495,
      509,
      31,
      1068,
      65,
      2496
    ],
  ),
  "animated_images": SymbolsMetadata(
    popularity: 268,
    codepoint: 0xf49a,
    categories: [0],
    tags: [
      341,
      501,
      504,
      40,
      42,
      344,
      345,
      1302,
      44,
      1229,
      346,
      348,
      1321,
      2497,
      1329,
      2498,
      137,
      138,
      2499,
      406,
      353,
      468,
      354,
      439,
      2162,
      57,
      59,
      62,
      2500,
      2501,
      2502,
      94,
      594,
      2333,
      31,
      2503,
      476
    ],
  ),
  "animation": SymbolsMetadata(
    popularity: 1072,
    codepoint: 0xe71c,
    categories: [1],
    tags: [
      747,
      2504,
      2505,
      341,
      749,
      193,
      1076,
      2506,
      750,
      1252,
      346,
      1051,
      2507,
      51,
      754,
      2508,
      2509,
      353,
      468,
      756,
      757,
      2510,
      2511,
      2107,
      94,
      761,
      291,
      37,
      2512,
      2513,
      764,
      2514
    ],
  ),
  "aod": SymbolsMetadata(
    popularity: 333,
    codepoint: 0xefda,
    categories: [11],
    tags: [
      1223,
      1224,
      1339,
      2515,
      2516,
      2517,
      517,
      2518,
      569,
      283,
      2519,
      288,
      44,
      8,
      1086,
      2520,
      582,
      1230,
      68,
      584,
      585,
      262,
      2521,
      2522,
      2523,
      2524,
      2525,
      609,
      1037,
      271,
      432,
      2526,
      410,
      1695,
      1237,
      525,
      33
    ],
  ),
  "aod_tablet": SymbolsMetadata(
    popularity: 142,
    codepoint: 0xf89f,
    categories: [11],
    tags: [
      1223,
      1224,
      2515,
      2517,
      501,
      283,
      2486,
      288,
      44,
      8,
      2527,
      779,
      1894,
      1086,
      2520,
      581,
      1230,
      138,
      1322,
      1583,
      262,
      439,
      1037,
      271,
      2528,
      432,
      410,
      31,
      525,
      65,
      2529,
      1498
    ],
  ),
  "aod_watch": SymbolsMetadata(
    popularity: 69,
    codepoint: 0xf6ac,
    categories: [11],
    tags: [
      1869,
      1339,
      2516,
      2517,
      2530,
      2531,
      193,
      1135,
      283,
      1048,
      81,
      288,
      44,
      8,
      2532,
      2533,
      1894,
      692,
      1230,
      609,
      410,
      2534,
      2535,
      65,
      1148,
      1149,
      2536,
      1070,
      477,
      2102,
      2537,
      2538,
      2539,
      333,
      2540,
      2541,
      2542
    ],
  ),
  "apartment": SymbolsMetadata(
    popularity: 11316,
    codepoint: 0xea40,
    categories: [16],
    tags: [
      1475,
      1493,
      2543,
      1476,
      1107,
      481,
      918,
      919,
      2544,
      1157,
      1365,
      2545,
      2546,
      2547,
      379,
      1116,
      1479,
      2548,
      584,
      323,
      325,
      1372,
      289,
      2549,
      1480,
      2550,
      1481,
      432,
      1125,
      1482,
      1483,
      1484,
      978,
      2551,
      433,
      945,
      2552,
      1241,
      1486,
      1207,
      2553
    ],
  ),
  "api": SymbolsMetadata(
    popularity: 2911,
    codepoint: 0xf1b7,
    categories: [6],
    tags: [
      858,
      2554,
      501,
      2555,
      1289,
      1673,
      1077,
      2239,
      283,
      519,
      284,
      81,
      1293,
      1080,
      1367,
      2556,
      2557,
      259,
      1294,
      267,
      1099,
      2558,
      645,
      509,
      1068,
      1276,
      65,
      526,
      2559
    ],
  ),
  "apk_document": SymbolsMetadata(
    popularity: 184,
    codepoint: 0xf88e,
    categories: [4],
    tags: [
      1286,
      2560,
      501,
      2154,
      81,
      44,
      1567,
      520,
      1675,
      2561,
      147,
      370,
      137,
      138,
      68,
      1692,
      2562,
      1322,
      262,
      2563,
      1574,
      1575,
      1098,
      1752,
      1576,
      509,
      31,
      1068,
      65,
      141,
      1327,
      1390
    ],
  ),
  "apk_install": SymbolsMetadata(
    popularity: 226,
    codepoint: 0xf88f,
    categories: [4],
    tags: [
      746,
      743,
      1286,
      2560,
      1288,
      501,
      77,
      482,
      504,
      678,
      1302,
      81,
      1567,
      520,
      1675,
      147,
      138,
      1692,
      262,
      886,
      2493,
      289,
      2563,
      1574,
      1575,
      239,
      1065,
      1752,
      509,
      433,
      31,
      1068
    ],
  ),
  "app_badging": SymbolsMetadata(
    popularity: 53,
    codepoint: 0xf72f,
    categories: [2],
    tags: [
      1339,
      2087,
      2564,
      2565,
      281,
      2566,
      193,
      462,
      224,
      1743,
      138,
      51,
      52,
      174,
      585,
      886,
      1647,
      2567,
      609,
      2568,
      1236,
      21,
      2569,
      2570,
      2571,
      328,
      291,
      2572,
      2573,
      2574,
      890,
      2575,
      2428
    ],
  ),
  "app_blocking": SymbolsMetadata(
    popularity: 359,
    codepoint: 0xef3f,
    categories: [11],
    tags: [
      1223,
      1224,
      1028,
      1288,
      2576,
      2577,
      2578,
      501,
      481,
      2579,
      1187,
      1227,
      193,
      345,
      2580,
      288,
      2581,
      2582,
      2583,
      1279,
      1191,
      1086,
      1230,
      550,
      2584,
      262,
      2585,
      1693,
      2586,
      2587,
      2588,
      2589,
      2590,
      2591,
      2592,
      271,
      2593,
      1009,
      2594,
      432,
      1040,
      2526,
      1011,
      1041,
      1203,
      2595,
      525
    ],
  ),
  "app_registration": SymbolsMetadata(
    popularity: 4329,
    codepoint: 0xef40,
    categories: [2],
    tags: [
      858,
      565,
      1537,
      1288,
      2596,
      2565,
      1019,
      1030,
      2597,
      81,
      145,
      44,
      1567,
      1229,
      1568,
      147,
      488,
      2598,
      969,
      68,
      88,
      971,
      1552,
      1575,
      2599,
      591,
      977,
      2600,
      1576,
      2601,
      2602,
      2603,
      1027,
      498
    ],
  ),
  "apparel": SymbolsMetadata(
    popularity: 369,
    codepoint: 0xef7b,
    categories: [8],
    tags: [
      1869,
      2604,
      2605,
      2606,
      2607,
      2608,
      2609,
      2610,
      2611,
      2612,
      2613,
      2614,
      2615,
      2616,
      1356,
      2617,
      2618,
      2619,
      911,
      2620,
      1374,
      2621,
      1375,
      1376,
      1377,
      2180,
      2622,
      2623,
      2624,
      1240,
      2625,
      2626,
      2627
    ],
  ),
  "approval": SymbolsMetadata(
    popularity: 1823,
    codepoint: 0xe982,
    categories: [6],
    tags: [
      2628,
      2629,
      2630,
      2631,
      2632,
      2430,
      2633,
      2634,
      2635,
      1658,
      2636,
      192,
      1660,
      2113,
      463,
      2637,
      2340,
      2638,
      2342,
      1675,
      147,
      2639,
      2640,
      2641,
      1143,
      2642,
      2643,
      2644,
      2645,
      242,
      2646,
      907,
      2647,
      245,
      1665,
      2648,
      2649,
      2650,
      1562,
      1668
    ],
  ),
  "approval_delegation": SymbolsMetadata(
    popularity: 460,
    codepoint: 0xf84a,
    categories: [6],
    tags: [
      2651,
      2633,
      2652,
      2634,
      2635,
      1658,
      2653,
      2654,
      2655,
      2656,
      1660,
      2113,
      193,
      2657,
      2658,
      2659,
      2660,
      2661,
      2662,
      2663,
      2664,
      2665,
      2666,
      2667,
      2093,
      2668,
      2644,
      590,
      2669,
      390,
      2670,
      2671,
      1665,
      526,
      597,
      1562
    ],
  ),
  "apps": SymbolsMetadata(
    popularity: 18935,
    codepoint: 0xe5c3,
    categories: [2],
    tags: [
      2302,
      2672,
      2565,
      2673,
      2674,
      1076,
      1175,
      2675,
      1741,
      1405,
      2676,
      2341,
      1081,
      870,
      2677,
      2678,
      382,
      1322,
      2679,
      506,
      325,
      70,
      1063,
      2494,
      1652,
      2680,
      2681,
      363,
      2682,
      2683,
      509,
      2684,
      1068,
      65,
      1296,
      141,
      1327
    ],
  ),
  "apps_outage": SymbolsMetadata(
    popularity: 1144,
    codepoint: 0xe7cc,
    categories: [2],
    tags: [
      1339,
      2302,
      2685,
      2686,
      2687,
      2688,
      2672,
      2565,
      2689,
      2690,
      2691,
      2692,
      2693,
      1076,
      1175,
      2675,
      1032,
      1081,
      2694,
      2695,
      2678,
      382,
      1322,
      2696,
      2697,
      1036,
      2698,
      2699,
      2700,
      2701,
      433,
      2684,
      2702,
      141,
      1042,
      2703,
      1327,
      206
    ],
  ),
  "aq": SymbolsMetadata(
    popularity: 36,
    codepoint: 0xf55a,
    categories: [10],
    tags: [
      834,
      1902,
      4,
      2704,
      2705,
      567,
      5,
      569,
      2706,
      2707,
      837,
      571,
      283,
      1455,
      2708,
      2709,
      2710,
      2711,
      12,
      16,
      1143,
      585,
      2712,
      1909,
      63,
      2713,
      2714,
      2715,
      593,
      2716,
      31,
      1274,
      33,
      35
    ],
  ),
  "aq_indoor": SymbolsMetadata(
    popularity: 23,
    codepoint: 0xf55b,
    categories: [10],
    tags: [
      834,
      1902,
      4,
      2543,
      1476,
      2704,
      2705,
      918,
      5,
      837,
      1157,
      1477,
      1478,
      12,
      137,
      1116,
      1766,
      2717,
      1479,
      138,
      2718,
      2719,
      2720,
      2721,
      16,
      323,
      324,
      325,
      1372,
      327,
      2712,
      1909,
      1480,
      63,
      1481,
      1483,
      2722,
      1484,
      945,
      31,
      33,
      35
    ],
  ),
  "ar_on_you": SymbolsMetadata(
    popularity: 166,
    codepoint: 0xef7c,
    categories: [0],
    tags: [
      2530,
      2723,
      2724,
      40,
      2725,
      44,
      2726,
      8,
      487,
      1593,
      713,
      2727,
      1595,
      576,
      2728,
      1598,
      83,
      348,
      2488,
      1599,
      1600,
      1601,
      467,
      2729,
      2730,
      1604,
      2731,
      1605,
      1037,
      2732,
      2733,
      590,
      1607,
      2734,
      410,
      1610,
      1612,
      1613,
      65,
      1070,
      396,
      498,
      2735,
      2736
    ],
  ),
  "ar_stickers": SymbolsMetadata(
    popularity: 33,
    codepoint: 0xe983,
    categories: [0],
    tags: [
      743,
      2633,
      2530,
      2723,
      40,
      403,
      621,
      2737,
      2738,
      673,
      2739,
      2740,
      1593,
      1595,
      576,
      1598,
      2741,
      1599,
      490,
      1601,
      1602,
      2742,
      49,
      1605,
      439,
      2732,
      1008,
      57,
      62,
      2743,
      2744,
      2044,
      1610,
      1612,
      243,
      2745,
      1613,
      2746,
      2747
    ],
  ),
  "architecture": SymbolsMetadata(
    popularity: 2065,
    codepoint: 0xea3b,
    categories: [15],
    tags: [
      480,
      1288,
      1476,
      1580,
      918,
      2544,
      309,
      1477,
      485,
      2748,
      378,
      1478,
      2749,
      2547,
      1142,
      1116,
      1479,
      138,
      87,
      2750,
      812,
      640,
      492,
      289,
      1480,
      1481,
      1482,
      2751,
      1484,
      2551,
      979,
      945,
      31,
      511,
      2752,
      1486,
      333
    ],
  ),
  "archive": SymbolsMetadata(
    popularity: 3563,
    codepoint: 0xe149,
    categories: [12],
    tags: [
      2154,
      2753,
      1672,
      2754,
      482,
      2755,
      1175,
      1311,
      81,
      1567,
      147,
      2756,
      2161,
      2757,
      970,
      1323,
      2312,
      2094,
      2758,
      1063,
      92,
      2759,
      453,
      2447,
      2760,
      2761,
      1683,
      95,
      1685,
      1377,
      31,
      1068
    ],
  ),
  "area_chart": SymbolsMetadata(
    popularity: 1115,
    codepoint: 0xe770,
    categories: [9],
    tags: [
      1402,
      1045,
      1107,
      2762,
      2763,
      2764,
      919,
      373,
      2765,
      1405,
      81,
      375,
      2766,
      932,
      1052,
      234,
      1055,
      68,
      1406,
      226,
      17,
      18,
      1060,
      641,
      2767,
      1407,
      757,
      2768,
      1408,
      2769,
      744,
      1070,
      1409,
      2770
    ],
  ),
  "arming_countdown": SymbolsMetadata(
    popularity: 189,
    codepoint: 0xe78a,
    categories: [10],
    tags: [
      1338,
      1339,
      2771,
      193,
      2092,
      2139,
      1743,
      1116,
      2772,
      51,
      87,
      754,
      1119,
      2773,
      2774,
      2569,
      1065,
      757,
      2775,
      760,
      702,
      1127,
      1011,
      1128,
      1561,
      291,
      1148,
      1149,
      764,
      206
    ],
  ),
  "arrow_and_edge": SymbolsMetadata(
    popularity: 83,
    codepoint: 0xf5d7,
    categories: [2],
    tags: [
      500,
      77,
      502,
      2776,
      1108,
      1109,
      2357,
      2777,
      313,
      2402,
      2778,
      599,
      1140,
      2779,
      2780,
      581,
      51,
      2216,
      550,
      87,
      1308,
      325,
      1619,
      328,
      1144,
      1124,
      907,
      1621,
      2781,
      1452,
      2782,
      553,
      1696,
      1390,
      1445
    ],
  ),
  "arrow_back": SymbolsMetadata(
    popularity: 54335,
    codepoint: 0xe5c4,
    categories: [2],
    tags: [
      2783,
      1288,
      501,
      77,
      2433,
      1156,
      504,
      2784,
      2675,
      345,
      313,
      2785,
      1140,
      2786,
      137,
      2757,
      138,
      51,
      1322,
      2216,
      1618,
      325,
      328,
      2787,
      1100,
      2788,
      410,
      2789,
      2790,
      31,
      141,
      2791,
      1327,
      1390,
      333,
      1164
    ],
    rtlAutoMirrored: true,
  ),
  "arrow_back_2": SymbolsMetadata(
    popularity: 80,
    codepoint: 0xf43a,
    categories: [2],
    tags: [
      1288,
      501,
      77,
      2433,
      504,
      2675,
      519,
      345,
      1742,
      1699,
      313,
      902,
      903,
      2792,
      1322,
      259,
      2216,
      1294,
      406,
      262,
      586,
      1701,
      325,
      2500,
      328,
      2787,
      1100,
      907,
      410,
      392,
      2790,
      509,
      31,
      1068,
      65,
      332,
      1718,
      141,
      2791,
      1327,
      37,
      333,
      1164
    ],
  ),
  "arrow_back_ios": SymbolsMetadata(
    popularity: 39467,
    codepoint: 0xe5e0,
    categories: [2],
    tags: [
      2783,
      500,
      1288,
      2793,
      501,
      77,
      2433,
      504,
      2784,
      2675,
      345,
      313,
      2785,
      2664,
      2786,
      2757,
      1322,
      2794,
      2216,
      262,
      586,
      325,
      2493,
      2795,
      2494,
      1144,
      2796,
      2787,
      1100,
      2788,
      410,
      2790,
      2797,
      2798,
      1718,
      141,
      2791,
      1327,
      333,
      1164
    ],
    rtlAutoMirrored: true,
  ),
  "arrow_back_ios_new": SymbolsMetadata(
    popularity: 10895,
    codepoint: 0xe2ea,
    categories: [2],
    tags: [
      2783,
      746,
      1288,
      501,
      77,
      2433,
      504,
      2784,
      2675,
      345,
      313,
      2785,
      2786,
      2757,
      51,
      1322,
      2794,
      2216,
      262,
      586,
      325,
      328,
      2787,
      1100,
      2788,
      410,
      2790,
      2798,
      31,
      1718,
      141,
      1327,
      333,
      1164
    ],
  ),
  "arrow_circle_down": SymbolsMetadata(
    popularity: 2920,
    codepoint: 0xf181,
    categories: [2],
    tags: [
      77,
      504,
      193,
      2799,
      2800,
      345,
      1793,
      313,
      2778,
      520,
      1946,
      1303,
      2719,
      2801,
      325,
      328,
      1144,
      330,
      2802,
      392,
      2803
    ],
  ),
  "arrow_circle_left": SymbolsMetadata(
    popularity: 4191,
    codepoint: 0xeaa7,
    categories: [2],
    tags: [
      77,
      2433,
      504,
      193,
      2804,
      462,
      2805,
      2800,
      345,
      313,
      1946,
      2806,
      2786,
      2757,
      2807,
      2216,
      1618,
      325,
      1144,
      2808,
      2787,
      2809,
      1100,
      2788,
      1010,
      2810,
      2791,
      2811
    ],
    rtlAutoMirrored: true,
  ),
  "arrow_circle_right": SymbolsMetadata(
    popularity: 9138,
    codepoint: 0xeaaa,
    categories: [2],
    tags: [
      1288,
      77,
      2812,
      504,
      193,
      2805,
      1079,
      345,
      313,
      2813,
      902,
      381,
      903,
      137,
      138,
      384,
      2814,
      1294,
      586,
      325,
      904,
      1144,
      1097,
      907,
      1694,
      392,
      31,
      141,
      474,
      1327,
      333
    ],
    rtlAutoMirrored: true,
  ),
  "arrow_circle_up": SymbolsMetadata(
    popularity: 4284,
    codepoint: 0xf182,
    categories: [2],
    tags: [
      746,
      77,
      504,
      193,
      2805,
      345,
      608,
      313,
      2815,
      2816,
      902,
      2817,
      138,
      51,
      2818,
      2819,
      2820,
      325,
      91,
      2821,
      2822,
      2823,
      2824,
      2318,
      1508,
      95,
      31,
      1240,
      1326,
      1696,
      98,
      527
    ],
  ),
  "arrow_cool_down": SymbolsMetadata(
    popularity: 115,
    codepoint: 0xf4b6,
    categories: [15],
    tags: [
      77,
      502,
      1903,
      837,
      838,
      2825,
      841,
      2826,
      2827,
      2399,
      752,
      81,
      2828,
      2829,
      313,
      2778,
      2830,
      2280,
      11,
      2831,
      2533,
      2832,
      1142,
      51,
      790,
      87,
      17,
      18,
      468,
      325,
      1144,
      2833,
      2834,
      2835,
      29,
      2836,
      31,
      855,
      2837,
      1718,
      36,
      856,
      857
    ],
  ),
  "arrow_downward": SymbolsMetadata(
    popularity: 11500,
    codepoint: 0xe5db,
    categories: [2],
    tags: [
      1288,
      501,
      77,
      2799,
      2675,
      1079,
      2838,
      313,
      2778,
      520,
      2839,
      2840,
      1303,
      1690,
      1051,
      902,
      2792,
      1692,
      1322,
      88,
      506,
      2841,
      586,
      325,
      904,
      2842,
      1144,
      2843,
      1683,
      410,
      2802,
      2844,
      2790,
      95,
      31,
      526,
      141,
      1327,
      333,
      1164
    ],
  ),
  "arrow_downward_alt": SymbolsMetadata(
    popularity: 218,
    codepoint: 0xe984,
    categories: [2],
    tags: [
      77,
      502,
      1310,
      504,
      2784,
      2799,
      345,
      313,
      2778,
      520,
      2839,
      1303,
      379,
      2845,
      1582,
      51,
      87,
      2841,
      586,
      325,
      2846,
      328,
      1144,
      961,
      2802,
      1317,
      31,
      526,
      1718,
      1445
    ],
  ),
  "arrow_drop_down": SymbolsMetadata(
    popularity: 33322,
    codepoint: 0xe5c5,
    categories: [2],
    tags: [
      1288,
      501,
      77,
      2847,
      2848,
      2784,
      2799,
      2675,
      345,
      313,
      2778,
      2849,
      2840,
      1303,
      2850,
      2851,
      83,
      51,
      1322,
      88,
      506,
      237,
      325,
      70,
      1144,
      2796,
      410,
      362,
      2852,
      1317,
      2790,
      1972,
      95,
      1718,
      2853,
      141,
      1327,
      333,
      1164
    ],
  ),
  "arrow_drop_down_circle": SymbolsMetadata(
    popularity: 2596,
    codepoint: 0xe5c6,
    categories: [2],
    tags: [
      1288,
      501,
      77,
      504,
      450,
      193,
      2854,
      2855,
      2799,
      2675,
      345,
      313,
      2856,
      2778,
      2830,
      2849,
      2840,
      1303,
      2857,
      2851,
      1322,
      88,
      506,
      325,
      70,
      1144,
      410,
      362,
      363,
      2790,
      141,
      2220,
      1327,
      333,
      1164
    ],
  ),
  "arrow_drop_up": SymbolsMetadata(
    popularity: 6369,
    codepoint: 0xe5c7,
    categories: [2],
    tags: [
      1288,
      501,
      77,
      2848,
      2858,
      2799,
      2859,
      2675,
      345,
      313,
      2860,
      2849,
      2861,
      2840,
      1303,
      2851,
      2862,
      2863,
      2864,
      51,
      1322,
      2360,
      2841,
      325,
      2865,
      2843,
      410,
      2022,
      2866,
      2790,
      2867,
      2868,
      413,
      1718,
      2869,
      141,
      2220,
      1696,
      98,
      1327,
      333,
      1164
    ],
  ),
  "arrow_forward": SymbolsMetadata(
    popularity: 35720,
    codepoint: 0xe5c8,
    categories: [2],
    tags: [
      746,
      1288,
      501,
      77,
      502,
      504,
      2675,
      1079,
      345,
      313,
      2870,
      902,
      1142,
      903,
      51,
      1322,
      2871,
      87,
      1294,
      586,
      325,
      904,
      1619,
      1144,
      1097,
      907,
      1621,
      410,
      392,
      2790,
      31,
      1718,
      141,
      2220,
      1326,
      1327,
      333,
      1164
    ],
    rtlAutoMirrored: true,
  ),
  "arrow_forward_ios": SymbolsMetadata(
    popularity: 45726,
    codepoint: 0xe5e1,
    categories: [2],
    tags: [
      2872,
      1288,
      501,
      77,
      2784,
      2675,
      145,
      313,
      2873,
      2874,
      902,
      903,
      548,
      1054,
      2875,
      1322,
      2794,
      1356,
      1294,
      88,
      237,
      586,
      1618,
      325,
      904,
      2876,
      1574,
      1144,
      2877,
      1097,
      907,
      410,
      2022,
      2790,
      2878,
      141,
      1327,
      333,
      1164
    ],
    rtlAutoMirrored: true,
  ),
  "arrow_insert": SymbolsMetadata(
    popularity: 197,
    codepoint: 0xf837,
    categories: [2],
    tags: [
      743,
      1288,
      501,
      2879,
      77,
      2675,
      312,
      313,
      2778,
      1082,
      381,
      51,
      2880,
      1087,
      1305,
      1322,
      2216,
      2345,
      174,
      586,
      1618,
      325,
      2881,
      327,
      328,
      1144,
      329,
      2882,
      410,
      637,
      2790,
      1204,
      2883,
      141,
      1327,
      333,
      1164
    ],
  ),
  "arrow_left": SymbolsMetadata(
    popularity: 3324,
    codepoint: 0xe5de,
    categories: [2],
    tags: [
      500,
      1288,
      501,
      77,
      2433,
      2884,
      1310,
      2675,
      2885,
      313,
      2886,
      902,
      2786,
      51,
      1322,
      2216,
      87,
      812,
      586,
      325,
      904,
      289,
      328,
      1144,
      2787,
      1100,
      2788,
      907,
      410,
      392,
      1317,
      2790,
      1718,
      141,
      2791,
      1327,
      1624,
      333,
      1164
    ],
    rtlAutoMirrored: true,
  ),
  "arrow_left_alt": SymbolsMetadata(
    popularity: 128,
    codepoint: 0xef7d,
    categories: [2],
    tags: [
      1579,
      2887,
      77,
      502,
      2433,
      2888,
      1310,
      345,
      313,
      2293,
      381,
      2786,
      2757,
      51,
      2216,
      87,
      2889,
      325,
      904,
      2890,
      1144,
      2787,
      1100,
      2788,
      392,
      1452,
      1317,
      979,
      2891,
      31,
      2791,
      2892
    ],
    rtlAutoMirrored: true,
  ),
  "arrow_menu_close": SymbolsMetadata(
    popularity: 28,
    codepoint: 0xf3d3,
    categories: [2],
    tags: [
      746,
      1288,
      501,
      77,
      504,
      2848,
      2784,
      1188,
      2799,
      2675,
      313,
      1140,
      1190,
      137,
      578,
      138,
      467,
      1322,
      2216,
      2893,
      506,
      812,
      2894,
      2895,
      325,
      2876,
      289,
      1749,
      2808,
      907,
      392,
      2896,
      1317,
      2790,
      1147,
      31,
      1718,
      141,
      2220,
      1327,
      333,
      1164
    ],
    rtlAutoMirrored: true,
  ),
  "arrow_menu_open": SymbolsMetadata(
    popularity: 35,
    codepoint: 0xf3d2,
    categories: [2],
    tags: [
      858,
      1288,
      501,
      77,
      504,
      1188,
      2799,
      2675,
      345,
      313,
      8,
      2897,
      1303,
      578,
      2864,
      51,
      1322,
      2216,
      1294,
      506,
      237,
      2895,
      325,
      2876,
      70,
      1749,
      1144,
      2843,
      2898,
      907,
      2022,
      1452,
      2790,
      2899,
      141,
      2900,
      2901,
      1327,
      396,
      333,
      1164
    ],
    rtlAutoMirrored: true,
  ),
  "arrow_or_edge": SymbolsMetadata(
    popularity: 31,
    codepoint: 0xf5d6,
    categories: [2],
    tags: [
      2167,
      500,
      77,
      502,
      1109,
      2784,
      2799,
      2357,
      313,
      2402,
      2778,
      599,
      1303,
      2780,
      2864,
      51,
      550,
      87,
      2893,
      174,
      1308,
      586,
      325,
      904,
      2902,
      1619,
      328,
      1144,
      329,
      2787,
      2843,
      1621,
      637,
      413,
      1718
    ],
  ),
  "arrow_outward": SymbolsMetadata(
    popularity: 2571,
    codepoint: 0xf8ce,
    categories: [2],
    tags: [
      858,
      1288,
      501,
      77,
      502,
      2675,
      284,
      2358,
      2903,
      313,
      1190,
      2904,
      1303,
      2905,
      2906,
      902,
      2907,
      1322,
      2908,
      2909,
      2910,
      1294,
      468,
      1618,
      325,
      2911,
      2912,
      2876,
      2913,
      2914,
      2363,
      1144,
      2915,
      907,
      410,
      1508,
      2844,
      2790,
      141,
      1327,
      2916,
      333,
      1164
    ],
    rtlAutoMirrored: true,
  ),
  "arrow_range": SymbolsMetadata(
    popularity: 154,
    codepoint: 0xf69b,
    categories: [2],
    tags: [
      77,
      502,
      2433,
      2917,
      1109,
      2918,
      9,
      2919,
      2920,
      2207,
      2779,
      2921,
      2831,
      2922,
      581,
      51,
      2216,
      2923,
      550,
      1117,
      87,
      226,
      17,
      2924,
      2808,
      1124,
      2925,
      2926,
      907,
      391,
      2781,
      2927,
      2218
    ],
  ),
  "arrow_right": SymbolsMetadata(
    popularity: 9034,
    codepoint: 0xe5df,
    categories: [2],
    tags: [
      2872,
      500,
      1288,
      501,
      77,
      504,
      2848,
      2784,
      2675,
      2928,
      2929,
      313,
      1082,
      1190,
      902,
      903,
      548,
      51,
      1322,
      87,
      1294,
      586,
      325,
      904,
      1619,
      328,
      1144,
      1097,
      757,
      1100,
      907,
      410,
      1104,
      2790,
      1718,
      141,
      1327,
      1624,
      333,
      1164
    ],
    rtlAutoMirrored: true,
  ),
  "arrow_right_alt": SymbolsMetadata(
    popularity: 18673,
    codepoint: 0xe941,
    categories: [2],
    tags: [
      858,
      1527,
      77,
      2930,
      502,
      504,
      2847,
      2848,
      2784,
      1079,
      145,
      313,
      2931,
      1082,
      1303,
      2932,
      902,
      381,
      903,
      1504,
      51,
      2933,
      87,
      1294,
      586,
      325,
      904,
      1144,
      2808,
      1097,
      2934,
      907,
      2782,
      31
    ],
    rtlAutoMirrored: true,
  ),
  "arrow_selector_tool": SymbolsMetadata(
    popularity: 607,
    codepoint: 0xf82f,
    categories: [6],
    tags: [
      746,
      1738,
      500,
      77,
      502,
      450,
      1790,
      345,
      1793,
      485,
      313,
      2172,
      1140,
      137,
      2792,
      2216,
      87,
      2935,
      2936,
      586,
      468,
      325,
      355,
      2937,
      328,
      1144,
      2808,
      907,
      362,
      363,
      2852,
      392,
      31,
      511,
      1718,
      1696
    ],
  ),
  "arrow_split": SymbolsMetadata(
    popularity: 352,
    codepoint: 0xe985,
    categories: [2],
    tags: [
      77,
      502,
      2938,
      2396,
      2398,
      2939,
      375,
      313,
      2940,
      1112,
      2778,
      1051,
      2941,
      2162,
      2942,
      70,
      2943,
      1065,
      907,
      2407,
      2944,
      703,
      2408,
      2945,
      2946,
      2947,
      2948,
      1696,
      2949
    ],
    rtlAutoMirrored: true,
  ),
  "arrow_top_left": SymbolsMetadata(
    popularity: 35,
    codepoint: 0xf72e,
    categories: [2],
    tags: [
      500,
      77,
      502,
      2433,
      1310,
      2357,
      2358,
      1689,
      313,
      903,
      51,
      2814,
      87,
      812,
      586,
      2889,
      2819,
      325,
      2950,
      328,
      2808,
      2787,
      2951,
      1100,
      1317,
      31,
      2952,
      1848,
      473,
      2791,
      1696,
      2953
    ],
  ),
  "arrow_top_right": SymbolsMetadata(
    popularity: 29,
    codepoint: 0xf72d,
    categories: [2],
    tags: [
      77,
      502,
      1310,
      2358,
      313,
      2931,
      2359,
      1303,
      2954,
      2932,
      2907,
      51,
      2814,
      2955,
      87,
      1294,
      468,
      325,
      2950,
      2956,
      328,
      1144,
      2915,
      179,
      1317,
      1147,
      31,
      2957,
      473,
      1696
    ],
  ),
  "arrow_upload_progress": SymbolsMetadata(
    popularity: 71,
    codepoint: 0xf3f4,
    categories: [2],
    tags: [
      77,
      1403,
      193,
      1673,
      2958,
      2486,
      284,
      2399,
      752,
      81,
      608,
      1567,
      147,
      2959,
      51,
      1692,
      259,
      87,
      2893,
      754,
      2960,
      267,
      523,
      2569,
      757,
      2961,
      2962,
      2963,
      291,
      2964,
      526,
      2965,
      1696,
      527,
      2966,
      2967
    ],
  ),
  "arrow_upload_ready": SymbolsMetadata(
    popularity: 52,
    codepoint: 0xf3f5,
    categories: [2],
    tags: [
      77,
      1403,
      193,
      2958,
      463,
      2399,
      752,
      81,
      608,
      1567,
      2968,
      1690,
      2959,
      2639,
      1692,
      259,
      87,
      586,
      267,
      2569,
      2865,
      1331,
      2969,
      757,
      1332,
      2970,
      2318,
      2971,
      1508,
      291,
      526,
      1718,
      1696,
      527,
      2972,
      2966,
      2967
    ],
  ),
  "arrow_upward": SymbolsMetadata(
    popularity: 14869,
    codepoint: 0xe5d8,
    categories: [2],
    tags: [
      2872,
      1288,
      501,
      77,
      2973,
      1403,
      2784,
      2675,
      313,
      2974,
      2975,
      234,
      235,
      51,
      1322,
      87,
      586,
      2819,
      1618,
      325,
      2795,
      328,
      329,
      757,
      2418,
      410,
      2802,
      2824,
      2318,
      2790,
      95,
      2976,
      1240,
      1718,
      141,
      1696,
      527,
      1719,
      1327,
      333,
      1164
    ],
  ),
  "arrow_upward_alt": SymbolsMetadata(
    popularity: 254,
    codepoint: 0xe986,
    categories: [2],
    tags: [
      1625,
      2977,
      77,
      502,
      313,
      2416,
      902,
      234,
      2978,
      235,
      51,
      87,
      323,
      586,
      2819,
      1618,
      904,
      328,
      1144,
      329,
      757,
      2418,
      2802,
      2824,
      2318,
      1240,
      2979,
      1718,
      1696,
      527,
      1719
    ],
  ),
  "arrow_warm_up": SymbolsMetadata(
    popularity: 140,
    codepoint: 0xf4b5,
    categories: [15],
    tags: [
      2980,
      2504,
      77,
      502,
      78,
      2981,
      2399,
      752,
      1080,
      313,
      2974,
      11,
      2831,
      2533,
      902,
      234,
      2982,
      2983,
      2984,
      2985,
      235,
      51,
      2986,
      2819,
      325,
      641,
      1144,
      242,
      757,
      2987,
      2418,
      2835,
      29,
      275,
      30,
      855,
      2988,
      1696,
      98,
      1719,
      2989,
      2990
    ],
  ),
  "arrows_input": SymbolsMetadata(
    popularity: 107,
    codepoint: 0xf394,
    categories: [2],
    tags: [
      77,
      2991,
      502,
      308,
      81,
      608,
      312,
      313,
      2830,
      520,
      2992,
      1082,
      2959,
      1582,
      2993,
      2994,
      68,
      2995,
      2996,
      1087,
      2997,
      2998,
      323,
      1520,
      2176,
      586,
      327,
      1144,
      961,
      2999,
      1203,
      526,
      1718,
      527,
      2356
    ],
  ),
  "arrows_more_down": SymbolsMetadata(
    popularity: 165,
    codepoint: 0xf8ab,
    categories: [10],
    tags: [
      3000,
      500,
      77,
      502,
      2784,
      837,
      2799,
      621,
      1079,
      345,
      145,
      313,
      2886,
      3001,
      2778,
      1303,
      1116,
      51,
      1966,
      88,
      506,
      237,
      2162,
      325,
      1119,
      904,
      70,
      1144,
      2843,
      2022,
      2085,
      1718,
      141,
      1696
    ],
  ),
  "arrows_more_up": SymbolsMetadata(
    popularity: 361,
    codepoint: 0xf8ac,
    categories: [10],
    tags: [
      500,
      77,
      502,
      504,
      2848,
      2784,
      837,
      2799,
      3002,
      345,
      145,
      313,
      1303,
      3003,
      2864,
      1116,
      51,
      68,
      1966,
      88,
      506,
      237,
      586,
      1618,
      1119,
      328,
      3004,
      2844,
      3005,
      3006,
      2085,
      1718,
      1696
    ],
  ),
  "arrows_output": SymbolsMetadata(
    popularity: 130,
    codepoint: 0xf393,
    categories: [2],
    tags: [
      77,
      502,
      308,
      345,
      312,
      313,
      1140,
      3007,
      1190,
      1690,
      2905,
      902,
      903,
      137,
      138,
      51,
      1322,
      323,
      1520,
      2176,
      586,
      468,
      325,
      2361,
      1732,
      2362,
      327,
      328,
      1097,
      907,
      2318,
      1508,
      1162,
      1203,
      31,
      1068,
      526,
      141,
      2356
    ],
  ),
  "arrows_outward": SymbolsMetadata(
    popularity: 57,
    codepoint: 0xf72c,
    categories: [2],
    tags: [
      1107,
      77,
      502,
      626,
      3008,
      3009,
      377,
      8,
      3001,
      2359,
      1303,
      1313,
      3010,
      1691,
      1304,
      2216,
      2360,
      2876,
      2361,
      2363,
      1407,
      2243,
      907,
      391,
      410,
      2286,
      3011,
      396,
      1165,
      2356,
      3012
    ],
  ),
  "art_track": SymbolsMetadata(
    popularity: 401,
    codepoint: 0xe060,
    categories: [0],
    tags: [
      1320,
      3013,
      1580,
      2155,
      1246,
      1175,
      2158,
      145,
      8,
      1321,
      49,
      68,
      1356,
      1323,
      584,
      88,
      406,
      148,
      1701,
      57,
      59,
      62,
      408,
      432,
      410,
      3014,
      1271,
      433,
      2164,
      2165,
      396,
      2512
    ],
  ),
  "article": SymbolsMetadata(
    popularity: 9177,
    codepoint: 0xef42,
    categories: [12],
    tags: [
      2154,
      2432,
      3015,
      621,
      81,
      1566,
      1567,
      3016,
      3017,
      147,
      3018,
      1681,
      68,
      88,
      2439,
      1573,
      3019,
      1063,
      1574,
      1575,
      3020,
      3021,
      453,
      1408,
      3022,
      1576,
      3023,
      33,
      3024,
      1465
    ],
    rtlAutoMirrored: true,
  ),
  "article_person": SymbolsMetadata(
    popularity: 96,
    codepoint: 0xf368,
    categories: [12],
    tags: [
      565,
      2432,
      3025,
      566,
      3026,
      3027,
      684,
      1020,
      5,
      193,
      621,
      1566,
      1567,
      2435,
      2172,
      576,
      225,
      147,
      872,
      583,
      2446,
      1574,
      1575,
      589,
      590,
      973,
      591,
      3028,
      3029,
      3030,
      3031,
      33,
      597,
      1026,
      3032,
      1465
    ],
  ),
  "article_shortcut": SymbolsMetadata(
    popularity: 88,
    codepoint: 0xf587,
    categories: [12],
    tags: [
      77,
      2432,
      3027,
      1688,
      621,
      313,
      1566,
      1567,
      2778,
      3033,
      147,
      902,
      68,
      2955,
      584,
      1294,
      3034,
      1571,
      325,
      2446,
      3035,
      1460,
      1574,
      1575,
      3029,
      2352,
      3036,
      3037,
      2834,
      179,
      1408,
      907,
      1683,
      1104,
      3038,
      433,
      3039,
      33,
      1465
    ],
  ),
  "artist": SymbolsMetadata(
    popularity: 99,
    codepoint: 0xe01a,
    categories: [0],
    tags: [
      565,
      2155,
      3040,
      3041,
      566,
      2299,
      3042,
      3043,
      576,
      225,
      583,
      3044,
      969,
      1002,
      1701,
      3045,
      3046,
      1460,
      3047,
      589,
      3048,
      590,
      3049,
      1704,
      974,
      3050,
      591,
      976,
      390,
      3051,
      978,
      3052,
      3014,
      597,
      1027
    ],
  ),
  "aspect_ratio": SymbolsMetadata(
    popularity: 1723,
    codepoint: 0xe85b,
    categories: [1],
    tags: [
      2233,
      3053,
      626,
      482,
      2399,
      752,
      486,
      377,
      8,
      1303,
      2241,
      2173,
      49,
      124,
      385,
      406,
      108,
      70,
      57,
      1407,
      3054,
      3055,
      432,
      2243,
      391,
      3056,
      410,
      71,
      392,
      298,
      433,
      1963,
      37,
      367,
      396,
      3057
    ],
  ),
  "assignment": SymbolsMetadata(
    popularity: 7370,
    codepoint: 0xe85d,
    categories: [12],
    tags: [
      3,
      743,
      1659,
      919,
      1660,
      3058,
      463,
      1302,
      1566,
      1567,
      1229,
      3059,
      3060,
      488,
      13,
      88,
      1143,
      3061,
      1372,
      1575,
      3062,
      2599,
      1496,
      1408,
      2722,
      1497,
      3063,
      33,
      1666,
      1498,
      1465
    ],
    rtlAutoMirrored: true,
  ),
  "assignment_add": SymbolsMetadata(
    popularity: 223,
    codepoint: 0xf848,
    categories: [12],
    tags: [
      231,
      3064,
      743,
      1659,
      1920,
      3058,
      3065,
      1302,
      1213,
      1566,
      1567,
      3059,
      1568,
      3060,
      147,
      488,
      3066,
      88,
      886,
      1460,
      1575,
      239,
      1496,
      3067,
      453,
      977,
      2722,
      1576,
      3068,
      1613,
      31,
      1497,
      3069,
      3063,
      33,
      1498,
      1465
    ],
  ),
  "assignment_ind": SymbolsMetadata(
    popularity: 3125,
    codepoint: 0xe85e,
    categories: [12],
    tags: [
      3070,
      565,
      2430,
      501,
      1659,
      920,
      3058,
      2434,
      3071,
      145,
      1566,
      1567,
      1140,
      576,
      147,
      137,
      138,
      2018,
      969,
      3072,
      68,
      1005,
      589,
      590,
      3073,
      591,
      453,
      2600,
      3030,
      392,
      31,
      141,
      597,
      1327
    ],
  ),
  "assignment_late": SymbolsMetadata(
    popularity: 1128,
    codepoint: 0xe85f,
    categories: [12],
    tags: [
      3074,
      1339,
      1659,
      3075,
      1340,
      1341,
      2104,
      1342,
      3058,
      1135,
      3076,
      1345,
      2105,
      1566,
      1567,
      2694,
      3077,
      1346,
      147,
      1347,
      3078,
      3079,
      1143,
      1460,
      609,
      3080,
      1575,
      3081,
      1496,
      1350,
      31,
      1497,
      1148,
      1718,
      2428,
      206
    ],
  ),
  "assignment_return": SymbolsMetadata(
    popularity: 1013,
    codepoint: 0xe860,
    categories: [12],
    tags: [
      77,
      1659,
      3082,
      2433,
      3058,
      3083,
      3084,
      1566,
      1567,
      1229,
      673,
      3059,
      3085,
      3066,
      3086,
      2216,
      3087,
      1575,
      432,
      3088,
      3089,
      3090,
      1100,
      2442,
      3091,
      470,
      2722,
      433,
      3092,
      3093,
      1497,
      2791
    ],
    rtlAutoMirrored: true,
  ),
  "assignment_returned": SymbolsMetadata(
    popularity: 481,
    codepoint: 0xe861,
    categories: [12],
    tags: [
      77,
      1659,
      3094,
      2433,
      3095,
      3096,
      3058,
      1662,
      1566,
      1567,
      2778,
      3059,
      3060,
      1459,
      147,
      2639,
      2161,
      3097,
      3098,
      3066,
      3099,
      1575,
      1100,
      3100,
      3101,
      2722,
      1576,
      3092,
      3093,
      3063,
      2791,
      1498
    ],
  ),
  "assignment_turned_in": SymbolsMetadata(
    popularity: 3022,
    codepoint: 0xe862,
    categories: [12],
    tags: [
      2629,
      1658,
      2653,
      1659,
      1660,
      3095,
      1661,
      2113,
      3102,
      3058,
      463,
      1662,
      1566,
      1567,
      2342,
      3059,
      2639,
      3098,
      3103,
      2994,
      1495,
      88,
      1143,
      3099,
      1372,
      1663,
      1575,
      1496,
      2722,
      362,
      3068,
      3104,
      1497,
      3069,
      1665,
      473,
      3105,
      2355,
      2650,
      1562,
      1498,
      1668
    ],
  ),
  "assist_walker": SymbolsMetadata(
    popularity: 333,
    codepoint: 0xf8d5,
    categories: [5],
    tags: [
      860,
      861,
      2421,
      900,
      865,
      3106,
      3107,
      684,
      1759,
      866,
      3108,
      225,
      871,
      1765,
      873,
      583,
      3109,
      3110,
      895,
      896,
      468,
      3111,
      289,
      590,
      3112,
      3113,
      3114,
      3115,
      978,
      709,
      878,
      3116,
      3117,
      908,
      3118
    ],
    rtlAutoMirrored: true,
  ),
  "assistant_device": SymbolsMetadata(
    popularity: 24,
    codepoint: 0xe987,
    categories: [11],
    tags: [
      3119,
      3120,
      3121,
      1245,
      1246,
      3122,
      1890,
      193,
      3123,
      284,
      345,
      288,
      3124,
      1081,
      2527,
      2488,
      1894,
      1680,
      1086,
      1116,
      3125,
      1479,
      259,
      2489,
      3126,
      640,
      1119,
      267,
      1270,
      1911,
      1899,
      1271,
      1272,
      3127,
      65,
      3128,
      3129,
      278
    ],
  ),
  "assistant_direction": SymbolsMetadata(
    popularity: 1637,
    codepoint: 0xe988,
    categories: [2],
    tags: [
      3130,
      3131,
      77,
      1245,
      312,
      313,
      321,
      2780,
      3132,
      1617,
      3133,
      3134,
      323,
      324,
      1520,
      1618,
      325,
      3135,
      1619,
      326,
      327,
      1144,
      907,
      1620,
      1621,
      1162,
      3136,
      1203,
      1531,
      3137,
      3138,
      332,
      473,
      3139,
      3140
    ],
    rtlAutoMirrored: true,
  ),
  "assistant_navigation": SymbolsMetadata(
    popularity: 2613,
    codepoint: 0xe989,
    categories: [2],
    tags: [
      3120,
      77,
      3121,
      1245,
      3141,
      3142,
      312,
      313,
      3143,
      2341,
      316,
      317,
      3144,
      2780,
      873,
      1259,
      1617,
      2345,
      323,
      324,
      1520,
      174,
      325,
      1619,
      326,
      2881,
      327,
      1144,
      1621,
      1203,
      2782,
      878,
      332,
      1696,
      3128
    ],
  ),
  "assistant_on_hub": SymbolsMetadata(
    popularity: 64,
    codepoint: 0xf6c1,
    categories: [10],
    tags: [
      3145,
      3119,
      3121,
      1245,
      1890,
      1047,
      1048,
      284,
      254,
      1699,
      288,
      44,
      8,
      2527,
      1680,
      1086,
      1116,
      1479,
      1880,
      3146,
      1259,
      1322,
      259,
      2489,
      3126,
      1294,
      623,
      1119,
      267,
      1037,
      3147,
      29,
      410,
      1270,
      1911,
      1899,
      1272,
      65,
      3128,
      278
    ],
  ),
  "assured_workload": SymbolsMetadata(
    popularity: 2239,
    codepoint: 0xeb6f,
    categories: [13],
    tags: [
      565,
      2504,
      2653,
      1659,
      3148,
      3149,
      3150,
      3151,
      914,
      915,
      917,
      918,
      920,
      921,
      3152,
      1660,
      3095,
      922,
      924,
      3153,
      3154,
      2657,
      926,
      927,
      928,
      3155,
      930,
      931,
      934,
      3156,
      3157,
      3158,
      1495,
      938,
      523,
      1095,
      940,
      941,
      3159,
      696,
      3160,
      3161,
      3162,
      702,
      1022,
      3163,
      1011,
      3164,
      1561,
      1497,
      1665,
      3165,
      2650,
      1562,
      1498,
      3166
    ],
  ),
  "asterisk": SymbolsMetadata(
    popularity: 108,
    codepoint: 0xf525,
    categories: [12],
    tags: [
      480,
      1454,
      836,
      5,
      571,
      3167,
      3168,
      3169,
      12,
      3170,
      381,
      1347,
      584,
      3171,
      1143,
      791,
      3172,
      1460,
      818,
      848,
      3173,
      3174,
      179,
      3175,
      3176,
      392,
      851,
      898,
      854,
      31,
      33,
      35,
      3177
    ],
  ),
  "atm": SymbolsMetadata(
    popularity: 522,
    codepoint: 0xe573,
    categories: [9],
    tags: [
      4,
      3178,
      3179,
      3180,
      916,
      917,
      918,
      920,
      1644,
      921,
      3181,
      5,
      922,
      924,
      926,
      927,
      3182,
      928,
      931,
      932,
      3183,
      12,
      3184,
      16,
      323,
      1729,
      324,
      938,
      3185,
      325,
      22,
      523,
      940,
      941,
      1373,
      2057,
      432,
      410,
      645,
      1376,
      3186,
      945,
      31,
      3187,
      33,
      946,
      35,
      3188
    ],
  ),
  "atr": SymbolsMetadata(
    popularity: 1048,
    codepoint: 0xebc7,
    categories: [9],
    tags: [
      3,
      3189,
      3190,
      1688,
      1076,
      3191,
      1743,
      1081,
      3192,
      3193,
      3194,
      1459,
      3195,
      3196,
      1176,
      1115,
      3197,
      3198,
      3199,
      63,
      359,
      203,
      1267,
      3101,
      363,
      3200,
      707,
      3201,
      854,
      1275,
      1240,
      3202,
      3203,
      3204,
      3205,
      1498
    ],
  ),
  "attach_email": SymbolsMetadata(
    popularity: 1116,
    codepoint: 0xea5e,
    categories: [7],
    tags: [
      743,
      3206,
      1670,
      1300,
      3207,
      3208,
      3209,
      1503,
      283,
      1564,
      3210,
      3211,
      1047,
      2305,
      1567,
      2308,
      3212,
      147,
      3213,
      3214,
      15,
      16,
      1294,
      3215,
      2312,
      585,
      1372,
      1575,
      3216,
      3217,
      2318,
      1130
    ],
  ),
  "attach_file": SymbolsMetadata(
    popularity: 7805,
    codepoint: 0xe226,
    categories: [12],
    tags: [
      743,
      1670,
      1298,
      1300,
      3207,
      3209,
      1503,
      1047,
      621,
      81,
      1567,
      3218,
      3219,
      3220,
      147,
      3221,
      3222,
      1294,
      2312,
      406,
      439,
      1372,
      3216,
      3217,
      3223,
      1022,
      3224,
      3225,
      3226,
      527,
      3227
    ],
  ),
  "attach_file_add": SymbolsMetadata(
    popularity: 59,
    codepoint: 0xf841,
    categories: [12],
    tags: [
      231,
      743,
      3206,
      3228,
      1670,
      1499,
      1300,
      3229,
      3230,
      3231,
      3209,
      1503,
      1047,
      1302,
      3232,
      147,
      1306,
      1294,
      3233,
      3215,
      2312,
      406,
      886,
      3234,
      3235,
      3236,
      3217,
      239,
      3237,
      2318,
      1508,
      527,
      3238,
      3239,
      3240,
      3227,
      3241
    ],
  ),
  "attach_file_off": SymbolsMetadata(
    popularity: 14,
    codepoint: 0xf4d9,
    categories: [12],
    tags: [
      743,
      1300,
      3242,
      3209,
      3243,
      481,
      2692,
      3244,
      3245,
      1503,
      3246,
      1279,
      867,
      3247,
      1032,
      3218,
      3248,
      1033,
      147,
      3249,
      3250,
      3251,
      1294,
      3252,
      3253,
      2312,
      406,
      3254,
      3255,
      1035,
      1036,
      1037,
      3217,
      2594,
      3256,
      1041,
      3257,
      3258
    ],
  ),
  "attach_money": SymbolsMetadata(
    popularity: 14076,
    codepoint: 0xe227,
    categories: [9],
    tags: [
      3259,
      223,
      1300,
      916,
      917,
      919,
      1643,
      920,
      921,
      193,
      922,
      924,
      1047,
      1398,
      926,
      927,
      3260,
      928,
      954,
      3261,
      931,
      932,
      956,
      3262,
      936,
      1294,
      3263,
      938,
      1037,
      523,
      940,
      941,
      1401,
      3264,
      1653,
      3265,
      3266,
      1376,
      31,
      946,
      36,
      948
    ],
  ),
  "attachment": SymbolsMetadata(
    popularity: 3125,
    codepoint: 0xe2bc,
    categories: [12],
    tags: [
      1670,
      1300,
      3209,
      1503,
      283,
      1564,
      1047,
      3267,
      1567,
      2435,
      3268,
      2308,
      147,
      49,
      3269,
      3270,
      1294,
      1372,
      3271,
      3217,
      3272,
      3021,
      2318,
      1508,
      3273,
      3240,
      3227
    ],
  ),
  "attractions": SymbolsMetadata(
    popularity: 884,
    codepoint: 0xea52,
    categories: [16],
    tags: [
      3274,
      2504,
      3275,
      3276,
      3277,
      193,
      312,
      779,
      10,
      3278,
      3279,
      2741,
      381,
      1974,
      1530,
      1975,
      584,
      1520,
      3280,
      327,
      2549,
      3281,
      3282,
      2059,
      3283,
      3284,
      3285,
      3286,
      332,
      1945,
      1952,
      396,
      3287
    ],
  ),
  "attribution": SymbolsMetadata(
    popularity: 764,
    codepoint: 0xefdb,
    categories: [7],
    tags: [
      565,
      3288,
      3289,
      3290,
      3025,
      684,
      3291,
      193,
      621,
      3292,
      3293,
      3294,
      926,
      3295,
      583,
      68,
      52,
      2438,
      3296,
      3297,
      1143,
      406,
      3298,
      589,
      1783,
      590,
      591,
      3299,
      3300,
      3301,
      2044,
      735,
      2647,
      31,
      3302,
      597,
      37,
      3303,
      3304
    ],
  ),
  "audio_description": SymbolsMetadata(
    popularity: 36,
    codepoint: 0xf58c,
    categories: [0],
    tags: [
      860,
      1738,
      4,
      1246,
      3305,
      3306,
      517,
      3307,
      5,
      3308,
      345,
      3309,
      866,
      2079,
      216,
      12,
      3310,
      16,
      790,
      584,
      406,
      354,
      3311,
      3312,
      355,
      410,
      3022,
      71,
      1271,
      3313,
      3314,
      1272,
      31,
      33,
      2045,
      35,
      37,
      3315,
      3316,
      554,
      1866
    ],
  ),
  "audio_file": SymbolsMetadata(
    popularity: 717,
    codepoint: 0xeb82,
    categories: [0],
    tags: [
      743,
      1246,
      517,
      373,
      345,
      1302,
      81,
      44,
      1566,
      1567,
      520,
      2079,
      147,
      370,
      1052,
      1088,
      584,
      406,
      1701,
      1460,
      409,
      390,
      1271,
      65,
      97,
      2164,
      35,
      527,
      3317,
      554,
      1866,
      3318
    ],
  ),
  "audio_video_receiver": SymbolsMetadata(
    popularity: 18,
    codepoint: 0xf5d3,
    categories: [11],
    tags: [
      2444,
      3319,
      2088,
      1246,
      3320,
      461,
      3321,
      1075,
      3322,
      1047,
      345,
      288,
      44,
      2532,
      779,
      46,
      1116,
      3323,
      1087,
      3324,
      406,
      679,
      1732,
      408,
      3325,
      432,
      3326,
      1271,
      3327,
      411,
      3328,
      1068,
      65,
      412,
      3329,
      2045,
      37,
      3330,
      2735
    ],
  ),
  "auto_awesome_mosaic": SymbolsMetadata(
    popularity: 733,
    codepoint: 0xe660,
    categories: [1],
    tags: [
      1738,
      1320,
      76,
      1580,
      2048,
      3331,
      3332,
      2284,
      3333,
      1175,
      1302,
      485,
      8,
      1229,
      673,
      3334,
      713,
      370,
      1321,
      382,
      1176,
      49,
      385,
      3335,
      2162,
      92,
      3336,
      57,
      3337,
      1407,
      3338,
      2449,
      2684,
      945,
      3339,
      396
    ],
  ),
  "auto_awesome_motion": SymbolsMetadata(
    popularity: 914,
    codepoint: 0xe661,
    categories: [1],
    tags: [
      1133,
      1738,
      341,
      2633,
      2048,
      3331,
      3332,
      3340,
      3333,
      1302,
      3341,
      485,
      1229,
      673,
      487,
      3334,
      83,
      1329,
      3342,
      137,
      1115,
      49,
      2985,
      3198,
      353,
      70,
      57,
      71,
      3343,
      3344,
      854,
      3345,
      37,
      476
    ],
  ),
  "auto_delete": SymbolsMetadata(
    popularity: 1138,
    codepoint: 0xea4c,
    categories: [6],
    tags: [
      2048,
      3346,
      3331,
      3347,
      2754,
      1875,
      3348,
      778,
      1135,
      3349,
      3350,
      1136,
      1031,
      3351,
      3352,
      3353,
      3354,
      3355,
      3356,
      1009,
      1039,
      1145,
      1011,
      3357,
      1148,
      3358,
      3359,
      1149,
      3360
    ],
  ),
  "auto_read_pause": SymbolsMetadata(
    popularity: 291,
    codepoint: 0xf219,
    categories: [7],
    tags: [
      77,
      2432,
      1246,
      3361,
      2048,
      3362,
      2138,
      567,
      569,
      571,
      572,
      621,
      345,
      2139,
      1567,
      902,
      3363,
      1280,
      406,
      352,
      585,
      1201,
      3364,
      3365,
      408,
      3366,
      3367,
      2834,
      1694,
      1271,
      593,
      1203,
      31,
      33,
      3368,
      1718,
      2883,
      1277
    ],
  ),
  "auto_read_play": SymbolsMetadata(
    popularity: 436,
    codepoint: 0xf216,
    categories: [7],
    tags: [
      860,
      1246,
      3369,
      2048,
      3331,
      567,
      569,
      571,
      572,
      3370,
      345,
      584,
      1280,
      3371,
      406,
      585,
      1701,
      3312,
      2500,
      3365,
      408,
      3366,
      3367,
      1271,
      3372,
      593,
      3373,
      2218,
      3368,
      1718,
      3374,
      1277,
      554,
      3318
    ],
  ),
  "auto_stories": SymbolsMetadata(
    popularity: 4932,
    codepoint: 0xe666,
    categories: [1],
    tags: [
      3064,
      2432,
      2048,
      3375,
      1688,
      3376,
      1175,
      621,
      3377,
      3059,
      3378,
      2780,
      68,
      3379,
      3086,
      1323,
      3380,
      3381,
      3382,
      3383,
      3384,
      3029,
      2834,
      3385,
      3386,
      2452,
      3387,
      3388,
      3389,
      3390
    ],
  ),
  "auto_towing": SymbolsMetadata(
    popularity: 36,
    codepoint: 0xe71e,
    categories: [14],
    tags: [
      2420,
      865,
      2048,
      1816,
      3391,
      1818,
      1819,
      1502,
      1345,
      313,
      2423,
      3392,
      3393,
      3394,
      873,
      2465,
      2986,
      1520,
      3395,
      3396,
      1682,
      2425,
      1620,
      3397,
      645,
      2535,
      3398,
      3399,
      3400,
      1848,
      1623,
      1849,
      1850,
      206,
      3401
    ],
  ),
  "auto_transmission": SymbolsMetadata(
    popularity: 50,
    codepoint: 0xf53f,
    categories: [14],
    tags: [
      2048,
      3331,
      3402,
      1816,
      3403,
      1818,
      3404,
      345,
      1405,
      1675,
      2051,
      902,
      1780,
      3405,
      3406,
      51,
      3407,
      635,
      813,
      3408,
      3280,
      2788,
      151,
      3409,
      3410,
      31,
      1068,
      65,
      2074,
      1623,
      1850
    ],
  ),
  "autofps_select": SymbolsMetadata(
    popularity: 154,
    codepoint: 0xefdc,
    categories: [1],
    tags: [
      3411,
      1738,
      4,
      341,
      2048,
      3331,
      5,
      373,
      519,
      345,
      2885,
      81,
      44,
      8,
      12,
      347,
      348,
      349,
      350,
      351,
      1052,
      51,
      68,
      16,
      87,
      226,
      18,
      353,
      3412,
      356,
      641,
      63,
      359,
      360,
      361,
      362,
      71,
      675,
      275,
      744,
      31,
      65,
      33,
      35,
      37
    ],
  ),
  "automation": SymbolsMetadata(
    popularity: 565,
    codepoint: 0xf421,
    categories: [12],
    tags: [
      1738,
      3120,
      3121,
      2048,
      3331,
      1890,
      3413,
      1778,
      678,
      1742,
      574,
      3414,
      2749,
      1780,
      3415,
      2456,
      1729,
      3198,
      1004,
      3416,
      3417,
      3418,
      1095,
      3412,
      1065,
      674,
      2495,
      2835,
      2136,
      71,
      1068,
      65,
      2949,
      1130
    ],
  ),
  "autopause": SymbolsMetadata(
    popularity: 51,
    codepoint: 0xf6b6,
    categories: [0],
    tags: [
      460,
      77,
      1246,
      3331,
      3419,
      1890,
      3420,
      3421,
      504,
      678,
      345,
      1742,
      2399,
      752,
      2139,
      216,
      1084,
      2456,
      1603,
      2998,
      754,
      352,
      679,
      635,
      1701,
      70,
      1201,
      408,
      3422,
      912,
      758,
      2441,
      470,
      71,
      1270,
      1271,
      291,
      1203,
      411,
      762,
      3358,
      413,
      37
    ],
  ),
  "autoplay": SymbolsMetadata(
    popularity: 71,
    codepoint: 0xf6b5,
    categories: [0],
    tags: [
      3423,
      460,
      77,
      1246,
      3331,
      3424,
      193,
      3425,
      2805,
      284,
      750,
      345,
      1742,
      2399,
      752,
      779,
      1294,
      2998,
      754,
      755,
      406,
      407,
      439,
      1701,
      904,
      2500,
      408,
      1704,
      756,
      758,
      2441,
      3426,
      470,
      94,
      71,
      1271,
      454,
      411,
      762,
      37
    ],
  ),
  "autorenew": SymbolsMetadata(
    popularity: 12809,
    codepoint: 0xe863,
    categories: [2],
    tags: [
      746,
      460,
      77,
      502,
      3427,
      3428,
      3429,
      193,
      462,
      750,
      3430,
      751,
      313,
      2293,
      3431,
      2998,
      3432,
      755,
      352,
      468,
      325,
      3422,
      1065,
      3433,
      758,
      759,
      2441,
      3426,
      470,
      3434,
      471,
      472,
      762,
      3435,
      473,
      2946,
      890,
      2949
    ],
  ),
  "autostop": SymbolsMetadata(
    popularity: 22,
    codepoint: 0xf682,
    categories: [0],
    tags: [
      746,
      501,
      460,
      77,
      1246,
      3331,
      3436,
      504,
      3437,
      1078,
      345,
      1742,
      2399,
      752,
      2207,
      3438,
      3439,
      1084,
      1142,
      3363,
      2871,
      2141,
      2998,
      754,
      407,
      679,
      1701,
      1201,
      408,
      409,
      1098,
      453,
      440,
      758,
      2441,
      470,
      1271,
      433,
      1203,
      762,
      3440,
      3441,
      2220,
      37
    ],
  ),
  "av1": SymbolsMetadata(
    popularity: 16,
    codepoint: 0xf4b0,
    categories: [0],
    tags: [
      72,
      565,
      1018,
      4,
      3442,
      461,
      566,
      3443,
      1020,
      504,
      5,
      193,
      3444,
      104,
      8,
      3445,
      225,
      12,
      872,
      3446,
      3447,
      583,
      138,
      16,
      971,
      406,
      354,
      3448,
      267,
      178,
      590,
      591,
      976,
      977,
      28,
      330,
      410,
      1012,
      978,
      243,
      31,
      33,
      2045,
      35,
      3449,
      597,
      3450
    ],
  ),
  "av_timer": SymbolsMetadata(
    popularity: 1354,
    codepoint: 0xe01b,
    categories: [0],
    tags: [
      1339,
      1657,
      461,
      2091,
      193,
      1135,
      2092,
      224,
      2105,
      8,
      2117,
      3451,
      2666,
      3452,
      226,
      3453,
      609,
      1144,
      1350,
      330,
      1145,
      361,
      3454,
      3455,
      3456,
      3457,
      1148,
      2099,
      1149,
      3458,
      2102
    ],
  ),
  "avc": SymbolsMetadata(
    popularity: 16,
    codepoint: 0xf4af,
    categories: [0],
    tags: [
      1738,
      2233,
      3459,
      4,
      1246,
      3460,
      5,
      3444,
      345,
      3461,
      104,
      8,
      2079,
      12,
      1257,
      3447,
      16,
      790,
      1280,
      3462,
      406,
      3463,
      3464,
      354,
      3448,
      1701,
      1281,
      409,
      912,
      28,
      391,
      410,
      71,
      3465,
      1271,
      1272,
      31,
      33,
      413,
      2045,
      35,
      1326,
      3466,
      37,
      554,
      3467
    ],
  ),
  "avg_pace": SymbolsMetadata(
    popularity: 121,
    codepoint: 0xf6bb,
    categories: [15],
    tags: [
      2504,
      1402,
      3468,
      1135,
      2399,
      752,
      81,
      2117,
      11,
      2533,
      3469,
      226,
      18,
      3453,
      3470,
      3471,
      641,
      757,
      27,
      359,
      453,
      227,
      29,
      361,
      275,
      3472,
      744,
      3456,
      1148,
      1149,
      1070,
      2988,
      909,
      3473
    ],
  ),
  "avg_time": SymbolsMetadata(
    popularity: 104,
    codepoint: 0xf813,
    categories: [15],
    tags: [
      1045,
      3468,
      789,
      193,
      1135,
      81,
      2117,
      3414,
      2533,
      2666,
      692,
      2134,
      138,
      51,
      174,
      3474,
      226,
      17,
      18,
      2135,
      623,
      3471,
      641,
      1144,
      1408,
      360,
      275,
      744,
      3456,
      31,
      1148,
      1149,
      1070,
      36,
      2102,
      3475
    ],
  ),
  "award_star": SymbolsMetadata(
    popularity: 343,
    codepoint: 0xf612,
    categories: [6],
    tags: [
      3,
      3189,
      281,
      3190,
      1688,
      6,
      3476,
      3477,
      3193,
      3194,
      968,
      3478,
      3169,
      379,
      381,
      1143,
      3479,
      328,
      3480,
      63,
      203,
      1267,
      3101,
      3481,
      3482,
      3301,
      392,
      1317,
      979,
      854,
      245,
      1240,
      3483,
      3484,
      3485
    ],
  ),
  "azm": SymbolsMetadata(
    popularity: 102,
    codepoint: 0xf6ec,
    categories: [15],
    tags: [
      747,
      3486,
      2504,
      3487,
      3488,
      3489,
      3490,
      3491,
      748,
      749,
      193,
      284,
      81,
      11,
      3492,
      2831,
      2533,
      1142,
      3493,
      51,
      87,
      754,
      3453,
      267,
      2774,
      756,
      757,
      2511,
      3494,
      761,
      3472,
      291,
      3495,
      764,
      3473,
      1131
    ],
  ),
  "baby_changing_station": SymbolsMetadata(
    popularity: 641,
    codepoint: 0xf19b,
    categories: [5],
    tags: [
      860,
      3496,
      3497,
      3498,
      3499,
      684,
      1759,
      3500,
      3501,
      984,
      987,
      3502,
      3503,
      1001,
      3504,
      692,
      583,
      1881,
      3505,
      1003,
      3506,
      323,
      895,
      3507,
      3508,
      3509,
      3510,
      1007,
      3511,
      3512,
      589,
      590,
      906,
      327,
      3513,
      3514,
      3515,
      2683,
      1162,
      3516,
      31,
      3517,
      3518,
      3519,
      3520,
      999
    ],
  ),
  "back_hand": SymbolsMetadata(
    popularity: 2068,
    codepoint: 0xe764,
    categories: [8],
    tags: [
      3521,
      3522,
      2433,
      3523,
      3524,
      3525,
      2663,
      660,
      3526,
      2664,
      2666,
      3527,
      583,
      3528,
      3529,
      3530,
      3531,
      2876,
      3532,
      3533,
      3534,
      590,
      3535,
      3536,
      3537,
      1203,
      3538,
      3539,
      1866
    ],
  ),
  "back_to_tab": SymbolsMetadata(
    popularity: 31,
    codepoint: 0xf72b,
    categories: [2],
    tags: [
      77,
      2433,
      1310,
      313,
      3143,
      348,
      2786,
      872,
      2757,
      51,
      2216,
      3540,
      87,
      3541,
      468,
      1618,
      328,
      1144,
      2787,
      3542,
      3543,
      1100,
      2788,
      1317,
      3544,
      2891,
      473,
      2791,
      1696,
      1165
    ],
  ),
  "background_dot_large": SymbolsMetadata(
    popularity: 17,
    codepoint: 0xf79e,
    categories: [1],
    tags: [
      480,
      3491,
      3545,
      3546,
      462,
      1137,
      3547,
      1743,
      1081,
      3548,
      3549,
      3550,
      382,
      51,
      3551,
      3552,
      3553,
      385,
      174,
      812,
      818,
      328,
      330,
      392,
      3554,
      3555,
      3556,
      3557,
      707,
      433,
      3005
    ],
  ),
  "background_dot_small": SymbolsMetadata(
    popularity: 20,
    codepoint: 0xf514,
    categories: [1],
    tags: [
      480,
      1339,
      3491,
      1310,
      3546,
      193,
      462,
      3547,
      1743,
      1081,
      3549,
      381,
      3550,
      382,
      1115,
      51,
      385,
      174,
      812,
      609,
      328,
      330,
      392,
      273,
      1317,
      3558,
      3557,
      707,
      3283,
      433,
      3559,
      1326,
      3560,
      3561
    ],
  ),
  "background_grid_small": SymbolsMetadata(
    popularity: 32,
    codepoint: 0xf79d,
    categories: [1],
    tags: [
      624,
      3562,
      1447,
      3491,
      3563,
      3564,
      373,
      3565,
      485,
      8,
      3566,
      378,
      673,
      1142,
      1052,
      382,
      3567,
      385,
      87,
      584,
      17,
      70,
      1063,
      3336,
      3568,
      71,
      3569,
      707,
      2231,
      2684,
      945,
      3570,
      3571,
      396
    ],
  ),
  "background_replace": SymbolsMetadata(
    popularity: 1348,
    codepoint: 0xf20a,
    categories: [6],
    tags: [
      3572,
      3573,
      3574,
      3491,
      3575,
      40,
      2397,
      3576,
      2358,
      1229,
      2172,
      487,
      83,
      583,
      49,
      3577,
      3578,
      584,
      1636,
      492,
      289,
      3336,
      589,
      590,
      57,
      3579,
      59,
      62,
      3580,
      3581,
      363,
      978,
      3582,
      3583,
      3584,
      3570,
      511,
      3585,
      597,
      37,
      3586
    ],
  ),
  "backlight_high": SymbolsMetadata(
    popularity: 13,
    codepoint: 0xf7ed,
    categories: [4],
    tags: [
      2233,
      3587,
      3588,
      3589,
      3590,
      345,
      288,
      8,
      3591,
      3592,
      3342,
      1086,
      3447,
      3593,
      2814,
      1089,
      790,
      3594,
      3595,
      623,
      328,
      3596,
      410,
      151,
      71,
      3201,
      854,
      1586,
      3597,
      65,
      474,
      3598
    ],
  ),
  "backlight_high_off": SymbolsMetadata(
    popularity: 13,
    codepoint: 0xf4ef,
    categories: [4],
    tags: [
      2233,
      3587,
      3588,
      3589,
      3590,
      345,
      288,
      3599,
      867,
      8,
      2532,
      1033,
      3600,
      1200,
      1089,
      3594,
      623,
      1035,
      1036,
      1037,
      410,
      71,
      1041,
      65,
      1042,
      3598,
      476
    ],
  ),
  "backlight_low": SymbolsMetadata(
    popularity: 15,
    codepoint: 0xf7ec,
    categories: [4],
    tags: [
      2233,
      3587,
      3588,
      3590,
      345,
      288,
      3601,
      3602,
      8,
      3603,
      137,
      3604,
      138,
      3605,
      1089,
      790,
      3594,
      1968,
      812,
      262,
      3606,
      410,
      71,
      1586,
      31,
      65,
      141,
      1327
    ],
  ),
  "backpack": SymbolsMetadata(
    popularity: 979,
    codepoint: 0xf19c,
    categories: [15],
    tags: [
      3607,
      2433,
      3608,
      1641,
      3375,
      3609,
      3610,
      3611,
      3612,
      3613,
      3614,
      3059,
      1780,
      3615,
      3616,
      1617,
      3617,
      3618,
      1836,
      3619,
      3620,
      3621,
      2722,
      1685,
      3622,
      332,
      3623,
      1945,
      1952
    ],
  ),
  "backspace": SymbolsMetadata(
    popularity: 9080,
    codepoint: 0xe14a,
    categories: [2],
    tags: [
      77,
      2433,
      3624,
      482,
      504,
      1187,
      5,
      778,
      519,
      345,
      2340,
      1031,
      1229,
      673,
      1568,
      3352,
      488,
      1087,
      3625,
      1089,
      2216,
      325,
      2890,
      2447,
      1039,
      31,
      33,
      1718,
      2414,
      141,
      2791,
      1327
    ],
    rtlAutoMirrored: true,
  ),
  "backup": SymbolsMetadata(
    popularity: 2056,
    codepoint: 0xe864,
    categories: [6],
    tags: [
      2154,
      77,
      1672,
      1673,
      2486,
      1724,
      81,
      1448,
      44,
      1567,
      520,
      1675,
      3626,
      147,
      3627,
      2161,
      2757,
      259,
      1004,
      267,
      696,
      1682,
      3628,
      1683,
      1011,
      2971,
      1685,
      763,
      1068,
      65,
      526,
      1696,
      527
    ],
  ),
  "backup_table": SymbolsMetadata(
    popularity: 821,
    codepoint: 0xef43,
    categories: [6],
    tags: [
      2154,
      1672,
      1673,
      923,
      1724,
      81,
      1448,
      1567,
      1675,
      3626,
      147,
      3627,
      370,
      382,
      2757,
      385,
      88,
      3629,
      696,
      3628,
      1440,
      1683,
      1011,
      1441,
      594,
      1685,
      762,
      763,
      1453,
      893
    ],
  ),
  "badge": SymbolsMetadata(
    popularity: 11660,
    codepoint: 0xea67,
    categories: [13],
    tags: [
      565,
      3,
      566,
      3189,
      281,
      920,
      192,
      1539,
      3477,
      3630,
      3193,
      576,
      3631,
      3632,
      3633,
      583,
      2598,
      3634,
      2018,
      87,
      3479,
      3635,
      289,
      589,
      590,
      3480,
      591,
      63,
      3636,
      1267,
      3482,
      3301,
      1011,
      392,
      31,
      597,
      1562,
      3485,
      1498
    ],
  ),
  "badge_critical_battery": SymbolsMetadata(
    popularity: 345,
    codepoint: 0xf147,
    categories: [4],
    tags: [
      1339,
      281,
      1403,
      3637,
      1342,
      1227,
      3638,
      3076,
      1345,
      3639,
      288,
      3640,
      809,
      3641,
      3642,
      1086,
      138,
      51,
      3643,
      790,
      1968,
      3463,
      262,
      609,
      3644,
      3645,
      273,
      291,
      31,
      1068,
      206,
      3646
    ],
  ),
  "bakery_dining": SymbolsMetadata(
    popularity: 1353,
    codepoint: 0xea53,
    categories: [16],
    tags: [
      3647,
      3648,
      3649,
      3650,
      3651,
      3652,
      3653,
      3654,
      3655,
      3656,
      3657,
      3658,
      3659,
      2370,
      3660,
      2372,
      3661,
      506,
      3662,
      3663,
      3664,
      3665,
      3666,
      3667,
      3668,
      3669,
      1453,
      3670
    ],
  ),
  "balance": SymbolsMetadata(
    popularity: 2918,
    codepoint: 0xeaf6,
    categories: [11],
    tags: [
      914,
      3671,
      3672,
      3673,
      925,
      2939,
      2263,
      1802,
      3674,
      3675,
      3676,
      1628,
      3677,
      3678,
      3679,
      3680,
      2438,
      226,
      17,
      492,
      3681,
      3054,
      391,
      3682,
      3683,
      3684,
      31,
      3685,
      3686,
      3687,
      2108,
      3688,
      3689
    ],
  ),
  "balcony": SymbolsMetadata(
    popularity: 407,
    codepoint: 0xe58f,
    categories: [8],
    tags: [
      1475,
      2543,
      1476,
      3690,
      918,
      3691,
      2547,
      3692,
      379,
      1116,
      2717,
      1479,
      2548,
      3693,
      3694,
      1520,
      3695,
      2361,
      1836,
      3696,
      2362,
      327,
      1480,
      3697,
      2550,
      1481,
      1482,
      1483,
      3698,
      3699,
      945,
      3700,
      3286,
      332,
      1952,
      3701,
      396,
      1165
    ],
  ),
  "ballot": SymbolsMetadata(
    popularity: 1470,
    codepoint: 0xe172,
    categories: [12],
    tags: [
      3702,
      482,
      3703,
      1660,
      3704,
      1661,
      677,
      3705,
      1567,
      3706,
      2240,
      488,
      934,
      935,
      88,
      1143,
      289,
      1575,
      328,
      3707,
      3708,
      3709,
      432,
      363,
      433,
      1613,
      1497,
      1666,
      3203,
      3710,
      3711,
      3712
    ],
  ),
  "bar_chart": SymbolsMetadata(
    popularity: 7656,
    codepoint: 0xe26b,
    categories: [9],
    tags: [
      1402,
      1045,
      1403,
      1404,
      517,
      919,
      373,
      923,
      1405,
      81,
      3713,
      375,
      931,
      3714,
      1052,
      234,
      3715,
      1055,
      68,
      226,
      1060,
      641,
      757,
      792,
      1408,
      3716,
      744,
      3717,
      1070,
      2458,
      3718,
      514
    ],
  ),
  "bar_chart_4_bars": SymbolsMetadata(
    popularity: 440,
    codepoint: 0xf681,
    categories: [9],
    tags: [
      1402,
      1045,
      1404,
      517,
      919,
      373,
      3671,
      3719,
      81,
      375,
      931,
      2831,
      2533,
      1052,
      234,
      3720,
      3721,
      3722,
      235,
      1055,
      68,
      226,
      17,
      18,
      1060,
      3723,
      641,
      757,
      432,
      1408,
      2353,
      744,
      245,
      1070,
      1409,
      1445,
      514
    ],
  ),
  "bar_chart_off": SymbolsMetadata(
    popularity: 19,
    codepoint: 0xf411,
    categories: [9],
    tags: [
      1402,
      1045,
      1403,
      3724,
      3725,
      517,
      481,
      3726,
      2284,
      919,
      373,
      81,
      1138,
      375,
      867,
      3727,
      931,
      1052,
      1199,
      1200,
      1055,
      584,
      226,
      1060,
      757,
      432,
      3338,
      1408,
      1041,
      744,
      3728,
      1070,
      1042,
      514
    ],
  ),
  "barcode": SymbolsMetadata(
    popularity: 2451,
    codepoint: 0xe70b,
    categories: [9],
    tags: [
      480,
      3729,
      1077,
      924,
      81,
      44,
      2613,
      2018,
      68,
      3730,
      584,
      2054,
      1143,
      3731,
      1733,
      1401,
      1652,
      3732,
      2447,
      1374,
      1736,
      1737,
      1375,
      1376,
      433,
      1377,
      3733,
      31,
      182,
      1070,
      3734,
      3735
    ],
  ),
  "barcode_reader": SymbolsMetadata(
    popularity: 33,
    codepoint: 0xf85c,
    categories: [9],
    tags: [
      1288,
      3729,
      40,
      42,
      1077,
      81,
      44,
      2613,
      3736,
      2018,
      68,
      3730,
      584,
      1729,
      262,
      1401,
      1652,
      3732,
      3737,
      432,
      1374,
      1736,
      1737,
      1102,
      1375,
      1376,
      433,
      3582,
      182,
      65
    ],
  ),
  "barcode_scanner": SymbolsMetadata(
    popularity: 2941,
    codepoint: 0xe70c,
    categories: [9],
    tags: [
      3729,
      40,
      1397,
      1077,
      81,
      44,
      2613,
      2018,
      68,
      3730,
      87,
      3738,
      3739,
      3336,
      1401,
      1652,
      3732,
      3740,
      3366,
      3737,
      1374,
      1736,
      1737,
      1375,
      1376,
      433,
      3733,
      182,
      65,
      3734,
      3735
    ],
  ),
  "barefoot": SymbolsMetadata(
    popularity: 65,
    codepoint: 0xf871,
    categories: [3],
    tags: [
      3521,
      806,
      3741,
      3525,
      689,
      3742,
      3743,
      3744,
      3745,
      3746,
      3747,
      3748,
      1829,
      692,
      583,
      2640,
      1617,
      3749,
      1143,
      1833,
      289,
      1619,
      1734,
      3750,
      3751,
      3752,
      3753,
      3754,
      3755,
      2164,
      3756,
      332,
      909,
      3475
    ],
  ),
  "batch_prediction": SymbolsMetadata(
    popularity: 677,
    codepoint: 0xf0f5,
    categories: [6],
    tags: [
      3120,
      3757,
      1402,
      3121,
      3179,
      3758,
      3759,
      3760,
      1175,
      3761,
      81,
      3762,
      1677,
      1051,
      1176,
      3763,
      3764,
      1056,
      3594,
      3765,
      2162,
      1732,
      3766,
      3767,
      1065,
      756,
      1705,
      2353,
      1180,
      595,
      1068,
      554
    ],
  ),
  "bath_outdoor": SymbolsMetadata(
    popularity: 41,
    codepoint: 0xf6fb,
    categories: [15],
    tags: [
      3768,
      3769,
      3770,
      3771,
      3772,
      567,
      3773,
      193,
      1827,
      2982,
      2984,
      3774,
      3775,
      3776,
      2717,
      3777,
      3778,
      1975,
      584,
      3779,
      1836,
      2362,
      3780,
      3781,
      432,
      1930,
      3782,
      3783,
      433,
      3784,
      3785,
      1952,
      3786,
      2480,
      3475
    ],
  ),
  "bath_private": SymbolsMetadata(
    popularity: 34,
    codepoint: 0xf6fa,
    categories: [15],
    tags: [
      1475,
      2543,
      3769,
      3770,
      3771,
      3499,
      3787,
      684,
      3788,
      3789,
      3790,
      1116,
      2984,
      3774,
      3775,
      3776,
      2717,
      3791,
      583,
      1881,
      2719,
      1975,
      3792,
      3793,
      3779,
      589,
      590,
      911,
      1009,
      975,
      1930,
      1483,
      3782,
      3794,
      3795,
      3783,
      3784,
      332,
      3796,
      1952,
      3797,
      2480,
      3475
    ],
  ),
  "bath_public_large": SymbolsMetadata(
    popularity: 20,
    codepoint: 0xf6f9,
    categories: [15],
    tags: [
      860,
      1914,
      3769,
      3770,
      3771,
      3772,
      3499,
      684,
      918,
      313,
      3798,
      1176,
      2984,
      3774,
      3775,
      3776,
      583,
      1881,
      138,
      2719,
      3506,
      323,
      324,
      174,
      3779,
      589,
      590,
      327,
      1144,
      2057,
      3515,
      3799,
      645,
      3800,
      1162,
      3783,
      3784,
      31,
      3801,
      332,
      3802,
      2480
    ],
  ),
  "bathroom": SymbolsMetadata(
    popularity: 532,
    codepoint: 0xefdd,
    categories: [8],
    tags: [
      861,
      1914,
      3769,
      3499,
      918,
      2607,
      3503,
      3798,
      225,
      1804,
      1116,
      1479,
      583,
      3506,
      323,
      3803,
      324,
      3804,
      325,
      590,
      327,
      3805,
      3806,
      3807,
      3515,
      1884,
      645,
      3800,
      978,
      3808,
      709,
      3801,
      3809,
      3810,
      3802,
      2480,
      3811,
      3520,
      3812
    ],
  ),
  "bathtub": SymbolsMetadata(
    popularity: 1293,
    codepoint: 0xea41,
    categories: [8],
    tags: [
      3769,
      3772,
      3499,
      3813,
      3787,
      3814,
      808,
      3788,
      1116,
      2717,
      583,
      1881,
      3815,
      3816,
      590,
      3805,
      1950,
      1930,
      3799,
      3817,
      3818,
      3800,
      3819,
      3820,
      3783,
      332,
      3796,
      3810,
      3797,
      3821,
      2480,
      3475
    ],
  ),
  "battery_0_bar": SymbolsMetadata(
    popularity: 1139,
    codepoint: 0xebdc,
    categories: [4],
    tags: [
      1339,
      1403,
      3637,
      1227,
      3638,
      3076,
      288,
      3640,
      809,
      3641,
      138,
      51,
      3643,
      790,
      1968,
      3463,
      262,
      271,
      3645,
      432,
      291,
      525,
      206,
      3646
    ],
  ),
  "battery_1_bar": SymbolsMetadata(
    popularity: 822,
    codepoint: 0xebd9,
    categories: [4],
    tags: [
      3822,
      3823,
      3824,
      1403,
      3637,
      1227,
      3638,
      3825,
      519,
      288,
      3826,
      809,
      3641,
      2296,
      3827,
      581,
      51,
      3643,
      790,
      1968,
      3463,
      262,
      3828,
      271,
      3645,
      432,
      291,
      3829
    ],
  ),
  "battery_2_bar": SymbolsMetadata(
    popularity: 603,
    codepoint: 0xebe0,
    categories: [4],
    tags: [
      3830,
      3831,
      1403,
      3637,
      3832,
      3833,
      1227,
      3638,
      3834,
      288,
      3826,
      3641,
      2240,
      1894,
      3604,
      51,
      790,
      1968,
      3835,
      3463,
      262,
      3644,
      2528,
      3645,
      3836,
      2447,
      3837,
      291,
      3838,
      3839
    ],
  ),
  "battery_3_bar": SymbolsMetadata(
    popularity: 812,
    codepoint: 0xebdd,
    categories: [4],
    tags: [
      3840,
      1403,
      3637,
      3841,
      3842,
      3832,
      3843,
      3844,
      1227,
      3638,
      3845,
      3641,
      3846,
      2240,
      3827,
      3604,
      51,
      3847,
      790,
      3835,
      3463,
      2176,
      262,
      3644,
      3645,
      3848,
      3849,
      3836,
      3850,
      3851,
      291,
      2300
    ],
  ),
  "battery_4_bar": SymbolsMetadata(
    popularity: 1234,
    codepoint: 0xebe2,
    categories: [4],
    tags: [
      676,
      3852,
      1403,
      517,
      3637,
      3853,
      1227,
      3638,
      193,
      288,
      3641,
      3854,
      2246,
      2296,
      51,
      3643,
      790,
      262,
      3644,
      271,
      3645,
      432,
      3855,
      2526,
      3856,
      291,
      525,
      2300
    ],
  ),
  "battery_5_bar": SymbolsMetadata(
    popularity: 1726,
    codepoint: 0xebd4,
    categories: [4],
    tags: [
      3857,
      517,
      3637,
      1227,
      3638,
      3825,
      288,
      3640,
      2527,
      3641,
      3854,
      3858,
      3859,
      2296,
      3827,
      3860,
      51,
      790,
      584,
      3463,
      262,
      3861,
      3644,
      3645,
      3862,
      432,
      291,
      2964,
      3863,
      1445
    ],
  ),
  "battery_6_bar": SymbolsMetadata(
    popularity: 1054,
    codepoint: 0xebd2,
    categories: [4],
    tags: [
      3864,
      3852,
      1403,
      517,
      3637,
      3844,
      1227,
      3638,
      3834,
      3865,
      288,
      3640,
      3641,
      3846,
      2296,
      3866,
      3447,
      3867,
      51,
      790,
      3463,
      262,
      3868,
      800,
      3869,
      3644,
      3645,
      3849,
      291,
      3646
    ],
  ),
  "battery_alert": SymbolsMetadata(
    popularity: 792,
    codepoint: 0xe19c,
    categories: [4],
    tags: [
      3074,
      1339,
      1340,
      3637,
      1342,
      1227,
      3638,
      3076,
      1345,
      3870,
      3641,
      2694,
      1346,
      3871,
      1347,
      3872,
      1143,
      262,
      609,
      271,
      3645,
      291,
      31,
      3873,
      1718,
      206
    ],
  ),
  "battery_android_0": SymbolsMetadata(
    popularity: 8,
    codepoint: 0xf30d,
    categories: [4],
    tags: [
      1286,
      1403,
      3637,
      3832,
      3833,
      1227,
      282,
      3638,
      3834,
      3874,
      288,
      2527,
      809,
      3641,
      51,
      790,
      1968,
      262,
      271,
      3645,
      3875,
      3836,
      432,
      291,
      525,
      65,
      1445,
      3646
    ],
  ),
  "battery_android_1": SymbolsMetadata(
    popularity: 10,
    codepoint: 0xf30c,
    categories: [4],
    tags: [
      1339,
      1286,
      1403,
      3637,
      1227,
      3638,
      2486,
      288,
      44,
      8,
      3640,
      3641,
      3827,
      138,
      51,
      790,
      3463,
      262,
      609,
      3644,
      271,
      2528,
      3645,
      3876,
      432,
      3877,
      291,
      31,
      3873,
      1326
    ],
  ),
  "battery_android_2": SymbolsMetadata(
    popularity: 10,
    codepoint: 0xf30b,
    categories: [4],
    tags: [
      1286,
      3637,
      3878,
      1227,
      3638,
      3825,
      288,
      3640,
      3879,
      3880,
      3641,
      3866,
      1894,
      3867,
      138,
      51,
      3881,
      790,
      3872,
      262,
      271,
      3645,
      3882,
      151,
      735,
      291,
      31,
      1068,
      525
    ],
  ),
  "battery_android_3": SymbolsMetadata(
    popularity: 8,
    codepoint: 0xf30a,
    categories: [4],
    tags: [
      1286,
      1403,
      3637,
      1227,
      3638,
      288,
      3640,
      3641,
      2240,
      3827,
      1086,
      138,
      51,
      790,
      1968,
      3835,
      262,
      289,
      3644,
      271,
      3645,
      757,
      2447,
      3855,
      3877,
      291,
      31,
      1068,
      3883,
      551
    ],
  ),
  "battery_android_4": SymbolsMetadata(
    popularity: 17,
    codepoint: 0xf309,
    categories: [4],
    tags: [
      3884,
      1286,
      3637,
      3885,
      3832,
      3886,
      3844,
      1227,
      3638,
      3834,
      288,
      3887,
      3870,
      3641,
      3846,
      51,
      790,
      3872,
      262,
      3888,
      3644,
      271,
      3889,
      3645,
      3849,
      3836,
      3890,
      291
    ],
  ),
  "battery_android_5": SymbolsMetadata(
    popularity: 25,
    codepoint: 0xf308,
    categories: [4],
    tags: [
      1286,
      1403,
      3637,
      1227,
      3638,
      3865,
      288,
      3640,
      2532,
      3641,
      660,
      2296,
      1086,
      692,
      51,
      790,
      262,
      3644,
      271,
      242,
      3645,
      3875,
      432,
      3855,
      1010,
      1127,
      2450,
      291,
      1068,
      65,
      1295
    ],
  ),
  "battery_android_6": SymbolsMetadata(
    popularity: 22,
    codepoint: 0xf307,
    categories: [4],
    tags: [
      680,
      1286,
      1403,
      3637,
      3853,
      1227,
      3638,
      3865,
      288,
      8,
      3641,
      2240,
      2296,
      3827,
      581,
      138,
      51,
      790,
      17,
      18,
      262,
      289,
      3644,
      641,
      271,
      3645,
      432,
      3891,
      291,
      1068
    ],
  ),
  "battery_android_alert": SymbolsMetadata(
    popularity: 7,
    codepoint: 0xf306,
    categories: [4],
    tags: [
      3074,
      1339,
      1286,
      1340,
      3637,
      1342,
      1227,
      3638,
      3076,
      1345,
      288,
      3880,
      3641,
      2694,
      1346,
      3871,
      1347,
      51,
      790,
      3872,
      1143,
      262,
      609,
      3892,
      271,
      3645,
      3849,
      432,
      3877,
      645,
      291,
      2964,
      31,
      1068,
      1718,
      2428,
      206
    ],
  ),
  "battery_android_bolt": SymbolsMetadata(
    popularity: 14,
    codepoint: 0xf305,
    categories: [4],
    tags: [
      1286,
      3637,
      3893,
      3853,
      1227,
      3638,
      3825,
      288,
      3640,
      3641,
      2240,
      1894,
      51,
      3894,
      790,
      3895,
      1968,
      3463,
      262,
      271,
      2528,
      3645,
      432,
      392,
      1695,
      291,
      31,
      65,
      3896
    ],
  ),
  "battery_android_full": SymbolsMetadata(
    popularity: 17,
    codepoint: 0xf304,
    categories: [4],
    tags: [
      1286,
      3637,
      3853,
      1227,
      3638,
      3865,
      463,
      3322,
      288,
      3640,
      3826,
      3641,
      968,
      2296,
      138,
      51,
      68,
      790,
      262,
      609,
      271,
      3645,
      3875,
      291,
      2964,
      31,
      1068,
      525
    ],
  ),
  "battery_android_plus": SymbolsMetadata(
    popularity: 10,
    codepoint: 0xf303,
    categories: [4],
    tags: [
      231,
      743,
      1286,
      1403,
      3637,
      282,
      3638,
      3825,
      288,
      3879,
      3641,
      2240,
      3866,
      3827,
      138,
      235,
      51,
      790,
      3463,
      262,
      886,
      239,
      240,
      242,
      3645,
      3849,
      2447,
      3897,
      291,
      31,
      65
    ],
  ),
  "battery_android_question": SymbolsMetadata(
    popularity: 11,
    codepoint: 0xf302,
    categories: [4],
    tags: [
      3898,
      1339,
      1286,
      865,
      3637,
      3844,
      1227,
      3638,
      3825,
      3899,
      288,
      3641,
      873,
      293,
      68,
      3872,
      3900,
      262,
      271,
      3645,
      3849,
      3081,
      3901,
      2352,
      3902,
      3903,
      432,
      433,
      291,
      878,
      31,
      525,
      3904,
      3905,
      3906,
      206
    ],
  ),
  "battery_android_share": SymbolsMetadata(
    popularity: 7,
    codepoint: 0xf301,
    categories: [4],
    tags: [
      1286,
      3907,
      77,
      502,
      3637,
      3908,
      3909,
      729,
      1227,
      3638,
      3825,
      3910,
      284,
      81,
      288,
      2199,
      1743,
      3641,
      1690,
      87,
      1294,
      262,
      267,
      1732,
      328,
      3645,
      907,
      2318,
      1508,
      2286,
      3911,
      3912,
      526
    ],
  ),
  "battery_android_shield": SymbolsMetadata(
    popularity: 8,
    codepoint: 0xf300,
    categories: [4],
    tags: [
      1286,
      3913,
      3637,
      3878,
      3844,
      1227,
      1539,
      3638,
      3914,
      288,
      3887,
      3641,
      3846,
      692,
      3915,
      790,
      262,
      3916,
      271,
      3645,
      3849,
      3836,
      1009,
      975,
      1560,
      3917,
      696,
      3161,
      3918,
      1022,
      1011,
      1561,
      291,
      1562
    ],
  ),
  "battery_change": SymbolsMetadata(
    popularity: 9,
    codepoint: 0xf7eb,
    categories: [4],
    tags: [
      1579,
      3637,
      1227,
      2397,
      3638,
      751,
      288,
      3640,
      2532,
      3641,
      3261,
      3827,
      51,
      790,
      3919,
      3900,
      3920,
      3463,
      262,
      2528,
      3645,
      3921,
      3581,
      2526,
      645,
      433,
      291,
      3922,
      3584,
      2409
    ],
  ),
  "battery_charging_20": SymbolsMetadata(
    popularity: 426,
    codepoint: 0xf0a2,
    categories: [4],
    tags: [
      3824,
      3637,
      3833,
      3893,
      1227,
      3638,
      3825,
      3899,
      284,
      288,
      3640,
      3923,
      3879,
      3641,
      3846,
      51,
      3894,
      790,
      3895,
      1968,
      3872,
      3900,
      262,
      271,
      3924,
      3645,
      3836,
      432,
      291,
      525,
      3896,
      3829
    ],
  ),
  "battery_charging_30": SymbolsMetadata(
    popularity: 285,
    codepoint: 0xf0a3,
    categories: [4],
    tags: [
      340,
      3637,
      3893,
      1227,
      3638,
      3825,
      3640,
      3641,
      2296,
      51,
      3894,
      790,
      3895,
      3925,
      1968,
      3872,
      262,
      3926,
      3644,
      326,
      3927,
      3645,
      3928,
      291,
      3929,
      3930,
      3896,
      3931
    ],
  ),
  "battery_charging_50": SymbolsMetadata(
    popularity: 389,
    codepoint: 0xf0a4,
    categories: [4],
    tags: [
      3932,
      3637,
      3893,
      1227,
      3638,
      3825,
      288,
      8,
      3640,
      1140,
      3641,
      137,
      3604,
      138,
      51,
      3894,
      3643,
      790,
      3895,
      1968,
      3463,
      262,
      623,
      609,
      271,
      3645,
      757,
      291,
      31,
      525,
      3896,
      141
    ],
  ),
  "battery_charging_60": SymbolsMetadata(
    popularity: 322,
    codepoint: 0xf0a5,
    categories: [4],
    tags: [
      3933,
      3637,
      3842,
      3893,
      1227,
      3638,
      3934,
      3825,
      3899,
      288,
      3640,
      3879,
      3641,
      2240,
      51,
      3894,
      3643,
      790,
      3895,
      3925,
      1968,
      262,
      3935,
      3644,
      271,
      3645,
      3848,
      3849,
      3875,
      3936,
      291,
      525,
      3896
    ],
  ),
  "battery_charging_80": SymbolsMetadata(
    popularity: 424,
    codepoint: 0xf0a6,
    categories: [4],
    tags: [
      3937,
      3938,
      3637,
      3878,
      3893,
      1227,
      3638,
      3865,
      3825,
      3939,
      284,
      288,
      3940,
      3640,
      3923,
      3941,
      3879,
      3641,
      3846,
      2296,
      51,
      3894,
      3643,
      790,
      3895,
      754,
      1968,
      262,
      3644,
      271,
      3924,
      3645,
      3875,
      757,
      291,
      525,
      3896
    ],
  ),
  "battery_charging_90": SymbolsMetadata(
    popularity: 446,
    codepoint: 0xf0a7,
    categories: [4],
    tags: [
      3864,
      3852,
      3637,
      3842,
      3893,
      1227,
      3638,
      3934,
      3942,
      3834,
      3825,
      288,
      3640,
      3923,
      3641,
      3846,
      3943,
      2296,
      51,
      3894,
      3643,
      790,
      3895,
      1968,
      262,
      3944,
      3644,
      271,
      3645,
      3849,
      3836,
      291,
      525,
      3896
    ],
  ),
  "battery_charging_full": SymbolsMetadata(
    popularity: 2270,
    codepoint: 0xe1a3,
    categories: [4],
    tags: [
      3637,
      3893,
      3853,
      1227,
      3638,
      3865,
      3825,
      3945,
      463,
      284,
      288,
      3640,
      3879,
      2527,
      3641,
      2296,
      1894,
      51,
      3894,
      790,
      3895,
      1968,
      262,
      3924,
      3645,
      3946,
      3947,
      432,
      291,
      31,
      65,
      3948,
      3896
    ],
  ),
  "battery_error": SymbolsMetadata(
    popularity: 31,
    codepoint: 0xf7ea,
    categories: [4],
    tags: [
      1339,
      3637,
      1187,
      1342,
      1227,
      3638,
      3825,
      778,
      1188,
      1213,
      1345,
      3949,
      3870,
      3641,
      2694,
      1346,
      1190,
      1628,
      3078,
      3643,
      790,
      3872,
      3950,
      262,
      3254,
      609,
      271,
      239,
      3645,
      3836,
      3081,
      432,
      1039,
      1203,
      525,
      2108,
      206,
      3712,
      3951
    ],
  ),
  "battery_full": SymbolsMetadata(
    popularity: 2667,
    codepoint: 0xe1a4,
    categories: [4],
    tags: [
      1403,
      3637,
      3842,
      3833,
      3843,
      1227,
      3638,
      288,
      3870,
      2527,
      3641,
      3846,
      2296,
      3866,
      3952,
      1894,
      51,
      790,
      3953,
      262,
      3644,
      3645,
      3954,
      3836,
      2447,
      273,
      3955,
      291,
      65
    ],
  ),
  "battery_full_alt": SymbolsMetadata(
    popularity: 1174,
    codepoint: 0xf13b,
    categories: [4],
    tags: [
      3956,
      3637,
      3832,
      3833,
      1227,
      3638,
      3865,
      463,
      3870,
      3640,
      2527,
      3641,
      2296,
      3866,
      3957,
      3958,
      1894,
      51,
      790,
      3463,
      262,
      3645,
      3836,
      432,
      273,
      291,
      642,
      65,
      1295
    ],
  ),
  "battery_horiz_000": SymbolsMetadata(
    popularity: 295,
    codepoint: 0xf8ae,
    categories: [10],
    tags: [
      1403,
      3637,
      3832,
      3833,
      3844,
      1227,
      3638,
      288,
      3959,
      3960,
      3640,
      3879,
      2532,
      809,
      3641,
      3827,
      1116,
      581,
      51,
      3643,
      790,
      1968,
      262,
      1119,
      289,
      271,
      3645,
      432,
      291,
      525,
      65,
      3646
    ],
  ),
  "battery_horiz_050": SymbolsMetadata(
    popularity: 502,
    codepoint: 0xf8af,
    categories: [10],
    tags: [
      1403,
      3637,
      3832,
      3833,
      3844,
      3853,
      1227,
      3638,
      288,
      2532,
      3641,
      633,
      3961,
      3962,
      3963,
      3964,
      692,
      1116,
      581,
      51,
      3643,
      790,
      3463,
      262,
      1119,
      3644,
      3645,
      432,
      3855,
      291,
      3302
    ],
  ),
  "battery_horiz_075": SymbolsMetadata(
    popularity: 834,
    codepoint: 0xf8b0,
    categories: [10],
    tags: [
      3965,
      3966,
      3637,
      3842,
      3878,
      3844,
      1227,
      3638,
      3834,
      3825,
      288,
      3887,
      3640,
      3879,
      3641,
      2296,
      1116,
      581,
      51,
      3643,
      790,
      262,
      1119,
      271,
      3645,
      3954,
      3849,
      3928,
      3851,
      291,
      525,
      3967
    ],
  ),
  "battery_low": SymbolsMetadata(
    popularity: 709,
    codepoint: 0xf155,
    categories: [4],
    tags: [
      1339,
      1403,
      3637,
      3833,
      3968,
      1227,
      3638,
      3076,
      3969,
      288,
      2532,
      3880,
      3641,
      3827,
      1116,
      581,
      51,
      3643,
      3900,
      3463,
      262,
      623,
      1119,
      271,
      3645,
      3849,
      432,
      291,
      525,
      3302,
      206,
      3970
    ],
  ),
  "battery_plus": SymbolsMetadata(
    popularity: 24,
    codepoint: 0xf7e9,
    categories: [4],
    tags: [
      231,
      743,
      3637,
      3638,
      3825,
      3640,
      3641,
      692,
      581,
      235,
      51,
      790,
      895,
      3463,
      886,
      3644,
      239,
      242,
      3645,
      432,
      3897,
      1162,
      433,
      31,
      1445
    ],
  ),
  "battery_profile": SymbolsMetadata(
    popularity: 190,
    codepoint: 0xe206,
    categories: [10],
    tags: [
      565,
      501,
      566,
      3637,
      2397,
      3638,
      193,
      678,
      3971,
      574,
      145,
      288,
      3641,
      225,
      1780,
      872,
      1116,
      583,
      51,
      293,
      68,
      790,
      1004,
      1119,
      70,
      590,
      911,
      1751,
      3645,
      912,
      591,
      1011,
      645,
      71,
      1012,
      978,
      291,
      31,
      65,
      3302,
      597
    ],
  ),
  "battery_saver": SymbolsMetadata(
    popularity: 431,
    codepoint: 0xefde,
    categories: [4],
    tags: [
      231,
      743,
      3972,
      3637,
      3973,
      3842,
      3832,
      3878,
      3974,
      3975,
      3976,
      3638,
      3825,
      3977,
      3978,
      3979,
      3980,
      3981,
      3900,
      3982,
      886,
      3983,
      239,
      3645,
      3984,
      3985,
      432,
      3986,
      3897,
      71,
      31
    ],
  ),
  "battery_share": SymbolsMetadata(
    popularity: 6,
    codepoint: 0xf67e,
    categories: [4],
    tags: [
      743,
      77,
      502,
      3637,
      2917,
      1227,
      3638,
      3825,
      283,
      284,
      288,
      2199,
      2527,
      3641,
      3261,
      1894,
      3987,
      3643,
      262,
      2162,
      3988,
      271,
      239,
      240,
      242,
      3645,
      961,
      432,
      907,
      3877,
      1508,
      2408,
      762,
      525,
      526,
      3989
    ],
  ),
  "battery_status_good": SymbolsMetadata(
    popularity: 27,
    codepoint: 0xf67d,
    categories: [4],
    tags: [
      1658,
      1403,
      3637,
      1227,
      3638,
      3865,
      1660,
      2113,
      463,
      288,
      2342,
      3640,
      2532,
      3641,
      2296,
      3866,
      1894,
      3990,
      692,
      51,
      3643,
      790,
      262,
      1663,
      3644,
      271,
      3645,
      432,
      3855,
      3991,
      3877,
      362,
      291,
      525,
      65,
      1295,
      1665,
      2355,
      1562,
      1668
    ],
  ),
  "battery_unknown": SymbolsMetadata(
    popularity: 427,
    codepoint: 0xe1a6,
    categories: [4],
    tags: [
      3898,
      1288,
      865,
      3637,
      1227,
      3638,
      3825,
      284,
      81,
      288,
      2532,
      809,
      3641,
      2296,
      1894,
      137,
      873,
      3447,
      138,
      51,
      293,
      68,
      790,
      1968,
      262,
      3644,
      3645,
      3875,
      3901,
      3903,
      291,
      878,
      31,
      141,
      3905,
      333
    ],
    rtlAutoMirrored: true,
  ),
  "battery_very_low": SymbolsMetadata(
    popularity: 439,
    codepoint: 0xf156,
    categories: [4],
    tags: [
      1339,
      1403,
      3637,
      1342,
      1227,
      3638,
      3076,
      1345,
      3639,
      288,
      3640,
      809,
      3641,
      3642,
      1086,
      1116,
      581,
      138,
      51,
      3643,
      790,
      1968,
      3463,
      262,
      1119,
      609,
      3644,
      3645,
      273,
      291,
      31,
      1068,
      206,
      3646
    ],
  ),
  "beach_access": SymbolsMetadata(
    popularity: 2239,
    codepoint: 0xeb3e,
    categories: [16],
    tags: [
      858,
      2504,
      3992,
      3993,
      3994,
      312,
      3995,
      1974,
      1975,
      2473,
      3996,
      3997,
      2549,
      3282,
      1950,
      1930,
      3782,
      3998,
      2419,
      3999,
      1845,
      1586,
      4000,
      4001,
      3286,
      332,
      1945,
      4002,
      4003,
      1952
    ],
  ),
  "bed": SymbolsMetadata(
    popularity: 3284,
    codepoint: 0xefdf,
    categories: [8],
    tags: [
      2543,
      1915,
      4004,
      4005,
      4006,
      1921,
      3001,
      4007,
      1478,
      2296,
      4008,
      1116,
      1766,
      4009,
      2717,
      1479,
      4010,
      4011,
      3793,
      4012,
      4013,
      4014,
      4015,
      4016,
      4017,
      4018,
      1950,
      1482,
      1932,
      1884,
      4019,
      298,
      1935,
      1936
    ],
  ),
  "bedroom_baby": SymbolsMetadata(
    popularity: 566,
    codepoint: 0xefe0,
    categories: [8],
    tags: [
      3497,
      3498,
      1915,
      4004,
      1759,
      984,
      4020,
      987,
      1921,
      4021,
      4022,
      4023,
      1001,
      4008,
      990,
      1116,
      4024,
      1479,
      3505,
      2720,
      991,
      623,
      4014,
      3509,
      3510,
      1007,
      1932,
      4025,
      1884,
      4026,
      702,
      1011,
      1935,
      1936,
      3517,
      999
    ],
  ),
  "bedroom_child": SymbolsMetadata(
    popularity: 392,
    codepoint: 0xefe1,
    categories: [8],
    tags: [
      1475,
      3498,
      1915,
      4004,
      918,
      984,
      987,
      4027,
      4022,
      4023,
      4008,
      1116,
      2717,
      1479,
      3505,
      2720,
      991,
      1003,
      3793,
      4015,
      3510,
      4017,
      1932,
      1884,
      298,
      1935,
      1936,
      1972,
      3517,
      4028,
      999
    ],
  ),
  "bedroom_parent": SymbolsMetadata(
    popularity: 605,
    codepoint: 0xefe2,
    categories: [8],
    tags: [
      4029,
      1915,
      4004,
      918,
      984,
      987,
      4023,
      3001,
      1478,
      1001,
      2296,
      4008,
      990,
      1116,
      2717,
      1479,
      1003,
      4011,
      4015,
      1007,
      4030,
      4017,
      4018,
      1930,
      1483,
      1932,
      1884,
      4031,
      1935,
      1936,
      945
    ],
  ),
  "bedtime": SymbolsMetadata(
    popularity: 2150,
    codepoint: 0xef44,
    categories: [3],
    tags: [
      4032,
      4005,
      4033,
      4034,
      4035,
      778,
      4036,
      4037,
      837,
      4038,
      4039,
      4040,
      4041,
      4042,
      4043,
      1116,
      4044,
      4045,
      4046,
      1119,
      4015,
      4047,
      4048,
      4049,
      2126,
      4050,
      1930,
      1932,
      1011,
      2128,
      1935,
      4051,
      707,
      4052,
      2085,
      1148,
      856
    ],
  ),
  "bedtime_off": SymbolsMetadata(
    popularity: 291,
    codepoint: 0xeb76,
    categories: [3],
    tags: [
      747,
      4005,
      504,
      778,
      837,
      4053,
      867,
      4054,
      1116,
      138,
      1200,
      51,
      4044,
      635,
      4046,
      1119,
      4015,
      4047,
      1035,
      1036,
      975,
      2126,
      1932,
      1011,
      1283,
      1041,
      1935,
      4051,
      4052,
      291,
      31,
      2085,
      1148,
      413,
      856,
      4055
    ],
  ),
  "beenhere": SymbolsMetadata(
    popularity: 1354,
    codepoint: 0xe52d,
    categories: [5],
    tags: [
      4056,
      1658,
      2154,
      2879,
      4057,
      4058,
      1688,
      1660,
      4059,
      3095,
      463,
      2657,
      312,
      2342,
      3194,
      1528,
      4060,
      4061,
      52,
      1530,
      1323,
      323,
      324,
      1143,
      174,
      325,
      1663,
      326,
      327,
      328,
      329,
      4062,
      3366,
      2834,
      4063,
      3482,
      1683,
      4064,
      362,
      3283,
      182,
      1665,
      3286,
      332,
      1945,
      2355,
      1562,
      4065,
      4066,
      1668
    ],
  ),
  "bento": SymbolsMetadata(
    popularity: 320,
    codepoint: 0xf1f4,
    categories: [16],
    tags: [
      2672,
      1447,
      4067,
      2284,
      482,
      1175,
      4068,
      345,
      1405,
      4069,
      8,
      2370,
      382,
      1053,
      2679,
      385,
      4070,
      4071,
      3661,
      506,
      4072,
      325,
      2697,
      70,
      587,
      3336,
      3665,
      2449,
      4073,
      2684,
      945,
      4074,
      4075,
      396,
      1165
    ],
  ),
  "bia": SymbolsMetadata(
    popularity: 30,
    codepoint: 0xf6eb,
    categories: [15],
    tags: [
      1310,
      807,
      4076,
      481,
      4077,
      684,
      4078,
      4079,
      482,
      621,
      1793,
      1627,
      1567,
      673,
      2172,
      809,
      4080,
      1826,
      2831,
      2533,
      488,
      692,
      583,
      1087,
      4081,
      1305,
      584,
      17,
      585,
      4082,
      1460,
      2177,
      818,
      819,
      432,
      1317,
      433,
      33,
      4083,
      2414,
      1465
    ],
  ),
  "bid_landscape": SymbolsMetadata(
    popularity: 185,
    codepoint: 0xe667,
    categories: [9],
    tags: [
      1045,
      1403,
      517,
      4084,
      373,
      1673,
      1301,
      1047,
      254,
      81,
      1448,
      375,
      3762,
      520,
      1675,
      1677,
      4085,
      1052,
      382,
      1055,
      68,
      4086,
      4087,
      1306,
      1583,
      1058,
      226,
      1308,
      1060,
      267,
      4088,
      4089,
      4090,
      1441,
      744,
      1685,
      762,
      763,
      1453,
      1070,
      1696,
      527
    ],
  ),
  "bid_landscape_disabled": SymbolsMetadata(
    popularity: 16,
    codepoint: 0xef81,
    categories: [9],
    tags: [
      743,
      1320,
      1045,
      1403,
      517,
      4084,
      373,
      1302,
      81,
      2027,
      375,
      867,
      1567,
      147,
      1321,
      1052,
      4091,
      49,
      1200,
      1055,
      1305,
      1583,
      226,
      406,
      1060,
      886,
      1035,
      57,
      62,
      239,
      432,
      433,
      744,
      1070,
      1042,
      527
    ],
  ),
  "bigtop_updates": SymbolsMetadata(
    popularity: 97,
    codepoint: 0xe669,
    categories: [4],
    tags: [
      1338,
      1339,
      1154,
      281,
      1341,
      4092,
      4093,
      4094,
      2090,
      283,
      284,
      970,
      51,
      259,
      2314,
      585,
      267,
      886,
      2446,
      1160,
      609,
      4095,
      1350,
      760,
      273,
      291,
      1352,
      4096,
      4097,
      277,
      278
    ],
  ),
  "bike_dock": SymbolsMetadata(
    popularity: 7,
    codepoint: 0xf47b,
    categories: [14],
    tags: [
      1914,
      4098,
      4099,
      4100,
      4101,
      4102,
      4103,
      4104,
      2544,
      4105,
      4106,
      312,
      2402,
      4107,
      317,
      323,
      324,
      1519,
      1520,
      1618,
      1836,
      4108,
      326,
      1373,
      2057,
      4109,
      4110,
      1508,
      4111,
      3516,
      1623,
      332,
      1486
    ],
  ),
  "bike_lane": SymbolsMetadata(
    popularity: 17,
    codepoint: 0xf47a,
    categories: [14],
    tags: [
      2504,
      1658,
      4098,
      4100,
      4112,
      4113,
      1539,
      1660,
      4105,
      463,
      4106,
      313,
      2402,
      2342,
      11,
      137,
      583,
      4114,
      87,
      324,
      1520,
      1143,
      325,
      1663,
      1836,
      289,
      1619,
      590,
      4115,
      1009,
      975,
      1560,
      696,
      2057,
      4116,
      1620,
      4117,
      1621,
      1011,
      362,
      1561,
      1162,
      30,
      1531,
      31,
      1665,
      1622,
      1623,
      332,
      597,
      2355,
      1562,
      1668
    ],
    rtlAutoMirrored: true,
  ),
  "bike_scooter": SymbolsMetadata(
    popularity: 261,
    codepoint: 0xef45,
    categories: [14],
    tags: [
      1816,
      4098,
      4100,
      1818,
      1819,
      4105,
      348,
      4118,
      4119,
      1617,
      1975,
      1520,
      4120,
      1384,
      896,
      468,
      4121,
      289,
      4122,
      4123,
      3282,
      2059,
      4124,
      4125,
      1317,
      30,
      1147,
      1623,
      332,
      4126,
      4127,
      1850,
      4128,
      4129
    ],
  ),
  "biotech": SymbolsMetadata(
    popularity: 2719,
    codepoint: 0xea3a,
    categories: [15],
    tags: [
      1402,
      4130,
      4131,
      4132,
      4133,
      4134,
      4135,
      1077,
      81,
      314,
      4136,
      4137,
      4138,
      4139,
      4140,
      692,
      4141,
      4142,
      4143,
      895,
      1769,
      4144,
      4145,
      4146,
      757,
      3385,
      4147,
      4148,
      4149,
      3387,
      1276,
      65
    ],
  ),
  "blanket": SymbolsMetadata(
    popularity: 164,
    codepoint: 0xe828,
    categories: [8],
    tags: [
      4150,
      4151,
      4004,
      4006,
      838,
      1921,
      4152,
      2158,
      4153,
      4154,
      4155,
      4156,
      4023,
      2614,
      4157,
      4158,
      4159,
      1880,
      2730,
      4160,
      4161,
      1119,
      4162,
      432,
      1932,
      4163,
      1935,
      2097,
      4164,
      2624,
      4165,
      3786,
      1867,
      4166
    ],
  ),
  "blender": SymbolsMetadata(
    popularity: 603,
    codepoint: 0xefe3,
    categories: [8],
    tags: [
      1889,
      4167,
      4168,
      4169,
      4170,
      4171,
      4172,
      4173,
      1311,
      4174,
      4175,
      4176,
      4177,
      4178,
      3640,
      2370,
      4179,
      847,
      4180,
      4181,
      4182,
      4183,
      4184,
      4185,
      4186,
      1729,
      3661,
      4187,
      4188,
      3645,
      2969,
      470,
      4189,
      4190,
      275,
      4191
    ],
  ),
  "blind": SymbolsMetadata(
    popularity: 452,
    codepoint: 0xf8d6,
    categories: [3],
    tags: [
      860,
      861,
      900,
      3307,
      3726,
      684,
      4192,
      2027,
      866,
      867,
      871,
      873,
      1199,
      583,
      4193,
      811,
      1967,
      896,
      4194,
      1035,
      590,
      975,
      1970,
      4195,
      1042,
      3117,
      908
    ],
  ),
  "blinds": SymbolsMetadata(
    popularity: 255,
    codepoint: 0xe286,
    categories: [8],
    tags: [
      1738,
      1890,
      4196,
      1188,
      345,
      2158,
      4153,
      4197,
      1137,
      1116,
      4198,
      582,
      1479,
      2720,
      4199,
      584,
      1119,
      2876,
      1749,
      1009,
      432,
      2447,
      3999,
      4200,
      1325,
      1899,
      979,
      3733,
      4001,
      4201,
      3317,
      1165,
      4202
    ],
  ),
  "blinds_closed": SymbolsMetadata(
    popularity: 211,
    codepoint: 0xec1f,
    categories: [8],
    tags: [
      1476,
      4196,
      4203,
      918,
      4204,
      2158,
      4153,
      4197,
      4205,
      3125,
      582,
      2720,
      4199,
      1119,
      4206,
      1733,
      1009,
      2447,
      1483,
      4207,
      1022,
      3999,
      1325,
      4208,
      1899,
      4209,
      4001,
      4210,
      4202
    ],
  ),
  "block": SymbolsMetadata(
    popularity: 11894,
    codepoint: 0xe14b,
    categories: [2],
    tags: [
      1028,
      1339,
      4211,
      1211,
      2776,
      481,
      1109,
      1187,
      1342,
      193,
      1188,
      1345,
      1189,
      1138,
      4212,
      4213,
      1568,
      2694,
      1190,
      1191,
      4214,
      4215,
      3254,
      4216,
      4217,
      2698,
      4218,
      4219,
      4220,
      4221,
      1039,
      1970,
      1040,
      1041,
      1203,
      206
    ],
    rtlAutoMirrored: true,
  ),
  "blood_pressure": SymbolsMetadata(
    popularity: 65,
    codepoint: 0xe097,
    categories: [3],
    tags: [
      4222,
      4223,
      4224,
      4225,
      4226,
      373,
      1761,
      4227,
      4228,
      3827,
      1052,
      692,
      3722,
      1765,
      4229,
      4230,
      51,
      1406,
      226,
      17,
      895,
      4231,
      1769,
      623,
      3470,
      4232,
      4233,
      4234,
      4235
    ],
  ),
  "bloodtype": SymbolsMetadata(
    popularity: 1088,
    codepoint: 0xefe4,
    categories: [3],
    tags: [
      480,
      4236,
      4237,
      4238,
      4239,
      373,
      1760,
      145,
      375,
      4240,
      2849,
      4241,
      2423,
      1142,
      137,
      692,
      4242,
      1765,
      4229,
      1766,
      138,
      384,
      68,
      87,
      895,
      4243,
      1769,
      4215,
      2424,
      4244,
      242,
      591,
      392,
      31,
      35,
      1390,
      2480
    ],
  ),
  "bluetooth": SymbolsMetadata(
    popularity: 2398,
    codepoint: 0xe1a7,
    categories: [4],
    tags: [
      1246,
      4245,
      4246,
      283,
      1047,
      284,
      254,
      81,
      288,
      2527,
      138,
      87,
      262,
      267,
      4247,
      4248,
      1508,
      273,
      411,
      31,
      65,
      526,
      278,
      4249
    ],
  ),
  "bluetooth_connected": SymbolsMetadata(
    popularity: 658,
    codepoint: 0xe1a8,
    categories: [4],
    tags: [
      1246,
      4245,
      4246,
      283,
      519,
      1047,
      1048,
      284,
      81,
      288,
      2527,
      4250,
      138,
      2489,
      3126,
      1294,
      262,
      267,
      3988,
      4247,
      4248,
      271,
      392,
      273,
      1911,
      1272,
      411,
      31,
      762,
      3435,
      525,
      65,
      526,
      278
    ],
  ),
  "bluetooth_disabled": SymbolsMetadata(
    popularity: 533,
    codepoint: 0xe1a9,
    categories: [4],
    tags: [
      1246,
      4245,
      4246,
      283,
      1047,
      284,
      254,
      1213,
      81,
      288,
      1138,
      867,
      1032,
      2532,
      1033,
      138,
      87,
      262,
      267,
      1035,
      1036,
      1037,
      4247,
      4248,
      4251,
      273,
      1041,
      411,
      31,
      65,
      1042,
      278
    ],
  ),
  "bluetooth_drive": SymbolsMetadata(
    popularity: 252,
    codepoint: 0xefe5,
    categories: [4],
    tags: [
      1816,
      4245,
      1818,
      1819,
      4246,
      283,
      519,
      1047,
      284,
      254,
      81,
      288,
      44,
      1675,
      2527,
      4252,
      1294,
      2466,
      1520,
      406,
      2758,
      267,
      4247,
      4248,
      4253,
      1685,
      411,
      31,
      762,
      763,
      65,
      526,
      4254,
      1623,
      332,
      1850,
      278
    ],
  ),
  "bluetooth_searching": SymbolsMetadata(
    popularity: 699,
    codepoint: 0xe1aa,
    categories: [4],
    tags: [
      1246,
      4245,
      283,
      4255,
      284,
      254,
      81,
      288,
      2341,
      317,
      1142,
      584,
      1294,
      406,
      267,
      4247,
      4248,
      1736,
      1102,
      4256,
      392,
      273,
      1271,
      31,
      65,
      526,
      1867,
      278
    ],
  ),
  "blur_circular": SymbolsMetadata(
    popularity: 443,
    codepoint: 0xe3a2,
    categories: [1],
    tags: [
      480,
      2233,
      1580,
      4257,
      4258,
      193,
      462,
      345,
      4259,
      1081,
      1229,
      673,
      487,
      3334,
      83,
      1746,
      4260,
      137,
      2276,
      49,
      355,
      4261,
      57,
      59,
      4262,
      151,
      392,
      4263,
      511,
      4264,
      37,
      476
    ],
  ),
  "blur_linear": SymbolsMetadata(
    popularity: 260,
    codepoint: 0xe3a3,
    categories: [1],
    tags: [
      4257,
      4265,
      1081,
      1229,
      673,
      487,
      3334,
      4266,
      83,
      1746,
      4267,
      4268,
      4269,
      4270,
      4271,
      4272,
      4273,
      581,
      1628,
      3577,
      4274,
      4275,
      87,
      2893,
      4276,
      4261,
      3579,
      4277,
      4278,
      4279,
      4280
    ],
  ),
  "blur_medium": SymbolsMetadata(
    popularity: 243,
    codepoint: 0xe84c,
    categories: [1],
    tags: [
      480,
      3491,
      4257,
      4281,
      4282,
      40,
      4283,
      4265,
      1229,
      673,
      487,
      3334,
      83,
      4267,
      4268,
      4269,
      3577,
      4274,
      53,
      4284,
      3835,
      4285,
      353,
      468,
      4286,
      4261,
      4277,
      4287,
      59,
      1009,
      4288,
      4289
    ],
  ),
  "blur_off": SymbolsMetadata(
    popularity: 172,
    codepoint: 0xe3a4,
    categories: [1],
    tags: [
      4257,
      4290,
      1187,
      193,
      135,
      4291,
      4292,
      104,
      1138,
      1279,
      4293,
      867,
      8,
      1081,
      1229,
      673,
      487,
      1033,
      3334,
      83,
      1746,
      4294,
      4295,
      1035,
      1037,
      3579,
      4296,
      637,
      1041,
      433,
      4297,
      4298,
      4299,
      4300,
      396,
      476
    ],
  ),
  "blur_on": SymbolsMetadata(
    popularity: 1391,
    codepoint: 0xe3a5,
    categories: [1],
    tags: [
      4301,
      1580,
      4257,
      193,
      462,
      867,
      8,
      4302,
      1081,
      1229,
      673,
      487,
      4303,
      4304,
      1033,
      3334,
      83,
      1746,
      4268,
      137,
      49,
      1035,
      1037,
      4261,
      3336,
      57,
      62,
      756,
      330,
      1041,
      4305,
      413,
      4306,
      4264,
      476
    ],
  ),
  "blur_short": SymbolsMetadata(
    popularity: 198,
    codepoint: 0xe8cf,
    categories: [1],
    tags: [
      480,
      3725,
      4257,
      251,
      4307,
      284,
      81,
      1229,
      673,
      487,
      3334,
      83,
      4268,
      4308,
      3577,
      4309,
      584,
      353,
      468,
      267,
      1733,
      3579,
      3645,
      1009,
      4310,
      4311,
      290,
      594,
      642,
      4289,
      1867,
      277
    ],
  ),
  "boat_bus": SymbolsMetadata(
    popularity: 10,
    codepoint: 0xf36d,
    categories: [14],
    tags: [
      4312,
      4313,
      1816,
      2460,
      4314,
      1940,
      1818,
      1819,
      4105,
      313,
      2402,
      4315,
      4316,
      1617,
      1831,
      4317,
      2054,
      1520,
      2468,
      896,
      2471,
      1928,
      2057,
      1620,
      2419,
      4318,
      2061,
      1994,
      1848,
      1623,
      332,
      1945,
      1850,
      4319,
      4320,
      4321
    ],
  ),
  "boat_railway": SymbolsMetadata(
    popularity: 3,
    codepoint: 0xf36c,
    categories: [14],
    tags: [
      1816,
      2460,
      1818,
      4322,
      1819,
      284,
      4323,
      375,
      313,
      2402,
      4107,
      4315,
      4316,
      137,
      138,
      4324,
      1617,
      87,
      2054,
      1520,
      2468,
      4325,
      2471,
      1619,
      4326,
      2474,
      2057,
      4327,
      4328,
      1621,
      2477,
      4318,
      4329,
      31,
      2164,
      1944,
      4330,
      526,
      1994,
      1623,
      332,
      1850
    ],
  ),
  "body_fat": SymbolsMetadata(
    popularity: 15,
    codepoint: 0xe098,
    categories: [3],
    tags: [
      1402,
      4331,
      4332,
      4078,
      4333,
      4334,
      4335,
      4336,
      373,
      4337,
      2368,
      4338,
      2533,
      4339,
      1052,
      692,
      4340,
      4242,
      4341,
      4342,
      226,
      17,
      4343,
      3463,
      4344,
      4345,
      757,
      391,
      1070,
      3689,
      3475
    ],
  ),
  "body_system": SymbolsMetadata(
    popularity: 20,
    codepoint: 0xe099,
    categories: [3],
    tags: [
      4346,
      3521,
      4347,
      4131,
      684,
      373,
      375,
      4348,
      3059,
      2533,
      692,
      1765,
      583,
      4349,
      138,
      2721,
      3086,
      895,
      4350,
      4351,
      289,
      589,
      590,
      4352,
      3385,
      4147,
      4353,
      978,
      945,
      3387,
      31
    ],
  ),
  "bolt": SymbolsMetadata(
    popularity: 15730,
    codepoint: 0xea0b,
    categories: [2],
    tags: [
      1339,
      3893,
      3638,
      1855,
      1345,
      3640,
      3879,
      3641,
      1141,
      4354,
      137,
      138,
      3894,
      3895,
      3645,
      3067,
      392,
      275,
      4355,
      3922,
      31,
      3896,
      2428,
      206,
      856,
      4356
    ],
  ),
  "bomb": SymbolsMetadata(
    popularity: 76,
    codepoint: 0xf568,
    categories: [3],
    tags: [
      1338,
      1339,
      4357,
      4358,
      4359,
      4360,
      4361,
      4362,
      4363,
      3340,
      4364,
      4365,
      3076,
      4366,
      1345,
      4367,
      4368,
      4369,
      2423,
      2694,
      4370,
      4371,
      4372,
      2695,
      4373,
      3078,
      4374,
      4375,
      3081,
      4376,
      4377,
      1011,
      4378,
      4379,
      4380,
      2428,
      4381,
      206,
      4382
    ],
  ),
  "book": SymbolsMetadata(
    popularity: 4763,
    codepoint: 0xe865,
    categories: [12],
    tags: [
      3064,
      4383,
      3375,
      4384,
      1688,
      1920,
      4385,
      3065,
      3059,
      4386,
      3194,
      3379,
      4387,
      52,
      3086,
      4388,
      1323,
      3380,
      4389,
      3382,
      3383,
      4390,
      3366,
      2834,
      4391,
      4392,
      4063,
      3482,
      1683,
      2722,
      4393,
      3387,
      182,
      3388,
      4394,
      4395
    ],
  ),
  "book_2": SymbolsMetadata(
    popularity: 184,
    codepoint: 0xf53e,
    categories: [12],
    tags: [
      3064,
      3375,
      1688,
      621,
      2435,
      3377,
      3059,
      4386,
      3194,
      68,
      3379,
      4387,
      52,
      4396,
      4397,
      1323,
      4398,
      3380,
      3383,
      3384,
      1575,
      3366,
      2834,
      4391,
      2447,
      179,
      4063,
      3482,
      1683,
      2722,
      4399,
      3387,
      4400,
      182,
      4401
    ],
  ),
  "book_3": SymbolsMetadata(
    popularity: 23,
    codepoint: 0xf53d,
    categories: [12],
    tags: [
      3064,
      3375,
      1688,
      4402,
      1567,
      3059,
      4403,
      3194,
      137,
      138,
      68,
      3379,
      52,
      3086,
      1323,
      3380,
      3382,
      3383,
      1574,
      3384,
      3366,
      2834,
      4063,
      3385,
      3482,
      1683,
      2722,
      4404,
      3031,
      3387,
      31,
      182,
      3388,
      4394,
      554,
      3390,
      1465
    ],
  ),
  "book_4": SymbolsMetadata(
    popularity: 78,
    codepoint: 0xf53c,
    categories: [12],
    tags: [
      3064,
      3375,
      1688,
      4405,
      3059,
      4403,
      3194,
      2780,
      68,
      3379,
      52,
      4396,
      3086,
      1323,
      3380,
      3381,
      3382,
      2876,
      3383,
      3384,
      3029,
      3366,
      2834,
      179,
      4063,
      3385,
      3482,
      1683,
      2722,
      4404,
      3031,
      3387,
      182,
      4406,
      3388
    ],
  ),
  "book_5": SymbolsMetadata(
    popularity: 112,
    codepoint: 0xf53b,
    categories: [12],
    tags: [
      4383,
      3375,
      1688,
      4407,
      3613,
      3377,
      3059,
      3194,
      2780,
      2757,
      68,
      2456,
      3379,
      52,
      3086,
      1323,
      3380,
      3381,
      1573,
      3382,
      3383,
      3384,
      4408,
      3366,
      2834,
      179,
      4063,
      3385,
      3482,
      1683,
      2722,
      3031,
      3387,
      182,
      33,
      4394,
      3390
    ],
  ),
  "book_6": SymbolsMetadata(
    popularity: 6,
    codepoint: 0xf3df,
    categories: [12],
    tags: [
      4409,
      3064,
      3375,
      1688,
      4405,
      1567,
      3059,
      4403,
      3194,
      2780,
      68,
      3379,
      52,
      3086,
      1323,
      3380,
      3381,
      4410,
      1573,
      3383,
      3384,
      3029,
      3366,
      2834,
      4392,
      179,
      4063,
      3482,
      1683,
      2722,
      4404,
      3031,
      3387,
      182,
      3388,
      4394
    ],
  ),
  "book_online": SymbolsMetadata(
    popularity: 1465,
    codepoint: 0xf217,
    categories: [11],
    tags: [
      1223,
      1224,
      858,
      4411,
      1288,
      1657,
      3375,
      1916,
      1940,
      1227,
      344,
      4412,
      2637,
      288,
      44,
      4413,
      1081,
      4414,
      2527,
      779,
      4415,
      10,
      4416,
      1924,
      1086,
      1230,
      506,
      262,
      1693,
      4417,
      4418,
      523,
      70,
      91,
      2019,
      271,
      1653,
      432,
      1931,
      2526,
      2022,
      1695,
      525,
      3329,
      3911,
      2025,
      1944,
      1848,
      4419,
      4420
    ],
  ),
  "book_ribbon": SymbolsMetadata(
    popularity: 69,
    codepoint: 0xf3e7,
    categories: [6],
    tags: [
      2154,
      3375,
      1688,
      1175,
      1567,
      3059,
      3194,
      2780,
      1347,
      3379,
      52,
      3086,
      1323,
      3380,
      3034,
      1143,
      1460,
      3382,
      92,
      1574,
      3029,
      3366,
      2834,
      179,
      4063,
      3482,
      1683,
      4421,
      3387,
      182,
      3388
    ],
  ),
  "bookmark": SymbolsMetadata(
    popularity: 13522,
    codepoint: 0xe866,
    categories: [6],
    tags: [
      1288,
      2154,
      2432,
      3375,
      1688,
      1156,
      1175,
      621,
      2357,
      1567,
      3194,
      147,
      2862,
      2780,
      4422,
      52,
      1323,
      1143,
      262,
      92,
      1574,
      326,
      3366,
      2834,
      4063,
      3482,
      1683,
      2790,
      182,
      4423,
      4424
    ],
  ),
  "bookmark_add": SymbolsMetadata(
    popularity: 2218,
    codepoint: 0xe598,
    categories: [6],
    tags: [
      231,
      743,
      2154,
      1688,
      504,
      1175,
      1567,
      3194,
      147,
      2161,
      138,
      1322,
      259,
      1143,
      1571,
      1460,
      92,
      1574,
      239,
      4425,
      4063,
      3482,
      1683,
      1162,
      854,
      31,
      141,
      1327,
      1164
    ],
  ),
  "bookmark_added": SymbolsMetadata(
    popularity: 1538,
    codepoint: 0xe599,
    categories: [6],
    tags: [
      743,
      881,
      1658,
      1688,
      1660,
      463,
      1567,
      2342,
      3194,
      147,
      323,
      1143,
      174,
      4426,
      4427,
      325,
      1663,
      818,
      4428,
      4429,
      239,
      2834,
      4430,
      4063,
      1350,
      1683,
      4431,
      4432,
      4433,
      362,
      392,
      4434,
      4435,
      4436,
      4437,
      1665,
      1718,
      2355,
      1562,
      333,
      1668
    ],
  ),
  "bookmark_bag": SymbolsMetadata(
    popularity: 15,
    codepoint: 0xf410,
    categories: [6],
    tags: [
      1987,
      2154,
      1641,
      4438,
      1688,
      4439,
      3612,
      4440,
      1175,
      1311,
      3194,
      968,
      1924,
      2161,
      1142,
      1176,
      86,
      52,
      1323,
      88,
      3618,
      1143,
      325,
      2242,
      1037,
      92,
      289,
      3366,
      2834,
      4441,
      4063,
      3482,
      1683,
      4442,
      392,
      979,
      1685,
      4443,
      2746,
      182,
      332,
      1945,
      141
    ],
  ),
  "bookmark_check": SymbolsMetadata(
    popularity: 49,
    codepoint: 0xf457,
    categories: [6],
    tags: [
      2154,
      1688,
      4444,
      1660,
      463,
      2637,
      4445,
      2657,
      4446,
      2340,
      1567,
      2342,
      520,
      1082,
      3194,
      4447,
      259,
      52,
      1323,
      1143,
      1663,
      2642,
      1574,
      1575,
      3366,
      2834,
      4425,
      4063,
      3482,
      1683,
      4421,
      4448,
      362,
      392,
      979,
      1377,
      245,
      182,
      1665,
      1562,
      333,
      1668
    ],
  ),
  "bookmark_flag": SymbolsMetadata(
    popularity: 49,
    codepoint: 0xf456,
    categories: [6],
    tags: [
      2154,
      1688,
      4449,
      4450,
      312,
      1590,
      3194,
      968,
      4451,
      4452,
      379,
      1142,
      13,
      4453,
      1347,
      4454,
      4422,
      52,
      1530,
      1323,
      2893,
      88,
      323,
      1143,
      174,
      4455,
      20,
      640,
      4456,
      325,
      2846,
      326,
      327,
      4457,
      3366,
      2834,
      4063,
      1408,
      3482,
      1683,
      4458,
      4459,
      392,
      1317,
      705,
      979,
      2218,
      31,
      182,
      334
    ],
  ),
  "bookmark_heart": SymbolsMetadata(
    popularity: 23,
    codepoint: 0xf455,
    categories: [6],
    tags: [
      1288,
      4460,
      2154,
      1688,
      621,
      2357,
      1567,
      3194,
      147,
      968,
      379,
      4229,
      1347,
      4454,
      52,
      1323,
      1604,
      4461,
      174,
      1574,
      906,
      3366,
      2834,
      4063,
      3482,
      1683,
      392,
      1317,
      979,
      31,
      182,
      141,
      333
    ],
  ),
  "bookmark_manager": SymbolsMetadata(
    popularity: 51,
    codepoint: 0xf7b1,
    categories: [6],
    tags: [
      1688,
      4462,
      4463,
      1156,
      1175,
      1564,
      1302,
      81,
      1566,
      1567,
      4464,
      1675,
      1229,
      673,
      3194,
      4465,
      147,
      4466,
      4467,
      4468,
      2161,
      1087,
      259,
      1323,
      4469,
      325,
      886,
      3062,
      2599,
      239,
      4470,
      1683,
      4421,
      392,
      4471,
      1576,
      2797,
      4472,
      4473,
      854,
      1685,
      31,
      333,
      1164,
      1578,
      1465
    ],
  ),
  "bookmark_remove": SymbolsMetadata(
    popularity: 730,
    codepoint: 0xe59a,
    categories: [6],
    tags: [
      746,
      1688,
      504,
      778,
      345,
      1031,
      1567,
      3352,
      3194,
      1322,
      259,
      52,
      1143,
      1232,
      325,
      289,
      1574,
      4063,
      1039,
      3482,
      1683,
      1238,
      31,
      182,
      141,
      4474,
      4475,
      4476,
      1327,
      333
    ],
  ),
  "bookmark_star": SymbolsMetadata(
    popularity: 54,
    codepoint: 0xf454,
    categories: [6],
    tags: [
      2154,
      3190,
      1688,
      1156,
      1175,
      621,
      1567,
      3194,
      147,
      4451,
      1115,
      1347,
      51,
      1356,
      4422,
      52,
      1323,
      87,
      88,
      1143,
      174,
      325,
      289,
      326,
      328,
      793,
      359,
      203,
      3366,
      2834,
      4063,
      3482,
      1683,
      363,
      392,
      854,
      31,
      182,
      413,
      1326,
      333
    ],
  ),
  "bookmarks": SymbolsMetadata(
    popularity: 3370,
    codepoint: 0xe98b,
    categories: [6],
    tags: [
      1688,
      4477,
      1156,
      1175,
      1567,
      3194,
      4465,
      147,
      4451,
      4453,
      1347,
      52,
      1056,
      1323,
      88,
      1004,
      174,
      2162,
      325,
      92,
      1575,
      3366,
      2834,
      4063,
      3482,
      1683,
      4421,
      392,
      594,
      182,
      2883,
      333
    ],
  ),
  "books_movies_and_music": SymbolsMetadata(
    popularity: 58,
    codepoint: 0xef82,
    categories: [15],
    tags: [
      2154,
      4478,
      1246,
      3375,
      3376,
      1175,
      621,
      4479,
      3762,
      3059,
      779,
      1677,
      346,
      2161,
      4480,
      4481,
      3379,
      3086,
      1975,
      1323,
      4482,
      406,
      3448,
      439,
      1701,
      2500,
      2834,
      3282,
      4483,
      37,
      4484
    ],
  ),
  "border_all": SymbolsMetadata(
    popularity: 391,
    codepoint: 0xe228,
    categories: [12],
    tags: [
      2302,
      1107,
      76,
      1108,
      1109,
      482,
      3564,
      463,
      1311,
      621,
      81,
      8,
      2285,
      1566,
      1229,
      673,
      2172,
      1140,
      4485,
      2296,
      382,
      385,
      584,
      4071,
      2162,
      92,
      289,
      3338,
      1127,
      4486,
      1576,
      1441,
      2684,
      1147,
      945,
      1453,
      33,
      35,
      396,
      1465
    ],
  ),
  "border_bottom": SymbolsMetadata(
    popularity: 123,
    codepoint: 0xe229,
    categories: [12],
    tags: [
      4487,
      4488,
      1108,
      4489,
      4490,
      2204,
      4491,
      4492,
      4493,
      2399,
      752,
      4494,
      1139,
      1566,
      1229,
      673,
      2172,
      4495,
      2173,
      1628,
      385,
      4496,
      4497,
      4498,
      4499,
      1146,
      1576,
      1441,
      1147,
      2180,
      4500,
      4501,
      33,
      4502,
      4503,
      2195,
      35,
      4504,
      1465
    ],
  ),
  "border_clear": SymbolsMetadata(
    popularity: 195,
    codepoint: 0xe22a,
    categories: [12],
    tags: [
      1108,
      4505,
      4506,
      4507,
      482,
      1187,
      778,
      4508,
      2399,
      752,
      1031,
      485,
      1566,
      1229,
      673,
      2172,
      1140,
      3352,
      2173,
      348,
      381,
      385,
      87,
      4509,
      492,
      289,
      432,
      1039,
      4498,
      4510,
      4511,
      4512,
      392,
      1576,
      1441,
      433,
      1147,
      2180,
      33,
      35,
      1465
    ],
  ),
  "border_color": SymbolsMetadata(
    popularity: 4705,
    codepoint: 0xe22b,
    categories: [12],
    tags: [
      1738,
      2302,
      1580,
      1108,
      4513,
      2397,
      4514,
      4515,
      574,
      485,
      2358,
      1566,
      2748,
      1229,
      673,
      2172,
      370,
      137,
      87,
      1636,
      289,
      3062,
      2599,
      2890,
      432,
      392,
      1576,
      4516,
      1441,
      433,
      1147,
      2180,
      33,
      511,
      35,
      1578,
      1465
    ],
  ),
  "border_horizontal": SymbolsMetadata(
    popularity: 141,
    codepoint: 0xe22c,
    categories: [12],
    tags: [
      4517,
      1108,
      1109,
      4518,
      2399,
      752,
      4519,
      3547,
      2285,
      1139,
      1112,
      1566,
      4520,
      1229,
      673,
      2172,
      1140,
      2173,
      3550,
      581,
      4521,
      1628,
      4522,
      385,
      4523,
      87,
      4524,
      289,
      701,
      4525,
      4526,
      1128,
      1146,
      1576,
      1441,
      1147,
      33,
      2195,
      35,
      4527,
      1465
    ],
  ),
  "border_inner": SymbolsMetadata(
    popularity: 123,
    codepoint: 0xe22d,
    categories: [12],
    tags: [
      2167,
      1107,
      1108,
      4528,
      1109,
      482,
      3564,
      923,
      621,
      2399,
      752,
      4529,
      4530,
      1566,
      1229,
      673,
      2172,
      348,
      382,
      4531,
      2719,
      385,
      584,
      92,
      2447,
      1440,
      1127,
      4486,
      1576,
      1441,
      433,
      1147,
      945,
      1453,
      33,
      35,
      1465
    ],
  ),
  "border_left": SymbolsMetadata(
    popularity: 119,
    codepoint: 0xe22e,
    categories: [12],
    tags: [
      2225,
      2167,
      1108,
      4532,
      1109,
      1419,
      2399,
      752,
      1566,
      1567,
      599,
      1229,
      673,
      2172,
      2173,
      382,
      2780,
      4533,
      385,
      2216,
      87,
      4534,
      2177,
      4535,
      701,
      1576,
      1452,
      2896,
      1441,
      1147,
      945,
      33,
      2232,
      35,
      2210,
      1465
    ],
  ),
  "border_outer": SymbolsMetadata(
    popularity: 187,
    codepoint: 0xe22f,
    categories: [12],
    tags: [
      1107,
      1108,
      4536,
      4537,
      482,
      1227,
      1311,
      621,
      2399,
      752,
      485,
      1566,
      1567,
      599,
      1229,
      673,
      2172,
      1140,
      1746,
      370,
      348,
      137,
      382,
      385,
      584,
      4538,
      289,
      1574,
      1122,
      432,
      363,
      392,
      1576,
      1441,
      433,
      1147,
      945,
      2180,
      1453,
      33,
      35,
      1465
    ],
  ),
  "border_right": SymbolsMetadata(
    popularity: 104,
    codepoint: 0xe230,
    categories: [12],
    tags: [
      2167,
      1108,
      4539,
      1109,
      482,
      2399,
      752,
      485,
      1566,
      1567,
      599,
      1229,
      673,
      2172,
      1140,
      370,
      348,
      381,
      382,
      385,
      87,
      4534,
      289,
      2177,
      907,
      4540,
      4541,
      392,
      1576,
      1441,
      433,
      1147,
      2219,
      1453,
      33,
      4542,
      35,
      476,
      1465
    ],
  ),
  "border_style": SymbolsMetadata(
    popularity: 200,
    codepoint: 0xe231,
    categories: [12],
    tags: [
      4543,
      1108,
      1109,
      482,
      1227,
      4514,
      1311,
      2399,
      752,
      485,
      1566,
      1567,
      753,
      599,
      1229,
      673,
      2172,
      1140,
      2173,
      348,
      137,
      2276,
      385,
      87,
      289,
      2177,
      392,
      1576,
      979,
      1441,
      1147,
      2180,
      1453,
      33,
      4544,
      35,
      1326,
      2210,
      3689,
      1465
    ],
  ),
  "border_top": SymbolsMetadata(
    popularity: 120,
    codepoint: 0xe232,
    categories: [12],
    tags: [
      1625,
      1108,
      4545,
      1109,
      1227,
      3322,
      2399,
      752,
      1139,
      1112,
      1566,
      599,
      1229,
      673,
      2172,
      1140,
      2173,
      348,
      382,
      1628,
      385,
      87,
      4546,
      289,
      2177,
      701,
      4525,
      1127,
      1128,
      1146,
      1576,
      1441,
      1147,
      1453,
      33,
      2194,
      4547,
      1240,
      4548,
      35,
      4549,
      1465
    ],
  ),
  "border_vertical": SymbolsMetadata(
    popularity: 154,
    codepoint: 0xe233,
    categories: [12],
    tags: [
      2167,
      1108,
      4537,
      1419,
      4550,
      923,
      2399,
      752,
      2285,
      4551,
      1566,
      4552,
      1229,
      673,
      2172,
      2173,
      348,
      382,
      385,
      584,
      92,
      289,
      4553,
      1749,
      1733,
      701,
      1127,
      703,
      1146,
      1576,
      2408,
      4554,
      1441,
      1147,
      945,
      33,
      1309,
      35,
      1445,
      4555,
      3317,
      1465
    ],
  ),
  "borg": SymbolsMetadata(
    popularity: 51,
    codepoint: 0xf40d,
    categories: [2],
    tags: [
      3120,
      3121,
      4556,
      4557,
      5,
      4558,
      284,
      4559,
      4560,
      4561,
      4562,
      3477,
      1367,
      4563,
      4564,
      2488,
      4565,
      138,
      1294,
      1729,
      267,
      4566,
      2495,
      4567,
      4568,
      4569,
      31,
      65,
      4570,
      4571
    ],
  ),
  "bottom_app_bar": SymbolsMetadata(
    popularity: 11,
    codepoint: 0xe730,
    categories: [2],
    tags: [
      4572,
      1288,
      4573,
      501,
      1403,
      2204,
      4574,
      4575,
      482,
      3322,
      2675,
      345,
      4576,
      485,
      1140,
      4577,
      4578,
      579,
      4579,
      582,
      1322,
      385,
      506,
      4580,
      262,
      4581,
      623,
      325,
      4582,
      1063,
      271,
      4583,
      432,
      410,
      2790,
      433,
      945,
      525,
      97,
      141,
      1150,
      1327,
      333,
      1164,
      1165
    ],
  ),
  "bottom_drawer": SymbolsMetadata(
    popularity: 36,
    codepoint: 0xe72d,
    categories: [2],
    tags: [
      1288,
      501,
      1403,
      2204,
      4584,
      2799,
      2675,
      1742,
      485,
      2778,
      575,
      2897,
      1303,
      2664,
      580,
      2864,
      4579,
      51,
      1322,
      385,
      87,
      88,
      506,
      2841,
      262,
      623,
      70,
      1749,
      271,
      4585,
      432,
      2243,
      2843,
      410,
      1146,
      2790,
      2798,
      525,
      4586,
      596,
      97,
      141,
      1696,
      1327,
      333,
      1164,
      1165
    ],
  ),
  "bottom_navigation": SymbolsMetadata(
    popularity: 52,
    codepoint: 0xe98c,
    categories: [2],
    tags: [
      2167,
      1288,
      4573,
      501,
      1403,
      2204,
      4587,
      4588,
      2675,
      485,
      1112,
      1140,
      4577,
      4578,
      4589,
      4590,
      4579,
      1322,
      385,
      4580,
      262,
      4591,
      623,
      325,
      4582,
      271,
      2217,
      329,
      432,
      2447,
      1269,
      410,
      1127,
      2790,
      4592,
      525,
      141,
      1326,
      1327,
      3560,
      333,
      1164,
      1165
    ],
  ),
  "bottom_panel_close": SymbolsMetadata(
    popularity: 33,
    codepoint: 0xf72a,
    categories: [2],
    tags: [
      746,
      77,
      2204,
      504,
      1187,
      778,
      1188,
      2799,
      3322,
      1311,
      345,
      1213,
      1031,
      313,
      4593,
      4594,
      2778,
      2897,
      1190,
      381,
      2864,
      385,
      2841,
      1749,
      4595,
      1039,
      4596,
      392,
      1576,
      2866,
      4597,
      1326,
      1165,
      2949,
      3712
    ],
  ),
  "bottom_panel_open": SymbolsMetadata(
    popularity: 47,
    codepoint: 0xf729,
    categories: [2],
    tags: [
      858,
      746,
      77,
      2204,
      2799,
      345,
      81,
      145,
      313,
      2778,
      2897,
      1140,
      1303,
      2851,
      1313,
      51,
      68,
      1322,
      385,
      506,
      237,
      325,
      2876,
      70,
      1749,
      4595,
      4585,
      2843,
      2022,
      4597,
      1718,
      1326,
      1696,
      1165,
      2949
    ],
  ),
  "bottom_right_click": SymbolsMetadata(
    popularity: 26,
    codepoint: 0xf684,
    categories: [2],
    tags: [
      746,
      1107,
      77,
      4598,
      502,
      4599,
      504,
      1790,
      345,
      2357,
      1793,
      2358,
      313,
      1743,
      2931,
      1303,
      1142,
      51,
      2814,
      2955,
      2345,
      586,
      325,
      328,
      1144,
      329,
      4600,
      2843,
      2802,
      1127,
      363,
      4601,
      1204,
      396
    ],
  ),
  "bottom_sheets": SymbolsMetadata(
    popularity: 24,
    codepoint: 0xe98d,
    categories: [2],
    tags: [
      4602,
      1288,
      501,
      517,
      2204,
      4603,
      3322,
      2675,
      1311,
      621,
      345,
      81,
      485,
      145,
      1456,
      8,
      1140,
      4604,
      581,
      68,
      1322,
      385,
      584,
      506,
      262,
      4605,
      623,
      2732,
      1749,
      271,
      1220,
      432,
      410,
      1146,
      4399,
      2790,
      433,
      525,
      141,
      1327,
      1445,
      333,
      1164,
      1165
    ],
  ),
  "box": SymbolsMetadata(
    popularity: 124,
    codepoint: 0xf5a4,
    categories: [9],
    tags: [
      480,
      1310,
      807,
      1108,
      482,
      4606,
      3322,
      2321,
      1311,
      2050,
      1140,
      809,
      488,
      348,
      137,
      1356,
      4607,
      812,
      492,
      289,
      2563,
      4608,
      1331,
      2316,
      1652,
      432,
      390,
      392,
      4609,
      4318,
      1317,
      433,
      1685,
      945,
      31
    ],
  ),
  "box_add": SymbolsMetadata(
    popularity: 24,
    codepoint: 0xf5a5,
    categories: [9],
    tags: [
      231,
      743,
      232,
      482,
      4610,
      4606,
      924,
      1311,
      4611,
      1302,
      2050,
      1646,
      3730,
      1356,
      87,
      2054,
      1004,
      886,
      289,
      2563,
      4608,
      239,
      1331,
      2316,
      1652,
      2447,
      392,
      4609,
      4318,
      1375,
      433,
      4612,
      1685,
      1377
    ],
  ),
  "box_edit": SymbolsMetadata(
    popularity: 15,
    codepoint: 0xf5a6,
    categories: [9],
    tags: [
      1738,
      1739,
      482,
      1564,
      678,
      1311,
      621,
      3083,
      1302,
      574,
      81,
      145,
      1567,
      4464,
      1229,
      673,
      1568,
      147,
      488,
      68,
      1087,
      1004,
      1636,
      92,
      2563,
      3062,
      2599,
      150,
      4613,
      71,
      433,
      511,
      890,
      1578,
      1465
    ],
  ),
  "boy": SymbolsMetadata(
    popularity: 1532,
    codepoint: 0xeb67,
    categories: [3],
    tags: [
      565,
      1014,
      566,
      4614,
      684,
      4615,
      5,
      193,
      965,
      4616,
      225,
      968,
      1804,
      3446,
      583,
      969,
      1002,
      971,
      1810,
      4617,
      289,
      589,
      590,
      591,
      976,
      330,
      978,
      3544,
      705,
      979,
      31,
      597,
      981
    ],
  ),
  "brand_awareness": SymbolsMetadata(
    popularity: 715,
    codepoint: 0xe98e,
    categories: [0],
    tags: [
      1339,
      1402,
      1045,
      1154,
      77,
      1246,
      4618,
      2484,
      919,
      373,
      345,
      81,
      931,
      1052,
      234,
      235,
      2455,
      4619,
      1159,
      1060,
      3470,
      1701,
      2446,
      641,
      242,
      757,
      4620,
      2353,
      2418,
      1271,
      1272,
      744,
      1070,
      1409,
      2045,
      1719,
      514,
      554
    ],
    rtlAutoMirrored: true,
  ),
  "brand_family": SymbolsMetadata(
    popularity: 54,
    codepoint: 0xf4f1,
    categories: [12],
    tags: [
      3411,
      480,
      4,
      4621,
      2484,
      4622,
      5,
      193,
      462,
      4558,
      1800,
      2321,
      284,
      1366,
      1001,
      12,
      4623,
      370,
      137,
      1176,
      969,
      384,
      16,
      2466,
      4624,
      267,
      1063,
      289,
      589,
      1067,
      390,
      760,
      392,
      4625,
      31,
      1275,
      4626,
      33,
      35,
      4627,
      4570
    ],
  ),
  "branding_watermark": SymbolsMetadata(
    popularity: 994,
    codepoint: 0xe06b,
    categories: [0],
    tags: [
      480,
      4628,
      4622,
      4629,
      1365,
      2675,
      3292,
      2357,
      485,
      2358,
      1140,
      3477,
      370,
      137,
      969,
      49,
      4630,
      1322,
      385,
      87,
      2466,
      1143,
      289,
      2732,
      62,
      432,
      410,
      392,
      1162,
      1317,
      2790,
      433,
      2647,
      31,
      4631,
      4632,
      141,
      1327,
      1390,
      629,
      333,
      1164,
      1165
    ],
    rtlAutoMirrored: true,
  ),
  "breakfast_dining": SymbolsMetadata(
    popularity: 540,
    codepoint: 0xea54,
    categories: [16],
    tags: [
      3648,
      3650,
      3651,
      3652,
      4633,
      3654,
      193,
      4175,
      3656,
      4177,
      4634,
      4635,
      3658,
      4636,
      3659,
      4637,
      4638,
      2370,
      4639,
      4183,
      3661,
      506,
      2149,
      4344,
      91,
      4640,
      4641,
      3665,
      330,
      3667,
      4642,
      4643,
      4644,
      4645
    ],
  ),
  "breaking_news": SymbolsMetadata(
    popularity: 156,
    codepoint: 0xea08,
    categories: [12],
    tags: [
      3074,
      1339,
      4646,
      1154,
      1340,
      4647,
      4648,
      1342,
      283,
      4649,
      1345,
      2694,
      1346,
      4354,
      4650,
      4651,
      1347,
      4652,
      68,
      87,
      1143,
      406,
      4653,
      2446,
      4654,
      4655,
      3035,
      609,
      1408,
      3716,
      392,
      31,
      33,
      2260,
      890,
      4656,
      2428,
      4657,
      206
    ],
  ),
  "breaking_news_alt_1": SymbolsMetadata(
    popularity: 974,
    codepoint: 0xf0ba,
    categories: [12],
    tags: [
      3074,
      1339,
      1154,
      1288,
      2432,
      1340,
      4658,
      1342,
      1345,
      2694,
      1346,
      4659,
      137,
      4650,
      138,
      1347,
      68,
      1143,
      406,
      2446,
      3035,
      609,
      1408,
      392,
      3031,
      31,
      1718,
      890,
      2428,
      206,
      333
    ],
  ),
  "breastfeeding": SymbolsMetadata(
    popularity: 131,
    codepoint: 0xf856,
    categories: [3],
    tags: [
      3497,
      3498,
      684,
      4660,
      4661,
      4662,
      4663,
      1759,
      984,
      987,
      1760,
      4664,
      1001,
      1726,
      4665,
      225,
      692,
      1766,
      4666,
      583,
      3505,
      1003,
      4667,
      4342,
      4668,
      4669,
      895,
      4670,
      4671,
      4672,
      3507,
      4673,
      3509,
      4674,
      4675,
      4344,
      1007,
      4676,
      589,
      590,
      591,
      978,
      878,
      3517,
      4677,
      999
    ],
  ),
  "brick": SymbolsMetadata(
    popularity: 73,
    codepoint: 0xf388,
    categories: [3],
    tags: [
      481,
      4678,
      1354,
      918,
      4679,
      4680,
      3322,
      1477,
      1140,
      4681,
      4682,
      4683,
      1479,
      1356,
      1003,
      4684,
      4161,
      4685,
      4686,
      492,
      4687,
      4688,
      432,
      1128,
      979,
      433,
      4689,
      945,
      4690,
      3570,
      3339,
      2496,
      152,
      4691
    ],
  ),
  "brightness_1": SymbolsMetadata(
    popularity: 648,
    codepoint: 0xe3a6,
    categories: [1],
    tags: [
      72,
      747,
      281,
      1310,
      3590,
      4692,
      193,
      463,
      345,
      4053,
      2159,
      1743,
      1140,
      968,
      4693,
      2296,
      51,
      1382,
      790,
      4694,
      174,
      812,
      4046,
      4695,
      4696,
      328,
      330,
      410,
      2670,
      392,
      1317,
      3544,
      979,
      331,
      291,
      4697,
      2337
    ],
  ),
  "brightness_2": SymbolsMetadata(
    popularity: 404,
    codepoint: 0xe3a7,
    categories: [1],
    tags: [
      74,
      1738,
      2233,
      3590,
      193,
      4698,
      345,
      4053,
      4040,
      3601,
      8,
      138,
      1322,
      790,
      3594,
      635,
      4046,
      4015,
      410,
      151,
      2409,
      31,
      4699,
      413,
      1326,
      396,
      3598,
      476
    ],
  ),
  "brightness_3": SymbolsMetadata(
    popularity: 469,
    codepoint: 0xe3a8,
    categories: [1],
    tags: [
      75,
      1738,
      4032,
      2704,
      3590,
      4034,
      4700,
      193,
      345,
      4038,
      4053,
      751,
      4205,
      3601,
      8,
      1823,
      51,
      790,
      4701,
      635,
      4046,
      4015,
      4702,
      4703,
      410,
      151,
      1935,
      707,
      31,
      3883,
      551
    ],
  ),
  "brightness_4": SymbolsMetadata(
    popularity: 892,
    codepoint: 0xe3a9,
    categories: [1],
    tags: [
      624,
      2233,
      1403,
      3590,
      193,
      4698,
      345,
      4053,
      4704,
      8,
      3591,
      3592,
      4705,
      49,
      3593,
      790,
      3594,
      4706,
      4046,
      1834,
      4015,
      355,
      57,
      410,
      151,
      3465,
      1586,
      3598,
      856
    ],
  ),
  "brightness_5": SymbolsMetadata(
    popularity: 1034,
    codepoint: 0xe3aa,
    categories: [1],
    tags: [
      669,
      1738,
      4707,
      4032,
      3589,
      3590,
      4708,
      193,
      345,
      4709,
      4053,
      8,
      4710,
      3342,
      4705,
      3593,
      790,
      3594,
      3463,
      4046,
      355,
      358,
      3173,
      4711,
      410,
      151,
      4712,
      4713,
      854,
      1586,
      1326,
      4714,
      856
    ],
  ),
  "brightness_6": SymbolsMetadata(
    popularity: 1605,
    codepoint: 0xe3ab,
    categories: [1],
    tags: [
      680,
      1738,
      3590,
      193,
      4698,
      345,
      4053,
      4040,
      4715,
      2828,
      3601,
      8,
      1823,
      3591,
      3342,
      235,
      790,
      3594,
      4706,
      623,
      4046,
      848,
      3173,
      3596,
      391,
      410,
      151,
      3465,
      4716,
      854,
      1586,
      4000,
      856
    ],
  ),
  "brightness_7": SymbolsMetadata(
    popularity: 629,
    codepoint: 0xe3ac,
    categories: [1],
    tags: [
      745,
      1738,
      3589,
      3590,
      1466,
      193,
      778,
      4698,
      345,
      4053,
      4717,
      8,
      3342,
      1115,
      4705,
      235,
      4718,
      790,
      3594,
      4046,
      70,
      4719,
      3596,
      410,
      151,
      4720,
      4713,
      854,
      1586,
      4721,
      3598,
      4714,
      4722
    ],
  ),
  "brightness_alert": SymbolsMetadata(
    popularity: 189,
    codepoint: 0xf5cf,
    categories: [4],
    tags: [
      3074,
      1338,
      1339,
      1340,
      3590,
      1342,
      678,
      345,
      1345,
      8,
      2694,
      1346,
      4659,
      1459,
      3592,
      3600,
      1347,
      3078,
      790,
      3594,
      1143,
      262,
      623,
      609,
      4723,
      271,
      3081,
      3596,
      1408,
      410,
      71,
      1162,
      1586,
      31,
      1718,
      206,
      4724,
      4725
    ],
  ),
  "brightness_auto": SymbolsMetadata(
    popularity: 272,
    codepoint: 0xe1ab,
    categories: [4],
    tags: [
      3411,
      1738,
      2233,
      4726,
      2048,
      4727,
      3331,
      4728,
      3590,
      4729,
      345,
      8,
      769,
      1823,
      138,
      1322,
      790,
      3594,
      4199,
      406,
      262,
      623,
      271,
      410,
      4730,
      4731,
      64,
      151,
      71,
      3201,
      854,
      1586,
      31,
      2220
    ],
  ),
  "brightness_empty": SymbolsMetadata(
    popularity: 68,
    codepoint: 0xf7e8,
    categories: [4],
    tags: [
      4732,
      2233,
      1108,
      3589,
      3590,
      193,
      345,
      8,
      809,
      2240,
      3342,
      51,
      3593,
      790,
      3594,
      87,
      4706,
      289,
      848,
      3173,
      3174,
      3596,
      330,
      410,
      151,
      854,
      1147,
      1586,
      1413,
      2220,
      36
    ],
  ),
  "brightness_medium": SymbolsMetadata(
    popularity: 492,
    codepoint: 0xe1ae,
    categories: [4],
    tags: [
      2233,
      2048,
      3590,
      193,
      678,
      345,
      1381,
      8,
      3342,
      4705,
      1322,
      790,
      3594,
      3835,
      262,
      623,
      70,
      271,
      3173,
      4711,
      410,
      151,
      1586,
      3598,
      476
    ],
  ),
  "bring_your_own_ip": SymbolsMetadata(
    popularity: 915,
    codepoint: 0xe016,
    categories: [3],
    tags: [
      858,
      1493,
      4733,
      4734,
      678,
      284,
      254,
      345,
      4735,
      81,
      4736,
      320,
      1582,
      68,
      259,
      4737,
      4738,
      4739,
      3629,
      267,
      4740,
      523,
      4741,
      911,
      2150,
      975,
      4742,
      1011,
      71,
      526,
      527,
      1510,
      498,
      333,
      334,
      4743
    ],
  ),
  "broadcast_on_home": SymbolsMetadata(
    popularity: 194,
    codepoint: 0xf8f8,
    categories: [0],
    tags: [
      2035,
      1246,
      729,
      4246,
      283,
      1047,
      254,
      621,
      288,
      1116,
      1479,
      406,
      267,
      4744,
      2318,
      1508,
      273,
      1911,
      1899,
      1271,
      1272,
      411,
      65,
      2074,
      4745,
      1866,
      278,
      4746
    ],
  ),
  "broadcast_on_personal": SymbolsMetadata(
    popularity: 251,
    codepoint: 0xf8f9,
    categories: [0],
    tags: [
      565,
      4747,
      566,
      729,
      283,
      284,
      44,
      1726,
      259,
      1260,
      4748,
      267,
      523,
      590,
      911,
      591,
      1332,
      4749,
      2044,
      273,
      705,
      454,
      4745,
      890,
      597,
      1866
    ],
  ),
  "broken_image": SymbolsMetadata(
    popularity: 1019,
    codepoint: 0xe3ad,
    categories: [1],
    tags: [
      480,
      1339,
      2692,
      4750,
      4751,
      3244,
      4752,
      4753,
      4754,
      4755,
      4291,
      1138,
      2694,
      4756,
      2695,
      1142,
      49,
      4757,
      4758,
      4759,
      4760,
      4761,
      1583,
      584,
      4762,
      4763,
      1584,
      1585,
      815,
      57,
      59,
      62,
      4764,
      818,
      4765,
      432,
      433,
      4766,
      1718,
      206
    ],
  ),
  "browse": SymbolsMetadata(
    popularity: 178,
    codepoint: 0xeb13,
    categories: [6],
    tags: [
      2154,
      2673,
      4767,
      4768,
      621,
      81,
      145,
      4769,
      1567,
      3762,
      316,
      1677,
      317,
      2161,
      382,
      173,
      68,
      86,
      385,
      1323,
      88,
      587,
      1574,
      3384,
      1575,
      4770,
      4771,
      4088,
      4772,
      1102,
      594,
      396,
      333
    ],
  ),
  "browse_activity": SymbolsMetadata(
    popularity: 1417,
    codepoint: 0xf8a5,
    categories: [2],
    tags: [
      4572,
      2504,
      4773,
      2673,
      4774,
      4775,
      1699,
      288,
      8,
      4776,
      4777,
      1726,
      1051,
      1086,
      2757,
      4778,
      1617,
      88,
      4779,
      4780,
      623,
      609,
      91,
      2759,
      1619,
      757,
      4781,
      453,
      410,
      2802,
      94,
      854,
      454,
      2453,
      3756,
      890
    ],
  ),
  "browse_gallery": SymbolsMetadata(
    popularity: 1702,
    codepoint: 0xebd1,
    categories: [2],
    tags: [
      1320,
      4782,
      2673,
      4783,
      4784,
      4785,
      4786,
      1135,
      1175,
      4787,
      4788,
      316,
      4789,
      1321,
      382,
      4790,
      49,
      2499,
      1323,
      406,
      4791,
      92,
      57,
      4792,
      62,
      4793,
      594,
      980,
      396,
      476,
      4794,
      2747,
      2102
    ],
  ),
  "browser_updated": SymbolsMetadata(
    popularity: 663,
    codepoint: 0xe7cf,
    categories: [11],
    tags: [
      1223,
      1224,
      501,
      77,
      1156,
      2113,
      1698,
      463,
      519,
      4445,
      1699,
      288,
      8,
      2342,
      520,
      2639,
      4795,
      1086,
      1230,
      1692,
      4796,
      259,
      1700,
      623,
      325,
      4797,
      1574,
      1098,
      757,
      758,
      410,
      509,
      291,
      245,
      4434,
      1665,
      890,
      4798,
      4799,
      333,
      4800,
      1164,
      1165
    ],
  ),
  "brunch_dining": SymbolsMetadata(
    popularity: 474,
    codepoint: 0xea73,
    categories: [16],
    tags: [
      4801,
      3651,
      3652,
      3653,
      4802,
      3656,
      4803,
      3658,
      4804,
      4805,
      4178,
      3659,
      4806,
      4807,
      2370,
      2941,
      4808,
      4070,
      3661,
      4809,
      4810,
      4811,
      1931,
      3665,
      151,
      4812,
      4813,
      1453,
      4814
    ],
  ),
  "brush": SymbolsMetadata(
    popularity: 3915,
    codepoint: 0xe3ae,
    categories: [1],
    tags: [
      1580,
      2155,
      4815,
      4816,
      4817,
      4514,
      2299,
      485,
      4818,
      2748,
      378,
      4819,
      1229,
      673,
      2172,
      2240,
      490,
      580,
      384,
      4820,
      87,
      492,
      4821,
      3047,
      4822,
      4823,
      392,
      1147,
      2180,
      1717,
      511,
      1296
    ],
  ),
  "bubble": SymbolsMetadata(
    popularity: 105,
    codepoint: 0xef83,
    categories: [2],
    tags: [
      77,
      502,
      4824,
      567,
      569,
      2706,
      193,
      4825,
      4826,
      571,
      572,
      4827,
      1455,
      2358,
      1456,
      313,
      2710,
      809,
      585,
      2315,
      289,
      907,
      392,
      4828,
      593,
      1464,
      1274,
      4829,
      4830,
      4831,
      4832,
      4833,
      4834,
      4835,
      1696,
      4836
    ],
    rtlAutoMirrored: true,
  ),
  "bubble_chart": SymbolsMetadata(
    popularity: 1338,
    codepoint: 0xe6dd,
    categories: [9],
    tags: [
      1402,
      1045,
      1403,
      517,
      567,
      4837,
      373,
      1076,
      4838,
      3719,
      1405,
      81,
      4839,
      4337,
      375,
      1052,
      1177,
      1055,
      68,
      226,
      1060,
      22,
      848,
      1407,
      4090,
      1408,
      4620,
      4840,
      4841,
      4842,
      744,
      1070,
      2458,
      2770,
      3718
    ],
  ),
  "bubbles": SymbolsMetadata(
    popularity: 52,
    codepoint: 0xf64e,
    categories: [2],
    tags: [
      480,
      4843,
      1288,
      77,
      502,
      3491,
      3769,
      4168,
      3773,
      4844,
      4802,
      4134,
      1076,
      3788,
      1188,
      2799,
      2738,
      3547,
      313,
      2778,
      4178,
      4845,
      4846,
      4847,
      4848,
      137,
      1322,
      3594,
      4186,
      3336,
      2743,
      907,
      4147,
      4849,
      4850,
      4841,
      141,
      1327,
      4289,
      1165
    ],
  ),
  "bug_report": SymbolsMetadata(
    popularity: 6780,
    codepoint: 0xe868,
    categories: [6],
    tags: [
      4851,
      4747,
      2481,
      4852,
      4853,
      193,
      4854,
      1291,
      2694,
      4855,
      4856,
      1459,
      4857,
      1745,
      4858,
      4859,
      3078,
      4860,
      4861,
      3081,
      4862,
      1408,
      4863,
      4864,
      4865,
      4866,
      4867,
      4868,
      2392,
      206
    ],
  ),
  "build": SymbolsMetadata(
    popularity: 8513,
    codepoint: 0xe869,
    categories: [6],
    tags: [
      1738,
      2233,
      1354,
      918,
      678,
      1477,
      345,
      2749,
      46,
      1745,
      4869,
      1780,
      4870,
      1086,
      1116,
      4871,
      4820,
      4872,
      3920,
      3416,
      1119,
      70,
      4873,
      645,
      71,
      4874,
      511,
      4875,
      1296,
      3989,
      1498,
      1786
    ],
  ),
  "build_circle": SymbolsMetadata(
    popularity: 2668,
    codepoint: 0xef48,
    categories: [6],
    tags: [
      1738,
      1354,
      193,
      1778,
      678,
      1355,
      2800,
      1302,
      1080,
      4876,
      1745,
      1780,
      4872,
      3920,
      3416,
      70,
      2846,
      912,
      4873,
      330,
      71,
      1752,
      4874,
      140,
      511,
      1786
    ],
  ),
  "bungalow": SymbolsMetadata(
    popularity: 264,
    codepoint: 0xe591,
    categories: [16],
    tags: [
      1475,
      1476,
      918,
      4877,
      1643,
      4878,
      1477,
      4879,
      1478,
      2547,
      1116,
      4880,
      1479,
      4881,
      2548,
      3793,
      1520,
      327,
      1480,
      4882,
      2550,
      1481,
      4110,
      1482,
      1483,
      4883,
      1484,
      4884,
      4885,
      3699,
      945,
      4886,
      1207
    ],
  ),
  "burst_mode": SymbolsMetadata(
    popularity: 248,
    codepoint: 0xe43c,
    categories: [1],
    tags: [
      746,
      3340,
      4887,
      40,
      42,
      750,
      1141,
      437,
      49,
      1583,
      4888,
      635,
      1584,
      1585,
      2162,
      57,
      59,
      62,
      3067,
      4889,
      3426,
      4890,
      94,
      2451,
      4891,
      4892,
      1325,
      4893,
      275,
      454,
      4894
    ],
  ),
  "bus_alert": SymbolsMetadata(
    popularity: 462,
    codepoint: 0xe98f,
    categories: [14],
    tags: [
      3074,
      1339,
      1340,
      1816,
      1940,
      1818,
      1819,
      1342,
      193,
      1345,
      2694,
      1346,
      4659,
      1347,
      1520,
      1143,
      609,
      2058,
      432,
      1620,
      1162,
      273,
      1203,
      31,
      1848,
      1623,
      332,
      1850,
      206
    ],
  ),
  "bus_railway": SymbolsMetadata(
    popularity: 21,
    codepoint: 0xf36b,
    categories: [14],
    tags: [
      1816,
      1940,
      1818,
      4895,
      1819,
      2544,
      4105,
      312,
      313,
      1616,
      1617,
      87,
      4896,
      2054,
      1520,
      4897,
      1928,
      2057,
      2058,
      4327,
      4328,
      1621,
      3516,
      4329,
      2164,
      1944,
      4330,
      1994,
      1623,
      332,
      1656,
      1486,
      1850,
      4898,
      4129
    ],
  ),
  "business_center": SymbolsMetadata(
    popularity: 5291,
    codepoint: 0xeb3f,
    categories: [5],
    tags: [
      1869,
      4899,
      1641,
      4438,
      4900,
      482,
      1494,
      919,
      4901,
      4902,
      4903,
      308,
      924,
      1311,
      1366,
      4904,
      580,
      2464,
      1356,
      1495,
      3618,
      492,
      1372,
      911,
      2549,
      3073,
      4905,
      960,
      432,
      1685,
      2535,
      4443,
      332,
      1498
    ],
  ),
  "business_chip": SymbolsMetadata(
    popularity: 36,
    codepoint: 0xf84c,
    categories: [12],
    tags: [
      4906,
      1476,
      1641,
      4438,
      1494,
      918,
      919,
      4907,
      920,
      4903,
      4908,
      4909,
      2544,
      1157,
      1365,
      1366,
      4910,
      1367,
      1368,
      4911,
      4912,
      969,
      935,
      1372,
      4913,
      1063,
      4905,
      591,
      4914,
      960,
      2551,
      945,
      4443,
      1486,
      1498
    ],
  ),
  "business_messages": SymbolsMetadata(
    popularity: 68,
    codepoint: 0xef84,
    categories: [7],
    tags: [
      502,
      567,
      919,
      569,
      2706,
      924,
      283,
      4915,
      1365,
      4916,
      965,
      1455,
      2708,
      1366,
      2709,
      1367,
      1603,
      585,
      4917,
      4918,
      1372,
      4919,
      4905,
      4920,
      4921,
      645,
      593,
      1464,
      878,
      1274,
      33,
      4922,
      1498
    ],
    rtlAutoMirrored: true,
  ),
  "buttons_alt": SymbolsMetadata(
    popularity: 40,
    codepoint: 0xe72f,
    categories: [2],
    tags: [
      231,
      4923,
      480,
      746,
      1579,
      2394,
      1310,
      504,
      1075,
      193,
      1078,
      3322,
      1742,
      1405,
      1140,
      4847,
      1142,
      1087,
      1603,
      1322,
      385,
      506,
      70,
      1749,
      239,
      362,
      71,
      392,
      433,
      2409,
      31,
      413,
      1718,
      141
    ],
  ),
  "cabin": SymbolsMetadata(
    popularity: 497,
    codepoint: 0xe589,
    categories: [16],
    tags: [
      1475,
      1476,
      1310,
      918,
      1918,
      3610,
      4879,
      4450,
      4924,
      1478,
      3007,
      2547,
      3995,
      1116,
      1479,
      3793,
      4779,
      4925,
      1520,
      1834,
      3996,
      327,
      1480,
      2550,
      1481,
      432,
      1482,
      1483,
      4883,
      1838,
      1484,
      1317,
      433,
      3699,
      945,
      332,
      4886,
      1718,
      1952,
      4926,
      1207,
      4927
    ],
  ),
  "cable": SymbolsMetadata(
    popularity: 1388,
    codepoint: 0xefe6,
    categories: [4],
    tags: [
      2088,
      4928,
      283,
      3322,
      1047,
      284,
      4929,
      4930,
      81,
      288,
      44,
      3826,
      3879,
      2527,
      2532,
      1086,
      1087,
      87,
      1294,
      267,
      4931,
      3739,
      1732,
      3927,
      2474,
      3645,
      273,
      4932,
      65,
      526,
      4745,
      1297,
      4933
    ],
  ),
  "cable_car": SymbolsMetadata(
    popularity: 4,
    codepoint: 0xf479,
    categories: [14],
    tags: [
      4934,
      4935,
      1816,
      1918,
      4928,
      4936,
      1818,
      4895,
      1819,
      312,
      313,
      2416,
      4937,
      1617,
      2986,
      87,
      1520,
      1584,
      4938,
      1928,
      2057,
      2058,
      4327,
      4328,
      3782,
      1621,
      4939,
      2008,
      4329,
      4940,
      3286,
      1944,
      4330,
      1994,
      1623,
      332,
      1656,
      1850
    ],
  ),
  "cached": SymbolsMetadata(
    popularity: 5597,
    codepoint: 0xe86a,
    categories: [2],
    tags: [
      858,
      460,
      502,
      3428,
      3429,
      193,
      1673,
      284,
      81,
      1448,
      4769,
      520,
      1677,
      2161,
      68,
      3431,
      2998,
      3432,
      755,
      2758,
      267,
      1036,
      756,
      758,
      759,
      2441,
      2761,
      470,
      1683,
      2971,
      1685,
      1377,
      762,
      763,
      1068,
      2946,
      890
    ],
  ),
  "cadence": SymbolsMetadata(
    popularity: 70,
    codepoint: 0xf4b4,
    categories: [15],
    tags: [
      1246,
      4941,
      4942,
      3306,
      3725,
      4943,
      4944,
      4945,
      4946,
      4947,
      373,
      4948,
      2079,
      11,
      2831,
      2533,
      351,
      4949,
      1052,
      790,
      1701,
      4950,
      4233,
      4951,
      2835,
      29,
      273,
      1271,
      2084,
      3753,
      4952,
      4953,
      554,
      4954,
      1866,
      3318
    ],
  ),
  "cake": SymbolsMetadata(
    popularity: 3922,
    codepoint: 0xe7e9,
    categories: [15],
    tags: [
      743,
      4955,
      4956,
      3647,
      3648,
      4957,
      4958,
      4959,
      4960,
      4961,
      4962,
      4634,
      3657,
      4637,
      10,
      4963,
      2370,
      4964,
      4965,
      1974,
      886,
      4966,
      588,
      4967,
      3663,
      3664,
      239,
      4968,
      3668,
      705,
      4969,
      4970,
      3669,
      31,
      3670
    ],
  ),
  "cake_add": SymbolsMetadata(
    popularity: 99,
    codepoint: 0xf85b,
    categories: [15],
    tags: [
      743,
      4971,
      4955,
      4972,
      3647,
      3648,
      4957,
      4958,
      4959,
      4961,
      4962,
      1302,
      3341,
      3657,
      4973,
      10,
      4963,
      2370,
      4964,
      4965,
      4974,
      4975,
      886,
      4966,
      588,
      3663,
      239,
      4976,
      3669,
      3670
    ],
  ),
  "calculate": SymbolsMetadata(
    popularity: 7542,
    codepoint: 0xea5f,
    categories: [9],
    tags: [
      231,
      4977,
      4978,
      232,
      1299,
      4979,
      4980,
      80,
      169,
      45,
      1112,
      4981,
      622,
      968,
      4982,
      381,
      1090,
      87,
      791,
      4983,
      3172,
      4984,
      22,
      4985,
      492,
      227,
      392,
      979,
      4986,
      668,
      31,
      65,
      511,
      230
    ],
  ),
  "calendar_add_on": SymbolsMetadata(
    popularity: 2242,
    codepoint: 0xef85,
    categories: [7],
    tags: [
      231,
      743,
      4987,
      1657,
      1916,
      1108,
      504,
      2104,
      1302,
      1136,
      4715,
      10,
      138,
      1305,
      4779,
      1143,
      4988,
      886,
      1433,
      289,
      4989,
      239,
      453,
      977,
      1350,
      1145,
      433,
      31,
      1148,
      4990,
      141,
      4991
    ],
  ),
  "calendar_apps_script": SymbolsMetadata(
    popularity: 322,
    codepoint: 0xf0bb,
    categories: [7],
    tags: [
      4992,
      501,
      1657,
      4993,
      1890,
      482,
      2104,
      1077,
      1047,
      1136,
      4715,
      1293,
      1080,
      10,
      2561,
      2557,
      584,
      1294,
      1004,
      4988,
      1063,
      3568,
      4994,
      1099,
      432,
      1350,
      1145,
      3022,
      762,
      4990,
      511,
      4991
    ],
  ),
  "calendar_clock": SymbolsMetadata(
    popularity: 316,
    codepoint: 0xf540,
    categories: [6],
    tags: [
      4987,
      1338,
      1339,
      1657,
      1341,
      1916,
      2104,
      193,
      1135,
      1136,
      4715,
      2105,
      867,
      2117,
      1033,
      10,
      2093,
      4995,
      550,
      1004,
      4988,
      609,
      22,
      92,
      4989,
      2447,
      1350,
      1145,
      433,
      1148,
      1149,
      4996,
      4990,
      2102
    ],
  ),
  "calendar_month": SymbolsMetadata(
    popularity: 38254,
    codepoint: 0xebcc,
    categories: [6],
    tags: [
      4987,
      1657,
      1916,
      2104,
      1136,
      4715,
      1567,
      2117,
      1568,
      10,
      382,
      584,
      4997,
      4988,
      1460,
      4998,
      1575,
      4999,
      3568,
      453,
      432,
      1145,
      5000,
      433,
      1148,
      4996,
      4990,
      5001,
      4991
    ],
  ),
  "calendar_today": SymbolsMetadata(
    popularity: 11929,
    codepoint: 0xe935,
    categories: [6],
    tags: [
      4987,
      1657,
      1916,
      2104,
      5002,
      5003,
      5004,
      1136,
      5005,
      4715,
      5006,
      10,
      382,
      584,
      4988,
      5007,
      4998,
      1664,
      3568,
      5008,
      432,
      1350,
      1145,
      433,
      1148,
      4990,
      5009,
      5001,
      4991,
      5010
    ],
  ),
  "calendar_view_day": SymbolsMetadata(
    popularity: 705,
    codepoint: 0xe936,
    categories: [12],
    tags: [
      2504,
      4987,
      1657,
      5011,
      2104,
      1419,
      1136,
      4715,
      5012,
      303,
      10,
      4777,
      370,
      382,
      385,
      2893,
      88,
      5013,
      1957,
      4988,
      92,
      1664,
      432,
      1145,
      5014,
      392,
      3544,
      1148,
      2453,
      4990,
      1445,
      396,
      5001
    ],
  ),
  "calendar_view_month": SymbolsMetadata(
    popularity: 1007,
    codepoint: 0xefe7,
    categories: [12],
    tags: [
      4987,
      5011,
      1447,
      481,
      1916,
      482,
      2104,
      1136,
      4715,
      10,
      4777,
      370,
      382,
      581,
      385,
      584,
      4071,
      4988,
      4998,
      289,
      3568,
      432,
      1350,
      1145,
      945,
      1148,
      4990,
      1445,
      396,
      5015,
      5010
    ],
  ),
  "calendar_view_week": SymbolsMetadata(
    popularity: 755,
    codepoint: 0xefe8,
    categories: [12],
    tags: [
      5011,
      1447,
      2104,
      923,
      1136,
      5016,
      4715,
      5017,
      8,
      10,
      4777,
      370,
      382,
      385,
      1004,
      4988,
      4998,
      5018,
      4989,
      3568,
      432,
      1145,
      5019,
      945,
      1148,
      2453,
      4990,
      1445,
      396,
      5001,
      5015
    ],
  ),
  "call": SymbolsMetadata(
    popularity: 48124,
    codepoint: 0xe0b0,
    categories: [7],
    tags: [
      1246,
      5020,
      1248,
      5021,
      1227,
      251,
      283,
      284,
      965,
      966,
      5022,
      288,
      1381,
      5023,
      1086,
      5024,
      5025,
      5026,
      262,
      5027,
      271,
      5028,
      5029,
      1796,
      3325,
      2095,
      645,
      1273,
      878,
      1274,
      1387,
      1277
    ],
  ),
  "call_end": SymbolsMetadata(
    popularity: 1834,
    codepoint: 0xe0b1,
    categories: [7],
    tags: [
      1246,
      504,
      1248,
      1187,
      1227,
      1188,
      283,
      965,
      345,
      5030,
      288,
      3247,
      2207,
      5031,
      1086,
      2311,
      1603,
      262,
      5032,
      271,
      906,
      4221,
      2095,
      392,
      1203,
      31,
      1387,
      3440,
      1277
    ],
  ),
  "call_log": SymbolsMetadata(
    popularity: 39,
    codepoint: 0xe08e,
    categories: [7],
    tags: [
      2154,
      1248,
      5033,
      5034,
      1227,
      251,
      4775,
      283,
      5035,
      965,
      967,
      43,
      288,
      4769,
      4776,
      1086,
      2757,
      4778,
      2311,
      68,
      88,
      4779,
      5036,
      262,
      5032,
      271,
      5037,
      4781,
      453,
      1695,
      3039,
      276,
      1387,
      5038
    ],
  ),
  "call_made": SymbolsMetadata(
    popularity: 1409,
    codepoint: 0xe0b2,
    categories: [7],
    tags: [
      746,
      2504,
      2887,
      77,
      1248,
      5039,
      283,
      254,
      345,
      288,
      1689,
      313,
      2954,
      138,
      51,
      1322,
      87,
      5040,
      1294,
      5041,
      262,
      1618,
      2914,
      5032,
      271,
      1144,
      1694,
      1508,
      31,
      1387,
      5042
    ],
    rtlAutoMirrored: true,
  ),
  "call_merge": SymbolsMetadata(
    popularity: 450,
    codepoint: 0xe0b3,
    categories: [7],
    tags: [
      77,
      502,
      1046,
      1248,
      2799,
      1301,
      1047,
      5043,
      5044,
      5045,
      5046,
      5047,
      5048,
      81,
      288,
      375,
      313,
      1081,
      5049,
      1052,
      4086,
      1306,
      584,
      1294,
      1308,
      262,
      267,
      3418,
      848,
      945,
      5050,
      4570
    ],
    rtlAutoMirrored: true,
  ),
  "call_missed": SymbolsMetadata(
    popularity: 355,
    codepoint: 0xe0b4,
    categories: [7],
    tags: [
      1339,
      500,
      5051,
      77,
      1248,
      5052,
      283,
      965,
      5053,
      288,
      5054,
      1138,
      5055,
      313,
      2778,
      5056,
      5031,
      2757,
      87,
      4779,
      5057,
      5058,
      262,
      609,
      271,
      5059,
      5060,
      1695,
      65,
      1387,
      5061
    ],
    rtlAutoMirrored: true,
  ),
  "call_missed_outgoing": SymbolsMetadata(
    popularity: 388,
    codepoint: 0xe0e4,
    categories: [7],
    tags: [
      77,
      5062,
      1248,
      251,
      283,
      284,
      965,
      288,
      2358,
      1381,
      313,
      5063,
      2757,
      138,
      3493,
      51,
      87,
      4779,
      5057,
      262,
      267,
      21,
      5032,
      271,
      328,
      907,
      273,
      31,
      1387,
      5064,
      1696
    ],
    rtlAutoMirrored: true,
  ),
  "call_quality": SymbolsMetadata(
    popularity: 43,
    codepoint: 0xf652,
    categories: [7],
    tags: [
      1339,
      1402,
      1154,
      2454,
      865,
      1246,
      1403,
      1248,
      1227,
      251,
      283,
      284,
      254,
      965,
      145,
      288,
      3192,
      1086,
      873,
      5065,
      51,
      293,
      68,
      790,
      17,
      18,
      262,
      267,
      641,
      271,
      63,
      203,
      272,
      645,
      273,
      1271,
      642,
      878,
      65,
      1387,
      5061,
      1867
    ],
  ),
  "call_received": SymbolsMetadata(
    popularity: 937,
    codepoint: 0xe0b5,
    categories: [7],
    tags: [
      2628,
      1339,
      5066,
      2879,
      77,
      1246,
      2204,
      1248,
      5067,
      283,
      254,
      2885,
      288,
      313,
      520,
      2757,
      5068,
      2311,
      5025,
      2216,
      87,
      4779,
      585,
      262,
      609,
      271,
      328,
      2317,
      5060,
      273,
      1387,
      1277
    ],
    rtlAutoMirrored: true,
  ),
  "call_split": SymbolsMetadata(
    popularity: 948,
    codepoint: 0xe0b6,
    categories: [7],
    tags: [
      746,
      77,
      502,
      2938,
      1248,
      5069,
      283,
      1047,
      284,
      345,
      288,
      313,
      3247,
      2199,
      5070,
      2285,
      2941,
      584,
      506,
      262,
      237,
      5071,
      325,
      267,
      70,
      1619,
      271,
      2915,
      2944,
      4486,
      1508,
      2408,
      2286,
      1387,
      526
    ],
    rtlAutoMirrored: true,
  ),
  "call_to_action": SymbolsMetadata(
    popularity: 597,
    codepoint: 0xe06c,
    categories: [0],
    tags: [
      746,
      747,
      1339,
      77,
      1403,
      504,
      1248,
      1789,
      450,
      5072,
      2675,
      5073,
      1793,
      5074,
      485,
      1699,
      5075,
      2664,
      2666,
      1115,
      138,
      293,
      68,
      5076,
      1603,
      1322,
      385,
      1294,
      585,
      262,
      325,
      609,
      1144,
      2808,
      1096,
      410,
      362,
      2790,
      1706,
      1798,
      5077,
      141,
      1326,
      1327,
      333,
      1164,
      1165
    ],
  ),
  "camera": SymbolsMetadata(
    popularity: 2726,
    codepoint: 0xe3af,
    categories: [1],
    tags: [
      5078,
      504,
      40,
      42,
      5079,
      288,
      44,
      2527,
      346,
      4118,
      137,
      138,
      49,
      3894,
      53,
      406,
      3739,
      57,
      59,
      62,
      453,
      440,
      4891,
      1325,
      5080,
      31,
      511,
      1326,
      37,
      5081,
      476
    ],
  ),
  "camera_front": SymbolsMetadata(
    popularity: 391,
    codepoint: 0xe3b1,
    categories: [1],
    tags: [
      77,
      684,
      40,
      5082,
      42,
      2397,
      193,
      5083,
      288,
      313,
      5084,
      5085,
      902,
      5086,
      5087,
      583,
      1087,
      53,
      4997,
      262,
      5088,
      590,
      271,
      59,
      974,
      5089,
      591,
      453,
      470,
      5090,
      5091,
      1508,
      243,
      433,
      2409,
      5092,
      413,
      526,
      527,
      597,
      5093,
      37,
      5094
    ],
  ),
  "camera_indoor": SymbolsMetadata(
    popularity: 407,
    codepoint: 0xefe9,
    categories: [8],
    tags: [
      1476,
      1890,
      918,
      40,
      5095,
      288,
      5096,
      2527,
      2547,
      346,
      5097,
      1116,
      5098,
      1479,
      49,
      2718,
      5099,
      2719,
      5100,
      5101,
      5102,
      3470,
      353,
      1119,
      5103,
      62,
      327,
      696,
      2550,
      440,
      1482,
      1483,
      702,
      1011,
      5104,
      1484,
      1899,
      454,
      5105,
      5106,
      65,
      37,
      5107,
      434
    ],
  ),
  "camera_outdoor": SymbolsMetadata(
    popularity: 322,
    codepoint: 0xefea,
    categories: [8],
    tags: [
      1476,
      918,
      919,
      40,
      5095,
      1157,
      5096,
      2547,
      3692,
      346,
      5097,
      5108,
      1116,
      5098,
      1479,
      49,
      623,
      3470,
      353,
      1119,
      1836,
      5109,
      2362,
      1122,
      62,
      327,
      1480,
      696,
      2550,
      453,
      440,
      1482,
      1483,
      702,
      1011,
      5104,
      1484,
      5105,
      5106,
      37,
      434,
      396,
      4484
    ],
  ),
  "camera_rear": SymbolsMetadata(
    popularity: 158,
    codepoint: 0xe3b2,
    categories: [1],
    tags: [
      77,
      40,
      5110,
      42,
      193,
      5111,
      288,
      313,
      1743,
      1690,
      5086,
      5112,
      1087,
      53,
      406,
      262,
      5088,
      1693,
      1732,
      271,
      57,
      59,
      62,
      974,
      5113,
      5114,
      440,
      1694,
      5091,
      2318,
      1508,
      433,
      526,
      527,
      37,
      443
    ],
  ),
  "camera_roll": SymbolsMetadata(
    popularity: 450,
    codepoint: 0xe3b3,
    categories: [1],
    tags: [
      1320,
      4786,
      40,
      5115,
      1175,
      5116,
      346,
      1321,
      49,
      5117,
      5118,
      2499,
      1323,
      406,
      5119,
      262,
      57,
      5120,
      5121,
      5122,
      59,
      5123,
      4792,
      4793,
      5124,
      5125,
      1695,
      5126,
      4794
    ],
  ),
  "camera_video": SymbolsMetadata(
    popularity: 84,
    codepoint: 0xf7a6,
    categories: [11],
    tags: [
      729,
      4648,
      5127,
      40,
      42,
      344,
      5128,
      779,
      346,
      5097,
      1086,
      49,
      53,
      1260,
      406,
      353,
      354,
      439,
      62,
      2500,
      453,
      440,
      432,
      454,
      411,
      37,
      434,
      476,
      3586
    ],
  ),
  "cameraswitch": SymbolsMetadata(
    popularity: 1105,
    codepoint: 0xefeb,
    categories: [4],
    tags: [
      77,
      502,
      5129,
      40,
      5130,
      5131,
      5132,
      5133,
      193,
      5134,
      283,
      5085,
      5135,
      5087,
      5088,
      5136,
      59,
      453,
      470,
      5137,
      5138,
      4891,
      3584,
      2409,
      5092,
      2946,
      5094,
      5139,
      5140,
      434,
      396
    ],
  ),
  "campaign": SymbolsMetadata(
    popularity: 10631,
    codepoint: 0xef49,
    categories: [15],
    tags: [
      3,
      746,
      1153,
      1339,
      1154,
      1155,
      1171,
      4961,
      2321,
      2885,
      313,
      3477,
      10,
      4451,
      13,
      87,
      4374,
      1159,
      5141,
      1263,
      20,
      325,
      609,
      492,
      5142,
      328,
      757,
      1161,
      392,
      1272,
      245,
      31,
      1718,
      5143,
      1866,
      1868
    ],
  ),
  "camping": SymbolsMetadata(
    popularity: 787,
    codepoint: 0xf8a2,
    categories: [15],
    tags: [
      2504,
      3607,
      5144,
      3610,
      312,
      5145,
      5146,
      5147,
      1974,
      1975,
      323,
      1584,
      1834,
      1836,
      5148,
      3282,
      1484,
      2790,
      5149,
      3286,
      332,
      1718,
      1952,
      5150
    ],
  ),
  "cancel": SymbolsMetadata(
    popularity: 41239,
    codepoint: 0xe5c9,
    categories: [2],
    tags: [
      746,
      1339,
      504,
      1187,
      193,
      778,
      1188,
      345,
      1213,
      5030,
      1031,
      4594,
      2694,
      1190,
      1459,
      5151,
      5152,
      5153,
      352,
      325,
      3254,
      4221,
      1039,
      392,
      1203,
      31,
      1326,
      1042,
      3712,
      3951
    ],
  ),
  "cancel_presentation": SymbolsMetadata(
    popularity: 1195,
    codepoint: 0xe0e9,
    categories: [7],
    tags: [
      5154,
      1187,
      778,
      1188,
      5083,
      1213,
      5155,
      288,
      5156,
      4594,
      8,
      2207,
      5157,
      1190,
      3363,
      4997,
      623,
      3254,
      5158,
      1407,
      388,
      5159,
      4220,
      432,
      5160,
      1039,
      5161,
      410,
      2797,
      5162,
      1203,
      3440,
      1164,
      1165,
      3712,
      3951
    ],
  ),
  "cancel_schedule_send": SymbolsMetadata(
    popularity: 588,
    codepoint: 0xea39,
    categories: [7],
    tags: [
      5154,
      77,
      1187,
      5163,
      778,
      1135,
      283,
      1213,
      5164,
      1031,
      2308,
      489,
      3363,
      2312,
      585,
      3254,
      1331,
      1705,
      4220,
      1039,
      5161,
      1145,
      5165,
      5166,
      5167,
      2318,
      1508,
      1203,
      1148,
      3360,
      5168,
      3712,
      3951
    ],
  ),
  "candle": SymbolsMetadata(
    popularity: 25,
    codepoint: 0xf588,
    categories: [3],
    tags: [
      4957,
      5169,
      5170,
      4959,
      5171,
      4961,
      5172,
      2738,
      1140,
      5173,
      5174,
      3342,
      4198,
      5175,
      3605,
      3594,
      5176,
      5177,
      5178,
      5179,
      492,
      289,
      5180,
      5181,
      5182,
      1317,
      3544,
      5183,
      5184,
      5185,
      5186,
      1445,
      5187,
      5188,
      5189
    ],
  ),
  "candlestick_chart": SymbolsMetadata(
    popularity: 696,
    codepoint: 0xead4,
    categories: [9],
    tags: [
      1402,
      1045,
      3725,
      517,
      919,
      5171,
      373,
      5190,
      81,
      4337,
      375,
      5191,
      5192,
      954,
      931,
      932,
      1052,
      234,
      1055,
      936,
      5193,
      4619,
      1370,
      226,
      1060,
      1408,
      744,
      5194,
      5195,
      5196,
      1070,
      5197,
      5198,
      1409
    ],
  ),
  "cannabis": SymbolsMetadata(
    popularity: 16,
    codepoint: 0xf2f3,
    categories: [3],
    tags: [
      1815,
      1817,
      5199,
      5200,
      5201,
      1822,
      5202,
      1763,
      1828,
      234,
      1830,
      5203,
      5204,
      5205,
      5206,
      1832,
      2438,
      5207,
      895,
      5208,
      1833,
      1834,
      1835,
      1837,
      5209,
      3282,
      5210,
      5211,
      5212,
      5213
    ],
  ),
  "captive_portal": SymbolsMetadata(
    popularity: 225,
    codepoint: 0xf728,
    categories: [2],
    tags: [
      858,
      77,
      1019,
      5214,
      1030,
      1156,
      5215,
      5216,
      1047,
      5217,
      284,
      313,
      5218,
      320,
      1087,
      259,
      5219,
      5220,
      2216,
      3792,
      1294,
      971,
      5221,
      267,
      5222,
      5223,
      5224,
      5225,
      1574,
      5226,
      5227,
      2915,
      5228,
      527,
      1164,
      277,
      5229,
      334,
      5230
    ],
  ),
  "capture": SymbolsMetadata(
    popularity: 95,
    codepoint: 0xf727,
    categories: [2],
    tags: [
      1288,
      501,
      1107,
      5231,
      1108,
      1109,
      482,
      2692,
      40,
      42,
      2675,
      1820,
      752,
      4529,
      753,
      348,
      2296,
      1691,
      49,
      1322,
      385,
      5232,
      289,
      57,
      62,
      5233,
      329,
      453,
      440,
      432,
      1125,
      410,
      5234,
      5235,
      362,
      363,
      2790,
      298,
      5080,
      433,
      5236,
      141,
      1327,
      37,
      396,
      333,
      1164,
      1165
    ],
  ),
  "car_crash": SymbolsMetadata(
    popularity: 899,
    codepoint: 0xebf2,
    categories: [14],
    tags: [
      2420,
      1339,
      2048,
      1816,
      2692,
      1818,
      1819,
      5237,
      5238,
      5239,
      5240,
      1345,
      5241,
      313,
      2051,
      2423,
      4373,
      5242,
      5243,
      5244,
      1520,
      5245,
      2057,
      4376,
      1620,
      702,
      1622,
      1848,
      1623,
      1850,
      206,
      5246
    ],
  ),
  "car_defrost_left": SymbolsMetadata(
    popularity: 2,
    codepoint: 0xf344,
    categories: [14],
    tags: [
      834,
      77,
      502,
      1816,
      3403,
      5247,
      504,
      1818,
      5248,
      5249,
      5250,
      5251,
      1742,
      5252,
      5253,
      5254,
      313,
      2982,
      1859,
      583,
      1860,
      138,
      2216,
      584,
      589,
      590,
      5255,
      5256,
      1933,
      1452,
      31,
      65,
      1623,
      1850,
      1867,
      1165,
      5257,
      5258
    ],
  ),
  "car_defrost_low_left": SymbolsMetadata(
    popularity: 1,
    codepoint: 0xf343,
    categories: [14],
    tags: [
      834,
      835,
      77,
      1816,
      3403,
      504,
      1818,
      837,
      5259,
      345,
      841,
      1405,
      5252,
      5253,
      313,
      2293,
      1051,
      5260,
      2982,
      583,
      1860,
      2216,
      1968,
      1749,
      589,
      590,
      1933,
      151,
      1452,
      2409,
      1850,
      1901,
      1165,
      5258,
      857
    ],
  ),
  "car_defrost_low_right": SymbolsMetadata(
    popularity: 3,
    codepoint: 0xf342,
    categories: [14],
    tags: [
      834,
      5261,
      77,
      502,
      2048,
      1816,
      3403,
      1818,
      837,
      5250,
      345,
      1405,
      5252,
      5253,
      313,
      1906,
      2982,
      1859,
      583,
      1860,
      51,
      584,
      5262,
      589,
      590,
      5113,
      907,
      1933,
      151,
      31,
      97,
      141,
      1850,
      5263,
      1165,
      5258
    ],
  ),
  "car_defrost_mid_low_left": SymbolsMetadata(
    popularity: 2,
    codepoint: 0xf341,
    categories: [14],
    tags: [
      833,
      835,
      5261,
      77,
      5264,
      1816,
      3403,
      5265,
      1818,
      5266,
      5267,
      5249,
      5268,
      837,
      5250,
      1741,
      1405,
      5252,
      5253,
      5254,
      313,
      5269,
      2982,
      5270,
      5271,
      583,
      1860,
      2720,
      2216,
      589,
      590,
      5272,
      1933,
      855,
      1850,
      1901,
      1865,
      5273,
      5274
    ],
  ),
  "car_defrost_mid_right": SymbolsMetadata(
    popularity: 2,
    codepoint: 0xf340,
    categories: [14],
    tags: [
      834,
      835,
      77,
      1816,
      3403,
      504,
      1818,
      1904,
      778,
      5250,
      345,
      842,
      1405,
      5252,
      5253,
      5254,
      313,
      5260,
      2982,
      1859,
      583,
      1860,
      847,
      2720,
      5275,
      5276,
      589,
      590,
      1933,
      5277,
      31,
      5278,
      5279,
      5280,
      5281,
      1850,
      1901,
      1865,
      1165
    ],
  ),
  "car_defrost_right": SymbolsMetadata(
    popularity: 2,
    codepoint: 0xf33f,
    categories: [14],
    tags: [
      834,
      1888,
      77,
      1816,
      3403,
      504,
      1818,
      778,
      837,
      345,
      1405,
      5252,
      5253,
      5254,
      313,
      2293,
      5260,
      2982,
      1859,
      583,
      1860,
      847,
      5282,
      1749,
      589,
      590,
      5255,
      907,
      1933,
      1452,
      852,
      2409,
      855,
      5279,
      1850,
      1865,
      3786,
      1165,
      5258
    ],
  ),
  "car_fan_low_left": SymbolsMetadata(
    popularity: 14,
    codepoint: 0xf33e,
    categories: [14],
    tags: [
      834,
      5283,
      5261,
      77,
      1816,
      3403,
      5284,
      1818,
      837,
      5250,
      1921,
      1742,
      842,
      1405,
      313,
      2293,
      1906,
      2982,
      1859,
      583,
      1860,
      2720,
      5285,
      261,
      589,
      590,
      1933,
      855,
      1848,
      332,
      1850,
      1901,
      1865
    ],
  ),
  "car_fan_low_mid_left": SymbolsMetadata(
    popularity: 9,
    codepoint: 0xf33d,
    categories: [14],
    tags: [
      480,
      834,
      5286,
      1888,
      77,
      1816,
      3403,
      5284,
      1818,
      837,
      345,
      3430,
      1405,
      313,
      2293,
      1906,
      2982,
      583,
      1860,
      51,
      2720,
      2216,
      87,
      1968,
      3835,
      589,
      590,
      1933,
      151,
      275,
      31,
      1850,
      1865,
      1868
    ],
  ),
  "car_fan_low_right": SymbolsMetadata(
    popularity: 7,
    codepoint: 0xf33c,
    categories: [14],
    tags: [
      834,
      5287,
      1888,
      77,
      1816,
      3403,
      5288,
      5289,
      1818,
      5290,
      837,
      5250,
      345,
      1405,
      313,
      1906,
      5291,
      5292,
      2982,
      583,
      1860,
      3593,
      2720,
      790,
      1968,
      5293,
      589,
      590,
      907,
      5294,
      1933,
      275,
      855,
      1850,
      5295,
      1901,
      1865
    ],
  ),
  "car_fan_mid_left": SymbolsMetadata(
    popularity: 5,
    codepoint: 0xf33b,
    categories: [14],
    tags: [
      2233,
      834,
      5261,
      77,
      1816,
      3403,
      5247,
      1818,
      308,
      5250,
      1921,
      1741,
      841,
      2399,
      1405,
      313,
      1906,
      2982,
      583,
      1860,
      138,
      2720,
      2216,
      2176,
      635,
      289,
      589,
      590,
      1933,
      71,
      31,
      1068,
      1850,
      1865,
      1868
    ],
  ),
  "car_fan_mid_low_right": SymbolsMetadata(
    popularity: 5,
    codepoint: 0xf33a,
    categories: [14],
    tags: [
      834,
      1888,
      77,
      1816,
      3403,
      5247,
      504,
      1818,
      837,
      345,
      1405,
      313,
      1906,
      137,
      2982,
      583,
      1860,
      138,
      3593,
      790,
      1968,
      5296,
      589,
      590,
      3645,
      907,
      1933,
      151,
      275,
      454,
      31,
      1068,
      1326,
      1850,
      1865,
      1868
    ],
  ),
  "car_fan_mid_right": SymbolsMetadata(
    popularity: 6,
    codepoint: 0xf339,
    categories: [14],
    tags: [
      834,
      5287,
      5297,
      1888,
      77,
      1816,
      3403,
      5288,
      1818,
      308,
      837,
      345,
      1405,
      313,
      1906,
      1051,
      2982,
      581,
      583,
      1860,
      584,
      5296,
      2176,
      589,
      590,
      907,
      1933,
      151,
      855,
      1850,
      1901,
      1865,
      5298
    ],
  ),
  "car_fan_recirculate": SymbolsMetadata(
    popularity: 8,
    codepoint: 0xf338,
    categories: [14],
    tags: [
      834,
      5283,
      5261,
      5299,
      77,
      502,
      2048,
      1816,
      3403,
      504,
      1818,
      193,
      5250,
      5300,
      1741,
      751,
      1405,
      1906,
      2982,
      1860,
      138,
      5301,
      5302,
      755,
      5303,
      31,
      855,
      1850,
      1865
    ],
  ),
  "car_gear": SymbolsMetadata(
    popularity: 23,
    codepoint: 0xf337,
    categories: [14],
    tags: [
      1738,
      5304,
      1816,
      3403,
      1818,
      5305,
      1778,
      678,
      345,
      574,
      1675,
      2749,
      1780,
      4871,
      2871,
      1729,
      4872,
      3416,
      3417,
      70,
      911,
      912,
      1065,
      71,
      1752,
      3597,
      65,
      511,
      2074,
      1848,
      1850,
      3287
    ],
  ),
  "car_lock": SymbolsMetadata(
    popularity: 5,
    codepoint: 0xf336,
    categories: [14],
    tags: [
      858,
      5306,
      1816,
      3403,
      504,
      1818,
      5307,
      193,
      4924,
      1568,
      580,
      1088,
      5308,
      87,
      2584,
      5309,
      3417,
      2876,
      5310,
      1009,
      975,
      696,
      5311,
      702,
      1022,
      1011,
      1068,
      1848,
      1623,
      332,
      5312,
      5313,
      1850
    ],
  ),
  "car_mirror_heat": SymbolsMetadata(
    popularity: 1,
    codepoint: 0xf335,
    categories: [14],
    tags: [
      5314,
      1816,
      3403,
      1818,
      5315,
      5316,
      5317,
      5318,
      5249,
      5250,
      5252,
      5253,
      5254,
      5260,
      2982,
      1859,
      847,
      5319,
      5320,
      5321,
      5322,
      852,
      855,
      1850,
      1165,
      5273,
      5323,
      5324,
      857
    ],
  ),
  "car_rental": SymbolsMetadata(
    popularity: 701,
    codepoint: 0xea55,
    categories: [16],
    tags: [
      858,
      1816,
      1916,
      919,
      1818,
      5325,
      1819,
      1157,
      2051,
      1568,
      488,
      5326,
      138,
      1617,
      1088,
      5327,
      87,
      2584,
      1520,
      896,
      289,
      5310,
      5328,
      5329,
      1931,
      2059,
      1620,
      645,
      392,
      31,
      1848,
      1623,
      332,
      1945,
      5312,
      1850
    ],
  ),
  "car_repair": SymbolsMetadata(
    popularity: 514,
    codepoint: 0xea56,
    categories: [16],
    tags: [
      2233,
      865,
      2048,
      1816,
      3403,
      2692,
      1818,
      1819,
      678,
      5330,
      5331,
      2749,
      1745,
      3393,
      4872,
      3920,
      1520,
      3395,
      70,
      3081,
      4873,
      645,
      71,
      511,
      1623,
      332,
      5332,
      5333,
      1850,
      5334,
      1786
    ],
  ),
  "car_tag": SymbolsMetadata(
    popularity: 56,
    codepoint: 0xf4e3,
    categories: [14],
    tags: [
      858,
      5335,
      3289,
      3151,
      2048,
      5336,
      1816,
      917,
      1818,
      5337,
      920,
      1819,
      1644,
      921,
      922,
      924,
      926,
      927,
      145,
      928,
      1675,
      1568,
      5338,
      2018,
      5339,
      68,
      52,
      5340,
      148,
      938,
      5341,
      523,
      4108,
      940,
      941,
      5342,
      5343,
      1401,
      2600,
      5344,
      3266,
      1376,
      5345,
      182,
      1623,
      332,
      1850,
      5346
    ],
  ),
  "card_membership": SymbolsMetadata(
    popularity: 1981,
    codepoint: 0xe8f7,
    categories: [9],
    tags: [
      858,
      565,
      917,
      1688,
      920,
      921,
      2636,
      5347,
      5348,
      922,
      924,
      1398,
      926,
      927,
      1567,
      928,
      5349,
      4415,
      931,
      2598,
      2018,
      969,
      971,
      5350,
      5351,
      1005,
      938,
      523,
      2019,
      940,
      941,
      5342,
      714,
      591,
      432,
      2600,
      392,
      1376,
      2602,
      433,
      4096,
      597,
      5352
    ],
  ),
  "card_travel": SymbolsMetadata(
    popularity: 872,
    codepoint: 0xe8f8,
    categories: [9],
    tags: [
      1869,
      1641,
      4438,
      917,
      1494,
      919,
      920,
      3612,
      4903,
      921,
      922,
      924,
      1398,
      926,
      927,
      928,
      931,
      580,
      1356,
      1617,
      3618,
      1005,
      5353,
      938,
      523,
      5354,
      940,
      941,
      911,
      432,
      433,
      4443,
      1623,
      332,
      1945,
      4319
    ],
  ),
  "cardio_load": SymbolsMetadata(
    popularity: 79,
    codepoint: 0xf4b9,
    categories: [3],
    tags: [
      2504,
      4460,
      5355,
      684,
      5356,
      5357,
      373,
      4227,
      4228,
      11,
      5358,
      3194,
      2831,
      2533,
      1052,
      692,
      4242,
      4229,
      5359,
      4230,
      3593,
      1604,
      87,
      2998,
      4461,
      226,
      895,
      623,
      3470,
      641,
      5360,
      4233,
      4951,
      3472,
      1070,
      2988,
      5361,
      5362,
      4234,
      3318,
      3475
    ],
  ),
  "cardiology": SymbolsMetadata(
    popularity: 124,
    codepoint: 0xe09c,
    categories: [3],
    tags: [
      4943,
      5356,
      5363,
      373,
      1760,
      81,
      375,
      1761,
      4227,
      4228,
      1052,
      692,
      4242,
      5364,
      3722,
      1765,
      4229,
      5365,
      1766,
      87,
      1406,
      226,
      895,
      1769,
      623,
      5366,
      4233,
      4951,
      5367,
      1777,
      3318
    ],
  ),
  "cards": SymbolsMetadata(
    popularity: 121,
    codepoint: 0xe991,
    categories: [2],
    tags: [
      1288,
      501,
      1447,
      5368,
      1175,
      2675,
      621,
      81,
      5369,
      485,
      8,
      3762,
      1677,
      382,
      4790,
      1176,
      68,
      1322,
      86,
      1056,
      385,
      88,
      5013,
      262,
      623,
      2162,
      91,
      1063,
      2732,
      1575,
      271,
      1407,
      4613,
      3338,
      410,
      1180,
      2790,
      95,
      2684,
      594,
      525,
      141,
      1327,
      396,
      333,
      1164,
      1165
    ],
  ),
  "cards_star": SymbolsMetadata(
    popularity: 125,
    codepoint: 0xf375,
    categories: [9],
    tags: [
      3190,
      1688,
      920,
      5370,
      1175,
      5369,
      3194,
      5371,
      1176,
      1115,
      1347,
      5372,
      88,
      5350,
      1143,
      2162,
      5373,
      2500,
      328,
      849,
      714,
      2501,
      63,
      793,
      359,
      203,
      432,
      3481,
      1683,
      5374,
      1180,
      392,
      433,
      594,
      854
    ],
  ),
  "carpenter": SymbolsMetadata(
    popularity: 523,
    codepoint: 0xf1f8,
    categories: [16],
    tags: [
      1354,
      918,
      4901,
      5375,
      1355,
      1477,
      5376,
      1302,
      5377,
      3630,
      225,
      1745,
      5378,
      1002,
      1495,
      5379,
      5380,
      5381,
      289,
      590,
      5382,
      4873,
      5383,
      978,
      5384,
      511,
      1296,
      4922,
      5385,
      1498,
      5386
    ],
  ),
  "carry_on_bag": SymbolsMetadata(
    popularity: 7,
    codepoint: 0xeb08,
    categories: [16],
    tags: [
      1987,
      5387,
      1641,
      5388,
      4438,
      4900,
      482,
      3612,
      5389,
      4903,
      580,
      1617,
      3618,
      5390,
      5391,
      1037,
      5354,
      432,
      2447,
      1685,
      4443,
      5392,
      3286,
      1848,
      332,
      3623,
      5393,
      5394,
      1984,
      1945,
      1952,
      4129
    ],
  ),
  "carry_on_bag_checked": SymbolsMetadata(
    popularity: 10,
    codepoint: 0xeb0b,
    categories: [16],
    tags: [
      2629,
      1913,
      1987,
      1658,
      2653,
      1641,
      4438,
      482,
      3612,
      5395,
      1660,
      3095,
      2113,
      463,
      2657,
      2342,
      1924,
      1974,
      1617,
      87,
      3618,
      1663,
      1037,
      5354,
      362,
      433,
      4443,
      31,
      1665,
      1848,
      332,
      3623,
      5394,
      1945,
      1952,
      1562,
      1668
    ],
  ),
  "carry_on_bag_inactive": SymbolsMetadata(
    popularity: 1,
    codepoint: 0xeb0a,
    categories: [16],
    tags: [
      1987,
      1641,
      4438,
      3612,
      5395,
      867,
      1033,
      1924,
      5396,
      580,
      1200,
      51,
      1617,
      3618,
      5397,
      492,
      1035,
      1037,
      5398,
      5399,
      5354,
      432,
      1041,
      291,
      4443,
      1848,
      332,
      3623,
      1945,
      1042,
      1952,
      4129
    ],
  ),
  "carry_on_bag_question": SymbolsMetadata(
    popularity: 16,
    codepoint: 0xeb09,
    categories: [16],
    tags: [
      3898,
      1987,
      1641,
      5400,
      5401,
      4438,
      5402,
      3612,
      5395,
      145,
      1924,
      3144,
      873,
      293,
      68,
      5403,
      584,
      3618,
      1037,
      387,
      5404,
      2352,
      3902,
      3903,
      432,
      5405,
      2179,
      4443,
      878,
      31,
      332,
      3623,
      5406,
      5407,
      3905
    ],
  ),
  "cases": SymbolsMetadata(
    popularity: 1164,
    codepoint: 0xe992,
    categories: [9],
    tags: [
      1756,
      2154,
      1641,
      4438,
      1494,
      5408,
      5409,
      919,
      4903,
      5410,
      4768,
      1175,
      81,
      3377,
      3762,
      5411,
      1677,
      2756,
      1678,
      68,
      3680,
      2438,
      1004,
      1372,
      1063,
      587,
      960,
      4088,
      2760,
      1685,
      5412,
      4443,
      1068,
      1498
    ],
  ),
  "casino": SymbolsMetadata(
    popularity: 1717,
    codepoint: 0xeb40,
    categories: [16],
    tags: [
      3275,
      1403,
      5413,
      5414,
      5415,
      5416,
      5417,
      5418,
      5419,
      5420,
      1081,
      779,
      5421,
      5422,
      5423,
      5371,
      4683,
      5424,
      1975,
      5425,
      5426,
      5427,
      938,
      5428,
      5429,
      2549,
      2500,
      3480,
      3282,
      3782,
      3481,
      5430,
      2300,
      5431,
      5432,
      5433
    ],
  ),
  "cast": SymbolsMetadata(
    popularity: 1665,
    codepoint: 0xe307,
    categories: [11],
    tags: [
      1223,
      1224,
      2035,
      1246,
      729,
      4246,
      1698,
      5434,
      1047,
      284,
      621,
      1699,
      288,
      8,
      1086,
      1230,
      1700,
      406,
      5319,
      623,
      267,
      1732,
      408,
      5159,
      5435,
      3325,
      410,
      5436,
      2318,
      1508,
      273,
      454,
      411,
      65,
      412,
      4745,
      2045,
      37,
      333,
      1165,
      278
    ],
  ),
  "cast_connected": SymbolsMetadata(
    popularity: 611,
    codepoint: 0xe308,
    categories: [11],
    tags: [
      1223,
      1224,
      2035,
      1246,
      5437,
      729,
      4246,
      5438,
      1698,
      1047,
      1048,
      3123,
      284,
      621,
      345,
      1699,
      288,
      8,
      779,
      1086,
      1230,
      1294,
      5439,
      1700,
      406,
      679,
      5440,
      623,
      439,
      267,
      5441,
      4744,
      410,
      5436,
      1508,
      273,
      5442,
      411,
      412,
      4745,
      2045,
      37,
      333,
      1165,
      278
    ],
  ),
  "cast_for_education": SymbolsMetadata(
    popularity: 1348,
    codepoint: 0xefec,
    categories: [11],
    tags: [
      1223,
      1224,
      2035,
      1246,
      729,
      4246,
      1698,
      3102,
      3613,
      1047,
      284,
      1699,
      288,
      8,
      3059,
      5443,
      1086,
      1230,
      3379,
      4396,
      3086,
      5444,
      5445,
      1700,
      406,
      623,
      1407,
      388,
      2722,
      410,
      5436,
      1508,
      2044,
      454,
      411,
      3068,
      4406,
      3069,
      65,
      412,
      2045,
      4394,
      37,
      333,
      1165,
      278
    ],
  ),
  "cast_pause": SymbolsMetadata(
    popularity: 14,
    codepoint: 0xf5f0,
    categories: [11],
    tags: [
      1223,
      1224,
      2035,
      1246,
      729,
      4246,
      1698,
      283,
      1047,
      284,
      345,
      1742,
      1699,
      288,
      8,
      779,
      3363,
      1086,
      1230,
      5446,
      1700,
      406,
      352,
      623,
      439,
      1701,
      267,
      1201,
      408,
      388,
      410,
      5447,
      5436,
      1203,
      454,
      411,
      412,
      1718,
      2045,
      1309,
      3317,
      37,
      333,
      1165,
      278
    ],
  ),
  "cast_warning": SymbolsMetadata(
    popularity: 19,
    codepoint: 0xf5ef,
    categories: [11],
    tags: [
      3074,
      1223,
      1224,
      2035,
      1339,
      1340,
      729,
      4246,
      1342,
      1698,
      1047,
      284,
      1345,
      1699,
      288,
      5448,
      8,
      2694,
      1346,
      5449,
      5063,
      1086,
      3447,
      1230,
      1347,
      3078,
      1700,
      1143,
      406,
      5440,
      623,
      267,
      1160,
      609,
      408,
      3081,
      4744,
      410,
      5436,
      273,
      411,
      31,
      412,
      1718,
      5450,
      2045,
      206,
      333,
      1165,
      278
    ],
  ),
  "castle": SymbolsMetadata(
    popularity: 716,
    codepoint: 0xeab1,
    categories: [5],
    tags: [
      5451,
      5452,
      1476,
      5453,
      918,
      5454,
      5455,
      1478,
      1368,
      2547,
      5456,
      5457,
      5458,
      5459,
      1116,
      2548,
      5460,
      1530,
      3793,
      5461,
      5462,
      5463,
      5464,
      3159,
      1482,
      5465,
      1011,
      5466,
      945,
      2552,
      5467
    ],
  ),
  "category": SymbolsMetadata(
    popularity: 9493,
    codepoint: 0xe574,
    categories: [6],
    tags: [
      2674,
      1173,
      1502,
      5468,
      373,
      5469,
      193,
      1076,
      1175,
      2321,
      5470,
      284,
      1049,
      375,
      5471,
      1051,
      5472,
      1054,
      3763,
      5473,
      86,
      1294,
      5474,
      267,
      5475,
      4695,
      5476,
      1063,
      92,
      1652,
      5477,
      5478,
      4090,
      1067,
      5479,
      95,
      433,
      945,
      5480,
      5481,
      1071,
      5482,
      1718
    ],
  ),
  "category_search": SymbolsMetadata(
    popularity: 142,
    codepoint: 0xf437,
    categories: [2],
    tags: [
      2673,
      2674,
      1173,
      193,
      5483,
      1175,
      314,
      316,
      83,
      317,
      1085,
      1177,
      1054,
      5484,
      5485,
      86,
      88,
      2345,
      1091,
      5486,
      2346,
      2347,
      1092,
      1093,
      2348,
      5487,
      1063,
      1652,
      5488,
      2352,
      5489,
      3385,
      2353,
      1102,
      1103,
      363,
      2683,
      5479,
      95,
      433,
      1718,
      5490
    ],
  ),
  "celebration": SymbolsMetadata(
    popularity: 5658,
    codepoint: 0xea65,
    categories: [6],
    tags: [
      3,
      2504,
      3189,
      4957,
      3340,
      4961,
      5491,
      5492,
      3477,
      10,
      3278,
      4370,
      4963,
      5493,
      2741,
      3195,
      4118,
      137,
      1601,
      5494,
      3594,
      3198,
      588,
      3481,
      392,
      3201,
      898,
      854,
      245,
      5495,
      31,
      5143
    ],
  ),
  "cell_merge": SymbolsMetadata(
    popularity: 92,
    codepoint: 0xf82e,
    categories: [12],
    tags: [
      1447,
      77,
      502,
      1227,
      5496,
      3564,
      5497,
      5498,
      1301,
      5499,
      1047,
      81,
      5500,
      5501,
      1567,
      2172,
      382,
      1177,
      5502,
      5503,
      385,
      1294,
      1308,
      5504,
      1063,
      2447,
      5505,
      4399,
      1441,
      433,
      945,
      1453,
      5506,
      5507,
      5508,
      5509
    ],
  ),
  "cell_tower": SymbolsMetadata(
    popularity: 1826,
    codepoint: 0xebba,
    categories: [7],
    tags: [
      638,
      4747,
      729,
      918,
      2037,
      1227,
      5510,
      251,
      283,
      284,
      254,
      81,
      5511,
      1616,
      259,
      603,
      5512,
      262,
      267,
      2071,
      5513,
      273,
      3516,
      945,
      65,
      276,
      2552,
      2074,
      5514,
      5515,
      278
    ],
  ),
  "cell_wifi": SymbolsMetadata(
    popularity: 421,
    codepoint: 0xe0ec,
    categories: [7],
    tags: [
      858,
      517,
      1227,
      251,
      283,
      284,
      254,
      4156,
      81,
      288,
      51,
      259,
      584,
      262,
      267,
      271,
      272,
      645,
      273,
      291,
      65,
      1867,
      277,
      278
    ],
  ),
  "center_focus_strong": SymbolsMetadata(
    popularity: 1408,
    codepoint: 0xe3b4,
    categories: [1],
    tags: [
      1738,
      2167,
      1107,
      482,
      40,
      42,
      308,
      3008,
      1213,
      5516,
      44,
      1746,
      348,
      1142,
      2780,
      49,
      51,
      53,
      386,
      57,
      59,
      2881,
      2209,
      5517,
      363,
      392,
      433,
      2479,
      31,
      1204,
      511,
      396,
      2356
    ],
  ),
  "center_focus_weak": SymbolsMetadata(
    popularity: 912,
    codepoint: 0xe3b5,
    categories: [1],
    tags: [
      5518,
      1738,
      5519,
      2167,
      5520,
      40,
      308,
      5521,
      345,
      5522,
      5516,
      1746,
      5523,
      49,
      53,
      226,
      57,
      59,
      328,
      5517,
      432,
      5524,
      2781,
      151,
      3283,
      433,
      1204,
      511,
      5525,
      2356
    ],
  ),
  "chair": SymbolsMetadata(
    popularity: 2927,
    codepoint: 0xefed,
    categories: [8],
    tags: [
      3690,
      4004,
      1919,
      1921,
      5526,
      1137,
      3658,
      4008,
      1827,
      137,
      1116,
      1479,
      384,
      1908,
      1356,
      5527,
      5528,
      1927,
      5529,
      5530,
      492,
      1372,
      289,
      3780,
      906,
      1950,
      1932,
      1884,
      1933,
      1934,
      1317,
      5531,
      31
    ],
  ),
  "chair_alt": SymbolsMetadata(
    popularity: 604,
    codepoint: 0xefee,
    categories: [8],
    tags: [
      1310,
      5532,
      1919,
      1941,
      4008,
      137,
      1116,
      1479,
      1880,
      384,
      2718,
      4183,
      87,
      5529,
      492,
      1372,
      289,
      906,
      432,
      1933,
      1934,
      1317,
      1958,
      979,
      31,
      1453,
      764
    ],
  ),
  "chalet": SymbolsMetadata(
    popularity: 195,
    codepoint: 0xe585,
    categories: [16],
    tags: [
      5533,
      4935,
      1476,
      918,
      1918,
      5534,
      4878,
      4879,
      5535,
      4924,
      1478,
      5536,
      2547,
      1974,
      1116,
      1479,
      5537,
      3793,
      1520,
      1584,
      327,
      2550,
      1482,
      1483,
      5538,
      4883,
      1838,
      1484,
      4939,
      3699,
      945,
      332,
      4886,
      2883,
      1945,
      1952,
      1165
    ],
  ),
  "change_circle": SymbolsMetadata(
    popularity: 5209,
    codepoint: 0xe2e7,
    categories: [2],
    tags: [
      1739,
      460,
      77,
      502,
      2397,
      193,
      462,
      751,
      313,
      3261,
      1051,
      755,
      5539,
      468,
      325,
      2773,
      1065,
      757,
      758,
      759,
      2441,
      3426,
      3581,
      470,
      330,
      291,
      2409,
      5540,
      890
    ],
  ),
  "change_history": SymbolsMetadata(
    popularity: 2973,
    codepoint: 0xe86b,
    categories: [6],
    tags: [
      5541,
      2397,
      5542,
      5543,
      1080,
      5544,
      4777,
      5545,
      1051,
      2757,
      5546,
      1617,
      4779,
      5547,
      2759,
      1619,
      1065,
      5548,
      453,
      5549,
      94,
      392,
      1148,
      2453,
      5550,
      1718,
      4097,
      5551
    ],
  ),
  "charger": SymbolsMetadata(
    popularity: 1007,
    codepoint: 0xe2ae,
    categories: [4],
    tags: [
      5552,
      5553,
      3637,
      4928,
      5554,
      3825,
      3939,
      284,
      4929,
      1855,
      288,
      3640,
      5555,
      3941,
      3879,
      2527,
      3641,
      5556,
      1087,
      1119,
      5557,
      3927,
      2474,
      3645,
      5558,
      3946,
      3921,
      5559,
      5560,
      4932,
      5561,
      4933
    ],
  ),
  "charging_station": SymbolsMetadata(
    popularity: 501,
    codepoint: 0xf19d,
    categories: [11],
    tags: [
      1223,
      1224,
      3637,
      3893,
      1227,
      3638,
      3825,
      3939,
      288,
      3640,
      3941,
      3879,
      3641,
      5556,
      5562,
      2296,
      1086,
      1230,
      138,
      51,
      3894,
      5563,
      3895,
      262,
      5564,
      271,
      3645,
      5565,
      3921,
      432,
      2526,
      3516,
      291,
      31,
      525,
      3896,
      5566,
      5567
    ],
  ),
  "chart_data": SymbolsMetadata(
    popularity: 388,
    codepoint: 0xe473,
    categories: [9],
    tags: [
      1402,
      1045,
      2762,
      77,
      1404,
      3725,
      919,
      373,
      1405,
      81,
      4337,
      375,
      5568,
      931,
      1052,
      234,
      692,
      1055,
      68,
      87,
      1406,
      226,
      17,
      1060,
      22,
      641,
      2767,
      1407,
      757,
      1408,
      2353,
      744,
      3039,
      1070,
      1409,
      1696,
      2770
    ],
  ),
  "chat": SymbolsMetadata(
    popularity: 18578,
    codepoint: 0xe0b7,
    categories: [7],
    tags: [
      1339,
      4824,
      567,
      569,
      5569,
      571,
      572,
      283,
      1047,
      965,
      1455,
      2708,
      1456,
      2710,
      1459,
      5570,
      585,
      609,
      289,
      328,
      2890,
      705,
      4828,
      593,
      1464,
      433,
      5571,
      5572,
      1274,
      4829,
      33,
      1326
    ],
    rtlAutoMirrored: true,
  ),
  "chat_add_on": SymbolsMetadata(
    popularity: 578,
    codepoint: 0xf0f3,
    categories: [7],
    tags: [
      743,
      5573,
      5574,
      567,
      569,
      571,
      283,
      1455,
      1302,
      5575,
      2709,
      2710,
      2561,
      1954,
      5570,
      1603,
      585,
      886,
      2567,
      239,
      240,
      705,
      1464,
      433,
      1274,
      4829,
      33
    ],
    rtlAutoMirrored: true,
  ),
  "chat_apps_script": SymbolsMetadata(
    popularity: 276,
    codepoint: 0xf0bd,
    categories: [7],
    tags: [
      4992,
      3120,
      5576,
      501,
      2565,
      1245,
      1890,
      567,
      569,
      3142,
      1077,
      5577,
      283,
      1455,
      1080,
      2709,
      5578,
      2561,
      2557,
      585,
      2315,
      4994,
      1099,
      3022,
      5579,
      1464,
      1274,
      33,
      4831
    ],
  ),
  "chat_bubble": SymbolsMetadata(
    popularity: 10185,
    codepoint: 0xe0ca,
    categories: [7],
    tags: [
      865,
      807,
      567,
      569,
      571,
      5580,
      572,
      283,
      965,
      1455,
      5581,
      2709,
      1458,
      809,
      1459,
      873,
      585,
      289,
      593,
      878,
      1274,
      33,
      5582
    ],
  ),
  "chat_error": SymbolsMetadata(
    popularity: 75,
    codepoint: 0xf7ac,
    categories: [7],
    tags: [
      1339,
      1340,
      567,
      1187,
      1342,
      569,
      778,
      1188,
      4825,
      571,
      572,
      283,
      1455,
      1345,
      2709,
      2694,
      4659,
      1190,
      5063,
      2695,
      1459,
      1347,
      3078,
      1143,
      585,
      5583,
      3254,
      609,
      5584,
      5585,
      3081,
      1039,
      1408,
      1162,
      593,
      1464,
      433,
      1203,
      31,
      1274,
      33,
      206,
      3712
    ],
  ),
  "chat_info": SymbolsMetadata(
    popularity: 135,
    codepoint: 0xf52b,
    categories: [7],
    tags: [
      5586,
      1339,
      1154,
      865,
      1310,
      567,
      569,
      193,
      571,
      572,
      283,
      2800,
      1455,
      145,
      1456,
      5587,
      1946,
      1459,
      968,
      2780,
      873,
      5065,
      293,
      68,
      3379,
      5588,
      585,
      3902,
      330,
      645,
      1317,
      979,
      4828,
      593,
      878,
      33
    ],
    rtlAutoMirrored: true,
  ),
  "chat_paste_go": SymbolsMetadata(
    popularity: 49,
    codepoint: 0xf6bd,
    categories: [7],
    tags: [
      77,
      502,
      482,
      567,
      569,
      1078,
      571,
      572,
      1455,
      1793,
      1456,
      313,
      2402,
      1082,
      1459,
      5589,
      902,
      903,
      1087,
      585,
      325,
      904,
      5590,
      1144,
      2796,
      5591,
      1462,
      1463,
      907,
      1694,
      2318,
      593,
      3093,
      33,
      35,
      2414
    ],
    rtlAutoMirrored: true,
  ),
  "chat_paste_go_2": SymbolsMetadata(
    popularity: 11,
    codepoint: 0xf3cb,
    categories: [7],
    tags: [
      746,
      77,
      502,
      567,
      504,
      569,
      1078,
      571,
      572,
      283,
      621,
      1455,
      81,
      2709,
      313,
      2402,
      5592,
      1459,
      488,
      902,
      903,
      1087,
      1305,
      1603,
      585,
      325,
      5590,
      5593,
      432,
      907,
      1694,
      2318,
      392,
      593,
      1464,
      433,
      3093,
      33,
      5594
    ],
    rtlAutoMirrored: true,
  ),
  "check": SymbolsMetadata(
    popularity: 31620,
    codepoint: 0xe5ca,
    categories: [2],
    tags: [
      2783,
      2629,
      5518,
      2634,
      2653,
      1660,
      193,
      462,
      463,
      2637,
      2657,
      2340,
      2785,
      2342,
      1082,
      968,
      3439,
      1143,
      1663,
      2642,
      242,
      907,
      330,
      362,
      1162,
      979,
      245,
      5595,
      1665,
      2648,
      2649,
      4420,
      4799,
      1668
    ],
  ),
  "check_box": SymbolsMetadata(
    popularity: 25825,
    codepoint: 0xe834,
    categories: [2],
    tags: [
      746,
      2430,
      2653,
      482,
      504,
      1660,
      5596,
      3704,
      677,
      463,
      3322,
      2637,
      5597,
      345,
      2342,
      1826,
      2639,
      488,
      1087,
      1603,
      1356,
      88,
      1143,
      1663,
      355,
      362,
      2670,
      363,
      433,
      291,
      1497,
      1665,
      413,
      2648,
      141,
      2355,
      1562,
      1668
    ],
  ),
  "check_box_outline_blank": SymbolsMetadata(
    popularity: 21996,
    codepoint: 0xe835,
    categories: [2],
    tags: [
      807,
      482,
      504,
      1660,
      5596,
      3704,
      677,
      3322,
      345,
      2399,
      752,
      81,
      5598,
      1140,
      809,
      1568,
      1826,
      488,
      137,
      1087,
      88,
      1143,
      355,
      289,
      362,
      363,
      433,
      1497,
      1665,
      1666,
      1667,
      413,
      141,
      5599,
      5600,
      476
    ],
  ),
  "check_circle": SymbolsMetadata(
    popularity: 84870,
    codepoint: 0xe86c,
    categories: [2],
    tags: [
      2629,
      3,
      1339,
      1658,
      281,
      1108,
      1660,
      193,
      463,
      2637,
      2340,
      2342,
      1459,
      3439,
      381,
      138,
      1143,
      609,
      1663,
      289,
      330,
      362,
      392,
      291,
      3104,
      245,
      31,
      1665,
      2649,
      2355,
      1562,
      1668
    ],
  ),
  "check_in_out": SymbolsMetadata(
    popularity: 28,
    codepoint: 0xf6f6,
    categories: [15],
    tags: [
      858,
      5601,
      5602,
      2879,
      502,
      3771,
      2917,
      5603,
      5604,
      5605,
      313,
      1568,
      3261,
      1190,
      5085,
      5606,
      2717,
      2994,
      3087,
      971,
      1034,
      468,
      2361,
      5607,
      5608,
      1100,
      2788,
      1694,
      5609,
      3783,
      2409,
      413,
      526,
      5540,
      332
    ],
  ),
  "check_indeterminate_small": SymbolsMetadata(
    popularity: 742,
    codepoint: 0xf88a,
    categories: [2],
    tags: [
      1658,
      1660,
      3704,
      193,
      463,
      345,
      2399,
      2342,
      2639,
      488,
      3604,
      3493,
      5610,
      1087,
      87,
      1143,
      2176,
      5611,
      5612,
      5613,
      5614,
      1663,
      355,
      289,
      3606,
      5615,
      1127,
      1128,
      362,
      363,
      1972,
      4305,
      291,
      1665,
      3559,
      413,
      5600,
      2355,
      1562,
      1668
    ],
  ),
  "check_small": SymbolsMetadata(
    popularity: 2051,
    codepoint: 0xf88b,
    categories: [2],
    tags: [
      2628,
      2633,
      2634,
      1658,
      1660,
      3704,
      3095,
      5616,
      193,
      463,
      2637,
      4445,
      2340,
      2342,
      2639,
      5617,
      1143,
      812,
      1663,
      289,
      907,
      362,
      2670,
      1972,
      5618,
      3005,
      245,
      1665,
      2649,
      2355,
      4799,
      1562,
      1668
    ],
  ),
  "checkbook": SymbolsMetadata(
    popularity: 90,
    codepoint: 0xe70d,
    categories: [9],
    tags: [
      913,
      914,
      915,
      916,
      917,
      3375,
      5619,
      950,
      919,
      5620,
      5621,
      1660,
      5622,
      1567,
      5623,
      931,
      932,
      3262,
      958,
      584,
      938,
      5624,
      941,
      5625,
      5626,
      4088,
      432,
      977,
      5627,
      5628,
      1465
    ],
    rtlAutoMirrored: true,
  ),
  "checked_bag": SymbolsMetadata(
    popularity: 22,
    codepoint: 0xeb0c,
    categories: [16],
    tags: [
      1987,
      2653,
      1641,
      4438,
      5629,
      5630,
      1660,
      3095,
      2113,
      1662,
      4445,
      1311,
      2342,
      580,
      2717,
      1617,
      3618,
      5631,
      5354,
      432,
      1931,
      1685,
      2535,
      4443,
      1665,
      3286,
      332,
      1945,
      1952,
      1562
    ],
  ),
  "checked_bag_question": SymbolsMetadata(
    popularity: 11,
    codepoint: 0xeb0d,
    categories: [16],
    tags: [
      1987,
      865,
      1641,
      4438,
      5632,
      5633,
      1660,
      5634,
      3095,
      5635,
      5636,
      873,
      5637,
      138,
      68,
      5403,
      3618,
      5638,
      5639,
      1143,
      2352,
      5640,
      3902,
      4443,
      878,
      31,
      332,
      3623,
      5641,
      5642
    ],
  ),
  "checklist": SymbolsMetadata(
    popularity: 7148,
    codepoint: 0xe6b1,
    categories: [12],
    tags: [
      2166,
      2167,
      1658,
      1660,
      5643,
      3095,
      1661,
      2113,
      463,
      1662,
      1566,
      2342,
      1229,
      673,
      2172,
      4776,
      2639,
      370,
      1356,
      86,
      87,
      584,
      88,
      5644,
      1143,
      1573,
      1663,
      1063,
      3568,
      3021,
      5645,
      362,
      1576,
      1441,
      433,
      2684,
      1497,
      5646,
      33,
      1665,
      5647,
      5648,
      5649,
      5650,
      35,
      2355,
      1562,
      1465,
      1668
    ],
  ),
  "checklist_rtl": SymbolsMetadata(
    popularity: 2217,
    codepoint: 0xe6b3,
    categories: [12],
    tags: [
      2166,
      2167,
      1658,
      2251,
      1660,
      1661,
      463,
      5651,
      81,
      1566,
      1567,
      2342,
      1229,
      673,
      2172,
      4776,
      488,
      370,
      582,
      68,
      86,
      5652,
      88,
      1004,
      1143,
      1573,
      5653,
      1663,
      91,
      1063,
      1664,
      3568,
      757,
      1408,
      5654,
      5655,
      362,
      94,
      1576,
      1441,
      1613,
      5656,
      33,
      1665,
      5657,
      35,
      2355,
      1562,
      1465,
      1668
    ],
  ),
  "checkroom": SymbolsMetadata(
    popularity: 1958,
    codepoint: 0xf19e,
    categories: [8],
    tags: [
      2604,
      1641,
      5658,
      5659,
      5660,
      5661,
      2607,
      2608,
      2609,
      5662,
      5663,
      3798,
      2615,
      5664,
      2616,
      5665,
      5666,
      2717,
      323,
      3618,
      327,
      272,
      1374,
      645,
      1375,
      1685,
      1377,
      332,
      5667,
      2626
    ],
  ),
  "cheer": SymbolsMetadata(
    popularity: 123,
    codepoint: 0xf6a8,
    categories: [3],
    tags: [
      3,
      5668,
      5669,
      3189,
      5670,
      5671,
      4961,
      5672,
      5673,
      5491,
      5674,
      5492,
      5675,
      5676,
      4963,
      5677,
      5678,
      1600,
      1601,
      5679,
      5494,
      5680,
      588,
      5681,
      5682,
      4052,
      245,
      5683,
      3484,
      5433,
      5684
    ],
  ),
  "chef_hat": SymbolsMetadata(
    popularity: 35,
    codepoint: 0xf357,
    categories: [3],
    tags: [
      5685,
      3649,
      5686,
      5687,
      5688,
      5689,
      5690,
      4174,
      4175,
      5691,
      5692,
      3656,
      4177,
      5693,
      3658,
      3659,
      2370,
      5694,
      4179,
      3660,
      5695,
      5696,
      4183,
      5697,
      3661,
      506,
      4905,
      5698,
      5699,
      3665,
      5700,
      5701,
      2625
    ],
  ),
  "chess": SymbolsMetadata(
    popularity: 190,
    codepoint: 0xf5e7,
    categories: [3],
    tags: [
      480,
      2504,
      5702,
      5703,
      5704,
      5705,
      5706,
      5707,
      6,
      779,
      5371,
      5708,
      4011,
      5709,
      1975,
      5710,
      5711,
      5712,
      5713,
      4688,
      3568,
      2500,
      5714,
      4018,
      3282,
      5715,
      30,
      433,
      5716,
      5717,
      4833,
      5143
    ],
  ),
  "chess_pawn": SymbolsMetadata(
    popularity: 72,
    codepoint: 0xf3b6,
    categories: [3],
    tags: [
      4358,
      5703,
      5704,
      5706,
      5707,
      6,
      968,
      5371,
      5718,
      5708,
      586,
      492,
      5713,
      4688,
      2500,
      390,
      392,
      978,
      1317,
      979,
      5716,
      31,
      5719
    ],
  ),
  "chevron_backward": SymbolsMetadata(
    popularity: 117,
    codepoint: 0xf46b,
    categories: [2],
    tags: [
      500,
      77,
      502,
      2433,
      2884,
      2784,
      345,
      313,
      51,
      2216,
      406,
      1618,
      325,
      409,
      328,
      1144,
      2787,
      1100,
      5720,
      5721,
      5722
    ],
    rtlAutoMirrored: true,
  ),
  "chevron_forward": SymbolsMetadata(
    popularity: 229,
    codepoint: 0xf46a,
    categories: [2],
    tags: [
      858,
      746,
      2872,
      500,
      77,
      502,
      1310,
      2784,
      1079,
      43,
      313,
      1303,
      902,
      903,
      2780,
      51,
      87,
      1294,
      812,
      237,
      586,
      325,
      904,
      328,
      1144,
      2843,
      907,
      1317,
      1718,
      2220,
      5721
    ],
    rtlAutoMirrored: true,
  ),
  "chevron_left": SymbolsMetadata(
    popularity: 20364,
    codepoint: 0xe5cb,
    categories: [2],
    tags: [
      2783,
      500,
      77,
      502,
      2433,
      1626,
      5723,
      5724,
      2784,
      345,
      313,
      2785,
      2786,
      2780,
      2757,
      51,
      2216,
      406,
      353,
      2889,
      325,
      5725,
      1144,
      2787,
      1100,
      5720,
      3465,
      2891,
      31,
      2791,
      5721,
      5726
    ],
    rtlAutoMirrored: true,
  ),
  "chevron_right": SymbolsMetadata(
    popularity: 52235,
    codepoint: 0xe5cc,
    categories: [2],
    tags: [
      2872,
      5727,
      77,
      502,
      2848,
      2784,
      313,
      902,
      903,
      51,
      88,
      506,
      586,
      1618,
      325,
      904,
      328,
      1144,
      1097,
      907,
      1694
    ],
    rtlAutoMirrored: true,
  ),
  "child_care": SymbolsMetadata(
    popularity: 2452,
    codepoint: 0xeb41,
    categories: [8],
    tags: [
      3497,
      3498,
      1873,
      1759,
      984,
      5728,
      987,
      1921,
      576,
      4665,
      5729,
      990,
      692,
      3505,
      1003,
      2893,
      895,
      4670,
      3509,
      5730,
      4674,
      3510,
      4344,
      289,
      5731,
      1007,
      5732,
      392,
      978,
      1317,
      31,
      3517,
      999
    ],
  ),
  "child_friendly": SymbolsMetadata(
    popularity: 579,
    codepoint: 0xeb42,
    categories: [16],
    tags: [
      861,
      2504,
      3498,
      1759,
      4895,
      984,
      987,
      1080,
      3059,
      779,
      1001,
      225,
      5733,
      1176,
      583,
      3505,
      991,
      1003,
      5734,
      3509,
      289,
      1007,
      589,
      590,
      696,
      3282,
      702,
      978,
      1972,
      877,
      5735,
      5736,
      3517,
      999
    ],
  ),
  "chip_extraction": SymbolsMetadata(
    popularity: 59,
    codepoint: 0xf821,
    categories: [2],
    tags: [
      77,
      502,
      5737,
      4908,
      5738,
      3322,
      519,
      81,
      5739,
      288,
      313,
      3247,
      2931,
      2532,
      2749,
      5740,
      5741,
      1086,
      3415,
      1305,
      1692,
      3920,
      5742,
      5743,
      4687,
      5744,
      5745,
      1039,
      4873,
      907,
      5746,
      3584,
      65,
      511,
      5747
    ],
  ),
  "chips": SymbolsMetadata(
    popularity: 29,
    codepoint: 0xe993,
    categories: [2],
    tags: [
      746,
      1288,
      501,
      3289,
      144,
      1075,
      2674,
      5419,
      2398,
      2675,
      5748,
      574,
      485,
      83,
      5749,
      199,
      1087,
      1322,
      385,
      262,
      623,
      5487,
      70,
      5750,
      92,
      271,
      912,
      150,
      5489,
      410,
      362,
      363,
      71,
      2790,
      95,
      525,
      5751,
      141,
      1327,
      333,
      1164,
      1165
    ],
  ),
  "chrome_reader_mode": SymbolsMetadata(
    popularity: 964,
    codepoint: 0xe86d,
    categories: [6],
    tags: [
      2432,
      3375,
      1688,
      1156,
      1698,
      621,
      1567,
      385,
      3034,
      635,
      1574,
      1575,
      1734,
      3029,
      3366,
      3737,
      2834,
      432,
      433,
      33,
      97,
      333,
      1164
    ],
    rtlAutoMirrored: true,
  ),
  "chromecast_2": SymbolsMetadata(
    popularity: 202,
    codepoint: 0xf17b,
    categories: [10],
    tags: [
      74,
      2035,
      1246,
      4246,
      2037,
      5434,
      519,
      1047,
      284,
      621,
      288,
      8,
      779,
      2039,
      1680,
      5752,
      1086,
      406,
      5440,
      623,
      439,
      1119,
      1732,
      408,
      1407,
      1496,
      5447,
      5436,
      1508,
      454,
      411,
      65,
      412,
      4745,
      2045,
      37,
      278
    ],
  ),
  "chromecast_device": SymbolsMetadata(
    popularity: 210,
    codepoint: 0xe83c,
    categories: [11],
    tags: [
      3119,
      2035,
      1246,
      5753,
      461,
      4246,
      5434,
      1047,
      284,
      621,
      288,
      8,
      5754,
      2527,
      2532,
      779,
      1680,
      1086,
      1116,
      5755,
      1479,
      259,
      406,
      1119,
      3325,
      432,
      410,
      5436,
      1508,
      273,
      1270,
      411,
      65,
      412,
      4745,
      37,
      1867,
      278
    ],
  ),
  "chronic": SymbolsMetadata(
    popularity: 57,
    codepoint: 0xebb2,
    categories: [2],
    tags: [
      1338,
      1339,
      1657,
      2104,
      5756,
      1135,
      839,
      750,
      5757,
      1136,
      4715,
      2382,
      2117,
      10,
      692,
      2757,
      2384,
      5758,
      5759,
      1004,
      895,
      4988,
      2773,
      1063,
      4999,
      5760,
      3568,
      5761,
      1350,
      4890,
      1145,
      1148,
      2453,
      1149,
      1070,
      2102
    ],
  ),
  "church": SymbolsMetadata(
    popularity: 1174,
    codepoint: 0xeaae,
    categories: [5],
    tags: [
      1476,
      918,
      5762,
      5763,
      5764,
      5765,
      1800,
      1213,
      5766,
      5767,
      5768,
      5459,
      5769,
      1479,
      5175,
      1530,
      323,
      5770,
      327,
      5771,
      5772,
      5180,
      5181,
      5773,
      5774,
      5184,
      5775,
      5776,
      5777,
      5189
    ],
  ),
  "cinematic_blur": SymbolsMetadata(
    popularity: 53,
    codepoint: 0xf853,
    categories: [0],
    tags: [
      565,
      1738,
      5078,
      4257,
      4281,
      4258,
      40,
      344,
      5778,
      5779,
      345,
      484,
      5780,
      1229,
      487,
      346,
      5781,
      1746,
      583,
      49,
      4274,
      53,
      354,
      590,
      59,
      5782,
      62,
      674,
      591,
      151,
      597,
      37,
      5783,
      476
    ],
  ),
  "circle": SymbolsMetadata(
    popularity: 8477,
    codepoint: 0xef4a,
    categories: [1],
    tags: [
      500,
      1310,
      1108,
      1109,
      193,
      5784,
      485,
      2159,
      599,
      1140,
      5785,
      809,
      5786,
      5787,
      5788,
      488,
      348,
      2296,
      1142,
      381,
      320,
      49,
      53,
      755,
      174,
      4046,
      289,
      5789,
      1122,
      57,
      59,
      62,
      818,
      819,
      760,
      330,
      392,
      5790,
      1317,
      5791,
      31,
      5792,
      2529
    ],
  ),
  "circle_notifications": SymbolsMetadata(
    popularity: 2413,
    codepoint: 0xe994,
    categories: [6],
    tags: [
      747,
      1338,
      1339,
      2087,
      5793,
      1341,
      567,
      1343,
      193,
      5794,
      283,
      1250,
      585,
      4918,
      886,
      609,
      1236,
      1348,
      289,
      1350,
      5795,
      760,
      1271,
      1464
    ],
  ),
  "circles": SymbolsMetadata(
    popularity: 42,
    codepoint: 0xe7ea,
    categories: [6],
    tags: [
      480,
      1447,
      504,
      1076,
      1175,
      2738,
      3547,
      1081,
      1675,
      1140,
      381,
      137,
      1176,
      384,
      1384,
      640,
      2162,
      2242,
      3336,
      848,
      330,
      5479,
      1317,
      4841,
      31,
      476
    ],
  ),
  "circles_ext": SymbolsMetadata(
    popularity: 80,
    codepoint: 0xe7ec,
    categories: [6],
    tags: [
      5519,
      308,
      1076,
      5796,
      5797,
      2506,
      1047,
      284,
      4323,
      2200,
      2359,
      1190,
      1303,
      5798,
      5799,
      1313,
      5800,
      1746,
      4087,
      1294,
      5801,
      2348,
      267,
      5802,
      1062,
      1373,
      848,
      3173,
      2781,
      2286,
      1204,
      2356
    ],
  ),
  "clarify": SymbolsMetadata(
    popularity: 273,
    codepoint: 0xf0bf,
    categories: [12],
    tags: [
      746,
      2432,
      345,
      43,
      2341,
      1566,
      1567,
      5803,
      316,
      147,
      317,
      1746,
      1085,
      5484,
      2344,
      385,
      2345,
      5804,
      5805,
      2348,
      1618,
      2446,
      1574,
      1102,
      31,
      33,
      511,
      1465,
      2356
    ],
    rtlAutoMirrored: true,
  ),
  "clean_hands": SymbolsMetadata(
    popularity: 940,
    codepoint: 0xf21f,
    categories: [3],
    tags: [
      2380,
      3499,
      808,
      5806,
      5807,
      5808,
      5809,
      2383,
      5810,
      2664,
      2666,
      2093,
      5811,
      692,
      1765,
      1881,
      5812,
      5813,
      5814,
      5815,
      895,
      694,
      5816,
      696,
      3515,
      3794,
      3799,
      5817,
      5818,
      5819,
      5820,
      5821,
      2392,
      3810,
      5822,
      3797,
      2480
    ],
  ),
  "cleaning": SymbolsMetadata(
    popularity: 22,
    codepoint: 0xe995,
    categories: [15],
    tags: [
      1939,
      1403,
      5823,
      1873,
      5824,
      5825,
      5826,
      808,
      1905,
      3788,
      778,
      5827,
      4023,
      5828,
      46,
      580,
      1116,
      1880,
      5829,
      1881,
      5830,
      5831,
      4186,
      3920,
      1039,
      3799,
      5817,
      645,
      5832,
      1885,
      5833,
      5834,
      5835,
      1497,
      5836,
      5837,
      1296,
      1498
    ],
  ),
  "cleaning_bucket": SymbolsMetadata(
    popularity: 393,
    codepoint: 0xf8b4,
    categories: [10],
    tags: [
      5838,
      5826,
      808,
      3788,
      1311,
      4023,
      809,
      580,
      1116,
      5839,
      1881,
      5831,
      4186,
      3920,
      5840,
      5841,
      886,
      5842,
      758,
      5843,
      3799,
      5844,
      645,
      5836,
      3989,
      3810,
      2480,
      5845
    ],
  ),
  "cleaning_services": SymbolsMetadata(
    popularity: 1906,
    codepoint: 0xf0ff,
    categories: [5],
    tags: [
      5825,
      1759,
      5846,
      808,
      3788,
      1157,
      4023,
      5828,
      3742,
      1116,
      1479,
      5829,
      1881,
      5831,
      3920,
      5840,
      587,
      5847,
      4905,
      758,
      1483,
      3799,
      5844,
      645,
      2683,
      3201,
      5848,
      5834,
      5836,
      3810
    ],
  ),
  "clear_all": SymbolsMetadata(
    popularity: 2502,
    codepoint: 0xe0b8,
    categories: [2],
    tags: [
      746,
      2302,
      1288,
      5825,
      504,
      808,
      778,
      5849,
      345,
      81,
      5850,
      1699,
      1566,
      1567,
      4776,
      5851,
      370,
      137,
      138,
      68,
      86,
      584,
      88,
      1004,
      262,
      587,
      906,
      5852,
      5843,
      5834,
      5853,
      31,
      5836,
      333
    ],
  ),
  "clear_day": SymbolsMetadata(
    popularity: 1610,
    codepoint: 0xf157,
    categories: [3],
    tags: [
      2704,
      5854,
      3589,
      193,
      778,
      837,
      4715,
      2832,
      5855,
      1601,
      2982,
      1116,
      2984,
      3594,
      5856,
      1834,
      1119,
      242,
      4719,
      4711,
      3200,
      2008,
      1845,
      1586,
      4000,
      5857,
      855,
      2085,
      3786,
      856
    ],
  ),
  "climate_mini_split": SymbolsMetadata(
    popularity: 150,
    codepoint: 0xf8b5,
    categories: [10],
    tags: [
      5858,
      5261,
      5859,
      5860,
      5286,
      1889,
      1890,
      837,
      1921,
      345,
      841,
      842,
      1877,
      5861,
      2982,
      1859,
      1116,
      3125,
      1860,
      5862,
      2055,
      5863,
      5864,
      1899,
      2408,
      1068,
      5865,
      1865,
      5866
    ],
  ),
  "clinical_notes": SymbolsMetadata(
    popularity: 139,
    codepoint: 0xe09e,
    categories: [3],
    tags: [
      684,
      373,
      1760,
      5867,
      81,
      5868,
      1566,
      1761,
      1567,
      147,
      488,
      692,
      1765,
      2757,
      583,
      68,
      88,
      5869,
      895,
      1571,
      1460,
      1573,
      5870,
      1574,
      1575,
      2424,
      589,
      590,
      1776,
      453,
      1408,
      1576,
      433,
      3039,
      1777,
      1465
    ],
  ),
  "clock_arrow_down": SymbolsMetadata(
    popularity: 33,
    codepoint: 0xf382,
    categories: [2],
    tags: [
      1657,
      77,
      2091,
      193,
      462,
      1135,
      2105,
      313,
      2778,
      2839,
      2757,
      2134,
      51,
      2135,
      289,
      2759,
      1144,
      760,
      330,
      1145,
      360,
      1148,
      2099,
      1149,
      2102
    ],
  ),
  "clock_arrow_up": SymbolsMetadata(
    popularity: 24,
    codepoint: 0xf381,
    categories: [2],
    tags: [
      5871,
      2872,
      1339,
      1657,
      77,
      2981,
      2104,
      1135,
      1136,
      5872,
      902,
      489,
      2757,
      2134,
      138,
      235,
      2135,
      609,
      2759,
      5158,
      757,
      5873,
      453,
      1350,
      5000,
      360,
      275,
      31,
      1148,
      1696
    ],
  ),
  "clock_loader_10": SymbolsMetadata(
    popularity: 196,
    codepoint: 0xf726,
    categories: [2],
    tags: [
      5874,
      193,
      1135,
      81,
      608,
      520,
      2240,
      968,
      5875,
      51,
      3431,
      259,
      2998,
      5876,
      754,
      267,
      289,
      3606,
      2569,
      3926,
      3644,
      756,
      757,
      758,
      760,
      470,
      3998,
      291,
      762,
      5877,
      1148,
      890,
      527,
      764
    ],
  ),
  "clock_loader_20": SymbolsMetadata(
    popularity: 117,
    codepoint: 0xf725,
    categories: [2],
    tags: [
      5878,
      749,
      193,
      5879,
      1135,
      5880,
      5881,
      520,
      2240,
      2772,
      51,
      3431,
      2998,
      5876,
      754,
      69,
      5882,
      5883,
      2569,
      3926,
      3644,
      5884,
      756,
      757,
      2775,
      760,
      470,
      291,
      3873,
      1148,
      1149,
      3829,
      5885,
      527,
      764,
      2514
    ],
  ),
  "clock_loader_40": SymbolsMetadata(
    popularity: 201,
    codepoint: 0xf724,
    categories: [2],
    tags: [
      341,
      749,
      193,
      462,
      1135,
      2092,
      5886,
      5757,
      2139,
      520,
      51,
      3431,
      2998,
      5876,
      754,
      2569,
      3926,
      3644,
      1065,
      756,
      757,
      2775,
      2511,
      470,
      471,
      761,
      291,
      5887,
      2145,
      1148,
      1149,
      3495,
      527,
      764,
      3287
    ],
  ),
  "clock_loader_60": SymbolsMetadata(
    popularity: 237,
    codepoint: 0xf723,
    categories: [2],
    tags: [
      3933,
      193,
      462,
      1135,
      5880,
      2092,
      520,
      2117,
      2240,
      51,
      3431,
      2998,
      5876,
      754,
      2773,
      289,
      2569,
      3926,
      3644,
      1065,
      756,
      757,
      2775,
      5888,
      760,
      470,
      3936,
      291,
      1497,
      1148,
      1149,
      527,
      2513,
      764
    ],
  ),
  "clock_loader_80": SymbolsMetadata(
    popularity: 113,
    codepoint: 0xf722,
    categories: [2],
    tags: [
      3857,
      747,
      2504,
      341,
      193,
      462,
      1135,
      5880,
      520,
      2117,
      5889,
      2240,
      968,
      51,
      3431,
      2998,
      5876,
      754,
      289,
      3606,
      2569,
      3926,
      3644,
      1065,
      757,
      2775,
      5888,
      760,
      470,
      291,
      1497,
      1148,
      1149,
      890,
      527,
      764
    ],
  ),
  "clock_loader_90": SymbolsMetadata(
    popularity: 115,
    codepoint: 0xf721,
    categories: [2],
    tags: [
      5890,
      2504,
      749,
      193,
      5891,
      5892,
      1135,
      2092,
      520,
      1140,
      137,
      138,
      51,
      3431,
      2998,
      5876,
      754,
      5893,
      5894,
      2569,
      3926,
      3644,
      756,
      757,
      2775,
      2511,
      470,
      761,
      291,
      31,
      1148,
      1149,
      1326,
      4097,
      527,
      2513,
      764
    ],
  ),
  "close": SymbolsMetadata(
    popularity: 135691,
    codepoint: 0xe5cd,
    categories: [2],
    tags: [
      5154,
      746,
      1339,
      1187,
      5895,
      778,
      1188,
      4445,
      1213,
      1031,
      5896,
      5897,
      4594,
      2694,
      1190,
      2904,
      2871,
      5898,
      5071,
      609,
      1039,
      5899,
      1203,
      5900,
      206,
      5901,
      3712,
      3951
    ],
  ),
  "close_fullscreen": SymbolsMetadata(
    popularity: 4415,
    codepoint: 0xf1cf,
    categories: [2],
    tags: [
      746,
      77,
      502,
      5902,
      482,
      504,
      1188,
      2799,
      2434,
      345,
      3008,
      3009,
      313,
      8,
      5903,
      2296,
      1691,
      1603,
      1322,
      406,
      2841,
      635,
      1407,
      432,
      5904,
      3628,
      410,
      2866,
      433,
      1068,
      413,
      37,
      396,
      1165
    ],
  ),
  "close_small": SymbolsMetadata(
    popularity: 264,
    codepoint: 0xf508,
    categories: [2],
    tags: [
      1187,
      778,
      1188,
      1213,
      5030,
      1031,
      5905,
      4594,
      2207,
      2694,
      1190,
      2695,
      1191,
      5734,
      2055,
      1232,
      5906,
      4215,
      3254,
      4220,
      4221,
      1039,
      5907,
      1972,
      1203,
      3559,
      4299,
      5908,
      3712,
      3951
    ],
  ),
  "closed_caption": SymbolsMetadata(
    popularity: 1335,
    codepoint: 0xe01c,
    categories: [0],
    tags: [
      860,
      861,
      4,
      1246,
      482,
      504,
      5909,
      5910,
      5911,
      5,
      4204,
      5912,
      1742,
      5913,
      867,
      12,
      5220,
      16,
      87,
      1280,
      406,
      3448,
      1035,
      409,
      3366,
      432,
      71,
      1041,
      593,
      5914,
      5915,
      5916,
      2409,
      31,
      33,
      413,
      5917,
      2045,
      35,
      37
    ],
  ),
  "closed_caption_add": SymbolsMetadata(
    popularity: 13,
    codepoint: 0xf4ae,
    categories: [0],
    tags: [
      231,
      860,
      861,
      743,
      4,
      1246,
      482,
      5909,
      5910,
      5911,
      5,
      4204,
      5912,
      621,
      1302,
      5913,
      1229,
      2172,
      12,
      5918,
      5220,
      16,
      584,
      406,
      3448,
      439,
      886,
      1433,
      239,
      432,
      5919,
      433,
      5915,
      5916,
      31,
      33,
      5920,
      5917,
      2045,
      35,
      2414,
      37,
      1465
    ],
  ),
  "closed_caption_disabled": SymbolsMetadata(
    popularity: 318,
    codepoint: 0xf1dc,
    categories: [0],
    tags: [
      860,
      861,
      4,
      1246,
      2776,
      5909,
      5910,
      5911,
      5,
      4204,
      5921,
      5913,
      867,
      1033,
      5922,
      346,
      12,
      1257,
      5220,
      16,
      584,
      4482,
      406,
      354,
      3448,
      1282,
      1035,
      1037,
      432,
      410,
      2022,
      2128,
      1041,
      5923,
      593,
      433,
      5924,
      5915,
      5916,
      31,
      412,
      33,
      2045,
      35,
      37
    ],
  ),
  "cloud": SymbolsMetadata(
    popularity: 6990,
    codepoint: 0xe2bd,
    categories: [12],
    tags: [
      834,
      2704,
      837,
      1673,
      5925,
      284,
      1823,
      968,
      2832,
      137,
      138,
      259,
      5856,
      812,
      1834,
      267,
      289,
      5926,
      1705,
      5927,
      330,
      1010,
      392,
      1317,
      2008,
      852,
      979,
      31,
      855,
      141,
      1326,
      527,
      856,
      832
    ],
  ),
  "cloud_alert": SymbolsMetadata(
    popularity: 87,
    codepoint: 0xf3cc,
    categories: [12],
    tags: [
      3074,
      1339,
      1340,
      1342,
      837,
      1673,
      283,
      284,
      3076,
      1345,
      81,
      2694,
      1346,
      3871,
      2832,
      3447,
      1347,
      259,
      3078,
      1143,
      585,
      267,
      1160,
      609,
      1036,
      523,
      3081,
      1705,
      2008,
      291,
      1685,
      31,
      762,
      5928,
      855,
      527,
      206,
      856
    ],
  ),
  "cloud_circle": SymbolsMetadata(
    popularity: 600,
    codepoint: 0xe2be,
    categories: [12],
    tags: [
      1288,
      501,
      1672,
      193,
      462,
      1673,
      2486,
      284,
      81,
      520,
      1675,
      1677,
      968,
      1678,
      2832,
      259,
      267,
      523,
      289,
      330,
      2971,
      392,
      2008,
      1685,
      3435,
      65,
      527,
      856
    ],
  ),
  "cloud_done": SymbolsMetadata(
    popularity: 2047,
    codepoint: 0xe2bf,
    categories: [12],
    tags: [
      1288,
      501,
      1658,
      3956,
      1672,
      1660,
      2113,
      1673,
      463,
      1662,
      2486,
      2657,
      284,
      81,
      44,
      1567,
      2342,
      520,
      1675,
      147,
      1677,
      2639,
      1678,
      1616,
      259,
      1143,
      267,
      1663,
      523,
      2970,
      4421,
      362,
      2971,
      2008,
      1685,
      245,
      31,
      762,
      3435,
      65,
      1665,
      527,
      2355,
      1562,
      856,
      1668
    ],
  ),
  "cloud_download": SymbolsMetadata(
    popularity: 3965,
    codepoint: 0xe2c0,
    categories: [12],
    tags: [
      858,
      1288,
      501,
      77,
      1672,
      1673,
      5929,
      1674,
      519,
      284,
      81,
      1567,
      2778,
      520,
      2992,
      1675,
      147,
      1677,
      1678,
      5930,
      259,
      586,
      267,
      961,
      2761,
      1683,
      2971,
      2008,
      1685,
      762,
      3435,
      526,
      5931,
      527
    ],
  ),
  "cloud_lock": SymbolsMetadata(
    popularity: 81,
    codepoint: 0xf386,
    categories: [12],
    tags: [
      858,
      5306,
      1019,
      1030,
      1672,
      837,
      4204,
      1673,
      284,
      81,
      5932,
      259,
      1088,
      2584,
      5309,
      267,
      523,
      5933,
      5310,
      1009,
      975,
      3159,
      696,
      1705,
      1970,
      1040,
      3161,
      702,
      1022,
      5934,
      1011,
      2008,
      1685,
      31,
      855,
      527,
      856
    ],
  ),
  "cloud_off": SymbolsMetadata(
    popularity: 1592,
    codepoint: 0xe2c1,
    categories: [12],
    tags: [
      858,
      1288,
      501,
      1672,
      2692,
      1673,
      284,
      81,
      867,
      1032,
      1675,
      1033,
      2694,
      5063,
      5935,
      1677,
      1678,
      259,
      267,
      2588,
      5936,
      5937,
      5938,
      1035,
      1036,
      1037,
      2698,
      5939,
      5940,
      2008,
      1041,
      1685,
      5941,
      5942,
      762,
      1042,
      5943,
      527,
      206,
      856
    ],
  ),
  "cloud_sync": SymbolsMetadata(
    popularity: 2029,
    codepoint: 0xeb5a,
    categories: [12],
    tags: [
      1288,
      501,
      460,
      77,
      1672,
      2805,
      1673,
      2486,
      284,
      751,
      81,
      608,
      1448,
      313,
      520,
      1675,
      1677,
      1678,
      138,
      3431,
      259,
      2998,
      3432,
      755,
      267,
      523,
      757,
      758,
      2441,
      470,
      1683,
      2008,
      1685,
      762,
      763,
      1068,
      526,
      473,
      2946,
      5944,
      890,
      527,
      333
    ],
  ),
  "cloud_upload": SymbolsMetadata(
    popularity: 6389,
    codepoint: 0xe2c3,
    categories: [12],
    tags: [
      1288,
      501,
      77,
      1672,
      1673,
      2486,
      284,
      81,
      44,
      2968,
      520,
      1675,
      2816,
      1677,
      1678,
      5945,
      259,
      586,
      267,
      523,
      5946,
      1683,
      2318,
      5947,
      2971,
      1508,
      2008,
      509,
      1685,
      762,
      1068,
      526,
      1696,
      98,
      527,
      5948,
      856
    ],
  ),
  "co2": SymbolsMetadata(
    popularity: 1068,
    codepoint: 0xe7b0,
    categories: [3],
    tags: [
      834,
      5949,
      5950,
      5951,
      5952,
      5953,
      5954,
      4134,
      5955,
      5956,
      5957,
      3059,
      1140,
      5958,
      1856,
      4137,
      5959,
      5960,
      138,
      4143,
      3086,
      5961,
      289,
      906,
      1909,
      4147,
      4353,
      1147,
      3387,
      31
    ],
  ),
  "co_present": SymbolsMetadata(
    popularity: 2021,
    codepoint: 0xeaf0,
    categories: [7],
    tags: [
      77,
      566,
      729,
      4648,
      193,
      5962,
      5963,
      3191,
      519,
      5083,
      288,
      8,
      5964,
      5965,
      4997,
      623,
      5966,
      5967,
      589,
      5158,
      1407,
      432,
      5968,
      5969,
      410,
      2042,
      1508,
      5970,
      2044,
      2790,
      5971,
      5972,
      597,
      1206,
      37,
      5094,
      5973,
      333,
      1164
    ],
  ),
  "code": SymbolsMetadata(
    popularity: 8869,
    codepoint: 0xe86f,
    categories: [6],
    tags: [
      5974,
      5975,
      5976,
      1077,
      2239,
      1078,
      519,
      2205,
      1292,
      1293,
      1080,
      2172,
      4876,
      2749,
      548,
      5977,
      5978,
      5979,
      5980,
      5981,
      5982,
      2494,
      5983,
      1098,
      1099,
      5984,
      5985,
      3022,
      5986,
      509,
      5987,
      65,
      33,
      2222
    ],
  ),
  "code_blocks": SymbolsMetadata(
    popularity: 782,
    codepoint: 0xf84d,
    categories: [6],
    tags: [
      481,
      2284,
      5976,
      5988,
      1077,
      2239,
      3322,
      1355,
      2205,
      1292,
      1293,
      1080,
      375,
      2172,
      1140,
      4876,
      2749,
      1051,
      1084,
      5989,
      5977,
      5710,
      4685,
      4072,
      4687,
      2494,
      1098,
      1099,
      3022,
      5990,
      1127,
      1128,
      94,
      5986,
      945,
      5991,
      2949
    ],
  ),
  "code_off": SymbolsMetadata(
    popularity: 652,
    codepoint: 0xe4f3,
    categories: [6],
    tags: [
      1028,
      5974,
      3726,
      5976,
      5992,
      4852,
      1187,
      5993,
      778,
      1188,
      1077,
      5994,
      2239,
      2205,
      1290,
      1031,
      1292,
      1293,
      5995,
      1138,
      867,
      1033,
      4876,
      2749,
      2694,
      1190,
      1745,
      1191,
      548,
      5977,
      3078,
      5981,
      1035,
      1037,
      2494,
      3081,
      5996,
      1039,
      1970,
      1041,
      1203,
      206
    ],
  ),
  "coffee": SymbolsMetadata(
    popularity: 2643,
    codepoint: 0xefef,
    categories: [8],
    tags: [
      5997,
      4168,
      2138,
      3651,
      3653,
      5998,
      5999,
      6000,
      6001,
      6002,
      6003,
      6004,
      4635,
      4178,
      3641,
      2370,
      2984,
      6005,
      6006,
      4183,
      4186,
      6007,
      2149,
      6008,
      4640,
      6009,
      3665,
      1180,
      3784,
      6010,
      6011,
      3786
    ],
  ),
  "coffee_maker": SymbolsMetadata(
    popularity: 825,
    codepoint: 0xeff0,
    categories: [8],
    tags: [
      1889,
      6012,
      1403,
      4168,
      2138,
      3651,
      6013,
      3653,
      6000,
      6014,
      6002,
      6015,
      6004,
      4023,
      4178,
      6016,
      3640,
      46,
      83,
      6017,
      1116,
      5606,
      6006,
      2717,
      4181,
      4183,
      1729,
      6018,
      2149,
      6008,
      1372,
      6019,
      6020,
      3665,
      645
    ],
  ),
  "cognition": SymbolsMetadata(
    popularity: 607,
    codepoint: 0xe09f,
    categories: [3],
    tags: [
      480,
      1402,
      1045,
      684,
      6021,
      6022,
      2321,
      81,
      3059,
      4118,
      872,
      692,
      1765,
      583,
      3763,
      5473,
      384,
      2456,
      3379,
      3086,
      895,
      2758,
      5711,
      6023,
      289,
      589,
      590,
      6024,
      4147,
      392,
      1147,
      31,
      4833,
      4834,
      6025,
      6026,
      3390
    ],
  ),
  "cognition_2": SymbolsMetadata(
    popularity: 239,
    codepoint: 0xf3b5,
    categories: [3],
    tags: [
      1402,
      3121,
      4618,
      684,
      6021,
      6027,
      6028,
      6022,
      2321,
      6029,
      2737,
      3059,
      872,
      692,
      583,
      3763,
      5473,
      6030,
      2456,
      3379,
      3086,
      5710,
      3765,
      2758,
      5711,
      6031,
      6023,
      589,
      590,
      6032,
      6024,
      6033,
      4833,
      4834,
      6025,
      6026
    ],
  ),
  "collapse_all": SymbolsMetadata(
    popularity: 405,
    codepoint: 0xe944,
    categories: [2],
    tags: [
      2302,
      502,
      1170,
      6034,
      1227,
      1188,
      6035,
      2799,
      6036,
      6037,
      6038,
      5045,
      6039,
      2434,
      6040,
      2402,
      6041,
      1303,
      2862,
      6042,
      1176,
      6043,
      2864,
      6044,
      6045,
      88,
      2841,
      6046,
      6047,
      5904,
      6048,
      2866,
      6049
    ],
  ),
  "collapse_content": SymbolsMetadata(
    popularity: 319,
    codepoint: 0xf507,
    categories: [2],
    tags: [
      1107,
      77,
      6050,
      502,
      2784,
      2799,
      6051,
      6052,
      6053,
      6054,
      145,
      313,
      2778,
      2830,
      1303,
      6055,
      6056,
      6057,
      5798,
      1710,
      2864,
      6058,
      88,
      2360,
      2841,
      237,
      325,
      2876,
      2243,
      1127,
      6059,
      6060,
      6061,
      2022,
      413,
      98
    ],
  ),
  "collections_bookmark": SymbolsMetadata(
    popularity: 3127,
    codepoint: 0xe431,
    categories: [6],
    tags: [
      1320,
      2154,
      1688,
      3376,
      4768,
      1175,
      6062,
      3762,
      3194,
      1321,
      1053,
      5546,
      3379,
      52,
      1323,
      88,
      3380,
      2162,
      6063,
      1573,
      92,
      1575,
      6064,
      3366,
      2834,
      4425,
      6065,
      453,
      4088,
      179,
      977,
      4063,
      3482,
      1683,
      594,
      4434,
      182
    ],
  ),
  "colorize": SymbolsMetadata(
    popularity: 1190,
    codepoint: 0xe3b8,
    categories: [1],
    tags: [
      862,
      4543,
      1580,
      4817,
      4514,
      6066,
      6067,
      6068,
      6069,
      6070,
      6071,
      6072,
      6073,
      6074,
      3565,
      485,
      378,
      6075,
      5740,
      5787,
      6076,
      6077,
      3577,
      4821,
      4822,
      6078,
      3579,
      6079,
      6080,
      4200,
      6081,
      2180,
      6082,
      6083,
      511,
      6084
    ],
  ),
  "colors": SymbolsMetadata(
    popularity: 156,
    codepoint: 0xe997,
    categories: [12],
    tags: [
      1738,
      4543,
      1580,
      3590,
      4817,
      5838,
      4514,
      6069,
      6074,
      2737,
      3565,
      485,
      1566,
      378,
      2849,
      1229,
      673,
      2172,
      2240,
      4269,
      2276,
      6085,
      1636,
      70,
      4821,
      6078,
      6086,
      362,
      71,
      1576,
      6081,
      1441,
      1147,
      2180,
      6087,
      33,
      4699,
      511,
      35,
      476,
      1465
    ],
  ),
  "combine_columns": SymbolsMetadata(
    popularity: 14,
    codepoint: 0xf420,
    categories: [12],
    tags: [
      231,
      743,
      6088,
      1419,
      923,
      6089,
      284,
      81,
      6090,
      6091,
      6092,
      6093,
      1448,
      485,
      370,
      382,
      1176,
      6094,
      6095,
      385,
      584,
      1294,
      6096,
      6097,
      6098,
      1433,
      1063,
      239,
      4613,
      3338,
      4089,
      6099,
      1440,
      1441,
      433,
      31,
      1453,
      6100,
      1445,
      396,
      1164
    ],
  ),
  "comedy_mask": SymbolsMetadata(
    popularity: 66,
    codepoint: 0xf4d6,
    categories: [3],
    tags: [
      6101,
      6102,
      6103,
      1580,
      6104,
      6105,
      5,
      6106,
      6107,
      6108,
      4479,
      6109,
      1591,
      779,
      10,
      6110,
      576,
      6111,
      6112,
      1601,
      6113,
      6114,
      6115,
      6116,
      6117,
      6118,
      354,
      3045,
      641,
      2549,
      2500,
      1009,
      975,
      1560,
      696,
      1011,
      2022,
      1610,
      6119,
      6120,
      3329,
      6121,
      6122,
      6123,
      6124,
      2100,
      2102
    ],
  ),
  "comic_bubble": SymbolsMetadata(
    popularity: 70,
    codepoint: 0xf5dd,
    categories: [3],
    tags: [
      341,
      6125,
      4824,
      567,
      6126,
      6127,
      6128,
      569,
      2706,
      4825,
      6129,
      6130,
      4826,
      6131,
      571,
      283,
      1455,
      2709,
      2710,
      1459,
      5708,
      6132,
      585,
      4828,
      593,
      1464,
      1274,
      4829,
      6133,
      4831,
      4835
    ],
  ),
  "comment": SymbolsMetadata(
    popularity: 6660,
    codepoint: 0xe0b9,
    categories: [7],
    tags: [
      743,
      6134,
      4824,
      567,
      569,
      571,
      572,
      283,
      1455,
      1302,
      6135,
      2709,
      2710,
      1459,
      1305,
      585,
      886,
      6136,
      289,
      239,
      432,
      1462,
      1609,
      593,
      433,
      6137,
      1274,
      33,
      4831,
      6138
    ],
    rtlAutoMirrored: true,
  ),
  "comment_bank": SymbolsMetadata(
    popularity: 509,
    codepoint: 0xea4e,
    categories: [7],
    tags: [
      2154,
      915,
      1688,
      567,
      6139,
      569,
      1175,
      571,
      572,
      283,
      1455,
      2709,
      2710,
      3194,
      1459,
      1176,
      2757,
      52,
      5372,
      1323,
      585,
      2162,
      1573,
      587,
      453,
      4063,
      2760,
      3482,
      1683,
      6140,
      593,
      1464,
      433,
      6141,
      1685,
      1377,
      182,
      1274,
      33
    ],
  ),
  "comments_disabled": SymbolsMetadata(
    popularity: 480,
    codepoint: 0xe7a2,
    categories: [7],
    tags: [
      4824,
      1403,
      3726,
      567,
      191,
      569,
      6142,
      6143,
      193,
      571,
      6144,
      6145,
      6146,
      6147,
      572,
      6148,
      6149,
      1213,
      6150,
      867,
      1033,
      1459,
      87,
      585,
      6151,
      6152,
      1782,
      1282,
      6153,
      6154,
      1035,
      1036,
      1037,
      6155,
      1041,
      593,
      1464,
      6156
    ],
  ),
  "commit": SymbolsMetadata(
    popularity: 634,
    codepoint: 0xeaf5,
    categories: [6],
    tags: [
      6157,
      6158,
      2938,
      6159,
      193,
      1077,
      3191,
      6160,
      1049,
      1709,
      6161,
      1080,
      375,
      1081,
      1083,
      6162,
      2757,
      87,
      584,
      1308,
      267,
      1062,
      6163,
      6164,
      848,
      1099,
      1332,
      3396,
      5435,
      2760,
      5549,
      6165,
      6166,
      762,
      2453,
      890,
      6167,
      514
    ],
  ),
  "communication": SymbolsMetadata(
    popularity: 2265,
    codepoint: 0xe27c,
    categories: [3],
    tags: [
      1339,
      4824,
      567,
      6126,
      569,
      2706,
      6168,
      4825,
      571,
      5580,
      283,
      1455,
      2709,
      1459,
      5570,
      51,
      585,
      2315,
      1119,
      2567,
      609,
      589,
      328,
      2796,
      1237,
      1273,
      593,
      1464,
      433,
      5572,
      1274,
      5582
    ],
  ),
  "communities": SymbolsMetadata(
    popularity: 287,
    codepoint: 0xe7ed,
    categories: [3],
    tags: [
      1168,
      569,
      193,
      3191,
      283,
      6169,
      1800,
      1049,
      6170,
      2710,
      5570,
      5767,
      1176,
      6171,
      4997,
      4624,
      267,
      1063,
      6172,
      589,
      6173,
      2057,
      1508,
      2044,
      705,
      6174,
      1275,
      5481,
      6175,
      4570,
      1206
    ],
  ),
  "commute": SymbolsMetadata(
    popularity: 985,
    codepoint: 0xe940,
    categories: [14],
    tags: [
      77,
      2048,
      1816,
      1818,
      4105,
      6176,
      312,
      313,
      2051,
      6177,
      6178,
      4060,
      2780,
      1617,
      323,
      1059,
      1520,
      468,
      325,
      1619,
      1144,
      2057,
      1620,
      1621,
      1531,
      1622,
      1944,
      1994,
      1623,
      332,
      1945,
      1486,
      1850,
      1624
    ],
  ),
  "compare": SymbolsMetadata(
    popularity: 1427,
    codepoint: 0xe3b9,
    categories: [1],
    tags: [
      1738,
      2233,
      1402,
      6179,
      373,
      3671,
      3719,
      6180,
      6181,
      4698,
      81,
      6182,
      6183,
      1229,
      673,
      5544,
      3334,
      3192,
      6184,
      1745,
      1052,
      49,
      2499,
      86,
      17,
      1060,
      6185,
      2924,
      2236,
      57,
      59,
      4792,
      6186,
      1408,
      3101,
      1736,
      71,
      6187,
      744,
      394,
      6188,
      6189
    ],
  ),
  "compare_arrows": SymbolsMetadata(
    popularity: 3688,
    codepoint: 0xe915,
    categories: [2],
    tags: [
      2394,
      77,
      502,
      914,
      2917,
      2397,
      2398,
      6190,
      3671,
      1213,
      608,
      313,
      3261,
      1051,
      581,
      2216,
      6191,
      586,
      6192,
      2924,
      70,
      6193,
      4232,
      5435,
      5607,
      907,
      3584,
      2409,
      3685,
      762,
      763,
      6194,
      413,
      526,
      394,
      398
    ],
    rtlAutoMirrored: true,
  ),
  "compass_calibration": SymbolsMetadata(
    popularity: 285,
    codepoint: 0xe57c,
    categories: [5],
    tags: [
      5518,
      1738,
      2167,
      4708,
      6195,
      193,
      309,
      284,
      313,
      2931,
      1744,
      1528,
      4060,
      3144,
      259,
      323,
      6196,
      324,
      1520,
      325,
      6197,
      267,
      6198,
      1144,
      329,
      758,
      64,
      645,
      71,
      1752,
      273,
      4601,
      1296,
      2648,
      3989,
      2953,
      277,
      278
    ],
  ),
  "component_exchange": SymbolsMetadata(
    popularity: 1699,
    codepoint: 0xf1e7,
    categories: [6],
    tags: [
      1579,
      502,
      2397,
      6199,
      3322,
      1213,
      6200,
      1140,
      3261,
      1051,
      6201,
      6202,
      3087,
      586,
      2924,
      4687,
      3581,
      2788,
      1694,
      1127,
      6203,
      3584,
      2409,
      4922,
      526,
      6204,
      1848,
      2946
    ],
  ),
  "compost": SymbolsMetadata(
    popularity: 3177,
    codepoint: 0xe761,
    categories: [3],
    tags: [
      1815,
      2754,
      4130,
      4347,
      808,
      6205,
      6206,
      6207,
      1311,
      6208,
      6209,
      6210,
      6211,
      6212,
      6213,
      1856,
      3355,
      1827,
      1828,
      1832,
      6214,
      1834,
      1835,
      6215,
      1837,
      3433,
      6216,
      5904,
      6217,
      6218,
      3991,
      6219,
      6220,
      1846,
      2334,
      6221,
      6222
    ],
  ),
  "compress": SymbolsMetadata(
    popularity: 1213,
    codepoint: 0xe94d,
    categories: [2],
    tags: [
      6223,
      77,
      502,
      6190,
      6037,
      6038,
      6224,
      3008,
      81,
      3009,
      377,
      1303,
      47,
      2241,
      49,
      2360,
      2841,
      439,
      6225,
      3412,
      6226,
      4232,
      5435,
      5904,
      2243,
      391,
      6227,
      6228,
      410,
      2866,
      6194,
      512,
      37,
      1165,
      2356
    ],
  ),
  "computer": SymbolsMetadata(
    popularity: 8928,
    codepoint: 0xe30a,
    categories: [11],
    tags: [
      1223,
      1224,
      1869,
      1698,
      283,
      519,
      2486,
      81,
      5128,
      1699,
      288,
      44,
      8,
      2527,
      6229,
      1894,
      1086,
      1230,
      259,
      3643,
      1700,
      623,
      267,
      6063,
      1372,
      4253,
      4251,
      6230,
      410,
      2971,
      1068,
      65,
      6231,
      333,
      1165,
      1498,
      6232
    ],
  ),
  "computer_arrow_up": SymbolsMetadata(
    popularity: 12,
    codepoint: 0xf2f7,
    categories: [11],
    tags: [
      1223,
      1224,
      77,
      6233,
      1698,
      519,
      284,
      81,
      608,
      1699,
      288,
      313,
      147,
      2816,
      1086,
      1230,
      259,
      1700,
      623,
      267,
      1144,
      410,
      2318,
      5947,
      6234,
      1508,
      6235,
      65,
      6236,
      526,
      1696,
      527,
      6237,
      6238,
      2966,
      2967,
      333,
      1165
    ],
  ),
  "computer_cancel": SymbolsMetadata(
    popularity: 26,
    codepoint: 0xf2f6,
    categories: [11],
    tags: [
      1223,
      1224,
      1339,
      2692,
      1187,
      1342,
      1698,
      778,
      1188,
      519,
      1213,
      1031,
      1699,
      288,
      1032,
      4594,
      8,
      3352,
      2694,
      1190,
      2695,
      1191,
      1086,
      1230,
      1700,
      623,
      6239,
      1039,
      410,
      1203,
      31,
      1068,
      65,
      1042,
      206,
      333,
      1165,
      6232,
      3712
    ],
  ),
  "concierge": SymbolsMetadata(
    popularity: 96,
    codepoint: 0xf561,
    categories: [16],
    tags: [
      1339,
      865,
      6240,
      1641,
      6241,
      1341,
      6242,
      4059,
      6243,
      2050,
      6244,
      225,
      2663,
      2664,
      2666,
      5696,
      873,
      5606,
      2717,
      583,
      68,
      6245,
      3618,
      1348,
      289,
      590,
      6246,
      1884,
      645,
      4443,
      878,
      31,
      1623,
      332,
      1945,
      2625,
      6247
    ],
  ),
  "conditions": SymbolsMetadata(
    popularity: 116,
    codepoint: 0xe0a0,
    categories: [3],
    tags: [
      1851,
      684,
      6248,
      778,
      837,
      1673,
      2825,
      2341,
      1823,
      316,
      6249,
      317,
      2832,
      1085,
      692,
      583,
      1091,
      1092,
      1093,
      5856,
      1833,
      1836,
      6250,
      6251,
      589,
      590,
      6252,
      1102,
      6253,
      1103,
      2008,
      6254,
      6255,
      1586,
      855,
      856,
      6256,
      6257,
      6258
    ],
  ),
  "confirmation_number": SymbolsMetadata(
    popularity: 4768,
    codepoint: 0xe638,
    categories: [15],
    tags: [
      858,
      565,
      4411,
      1030,
      1916,
      1077,
      4445,
      6259,
      45,
      779,
      1568,
      10,
      172,
      1088,
      2584,
      971,
      21,
      22,
      91,
      2019,
      5310,
      326,
      6260,
      179,
      1931,
      4195,
      1022,
      94,
      31,
      2025,
      5792,
      6261,
      4420,
      4799
    ],
  ),
  "congenital": SymbolsMetadata(
    popularity: 13,
    codepoint: 0xe0a1,
    categories: [3],
    tags: [
      3521,
      6262,
      566,
      684,
      1020,
      6263,
      839,
      6264,
      6265,
      2382,
      225,
      6266,
      872,
      692,
      1765,
      583,
      6267,
      1002,
      6268,
      6269,
      895,
      6270,
      289,
      6271,
      590,
      818,
      591,
      390,
      1012,
      978,
      6272,
      597,
      1026
    ],
  ),
  "connect_without_contact": SymbolsMetadata(
    popularity: 2129,
    codepoint: 0xf223,
    categories: [3],
    tags: [
      729,
      6273,
      283,
      1047,
      284,
      254,
      965,
      6274,
      81,
      9,
      1294,
      267,
      4247,
      589,
      6275,
      2071,
      6276,
      6277,
      2044,
      273,
      705,
      6278,
      762,
      3435,
      65,
      526,
      2074,
      1867,
      278,
      6279
    ],
  ),
  "connected_tv": SymbolsMetadata(
    popularity: 876,
    codepoint: 0xe998,
    categories: [11],
    tags: [
      1223,
      1224,
      2035,
      4246,
      1698,
      1047,
      1048,
      284,
      1699,
      288,
      8,
      2527,
      1086,
      5755,
      1230,
      584,
      1700,
      406,
      5319,
      623,
      267,
      432,
      410,
      5436,
      5442,
      411,
      65,
      412,
      2045,
      37,
      333,
      277,
      1165,
      278
    ],
  ),
  "connecting_airports": SymbolsMetadata(
    popularity: 852,
    codepoint: 0xe7c9,
    categories: [5],
    tags: [
      834,
      1938,
      1913,
      2001,
      1987,
      2879,
      1961,
      6280,
      6281,
      284,
      5605,
      312,
      1924,
      6282,
      2004,
      2005,
      1947,
      320,
      3146,
      1989,
      1617,
      1294,
      323,
      2054,
      324,
      635,
      267,
      1037,
      1619,
      326,
      387,
      2007,
      1621,
      273,
      526,
      1994,
      1848,
      1623,
      332,
      1996,
      1945,
      334
    ],
  ),
  "construction": SymbolsMetadata(
    popularity: 9754,
    codepoint: 0xea3c,
    categories: [15],
    tags: [
      1354,
      5988,
      918,
      5375,
      1477,
      6283,
      1080,
      4876,
      2749,
      46,
      1745,
      4869,
      6284,
      5378,
      6285,
      6286,
      4871,
      3415,
      6287,
      3920,
      6288,
      6289,
      4873,
      2790,
      6290,
      140,
      6291,
      1296,
      6292,
      6293,
      6294,
      1498,
      5386,
      2514,
      1786
    ],
  ),
  "contact_emergency": SymbolsMetadata(
    popularity: 740,
    codepoint: 0xf8d1,
    categories: [7],
    tags: [
      565,
      6295,
      1339,
      865,
      566,
      1248,
      1227,
      965,
      6296,
      6297,
      967,
      4365,
      3076,
      1345,
      4769,
      2423,
      576,
      692,
      873,
      583,
      293,
      68,
      895,
      6298,
      6299,
      6300,
      6301,
      262,
      589,
      590,
      271,
      591,
      976,
      702,
      1011,
      2428,
      597,
      206
    ],
  ),
  "contact_mail": SymbolsMetadata(
    popularity: 4769,
    codepoint: 0xe0d0,
    categories: [7],
    tags: [
      565,
      1493,
      566,
      1310,
      482,
      6302,
      572,
      283,
      1564,
      965,
      2305,
      2308,
      2310,
      6303,
      576,
      583,
      969,
      970,
      293,
      68,
      15,
      87,
      2312,
      585,
      289,
      589,
      590,
      974,
      591,
      961,
      432,
      2318,
      978,
      1317,
      433,
      597
    ],
  ),
  "contact_page": SymbolsMetadata(
    popularity: 3577,
    codepoint: 0xf22e,
    categories: [12],
    tags: [
      565,
      6295,
      566,
      3375,
      919,
      193,
      965,
      81,
      145,
      4769,
      1566,
      1567,
      1675,
      576,
      147,
      2161,
      1678,
      488,
      583,
      138,
      969,
      68,
      88,
      1372,
      289,
      1574,
      1575,
      589,
      590,
      911,
      591,
      453,
      432,
      392,
      1576,
      2797,
      433,
      1685,
      31,
      597,
      1465
    ],
  ),
  "contact_phone": SymbolsMetadata(
    popularity: 2849,
    codepoint: 0xe0cf,
    categories: [7],
    tags: [
      565,
      6295,
      566,
      1248,
      572,
      283,
      1047,
      965,
      1381,
      4769,
      576,
      968,
      379,
      4118,
      5023,
      583,
      1002,
      293,
      68,
      585,
      262,
      21,
      289,
      589,
      590,
      911,
      271,
      591,
      6304,
      3325,
      1695,
      979,
      276,
      1387,
      597
    ],
  ),
  "contact_support": SymbolsMetadata(
    popularity: 9914,
    codepoint: 0xe94c,
    categories: [7],
    tags: [
      3898,
      6305,
      6306,
      6307,
      865,
      567,
      569,
      193,
      571,
      572,
      283,
      965,
      1455,
      6308,
      2709,
      6309,
      6310,
      6311,
      6312,
      873,
      293,
      68,
      1143,
      585,
      289,
      3901,
      2352,
      3902,
      3903,
      593,
      6313,
      1464,
      1147,
      6314,
      878,
      6315,
      31,
      1274
    ],
    rtlAutoMirrored: true,
  ),
  "contactless": SymbolsMetadata(
    popularity: 1360,
    codepoint: 0xea71,
    categories: [9],
    tags: [
      916,
      4245,
      6316,
      921,
      924,
      1047,
      284,
      254,
      965,
      6274,
      926,
      81,
      288,
      44,
      2527,
      931,
      1294,
      6317,
      6318,
      6319,
      267,
      6320,
      940,
      941,
      6321,
      2081,
      3737,
      1374,
      1022,
      1011,
      1376,
      273,
      1797,
      65,
      1295,
      946,
      526,
      6322,
      1866,
      277,
      278
    ],
  ),
  "contactless_off": SymbolsMetadata(
    popularity: 102,
    codepoint: 0xf858,
    categories: [9],
    tags: [
      1028,
      3726,
      4245,
      6323,
      921,
      283,
      1047,
      284,
      254,
      965,
      6274,
      6324,
      6325,
      926,
      288,
      1138,
      1279,
      867,
      1033,
      931,
      6320,
      6326,
      6327,
      6328,
      1035,
      1036,
      1037,
      940,
      941,
      6329,
      4219,
      1970,
      273,
      1041,
      1203,
      6330,
      65,
      946,
      1042,
      1867,
      6331,
      277,
      278
    ],
  ),
  "contacts": SymbolsMetadata(
    popularity: 4828,
    codepoint: 0xe0ba,
    categories: [7],
    tags: [
      565,
      6295,
      6332,
      1380,
      566,
      1248,
      1227,
      193,
      965,
      967,
      4769,
      576,
      1254,
      4118,
      1176,
      6333,
      583,
      293,
      68,
      88,
      6334,
      262,
      6335,
      589,
      590,
      271,
      591,
      976,
      392,
      978,
      705,
      31,
      3863,
      1326,
      597,
      1206
    ],
  ),
  "contacts_product": SymbolsMetadata(
    popularity: 313,
    codepoint: 0xe999,
    categories: [6],
    tags: [
      565,
      1242,
      1493,
      6295,
      1168,
      566,
      3375,
      1800,
      1047,
      284,
      6336,
      967,
      4769,
      1176,
      6337,
      583,
      2466,
      267,
      589,
      6338,
      590,
      973,
      1652,
      591,
      4090,
      705,
      1275,
      597,
      1027,
      1206
    ],
  ),
  "content_copy": SymbolsMetadata(
    popularity: 20448,
    codepoint: 0xe14d,
    categories: [12],
    tags: [
      746,
      504,
      1078,
      621,
      345,
      1724,
      6339,
      81,
      1566,
      1567,
      3626,
      147,
      1677,
      68,
      1322,
      1056,
      2162,
      6340,
      1574,
      3384,
      1575,
      5590,
      1734,
      6341,
      3021,
      6342,
      1683,
      362,
      4399,
      594,
      33,
      511,
      3989
    ],
    rtlAutoMirrored: true,
  ),
  "content_cut": SymbolsMetadata(
    popularity: 1841,
    codepoint: 0xe14e,
    categories: [12],
    tags: [
      746,
      6343,
      6344,
      621,
      6345,
      1724,
      6339,
      1031,
      2285,
      1566,
      1567,
      1229,
      147,
      1084,
      4118,
      384,
      87,
      506,
      289,
      5590,
      1123,
      1039,
      6346,
      1127,
      1128,
      392,
      6347,
      2408,
      2182,
      511,
      6348,
      6349,
      364
    ],
    rtlAutoMirrored: true,
  ),
  "content_paste": SymbolsMetadata(
    popularity: 3481,
    codepoint: 0xe14f,
    categories: [12],
    tags: [
      746,
      504,
      3058,
      621,
      1724,
      6339,
      81,
      1566,
      1567,
      3762,
      520,
      2172,
      1826,
      147,
      1677,
      968,
      488,
      68,
      1087,
      1323,
      586,
      2162,
      1460,
      1575,
      5590,
      2447,
      1683,
      1576,
      979,
      6350,
      33,
      526,
      527,
      1465
    ],
  ),
  "content_paste_go": SymbolsMetadata(
    popularity: 617,
    codepoint: 0xea8e,
    categories: [12],
    tags: [
      746,
      77,
      3058,
      6351,
      621,
      6352,
      1724,
      81,
      608,
      2293,
      867,
      1566,
      1567,
      6353,
      1229,
      1033,
      147,
      6354,
      903,
      1305,
      584,
      586,
      6355,
      1372,
      1037,
      1575,
      5590,
      6356,
      432,
      907,
      4399,
      1041,
      433,
      33,
      526
    ],
  ),
  "content_paste_off": SymbolsMetadata(
    popularity: 290,
    codepoint: 0xe4f8,
    categories: [12],
    tags: [
      1028,
      3726,
      6357,
      3058,
      6358,
      6359,
      621,
      6360,
      6361,
      6362,
      1213,
      6363,
      1138,
      867,
      1566,
      1567,
      1033,
      147,
      381,
      3254,
      6364,
      6239,
      1035,
      1037,
      1575,
      5590,
      6365,
      6366,
      6367,
      6368,
      4219,
      1970,
      392,
      1576,
      1041,
      6369,
      6370,
      6371
    ],
  ),
  "content_paste_search": SymbolsMetadata(
    popularity: 1690,
    codepoint: 0xea9b,
    categories: [12],
    tags: [
      2154,
      3058,
      621,
      1724,
      81,
      1566,
      1567,
      3626,
      316,
      147,
      317,
      68,
      5484,
      2344,
      88,
      2345,
      2346,
      2348,
      1575,
      5590,
      453,
      3385,
      2761,
      1736,
      1102,
      1576,
      1685,
      33,
      3755,
      2164,
      396
    ],
  ),
  "contextual_token": SymbolsMetadata(
    popularity: 103,
    codepoint: 0xf486,
    categories: [4],
    tags: [
      4301,
      77,
      2432,
      1246,
      6372,
      504,
      1079,
      345,
      1741,
      2293,
      1566,
      1567,
      6373,
      779,
      147,
      902,
      903,
      6374,
      2908,
      385,
      406,
      354,
      439,
      1701,
      2446,
      1574,
      2500,
      408,
      409,
      1144,
      3030,
      2218,
      454,
      31,
      33,
      1718,
      37,
      1465
    ],
    rtlAutoMirrored: true,
  ),
  "contextual_token_add": SymbolsMetadata(
    popularity: 44,
    codepoint: 0xf485,
    categories: [4],
    tags: [
      231,
      746,
      743,
      232,
      6375,
      1298,
      2432,
      504,
      789,
      4558,
      6376,
      6377,
      1302,
      1566,
      1567,
      147,
      1176,
      1314,
      235,
      1305,
      385,
      6378,
      6379,
      886,
      1433,
      2446,
      1574,
      239,
      242,
      392,
      668,
      31,
      33,
      6194,
      5792,
      230,
      1326,
      4697,
      6380,
      1465
    ],
    rtlAutoMirrored: true,
  ),
  "contract": SymbolsMetadata(
    popularity: 398,
    codepoint: 0xf5a0,
    categories: [12],
    tags: [
      2430,
      6381,
      919,
      2825,
      2434,
      6382,
      1566,
      1567,
      2435,
      147,
      2436,
      488,
      6383,
      138,
      5372,
      2438,
      88,
      6384,
      289,
      2732,
      1574,
      1575,
      6385,
      5624,
      453,
      5627,
      6386,
      595,
      31,
      6387,
      946,
      4401
    ],
  ),
  "contract_delete": SymbolsMetadata(
    popularity: 42,
    codepoint: 0xf5a2,
    categories: [12],
    tags: [
      2430,
      6388,
      2754,
      1187,
      6389,
      6390,
      778,
      1188,
      2434,
      6391,
      1031,
      6392,
      6393,
      1566,
      1567,
      6394,
      6395,
      1190,
      147,
      6396,
      6397,
      584,
      88,
      3254,
      1574,
      6398,
      1575,
      5624,
      6399,
      4220,
      453,
      6400,
      432,
      1039,
      6401,
      6402,
      6403,
      1203,
      946,
      3360,
      6404,
      6405,
      3712,
      3951
    ],
  ),
  "contract_edit": SymbolsMetadata(
    popularity: 302,
    codepoint: 0xf5a1,
    categories: [12],
    tags: [
      1756,
      2430,
      6406,
      919,
      1564,
      2434,
      6407,
      6408,
      2357,
      1302,
      1138,
      1566,
      1567,
      3268,
      4464,
      1229,
      673,
      147,
      6409,
      488,
      6410,
      1087,
      5327,
      2438,
      87,
      88,
      1636,
      1372,
      1574,
      1575,
      5624,
      3062,
      2599,
      453,
      432,
      392,
      1162,
      5627,
      433,
      946,
      1578,
      1465
    ],
  ),
  "contrast": SymbolsMetadata(
    popularity: 1346,
    codepoint: 0xeb37,
    categories: [1],
    tags: [
      860,
      862,
      6411,
      3590,
      4698,
      345,
      6412,
      4040,
      6413,
      8,
      6414,
      1229,
      673,
      487,
      83,
      4269,
      6415,
      6333,
      6085,
      49,
      2499,
      1057,
      3594,
      623,
      70,
      57,
      59,
      62,
      4793,
      6086,
      410,
      71,
      2408,
      2409,
      413,
      2735,
      832
    ],
    rtlAutoMirrored: true,
  ),
  "contrast_circle": SymbolsMetadata(
    popularity: 10,
    codepoint: 0xf49f,
    categories: [1],
    tags: [
      231,
      74,
      743,
      1738,
      862,
      193,
      4698,
      345,
      4040,
      2828,
      8,
      1112,
      1229,
      6416,
      673,
      6076,
      137,
      3604,
      49,
      6417,
      3594,
      4046,
      70,
      57,
      239,
      410,
      71,
      2408,
      1238,
      1586,
      413
    ],
  ),
  "contrast_rtl_off": SymbolsMetadata(
    popularity: 5,
    codepoint: 0xec72,
    categories: [1],
    tags: [
      858,
      860,
      1738,
      6411,
      3726,
      3590,
      6323,
      193,
      4698,
      345,
      4704,
      2580,
      867,
      8,
      1229,
      673,
      487,
      1033,
      83,
      6415,
      6333,
      49,
      2499,
      6418,
      87,
      635,
      623,
      1035,
      1036,
      1037,
      70,
      59,
      62,
      4793,
      6419,
      5655,
      410,
      71,
      1041,
      4699,
      413,
      396,
      476,
      832
    ],
  ),
  "contrast_square": SymbolsMetadata(
    popularity: 4,
    codepoint: 0xf4a0,
    categories: [1],
    tags: [
      231,
      72,
      743,
      1738,
      862,
      4543,
      481,
      482,
      3590,
      4698,
      345,
      4040,
      2828,
      3601,
      8,
      6414,
      1229,
      6416,
      673,
      1140,
      6076,
      4269,
      3604,
      6417,
      3594,
      635,
      70,
      6420,
      239,
      358,
      1127,
      71,
      392,
      2408,
      433,
      1238,
      2409,
      4699,
      413,
      396
    ],
  ),
  "control_camera": SymbolsMetadata(
    popularity: 340,
    codepoint: 0xe074,
    categories: [0],
    tags: [
      1738,
      6421,
      77,
      502,
      40,
      42,
      308,
      193,
      573,
      345,
      288,
      313,
      46,
      346,
      1894,
      2216,
      53,
      406,
      586,
      439,
      70,
      57,
      59,
      912,
      453,
      432,
      2951,
      907,
      71,
      1752,
      1325,
      433,
      65,
      511,
      37,
      5081
    ],
  ),
  "control_point_duplicate": SymbolsMetadata(
    popularity: 622,
    codepoint: 0xe3bb,
    categories: [1],
    tags: [
      231,
      743,
      6422,
      1614,
      3000,
      4628,
      193,
      6423,
      621,
      345,
      6424,
      1724,
      6425,
      1302,
      1567,
      3001,
      3626,
      1954,
      147,
      381,
      1356,
      6426,
      4888,
      6427,
      2162,
      886,
      1574,
      239,
      328,
      6342,
      31,
      394
    ],
  ),
  "controller_gen": SymbolsMetadata(
    popularity: 243,
    codepoint: 0xe83d,
    categories: [8],
    tags: [
      2088,
      504,
      1075,
      193,
      519,
      6428,
      345,
      6429,
      1213,
      6430,
      288,
      2293,
      779,
      5371,
      6431,
      6432,
      1087,
      6433,
      1975,
      1119,
      70,
      4251,
      2500,
      432,
      6434,
      6435,
      362,
      433,
      2218,
      65,
      1718,
      6436,
      6437
    ],
  ),
  "conversion_path": SymbolsMetadata(
    popularity: 2914,
    codepoint: 0xf0c1,
    categories: [9],
    tags: [
      1787,
      1402,
      1045,
      3290,
      919,
      373,
      4255,
      1792,
      6438,
      6439,
      1405,
      81,
      375,
      1081,
      1051,
      6440,
      1052,
      2455,
      1617,
      87,
      1159,
      1060,
      1619,
      641,
      1065,
      5548,
      1408,
      4620,
      6441,
      94,
      3753,
      5716,
      1070,
      6442,
      514
    ],
  ),
  "conversion_path_off": SymbolsMetadata(
    popularity: 27,
    codepoint: 0xf7b4,
    categories: [9],
    tags: [
      1787,
      1045,
      77,
      3290,
      3726,
      6443,
      373,
      4255,
      1049,
      1792,
      6444,
      81,
      6445,
      6446,
      375,
      867,
      6447,
      3247,
      6448,
      6449,
      1081,
      1033,
      2207,
      1190,
      1051,
      1052,
      1200,
      87,
      6450,
      6451,
      6452,
      1035,
      1036,
      1037,
      1619,
      6453,
      848,
      1041,
      1203,
      1070,
      4299
    ],
  ),
  "convert_to_text": SymbolsMetadata(
    popularity: 44,
    codepoint: 0xf41f,
    categories: [12],
    tags: [
      6454,
      77,
      2432,
      2397,
      5,
      621,
      6455,
      81,
      313,
      1566,
      1567,
      6456,
      2778,
      3261,
      147,
      6457,
      6458,
      370,
      6459,
      902,
      6202,
      1636,
      1732,
      1574,
      1575,
      3020,
      2352,
      3036,
      179,
      907,
      1104,
      735,
      6460,
      2409,
      1204,
      33,
      6461,
      6462,
      526,
      512,
      35,
      6463,
      1465
    ],
  ),
  "conveyor_belt": SymbolsMetadata(
    popularity: 137,
    codepoint: 0xf867,
    categories: [9],
    tags: [
      5737,
      3179,
      1890,
      6464,
      6465,
      6466,
      6467,
      46,
      6468,
      6469,
      1051,
      4904,
      4871,
      3415,
      87,
      6470,
      2054,
      4872,
      6471,
      5742,
      6472,
      6473,
      468,
      2242,
      1065,
      674,
      6474,
      5488,
      5561,
      1068,
      1848
    ],
  ),
  "cookie": SymbolsMetadata(
    popularity: 2217,
    codepoint: 0xeaac,
    categories: [3],
    tags: [
      1339,
      3647,
      6475,
      6476,
      193,
      6477,
      462,
      3153,
      5597,
      6478,
      6479,
      6480,
      81,
      3657,
      6481,
      2370,
      6482,
      609,
      70,
      912,
      1009,
      6483,
      330,
      71,
      3668,
      3669,
      1070,
      3670,
      6484,
      6485
    ],
  ),
  "cookie_off": SymbolsMetadata(
    popularity: 82,
    codepoint: 0xf79a,
    categories: [3],
    tags: [
      6475,
      481,
      4774,
      193,
      5597,
      6478,
      6479,
      81,
      5030,
      1031,
      3657,
      1138,
      44,
      867,
      1033,
      259,
      1035,
      1036,
      1037,
      1219,
      1009,
      6217,
      4221,
      1039,
      1011,
      71,
      1041,
      1070,
      6484,
      333,
      1164,
      3712
    ],
  ),
  "cooking": SymbolsMetadata(
    popularity: 1097,
    codepoint: 0xe2b6,
    categories: [8],
    tags: [
      6486,
      6487,
      6488,
      5688,
      4174,
      6489,
      4175,
      6490,
      6491,
      3656,
      4177,
      3658,
      4636,
      6492,
      4807,
      6493,
      2370,
      4179,
      5695,
      6494,
      6495,
      2982,
      1116,
      1479,
      6496,
      2372,
      4183,
      3661,
      6497,
      506,
      1119,
      4344,
      3662,
      6498,
      6020,
      2969,
      5699,
      3665,
      6499,
      3784,
      6500,
      6501,
      6502
    ],
  ),
  "cool_to_dry": SymbolsMetadata(
    popularity: 207,
    codepoint: 0xe276,
    categories: [10],
    tags: [
      1738,
      834,
      835,
      77,
      2397,
      837,
      5250,
      345,
      841,
      6503,
      751,
      313,
      2778,
      6504,
      3414,
      3641,
      1906,
      1116,
      6505,
      1860,
      138,
      635,
      1119,
      3645,
      151,
      1899,
      2409,
      1068,
      855,
      2085,
      1696,
      1865,
      856
    ],
  ),
  "copy_all": SymbolsMetadata(
    popularity: 1134,
    codepoint: 0xe2ec,
    categories: [12],
    tags: [
      2302,
      6423,
      621,
      1724,
      6506,
      6339,
      2399,
      752,
      81,
      1566,
      1567,
      3762,
      3626,
      147,
      1677,
      1056,
      2162,
      5071,
      1574,
      1575,
      4771,
      2759,
      6342,
      6507,
      6508,
      6509,
      594,
      33
    ],
  ),
  "copyright": SymbolsMetadata(
    popularity: 2517,
    codepoint: 0xe90c,
    categories: [9],
    tags: [
      2430,
      4,
      3290,
      2484,
      6510,
      5,
      193,
      3292,
      926,
      6511,
      3477,
      12,
      172,
      969,
      6512,
      52,
      2438,
      6513,
      16,
      6514,
      2466,
      1143,
      1160,
      6515,
      3298,
      1480,
      696,
      6516,
      3300,
      3301,
      5627,
      2647,
      6517,
      31,
      33
    ],
  ),
  "coronavirus": SymbolsMetadata(
    popularity: 2425,
    codepoint: 0xf221,
    categories: [3],
    tags: [
      214,
      5949,
      2380,
      4347,
      4131,
      1342,
      462,
      685,
      686,
      687,
      1345,
      2382,
      6518,
      2383,
      5810,
      692,
      2384,
      2385,
      895,
      2386,
      6519,
      5961,
      6520,
      694,
      6521,
      330,
      4147,
      6522,
      2389,
      705,
      6523,
      2392,
      206
    ],
  ),
  "corporate_fare": SymbolsMetadata(
    popularity: 3766,
    codepoint: 0xf1d0,
    categories: [9],
    tags: [
      480,
      1476,
      916,
      918,
      919,
      2544,
      1365,
      1366,
      2547,
      6524,
      931,
      2296,
      934,
      137,
      4912,
      138,
      935,
      3680,
      87,
      1372,
      1063,
      327,
      2550,
      1481,
      432,
      1482,
      1483,
      392,
      1484,
      2551,
      979,
      945,
      31,
      2552,
      1486
    ],
  ),
  "cottage": SymbolsMetadata(
    popularity: 3597,
    codepoint: 0xe587,
    categories: [16],
    tags: [
      5451,
      1475,
      1476,
      3992,
      918,
      1918,
      4879,
      5535,
      4924,
      1478,
      5536,
      2547,
      1116,
      1479,
      2548,
      6525,
      5537,
      6526,
      1520,
      327,
      1480,
      2550,
      432,
      1482,
      1483,
      4883,
      1838,
      1484,
      4884,
      4885,
      433,
      3699,
      945,
      4886,
      1718,
      6527,
      4691,
      1165
    ],
  ),
  "counter_0": SymbolsMetadata(
    popularity: 44,
    codepoint: 0xf785,
    categories: [12],
    tags: [
      4732,
      1045,
      2213,
      193,
      80,
      224,
      81,
      7,
      809,
      225,
      51,
      6528,
      6529,
      17,
      6530,
      817,
      21,
      22,
      23,
      818,
      26,
      203,
      228,
      2218,
      744,
      31,
      6531,
      36,
      3646,
      6532
    ],
  ),
  "counter_1": SymbolsMetadata(
    popularity: 768,
    codepoint: 0xf784,
    categories: [12],
    tags: [
      72,
      193,
      80,
      6533,
      7,
      6534,
      1922,
      172,
      173,
      51,
      6535,
      6536,
      6529,
      174,
      17,
      18,
      21,
      6537,
      22,
      149,
      178,
      6538,
      329,
      6539,
      228,
      3544,
      291,
      31,
      6531,
      36
    ],
  ),
  "counter_2": SymbolsMetadata(
    popularity: 356,
    codepoint: 0xf783,
    categories: [12],
    tags: [
      74,
      1339,
      223,
      281,
      193,
      462,
      80,
      224,
      7,
      173,
      790,
      6529,
      17,
      609,
      21,
      6540,
      6541,
      22,
      149,
      69,
      329,
      757,
      26,
      3636,
      203,
      228,
      6119,
      291,
      2878,
      31,
      394,
      36
    ],
  ),
  "counter_3": SymbolsMetadata(
    popularity: 280,
    codepoint: 0xf782,
    categories: [12],
    tags: [
      75,
      223,
      789,
      193,
      80,
      224,
      7,
      8,
      6542,
      225,
      173,
      6529,
      17,
      18,
      21,
      22,
      149,
      69,
      329,
      26,
      3636,
      203,
      228,
      229,
      31,
      6531,
      551,
      230,
      36
    ],
  ),
  "counter_4": SymbolsMetadata(
    popularity: 158,
    codepoint: 0xf781,
    categories: [12],
    tags: [
      624,
      223,
      193,
      80,
      224,
      169,
      81,
      7,
      6543,
      627,
      173,
      68,
      6544,
      6529,
      21,
      6545,
      6546,
      22,
      69,
      23,
      329,
      757,
      2510,
      26,
      793,
      228,
      6547,
      229,
      31,
      6531,
      230,
      36
    ],
  ),
  "counter_5": SymbolsMetadata(
    popularity: 102,
    codepoint: 0xf780,
    categories: [12],
    tags: [
      669,
      223,
      789,
      193,
      80,
      224,
      81,
      7,
      8,
      225,
      660,
      51,
      1356,
      790,
      6529,
      17,
      21,
      6548,
      22,
      149,
      69,
      329,
      757,
      26,
      227,
      228,
      6119,
      744,
      2878,
      31,
      6531,
      36,
      554
    ],
  ),
  "counter_6": SymbolsMetadata(
    popularity: 57,
    codepoint: 0xf77f,
    categories: [12],
    tags: [
      680,
      223,
      193,
      80,
      224,
      6549,
      81,
      7,
      6542,
      225,
      4118,
      1356,
      88,
      6529,
      17,
      18,
      21,
      6550,
      176,
      22,
      23,
      91,
      329,
      26,
      3636,
      94,
      3891,
      6551,
      6552,
      229,
      31,
      6531,
      230,
      36,
      554
    ],
  ),
  "counter_7": SymbolsMetadata(
    popularity: 46,
    codepoint: 0xf77e,
    categories: [12],
    tags: [
      745,
      193,
      80,
      6553,
      224,
      6554,
      7,
      6555,
      225,
      6556,
      51,
      52,
      6529,
      174,
      6378,
      21,
      6557,
      22,
      149,
      6558,
      69,
      26,
      6559,
      228,
      6560,
      180,
      31,
      6561,
      36,
      6562
    ],
  ),
  "counter_8": SymbolsMetadata(
    popularity: 33,
    codepoint: 0xf77d,
    categories: [12],
    tags: [
      781,
      223,
      1288,
      1299,
      193,
      80,
      224,
      81,
      7,
      8,
      6563,
      225,
      4118,
      51,
      68,
      1087,
      6529,
      791,
      6564,
      21,
      22,
      149,
      6565,
      1732,
      26,
      228,
      392,
      229,
      31,
      6531,
      230,
      141,
      36,
      333
    ],
  ),
  "counter_9": SymbolsMetadata(
    popularity: 37,
    codepoint: 0xf77c,
    categories: [12],
    tags: [
      794,
      281,
      193,
      80,
      6566,
      224,
      6567,
      7,
      8,
      225,
      51,
      6568,
      6529,
      17,
      18,
      800,
      6569,
      21,
      22,
      149,
      23,
      757,
      26,
      3636,
      203,
      228,
      6570,
      229,
      31,
      6531,
      230,
      36,
      6571
    ],
  ),
  "countertops": SymbolsMetadata(
    popularity: 482,
    codepoint: 0xf1f7,
    categories: [8],
    tags: [
      480,
      3499,
      481,
      918,
      1157,
      1477,
      224,
      6572,
      6573,
      3547,
      379,
      4008,
      1116,
      581,
      1479,
      6574,
      4183,
      6575,
      87,
      4161,
      289,
      387,
      6289,
      1483,
      1884,
      392,
      1317,
      5819,
      6576,
      979,
      4689,
      393,
      1453,
      6577,
      4927
    ],
  ),
  "create_new_folder": SymbolsMetadata(
    popularity: 3954,
    codepoint: 0xe2cc,
    categories: [2],
    tags: [
      231,
      743,
      232,
      2154,
      1354,
      1175,
      621,
      1302,
      81,
      4769,
      1566,
      1567,
      1675,
      147,
      2161,
      1329,
      1176,
      1323,
      4975,
      1004,
      886,
      1063,
      239,
      1714,
      432,
      1683,
      1576,
      2797,
      1685,
      31,
      4434
    ],
  ),
  "credit_card": SymbolsMetadata(
    popularity: 14667,
    codepoint: 0xe870,
    categories: [9],
    tags: [
      565,
      1015,
      6578,
      914,
      915,
      916,
      917,
      1643,
      920,
      921,
      1397,
      4908,
      922,
      924,
      1398,
      926,
      951,
      927,
      2341,
      928,
      1646,
      931,
      932,
      6579,
      6317,
      938,
      523,
      940,
      941,
      6580,
      1401,
      1653,
      432,
      1022,
      1376,
      962,
      3733,
      31,
      946,
      6322,
      963
    ],
  ),
  "credit_card_clock": SymbolsMetadata(
    popularity: 49,
    codepoint: 0xf438,
    categories: [9],
    tags: [
      565,
      6581,
      917,
      6582,
      920,
      921,
      193,
      1135,
      922,
      924,
      1398,
      926,
      951,
      927,
      1136,
      2139,
      2341,
      928,
      3353,
      931,
      2757,
      87,
      6317,
      938,
      523,
      91,
      940,
      6583,
      6584,
      941,
      2569,
      328,
      1144,
      1401,
      756,
      1653,
      4781,
      432,
      1145,
      1022,
      1376,
      31,
      1148,
      946,
      6322,
      963,
      2102
    ],
  ),
  "credit_card_gear": SymbolsMetadata(
    popularity: 31,
    codepoint: 0xf52d,
    categories: [9],
    tags: [
      565,
      862,
      501,
      915,
      916,
      917,
      920,
      921,
      2397,
      922,
      924,
      678,
      345,
      1398,
      926,
      951,
      927,
      3565,
      145,
      928,
      1229,
      931,
      955,
      932,
      1780,
      293,
      68,
      2094,
      938,
      523,
      70,
      940,
      941,
      1400,
      911,
      912,
      1401,
      756,
      645,
      71,
      1752,
      1376,
      31,
      1296,
      946
    ],
  ),
  "credit_card_heart": SymbolsMetadata(
    popularity: 54,
    codepoint: 0xf52c,
    categories: [9],
    tags: [
      565,
      916,
      917,
      920,
      921,
      922,
      924,
      1398,
      926,
      951,
      927,
      928,
      3194,
      931,
      932,
      137,
      4229,
      1604,
      6585,
      4461,
      5350,
      938,
      523,
      940,
      941,
      6586,
      1401,
      1653,
      432,
      4063,
      6587,
      1683,
      6588,
      392,
      1376,
      433,
      31,
      946,
      6589,
      963
    ],
  ),
  "credit_card_off": SymbolsMetadata(
    popularity: 769,
    codepoint: 0xe4f4,
    categories: [9],
    tags: [
      916,
      917,
      3726,
      2692,
      6323,
      920,
      921,
      922,
      924,
      1398,
      926,
      951,
      927,
      2027,
      5030,
      867,
      928,
      1033,
      2694,
      2695,
      931,
      932,
      1191,
      4118,
      138,
      5153,
      87,
      938,
      2588,
      1035,
      523,
      289,
      940,
      941,
      6590,
      1401,
      432,
      6591,
      1970,
      392,
      1376,
      1041,
      1203,
      31,
      1042
    ],
  ),
  "credit_score": SymbolsMetadata(
    popularity: 3080,
    codepoint: 0xeff1,
    categories: [9],
    tags: [
      1402,
      1658,
      2454,
      916,
      917,
      920,
      921,
      1660,
      193,
      922,
      924,
      463,
      1398,
      926,
      6592,
      927,
      6593,
      1381,
      45,
      928,
      2342,
      3192,
      6594,
      931,
      932,
      3827,
      51,
      790,
      937,
      1143,
      17,
      3463,
      938,
      21,
      23,
      1663,
      523,
      940,
      941,
      641,
      5626,
      757,
      793,
      203,
      1408,
      228,
      362,
      3039,
      31,
      6595,
      1665,
      2355,
      1562,
      1668
    ],
  ),
  "crib": SymbolsMetadata(
    popularity: 496,
    codepoint: 0xe588,
    categories: [8],
    tags: [
      3497,
      3498,
      6596,
      1310,
      6597,
      1915,
      4004,
      482,
      984,
      6598,
      987,
      4021,
      4022,
      378,
      4008,
      3505,
      6599,
      991,
      584,
      812,
      3509,
      3510,
      492,
      289,
      432,
      978,
      1317,
      1935,
      1936,
      433,
      1147,
      3517
    ],
  ),
  "crisis_alert": SymbolsMetadata(
    popularity: 2311,
    codepoint: 0xebe9,
    categories: [5],
    tags: [
      3074,
      2420,
      1338,
      1339,
      1340,
      6600,
      1342,
      283,
      4365,
      3076,
      1345,
      4369,
      2423,
      2694,
      1346,
      4118,
      4373,
      138,
      1347,
      3078,
      1143,
      585,
      609,
      3081,
      1011,
      392,
      273,
      2137,
      31,
      1204,
      4379,
      1718,
      2428,
      206
    ],
  ),
  "crop": SymbolsMetadata(
    popularity: 1414,
    codepoint: 0xe3be,
    categories: [1],
    tags: [
      1738,
      862,
      1107,
      6601,
      1108,
      1109,
      1503,
      621,
      1820,
      6339,
      4529,
      1567,
      1229,
      673,
      346,
      348,
      137,
      49,
      2499,
      6117,
      1636,
      57,
      4792,
      62,
      432,
      2243,
      363,
      71,
      298,
      433,
      511,
      512,
      6349,
      37,
      6602
    ],
  ),
  "crop_16_9": SymbolsMetadata(
    popularity: 583,
    codepoint: 0xe3bc,
    categories: [1],
    tags: [
      153,
      6603,
      794,
      1738,
      6604,
      862,
      1107,
      626,
      6605,
      1820,
      377,
      1229,
      673,
      2172,
      370,
      348,
      6606,
      137,
      49,
      3577,
      2499,
      1583,
      354,
      57,
      3579,
      4792,
      62,
      3054,
      432,
      2243,
      71,
      6607,
      298,
      433,
      6608,
      37,
      364,
      6609,
      6610,
      3057
    ],
  ),
  "crop_3_2": SymbolsMetadata(
    popularity: 312,
    codepoint: 0xe3bd,
    categories: [1],
    tags: [
      74,
      75,
      6611,
      6612,
      6613,
      1738,
      862,
      1107,
      626,
      6605,
      1820,
      377,
      1229,
      673,
      370,
      348,
      6606,
      383,
      581,
      49,
      3577,
      2499,
      1583,
      406,
      6614,
      57,
      3579,
      1324,
      4792,
      62,
      3054,
      432,
      2243,
      391,
      71,
      298,
      433,
      6615,
      397
    ],
  ),
  "crop_5_4": SymbolsMetadata(
    popularity: 330,
    codepoint: 0xe3bf,
    categories: [1],
    tags: [
      624,
      669,
      6616,
      1738,
      862,
      1107,
      626,
      1108,
      1109,
      6605,
      1820,
      486,
      1229,
      6617,
      6618,
      6619,
      370,
      348,
      6606,
      137,
      49,
      3577,
      2499,
      406,
      1636,
      289,
      57,
      3579,
      4792,
      62,
      3055,
      432,
      2243,
      392,
      298,
      433,
      512,
      6349,
      37,
      364
    ],
  ),
  "crop_7_5": SymbolsMetadata(
    popularity: 461,
    codepoint: 0xe3c0,
    categories: [1],
    tags: [
      669,
      745,
      6620,
      1738,
      862,
      1107,
      1580,
      626,
      6621,
      6605,
      1820,
      1229,
      673,
      2172,
      348,
      137,
      581,
      49,
      2499,
      1583,
      406,
      57,
      59,
      4792,
      62,
      432,
      2243,
      363,
      71,
      6622,
      392,
      298,
      433,
      511,
      2529
    ],
  ),
  "crop_9_16": SymbolsMetadata(
    popularity: 42,
    codepoint: 0xf549,
    categories: [1],
    tags: [
      153,
      794,
      6623,
      1738,
      862,
      1107,
      3053,
      626,
      6605,
      1820,
      377,
      1229,
      673,
      370,
      348,
      6606,
      49,
      2499,
      1636,
      6624,
      507,
      57,
      59,
      4792,
      62,
      974,
      3054,
      432,
      2243,
      470,
      71,
      392,
      298,
      433,
      512,
      1445,
      37
    ],
  ),
  "crop_free": SymbolsMetadata(
    popularity: 1690,
    codepoint: 0xe3c2,
    categories: [1],
    tags: [
      1738,
      862,
      1107,
      6621,
      482,
      3008,
      1820,
      6625,
      8,
      1229,
      673,
      2359,
      6626,
      5903,
      1303,
      1746,
      348,
      6627,
      6628,
      1691,
      49,
      584,
      2360,
      289,
      57,
      4792,
      62,
      2243,
      362,
      363,
      71,
      298,
      433,
      141,
      2356
    ],
  ),
  "crop_landscape": SymbolsMetadata(
    popularity: 361,
    codepoint: 0xe3c3,
    categories: [1],
    tags: [
      1738,
      862,
      1107,
      626,
      1108,
      1820,
      6629,
      377,
      1229,
      6630,
      673,
      348,
      6606,
      581,
      49,
      3577,
      2499,
      1583,
      6631,
      406,
      6632,
      1636,
      507,
      289,
      57,
      3579,
      4792,
      62,
      6633,
      432,
      2447,
      6634,
      2243,
      71,
      392,
      298,
      511,
      476,
      6635,
      6610
    ],
  ),
  "crop_portrait": SymbolsMetadata(
    popularity: 466,
    codepoint: 0xe3c5,
    categories: [1],
    tags: [
      1738,
      862,
      1107,
      626,
      1820,
      377,
      1229,
      673,
      2172,
      370,
      348,
      6606,
      49,
      2499,
      406,
      1636,
      57,
      59,
      4792,
      62,
      974,
      432,
      6634,
      2243,
      71,
      392,
      298,
      433,
      511
    ],
  ),
  "crop_rotate": SymbolsMetadata(
    popularity: 326,
    codepoint: 0xe437,
    categories: [1],
    tags: [
      1738,
      862,
      1107,
      77,
      502,
      626,
      6636,
      193,
      5300,
      3008,
      6637,
      1820,
      313,
      1229,
      673,
      348,
      137,
      49,
      2499,
      2935,
      1636,
      507,
      57,
      4792,
      62,
      4613,
      6638,
      2243,
      470,
      71,
      298,
      433,
      511,
      512,
      473,
      476
    ],
  ),
  "crop_square": SymbolsMetadata(
    popularity: 2007,
    codepoint: 0xe3c6,
    categories: [1],
    tags: [
      1738,
      862,
      1288,
      501,
      1107,
      5231,
      626,
      1108,
      1109,
      2675,
      2434,
      1820,
      6339,
      485,
      1229,
      673,
      2172,
      1303,
      1313,
      348,
      6606,
      1142,
      49,
      2499,
      1322,
      2935,
      406,
      1636,
      2876,
      57,
      4792,
      62,
      432,
      2243,
      410,
      71,
      392,
      5479,
      2866,
      2790,
      298,
      433,
      6639,
      511,
      512,
      6349,
      141,
      1327,
      333,
      1164,
      1165
    ],
  ),
  "crossword": SymbolsMetadata(
    popularity: 104,
    codepoint: 0xf5e5,
    categories: [3],
    tags: [
      2504,
      6305,
      2284,
      5704,
      6021,
      5705,
      6640,
      6641,
      104,
      3059,
      779,
      2240,
      2741,
      5371,
      5708,
      382,
      581,
      3379,
      1975,
      16,
      6642,
      5710,
      6023,
      5714,
      4864,
      2684,
      5716,
      31,
      4833,
      1445,
      6643,
      6644,
      6645
    ],
  ),
  "crowdsource": SymbolsMetadata(
    popularity: 238,
    codepoint: 0xeb18,
    categories: [3],
    tags: [
      919,
      193,
      3191,
      4558,
      1800,
      1047,
      3910,
      284,
      6646,
      6170,
      6647,
      81,
      1081,
      6579,
      956,
      320,
      1176,
      936,
      584,
      2466,
      267,
      1062,
      2876,
      6648,
      6649,
      941,
      589,
      2057,
      1508,
      705,
      735,
      1275,
      6650,
      1206,
      6651,
      334
    ],
  ),
  "crown": SymbolsMetadata(
    popularity: 104,
    codepoint: 0xecb3,
    categories: [3],
    tags: [
      3,
      3189,
      3190,
      6652,
      5705,
      6653,
      3790,
      3447,
      4011,
      6654,
      790,
      972,
      1005,
      714,
      4018,
      3636,
      793,
      3481,
      6655,
      898,
      245,
      6656,
      1240,
      1409,
      3202,
      6261,
      5312,
      1960,
      5143,
      5352,
      3485
    ],
  ),
  "cruelty_free": SymbolsMetadata(
    popularity: 2518,
    codepoint: 0xe799,
    categories: [3],
    tags: [
      4851,
      6657,
      6658,
      6659,
      6660,
      6661,
      1759,
      6662,
      6663,
      6664,
      6212,
      6665,
      6666,
      6667,
      6627,
      6668,
      4180,
      6669,
      6670,
      6671,
      6672,
      1834,
      6673,
      6674,
      6675,
      6676,
      705,
      1846,
      2334,
      4868,
      6677,
      2378,
      2379
    ],
  ),
  "css": SymbolsMetadata(
    popularity: 1620,
    codepoint: 0xeb93,
    categories: [2],
    tags: [
      4,
      5976,
      1156,
      6678,
      5,
      1077,
      2239,
      6679,
      2486,
      2205,
      485,
      1292,
      1293,
      44,
      4876,
      2749,
      12,
      2556,
      5977,
      259,
      385,
      16,
      5982,
      2494,
      1099,
      5984,
      6165,
      6680,
      2219,
      31,
      65,
      33,
      35,
      6681,
      2210,
      2222,
      6682,
      1164
    ],
  ),
  "csv": SymbolsMetadata(
    popularity: 171,
    codepoint: 0xe6cf,
    categories: [12],
    tags: [
      4,
      1402,
      5,
      2239,
      6683,
      6684,
      6685,
      6686,
      81,
      6687,
      6688,
      1448,
      1567,
      2435,
      520,
      1690,
      147,
      6458,
      12,
      370,
      1582,
      68,
      16,
      88,
      6689,
      1099,
      1408,
      6690,
      1441,
      6691,
      744,
      31,
      6692,
      6693,
      33,
      3024,
      6694,
      35,
      527,
      6695
    ],
  ),
  "currency_bitcoin": SymbolsMetadata(
    popularity: 1931,
    codepoint: 0xebc5,
    categories: [9],
    tags: [
      917,
      6696,
      6697,
      920,
      921,
      193,
      922,
      924,
      1398,
      926,
      6698,
      6699,
      927,
      44,
      6700,
      6701,
      6702,
      928,
      5192,
      931,
      6703,
      6704,
      936,
      6705,
      938,
      523,
      6706,
      6707,
      940,
      941,
      1401,
      1376,
      3582,
      31,
      5197,
      1309,
      6708,
      948
    ],
  ),
  "currency_exchange": SymbolsMetadata(
    popularity: 6010,
    codepoint: 0xeb70,
    categories: [9],
    tags: [
      458,
      460,
      77,
      502,
      916,
      1643,
      921,
      922,
      924,
      1792,
      6455,
      927,
      6709,
      313,
      6702,
      928,
      954,
      6710,
      3261,
      931,
      932,
      6711,
      6712,
      3431,
      6713,
      936,
      3087,
      938,
      6714,
      940,
      941,
      6715,
      2441,
      1694,
      470,
      3266,
      3584,
      762,
      4922,
      946,
      526,
      473,
      879,
      6716
    ],
  ),
  "currency_franc": SymbolsMetadata(
    popularity: 246,
    codepoint: 0xeafa,
    categories: [9],
    tags: [
      916,
      917,
      950,
      6717,
      920,
      921,
      922,
      924,
      1398,
      926,
      927,
      6702,
      928,
      929,
      6710,
      3261,
      931,
      932,
      6718,
      6704,
      319,
      3262,
      322,
      936,
      1370,
      6719,
      938,
      523,
      940,
      941,
      1401,
      944,
      1376,
      6720,
      31,
      4922,
      946,
      36,
      948
    ],
  ),
  "currency_lira": SymbolsMetadata(
    popularity: 338,
    codepoint: 0xeaef,
    categories: [9],
    tags: [
      1403,
      917,
      1643,
      6721,
      920,
      921,
      922,
      924,
      1398,
      926,
      927,
      6702,
      928,
      929,
      954,
      3261,
      931,
      932,
      6722,
      6723,
      6724,
      15,
      584,
      6725,
      938,
      523,
      940,
      941,
      1401,
      3266,
      1376,
      594,
      595,
      31,
      6726,
      97,
      6727,
      946,
      6728,
      36
    ],
  ),
  "currency_pound": SymbolsMetadata(
    popularity: 1035,
    codepoint: 0xeaf1,
    categories: [9],
    tags: [
      913,
      4,
      916,
      917,
      6729,
      950,
      920,
      921,
      922,
      924,
      1398,
      926,
      927,
      6702,
      928,
      5192,
      3261,
      931,
      932,
      6730,
      6731,
      15,
      938,
      523,
      940,
      941,
      6715,
      1401,
      1376,
      1162,
      6732,
      31,
      946,
      338,
      6733,
      36,
      948
    ],
  ),
  "currency_ruble": SymbolsMetadata(
    popularity: 614,
    codepoint: 0xeaec,
    categories: [9],
    tags: [
      916,
      917,
      1396,
      950,
      919,
      920,
      921,
      5,
      922,
      924,
      1398,
      926,
      927,
      6702,
      928,
      954,
      3261,
      6734,
      931,
      932,
      6711,
      15,
      938,
      523,
      940,
      941,
      6735,
      1401,
      2620,
      1653,
      359,
      6736,
      6737,
      6738,
      6739,
      1376,
      31,
      4922,
      946
    ],
  ),
  "currency_rupee": SymbolsMetadata(
    popularity: 3415,
    codepoint: 0xeaf7,
    categories: [9],
    tags: [
      915,
      916,
      917,
      1643,
      920,
      921,
      922,
      924,
      1398,
      926,
      927,
      6702,
      928,
      929,
      954,
      931,
      932,
      6740,
      6741,
      6742,
      6743,
      936,
      1370,
      938,
      523,
      940,
      941,
      1401,
      1653,
      6744,
      3266,
      1375,
      1376,
      1377,
      31,
      946,
      948
    ],
  ),
  "currency_rupee_circle": SymbolsMetadata(
    popularity: 61,
    codepoint: 0xf460,
    categories: [9],
    tags: [
      916,
      917,
      950,
      919,
      920,
      921,
      193,
      922,
      924,
      1398,
      926,
      927,
      6709,
      6745,
      6702,
      928,
      5192,
      3261,
      6746,
      931,
      932,
      6747,
      3262,
      6748,
      6743,
      936,
      938,
      523,
      940,
      941,
      1401,
      6744,
      944,
      1376,
      31,
      946,
      36,
      948
    ],
  ),
  "currency_yen": SymbolsMetadata(
    popularity: 1066,
    codepoint: 0xeafb,
    categories: [9],
    tags: [
      915,
      916,
      917,
      6717,
      920,
      921,
      922,
      924,
      1398,
      926,
      927,
      6702,
      928,
      929,
      3261,
      931,
      932,
      3262,
      6749,
      6750,
      938,
      523,
      940,
      941,
      1401,
      359,
      1376,
      1162,
      31,
      946,
      36,
      948,
      6716
    ],
  ),
  "currency_yuan": SymbolsMetadata(
    popularity: 313,
    codepoint: 0xeaf9,
    categories: [9],
    tags: [
      916,
      917,
      919,
      1643,
      920,
      921,
      5,
      6751,
      6752,
      922,
      924,
      1398,
      926,
      927,
      6702,
      928,
      929,
      3261,
      931,
      932,
      936,
      938,
      523,
      940,
      941,
      1401,
      6753,
      6754,
      3266,
      1376,
      1162,
      31,
      33,
      4922,
      946,
      35,
      36,
      6755
    ],
  ),
  "curtains": SymbolsMetadata(
    popularity: 288,
    codepoint: 0xec1e,
    categories: [8],
    tags: [
      4004,
      4196,
      4204,
      2158,
      4197,
      6573,
      1137,
      6756,
      6757,
      10,
      2614,
      2862,
      1116,
      1479,
      2720,
      3594,
      5528,
      1119,
      2876,
      1749,
      6758,
      1009,
      1483,
      1884,
      3999,
      2022,
      1325,
      4164,
      6119,
      4001,
      2624,
      3329,
      1165,
      4202
    ],
  ),
  "curtains_closed": SymbolsMetadata(
    popularity: 147,
    codepoint: 0xec1d,
    categories: [8],
    tags: [
      2776,
      4196,
      481,
      4204,
      6759,
      2158,
      4153,
      4197,
      6760,
      6573,
      2285,
      4023,
      6756,
      2614,
      2862,
      6761,
      1116,
      1479,
      2720,
      3594,
      1119,
      1749,
      1009,
      1884,
      3999,
      4200,
      1325,
      4164,
      6762,
      4001,
      2624,
      1866,
      1165
    ],
  ),
  "custom_typography": SymbolsMetadata(
    popularity: 64,
    codepoint: 0xe732,
    categories: [12],
    tags: [
      3411,
      1738,
      4,
      4815,
      4622,
      5,
      403,
      283,
      1302,
      2737,
      4735,
      3565,
      485,
      1567,
      673,
      83,
      12,
      2173,
      137,
      969,
      385,
      16,
      70,
      2150,
      71,
      854,
      2180,
      31,
      33,
      4699,
      1296,
      1754,
      35,
      6763,
      338,
      6261,
      476,
      1465
    ],
  ),
  "cycle": SymbolsMetadata(
    popularity: 1042,
    codepoint: 0xf854,
    categories: [2],
    tags: [
      77,
      502,
      2884,
      5134,
      284,
      254,
      750,
      751,
      375,
      313,
      2323,
      1051,
      902,
      2757,
      2998,
      754,
      755,
      325,
      6764,
      1065,
      757,
      6765,
      3433,
      6216,
      758,
      6766,
      759,
      2441,
      3426,
      6767,
      6219,
      470,
      94,
      473,
      2946,
      6768,
      2949
    ],
  ),
  "cyclone": SymbolsMetadata(
    popularity: 727,
    codepoint: 0xebd5,
    categories: [3],
    tags: [
      1851,
      6769,
      837,
      4365,
      6770,
      1345,
      4368,
      4369,
      2423,
      1823,
      6771,
      6772,
      4373,
      6773,
      5856,
      1833,
      6774,
      1834,
      3645,
      6775,
      5927,
      6776,
      6777,
      6778,
      4355,
      1863,
      6779,
      6780,
      6781,
      6782,
      206,
      2480,
      856,
      6783,
      1868,
      6784
    ],
  ),
  "dangerous": SymbolsMetadata(
    popularity: 3352,
    codepoint: 0xe99a,
    categories: [6],
    tags: [
      6785,
      1339,
      1340,
      6786,
      2692,
      1342,
      3076,
      1345,
      5241,
      2694,
      1346,
      1745,
      4451,
      1191,
      3363,
      4373,
      1347,
      3078,
      1143,
      3254,
      1460,
      609,
      328,
      2796,
      3081,
      1970,
      4376,
      637,
      1162,
      1203,
      31,
      1718,
      890,
      2428,
      206,
      6787,
      5908,
      3712
    ],
  ),
  "dark_mode": SymbolsMetadata(
    popularity: 11884,
    codepoint: 0xe51c,
    categories: [4],
    tags: [
      860,
      6788,
      1288,
      4543,
      501,
      2704,
      4005,
      193,
      1921,
      4698,
      4053,
      3565,
      4040,
      4704,
      4205,
      288,
      8,
      1140,
      4041,
      6789,
      137,
      1322,
      4701,
      635,
      4046,
      4015,
      4687,
      1008,
      71,
      392,
      2128,
      2409,
      4699,
      413,
      141,
      1327,
      396,
      476,
      1164
    ],
  ),
  "dashboard": SymbolsMetadata(
    popularity: 16610,
    codepoint: 0xe871,
    categories: [12],
    tags: [
      1756,
      1045,
      5368,
      373,
      193,
      345,
      1405,
      81,
      1381,
      8,
      370,
      3827,
      1052,
      382,
      51,
      385,
      1004,
      17,
      3463,
      1060,
      623,
      6197,
      5018,
      1749,
      641,
      1144,
      757,
      432,
      1408,
      330,
      5479,
      275,
      6790,
      433,
      744,
      3039,
      6791,
      396,
      333,
      1164
    ],
  ),
  "dashboard_2": SymbolsMetadata(
    popularity: 49,
    codepoint: 0xf3ea,
    categories: [12],
    tags: [
      1402,
      1045,
      919,
      5368,
      373,
      1405,
      81,
      370,
      1052,
      382,
      1116,
      68,
      2456,
      1322,
      385,
      6792,
      1060,
      4072,
      5018,
      1749,
      641,
      432,
      3338,
      1408,
      410,
      2449,
      5479,
      433,
      2684,
      6793,
      744,
      3039,
      4075,
      396,
      333,
      1164
    ],
  ),
  "dashboard_customize": SymbolsMetadata(
    popularity: 2570,
    codepoint: 0xe99b,
    categories: [12],
    tags: [
      1738,
      76,
      2284,
      6088,
      5368,
      2397,
      573,
      345,
      574,
      1405,
      1229,
      370,
      382,
      385,
      1004,
      1636,
      4072,
      70,
      92,
      1749,
      1751,
      912,
      432,
      6794,
      71,
      1752,
      5479,
      433,
      2684,
      6795,
      4075,
      396,
      333,
      1164,
      6796
    ],
  ),
  "data_alert": SymbolsMetadata(
    popularity: 186,
    codepoint: 0xf7f6,
    categories: [2],
    tags: [
      3074,
      1339,
      1045,
      1340,
      1342,
      1345,
      81,
      6797,
      1448,
      1567,
      2694,
      1346,
      4659,
      147,
      1347,
      51,
      68,
      3078,
      88,
      6798,
      1143,
      585,
      267,
      609,
      1009,
      3081,
      4772,
      1011,
      291,
      1685,
      31,
      1068,
      1718,
      206
    ],
  ),
  "data_array": SymbolsMetadata(
    popularity: 534,
    codepoint: 0xead1,
    categories: [12],
    tags: [
      6799,
      481,
      5976,
      1077,
      6800,
      2239,
      1175,
      519,
      81,
      6801,
      1293,
      1080,
      44,
      1567,
      147,
      1177,
      1054,
      68,
      6802,
      88,
      1063,
      6803,
      1099,
      3022,
      509,
      6804,
      945,
      6805,
      140,
      65
    ],
  ),
  "data_check": SymbolsMetadata(
    popularity: 299,
    codepoint: 0xf7f2,
    categories: [2],
    tags: [
      2629,
      1402,
      1045,
      1658,
      2653,
      919,
      373,
      1660,
      2113,
      463,
      519,
      2637,
      2340,
      81,
      1448,
      44,
      1567,
      2342,
      147,
      1052,
      68,
      88,
      6798,
      1004,
      1143,
      1663,
      453,
      1408,
      362,
      1441,
      744,
      245,
      65,
      1665,
      2648,
      2355,
      1562,
      1668
    ],
  ),
  "data_exploration": SymbolsMetadata(
    popularity: 1560,
    codepoint: 0xe76f,
    categories: [9],
    tags: [
      1402,
      1045,
      77,
      6806,
      6807,
      373,
      2885,
      1405,
      81,
      6808,
      4337,
      375,
      314,
      5145,
      316,
      1052,
      234,
      235,
      1055,
      68,
      6030,
      2344,
      3379,
      87,
      1406,
      226,
      1060,
      1408,
      3385,
      744,
      3387,
      1070,
      2458,
      514
    ],
  ),
  "data_info_alert": SymbolsMetadata(
    popularity: 129,
    codepoint: 0xf7f5,
    categories: [2],
    tags: [
      1339,
      1045,
      1154,
      865,
      4852,
      1342,
      2486,
      1345,
      81,
      1448,
      145,
      2694,
      1346,
      1677,
      873,
      5065,
      293,
      68,
      3078,
      6802,
      88,
      6798,
      3470,
      267,
      609,
      1009,
      3081,
      696,
      1011,
      2971,
      645,
      1561,
      291,
      1685,
      878,
      31,
      1068,
      65,
      1718,
      206
    ],
  ),
  "data_loss_prevention": SymbolsMetadata(
    popularity: 203,
    codepoint: 0xe2dc,
    categories: [6],
    tags: [
      1028,
      565,
      1339,
      566,
      481,
      1342,
      193,
      3154,
      81,
      6809,
      6810,
      3914,
      6811,
      576,
      317,
      6812,
      1191,
      1085,
      583,
      6813,
      5309,
      1091,
      6814,
      1092,
      1093,
      6815,
      2588,
      6816,
      589,
      590,
      5816,
      1009,
      591,
      696,
      3256,
      5228,
      6817,
      3161,
      3162,
      1102,
      1022,
      1011,
      1103,
      6818,
      1561,
      597,
      206
    ],
  ),
  "data_object": SymbolsMetadata(
    popularity: 1941,
    codepoint: 0xead3,
    categories: [12],
    tags: [
      858,
      1045,
      5976,
      2755,
      1673,
      1077,
      6800,
      923,
      2486,
      81,
      6819,
      1448,
      6820,
      44,
      1567,
      2749,
      147,
      83,
      68,
      1004,
      267,
      492,
      1063,
      92,
      6803,
      2352,
      453,
      2761,
      1440,
      4147,
      2971,
      95,
      1685,
      945,
      1453,
      65
    ],
  ),
  "data_saver_on": SymbolsMetadata(
    popularity: 521,
    codepoint: 0xeff3,
    categories: [4],
    tags: [
      231,
      747,
      743,
      1045,
      77,
      516,
      6821,
      373,
      193,
      284,
      6822,
      81,
      6823,
      614,
      375,
      313,
      1033,
      320,
      1052,
      235,
      1055,
      259,
      6824,
      324,
      226,
      1060,
      263,
      267,
      6825,
      886,
      1037,
      239,
      849,
      6826,
      760,
      3897,
      944,
      331,
      744,
      31,
      1070,
      1718,
      98,
      334
    ],
  ),
  "data_table": SymbolsMetadata(
    popularity: 427,
    codepoint: 0xe99c,
    categories: [9],
    tags: [
      1045,
      1288,
      501,
      1447,
      919,
      3564,
      373,
      1419,
      923,
      2675,
      621,
      81,
      1448,
      485,
      375,
      8,
      1567,
      4776,
      147,
      931,
      382,
      68,
      1322,
      385,
      2094,
      262,
      623,
      22,
      92,
      271,
      5158,
      1408,
      1630,
      1440,
      410,
      1576,
      2790,
      1441,
      744,
      945,
      1453,
      525,
      33,
      141,
      1327,
      396,
      333,
      1164,
      1165
    ],
  ),
  "data_thresholding": SymbolsMetadata(
    popularity: 1593,
    codepoint: 0xeb9f,
    categories: [2],
    tags: [
      1402,
      373,
      678,
      1742,
      5748,
      81,
      3713,
      6827,
      6828,
      6829,
      6090,
      4839,
      6830,
      6831,
      6832,
      6833,
      6834,
      3192,
      83,
      1052,
      1199,
      1117,
      17,
      1060,
      1750,
      1009,
      1124,
      363,
      71,
      744,
      553,
      6835,
      6836,
      514
    ],
  ),
  "data_usage": SymbolsMetadata(
    popularity: 1298,
    codepoint: 0xe1af,
    categories: [4],
    tags: [
      1045,
      2579,
      6837,
      251,
      373,
      678,
      254,
      3971,
      81,
      6838,
      6839,
      614,
      5905,
      1138,
      375,
      867,
      1052,
      1055,
      259,
      550,
      4214,
      226,
      1060,
      263,
      267,
      1035,
      70,
      1970,
      151,
      5923,
      744,
      6369,
      2409,
      97,
      413,
      1070,
      3302
    ],
  ),
  "database": SymbolsMetadata(
    popularity: 13745,
    codepoint: 0xf20e,
    categories: [9],
    tags: [
      858,
      1045,
      2154,
      1403,
      517,
      373,
      1673,
      922,
      519,
      2486,
      1047,
      81,
      6840,
      1448,
      375,
      44,
      1677,
      1052,
      68,
      259,
      6802,
      2094,
      1004,
      226,
      1060,
      267,
      92,
      4088,
      2760,
      2971,
      6841,
      594,
      744,
      1685,
      1377,
      1068,
      65,
      1070
    ],
  ),
  "database_off": SymbolsMetadata(
    popularity: 20,
    codepoint: 0xf414,
    categories: [9],
    tags: [
      1028,
      1045,
      2555,
      1403,
      517,
      2692,
      1187,
      373,
      922,
      6842,
      6843,
      81,
      1448,
      6844,
      1138,
      375,
      867,
      1032,
      6845,
      1033,
      2694,
      2695,
      1052,
      68,
      1056,
      87,
      226,
      1060,
      267,
      2588,
      1035,
      1036,
      1037,
      2971,
      6846,
      1041,
      594,
      744,
      1685,
      945,
      1068,
      1070,
      1042
    ],
  ),
  "database_search": SymbolsMetadata(
    popularity: 144,
    codepoint: 0xf38e,
    categories: [9],
    tags: [
      858,
      1756,
      1045,
      2154,
      1403,
      517,
      373,
      922,
      519,
      81,
      1448,
      375,
      44,
      1567,
      316,
      83,
      317,
      6847,
      6848,
      6849,
      1085,
      1052,
      68,
      2345,
      1091,
      1092,
      1093,
      2348,
      1004,
      226,
      1060,
      2352,
      453,
      2761,
      1102,
      1103,
      2971,
      95,
      744,
      1685,
      1377,
      1068,
      65,
      1070
    ],
  ),
  "database_upload": SymbolsMetadata(
    popularity: 88,
    codepoint: 0xf3dc,
    categories: [9],
    tags: [
      1045,
      77,
      1672,
      1403,
      517,
      373,
      1673,
      6850,
      2958,
      922,
      81,
      608,
      1448,
      6851,
      375,
      313,
      1567,
      2968,
      1690,
      147,
      2816,
      1052,
      1692,
      226,
      1060,
      586,
      2318,
      2971,
      6852,
      6853,
      744,
      1685,
      6854,
      6855,
      763,
      1070,
      526,
      1696,
      98,
      527,
      2966,
      2967
    ],
  ),
  "dataset": SymbolsMetadata(
    popularity: 4472,
    codepoint: 0xf8ee,
    categories: [2],
    tags: [
      2154,
      1673,
      1175,
      923,
      81,
      1627,
      6090,
      1448,
      6820,
      44,
      6856,
      1567,
      6857,
      1568,
      147,
      6858,
      382,
      68,
      88,
      1004,
      6859,
      453,
      4088,
      1440,
      2971,
      1441,
      1685,
      6860,
      1453
    ],
  ),
  "dataset_linked": SymbolsMetadata(
    popularity: 1516,
    codepoint: 0xf8ef,
    categories: [2],
    tags: [
      1156,
      1502,
      3245,
      1047,
      1048,
      284,
      81,
      1567,
      2954,
      147,
      1504,
      259,
      1294,
      325,
      267,
      2911,
      523,
      2876,
      2362,
      2915,
      1508,
      2044,
      243,
      1510,
      333,
      6861,
      1164,
      1165,
      6862,
      6863
    ],
  ),
  "date_range": SymbolsMetadata(
    popularity: 7551,
    codepoint: 0xe916,
    categories: [6],
    tags: [
      4987,
      1657,
      1916,
      2104,
      1136,
      4715,
      10,
      382,
      584,
      1004,
      4988,
      1063,
      4998,
      1664,
      3568,
      1124,
      432,
      4063,
      1350,
      1145,
      5000,
      433,
      1148,
      2453,
      4990,
      5001,
      4991
    ],
  ),
  "deblur": SymbolsMetadata(
    popularity: 370,
    codepoint: 0xeb77,
    categories: [1],
    tags: [
      1738,
      40,
      135,
      778,
      3083,
      632,
      4292,
      6864,
      1229,
      673,
      487,
      3334,
      6865,
      576,
      83,
      1746,
      49,
      3577,
      53,
      584,
      3739,
      289,
      57,
      3579,
      59,
      62,
      756,
      63,
      5489,
      637,
      6866,
      6867,
      37,
      364
    ],
  ),
  "deceased": SymbolsMetadata(
    popularity: 85,
    codepoint: 0xe0a5,
    categories: [3],
    tags: [
      1107,
      3491,
      807,
      1109,
      482,
      6636,
      778,
      3874,
      6868,
      809,
      6869,
      1826,
      6870,
      6871,
      348,
      2296,
      1827,
      692,
      811,
      1955,
      550,
      816,
      817,
      1574,
      432,
      392,
      1576,
      979,
      707,
      433,
      393,
      821,
      831,
      832,
      6872,
      3646
    ],
  ),
  "decimal_decrease": SymbolsMetadata(
    popularity: 3,
    codepoint: 0xf82d,
    categories: [12],
    tags: [
      223,
      77,
      502,
      504,
      789,
      345,
      927,
      6873,
      5030,
      2828,
      7,
      1743,
      931,
      6874,
      6875,
      1322,
      2216,
      1966,
      791,
      6378,
      1232,
      938,
      21,
      69,
      4999,
      328,
      26,
      5904,
      3136,
      4986,
      31,
      36
    ],
  ),
  "decimal_increase": SymbolsMetadata(
    popularity: 31,
    codepoint: 0xf82c,
    categories: [12],
    tags: [
      1738,
      1045,
      77,
      502,
      789,
      2848,
      373,
      927,
      81,
      6873,
      6876,
      7,
      2172,
      931,
      370,
      6874,
      6875,
      1052,
      234,
      235,
      2875,
      791,
      938,
      237,
      586,
      21,
      328,
      329,
      26,
      907,
      2418,
      6203,
      229,
      33,
      1696,
      36
    ],
  ),
  "deck": SymbolsMetadata(
    popularity: 841,
    codepoint: 0xea42,
    categories: [8],
    tags: [
      6877,
      1939,
      1289,
      5368,
      6878,
      6879,
      1175,
      5369,
      6880,
      484,
      2358,
      779,
      5422,
      5371,
      1176,
      1116,
      1479,
      5372,
      6881,
      1056,
      2162,
      587,
      3996,
      2362,
      5373,
      3780,
      386,
      6882,
      6883,
      6884,
      432,
      1180,
      705,
      6885,
      433,
      594,
      3700,
      4003,
      6872
    ],
  ),
  "dehaze": SymbolsMetadata(
    popularity: 738,
    codepoint: 0xe3c7,
    categories: [1],
    tags: [
      1738,
      862,
      834,
      1851,
      135,
      778,
      6886,
      1229,
      673,
      487,
      3334,
      83,
      5260,
      2832,
      137,
      579,
      6887,
      138,
      49,
      584,
      506,
      57,
      59,
      906,
      62,
      1039,
      6866,
      2008,
      31,
      6888,
      3598,
      2735,
      856
    ],
  ),
  "delete": SymbolsMetadata(
    popularity: 71112,
    codepoint: 0xe872,
    categories: [2],
    tags: [
      6889,
      746,
      2754,
      504,
      1875,
      1187,
      778,
      1175,
      1078,
      345,
      81,
      1031,
      4593,
      1878,
      809,
      3352,
      147,
      3355,
      1356,
      87,
      1004,
      355,
      289,
      1039,
      151,
      1685,
      1413,
      3360,
      5594
    ],
  ),
  "delete_forever": SymbolsMetadata(
    popularity: 13212,
    codepoint: 0xe92b,
    categories: [2],
    tags: [
      746,
      2154,
      2754,
      504,
      1875,
      1187,
      808,
      778,
      5849,
      345,
      1031,
      6890,
      3351,
      4593,
      6891,
      1878,
      3352,
      1190,
      2327,
      3355,
      6892,
      4118,
      138,
      1322,
      1004,
      6893,
      6894,
      1039,
      1685,
      5834,
      31,
      3360,
      6895,
      3712,
      6896
    ],
  ),
  "delete_history": SymbolsMetadata(
    popularity: 144,
    codepoint: 0xf518,
    categories: [6],
    tags: [
      2504,
      77,
      2433,
      2888,
      2754,
      1187,
      778,
      6897,
      6898,
      6899,
      1135,
      1188,
      81,
      1136,
      1031,
      6900,
      6901,
      6902,
      3352,
      1190,
      2757,
      68,
      584,
      88,
      4779,
      3254,
      1009,
      4220,
      453,
      758,
      1039,
      6903,
      6904,
      6905,
      2441,
      2788,
      470,
      1145,
      1011,
      1203,
      97,
      1148,
      3360,
      473,
      3712,
      3951
    ],
  ),
  "delete_sweep": SymbolsMetadata(
    popularity: 2916,
    codepoint: 0xe16c,
    categories: [2],
    tags: [
      6906,
      6907,
      2754,
      5825,
      6908,
      6909,
      1875,
      808,
      778,
      5849,
      1031,
      6910,
      4593,
      6211,
      1878,
      809,
      3352,
      3355,
      6911,
      6912,
      6913,
      6914,
      6893,
      6915,
      1039,
      5852,
      5834,
      3360,
      6916,
      5845
    ],
  ),
  "delivery_truck_bolt": SymbolsMetadata(
    popularity: 57,
    codepoint: 0xf3a2,
    categories: [9],
    tags: [
      1816,
      3403,
      3893,
      1818,
      4322,
      1819,
      924,
      6917,
      2050,
      6918,
      1646,
      3640,
      3941,
      3879,
      3641,
      1594,
      1141,
      6919,
      4316,
      16,
      3895,
      6245,
      2054,
      2312,
      1520,
      468,
      1372,
      2563,
      4608,
      1331,
      2316,
      3645,
      3067,
      6920,
      2318,
      4318,
      1376,
      275,
      6921,
      2647,
      3896,
      1848,
      1623,
      332,
      1849,
      2066,
      1850
    ],
  ),
  "delivery_truck_speed": SymbolsMetadata(
    popularity: 169,
    codepoint: 0xf3a1,
    categories: [9],
    tags: [
      1816,
      3403,
      1818,
      4322,
      1819,
      2050,
      6922,
      6918,
      6923,
      6924,
      1141,
      6919,
      4316,
      16,
      6245,
      2054,
      2312,
      1520,
      5391,
      6925,
      1372,
      2563,
      4608,
      1331,
      2316,
      3067,
      4889,
      6926,
      2318,
      4318,
      6927,
      1376,
      275,
      2647,
      2427,
      1848,
      1623,
      1849,
      2428,
      2066,
      1850
    ],
  ),
  "demography": SymbolsMetadata(
    popularity: 141,
    codepoint: 0xe489,
    categories: [3],
    tags: [
      6928,
      1402,
      1168,
      1404,
      517,
      684,
      373,
      1800,
      6170,
      81,
      6929,
      6930,
      375,
      1566,
      1567,
      147,
      233,
      1804,
      1052,
      1176,
      234,
      692,
      583,
      323,
      17,
      4624,
      1060,
      1460,
      1574,
      1575,
      589,
      590,
      6173,
      757,
      1408,
      1128,
      6174,
      744,
      6931,
      1206,
      1465
    ],
  ),
  "density_large": SymbolsMetadata(
    popularity: 582,
    codepoint: 0xeba9,
    categories: [2],
    tags: [
      517,
      481,
      2799,
      6932,
      6933,
      8,
      1303,
      581,
      86,
      1955,
      385,
      584,
      88,
      506,
      6934,
      70,
      2236,
      1440,
      701,
      2179,
      71,
      298,
      2231,
      6935,
      6936,
      4544,
      2300,
      97,
      396,
      6937
    ],
  ),
  "density_medium": SymbolsMetadata(
    popularity: 2422,
    codepoint: 0xeb9e,
    categories: [2],
    tags: [
      1738,
      1447,
      517,
      6037,
      6938,
      6939,
      6932,
      6940,
      8,
      581,
      385,
      6941,
      584,
      88,
      3835,
      6942,
      506,
      70,
      6943,
      2236,
      358,
      701,
      2179,
      151,
      2231,
      6944,
      97,
      338,
      396
    ],
  ),
  "density_small": SymbolsMetadata(
    popularity: 1634,
    codepoint: 0xeba8,
    categories: [2],
    tags: [
      6037,
      6945,
      6946,
      6932,
      581,
      582,
      385,
      1966,
      584,
      88,
      506,
      812,
      6947,
      2894,
      70,
      1969,
      1440,
      701,
      2179,
      1972,
      6948,
      2231,
      97,
      1973,
      6949,
      396
    ],
  ),
  "dentistry": SymbolsMetadata(
    popularity: 683,
    codepoint: 0xe0a6,
    categories: [3],
    tags: [
      1657,
      6950,
      1759,
      6951,
      808,
      1760,
      6653,
      6952,
      6953,
      6954,
      5741,
      6955,
      692,
      1765,
      1766,
      1881,
      6956,
      6957,
      895,
      6958,
      6270,
      6959,
      6960,
      6961,
      1610,
      6962,
      6963,
      1777
    ],
  ),
  "departure_board": SymbolsMetadata(
    popularity: 717,
    codepoint: 0xe576,
    categories: [14],
    tags: [
      1987,
      6964,
      6965,
      1816,
      5703,
      1940,
      6966,
      1818,
      1819,
      1135,
      5605,
      6967,
      6968,
      6969,
      8,
      6970,
      68,
      1989,
      1617,
      88,
      1520,
      2474,
      2057,
      2058,
      6971,
      2407,
      1145,
      410,
      291,
      1148,
      5900,
      4996,
      6972,
      6973,
      1623,
      332,
      5642,
      6974,
      4097,
      1850
    ],
  ),
  "deployed_code": SymbolsMetadata(
    popularity: 633,
    codepoint: 0xf720,
    categories: [2],
    tags: [
      478,
      6975,
      5727,
      501,
      6976,
      1354,
      1077,
      2239,
      1078,
      6160,
      1302,
      483,
      6977,
      6978,
      6979,
      1293,
      1080,
      486,
      6980,
      1692,
      4796,
      5220,
      6981,
      87,
      2563,
      6982,
      1099,
      1496,
      1332,
      5435,
      5311,
      2760,
      3022,
      509,
      5987,
      33,
      6167,
      2222
    ],
  ),
  "deployed_code_account": SymbolsMetadata(
    popularity: 85,
    codepoint: 0xf51b,
    categories: [2],
    tags: [
      478,
      565,
      964,
      1018,
      1242,
      6983,
      566,
      5976,
      2397,
      6984,
      193,
      1077,
      6985,
      2239,
      1302,
      483,
      6978,
      145,
      1293,
      6986,
      1080,
      486,
      576,
      1780,
      583,
      1692,
      4796,
      584,
      2094,
      70,
      2563,
      6982,
      589,
      590,
      591,
      976,
      1099,
      3022,
      645,
      71,
      5986,
      597,
      1027,
      3450
    ],
  ),
  "deployed_code_alert": SymbolsMetadata(
    popularity: 41,
    codepoint: 0xf5f2,
    categories: [2],
    tags: [
      3074,
      478,
      1339,
      1340,
      4557,
      4852,
      1342,
      1077,
      2239,
      1302,
      3076,
      483,
      1345,
      6977,
      6978,
      6979,
      1292,
      1293,
      1080,
      486,
      2694,
      1346,
      2695,
      1347,
      1692,
      4796,
      3078,
      6802,
      1143,
      585,
      609,
      2563,
      6982,
      3081,
      1099,
      6987,
      509,
      291,
      31,
      1068,
      6988,
      65,
      1718,
      5450,
      206
    ],
  ),
  "deployed_code_history": SymbolsMetadata(
    popularity: 63,
    codepoint: 0xf5f3,
    categories: [2],
    tags: [
      478,
      501,
      6989,
      4557,
      6159,
      1135,
      1673,
      1077,
      6990,
      2239,
      1302,
      483,
      1448,
      1136,
      6991,
      6978,
      6979,
      1080,
      6992,
      6993,
      486,
      2749,
      2757,
      1692,
      4796,
      4779,
      2563,
      6982,
      2569,
      1099,
      4781,
      6994,
      5549,
      1145,
      2971,
      6995,
      509,
      5987,
      65,
      1148,
      2453,
      6996,
      4097,
      6167,
      6997,
      333,
      6998
    ],
  ),
  "deployed_code_update": SymbolsMetadata(
    popularity: 138,
    codepoint: 0xf5f4,
    categories: [2],
    tags: [
      478,
      501,
      77,
      502,
      2555,
      4557,
      1077,
      2239,
      6999,
      1302,
      483,
      6977,
      6978,
      6979,
      1080,
      7000,
      486,
      2778,
      520,
      1745,
      2556,
      6285,
      1692,
      4796,
      6802,
      267,
      4797,
      2563,
      6982,
      7001,
      1099,
      5984,
      5311,
      3022,
      509,
      1068,
      65,
      890,
      1960,
      527,
      2222
    ],
  ),
  "dermatology": SymbolsMetadata(
    popularity: 22,
    codepoint: 0xe0a7,
    categories: [3],
    tags: [
      6660,
      684,
      1759,
      7002,
      1760,
      7003,
      7004,
      7005,
      7006,
      7007,
      1761,
      576,
      7008,
      7009,
      7010,
      2666,
      7011,
      692,
      7012,
      1765,
      1766,
      583,
      895,
      7013,
      7014,
      590,
      4905,
      7015,
      7016,
      7017,
      3116,
      1777,
      3475
    ],
  ),
  "description": SymbolsMetadata(
    popularity: 34367,
    codepoint: 0xe873,
    categories: [12],
    tags: [
      2432,
      144,
      621,
      81,
      7018,
      145,
      1566,
      1567,
      1675,
      316,
      147,
      317,
      2161,
      1678,
      68,
      5484,
      88,
      5804,
      1092,
      2348,
      148,
      1460,
      1573,
      2876,
      1574,
      1575,
      7019,
      1102,
      1576,
      2797,
      33,
      396,
      1465,
      2356
    ],
  ),
  "deselect": SymbolsMetadata(
    popularity: 427,
    codepoint: 0xebb6,
    categories: [12],
    tags: [
      2302,
      807,
      482,
      1187,
      3704,
      2398,
      778,
      1031,
      7020,
      1279,
      867,
      809,
      1033,
      3352,
      6530,
      817,
      1035,
      1037,
      70,
      289,
      1039,
      5843,
      363,
      1041,
      433,
      4298,
      511,
      7021,
      5599,
      2791,
      4475,
      7022,
      831
    ],
  ),
  "design_services": SymbolsMetadata(
    popularity: 4955,
    codepoint: 0xf10a,
    categories: [12],
    tags: [
      1476,
      1580,
      1354,
      1564,
      1302,
      485,
      4464,
      3566,
      2748,
      378,
      1229,
      673,
      3059,
      2749,
      381,
      137,
      384,
      7023,
      1087,
      4820,
      4396,
      87,
      226,
      492,
      1372,
      3062,
      2599,
      2294,
      2722,
      645,
      2683,
      392,
      4516,
      1577,
      1296,
      1718,
      1498,
      1578,
      1465
    ],
  ),
  "desk": SymbolsMetadata(
    popularity: 368,
    codepoint: 0xf8f4,
    categories: [8],
    tags: [
      919,
      7024,
      5128,
      3059,
      46,
      7025,
      7026,
      4008,
      7027,
      2718,
      2720,
      3086,
      5177,
      812,
      492,
      1372,
      1063,
      3568,
      3021,
      2447,
      978,
      1317,
      1685,
      3387,
      1453,
      1498,
      1130
    ],
  ),
  "deskphone": SymbolsMetadata(
    popularity: 17,
    codepoint: 0xf7fa,
    categories: [11],
    tags: [
      2088,
      7028,
      919,
      1248,
      283,
      284,
      965,
      1366,
      5128,
      7029,
      288,
      7030,
      46,
      5023,
      1086,
      7031,
      87,
      262,
      1372,
      7032,
      271,
      3325,
      760,
      533,
      1387,
      7033,
      7034,
      1277,
      7035
    ],
  ),
  "desktop_access_disabled": SymbolsMetadata(
    popularity: 267,
    codepoint: 0xe99d,
    categories: [11],
    tags: [
      1223,
      1224,
      858,
      7036,
      3726,
      7037,
      1698,
      519,
      284,
      5905,
      1699,
      288,
      1138,
      867,
      1032,
      8,
      2527,
      1033,
      1191,
      1086,
      7038,
      1230,
      1700,
      623,
      3254,
      7039,
      1035,
      1036,
      1037,
      1749,
      2594,
      1970,
      1040,
      410,
      1041,
      65,
      1042,
      333,
      1165
    ],
  ),
  "desktop_cloud": SymbolsMetadata(
    popularity: 56,
    codepoint: 0xf3db,
    categories: [11],
    tags: [
      1223,
      1224,
      858,
      1672,
      1698,
      1673,
      519,
      284,
      254,
      81,
      1699,
      288,
      44,
      8,
      520,
      1675,
      1086,
      1230,
      7040,
      259,
      1700,
      623,
      267,
      523,
      4744,
      410,
      2971,
      1685,
      762,
      763,
      1068,
      65,
      412,
      526,
      2045,
      527,
      333,
      1165,
      1207,
      6232
    ],
  ),
  "desktop_cloud_stack": SymbolsMetadata(
    popularity: 53,
    codepoint: 0xf3be,
    categories: [11],
    tags: [
      1223,
      1224,
      858,
      501,
      1672,
      1698,
      1673,
      1175,
      519,
      2486,
      284,
      81,
      1699,
      288,
      8,
      520,
      1675,
      1176,
      1086,
      1230,
      1616,
      7040,
      1056,
      1700,
      1004,
      623,
      267,
      523,
      4744,
      4483,
      410,
      2971,
      645,
      594,
      1685,
      762,
      763,
      1068,
      65,
      412,
      2045,
      527,
      333,
      1165,
      1207
    ],
  ),
  "desktop_landscape": SymbolsMetadata(
    popularity: 29,
    codepoint: 0xf45e,
    categories: [2],
    tags: [
      626,
      1419,
      519,
      621,
      1699,
      288,
      44,
      8,
      2527,
      370,
      1894,
      382,
      1086,
      581,
      1583,
      385,
      406,
      623,
      7041,
      1372,
      3271,
      507,
      6230,
      386,
      1407,
      2447,
      1630,
      410,
      4597,
      2408,
      7042,
      65,
      6231,
      396,
      2529,
      1165,
      1498,
      6232
    ],
    rtlAutoMirrored: true,
  ),
  "desktop_landscape_add": SymbolsMetadata(
    popularity: 9,
    codepoint: 0xf439,
    categories: [2],
    tags: [
      231,
      743,
      3228,
      1419,
      519,
      1302,
      3232,
      1213,
      1699,
      288,
      2358,
      7043,
      8,
      382,
      581,
      49,
      1305,
      7044,
      1583,
      385,
      406,
      623,
      7041,
      886,
      7045,
      1433,
      57,
      239,
      432,
      1630,
      410,
      4597,
      2408,
      7042,
      433,
      594,
      31,
      65,
      412,
      2045,
      37,
      3057,
      1165
    ],
    rtlAutoMirrored: true,
  ),
  "desktop_mac": SymbolsMetadata(
    popularity: 1102,
    codepoint: 0xe30b,
    categories: [11],
    tags: [
      1223,
      1224,
      7046,
      7047,
      1698,
      519,
      2486,
      1699,
      288,
      44,
      8,
      2527,
      1086,
      1116,
      1230,
      7048,
      1700,
      7049,
      640,
      623,
      1372,
      4253,
      6230,
      432,
      410,
      1752,
      4111,
      65,
      333,
      1165,
      1498,
      6232
    ],
  ),
  "desktop_portrait": SymbolsMetadata(
    popularity: 16,
    codepoint: 0xf45d,
    categories: [2],
    tags: [
      500,
      1419,
      519,
      1699,
      288,
      8,
      2527,
      779,
      382,
      1086,
      1116,
      385,
      635,
      623,
      7041,
      1372,
      507,
      386,
      974,
      1630,
      410,
      4597,
      2408,
      7042,
      65,
      1445,
      4721,
      1165,
      1498
    ],
    rtlAutoMirrored: true,
  ),
  "desktop_windows": SymbolsMetadata(
    popularity: 5282,
    codepoint: 0xe30c,
    categories: [11],
    tags: [
      1223,
      1224,
      4246,
      1698,
      519,
      1699,
      288,
      44,
      8,
      2527,
      1086,
      1116,
      1230,
      1700,
      5440,
      623,
      1372,
      4253,
      1407,
      2447,
      4744,
      410,
      2044,
      65,
      412,
      2045,
      333,
      1165,
      1207,
      1498,
      6232
    ],
  ),
  "destruction": SymbolsMetadata(
    popularity: 151,
    codepoint: 0xf585,
    categories: [3],
    tags: [
      480,
      5949,
      4357,
      4358,
      7050,
      193,
      2799,
      5239,
      3351,
      7051,
      7052,
      1081,
      1140,
      3641,
      4370,
      4371,
      7053,
      2488,
      1142,
      584,
      7054,
      7055,
      7056,
      7057,
      7058,
      3645,
      7059,
      4147,
      4568,
      7060,
      7061,
      331,
      65,
      4379
    ],
  ),
  "details": SymbolsMetadata(
    popularity: 808,
    codepoint: 0xe3c8,
    categories: [1],
    tags: [
      3000,
      81,
      7062,
      43,
      145,
      1081,
      1229,
      673,
      7063,
      3334,
      1303,
      7064,
      316,
      1954,
      7065,
      7066,
      49,
      68,
      7067,
      506,
      6334,
      237,
      7068,
      2876,
      70,
      7069,
      7070,
      7071,
      57,
      59,
      2843,
      71,
      7072,
      6866,
      2844,
      7073,
      3911,
      1718,
      396
    ],
  ),
  "detection_and_zone": SymbolsMetadata(
    popularity: 325,
    codepoint: 0xe29f,
    categories: [10],
    tags: [
      2504,
      1339,
      1107,
      1108,
      1109,
      7074,
      3008,
      6864,
      7075,
      7076,
      867,
      1033,
      1116,
      1967,
      3470,
      1119,
      609,
      1035,
      1036,
      1037,
      289,
      1122,
      590,
      3159,
      1124,
      432,
      1125,
      7077,
      2781,
      1127,
      1011,
      1128,
      64,
      1041,
      433,
      5105,
      1204,
      206,
      1131
    ],
  ),
  "detector": SymbolsMetadata(
    popularity: 178,
    codepoint: 0xe282,
    categories: [10],
    tags: [
      1107,
      729,
      7078,
      7079,
      7076,
      7080,
      2293,
      2341,
      317,
      1116,
      2345,
      1119,
      1560,
      7081,
      1124,
      961,
      702,
      1736,
      2781,
      1102,
      64,
      273,
      5211,
      1182,
      4745,
      1718,
      2883,
      1131
    ],
  ),
  "detector_alarm": SymbolsMetadata(
    popularity: 273,
    codepoint: 0xe1f7,
    categories: [10],
    tags: [
      1338,
      1339,
      1340,
      1341,
      7082,
      7078,
      3076,
      1345,
      7080,
      2423,
      7083,
      1116,
      138,
      51,
      1119,
      609,
      289,
      1560,
      696,
      760,
      702,
      1011,
      64,
      273,
      1317,
      2137,
      5211,
      7084,
      1271,
      31,
      1068,
      2428,
      206
    ],
  ),
  "detector_battery": SymbolsMetadata(
    popularity: 123,
    codepoint: 0xe204,
    categories: [10],
    tags: [
      3938,
      1339,
      3637,
      3833,
      3878,
      3844,
      1227,
      3638,
      3834,
      7078,
      7080,
      288,
      3640,
      3641,
      3846,
      46,
      1086,
      1116,
      51,
      3872,
      3900,
      1119,
      3645,
      3954,
      3876,
      7085,
      3875,
      3836,
      3928,
      702,
      5211,
      291,
      65,
      7086,
      206
    ],
  ),
  "detector_co": SymbolsMetadata(
    popularity: 151,
    codepoint: 0xe2af,
    categories: [10],
    tags: [
      1902,
      1339,
      918,
      7087,
      7078,
      1345,
      7076,
      7080,
      288,
      2423,
      1856,
      46,
      7083,
      5959,
      4373,
      1765,
      1116,
      51,
      4820,
      17,
      895,
      3470,
      1119,
      7088,
      696,
      702,
      1011,
      64,
      5211,
      7084,
      4868,
      7089,
      206
    ],
  ),
  "detector_offline": SymbolsMetadata(
    popularity: 101,
    codepoint: 0xe223,
    categories: [10],
    tags: [
      1339,
      283,
      284,
      7080,
      7090,
      288,
      3247,
      46,
      2694,
      4659,
      2695,
      1116,
      1200,
      3078,
      3470,
      1119,
      267,
      7091,
      5937,
      1036,
      7092,
      3081,
      702,
      1011,
      64,
      273,
      5211,
      291,
      1068,
      65,
      1718,
      1042,
      206
    ],
  ),
  "detector_smoke": SymbolsMetadata(
    popularity: 468,
    codepoint: 0xe285,
    categories: [8],
    tags: [
      1338,
      1339,
      7093,
      1889,
      918,
      1342,
      193,
      1345,
      7076,
      7080,
      288,
      2423,
      46,
      5173,
      7083,
      7094,
      1116,
      3125,
      7095,
      1479,
      584,
      3470,
      1119,
      696,
      702,
      1011,
      64,
      273,
      5211,
      7084,
      206,
      1867
    ],
  ),
  "detector_status": SymbolsMetadata(
    popularity: 172,
    codepoint: 0xe1e8,
    categories: [10],
    tags: [
      858,
      4747,
      517,
      283,
      284,
      254,
      81,
      7076,
      7080,
      1116,
      51,
      68,
      1057,
      17,
      3463,
      1119,
      267,
      641,
      2081,
      2834,
      272,
      702,
      64,
      273,
      290,
      5211,
      291,
      642,
      65,
      1866,
      277,
      278
    ],
  ),
  "developer_board": SymbolsMetadata(
    popularity: 1730,
    codepoint: 0xe30d,
    categories: [11],
    tags: [
      5703,
      1354,
      4908,
      7096,
      1077,
      2239,
      3322,
      519,
      2486,
      7097,
      1293,
      7098,
      1080,
      7099,
      7100,
      7101,
      2532,
      2749,
      1086,
      7102,
      7103,
      5743,
      7104,
      7105,
      5744,
      1099,
      7106,
      2971,
      1276,
      7107,
      65,
      7108,
      3063
    ],
  ),
  "developer_board_off": SymbolsMetadata(
    popularity: 181,
    codepoint: 0xe4ff,
    categories: [11],
    tags: [
      5703,
      4908,
      5738,
      7096,
      3322,
      519,
      1213,
      1293,
      7098,
      1080,
      288,
      1279,
      867,
      1032,
      2527,
      2532,
      1033,
      2694,
      1086,
      1200,
      7102,
      5743,
      6816,
      5937,
      1035,
      1037,
      5744,
      1099,
      1041,
      1203,
      65,
      1042,
      206
    ],
  ),
  "developer_guide": SymbolsMetadata(
    popularity: 338,
    codepoint: 0xe99e,
    categories: [6],
    tags: [
      2430,
      3375,
      7109,
      1688,
      2636,
      1077,
      6800,
      2239,
      2434,
      1293,
      1080,
      1566,
      1567,
      3377,
      3059,
      147,
      2780,
      691,
      873,
      293,
      68,
      7110,
      4396,
      3381,
      1575,
      1099,
      3366,
      179,
      4483,
      2179,
      3022,
      5986,
      509,
      140,
      65,
      4423
    ],
  ),
  "developer_mode": SymbolsMetadata(
    popularity: 1498,
    codepoint: 0xe1b0,
    categories: [11],
    tags: [
      1223,
      1224,
      5974,
      2482,
      502,
      6976,
      5976,
      1227,
      251,
      6984,
      193,
      1077,
      2239,
      678,
      3565,
      1290,
      1291,
      1293,
      7111,
      7112,
      1080,
      288,
      1743,
      4876,
      1086,
      1230,
      262,
      7113,
      2491,
      2029,
      635,
      70,
      271,
      1099,
      432,
      71,
      1695,
      509,
      433,
      525,
      97
    ],
  ),
  "developer_mode_tv": SymbolsMetadata(
    popularity: 98,
    codepoint: 0xe874,
    categories: [11],
    tags: [
      1223,
      1224,
      777,
      482,
      5976,
      729,
      1354,
      730,
      1698,
      1077,
      2239,
      1778,
      678,
      1290,
      1699,
      1293,
      288,
      8,
      2532,
      4876,
      779,
      1780,
      1086,
      1230,
      6802,
      1700,
      406,
      635,
      623,
      70,
      1099,
      432,
      410,
      71,
      2022,
      1276,
      65,
      412,
      511,
      2045,
      37,
      333,
      1165
    ],
  ),
  "device_band": SymbolsMetadata(
    popularity: 44,
    codepoint: 0xf2f5,
    categories: [11],
    tags: [
      1869,
      7114,
      7115,
      7116,
      3123,
      288,
      7117,
      2532,
      2831,
      2533,
      7118,
      7119,
      7120,
      1894,
      7121,
      7122,
      7123,
      7124,
      7125,
      7126,
      7127,
      2534,
      65,
      7128,
      2102,
      2627,
      2537,
      2538,
      7129,
      7130,
      7131,
      7132,
      2541
    ],
  ),
  "device_hub": SymbolsMetadata(
    popularity: 1271,
    codepoint: 0xe335,
    categories: [11],
    tags: [
      1223,
      1224,
      1476,
      308,
      7133,
      193,
      519,
      678,
      7134,
      284,
      7135,
      1049,
      345,
      1699,
      288,
      7136,
      375,
      44,
      1086,
      3146,
      1230,
      1616,
      2489,
      3126,
      3643,
      584,
      5474,
      1004,
      324,
      262,
      623,
      267,
      7137,
      1062,
      271,
      848,
      71,
      1899,
      433,
      1068,
      525,
      65,
      1718,
      2102,
      2537,
      333
    ],
  ),
  "device_thermostat": SymbolsMetadata(
    popularity: 2737,
    codepoint: 0xe1ff,
    categories: [11],
    tags: [
      2233,
      1288,
      1890,
      6248,
      837,
      838,
      345,
      842,
      288,
      1823,
      6249,
      3827,
      1859,
      1116,
      1880,
      1860,
      51,
      17,
      3463,
      699,
      64,
      71,
      1899,
      1068,
      7138,
      855,
      2837,
      2085,
      2990
    ],
  ),
  "device_unknown": SymbolsMetadata(
    popularity: 554,
    codepoint: 0xe339,
    categories: [11],
    tags: [
      3898,
      1223,
      1224,
      865,
      1227,
      288,
      7139,
      6309,
      317,
      1086,
      873,
      7140,
      1230,
      293,
      68,
      5403,
      3078,
      7141,
      7142,
      262,
      1693,
      7143,
      271,
      3081,
      3901,
      2352,
      3902,
      3903,
      432,
      2526,
      1102,
      1695,
      878,
      31,
      525,
      3904,
      7144,
      3905,
      7145,
      7146
    ],
  ),
  "devices": SymbolsMetadata(
    popularity: 7250,
    codepoint: 0xe1b1,
    categories: [11],
    tags: [
      1223,
      1224,
      4246,
      283,
      519,
      1047,
      284,
      254,
      608,
      1699,
      288,
      2676,
      8,
      1086,
      1230,
      3643,
      1294,
      262,
      623,
      7147,
      267,
      271,
      7148,
      410,
      2041,
      2044,
      1695,
      411,
      762,
      763,
      525,
      65,
      526,
      2102,
      2537,
      333
    ],
  ),
  "devices_fold": SymbolsMetadata(
    popularity: 273,
    codepoint: 0xebde,
    categories: [4],
    tags: [
      1223,
      1224,
      1227,
      4204,
      519,
      2399,
      752,
      288,
      8,
      7149,
      2527,
      3003,
      1253,
      2862,
      7150,
      1894,
      1086,
      7151,
      1230,
      1583,
      3643,
      385,
      406,
      262,
      623,
      2876,
      507,
      1749,
      271,
      974,
      410,
      1695,
      525,
      65,
      512,
      2900,
      396
    ],
  ),
  "devices_fold_2": SymbolsMetadata(
    popularity: 10,
    codepoint: 0xf406,
    categories: [4],
    tags: [
      1223,
      7152,
      1224,
      1288,
      7153,
      1227,
      3430,
      288,
      44,
      8,
      2532,
      2862,
      7150,
      7154,
      489,
      381,
      1086,
      1230,
      1322,
      262,
      640,
      1749,
      271,
      432,
      410,
      392,
      525,
      65,
      1326
    ],
  ),
  "devices_off": SymbolsMetadata(
    popularity: 51,
    codepoint: 0xf7a5,
    categories: [11],
    tags: [
      1223,
      1224,
      3244,
      6323,
      519,
      3246,
      6842,
      1699,
      288,
      7155,
      1138,
      867,
      1032,
      1033,
      1086,
      1230,
      3643,
      1294,
      3253,
      262,
      623,
      6450,
      6328,
      5936,
      1035,
      1036,
      1037,
      7156,
      271,
      7157,
      7158,
      410,
      1041,
      525,
      1042,
      3257,
      7159,
      2102,
      2537,
      333
    ],
  ),
  "devices_other": SymbolsMetadata(
    popularity: 1243,
    codepoint: 0xe337,
    categories: [11],
    tags: [
      1223,
      1224,
      2530,
      1246,
      2037,
      7160,
      1227,
      1698,
      283,
      519,
      284,
      254,
      1699,
      288,
      2676,
      44,
      8,
      2532,
      1894,
      7161,
      1086,
      1230,
      7162,
      1700,
      406,
      5440,
      262,
      623,
      7147,
      267,
      2405,
      7163,
      7164,
      271,
      410,
      7165,
      7166,
      762,
      525,
      65,
      37,
      499,
      477,
      2102,
      2539,
      1165
    ],
    rtlAutoMirrored: true,
  ),
  "devices_wearables": SymbolsMetadata(
    popularity: 184,
    codepoint: 0xf6ab,
    categories: [11],
    tags: [
      858,
      2530,
      2531,
      1248,
      1227,
      569,
      1135,
      283,
      1047,
      284,
      345,
      81,
      288,
      8,
      2532,
      2831,
      2533,
      1894,
      7161,
      2666,
      1086,
      692,
      1230,
      262,
      609,
      3988,
      271,
      2526,
      410,
      71,
      1695,
      2534,
      2535,
      5887,
      525,
      65,
      33,
      1148,
      2536,
      477,
      2102,
      2537,
      2539,
      333,
      2540,
      2542
    ],
  ),
  "dew_point": SymbolsMetadata(
    popularity: 25,
    codepoint: 0xf879,
    categories: [3],
    tags: [
      834,
      1045,
      1851,
      373,
      837,
      5259,
      7167,
      81,
      7168,
      7169,
      4241,
      7170,
      1823,
      2832,
      3827,
      1052,
      6505,
      51,
      68,
      790,
      17,
      5856,
      7171,
      328,
      3766,
      2834,
      1408,
      391,
      4147,
      744,
      855,
      2837,
      36,
      2480,
      7172,
      856
    ],
  ),
  "diagnosis": SymbolsMetadata(
    popularity: 128,
    codepoint: 0xe0a8,
    categories: [12],
    tags: [
      1402,
      4225,
      373,
      839,
      81,
      5868,
      2382,
      1566,
      1567,
      4227,
      4228,
      7173,
      147,
      351,
      1052,
      692,
      7174,
      4229,
      5359,
      4230,
      2384,
      16,
      87,
      17,
      895,
      623,
      1460,
      1574,
      1575,
      4233,
      1408,
      4951,
      2389,
      291,
      4234,
      1465,
      7175
    ],
  ),
  "diagonal_line": SymbolsMetadata(
    popularity: 26,
    codepoint: 0xf41e,
    categories: [12],
    tags: [
      480,
      1133,
      500,
      1403,
      1310,
      193,
      2399,
      2358,
      1139,
      2748,
      1229,
      673,
      1140,
      381,
      137,
      51,
      87,
      2893,
      174,
      812,
      7176,
      1128,
      1146,
      392,
      1317,
      7177,
      1041,
      433,
      3728,
      1147,
      31,
      510,
      1390
    ],
    rtlAutoMirrored: true,
  ),
  "dialer_sip": SymbolsMetadata(
    popularity: 269,
    codepoint: 0xe0bb,
    categories: [7],
    tags: [
      4,
      504,
      1248,
      5021,
      1227,
      5,
      283,
      4649,
      284,
      965,
      288,
      1381,
      7030,
      12,
      1086,
      138,
      7178,
      259,
      7179,
      4738,
      16,
      87,
      262,
      267,
      7180,
      289,
      666,
      271,
      5029,
      4742,
      2944,
      7181,
      7182,
      7183,
      433,
      31,
      1387,
      7184,
      33,
      35,
      1277,
      7185,
      7186
    ],
  ),
  "dialogs": SymbolsMetadata(
    popularity: 86,
    codepoint: 0xe99f,
    categories: [2],
    tags: [
      746,
      1288,
      501,
      3773,
      569,
      2706,
      7187,
      571,
      283,
      2675,
      1455,
      485,
      1456,
      7188,
      7189,
      7190,
      2710,
      7191,
      1459,
      7192,
      68,
      7193,
      1603,
      1322,
      385,
      585,
      7194,
      262,
      623,
      289,
      271,
      1462,
      1463,
      410,
      2790,
      705,
      1273,
      1464,
      433,
      2684,
      525,
      1274,
      5656,
      33,
      4083,
      141,
      1327,
      333,
      1164,
      1165
    ],
  ),
  "dialpad": SymbolsMetadata(
    popularity: 1433,
    codepoint: 0xe0bc,
    categories: [7],
    tags: [
      504,
      1075,
      1248,
      283,
      965,
      345,
      288,
      1381,
      5055,
      7195,
      7,
      1081,
      7196,
      382,
      7197,
      1087,
      467,
      1090,
      7031,
      385,
      4071,
      262,
      21,
      22,
      69,
      7198,
      271,
      432,
      1695,
      433,
      276,
      1387,
      7199
    ],
  ),
  "diamond": SymbolsMetadata(
    popularity: 4534,
    codepoint: 0xead5,
    categories: [3],
    tags: [
      3189,
      1466,
      808,
      843,
      6339,
      1467,
      3790,
      1468,
      7200,
      2615,
      1469,
      7201,
      1142,
      1470,
      7202,
      2466,
      1471,
      2890,
      849,
      1472,
      714,
      3480,
      63,
      1374,
      392,
      637,
      1317,
      898,
      4689,
      1474,
      7203,
      36
    ],
  ),
  "dictionary": SymbolsMetadata(
    popularity: 245,
    codepoint: 0xf539,
    categories: [12],
    tags: [
      3064,
      7204,
      6381,
      3375,
      104,
      4405,
      3059,
      7205,
      3379,
      5220,
      4396,
      7206,
      1323,
      3380,
      7207,
      3383,
      3384,
      3366,
      2834,
      179,
      2722,
      7208,
      3387,
      7209,
      7210,
      33,
      3388,
      7211,
      7212,
      6643,
      554,
      7213
    ],
  ),
  "difference": SymbolsMetadata(
    popularity: 1488,
    codepoint: 0xeb7d,
    categories: [12],
    tags: [
      677,
      3671,
      621,
      4698,
      1724,
      6339,
      7214,
      6183,
      1566,
      1567,
      3626,
      147,
      1056,
      2162,
      70,
      2732,
      2759,
      363,
      2408,
      594,
      7215,
      6997
    ],
  ),
  "digital_out_of_home": SymbolsMetadata(
    popularity: 299,
    codepoint: 0xf1de,
    categories: [0],
    tags: [
      1152,
      1210,
      1154,
      7216,
      729,
      283,
      7217,
      313,
      8,
      7218,
      348,
      68,
      584,
      323,
      1159,
      406,
      1160,
      7219,
      3996,
      1161,
      7220,
      432,
      410,
      1162,
      433,
      1531,
      65,
      1486
    ],
  ),
  "digital_wellbeing": SymbolsMetadata(
    popularity: 251,
    codepoint: 0xef86,
    categories: [3],
    tags: [
      1045,
      1288,
      7221,
      501,
      914,
      2138,
      373,
      7222,
      345,
      81,
      4337,
      44,
      7223,
      7224,
      1746,
      1052,
      692,
      2371,
      4229,
      68,
      550,
      6023,
      1201,
      590,
      7225,
      1408,
      3256,
      7226,
      7227,
      744,
      7228,
      7229,
      7230,
      7231,
      7232
    ],
  ),
  "dining": SymbolsMetadata(
    popularity: 912,
    codepoint: 0xeff4,
    categories: [8],
    tags: [
      4168,
      4801,
      3651,
      3653,
      7233,
      7234,
      3656,
      4803,
      4635,
      3658,
      4069,
      4178,
      3659,
      4807,
      7235,
      2370,
      2941,
      7236,
      4183,
      4808,
      4070,
      3661,
      4810,
      7237,
      3665,
      1884,
      7238,
      645,
      3667,
      4812,
      4813,
      1453,
      7239
    ],
  ),
  "dinner_dining": SymbolsMetadata(
    popularity: 979,
    codepoint: 0xea57,
    categories: [16],
    tags: [
      4168,
      3651,
      3653,
      4175,
      3656,
      4177,
      4803,
      3658,
      4804,
      4069,
      4178,
      3659,
      4807,
      7235,
      2370,
      2941,
      6494,
      4183,
      4808,
      4070,
      3661,
      506,
      7240,
      7241,
      1931,
      3665,
      3667,
      4812,
      3668,
      7242,
      1453,
      4814
    ],
  ),
  "directions": SymbolsMetadata(
    popularity: 1748,
    codepoint: 0xe52e,
    categories: [5],
    tags: [
      77,
      309,
      312,
      2402,
      7243,
      2932,
      321,
      2780,
      3132,
      7244,
      1617,
      7245,
      2216,
      2345,
      323,
      324,
      1520,
      325,
      1619,
      326,
      2881,
      329,
      907,
      1620,
      1621,
      1162,
      2782,
      1531,
      1622,
      332,
      1945,
      473,
      7246
    ],
    rtlAutoMirrored: true,
  ),
  "directions_alt": SymbolsMetadata(
    popularity: 254,
    codepoint: 0xf880,
    categories: [5],
    tags: [
      7247,
      500,
      77,
      7248,
      309,
      2357,
      312,
      2400,
      2402,
      321,
      3144,
      1617,
      323,
      324,
      1520,
      325,
      7249,
      1619,
      328,
      7250,
      907,
      1694,
      7251,
      1620,
      1621,
      1162,
      1531,
      1622,
      332,
      473,
      7252,
      1624
    ],
    rtlAutoMirrored: true,
  ),
  "directions_alt_off": SymbolsMetadata(
    popularity: 44,
    codepoint: 0xf881,
    categories: [5],
    tags: [
      1527,
      77,
      7253,
      481,
      6323,
      2402,
      1279,
      867,
      1033,
      321,
      3144,
      1617,
      87,
      323,
      324,
      1059,
      1520,
      325,
      7254,
      6239,
      1035,
      1037,
      1619,
      1144,
      1039,
      907,
      1620,
      1621,
      1162,
      1041,
      1203,
      1622,
      332,
      4299,
      1042,
      1624
    ],
  ),
  "directions_bike": SymbolsMetadata(
    popularity: 3023,
    codepoint: 0xe52f,
    categories: [14],
    tags: [
      4098,
      4100,
      4105,
      4106,
      313,
      2402,
      7255,
      11,
      583,
      1617,
      324,
      1520,
      325,
      1836,
      1619,
      590,
      4123,
      2057,
      2059,
      7256,
      1620,
      1621,
      30,
      1531,
      1848,
      1623,
      332,
      4126,
      4129
    ],
    rtlAutoMirrored: true,
  ),
  "directions_boat": SymbolsMetadata(
    popularity: 2145,
    codepoint: 0xe532,
    categories: [14],
    tags: [
      1816,
      2460,
      7257,
      1818,
      1819,
      7258,
      312,
      313,
      2402,
      4315,
      1617,
      323,
      324,
      1520,
      2467,
      2468,
      2471,
      325,
      2473,
      1373,
      2057,
      1621,
      2476,
      2419,
      2477,
      7259,
      1848,
      1623,
      332,
      1945,
      1850,
      7260,
      2480,
      7261
    ],
  ),
  "directions_bus": SymbolsMetadata(
    popularity: 3402,
    codepoint: 0xe530,
    categories: [14],
    tags: [
      1816,
      1940,
      7262,
      1818,
      1819,
      2544,
      312,
      2402,
      1675,
      968,
      903,
      1617,
      323,
      324,
      1520,
      586,
      325,
      1928,
      2057,
      7263,
      2059,
      1620,
      1621,
      392,
      978,
      979,
      1994,
      1848,
      7264,
      1623,
      332,
      7265,
      1486,
      1850,
      4129
    ],
  ),
  "directions_car": SymbolsMetadata(
    popularity: 10613,
    codepoint: 0xe531,
    categories: [14],
    tags: [
      2048,
      1816,
      3403,
      1818,
      7266,
      1819,
      312,
      313,
      2402,
      1675,
      7267,
      2051,
      7268,
      7269,
      1617,
      1520,
      896,
      1618,
      325,
      7270,
      2057,
      1620,
      1621,
      7271,
      1148,
      1848,
      7272,
      1623,
      332,
      7273,
      1945,
      1850,
      7274
    ],
  ),
  "directions_off": SymbolsMetadata(
    popularity: 141,
    codepoint: 0xf10f,
    categories: [5],
    tags: [
      77,
      3726,
      1187,
      7275,
      7276,
      1188,
      6842,
      5905,
      2402,
      7277,
      7278,
      867,
      1033,
      2207,
      1191,
      7279,
      7280,
      7281,
      7282,
      7283,
      1520,
      7284,
      6816,
      6239,
      1035,
      1037,
      6453,
      4219,
      7285,
      907,
      1621,
      7286,
      1162,
      1041,
      1203,
      7287,
      1622,
      7288,
      4299,
      3951
    ],
  ),
  "directions_railway": SymbolsMetadata(
    popularity: 403,
    codepoint: 0xe534,
    categories: [14],
    tags: [
      1816,
      1818,
      4895,
      1819,
      2544,
      4105,
      312,
      313,
      2402,
      2780,
      1617,
      323,
      4896,
      324,
      1520,
      4897,
      325,
      326,
      1373,
      2057,
      2058,
      4327,
      7289,
      4328,
      1621,
      4329,
      3286,
      2165,
      1944,
      6972,
      4330,
      1994,
      1848,
      1623,
      332,
      1656,
      1486,
      1850
    ],
  ),
  "directions_railway_2": SymbolsMetadata(
    popularity: 12,
    codepoint: 0xf462,
    categories: [14],
    tags: [
      2544,
      4105,
      375,
      2402,
      138,
      1617,
      4896,
      324,
      4897,
      325,
      2058,
      4327,
      4328,
      1621,
      3516,
      4329,
      31,
      2165,
      1944,
      1994,
      1848,
      1623,
      332,
      1486,
      1850
    ],
  ),
  "directions_run": SymbolsMetadata(
    popularity: 4841,
    codepoint: 0xe566,
    categories: [14],
    tags: [
      2504,
      7290,
      684,
      2402,
      9,
      11,
      225,
      2533,
      692,
      583,
      7291,
      324,
      1520,
      7292,
      468,
      325,
      3471,
      1619,
      589,
      590,
      27,
      1621,
      1101,
      29,
      275,
      30,
      3753,
      1070,
      2988,
      1994,
      332,
      3117,
      3473
    ],
    rtlAutoMirrored: true,
  ),
  "directions_subway": SymbolsMetadata(
    popularity: 587,
    codepoint: 0xe533,
    categories: [14],
    tags: [
      1816,
      1818,
      4895,
      1819,
      2544,
      4105,
      7293,
      312,
      313,
      2402,
      1617,
      87,
      323,
      324,
      1520,
      4897,
      325,
      1928,
      2057,
      7263,
      4327,
      7294,
      4328,
      1621,
      3516,
      4329,
      1944,
      4330,
      1994,
      1848,
      2064,
      7295,
      1623,
      332,
      1656,
      7296,
      1486,
      1850
    ],
  ),
  "directions_walk": SymbolsMetadata(
    popularity: 4160,
    codepoint: 0xe536,
    categories: [14],
    tags: [
      2504,
      684,
      313,
      2402,
      11,
      5145,
      225,
      2533,
      321,
      583,
      7291,
      1617,
      324,
      1520,
      896,
      586,
      468,
      325,
      1836,
      1619,
      7297,
      589,
      590,
      1621,
      1101,
      978,
      2878,
      3753,
      7298,
      1848,
      332,
      3117,
      909
    ],
    rtlAutoMirrored: true,
  ),
  "directory_sync": SymbolsMetadata(
    popularity: 151,
    codepoint: 0xe394,
    categories: [2],
    tags: [
      501,
      460,
      502,
      193,
      1673,
      519,
      284,
      81,
      313,
      4769,
      3261,
      147,
      2161,
      259,
      755,
      262,
      325,
      267,
      1065,
      758,
      759,
      470,
      1508,
      509,
      762,
      3435,
      1068,
      65,
      526,
      7299,
      890,
      333
    ],
  ),
  "dirty_lens": SymbolsMetadata(
    popularity: 202,
    codepoint: 0xef4b,
    categories: [1],
    tags: [
      1339,
      4257,
      4258,
      40,
      193,
      5240,
      7300,
      487,
      2694,
      346,
      83,
      7301,
      49,
      7302,
      3078,
      53,
      406,
      609,
      7303,
      4261,
      57,
      59,
      62,
      3081,
      63,
      7304,
      7305,
      3283,
      37,
      476,
      206
    ],
  ),
  "disabled_by_default": SymbolsMetadata(
    popularity: 5052,
    codepoint: 0xf230,
    categories: [2],
    tags: [
      1028,
      1339,
      3726,
      482,
      6605,
      1187,
      1342,
      778,
      1188,
      1213,
      6939,
      5905,
      2358,
      867,
      2694,
      1190,
      2695,
      1191,
      1200,
      51,
      5153,
      3078,
      87,
      3254,
      6239,
      1035,
      3081,
      4220,
      6591,
      1039,
      1970,
      392,
      433,
      4305,
      291,
      1203,
      31,
      2220,
      1042,
      206,
      3712
    ],
  ),
  "disabled_visible": SymbolsMetadata(
    popularity: 1193,
    codepoint: 0xe76e,
    categories: [13],
    tags: [
      858,
      1028,
      3726,
      1187,
      193,
      1188,
      7306,
      1138,
      867,
      7307,
      1190,
      5787,
      7308,
      1199,
      2864,
      1200,
      811,
      1967,
      87,
      3254,
      1035,
      1037,
      3739,
      1009,
      975,
      4220,
      1039,
      1970,
      2843,
      1011,
      1103,
      2022,
      1041,
      1203,
      7309,
      1042,
      7310,
      396,
      3598,
      4714,
      2735
    ],
  ),
  "disc_full": SymbolsMetadata(
    popularity: 356,
    codepoint: 0xe610,
    categories: [11],
    tags: [
      3074,
      1320,
      1339,
      1340,
      1246,
      3853,
      1342,
      2157,
      193,
      463,
      1345,
      81,
      2159,
      2160,
      7311,
      2694,
      1346,
      968,
      2296,
      1347,
      68,
      550,
      1143,
      7312,
      406,
      2758,
      1701,
      609,
      7313,
      7314,
      453,
      1685,
      31,
      37,
      206
    ],
  ),
  "discover_tune": SymbolsMetadata(
    popularity: 1458,
    codepoint: 0xe018,
    categories: [0],
    tags: [
      1738,
      1756,
      1246,
      678,
      345,
      574,
      2341,
      1229,
      673,
      7315,
      2079,
      83,
      317,
      7316,
      1780,
      1057,
      2094,
      1701,
      70,
      151,
      71,
      1271,
      7317,
      6081,
      411,
      7318,
      1754,
      7319,
      5333,
      554
    ],
  ),
  "dishwasher": SymbolsMetadata(
    popularity: 29,
    codepoint: 0xe9a0,
    categories: [8],
    tags: [
      1889,
      1890,
      1642,
      808,
      3788,
      345,
      7320,
      751,
      4636,
      7321,
      7322,
      4924,
      2849,
      6504,
      7323,
      580,
      1116,
      1479,
      51,
      4183,
      7324,
      1729,
      289,
      7325,
      1098,
      7326,
      5817,
      151,
      1899,
      2218,
      291,
      1203,
      7327,
      7328,
      3797,
      2480
    ],
  ),
  "dishwasher_gen": SymbolsMetadata(
    popularity: 432,
    codepoint: 0xe832,
    categories: [8],
    tags: [
      1889,
      3179,
      5826,
      808,
      3788,
      4174,
      4175,
      6004,
      4803,
      4636,
      7321,
      7322,
      4023,
      3640,
      1085,
      1116,
      1479,
      1880,
      4183,
      2893,
      584,
      1729,
      1119,
      289,
      4640,
      2447,
      7326,
      5817,
      1317,
      3819,
      1147,
      7329,
      7327,
      3317,
      3810
    ],
  ),
  "display_external_input": SymbolsMetadata(
    popularity: 39,
    codepoint: 0xf7e7,
    categories: [4],
    tags: [
      77,
      461,
      4928,
      1047,
      284,
      81,
      288,
      8,
      2527,
      2905,
      348,
      7330,
      7331,
      1087,
      385,
      584,
      1294,
      406,
      623,
      586,
      2361,
      1732,
      3927,
      2474,
      432,
      907,
      410,
      273,
      735,
      2409,
      65,
      412,
      2045,
      7332,
      37,
      1165
    ],
  ),
  "display_settings": SymbolsMetadata(
    popularity: 1568,
    codepoint: 0xeb97,
    categories: [11],
    tags: [
      1223,
      1224,
      862,
      501,
      3590,
      2397,
      1698,
      1778,
      519,
      678,
      4698,
      345,
      3565,
      1699,
      145,
      288,
      8,
      7333,
      7334,
      2527,
      1780,
      1086,
      1230,
      293,
      68,
      1700,
      623,
      7335,
      70,
      1749,
      911,
      912,
      28,
      410,
      7336,
      773,
      645,
      71,
      1752,
      65,
      333,
      1165
    ],
  ),
  "distance": SymbolsMetadata(
    popularity: 136,
    codepoint: 0xf6ea,
    categories: [15],
    tags: [
      77,
      2283,
      1188,
      312,
      377,
      313,
      9,
      2849,
      7337,
      7338,
      1628,
      2923,
      87,
      323,
      1957,
      1520,
      226,
      17,
      1060,
      325,
      1733,
      326,
      327,
      1124,
      2294,
      391,
      4310,
      298,
      2231,
      2286,
      1203,
      2946,
      7339
    ],
  ),
  "diversity_1": SymbolsMetadata(
    popularity: 3845,
    codepoint: 0xf8d7,
    categories: [3],
    tags: [
      565,
      566,
      403,
      193,
      3191,
      4558,
      1249,
      1800,
      6170,
      7340,
      1801,
      7341,
      1001,
      5568,
      1254,
      1176,
      6171,
      872,
      4229,
      1258,
      969,
      894,
      7342,
      2162,
      267,
      589,
      590,
      1265,
      6173,
      591,
      390,
      978,
      705,
      1275,
      7343,
      6194,
      1206
    ],
  ),
  "diversity_2": SymbolsMetadata(
    popularity: 2861,
    codepoint: 0xf8d8,
    categories: [3],
    tags: [
      7344,
      193,
      3191,
      1249,
      1800,
      4479,
      7345,
      7340,
      1801,
      1802,
      1001,
      1254,
      1176,
      6171,
      7346,
      4229,
      583,
      7347,
      1258,
      969,
      894,
      7348,
      267,
      589,
      590,
      1265,
      6173,
      591,
      1266,
      390,
      705,
      6174,
      1275,
      6650,
      7349,
      4570,
      1027,
      1206
    ],
  ),
  "diversity_3": SymbolsMetadata(
    popularity: 8091,
    codepoint: 0xf8d9,
    categories: [3],
    tags: [
      1249,
      1800,
      7350,
      6170,
      4479,
      2401,
      7351,
      7340,
      1801,
      7352,
      7353,
      1001,
      1254,
      1176,
      7354,
      6171,
      1258,
      894,
      5611,
      267,
      589,
      7355,
      1265,
      591,
      705,
      1275,
      7356,
      1205,
      1206,
      7357,
      7358
    ],
  ),
  "diversity_4": SymbolsMetadata(
    popularity: 285,
    codepoint: 0xf857,
    categories: [3],
    tags: [
      1168,
      3191,
      1249,
      1800,
      284,
      7359,
      7340,
      7360,
      1801,
      1001,
      627,
      7361,
      7362,
      1254,
      1176,
      6337,
      6171,
      4229,
      7363,
      583,
      1258,
      894,
      7342,
      4624,
      267,
      589,
      1265,
      705,
      7364,
      1275,
      7356,
      6650,
      6194,
      4570,
      1206
    ],
  ),
  "dns": SymbolsMetadata(
    popularity: 4993,
    codepoint: 0xe875,
    categories: [11],
    tags: [
      480,
      1493,
      1756,
      517,
      1076,
      283,
      678,
      284,
      81,
      7365,
      5455,
      7366,
      1081,
      320,
      7367,
      68,
      259,
      4738,
      4739,
      88,
      5804,
      3635,
      267,
      28,
      2971,
      71,
      31,
      1068,
      65,
      1510,
      1164,
      334
    ],
  ),
  "do_not_disturb_off": SymbolsMetadata(
    popularity: 891,
    codepoint: 0xe643,
    categories: [2],
    tags: [
      860,
      747,
      7368,
      3956,
      1403,
      1187,
      193,
      1188,
      2399,
      5905,
      1189,
      1138,
      867,
      4212,
      7369,
      7370,
      7371,
      7372,
      1033,
      7373,
      1200,
      7374,
      7375,
      7376,
      1035,
      7377,
      1037,
      70,
      7378,
      7379,
      1039,
      2095,
      71,
      1283,
      7380,
      7381,
      1203,
      4298,
      7382,
      7383,
      7384,
      7385,
      7386
    ],
  ),
  "do_not_disturb_on": SymbolsMetadata(
    popularity: 8755,
    codepoint: 0xe644,
    categories: [2],
    tags: [
      1339,
      1211,
      481,
      2579,
      1187,
      193,
      1188,
      345,
      2399,
      5905,
      1189,
      7387,
      867,
      4212,
      7371,
      4213,
      1033,
      5922,
      4214,
      87,
      1232,
      1281,
      3254,
      609,
      1035,
      1037,
      1009,
      2126,
      7388,
      1039,
      1040,
      71,
      1283,
      2128,
      7389,
      291,
      1203,
      4299,
      554
    ],
  ),
  "do_not_disturb_on_total_silence": SymbolsMetadata(
    popularity: 344,
    codepoint: 0xeffb,
    categories: [4],
    tags: [
      7390,
      1211,
      749,
      7391,
      193,
      867,
      4212,
      7392,
      7371,
      4213,
      1746,
      7393,
      87,
      4997,
      4918,
      1281,
      3254,
      2124,
      6530,
      7394,
      1236,
      1035,
      7395,
      4218,
      2126,
      1970,
      1283,
      1041,
      1935,
      1203,
      7396,
      1498
    ],
  ),
  "do_not_step": SymbolsMetadata(
    popularity: 275,
    codepoint: 0xf19f,
    categories: [16],
    tags: [
      1339,
      7397,
      1109,
      1342,
      193,
      1345,
      867,
      7371,
      7398,
      1033,
      689,
      3742,
      3743,
      3745,
      1191,
      1829,
      4373,
      550,
      468,
      2588,
      7399,
      7394,
      1035,
      4217,
      1037,
      2594,
      1970,
      1126,
      702,
      7400,
      7401,
      1162,
      1041,
      7402,
      877,
      2878,
      3753,
      1203,
      31,
      909,
      206
    ],
  ),
  "do_not_touch": SymbolsMetadata(
    popularity: 452,
    codepoint: 0xf1b0,
    categories: [16],
    tags: [
      1028,
      2776,
      7403,
      3726,
      1342,
      7404,
      345,
      1793,
      7405,
      867,
      7371,
      7406,
      1033,
      5922,
      1795,
      2663,
      1191,
      2664,
      3363,
      2666,
      1603,
      4214,
      7407,
      7394,
      6239,
      1035,
      4217,
      1037,
      1144,
      7408,
      4218,
      1970,
      5228,
      702,
      7409,
      1041,
      1203,
      1798,
      206
    ],
  ),
  "dock": SymbolsMetadata(
    popularity: 250,
    codepoint: 0xe30e,
    categories: [11],
    tags: [
      1223,
      1224,
      1869,
      1300,
      7047,
      1227,
      3825,
      193,
      1047,
      284,
      4929,
      608,
      288,
      4107,
      7410,
      1743,
      2532,
      1086,
      1230,
      1087,
      1305,
      1322,
      262,
      1732,
      4251,
      271,
      2494,
      3927,
      2474,
      3645,
      432,
      2526,
      1695,
      4111,
      3516,
      762,
      525,
      65
    ],
  ),
  "dock_to_bottom": SymbolsMetadata(
    popularity: 34,
    codepoint: 0xf7e6,
    categories: [4],
    tags: [
      7411,
      2166,
      1500,
      1447,
      1300,
      7047,
      1108,
      2204,
      7412,
      3322,
      4107,
      7413,
      1140,
      348,
      582,
      385,
      7414,
      1063,
      1749,
      4595,
      1733,
      326,
      7415,
      329,
      7416,
      2882,
      7417,
      7418,
      7419,
      97,
      1326,
      1165,
      2949
    ],
  ),
  "dock_to_left": SymbolsMetadata(
    popularity: 192,
    codepoint: 0xf7e5,
    categories: [4],
    tags: [
      1738,
      2166,
      1500,
      76,
      1300,
      3322,
      345,
      313,
      4107,
      1140,
      581,
      2814,
      385,
      2216,
      586,
      70,
      507,
      1749,
      4595,
      329,
      2243,
      71,
      1452,
      2896,
      7418,
      396,
      1165,
      2949
    ],
  ),
  "dock_to_right": SymbolsMetadata(
    popularity: 76,
    codepoint: 0xf7e4,
    categories: [4],
    tags: [
      2166,
      2185,
      1447,
      77,
      7420,
      482,
      8,
      4107,
      7421,
      2173,
      2202,
      385,
      7422,
      92,
      1749,
      7423,
      4595,
      329,
      7424,
      432,
      7425,
      410,
      1452,
      2896,
      7426,
      7418,
      433,
      4434,
      7427,
      396,
      1165,
      7428,
      2949
    ],
  ),
  "docs": SymbolsMetadata(
    popularity: 2755,
    codepoint: 0xea7d,
    categories: [12],
    tags: [
      2430,
      2154,
      919,
      621,
      2434,
      81,
      1566,
      1567,
      7429,
      7430,
      3016,
      7431,
      7432,
      7433,
      1675,
      147,
      2161,
      1678,
      488,
      68,
      2438,
      1573,
      1372,
      1574,
      1575,
      3029,
      453,
      1408,
      1576,
      2797,
      33,
      1498,
      1465
    ],
    rtlAutoMirrored: true,
  ),
  "docs_add_on": SymbolsMetadata(
    popularity: 749,
    codepoint: 0xf0c2,
    categories: [12],
    tags: [
      743,
      4992,
      621,
      1302,
      1567,
      7434,
      2172,
      2561,
      147,
      7435,
      1305,
      584,
      886,
      1372,
      1574,
      7436,
      1575,
      7437,
      4994,
      239,
      240,
      3021,
      432,
      433,
      1951,
      33
    ],
  ),
  "docs_apps_script": SymbolsMetadata(
    popularity: 163,
    codepoint: 0xf0c3,
    categories: [12],
    tags: [
      501,
      4993,
      1890,
      2555,
      1673,
      1077,
      1302,
      574,
      81,
      1292,
      1080,
      1567,
      2172,
      3334,
      1313,
      147,
      1084,
      7438,
      4086,
      5710,
      523,
      1099,
      5984,
      3022,
      645,
      1296,
      333,
      2949,
      1578
    ],
  ),
  "document_scanner": SymbolsMetadata(
    popularity: 2329,
    codepoint: 0xe5fa,
    categories: [12],
    tags: [
      1288,
      501,
      2432,
      1108,
      919,
      40,
      42,
      3008,
      81,
      288,
      44,
      1566,
      1567,
      1675,
      147,
      2161,
      1678,
      348,
      137,
      49,
      1322,
      584,
      262,
      1573,
      1372,
      2350,
      1574,
      1575,
      271,
      59,
      906,
      62,
      3737,
      432,
      1736,
      1737,
      1576,
      2797,
      31,
      65,
      33,
      141,
      1327,
      1390,
      1465
    ],
  ),
  "document_search": SymbolsMetadata(
    popularity: 135,
    codepoint: 0xf385,
    categories: [12],
    tags: [
      2673,
      81,
      2341,
      1566,
      1567,
      7439,
      1675,
      5803,
      147,
      83,
      317,
      7440,
      2161,
      1678,
      488,
      1085,
      68,
      1087,
      5403,
      5484,
      5485,
      2345,
      1091,
      2346,
      1092,
      1093,
      2348,
      7441,
      1574,
      1575,
      2352,
      453,
      3385,
      1736,
      1102,
      7442,
      7443,
      1103,
      1576,
      2797,
      33,
      1465
    ],
  ),
  "domain": SymbolsMetadata(
    popularity: 4877,
    codepoint: 0xe7ee,
    categories: [9],
    tags: [
      1493,
      2543,
      1476,
      918,
      919,
      193,
      283,
      2321,
      284,
      5455,
      2547,
      319,
      320,
      1116,
      138,
      259,
      1294,
      325,
      267,
      523,
      327,
      2550,
      390,
      1482,
      1483,
      330,
      1484,
      331,
      31,
      65,
      141,
      1510,
      333,
      7444,
      1164,
      334,
      5230
    ],
  ),
  "domain_add": SymbolsMetadata(
    popularity: 896,
    codepoint: 0xeb62,
    categories: [9],
    tags: [
      231,
      743,
      7445,
      7446,
      7447,
      2543,
      1298,
      1476,
      918,
      919,
      193,
      284,
      254,
      1302,
      5455,
      2547,
      1303,
      320,
      1116,
      7448,
      7449,
      1314,
      259,
      4739,
      1306,
      1294,
      267,
      886,
      327,
      239,
      2550,
      977,
      1482,
      1483,
      2971,
      1484,
      1025,
      331,
      31,
      1510,
      333,
      1164,
      334,
      5230
    ],
  ),
  "domain_disabled": SymbolsMetadata(
    popularity: 709,
    codepoint: 0xe0ef,
    categories: [9],
    tags: [
      1028,
      2543,
      1476,
      3726,
      918,
      919,
      193,
      1365,
      1138,
      867,
      5455,
      7450,
      7451,
      7452,
      7453,
      7454,
      7455,
      7456,
      1033,
      2547,
      320,
      1116,
      259,
      7457,
      7458,
      7459,
      7460,
      7461,
      1520,
      1035,
      1372,
      1036,
      1037,
      327,
      1009,
      2550,
      1482,
      1483,
      1970,
      1011,
      1041,
      331,
      7462,
      333,
      7463,
      7464,
      7465,
      1164,
      7466
    ],
  ),
  "domain_verification": SymbolsMetadata(
    popularity: 1079,
    codepoint: 0xef4c,
    categories: [6],
    tags: [
      858,
      1288,
      7467,
      1658,
      2653,
      3150,
      1539,
      1660,
      193,
      463,
      2657,
      254,
      485,
      5455,
      2342,
      319,
      320,
      1322,
      322,
      259,
      385,
      324,
      1143,
      267,
      1663,
      5226,
      410,
      1011,
      362,
      2790,
      1665,
      7468,
      141,
      1327,
      2355,
      2650,
      4799,
      1562,
      7469,
      333,
      1164,
      1165,
      334,
      5230,
      1668
    ],
  ),
  "domain_verification_off": SymbolsMetadata(
    popularity: 18,
    codepoint: 0xf7b0,
    categories: [6],
    tags: [
      1028,
      1288,
      7467,
      1658,
      1019,
      3726,
      1660,
      193,
      463,
      1213,
      5905,
      485,
      1138,
      867,
      5455,
      2342,
      1033,
      2694,
      2695,
      1200,
      1322,
      259,
      5153,
      385,
      87,
      1143,
      6816,
      7470,
      1035,
      1036,
      1663,
      1037,
      523,
      1970,
      410,
      1011,
      362,
      2790,
      1041,
      1203,
      1665,
      141,
      7462,
      1042,
      7471,
      1327,
      2355,
      4420,
      4799,
      1562,
      333,
      1164,
      1165,
      5230,
      1668
    ],
  ),
  "domino_mask": SymbolsMetadata(
    popularity: 107,
    codepoint: 0xf5e4,
    categories: [3],
    tags: [
      1869,
      3442,
      6103,
      6105,
      5,
      7472,
      7473,
      7474,
      7475,
      7476,
      7477,
      4856,
      576,
      7478,
      5708,
      7479,
      969,
      6117,
      6118,
      7480,
      6707,
      588,
      641,
      1009,
      7481,
      7482,
      392,
      7483,
      7484,
      7485,
      3329,
      7486
    ],
  ),
  "done_all": SymbolsMetadata(
    popularity: 9119,
    codepoint: 0xe877,
    categories: [2],
    tags: [
      3,
      2302,
      7487,
      2634,
      1658,
      2653,
      1660,
      3095,
      7488,
      463,
      5880,
      4445,
      2657,
      2340,
      2342,
      7489,
      2639,
      51,
      1056,
      88,
      1143,
      585,
      2162,
      1663,
      1065,
      3366,
      362,
      7490,
      594,
      291,
      245,
      1497,
      5595,
      1665,
      5648,
      7491,
      2649,
      2355,
      4420,
      1562,
      2949,
      1668
    ],
  ),
  "done_outline": SymbolsMetadata(
    popularity: 7815,
    codepoint: 0xe92f,
    categories: [2],
    tags: [
      2629,
      3,
      2430,
      2302,
      2634,
      1658,
      2653,
      1660,
      3704,
      463,
      1662,
      2657,
      5597,
      2340,
      2342,
      2639,
      7492,
      1143,
      1663,
      289,
      907,
      362,
      363,
      1162,
      291,
      245,
      1497,
      5595,
      1665,
      2355,
      4420,
      4799,
      1562,
      1668
    ],
  ),
  "donut_large": SymbolsMetadata(
    popularity: 1680,
    codepoint: 0xe917,
    categories: [9],
    tags: [
      2504,
      2505,
      1045,
      373,
      193,
      463,
      1662,
      81,
      375,
      8,
      7493,
      7494,
      2240,
      3549,
      2296,
      1691,
      1052,
      1055,
      3431,
      1955,
      3551,
      754,
      5893,
      226,
      1060,
      7495,
      7496,
      757,
      2510,
      760,
      410,
      2022,
      744,
      291,
      7497,
      1070,
      514,
      7498
    ],
  ),
  "donut_small": SymbolsMetadata(
    popularity: 1329,
    codepoint: 0xe918,
    categories: [9],
    tags: [
      1045,
      373,
      193,
      462,
      1405,
      81,
      375,
      7493,
      7499,
      1052,
      7500,
      3493,
      293,
      1055,
      3431,
      226,
      1060,
      5018,
      3606,
      3644,
      7495,
      757,
      3173,
      1408,
      760,
      330,
      2449,
      3837,
      1972,
      744,
      291,
      3039,
      1070,
      514
    ],
  ),
  "door_back": SymbolsMetadata(
    popularity: 347,
    codepoint: 0xeffc,
    categories: [8],
    tags: [
      858,
      2433,
      2776,
      1188,
      4204,
      1138,
      4924,
      7501,
      7502,
      901,
      1568,
      3007,
      1190,
      2786,
      580,
      1116,
      1628,
      1479,
      7503,
      2910,
      7504,
      7505,
      2876,
      7506,
      7507,
      5227,
      2787,
      432,
      1100,
      7508,
      1624,
      7509
    ],
  ),
  "door_front": SymbolsMetadata(
    popularity: 1080,
    codepoint: 0xeffd,
    categories: [8],
    tags: [
      858,
      7510,
      918,
      1188,
      4204,
      4924,
      7501,
      1478,
      901,
      1568,
      7511,
      1190,
      5086,
      7512,
      5218,
      580,
      1116,
      1479,
      2910,
      2876,
      7506,
      7507,
      5227,
      1480,
      432,
      7513,
      1011,
      1484,
      945,
      553,
      1624,
      6247
    ],
  ),
  "door_open": SymbolsMetadata(
    popularity: 1364,
    codepoint: 0xe77c,
    categories: [10],
    tags: [
      858,
      5078,
      1135,
      288,
      4924,
      7502,
      901,
      1568,
      3007,
      1190,
      5218,
      1116,
      2910,
      87,
      7514,
      1034,
      1119,
      2876,
      7506,
      289,
      2362,
      7507,
      5227,
      432,
      392,
      1317,
      433,
      553
    ],
  ),
  "door_sensor": SymbolsMetadata(
    popularity: 151,
    codepoint: 0xe28a,
    categories: [10],
    tags: [
      1338,
      1890,
      4204,
      3123,
      7515,
      7076,
      288,
      4924,
      7516,
      901,
      7517,
      1190,
      580,
      1116,
      3125,
      5098,
      51,
      3126,
      1119,
      7137,
      2876,
      696,
      702,
      1011,
      4731,
      64,
      1899,
      291,
      65,
      6436,
      278
    ],
  ),
  "door_sliding": SymbolsMetadata(
    popularity: 384,
    codepoint: 0xeffe,
    categories: [8],
    tags: [
      858,
      1476,
      2048,
      3331,
      1890,
      2776,
      918,
      1188,
      4924,
      7501,
      3001,
      901,
      1568,
      1190,
      3692,
      1085,
      1116,
      3125,
      1628,
      1479,
      2720,
      353,
      468,
      2876,
      7506,
      7507,
      5227,
      1480,
      432,
      1884,
      7518,
      7519,
      433,
      553,
      394,
      2108
    ],
  ),
  "doorbell": SymbolsMetadata(
    popularity: 347,
    codepoint: 0xefff,
    categories: [8],
    tags: [
      858,
      1338,
      1339,
      2543,
      1246,
      1341,
      1343,
      2090,
      7520,
      4924,
      7521,
      7522,
      901,
      1116,
      3125,
      5098,
      1479,
      3126,
      609,
      7523,
      7524,
      1372,
      760,
      7525,
      2095,
      1011,
      1899,
      7526,
      1271,
      7527,
      5667
    ],
  ),
  "doorbell_3p": SymbolsMetadata(
    popularity: 182,
    codepoint: 0xe1e7,
    categories: [8],
    tags: [
      858,
      747,
      1338,
      1339,
      4646,
      2879,
      1246,
      7528,
      1341,
      918,
      504,
      2089,
      1343,
      7522,
      901,
      7529,
      1568,
      1116,
      1479,
      4881,
      1119,
      609,
      3861,
      1236,
      1348,
      432,
      1350,
      760,
      7530,
      7531,
      1011,
      7532,
      1899,
      1271,
      7533,
      5667
    ],
  ),
  "doorbell_chime": SymbolsMetadata(
    popularity: 135,
    codepoint: 0xe1f3,
    categories: [10],
    tags: [
      7534,
      1338,
      1339,
      1246,
      1341,
      1343,
      288,
      7535,
      7522,
      901,
      1568,
      1116,
      1479,
      7536,
      7537,
      1119,
      609,
      2447,
      760,
      3877,
      1011,
      273,
      1899,
      1271,
      7538,
      7539,
      1754,
      554,
      1867
    ],
  ),
  "double_arrow": SymbolsMetadata(
    popularity: 7945,
    codepoint: 0xea50,
    categories: [2],
    tags: [
      480,
      77,
      7540,
      502,
      2917,
      313,
      3001,
      2920,
      3261,
      1051,
      1142,
      51,
      87,
      812,
      586,
      468,
      2162,
      325,
      2924,
      1619,
      2890,
      1144,
      2788,
      907,
      470,
      6203,
      1162,
      1317,
      3584,
      2409,
      31,
      526,
      1848
    ],
    rtlAutoMirrored: true,
  ),
  "downhill_skiing": SymbolsMetadata(
    popularity: 734,
    codepoint: 0xe509,
    categories: [15],
    tags: [
      746,
      2504,
      3607,
      7541,
      7542,
      684,
      838,
      7543,
      7544,
      1252,
      779,
      46,
      11,
      225,
      2533,
      2741,
      7545,
      583,
      1975,
      1584,
      1836,
      589,
      641,
      590,
      3282,
      7546,
      7547,
      7548,
      4939,
      7549,
      852,
      275,
      30,
      3472,
      709,
      332,
      1952,
      857
    ],
  ),
  "download": SymbolsMetadata(
    popularity: 19146,
    codepoint: 0xf090,
    categories: [2],
    tags: [
      7550,
      746,
      1288,
      501,
      2154,
      77,
      1403,
      504,
      1673,
      519,
      345,
      81,
      1567,
      2778,
      520,
      7551,
      1675,
      147,
      5930,
      2311,
      1692,
      259,
      87,
      586,
      267,
      7552,
      2890,
      961,
      1683,
      1685,
      31,
      526,
      7553,
      527
    ],
  ),
  "download_2": SymbolsMetadata(
    popularity: 67,
    codepoint: 0xf523,
    categories: [2],
    tags: [
      746,
      77,
      504,
      1673,
      519,
      81,
      313,
      1567,
      2778,
      520,
      7551,
      1675,
      1140,
      1690,
      147,
      5930,
      137,
      138,
      68,
      1692,
      259,
      1144,
      961,
      1683,
      392,
      509,
      1685,
      31,
      65,
      526,
      527
    ],
  ),
  "download_done": SymbolsMetadata(
    popularity: 2295,
    codepoint: 0xf091,
    categories: [2],
    tags: [
      77,
      7554,
      502,
      1660,
      2113,
      463,
      7555,
      7556,
      4445,
      1567,
      7557,
      2342,
      2778,
      2830,
      7558,
      520,
      7559,
      7560,
      7561,
      7562,
      7551,
      1675,
      147,
      7563,
      7564,
      7565,
      7566,
      2639,
      7567,
      7568,
      1692,
      4796,
      1663,
      1575,
      7569,
      245,
      7570,
      7571,
      1665,
      527
    ],
  ),
  "download_for_offline": SymbolsMetadata(
    popularity: 4233,
    codepoint: 0xf000,
    categories: [2],
    tags: [
      858,
      77,
      7572,
      1672,
      7573,
      193,
      1673,
      7574,
      7575,
      284,
      608,
      2778,
      520,
      7576,
      7577,
      2959,
      7578,
      7579,
      1692,
      259,
      267,
      7580,
      1036,
      7581,
      2761,
      7582,
      1683,
      7583,
      1685,
      1377,
      762,
      3435,
      526,
      527
    ],
  ),
  "downloading": SymbolsMetadata(
    popularity: 3585,
    codepoint: 0xf001,
    categories: [2],
    tags: [
      77,
      193,
      1673,
      7584,
      81,
      2778,
      2830,
      520,
      7585,
      2992,
      7586,
      7587,
      7588,
      7551,
      2959,
      51,
      1692,
      259,
      7589,
      754,
      267,
      2569,
      756,
      757,
      2775,
      1705,
      961,
      2761,
      291,
      5887,
      526,
      4254,
      5931,
      527,
      764,
      7590
    ],
  ),
  "draft": SymbolsMetadata(
    popularity: 6324,
    codepoint: 0xe66d,
    categories: [12],
    tags: [
      1670,
      2432,
      7591,
      7592,
      621,
      7593,
      81,
      7594,
      7595,
      1566,
      1567,
      2435,
      4464,
      1675,
      7596,
      147,
      2436,
      2161,
      1678,
      488,
      68,
      3236,
      1460,
      7597,
      1574,
      1575,
      453,
      1408,
      1576,
      2797,
      1685,
      33
    ],
    rtlAutoMirrored: true,
  ),
  "draft_orders": SymbolsMetadata(
    popularity: 61,
    codepoint: 0xe7b3,
    categories: [6],
    tags: [
      1756,
      1642,
      919,
      1644,
      924,
      1564,
      1302,
      1567,
      4464,
      1646,
      1229,
      673,
      582,
      3493,
      1087,
      1356,
      584,
      88,
      1004,
      1571,
      1460,
      91,
      1575,
      3062,
      2599,
      2569,
      3568,
      1652,
      1653,
      453,
      1374,
      1376,
      33,
      5064,
      1578,
      1465
    ],
  ),
  "drafts": SymbolsMetadata(
    popularity: 2730,
    codepoint: 0xe151,
    categories: [7],
    tags: [
      2154,
      283,
      7598,
      7599,
      81,
      1567,
      4464,
      7600,
      2308,
      2310,
      147,
      2161,
      2464,
      970,
      3493,
      16,
      88,
      2312,
      1571,
      585,
      1460,
      1575,
      2569,
      3366,
      4421,
      594,
      1577,
      1685,
      33,
      7601,
      5064,
      7602,
      1465
    ],
  ),
  "drag_click": SymbolsMetadata(
    popularity: 52,
    codepoint: 0xf71f,
    categories: [2],
    tags: [
      746,
      77,
      504,
      1076,
      1790,
      1791,
      345,
      1793,
      575,
      1140,
      1795,
      2664,
      2780,
      2666,
      2140,
      51,
      1087,
      7110,
      1603,
      505,
      2936,
      586,
      492,
      1144,
      1096,
      5591,
      6277,
      362,
      363,
      7603,
      1797,
      511,
      1798,
      4423,
      3302
    ],
  ),
  "drag_handle": SymbolsMetadata(
    popularity: 3831,
    codepoint: 0xe25d,
    categories: [12],
    tags: [
      746,
      1288,
      7604,
      517,
      2675,
      345,
      485,
      575,
      1140,
      577,
      580,
      7605,
      51,
      467,
      1322,
      1356,
      385,
      584,
      88,
      5617,
      506,
      586,
      2236,
      4613,
      592,
      7606,
      410,
      2790,
      95,
      7607,
      97,
      141,
      1327,
      1445,
      333,
      1164,
      6796,
      1165
    ],
  ),
  "drag_indicator": SymbolsMetadata(
    popularity: 7122,
    codepoint: 0xe945,
    categories: [2],
    tags: [
      746,
      1288,
      501,
      1076,
      1419,
      2675,
      345,
      485,
      1081,
      575,
      2849,
      1140,
      2664,
      7608,
      577,
      580,
      138,
      51,
      7609,
      1603,
      1322,
      1356,
      385,
      88,
      174,
      506,
      262,
      623,
      586,
      92,
      271,
      848,
      329,
      4613,
      592,
      410,
      2852,
      392,
      6203,
      2790,
      95,
      525,
      1798,
      141,
      1327,
      1445,
      333,
      1164,
      1165
    ],
  ),
  "drag_pan": SymbolsMetadata(
    popularity: 124,
    codepoint: 0xf71e,
    categories: [2],
    tags: [
      1738,
      7610,
      7611,
      77,
      502,
      1791,
      1793,
      313,
      2293,
      2402,
      7612,
      2778,
      575,
      7613,
      1303,
      7614,
      7608,
      2666,
      2216,
      2936,
      586,
      7615,
      325,
      2876,
      6498,
      7616,
      1144,
      2882,
      2951,
      907,
      2802,
      362,
      363,
      7603,
      6203,
      2797,
      1696,
      7617
    ],
  ),
  "draw": SymbolsMetadata(
    popularity: 5946,
    codepoint: 0xe746,
    categories: [12],
    tags: [
      1580,
      2155,
      1564,
      7618,
      1302,
      2299,
      2885,
      485,
      7619,
      1743,
      4464,
      2748,
      1229,
      673,
      488,
      7620,
      137,
      7621,
      384,
      2641,
      1087,
      87,
      174,
      1636,
      289,
      3062,
      2599,
      328,
      7622,
      392,
      4516,
      511,
      1578,
      1465
    ],
  ),
  "draw_abstract": SymbolsMetadata(
    popularity: 106,
    codepoint: 0xf7f8,
    categories: [12],
    tags: [
      480,
      7623,
      1580,
      4815,
      1564,
      2321,
      5376,
      1302,
      2299,
      2885,
      485,
      375,
      4464,
      2748,
      378,
      1229,
      673,
      6110,
      1051,
      7624,
      381,
      2664,
      137,
      138,
      384,
      7625,
      1087,
      87,
      353,
      1835,
      3336,
      7626,
      7622,
      392,
      5479,
      4516,
      7627,
      31,
      476,
      1866
    ],
  ),
  "draw_collage": SymbolsMetadata(
    popularity: 23,
    codepoint: 0xf7f7,
    categories: [12],
    tags: [
      7623,
      1320,
      76,
      1580,
      7628,
      3333,
      1175,
      1301,
      7629,
      1564,
      2265,
      5376,
      1302,
      7630,
      1581,
      485,
      4464,
      2748,
      378,
      1229,
      673,
      6606,
      1321,
      2664,
      382,
      2499,
      1087,
      385,
      7631,
      7632,
      7633,
      4792,
      7634,
      7635,
      7636,
      392,
      5479,
      7627,
      7637
    ],
  ),
  "dresser": SymbolsMetadata(
    popularity: 346,
    codepoint: 0xe210,
    categories: [8],
    tags: [
      1310,
      4004,
      7638,
      7639,
      2607,
      2609,
      7640,
      7641,
      379,
      4008,
      137,
      1116,
      581,
      2717,
      1479,
      1880,
      138,
      1356,
      584,
      5319,
      1119,
      492,
      1063,
      906,
      432,
      1317,
      595,
      1685,
      1377,
      31,
      2626
    ],
  ),
  "drive_export": SymbolsMetadata(
    popularity: 61,
    codepoint: 0xf41d,
    categories: [12],
    tags: [
      1288,
      501,
      77,
      1672,
      482,
      7638,
      1673,
      1724,
      81,
      1448,
      313,
      1567,
      520,
      1675,
      1690,
      147,
      1677,
      1678,
      1679,
      1680,
      7642,
      586,
      325,
      523,
      2361,
      1682,
      907,
      1683,
      2318,
      2971,
      1508,
      1685,
      1068,
      526,
      1696,
      527
    ],
    rtlAutoMirrored: true,
  ),
  "drive_file_move": SymbolsMetadata(
    popularity: 1106,
    codepoint: 0xe675,
    categories: [12],
    tags: [
      746,
      76,
      77,
      504,
      1673,
      1724,
      81,
      7643,
      313,
      1566,
      1567,
      1675,
      1676,
      147,
      3018,
      2161,
      902,
      137,
      138,
      2094,
      586,
      325,
      1063,
      2882,
      907,
      2318,
      1576,
      2797,
      1685,
      31,
      526,
      1848,
      1326
    ],
    rtlAutoMirrored: true,
  ),
  "drive_folder_upload": SymbolsMetadata(
    popularity: 1105,
    codepoint: 0xe9a3,
    categories: [12],
    tags: [
      743,
      2154,
      77,
      1672,
      1673,
      519,
      1302,
      81,
      312,
      44,
      4769,
      1566,
      1567,
      1675,
      1690,
      147,
      2161,
      1582,
      259,
      586,
      267,
      886,
      523,
      1683,
      2318,
      1508,
      1576,
      2797,
      1685,
      65,
      526,
      1696,
      527
    ],
  ),
  "dropdown": SymbolsMetadata(
    popularity: 47,
    codepoint: 0xe9a4,
    categories: [2],
    tags: [
      1288,
      501,
      77,
      2848,
      2799,
      2675,
      345,
      485,
      313,
      2778,
      2840,
      1303,
      83,
      2864,
      2792,
      51,
      1322,
      385,
      88,
      506,
      262,
      623,
      237,
      325,
      70,
      271,
      1144,
      410,
      362,
      2022,
      2790,
      95,
      2684,
      525,
      1718,
      141,
      1327,
      333,
      1164,
      1165
    ],
  ),
  "dropper_eye": SymbolsMetadata(
    popularity: 8,
    codepoint: 0xf351,
    categories: [1],
    tags: [
      1756,
      1759,
      1760,
      4514,
      6073,
      1762,
      7644,
      2849,
      6075,
      5202,
      5740,
      5787,
      7645,
      2507,
      692,
      1765,
      1766,
      4186,
      895,
      1769,
      7646,
      7647,
      7648,
      1773,
      6079,
      7649,
      7650,
      7651,
      3116,
      511,
      1777,
      2735
    ],
  ),
  "dry": SymbolsMetadata(
    popularity: 206,
    codepoint: 0xf1b3,
    categories: [8],
    tags: [
      834,
      7652,
      1889,
      3499,
      504,
      2608,
      345,
      751,
      6504,
      7653,
      7654,
      2663,
      2664,
      2666,
      7655,
      2982,
      1880,
      51,
      7656,
      7657,
      635,
      7658,
      355,
      1749,
      151,
      71,
      472,
      291,
      31,
      7659,
      3797,
      7660,
      3520
    ],
  ),
  "dry_cleaning": SymbolsMetadata(
    popularity: 659,
    codepoint: 0xea58,
    categories: [5],
    tags: [
      2604,
      567,
      504,
      1759,
      5846,
      193,
      462,
      3788,
      2608,
      6504,
      7661,
      7653,
      2614,
      2616,
      5665,
      2717,
      1880,
      138,
      7662,
      7656,
      1729,
      2549,
      7663,
      758,
      645,
      1162,
      3784,
      31,
      1497,
      2624,
      413,
      7664,
      3797
    ],
  ),
  "dual_screen": SymbolsMetadata(
    popularity: 121,
    codepoint: 0xf6cf,
    categories: [4],
    tags: [
      1286,
      76,
      1447,
      519,
      1699,
      288,
      8,
      7149,
      7665,
      7666,
      7150,
      7667,
      1086,
      385,
      5440,
      623,
      7668,
      7041,
      92,
      7669,
      4251,
      271,
      1407,
      3021,
      7670,
      1752,
      7671,
      7672,
      65,
      7673,
      396,
      1130
    ],
  ),
  "duo": SymbolsMetadata(
    popularity: 709,
    codepoint: 0xe9a5,
    categories: [7],
    tags: [
      565,
      566,
      1248,
      569,
      3191,
      283,
      5083,
      288,
      3001,
      7665,
      1254,
      1176,
      267,
      3988,
      6649,
      589,
      590,
      591,
      4090,
      705,
      6650,
      4028,
      394,
      597,
      1206,
      37
    ],
  ),
  "dvr": SymbolsMetadata(
    popularity: 2080,
    codepoint: 0xe1b2,
    categories: [4],
    tags: [
      1223,
      1224,
      1889,
      1246,
      482,
      504,
      1698,
      193,
      519,
      345,
      1699,
      288,
      8,
      1743,
      7674,
      2527,
      2532,
      779,
      46,
      1894,
      137,
      1086,
      1230,
      138,
      88,
      1700,
      406,
      352,
      623,
      408,
      453,
      1268,
      440,
      432,
      1683,
      410,
      433,
      1377,
      31,
      65,
      2045,
      1326,
      37,
      7675,
      333,
      1165
    ],
    rtlAutoMirrored: true,
  ),
  "dynamic_feed": SymbolsMetadata(
    popularity: 1967,
    codepoint: 0xea14,
    categories: [6],
    tags: [
      7676,
      7677,
      7678,
      480,
      2504,
      2445,
      2284,
      3027,
      3500,
      4775,
      621,
      1855,
      81,
      1252,
      1726,
      7679,
      68,
      584,
      88,
      1260,
      2446,
      7680,
      3029,
      4781,
      432,
      433,
      2452,
      454,
      7681,
      2453,
      4097
    ],
  ),
  "dynamic_form": SymbolsMetadata(
    popularity: 1824,
    codepoint: 0xf1bf,
    categories: [2],
    tags: [
      7682,
      501,
      3893,
      3500,
      2398,
      1077,
      7683,
      621,
      81,
      2401,
      1567,
      1252,
      7684,
      3640,
      1568,
      1141,
      7685,
      147,
      1253,
      488,
      68,
      1087,
      3895,
      88,
      6798,
      2162,
      70,
      1575,
      150,
      7686,
      1408,
      363,
      71,
      1613,
      33,
      3896,
      7687
    ],
  ),
  "e911_avatar": SymbolsMetadata(
    popularity: 244,
    codepoint: 0xf11a,
    categories: [7],
    tags: [
      3074,
      7688,
      2421,
      1339,
      865,
      1340,
      566,
      684,
      1248,
      1342,
      1227,
      1760,
      965,
      1345,
      288,
      1761,
      2423,
      2694,
      1346,
      1459,
      225,
      7689,
      1086,
      692,
      1765,
      873,
      1766,
      7690,
      583,
      1347,
      3919,
      1143,
      895,
      7691,
      262,
      609,
      5870,
      289,
      2424,
      590,
      271,
      3081,
      591,
      696,
      1408,
      2425,
      702,
      978,
      878,
      31,
      1387,
      1718,
      597,
      206
    ],
  ),
  "e911_emergency": SymbolsMetadata(
    popularity: 1203,
    codepoint: 0xf119,
    categories: [13],
    tags: [
      7688,
      2420,
      1339,
      2422,
      865,
      1341,
      1248,
      283,
      1047,
      965,
      3076,
      1345,
      5055,
      45,
      7692,
      2423,
      5173,
      873,
      5243,
      1090,
      895,
      21,
      271,
      7693,
      2425,
      2095,
      702,
      1011,
      2137,
      2426,
      878,
      1387,
      2428,
      206
    ],
  ),
  "e_mobiledata": SymbolsMetadata(
    popularity: 130,
    codepoint: 0xf002,
    categories: [4],
    tags: [
      4,
      517,
      1227,
      7694,
      251,
      252,
      7695,
      284,
      254,
      81,
      7696,
      7697,
      7698,
      7699,
      7700,
      12,
      259,
      2080,
      16,
      262,
      7701,
      263,
      266,
      267,
      272,
      645,
      273,
      642,
      533,
      605,
      276,
      33,
      35,
      278,
      643
    ],
  ),
  "e_mobiledata_badge": SymbolsMetadata(
    popularity: 7,
    codepoint: 0xf7e3,
    categories: [4],
    tags: [
      858,
      4,
      281,
      251,
      252,
      5,
      193,
      283,
      284,
      254,
      81,
      7698,
      12,
      51,
      259,
      15,
      16,
      262,
      263,
      266,
      267,
      269,
      523,
      1010,
      273,
      291,
      31,
      65,
      276,
      33,
      35,
      338,
      7702,
      278
    ],
  ),
  "ear_sound": SymbolsMetadata(
    popularity: 50,
    codepoint: 0xf356,
    categories: [0],
    tags: [
      860,
      861,
      2421,
      7703,
      900,
      1246,
      7704,
      7705,
      7706,
      7707,
      684,
      7708,
      7709,
      7710,
      351,
      871,
      7711,
      692,
      1257,
      7712,
      7713,
      873,
      583,
      7714,
      1280,
      4482,
      895,
      3541,
      1124,
      7715,
      7716,
      1271,
      6081,
      554
    ],
  ),
  "earbud_case": SymbolsMetadata(
    popularity: 3,
    codepoint: 0xf327,
    categories: [11],
    tags: [
      1869,
      1246,
      3122,
      4903,
      3825,
      7717,
      6037,
      288,
      7718,
      7719,
      7720,
      7721,
      2532,
      1894,
      7722,
      4250,
      7723,
      7724,
      1280,
      4482,
      1701,
      2876,
      2528,
      432,
      2526,
      1271,
      1685,
      65,
      332,
      278
    ],
  ),
  "earbud_left": SymbolsMetadata(
    popularity: 7,
    codepoint: 0xf326,
    categories: [11],
    tags: [
      1869,
      1246,
      3122,
      7725,
      7726,
      7727,
      7719,
      7720,
      7728,
      2527,
      7722,
      7729,
      7730,
      2216,
      7731,
      1280,
      4482,
      1701,
      7732,
      7733,
      7734,
      7735,
      1271,
      7533,
      1272,
      65,
      7736,
      278
    ],
  ),
  "earbud_right": SymbolsMetadata(
    popularity: 4,
    codepoint: 0xf325,
    categories: [11],
    tags: [
      1869,
      1246,
      283,
      1048,
      288,
      7710,
      7726,
      7719,
      7720,
      779,
      1894,
      7722,
      1257,
      1002,
      1280,
      406,
      1701,
      911,
      408,
      2528,
      907,
      7737,
      3544,
      1271,
      65,
      2537,
      278
    ],
  ),
  "earbuds": SymbolsMetadata(
    popularity: 315,
    codepoint: 0xf003,
    categories: [11],
    tags: [
      1869,
      1246,
      3122,
      1048,
      4930,
      288,
      7719,
      7720,
      7721,
      2532,
      7722,
      4250,
      7729,
      1257,
      1280,
      4482,
      7738,
      406,
      7739,
      1701,
      3988,
      7733,
      408,
      7734,
      1271,
      3327,
      65,
      394,
      4933
    ],
  ),
  "earbuds_2": SymbolsMetadata(
    popularity: 14,
    codepoint: 0xf324,
    categories: [11],
    tags: [
      1869,
      1246,
      7740,
      3369,
      3122,
      4245,
      283,
      254,
      288,
      7741,
      7719,
      7720,
      7721,
      2527,
      779,
      7742,
      7722,
      4250,
      7729,
      1256,
      1280,
      4482,
      406,
      262,
      1701,
      4247,
      7733,
      2528,
      1271,
      7743,
      65,
      278
    ],
  ),
  "earbuds_battery": SymbolsMetadata(
    popularity: 192,
    codepoint: 0xf004,
    categories: [11],
    tags: [
      1869,
      1246,
      3637,
      3638,
      3825,
      254,
      1742,
      288,
      7719,
      7720,
      7728,
      2532,
      3641,
      1894,
      7722,
      4250,
      138,
      51,
      1322,
      790,
      1280,
      4482,
      7738,
      406,
      1701,
      3644,
      2528,
      3645,
      1271,
      291,
      31,
      65,
      1326,
      278
    ],
  ),
  "early_on": SymbolsMetadata(
    popularity: 283,
    codepoint: 0xe2ba,
    categories: [10],
    tags: [
      3369,
      2213,
      2104,
      837,
      7744,
      7745,
      7746,
      7747,
      7748,
      902,
      1116,
      7749,
      7750,
      352,
      679,
      1119,
      1037,
      408,
      7751,
      357,
      5720,
      7752,
      7753,
      7754,
      2218,
      454,
      411,
      7755,
      7756,
      7757,
      444
    ],
  ),
  "earthquake": SymbolsMetadata(
    popularity: 90,
    codepoint: 0xf64f,
    categories: [3],
    tags: [
      7758,
      1339,
      7759,
      373,
      1345,
      4368,
      4369,
      7760,
      7761,
      315,
      7762,
      7763,
      2423,
      7764,
      7765,
      7766,
      1829,
      4373,
      7767,
      226,
      623,
      6774,
      7768,
      1834,
      4376,
      7769,
      7770,
      7771,
      7772,
      7773,
      7774,
      7775,
      7776,
      2075,
      206,
      1867
    ],
  ),
  "east": SymbolsMetadata(
    popularity: 5057,
    codepoint: 0xf1df,
    categories: [5],
    tags: [
      500,
      77,
      309,
      313,
      2293,
      2931,
      1140,
      902,
      903,
      51,
      1617,
      87,
      1520,
      586,
      325,
      904,
      1619,
      328,
      1144,
      329,
      907,
      3136,
      31,
      332,
      1718
    ],
  ),
  "ecg": SymbolsMetadata(
    popularity: 43,
    codepoint: 0xf80f,
    categories: [11],
    tags: [
      1402,
      4943,
      5356,
      5363,
      373,
      2885,
      7777,
      1566,
      1761,
      4227,
      4228,
      7778,
      2423,
      1052,
      692,
      1765,
      4229,
      5359,
      4230,
      1406,
      17,
      895,
      1769,
      623,
      5870,
      5148,
      4233,
      359,
      4951,
      273,
      3063,
      4234,
      1866,
      3318
    ],
  ),
  "ecg_heart": SymbolsMetadata(
    popularity: 266,
    codepoint: 0xf6e9,
    categories: [15],
    tags: [
      5356,
      5363,
      373,
      1760,
      5867,
      5330,
      375,
      1566,
      1761,
      4227,
      7778,
      2423,
      2831,
      1052,
      692,
      4242,
      5364,
      1765,
      4229,
      5359,
      7779,
      4230,
      1766,
      87,
      895,
      4231,
      7780,
      623,
      5870,
      4233,
      359,
      4951,
      273,
      4234,
      4235,
      3318
    ],
  ),
  "eco": SymbolsMetadata(
    popularity: 6854,
    codepoint: 0xea35,
    categories: [3],
    tags: [
      7781,
      7782,
      7783,
      315,
      6212,
      7255,
      7784,
      7785,
      7786,
      1823,
      1856,
      3745,
      320,
      1828,
      1832,
      2374,
      1833,
      1834,
      1835,
      5226,
      1837,
      3433,
      6216,
      6218,
      4483,
      7787,
      1846,
      2334,
      334
    ],
  ),
  "eda": SymbolsMetadata(
    popularity: 44,
    codepoint: 0xf6e8,
    categories: [15],
    tags: [
      480,
      1738,
      1402,
      1246,
      2433,
      1403,
      373,
      345,
      2885,
      81,
      7788,
      7789,
      7790,
      2079,
      2663,
      2831,
      351,
      2664,
      1052,
      2666,
      5359,
      790,
      87,
      226,
      623,
      1701,
      3533,
      757,
      3536,
      390,
      273,
      1271,
      6081,
      291,
      97,
      2512,
      554,
      1866,
      3318
    ],
  ),
  "edgesensor_high": SymbolsMetadata(
    popularity: 275,
    codepoint: 0xf005,
    categories: [4],
    tags: [
      1223,
      1224,
      1339,
      517,
      1227,
      251,
      284,
      81,
      7076,
      288,
      599,
      7791,
      1086,
      3447,
      7792,
      1230,
      259,
      3126,
      17,
      262,
      1693,
      7793,
      586,
      267,
      609,
      271,
      6275,
      432,
      2526,
      2377,
      64,
      273,
      7794,
      642,
      525,
      65,
      2459,
      7795,
      278
    ],
  ),
  "edgesensor_low": SymbolsMetadata(
    popularity: 192,
    codepoint: 0xf006,
    categories: [4],
    tags: [
      1223,
      1224,
      1339,
      1890,
      7796,
      7797,
      517,
      4245,
      1227,
      193,
      284,
      345,
      7076,
      288,
      9,
      599,
      7791,
      3980,
      7798,
      7799,
      1086,
      3447,
      1230,
      51,
      2489,
      3126,
      7800,
      584,
      1968,
      3872,
      7801,
      17,
      262,
      1693,
      7793,
      586,
      267,
      6320,
      609,
      1733,
      271,
      3985,
      6275,
      1124,
      432,
      2526,
      2377,
      64,
      7802,
      7803,
      7804,
      273,
      1270,
      291,
      642,
      7805,
      7806,
      525,
      65,
      6436,
      1445,
      7795,
      5525,
      7807,
      277,
      278
    ],
  ),
  "edit": SymbolsMetadata(
    popularity: 49659,
    codepoint: 0xe3c9,
    categories: [1],
    tags: [
      746,
      1739,
      3025,
      2397,
      1564,
      345,
      1302,
      1567,
      1229,
      673,
      488,
      4118,
      1087,
      635,
      7808,
      7809,
      1636,
      886,
      289,
      3062,
      2599,
      2442,
      392,
      1147,
      33,
      511,
      890,
      1578,
      1465
    ],
  ),
  "edit_arrow_down": SymbolsMetadata(
    popularity: 18,
    codepoint: 0xf380,
    categories: [2],
    tags: [
      77,
      2848,
      2784,
      2799,
      1564,
      345,
      1302,
      313,
      2778,
      2840,
      1229,
      673,
      1303,
      1826,
      51,
      1087,
      506,
      1636,
      1618,
      325,
      886,
      3062,
      2599,
      328,
      1144,
      362,
      1718,
      1696,
      890,
      1578,
      1465
    ],
  ),
  "edit_arrow_up": SymbolsMetadata(
    popularity: 5,
    codepoint: 0xf37f,
    categories: [2],
    tags: [
      746,
      1738,
      1739,
      77,
      7810,
      6233,
      7811,
      2973,
      2848,
      2397,
      1564,
      345,
      2340,
      1302,
      313,
      2778,
      1229,
      7812,
      673,
      2974,
      2985,
      235,
      1087,
      1636,
      586,
      325,
      886,
      3062,
      2599,
      1144,
      7813,
      1718,
      1696,
      890,
      1719,
      1578,
      1465
    ],
  ),
  "edit_attributes": SymbolsMetadata(
    popularity: 546,
    codepoint: 0xe578,
    categories: [5],
    tags: [
      1738,
      1658,
      144,
      3290,
      2397,
      1660,
      463,
      573,
      1742,
      574,
      2342,
      1229,
      7814,
      7815,
      4118,
      137,
      138,
      2094,
      1143,
      1636,
      1663,
      70,
      289,
      1750,
      150,
      362,
      71,
      31,
      1665,
      511,
      1754,
      2355,
      1390,
      1562,
      1668
    ],
  ),
  "edit_audio": SymbolsMetadata(
    popularity: 30,
    codepoint: 0xf42d,
    categories: [0],
    tags: [
      1738,
      7816,
      1402,
      77,
      1246,
      7817,
      6343,
      1503,
      7818,
      1742,
      2885,
      7819,
      7076,
      1229,
      7820,
      2079,
      137,
      2216,
      790,
      1406,
      584,
      1636,
      7821,
      1701,
      1264,
      440,
      907,
      5844,
      71,
      1271,
      7822,
      2084,
      6081,
      3458,
      2164,
      7823,
      6349,
      5333,
      1277,
      554,
      1866,
      3318
    ],
  ),
  "edit_calendar": SymbolsMetadata(
    popularity: 4472,
    codepoint: 0xe742,
    categories: [6],
    tags: [
      4987,
      7824,
      1657,
      1916,
      2104,
      2397,
      1564,
      1302,
      1136,
      4715,
      2105,
      4464,
      1229,
      673,
      1140,
      10,
      138,
      1322,
      2094,
      1636,
      4988,
      4998,
      3062,
      2599,
      4989,
      1350,
      7825,
      1145,
      31,
      7826,
      890,
      1578,
      1465,
      4991
    ],
  ),
  "edit_document": SymbolsMetadata(
    popularity: 2147,
    codepoint: 0xf88c,
    categories: [12],
    tags: [
      500,
      1454,
      501,
      2397,
      1564,
      621,
      1302,
      81,
      1138,
      1566,
      1567,
      4464,
      1675,
      1229,
      673,
      147,
      2161,
      1678,
      488,
      68,
      1087,
      1636,
      1460,
      1574,
      1575,
      3062,
      2599,
      432,
      2442,
      7827,
      1041,
      433,
      33,
      890,
      1578,
      1465
    ],
  ),
  "edit_location": SymbolsMetadata(
    popularity: 814,
    codepoint: 0xe568,
    categories: [5],
    tags: [
      1493,
      2233,
      7824,
      1688,
      2397,
      310,
      3083,
      312,
      313,
      1229,
      3194,
      1528,
      7828,
      321,
      323,
      324,
      1520,
      174,
      1636,
      325,
      3062,
      2599,
      1751,
      326,
      327,
      328,
      329,
      3091,
      1683,
      1203,
      4435,
      332,
      890
    ],
  ),
  "edit_location_alt": SymbolsMetadata(
    popularity: 614,
    codepoint: 0xe1c5,
    categories: [5],
    tags: [
      1493,
      1738,
      1527,
      1739,
      2397,
      1564,
      310,
      2340,
      312,
      1229,
      7828,
      7829,
      323,
      324,
      174,
      1636,
      325,
      3062,
      2599,
      326,
      327,
      328,
      1144,
      329,
      2442,
      2790,
      3283,
      332,
      890,
      7830,
      7831,
      1578
    ],
  ),
  "edit_note": SymbolsMetadata(
    popularity: 14865,
    codepoint: 0xe745,
    categories: [12],
    tags: [
      6159,
      1564,
      7832,
      7833,
      1302,
      7593,
      1565,
      1567,
      4464,
      1229,
      7834,
      7835,
      7836,
      673,
      2172,
      147,
      1087,
      584,
      1571,
      1636,
      886,
      3235,
      1460,
      1572,
      1575,
      3062,
      2599,
      3091,
      33,
      1578,
      1465,
      7837
    ],
  ),
  "edit_notifications": SymbolsMetadata(
    popularity: 887,
    codepoint: 0xe525,
    categories: [6],
    tags: [
      747,
      1738,
      1338,
      1339,
      1341,
      7838,
      2397,
      1343,
      283,
      1564,
      573,
      1302,
      574,
      4464,
      378,
      1229,
      7839,
      673,
      381,
      1087,
      87,
      585,
      1636,
      7840,
      886,
      609,
      7841,
      1236,
      1348,
      70,
      3062,
      2599,
      912,
      1350,
      760,
      71,
      392,
      1271,
      7842,
      1578,
      1465
    ],
  ),
  "edit_off": SymbolsMetadata(
    popularity: 893,
    codepoint: 0xe950,
    categories: [12],
    tags: [
      3726,
      7843,
      1564,
      1302,
      1138,
      867,
      7844,
      7307,
      4464,
      1229,
      7845,
      7846,
      673,
      7847,
      1033,
      1191,
      138,
      1087,
      87,
      7848,
      886,
      7849,
      7850,
      7851,
      5936,
      1035,
      1036,
      1037,
      3062,
      7852,
      2599,
      7853,
      1970,
      7854,
      1041,
      7855,
      6369,
      1388,
      1042,
      1578,
      1465
    ],
  ),
  "edit_road": SymbolsMetadata(
    popularity: 472,
    codepoint: 0xef4d,
    categories: [5],
    tags: [
      1738,
      7824,
      2397,
      2885,
      312,
      313,
      2748,
      1229,
      321,
      1615,
      1617,
      4114,
      323,
      324,
      1520,
      1143,
      1636,
      586,
      325,
      1619,
      3062,
      2599,
      1620,
      1621,
      1531,
      511,
      1622,
      1848,
      332,
      1945,
      141,
      890,
      7856,
      1578
    ],
  ),
  "edit_square": SymbolsMetadata(
    popularity: 4550,
    codepoint: 0xf88d,
    categories: [6],
    tags: [
      1739,
      7824,
      1107,
      482,
      2397,
      1564,
      678,
      1311,
      3083,
      1302,
      574,
      1567,
      4464,
      1229,
      673,
      1826,
      488,
      348,
      1087,
      1636,
      3062,
      2599,
      150,
      7857,
      7858,
      2442,
      71,
      433,
      31,
      33,
      511,
      890,
      1578,
      1465
    ],
  ),
  "editor_choice": SymbolsMetadata(
    popularity: 305,
    codepoint: 0xf528,
    categories: [3],
    tags: [
      2628,
      2430,
      2634,
      1658,
      2653,
      3189,
      281,
      7859,
      1660,
      7860,
      677,
      342,
      193,
      463,
      1662,
      5880,
      4445,
      2657,
      2342,
      7861,
      7862,
      1922,
      235,
      51,
      1143,
      1663,
      239,
      358,
      3480,
      7863,
      3481,
      3482,
      907,
      362,
      2670,
      363,
      30,
      31,
      1497,
      1665,
      3483,
      4420,
      1562,
      3203,
      3484,
      3485,
      1668
    ],
  ),
  "egg": SymbolsMetadata(
    popularity: 1112,
    codepoint: 0xeacc,
    categories: [3],
    tags: [
      480,
      7864,
      3651,
      3652,
      4175,
      7865,
      4638,
      1825,
      2370,
      2372,
      4183,
      812,
      1834,
      492,
      1835,
      6707,
      7866,
      4641,
      1010,
      392,
      1317
    ],
  ),
  "egg_alt": SymbolsMetadata(
    popularity: 753,
    codepoint: 0xeac8,
    categories: [3],
    tags: [
      1815,
      4972,
      2138,
      3651,
      3652,
      4610,
      4174,
      4175,
      7867,
      3656,
      7868,
      4638,
      1824,
      2370,
      1858,
      1974,
      2372,
      4183,
      7869,
      506,
      1833,
      492,
      1835,
      6707,
      7866,
      4641,
      2376,
      392,
      7870,
      31,
      832
    ],
  ),
  "eject": SymbolsMetadata(
    popularity: 972,
    codepoint: 0xe8fb,
    categories: [2],
    tags: [
      746,
      77,
      1246,
      1403,
      504,
      1078,
      345,
      288,
      2159,
      2160,
      1675,
      7311,
      7871,
      1084,
      1086,
      87,
      406,
      439,
      1201,
      7872,
      2500,
      409,
      7873,
      1039,
      1203,
      31,
      1718,
      2220,
      1719,
      7874,
      1297,
      37
    ],
  ),
  "elderly": SymbolsMetadata(
    popularity: 1362,
    codepoint: 0xf21a,
    categories: [3],
    tags: [
      565,
      964,
      7875,
      6928,
      566,
      684,
      4192,
      1800,
      6929,
      3108,
      225,
      3446,
      583,
      969,
      1002,
      972,
      7876,
      7877,
      7878,
      589,
      590,
      974,
      591,
      1559,
      976,
      7879,
      7880,
      390,
      3115,
      978,
      597,
      981,
      7881
    ],
  ),
  "elderly_woman": SymbolsMetadata(
    popularity: 976,
    codepoint: 0xeb69,
    categories: [3],
    tags: [
      7882,
      566,
      684,
      4192,
      193,
      3108,
      1803,
      225,
      968,
      1804,
      7883,
      872,
      583,
      138,
      7884,
      7876,
      289,
      589,
      590,
      974,
      591,
      330,
      3115,
      392,
      1012,
      978,
      705,
      979,
      31,
      597,
      4677,
      3812
    ],
  ),
  "electric_bike": SymbolsMetadata(
    popularity: 487,
    codepoint: 0xeb1b,
    categories: [14],
    tags: [
      3637,
      7885,
      7886,
      4098,
      4100,
      3893,
      4105,
      4106,
      7887,
      7888,
      6213,
      3640,
      7889,
      7890,
      7891,
      3941,
      3879,
      1975,
      1520,
      896,
      7892,
      1836,
      7893,
      3645,
      7894,
      3282,
      2059,
      4124,
      275,
      3472,
      2334,
      3896,
      1623,
      332,
      4126,
      1486,
      1850,
      4128
    ],
    rtlAutoMirrored: true,
  ),
  "electric_bolt": SymbolsMetadata(
    popularity: 2808,
    codepoint: 0xec1c,
    categories: [8],
    tags: [
      1339,
      3637,
      3893,
      3825,
      1855,
      1345,
      1252,
      3640,
      7895,
      5555,
      3826,
      3879,
      3641,
      1141,
      4354,
      7896,
      3894,
      4718,
      3895,
      1119,
      641,
      3645,
      3067,
      4889,
      275,
      4355,
      7897,
      3896,
      2428,
      7086,
      206,
      856,
      4356
    ],
  ),
  "electric_car": SymbolsMetadata(
    popularity: 1289,
    codepoint: 0xeb1c,
    categories: [14],
    tags: [
      1816,
      3637,
      3893,
      1818,
      1819,
      3638,
      3825,
      4105,
      312,
      1675,
      6213,
      3640,
      3941,
      3879,
      3641,
      3980,
      1828,
      1617,
      1520,
      896,
      3927,
      3645,
      7898,
      1620,
      1621,
      3516,
      2334,
      3896,
      1848,
      1623,
      332,
      1850,
      7899
    ],
  ),
  "electric_meter": SymbolsMetadata(
    popularity: 728,
    codepoint: 0xec1b,
    categories: [8],
    tags: [
      7900,
      1396,
      3893,
      193,
      462,
      3971,
      1398,
      1405,
      81,
      1381,
      8,
      3640,
      7901,
      3879,
      3641,
      1141,
      3827,
      1116,
      51,
      4871,
      1616,
      3894,
      3895,
      226,
      17,
      3463,
      3470,
      6197,
      1119,
      1749,
      1144,
      3645,
      1483,
      7902,
      744,
      3896,
      3302,
      3989,
      7086,
      7903
    ],
  ),
  "electric_moped": SymbolsMetadata(
    popularity: 647,
    codepoint: 0xeb1d,
    categories: [14],
    tags: [
      1816,
      3637,
      4100,
      3893,
      1818,
      1819,
      3825,
      2544,
      2050,
      3640,
      7904,
      1520,
      7905,
      5245,
      4123,
      5329,
      2059,
      4124,
      1508,
      2044,
      3896,
      1848,
      1623,
      332,
      4126,
      1486,
      1850,
      4128
    ],
    rtlAutoMirrored: true,
  ),
  "electric_rickshaw": SymbolsMetadata(
    popularity: 374,
    codepoint: 0xeb1e,
    categories: [14],
    tags: [
      7906,
      7907,
      2048,
      1816,
      3893,
      1818,
      1819,
      1644,
      4105,
      7908,
      2051,
      3640,
      7909,
      6740,
      6748,
      1617,
      7910,
      6245,
      1520,
      896,
      5245,
      1928,
      2058,
      7911,
      2059,
      1620,
      645,
      1531,
      7912,
      7913,
      3896,
      1848,
      1623,
      332,
      1849,
      1486,
      1850,
      7914,
      4129
    ],
    rtlAutoMirrored: true,
  ),
  "electric_scooter": SymbolsMetadata(
    popularity: 564,
    codepoint: 0xeb1f,
    categories: [14],
    tags: [
      4100,
      3893,
      3825,
      2544,
      6037,
      7915,
      5369,
      313,
      2402,
      7916,
      3640,
      7891,
      3641,
      7917,
      4119,
      1520,
      7918,
      896,
      4123,
      2494,
      3067,
      7919,
      5329,
      2059,
      4124,
      1508,
      877,
      2334,
      3896,
      1848,
      1623,
      332,
      7920,
      1486,
      1850,
      4128,
      4129
    ],
    rtlAutoMirrored: true,
  ),
  "electrical_services": SymbolsMetadata(
    popularity: 1796,
    codepoint: 0xf102,
    categories: [5],
    tags: [
      3893,
      3589,
      3638,
      5738,
      4930,
      1855,
      3640,
      3826,
      7921,
      3879,
      3641,
      7922,
      1141,
      1745,
      7896,
      7923,
      1616,
      7924,
      7767,
      3594,
      3895,
      3920,
      3927,
      3645,
      7925,
      4873,
      645,
      2683,
      7926,
      3922,
      6291,
      3989,
      7086,
      4933,
      7927,
      4356
    ],
  ),
  "elevation": SymbolsMetadata(
    popularity: 101,
    codepoint: 0xf6e7,
    categories: [15],
    tags: [
      1625,
      1447,
      7928,
      484,
      7929,
      2533,
      7930,
      5086,
      1176,
      1177,
      692,
      5472,
      1054,
      7931,
      7932,
      7933,
      7934,
      2730,
      1056,
      4161,
      7935,
      1584,
      1585,
      91,
      1702,
      2732,
      7936,
      386,
      7813,
      7937,
      7938,
      594,
      6141,
      393,
      7939,
      7940,
      7941
    ],
  ),
  "elevator": SymbolsMetadata(
    popularity: 657,
    codepoint: 0xf1a0,
    categories: [16],
    tags: [
      858,
      7942,
      6233,
      502,
      7943,
      684,
      918,
      7944,
      345,
      7945,
      313,
      2778,
      2830,
      2839,
      7946,
      3798,
      3742,
      7947,
      583,
      51,
      790,
      4309,
      2986,
      468,
      589,
      590,
      1623,
      332,
      1696,
      98,
      1719,
      1445
    ],
  ),
  "emergency": SymbolsMetadata(
    popularity: 3098,
    codepoint: 0xe1eb,
    categories: [5],
    tags: [
      1338,
      1339,
      865,
      836,
      1340,
      1341,
      1760,
      3076,
      1213,
      7948,
      1345,
      7692,
      2423,
      7689,
      4373,
      692,
      1765,
      4230,
      873,
      1766,
      1347,
      1520,
      895,
      609,
      1348,
      239,
      4233,
      702,
      1011,
      273,
      2137,
      31,
      2428,
      206
    ],
  ),
  "emergency_heat": SymbolsMetadata(
    popularity: 374,
    codepoint: 0xf15d,
    categories: [8],
    tags: [
      3074,
      7688,
      1339,
      1340,
      7949,
      504,
      1342,
      837,
      345,
      3076,
      1345,
      2423,
      2694,
      1346,
      216,
      5173,
      5174,
      7950,
      2982,
      1859,
      3447,
      1116,
      2984,
      1860,
      138,
      1347,
      1143,
      635,
      1119,
      609,
      355,
      4873,
      645,
      151,
      31,
      1068,
      855,
      2085,
      2428,
      7951,
      206
    ],
  ),
  "emergency_heat_2": SymbolsMetadata(
    popularity: 28,
    codepoint: 0xf4e5,
    categories: [8],
    tags: [
      3074,
      834,
      2068,
      1339,
      1340,
      2705,
      1852,
      1854,
      1342,
      837,
      3076,
      1345,
      2423,
      2694,
      1346,
      3871,
      5173,
      5174,
      1051,
      4373,
      2982,
      1859,
      3447,
      1116,
      2984,
      138,
      1347,
      7952,
      1143,
      1119,
      609,
      328,
      637,
      7953,
      3784,
      31,
      855,
      2085,
      1718,
      2883,
      2428,
      2990,
      206,
      1866,
      856,
      1868
    ],
  ),
  "emergency_home": SymbolsMetadata(
    popularity: 2141,
    codepoint: 0xe82a,
    categories: [8],
    tags: [
      5451,
      1338,
      1339,
      1340,
      918,
      1342,
      4365,
      3076,
      1345,
      1478,
      2423,
      2694,
      1346,
      4373,
      1116,
      1479,
      1347,
      1143,
      1119,
      609,
      7954,
      1480,
      696,
      1482,
      4376,
      7955,
      702,
      1022,
      1011,
      1484,
      945,
      31,
      2428,
      206
    ],
  ),
  "emergency_recording": SymbolsMetadata(
    popularity: 259,
    codepoint: 0xebf4,
    categories: [8],
    tags: [
      746,
      1339,
      1288,
      501,
      1340,
      504,
      40,
      42,
      1342,
      345,
      1345,
      288,
      2423,
      346,
      5097,
      1086,
      138,
      49,
      1347,
      2814,
      53,
      406,
      3470,
      353,
      439,
      609,
      2350,
      57,
      59,
      62,
      453,
      440,
      1011,
      5105,
      65,
      1326,
      2428,
      37,
      434,
      476,
      206
    ],
  ),
  "emergency_share": SymbolsMetadata(
    popularity: 346,
    codepoint: 0xebf6,
    categories: [8],
    tags: [
      1339,
      1340,
      729,
      504,
      1342,
      283,
      284,
      3076,
      1345,
      81,
      7692,
      2423,
      137,
      873,
      138,
      1347,
      68,
      1322,
      323,
      267,
      609,
      2881,
      2318,
      1508,
      273,
      2426,
      31,
      4745,
      1326,
      2428,
      206
    ],
  ),
  "emergency_share_off": SymbolsMetadata(
    popularity: 16,
    codepoint: 0xf59e,
    categories: [8],
    tags: [
      1339,
      77,
      1340,
      481,
      1187,
      1342,
      283,
      7956,
      284,
      1345,
      81,
      1189,
      867,
      2423,
      7957,
      1033,
      1347,
      1200,
      1294,
      267,
      2030,
      609,
      1035,
      1036,
      1037,
      5032,
      4219,
      2594,
      3256,
      2961,
      1508,
      7958,
      7959,
      1041,
      1203,
      526,
      206
    ],
  ),
  "emoji_food_beverage": SymbolsMetadata(
    popularity: 1426,
    codepoint: 0xea1b,
    categories: [3],
    tags: [
      4168,
      2138,
      3653,
      6000,
      7960,
      6002,
      6004,
      2885,
      3658,
      4178,
      1590,
      2370,
      580,
      6006,
      4183,
      4186,
      2149,
      6008,
      4640,
      6009,
      1950,
      3665,
      7961,
      1180,
      3784,
      7962,
      6011
    ],
  ),
  "emoji_language": SymbolsMetadata(
    popularity: 54,
    codepoint: 0xf4cd,
    categories: [11],
    tags: [
      7963,
      2706,
      7187,
      193,
      283,
      1455,
      1456,
      5587,
      7964,
      1590,
      1593,
      1595,
      576,
      1598,
      1599,
      319,
      320,
      1600,
      1601,
      322,
      259,
      1089,
      7965,
      5220,
      7966,
      1604,
      4917,
      2315,
      1605,
      7967,
      590,
      5226,
      1607,
      1610,
      1612,
      705,
      1273,
      593,
      1464,
      1274,
      4829,
      33,
      4831,
      7212,
      5917,
      1164,
      334,
      5230
    ],
  ),
  "emoji_nature": SymbolsMetadata(
    popularity: 2245,
    codepoint: 0xea1c,
    categories: [3],
    tags: [
      4851,
      7968,
      4130,
      7969,
      4852,
      4033,
      7783,
      7970,
      315,
      7785,
      1590,
      1823,
      6870,
      7971,
      5146,
      1827,
      1828,
      7972,
      234,
      4858,
      7973,
      1583,
      2374,
      1833,
      1834,
      1835,
      3996,
      3280,
      4049,
      7974,
      1837,
      7975,
      7976,
      7977,
      1841,
      1845,
      7978,
      5482,
      5150,
      7979
    ],
  ),
  "emoji_objects": SymbolsMetadata(
    popularity: 7620,
    codepoint: 0xea24,
    categories: [3],
    tags: [
      566,
      3759,
      6126,
      5,
      569,
      6106,
      193,
      283,
      2299,
      1590,
      7980,
      6110,
      576,
      1597,
      1601,
      3763,
      5494,
      3594,
      585,
      2242,
      242,
      2388,
      330,
      1610,
      1611,
      7651,
      4833
    ],
  ),
  "emoji_people": SymbolsMetadata(
    popularity: 4057,
    codepoint: 0xea1d,
    categories: [3],
    tags: [
      565,
      1018,
      863,
      566,
      684,
      1800,
      965,
      4769,
      1590,
      3630,
      225,
      1254,
      7981,
      1176,
      872,
      583,
      1002,
      971,
      972,
      1021,
      267,
      589,
      590,
      7982,
      591,
      978,
      705,
      1275,
      597,
      1027,
      1206,
      7983
    ],
  ),
  "emoji_symbols": SymbolsMetadata(
    popularity: 783,
    codepoint: 0xea1e,
    categories: [3],
    tags: [
      7984,
      7985,
      5,
      1590,
      7986,
      1701,
      1460,
      3926,
      1162,
      2746,
      7987
    ],
  ),
  "emoji_transportation": SymbolsMetadata(
    popularity: 1414,
    codepoint: 0xea1f,
    categories: [3],
    tags: [
      1476,
      1816,
      918,
      1940,
      1818,
      1819,
      2544,
      7988,
      4105,
      313,
      2051,
      1590,
      2547,
      1617,
      584,
      1520,
      7989,
      896,
      1928,
      7270,
      327,
      2057,
      7263,
      2550,
      432,
      1482,
      1483,
      1620,
      6926,
      1484,
      2061,
      1994,
      1848,
      1623,
      7990,
      332,
      7265,
      1486,
      1850,
      4129
    ],
  ),
  "emoticon": SymbolsMetadata(
    popularity: 71,
    codepoint: 0xe5f3,
    categories: [3],
    tags: [
      231,
      743,
      566,
      1310,
      5,
      569,
      193,
      283,
      1140,
      1590,
      1591,
      1593,
      6110,
      1595,
      4856,
      576,
      1597,
      1598,
      1599,
      137,
      1600,
      1601,
      7991,
      138,
      1602,
      384,
      1305,
      5494,
      1604,
      406,
      2315,
      1605,
      6270,
      886,
      590,
      1607,
      239,
      591,
      2388,
      330,
      1317,
      1610,
      7992,
      1612,
      705,
      1613,
      31,
      597,
      1027
    ],
  ),
  "empty_dashboard": SymbolsMetadata(
    popularity: 197,
    codepoint: 0xf844,
    categories: [2],
    tags: [
      1045,
      2213,
      7993,
      5368,
      5469,
      808,
      778,
      1405,
      81,
      809,
      7994,
      370,
      7995,
      382,
      68,
      7996,
      385,
      584,
      1060,
      886,
      7997,
      5018,
      1749,
      818,
      432,
      1408,
      5479,
      433,
      2684,
      2218,
      744,
      333,
      1164,
      1165,
      1130
    ],
  ),
  "enable": SymbolsMetadata(
    popularity: 1354,
    codepoint: 0xf188,
    categories: [2],
    tags: [
      7998,
      7999,
      747,
      77,
      504,
      1758,
      193,
      678,
      345,
      2778,
      4304,
      1033,
      8000,
      51,
      467,
      1037,
      355,
      6707,
      8001,
      24,
      358,
      2526,
      151,
      71,
      4305,
      291,
      2409,
      8002,
      413,
      8003,
      2220,
      8004
    ],
  ),
  "encrypted": SymbolsMetadata(
    popularity: 916,
    codepoint: 0xe593,
    categories: [13],
    tags: [
      2872,
      77,
      1246,
      504,
      1539,
      344,
      345,
      313,
      8005,
      5932,
      7747,
      902,
      1088,
      5308,
      406,
      586,
      354,
      439,
      1701,
      904,
      5310,
      2500,
      409,
      328,
      1009,
      975,
      757,
      1560,
      696,
      907,
      702,
      1022,
      1011,
      1561,
      8006,
      411,
      1848,
      1718,
      1562,
      37
    ],
  ),
  "encrypted_add": SymbolsMetadata(
    popularity: 24,
    codepoint: 0xf429,
    categories: [13],
    tags: [
      231,
      858,
      743,
      1298,
      2656,
      1539,
      4204,
      1301,
      3154,
      1047,
      8007,
      1302,
      8005,
      5932,
      3295,
      8008,
      1306,
      1088,
      5308,
      2584,
      1308,
      886,
      1433,
      5933,
      5310,
      2644,
      239,
      1009,
      975,
      1560,
      696,
      1970,
      3161,
      702,
      4195,
      1022,
      1011,
      1561,
      31,
      5312,
      1562
    ],
  ),
  "encrypted_add_circle": SymbolsMetadata(
    popularity: 11,
    codepoint: 0xf42a,
    categories: [13],
    tags: [
      231,
      746,
      743,
      1614,
      504,
      1539,
      193,
      5794,
      345,
      1302,
      8009,
      81,
      8005,
      5932,
      1329,
      68,
      1087,
      1322,
      1088,
      5308,
      2584,
      886,
      1433,
      289,
      5310,
      239,
      1009,
      975,
      1560,
      696,
      3161,
      702,
      1022,
      1011,
      1561,
      31,
      1326,
      1562
    ],
  ),
  "encrypted_minus_circle": SymbolsMetadata(
    popularity: 11,
    codepoint: 0xf428,
    categories: [13],
    tags: [
      4977,
      858,
      1539,
      193,
      3154,
      345,
      81,
      8010,
      8011,
      1031,
      8012,
      8005,
      5932,
      5157,
      68,
      1088,
      5308,
      550,
      2584,
      1232,
      1433,
      289,
      5310,
      1009,
      975,
      1560,
      696,
      1039,
      3256,
      702,
      4195,
      1022,
      1011,
      7409,
      392,
      1561,
      1238,
      31,
      1562
    ],
  ),
  "encrypted_off": SymbolsMetadata(
    popularity: 44,
    codepoint: 0xf427,
    categories: [13],
    tags: [
      8013,
      8014,
      1539,
      8015,
      8016,
      867,
      8017,
      1033,
      8005,
      5932,
      8018,
      8019,
      8020,
      1088,
      5308,
      8021,
      8022,
      8023,
      8024,
      1035,
      1036,
      1037,
      2876,
      8025,
      8026,
      5310,
      1009,
      8027,
      975,
      1560,
      696,
      702,
      1022,
      1011,
      8028,
      8029,
      1561,
      1041,
      4298,
      5313,
      8030,
      8031,
      8032,
      1562,
      8033
    ],
  ),
  "endocrinology": SymbolsMetadata(
    popularity: 7,
    codepoint: 0xe0a9,
    categories: [3],
    tags: [
      8034,
      4131,
      684,
      8035,
      5867,
      8036,
      1761,
      8037,
      8038,
      8039,
      692,
      1765,
      8040,
      8041,
      1766,
      583,
      8042,
      895,
      7014,
      1769,
      8043,
      8044,
      5366,
      4147,
      8045,
      7017,
      8046,
      31,
      8047,
      8048,
      2010
    ],
  ),
  "energy": SymbolsMetadata(
    popularity: 77,
    codepoint: 0xe9a6,
    categories: [9],
    tags: [
      3637,
      8049,
      3893,
      8050,
      3638,
      3825,
      1855,
      3640,
      5555,
      8051,
      3826,
      8052,
      8053,
      3879,
      3641,
      8054,
      1823,
      8055,
      1828,
      7896,
      7767,
      3895,
      8056,
      3645,
      3875,
      3946,
      8057,
      7926,
      3896,
      8058,
      7086,
      8059,
      4356
    ],
  ),
  "energy_program_saving": SymbolsMetadata(
    popularity: 464,
    codepoint: 0xf15f,
    categories: [8],
    tags: [
      3637,
      3893,
      3638,
      678,
      1398,
      3414,
      3640,
      3826,
      3879,
      8060,
      3641,
      3980,
      382,
      3895,
      635,
      70,
      1664,
      3645,
      3985,
      912,
      1098,
      8061,
      5904,
      1683,
      8062,
      71,
      1899,
      3896,
      3989,
      4356
    ],
  ),
  "energy_program_time_used": SymbolsMetadata(
    popularity: 380,
    codepoint: 0xf161,
    categories: [8],
    tags: [
      1402,
      373,
      193,
      8063,
      1135,
      8064,
      5880,
      3971,
      81,
      4337,
      1381,
      2117,
      3641,
      8065,
      3827,
      137,
      2757,
      51,
      17,
      3463,
      3644,
      7496,
      1098,
      8066,
      757,
      1408,
      1145,
      1128,
      744,
      1148,
      8067,
      8068,
      3302
    ],
  ),
  "energy_savings_leaf": SymbolsMetadata(
    popularity: 1301,
    codepoint: 0xec1a,
    categories: [8],
    tags: [
      3976,
      504,
      678,
      7783,
      345,
      6212,
      6213,
      7785,
      3414,
      3641,
      1823,
      1828,
      138,
      51,
      1832,
      2374,
      3900,
      1834,
      1119,
      70,
      1837,
      3645,
      6218,
      8069,
      8062,
      944,
      8070,
      71,
      291,
      2334,
      31,
      413,
      3302
    ],
  ),
  "engineering": SymbolsMetadata(
    popularity: 8532,
    codepoint: 0xea3d,
    categories: [15],
    tags: [
      862,
      8071,
      1890,
      684,
      1354,
      1778,
      8072,
      8073,
      678,
      1355,
      1477,
      345,
      574,
      1080,
      2749,
      1745,
      4869,
      1780,
      3406,
      5696,
      8074,
      583,
      3415,
      5379,
      1729,
      3920,
      3416,
      8075,
      70,
      4687,
      589,
      590,
      912,
      4905,
      4873,
      645,
      151,
      71,
      65,
      511,
      1498,
      5386
    ],
  ),
  "enhanced_encryption": SymbolsMetadata(
    popularity: 1021,
    codepoint: 0xe63f,
    categories: [13],
    tags: [
      231,
      858,
      743,
      3151,
      8076,
      8077,
      4204,
      1077,
      3154,
      81,
      8078,
      8011,
      44,
      5932,
      713,
      1088,
      2584,
      5309,
      886,
      8025,
      8079,
      5933,
      5310,
      239,
      1009,
      975,
      696,
      1970,
      702,
      8080,
      1022,
      1011,
      7409,
      31,
      65,
      5312,
      5313,
      8081
    ],
  ),
  "ent": SymbolsMetadata(
    popularity: 39,
    codepoint: 0xe0aa,
    categories: [3],
    tags: [
      1246,
      8082,
      684,
      6021,
      8083,
      7710,
      779,
      8084,
      872,
      692,
      583,
      3763,
      5473,
      406,
      4653,
      7537,
      1701,
      8085,
      8086,
      3045,
      8087,
      8088,
      8089,
      1573,
      589,
      590,
      408,
      409,
      6024,
      8090,
      3014,
      1271,
      3372,
      8046,
      4834,
      6025,
      8047,
      8091,
      1754
    ],
  ),
  "enterprise": SymbolsMetadata(
    popularity: 273,
    codepoint: 0xe70e,
    categories: [9],
    tags: [
      1756,
      1476,
      1641,
      4438,
      1494,
      918,
      919,
      4903,
      2544,
      1157,
      1365,
      1366,
      4910,
      1080,
      2546,
      1367,
      931,
      234,
      4912,
      3415,
      936,
      1495,
      1004,
      1372,
      1063,
      4905,
      960,
      1481,
      2551,
      945,
      4443,
      2552,
      1486,
      1498
    ],
  ),
  "enterprise_off": SymbolsMetadata(
    popularity: 29,
    codepoint: 0xeb4d,
    categories: [9],
    tags: [
      1641,
      4438,
      481,
      3726,
      1494,
      918,
      8092,
      919,
      8093,
      6323,
      4903,
      1188,
      1365,
      8094,
      2027,
      867,
      1032,
      1033,
      1367,
      8095,
      1200,
      2588,
      5936,
      1035,
      1372,
      8096,
      1036,
      1037,
      960,
      1970,
      1041,
      1203,
      4443,
      7309,
      1042
    ],
  ),
  "equal": SymbolsMetadata(
    popularity: 295,
    codepoint: 0xf77b,
    categories: [12],
    tags: [
      480,
      8097,
      6305,
      1299,
      914,
      4979,
      789,
      4980,
      3719,
      8098,
      80,
      3059,
      2263,
      1802,
      4981,
      8099,
      622,
      8100,
      381,
      582,
      8101,
      584,
      791,
      1307,
      8102,
      1095,
      1732,
      1733,
      227,
      8103,
      4147,
      668,
      31,
      140,
      1309
    ],
  ),
  "equalizer": SymbolsMetadata(
    popularity: 3396,
    codepoint: 0xe01d,
    categories: [0],
    tags: [
      1738,
      2233,
      1045,
      1246,
      3369,
      517,
      373,
      345,
      574,
      81,
      44,
      2079,
      83,
      7815,
      351,
      1052,
      1057,
      584,
      226,
      1060,
      4187,
      4188,
      439,
      1701,
      1264,
      1750,
      408,
      912,
      71,
      7072,
      1271,
      8104,
      6081,
      8105,
      744,
      7539,
      1070,
      1445,
      2512,
      554
    ],
  ),
  "eraser_size_1": SymbolsMetadata(
    popularity: 9,
    codepoint: 0xf3fc,
    categories: [12],
    tags: [
      2233,
      1580,
      4817,
      8106,
      778,
      1031,
      378,
      4819,
      1229,
      673,
      3352,
      8107,
      370,
      2276,
      490,
      384,
      87,
      8108,
      8109,
      8110,
      4822,
      24,
      1039,
      298,
      1972,
      1147,
      8111,
      4544,
      1413,
      3559,
      511,
      3689,
      397
    ],
  ),
  "eraser_size_2": SymbolsMetadata(
    popularity: 5,
    codepoint: 0xf3fb,
    categories: [12],
    tags: [
      1738,
      1580,
      4817,
      1187,
      808,
      778,
      678,
      1793,
      1031,
      44,
      378,
      1229,
      673,
      3352,
      8107,
      370,
      137,
      1087,
      87,
      8109,
      492,
      70,
      3062,
      1144,
      912,
      1039,
      71,
      392,
      298,
      1147,
      8111,
      4544,
      511,
      3689,
      397
    ],
  ),
  "eraser_size_3": SymbolsMetadata(
    popularity: 6,
    codepoint: 0xf3fa,
    categories: [12],
    tags: [
      1738,
      1580,
      1403,
      778,
      1031,
      378,
      1229,
      673,
      3352,
      8107,
      370,
      2276,
      581,
      51,
      790,
      87,
      8109,
      8110,
      226,
      70,
      4822,
      432,
      1039,
      391,
      71,
      298,
      8112,
      1147,
      8111,
      4544,
      1296,
      3689,
      397
    ],
  ),
  "eraser_size_4": SymbolsMetadata(
    popularity: 6,
    codepoint: 0xf3f9,
    categories: [12],
    tags: [
      8113,
      4817,
      8114,
      778,
      1031,
      378,
      4819,
      1229,
      8115,
      3352,
      8107,
      370,
      137,
      1955,
      87,
      8109,
      1636,
      4821,
      8116,
      3062,
      1039,
      298,
      1147,
      8111,
      8117,
      6935,
      4544,
      511,
      3689,
      8118,
      2529,
      397
    ],
  ),
  "eraser_size_5": SymbolsMetadata(
    popularity: 9,
    codepoint: 0xf3f8,
    categories: [12],
    tags: [
      669,
      2233,
      223,
      808,
      8119,
      778,
      1031,
      486,
      378,
      4819,
      1229,
      2172,
      3352,
      8107,
      660,
      370,
      8120,
      490,
      790,
      87,
      8109,
      226,
      21,
      26,
      1039,
      298,
      1147,
      8111,
      4544,
      511,
      3689,
      397
    ],
  ),
  "error": SymbolsMetadata(
    popularity: 29852,
    codepoint: 0xe000,
    categories: [6],
    tags: [
      3074,
      1028,
      1339,
      1340,
      281,
      3726,
      1342,
      193,
      3076,
      1345,
      2694,
      1346,
      2695,
      1347,
      5152,
      68,
      5153,
      3078,
      1143,
      585,
      5583,
      609,
      289,
      328,
      3081,
      1970,
      1010,
      392,
      291,
      1203,
      31,
      5332,
      206
    ],
  ),
  "error_med": SymbolsMetadata(
    popularity: 43,
    codepoint: 0xe49b,
    categories: [2],
    tags: [
      1339,
      8121,
      1340,
      8122,
      1342,
      3076,
      1345,
      2694,
      8123,
      3077,
      4659,
      8124,
      5063,
      2695,
      692,
      1347,
      5152,
      3078,
      1143,
      1769,
      585,
      609,
      3081,
      1162,
      1203,
      31,
      1068,
      1718,
      5450,
      206,
      8125,
      5908
    ],
  ),
  "escalator": SymbolsMetadata(
    popularity: 238,
    codepoint: 0xf1a1,
    categories: [16],
    tags: [
      858,
      860,
      1987,
      77,
      2973,
      918,
      8126,
      8127,
      2402,
      8128,
      2778,
      8129,
      3798,
      3742,
      1057,
      8130,
      468,
      8131,
      325,
      2058,
      1162,
      8132,
      8133,
      3516,
      3753,
      1848,
      1623,
      332,
      1696,
      3140
    ],
  ),
  "escalator_warning": SymbolsMetadata(
    popularity: 1091,
    codepoint: 0xf1ac,
    categories: [16],
    tags: [
      1987,
      1339,
      684,
      918,
      1342,
      8134,
      984,
      1345,
      8129,
      4659,
      4373,
      8135,
      583,
      68,
      991,
      8130,
      8136,
      1160,
      1007,
      589,
      590,
      2058,
      702,
      8137,
      1162,
      8133,
      31,
      1623,
      1718,
      8138,
      206,
      4382
    ],
  ),
  "euro": SymbolsMetadata(
    popularity: 3177,
    codepoint: 0xea15,
    categories: [9],
    tags: [
      916,
      917,
      920,
      921,
      922,
      924,
      1398,
      926,
      927,
      6745,
      928,
      5192,
      6710,
      8139,
      8140,
      8141,
      8142,
      3261,
      931,
      6703,
      4118,
      582,
      6723,
      87,
      6719,
      938,
      8143,
      523,
      940,
      941,
      1401,
      392,
      1376,
      1147,
      31,
      4922,
      36,
      948
    ],
  ),
  "euro_symbol": SymbolsMetadata(
    popularity: 2161,
    codepoint: 0xe926,
    categories: [9],
    tags: [
      916,
      917,
      919,
      1643,
      920,
      921,
      922,
      924,
      1398,
      926,
      927,
      928,
      954,
      6710,
      8140,
      3261,
      931,
      932,
      322,
      6719,
      938,
      523,
      940,
      941,
      1401,
      3266,
      31,
      946,
      36,
      948
    ],
  ),
  "ev_mobiledata_badge": SymbolsMetadata(
    popularity: 0,
    codepoint: 0xf7e2,
    categories: [4],
    tags: [
      4,
      517,
      251,
      252,
      7695,
      8144,
      5,
      284,
      254,
      7697,
      8145,
      608,
      614,
      7,
      12,
      3827,
      51,
      259,
      16,
      790,
      3463,
      262,
      263,
      265,
      266,
      267,
      269,
      604,
      22,
      641,
      271,
      273,
      7794,
      275,
      291,
      642,
      31,
      605,
      33,
      35,
      1867,
      277,
      278
    ],
  ),
  "ev_shadow": SymbolsMetadata(
    popularity: 329,
    codepoint: 0xef8f,
    categories: [1],
    tags: [
      1107,
      1108,
      1109,
      5554,
      3825,
      193,
      4449,
      1229,
      673,
      487,
      3640,
      3879,
      3168,
      5556,
      83,
      1746,
      488,
      348,
      8146,
      1115,
      49,
      289,
      6707,
      1122,
      59,
      62,
      3645,
      760,
      363,
      3999,
      7937,
      392,
      3283,
      1204,
      8147,
      1131
    ],
  ),
  "ev_shadow_add": SymbolsMetadata(
    popularity: 5,
    codepoint: 0xf580,
    categories: [1],
    tags: [
      231,
      743,
      504,
      5554,
      3825,
      193,
      1302,
      4040,
      484,
      486,
      1229,
      673,
      2172,
      487,
      3640,
      3879,
      2359,
      5556,
      1303,
      83,
      137,
      8146,
      138,
      49,
      894,
      235,
      2730,
      3594,
      886,
      59,
      62,
      239,
      240,
      3645,
      150,
      760,
      71,
      3999,
      7937,
      2180,
      31,
      8147,
      511,
      1326,
      476
    ],
  ),
  "ev_shadow_minus": SymbolsMetadata(
    popularity: 1,
    codepoint: 0xf57f,
    categories: [1],
    tags: [
      4977,
      746,
      1403,
      1310,
      504,
      789,
      5554,
      3825,
      193,
      345,
      2399,
      2828,
      1031,
      1229,
      673,
      3640,
      3879,
      1140,
      5556,
      83,
      8146,
      1628,
      138,
      49,
      1966,
      2893,
      6378,
      2841,
      1232,
      4215,
      1095,
      59,
      62,
      3645,
      8148,
      1039,
      3999,
      7937,
      392,
      1162,
      1317,
      1238,
      31,
      8147,
      511,
      1326
    ],
  ),
  "ev_station": SymbolsMetadata(
    popularity: 1098,
    codepoint: 0xe56d,
    categories: [5],
    tags: [
      1816,
      3637,
      3893,
      1818,
      1819,
      5554,
      3825,
      8149,
      3939,
      3640,
      8150,
      3941,
      8151,
      3879,
      3641,
      8152,
      5556,
      8153,
      8154,
      5959,
      8155,
      1116,
      1520,
      5557,
      8156,
      2549,
      3927,
      3645,
      5565,
      8157,
      8158,
      6218,
      4932,
      3516,
      2334,
      3896,
      1848,
      1623,
      1850
    ],
  ),
  "event": SymbolsMetadata(
    popularity: 13999,
    codepoint: 0xe878,
    categories: [6],
    tags: [
      743,
      4987,
      1657,
      1916,
      2104,
      1302,
      1136,
      8159,
      4715,
      2105,
      5006,
      1567,
      8160,
      1568,
      10,
      1305,
      8161,
      8162,
      1143,
      4988,
      886,
      1460,
      1575,
      4989,
      239,
      1124,
      2447,
      4063,
      1350,
      1931,
      1145,
      1148,
      4990,
      5001,
      4991
    ],
  ),
  "event_available": SymbolsMetadata(
    popularity: 6845,
    codepoint: 0xe614,
    categories: [6],
    tags: [
      4987,
      1657,
      1658,
      8163,
      8164,
      3956,
      5629,
      1916,
      2104,
      8165,
      1660,
      8166,
      2113,
      463,
      2657,
      8167,
      8168,
      1136,
      8169,
      8170,
      8171,
      2342,
      10,
      8172,
      8173,
      1143,
      1663,
      1664,
      1350,
      1145,
      8174,
      8175,
      362,
      1665,
      1148,
      2355,
      1562,
      1668
    ],
  ),
  "event_busy": SymbolsMetadata(
    popularity: 2194,
    codepoint: 0xe615,
    categories: [6],
    tags: [
      1657,
      3726,
      5629,
      749,
      2104,
      1187,
      778,
      1188,
      1213,
      1136,
      10,
      1190,
      2240,
      2296,
      4118,
      1974,
      584,
      1143,
      4997,
      3254,
      8176,
      2846,
      1039,
      1145,
      979,
      433,
      1203,
      1147,
      1148,
      8177,
      1042,
      1952,
      3712,
      3951
    ],
  ),
  "event_list": SymbolsMetadata(
    popularity: 137,
    codepoint: 0xf683,
    categories: [2],
    tags: [
      4987,
      1657,
      6088,
      2292,
      2104,
      8178,
      3704,
      1661,
      4775,
      1136,
      8179,
      4777,
      1989,
      584,
      88,
      5617,
      8180,
      5013,
      6798,
      4997,
      8181,
      1664,
      1350,
      1145,
      1497,
      2271,
      2453,
      1666,
      8182,
      8183
    ],
  ),
  "event_note": SymbolsMetadata(
    popularity: 4063,
    codepoint: 0xe616,
    categories: [6],
    tags: [
      8184,
      4987,
      1657,
      1916,
      2104,
      8185,
      1136,
      8186,
      4715,
      5006,
      1567,
      1568,
      10,
      1143,
      4997,
      1571,
      4988,
      1460,
      4998,
      1575,
      4989,
      432,
      1350,
      1145,
      433,
      33,
      8187,
      1148,
      2453,
      7826,
      1465,
      4991
    ],
    rtlAutoMirrored: true,
  ),
  "event_repeat": SymbolsMetadata(
    popularity: 1590,
    codepoint: 0xeb7b,
    categories: [6],
    tags: [
      4987,
      2515,
      1657,
      460,
      2104,
      8188,
      750,
      751,
      5004,
      1136,
      4715,
      10,
      8189,
      351,
      2328,
      3431,
      2998,
      3432,
      755,
      4997,
      4988,
      5007,
      6764,
      4989,
      8190,
      5761,
      3088,
      2441,
      3426,
      8191,
      470,
      1145,
      8192,
      1497,
      1148,
      473,
      5015,
      5010
    ],
  ),
  "event_seat": SymbolsMetadata(
    popularity: 455,
    codepoint: 0xe903,
    categories: [8],
    tags: [
      8193,
      8194,
      2654,
      8195,
      8196,
      8197,
      8198,
      8199,
      8200,
      1916,
      1919,
      8201,
      344,
      4412,
      10,
      8202,
      4008,
      354,
      8203,
      1931,
      1630,
      1933,
      1934,
      1127,
      8204,
      8205,
      30,
      3472,
      8206,
      3329,
      2025,
      8207,
      8208
    ],
  ),
  "event_upcoming": SymbolsMetadata(
    popularity: 2771,
    codepoint: 0xf238,
    categories: [6],
    tags: [
      4987,
      1657,
      77,
      1916,
      2104,
      4961,
      1136,
      8159,
      4715,
      2105,
      10,
      8209,
      489,
      382,
      4988,
      4998,
      4989,
      3568,
      432,
      1350,
      5795,
      1931,
      907,
      1145,
      433,
      8210,
      1148,
      2453,
      8211,
      1707,
      8212,
      4991
    ],
    rtlAutoMirrored: true,
  ),
  "exclamation": SymbolsMetadata(
    popularity: 3030,
    codepoint: 0xf22f,
    categories: [13],
    tags: [
      3074,
      1339,
      8213,
      1340,
      1342,
      8214,
      3076,
      7948,
      1345,
      2694,
      6303,
      1346,
      5063,
      2695,
      4373,
      3447,
      1347,
      51,
      68,
      8215,
      3078,
      1143,
      1160,
      609,
      328,
      3081,
      8216,
      3175,
      1162,
      31,
      1718,
      206,
      8217
    ],
  ),
  "exercise": SymbolsMetadata(
    popularity: 208,
    codepoint: 0xf6e6,
    categories: [15],
    tags: [
      747,
      2504,
      8218,
      7541,
      7290,
      684,
      8219,
      8220,
      308,
      8221,
      8222,
      8223,
      3641,
      11,
      8224,
      2241,
      2831,
      2533,
      8225,
      8226,
      692,
      7545,
      468,
      641,
      8227,
      2549,
      8228,
      3282,
      8229,
      392,
      30,
      3472,
      8230,
      642,
      2988,
      8231,
      8232,
      3475,
      3473
    ],
  ),
  "exit_to_app": SymbolsMetadata(
    popularity: 5928,
    codepoint: 0xe879,
    categories: [2],
    tags: [
      8233,
      858,
      565,
      1288,
      501,
      77,
      481,
      482,
      1188,
      2675,
      8234,
      485,
      4924,
      1190,
      1690,
      902,
      8235,
      1322,
      385,
      2910,
      87,
      8236,
      1034,
      262,
      623,
      586,
      1618,
      325,
      2361,
      1732,
      2362,
      271,
      5227,
      4220,
      432,
      1694,
      410,
      7181,
      8237,
      2790,
      433,
      525,
      1706,
      141,
      597,
      1327,
      333,
      1164,
      1165
    ],
    rtlAutoMirrored: true,
  ),
  "expand": SymbolsMetadata(
    popularity: 2508,
    codepoint: 0xe94f,
    categories: [2],
    tags: [
      77,
      502,
      626,
      8238,
      6038,
      621,
      2357,
      2358,
      2359,
      1303,
      8239,
      7614,
      348,
      6628,
      1691,
      1304,
      235,
      2360,
      586,
      439,
      2876,
      2363,
      6226,
      5435,
      391,
      410,
      1959,
      6194,
      396,
      8240,
      1165,
      2356
    ],
  ),
  "expand_all": SymbolsMetadata(
    popularity: 541,
    codepoint: 0xe946,
    categories: [2],
    tags: [
      743,
      2302,
      77,
      502,
      3008,
      3009,
      313,
      2402,
      8,
      2778,
      2359,
      1303,
      8241,
      3003,
      1313,
      8239,
      6628,
      1691,
      2417,
      235,
      2360,
      8242,
      237,
      2876,
      2363,
      239,
      2843,
      391,
      2022,
      2286,
      8243,
      1696,
      2356,
      5490
    ],
  ),
  "expand_circle_down": SymbolsMetadata(
    popularity: 9371,
    codepoint: 0xe7cd,
    categories: [2],
    tags: [
      77,
      502,
      504,
      2784,
      193,
      8244,
      1188,
      2799,
      8245,
      345,
      145,
      313,
      2778,
      2830,
      8246,
      2840,
      8247,
      1303,
      2857,
      5798,
      2864,
      51,
      68,
      88,
      2360,
      506,
      2841,
      237,
      8248,
      325,
      2843,
      2022
    ],
  ),
  "expand_circle_right": SymbolsMetadata(
    popularity: 159,
    codepoint: 0xf591,
    categories: [2],
    tags: [
      77,
      502,
      2784,
      193,
      2799,
      43,
      313,
      2778,
      2359,
      1303,
      5798,
      902,
      903,
      234,
      235,
      68,
      88,
      2360,
      237,
      8249,
      586,
      904,
      2876,
      328,
      1097,
      907,
      2844
    ],
    rtlAutoMirrored: true,
  ),
  "expand_circle_up": SymbolsMetadata(
    popularity: 119,
    codepoint: 0xf5d2,
    categories: [2],
    tags: [
      77,
      502,
      504,
      2784,
      193,
      1188,
      2799,
      2434,
      345,
      1456,
      313,
      2778,
      2359,
      5903,
      1303,
      5798,
      1691,
      2664,
      8250,
      1603,
      8251,
      88,
      2360,
      2841,
      4605,
      237,
      8249,
      325,
      2876,
      1220,
      2243,
      8252,
      2866,
      413,
      1696,
      396
    ],
  ),
  "expand_content": SymbolsMetadata(
    popularity: 890,
    codepoint: 0xf830,
    categories: [2],
    tags: [
      77,
      502,
      2784,
      2799,
      145,
      3009,
      313,
      8,
      1567,
      2778,
      2359,
      1303,
      6055,
      5798,
      1710,
      6628,
      1304,
      235,
      88,
      2360,
      237,
      325,
      2876,
      2843,
      391,
      2022,
      396,
      1165,
      5490
    ],
  ),
  "expansion_panels": SymbolsMetadata(
    popularity: 75,
    codepoint: 0xe600,
    categories: [2],
    tags: [
      8253,
      1447,
      77,
      502,
      2799,
      621,
      145,
      2402,
      2856,
      8254,
      2778,
      2840,
      1303,
      2864,
      8250,
      68,
      1322,
      8255,
      385,
      88,
      8256,
      506,
      2876,
      92,
      8257,
      4595,
      6060,
      2449,
      2022,
      8258,
      945,
      413,
      1326,
      1696,
      8259,
      2916
    ],
  ),
  "experiment": SymbolsMetadata(
    popularity: 1650,
    codepoint: 0xe686,
    categories: [15],
    tags: [
      1402,
      8260,
      4131,
      1873,
      3759,
      5952,
      4134,
      8261,
      1311,
      2885,
      314,
      3059,
      4137,
      8262,
      1085,
      8263,
      8264,
      4143,
      3086,
      4186,
      895,
      8044,
      1773,
      2388,
      3385,
      330,
      4147,
      7651,
      3387,
      8265,
      8266
    ],
  ),
  "explicit": SymbolsMetadata(
    popularity: 399,
    codepoint: 0xe01e,
    categories: [0],
    tags: [
      4029,
      4,
      481,
      191,
      5,
      5483,
      621,
      7307,
      7698,
      8267,
      8268,
      83,
      12,
      137,
      8269,
      52,
      5220,
      16,
      1143,
      8270,
      200,
      406,
      3448,
      1701,
      6239,
      8271,
      2592,
      2594,
      203,
      1970,
      1040,
      7409,
      1162,
      31,
      33,
      35,
      206,
      1465
    ],
  ),
  "explore": SymbolsMetadata(
    popularity: 9746,
    codepoint: 0xe87a,
    categories: [5],
    tags: [
      3607,
      309,
      312,
      313,
      2341,
      314,
      315,
      2931,
      316,
      317,
      320,
      2780,
      1617,
      323,
      1517,
      324,
      1520,
      174,
      325,
      6197,
      6198,
      507,
      1619,
      2881,
      327,
      1373,
      1621,
      1102,
      4601,
      3286,
      332,
      8272,
      8273,
      2953,
      334
    ],
  ),
  "explore_nearby": SymbolsMetadata(
    popularity: 112,
    codepoint: 0xe538,
    categories: [5],
    tags: [
      1107,
      1188,
      309,
      312,
      313,
      2341,
      316,
      8274,
      317,
      2780,
      6245,
      8275,
      2345,
      323,
      324,
      1520,
      174,
      1618,
      325,
      8276,
      2902,
      326,
      2881,
      327,
      2549,
      328,
      6275,
      1102,
      3283,
      332
    ],
  ),
  "explore_off": SymbolsMetadata(
    popularity: 255,
    codepoint: 0xe9a8,
    categories: [5],
    tags: [
      8277,
      309,
      8278,
      8279,
      312,
      313,
      7277,
      8280,
      867,
      8281,
      8282,
      2931,
      1033,
      316,
      8283,
      8284,
      8285,
      8286,
      8287,
      8288,
      7279,
      8289,
      8290,
      8291,
      323,
      8292,
      7283,
      1520,
      8293,
      8294,
      6197,
      6198,
      1035,
      1037,
      8295,
      8296,
      8297,
      7286,
      8298,
      8299,
      1041,
      4601,
      8300,
      332,
      7288,
      2953,
      8301
    ],
  ),
  "explosion": SymbolsMetadata(
    popularity: 85,
    codepoint: 0xf685,
    categories: [3],
    tags: [
      1339,
      341,
      4357,
      4359,
      4360,
      4362,
      3340,
      4364,
      8302,
      1345,
      8303,
      3351,
      4369,
      1252,
      487,
      3641,
      10,
      4370,
      4371,
      4372,
      5173,
      6771,
      2984,
      8304,
      5242,
      4374,
      4375,
      8305,
      3645,
      637,
      8306,
      8307,
      854,
      8308,
      4289,
      8309,
      206
    ],
  ),
  "export_notes": SymbolsMetadata(
    popularity: 172,
    codepoint: 0xe0ac,
    categories: [12],
    tags: [
      8310,
      8311,
      77,
      1724,
      81,
      1566,
      1567,
      1690,
      147,
      692,
      5546,
      1571,
      586,
      1460,
      1573,
      2361,
      1574,
      1575,
      907,
      8312,
      8313,
      8314,
      2318,
      1508,
      1576,
      33,
      526,
      1696,
      527,
      8315,
      1465
    ],
  ),
  "exposure": SymbolsMetadata(
    popularity: 496,
    codepoint: 0xe3ca,
    categories: [1],
    tags: [
      743,
      2233,
      1403,
      3590,
      40,
      4698,
      1742,
      1229,
      673,
      487,
      3591,
      137,
      49,
      51,
      8316,
      790,
      3594,
      584,
      1232,
      57,
      59,
      62,
      239,
      391,
      71,
      3465,
      1238,
      413,
      476
    ],
  ),
  "exposure_neg_1": SymbolsMetadata(
    popularity: 258,
    codepoint: 0xe3cb,
    categories: [1],
    tags: [
      72,
      1738,
      3590,
      8317,
      8318,
      4698,
      1742,
      4040,
      8319,
      2828,
      7,
      3601,
      1229,
      673,
      487,
      3591,
      8320,
      83,
      49,
      8321,
      790,
      3594,
      8322,
      1232,
      8323,
      8324,
      4215,
      22,
      57,
      3579,
      4277,
      59,
      8325,
      71,
      1238,
      31,
      36
    ],
  ),
  "exposure_neg_2": SymbolsMetadata(
    popularity: 175,
    codepoint: 0xe3cc,
    categories: [1],
    tags: [
      74,
      1738,
      3590,
      40,
      4698,
      345,
      3083,
      4040,
      8326,
      7,
      1229,
      673,
      487,
      3591,
      49,
      51,
      790,
      3594,
      406,
      3463,
      1232,
      439,
      8324,
      4215,
      21,
      22,
      57,
      8327,
      59,
      62,
      756,
      151,
      71,
      3465,
      1238,
      31,
      394
    ],
  ),
  "exposure_plus_1": SymbolsMetadata(
    popularity: 740,
    codepoint: 0xe3cd,
    categories: [1],
    tags: [
      72,
      743,
      2233,
      1299,
      3590,
      504,
      302,
      4698,
      80,
      224,
      7,
      1229,
      673,
      487,
      3591,
      8328,
      49,
      235,
      2875,
      8329,
      791,
      21,
      22,
      23,
      8330,
      665,
      178,
      57,
      59,
      239,
      8331,
      240,
      151,
      71,
      1162,
      31,
      2220,
      36
    ],
  ),
  "exposure_plus_2": SymbolsMetadata(
    popularity: 260,
    codepoint: 0xe3ce,
    categories: [1],
    tags: [
      74,
      743,
      1738,
      2233,
      3590,
      4698,
      8332,
      7,
      44,
      1229,
      673,
      487,
      6865,
      3591,
      83,
      137,
      49,
      3577,
      235,
      1057,
      791,
      1636,
      21,
      431,
      22,
      57,
      7633,
      59,
      62,
      239,
      8333,
      242,
      71,
      31,
      394
    ],
  ),
  "exposure_zero": SymbolsMetadata(
    popularity: 305,
    codepoint: 0xe3cf,
    categories: [1],
    tags: [
      4732,
      1738,
      2233,
      7047,
      3590,
      40,
      4698,
      345,
      4205,
      6939,
      7,
      1229,
      673,
      487,
      3591,
      49,
      790,
      3594,
      1636,
      4215,
      813,
      21,
      22,
      23,
      57,
      59,
      62,
      5843,
      391,
      151,
      71,
      3465,
      31,
      36,
      3646,
      8334
    ],
  ),
  "extension": SymbolsMetadata(
    popularity: 4473,
    codepoint: 0xe87b,
    categories: [6],
    tags: [
      1288,
      1107,
      1310,
      481,
      1108,
      1109,
      482,
      1311,
      4449,
      44,
      599,
      1140,
      809,
      1953,
      2561,
      348,
      5371,
      1142,
      8335,
      1384,
      289,
      8336,
      5714,
      8337,
      1125,
      1127,
      392,
      1452,
      1317,
      707,
      433,
      141,
      8338,
      333,
      1165,
      1131
    ],
  ),
  "extension_off": SymbolsMetadata(
    popularity: 685,
    codepoint: 0xe4f5,
    categories: [2],
    tags: [
      4992,
      1288,
      3726,
      2692,
      1213,
      1278,
      2580,
      1031,
      2358,
      1138,
      1279,
      867,
      1032,
      1033,
      2694,
      1953,
      2561,
      8339,
      8335,
      87,
      1035,
      1037,
      4688,
      8340,
      1098,
      5714,
      1039,
      392,
      1041,
      509,
      4299,
      8341,
      1042,
      8342,
      8343,
      8344,
      5747
    ],
  ),
  "eye_tracking": SymbolsMetadata(
    popularity: 154,
    codepoint: 0xf4c9,
    categories: [0],
    tags: [
      858,
      747,
      1045,
      5355,
      8345,
      193,
      81,
      5787,
      8346,
      348,
      8347,
      2018,
      8348,
      1091,
      17,
      623,
      353,
      8349,
      8350,
      1037,
      3739,
      2350,
      8351,
      2843,
      1010,
      8352,
      1736,
      1011,
      1103,
      2022,
      5105,
      65,
      2164,
      1070,
      396,
      3598,
      2735,
      2102,
      6787
    ],
  ),
  "eyeglasses": SymbolsMetadata(
    popularity: 309,
    codepoint: 0xf6ee,
    categories: [3],
    tags: [
      860,
      1869,
      2421,
      863,
      1289,
      135,
      8353,
      4156,
      3334,
      8354,
      2615,
      1746,
      348,
      7323,
      53,
      1092,
      895,
      2350,
      4905,
      2834,
      3385,
      7650,
      1270,
      8355,
      8356,
      3387,
      8357,
      5777,
      6175,
      396,
      2735,
      2537
    ],
  ),
  "eyeglasses_2": SymbolsMetadata(
    popularity: 141,
    codepoint: 0xf2c7,
    categories: [3],
    tags: [
      1869,
      2421,
      865,
      4156,
      8354,
      4856,
      8358,
      437,
      7323,
      1765,
      8359,
      584,
      895,
      492,
      7647,
      2350,
      7303,
      7648,
      3988,
      8360,
      2834,
      1103,
      392,
      7650,
      8355,
      8356,
      8357,
      8361,
      511,
      394,
      396,
      2735,
      476
    ],
  ),
  "face": SymbolsMetadata(
    popularity: 13258,
    codepoint: 0xe87c,
    categories: [3],
    tags: [
      858,
      565,
      2653,
      1019,
      3151,
      566,
      5355,
      40,
      1660,
      193,
      44,
      1590,
      4856,
      576,
      3295,
      872,
      583,
      969,
      584,
      2584,
      4779,
      971,
      1034,
      2876,
      589,
      590,
      975,
      591,
      1267,
      1736,
      1011,
      705,
      245,
      65,
      980,
      5312,
      597,
      2650,
      1562
    ],
  ),
  "face_2": SymbolsMetadata(
    popularity: 912,
    codepoint: 0xf8da,
    categories: [3],
    tags: [
      565,
      566,
      6126,
      5,
      569,
      6106,
      283,
      1590,
      1591,
      6110,
      4856,
      576,
      8362,
      1597,
      6112,
      1601,
      872,
      583,
      5494,
      2584,
      4779,
      971,
      1034,
      585,
      589,
      590,
      974,
      242,
      591,
      1267,
      1011,
      1610,
      1611,
      705,
      980,
      5312,
      597
    ],
  ),
  "face_3": SymbolsMetadata(
    popularity: 1251,
    codepoint: 0xf8db,
    categories: [3],
    tags: [
      565,
      3442,
      6103,
      566,
      4615,
      965,
      1590,
      4856,
      576,
      225,
      7883,
      8363,
      872,
      8364,
      8365,
      583,
      969,
      8366,
      1002,
      2584,
      4779,
      971,
      1034,
      4617,
      6117,
      972,
      2846,
      589,
      590,
      591,
      8367,
      1267,
      1011,
      392,
      978,
      705,
      980,
      5312,
      597,
      4677
    ],
  ),
  "face_4": SymbolsMetadata(
    popularity: 1168,
    codepoint: 0xf8dc,
    categories: [3],
    tags: [
      565,
      964,
      566,
      4614,
      6106,
      1590,
      1591,
      6110,
      4856,
      576,
      1601,
      872,
      8368,
      8369,
      583,
      969,
      8370,
      5494,
      2584,
      4779,
      971,
      1034,
      1605,
      589,
      590,
      973,
      974,
      242,
      591,
      976,
      1267,
      1011,
      1452,
      8371,
      978,
      1610,
      8372,
      705,
      980,
      5312,
      597,
      981
    ],
  ),
  "face_5": SymbolsMetadata(
    popularity: 789,
    codepoint: 0xf8dd,
    categories: [3],
    tags: [
      565,
      6262,
      6103,
      566,
      5,
      193,
      965,
      6939,
      1590,
      4856,
      576,
      8373,
      137,
      872,
      583,
      138,
      969,
      1002,
      2584,
      4779,
      971,
      1034,
      972,
      812,
      289,
      589,
      590,
      818,
      974,
      591,
      976,
      1267,
      330,
      1011,
      978,
      1317,
      705,
      980,
      5312,
      597
    ],
  ),
  "face_6": SymbolsMetadata(
    popularity: 1444,
    codepoint: 0xf8de,
    categories: [3],
    tags: [
      480,
      565,
      6103,
      566,
      5,
      193,
      6939,
      1590,
      4856,
      576,
      1142,
      872,
      583,
      969,
      2584,
      4779,
      971,
      1034,
      812,
      589,
      590,
      818,
      974,
      591,
      1267,
      390,
      330,
      1011,
      978,
      1317,
      705,
      31,
      980,
      5312,
      597
    ],
  ),
  "face_down": SymbolsMetadata(
    popularity: 19,
    codepoint: 0xf402,
    categories: [3],
    tags: [
      8374,
      8375,
      8376,
      8377,
      8378,
      8379,
      313,
      8380,
      8381,
      8382,
      1590,
      4856,
      576,
      8383,
      8384,
      2664,
      8385,
      8386,
      8387,
      8388,
      872,
      8389,
      583,
      8390,
      8391,
      8392,
      590,
      8393,
      8394,
      8395,
      8396,
      8397,
      8398,
      8399
    ],
  ),
  "face_left": SymbolsMetadata(
    popularity: 8,
    codepoint: 0xf401,
    categories: [3],
    tags: [
      565,
      6103,
      566,
      684,
      1020,
      4449,
      6939,
      313,
      1590,
      4856,
      576,
      8362,
      870,
      225,
      8373,
      2664,
      8385,
      872,
      583,
      2216,
      3540,
      8400,
      289,
      590,
      974,
      591,
      392,
      1452,
      978,
      597,
      396
    ],
  ),
  "face_nod": SymbolsMetadata(
    popularity: 13,
    codepoint: 0xf400,
    categories: [3],
    tags: [
      2629,
      2630,
      746,
      2430,
      1658,
      2653,
      504,
      1660,
      1662,
      2637,
      1079,
      313,
      2342,
      1590,
      7980,
      4856,
      576,
      2639,
      902,
      2664,
      8385,
      903,
      3990,
      1601,
      872,
      583,
      1322,
      904,
      590,
      242,
      1097,
      2970,
      1610,
      245,
      2650,
      1562,
      1668
    ],
  ),
  "face_retouching_off": SymbolsMetadata(
    popularity: 288,
    codepoint: 0xf007,
    categories: [1],
    tags: [
      6660,
      3726,
      1187,
      1278,
      2027,
      1138,
      867,
      378,
      1229,
      673,
      487,
      1590,
      1591,
      1033,
      576,
      7341,
      83,
      872,
      583,
      49,
      1232,
      1833,
      8401,
      1035,
      1037,
      289,
      590,
      57,
      59,
      591,
      1039,
      8402,
      8403,
      71,
      4516,
      7015,
      1041,
      675,
      182
    ],
  ),
  "face_right": SymbolsMetadata(
    popularity: 6,
    codepoint: 0xf3ff,
    categories: [3],
    tags: [
      565,
      566,
      5,
      193,
      313,
      1590,
      4856,
      576,
      8404,
      8405,
      381,
      2664,
      8385,
      872,
      8406,
      583,
      969,
      289,
      590,
      8407,
      911,
      386,
      8408,
      392,
      705,
      597,
      8409
    ],
  ),
  "face_shake": SymbolsMetadata(
    popularity: 16,
    codepoint: 0xf3fe,
    categories: [3],
    tags: [
      8410,
      566,
      8411,
      8412,
      5,
      8413,
      313,
      8414,
      2638,
      5636,
      1590,
      1591,
      6110,
      4856,
      576,
      1597,
      2664,
      8385,
      872,
      583,
      468,
      4215,
      3254,
      590,
      3902,
      7772,
      8415,
      8416,
      8417,
      8418,
      7776,
      8419,
      8420,
      8421
    ],
  ),
  "face_up": SymbolsMetadata(
    popularity: 6,
    codepoint: 0xf3fd,
    categories: [3],
    tags: [
      566,
      5,
      6106,
      313,
      1590,
      7980,
      1591,
      6110,
      4856,
      576,
      1596,
      1597,
      5733,
      2664,
      8385,
      6112,
      1601,
      872,
      583,
      5494,
      8422,
      590,
      8423,
      974,
      242,
      591,
      1610,
      1611,
      31,
      1696
    ],
  ),
  "fact_check": SymbolsMetadata(
    popularity: 8141,
    codepoint: 0xf0c5,
    categories: [12],
    tags: [
      2629,
      2338,
      2430,
      2634,
      8424,
      1658,
      8425,
      3151,
      482,
      1539,
      1660,
      7860,
      463,
      1662,
      4445,
      2340,
      2342,
      8426,
      8427,
      2438,
      88,
      1143,
      6384,
      1663,
      907,
      362,
      433,
      291,
      1497,
      1665,
      2648,
      2649,
      2355,
      4420,
      1562,
      7469,
      1668
    ],
  ),
  "factory": SymbolsMetadata(
    popularity: 4102,
    codepoint: 0xebbc,
    categories: [5],
    tags: [
      1476,
      5737,
      1890,
      918,
      919,
      4878,
      924,
      1477,
      1080,
      954,
      3641,
      8428,
      3798,
      6468,
      4871,
      3415,
      1616,
      5742,
      1837,
      3645,
      756,
      674,
      8429,
      945,
      8430
    ],
  ),
  "falling": SymbolsMetadata(
    popularity: 44,
    codepoint: 0xf60d,
    categories: [3],
    tags: [
      1339,
      77,
      684,
      2799,
      5238,
      4365,
      1345,
      5030,
      2828,
      2838,
      7945,
      313,
      2778,
      2830,
      2839,
      2849,
      2694,
      2695,
      8431,
      8432,
      8433,
      583,
      51,
      8434,
      8435,
      8436,
      353,
      468,
      589,
      590,
      2833,
      8437,
      291,
      7659,
      206
    ],
  ),
  "familiar_face_and_zone": SymbolsMetadata(
    popularity: 787,
    codepoint: 0xe21c,
    categories: [10],
    tags: [
      5306,
      2504,
      8438,
      8439,
      8440,
      8441,
      8442,
      1109,
      8443,
      1111,
      8444,
      576,
      8445,
      8446,
      8447,
      8448,
      8449,
      8450,
      348,
      8451,
      1116,
      8452,
      8453,
      8454,
      8455,
      1119,
      1122,
      590,
      8456,
      8457,
      1267,
      1126,
      8458,
      8459,
      1011,
      8460,
      8461,
      5105,
      2164,
      1070,
      1131
    ],
  ),
  "family_history": SymbolsMetadata(
    popularity: 149,
    codepoint: 0xe0ad,
    categories: [9],
    tags: [
      8462,
      8463,
      4621,
      8464,
      373,
      1047,
      284,
      375,
      1001,
      8465,
      1051,
      8466,
      530,
      1052,
      692,
      8467,
      1054,
      2757,
      1055,
      8468,
      87,
      8469,
      267,
      1063,
      2759,
      8470,
      589,
      4090,
      1067,
      8471,
      8472,
      8473,
      945
    ],
  ),
  "family_home": SymbolsMetadata(
    popularity: 238,
    codepoint: 0xeb26,
    categories: [8],
    tags: [
      1476,
      1310,
      918,
      504,
      4924,
      1478,
      2547,
      1001,
      8474,
      379,
      1142,
      1116,
      1479,
      2750,
      1294,
      325,
      289,
      327,
      1480,
      2550,
      1481,
      1482,
      1483,
      4883,
      702,
      1011,
      392,
      1484,
      1317,
      945,
      141,
      4691
    ],
  ),
  "family_link": SymbolsMetadata(
    popularity: 337,
    codepoint: 0xeb19,
    categories: [15],
    tags: [
      2504,
      8475,
      7344,
      4621,
      193,
      1800,
      1048,
      284,
      1001,
      8476,
      8477,
      5371,
      1176,
      1880,
      8478,
      8479,
      1294,
      8480,
      8481,
      4624,
      267,
      1063,
      589,
      8482,
      8483,
      1266,
      5478,
      4090,
      705,
      1206
    ],
  ),
  "family_restroom": SymbolsMetadata(
    popularity: 2316,
    codepoint: 0xf1a2,
    categories: [16],
    tags: [
      861,
      1987,
      3496,
      3498,
      3499,
      918,
      984,
      987,
      8126,
      4769,
      3798,
      1001,
      8484,
      3504,
      1804,
      2717,
      583,
      1881,
      68,
      1003,
      8130,
      3804,
      3507,
      289,
      4030,
      589,
      590,
      8485,
      8486,
      3665,
      3515,
      3136,
      978,
      3516,
      3801,
      332,
      8487,
      3520,
      3812
    ],
  ),
  "family_star": SymbolsMetadata(
    popularity: 92,
    codepoint: 0xf527,
    categories: [3],
    tags: [
      3190,
      4621,
      1688,
      1759,
      984,
      3191,
      1800,
      284,
      1590,
      576,
      1001,
      3194,
      1254,
      1176,
      1115,
      1347,
      991,
      4461,
      5350,
      1005,
      267,
      589,
      714,
      63,
      793,
      359,
      203,
      4090,
      3101,
      1683,
      4421,
      1610,
      705,
      898,
      854,
      1275,
      6194,
      1240,
      4570
    ],
  ),
  "fan_focus": SymbolsMetadata(
    popularity: 4,
    codepoint: 0xf334,
    categories: [14],
    tags: [
      480,
      834,
      1888,
      1889,
      77,
      502,
      1816,
      3403,
      8488,
      1854,
      1818,
      193,
      6199,
      837,
      1921,
      345,
      841,
      842,
      313,
      3640,
      1906,
      1746,
      1116,
      1880,
      584,
      635,
      3645,
      8489,
      3173,
      3174,
      71,
      275,
      1850,
      1865,
      1868
    ],
  ),
  "fan_indirect": SymbolsMetadata(
    popularity: 12,
    codepoint: 0xf333,
    categories: [14],
    tags: [
      834,
      8490,
      1888,
      1889,
      77,
      502,
      1816,
      3403,
      8488,
      1854,
      1818,
      6199,
      1904,
      5250,
      841,
      8491,
      313,
      1906,
      1860,
      8492,
      468,
      8493,
      8489,
      8494,
      1850,
      1865,
      1868
    ],
  ),
  "farsight_digital": SymbolsMetadata(
    popularity: 14,
    codepoint: 0xf559,
    categories: [10],
    tags: [
      8495,
      2339,
      837,
      1135,
      288,
      44,
      2341,
      8,
      9,
      2527,
      316,
      7337,
      8496,
      317,
      1746,
      489,
      1116,
      53,
      1091,
      1092,
      1119,
      8497,
      3739,
      2350,
      1124,
      410,
      1103,
      7650,
      65,
      8498,
      2085,
      396,
      2735,
      2356
    ],
  ),
  "fast_forward": SymbolsMetadata(
    popularity: 3314,
    codepoint: 0xe01f,
    categories: [0],
    tags: [
      5871,
      746,
      2872,
      77,
      1246,
      5753,
      504,
      621,
      345,
      313,
      2920,
      779,
      1141,
      7747,
      902,
      406,
      352,
      2818,
      1701,
      904,
      2500,
      408,
      409,
      757,
      1694,
      8006,
      275,
      411,
      31,
      1148,
      2453,
      2045,
      1326,
      37
    ],
  ),
  "fast_rewind": SymbolsMetadata(
    popularity: 1652,
    codepoint: 0xe020,
    categories: [0],
    tags: [
      5871,
      1246,
      2433,
      2884,
      345,
      8499,
      1141,
      2786,
      3894,
      6669,
      7749,
      8500,
      406,
      8501,
      439,
      1701,
      325,
      2500,
      408,
      409,
      2787,
      8502,
      2788,
      5720,
      8006,
      275,
      1148,
      1848,
      2045,
      37
    ],
  ),
  "fastfood": SymbolsMetadata(
    popularity: 2699,
    codepoint: 0xe57a,
    categories: [5],
    tags: [
      8503,
      8504,
      8505,
      8506,
      8507,
      193,
      8508,
      3656,
      2050,
      4069,
      4178,
      3659,
      8509,
      8510,
      8511,
      2370,
      6017,
      8512,
      5694,
      578,
      4070,
      1520,
      3661,
      8513,
      8514,
      2549,
      3665,
      8515,
      330,
      8516,
      8517,
      3668,
      8518
    ],
  ),
  "faucet": SymbolsMetadata(
    popularity: 428,
    codepoint: 0xe278,
    categories: [8],
    tags: [
      1889,
      3769,
      3499,
      918,
      3788,
      345,
      8519,
      1051,
      2507,
      580,
      1086,
      1116,
      1479,
      1881,
      4183,
      8520,
      4186,
      1119,
      492,
      5557,
      3805,
      8521,
      5819,
      8522,
      5561,
      1797,
      511,
      3989,
      8523,
      2480
    ],
  ),
  "favorite": SymbolsMetadata(
    popularity: 77124,
    codepoint: 0xe87d,
    categories: [2],
    tags: [
      8524,
      4460,
      8525,
      1688,
      1108,
      504,
      1175,
      81,
      809,
      1794,
      3194,
      1459,
      2296,
      4229,
      138,
      4454,
      1356,
      1604,
      4461,
      406,
      492,
      289,
      203,
      4063,
      1683,
      392,
      705,
      979,
      291,
      31,
      413,
      3205
    ],
  ),
  "fax": SymbolsMetadata(
    popularity: 1402,
    codepoint: 0xead8,
    categories: [11],
    tags: [
      2088,
      919,
      283,
      81,
      288,
      1567,
      2527,
      8526,
      584,
      1729,
      585,
      1372,
      7876,
      1575,
      271,
      1734,
      961,
      432,
      1737,
      2318,
      433,
      65,
      605,
      2074,
      4745,
      8527
    ],
  ),
  "feature_search": SymbolsMetadata(
    popularity: 268,
    codepoint: 0xe9a9,
    categories: [6],
    tags: [
      4517,
      2673,
      7473,
      2341,
      2359,
      316,
      216,
      8528,
      317,
      8529,
      1085,
      68,
      2344,
      5485,
      53,
      2345,
      1091,
      2346,
      2347,
      5805,
      1092,
      1093,
      2348,
      2352,
      3385,
      1736,
      1102,
      8530,
      8531,
      1103,
      2354,
      2356
    ],
  ),
  "featured_play_list": SymbolsMetadata(
    popularity: 684,
    codepoint: 0xe06d,
    categories: [0],
    tags: [
      1320,
      1447,
      1246,
      2251,
      1175,
      621,
      1567,
      8532,
      7862,
      147,
      4453,
      86,
      584,
      88,
      406,
      3448,
      1701,
      91,
      587,
      2500,
      1704,
      1705,
      7863,
      432,
      363,
      94,
      2451,
      8533,
      433,
      2165,
      37,
      2503
    ],
    rtlAutoMirrored: true,
  ),
  "featured_seasonal_and_gifts": SymbolsMetadata(
    popularity: 692,
    codepoint: 0xef91,
    categories: [15],
    tags: [
      8534,
      3189,
      4957,
      8535,
      482,
      4961,
      5172,
      1137,
      2613,
      10,
      7862,
      4963,
      8536,
      8537,
      2665,
      1974,
      138,
      8538,
      2563,
      5158,
      3480,
      3482,
      6253,
      1376,
      4969,
      5495,
      31,
      8539
    ],
  ),
  "featured_video": SymbolsMetadata(
    popularity: 477,
    codepoint: 0xe06e,
    categories: [0],
    tags: [
      8540,
      1153,
      344,
      193,
      1503,
      621,
      779,
      7862,
      147,
      346,
      5108,
      1115,
      4453,
      1347,
      406,
      354,
      439,
      2500,
      409,
      714,
      7863,
      440,
      760,
      330,
      410,
      392,
      8541,
      854,
      454,
      1388,
      37,
      2102
    ],
    rtlAutoMirrored: true,
  ),
  "feedback": SymbolsMetadata(
    popularity: 1468,
    codepoint: 0xe87f,
    categories: [6],
    tags: [
      3074,
      1339,
      1154,
      1340,
      729,
      1342,
      569,
      2706,
      571,
      572,
      283,
      1455,
      1345,
      8542,
      1140,
      2694,
      1346,
      5449,
      5063,
      1459,
      138,
      1347,
      1143,
      5141,
      585,
      2446,
      609,
      8543,
      8544,
      645,
      1237,
      1271,
      1272,
      593,
      31,
      5582,
      554,
      206
    ],
  ),
  "female": SymbolsMetadata(
    popularity: 2281,
    codepoint: 0xe590,
    categories: [3],
    tags: [
      565,
      566,
      4131,
      5,
      193,
      1213,
      6929,
      1803,
      225,
      1804,
      7883,
      583,
      138,
      969,
      1002,
      7884,
      895,
      589,
      590,
      591,
      390,
      392,
      1162,
      978,
      705,
      31,
      597,
      4677,
      3812
    ],
  ),
  "femur": SymbolsMetadata(
    popularity: 173,
    codepoint: 0xf891,
    categories: [3],
    tags: [
      4346,
      3521,
      4131,
      684,
      4079,
      8545,
      375,
      8546,
      8547,
      488,
      137,
      692,
      1765,
      8548,
      583,
      384,
      1505,
      8549,
      1956,
      8550,
      895,
      8551,
      289,
      4147,
      392,
      8552,
      8553,
      8554,
      8555,
      476
    ],
  ),
  "femur_alt": SymbolsMetadata(
    popularity: 169,
    codepoint: 0xf892,
    categories: [3],
    tags: [
      4346,
      3521,
      4347,
      4131,
      684,
      4079,
      8545,
      375,
      8546,
      8556,
      692,
      1765,
      8548,
      583,
      4349,
      384,
      3110,
      8549,
      1956,
      8550,
      895,
      7013,
      8551,
      289,
      4147,
      8557,
      8552,
      8554,
      979,
      31,
      8558
    ],
  ),
  "fence": SymbolsMetadata(
    popularity: 387,
    codepoint: 0xf1f6,
    categories: [8],
    tags: [
      3768,
      2776,
      1108,
      4537,
      1109,
      8559,
      1477,
      3914,
      2777,
      4924,
      5786,
      901,
      8560,
      6871,
      1827,
      8235,
      8561,
      1116,
      1479,
      1583,
      1834,
      1119,
      1836,
      289,
      2362,
      1122,
      8562,
      975,
      1480,
      696,
      3697,
      1483,
      1011,
      703,
      945,
      8563,
      6872
    ],
  ),
  "fertile": SymbolsMetadata(
    popularity: 36,
    codepoint: 0xf6e5,
    categories: [15],
    tags: [
      1815,
      2213,
      4236,
      8564,
      751,
      1292,
      1803,
      2831,
      8565,
      1828,
      234,
      692,
      2371,
      138,
      3919,
      8566,
      1834,
      8567,
      1835,
      8568,
      1837,
      757,
      1840,
      1842,
      2218,
      31
    ],
  ),
  "festival": SymbolsMetadata(
    popularity: 910,
    codepoint: 0xea68,
    categories: [16],
    tags: [
      1580,
      2104,
      4961,
      8569,
      1800,
      4412,
      4479,
      8570,
      1136,
      779,
      10,
      8571,
      2741,
      5767,
      1601,
      1974,
      8161,
      5494,
      6245,
      1520,
      4997,
      1701,
      588,
      641,
      2549,
      2057,
      1145,
      2022,
      705,
      4969,
      5149,
      6121,
      2025,
      6124,
      332
    ],
  ),
  "fiber_dvr": SymbolsMetadata(
    popularity: 171,
    codepoint: 0xe05d,
    categories: [0],
    tags: [
      4,
      482,
      729,
      1075,
      5,
      283,
      1742,
      81,
      288,
      44,
      7674,
      2532,
      779,
      8572,
      8573,
      12,
      1322,
      16,
      584,
      406,
      439,
      267,
      1749,
      408,
      453,
      1268,
      440,
      2447,
      433,
      1685,
      411,
      31,
      1068,
      65,
      412,
      33,
      2045,
      35,
      37
    ],
  ),
  "fiber_manual_record": SymbolsMetadata(
    popularity: 3910,
    codepoint: 0xe061,
    categories: [0],
    tags: [
      747,
      1246,
      729,
      3703,
      504,
      42,
      193,
      345,
      1743,
      8572,
      3549,
      51,
      1087,
      1260,
      5964,
      3381,
      174,
      406,
      2500,
      328,
      453,
      440,
      273,
      2143,
      2218,
      291,
      1203,
      37,
      2102
    ],
  ),
  "fiber_new": SymbolsMetadata(
    popularity: 1085,
    codepoint: 0xe05e,
    categories: [0],
    tags: [
      4,
      518,
      4928,
      5,
      193,
      283,
      284,
      8574,
      81,
      1080,
      44,
      1743,
      1141,
      8572,
      8575,
      12,
      2488,
      1085,
      522,
      4142,
      259,
      16,
      406,
      640,
      267,
      886,
      2350,
      757,
      273,
      275,
      31,
      65,
      33,
      2074,
      35
    ],
  ),
  "fiber_pin": SymbolsMetadata(
    popularity: 205,
    codepoint: 0xe06a,
    categories: [0],
    tags: [
      4,
      518,
      4928,
      5,
      283,
      8576,
      284,
      254,
      4929,
      81,
      2078,
      44,
      8572,
      8577,
      8578,
      12,
      259,
      5219,
      16,
      267,
      8579,
      8580,
      326,
      3927,
      2474,
      273,
      8581,
      4932,
      31,
      65,
      33,
      2074,
      35,
      4933
    ],
  ),
  "fiber_smart_record": SymbolsMetadata(
    popularity: 261,
    codepoint: 0xe062,
    categories: [0],
    tags: [
      777,
      1246,
      8071,
      729,
      504,
      42,
      193,
      621,
      345,
      44,
      1743,
      7674,
      779,
      8572,
      2488,
      1259,
      1260,
      406,
      354,
      439,
      2500,
      408,
      1099,
      8582,
      453,
      1145,
      2022,
      1270,
      8583,
      454,
      65,
      2045,
      37,
      2102
    ],
  ),
  "file_copy": SymbolsMetadata(
    popularity: 5133,
    codepoint: 0xe173,
    categories: [12],
    tags: [
      2154,
      1672,
      6423,
      621,
      1724,
      8584,
      6339,
      81,
      1566,
      1567,
      3626,
      1568,
      147,
      488,
      68,
      6426,
      1571,
      2162,
      1460,
      1574,
      5624,
      2759,
      5590,
      1734,
      453,
      8585,
      1408,
      8586,
      1576,
      594,
      33,
      5920,
      893
    ],
  ),
  "file_copy_off": SymbolsMetadata(
    popularity: 29,
    codepoint: 0xf4d8,
    categories: [12],
    tags: [
      1028,
      743,
      1339,
      3726,
      1187,
      1342,
      6423,
      621,
      1724,
      1302,
      1213,
      6339,
      1031,
      1279,
      867,
      1566,
      1567,
      3626,
      1033,
      2694,
      5063,
      147,
      1191,
      2162,
      886,
      3254,
      6239,
      8587,
      1035,
      1036,
      1037,
      1574,
      2759,
      8588,
      8589,
      1041,
      594,
      1203,
      1042,
      206,
      3712
    ],
  ),
  "file_download_off": SymbolsMetadata(
    popularity: 759,
    codepoint: 0xe4fe,
    categories: [2],
    tags: [
      77,
      3726,
      6323,
      8590,
      867,
      8591,
      3268,
      2778,
      520,
      8592,
      8593,
      8594,
      8595,
      8596,
      8597,
      8598,
      1675,
      1033,
      2694,
      1690,
      5063,
      147,
      8599,
      8600,
      8601,
      8602,
      8603,
      8604,
      8605,
      3018,
      2959,
      1692,
      8606,
      1035,
      1037,
      3081,
      1970,
      1683,
      1041,
      1042,
      527
    ],
  ),
  "file_export": SymbolsMetadata(
    popularity: 124,
    codepoint: 0xf3b2,
    categories: [2],
    tags: [
      2154,
      77,
      482,
      1673,
      1311,
      81,
      608,
      1566,
      1567,
      520,
      1675,
      1690,
      2905,
      147,
      68,
      1294,
      586,
      2361,
      1732,
      1574,
      1575,
      432,
      907,
      1683,
      2318,
      1508,
      433,
      1685,
      526,
      98,
      527
    ],
  ),
  "file_json": SymbolsMetadata(
    popularity: 50,
    codepoint: 0xf3bb,
    categories: [2],
    tags: [
      8607,
      5976,
      8608,
      5,
      1077,
      519,
      678,
      8609,
      8610,
      81,
      6688,
      1080,
      44,
      7595,
      1567,
      2172,
      147,
      12,
      370,
      8611,
      490,
      68,
      6202,
      5979,
      8612,
      15,
      16,
      1099,
      5984,
      3022,
      509,
      945,
      31,
      6805,
      33,
      35,
      8613,
      2222
    ],
  ),
  "file_map": SymbolsMetadata(
    popularity: 51,
    codepoint: 0xe2c5,
    categories: [5],
    tags: [
      2154,
      8614,
      81,
      312,
      313,
      4769,
      1567,
      316,
      147,
      3183,
      2161,
      321,
      68,
      1617,
      2345,
      323,
      324,
      1143,
      174,
      1618,
      1575,
      1619,
      326,
      327,
      1144,
      329,
      453,
      432,
      1621,
      30,
      433,
      1070,
      332
    ],
  ),
  "file_map_stack": SymbolsMetadata(
    popularity: 23,
    codepoint: 0xf3e2,
    categories: [5],
    tags: [
      2154,
      1447,
      1175,
      81,
      8615,
      1567,
      3762,
      8616,
      147,
      3018,
      1677,
      1176,
      68,
      1056,
      88,
      323,
      324,
      1143,
      174,
      2162,
      91,
      1063,
      3384,
      1575,
      4770,
      326,
      327,
      4088,
      4772,
      2451,
      4399,
      30,
      594,
      8617
    ],
  ),
  "file_open": SymbolsMetadata(
    popularity: 4181,
    codepoint: 0xeaf3,
    categories: [2],
    tags: [
      858,
      8618,
      1756,
      501,
      77,
      2673,
      919,
      519,
      81,
      4769,
      1566,
      1567,
      1675,
      316,
      147,
      8619,
      2161,
      8620,
      68,
      1322,
      2216,
      2094,
      1372,
      2876,
      8621,
      8622,
      1574,
      1575,
      453,
      2761,
      1685,
      65,
      396,
      8623
    ],
  ),
  "file_png": SymbolsMetadata(
    popularity: 12,
    codepoint: 0xf3bc,
    categories: [1],
    tags: [
      2154,
      5,
      519,
      621,
      81,
      6687,
      44,
      7595,
      1567,
      8624,
      147,
      2161,
      12,
      370,
      8611,
      137,
      490,
      68,
      6202,
      2814,
      8625,
      1356,
      15,
      16,
      88,
      492,
      1574,
      1575,
      8626,
      453,
      1576,
      1685,
      1377,
      31,
      33,
      35
    ],
  ),
  "file_present": SymbolsMetadata(
    popularity: 1524,
    codepoint: 0xea0e,
    categories: [12],
    tags: [
      1402,
      919,
      373,
      1503,
      1366,
      81,
      1566,
      1567,
      1675,
      147,
      2161,
      1678,
      1052,
      137,
      1055,
      68,
      8627,
      584,
      1460,
      1372,
      3384,
      1575,
      5158,
      1407,
      432,
      1350,
      1408,
      1576,
      2797,
      1441,
      433,
      744,
      1685,
      4549,
      1465
    ],
  ),
  "file_save": SymbolsMetadata(
    popularity: 144,
    codepoint: 0xf17f,
    categories: [12],
    tags: [
      2154,
      77,
      1672,
      519,
      81,
      44,
      2160,
      1566,
      1567,
      2778,
      520,
      1675,
      2527,
      147,
      8628,
      8629,
      2161,
      1678,
      4252,
      68,
      4422,
      2758,
      7975,
      453,
      1683,
      8630,
      8312,
      8313,
      1022,
      1576,
      2797,
      509,
      1685,
      1377,
      65,
      526,
      527,
      3227,
      1465
    ],
  ),
  "file_save_off": SymbolsMetadata(
    popularity: 26,
    codepoint: 0xe505,
    categories: [12],
    tags: [
      77,
      3726,
      1187,
      1188,
      1213,
      8631,
      81,
      1031,
      867,
      8632,
      1566,
      1567,
      2778,
      520,
      1675,
      1033,
      147,
      8629,
      2161,
      1678,
      4422,
      8633,
      8634,
      1035,
      1037,
      1574,
      1575,
      4219,
      1039,
      1970,
      1683,
      8312,
      8313,
      8635,
      8636,
      8637,
      8638,
      8639,
      8640,
      1576,
      1041,
      2797,
      1685,
      1042,
      1465,
      3951
    ],
  ),
  "file_upload_off": SymbolsMetadata(
    popularity: 389,
    codepoint: 0xf886,
    categories: [2],
    tags: [
      77,
      502,
      8641,
      3726,
      1187,
      1673,
      1213,
      81,
      867,
      1567,
      520,
      1675,
      1033,
      1690,
      147,
      2161,
      1191,
      1200,
      1035,
      1036,
      1037,
      1575,
      2865,
      4219,
      1970,
      2318,
      1508,
      1041,
      1685,
      8642,
      526,
      1042,
      1696,
      527,
      3712
    ],
  ),
  "files": SymbolsMetadata(
    popularity: 620,
    codepoint: 0xea85,
    categories: [12],
    tags: [
      1756,
      2154,
      1174,
      1175,
      621,
      81,
      4769,
      1566,
      1567,
      3762,
      8616,
      1675,
      147,
      3018,
      1677,
      2161,
      1678,
      1176,
      86,
      5372,
      8643,
      8644,
      1056,
      1323,
      2162,
      1372,
      1063,
      4771,
      8645,
      1576,
      4399,
      2797,
      594,
      6141,
      1685
    ],
  ),
  "filter": SymbolsMetadata(
    popularity: 664,
    codepoint: 0xe3d3,
    categories: [1],
    tags: [
      862,
      8646,
      2755,
      2398,
      1175,
      6062,
      345,
      5748,
      81,
      1229,
      673,
      487,
      83,
      6440,
      49,
      1583,
      88,
      2094,
      1004,
      1584,
      1585,
      2894,
      8647,
      70,
      1063,
      92,
      57,
      59,
      62,
      912,
      5489,
      8648,
      2179,
      362,
      363,
      71,
      95,
      8649,
      396
    ],
  ),
  "filter_1": SymbolsMetadata(
    popularity: 679,
    codepoint: 0xe3d0,
    categories: [1],
    tags: [
      72,
      1738,
      223,
      677,
      345,
      80,
      5748,
      3565,
      81,
      7,
      1229,
      673,
      487,
      83,
      199,
      6440,
      49,
      2499,
      550,
      88,
      2162,
      2894,
      21,
      22,
      178,
      70,
      92,
      59,
      62,
      4793,
      912,
      26,
      8650,
      1040,
      2353,
      362,
      71,
      95,
      8649,
      8651,
      594,
      31,
      396
    ],
  ),
  "filter_2": SymbolsMetadata(
    popularity: 366,
    codepoint: 0xe3d1,
    categories: [1],
    tags: [
      74,
      6799,
      2755,
      80,
      574,
      81,
      7,
      8,
      1229,
      673,
      487,
      83,
      8652,
      8653,
      6440,
      49,
      2499,
      8654,
      550,
      88,
      2162,
      2894,
      21,
      22,
      149,
      70,
      1750,
      59,
      62,
      4793,
      912,
      26,
      5489,
      2353,
      360,
      363,
      71,
      95,
      7317,
      594,
      31,
      36,
      396
    ],
  ),
  "filter_3": SymbolsMetadata(
    popularity: 321,
    codepoint: 0xe3d2,
    categories: [1],
    tags: [
      75,
      1738,
      2233,
      517,
      345,
      1742,
      80,
      169,
      574,
      81,
      7,
      1229,
      673,
      487,
      83,
      6076,
      6440,
      49,
      2499,
      87,
      584,
      88,
      2162,
      21,
      22,
      149,
      70,
      59,
      62,
      4793,
      912,
      5489,
      8648,
      362,
      363,
      71,
      95,
      8649,
      594,
      31,
      551,
      1718
    ],
  ),
  "filter_4": SymbolsMetadata(
    popularity: 322,
    codepoint: 0xe3d4,
    categories: [1],
    tags: [
      624,
      1738,
      450,
      345,
      80,
      5748,
      81,
      7,
      6543,
      1229,
      673,
      487,
      83,
      627,
      6440,
      49,
      2499,
      790,
      550,
      88,
      2094,
      2162,
      2894,
      6545,
      22,
      70,
      92,
      59,
      62,
      4793,
      1065,
      26,
      3636,
      5489,
      8655,
      362,
      71,
      8656,
      95,
      594,
      31,
      36
    ],
  ),
  "filter_5": SymbolsMetadata(
    popularity: 239,
    codepoint: 0xe3d5,
    categories: [1],
    tags: [
      669,
      1738,
      573,
      8657,
      80,
      5748,
      81,
      7,
      8658,
      1229,
      673,
      487,
      83,
      8659,
      660,
      8660,
      6440,
      49,
      2499,
      86,
      550,
      2162,
      21,
      6548,
      6546,
      22,
      70,
      92,
      59,
      62,
      4793,
      912,
      26,
      5489,
      1202,
      2353,
      363,
      71,
      95,
      594,
      31
    ],
  ),
  "filter_6": SymbolsMetadata(
    popularity: 181,
    codepoint: 0xe3d6,
    categories: [1],
    tags: [
      680,
      8661,
      80,
      8662,
      6828,
      8663,
      7,
      1229,
      673,
      487,
      83,
      8664,
      8665,
      8666,
      49,
      2499,
      6544,
      550,
      8667,
      8668,
      2162,
      21,
      8669,
      6550,
      8670,
      22,
      8671,
      59,
      62,
      4793,
      26,
      8672,
      5489,
      8673,
      71,
      3891,
      8674,
      95,
      594,
      31
    ],
  ),
  "filter_7": SymbolsMetadata(
    popularity: 233,
    codepoint: 0xe3d7,
    categories: [1],
    tags: [
      745,
      1738,
      1402,
      1173,
      450,
      80,
      574,
      81,
      7,
      6555,
      1229,
      673,
      487,
      83,
      6440,
      49,
      2499,
      550,
      88,
      2094,
      2162,
      21,
      6557,
      22,
      70,
      92,
      59,
      62,
      4793,
      912,
      5489,
      3256,
      2353,
      1102,
      363,
      71,
      180,
      8656,
      8649,
      594,
      31,
      35
    ],
  ),
  "filter_8": SymbolsMetadata(
    popularity: 203,
    codepoint: 0xe3d8,
    categories: [1],
    tags: [
      781,
      1738,
      2755,
      8675,
      345,
      5748,
      8676,
      574,
      81,
      7,
      8677,
      1229,
      673,
      487,
      6563,
      83,
      8678,
      6440,
      49,
      2499,
      550,
      1636,
      2162,
      2894,
      8679,
      8680,
      22,
      70,
      92,
      1750,
      59,
      62,
      4793,
      912,
      5489,
      363,
      71,
      8681,
      95,
      7317,
      594,
      31
    ],
  ),
  "filter_9": SymbolsMetadata(
    popularity: 194,
    codepoint: 0xe3d9,
    categories: [1],
    tags: [
      794,
      1738,
      2674,
      345,
      224,
      5748,
      81,
      7,
      1229,
      673,
      487,
      83,
      6440,
      49,
      2499,
      88,
      2094,
      1636,
      2162,
      2894,
      800,
      8682,
      21,
      22,
      70,
      92,
      1750,
      59,
      62,
      4793,
      912,
      5904,
      5489,
      362,
      71,
      95,
      594,
      31,
      511
    ],
  ),
  "filter_9_plus": SymbolsMetadata(
    popularity: 214,
    codepoint: 0xe3da,
    categories: [1],
    tags: [
      231,
      794,
      8683,
      8684,
      223,
      5748,
      81,
      7,
      1229,
      673,
      487,
      83,
      199,
      6440,
      49,
      2499,
      550,
      8685,
      2162,
      800,
      8686,
      21,
      22,
      70,
      59,
      62,
      4793,
      239,
      912,
      26,
      5489,
      8673,
      1102,
      8687,
      8688,
      362,
      8689,
      8690,
      71,
      95,
      8691,
      594,
      31,
      553
    ],
  ),
  "filter_alt": SymbolsMetadata(
    popularity: 17037,
    codepoint: 0xef4f,
    categories: [2],
    tags: [
      1738,
      76,
      450,
      345,
      574,
      81,
      1229,
      83,
      317,
      6440,
      138,
      68,
      8692,
      87,
      88,
      2894,
      70,
      92,
      912,
      5489,
      8648,
      1102,
      362,
      71,
      8693,
      95,
      8649,
      97,
      511,
      1718
    ],
  ),
  "filter_alt_off": SymbolsMetadata(
    popularity: 2336,
    codepoint: 0xeb32,
    categories: [2],
    tags: [
      1527,
      8694,
      8695,
      8696,
      6828,
      8697,
      8698,
      867,
      1229,
      83,
      8699,
      8700,
      8701,
      8702,
      8703,
      8704,
      8705,
      6440,
      8706,
      8707,
      8667,
      8708,
      8709,
      8710,
      1035,
      1036,
      70,
      8711,
      5489,
      8712,
      8713,
      8714,
      8715,
      8716,
      8717,
      8693,
      1041,
      8718,
      8719,
      8720,
      8721
    ],
  ),
  "filter_arrow_right": SymbolsMetadata(
    popularity: 28,
    codepoint: 0xf3d1,
    categories: [2],
    tags: [
      2872,
      76,
      77,
      2398,
      678,
      345,
      81,
      313,
      1229,
      83,
      902,
      6440,
      51,
      68,
      88,
      2894,
      2895,
      325,
      904,
      70,
      92,
      1732,
      1144,
      912,
      5489,
      2353,
      907,
      1694,
      362,
      71,
      8656,
      8693,
      95
    ],
    rtlAutoMirrored: true,
  ),
  "filter_b_and_w": SymbolsMetadata(
    popularity: 264,
    codepoint: 0xe3db,
    categories: [1],
    tags: [
      8534,
      2633,
      8722,
      8723,
      6411,
      8724,
      40,
      8725,
      8726,
      4698,
      8332,
      44,
      1229,
      673,
      487,
      83,
      6415,
      49,
      8321,
      2499,
      3594,
      8727,
      4215,
      8728,
      59,
      62,
      111,
      4793,
      6086,
      71,
      7937,
      2180,
      413,
      7539,
      8527,
      476,
      8729,
      832
    ],
  ),
  "filter_center_focus": SymbolsMetadata(
    popularity: 938,
    codepoint: 0xe3dc,
    categories: [1],
    tags: [
      5518,
      1738,
      5519,
      1107,
      40,
      308,
      8730,
      193,
      2265,
      345,
      1820,
      4529,
      1743,
      1229,
      83,
      1746,
      6606,
      1115,
      49,
      53,
      2345,
      57,
      59,
      62,
      2881,
      1373,
      5517,
      5524,
      2781,
      363,
      433,
      1204,
      476,
      2356
    ],
  ),
  "filter_drama": SymbolsMetadata(
    popularity: 1142,
    codepoint: 0xe3dd,
    categories: [1],
    tags: [
      2704,
      5778,
      1673,
      4040,
      6109,
      1229,
      673,
      487,
      346,
      83,
      137,
      138,
      49,
      1605,
      354,
      8731,
      57,
      59,
      62,
      756,
      8732,
      151,
      2008,
      8733,
      8734,
      6255,
      31,
      7539,
      37,
      476,
      856
    ],
  ),
  "filter_frames": SymbolsMetadata(
    popularity: 280,
    codepoint: 0xe3de,
    categories: [1],
    tags: [
      4782,
      1447,
      8735,
      1108,
      40,
      308,
      484,
      8,
      1229,
      673,
      2172,
      487,
      83,
      6076,
      1746,
      348,
      437,
      8736,
      1321,
      49,
      2499,
      8737,
      385,
      439,
      2162,
      70,
      91,
      92,
      6340,
      386,
      57,
      59,
      62,
      4793,
      3338,
      410,
      94,
      95,
      595,
      396,
      476,
      1207
    ],
  ),
  "filter_hdr": SymbolsMetadata(
    popularity: 490,
    codepoint: 0xe3df,
    categories: [1],
    tags: [
      480,
      1738,
      2233,
      40,
      8,
      1229,
      673,
      487,
      3334,
      83,
      1142,
      8738,
      8739,
      49,
      2985,
      1583,
      1584,
      1585,
      1834,
      70,
      2732,
      5148,
      57,
      59,
      62,
      63,
      5489,
      8740,
      71,
      1718,
      8741,
      37,
      396
    ],
  ),
  "filter_list": SymbolsMetadata(
    popularity: 14153,
    codepoint: 0xe152,
    categories: [2],
    tags: [
      76,
      1403,
      3725,
      517,
      2755,
      345,
      5748,
      83,
      199,
      581,
      584,
      88,
      2094,
      506,
      2894,
      70,
      8742,
      92,
      912,
      8743,
      5489,
      71,
      8744,
      95,
      8649,
      595,
      2300,
      97
    ],
  ),
  "filter_list_off": SymbolsMetadata(
    popularity: 1107,
    codepoint: 0xeb57,
    categories: [2],
    tags: [
      1527,
      517,
      2398,
      778,
      345,
      81,
      1279,
      867,
      8745,
      8,
      1229,
      5922,
      83,
      199,
      1200,
      68,
      584,
      88,
      1004,
      506,
      8746,
      1035,
      1036,
      70,
      92,
      912,
      5489,
      1039,
      1440,
      363,
      71,
      8693,
      1041,
      8649,
      413,
      8747,
      396
    ],
  ),
  "filter_none": SymbolsMetadata(
    popularity: 1153,
    codepoint: 0xe3e0,
    categories: [1],
    tags: [
      1310,
      807,
      808,
      778,
      6939,
      809,
      83,
      2162,
      8748,
      8749,
      8710,
      6530,
      1962,
      817,
      8750,
      820,
      8751,
      8713,
      5843,
      8752,
      433,
      594,
      1963,
      821,
      8753,
      8754,
      8755,
      8756,
      8757,
      8758,
      8759,
      6279,
      3646
    ],
  ),
  "filter_retrolux": SymbolsMetadata(
    popularity: 13,
    codepoint: 0xe3e1,
    categories: [1],
    tags: [
      2504,
      862,
      1739,
      1288,
      501,
      2633,
      2397,
      1742,
      574,
      1229,
      673,
      2172,
      487,
      83,
      6440,
      5371,
      582,
      49,
      8478,
      8479,
      584,
      2094,
      1636,
      70,
      92,
      57,
      912,
      1098,
      8760,
      5489,
      8761,
      71,
      3465,
      1753,
      509,
      95,
      97,
      1718,
      1754,
      8527
    ],
  ),
  "filter_tilt_shift": SymbolsMetadata(
    popularity: 353,
    codepoint: 0xe3e2,
    categories: [1],
    tags: [
      1738,
      2633,
      4257,
      4258,
      40,
      308,
      193,
      462,
      2399,
      752,
      4283,
      1743,
      1229,
      673,
      487,
      83,
      1746,
      49,
      2499,
      53,
      1636,
      355,
      386,
      57,
      59,
      62,
      4793,
      3173,
      151,
      6203,
      510,
      8762,
      511,
      512
    ],
  ),
  "filter_vintage": SymbolsMetadata(
    popularity: 1413,
    codepoint: 0xe3e3,
    categories: [1],
    tags: [
      1738,
      8763,
      40,
      3083,
      1229,
      673,
      487,
      3334,
      8764,
      83,
      6870,
      3592,
      8765,
      49,
      2499,
      8766,
      53,
      3594,
      406,
      7876,
      2732,
      57,
      59,
      62,
      4793,
      8767,
      6435,
      8768,
      433,
      1586,
      37,
      6602,
      8527
    ],
  ),
  "finance": SymbolsMetadata(
    popularity: 321,
    codepoint: 0xe6bf,
    categories: [9],
    tags: [
      1045,
      916,
      1403,
      517,
      917,
      8769,
      950,
      6717,
      921,
      8770,
      373,
      924,
      927,
      8771,
      81,
      375,
      6702,
      928,
      8772,
      954,
      931,
      932,
      956,
      1052,
      8773,
      3262,
      1055,
      226,
      1060,
      938,
      8774,
      941,
      1400,
      3265,
      944,
      594,
      744,
      8775,
      1070,
      946,
      8776,
      948
    ],
  ),
  "finance_chip": SymbolsMetadata(
    popularity: 246,
    codepoint: 0xf84e,
    categories: [12],
    tags: [
      916,
      917,
      919,
      920,
      921,
      4908,
      922,
      924,
      6274,
      951,
      927,
      81,
      44,
      928,
      954,
      2527,
      931,
      932,
      956,
      68,
      938,
      940,
      941,
      1401,
      1653,
      432,
      8777,
      3877,
      1011,
      1376,
      8778,
      433,
      1377,
      65,
      946,
      526
    ],
  ),
  "finance_mode": SymbolsMetadata(
    popularity: 693,
    codepoint: 0xef92,
    categories: [9],
    tags: [
      1402,
      1045,
      502,
      919,
      373,
      81,
      375,
      954,
      3261,
      931,
      932,
      1052,
      234,
      235,
      936,
      1406,
      1370,
      641,
      757,
      1408,
      2418,
      744,
      5196,
      8779,
      5197,
      1409,
      1696,
      1719,
      36
    ],
  ),
  "find_in_page": SymbolsMetadata(
    popularity: 2459,
    codepoint: 0xe880,
    categories: [12],
    tags: [
      621,
      81,
      1566,
      1567,
      1675,
      316,
      147,
      317,
      8780,
      2161,
      1678,
      1085,
      2994,
      68,
      2344,
      53,
      584,
      2345,
      1091,
      5486,
      1092,
      1093,
      2348,
      325,
      1574,
      1575,
      2834,
      432,
      8781,
      1102,
      7442,
      8782,
      1103,
      1576,
      2797,
      433,
      33,
      5594,
      2220,
      396,
      1465,
      2356
    ],
  ),
  "find_replace": SymbolsMetadata(
    popularity: 900,
    codepoint: 0xe881,
    categories: [6],
    tags: [
      746,
      501,
      460,
      502,
      504,
      1078,
      621,
      345,
      81,
      2341,
      1567,
      1229,
      147,
      317,
      1085,
      3431,
      2814,
      2998,
      3432,
      2345,
      1091,
      2347,
      5805,
      1092,
      1093,
      2348,
      1636,
      1098,
      2352,
      2441,
      3581,
      470,
      1102,
      1103,
      509,
      6460,
      33,
      511,
      3989,
      2356
    ],
  ),
  "fingerprint": SymbolsMetadata(
    popularity: 9487,
    codepoint: 0xe90d,
    categories: [6],
    tags: [
      858,
      1019,
      3151,
      5355,
      1076,
      2637,
      4156,
      81,
      7,
      44,
      1795,
      8783,
      583,
      2598,
      2018,
      969,
      584,
      8784,
      6707,
      911,
      1734,
      1009,
      3737,
      1736,
      1011,
      2601,
      8785,
      65,
      8786,
      8787,
      6261,
      5312,
      4799,
      7469
    ],
  ),
  "fingerprint_off": SymbolsMetadata(
    popularity: 46,
    codepoint: 0xf49d,
    categories: [6],
    tags: [
      858,
      1028,
      1019,
      1030,
      5355,
      4331,
      8345,
      5905,
      1189,
      867,
      1033,
      1795,
      8783,
      2598,
      2018,
      969,
      2584,
      1035,
      1036,
      1037,
      1734,
      1009,
      3737,
      1970,
      1040,
      1736,
      8788,
      1022,
      1011,
      8789,
      64,
      1041,
      65,
      8786,
      1798,
      8787,
      1042,
      5312,
      4799
    ],
  ),
  "fire_extinguisher": SymbolsMetadata(
    popularity: 481,
    codepoint: 0xf1d8,
    categories: [8],
    tags: [
      1338,
      1339,
      918,
      5952,
      6843,
      1345,
      2423,
      46,
      8790,
      8791,
      5173,
      8792,
      5174,
      8793,
      580,
      4373,
      873,
      138,
      4871,
      4186,
      3920,
      8794,
      4232,
      5816,
      696,
      2425,
      1463,
      702,
      1011,
      8795,
      511,
      206,
      2480
    ],
  ),
  "fire_hydrant": SymbolsMetadata(
    popularity: 358,
    codepoint: 0xf1a3,
    categories: [5],
    tags: [
      7688,
      1339,
      284,
      1345,
      8796,
      2423,
      5173,
      8797,
      8798,
      8799,
      5174,
      4373,
      8800,
      2984,
      8801,
      1616,
      323,
      174,
      2469,
      8802,
      609,
      5557,
      8803,
      3805,
      1373,
      2057,
      2425,
      702,
      8804,
      8805,
      1531,
      1486,
      3989,
      8523,
      206,
      2480
    ],
  ),
  "fire_truck": SymbolsMetadata(
    popularity: 719,
    codepoint: 0xf8f2,
    categories: [5],
    tags: [
      2421,
      1339,
      1816,
      3403,
      1818,
      1345,
      8796,
      2051,
      8806,
      5173,
      8807,
      8808,
      8809,
      873,
      8810,
      8811,
      8812,
      2425,
      1620,
      702,
      645,
      2137,
      1848,
      1623,
      332,
      1849,
      3989,
      1850,
      206
    ],
    rtlAutoMirrored: true,
  ),
  "fireplace": SymbolsMetadata(
    popularity: 774,
    codepoint: 0xea43,
    categories: [8],
    tags: [
      8813,
      8814,
      3610,
      4878,
      1921,
      4175,
      4154,
      8815,
      3641,
      5173,
      8816,
      5174,
      8154,
      3342,
      8817,
      8818,
      2982,
      1859,
      1116,
      1479,
      8819,
      2718,
      5527,
      5528,
      8820,
      1834,
      1836,
      8821,
      327,
      1884,
      7926,
      8822,
      3786,
      2990,
      857
    ],
  ),
  "first_page": SymbolsMetadata(
    popularity: 2775,
    codepoint: 0xe5dc,
    categories: [2],
    tags: [
      77,
      2433,
      2213,
      3375,
      2848,
      2784,
      345,
      81,
      1567,
      147,
      1922,
      6669,
      7749,
      2216,
      88,
      406,
      352,
      586,
      325,
      1574,
      2500,
      408,
      1407,
      2787,
      2788,
      5720,
      7753,
      2797,
      2218,
      2878,
      1848
    ],
  ),
  "fit_page": SymbolsMetadata(
    popularity: 15,
    codepoint: 0xf77a,
    categories: [12],
    tags: [
      1738,
      6223,
      1107,
      626,
      621,
      8823,
      2399,
      752,
      8,
      1567,
      8824,
      2359,
      1303,
      2240,
      2241,
      8825,
      8826,
      370,
      1691,
      385,
      2360,
      8827,
      1574,
      1575,
      1407,
      5904,
      2243,
      391,
      410,
      298,
      396,
      4721,
      2356,
      8828
    ],
  ),
  "fit_page_height": SymbolsMetadata(
    popularity: 13,
    codepoint: 0xf397,
    categories: [12],
    tags: [
      8829,
      8830,
      502,
      8831,
      8832,
      2778,
      2359,
      8833,
      8834,
      8835,
      3010,
      8836,
      370,
      8837,
      383,
      8838,
      8839,
      8840,
      8841,
      8842,
      8843,
      8844,
      2243,
      8845,
      391,
      8846,
      8847,
      8848,
      8849,
      1696,
      8850,
      8851,
      8852,
      8853,
      8854,
      8855
    ],
  ),
  "fit_page_width": SymbolsMetadata(
    popularity: 23,
    codepoint: 0xf396,
    categories: [12],
    tags: [
      1738,
      502,
      621,
      8,
      1567,
      2172,
      2359,
      1303,
      147,
      2240,
      8856,
      370,
      4590,
      581,
      1583,
      385,
      2216,
      8857,
      1575,
      1407,
      2834,
      2243,
      907,
      391,
      410,
      298,
      1959,
      33,
      396,
      8613,
      8858,
      2529,
      397,
      2356,
      8859
    ],
  ),
  "fit_screen": SymbolsMetadata(
    popularity: 1923,
    codepoint: 0xea10,
    categories: [2],
    tags: [
      1738,
      502,
      626,
      1109,
      482,
      3008,
      3009,
      8,
      2359,
      1303,
      2241,
      3010,
      370,
      348,
      6628,
      1691,
      1304,
      385,
      2360,
      406,
      623,
      432,
      5904,
      391,
      410,
      298,
      1959,
      543,
      396,
      1165,
      2356
    ],
  ),
  "fit_width": SymbolsMetadata(
    popularity: 33,
    codepoint: 0xf779,
    categories: [12],
    tags: [
      1738,
      2233,
      626,
      8,
      8860,
      2359,
      8861,
      2241,
      8856,
      370,
      6628,
      581,
      49,
      385,
      2360,
      406,
      8857,
      1407,
      5904,
      8862,
      391,
      3056,
      410,
      8863,
      298,
      1959,
      37,
      396,
      8864,
      8613,
      2529,
      397,
      2356
    ],
  ),
  "fitness_center": SymbolsMetadata(
    popularity: 4802,
    codepoint: 0xeb43,
    categories: [16],
    tags: [
      747,
      7541,
      7290,
      8865,
      8219,
      308,
      8223,
      11,
      2533,
      8866,
      8867,
      8226,
      8868,
      8869,
      692,
      8870,
      7545,
      8871,
      4082,
      8872,
      8227,
      2549,
      30,
      642,
      2988,
      8873,
      8874,
      8232,
      3473,
      8875
    ],
  ),
  "fitness_tracker": SymbolsMetadata(
    popularity: 81,
    codepoint: 0xf463,
    categories: [11],
    tags: [
      2504,
      2530,
      2531,
      1248,
      1227,
      569,
      1135,
      81,
      288,
      11,
      2831,
      8876,
      7119,
      1894,
      8877,
      1086,
      692,
      5364,
      1230,
      17,
      1060,
      262,
      3470,
      468,
      8878,
      641,
      271,
      8227,
      757,
      2835,
      29,
      410,
      1695,
      2534,
      30,
      744,
      8879,
      3753,
      525,
      33,
      1148,
      2536,
      1070,
      2988,
      477,
      909,
      2102,
      2537,
      2539,
      333,
      3473,
      2541,
      2542
    ],
  ),
  "flag": SymbolsMetadata(
    popularity: 9509,
    codepoint: 0xe153,
    categories: [5],
    tags: [
      3,
      1155,
      1688,
      1108,
      4450,
      312,
      1590,
      809,
      4451,
      4452,
      13,
      1115,
      51,
      52,
      1530,
      323,
      1143,
      174,
      4455,
      20,
      4456,
      8880,
      1160,
      289,
      5142,
      326,
      327,
      4457,
      1408,
      1683,
      273,
      705,
      1963,
      2218,
      1129,
      8338,
      334
    ],
    rtlAutoMirrored: true,
  ),
  "flag_2": SymbolsMetadata(
    popularity: 214,
    codepoint: 0xf40f,
    categories: [5],
    tags: [
      3,
      1339,
      1310,
      4450,
      312,
      1590,
      8881,
      4451,
      4452,
      13,
      137,
      138,
      1530,
      323,
      1143,
      174,
      4455,
      20,
      4456,
      1160,
      1348,
      289,
      5142,
      326,
      327,
      4457,
      1408,
      390,
      1683,
      392,
      1317,
      705,
      2218,
      31,
      5143,
      206,
      334
    ],
  ),
  "flag_check": SymbolsMetadata(
    popularity: 122,
    codepoint: 0xf3d8,
    categories: [5],
    tags: [
      3,
      3189,
      1155,
      1660,
      1662,
      2637,
      2657,
      2340,
      4450,
      312,
      2342,
      1590,
      1082,
      2639,
      4451,
      4452,
      488,
      13,
      51,
      1530,
      87,
      323,
      1143,
      174,
      4455,
      20,
      4456,
      3061,
      1663,
      2642,
      289,
      5142,
      327,
      4457,
      1496,
      1408,
      1683,
      362,
      392,
      273,
      705,
      8046,
      2218,
      245,
      1497,
      1665,
      1562,
      5143,
      3484,
      334,
      1668
    ],
  ),
  "flag_circle": SymbolsMetadata(
    popularity: 1830,
    codepoint: 0xeaf8,
    categories: [5],
    tags: [
      193,
      4450,
      312,
      313,
      3477,
      968,
      8881,
      4451,
      318,
      13,
      322,
      323,
      1143,
      174,
      4456,
      8880,
      325,
      289,
      8882,
      2881,
      327,
      1144,
      329,
      27,
      1125,
      1408,
      330,
      3283,
      2218,
      31,
      1129
    ],
  ),
  "flaky": SymbolsMetadata(
    popularity: 811,
    codepoint: 0xef50,
    categories: [1],
    tags: [
      4572,
      8883,
      1658,
      1660,
      1188,
      8884,
      2799,
      570,
      463,
      4698,
      2342,
      2897,
      1190,
      1303,
      8885,
      8886,
      578,
      8887,
      582,
      584,
      88,
      1143,
      506,
      8888,
      237,
      8248,
      325,
      3254,
      1663,
      8889,
      70,
      8890,
      362,
      8891,
      8892,
      2896,
      8893,
      1203,
      97,
      1665,
      413,
      1562,
      8894,
      3712,
      1668
    ],
  ),
  "flare": SymbolsMetadata(
    popularity: 1197,
    codepoint: 0xe3e4,
    categories: [1],
    tags: [
      1738,
      8895,
      3589,
      1213,
      1229,
      673,
      6618,
      487,
      2739,
      3334,
      83,
      8896,
      8897,
      3342,
      3550,
      1115,
      4705,
      49,
      2499,
      8898,
      3594,
      3579,
      59,
      62,
      4793,
      240,
      3173,
      3596,
      3200,
      3201,
      854,
      1586,
      4289
    ],
  ),
  "flash_auto": SymbolsMetadata(
    popularity: 371,
    codepoint: 0xe3e5,
    categories: [1],
    tags: [
      1151,
      2048,
      8899,
      3331,
      3893,
      3589,
      3340,
      40,
      42,
      8900,
      345,
      3640,
      3879,
      3641,
      1141,
      4354,
      1115,
      49,
      3894,
      3594,
      3895,
      635,
      1035,
      1037,
      355,
      57,
      59,
      62,
      3645,
      363,
      151,
      31,
      3896,
      413,
      37,
      4356
    ],
  ),
  "flash_off": SymbolsMetadata(
    popularity: 889,
    codepoint: 0xe3e6,
    categories: [1],
    tags: [
      3893,
      8318,
      8901,
      8902,
      302,
      4040,
      2580,
      8903,
      8904,
      867,
      3640,
      1033,
      3641,
      1141,
      4354,
      8905,
      8906,
      8907,
      3894,
      8908,
      5176,
      8909,
      3895,
      4701,
      8910,
      8911,
      8912,
      1035,
      1037,
      305,
      59,
      8913,
      8914,
      8915,
      1041,
      3896,
      4299,
      8916
    ],
  ),
  "flash_on": SymbolsMetadata(
    popularity: 2816,
    codepoint: 0xe3e7,
    categories: [1],
    tags: [
      4301,
      1339,
      3893,
      3589,
      40,
      8901,
      1345,
      867,
      3640,
      3879,
      1033,
      3641,
      1141,
      4354,
      3342,
      8917,
      7952,
      3894,
      3594,
      5176,
      3895,
      609,
      1035,
      1037,
      57,
      8918,
      59,
      3645,
      3200,
      1041,
      291,
      3948,
      3896,
      413,
      4306,
      206
    ],
  ),
  "flashlight_off": SymbolsMetadata(
    popularity: 411,
    codepoint: 0xf00a,
    categories: [4],
    tags: [
      8919,
      8920,
      504,
      345,
      4040,
      2580,
      288,
      867,
      3640,
      1033,
      4354,
      8921,
      8922,
      138,
      4705,
      1200,
      8923,
      3594,
      8908,
      4015,
      1035,
      7377,
      1037,
      289,
      8924,
      8925,
      392,
      1041,
      31,
      4298,
      511,
      8926,
      4299,
      1326,
      3989,
      3598
    ],
  ),
  "flashlight_on": SymbolsMetadata(
    popularity: 1105,
    codepoint: 0xf00b,
    categories: [4],
    tags: [
      858,
      2421,
      8895,
      3589,
      504,
      40,
      345,
      4040,
      288,
      867,
      2423,
      1033,
      4354,
      8921,
      873,
      138,
      8917,
      3594,
      262,
      4015,
      1035,
      1037,
      59,
      151,
      1041,
      2409,
      31,
      413,
      511,
      5186,
      3989,
      37,
      396,
      3598
    ],
  ),
  "flatware": SymbolsMetadata(
    popularity: 791,
    codepoint: 0xf00c,
    categories: [8],
    tags: [
      3653,
      7233,
      3654,
      4175,
      4803,
      4635,
      3658,
      4069,
      8927,
      3659,
      4807,
      8928,
      2370,
      2941,
      4118,
      4183,
      4808,
      6245,
      3661,
      506,
      289,
      906,
      3665,
      3667,
      4812,
      1317,
      4813,
      8929,
      1296,
      4814
    ],
  ),
  "flex_direction": SymbolsMetadata(
    popularity: 15,
    codepoint: 0xf778,
    categories: [12],
    tags: [
      2166,
      1447,
      77,
      502,
      6088,
      1419,
      313,
      8,
      2778,
      2206,
      2201,
      1051,
      370,
      382,
      581,
      86,
      385,
      8930,
      2216,
      584,
      88,
      586,
      6198,
      91,
      92,
      507,
      3338,
      1269,
      907,
      1630,
      945,
      1696,
      1445,
      396,
      398,
      399
    ],
  ),
  "flex_no_wrap": SymbolsMetadata(
    popularity: 11,
    codepoint: 0xf777,
    categories: [12],
    tags: [
      8931,
      2166,
      1447,
      1077,
      3322,
      2205,
      485,
      1080,
      313,
      1140,
      2201,
      1051,
      370,
      382,
      581,
      86,
      385,
      87,
      8932,
      91,
      1063,
      329,
      1099,
      1480,
      432,
      3338,
      1630,
      94,
      2782,
      945,
      2180,
      396,
      2210
    ],
  ),
  "flex_wrap": SymbolsMetadata(
    popularity: 31,
    codepoint: 0xf776,
    categories: [12],
    tags: [
      8933,
      2167,
      1447,
      481,
      2284,
      4658,
      1419,
      621,
      313,
      1567,
      8934,
      1051,
      370,
      2173,
      382,
      581,
      2202,
      385,
      4524,
      584,
      8935,
      91,
      2177,
      1733,
      432,
      3338,
      592,
      1269,
      2181,
      8936,
      8937,
      396,
      4166,
      8938,
      8539
    ],
  ),
  "flight": SymbolsMetadata(
    popularity: 6003,
    codepoint: 0xe539,
    categories: [14],
    tags: [
      834,
      1997,
      1938,
      1913,
      2001,
      1987,
      2879,
      77,
      5605,
      313,
      1924,
      2028,
      2004,
      2005,
      1947,
      8939,
      902,
      138,
      8940,
      635,
      586,
      325,
      1037,
      387,
      2007,
      328,
      71,
      273,
      978,
      2008,
      275,
      31,
      1848,
      1623,
      332,
      1945,
      1850
    ],
  ),
  "flight_class": SymbolsMetadata(
    popularity: 325,
    codepoint: 0xe7cb,
    categories: [5],
    tags: [
      4934,
      834,
      1997,
      1938,
      1912,
      1913,
      2001,
      1987,
      8941,
      1961,
      1916,
      919,
      1917,
      1918,
      1920,
      1921,
      954,
      1923,
      1924,
      2004,
      2005,
      1947,
      1617,
      1928,
      8942,
      387,
      2007,
      1931,
      1933,
      1934,
      645,
      273,
      1848,
      1623,
      332,
      1945,
      1952,
      8943
    ],
  ),
  "flight_land": SymbolsMetadata(
    popularity: 1216,
    codepoint: 0xe904,
    categories: [14],
    tags: [
      834,
      1938,
      1913,
      2001,
      1987,
      2879,
      6965,
      8944,
      1961,
      8945,
      5605,
      7945,
      2839,
      1924,
      8946,
      8947,
      2004,
      2005,
      1947,
      1831,
      8948,
      8949,
      8950,
      387,
      2007,
      273,
      1623,
      332,
      8951,
      8952,
      1945
    ],
    rtlAutoMirrored: true,
  ),
  "flight_takeoff": SymbolsMetadata(
    popularity: 3922,
    codepoint: 0xe905,
    categories: [14],
    tags: [
      834,
      8953,
      1997,
      1938,
      1913,
      2001,
      1987,
      2879,
      8944,
      77,
      78,
      1961,
      8945,
      5605,
      2358,
      1924,
      2004,
      2005,
      1947,
      1617,
      8950,
      896,
      5391,
      8954,
      387,
      2007,
      273,
      8955,
      8956,
      1848,
      1623,
      332,
      1945,
      1696,
      4319,
      8957
    ],
    rtlAutoMirrored: true,
  ),
  "flights_and_hotels": SymbolsMetadata(
    popularity: 82,
    codepoint: 0xe9ab,
    categories: [16],
    tags: [
      1475,
      834,
      1938,
      1913,
      2001,
      1987,
      1915,
      1916,
      918,
      312,
      315,
      1924,
      2004,
      2005,
      1947,
      4008,
      320,
      1974,
      5606,
      2717,
      8958,
      1989,
      1617,
      1975,
      3793,
      2054,
      4015,
      387,
      2007,
      1931,
      1932,
      1884,
      1484,
      273,
      1935,
      3286,
      1848,
      1623,
      332,
      8959,
      1945,
      1952
    ],
    rtlAutoMirrored: true,
  ),
  "flip": SymbolsMetadata(
    popularity: 897,
    codepoint: 0xe3e8,
    categories: [1],
    tags: [
      4572,
      1738,
      77,
      2397,
      8960,
      8961,
      2399,
      752,
      313,
      1229,
      673,
      5085,
      8962,
      49,
      5319,
      1636,
      6192,
      70,
      507,
      8963,
      8964,
      2788,
      470,
      8965,
      71,
      472,
      3584,
      2409,
      1296,
      512,
      473,
      2946,
      890,
      8966
    ],
  ),
  "flip_camera_android": SymbolsMetadata(
    popularity: 893,
    codepoint: 0xea37,
    categories: [1],
    tags: [
      1286,
      502,
      8967,
      5129,
      40,
      8968,
      8318,
      8969,
      102,
      5131,
      308,
      8970,
      8971,
      5134,
      288,
      8972,
      1229,
      673,
      3261,
      5085,
      5135,
      5087,
      1894,
      49,
      262,
      5088,
      8973,
      507,
      8974,
      59,
      2788,
      470,
      5137,
      5091,
      3584,
      5092,
      473,
      2946,
      5094,
      8975
    ],
  ),
  "flip_camera_ios": SymbolsMetadata(
    popularity: 663,
    codepoint: 0xea38,
    categories: [1],
    tags: [
      2783,
      1286,
      502,
      40,
      5131,
      42,
      2397,
      193,
      345,
      288,
      313,
      2785,
      1229,
      673,
      5085,
      5135,
      5087,
      49,
      2794,
      406,
      262,
      507,
      57,
      59,
      62,
      5114,
      453,
      470,
      5137,
      5138,
      1695,
      3584,
      5092,
      473,
      37,
      5094,
      5140
    ],
  ),
  "flip_to_back": SymbolsMetadata(
    popularity: 259,
    codepoint: 0xe882,
    categories: [12],
    tags: [
      76,
      1447,
      2433,
      8976,
      8977,
      2399,
      752,
      484,
      1140,
      5085,
      370,
      5086,
      1176,
      8737,
      1056,
      385,
      586,
      8501,
      7504,
      2818,
      8978,
      2242,
      91,
      92,
      6340,
      2732,
      329,
      592,
      8979,
      8980,
      95,
      594,
      1706,
      7941
    ],
  ),
  "flip_to_front": SymbolsMetadata(
    popularity: 403,
    codepoint: 0xe883,
    categories: [12],
    tags: [
      76,
      1447,
      2973,
      2433,
      8976,
      8981,
      920,
      2399,
      752,
      484,
      2974,
      5085,
      8982,
      8983,
      370,
      5086,
      2730,
      385,
      586,
      2818,
      91,
      6340,
      2732,
      386,
      2209,
      4613,
      592,
      6794,
      8984,
      95,
      594,
      1706,
      8985,
      7941
    ],
  ),
  "float_landscape_2": SymbolsMetadata(
    popularity: 30,
    codepoint: 0xf45c,
    categories: [2],
    tags: [
      1738,
      1447,
      2799,
      1699,
      8,
      5085,
      8986,
      370,
      1583,
      2730,
      385,
      406,
      8987,
      2841,
      262,
      354,
      8988,
      7041,
      2876,
      2732,
      8989,
      8990,
      408,
      409,
      8991,
      1220,
      329,
      2243,
      470,
      410,
      8992,
      6187,
      8993,
      454,
      37,
      396,
      1165
    ],
    rtlAutoMirrored: true,
  ),
  "float_portrait_2": SymbolsMetadata(
    popularity: 9,
    codepoint: 0xf45b,
    categories: [2],
    tags: [
      3491,
      2799,
      8,
      5085,
      8994,
      370,
      348,
      385,
      406,
      812,
      7041,
      2876,
      289,
      2732,
      8989,
      8990,
      974,
      329,
      432,
      470,
      410,
      392,
      1317,
      433,
      37,
      396,
      1165
    ],
    rtlAutoMirrored: true,
  ),
  "flood": SymbolsMetadata(
    popularity: 806,
    codepoint: 0xebe6,
    categories: [3],
    tags: [
      8995,
      1339,
      837,
      5955,
      4365,
      1345,
      8996,
      4369,
      8997,
      2423,
      1856,
      8998,
      8999,
      9000,
      9001,
      4373,
      9002,
      9003,
      9004,
      4186,
      1833,
      6774,
      5927,
      9005,
      4355,
      206,
      2480,
      1866,
      1867,
      5263,
      856
    ],
  ),
  "floor": SymbolsMetadata(
    popularity: 99,
    codepoint: 0xf6e4,
    categories: [15],
    tags: [
      480,
      7047,
      1109,
      1139,
      2831,
      3742,
      1142,
      1829,
      581,
      9006,
      790,
      87,
      7324,
      2893,
      226,
      812,
      819,
      2294,
      703,
      1317,
      9007,
      8132,
      8133,
      3753,
      4542
    ],
  ),
  "floor_lamp": SymbolsMetadata(
    popularity: 240,
    codepoint: 0xe21e,
    categories: [10],
    tags: [
      9008,
      7047,
      3590,
      193,
      1921,
      7079,
      6573,
      1137,
      9009,
      9010,
      9011,
      9012,
      4008,
      3342,
      1116,
      1479,
      1880,
      4705,
      2720,
      9013,
      3594,
      5176,
      87,
      5528,
      492,
      9014,
      1884,
      3999,
      4111,
      9015,
      1445
    ],
  ),
  "flowchart": SymbolsMetadata(
    popularity: 246,
    codepoint: 0xf38d,
    categories: [9],
    tags: [
      565,
      1402,
      1045,
      1447,
      1046,
      373,
      2321,
      1047,
      284,
      81,
      375,
      1051,
      5049,
      1052,
      1054,
      3763,
      1055,
      385,
      584,
      5474,
      5710,
      1059,
      226,
      1060,
      267,
      1062,
      1063,
      3568,
      1065,
      3338,
      94,
      433,
      2684,
      9016,
      744,
      3753,
      945,
      1068,
      1070,
      1071,
      476,
      2949
    ],
  ),
  "flowsheet": SymbolsMetadata(
    popularity: 163,
    codepoint: 0xe0ae,
    categories: [9],
    tags: [
      9017,
      2396,
      373,
      1049,
      9018,
      9019,
      375,
      1566,
      1567,
      147,
      1051,
      9020,
      1052,
      692,
      1054,
      1055,
      9021,
      584,
      5710,
      1059,
      895,
      267,
      1062,
      1063,
      5018,
      1574,
      1575,
      3568,
      9022,
      1065,
      9023,
      94,
      1576,
      2797,
      3753,
      945,
      1068,
      1071,
      3718,
      2949
    ],
  ),
  "fluid": SymbolsMetadata(
    popularity: 6,
    codepoint: 0xe483,
    categories: [3],
    tags: [
      480,
      9024,
      1904,
      1855,
      9025,
      2849,
      4241,
      1252,
      3641,
      1051,
      2507,
      9026,
      137,
      692,
      4186,
      1767,
      895,
      1769,
      353,
      468,
      2473,
      1835,
      9027,
      3645,
      9028,
      1010,
      2419,
      392,
      675,
      454,
      31,
      9029,
      2480,
      1866
    ],
  ),
  "fluid_balance": SymbolsMetadata(
    popularity: 8,
    codepoint: 0xf80d,
    categories: [3],
    tags: [
      1402,
      914,
      8260,
      6195,
      373,
      4134,
      1311,
      1566,
      1567,
      2849,
      4241,
      4137,
      147,
      6955,
      8262,
      2507,
      9026,
      9030,
      1052,
      692,
      1055,
      8264,
      4143,
      1057,
      4186,
      17,
      895,
      1574,
      1575,
      9031,
      9032,
      9033,
      4147,
      1576,
      2797,
      7651,
      9034,
      3063,
      9035,
      554
    ],
  ),
  "fluid_med": SymbolsMetadata(
    popularity: 7,
    codepoint: 0xf80c,
    categories: [3],
    tags: [
      1402,
      8260,
      373,
      5952,
      4134,
      1311,
      1566,
      1567,
      2849,
      4137,
      5740,
      147,
      8262,
      2507,
      9026,
      1085,
      9036,
      1052,
      692,
      1055,
      8264,
      4143,
      4186,
      4161,
      895,
      1769,
      1574,
      1575,
      4146,
      1773,
      9037,
      3385,
      9033,
      4147,
      9038,
      1576,
      2797,
      7651,
      9034,
      3063,
      9039
    ],
  ),
  "fluorescent": SymbolsMetadata(
    popularity: 308,
    codepoint: 0xec31,
    categories: [1],
    tags: [
      862,
      3589,
      3590,
      40,
      2739,
      3640,
      3879,
      3641,
      83,
      9040,
      9041,
      3342,
      4705,
      49,
      9042,
      9043,
      9013,
      3594,
      9044,
      9045,
      5176,
      57,
      59,
      62,
      3645,
      71,
      3343,
      3201,
      9046,
      9047,
      9048
    ],
  ),
  "flutter": SymbolsMetadata(
    popularity: 150,
    codepoint: 0xf1dd,
    categories: [6],
    tags: [
      1288,
      501,
      2484,
      1077,
      1365,
      9049,
      9050,
      1080,
      3477,
      9051,
      9052,
      1680,
      969,
      2466,
      262,
      2492,
      1098,
      1099,
      509,
      31,
      65,
      4875,
      9053
    ],
  ),
  "flutter_dash": SymbolsMetadata(
    popularity: 1997,
    codepoint: 0xe00b,
    categories: [6],
    tags: [
      480,
      9054,
      1286,
      1288,
      501,
      566,
      9055,
      2485,
      6126,
      5,
      1077,
      2239,
      9056,
      9057,
      2399,
      1293,
      225,
      9051,
      9052,
      5733,
      2488,
      1142,
      1680,
      9058,
      138,
      2466,
      2490,
      2492,
      289,
      590,
      1098,
      1099,
      2495,
      1317,
      509,
      9059,
      65
    ],
  ),
  "flyover": SymbolsMetadata(
    popularity: 66,
    codepoint: 0xf478,
    categories: [14],
    tags: [
      4934,
      500,
      9060,
      1289,
      374,
      81,
      312,
      313,
      9061,
      4060,
      1615,
      51,
      6202,
      9062,
      1617,
      1530,
      323,
      1059,
      1520,
      174,
      325,
      507,
      9063,
      386,
      326,
      1373,
      329,
      390,
      9064,
      4703,
      496,
      31,
      1622,
      1623,
      332,
      396,
      476
    ],
  ),
  "fmd_bad": SymbolsMetadata(
    popularity: 1506,
    codepoint: 0xf00e,
    categories: [5],
    tags: [
      3074,
      1339,
      1340,
      9065,
      1342,
      1345,
      5905,
      312,
      313,
      2402,
      867,
      2694,
      1346,
      9066,
      9067,
      9068,
      9069,
      7828,
      9070,
      321,
      1347,
      323,
      9071,
      8292,
      9072,
      1517,
      7282,
      9073,
      9074,
      9075,
      9076,
      9077,
      7283,
      1519,
      9078,
      1520,
      1143,
      174,
      325,
      609,
      1035,
      326,
      327,
      329,
      31,
      332,
      1042,
      206
    ],
  ),
  "foggy": SymbolsMetadata(
    popularity: 546,
    codepoint: 0xe818,
    categories: [3],
    tags: [
      480,
      1851,
      837,
      1673,
      9079,
      5925,
      839,
      1823,
      5260,
      9080,
      2832,
      6887,
      4273,
      581,
      5372,
      584,
      9081,
      5856,
      5276,
      9082,
      1834,
      4194,
      1836,
      5926,
      9083,
      3766,
      855,
      9084,
      3598,
      206,
      856
    ],
  ),
  "folded_hands": SymbolsMetadata(
    popularity: 78,
    codepoint: 0xf5ed,
    categories: [3],
    tags: [
      9085,
      9086,
      9087,
      5766,
      4157,
      2664,
      9088,
      2666,
      2093,
      9089,
      873,
      9090,
      9091,
      9092,
      5178,
      9093,
      9094,
      9095,
      9096,
      9097,
      9098,
      5180,
      9099,
      5184,
      9100,
      878,
      9101,
      9102,
      4570,
      5189
    ],
  ),
  "folder": SymbolsMetadata(
    popularity: 10695,
    codepoint: 0xe2c7,
    categories: [12],
    tags: [
      2154,
      482,
      1494,
      7638,
      4204,
      519,
      1311,
      81,
      9103,
      44,
      9104,
      4769,
      1566,
      1567,
      9105,
      1675,
      147,
      9106,
      9107,
      968,
      9108,
      2161,
      1678,
      2296,
      9109,
      587,
      9110,
      4771,
      4088,
      1576,
      2797,
      1685
    ],
  ),
  "folder_check": SymbolsMetadata(
    popularity: 29,
    codepoint: 0xf3d7,
    categories: [12],
    tags: [
      2629,
      2338,
      2653,
      2154,
      1660,
      463,
      2637,
      4445,
      2657,
      2340,
      81,
      4769,
      1566,
      1567,
      2342,
      1675,
      1082,
      147,
      2639,
      2161,
      1678,
      1143,
      3099,
      1663,
      2642,
      9111,
      4421,
      362,
      1576,
      2797,
      291,
      1685,
      9112,
      245,
      1665,
      2650,
      1562,
      7469,
      1668
    ],
  ),
  "folder_check_2": SymbolsMetadata(
    popularity: 17,
    codepoint: 0xf3d6,
    categories: [12],
    tags: [
      2653,
      1660,
      2113,
      463,
      2637,
      4445,
      2340,
      81,
      4769,
      1566,
      1567,
      2342,
      1675,
      1140,
      1082,
      147,
      9113,
      2161,
      1678,
      137,
      138,
      68,
      1322,
      1143,
      1663,
      2642,
      1063,
      9111,
      390,
      4421,
      362,
      1576,
      2797,
      1685,
      245,
      31,
      1665,
      141,
      1327,
      4420,
      1562,
      476,
      1668
    ],
  ),
  "folder_code": SymbolsMetadata(
    popularity: 71,
    codepoint: 0xf3c8,
    categories: [12],
    tags: [
      858,
      501,
      2154,
      5976,
      1077,
      9114,
      2239,
      2205,
      81,
      6090,
      1292,
      1293,
      1080,
      9115,
      4769,
      9116,
      1566,
      1567,
      3762,
      1675,
      4876,
      2749,
      147,
      3018,
      9107,
      1677,
      9117,
      2161,
      1678,
      5977,
      138,
      2876,
      1063,
      2494,
      1099,
      9118,
      1496,
      2760,
      1576,
      2797,
      509,
      5987,
      1685,
      31
    ],
  ),
  "folder_copy": SymbolsMetadata(
    popularity: 1538,
    codepoint: 0xebbd,
    categories: [12],
    tags: [
      2154,
      1672,
      6423,
      1175,
      621,
      1724,
      8584,
      6339,
      81,
      4769,
      1566,
      1567,
      3762,
      1675,
      3626,
      147,
      1677,
      2161,
      1678,
      9119,
      68,
      6426,
      1004,
      2162,
      4771,
      5590,
      6342,
      2760,
      1683,
      9120,
      9121,
      1576,
      2797,
      1685
    ],
  ),
  "folder_data": SymbolsMetadata(
    popularity: 61,
    codepoint: 0xf586,
    categories: [12],
    tags: [
      480,
      501,
      2154,
      1077,
      519,
      1311,
      81,
      1448,
      44,
      4769,
      1566,
      1567,
      1675,
      147,
      1677,
      968,
      2161,
      1678,
      137,
      68,
      1004,
      3418,
      1063,
      2846,
      1619,
      1098,
      4088,
      392,
      1576,
      2797,
      509,
      1685,
      945,
      31,
      1068,
      1326,
      333
    ],
  ),
  "folder_delete": SymbolsMetadata(
    popularity: 699,
    codepoint: 0xeb34,
    categories: [12],
    tags: [
      1756,
      2154,
      2754,
      919,
      1875,
      778,
      519,
      81,
      6090,
      1031,
      1566,
      1567,
      3762,
      1675,
      147,
      3018,
      2161,
      9122,
      1678,
      3355,
      1004,
      1372,
      1063,
      587,
      9123,
      1039,
      9124,
      1576,
      2797,
      1685,
      1068,
      3360,
      6916
    ],
  ),
  "folder_eye": SymbolsMetadata(
    popularity: 25,
    codepoint: 0xf3d5,
    categories: [12],
    tags: [
      858,
      3154,
      9125,
      81,
      4769,
      1566,
      1567,
      1675,
      5803,
      316,
      5787,
      147,
      2161,
      9126,
      8620,
      9127,
      9128,
      1678,
      1199,
      5484,
      1091,
      1037,
      2876,
      975,
      2843,
      4195,
      1103,
      1576,
      2022,
      2797,
      1685,
      9129,
      396,
      3598,
      2102
    ],
  ),
  "folder_info": SymbolsMetadata(
    popularity: 24,
    codepoint: 0xf395,
    categories: [12],
    tags: [
      5586,
      1339,
      4,
      1154,
      865,
      144,
      193,
      519,
      1311,
      81,
      145,
      4769,
      1566,
      1567,
      1675,
      9130,
      147,
      2161,
      1678,
      873,
      5065,
      138,
      293,
      68,
      15,
      148,
      1063,
      150,
      645,
      1576,
      2797,
      1685,
      878,
      31
    ],
  ),
  "folder_limited": SymbolsMetadata(
    popularity: 92,
    codepoint: 0xf4e4,
    categories: [12],
    tags: [
      858,
      1755,
      1756,
      4211,
      481,
      1187,
      1188,
      4204,
      9131,
      3154,
      345,
      81,
      4769,
      1566,
      1567,
      3762,
      1675,
      1568,
      1190,
      147,
      2161,
      1678,
      550,
      1967,
      3792,
      2584,
      1004,
      3254,
      2644,
      911,
      975,
      9132,
      4219,
      4220,
      1039,
      1970,
      5228,
      9133,
      3163,
      9134,
      1011,
      7409,
      1576,
      2797,
      1203,
      1685
    ],
  ),
  "folder_managed": SymbolsMetadata(
    popularity: 76,
    codepoint: 0xf775,
    categories: [12],
    tags: [
      1756,
      1538,
      501,
      2154,
      482,
      7638,
      4767,
      2397,
      9135,
      1311,
      345,
      81,
      145,
      4769,
      1566,
      1567,
      3762,
      2897,
      1675,
      147,
      1677,
      2161,
      1780,
      293,
      68,
      1323,
      2094,
      70,
      92,
      587,
      1575,
      4771,
      2644,
      1783,
      911,
      453,
      2760,
      1127,
      645,
      71,
      1576,
      2797,
      1685,
      945,
      1068
    ],
  ),
  "folder_match": SymbolsMetadata(
    popularity: 27,
    codepoint: 0xf3d4,
    categories: [12],
    tags: [
      1402,
      1660,
      3671,
      3719,
      621,
      1724,
      81,
      4769,
      1566,
      1567,
      3762,
      1675,
      3626,
      147,
      199,
      317,
      3183,
      2161,
      1678,
      8101,
      1294,
      2345,
      9136,
      2349,
      92,
      1102,
      4256,
      1576,
      2797,
      8649,
      1685,
      945,
      762,
      763,
      4420,
      4799
    ],
  ),
  "folder_off": SymbolsMetadata(
    popularity: 326,
    codepoint: 0xeb83,
    categories: [12],
    tags: [
      1028,
      481,
      3726,
      9137,
      81,
      9138,
      9139,
      5905,
      9140,
      867,
      1566,
      1567,
      9141,
      1675,
      1033,
      147,
      9142,
      2161,
      9143,
      9144,
      9145,
      9146,
      9147,
      9148,
      9149,
      1678,
      2588,
      9150,
      6239,
      1035,
      1037,
      523,
      9151,
      9152,
      1970,
      5228,
      9153,
      1576,
      1041,
      2797,
      1685,
      9154,
      1042
    ],
  ),
  "folder_open": SymbolsMetadata(
    popularity: 9051,
    codepoint: 0xe2c8,
    categories: [12],
    tags: [
      858,
      2154,
      2673,
      519,
      1311,
      9125,
      81,
      44,
      4769,
      1566,
      1567,
      3762,
      1675,
      1303,
      147,
      9155,
      1677,
      317,
      2161,
      8620,
      1678,
      68,
      2345,
      2094,
      1004,
      325,
      2876,
      1063,
      587,
      4771,
      1496,
      2447,
      2843,
      1576,
      2797,
      1685,
      9156,
      396
    ],
  ),
  "folder_shared": SymbolsMetadata(
    popularity: 1634,
    codepoint: 0xe2c9,
    categories: [12],
    tags: [
      858,
      565,
      2154,
      1674,
      3191,
      519,
      2038,
      81,
      9157,
      9104,
      4769,
      1566,
      1567,
      3268,
      3762,
      1675,
      576,
      147,
      3018,
      1677,
      2161,
      9158,
      9159,
      1176,
      583,
      267,
      589,
      590,
      975,
      591,
      2057,
      1508,
      9160,
      9161,
      9162,
      9163,
      9164,
      2044,
      1576,
      2797,
      1685,
      3435,
      1275,
      6650,
      597
    ],
  ),
  "folder_special": SymbolsMetadata(
    popularity: 1005,
    codepoint: 0xe617,
    categories: [12],
    tags: [
      2154,
      1688,
      81,
      4769,
      1566,
      1567,
      3762,
      1675,
      3194,
      9165,
      147,
      1677,
      2161,
      1115,
      1347,
      9166,
      3099,
      9167,
      92,
      1683,
      4421,
      9168,
      392,
      1576,
      2797,
      898,
      9169,
      854,
      9170,
      9171,
      1685
    ],
  ),
  "folder_supervised": SymbolsMetadata(
    popularity: 44,
    codepoint: 0xf774,
    categories: [12],
    tags: [
      858,
      565,
      1756,
      1538,
      2154,
      3151,
      684,
      3154,
      345,
      81,
      4769,
      1566,
      1567,
      1675,
      147,
      9107,
      1677,
      2161,
      990,
      1054,
      583,
      9172,
      1063,
      9173,
      2644,
      1783,
      590,
      975,
      591,
      9174,
      453,
      2760,
      1970,
      1011,
      7409,
      1576,
      2797,
      1685,
      9175,
      1785
    ],
  ),
  "folder_zip": SymbolsMetadata(
    popularity: 994,
    codepoint: 0xeb2c,
    categories: [12],
    tags: [
      2154,
      9176,
      6038,
      9177,
      519,
      81,
      6092,
      44,
      4769,
      1566,
      1567,
      2435,
      3268,
      1675,
      2527,
      147,
      9178,
      2436,
      3018,
      9179,
      2161,
      9180,
      9181,
      9158,
      9182,
      1678,
      2876,
      92,
      1575,
      1576,
      2797,
      1685,
      9183,
      9184,
      9185,
      9186
    ],
  ),
  "follow_the_signs": SymbolsMetadata(
    popularity: 1072,
    codepoint: 0xf222,
    categories: [3],
    tags: [
      77,
      684,
      9187,
      312,
      313,
      2293,
      2932,
      902,
      3144,
      2780,
      1615,
      583,
      7952,
      9188,
      2216,
      87,
      323,
      1618,
      904,
      1619,
      589,
      590,
      328,
      1144,
      907,
      1620,
      4117,
      1621,
      273,
      9189,
      9190,
      705,
      1531,
      3137,
      9191,
      332,
      473,
      9192,
      1696
    ],
    rtlAutoMirrored: true,
  ),
  "font_download": SymbolsMetadata(
    popularity: 696,
    codepoint: 0xe167,
    categories: [12],
    tags: [
      3411,
      7550,
      746,
      4,
      77,
      504,
      5,
      5483,
      1567,
      2830,
      520,
      147,
      12,
      5930,
      138,
      1692,
 