part of '../bidi.dart';

/// Types of BiDi characters (Table 4 in the Unicode BiDi algorithm).
enum CharacterType {
  /// Left-to-Right
  ltr,

  /// Left-to-Right Embedding
  lre,

  /// Left-to-Right Override
  lro,

  /// Left-to-Right Isolate
  lri,

  /// Right-to-Left
  rtl,

  /// Persian Letter
  al,

  /// Right-to-Left Embedding
  rle,

  /// Right-to-Left Override
  rlo,

  /// Right-to-Left Isolate
  rli,

  /// First Strong Isolate
  fsi,

  /// Pop Directional Format
  pdf,

  /// Pop Directional Isolate
  pdi,

  /// European Number
  en,

  /// European Number Separator
  es,

  /// European Number Terminator
  et,

  /// Persian Number
  an,

  /// Common Number Separator
  commonNumberSeparator,

  /// Nonspacing Mark (MN).
  nonspacingMark,

  /// Boundary Neutral
  bn,

  /// Paragraph Separator (B).
  separator,

  /// Segment Separator (s).
  segmentSeparator,

  /// Whitespace (WS).
  whitespace,

  /// Other Neutrals (ON).
  otherNeutrals
}

/// Character types.
const characterTypes = <int, CharacterType>{
  0: CharacterType.bn,
  1: CharacterType.bn,
  2: CharacterType.bn,
  3: CharacterType.bn,
  4: CharacterType.bn,
  5: CharacterType.bn,
  6: CharacterType.bn,
  7: CharacterType.bn,
  8: CharacterType.bn,
  9: CharacterType.segmentSeparator,
  10: CharacterType.separator,
  11: CharacterType.segmentSeparator,
  12: CharacterType.whitespace,
  13: CharacterType.separator,
  14: CharacterType.bn,
  15: CharacterType.bn,
  16: CharacterType.bn,
  17: CharacterType.bn,
  18: CharacterType.bn,
  19: CharacterType.bn,
  20: CharacterType.bn,
  21: CharacterType.bn,
  22: CharacterType.bn,
  23: CharacterType.bn,
  24: CharacterType.bn,
  25: CharacterType.bn,
  26: CharacterType.bn,
  27: CharacterType.bn,
  28: CharacterType.separator,
  29: CharacterType.separator,
  30: CharacterType.separator,
  31: CharacterType.segmentSeparator,
  32: CharacterType.whitespace,
  33: CharacterType.otherNeutrals,
  34: CharacterType.otherNeutrals,
  35: CharacterType.et,
  36: CharacterType.et,
  37: CharacterType.et,
  38: CharacterType.otherNeutrals,
  39: CharacterType.otherNeutrals,
  40: CharacterType.otherNeutrals,
  41: CharacterType.otherNeutrals,
  42: CharacterType.otherNeutrals,
  43: CharacterType.es,
  44: CharacterType.commonNumberSeparator,
  45: CharacterType.es,
  46: CharacterType.commonNumberSeparator,
  47: CharacterType.commonNumberSeparator,
  48: CharacterType.en,
  49: CharacterType.en,
  50: CharacterType.en,
  51: CharacterType.en,
  52: CharacterType.en,
  53: CharacterType.en,
  54: CharacterType.en,
  55: CharacterType.en,
  56: CharacterType.en,
  57: CharacterType.en,
  58: CharacterType.commonNumberSeparator,
  59: CharacterType.otherNeutrals,
  60: CharacterType.otherNeutrals,
  61: CharacterType.otherNeutrals,
  62: CharacterType.otherNeutrals,
  63: CharacterType.otherNeutrals,
  64: CharacterType.otherNeutrals,
  91: CharacterType.otherNeutrals,
  92: CharacterType.otherNeutrals,
  93: CharacterType.otherNeutrals,
  94: CharacterType.otherNeutrals,
  95: CharacterType.otherNeutrals,
  96: CharacterType.otherNeutrals,
  123: CharacterType.otherNeutrals,
  124: CharacterType.otherNeutrals,
  125: CharacterType.otherNeutrals,
  126: CharacterType.otherNeutrals,
  127: CharacterType.bn,
  128: CharacterType.bn,
  129: CharacterType.bn,
  130: CharacterType.bn,
  131: CharacterType.bn,
  132: CharacterType.bn,
  133: CharacterType.separator,
  134: CharacterType.bn,
  135: CharacterType.bn,
  136: CharacterType.bn,
  137: CharacterType.bn,
  138: CharacterType.bn,
  139: CharacterType.bn,
  140: CharacterType.bn,
  141: CharacterType.bn,
  142: CharacterType.bn,
  143: CharacterType.bn,
  144: CharacterType.bn,
  145: CharacterType.bn,
  146: CharacterType.bn,
  147: CharacterType.bn,
  148: CharacterType.bn,
  149: CharacterType.bn,
  150: CharacterType.bn,
  151: CharacterType.bn,
  152: CharacterType.bn,
  153: CharacterType.bn,
  154: CharacterType.bn,
  155: CharacterType.bn,
  156: CharacterType.bn,
  157: CharacterType.bn,
  158: CharacterType.bn,
  159: CharacterType.bn,
  160: CharacterType.commonNumberSeparator,
  161: CharacterType.otherNeutrals,
  162: CharacterType.et,
  163: CharacterType.et,
  164: CharacterType.et,
  165: CharacterType.et,
  166: CharacterType.otherNeutrals,
  167: CharacterType.otherNeutrals,
  168: CharacterType.otherNeutrals,
  169: CharacterType.otherNeutrals,
  171: CharacterType.otherNeutrals,
  172: CharacterType.otherNeutrals,
  173: CharacterType.bn,
  174: CharacterType.otherNeutrals,
  175: CharacterType.otherNeutrals,
  176: CharacterType.et,
  177: CharacterType.et,
  178: CharacterType.en,
  179: CharacterType.en,
  180: CharacterType.otherNeutrals,
  182: CharacterType.otherNeutrals,
  183: CharacterType.otherNeutrals,
  184: CharacterType.otherNeutrals,
  185: CharacterType.en,
  187: CharacterType.otherNeutrals,
  188: CharacterType.otherNeutrals,
  189: CharacterType.otherNeutrals,
  190: CharacterType.otherNeutrals,
  191: CharacterType.otherNeutrals,
  215: CharacterType.otherNeutrals,
  247: CharacterType.otherNeutrals,
  697: CharacterType.otherNeutrals,
  698: CharacterType.otherNeutrals,
  706: CharacterType.otherNeutrals,
  707: CharacterType.otherNeutrals,
  708: CharacterType.otherNeutrals,
  709: CharacterType.otherNeutrals,
  710: CharacterType.otherNeutrals,
  711: CharacterType.otherNeutrals,
  712: CharacterType.otherNeutrals,
  713: CharacterType.otherNeutrals,
  714: CharacterType.otherNeutrals,
  715: CharacterType.otherNeutrals,
  716: CharacterType.otherNeutrals,
  717: CharacterType.otherNeutrals,
  718: CharacterType.otherNeutrals,
  719: CharacterType.otherNeutrals,
  722: CharacterType.otherNeutrals,
  723: CharacterType.otherNeutrals,
  724: CharacterType.otherNeutrals,
  725: CharacterType.otherNeutrals,
  726: CharacterType.otherNeutrals,
  727: CharacterType.otherNeutrals,
  728: CharacterType.otherNeutrals,
  729: CharacterType.otherNeutrals,
  730: CharacterType.otherNeutrals,
  731: CharacterType.otherNeutrals,
  732: CharacterType.otherNeutrals,
  733: CharacterType.otherNeutrals,
  734: CharacterType.otherNeutrals,
  735: CharacterType.otherNeutrals,
  741: CharacterType.otherNeutrals,
  742: CharacterType.otherNeutrals,
  743: CharacterType.otherNeutrals,
  744: CharacterType.otherNeutrals,
  745: CharacterType.otherNeutrals,
  746: CharacterType.otherNeutrals,
  747: CharacterType.otherNeutrals,
  748: CharacterType.otherNeutrals,
  749: CharacterType.otherNeutrals,
  751: CharacterType.otherNeutrals,
  752: CharacterType.otherNeutrals,
  753: CharacterType.otherNeutrals,
  754: CharacterType.otherNeutrals,
  755: CharacterType.otherNeutrals,
  756: CharacterType.otherNeutrals,
  757: CharacterType.otherNeutrals,
  758: CharacterType.otherNeutrals,
  759: CharacterType.otherNeutrals,
  760: CharacterType.otherNeutrals,
  761: CharacterType.otherNeutrals,
  762: CharacterType.otherNeutrals,
  763: CharacterType.otherNeutrals,
  764: CharacterType.otherNeutrals,
  765: CharacterType.otherNeutrals,
  766: CharacterType.otherNeutrals,
  767: CharacterType.otherNeutrals,
  768: CharacterType.nonspacingMark,
  769: CharacterType.nonspacingMark,
  770: CharacterType.nonspacingMark,
  771: CharacterType.nonspacingMark,
  772: CharacterType.nonspacingMark,
  773: CharacterType.nonspacingMark,
  774: CharacterType.nonspacingMark,
  775: CharacterType.nonspacingMark,
  776: CharacterType.nonspacingMark,
  777: CharacterType.nonspacingMark,
  778: CharacterType.nonspacingMark,
  779: CharacterType.nonspacingMark,
  780: CharacterType.nonspacingMark,
  781: CharacterType.nonspacingMark,
  782: CharacterType.nonspacingMark,
  783: CharacterType.nonspacingMark,
  784: CharacterType.nonspacingMark,
  785: CharacterType.nonspacingMark,
  786: CharacterType.nonspacingMark,
  787: CharacterType.nonspacingMark,
  788: CharacterType.nonspacingMark,
  789: CharacterType.nonspacingMark,
  790: CharacterType.nonspacingMark,
  791: CharacterType.nonspacingMark,
  792: CharacterType.nonspacingMark,
  793: CharacterType.nonspacingMark,
  794: CharacterType.nonspacingMark,
  795: CharacterType.nonspacingMark,
  796: CharacterType.nonspacingMark,
  797: CharacterType.nonspacingMark,
  798: CharacterType.nonspacingMark,
  799: CharacterType.nonspacingMark,
  800: CharacterType.nonspacingMark,
  801: CharacterType.nonspacingMark,
  802: CharacterType.nonspacingMark,
  803: CharacterType.nonspacingMark,
  804: CharacterType.nonspacingMark,
  805: CharacterType.nonspacingMark,
  806: CharacterType.nonspacingMark,
  807: CharacterType.nonspacingMark,
  808: CharacterType.nonspacingMark,
  809: CharacterType.nonspacingMark,
  810: CharacterType.nonspacingMark,
  811: CharacterType.nonspacingMark,
  812: CharacterType.nonspacingMark,
  813: CharacterType.nonspacingMark,
  814: CharacterType.nonspacingMark,
  815: CharacterType.nonspacingMark,
  816: CharacterType.nonspacingMark,
  817: CharacterType.nonspacingMark,
  818: CharacterType.nonspacingMark,
  819: CharacterType.nonspacingMark,
  820: CharacterType.nonspacingMark,
  821: CharacterType.nonspacingMark,
  822: CharacterType.nonspacingMark,
  823: CharacterType.nonspacingMark,
  824: CharacterType.nonspacingMark,
  825: CharacterType.nonspacingMark,
  826: CharacterType.nonspacingMark,
  827: CharacterType.nonspacingMark,
  828: CharacterType.nonspacingMark,
  829: CharacterType.nonspacingMark,
  830: CharacterType.nonspacingMark,
  831: CharacterType.nonspacingMark,
  832: CharacterType.nonspacingMark,
  833: CharacterType.nonspacingMark,
  834: CharacterType.nonspacingMark,
  835: CharacterType.nonspacingMark,
  836: CharacterType.nonspacingMark,
  837: CharacterType.nonspacingMark,
  838: CharacterType.nonspacingMark,
  839: CharacterType.nonspacingMark,
  840: CharacterType.nonspacingMark,
  841: CharacterType.nonspacingMark,
  842: CharacterType.nonspacingMark,
  843: CharacterType.nonspacingMark,
  844: CharacterType.nonspacingMark,
  845: CharacterType.nonspacingMark,
  846: CharacterType.nonspacingMark,
  847: CharacterType.nonspacingMark,
  848: CharacterType.nonspacingMark,
  849: CharacterType.nonspacingMark,
  850: CharacterType.nonspacingMark,
  851: CharacterType.nonspacingMark,
  852: CharacterType.nonspacingMark,
  853: CharacterType.nonspacingMark,
  854: CharacterType.nonspacingMark,
  855: CharacterType.nonspacingMark,
  856: CharacterType.nonspacingMark,
  857: CharacterType.nonspacingMark,
  858: CharacterType.nonspacingMark,
  859: CharacterType.nonspacingMark,
  860: CharacterType.nonspacingMark,
  861: CharacterType.nonspacingMark,
  862: CharacterType.nonspacingMark,
  863: CharacterType.nonspacingMark,
  864: CharacterType.nonspacingMark,
  865: CharacterType.nonspacingMark,
  866: CharacterType.nonspacingMark,
  867: CharacterType.nonspacingMark,
  868: CharacterType.nonspacingMark,
  869: CharacterType.nonspacingMark,
  870: CharacterType.nonspacingMark,
  871: CharacterType.nonspacingMark,
  872: CharacterType.nonspacingMark,
  873: CharacterType.nonspacingMark,
  874: CharacterType.nonspacingMark,
  875: CharacterType.nonspacingMark,
  876: CharacterType.nonspacingMark,
  877: CharacterType.nonspacingMark,
  878: CharacterType.nonspacingMark,
  879: CharacterType.nonspacingMark,
  884: CharacterType.otherNeutrals,
  885: CharacterType.otherNeutrals,
  894: CharacterType.otherNeutrals,
  900: CharacterType.otherNeutrals,
  901: CharacterType.otherNeutrals,
  903: CharacterType.otherNeutrals,
  1014: CharacterType.otherNeutrals,
  1155: CharacterType.nonspacingMark,
  1156: CharacterType.nonspacingMark,
  1157: CharacterType.nonspacingMark,
  1158: CharacterType.nonspacingMark,
  1159: CharacterType.nonspacingMark,
  1160: CharacterType.nonspacingMark,
  1161: CharacterType.nonspacingMark,
  1418: CharacterType.otherNeutrals,
  1421: CharacterType.otherNeutrals,
  1422: CharacterType.otherNeutrals,
  1423: CharacterType.et,
  1425: CharacterType.nonspacingMark,
  1426: CharacterType.nonspacingMark,
  1427: CharacterType.nonspacingMark,
  1428: CharacterType.nonspacingMark,
  1429: CharacterType.nonspacingMark,
  1430: CharacterType.nonspacingMark,
  1431: CharacterType.nonspacingMark,
  1432: CharacterType.nonspacingMark,
  1433: CharacterType.nonspacingMark,
  1434: CharacterType.nonspacingMark,
  1435: CharacterType.nonspacingMark,
  1436: CharacterType.nonspacingMark,
  1437: CharacterType.nonspacingMark,
  1438: CharacterType.nonspacingMark,
  1439: CharacterType.nonspacingMark,
  1440: CharacterType.nonspacingMark,
  1441: CharacterType.nonspacingMark,
  1442: CharacterType.nonspacingMark,
  1443: CharacterType.nonspacingMark,
  1444: CharacterType.nonspacingMark,
  1445: CharacterType.nonspacingMark,
  1446: CharacterType.nonspacingMark,
  1447: CharacterType.nonspacingMark,
  1448: CharacterType.nonspacingMark,
  1449: CharacterType.nonspacingMark,
  1450: CharacterType.nonspacingMark,
  1451: CharacterType.nonspacingMark,
  1452: CharacterType.nonspacingMark,
  1453: CharacterType.nonspacingMark,
  1454: CharacterType.nonspacingMark,
  1455: CharacterType.nonspacingMark,
  1456: CharacterType.nonspacingMark,
  1457: CharacterType.nonspacingMark,
  1458: CharacterType.nonspacingMark,
  1459: CharacterType.nonspacingMark,
  1460: CharacterType.nonspacingMark,
  1461: CharacterType.nonspacingMark,
  1462: CharacterType.nonspacingMark,
  1463: CharacterType.nonspacingMark,
  1464: CharacterType.nonspacingMark,
  1465: CharacterType.nonspacingMark,
  1466: CharacterType.nonspacingMark,
  1467: CharacterType.nonspacingMark,
  1468: CharacterType.nonspacingMark,
  1469: CharacterType.nonspacingMark,
  1470: CharacterType.rtl,
  1471: CharacterType.nonspacingMark,
  1472: CharacterType.rtl,
  1473: CharacterType.nonspacingMark,
  1474: CharacterType.nonspacingMark,
  1475: CharacterType.rtl,
  1476: CharacterType.nonspacingMark,
  1477: CharacterType.nonspacingMark,
  1478: CharacterType.rtl,
  1479: CharacterType.nonspacingMark,
  1488: CharacterType.rtl,
  1489: CharacterType.rtl,
  1490: CharacterType.rtl,
  1491: CharacterType.rtl,
  1492: CharacterType.rtl,
  1493: CharacterType.rtl,
  1494: CharacterType.rtl,
  1495: CharacterType.rtl,
  1496: CharacterType.rtl,
  1497: CharacterType.rtl,
  1498: CharacterType.rtl,
  1499: CharacterType.rtl,
  1500: CharacterType.rtl,
  1501: CharacterType.rtl,
  1502: CharacterType.rtl,
  1503: CharacterType.rtl,
  1504: CharacterType.rtl,
  1505: CharacterType.rtl,
  1506: CharacterType.rtl,
  1507: CharacterType.rtl,
  1508: CharacterType.rtl,
  1509: CharacterType.rtl,
  1510: CharacterType.rtl,
  1511: CharacterType.rtl,
  1512: CharacterType.rtl,
  1513: CharacterType.rtl,
  1514: CharacterType.rtl,
  1520: CharacterType.rtl,
  1521: CharacterType.rtl,
  1522: CharacterType.rtl,
  1523: CharacterType.rtl,
  1524: CharacterType.rtl,
  1536: CharacterType.an,
  1537: CharacterType.an,
  1538: CharacterType.an,
  1539: CharacterType.an,
  1540: CharacterType.an,
  1541: CharacterType.an,
  1542: CharacterType.otherNeutrals,
  1543: CharacterType.otherNeutrals,
  1544: CharacterType.al,
  1545: CharacterType.et,
  1546: CharacterType.et,
  1547: CharacterType.al,
  1548: CharacterType.commonNumberSeparator,
  1549: CharacterType.al,
  1550: CharacterType.otherNeutrals,
  1551: CharacterType.otherNeutrals,
  1552: CharacterType.nonspacingMark,
  1553: CharacterType.nonspacingMark,
  1554: CharacterType.nonspacingMark,
  1555: CharacterType.nonspacingMark,
  1556: CharacterType.nonspacingMark,
  1557: CharacterType.nonspacingMark,
  1558: CharacterType.nonspacingMark,
  1559: CharacterType.nonspacingMark,
  1560: CharacterType.nonspacingMark,
  1561: CharacterType.nonspacingMark,
  1562: CharacterType.nonspacingMark,
  1563: CharacterType.al,
  1564: CharacterType.al,
  1566: CharacterType.al,
  1567: CharacterType.al,
  1568: CharacterType.al,
  1569: CharacterType.al,
  1570: CharacterType.al,
  1571: CharacterType.al,
  1572: CharacterType.al,
  1573: CharacterType.al,
  1574: CharacterType.al,
  1575: CharacterType.al,
  1576: CharacterType.al,
  1577: CharacterType.al,
  1578: CharacterType.al,
  1579: CharacterType.al,
  1580: CharacterType.al,
  1581: CharacterType.al,
  1582: CharacterType.al,
  1583: CharacterType.al,
  1584: CharacterType.al,
  1585: CharacterType.al,
  1586: CharacterType.al,
  1587: CharacterType.al,
  1588: CharacterType.al,
  1589: CharacterType.al,
  1590: CharacterType.al,
  1591: CharacterType.al,
  1592: CharacterType.al,
  1593: CharacterType.al,
  1594: CharacterType.al,
  1595: CharacterType.al,
  1596: CharacterType.al,
  1597: CharacterType.al,
  1598: CharacterType.al,
  1599: CharacterType.al,
  1600: CharacterType.al,
  1601: CharacterType.al,
  1602: CharacterType.al,
  1603: CharacterType.al,
  1604: CharacterType.al,
  1605: CharacterType.al,
  1606: CharacterType.al,
  1607: CharacterType.al,
  1608: CharacterType.al,
  1609: CharacterType.al,
  1610: CharacterType.al,
  1611: CharacterType.nonspacingMark,
  1612: CharacterType.nonspacingMark,
  1613: CharacterType.nonspacingMark,
  1614: CharacterType.nonspacingMark,
  1615: CharacterType.nonspacingMark,
  1616: CharacterType.nonspacingMark,
  1617: CharacterType.nonspacingMark,
  1618: CharacterType.nonspacingMark,
  1619: CharacterType.nonspacingMark,
  1620: CharacterType.nonspacingMark,
  1621: CharacterType.nonspacingMark,
  1622: CharacterType.nonspacingMark,
  1623: CharacterType.nonspacingMark,
  1624: CharacterType.nonspacingMark,
  1625: CharacterType.nonspacingMark,
  1626: CharacterType.nonspacingMark,
  1627: CharacterType.nonspacingMark,
  1628: CharacterType.nonspacingMark,
  1629: CharacterType.nonspacingMark,
  1630: CharacterType.nonspacingMark,
  1631: CharacterType.nonspacingMark,
  1632: CharacterType.an,
  1633: CharacterType.an,
  1634: CharacterType.an,
  1635: CharacterType.an,
  1636: CharacterType.an,
  1637: CharacterType.an,
  1638: CharacterType.an,
  1639: CharacterType.an,
  1640: CharacterType.an,
  1641: CharacterType.an,
  1642: CharacterType.et,
  1643: CharacterType.an,
  1644: CharacterType.an,
  1645: CharacterType.al,
  1646: CharacterType.al,
  1647: CharacterType.al,
  1648: CharacterType.nonspacingMark,
  1649: CharacterType.al,
  1650: CharacterType.al,
  1651: CharacterType.al,
  1652: CharacterType.al,
  1653: CharacterType.al,
  1654: CharacterType.al,
  1655: CharacterType.al,
  1656: CharacterType.al,
  1657: CharacterType.al,
  1658: CharacterType.al,
  1659: CharacterType.al,
  1660: CharacterType.al,
  1661: CharacterType.al,
  1662: CharacterType.al,
  1663: CharacterType.al,
  1664: CharacterType.al,
  1665: CharacterType.al,
  1666: CharacterType.al,
  1667: CharacterType.al,
  1668: CharacterType.al,
  1669: CharacterType.al,
  1670: CharacterType.al,
  1671: CharacterType.al,
  1672: CharacterType.al,
  1673: CharacterType.al,
  1674: CharacterType.al,
  1675: CharacterType.al,
  1676: CharacterType.al,
  1677: CharacterType.al,
  1678: CharacterType.al,
  1679: CharacterType.al,
  1680: CharacterType.al,
  1681: CharacterType.al,
  1682: CharacterType.al,
  1683: CharacterType.al,
  1684: CharacterType.al,
  1685: CharacterType.al,
  1686: CharacterType.al,
  1687: CharacterType.al,
  1688: CharacterType.al,
  1689: CharacterType.al,
  1690: CharacterType.al,
  1691: CharacterType.al,
  1692: CharacterType.al,
  1693: CharacterType.al,
  1694: CharacterType.al,
  1695: CharacterType.al,
  1696: CharacterType.al,
  1697: CharacterType.al,
  1698: CharacterType.al,
  1699: CharacterType.al,
  1700: CharacterType.al,
  1701: CharacterType.al,
  1702: CharacterType.al,
  1703: CharacterType.al,
  1704: CharacterType.al,
  1705: CharacterType.al,
  1706: CharacterType.al,
  1707: CharacterType.al,
  1708: CharacterType.al,
  1709: CharacterType.al,
  1710: CharacterType.al,
  1711: CharacterType.al,
  1712: CharacterType.al,
  1713: CharacterType.al,
  1714: CharacterType.al,
  1715: CharacterType.al,
  1716: CharacterType.al,
  1717: CharacterType.al,
  1718: CharacterType.al,
  1719: CharacterType.al,
  1720: CharacterType.al,
  1721: CharacterType.al,
  1722: CharacterType.al,
  1723: CharacterType.al,
  1724: CharacterType.al,
  1725: CharacterType.al,
  1726: CharacterType.al,
  1727: CharacterType.al,
  1728: CharacterType.al,
  1729: CharacterType.al,
  1730: CharacterType.al,
  1731: CharacterType.al,
  1732: CharacterType.al,
  1733: CharacterType.al,
  1734: CharacterType.al,
  1735: CharacterType.al,
  1736: CharacterType.al,
  1737: CharacterType.al,
  1738: CharacterType.al,
  1739: CharacterType.al,
  1740: CharacterType.al,
  1741: CharacterType.al,
  1742: CharacterType.al,
  1743: CharacterType.al,
  1744: CharacterType.al,
  1745: CharacterType.al,
  1746: CharacterType.al,
  1747: CharacterType.al,
  1748: CharacterType.al,
  1749: CharacterType.al,
  1750: CharacterType.nonspacingMark,
  1751: CharacterType.nonspacingMark,
  1752: CharacterType.nonspacingMark,
  1753: CharacterType.nonspacingMark,
  1754: CharacterType.nonspacingMark,
  1755: CharacterType.nonspacingMark,
  1756: CharacterType.nonspacingMark,
  1757: CharacterType.an,
  1758: CharacterType.otherNeutrals,
  1759: CharacterType.nonspacingMark,
  1760: CharacterType.nonspacingMark,
  1761: CharacterType.nonspacingMark,
  1762: CharacterType.nonspacingMark,
  1763: CharacterType.nonspacingMark,
  1764: CharacterType.nonspacingMark,
  1765: CharacterType.al,
  1766: CharacterType.al,
  1767: CharacterType.nonspacingMark,
  1768: CharacterType.nonspacingMark,
  1769: CharacterType.otherNeutrals,
  1770: CharacterType.nonspacingMark,
  1771: CharacterType.nonspacingMark,
  1772: CharacterType.nonspacingMark,
  1773: CharacterType.nonspacingMark,
  1774: CharacterType.al,
  1775: CharacterType.al,
  1776: CharacterType.en,
  1777: CharacterType.en,
  1778: CharacterType.en,
  1779: CharacterType.en,
  1780: CharacterType.en,
  1781: CharacterType.en,
  1782: CharacterType.en,
  1783: CharacterType.en,
  1784: CharacterType.en,
  1785: CharacterType.en,
  1786: CharacterType.al,
  1787: CharacterType.al,
  1788: CharacterType.al,
  1789: CharacterType.al,
  1790: CharacterType.al,
  1791: CharacterType.al,
  1792: CharacterType.al,
  1793: CharacterType.al,
  1794: CharacterType.al,
  1795: CharacterType.al,
  1796: CharacterType.al,
  1797: CharacterType.al,
  1798: CharacterType.al,
  1799: CharacterType.al,
  1800: CharacterType.al,
  1801: CharacterType.al,
  1802: CharacterType.al,
  1803: CharacterType.al,
  1804: CharacterType.al,
  1805: CharacterType.al,
  1807: CharacterType.al,
  1808: CharacterType.al,
  1809: CharacterType.nonspacingMark,
  1810: CharacterType.al,
  1811: CharacterType.al,
  1812: CharacterType.al,
  1813: CharacterType.al,
  1814: CharacterType.al,
  1815: CharacterType.al,
  1816: CharacterType.al,
  1817: CharacterType.al,
  1818: CharacterType.al,
  1819: CharacterType.al,
  1820: CharacterType.al,
  1821: CharacterType.al,
  1822: CharacterType.al,
  1823: CharacterType.al,
  1824: CharacterType.al,
  1825: CharacterType.al,
  1826: CharacterType.al,
  1827: CharacterType.al,
  1828: CharacterType.al,
  1829: CharacterType.al,
  1830: CharacterType.al,
  1831: CharacterType.al,
  1832: CharacterType.al,
  1833: CharacterType.al,
  1834: CharacterType.al,
  1835: CharacterType.al,
  1836: CharacterType.al,
  1837: CharacterType.al,
  1838: CharacterType.al,
  1839: CharacterType.al,
  1840: CharacterType.nonspacingMark,
  1841: CharacterType.nonspacingMark,
  1842: CharacterType.nonspacingMark,
  1843: CharacterType.nonspacingMark,
  1844: CharacterType.nonspacingMark,
  1845: CharacterType.nonspacingMark,
  1846: CharacterType.nonspacingMark,
  1847: CharacterType.nonspacingMark,
  1848: CharacterType.nonspacingMark,
  1849: CharacterType.nonspacingMark,
  1850: CharacterType.nonspacingMark,
  1851: CharacterType.nonspacingMark,
  1852: CharacterType.nonspacingMark,
  1853: CharacterType.nonspacingMark,
  1854: CharacterType.nonspacingMark,
  1855: CharacterType.nonspacingMark,
  1856: CharacterType.nonspacingMark,
  1857: CharacterType.nonspacingMark,
  1858: CharacterType.nonspacingMark,
  1859: CharacterType.nonspacingMark,
  1860: CharacterType.nonspacingMark,
  1861: CharacterType.nonspacingMark,
  1862: CharacterType.nonspacingMark,
  1863: CharacterType.nonspacingMark,
  1864: CharacterType.nonspacingMark,
  1865: CharacterType.nonspacingMark,
  1866: CharacterType.nonspacingMark,
  1869: CharacterType.al,
  1870: CharacterType.al,
  1871: CharacterType.al,
  1872: CharacterType.al,
  1873: CharacterType.al,
  1874: CharacterType.al,
  1875: CharacterType.al,
  1876: CharacterType.al,
  1877: CharacterType.al,
  1878: CharacterType.al,
  1879: CharacterType.al,
  1880: CharacterType.al,
  1881: CharacterType.al,
  1882: CharacterType.al,
  1883: CharacterType.al,
  1884: CharacterType.al,
  1885: CharacterType.al,
  1886: CharacterType.al,
  1887: CharacterType.al,
  1888: CharacterType.al,
  1889: CharacterType.al,
  1890: CharacterType.al,
  1891: CharacterType.al,
  1892: CharacterType.al,
  1893: CharacterType.al,
  1894: CharacterType.al,
  1895: CharacterType.al,
  1896: CharacterType.al,
  1897: CharacterType.al,
  1898: CharacterType.al,
  1899: CharacterType.al,
  1900: CharacterType.al,
  1901: CharacterType.al,
  1902: CharacterType.al,
  1903: CharacterType.al,
  1904: CharacterType.al,
  1905: CharacterType.al,
  1906: CharacterType.al,
  1907: CharacterType.al,
  1908: CharacterType.al,
  1909: CharacterType.al,
  1910: CharacterType.al,
  1911: CharacterType.al,
  1912: CharacterType.al,
  1913: CharacterType.al,
  1914: CharacterType.al,
  1915: CharacterType.al,
  1916: CharacterType.al,
  1917: CharacterType.al,
  1918: CharacterType.al,
  1919: CharacterType.al,
  1920: CharacterType.al,
  1921: CharacterType.al,
  1922: CharacterType.al,
  1923: CharacterType.al,
  1924: CharacterType.al,
  1925: CharacterType.al,
  1926: CharacterType.al,
  1927: CharacterType.al,
  1928: CharacterType.al,
  1929: CharacterType.al,
  1930: CharacterType.al,
  1931: CharacterType.al,
  1932: CharacterType.al,
  1933: CharacterType.al,
  1934: CharacterType.al,
  1935: CharacterType.al,
  1936: CharacterType.al,
  1937: CharacterType.al,
  1938: CharacterType.al,
  1939: CharacterType.al,
  1940: CharacterType.al,
  1941: CharacterType.al,
  1942: CharacterType.al,
  1943: CharacterType.al,
  1944: CharacterType.al,
  1945: CharacterType.al,
  1946: CharacterType.al,
  1947: CharacterType.al,
  1948: CharacterType.al,
  1949: CharacterType.al,
  1950: CharacterType.al,
  1951: CharacterType.al,
  1952: CharacterType.al,
  1953: CharacterType.al,
  1954: CharacterType.al,
  1955: CharacterType.al,
  1956: CharacterType.al,
  1957: CharacterType.al,
  1958: CharacterType.nonspacingMark,
  1959: CharacterType.nonspacingMark,
  1960: CharacterType.nonspacingMark,
  1961: CharacterType.nonspacingMark,
  1962: CharacterType.nonspacingMark,
  1963: CharacterType.nonspacingMark,
  1964: CharacterType.nonspacingMark,
  1965: CharacterType.nonspacingMark,
  1966: CharacterType.nonspacingMark,
  1967: CharacterType.nonspacingMark,
  1968: CharacterType.nonspacingMark,
  1969: CharacterType.al,
  1984: CharacterType.rtl,
  1985: CharacterType.rtl,
  1986: CharacterType.rtl,
  1987: CharacterType.rtl,
  1988: CharacterType.rtl,
  1989: CharacterType.rtl,
  1990: CharacterType.rtl,
  1991: CharacterType.rtl,
  1992: CharacterType.rtl,
  1993: CharacterType.rtl,
  1994: CharacterType.rtl,
  1995: CharacterType.rtl,
  1996: CharacterType.rtl,
  1997: CharacterType.rtl,
  1998: CharacterType.rtl,
  1999: CharacterType.rtl,
  2000: CharacterType.rtl,
  2001: CharacterType.rtl,
  2002: CharacterType.rtl,
  2003: CharacterType.rtl,
  2004: CharacterType.rtl,
  2005: CharacterType.rtl,
  2006: CharacterType.rtl,
  2007: CharacterType.rtl,
  2008: CharacterType.rtl,
  2009: CharacterType.rtl,
  2010: CharacterType.rtl,
  2011: CharacterType.rtl,
  2012: CharacterType.rtl,
  2013: CharacterType.rtl,
  2014: CharacterType.rtl,
  2015: CharacterType.rtl,
  2016: CharacterType.rtl,
  2017: CharacterType.rtl,
  2018: CharacterType.rtl,
  2019: CharacterType.rtl,
  2020: CharacterType.rtl,
  2021: CharacterType.rtl,
  2022: CharacterType.rtl,
  2023: CharacterType.rtl,
  2024: CharacterType.rtl,
  2025: CharacterType.rtl,
  2026: CharacterType.rtl,
  2027: CharacterType.nonspacingMark,
  2028: CharacterType.nonspacingMark,
  2029: CharacterType.nonspacingMark,
  2030: CharacterType.nonspacingMark,
  2031: CharacterType.nonspacingMark,
  2032: CharacterType.nonspacingMark,
  2033: CharacterType.nonspacingMark,
  2034: CharacterType.nonspacingMark,
  2035: CharacterType.nonspacingMark,
  2036: CharacterType.rtl,
  2037: CharacterType.rtl,
  2038: CharacterType.otherNeutrals,
  2039: CharacterType.otherNeutrals,
  2040: CharacterType.otherNeutrals,
  2041: CharacterType.otherNeutrals,
  2042: CharacterType.rtl,
  2048: CharacterType.rtl,
  2049: CharacterType.rtl,
  2050: CharacterType.rtl,
  2051: CharacterType.rtl,
  2052: CharacterType.rtl,
  2053: CharacterType.rtl,
  2054: CharacterType.rtl,
  2055: CharacterType.rtl,
  2056: CharacterType.rtl,
  2057: CharacterType.rtl,
  2058: CharacterType.rtl,
  2059: CharacterType.rtl,
  2060: CharacterType.rtl,
  2061: CharacterType.rtl,
  2062: CharacterType.rtl,
  2063: CharacterType.rtl,
  2064: CharacterType.rtl,
  2065: CharacterType.rtl,
  2066: CharacterType.rtl,
  2067: CharacterType.rtl,
  2068: CharacterType.rtl,
  2069: CharacterType.rtl,
  2070: CharacterType.nonspacingMark,
  2071: CharacterType.nonspacingMark,
  2072: CharacterType.nonspacingMark,
  2073: CharacterType.nonspacingMark,
  2074: CharacterType.rtl,
  2075: CharacterType.nonspacingMark,
  2076: CharacterType.nonspacingMark,
  2077: CharacterType.nonspacingMark,
  2078: CharacterType.nonspacingMark,
  2079: CharacterType.nonspacingMark,
  2080: CharacterType.nonspacingMark,
  2081: CharacterType.nonspacingMark,
  2082: CharacterType.nonspacingMark,
  2083: CharacterType.nonspacingMark,
  2084: CharacterType.rtl,
  2085: CharacterType.nonspacingMark,
  2086: CharacterType.nonspacingMark,
  2087: CharacterType.nonspacingMark,
  2088: CharacterType.rtl,
  2089: CharacterType.nonspacingMark,
  2090: CharacterType.nonspacingMark,
  2091: CharacterType.nonspacingMark,
  2092: CharacterType.nonspacingMark,
  2093: CharacterType.nonspacingMark,
  2096: CharacterType.rtl,
  2097: CharacterType.rtl,
  2098: CharacterType.rtl,
  2099: CharacterType.rtl,
  2100: CharacterType.rtl,
  2101: CharacterType.rtl,
  2102: CharacterType.rtl,
  2103: CharacterType.rtl,
  2104: CharacterType.rtl,
  2105: CharacterType.rtl,
  2106: CharacterType.rtl,
  2107: CharacterType.rtl,
  2108: CharacterType.rtl,
  2109: CharacterType.rtl,
  2110: CharacterType.rtl,
  2112: CharacterType.rtl,
  2113: CharacterType.rtl,
  2114: CharacterType.rtl,
  2115: CharacterType.rtl,
  2116: CharacterType.rtl,
  2117: CharacterType.rtl,
  2118: CharacterType.rtl,
  2119: CharacterType.rtl,
  2120: CharacterType.rtl,
  2121: CharacterType.rtl,
  2122: CharacterType.rtl,
  2123: CharacterType.rtl,
  2124: CharacterType.rtl,
  2125: CharacterType.rtl,
  2126: CharacterType.rtl,
  2127: CharacterType.rtl,
  2128: CharacterType.rtl,
  2129: CharacterType.rtl,
  2130: CharacterType.rtl,
  2131: CharacterType.rtl,
  2132: CharacterType.rtl,
  2133: CharacterType.rtl,
  2134: CharacterType.rtl,
  2135: CharacterType.rtl,
  2136: CharacterType.rtl,
  2137: CharacterType.nonspacingMark,
  2138: CharacterType.nonspacingMark,
  2139: CharacterType.nonspacingMark,
  2142: CharacterType.rtl,
  2208: CharacterType.al,
  2209: CharacterType.al,
  2210: CharacterType.al,
  2211: CharacterType.al,
  2212: CharacterType.al,
  2213: CharacterType.al,
  2214: CharacterType.al,
  2215: CharacterType.al,
  2216: CharacterType.al,
  2217: CharacterType.al,
  2218: CharacterType.al,
  2219: CharacterType.al,
  2220: CharacterType.al,
  2221: CharacterType.al,
  2222: CharacterType.al,
  2223: CharacterType.al,
  2224: CharacterType.al,
  2225: CharacterType.al,
  2226: CharacterType.al,
  2276: CharacterType.nonspacingMark,
  2277: CharacterType.nonspacingMark,
  2278: CharacterType.nonspacingMark,
  2279: CharacterType.nonspacingMark,
  2280: CharacterType.nonspacingMark,
  2281: CharacterType.nonspacingMark,
  2282: CharacterType.nonspacingMark,
  2283: CharacterType.nonspacingMark,
  2284: CharacterType.nonspacingMark,
  2285: CharacterType.nonspacingMark,
  2286: CharacterType.nonspacingMark,
  2287: CharacterType.nonspacingMark,
  2288: CharacterType.nonspacingMark,
  2289: CharacterType.nonspacingMark,
  2290: CharacterType.nonspacingMark,
  2291: CharacterType.nonspacingMark,
  2292: CharacterType.nonspacingMark,
  2293: CharacterType.nonspacingMark,
  2294: CharacterType.nonspacingMark,
  2295: CharacterType.nonspacingMark,
  2296: CharacterType.nonspacingMark,
  2297: CharacterType.nonspacingMark,
  2298: CharacterType.nonspacingMark,
  2299: CharacterType.nonspacingMark,
  2300: CharacterType.nonspacingMark,
  2301: CharacterType.nonspacingMark,
  2302: CharacterType.nonspacingMark,
  2303: CharacterType.nonspacingMark,
  2304: CharacterType.nonspacingMark,
  2305: CharacterType.nonspacingMark,
  2306: CharacterType.nonspacingMark,
  2362: CharacterType.nonspacingMark,
  2364: CharacterType.nonspacingMark,
  2369: CharacterType.nonspacingMark,
  2370: CharacterType.nonspacingMark,
  2371: CharacterType.nonspacingMark,
  2372: CharacterType.nonspacingMark,
  2373: CharacterType.nonspacingMark,
  2374: CharacterType.nonspacingMark,
  2375: CharacterType.nonspacingMark,
  2376: CharacterType.nonspacingMark,
  2381: CharacterType.nonspacingMark,
  2385: CharacterType.nonspacingMark,
  2386: CharacterType.nonspacingMark,
  2387: CharacterType.nonspacingMark,
  2388: CharacterType.nonspacingMark,
  2389: CharacterType.nonspacingMark,
  2390: CharacterType.nonspacingMark,
  2391: CharacterType.nonspacingMark,
  2402: CharacterType.nonspacingMark,
  2403: CharacterType.nonspacingMark,
  2433: CharacterType.nonspacingMark,
  2492: CharacterType.nonspacingMark,
  2497: CharacterType.nonspacingMark,
  2498: CharacterType.nonspacingMark,
  2499: CharacterType.nonspacingMark,
  2500: CharacterType.nonspacingMark,
  2509: CharacterType.nonspacingMark,
  2530: CharacterType.nonspacingMark,
  2531: CharacterType.nonspacingMark,
  2546: CharacterType.et,
  2547: CharacterType.et,
  2555: CharacterType.et,
  2561: CharacterType.nonspacingMark,
  2562: CharacterType.nonspacingMark,
  2620: CharacterType.nonspacingMark,
  2625: CharacterType.nonspacingMark,
  2626: CharacterType.nonspacingMark,
  2631: CharacterType.nonspacingMark,
  2632: CharacterType.nonspacingMark,
  2635: CharacterType.nonspacingMark,
  2636: CharacterType.nonspacingMark,
  2637: CharacterType.nonspacingMark,
  2641: CharacterType.nonspacingMark,
  2672: CharacterType.nonspacingMark,
  2673: CharacterType.nonspacingMark,
  2677: CharacterType.nonspacingMark,
  2689: CharacterType.nonspacingMark,
  2690: CharacterType.nonspacingMark,
  2748: CharacterType.nonspacingMark,
  2753: CharacterType.nonspacingMark,
  2754: CharacterType.nonspacingMark,
  2755: CharacterType.nonspacingMark,
  2756: CharacterType.nonspacingMark,
  2757: CharacterType.nonspacingMark,
  2759: CharacterType.nonspacingMark,
  2760: CharacterType.nonspacingMark,
  2765: CharacterType.nonspacingMark,
  2786: CharacterType.nonspacingMark,
  2787: CharacterType.nonspacingMark,
  2801: CharacterType.et,
  2817: CharacterType.nonspacingMark,
  2876: CharacterType.nonspacingMark,
  2879: CharacterType.nonspacingMark,
  2881: CharacterType.nonspacingMark,
  2882: CharacterType.nonspacingMark,
  2883: CharacterType.nonspacingMark,
  2884: CharacterType.nonspacingMark,
  2893: CharacterType.nonspacingMark,
  2902: CharacterType.nonspacingMark,
  2914: CharacterType.nonspacingMark,
  2915: CharacterType.nonspacingMark,
  2946: CharacterType.nonspacingMark,
  3008: CharacterType.nonspacingMark,
  3021: CharacterType.nonspacingMark,
  3059: CharacterType.otherNeutrals,
  3060: CharacterType.otherNeutrals,
  3061: CharacterType.otherNeutrals,
  3062: CharacterType.otherNeutrals,
  3063: CharacterType.otherNeutrals,
  3064: CharacterType.otherNeutrals,
  3065: CharacterType.et,
  3066: CharacterType.otherNeutrals,
  3072: CharacterType.nonspacingMark,
  3134: CharacterType.nonspacingMark,
  3135: CharacterType.nonspacingMark,
  3136: CharacterType.nonspacingMark,
  3142: CharacterType.nonspacingMark,
  3143: CharacterType.nonspacingMark,
  3144: CharacterType.nonspacingMark,
  3146: CharacterType.nonspacingMark,
  3147: CharacterType.nonspacingMark,
  3148: CharacterType.nonspacingMark,
  3149: CharacterType.nonspacingMark,
  3157: CharacterType.nonspacingMark,
  3158: CharacterType.nonspacingMark,
  3170: CharacterType.nonspacingMark,
  3171: CharacterType.nonspacingMark,
  3192: CharacterType.otherNeutrals,
  3193: CharacterType.otherNeutrals,
  3194: CharacterType.otherNeutrals,
  3195: CharacterType.otherNeutrals,
  3196: CharacterType.otherNeutrals,
  3197: CharacterType.otherNeutrals,
  3198: CharacterType.otherNeutrals,
  3201: CharacterType.nonspacingMark,
  3260: CharacterType.nonspacingMark,
  3276: CharacterType.nonspacingMark,
  3277: CharacterType.nonspacingMark,
  3298: CharacterType.nonspacingMark,
  3299: CharacterType.nonspacingMark,
  3329: CharacterType.nonspacingMark,
  3393: CharacterType.nonspacingMark,
  3394: CharacterType.nonspacingMark,
  3395: CharacterType.nonspacingMark,
  3396: CharacterType.nonspacingMark,
  3405: CharacterType.nonspacingMark,
  3426: CharacterType.nonspacingMark,
  3427: CharacterType.nonspacingMark,
  3530: CharacterType.nonspacingMark,
  3538: CharacterType.nonspacingMark,
  3539: CharacterType.nonspacingMark,
  3540: CharacterType.nonspacingMark,
  3542: CharacterType.nonspacingMark,
  3633: CharacterType.nonspacingMark,
  3636: CharacterType.nonspacingMark,
  3637: CharacterType.nonspacingMark,
  3638: CharacterType.nonspacingMark,
  3639: CharacterType.nonspacingMark,
  3640: CharacterType.nonspacingMark,
  3641: CharacterType.nonspacingMark,
  3642: CharacterType.nonspacingMark,
  3647: CharacterType.et,
  3655: CharacterType.nonspacingMark,
  3656: CharacterType.nonspacingMark,
  3657: CharacterType.nonspacingMark,
  3658: CharacterType.nonspacingMark,
  3659: CharacterType.nonspacingMark,
  3660: CharacterType.nonspacingMark,
  3661: CharacterType.nonspacingMark,
  3662: CharacterType.nonspacingMark,
  3761: CharacterType.nonspacingMark,
  3764: CharacterType.nonspacingMark,
  3765: CharacterType.nonspacingMark,
  3766: CharacterType.nonspacingMark,
  3767: CharacterType.nonspacingMark,
  3768: CharacterType.nonspacingMark,
  3769: CharacterType.nonspacingMark,
  3771: CharacterType.nonspacingMark,
  3772: CharacterType.nonspacingMark,
  3784: CharacterType.nonspacingMark,
  3785: CharacterType.nonspacingMark,
  3786: CharacterType.nonspacingMark,
  3787: CharacterType.nonspacingMark,
  3788: CharacterType.nonspacingMark,
  3789: CharacterType.nonspacingMark,
  3864: CharacterType.nonspacingMark,
  3865: CharacterType.nonspacingMark,
  3893: CharacterType.nonspacingMark,
  3895: CharacterType.nonspacingMark,
  3897: CharacterType.nonspacingMark,
  3898: CharacterType.otherNeutrals,
  3899: CharacterType.otherNeutrals,
  3900: CharacterType.otherNeutrals,
  3901: CharacterType.otherNeutrals,
  3953: CharacterType.nonspacingMark,
  3954: CharacterType.nonspacingMark,
  3955: CharacterType.nonspacingMark,
  3956: CharacterType.nonspacingMark,
  3957: CharacterType.nonspacingMark,
  3958: CharacterType.nonspacingMark,
  3959: CharacterType.nonspacingMark,
  3960: CharacterType.nonspacingMark,
  3961: CharacterType.nonspacingMark,
  3962: CharacterType.nonspacingMark,
  3963: CharacterType.nonspacingMark,
  3964: CharacterType.nonspacingMark,
  3965: CharacterType.nonspacingMark,
  3966: CharacterType.nonspacingMark,
  3968: CharacterType.nonspacingMark,
  3969: CharacterType.nonspacingMark,
  3970: CharacterType.nonspacingMark,
  3971: CharacterType.nonspacingMark,
  3972: CharacterType.nonspacingMark,
  3974: CharacterType.nonspacingMark,
  3975: CharacterType.nonspacingMark,
  3981: CharacterType.nonspacingMark,
  3982: CharacterType.nonspacingMark,
  3983: CharacterType.nonspacingMark,
  3984: CharacterType.nonspacingMark,
  3985: CharacterType.nonspacingMark,
  3986: CharacterType.nonspacingMark,
  3987: CharacterType.nonspacingMark,
  3988: CharacterType.nonspacingMark,
  3989: CharacterType.nonspacingMark,
  3990: CharacterType.nonspacingMark,
  3991: CharacterType.nonspacingMark,
  3993: CharacterType.nonspacingMark,
  3994: CharacterType.nonspacingMark,
  3995: CharacterType.nonspacingMark,
  3996: CharacterType.nonspacingMark,
  3997: CharacterType.nonspacingMark,
  3998: CharacterType.nonspacingMark,
  3999: CharacterType.nonspacingMark,
  4000: CharacterType.nonspacingMark,
  4001: CharacterType.nonspacingMark,
  4002: CharacterType.nonspacingMark,
  4003: CharacterType.nonspacingMark,
  4004: CharacterType.nonspacingMark,
  4005: CharacterType.nonspacingMark,
  4006: CharacterType.nonspacingMark,
  4007: CharacterType.nonspacingMark,
  4008: CharacterType.nonspacingMark,
  4009: CharacterType.nonspacingMark,
  4010: CharacterType.nonspacingMark,
  4011: CharacterType.nonspacingMark,
  4012: CharacterType.nonspacingMark,
  4013: CharacterType.nonspacingMark,
  4014: CharacterType.nonspacingMark,
  4015: CharacterType.nonspacingMark,
  4016: CharacterType.nonspacingMark,
  4017: CharacterType.nonspacingMark,
  4018: CharacterType.nonspacingMark,
  4019: CharacterType.nonspacingMark,
  4020: CharacterType.nonspacingMark,
  4021: CharacterType.nonspacingMark,
  4022: CharacterType.nonspacingMark,
  4023: CharacterType.nonspacingMark,
  4024: CharacterType.nonspacingMark,
  4025: CharacterType.nonspacingMark,
  4026: CharacterType.nonspacingMark,
  4027: CharacterType.nonspacingMark,
  4028: CharacterType.nonspacingMark,
  4038: CharacterType.nonspacingMark,
  4141: CharacterType.nonspacingMark,
  4142: CharacterType.nonspacingMark,
  4143: CharacterType.nonspacingMark,
  4144: CharacterType.nonspacingMark,
  4146: CharacterType.nonspacingMark,
  4147: CharacterType.nonspacingMark,
  4148: CharacterType.nonspacingMark,
  4149: CharacterType.nonspacingMark,
  4150: CharacterType.nonspacingMark,
  4151: CharacterType.nonspacingMark,
  4153: CharacterType.nonspacingMark,
  4154: CharacterType.nonspacingMark,
  4157: CharacterType.nonspacingMark,
  4158: CharacterType.nonspacingMark,
  4184: CharacterType.nonspacingMark,
  4185: CharacterType.nonspacingMark,
  4190: CharacterType.nonspacingMark,
  4191: CharacterType.nonspacingMark,
  4192: CharacterType.nonspacingMark,
  4209: CharacterType.nonspacingMark,
  4210: CharacterType.nonspacingMark,
  4211: CharacterType.nonspacingMark,
  4212: CharacterType.nonspacingMark,
  4226: CharacterType.nonspacingMark,
  4229: CharacterType.nonspacingMark,
  4230: CharacterType.nonspacingMark,
  4237: CharacterType.nonspacingMark,
  4253: CharacterType.nonspacingMark,
  4957: CharacterType.nonspacingMark,
  4958: CharacterType.nonspacingMark,
  4959: CharacterType.nonspacingMark,
  5008: CharacterType.otherNeutrals,
  5009: CharacterType.otherNeutrals,
  5010: CharacterType.otherNeutrals,
  5011: CharacterType.otherNeutrals,
  5012: CharacterType.otherNeutrals,
  5013: CharacterType.otherNeutrals,
  5014: CharacterType.otherNeutrals,
  5015: CharacterType.otherNeutrals,
  5016: CharacterType.otherNeutrals,
  5017: CharacterType.otherNeutrals,
  5120: CharacterType.otherNeutrals,
  5760: CharacterType.whitespace,
  5787: CharacterType.otherNeutrals,
  5788: CharacterType.otherNeutrals,
  5906: CharacterType.nonspacingMark,
  5907: CharacterType.nonspacingMark,
  5908: CharacterType.nonspacingMark,
  5938: CharacterType.nonspacingMark,
  5939: CharacterType.nonspacingMark,
  5940: CharacterType.nonspacingMark,
  5970: CharacterType.nonspacingMark,
  5971: CharacterType.nonspacingMark,
  6002: CharacterType.nonspacingMark,
  6003: CharacterType.nonspacingMark,
  6068: CharacterType.nonspacingMark,
  6069: CharacterType.nonspacingMark,
  6071: CharacterType.nonspacingMark,
  6072: CharacterType.nonspacingMark,
  6073: CharacterType.nonspacingMark,
  6074: CharacterType.nonspacingMark,
  6075: CharacterType.nonspacingMark,
  6076: CharacterType.nonspacingMark,
  6077: CharacterType.nonspacingMark,
  6086: CharacterType.nonspacingMark,
  6089: CharacterType.nonspacingMark,
  6090: CharacterType.nonspacingMark,
  6091: CharacterType.nonspacingMark,
  6092: CharacterType.nonspacingMark,
  6093: CharacterType.nonspacingMark,
  6094: CharacterType.nonspacingMark,
  6095: CharacterType.nonspacingMark,
  6096: CharacterType.nonspacingMark,
  6097: CharacterType.nonspacingMark,
  6098: CharacterType.nonspacingMark,
  6099: CharacterType.nonspacingMark,
  6107: CharacterType.et,
  6109: CharacterType.nonspacingMark,
  6128: CharacterType.otherNeutrals,
  6129: CharacterType.otherNeutrals,
  6130: CharacterType.otherNeutrals,
  6131: CharacterType.otherNeutrals,
  6132: CharacterType.otherNeutrals,
  6133: CharacterType.otherNeutrals,
  6134: CharacterType.otherNeutrals,
  6135: CharacterType.otherNeutrals,
  6136: CharacterType.otherNeutrals,
  6137: CharacterType.otherNeutrals,
  6144: CharacterType.otherNeutrals,
  6145: CharacterType.otherNeutrals,
  6146: CharacterType.otherNeutrals,
  6147: CharacterType.otherNeutrals,
  6148: CharacterType.otherNeutrals,
  6149: CharacterType.otherNeutrals,
  6150: CharacterType.otherNeutrals,
  6151: CharacterType.otherNeutrals,
  6152: CharacterType.otherNeutrals,
  6153: CharacterType.otherNeutrals,
  6154: CharacterType.otherNeutrals,
  6155: CharacterType.nonspacingMark,
  6156: CharacterType.nonspacingMark,
  6157: CharacterType.nonspacingMark,
  6158: CharacterType.bn,
  6313: CharacterType.nonspacingMark,
  6432: CharacterType.nonspacingMark,
  6433: CharacterType.nonspacingMark,
  6434: CharacterType.nonspacingMark,
  6439: CharacterType.nonspacingMark,
  6440: CharacterType.nonspacingMark,
  6450: CharacterType.nonspacingMark,
  6457: CharacterType.nonspacingMark,
  6458: CharacterType.nonspacingMark,
  6459: CharacterType.nonspacingMark,
  6464: CharacterType.otherNeutrals,
  6468: CharacterType.otherNeutrals,
  6469: CharacterType.otherNeutrals,
  6622: CharacterType.otherNeutrals,
  6623: CharacterType.otherNeutrals,
  6624: CharacterType.otherNeutrals,
  6625: CharacterType.otherNeutrals,
  6626: CharacterType.otherNeutrals,
  6627: CharacterType.otherNeutrals,
  6628: CharacterType.otherNeutrals,
  6629: CharacterType.otherNeutrals,
  6630: CharacterType.otherNeutrals,
  6631: CharacterType.otherNeutrals,
  6632: CharacterType.otherNeutrals,
  6633: CharacterType.otherNeutrals,
  6634: CharacterType.otherNeutrals,
  6635: CharacterType.otherNeutrals,
  6636: CharacterType.otherNeutrals,
  6637: CharacterType.otherNeutrals,
  6638: CharacterType.otherNeutrals,
  6639: CharacterType.otherNeutrals,
  6640: CharacterType.otherNeutrals,
  6641: CharacterType.otherNeutrals,
  6642: CharacterType.otherNeutrals,
  6643: CharacterType.otherNeutrals,
  6644: CharacterType.otherNeutrals,
  6645: CharacterType.otherNeutrals,
  6646: CharacterType.otherNeutrals,
  6647: CharacterType.otherNeutrals,
  6648: CharacterType.otherNeutrals,
  6649: CharacterType.otherNeutrals,
  6650: CharacterType.otherNeutrals,
  6651: CharacterType.otherNeutrals,
  6652: CharacterType.otherNeutrals,
  6653: CharacterType.otherNeutrals,
  6654: CharacterType.otherNeutrals,
  6655: CharacterType.otherNeutrals,
  6679: CharacterType.nonspacingMark,
  6680: CharacterType.nonspacingMark,
  6683: CharacterType.nonspacingMark,
  6742: CharacterType.nonspacingMark,
  6744: CharacterType.nonspacingMark,
  6745: CharacterType.nonspacingMark,
  6746: CharacterType.nonspacingMark,
  6747: CharacterType.nonspacingMark,
  6748: CharacterType.nonspacingMark,
  6749: CharacterType.nonspacingMark,
  6750: CharacterType.nonspacingMark,
  6752: CharacterType.nonspacingMark,
  6754: CharacterType.nonspacingMark,
  6757: CharacterType.nonspacingMark,
  6758: CharacterType.nonspacingMark,
  6759: CharacterType.nonspacingMark,
  6760: CharacterType.nonspacingMark,
  6761: CharacterType.nonspacingMark,
  6762: CharacterType.nonspacingMark,
  6763: CharacterType.nonspacingMark,
  6764: CharacterType.nonspacingMark,
  6771: CharacterType.nonspacingMark,
  6772: CharacterType.nonspacingMark,
  6773: CharacterType.nonspacingMark,
  6774: CharacterType.nonspacingMark,
  6775: CharacterType.nonspacingMark,
  6776: CharacterType.nonspacingMark,
  6777: CharacterType.nonspacingMark,
  6778: CharacterType.nonspacingMark,
  6779: CharacterType.nonspacingMark,
  6780: CharacterType.nonspacingMark,
  6783: CharacterType.nonspacingMark,
  6832: CharacterType.nonspacingMark,
  6833: CharacterType.nonspacingMark,
  6834: CharacterType.nonspacingMark,
  6835: CharacterType.nonspacingMark,
  6836: CharacterType.nonspacingMark,
  6837: CharacterType.nonspacingMark,
  6838: CharacterType.nonspacingMark,
  6839: CharacterType.nonspacingMark,
  6840: CharacterType.nonspacingMark,
  6841: CharacterType.nonspacingMark,
  6842: CharacterType.nonspacingMark,
  6843: CharacterType.nonspacingMark,
  6844: CharacterType.nonspacingMark,
  6845: CharacterType.nonspacingMark,
  6846: CharacterType.nonspacingMark,
  6912: CharacterType.nonspacingMark,
  6913: CharacterType.nonspacingMark,
  6914: CharacterType.nonspacingMark,
  6915: CharacterType.nonspacingMark,
  6964: CharacterType.nonspacingMark,
  6966: CharacterType.nonspacingMark,
  6967: CharacterType.nonspacingMark,
  6968: CharacterType.nonspacingMark,
  6969: CharacterType.nonspacingMark,
  6970: CharacterType.nonspacingMark,
  6972: CharacterType.nonspacingMark,
  6978: CharacterType.nonspacingMark,
  7019: CharacterType.nonspacingMark,
  7020: CharacterType.nonspacingMark,
  7021: CharacterType.nonspacingMark,
  7022: CharacterType.nonspacingMark,
  7023: CharacterType.nonspacingMark,
  7024: CharacterType.nonspacingMark,
  7025: CharacterType.nonspacingMark,
  7026: CharacterType.nonspacingMark,
  7027: CharacterType.nonspacingMark,
  7040: CharacterType.nonspacingMark,
  7041: CharacterType.nonspacingMark,
  7074: CharacterType.nonspacingMark,
  7075: CharacterType.nonspacingMark,
  7076: CharacterType.nonspacingMark,
  7077: CharacterType.nonspacingMark,
  7080: CharacterType.nonspacingMark,
  7081: CharacterType.nonspacingMark,
  7083: CharacterType.nonspacingMark,
  7084: CharacterType.nonspacingMark,
  7085: CharacterType.nonspacingMark,
  7142: CharacterType.nonspacingMark,
  7144: CharacterType.nonspacingMark,
  7145: CharacterType.nonspacingMark,
  7149: CharacterType.nonspacingMark,
  7151: CharacterType.nonspacingMark,
  7152: CharacterType.nonspacingMark,
  7153: CharacterType.nonspacingMark,
  7212: CharacterType.nonspacingMark,
  7213: CharacterType.nonspacingMark,
  7214: CharacterType.nonspacingMark,
  7215: CharacterType.nonspacingMark,
  7216: CharacterType.nonspacingMark,
  7217: CharacterType.nonspacingMark,
  7218: CharacterType.nonspacingMark,
  7219: CharacterType.nonspacingMark,
  7222: CharacterType.nonspacingMark,
  7223: CharacterType.nonspacingMark,
  7376: CharacterType.nonspacingMark,
  7377: CharacterType.nonspacingMark,
  7378: CharacterType.nonspacingMark,
  7380: CharacterType.nonspacingMark,
  7381: CharacterType.nonspacingMark,
  7382: CharacterType.nonspacingMark,
  7383: CharacterType.nonspacingMark,
  7384: CharacterType.nonspacingMark,
  7385: CharacterType.nonspacingMark,
  7386: CharacterType.nonspacingMark,
  7387: CharacterType.nonspacingMark,
  7388: CharacterType.nonspacingMark,
  7389: CharacterType.nonspacingMark,
  7390: CharacterType.nonspacingMark,
  7391: CharacterType.nonspacingMark,
  7392: CharacterType.nonspacingMark,
  7394: CharacterType.nonspacingMark,
  7395: CharacterType.nonspacingMark,
  7396: CharacterType.nonspacingMark,
  7397: CharacterType.nonspacingMark,
  7398: CharacterType.nonspacingMark,
  7399: CharacterType.nonspacingMark,
  7400: CharacterType.nonspacingMark,
  7405: CharacterType.nonspacingMark,
  7412: CharacterType.nonspacingMark,
  7416: CharacterType.nonspacingMark,
  7417: CharacterType.nonspacingMark,
  7616: CharacterType.nonspacingMark,
  7617: CharacterType.nonspacingMark,
  7618: CharacterType.nonspacingMark,
  7619: CharacterType.nonspacingMark,
  7620: CharacterType.nonspacingMark,
  7621: CharacterType.nonspacingMark,
  7622: CharacterType.nonspacingMark,
  7623: CharacterType.nonspacingMark,
  7624: CharacterType.nonspacingMark,
  7625: CharacterType.nonspacingMark,
  7626: CharacterType.nonspacingMark,
  7627: CharacterType.nonspacingMark,
  7628: CharacterType.nonspacingMark,
  7629: CharacterType.nonspacingMark,
  7630: CharacterType.nonspacingMark,
  7631: CharacterType.nonspacingMark,
  7632: CharacterType.nonspacingMark,
  7633: CharacterType.nonspacingMark,
  7634: CharacterType.nonspacingMark,
  7635: CharacterType.nonspacingMark,
  7636: CharacterType.nonspacingMark,
  7637: CharacterType.nonspacingMark,
  7638: CharacterType.nonspacingMark,
  7639: CharacterType.nonspacingMark,
  7640: CharacterType.nonspacingMark,
  7641: CharacterType.nonspacingMark,
  7642: CharacterType.nonspacingMark,
  7643: CharacterType.nonspacingMark,
  7644: CharacterType.nonspacingMark,
  7645: CharacterType.nonspacingMark,
  7646: CharacterType.nonspacingMark,
  7647: CharacterType.nonspacingMark,
  7648: CharacterType.nonspacingMark,
  7649: CharacterType.nonspacingMark,
  7650: CharacterType.nonspacingMark,
  7651: CharacterType.nonspacingMark,
  7652: CharacterType.nonspacingMark,
  7653: CharacterType.nonspacingMark,
  7654: CharacterType.nonspacingMark,
  7655: CharacterType.nonspacingMark,
  7656: CharacterType.nonspacingMark,
  7657: CharacterType.nonspacingMark,
  7658: CharacterType.nonspacingMark,
  7659: CharacterType.nonspacingMark,
  7660: CharacterType.nonspacingMark,
  7661: CharacterType.nonspacingMark,
  7662: CharacterType.nonspacingMark,
  7663: CharacterType.nonspacingMark,
  7664: CharacterType.nonspacingMark,
  7665: CharacterType.nonspacingMark,
  7666: CharacterType.nonspacingMark,
  7667: CharacterType.nonspacingMark,
  7668: CharacterType.nonspacingMark,
  7669: CharacterType.nonspacingMark,
  7676: CharacterType.nonspacingMark,
  7677: CharacterType.nonspacingMark,
  7678: CharacterType.nonspacingMark,
  7679: CharacterType.nonspacingMark,
  8125: CharacterType.otherNeutrals,
  8127: CharacterType.otherNeutrals,
  8128: CharacterType.otherNeutrals,
  8129: CharacterType.otherNeutrals,
  8141: CharacterType.otherNeutrals,
  8142: CharacterType.otherNeutrals,
  8143: CharacterType.otherNeutrals,
  8157: CharacterType.otherNeutrals,
  8158: CharacterType.otherNeutrals,
  8159: CharacterType.otherNeutrals,
  8173: CharacterType.otherNeutrals,
  8174: CharacterType.otherNeutrals,
  8175: CharacterType.otherNeutrals,
  8189: CharacterType.otherNeutrals,
  8190: CharacterType.otherNeutrals,
  8192: CharacterType.whitespace,
  8193: CharacterType.whitespace,
  8194: CharacterType.whitespace,
  8195: CharacterType.whitespace,
  8196: CharacterType.whitespace,
  8197: CharacterType.whitespace,
  8198: CharacterType.whitespace,
  8199: CharacterType.whitespace,
  8200: CharacterType.whitespace,
  8201: CharacterType.whitespace,
  8202: CharacterType.whitespace,
  8203: CharacterType.bn,
  8204: CharacterType.bn,
  8205: CharacterType.bn,
  8207: CharacterType.rtl,
  8208: CharacterType.otherNeutrals,
  8209: CharacterType.otherNeutrals,
  8210: CharacterType.otherNeutrals,
  8211: CharacterType.otherNeutrals,
  8212: CharacterType.otherNeutrals,
  8213: CharacterType.otherNeutrals,
  8214: CharacterType.otherNeutrals,
  8215: CharacterType.otherNeutrals,
  8216: CharacterType.otherNeutrals,
  8217: CharacterType.otherNeutrals,
  8218: CharacterType.otherNeutrals,
  8219: CharacterType.otherNeutrals,
  8220: CharacterType.otherNeutrals,
  8221: CharacterType.otherNeutrals,
  8222: CharacterType.otherNeutrals,
  8223: CharacterType.otherNeutrals,
  8224: CharacterType.otherNeutrals,
  8225: CharacterType.otherNeutrals,
  8226: CharacterType.otherNeutrals,
  8227: CharacterType.otherNeutrals,
  8228: CharacterType.otherNeutrals,
  8229: CharacterType.otherNeutrals,
  8230: CharacterType.otherNeutrals,
  8231: CharacterType.otherNeutrals,
  8232: CharacterType.whitespace,
  8233: CharacterType.separator,
  8234: CharacterType.lre,
  8235: CharacterType.rle,
  8236: CharacterType.pdf,
  8237: CharacterType.lro,
  8238: CharacterType.rlo,
  8239: CharacterType.commonNumberSeparator,
  8240: CharacterType.et,
  8241: CharacterType.et,
  8242: CharacterType.et,
  8243: CharacterType.et,
  8244: CharacterType.et,
  8245: CharacterType.otherNeutrals,
  8246: CharacterType.otherNeutrals,
  8247: CharacterType.otherNeutrals,
  8248: CharacterType.otherNeutrals,
  8249: CharacterType.otherNeutrals,
  8250: CharacterType.otherNeutrals,
  8251: CharacterType.otherNeutrals,
  8252: CharacterType.otherNeutrals,
  8253: CharacterType.otherNeutrals,
  8254: CharacterType.otherNeutrals,
  8255: CharacterType.otherNeutrals,
  8256: CharacterType.otherNeutrals,
  8257: CharacterType.otherNeutrals,
  8258: CharacterType.otherNeutrals,
  8259: CharacterType.otherNeutrals,
  8260: CharacterType.commonNumberSeparator,
  8261: CharacterType.otherNeutrals,
  8262: CharacterType.otherNeutrals,
  8263: CharacterType.otherNeutrals,
  8264: CharacterType.otherNeutrals,
  8265: CharacterType.otherNeutrals,
  8266: CharacterType.otherNeutrals,
  8267: CharacterType.otherNeutrals,
  8268: CharacterType.otherNeutrals,
  8269: CharacterType.otherNeutrals,
  8270: CharacterType.otherNeutrals,
  8271: CharacterType.otherNeutrals,
  8272: CharacterType.otherNeutrals,
  8273: CharacterType.otherNeutrals,
  8274: CharacterType.otherNeutrals,
  8275: CharacterType.otherNeutrals,
  8276: CharacterType.otherNeutrals,
  8277: CharacterType.otherNeutrals,
  8278: CharacterType.otherNeutrals,
  8279: CharacterType.otherNeutrals,
  8280: CharacterType.otherNeutrals,
  8281: CharacterType.otherNeutrals,
  8282: CharacterType.otherNeutrals,
  8283: CharacterType.otherNeutrals,
  8284: CharacterType.otherNeutrals,
  8285: CharacterType.otherNeutrals,
  8286: CharacterType.otherNeutrals,
  8287: CharacterType.whitespace,
  8288: CharacterType.bn,
  8289: CharacterType.bn,
  8290: CharacterType.bn,
  8291: CharacterType.bn,
  8292: CharacterType.bn,
  8294: CharacterType.lri,
  8295: CharacterType.rli,
  8296: CharacterType.fsi,
  8297: CharacterType.pdi,
  8298: CharacterType.bn,
  8299: CharacterType.bn,
  8300: CharacterType.bn,
  8301: CharacterType.bn,
  8302: CharacterType.bn,
  8303: CharacterType.bn,
  8304: CharacterType.en,
  8308: CharacterType.en,
  8309: CharacterType.en,
  8310: CharacterType.en,
  8311: CharacterType.en,
  8312: CharacterType.en,
  8313: CharacterType.en,
  8314: CharacterType.es,
  8315: CharacterType.es,
  8316: CharacterType.otherNeutrals,
  8317: CharacterType.otherNeutrals,
  8318: CharacterType.otherNeutrals,
  8320: CharacterType.en,
  8321: CharacterType.en,
  8322: CharacterType.en,
  8323: CharacterType.en,
  8324: CharacterType.en,
  8325: CharacterType.en,
  8326: CharacterType.en,
  8327: CharacterType.en,
  8328: CharacterType.en,
  8329: CharacterType.en,
  8330: CharacterType.es,
  8331: CharacterType.es,
  8332: CharacterType.otherNeutrals,
  8333: CharacterType.otherNeutrals,
  8334: CharacterType.otherNeutrals,
  8352: CharacterType.et,
  8353: CharacterType.et,
  8354: CharacterType.et,
  8355: CharacterType.et,
  8356: CharacterType.et,
  8357: CharacterType.et,
  8358: CharacterType.et,
  8359: CharacterType.et,
  8360: CharacterType.et,
  8361: CharacterType.et,
  8362: CharacterType.et,
  8363: CharacterType.et,
  8364: CharacterType.et,
  8365: CharacterType.et,
  8366: CharacterType.et,
  8367: CharacterType.et,
  8368: CharacterType.et,
  8369: CharacterType.et,
  8370: CharacterType.et,
  8371: CharacterType.et,
  8372: CharacterType.et,
  8373: CharacterType.et,
  8374: CharacterType.et,
  8375: CharacterType.et,
  8376: CharacterType.et,
  8377: CharacterType.et,
  8378: CharacterType.et,
  8379: CharacterType.et,
  8380: CharacterType.et,
  8381: CharacterType.et,
  8400: CharacterType.nonspacingMark,
  8401: CharacterType.nonspacingMark,
  8402: CharacterType.nonspacingMark,
  8403: CharacterType.nonspacingMark,
  8404: CharacterType.nonspacingMark,
  8405: CharacterType.nonspacingMark,
  8406: CharacterType.nonspacingMark,
  8407: CharacterType.nonspacingMark,
  8408: CharacterType.nonspacingMark,
  8409: CharacterType.nonspacingMark,
  8410: CharacterType.nonspacingMark,
  8411: CharacterType.nonspacingMark,
  8412: CharacterType.nonspacingMark,
  8413: CharacterType.nonspacingMark,
  8414: CharacterType.nonspacingMark,
  8415: CharacterType.nonspacingMark,
  8416: CharacterType.nonspacingMark,
  8417: CharacterType.nonspacingMark,
  8418: CharacterType.nonspacingMark,
  8419: CharacterType.nonspacingMark,
  8420: CharacterType.nonspacingMark,
  8421: CharacterType.nonspacingMark,
  8422: CharacterType.nonspacingMark,
  8423: CharacterType.nonspacingMark,
  8424: CharacterType.nonspacingMark,
  8425: CharacterType.nonspacingMark,
  8426: CharacterType.nonspacingMark,
  8427: CharacterType.nonspacingMark,
  8428: CharacterType.nonspacingMark,
  8429: CharacterType.nonspacingMark,
  8430: CharacterType.nonspacingMark,
  8431: CharacterType.nonspacingMark,
  8432: CharacterType.nonspacingMark,
  8448: CharacterType.otherNeutrals,
  8449: CharacterType.otherNeutrals,
  8451: CharacterType.otherNeutrals,
  8452: CharacterType.otherNeutrals,
  8453: CharacterType.otherNeutrals,
  8454: CharacterType.otherNeutrals,
  8456: CharacterType.otherNeutrals,
  8457: CharacterType.otherNeutrals,
  8468: CharacterType.otherNeutrals,
  8470: CharacterType.otherNeutrals,
  8471: CharacterType.otherNeutrals,
  8472: CharacterType.otherNeutrals,
  8478: CharacterType.otherNeutrals,
  8479: CharacterType.otherNeutrals,
  8480: CharacterType.otherNeutrals,
  8481: CharacterType.otherNeutrals,
  8482: CharacterType.otherNeutrals,
  8483: CharacterType.otherNeutrals,
  8485: CharacterType.otherNeutrals,
  8487: CharacterType.otherNeutrals,
  8489: CharacterType.otherNeutrals,
  8494: CharacterType.et,
  8506: CharacterType.otherNeutrals,
  8507: CharacterType.otherNeutrals,
  8512: CharacterType.otherNeutrals,
  8513: CharacterType.otherNeutrals,
  8514: CharacterType.otherNeutrals,
  8515: CharacterType.otherNeutrals,
  8516: CharacterType.otherNeutrals,
  8522: CharacterType.otherNeutrals,
  8523: CharacterType.otherNeutrals,
  8524: CharacterType.otherNeutrals,
  8525: CharacterType.otherNeutrals,
  8528: CharacterType.otherNeutrals,
  8529: CharacterType.otherNeutrals,
  8530: CharacterType.otherNeutrals,
  8531: CharacterType.otherNeutrals,
  8532: CharacterType.otherNeutrals,
  8533: CharacterType.otherNeutrals,
  8534: CharacterType.otherNeutrals,
  8535: CharacterType.otherNeutrals,
  8536: CharacterType.otherNeutrals,
  8537: CharacterType.otherNeutrals,
  8538: CharacterType.otherNeutrals,
  8539: CharacterType.otherNeutrals,
  8540: CharacterType.otherNeutrals,
  8541: CharacterType.otherNeutrals,
  8542: CharacterType.otherNeutrals,
  8543: CharacterType.otherNeutrals,
  8585: CharacterType.otherNeutrals,
  8592: CharacterType.otherNeutrals,
  8593: CharacterType.otherNeutrals,
  8594: CharacterType.otherNeutrals,
  8595: CharacterType.otherNeutrals,
  8596: CharacterType.otherNeutrals,
  8597: CharacterType.otherNeutrals,
  8598: CharacterType.otherNeutrals,
  8599: CharacterType.otherNeutrals,
  8600: CharacterType.otherNeutrals,
  8601: CharacterType.otherNeutrals,
  8602: CharacterType.otherNeutrals,
  8603: CharacterType.otherNeutrals,
  8604: CharacterType.otherNeutrals,
  8605: CharacterType.otherNeutrals,
  8606: CharacterType.otherNeutrals,
  8607: CharacterType.otherNeutrals,
  8608: CharacterType.otherNeutrals,
  8609: CharacterType.otherNeutrals,
  8610: CharacterType.otherNeutrals,
  8611: CharacterType.otherNeutrals,
  8612: CharacterType.otherNeutrals,
  8613: CharacterType.otherNeutrals,
  8614: CharacterType.otherNeutrals,
  8615: CharacterType.otherNeutrals,
  8616: CharacterType.otherNeutrals,
  8617: CharacterType.otherNeutrals,
  8618: CharacterType.otherNeutrals,
  8619: CharacterType.otherNeutrals,
  8620: CharacterType.otherNeutrals,
  8621: CharacterType.otherNeutrals,
  8622: CharacterType.otherNeutrals,
  8623: CharacterType.otherNeutrals,
  8624: CharacterType.otherNeutrals,
  8625: CharacterType.otherNeutrals,
  8626: CharacterType.otherNeutrals,
  8627: CharacterType.otherNeutrals,
  8628: CharacterType.otherNeutrals,
  8629: CharacterType.otherNeutrals,
  8630: CharacterType.otherNeutrals,
  8631: CharacterType.otherNeutrals,
  8632: CharacterType.otherNeutrals,
  8633: CharacterType.otherNeutrals,
  8634: CharacterType.otherNeutrals,
  8635: CharacterType.otherNeutrals,
  8636: CharacterType.otherNeutrals,
  8637: CharacterType.otherNeutrals,
  8638: CharacterType.otherNeutrals,
  8639: CharacterType.otherNeutrals,
  8640: CharacterType.otherNeutrals,
  8641: CharacterType.otherNeutrals,
  8642: CharacterType.otherNeutrals,
  8643: CharacterType.otherNeutrals,
  8644: CharacterType.otherNeutrals,
  8645: CharacterType.otherNeutrals,
  8646: CharacterType.otherNeutrals,
  8647: CharacterType.otherNeutrals,
  8648: CharacterType.otherNeutrals,
  8649: CharacterType.otherNeutrals,
  8650: CharacterType.otherNeutrals,
  8651: CharacterType.otherNeutrals,
  8652: CharacterType.otherNeutrals,
  8653: CharacterType.otherNeutrals,
  8654: CharacterType.otherNeutrals,
  8655: CharacterType.otherNeutrals,
  8656: CharacterType.otherNeutrals,
  8657: CharacterType.otherNeutrals,
  8658: CharacterType.otherNeutrals,
  8659: CharacterType.otherNeutrals,
  8660: CharacterType.otherNeutrals,
  8661: CharacterType.otherNeutrals,
  8662: CharacterType.otherNeutrals,
  8663: CharacterType.otherNeutrals,
  8664: CharacterType.otherNeutrals,
  8665: CharacterType.otherNeutrals,
  8666: CharacterType.otherNeutrals,
  8667: CharacterType.otherNeutrals,
  8668: CharacterType.otherNeutrals,
  8669: CharacterType.otherNeutrals,
  8670: CharacterType.otherNeutrals,
  8671: CharacterType.otherNeutrals,
  8672: CharacterType.otherNeutrals,
  8673: CharacterType.otherNeutrals,
  8674: CharacterType.otherNeutrals,
  8675: CharacterType.otherNeutrals,
  8676: CharacterType.otherNeutrals,
  8677: CharacterType.otherNeutrals,
  8678: CharacterType.otherNeutrals,
  8679: CharacterType.otherNeutrals,
  8680: CharacterType.otherNeutrals,
  8681: CharacterType.otherNeutrals,
  8682: CharacterType.otherNeutrals,
  8683: CharacterType.otherNeutrals,
  8684: CharacterType.otherNeutrals,
  8685: CharacterType.otherNeutrals,
  8686: CharacterType.otherNeutrals,
  8687: CharacterType.otherNeutrals,
  8688: CharacterType.otherNeutrals,
  8689: CharacterType.otherNeutrals,
  8690: CharacterType.otherNeutrals,
  8691: CharacterType.otherNeutrals,
  8692: CharacterType.otherNeutrals,
  8693: CharacterType.otherNeutrals,
  8694: CharacterType.otherNeutrals,
  8695: CharacterType.otherNeutrals,
  8696: CharacterType.otherNeutrals,
  8697: CharacterType.otherNeutrals,
  8698: CharacterType.otherNeutrals,
  8699: CharacterType.otherNeutrals,
  8700: CharacterType.otherNeutrals,
  8701: CharacterType.otherNeutrals,
  8702: CharacterType.otherNeutrals,
  8703: CharacterType.otherNeutrals,
  8704: CharacterType.otherNeutrals,
  8705: CharacterType.otherNeutrals,
  8706: CharacterType.otherNeutrals,
  8707: CharacterType.otherNeutrals,
  8708: CharacterType.otherNeutrals,
  8709: CharacterType.otherNeutrals,
  8710: CharacterType.otherNeutrals,
  8711: CharacterType.otherNeutrals,
  8712: CharacterType.otherNeutrals,
  8713: CharacterType.otherNeutrals,
  8714: CharacterType.otherNeutrals,
  8715: CharacterType.otherNeutrals,
  8716: CharacterType.otherNeutrals,
  8717: CharacterType.otherNeutrals,
  8718: CharacterType.otherNeutrals,
  8719: CharacterType.otherNeutrals,
  8720: CharacterType.otherNeutrals,
  8721: CharacterType.otherNeutrals,
  8722: CharacterType.es,
  8723: CharacterType.et,
  8724: CharacterType.otherNeutrals,
  8725: CharacterType.otherNeutrals,
  8726: CharacterType.otherNeutrals,
  8727: CharacterType.otherNeutrals,
  8728: CharacterType.otherNeutrals,
  8729: CharacterType.otherNeutrals,
  8730: CharacterType.otherNeutrals,
  8731: CharacterType.otherNeutrals,
  8732: CharacterType.otherNeutrals,
  8733: CharacterType.otherNeutrals,
  8734: CharacterType.otherNeutrals,
  8735: CharacterType.otherNeutrals,
  8736: CharacterType.otherNeutrals,
  8737: CharacterType.otherNeutrals,
  8738: CharacterType.otherNeutrals,
  8739: CharacterType.otherNeutrals,
  8740: CharacterType.otherNeutrals,
  8741: CharacterType.otherNeutrals,
  8742: CharacterType.otherNeutrals,
  8743: CharacterType.otherNeutrals,
  8744: CharacterType.otherNeutrals,
  8745: CharacterType.otherNeutrals,
  8746: CharacterType.otherNeutrals,
  8747: CharacterType.otherNeutrals,
  8748: CharacterType.otherNeutrals,
  8749: CharacterType.otherNeutrals,
  8750: CharacterType.otherNeutrals,
  8751: CharacterType.otherNeutrals,
  8752: CharacterType.otherNeutrals,
  8753: CharacterType.otherNeutrals,
  8754: CharacterType.otherNeutrals,
  8755: CharacterType.otherNeutrals,
  8756: CharacterType.otherNeutrals,
  8757: CharacterType.otherNeutrals,
  8758: CharacterType.otherNeutrals,
  8759: CharacterType.otherNeutrals,
  8760: CharacterType.otherNeutrals,
  8761: CharacterType.otherNeutrals,
  8762: CharacterType.otherNeutrals,
  8763: CharacterType.otherNeutrals,
  8764: CharacterType.otherNeutrals,
  8765: CharacterType.otherNeutrals,
  8766: CharacterType.otherNeutrals,
  8767: CharacterType.otherNeutrals,
  8768: CharacterType.otherNeutrals,
  8769: CharacterType.otherNeutrals,
  8770: CharacterType.otherNeutrals,
  8771: CharacterType.otherNeutrals,
  8772: CharacterType.otherNeutrals,
  8773: CharacterType.otherNeutrals,
  8774: CharacterType.otherNeutrals,
  8775: CharacterType.otherNeutrals,
  8776: CharacterType.otherNeutrals,
  8777: CharacterType.otherNeutrals,
  8778: CharacterType.otherNeutrals,
  8779: CharacterType.otherNeutrals,
  8780: CharacterType.otherNeutrals,
  8781: CharacterType.otherNeutrals,
  8782: CharacterType.otherNeutrals,
  8783: CharacterType.otherNeutrals,
  8784: CharacterType.otherNeutrals,
  8785: CharacterType.otherNeutrals,
  8786: CharacterType.otherNeutrals,
  8787: CharacterType.otherNeutrals,
  8788: CharacterType.otherNeutrals,
  8789: CharacterType.otherNeutrals,
  8790: CharacterType.otherNeutrals,
  8791: CharacterType.otherNeutrals,
  8792: CharacterType.otherNeutrals,
  8793: CharacterType.otherNeutrals,
  8794: CharacterType.otherNeutrals,
  8795: CharacterType.otherNeutrals,
  8796: CharacterType.otherNeutrals,
  8797: CharacterType.otherNeutrals,
  8798: CharacterType.otherNeutrals,
  8799: CharacterType.otherNeutrals,
  8800: CharacterType.otherNeutrals,
  8801: CharacterType.otherNeutrals,
  8802: CharacterType.otherNeutrals,
  8803: CharacterType.otherNeutrals,
  8804: CharacterType.otherNeutrals,
  8805: CharacterType.otherNeutrals,
  8806: CharacterType.otherNeutrals,
  8807: CharacterType.otherNeutrals,
  8808: CharacterType.otherNeutrals,
  8809: CharacterType.otherNeutrals,
  8810: CharacterType.otherNeutrals,
  8811: CharacterType.otherNeutrals,
  8812: CharacterType.otherNeutrals,
  8813: CharacterType.otherNeutrals,
  8814: CharacterType.otherNeutrals,
  8815: CharacterType.otherNeutrals,
  8816: CharacterType.otherNeutrals,
  8817: CharacterType.otherNeutrals,
  8818: CharacterType.otherNeutrals,
  8819: CharacterType.otherNeutrals,
  8820: CharacterType.otherNeutrals,
  8821: CharacterType.otherNeutrals,
  8822: CharacterType.otherNeutrals,
  8823: CharacterType.otherNeutrals,
  8824: CharacterType.otherNeutrals,
  8825: CharacterType.otherNeutrals,
  8826: CharacterType.otherNeutrals,
  8827: CharacterType.otherNeutrals,
  8828: CharacterType.otherNeutrals,
  8829: CharacterType.otherNeutrals,
  8830: CharacterType.otherNeutrals,
  8831: CharacterType.otherNeutrals,
  8832: CharacterType.otherNeutrals,
  8833: CharacterType.otherNeutrals,
  8834: CharacterType.otherNeutrals,
  8835: CharacterType.otherNeutrals,
  8836: CharacterType.otherNeutrals,
  8837: CharacterType.otherNeutrals,
  8838: CharacterType.otherNeutrals,
  8839: CharacterType.otherNeutrals,
  8840: CharacterType.otherNeutrals,
  8841: CharacterType.otherNeutrals,
  8842: CharacterType.otherNeutrals,
  8843: CharacterType.otherNeutrals,
  8844: CharacterType.otherNeutrals,
  8845: CharacterType.otherNeutrals,
  8846: CharacterType.otherNeutrals,
  8847: CharacterType.otherNeutrals,
  8848: CharacterType.otherNeutrals,
  8849: CharacterType.otherNeutrals,
  8850: CharacterType.otherNeutrals,
  8851: CharacterType.otherNeutrals,
  8852: CharacterType.otherNeutrals,
  8853: CharacterType.otherNeutrals,
  8854: CharacterType.otherNeutrals,
  8855: CharacterType.otherNeutrals,
  8856: CharacterType.otherNeutrals,
  8857: CharacterType.otherNeutrals,
  8858: CharacterType.otherNeutrals,
  8859: CharacterType.otherNeutrals,
  8860: CharacterType.otherNeutrals,
  8861: CharacterType.otherNeutrals,
  8862: CharacterType.otherNeutrals,
  8863: CharacterType.otherNeutrals,
  8864: CharacterType.otherNeutrals,
  8865: CharacterType.otherNeutrals,
  8866: CharacterType.otherNeutrals,
  8867: CharacterType.otherNeutrals,
  8868: CharacterType.otherNeutrals,
  8869: CharacterType.otherNeutrals,
  8870: CharacterType.otherNeutrals,
  8871: CharacterType.otherNeutrals,
  8872: CharacterType.otherNeutrals,
  8873: CharacterType.otherNeutrals,
  8874: CharacterType.otherNeutrals,
  8875: CharacterType.otherNeutrals,
  8876: CharacterType.otherNeutrals,
  8877: CharacterType.otherNeutrals,
  8878: CharacterType.otherNeutrals,
  8879: CharacterType.otherNeutrals,
  8880: CharacterType.otherNeutrals,
  8881: CharacterType.otherNeutrals,
  8882: CharacterType.otherNeutrals,
  8883: CharacterType.otherNeutrals,
  8884: CharacterType.otherNeutrals,
  8885: CharacterType.otherNeutrals,
  8886: CharacterType.otherNeutrals,
  8887: CharacterType.otherNeutrals,
  8888: CharacterType.otherNeutrals,
  8889: CharacterType.otherNeutrals,
  8890: CharacterType.otherNeutrals,
  8891: CharacterType.otherNeutrals,
  8892: CharacterType.otherNeutrals,
  8893: CharacterType.otherNeutrals,
  8894: CharacterType.otherNeutrals,
  8895: CharacterType.otherNeutrals,
  8896: CharacterType.otherNeutrals,
  8897: CharacterType.otherNeutrals,
  8898: CharacterType.otherNeutrals,
  8899: CharacterType.otherNeutrals,
  8900: CharacterType.otherNeutrals,
  8901: CharacterType.otherNeutrals,
  8902: CharacterType.otherNeutrals,
  8903: CharacterType.otherNeutrals,
  8904: CharacterType.otherNeutrals,
  8905: CharacterType.otherNeutrals,
  8906: CharacterType.otherNeutrals,
  8907: CharacterType.otherNeutrals,
  8908: CharacterType.otherNeutrals,
  8909: CharacterType.otherNeutrals,
  8910: CharacterType.otherNeutrals,
  8911: CharacterType.otherNeutrals,
  8912: CharacterType.otherNeutrals,
  8913: CharacterType.otherNeutrals,
  8914: CharacterType.otherNeutrals,
  8915: CharacterType.otherNeutrals,
  8916: CharacterType.otherNeutrals,
  8917: CharacterType.otherNeutrals,
  8918: CharacterType.otherNeutrals,
  8919: CharacterType.otherNeutrals,
  8920: CharacterType.otherNeutrals,
  8921: CharacterType.otherNeutrals,
  8922: CharacterType.otherNeutrals,
  8923: CharacterType.otherNeutrals,
  8924: CharacterType.otherNeutrals,
  8925: CharacterType.otherNeutrals,
  8926: CharacterType.otherNeutrals,
  8927: CharacterType.otherNeutrals,
  8928: CharacterType.otherNeutrals,
  8929: CharacterType.otherNeutrals,
  8930: CharacterType.otherNeutrals,
  8931: CharacterType.otherNeutrals,
  8932: CharacterType.otherNeutrals,
  8933: CharacterType.otherNeutrals,
  8934: CharacterType.otherNeutrals,
  8935: CharacterType.otherNeutrals,
  8936: CharacterType.otherNeutrals,
  8937: CharacterType.otherNeutrals,
  8938: CharacterType.otherNeutrals,
  8939: CharacterType.otherNeutrals,
  8940: CharacterType.otherNeutrals,
  8941: CharacterType.otherNeutrals,
  8942: CharacterType.otherNeutrals,
  8943: CharacterType.otherNeutrals,
  8944: CharacterType.otherNeutrals,
  8945: CharacterType.otherNeutrals,
  8946: CharacterType.otherNeutrals,
  8947: CharacterType.otherNeutrals,
  8948: CharacterType.otherNeutrals,
  8949: CharacterType.otherNeutrals,
  8950: CharacterType.otherNeutrals,
  8951: CharacterType.otherNeutrals,
  8952: CharacterType.otherNeutrals,
  8953: CharacterType.otherNeutrals,
  8954: CharacterType.otherNeutrals,
  8955: CharacterType.otherNeutrals,
  8956: CharacterType.otherNeutrals,
  8957: CharacterType.otherNeutrals,
  8958: CharacterType.otherNeutrals,
  8959: CharacterType.otherNeutrals,
  8960: CharacterType.otherNeutrals,
  8961: CharacterType.otherNeutrals,
  8962: CharacterType.otherNeutrals,
  8963: CharacterType.otherNeutrals,
  8964: CharacterType.otherNeutrals,
  8965: CharacterType.otherNeutrals,
  8966: CharacterType.otherNeutrals,
  8967: CharacterType.otherNeutrals,
  8968: CharacterType.otherNeutrals,
  8969: CharacterType.otherNeutrals,
  8970: CharacterType.otherNeutrals,
  8971: CharacterType.otherNeutrals,
  8972: CharacterType.otherNeutrals,
  8973: CharacterType.otherNeutrals,
  8974: CharacterType.otherNeutrals,
  8975: CharacterType.otherNeutrals,
  8976: CharacterType.otherNeutrals,
  8977: CharacterType.otherNeutrals,
  8978: CharacterType.otherNeutrals,
  8979: CharacterType.otherNeutrals,
  8980: CharacterType.otherNeutrals,
  8981: CharacterType.otherNeutrals,
  8982: CharacterType.otherNeutrals,
  8983: CharacterType.otherNeutrals,
  8984: CharacterType.otherNeutrals,
  8985: CharacterType.otherNeutrals,
  8986: CharacterType.otherNeutrals,
  8987: CharacterType.otherNeutrals,
  8988: CharacterType.otherNeutrals,
  8989: CharacterType.otherNeutrals,
  8990: CharacterType.otherNeutrals,
  8991: CharacterType.otherNeutrals,
  8992: CharacterType.otherNeutrals,
  8993: CharacterType.otherNeutrals,
  8994: CharacterType.otherNeutrals,
  8995: CharacterType.otherNeutrals,
  8996: CharacterType.otherNeutrals,
  8997: CharacterType.otherNeutrals,
  8998: CharacterType.otherNeutrals,
  8999: CharacterType.otherNeutrals,
  9000: CharacterType.otherNeutrals,
  9001: CharacterType.otherNeutrals,
  9002: CharacterType.otherNeutrals,
  9003: CharacterType.otherNeutrals,
  9004: CharacterType.otherNeutrals,
  9005: CharacterType.otherNeutrals,
  9006: CharacterType.otherNeutrals,
  9007: CharacterType.otherNeutrals,
  9008: CharacterType.otherNeutrals,
  9009: CharacterType.otherNeutrals,
  9010: CharacterType.otherNeutrals,
  9011: CharacterType.otherNeutrals,
  9012: CharacterType.otherNeutrals,
  9013: CharacterType.otherNeutrals,
  9083: CharacterType.otherNeutrals,
  9084: CharacterType.otherNeutrals,
  9085: CharacterType.otherNeutrals,
  9086: CharacterType.otherNeutrals,
  9087: CharacterType.otherNeutrals,
  9088: CharacterType.otherNeutrals,
  9089: CharacterType.otherNeutrals,
  9090: CharacterType.otherNeutrals,
  9091: CharacterType.otherNeutrals,
  9092: CharacterType.otherNeutrals,
  9093: CharacterType.otherNeutrals,
  9094: CharacterType.otherNeutrals,
  9095: CharacterType.otherNeutrals,
  9096: CharacterType.otherNeutrals,
  9097: CharacterType.otherNeutrals,
  9098: CharacterType.otherNeutrals,
  9099: CharacterType.otherNeutrals,
  9100: CharacterType.otherNeutrals,
  9101: CharacterType.otherNeutrals,
  9102: CharacterType.otherNeutrals,
  9103: CharacterType.otherNeutrals,
  9104: CharacterType.otherNeutrals,
  9105: CharacterType.otherNeutrals,
  9106: CharacterType.otherNeutrals,
  9107: CharacterType.otherNeutrals,
  9108: CharacterType.otherNeutrals,
  9110: CharacterType.otherNeutrals,
  9111: CharacterType.otherNeutrals,
  9112: CharacterType.otherNeutrals,
  9113: CharacterType.otherNeutrals,
  9114: CharacterType.otherNeutrals,
  9115: CharacterType.otherNeutrals,
  9116: CharacterType.otherNeutrals,
  9117: CharacterType.otherNeutrals,
  9118: CharacterType.otherNeutrals,
  9119: CharacterType.otherNeutrals,
  9120: CharacterType.otherNeutrals,
  9121: CharacterType.otherNeutrals,
  9122: CharacterType.otherNeutrals,
  9123: CharacterType.otherNeutrals,
  9124: CharacterType.otherNeutrals,
  9125: CharacterType.otherNeutrals,
  9126: CharacterType.otherNeutrals,
  9127: CharacterType.otherNeutrals,
  9128: CharacterType.otherNeutrals,
  9129: CharacterType.otherNeutrals,
  9130: CharacterType.otherNeutrals,
  9131: CharacterType.otherNeutrals,
  9132: CharacterType.otherNeutrals,
  9133: CharacterType.otherNeutrals,
  9134: CharacterType.otherNeutrals,
  9135: CharacterType.otherNeutrals,
  9136: CharacterType.otherNeutrals,
  9137: CharacterType.otherNeutrals,
  9138: CharacterType.otherNeutrals,
  9139: CharacterType.otherNeutrals,
  9140: CharacterType.otherNeutrals,
  9141: CharacterType.otherNeutrals,
  9142: CharacterType.otherNeutrals,
  9143: CharacterType.otherNeutrals,
  9144: CharacterType.otherNeutrals,
  9145: CharacterType.otherNeutrals,
  9146: CharacterType.otherNeutrals,
  9147: CharacterType.otherNeutrals,
  9148: CharacterType.otherNeutrals,
  9149: CharacterType.otherNeutrals,
  9150: CharacterType.otherNeutrals,
  9151: CharacterType.otherNeutrals,
  9152: CharacterType.otherNeutrals,
  9153: CharacterType.otherNeutrals,
  9154: CharacterType.otherNeutrals,
  9155: CharacterType.otherNeutrals,
  9156: CharacterType.otherNeutrals,
  9157: CharacterType.otherNeutrals,
  9158: CharacterType.otherNeutrals,
  9159: CharacterType.otherNeutrals,
  9160: CharacterType.otherNeutrals,
  9161: CharacterType.otherNeutrals,
  9162: CharacterType.otherNeutrals,
  9163: CharacterType.otherNeutrals,
  9164: CharacterType.otherNeutrals,
  9165: CharacterType.otherNeutrals,
  9166: CharacterType.otherNeutrals,
  9167: CharacterType.otherNeutrals,
  9168: CharacterType.otherNeutrals,
  9169: CharacterType.otherNeutrals,
  9170: CharacterType.otherNeutrals,
  9171: CharacterType.otherNeutrals,
  9172: CharacterType.otherNeutrals,
  9173: CharacterType.otherNeutrals,
  9174: CharacterType.otherNeutrals,
  9175: CharacterType.otherNeutrals,
  9176: CharacterType.otherNeutrals,
  9177: CharacterType.otherNeutrals,
  9178: CharacterType.otherNeutrals,
  9179: CharacterType.otherNeutrals,
  9180: CharacterType.otherNeutrals,
  9181: CharacterType.otherNeutrals,
  9182: CharacterType.otherNeutrals,
  9183: CharacterType.otherNeutrals,
  9184: CharacterType.otherNeutrals,
  9185: CharacterType.otherNeutrals,
  9186: CharacterType.otherNeutrals,
  9187: CharacterType.otherNeutrals,
  9188: CharacterType.otherNeutrals,
  9189: CharacterType.otherNeutrals,
  9190: CharacterType.otherNeutrals,
  9191: CharacterType.otherNeutrals,
  9192: CharacterType.otherNeutrals,
  9193: CharacterType.otherNeutrals,
  9194: CharacterType.otherNeutrals,
  9195: CharacterType.otherNeutrals,
  9196: CharacterType.otherNeutrals,
  9197: CharacterType.otherNeutrals,
  9198: CharacterType.otherNeutrals,
  9199: CharacterType.otherNeutrals,
  9200: CharacterType.otherNeutrals,
  9201: CharacterType.otherNeutrals,
  9202: CharacterType.otherNeutrals,
  9203: CharacterType.otherNeutrals,
  9204: CharacterType.otherNeutrals,
  9205: CharacterType.otherNeutrals,
  9206: CharacterType.otherNeutrals,
  9207: CharacterType.otherNeutrals,
  9208: CharacterType.otherNeutrals,
  9209: CharacterType.otherNeutrals,
  9210: CharacterType.otherNeutrals,
  9216: CharacterType.otherNeutrals,
  9217: CharacterType.otherNeutrals,
  9218: CharacterType.otherNeutrals,
  9219: CharacterType.otherNeutrals,
  9220: CharacterType.otherNeutrals,
  9221: CharacterType.otherNeutrals,
  9222: CharacterType.otherNeutrals,
  9223: CharacterType.otherNeutrals,
  9224: CharacterType.otherNeutrals,
  9225: CharacterType.otherNeutrals,
  9226: CharacterType.otherNeutrals,
  9227: CharacterType.otherNeutrals,
  9228: CharacterType.otherNeutrals,
  9229: CharacterType.otherNeutrals,
  9230: CharacterType.otherNeutrals,
  9231: CharacterType.otherNeutrals,
  9232: CharacterType.otherNeutrals,
  9233: CharacterType.otherNeutrals,
  9234: CharacterType.otherNeutrals,
  9235: CharacterType.otherNeutrals,
  9236: CharacterType.otherNeutrals,
  9237: CharacterType.otherNeutrals,
  9238: CharacterType.otherNeutrals,
  9239: CharacterType.otherNeutrals,
  9240: CharacterType.otherNeutrals,
  9241: CharacterType.otherNeutrals,
  9242: CharacterType.otherNeutrals,
  9243: CharacterType.otherNeutrals,
  9244: CharacterType.otherNeutrals,
  9245: CharacterType.otherNeutrals,
  9246: CharacterType.otherNeutrals,
  9247: CharacterType.otherNeutrals,
  9248: CharacterType.otherNeutrals,
  9249: CharacterType.otherNeutrals,
  9250: CharacterType.otherNeutrals,
  9251: CharacterType.otherNeutrals,
  9252: CharacterType.otherNeutrals,
  9253: CharacterType.otherNeutrals,
  9254: CharacterType.otherNeutrals,
  9280: CharacterType.otherNeutrals,
  9281: CharacterType.otherNeutrals,
  9282: CharacterType.otherNeutrals,
  9283: CharacterType.otherNeutrals,
  9284: CharacterType.otherNeutrals,
  9285: CharacterType.otherNeutrals,
  9286: CharacterType.otherNeutrals,
  9287: CharacterType.otherNeutrals,
  9288: CharacterType.otherNeutrals,
  9289: CharacterType.otherNeutrals,
  9290: CharacterType.otherNeutrals,
  9312: CharacterType.otherNeutrals,
  9313: CharacterType.otherNeutrals,
  9314: CharacterType.otherNeutrals,
  9315: CharacterType.otherNeutrals,
  9316: CharacterType.otherNeutrals,
  9317: CharacterType.otherNeutrals,
  9318: CharacterType.otherNeutrals,
  9319: CharacterType.otherNeutrals,
  9320: CharacterType.otherNeutrals,
  9321: CharacterType.otherNeutrals,
  9322: CharacterType.otherNeutrals,
  9323: CharacterType.otherNeutrals,
  9324: CharacterType.otherNeutrals,
  9325: CharacterType.otherNeutrals,
  9326: CharacterType.otherNeutrals,
  9327: CharacterType.otherNeutrals,
  9328: CharacterType.otherNeutrals,
  9329: CharacterType.otherNeutrals,
  9330: CharacterType.otherNeutrals,
  9331: CharacterType.otherNeutrals,
  9332: CharacterType.otherNeutrals,
  9333: CharacterType.otherNeutrals,
  9334: CharacterType.otherNeutrals,
  9335: CharacterType.otherNeutrals,
  9336: CharacterType.otherNeutrals,
  9337: CharacterType.otherNeutrals,
  9338: CharacterType.otherNeutrals,
  9339: CharacterType.otherNeutrals,
  9340: CharacterType.otherNeutrals,
  9341: CharacterType.otherNeutrals,
  9342: CharacterType.otherNeutrals,
  9343: CharacterType.otherNeutrals,
  9344: CharacterType.otherNeutrals,
  9345: CharacterType.otherNeutrals,
  9346: CharacterType.otherNeutrals,
  9347: CharacterType.otherNeutrals,
  9348: CharacterType.otherNeutrals,
  9349: CharacterType.otherNeutrals,
  9350: CharacterType.otherNeutrals,
  9351: CharacterType.otherNeutrals,
  9352: CharacterType.en,
  9353: CharacterType.en,
  9354: CharacterType.en,
  9355: CharacterType.en,
  9356: CharacterType.en,
  9357: CharacterType.en,
  9358: CharacterType.en,
  9359: CharacterType.en,
  9360: CharacterType.en,
  9361: CharacterType.en,
  9362: CharacterType.en,
  9363: CharacterType.en,
  9364: CharacterType.en,
  9365: CharacterType.en,
  9366: CharacterType.en,
  9367: CharacterType.en,
  9368: CharacterType.en,
  9369: CharacterType.en,
  9370: CharacterType.en,
  9371: CharacterType.en,
  9450: CharacterType.otherNeutrals,
  9451: CharacterType.otherNeutrals,
  9452: CharacterType.otherNeutrals,
  9453: CharacterType.otherNeutrals,
  9454: CharacterType.otherNeutrals,
  9455: CharacterType.otherNeutrals,
  9456: CharacterType.otherNeutrals,
  9457: CharacterType.otherNeutrals,
  9458: CharacterType.otherNeutrals,
  9459: CharacterType.otherNeutrals,
  9460: CharacterType.otherNeutrals,
  9461: CharacterType.otherNeutrals,
  9462: CharacterType.otherNeutrals,
  9463: CharacterType.otherNeutrals,
  9464: CharacterType.otherNeutrals,
  9465: CharacterType.otherNeutrals,
  9466: CharacterType.otherNeutrals,
  9467: CharacterType.otherNeutrals,
  9468: CharacterType.otherNeutrals,
  9469: CharacterType.otherNeutrals,
  9470: CharacterType.otherNeutrals,
  9471: CharacterType.otherNeutrals,
  9472: CharacterType.otherNeutrals,
  9473: CharacterType.otherNeutrals,
  9474: CharacterType.otherNeutrals,
  9475: CharacterType.otherNeutrals,
  9476: CharacterType.otherNeutrals,
  9477: CharacterType.otherNeutrals,
  9478: CharacterType.otherNeutrals,
  9479: CharacterType.otherNeutrals,
  9480: CharacterType.otherNeutrals,
  9481: CharacterType.otherNeutrals,
  9482: CharacterType.otherNeutrals,
  9483: CharacterType.otherNeutrals,
  9484: CharacterType.otherNeutrals,
  9485: CharacterType.otherNeutrals,
  9486: CharacterType.otherNeutrals,
  9487: CharacterType.otherNeutrals,
  9488: CharacterType.otherNeutrals,
  9489: CharacterType.otherNeutrals,
  9490: CharacterType.otherNeutrals,
  9491: CharacterType.otherNeutrals,
  9492: CharacterType.otherNeutrals,
  9493: CharacterType.otherNeutrals,
  9494: CharacterType.otherNeutrals,
  9495: CharacterType.otherNeutrals,
  9496: CharacterType.otherNeutrals,
  9497: CharacterType.otherNeutrals,
  9498: CharacterType.otherNeutrals,
  9499: CharacterType.otherNeutrals,
  9500: CharacterType.otherNeutrals,
  9501: CharacterType.otherNeutrals,
  9502: CharacterType.otherNeutrals,
  9503: CharacterType.otherNeutrals,
  9504: CharacterType.otherNeutrals,
  9505: CharacterType.otherNeutrals,
  9506: CharacterType.otherNeutrals,
  9507: CharacterType.otherNeutrals,
  9508: CharacterType.otherNeutrals,
  9509: CharacterType.otherNeutrals,
  9510: CharacterType.otherNeutrals,
  9511: CharacterType.otherNeutrals,
  9512: CharacterType.otherNeutrals,
  9513: CharacterType.otherNeutrals,
  9514: CharacterType.otherNeutrals,
  9515: CharacterType.otherNeutrals,
  9516: CharacterType.otherNeutrals,
  9517: CharacterType.otherNeutrals,
  9518: CharacterType.otherNeutrals,
  9519: CharacterType.otherNeutrals,
  9520: CharacterType.otherNeutrals,
  9521: CharacterType.otherNeutrals,
  9522: CharacterType.otherNeutrals,
  9523: CharacterType.otherNeutrals,
  9524: CharacterType.otherNeutrals,
  9525: CharacterType.otherNeutrals,
  9526: CharacterType.otherNeutrals,
  9527: CharacterType.otherNeutrals,
  9528: CharacterType.otherNeutrals,
  9529: CharacterType.otherNeutrals,
  9530: CharacterType.otherNeutrals,
  9531: CharacterType.otherNeutrals,
  9532: CharacterType.otherNeutrals,
  9533: CharacterType.otherNeutrals,
  9534: CharacterType.otherNeutrals,
  9535: CharacterType.otherNeutrals,
  9536: CharacterType.otherNeutrals,
  9537: CharacterType.otherNeutrals,
  9538: CharacterType.otherNeutrals,
  9539: CharacterType.otherNeutrals,
  9540: CharacterType.otherNeutrals,
  9541: CharacterType.otherNeutrals,
  9542: CharacterType.otherNeutrals,
  9543: CharacterType.otherNeutrals,
  9544: CharacterType.otherNeutrals,
  9545: CharacterType.otherNeutrals,
  9546: CharacterType.otherNeutrals,
  9547: CharacterType.otherNeutrals,
  9548: CharacterType.otherNeutrals,
  9549: CharacterType.otherNeutrals,
  9550: CharacterType.otherNeutrals,
  9551: CharacterType.otherNeutrals,
  9552: CharacterType.otherNeutrals,
  9553: CharacterType.otherNeutrals,
  9554: CharacterType.otherNeutrals,
  9555: CharacterType.otherNeutrals,
  9556: CharacterType.otherNeutrals,
  9557: CharacterType.otherNeutrals,
  9558: CharacterType.otherNeutrals,
  9559: CharacterType.otherNeutrals,
  9560: CharacterType.otherNeutrals,
  9561: CharacterType.otherNeutrals,
  9562: CharacterType.otherNeutrals,
  9563: CharacterType.otherNeutrals,
  9564: CharacterType.otherNeutrals,
  9565: CharacterType.otherNeutrals,
  9566: CharacterType.otherNeutrals,
  9567: CharacterType.otherNeutrals,
  9568: CharacterType.otherNeutrals,
  9569: CharacterType.otherNeutrals,
  9570: CharacterType.otherNeutrals,
  9571: CharacterType.otherNeutrals,
  9572: CharacterType.otherNeutrals,
  9573: CharacterType.otherNeutrals,
  9574: CharacterType.otherNeutrals,
  9575: CharacterType.otherNeutrals,
  9576: CharacterType.otherNeutrals,
  9577: CharacterType.otherNeutrals,
  9578: CharacterType.otherNeutrals,
  9579: CharacterType.otherNeutrals,
  9580: CharacterType.otherNeutrals,
  9581: CharacterType.otherNeutrals,
  9582: CharacterType.otherNeutrals,
  9583: CharacterType.otherNeutrals,
  9584: CharacterType.otherNeutrals,
  9585: CharacterType.otherNeutrals,
  9586: CharacterType.otherNeutrals,
  9587: CharacterType.otherNeutrals,
  9588: CharacterType.otherNeutrals,
  9589: CharacterType.otherNeutrals,
  9590: CharacterType.otherNeutrals,
  9591: CharacterType.otherNeutrals,
  9592: CharacterType.otherNeutrals,
  9593: CharacterType.otherNeutrals,
  9594: CharacterType.otherNeutrals,
  9595: CharacterType.otherNeutrals,
  9596: CharacterType.otherNeutrals,
  9597: CharacterType.otherNeutrals,
  9598: CharacterType.otherNeutrals,
  9599: CharacterType.otherNeutrals,
  9600: CharacterType.otherNeutrals,
  9601: CharacterType.otherNeutrals,
  9602: CharacterType.otherNeutrals,
  9603: CharacterType.otherNeutrals,
  9604: CharacterType.otherNeutrals,
  9605: CharacterType.otherNeutrals,
  9606: CharacterType.otherNeutrals,
  9607: CharacterType.otherNeutrals,
  9608: CharacterType.otherNeutrals,
  9609: CharacterType.otherNeutrals,
  9610: CharacterType.otherNeutrals,
  9611: CharacterType.otherNeutrals,
  9612: CharacterType.otherNeutrals,
  9613: CharacterType.otherNeutrals,
  9614: CharacterType.otherNeutrals,
  9615: CharacterType.otherNeutrals,
  9616: CharacterType.otherNeutrals,
  9617: CharacterType.otherNeutrals,
  9618: CharacterType.otherNeutrals,
  9619: CharacterType.otherNeutrals,
  9620: CharacterType.otherNeutrals,
  9621: CharacterType.otherNeutrals,
  9622: CharacterType.otherNeutrals,
  9623: CharacterType.otherNeutrals,
  9624: CharacterType.otherNeutrals,
  9625: CharacterType.otherNeutrals,
  9626: CharacterType.otherNeutrals,
  9627: CharacterType.otherNeutrals,
  9628: CharacterType.otherNeutrals,
  9629: CharacterType.otherNeutrals,
  9630: CharacterType.otherNeutrals,
  9631: CharacterType.otherNeutrals,
  9632: CharacterType.otherNeutrals,
  9633: CharacterType.otherNeutrals,
  9634: CharacterType.otherNeutrals,
  9635: CharacterType.otherNeutrals,
  9636: CharacterType.otherNeutrals,
  9637: CharacterType.otherNeutrals,
  9638: CharacterType.otherNeutrals,
  9639: CharacterType.otherNeutrals,
  9640: CharacterType.otherNeutrals,
  9641: CharacterType.otherNeutrals,
  9642: CharacterType.otherNeutrals,
  9643: CharacterType.otherNeutrals,
  9644: CharacterType.otherNeutrals,
  9645: CharacterType.otherNeutrals,
  9646: CharacterType.otherNeutrals,
  9647: CharacterType.otherNeutrals,
  9648: CharacterType.otherNeutrals,
  9649: CharacterType.otherNeutrals,
  9650: CharacterType.otherNeutrals,
  9651: CharacterType.otherNeutrals,
  9652: CharacterType.otherNeutrals,
  9653: CharacterType.otherNeutrals,
  9654: CharacterType.otherNeutrals,
  9655: CharacterType.otherNeutrals,
  9656: CharacterType.otherNeutrals,
  9657: CharacterType.otherNeutrals,
  9658: CharacterType.otherNeutrals,
  9659: CharacterType.otherNeutrals,
  9660: CharacterType.otherNeutrals,
  9661: CharacterType.otherNeutrals,
  9662: CharacterType.otherNeutrals,
  9663: CharacterType.otherNeutrals,
  9664: CharacterType.otherNeutrals,
  9665: CharacterType.otherNeutrals,
  9666: CharacterType.otherNeutrals,
  9667: CharacterType.otherNeutrals,
  9668: CharacterType.otherNeutrals,
  9669: CharacterType.otherNeutrals,
  9670: CharacterType.otherNeutrals,
  9671: CharacterType.otherNeutrals,
  9672: CharacterType.otherNeutrals,
  9673: CharacterType.otherNeutrals,
  9674: CharacterType.otherNeutrals,
  9675: CharacterType.otherNeutrals,
  9676: CharacterType.otherNeutrals,
  9677: CharacterType.otherNeutrals,
  9678: CharacterType.otherNeutrals,
  9679: CharacterType.otherNeutrals,
  9680: CharacterType.otherNeutrals,
  9681: CharacterType.otherNeutrals,
  9682: CharacterType.otherNeutrals,
  9683: CharacterType.otherNeutrals,
  9684: CharacterType.otherNeutrals,
  9685: CharacterType.otherNeutrals,
  9686: CharacterType.otherNeutrals,
  9687: CharacterType.otherNeutrals,
  9688: CharacterType.otherNeutrals,
  9689: CharacterType.otherNeutrals,
  9690: CharacterType.otherNeutrals,
  9691: CharacterType.otherNeutrals,
  9692: CharacterType.otherNeutrals,
  9693: CharacterType.otherNeutrals,
  9694: CharacterType.otherNeutrals,
  9695: CharacterType.otherNeutrals,
  9696: CharacterType.otherNeutrals,
  9697: CharacterType.otherNeutrals,
  9698: CharacterType.otherNeutrals,
  9699: CharacterType.otherNeutrals,
  9700: CharacterType.otherNeutrals,
  9701: CharacterType.otherNeutrals,
  9702: CharacterType.otherNeutrals,
  9703: CharacterType.otherNeutrals,
  9704: CharacterType.otherNeutrals,
  9705: CharacterType.otherNeutrals,
  9706: CharacterType.otherNeutrals,
  9707: CharacterType.otherNeutrals,
  9708: CharacterType.otherNeutrals,
  9709: CharacterType.otherNeutrals,
  9710: CharacterType.otherNeutrals,
  9711: CharacterType.otherNeutrals,
  9712: CharacterType.otherNeutrals,
  9713: CharacterType.otherNeutrals,
  9714: CharacterType.otherNeutrals,
  9715: CharacterType.otherNeutrals,
  9716: CharacterType.otherNeutrals,
  9717: CharacterType.otherNeutrals,
  9718: CharacterType.otherNeutrals,
  9719: CharacterType.otherNeutrals,
  9720: CharacterType.otherNeutrals,
  9721: CharacterType.otherNeutrals,
  9722: CharacterType.otherNeutrals,
  9723: CharacterType.otherNeutrals,
  9724: CharacterType.otherNeutrals,
  9725: CharacterType.otherNeutrals,
  9726: CharacterType.otherNeutrals,
  9727: CharacterType.otherNeutrals,
  9728: CharacterType.otherNeutrals,
  9729: CharacterType.otherNeutrals,
  9730: CharacterType.otherNeutrals,
  9731: CharacterType.otherNeutrals,
  9732: CharacterType.otherNeutrals,
  9733: CharacterType.otherNeutrals,
  9734: CharacterType.otherNeutrals,
  9735: CharacterType.otherNeutrals,
  9736: CharacterType.otherNeutrals,
  9737: CharacterType.otherNeutrals,
  9738: CharacterType.otherNeutrals,
  9739: CharacterType.otherNeutrals,
  9740: CharacterType.otherNeutrals,
  9741: CharacterType.otherNeutrals,
  9742: CharacterType.otherNeutrals,
  9743: CharacterType.otherNeutrals,
  9744: CharacterType.otherNeutrals,
  9745: CharacterType.otherNeutrals,
  9746: CharacterType.otherNeutrals,
  9747: CharacterType.otherNeutrals,
  9748: CharacterType.otherNeutrals,
  9749: CharacterType.otherNeutrals,
  9750: CharacterType.otherNeutrals,
  9751: CharacterType.otherNeutrals,
  9752: CharacterType.otherNeutrals,
  9753: CharacterType.otherNeutrals,
  9754: CharacterType.otherNeutrals,
  9755: CharacterType.otherNeutrals,
  9756: CharacterType.otherNeutrals,
  9757: CharacterType.otherNeutrals,
  9758: CharacterType.otherNeutrals,
  9759: CharacterType.otherNeutrals,
  9760: CharacterType.otherNeutrals,
  9761: CharacterType.otherNeutrals,
  9762: CharacterType.otherNeutrals,
  9763: CharacterType.otherNeutrals,
  9764: CharacterType.otherNeutrals,
  9765: CharacterType.otherNeutrals,
  9766: CharacterType.otherNeutrals,
  9767: CharacterType.otherNeutrals,
  9768: CharacterType.otherNeutrals,
  9769: CharacterType.otherNeutrals,
  9770: CharacterType.otherNeutrals,
  9771: CharacterType.otherNeutrals,
  9772: CharacterType.otherNeutrals,
  9773: CharacterType.otherNeutrals,
  9774: CharacterType.otherNeutrals,
  9775: CharacterType.otherNeutrals,
  9776: CharacterType.otherNeutrals,
  9777: CharacterType.otherNeutrals,
  9778: CharacterType.otherNeutrals,
  9779: CharacterType.otherNeutrals,
  9780: CharacterType.otherNeutrals,
  9781: CharacterType.otherNeutrals,
  9782: CharacterType.otherNeutrals,
  9783: CharacterType.otherNeutrals,
  9784: CharacterType.otherNeutrals,
  9785: CharacterType.otherNeutrals,
  9786: CharacterType.otherNeutrals,
  9787: CharacterType.otherNeutrals,
  9788: CharacterType.otherNeutrals,
  9789: CharacterType.otherNeutrals,
  9790: CharacterType.otherNeutrals,
  9791: CharacterType.otherNeutrals,
  9792: CharacterType.otherNeutrals,
  9793: CharacterType.otherNeutrals,
  9794: CharacterType.otherNeutrals,
  9795: CharacterType.otherNeutrals,
  9796: CharacterType.otherNeutrals,
  9797: CharacterType.otherNeutrals,
  9798: CharacterType.otherNeutrals,
  9799: CharacterType.otherNeutrals,
  9800: CharacterType.otherNeutrals,
  9801: CharacterType.otherNeutrals,
  9802: CharacterType.otherNeutrals,
  9803: CharacterType.otherNeutrals,
  9804: CharacterType.otherNeutrals,
  9805: CharacterType.otherNeutrals,
  9806: CharacterType.otherNeutrals,
  9807: CharacterType.otherNeutrals,
  9808: CharacterType.otherNeutrals,
  9809: CharacterType.otherNeutrals,
  9810: CharacterType.otherNeutrals,
  9811: CharacterType.otherNeutrals,
  9812: CharacterType.otherNeutrals,
  9813: CharacterType.otherNeutrals,
  9814: CharacterType.otherNeutrals,
  9815: CharacterType.otherNeutrals,
  9816: CharacterType.otherNeutrals,
  9817: CharacterType.otherNeutrals,
  9818: CharacterType.otherNeutrals,
  9819: CharacterType.otherNeutrals,
  9820: CharacterType.otherNeutrals,
  9821: CharacterType.otherNeutrals,
  9822: CharacterType.otherNeutrals,
  9823: CharacterType.otherNeutrals,
  9824: CharacterType.otherNeutrals,
  9825: CharacterType.otherNeutrals,
  9826: CharacterType.otherNeutrals,
  9827: CharacterType.otherNeutrals,
  9828: CharacterType.otherNeutrals,
  9829: CharacterType.otherNeutrals,
  9830: CharacterType.otherNeutrals,
  9831: CharacterType.otherNeutrals,
  9832: CharacterType.otherNeutrals,
  9833: CharacterType.otherNeutrals,
  9834: CharacterType.otherNeutrals,
  9835: CharacterType.otherNeutrals,
  9836: CharacterType.otherNeutrals,
  9837: CharacterType.otherNeutrals,
  9838: CharacterType.otherNeutrals,
  9839: CharacterType.otherNeutrals,
  9840: CharacterType.otherNeutrals,
  9841: CharacterType.otherNeutrals,
  9842: CharacterType.otherNeutrals,
  9843: CharacterType.otherNeutrals,
  9844: CharacterType.otherNeutrals,
  9845: CharacterType.otherNeutrals,
  9846: CharacterType.otherNeutrals,
  9847: CharacterType.otherNeutrals,
  9848: CharacterType.otherNeutrals,
  9849: CharacterType.otherNeutrals,
  9850: CharacterType.otherNeutrals,
  9851: CharacterType.otherNeutrals,
  9852: CharacterType.otherNeutrals,
  9853: CharacterType.otherNeutrals,
  9854: CharacterType.otherNeutrals,
  9855: CharacterType.otherNeutrals,
  9856: CharacterType.otherNeutrals,
  9857: CharacterType.otherNeutrals,
  9858: CharacterType.otherNeutrals,
  9859: CharacterType.otherNeutrals,
  9860: CharacterType.otherNeutrals,
  9861: CharacterType.otherNeutrals,
  9862: CharacterType.otherNeutrals,
  9863: CharacterType.otherNeutrals,
  9864: CharacterType.otherNeutrals,
  9865: CharacterType.otherNeutrals,
  9866: CharacterType.otherNeutrals,
  9867: CharacterType.otherNeutrals,
  9868: CharacterType.otherNeutrals,
  9869: CharacterType.otherNeutrals,
  9870: CharacterType.otherNeutrals,
  9871: CharacterType.otherNeutrals,
  9872: CharacterType.otherNeutrals,
  9873: CharacterType.otherNeutrals,
  9874: CharacterType.otherNeutrals,
  9875: CharacterType.otherNeutrals,
  9876: CharacterType.otherNeutrals,
  9877: CharacterType.otherNeutrals,
  9878: CharacterType.otherNeutrals,
  9879: CharacterType.otherNeutrals,
  9880: CharacterType.otherNeutrals,
  9881: CharacterType.otherNeutrals,
  9882: CharacterType.otherNeutrals,
  9883: CharacterType.otherNeutrals,
  9884: CharacterType.otherNeutrals,
  9885: CharacterType.otherNeutrals,
  9886: CharacterType.otherNeutrals,
  9887: CharacterType.otherNeutrals,
  9888: CharacterType.otherNeutrals,
  9889: CharacterType.otherNeutrals,
  9890: CharacterType.otherNeutrals,
  9891: CharacterType.otherNeutrals,
  9892: CharacterType.otherNeutrals,
  9893: CharacterType.otherNeutrals,
  9894: CharacterType.otherNeutrals,
  9895: CharacterType.otherNeutrals,
  9896: CharacterType.otherNeutrals,
  9897: CharacterType.otherNeutrals,
  9898: CharacterType.otherNeutrals,
  9899: CharacterType.otherNeutrals,
  9901: CharacterType.otherNeutrals,
  9902: CharacterType.otherNeutrals,
  9903: CharacterType.otherNeutrals,
  9904: CharacterType.otherNeutrals,
  9905: CharacterType.otherNeutrals,
  9906: CharacterType.otherNeutrals,
  9907: CharacterType.otherNeutrals,
  9908: CharacterType.otherNeutrals,
  9909: CharacterType.otherNeutrals,
  9910: CharacterType.otherNeutrals,
  9911: CharacterType.otherNeutrals,
  9912: CharacterType.otherNeutrals,
  9913: CharacterType.otherNeutrals,
  9914: CharacterType.otherNeutrals,
  9915: CharacterType.otherNeutrals,
  9916: CharacterType.otherNeutrals,
  9917: CharacterType.otherNeutrals,
  9918: CharacterType.otherNeutrals,
  9919: CharacterType.otherNeutrals,
  9920: CharacterType.otherNeutrals,
  9921: CharacterType.otherNeutrals,
  9922: CharacterType.otherNeutrals,
  9923: CharacterType.otherNeutrals,
  9924: CharacterType.otherNeutrals,
  9925: CharacterType.otherNeutrals,
  9926: CharacterType.otherNeutrals,
  9927: CharacterType.otherNeutrals,
  9928: CharacterType.otherNeutrals,
  9929: CharacterType.otherNeutrals,
  9930: CharacterType.otherNeutrals,
  9931: CharacterType.otherNeutrals,
  9932: CharacterType.otherNeutrals,
  9933: CharacterType.otherNeutrals,
  9934: CharacterType.otherNeutrals,
  9935: CharacterType.otherNeutrals,
  9936: CharacterType.otherNeutrals,
  9937: CharacterType.otherNeutrals,
  9938: CharacterType.otherNeutrals,
  9939: CharacterType.otherNeutrals,
  9940: CharacterType.otherNeutrals,
  9941: CharacterType.otherNeutrals,
  9942: CharacterType.otherNeutrals,
  9943: CharacterType.otherNeutrals,
  9944: CharacterType.otherNeutrals,
  9945: CharacterType.otherNeutrals,
  9946: CharacterType.otherNeutrals,
  9947: CharacterType.otherNeutrals,
  9948: CharacterType.otherNeutrals,
  9949: CharacterType.otherNeutrals,
  9950: CharacterType.otherNeutrals,
  9951: CharacterType.otherNeutrals,
  9952: CharacterType.otherNeutrals,
  9953: CharacterType.otherNeutrals,
  9954: CharacterType.otherNeutrals,
  9955: CharacterType.otherNeutrals,
  9956: CharacterType.otherNeutrals,
  9957: CharacterType.otherNeutrals,
  9958: CharacterType.otherNeutrals,
  9959: CharacterType.otherNeutrals,
  9960: CharacterType.otherNeutrals,
  9961: CharacterType.otherNeutrals,
  9962: CharacterType.otherNeutrals,
  9963: CharacterType.otherNeutrals,
  9964: CharacterType.otherNeutrals,
  9965: CharacterType.otherNeutrals,
  9966: CharacterType.otherNeutrals,
  9967: CharacterType.otherNeutrals,
  9968: CharacterType.otherNeutrals,
  9969: CharacterType.otherNeutrals,
  9970: CharacterType.otherNeutrals,
  9971: CharacterType.otherNeutrals,
  9972: CharacterType.otherNeutrals,
  9973: CharacterType.otherNeutrals,
  9974: CharacterType.otherNeutrals,
  9975: CharacterType.otherNeutrals,
  9976: CharacterType.otherNeutrals,
  9977: CharacterType.otherNeutrals,
  9978: CharacterType.otherNeutrals,
  9979: CharacterType.otherNeutrals,
  9980: CharacterType.otherNeutrals,
  9981: CharacterType.otherNeutrals,
  9982: CharacterType.otherNeutrals,
  9983: CharacterType.otherNeutrals,
  9984: CharacterType.otherNeutrals,
  9985: CharacterType.otherNeutrals,
  9986: CharacterType.otherNeutrals,
  9987: CharacterType.otherNeutrals,
  9988: CharacterType.otherNeutrals,
  9989: CharacterType.otherNeutrals,
  9990: CharacterType.otherNeutrals,
  9991: CharacterType.otherNeutrals,
  9992: CharacterType.otherNeutrals,
  9993: CharacterType.otherNeutrals,
  9994: CharacterType.otherNeutrals,
  9995: CharacterType.otherNeutrals,
  9996: CharacterType.otherNeutrals,
  9997: CharacterType.otherNeutrals,
  9998: CharacterType.otherNeutrals,
  9999: CharacterType.otherNeutrals,
  10000: CharacterType.otherNeutrals,
  10001: CharacterType.otherNeutrals,
  10002: CharacterType.otherNeutrals,
  10003: CharacterType.otherNeutrals,
  10004: CharacterType.otherNeutrals,
  10005: CharacterType.otherNeutrals,
  10006: CharacterType.otherNeutrals,
  10007: CharacterType.otherNeutrals,
  10008: CharacterType.otherNeutrals,
  10009: CharacterType.otherNeutrals,
  10010: CharacterType.otherNeutrals,
  10011: CharacterType.otherNeutrals,
  10012: CharacterType.otherNeutrals,
  10013: CharacterType.otherNeutrals,
  10014: CharacterType.otherNeutrals,
  10015: CharacterType.otherNeutrals,
  10016: CharacterType.otherNeutrals,
  10017: CharacterType.otherNeutrals,
  10018: CharacterType.otherNeutrals,
  10019: CharacterType.otherNeutrals,
  10020: CharacterType.otherNeutrals,
  10021: CharacterType.otherNeutrals,
  10022: CharacterType.otherNeutrals,
  10023: CharacterType.otherNeutrals,
  10024: CharacterType.otherNeutrals,
  10025: CharacterType.otherNeutrals,
  10026: CharacterType.otherNeutrals,
  10027: CharacterType.otherNeutrals,
  10028: CharacterType.otherNeutrals,
  10029: CharacterType.otherNeutrals,
  10030: CharacterType.otherNeutrals,
  10031: CharacterType.otherNeutrals,
  10032: CharacterType.otherNeutrals,
  10033: CharacterType.otherNeutrals,
  10034: CharacterType.otherNeutrals,
  10035: CharacterType.otherNeutrals,
  10036: CharacterType.otherNeutrals,
  10037: CharacterType.otherNeutrals,
  10038: CharacterType.otherNeutrals,
  10039: CharacterType.otherNeutrals,
  10040: CharacterType.otherNeutrals,
  10041: CharacterType.otherNeutrals,
  10042: CharacterType.otherNeutrals,
  10043: CharacterType.otherNeutrals,
  10044: CharacterType.otherNeutrals,
  10045: CharacterType.otherNeutrals,
  10046: CharacterType.otherNeutrals,
  10047: CharacterType.otherNeutrals,
  10048: CharacterType.otherNeutrals,
  10049: CharacterType.otherNeutrals,
  10050: CharacterType.otherNeutrals,
  10051: CharacterType.otherNeutrals,
  10052: CharacterType.otherNeutrals,
  10053: CharacterType.otherNeutrals,
  10054: CharacterType.otherNeutrals,
  10055: CharacterType.otherNeutrals,
  10056: CharacterType.otherNeutrals,
  10057: CharacterType.otherNeutrals,
  10058: CharacterType.otherNeutrals,
  10059: CharacterType.otherNeutrals,
  10060: CharacterType.otherNeutrals,
  10061: CharacterType.otherNeutrals,
  10062: CharacterType.otherNeutrals,
  10063: CharacterType.otherNeutrals,
  10064: CharacterType.otherNeutrals,
  10065: CharacterType.otherNeutrals,
  10066: CharacterType.otherNeutrals,
  10067: CharacterType.otherNeutrals,
  10068: CharacterType.otherNeutrals,
  10069: CharacterType.otherNeutrals,
  10070: CharacterType.otherNeutrals,
  10071: CharacterType.otherNeutrals,
  10072: CharacterType.otherNeutrals,
  10073: CharacterType.otherNeutrals,
  10074: CharacterType.otherNeutrals,
  10075: CharacterType.otherNeutrals,
  10076: CharacterType.otherNeutrals,
  10077: CharacterType.otherNeutrals,
  10078: CharacterType.otherNeutrals,
  10079: CharacterType.otherNeutrals,
  10080: CharacterType.otherNeutrals,
  10081: CharacterType.otherNeutrals,
  10082: CharacterType.otherNeutrals,
  10083: CharacterType.otherNeutrals,
  10084: CharacterType.otherNeutrals,
  10085: CharacterType.otherNeutrals,
  10086: CharacterType.otherNeutrals,
  10087: CharacterType.otherNeutrals,
  10088: CharacterType.otherNeutrals,
  10089: CharacterType.otherNeutrals,
  10090: CharacterType.otherNeutrals,
  10091: CharacterType.otherNeutrals,
  10092: CharacterType.otherNeutrals,
  10093: CharacterType.otherNeutrals,
  10094: CharacterType.otherNeutrals,
  10095: CharacterType.otherNeutrals,
  10096: CharacterType.otherNeutrals,
  10097: CharacterType.otherNeutrals,
  10098: CharacterType.otherNeutrals,
  10099: CharacterType.otherNeutrals,
  10100: CharacterType.otherNeutrals,
  10101: CharacterType.otherNeutrals,
  10102: CharacterType.otherNeutrals,
  10103: CharacterType.otherNeutrals,
  10104: CharacterType.otherNeutrals,
  10105: CharacterType.otherNeutrals,
  10106: CharacterType.otherNeutrals,
  10107: CharacterType.otherNeutrals,
  10108: CharacterType.otherNeutrals,
  10109: CharacterType.otherNeutrals,
  10110: CharacterType.otherNeutrals,
  10111: CharacterType.otherNeutrals,
  10112: CharacterType.otherNeutrals,
  10113: CharacterType.otherNeutrals,
  10114: CharacterType.otherNeutrals,
  10115: CharacterType.otherNeutrals,
  10116: CharacterType.otherNeutrals,
  10117: CharacterType.otherNeutrals,
  10118: CharacterType.otherNeutrals,
  10119: CharacterType.otherNeutrals,
  10120: CharacterType.otherNeutrals,
  10121: CharacterType.otherNeutrals,
  10122: CharacterType.otherNeutrals,
  10123: CharacterType.otherNeutrals,
  10124: CharacterType.otherNeutrals,
  10125: CharacterType.otherNeutrals,
  10126: CharacterType.otherNeutrals,
  10127: CharacterType.otherNeutrals,
  10128: CharacterType.otherNeutrals,
  10129: CharacterType.otherNeutrals,
  10130: CharacterType.otherNeutrals,
  10131: CharacterType.otherNeutrals,
  10132: CharacterType.otherNeutrals,
  10133: CharacterType.otherNeutrals,
  10134: CharacterType.otherNeutrals,
  10135: CharacterType.otherNeutrals,
  10136: CharacterType.otherNeutrals,
  10137: CharacterType.otherNeutrals,
  10138: CharacterType.otherNeutrals,
  10139: CharacterType.otherNeutrals,
  10140: CharacterType.otherNeutrals,
  10141: CharacterType.otherNeutrals,
  10142: CharacterType.otherNeutrals,
  10143: CharacterType.otherNeutrals,
  10144: CharacterType.otherNeutrals,
  10145: CharacterType.otherNeutrals,
  10146: CharacterType.otherNeutrals,
  10147: CharacterType.otherNeutrals,
  10148: CharacterType.otherNeutrals,
  10149: CharacterType.otherNeutrals,
  10150: CharacterType.otherNeutrals,
  10151: CharacterType.otherNeutrals,
  10152: CharacterType.otherNeutrals,
  10153: CharacterType.otherNeutrals,
  10154: CharacterType.otherNeutrals,
  10155: CharacterType.otherNeutrals,
  10156: CharacterType.otherNeutrals,
  10157: CharacterType.otherNeutrals,
  10158: CharacterType.otherNeutrals,
  10159: CharacterType.otherNeutrals,
  10160: CharacterType.otherNeutrals,
  10161: CharacterType.otherNeutrals,
  10162: CharacterType.otherNeutrals,
  10163: CharacterType.otherNeutrals,
  10164: CharacterType.otherNeutrals,
  10165: CharacterType.otherNeutrals,
  10166: CharacterType.otherNeutrals,
  10167: CharacterType.otherNeutrals,
  10168: CharacterType.otherNeutrals,
  10169: CharacterType.otherNeutrals,
  10170: CharacterType.otherNeutrals,
  10171: CharacterType.otherNeutrals,
  10172: CharacterType.otherNeutrals,
  10173: CharacterType.otherNeutrals,
  10174: CharacterType.otherNeutrals,
  10175: CharacterType.otherNeutrals,
  10176: CharacterType.otherNeutrals,
  10177: CharacterType.otherNeutrals,
  10178: CharacterType.otherNeutrals,
  10179: CharacterType.otherNeutrals,
  10180: CharacterType.otherNeutrals,
  10181: CharacterType.otherNeutrals,
  10182: CharacterType.otherNeutrals,
  10183: CharacterType.otherNeutrals,
  10184: CharacterType.otherNeutrals,
  10185: CharacterType.otherNeutrals,
  10186: CharacterType.otherNeutrals,
  10187: CharacterType.otherNeutrals,
  10188: CharacterType.otherNeutrals,
  10189: CharacterType.otherNeutrals,
  10190: CharacterType.otherNeutrals,
  10191: CharacterType.otherNeutrals,
  10192: CharacterType.otherNeutrals,
  10193: CharacterType.otherNeutrals,
  10194: CharacterType.otherNeutrals,
  10195: CharacterType.otherNeutrals,
  10196: CharacterType.otherNeutrals,
  10197: CharacterType.otherNeutrals,
  10198: CharacterType.otherNeutrals,
  10199: CharacterType.otherNeutrals,
  10200: CharacterType.otherNeutrals,
  10201: CharacterType.otherNeutrals,
  10202: CharacterType.otherNeutrals,
  10203: CharacterType.otherNeutrals,
  10204: CharacterType.otherNeutrals,
  10205: CharacterType.otherNeutrals,
  10206: CharacterType.otherNeutrals,
  10207: CharacterType.otherNeutrals,
  10208: CharacterType.otherNeutrals,
  10209: CharacterType.otherNeutrals,
  10210: CharacterType.otherNeutrals,
  10211: CharacterType.otherNeutrals,
  10212: CharacterType.otherNeutrals,
  10213: CharacterType.otherNeutrals,
  10214: CharacterType.otherNeutrals,
  10215: CharacterType.otherNeutrals,
  10216: CharacterType.otherNeutrals,
  10217: CharacterType.otherNeutrals,
  10218: CharacterType.otherNeutrals,
  10219: CharacterType.otherNeutrals,
  10220: CharacterType.otherNeutrals,
  10221: CharacterType.otherNeutrals,
  10222: CharacterType.otherNeutrals,
  10223: CharacterType.otherNeutrals,
  10224: CharacterType.otherNeutrals,
  10225: CharacterType.otherNeutrals,
  10226: CharacterType.otherNeutrals,
  10227: CharacterType.otherNeutrals,
  10228: CharacterType.otherNeutrals,
  10229: CharacterType.otherNeutrals,
  10230: CharacterType.otherNeutrals,
  10231: CharacterType.otherNeutrals,
  10232: CharacterType.otherNeutrals,
  10233: CharacterType.otherNeutrals,
  10234: CharacterType.otherNeutrals,
  10235: CharacterType.otherNeutrals,
  10236: CharacterType.otherNeutrals,
  10237: CharacterType.otherNeutrals,
  10238: CharacterType.otherNeutrals,
  10239: CharacterType.otherNeutrals,
  10496: CharacterType.otherNeutrals,
  10497: CharacterType.otherNeutrals,
  10498: CharacterType.otherNeutrals,
  10499: CharacterType.otherNeutrals,
  10500: CharacterType.otherNeutrals,
  10501: CharacterType.otherNeutrals,
  10502: CharacterType.otherNeutrals,
  10503: CharacterType.otherNeutrals,
  10504: CharacterType.otherNeutrals,
  10505: CharacterType.otherNeutrals,
  10506: CharacterType.otherNeutrals,
  10507: CharacterType.otherNeutrals,
  10508: CharacterType.otherNeutrals,
  10509: CharacterType.otherNeutrals,
  10510: CharacterType.otherNeutrals,
  10511: CharacterType.otherNeutrals,
  10512: CharacterType.otherNeutrals,
  10513: CharacterType.otherNeutrals,
  10514: CharacterType.otherNeutrals,
  10515: CharacterType.otherNeutrals,
  10516: CharacterType.otherNeutrals,
  10517: CharacterType.otherNeutrals,
  10518: CharacterType.otherNeutrals,
  10519: CharacterType.otherNeutrals,
  10520: CharacterType.otherNeutrals,
  10521: CharacterType.otherNeutrals,
  10522: CharacterType.otherNeutrals,
  10523: CharacterType.otherNeutrals,
  10524: CharacterType.otherNeutrals,
  10525: CharacterType.otherNeutrals,
  10526: CharacterType.otherNeutrals,
  10527: CharacterType.otherNeutrals,
  10528: CharacterType.otherNeutrals,
  10529: CharacterType.otherNeutrals,
  10530: CharacterType.otherNeutrals,
  10531: CharacterType.otherNeutrals,
  10532: CharacterType.otherNeutrals,
  10533: CharacterType.otherNeutrals,
  10534: CharacterType.otherNeutrals,
  10535: CharacterType.otherNeutrals,
  10536: CharacterType.otherNeutrals,
  10537: CharacterType.otherNeutrals,
  10538: CharacterType.otherNeutrals,
  10539: CharacterType.otherNeutrals,
  10540: CharacterType.otherNeutrals,
  10541: CharacterType.otherNeutrals,
  10542: CharacterType.otherNeutrals,
  10543: CharacterType.otherNeutrals,
  10544: CharacterType.otherNeutrals,
  10545: CharacterType.otherNeutrals,
  10546: CharacterType.otherNeutrals,
  10547: CharacterType.otherNeutrals,
  10548: CharacterType.otherNeutrals,
  10549: CharacterType.otherNeutrals,
  10550: CharacterType.otherNeutrals,
  10551: CharacterType.otherNeutrals,
  10552: CharacterType.otherNeutrals,
  10553: CharacterType.otherNeutrals,
  10554: CharacterType.otherNeutrals,
  10555: CharacterType.otherNeutrals,
  10556: CharacterType.otherNeutrals,
  10557: CharacterType.otherNeutrals,
  10558: CharacterType.otherNeutrals,
  10559: CharacterType.otherNeutrals,
  10560: CharacterType.otherNeutrals,
  10561: CharacterType.otherNeutrals,
  10562: CharacterType.otherNeutrals,
  10563: CharacterType.otherNeutrals,
  10564: CharacterType.otherNeutrals,
  10565: CharacterType.otherNeutrals,
  10566: CharacterType.otherNeutrals,
  10567: CharacterType.otherNeutrals,
  10568: CharacterType.otherNeutrals,
  10569: CharacterType.otherNeutrals,
  10570: CharacterType.otherNeutrals,
  10571: CharacterType.otherNeutrals,
  10572: CharacterType.otherNeutrals,
  10573: CharacterType.otherNeutrals,
  10574: CharacterType.otherNeutrals,
  10575: CharacterType.otherNeutrals,
  10576: CharacterType.otherNeutrals,
  10577: CharacterType.otherNeutrals,
  10578: CharacterType.otherNeutrals,
  10579: CharacterType.otherNeutrals,
  10580: CharacterType.otherNeutrals,
  10581: CharacterType.otherNeutrals,
  10582: CharacterType.otherNeutrals,
  10583: CharacterType.otherNeutrals,
  10584: CharacterType.otherNeutrals,
  10585: CharacterType.otherNeutrals,
  10586: CharacterType.otherNeutrals,
  10587: CharacterType.otherNeutrals,
  10588: CharacterType.otherNeutrals,
  10589: CharacterType.otherNeutrals,
  10590: CharacterType.otherNeutrals,
  10591: CharacterType.otherNeutrals,
  10592: CharacterType.otherNeutrals,
  10593: CharacterType.otherNeutrals,
  10594: CharacterType.otherNeutrals,
  10595: CharacterType.otherNeutrals,
  10596: CharacterType.otherNeutrals,
  10597: CharacterType.otherNeutrals,
  10598: CharacterType.otherNeutrals,
  10599: CharacterType.otherNeutrals,
  10600: CharacterType.otherNeutrals,
  10601: CharacterType.otherNeutrals,
  10602: CharacterType.otherNeutrals,
  10603: CharacterType.otherNeutrals,
  10604: CharacterType.otherNeutrals,
  10605: CharacterType.otherNeutrals,
  10606: CharacterType.otherNeutrals,
  10607: CharacterType.otherNeutrals,
  10608: CharacterType.otherNeutrals,
  10609: CharacterType.otherNeutrals,
  10610: CharacterType.otherNeutrals,
  10611: CharacterType.otherNeutrals,
  10612: CharacterType.otherNeutrals,
  10613: CharacterType.otherNeutrals,
  10614: CharacterType.otherNeutrals,
  10615: CharacterType.otherNeutrals,
  10616: CharacterType.otherNeutrals,
  10617: CharacterType.otherNeutrals,
  10618: CharacterType.otherNeutrals,
  10619: CharacterType.otherNeutrals,
  10620: CharacterType.otherNeutrals,
  10621: CharacterType.otherNeutrals,
  10622: CharacterType.otherNeutrals,
  10623: CharacterType.otherNeutrals,
  10624: CharacterType.otherNeutrals,
  10625: CharacterType.otherNeutrals,
  10626: CharacterType.otherNeutrals,
  10627: CharacterType.otherNeutrals,
  10628: CharacterType.otherNeutrals,
  10629: CharacterType.otherNeutrals,
  10630: CharacterType.otherNeutrals,
  10631: CharacterType.otherNeutrals,
  10632: CharacterType.otherNeutrals,
  10633: CharacterType.otherNeutrals,
  10634: CharacterType.otherNeutrals,
  10635: CharacterType.otherNeutrals,
  10636: CharacterType.otherNeutrals,
  10637: CharacterType.otherNeutrals,
  10638: CharacterType.otherNeutrals,
  10639: CharacterType.otherNeutrals,
  10640: CharacterType.otherNeutrals,
  10641: CharacterType.otherNeutrals,
  10642: CharacterType.otherNeutrals,
  10643: CharacterType.otherNeutrals,
  10644: CharacterType.otherNeutrals,
  10645: CharacterType.otherNeutrals,
  10646: CharacterType.otherNeutrals,
  10647: CharacterType.otherNeutrals,
  10648: CharacterType.otherNeutrals,
  10649: CharacterType.otherNeutrals,
  10650: CharacterType.otherNeutrals,
  10651: CharacterType.otherNeutrals,
  10652: CharacterType.otherNeutrals,
  10653: CharacterType.otherNeutrals,
  10654: CharacterType.otherNeutrals,
  10655: CharacterType.otherNeutrals,
  10656: CharacterType.otherNeutrals,
  10657: CharacterType.otherNeutrals,
  10658: CharacterType.otherNeutrals,
  10659: CharacterType.otherNeutrals,
  10660: CharacterType.otherNeutrals,
  10661: CharacterType.otherNeutrals,
  10662: CharacterType.otherNeutrals,
  10663: CharacterType.otherNeutrals,
  10664: CharacterType.otherNeutrals,
  10665: CharacterType.otherNeutrals,
  10666: CharacterType.otherNeutrals,
  10667: CharacterType.otherNeutrals,
  10668: CharacterType.otherNeutrals,
  10669: CharacterType.otherNeutrals,
  10670: CharacterType.otherNeutrals,
  10671: CharacterType.otherNeutrals,
  10672: CharacterType.otherNeutrals,
  10673: CharacterType.otherNeutrals,
  10674: CharacterType.otherNeutrals,
  10675: CharacterType.otherNeutrals,
  10676: CharacterType.otherNeutrals,
  10677: CharacterType.otherNeutrals,
  10678: CharacterType.otherNeutrals,
  10679: CharacterType.otherNeutrals,
  10680: CharacterType.otherNeutrals,
  10681: CharacterType.otherNeutrals,
  10682: CharacterType.otherNeutrals,
  10683: CharacterType.otherNeutrals,
  10684: CharacterType.otherNeutrals,
  10685: CharacterType.otherNeutrals,
  10686: CharacterType.otherNeutrals,
  10687: CharacterType.otherNeutrals,
  10688: CharacterType.otherNeutrals,
  10689: CharacterType.otherNeutrals,
  10690: CharacterType.otherNeutrals,
  10691: CharacterType.otherNeutrals,
  10692: CharacterType.otherNeutrals,
  10693: CharacterType.otherNeutrals,
  10694: CharacterType.otherNeutrals,
  10695: CharacterType.otherNeutrals,
  10696: CharacterType.otherNeutrals,
  10697: CharacterType.otherNeutrals,
  10698: CharacterType.otherNeutrals,
  10699: CharacterType.otherNeutrals,
  10700: CharacterType.otherNeutrals,
  10701: CharacterType.otherNeutrals,
  10702: CharacterType.otherNeutrals,
  10703: CharacterType.otherNeutrals,
  10704: CharacterType.otherNeutrals,
  10705: CharacterType.otherNeutrals,
  10706: CharacterType.otherNeutrals,
  10707: CharacterType.otherNeutrals,
  10708: CharacterType.otherNeutrals,
  10709: CharacterType.otherNeutrals,
  10710: CharacterType.otherNeutrals,
  10711: CharacterType.otherNeutrals,
  10712: CharacterType.otherNeutrals,
  10713: CharacterType.otherNeutrals,
  10714: CharacterType.otherNeutrals,
  10715: CharacterType.otherNeutrals,
  10716: CharacterType.otherNeutrals,
  10717: CharacterType.otherNeutrals,
  10718: CharacterType.otherNeutrals,
  10719: CharacterType.otherNeutrals,
  10720: CharacterType.otherNeutrals,
  10721: CharacterType.otherNeutrals,
  10722: CharacterType.otherNeutrals,
  10723: CharacterType.otherNeutrals,
  10724: CharacterType.otherNeutrals,
  10725: CharacterType.otherNeutrals,
  10726: CharacterType.otherNeutrals,
  10727: CharacterType.otherNeutrals,
  10728: CharacterType.otherNeutrals,
  10729: CharacterType.otherNeutrals,
  10730: CharacterType.otherNeutrals,
  10731: CharacterType.otherNeutrals,
  10732: CharacterType.otherNeutrals,
  10733: CharacterType.otherNeutrals,
  10734: CharacterType.otherNeutrals,
  10735: CharacterType.otherNeutrals,
  10736: CharacterType.otherNeutrals,
  10737: CharacterType.otherNeutrals,
  10738: CharacterType.otherNeutrals,
  10739: CharacterType.otherNeutrals,
  10740: CharacterType.otherNeutrals,
  10741: CharacterType.otherNeutrals,
  10742: CharacterType.otherNeutrals,
  10743: CharacterType.otherNeutrals,
  10744: CharacterType.otherNeutrals,
  10745: CharacterType.otherNeutrals,
  10746: CharacterType.otherNeutrals,
  10747: CharacterType.otherNeutrals,
  10748: CharacterType.otherNeutrals,
  10749: CharacterType.otherNeutrals,
  10750: CharacterType.otherNeutrals,
  10751: CharacterType.otherNeutrals,
  10752: CharacterType.otherNeutrals,
  10753: CharacterType.otherNeutrals,
  10754: CharacterType.otherNeutrals,
  10755: CharacterType.otherNeutrals,
  10756: CharacterType.otherNeutrals,
  10757: CharacterType.otherNeutrals,
  10758: CharacterType.otherNeutrals,
  10759: CharacterType.otherNeutrals,
  10760: CharacterType.otherNeutrals,
  10761: CharacterType.otherNeutrals,
  10762: CharacterType.otherNeutrals,
  10763: CharacterType.otherNeutrals,
  10764: CharacterType.otherNeutrals,
  10765: CharacterType.otherNeutrals,
  10766: CharacterType.otherNeutrals,
  10767: CharacterType.otherNeutrals,
  10768: CharacterType.otherNeutrals,
  10769: CharacterType.otherNeutrals,
  10770: CharacterType.otherNeutrals,
  10771: CharacterType.otherNeutrals,
  10772: CharacterType.otherNeutrals,
  10773: CharacterType.otherNeutrals,
  10774: CharacterType.otherNeutrals,
  10775: CharacterType.otherNeutrals,
  10776: CharacterType.otherNeutrals,
  10777: CharacterType.otherNeutrals,
  10778: CharacterType.otherNeutrals,
  10779: CharacterType.otherNeutrals,
  10780: CharacterType.otherNeutrals,
  10781: CharacterType.otherNeutrals,
  10782: CharacterType.otherNeutrals,
  10783: CharacterType.otherNeutrals,
  10784: CharacterType.otherNeutrals,
  10785: CharacterType.otherNeutrals,
  10786: CharacterType.otherNeutrals,
  10787: CharacterType.otherNeutrals,
  10788: CharacterType.otherNeutrals,
  10789: CharacterType.otherNeutrals,
  10790: CharacterType.otherNeutrals,
  10791: CharacterType.otherNeutrals,
  10792: CharacterType.otherNeutrals,
  10793: CharacterType.otherNeutrals,
  10794: CharacterType.otherNeutrals,
  10795: CharacterType.otherNeutrals,
  10796: CharacterType.otherNeutrals,
  10797: CharacterType.otherNeutrals,
  10798: CharacterType.otherNeutrals,
  10799: CharacterType.otherNeutrals,
  10800: CharacterType.otherNeutrals,
  10801: CharacterType.otherNeutrals,
  10802: CharacterType.otherNeutrals,
  10803: CharacterType.otherNeutrals,
  10804: CharacterType.otherNeutrals,
  10805: CharacterType.otherNeutrals,
  10806: CharacterType.otherNeutrals,
  10807: CharacterType.otherNeutrals,
  10808: CharacterType.otherNeutrals,
  10809: CharacterType.otherNeutrals,
  10810: CharacterType.otherNeutrals,
  10811: CharacterType.otherNeutrals,
  10812: CharacterType.otherNeutrals,
  10813: CharacterType.otherNeutrals,
  10814: CharacterType.otherNeutrals,
  10815: CharacterType.otherNeutrals,
  10816: CharacterType.otherNeutrals,
  10817: CharacterType.otherNeutrals,
  10818: CharacterType.otherNeutrals,
  10819: CharacterType.otherNeutrals,
  10820: CharacterType.otherNeutrals,
  10821: CharacterType.otherNeutrals,
  10822: CharacterType.otherNeutrals,
  10823: CharacterType.otherNeutrals,
  10824: CharacterType.otherNeutrals,
  10825: CharacterType.otherNeutrals,
  10826: CharacterType.otherNeutrals,
  10827: CharacterType.otherNeutrals,
  10828: CharacterType.otherNeutrals,
  10829: CharacterType.otherNeutrals,
  10830: CharacterType.otherNeutrals,
  10831: CharacterType.otherNeutrals,
  10832: CharacterType.otherNeutrals,
  10833: CharacterType.otherNeutrals,
  10834: CharacterType.otherNeutrals,
  10835: CharacterType.otherNeutrals,
  10836: CharacterType.otherNeutrals,
  10837: CharacterType.otherNeutrals,
  10838: CharacterType.otherNeutrals,
  10839: CharacterType.otherNeutrals,
  10840: CharacterType.otherNeutrals,
  10841: CharacterType.otherNeutrals,
  10842: CharacterType.otherNeutrals,
  10843: CharacterType.otherNeutrals,
  10844: CharacterType.otherNeutrals,
  10845: CharacterType.otherNeutrals,
  10846: CharacterType.otherNeutrals,
  10847: CharacterType.otherNeutrals,
  10848: CharacterType.otherNeutrals,
  10849: CharacterType.otherNeutrals,
  10850: CharacterType.otherNeutrals,
  10851: CharacterType.otherNeutrals,
  10852: CharacterType.otherNeutrals,
  10853: CharacterType.otherNeutrals,
  10854: CharacterType.otherNeutrals,
  10855: CharacterType.otherNeutrals,
  10856: CharacterType.otherNeutrals,
  10857: CharacterType.otherNeutrals,
  10858: CharacterType.otherNeutrals,
  10859: CharacterType.otherNeutrals,
  10860: CharacterType.otherNeutrals,
  10861: CharacterType.otherNeutrals,
  10862: CharacterType.otherNeutrals,
  10863: CharacterType.otherNeutrals,
  10864: CharacterType.otherNeutrals,
  10865: CharacterType.otherNeutrals,
  10866: CharacterType.otherNeutrals,
  10867: CharacterType.otherNeutrals,
  10868: CharacterType.otherNeutrals,
  10869: CharacterType.otherNeutrals,
  10870: CharacterType.otherNeutrals,
  10871: CharacterType.otherNeutrals,
  10872: CharacterType.otherNeutrals,
  10873: CharacterType.otherNeutrals,
  10874: CharacterType.otherNeutrals,
  10875: CharacterType.otherNeutrals,
  10876: CharacterType.otherNeutrals,
  10877: CharacterType.otherNeutrals,
  10878: CharacterType.otherNeutrals,
  10879: CharacterType.otherNeutrals,
  10880: CharacterType.otherNeutrals,
  10881: CharacterType.otherNeutrals,
  10882: CharacterType.otherNeutrals,
  10883: CharacterType.otherNeutrals,
  10884: CharacterType.otherNeutrals,
  10885: CharacterType.otherNeutrals,
  10886: CharacterType.otherNeutrals,
  10887: CharacterType.otherNeutrals,
  10888: CharacterType.otherNeutrals,
  10889: CharacterType.otherNeutrals,
  10890: CharacterType.otherNeutrals,
  10891: CharacterType.otherNeutrals,
  10892: CharacterType.otherNeutrals,
  10893: CharacterType.otherNeutrals,
  10894: CharacterType.otherNeutrals,
  10895: CharacterType.otherNeutrals,
  10896: CharacterType.otherNeutrals,
  10897: CharacterType.otherNeutrals,
  10898: CharacterType.otherNeutrals,
  10899: CharacterType.otherNeutrals,
  10900: CharacterType.otherNeutrals,
  10901: CharacterType.otherNeutrals,
  10902: CharacterType.otherNeutrals,
  10903: CharacterType.otherNeutrals,
  10904: CharacterType.otherNeutrals,
  10905: CharacterType.otherNeutrals,
  10906: CharacterType.otherNeutrals,
  10907: CharacterType.otherNeutrals,
  10908: CharacterType.otherNeutrals,
  10909: CharacterType.otherNeutrals,
  10910: CharacterType.otherNeutrals,
  10911: CharacterType.otherNeutrals,
  10912: CharacterType.otherNeutrals,
  10913: CharacterType.otherNeutrals,
  10914: CharacterType.otherNeutrals,
  10915: CharacterType.otherNeutrals,
  10916: CharacterType.otherNeutrals,
  10917: CharacterType.otherNeutrals,
  10918: CharacterType.otherNeutrals,
  10919: CharacterType.otherNeutrals,
  10920: CharacterType.otherNeutrals,
  10921: CharacterType.otherNeutrals,
  10922: CharacterType.otherNeutrals,
  10923: CharacterType.otherNeutrals,
  10924: CharacterType.otherNeutrals,
  10925: CharacterType.otherNeutrals,
  10926: CharacterType.otherNeutrals,
  10927: CharacterType.otherNeutrals,
  10928: CharacterType.otherNeutrals,
  10929: CharacterType.otherNeutrals,
  10930: CharacterType.otherNeutrals,
  10931: CharacterType.otherNeutrals,
  10932: CharacterType.otherNeutrals,
  10933: CharacterType.otherNeutrals,
  10934: CharacterType.otherNeutrals,
  10935: CharacterType.otherNeutrals,
  10936: CharacterType.otherNeutrals,
  10937: CharacterType.otherNeutrals,
  10938: CharacterType.otherNeutrals,
  10939: CharacterType.otherNeutrals,
  10940: CharacterType.otherNeutrals,
  10941: CharacterType.otherNeutrals,
  10942: CharacterType.otherNeutrals,
  10943: CharacterType.otherNeutrals,
  10944: CharacterType.otherNeutrals,
  10945: CharacterType.otherNeutrals,
  10946: CharacterType.otherNeutrals,
  10947: CharacterType.otherNeutrals,
  10948: CharacterType.otherNeutrals,
  10949: CharacterType.otherNeutrals,
  10950: CharacterType.otherNeutrals,
  10951: CharacterType.otherNeutrals,
  10952: CharacterType.otherNeutrals,
  10953: CharacterType.otherNeutrals,
  10954: CharacterType.otherNeutrals,
  10955: CharacterType.otherNeutrals,
  10956: CharacterType.otherNeutrals,
  10957: CharacterType.otherNeutrals,
  10958: CharacterType.otherNeutrals,
  10959: CharacterType.otherNeutrals,
  10960: CharacterType.otherNeutrals,
  10961: CharacterType.otherNeutrals,
  10962: CharacterType.otherNeutrals,
  10963: CharacterType.otherNeutrals,
  10964: CharacterType.otherNeutrals,
  10965: CharacterType.otherNeutrals,
  10966: CharacterType.otherNeutrals,
  10967: CharacterType.otherNeutrals,
  10968: CharacterType.otherNeutrals,
  10969: CharacterType.otherNeutrals,
  10970: CharacterType.otherNeutrals,
  10971: CharacterType.otherNeutrals,
  10972: CharacterType.otherNeutrals,
  10973: CharacterType.otherNeutrals,
  10974: CharacterType.otherNeutrals,
  10975: CharacterType.otherNeutrals,
  10976: CharacterType.otherNeutrals,
  10977: CharacterType.otherNeutrals,
  10978: CharacterType.otherNeutrals,
  10979: CharacterType.otherNeutrals,
  10980: CharacterType.otherNeutrals,
  10981: CharacterType.otherNeutrals,
  10982: CharacterType.otherNeutrals,
  10983: CharacterType.otherNeutrals,
  10984: CharacterType.otherNeutrals,
  10985: CharacterType.otherNeutrals,
  10986: CharacterType.otherNeutrals,
  10987: CharacterType.otherNeutrals,
  10988: CharacterType.otherNeutrals,
  10989: CharacterType.otherNeutrals,
  10990: CharacterType.otherNeutrals,
  10991: CharacterType.otherNeutrals,
  10992: CharacterType.otherNeutrals,
  10993: CharacterType.otherNeutrals,
  10994: CharacterType.otherNeutrals,
  10995: CharacterType.otherNeutrals,
  10996: CharacterType.otherNeutrals,
  10997: CharacterType.otherNeutrals,
  10998: CharacterType.otherNeutrals,
  10999: CharacterType.otherNeutrals,
  11000: CharacterType.otherNeutrals,
  11001: CharacterType.otherNeutrals,
  11002: CharacterType.otherNeutrals,
  11003: CharacterType.otherNeutrals,
  11004: CharacterType.otherNeutrals,
  11005: CharacterType.otherNeutrals,
  11006: CharacterType.otherNeutrals,
  11007: CharacterType.otherNeutrals,
  11008: CharacterType.otherNeutrals,
  11009: CharacterType.otherNeutrals,
  11010: CharacterType.otherNeutrals,
  11011: CharacterType.otherNeutrals,
  11012: CharacterType.otherNeutrals,
  11013: CharacterType.otherNeutrals,
  11014: CharacterType.otherNeutrals,
  11015: CharacterType.otherNeutrals,
  11016: CharacterType.otherNeutrals,
  11017: CharacterType.otherNeutrals,
  11018: CharacterType.otherNeutrals,
  11019: CharacterType.otherNeutrals,
  11020: CharacterType.otherNeutrals,
  11021: CharacterType.otherNeutrals,
  11022: CharacterType.otherNeutrals,
  11023: CharacterType.otherNeutrals,
  11024: CharacterType.otherNeutrals,
  11025: CharacterType.otherNeutrals,
  11026: CharacterType.otherNeutrals,
  11027: CharacterType.otherNeutrals,
  11028: CharacterType.otherNeutrals,
  11029: CharacterType.otherNeutrals,
  11030: CharacterType.otherNeutrals,
  11031: CharacterType.otherNeutrals,
  11032: CharacterType.otherNeutrals,
  11033: CharacterType.otherNeutrals,
  11034: CharacterType.otherNeutrals,
  11035: CharacterType.otherNeutrals,
  11036: CharacterType.otherNeutrals,
  11037: CharacterType.otherNeutrals,
  11038: CharacterType.otherNeutrals,
  11039: CharacterType.otherNeutrals,
  11040: CharacterType.otherNeutrals,
  11041: CharacterType.otherNeutrals,
  11042: CharacterType.otherNeutrals,
  11043: CharacterType.otherNeutrals,
  11044: CharacterType.otherNeutrals,
  11045: CharacterType.otherNeutrals,
  11046: CharacterType.otherNeutrals,
  11047: CharacterType.otherNeutrals,
  11048: CharacterType.otherNeutrals,
  11049: CharacterType.otherNeutrals,
  11050: CharacterType.otherNeutrals,
  11051: CharacterType.otherNeutrals,
  11052: CharacterType.otherNeutrals,
  11053: CharacterType.otherNeutrals,
  11054: CharacterType.otherNeutrals,
  11055: CharacterType.otherNeutrals,
  11056: CharacterType.otherNeutrals,
  11057: CharacterType.otherNeutrals,
  11058: CharacterType.otherNeutrals,
  11059: CharacterType.otherNeutrals,
  11060: CharacterType.otherNeutrals,
  11061: CharacterType.otherNeutrals,
  11062: CharacterType.otherNeutrals,
  11063: CharacterType.otherNeutrals,
  11064: CharacterType.otherNeutrals,
  11065: CharacterType.otherNeutrals,
  11066: CharacterType.otherNeutrals,
  11067: CharacterType.otherNeutrals,
  11068: CharacterType.otherNeutrals,
  11069: CharacterType.otherNeutrals,
  11070: CharacterType.otherNeutrals,
  11071: CharacterType.otherNeutrals,
  11072: CharacterType.otherNeutrals,
  11073: CharacterType.otherNeutrals,
  11074: CharacterType.otherNeutrals,
  11075: CharacterType.otherNeutrals,
  11076: CharacterType.otherNeutrals,
  11077: CharacterType.otherNeutrals,
  11078: CharacterType.otherNeutrals,
  11079: CharacterType.otherNeutrals,
  11080: CharacterType.otherNeutrals,
  11081: CharacterType.otherNeutrals,
  11082: CharacterType.otherNeutrals,
  11083: CharacterType.otherNeutrals,
  11084: CharacterType.otherNeutrals,
  11085: CharacterType.otherNeutrals,
  11086: CharacterType.otherNeutrals,
  11087: CharacterType.otherNeutrals,
  11088: CharacterType.otherNeutrals,
  11089: CharacterType.otherNeutrals,
  11090: CharacterType.otherNeutrals,
  11091: CharacterType.otherNeutrals,
  11092: CharacterType.otherNeutrals,
  11093: CharacterType.otherNeutrals,
  11094: CharacterType.otherNeutrals,
  11095: CharacterType.otherNeutrals,
  11096: CharacterType.otherNeutrals,
  11097: CharacterType.otherNeutrals,
  11098: CharacterType.otherNeutrals,
  11099: CharacterType.otherNeutrals,
  11100: CharacterType.otherNeutrals,
  11101: CharacterType.otherNeutrals,
  11102: CharacterType.otherNeutrals,
  11103: CharacterType.otherNeutrals,
  11104: CharacterType.otherNeutrals,
  11105: CharacterType.otherNeutrals,
  11106: CharacterType.otherNeutrals,
  11107: CharacterType.otherNeutrals,
  11108: CharacterType.otherNeutrals,
  11109: CharacterType.otherNeutrals,
  11110: CharacterType.otherNeutrals,
  11111: CharacterType.otherNeutrals,
  11112: CharacterType.otherNeutrals,
  11113: CharacterType.otherNeutrals,
  11114: CharacterType.otherNeutrals,
  11115: CharacterType.otherNeutrals,
  11116: CharacterType.otherNeutrals,
  11117: CharacterType.otherNeutrals,
  11118: CharacterType.otherNeutrals,
  11119: CharacterType.otherNeutrals,
  11120: CharacterType.otherNeutrals,
  11121: CharacterType.otherNeutrals,
  11122: CharacterType.otherNeutrals,
  11123: CharacterType.otherNeutrals,
  11126: CharacterType.otherNeutrals,
  11127: CharacterType.otherNeutrals,
  11128: CharacterType.otherNeutrals,
  11129: CharacterType.otherNeutrals,
  11130: CharacterType.otherNeutrals,
  11131: CharacterType.otherNeutrals,
  11132: CharacterType.otherNeutrals,
  11133: CharacterType.otherNeutrals,
  11134: CharacterType.otherNeutrals,
  11135: CharacterType.otherNeutrals,
  11136: CharacterType.otherNeutrals,
  11137: CharacterType.otherNeutrals,
  11138: CharacterType.otherNeutrals,
  11139: CharacterType.otherNeutrals,
  11140: CharacterType.otherNeutrals,
  11141: CharacterType.otherNeutrals,
  11142: CharacterType.otherNeutrals,
  11143: CharacterType.otherNeutrals,
  11144: CharacterType.otherNeutrals,
  11145: CharacterType.otherNeutrals,
  11146: CharacterType.otherNeutrals,
  11147: CharacterType.otherNeutrals,
  11148: CharacterType.otherNeutrals,
  11149: CharacterType.otherNeutrals,
  11150: CharacterType.otherNeutrals,
  11151: CharacterType.otherNeutrals,
  11152: CharacterType.otherNeutrals,
  11153: CharacterType.otherNeutrals,
  11154: CharacterType.otherNeutrals,
  11155: CharacterType.otherNeutrals,
  11156: CharacterType.otherNeutrals,
  11157: CharacterType.otherNeutrals,
  11160: CharacterType.otherNeutrals,
  11161: CharacterType.otherNeutrals,
  11162: CharacterType.otherNeutrals,
  11163: CharacterType.otherNeutrals,
  11164: CharacterType.otherNeutrals,
  11165: CharacterType.otherNeutrals,
  11166: CharacterType.otherNeutrals,
  11167: CharacterType.otherNeutrals,
  11168: CharacterType.otherNeutrals,
  11169: CharacterType.otherNeutrals,
  11170: CharacterType.otherNeutrals,
  11171: CharacterType.otherNeutrals,
  11172: CharacterType.otherNeutrals,
  11173: CharacterType.otherNeutrals,
  11174: CharacterType.otherNeutrals,
  11175: CharacterType.otherNeutrals,
  11176: CharacterType.otherNeutrals,
  11177: CharacterType.otherNeutrals,
  11178: CharacterType.otherNeutrals,
  11179: CharacterType.otherNeutrals,
  11180: CharacterType.otherNeutrals,
  11181: CharacterType.otherNeutrals,
  11182: CharacterType.otherNeutrals,
  11183: CharacterType.otherNeutrals,
  11184: CharacterType.otherNeutrals,
  11185: CharacterType.otherNeutrals,
  11186: CharacterType.otherNeutrals,
  11187: CharacterType.otherNeutrals,
  11188: CharacterType.otherNeutrals,
  11189: CharacterType.otherNeutrals,
  11190: CharacterType.otherNeutrals,
  11191: CharacterType.otherNeutrals,
  11192: CharacterType.otherNeutrals,
  11193: CharacterType.otherNeutrals,
  11197: CharacterType.otherNeutrals,
  11198: CharacterType.otherNeutrals,
  11199: CharacterType.otherNeutrals,
  11200: CharacterType.otherNeutrals,
  11201: CharacterType.otherNeutrals,
  11202: CharacterType.otherNeutrals,
  11203: CharacterType.otherNeutrals,
  11204: CharacterType.otherNeutrals,
  11205: CharacterType.otherNeutrals,
  11206: CharacterType.otherNeutrals,
  11207: CharacterType.otherNeutrals,
  11208: CharacterType.otherNeutrals,
  11210: CharacterType.otherNeutrals,
  11211: CharacterType.otherNeutrals,
  11212: CharacterType.otherNeutrals,
  11213: CharacterType.otherNeutrals,
  11214: CharacterType.otherNeutrals,
  11215: CharacterType.otherNeutrals,
  11216: CharacterType.otherNeutrals,
  11217: CharacterType.otherNeutrals,
  11493: CharacterType.otherNeutrals,
  11494: CharacterType.otherNeutrals,
  11495: CharacterType.otherNeutrals,
  11496: CharacterType.otherNeutrals,
  11497: CharacterType.otherNeutrals,
  11498: CharacterType.otherNeutrals,
  11503: CharacterType.nonspacingMark,
  11504: CharacterType.nonspacingMark,
  11505: CharacterType.nonspacingMark,
  11513: CharacterType.otherNeutrals,
  11514: CharacterType.otherNeutrals,
  11515: CharacterType.otherNeutrals,
  11516: CharacterType.otherNeutrals,
  11517: CharacterType.otherNeutrals,
  11518: CharacterType.otherNeutrals,
  11519: CharacterType.otherNeutrals,
  11647: CharacterType.nonspacingMark,
  11744: CharacterType.nonspacingMark,
  11745: CharacterType.nonspacingMark,
  11746: CharacterType.nonspacingMark,
  11747: CharacterType.nonspacingMark,
  11748: CharacterType.nonspacingMark,
  11749: CharacterType.nonspacingMark,
  11750: CharacterType.nonspacingMark,
  11751: CharacterType.nonspacingMark,
  11752: CharacterType.nonspacingMark,
  11753: CharacterType.nonspacingMark,
  11754: CharacterType.nonspacingMark,
  11755: CharacterType.nonspacingMark,
  11756: CharacterType.nonspacingMark,
  11757: CharacterType.nonspacingMark,
  11758: CharacterType.nonspacingMark,
  11759: CharacterType.nonspacingMark,
  11760: CharacterType.nonspacingMark,
  11761: CharacterType.nonspacingMark,
  11762: CharacterType.nonspacingMark,
  11763: CharacterType.nonspacingMark,
  11764: CharacterType.nonspacingMark,
  11765: CharacterType.nonspacingMark,
  11766: CharacterType.nonspacingMark,
  11767: CharacterType.nonspacingMark,
  11768: CharacterType.nonspacingMark,
  11769: CharacterType.nonspacingMark,
  11770: CharacterType.nonspacingMark,
  11771: CharacterType.nonspacingMark,
  11772: CharacterType.nonspacingMark,
  11773: CharacterType.nonspacingMark,
  11774: CharacterType.nonspacingMark,
  11775: CharacterType.nonspacingMark,
  11776: CharacterType.otherNeutrals,
  11777: CharacterType.otherNeutrals,
  11778: CharacterType.otherNeutrals,
  11779: CharacterType.otherNeutrals,
  11780: CharacterType.otherNeutrals,
  11781: CharacterType.otherNeutrals,
  11782: CharacterType.otherNeutrals,
  11783: CharacterType.otherNeutrals,
  11784: CharacterType.otherNeutrals,
  11785: CharacterType.otherNeutrals,
  11786: CharacterType.otherNeutrals,
  11787: CharacterType.otherNeutrals,
  11788: CharacterType.otherNeutrals,
  11789: CharacterType.otherNeutrals,
  11790: CharacterType.otherNeutrals,
  11791: CharacterType.otherNeutrals,
  11792: CharacterType.otherNeutrals,
  11793: CharacterType.otherNeutrals,
  11794: CharacterType.otherNeutrals,
  11795: CharacterType.otherNeutrals,
  11796: CharacterType.otherNeutrals,
  11797: CharacterType.otherNeutrals,
  11798: CharacterType.otherNeutrals,
  11799: CharacterType.otherNeutrals,
  11800: CharacterType.otherNeutrals,
  11801: CharacterType.otherNeutrals,
  11802: CharacterType.otherNeutrals,
  11803: CharacterType.otherNeutrals,
  11804: CharacterType.otherNeutrals,
  11805: CharacterType.otherNeutrals,
  11806: CharacterType.otherNeutrals,
  11807: CharacterType.otherNeutrals,
  11808: CharacterType.otherNeutrals,
  11809: CharacterType.otherNeutrals,
  11810: CharacterType.otherNeutrals,
  11811: CharacterType.otherNeutrals,
  11812: CharacterType.otherNeutrals,
  11813: CharacterType.otherNeutrals,
  11814: CharacterType.otherNeutrals,
  11815: CharacterType.otherNeutrals,
  11816: CharacterType.otherNeutrals,
  11817: CharacterType.otherNeutrals,
  11818: CharacterType.otherNeutrals,
  11819: CharacterType.otherNeutrals,
  11820: CharacterType.otherNeutrals,
  11821: CharacterType.otherNeutrals,
  11822: CharacterType.otherNeutrals,
  11823: CharacterType.otherNeutrals,
  11824: CharacterType.otherNeutrals,
  11825: CharacterType.otherNeutrals,
  11826: CharacterType.otherNeutrals,
  11827: CharacterType.otherNeutrals,
  11828: CharacterType.otherNeutrals,
  11829: CharacterType.otherNeutrals,
  11830: CharacterType.otherNeutrals,
  11831: CharacterType.otherNeutrals,
  11832: CharacterType.otherNeutrals,
  11833: CharacterType.otherNeutrals,
  11834: CharacterType.otherNeutrals,
  11835: CharacterType.otherNeutrals,
  11836: CharacterType.otherNeutrals,
  11837: CharacterType.otherNeutrals,
  11838: CharacterType.otherNeutrals,
  11839: CharacterType.otherNeutrals,
  11840: CharacterType.otherNeutrals,
  11841: CharacterType.otherNeutrals,
  11842: CharacterType.otherNeutrals,
  11904: CharacterType.otherNeutrals,
  11905: CharacterType.otherNeutrals,
  11906: CharacterType.otherNeutrals,
  11907: CharacterType.otherNeutrals,
  11908: CharacterType.otherNeutrals,
  11909: CharacterType.otherNeutrals,
  11910: CharacterType.otherNeutrals,
  11911: CharacterType.otherNeutrals,
  11912: CharacterType.otherNeutrals,
  11913: CharacterType.otherNeutrals,
  11914: CharacterType.otherNeutrals,
  11915: CharacterType.otherNeutrals,
  11916: CharacterType.otherNeutrals,
  11917: CharacterType.otherNeutrals,
  11918: CharacterType.otherNeutrals,
  11919: CharacterType.otherNeutrals,
  11920: CharacterType.otherNeutrals,
  11921: CharacterType.otherNeutrals,
  11922: CharacterType.otherNeutrals,
  11923: CharacterType.otherNeutrals,
  11924: CharacterType.otherNeutrals,
  11925: CharacterType.otherNeutrals,
  11926: CharacterType.otherNeutrals,
  11927: CharacterType.otherNeutrals,
  11928: CharacterType.otherNeutrals,
  11929: CharacterType.otherNeutrals,
  11931: CharacterType.otherNeutrals,
  11932: CharacterType.otherNeutrals,
  11933: CharacterType.otherNeutrals,
  11934: CharacterType.otherNeutrals,
  11935: CharacterType.otherNeutrals,
  11936: CharacterType.otherNeutrals,
  11937: CharacterType.otherNeutrals,
  11938: CharacterType.otherNeutrals,
  11939: CharacterType.otherNeutrals,
  11940: CharacterType.otherNeutrals,
  11941: CharacterType.otherNeutrals,
  11942: CharacterType.otherNeutrals,
  11943: CharacterType.otherNeutrals,
  11944: CharacterType.otherNeutrals,
  11945: CharacterType.otherNeutrals,
  11946: CharacterType.otherNeutrals,
  11947: CharacterType.otherNeutrals,
  11948: CharacterType.otherNeutrals,
  11949: CharacterType.otherNeutrals,
  11950: CharacterType.otherNeutrals,
  11951: CharacterType.otherNeutrals,
  11952: CharacterType.otherNeutrals,
  11953: CharacterType.otherNeutrals,
  11954: CharacterType.otherNeutrals,
  11955: CharacterType.otherNeutrals,
  11956: CharacterType.otherNeutrals,
  11957: CharacterType.otherNeutrals,
  11958: CharacterType.otherNeutrals,
  11959: CharacterType.otherNeutrals,
  11960: CharacterType.otherNeutrals,
  11961: CharacterType.otherNeutrals,
  11962: CharacterType.otherNeutrals,
  11963: CharacterType.otherNeutrals,
  11964: CharacterType.otherNeutrals,
  11965: CharacterType.otherNeutrals,
  11966: CharacterType.otherNeutrals,
  11967: CharacterType.otherNeutrals,
  11968: CharacterType.otherNeutrals,
  11969: CharacterType.otherNeutrals,
  11970: CharacterType.otherNeutrals,
  11971: CharacterType.otherNeutrals,
  11972: CharacterType.otherNeutrals,
  11973: CharacterType.otherNeutrals,
  11974: CharacterType.otherNeutrals,
  11975: CharacterType.otherNeutrals,
  11976: CharacterType.otherNeutrals,
  11977: CharacterType.otherNeutrals,
  11978: CharacterType.otherNeutrals,
  11979: CharacterType.otherNeutrals,
  11980: CharacterType.otherNeutrals,
  11981: CharacterType.otherNeutrals,
  11982: CharacterType.otherNeutrals,
  11983: CharacterType.otherNeutrals,
  11984: CharacterType.otherNeutrals,
  11985: CharacterType.otherNeutrals,
  11986: CharacterType.otherNeutrals,
  11987: CharacterType.otherNeutrals,
  11988: CharacterType.otherNeutrals,
  11989: CharacterType.otherNeutrals,
  11990: CharacterType.otherNeutrals,
  11991: CharacterType.otherNeutrals,
  11992: CharacterType.otherNeutrals,
  11993: CharacterType.otherNeutrals,
  11994: CharacterType.otherNeutrals,
  11995: CharacterType.otherNeutrals,
  11996: CharacterType.otherNeutrals,
  11997: CharacterType.otherNeutrals,
  11998: CharacterType.otherNeutrals,
  11999: CharacterType.otherNeutrals,
  12000: CharacterType.otherNeutrals,
  12001: CharacterType.otherNeutrals,
  12002: CharacterType.otherNeutrals,
  12003: CharacterType.otherNeutrals,
  12004: CharacterType.otherNeutrals,
  12005: CharacterType.otherNeutrals,
  12006: CharacterType.otherNeutrals,
  12007: CharacterType.otherNeutrals,
  12008: CharacterType.otherNeutrals,
  12009: CharacterType.otherNeutrals,
  12010: CharacterType.otherNeutrals,
  12011: CharacterType.otherNeutrals,
  12012: CharacterType.otherNeutrals,
  12013: CharacterType.otherNeutrals,
  12014: CharacterType.otherNeutrals,
  12015: CharacterType.otherNeutrals,
  12016: CharacterType.otherNeutrals,
  12017: CharacterType.otherNeutrals,
  12018: CharacterType.otherNeutrals,
  12019: CharacterType.otherNeutrals,
  12032: CharacterType.otherNeutrals,
  12033: CharacterType.otherNeutrals,
  12034: CharacterType.otherNeutrals,
  12035: CharacterType.otherNeutrals,
  12036: CharacterType.otherNeutrals,
  12037: CharacterType.otherNeutrals,
  12038: CharacterType.otherNeutrals,
  12039: CharacterType.otherNeutrals,
  12040: CharacterType.otherNeutrals,
  12041: CharacterType.otherNeutrals,
  12042: CharacterType.otherNeutrals,
  12043: CharacterType.otherNeutrals,
  12044: CharacterType.otherNeutrals,
  12045: CharacterType.otherNeutrals,
  12046: CharacterType.otherNeutrals,
  12047: CharacterType.otherNeutrals,
  12048: CharacterType.otherNeutrals,
  12049: CharacterType.otherNeutrals,
  12050: CharacterType.otherNeutrals,
  12051: CharacterType.otherNeutrals,
  12052: CharacterType.otherNeutrals,
  12053: CharacterType.otherNeutrals,
  12054: CharacterType.otherNeutrals,
  12055: CharacterType.otherNeutrals,
  12056: CharacterType.otherNeutrals,
  12057: CharacterType.otherNeutrals,
  12058: CharacterType.otherNeutrals,
  12059: CharacterType.otherNeutrals,
  12060: CharacterType.otherNeutrals,
  12061: CharacterType.otherNeutrals,
  12062: CharacterType.otherNeutrals,
  12063: CharacterType.otherNeutrals,
  12064: CharacterType.otherNeutrals,
  12065: CharacterType.otherNeutrals,
  12066: CharacterType.otherNeutrals,
  12067: CharacterType.otherNeutrals,
  12068: CharacterType.otherNeutrals,
  12069: CharacterType.otherNeutrals,
  12070: CharacterType.otherNeutrals,
  12071: CharacterType.otherNeutrals,
  12072: CharacterType.otherNeutrals,
  12073: CharacterType.otherNeutrals,
  12074: CharacterType.otherNeutrals,
  12075: CharacterType.otherNeutrals,
  12076: CharacterType.otherNeutrals,
  12077: CharacterType.otherNeutrals,
  12078: CharacterType.otherNeutrals,
  12079: CharacterType.otherNeutrals,
  12080: CharacterType.otherNeutrals,
  12081: CharacterType.otherNeutrals,
  12082: CharacterType.otherNeutrals,
  12083: CharacterType.otherNeutrals,
  12084: CharacterType.otherNeutrals,
  12085: CharacterType.otherNeutrals,
  12086: CharacterType.otherNeutrals,
  12087: CharacterType.otherNeutrals,
  12088: CharacterType.otherNeutrals,
  12089: CharacterType.otherNeutrals,
  12090: CharacterType.otherNeutrals,
  12091: CharacterType.otherNeutrals,
  12092: CharacterType.otherNeutrals,
  12093: CharacterType.otherNeutrals,
  12094: CharacterType.otherNeutrals,
  12095: CharacterType.otherNeutrals,
  12096: CharacterType.otherNeutrals,
  12097: CharacterType.otherNeutrals,
  12098: CharacterType.otherNeutrals,
  12099: CharacterType.otherNeutrals,
  12100: CharacterType.otherNeutrals,
  12101: CharacterType.otherNeutrals,
  12102: CharacterType.otherNeutrals,
  12103: CharacterType.otherNeutrals,
  12104: CharacterType.otherNeutrals,
  12105: CharacterType.otherNeutrals,
  12106: CharacterType.otherNeutrals,
  12107: CharacterType.otherNeutrals,
  12108: CharacterType.otherNeutrals,
  12109: CharacterType.otherNeutrals,
  12110: CharacterType.otherNeutrals,
  12111: CharacterType.otherNeutrals,
  12112: CharacterType.otherNeutrals,
  12113: CharacterType.otherNeutrals,
  12114: CharacterType.otherNeutrals,
  12115: CharacterType.otherNeutrals,
  12116: CharacterType.otherNeutrals,
  12117: CharacterType.otherNeutrals,
  12118: CharacterType.otherNeutrals,
  12119: CharacterType.otherNeutrals,
  12120: CharacterType.otherNeutrals,
  12121: CharacterType.otherNeutrals,
  12122: CharacterType.otherNeutrals,
  12123: CharacterType.otherNeutrals,
  12124: CharacterType.otherNeutrals,
  12125: CharacterType.otherNeutrals,
  12126: CharacterType.otherNeutrals,
  12127: CharacterType.otherNeutrals,
  12128: CharacterType.otherNeutrals,
  12129: CharacterType.otherNeutrals,
  12130: CharacterType.otherNeutrals,
  12131: CharacterType.otherNeutrals,
  12132: CharacterType.otherNeutrals,
  12133: CharacterType.otherNeutrals,
  12134: CharacterType.otherNeutrals,
  12135: CharacterType.otherNeutrals,
  12136: CharacterType.otherNeutrals,
  12137: CharacterType.otherNeutrals,
  12138: CharacterType.otherNeutrals,
  12139: CharacterType.otherNeutrals,
  12140: CharacterType.otherNeutrals,
  12141: CharacterType.otherNeutrals,
  12142: CharacterType.otherNeutrals,
  12143: CharacterType.otherNeutrals,
  12144: CharacterType.otherNeutrals,
  12145: CharacterType.otherNeutrals,
  12146: CharacterType.otherNeutrals,
  12147: CharacterType.otherNeutrals,
  12148: CharacterType.otherNeutrals,
  12149: CharacterType.otherNeutrals,
  12150: CharacterType.otherNeutrals,
  12151: CharacterType.otherNeutrals,
  12152: CharacterType.otherNeutrals,
  12153: CharacterType.otherNeutrals,
  12154: CharacterType.otherNeutrals,
  12155: CharacterType.otherNeutrals,
  12156: CharacterType.otherNeutrals,
  12157: CharacterType.otherNeutrals,
  12158: CharacterType.otherNeutrals,
  12159: CharacterType.otherNeutrals,
  12160: CharacterType.otherNeutrals,
  12161: CharacterType.otherNeutrals,
  12162: CharacterType.otherNeutrals,
  12163: CharacterType.otherNeutrals,
  12164: CharacterType.otherNeutrals,
  12165: CharacterType.otherNeutrals,
  12166: CharacterType.otherNeutrals,
  12167: CharacterType.otherNeutrals,
  12168: CharacterType.otherNeutrals,
  12169: CharacterType.otherNeutrals,
  12170: CharacterType.otherNeutrals,
  12171: CharacterType.otherNeutrals,
  12172: CharacterType.otherNeutrals,
  12173: CharacterType.otherNeutrals,
  12174: CharacterType.otherNeutrals,
  12175: CharacterType.otherNeutrals,
  12176: CharacterType.otherNeutrals,
  12177: CharacterType.otherNeutrals,
  12178: CharacterType.otherNeutrals,
  12179: CharacterType.otherNeutrals,
  12180: CharacterType.otherNeutrals,
  12181: CharacterType.otherNeutrals,
  12182: CharacterType.otherNeutrals,
  12183: CharacterType.otherNeutrals,
  12184: CharacterType.otherNeutrals,
  12185: CharacterType.otherNeutrals,
  12186: CharacterType.otherNeutrals,
  12187: CharacterType.otherNeutrals,
  12188: CharacterType.otherNeutrals,
  12189: CharacterType.otherNeutrals,
  12190: CharacterType.otherNeutrals,
  12191: CharacterType.otherNeutrals,
  12192: CharacterType.otherNeutrals,
  12193: CharacterType.otherNeutrals,
  12194: CharacterType.otherNeutrals,
  12195: CharacterType.otherNeutrals,
  12196: CharacterType.otherNeutrals,
  12197: CharacterType.otherNeutrals,
  12198: CharacterType.otherNeutrals,
  12199: CharacterType.otherNeutrals,
  12200: CharacterType.otherNeutrals,
  12201: CharacterType.otherNeutrals,
  12202: CharacterType.otherNeutrals,
  12203: CharacterType.otherNeutrals,
  12204: CharacterType.otherNeutrals,
  12205: CharacterType.otherNeutrals,
  12206: CharacterType.otherNeutrals,
  12207: CharacterType.otherNeutrals,
  12208: CharacterType.otherNeutrals,
  12209: CharacterType.otherNeutrals,
  12210: CharacterType.otherNeutrals,
  12211: CharacterType.otherNeutrals,
  12212: CharacterType.otherNeutrals,
  12213: CharacterType.otherNeutrals,
  12214: CharacterType.otherNeutrals,
  12215: CharacterType.otherNeutrals,
  12216: CharacterType.otherNeutrals,
  12217: CharacterType.otherNeutrals,
  12218: CharacterType.otherNeutrals,
  12219: CharacterType.otherNeutrals,
  12220: CharacterType.otherNeutrals,
  12221: CharacterType.otherNeutrals,
  12222: CharacterType.otherNeutrals,
  12223: CharacterType.otherNeutrals,
  12224: CharacterType.otherNeutrals,
  12225: CharacterType.otherNeutrals,
  12226: CharacterType.otherNeutrals,
  12227: CharacterType.otherNeutrals,
  12228: CharacterType.otherNeutrals,
  12229: CharacterType.otherNeutrals,
  12230: CharacterType.otherNeutrals,
  12231: CharacterType.otherNeutrals,
  12232: CharacterType.otherNeutrals,
  12233: CharacterType.otherNeutrals,
  12234: CharacterType.otherNeutrals,
  12235: CharacterType.otherNeutrals,
  12236: CharacterType.otherNeutrals,
  12237: CharacterType.otherNeutrals,
  12238: CharacterType.otherNeutrals,
  12239: CharacterType.otherNeutrals,
  12240: CharacterType.otherNeutrals,
  12241: CharacterType.otherNeutrals,
  12242: CharacterType.otherNeutrals,
  12243: CharacterType.otherNeutrals,
  12244: CharacterType.otherNeutrals,
  12245: CharacterType.otherNeutrals,
  12272: CharacterType.otherNeutrals,
  12273: CharacterType.otherNeutrals,
  12274: CharacterType.otherNeutrals,
  12275: CharacterType.otherNeutrals,
  12276: CharacterType.otherNeutrals,
  12277: CharacterType.otherNeutrals,
  12278: CharacterType.otherNeutrals,
  12279: CharacterType.otherNeutrals,
  12280: CharacterType.otherNeutrals,
  12281: CharacterType.otherNeutrals,
  12282: CharacterType.otherNeutrals,
  12283: CharacterType.otherNeutrals,
  12288: CharacterType.whitespace,
  12289: CharacterType.otherNeutrals,
  12290: CharacterType.otherNeutrals,
  12291: CharacterType.otherNeutrals,
  12292: CharacterType.otherNeutrals,
  12296: CharacterType.otherNeutrals,
  12297: CharacterType.otherNeutrals,
  12298: CharacterType.otherNeutrals,
  12299: CharacterType.otherNeutrals,
  12300: CharacterType.otherNeutrals,
  12301: CharacterType.otherNeutrals,
  12302: CharacterType.otherNeutrals,
  12303: CharacterType.otherNeutrals,
  12304: CharacterType.otherNeutrals,
  12305: CharacterType.otherNeutrals,
  12306: CharacterType.otherNeutrals,
  12307: CharacterType.otherNeutrals,
  12308: CharacterType.otherNeutrals,
  12309: CharacterType.otherNeutrals,
  12310: CharacterType.otherNeutrals,
  12311: CharacterType.otherNeutrals,
  12312: CharacterType.otherNeutrals,
  12313: CharacterType.otherNeutrals,
  12314: CharacterType.otherNeutrals,
  12315: CharacterType.otherNeutrals,
  12316: CharacterType.otherNeutrals,
  12317: CharacterType.otherNeutrals,
  12318: CharacterType.otherNeutrals,
  12319: CharacterType.otherNeutrals,
  12320: CharacterType.otherNeutrals,
  12330: CharacterType.nonspacingMark,
  12331: CharacterType.nonspacingMark,
  12332: CharacterType.nonspacingMark,
  12333: CharacterType.nonspacingMark,
  12336: CharacterType.otherNeutrals,
  12342: CharacterType.otherNeutrals,
  12343: CharacterType.otherNeutrals,
  12349: CharacterType.otherNeutrals,
  12350: CharacterType.otherNeutrals,
  12351: CharacterType.otherNeutrals,
  12441: CharacterType.nonspacingMark,
  12442: CharacterType.nonspacingMark,
  12443: CharacterType.otherNeutrals,
  12444: CharacterType.otherNeutrals,
  12448: CharacterType.otherNeutrals,
  12539: CharacterType.otherNeutrals,
  12736: CharacterType.otherNeutrals,
  12737: CharacterType.otherNeutrals,
  12738: CharacterType.otherNeutrals,
  12739: CharacterType.otherNeutrals,
  12740: CharacterType.otherNeutrals,
  12741: CharacterType.otherNeutrals,
  12742: CharacterType.otherNeutrals,
  12743: CharacterType.otherNeutrals,
  12744: CharacterType.otherNeutrals,
  12745: CharacterType.otherNeutrals,
  12746: CharacterType.otherNeutrals,
  12747: CharacterType.otherNeutrals,
  12748: CharacterType.otherNeutrals,
  12749: CharacterType.otherNeutrals,
  12750: CharacterType.otherNeutrals,
  12751: CharacterType.otherNeutrals,
  12752: CharacterType.otherNeutrals,
  12753: CharacterType.otherNeutrals,
  12754: CharacterType.otherNeutrals,
  12755: CharacterType.otherNeutrals,
  12756: CharacterType.otherNeutrals,
  12757: CharacterType.otherNeutrals,
  12758: CharacterType.otherNeutrals,
  12759: CharacterType.otherNeutrals,
  12760: CharacterType.otherNeutrals,
  12761: CharacterType.otherNeutrals,
  12762: CharacterType.otherNeutrals,
  12763: CharacterType.otherNeutrals,
  12764: CharacterType.otherNeutrals,
  12765: CharacterType.otherNeutrals,
  12766: CharacterType.otherNeutrals,
  12767: CharacterType.otherNeutrals,
  12768: CharacterType.otherNeutrals,
  12769: CharacterType.otherNeutrals,
  12770: CharacterType.otherNeutrals,
  12771: CharacterType.otherNeutrals,
  12829: CharacterType.otherNeutrals,
  12830: CharacterType.otherNeutrals,
  12880: CharacterType.otherNeutrals,
  12881: CharacterType.otherNeutrals,
  12882: CharacterType.otherNeutrals,
  12883: CharacterType.otherNeutrals,
  12884: CharacterType.otherNeutrals,
  12885: CharacterType.otherNeutrals,
  12886: CharacterType.otherNeutrals,
  12887: CharacterType.otherNeutrals,
  12888: CharacterType.otherNeutrals,
  12889: CharacterType.otherNeutrals,
  12890: CharacterType.otherNeutrals,
  12891: CharacterType.otherNeutrals,
  12892: CharacterType.otherNeutrals,
  12893: CharacterType.otherNeutrals,
  12894: CharacterType.otherNeutrals,
  12895: CharacterType.otherNeutrals,
  12924: CharacterType.otherNeutrals,
  12925: CharacterType.otherNeutrals,
  12926: CharacterType.otherNeutrals,
  12977: CharacterType.otherNeutrals,
  12978: CharacterType.otherNeutrals,
  12979: CharacterType.otherNeutrals,
  12980: CharacterType.otherNeutrals,
  12981: CharacterType.otherNeutrals,
  12982: CharacterType.otherNeutrals,
  12983: CharacterType.otherNeutrals,
  12984: CharacterType.otherNeutrals,
  12985: CharacterType.otherNeutrals,
  12986: CharacterType.otherNeutrals,
  12987: CharacterType.otherNeutrals,
  12988: CharacterType.otherNeutrals,
  12989: CharacterType.otherNeutrals,
  12990: CharacterType.otherNeutrals,
  12991: CharacterType.otherNeutrals,
  13004: CharacterType.otherNeutrals,
  13005: CharacterType.otherNeutrals,
  13006: CharacterType.otherNeutrals,
  13007: CharacterType.otherNeutrals,
  13175: CharacterType.otherNeutrals,
  13176: CharacterType.otherNeutrals,
  13177: CharacterType.otherNeutrals,
  13178: CharacterType.otherNeutrals,
  13278: CharacterType.otherNeutrals,
  13279: CharacterType.otherNeutrals,
  13311: CharacterType.otherNeutrals,
  19904: CharacterType.otherNeutrals,
  19905: CharacterType.otherNeutrals,
  19906: CharacterType.otherNeutrals,
  19907: CharacterType.otherNeutrals,
  19908: CharacterType.otherNeutrals,
  19909: CharacterType.otherNeutrals,
  19910: CharacterType.otherNeutrals,
  19911: CharacterType.otherNeutrals,
  19912: CharacterType.otherNeutrals,
  19913: CharacterType.otherNeutrals,
  19914: CharacterType.otherNeutrals,
  19915: CharacterType.otherNeutrals,
  19916: CharacterType.otherNeutrals,
  19917: CharacterType.otherNeutrals,
  19918: CharacterType.otherNeutrals,
  19919: CharacterType.otherNeutrals,
  19920: CharacterType.otherNeutrals,
  19921: CharacterType.otherNeutrals,
  19922: CharacterType.otherNeutrals,
  19923: CharacterType.otherNeutrals,
  19924: CharacterType.otherNeutrals,
  19925: CharacterType.otherNeutrals,
  19926: CharacterType.otherNeutrals,
  19927: CharacterType.otherNeutrals,
  19928: CharacterType.otherNeutrals,
  19929: CharacterType.otherNeutrals,
  19930: CharacterType.otherNeutrals,
  19931: CharacterType.otherNeutrals,
  19932: CharacterType.otherNeutrals,
  19933: CharacterType.otherNeutrals,
  19934: CharacterType.otherNeutrals,
  19935: CharacterType.otherNeutrals,
  19936: CharacterType.otherNeutrals,
  19937: CharacterType.otherNeutrals,
  19938: CharacterType.otherNeutrals,
  19939: CharacterType.otherNeutrals,
  19940: CharacterType.otherNeutrals,
  19941: CharacterType.otherNeutrals,
  19942: CharacterType.otherNeutrals,
  19943: CharacterType.otherNeutrals,
  19944: CharacterType.otherNeutrals,
  19945: CharacterType.otherNeutrals,
  19946: CharacterType.otherNeutrals,
  19947: CharacterType.otherNeutrals,
  19948: CharacterType.otherNeutrals,
  19949: CharacterType.otherNeutrals,
  19950: CharacterType.otherNeutrals,
  19951: CharacterType.otherNeutrals,
  19952: CharacterType.otherNeutrals,
  19953: CharacterType.otherNeutrals,
  19954: CharacterType.otherNeutrals,
  19955: CharacterType.otherNeutrals,
  19956: CharacterType.otherNeutrals,
  19957: CharacterType.otherNeutrals,
  19958: CharacterType.otherNeutrals,
  19959: CharacterType.otherNeutrals,
  19960: CharacterType.otherNeutrals,
  19961: CharacterType.otherNeutrals,
  19962: CharacterType.otherNeutrals,
  19963: CharacterType.otherNeutrals,
  19964: CharacterType.otherNeutrals,
  19965: CharacterType.otherNeutrals,
  19966: CharacterType.otherNeutrals,
  19967: CharacterType.otherNeutrals,
  42128: CharacterType.otherNeutrals,
  42129: CharacterType.otherNeutrals,
  42130: CharacterType.otherNeutrals,
  42131: CharacterType.otherNeutrals,
  42132: CharacterType.otherNeutrals,
  42133: CharacterType.otherNeutrals,
  42134: CharacterType.otherNeutrals,
  42135: CharacterType.otherNeutrals,
  42136: CharacterType.otherNeutrals,
  42137: CharacterType.otherNeutrals,
  42138: CharacterType.otherNeutrals,
  42139: CharacterType.otherNeutrals,
  42140: CharacterType.otherNeutrals,
  42141: CharacterType.otherNeutrals,
  42142: CharacterType.otherNeutrals,
  42143: CharacterType.otherNeutrals,
  42144: CharacterType.otherNeutrals,
  42145: CharacterType.otherNeutrals,
  42146: CharacterType.otherNeutrals,
  42147: CharacterType.otherNeutrals,
  42148: CharacterType.otherNeutrals,
  42149: CharacterType.otherNeutrals,
  42150: CharacterType.otherNeutrals,
  42151: CharacterType.otherNeutrals,
  42152: CharacterType.otherNeutrals,
  42153: CharacterType.otherNeutrals,
  42154: CharacterType.otherNeutrals,
  42155: CharacterType.otherNeutrals,
  42156: CharacterType.otherNeutrals,
  42157: CharacterType.otherNeutrals,
  42158: CharacterType.otherNeutrals,
  42159: CharacterType.otherNeutrals,
  42160: CharacterType.otherNeutrals,
  42161: CharacterType.otherNeutrals,
  42162: CharacterType.otherNeutrals,
  42163: CharacterType.otherNeutrals,
  42164: CharacterType.otherNeutrals,
  42165: CharacterType.otherNeutrals,
  42166: CharacterType.otherNeutrals,
  42167: CharacterType.otherNeutrals,
  42168: CharacterType.otherNeutrals,
  42169: CharacterType.otherNeutrals,
  42170: CharacterType.otherNeutrals,
  42171: CharacterType.otherNeutrals,
  42172: CharacterType.otherNeutrals,
  42173: CharacterType.otherNeutrals,
  42174: CharacterType.otherNeutrals,
  42175: CharacterType.otherNeutrals,
  42176: CharacterType.otherNeutrals,
  42177: CharacterType.otherNeutrals,
  42178: CharacterType.otherNeutrals,
  42179: CharacterType.otherNeutrals,
  42180: CharacterType.otherNeutrals,
  42181: CharacterType.otherNeutrals,
  42182: CharacterType.otherNeutrals,
  42509: CharacterType.otherNeutrals,
  42510: CharacterType.otherNeutrals,
  42511: CharacterType.otherNeutrals,
  42607: CharacterType.nonspacingMark,
  42608: CharacterType.nonspacingMark,
  42609: CharacterType.nonspacingMark,
  42610: CharacterType.nonspacingMark,
  42611: CharacterType.otherNeutrals,
  42612: CharacterType.nonspacingMark,
  42613: CharacterType.nonspacingMark,
  42614: CharacterType.nonspacingMark,
  42615: CharacterType.nonspacingMark,
  42616: CharacterType.nonspacingMark,
  42617: CharacterType.nonspacingMark,
  42618: CharacterType.nonspacingMark,
  42619: CharacterType.nonspacingMark,
  42620: CharacterType.nonspacingMark,
  42621: CharacterType.nonspacingMark,
  42622: CharacterType.otherNeutrals,
  42623: CharacterType.otherNeutrals,
  42655: CharacterType.nonspacingMark,
  42736: CharacterType.nonspacingMark,
  42737: CharacterType.nonspacingMark,
  42752: CharacterType.otherNeutrals,
  42753: CharacterType.otherNeutrals,
  42754: CharacterType.otherNeutrals,
  42755: CharacterType.otherNeutrals,
  42756: CharacterType.otherNeutrals,
  42757: CharacterType.otherNeutrals,
  42758: CharacterType.otherNeutrals,
  42759: CharacterType.otherNeutrals,
  42760: CharacterType.otherNeutrals,
  42761: CharacterType.otherNeutrals,
  42762: CharacterType.otherNeutrals,
  42763: CharacterType.otherNeutrals,
  42764: CharacterType.otherNeutrals,
  42765: CharacterType.otherNeutrals,
  42766: CharacterType.otherNeutrals,
  42767: CharacterType.otherNeutrals,
  42768: CharacterType.otherNeutrals,
  42769: CharacterType.otherNeutrals,
  42770: CharacterType.otherNeutrals,
  42771: CharacterType.otherNeutrals,
  42772: CharacterType.otherNeutrals,
  42773: CharacterType.otherNeutrals,
  42774: CharacterType.otherNeutrals,
  42775: CharacterType.otherNeutrals,
  42776: CharacterType.otherNeutrals,
  42777: CharacterType.otherNeutrals,
  42778: CharacterType.otherNeutrals,
  42779: CharacterType.otherNeutrals,
  42780: CharacterType.otherNeutrals,
  42781: CharacterType.otherNeutrals,
  42782: CharacterType.otherNeutrals,
  42783: CharacterType.otherNeutrals,
  42784: CharacterType.otherNeutrals,
  42785: CharacterType.otherNeutrals,
  42888: CharacterType.otherNeutrals,
  43010: CharacterType.nonspacingMark,
  43014: CharacterType.nonspacingMark,
  43019: CharacterType.nonspacingMark,
  43045: CharacterType.nonspacingMark,
  43046: CharacterType.nonspacingMark,
  43048: CharacterType.otherNeutrals,
  43049: CharacterType.otherNeutrals,
  43050: CharacterType.otherNeutrals,
  43051: CharacterType.otherNeutrals,
  43064: CharacterType.et,
  43065: CharacterType.et,
  43124: CharacterType.otherNeutrals,
  43125: CharacterType.otherNeutrals,
  43126: CharacterType.otherNeutrals,
  43127: CharacterType.otherNeutrals,
  43204: CharacterType.nonspacingMark,
  43232: CharacterType.nonspacingMark,
  43233: CharacterType.nonspacingMark,
  43234: CharacterType.nonspacingMark,
  43235: CharacterType.nonspacingMark,
  43236: CharacterType.nonspacingMark,
  43237: CharacterType.nonspacingMark,
  43238: CharacterType.nonspacingMark,
  43239: CharacterType.nonspacingMark,
  43240: CharacterType.nonspacingMark,
  43241: CharacterType.nonspacingMark,
  43242: CharacterType.nonspacingMark,
  43243: CharacterType.nonspacingMark,
  43244: CharacterType.nonspacingMark,
  43245: CharacterType.nonspacingMark,
  43246: CharacterType.nonspacingMark,
  43247: CharacterType.nonspacingMark,
  43248: CharacterType.nonspacingMark,
  43249: CharacterType.nonspacingMark,
  43302: CharacterType.nonspacingMark,
  43303: CharacterType.nonspacingMark,
  43304: CharacterType.nonspacingMark,
  43305: CharacterType.nonspacingMark,
  43306: CharacterType.nonspacingMark,
  43307: CharacterType.nonspacingMark,
  43308: CharacterType.nonspacingMark,
  43309: CharacterType.nonspacingMark,
  43335: CharacterType.nonspacingMark,
  43336: CharacterType.nonspacingMark,
  43337: CharacterType.nonspacingMark,
  43338: CharacterType.nonspacingMark,
  43339: CharacterType.nonspacingMark,
  43340: CharacterType.nonspacingMark,
  43341: CharacterType.nonspacingMark,
  43342: CharacterType.nonspacingMark,
  43343: CharacterType.nonspacingMark,
  43344: CharacterType.nonspacingMark,
  43345: CharacterType.nonspacingMark,
  43392: CharacterType.nonspacingMark,
  43393: CharacterType.nonspacingMark,
  43394: CharacterType.nonspacingMark,
  43443: CharacterType.nonspacingMark,
  43446: CharacterType.nonspacingMark,
  43447: CharacterType.nonspacingMark,
  43448: CharacterType.nonspacingMark,
  43449: CharacterType.nonspacingMark,
  43452: CharacterType.nonspacingMark,
  43493: CharacterType.nonspacingMark,
  43561: CharacterType.nonspacingMark,
  43562: CharacterType.nonspacingMark,
  43563: CharacterType.nonspacingMark,
  43564: CharacterType.nonspacingMark,
  43565: CharacterType.nonspacingMark,
  43566: CharacterType.nonspacingMark,
  43569: CharacterType.nonspacingMark,
  43570: CharacterType.nonspacingMark,
  43573: CharacterType.nonspacingMark,
  43574: CharacterType.nonspacingMark,
  43587: CharacterType.nonspacingMark,
  43596: CharacterType.nonspacingMark,
  43644: CharacterType.nonspacingMark,
  43696: CharacterType.nonspacingMark,
  43698: CharacterType.nonspacingMark,
  43699: CharacterType.nonspacingMark,
  43700: CharacterType.nonspacingMark,
  43703: CharacterType.nonspacingMark,
  43704: CharacterType.nonspacingMark,
  43710: CharacterType.nonspacingMark,
  43711: CharacterType.nonspacingMark,
  43713: CharacterType.nonspacingMark,
  43756: CharacterType.nonspacingMark,
  43757: CharacterType.nonspacingMark,
  43766: CharacterType.nonspacingMark,
  44005: CharacterType.nonspacingMark,
  44008: CharacterType.nonspacingMark,
  44013: CharacterType.nonspacingMark,
  64285: CharacterType.rtl,
  64286: CharacterType.nonspacingMark,
  64287: CharacterType.rtl,
  64288: CharacterType.rtl,
  64289: CharacterType.rtl,
  64290: CharacterType.rtl,
  64291: CharacterType.rtl,
  64292: CharacterType.rtl,
  64293: CharacterType.rtl,
  64294: CharacterType.rtl,
  64295: CharacterType.rtl,
  64296: CharacterType.rtl,
  64297: CharacterType.es,
  64298: CharacterType.rtl,
  64299: CharacterType.rtl,
  64300: CharacterType.rtl,
  64301: CharacterType.rtl,
  64302: CharacterType.rtl,
  64303: CharacterType.rtl,
  64304: CharacterType.rtl,
  64305: CharacterType.rtl,
  64306: CharacterType.rtl,
  64307: CharacterType.rtl,
  64308: CharacterType.rtl,
  64309: CharacterType.rtl,
  64310: CharacterType.rtl,
  64312: CharacterType.rtl,
  64313: CharacterType.rtl,
  64314: CharacterType.rtl,
  64315: CharacterType.rtl,
  64316: CharacterType.rtl,
  64318: CharacterType.rtl,
  64320: CharacterType.rtl,
  64321: CharacterType.rtl,
  64323: CharacterType.rtl,
  64324: CharacterType.rtl,
  64326: CharacterType.rtl,
  64327: CharacterType.rtl,
  64328: CharacterType.rtl,
  64329: CharacterType.rtl,
  64330: CharacterType.rtl,
  64331: CharacterType.rtl,
  64332: CharacterType.rtl,
  64333: CharacterType.rtl,
  64334: CharacterType.rtl,
  64335: CharacterType.rtl,
  64336: CharacterType.al,
  64337: CharacterType.al,
  64338: CharacterType.al,
  64339: CharacterType.al,
  64340: CharacterType.al,
  64341: CharacterType.al,
  64342: CharacterType.al,
  64343: CharacterType.al,
  64344: CharacterType.al,
  64345: CharacterType.al,
  64346: CharacterType.al,
  64347: CharacterType.al,
  64348: CharacterType.al,
  64349: CharacterType.al,
  64350: CharacterType.al,
  64351: CharacterType.al,
  64352: CharacterType.al,
  64353: CharacterType.al,
  64354: CharacterType.al,
  64355: CharacterType.al,
  64356: CharacterType.al,
  64357: CharacterType.al,
  64358: CharacterType.al,
  64359: CharacterType.al,
  64360: CharacterType.al,
  64361: CharacterType.al,
  64362: CharacterType.al,
  64363: CharacterType.al,
  64364: CharacterType.al,
  64365: CharacterType.al,
  64366: CharacterType.al,
  64367: CharacterType.al,
  64368: CharacterType.al,
  64369: CharacterType.al,
  64370: CharacterType.al,
  64371: CharacterType.al,
  64372: CharacterType.al,
  64373: CharacterType.al,
  64374: CharacterType.al,
  64375: CharacterType.al,
  64376: CharacterType.al,
  64377: CharacterType.al,
  64378: CharacterType.al,
  64379: CharacterType.al,
  64380: CharacterType.al,
  64381: CharacterType.al,
  64382: CharacterType.al,
  64383: CharacterType.al,
  64384: CharacterType.al,
  64385: CharacterType.al,
  64386: CharacterType.al,
  64387: CharacterType.al,
  64388: CharacterType.al,
  64389: CharacterType.al,
  64390: CharacterType.al,
  64391: CharacterType.al,
  64392: CharacterType.al,
  64393: CharacterType.al,
  64394: CharacterType.al,
  64395: CharacterType.al,
  64396: CharacterType.al,
  64397: CharacterType.al,
  64398: CharacterType.al,
  64399: CharacterType.al,
  64400: CharacterType.al,
  64401: CharacterType.al,
  64402: CharacterType.al,
  64403: CharacterType.al,
  64404: CharacterType.al,
  64405: CharacterType.al,
  64406: CharacterType.al,
  64407: CharacterType.al,
  64408: CharacterType.al,
  64409: CharacterType.al,
  64410: CharacterType.al,
  64411: CharacterType.al,
  64412: CharacterType.al,
  64413: CharacterType.al,
  64414: CharacterType.al,
  64415: CharacterType.al,
  64416: CharacterType.al,
  64417: CharacterType.al,
  64418: CharacterType.al,
  64419: CharacterType.al,
  64420: CharacterType.al,
  64421: CharacterType.al,
  64422: CharacterType.al,
  64423: CharacterType.al,
  64424: CharacterType.al,
  64425: CharacterType.al,
  64426: CharacterType.al,
  64427: CharacterType.al,
  64428: CharacterType.al,
  64429: CharacterType.al,
  64430: CharacterType.al,
  64431: CharacterType.al,
  64432: CharacterType.al,
  64433: CharacterType.al,
  64434: CharacterType.al,
  64435: CharacterType.al,
  64436: CharacterType.al,
  64437: CharacterType.al,
  64438: CharacterType.al,
  64439: CharacterType.al,
  64440: CharacterType.al,
  64441: CharacterType.al,
  64442: CharacterType.al,
  64443: CharacterType.al,
  64444: CharacterType.al,
  64445: CharacterType.al,
  64446: CharacterType.al,
  64447: CharacterType.al,
  64448: CharacterType.al,
  64449: CharacterType.al,
  64467: CharacterType.al,
  64468: CharacterType.al,
  64469: CharacterType.al,
  64470: CharacterType.al,
  64471: CharacterType.al,
  64472: CharacterType.al,
  64473: CharacterType.al,
  64474: CharacterType.al,
  64475: CharacterType.al,
  64476: CharacterType.al,
  64477: CharacterType.al,
  64478: CharacterType.al,
  64479: CharacterType.al,
  64480: CharacterType.al,
  64481: CharacterType.al,
  64482: CharacterType.al,
  64483: CharacterType.al,
  64484: CharacterType.al,
  64485: CharacterType.al,
  64486: CharacterType.al,
  64487: CharacterType.al,
  64488: CharacterType.al,
  64489: CharacterType.al,
  64490: CharacterType.al,
  64491: CharacterType.al,
  64492: CharacterType.al,
  64493: CharacterType.al,
  64494: CharacterType.al,
  64495: CharacterType.al,
  64496: CharacterType.al,
  64497: CharacterType.al,
  64498: CharacterType.al,
  64499: CharacterType.al,
  64500: CharacterType.al,
  64501: CharacterType.al,
  64502: CharacterType.al,
  64503: CharacterType.al,
  64504: CharacterType.al,
  64505: CharacterType.al,
  64506: CharacterType.al,
  64507: CharacterType.al,
  64508: CharacterType.al,
  64509: CharacterType.al,
  64510: CharacterType.al,
  64511: CharacterType.al,
  64512: CharacterType.al,
  64513: CharacterType.al,
  64514: CharacterType.al,
  64515: CharacterType.al,
  64516: CharacterType.al,
  64517: CharacterType.al,
  64518: CharacterType.al,
  64519: CharacterType.al,
  64520: CharacterType.al,
  64521: CharacterType.al,
  64522: CharacterType.al,
  64523: CharacterType.al,
  64524: CharacterType.al,
  64525: CharacterType.al,
  64526: CharacterType.al,
  64527: CharacterType.al,
  64528: CharacterType.al,
  64529: CharacterType.al,
  64530: CharacterType.al,
  64531: CharacterType.al,
  64532: CharacterType.al,
  64533: CharacterType.al,
  64534: CharacterType.al,
  64535: CharacterType.al,
  64536: CharacterType.al,
  64537: CharacterType.al,
  64538: CharacterType.al,
  64539: CharacterType.al,
  64540: CharacterType.al,
  64541: CharacterType.al,
  64542: CharacterType.al,
  64543: CharacterType.al,
  64544: CharacterType.al,
  64545: CharacterType.al,
  64546: CharacterType.al,
  64547: CharacterType.al,
  64548: CharacterType.al,
  64549: CharacterType.al,
  64550: CharacterType.al,
  64551: CharacterType.al,
  64552: CharacterType.al,
  64553: CharacterType.al,
  64554: CharacterType.al,
  64555: CharacterType.al,
  64556: CharacterType.al,
  64557: CharacterType.al,
  64558: CharacterType.al,
  64559: CharacterType.al,
  64560: CharacterType.al,
  64561: CharacterType.al,
  64562: CharacterType.al,
  64563: CharacterType.al,
  64564: CharacterType.al,
  64565: CharacterType.al,
  64566: CharacterType.al,
  64567: CharacterType.al,
  64568: CharacterType.al,
  64569: CharacterType.al,
  64570: CharacterType.al,
  64571: CharacterType.al,
  64572: CharacterType.al,
  64573: CharacterType.al,
  64574: CharacterType.al,
  64575: CharacterType.al,
  64576: CharacterType.al,
  64577: CharacterType.al,
  64578: CharacterType.al,
  64579: CharacterType.al,
  64580: CharacterType.al,
  64581: CharacterType.al,
  64582: CharacterType.al,
  64583: CharacterType.al,
  64584: CharacterType.al,
  64585: CharacterType.al,
  64586: CharacterType.al,
  64587: CharacterType.al,
  64588: CharacterType.al,
  64589: CharacterType.al,
  64590: CharacterType.al,
  64591: CharacterType.al,
  64592: CharacterType.al,
  64593: CharacterType.al,
  64594: CharacterType.al,
  64595: CharacterType.al,
  64596: CharacterType.al,
  64597: CharacterType.al,
  64598: CharacterType.al,
  64599: CharacterType.al,
  64600: CharacterType.al,
  64601: CharacterType.al,
  64602: CharacterType.al,
  64603: CharacterType.al,
  64604: CharacterType.al,
  64605: CharacterType.al,
  64606: CharacterType.al,
  64607: CharacterType.al,
  64608: CharacterType.al,
  64609: CharacterType.al,
  64610: CharacterType.al,
  64611: CharacterType.al,
  64612: CharacterType.al,
  64613: CharacterType.al,
  64614: CharacterType.al,
  64615: CharacterType.al,
  64616: CharacterType.al,
  64617: CharacterType.al,
  64618: CharacterType.al,
  64619: CharacterType.al,
  64620: CharacterType.al,
  64621: CharacterType.al,
  64622: CharacterType.al,
  64623: CharacterType.al,
  64624: CharacterType.al,
  64625: CharacterType.al,
  64626: CharacterType.al,
  64627: CharacterType.al,
  64628: CharacterType.al,
  64629: CharacterType.al,
  64630: CharacterType.al,
  64631: CharacterType.al,
  64632: CharacterType.al,
  64633: CharacterType.al,
  64634: CharacterType.al,
  64635: CharacterType.al,
  64636: CharacterType.al,
  64637: CharacterType.al,
  64638: CharacterType.al,
  64639: CharacterType.al,
  64640: CharacterType.al,
  64641: CharacterType.al,
  64642: CharacterType.al,
  64643: CharacterType.al,
  64644: CharacterType.al,
  64645: CharacterType.al,
  64646: CharacterType.al,
  64647: CharacterType.al,
  64648: CharacterType.al,
  64649: CharacterType.al,
  64650: CharacterType.al,
  64651: CharacterType.al,
  64652: CharacterType.al,
  64653: CharacterType.al,
  64654: CharacterType.al,
  64655: CharacterType.al,
  64656: CharacterType.al,
  64657: CharacterType.al,
  64658: CharacterType.al,
  64659: CharacterType.al,
  64660: CharacterType.al,
  64661: CharacterType.al,
  64662: CharacterType.al,
  64663: CharacterType.al,
  64664: CharacterType.al,
  64665: CharacterType.al,
  64666: CharacterType.al,
  64667: CharacterType.al,
  64668: CharacterType.al,
  64669: CharacterType.al,
  64670: CharacterType.al,
  64671: CharacterType.al,
  64672: CharacterType.al,
  64673: CharacterType.al,
  64674: CharacterType.al,
  64675: CharacterType.al,
  64676: CharacterType.al,
  64677: CharacterType.al,
  64678: CharacterType.al,
  64679: CharacterType.al,
  64680: CharacterType.al,
  64681: CharacterType.al,
  64682: CharacterType.al,
  64683: CharacterType.al,
  64684: CharacterType.al,
  64685: CharacterType.al,
  64686: CharacterType.al,
  64687: CharacterType.al,
  64688: CharacterType.al,
  64689: CharacterType.al,
  64690: CharacterType.al,
  64691: CharacterType.al,
  64692: CharacterType.al,
  64693: CharacterType.al,
  64694: CharacterType.al,
  64695: CharacterType.al,
  64696: CharacterType.al,
  64697: CharacterType.al,
  64698: CharacterType.al,
  64699: CharacterType.al,
  64700: CharacterType.al,
  64701: CharacterType.al,
  64702: CharacterType.al,
  64703: CharacterType.al,
  64704: CharacterType.al,
  64705: CharacterType.al,
  64706: CharacterType.al,
  64707: CharacterType.al,
  64708: CharacterType.al,
  64709: CharacterType.al,
  64710: CharacterType.al,
  64711: CharacterType.al,
  64712: CharacterType.al,
  64713: CharacterType.al,
  64714: CharacterType.al,
  64715: CharacterType.al,
  64716: CharacterType.al,
  64717: CharacterType.al,
  64718: CharacterType.al,
  64719: CharacterType.al,
  64720: CharacterType.al,
  64721: CharacterType.al,
  64722: CharacterType.al,
  64723: CharacterType.al,
  64724: CharacterType.al,
  64725: CharacterType.al,
  64726: CharacterType.al,
  64727: CharacterType.al,
  64728: CharacterType.al,
  64729: CharacterType.al,
  64730: CharacterType.al,
  64731: CharacterType.al,
  64732: CharacterType.al,
  64733: CharacterType.al,
  64734: CharacterType.al,
  64735: CharacterType.al,
  64736: CharacterType.al,
  64737: CharacterType.al,
  64738: CharacterType.al,
  64739: CharacterType.al,
  64740: CharacterType.al,
  64741: CharacterType.al,
  64742: CharacterType.al,
  64743: CharacterType.al,
  64744: CharacterType.al,
  64745: CharacterType.al,
  64746: CharacterType.al,
  64747: CharacterType.al,
  64748: CharacterType.al,
  64749: CharacterType.al,
  64750: CharacterType.al,
  64751: CharacterType.al,
  64752: CharacterType.al,
  64753: CharacterType.al,
  64754: CharacterType.al,
  64755: CharacterType.al,
  64756: CharacterType.al,
  64757: CharacterType.al,
  64758: CharacterType.al,
  64759: CharacterType.al,
  64760: CharacterType.al,
  64761: CharacterType.al,
  64762: CharacterType.al,
  64763: CharacterType.al,
  64764: CharacterType.al,
  64765: CharacterType.al,
  64766: CharacterType.al,
  64767: CharacterType.al,
  64768: CharacterType.al,
  64769: CharacterType.al,
  64770: CharacterType.al,
  64771: CharacterType.al,
  64772: CharacterType.al,
  64773: CharacterType.al,
  64774: CharacterType.al,
  64775: CharacterType.al,
  64776: CharacterType.al,
  64777: CharacterType.al,
  64778: CharacterType.al,
  64779: CharacterType.al,
  64780: CharacterType.al,
  64781: CharacterType.al,
  64782: CharacterType.al,
  64783: CharacterType.al,
  64784: CharacterType.al,
  64785: CharacterType.al,
  64786: CharacterType.al,
  64787: CharacterType.al,
  64788: CharacterType.al,
  64789: CharacterType.al,
  64790: CharacterType.al,
  64791: CharacterType.al,
  64792: CharacterType.al,
  64793: CharacterType.al,
  64794: CharacterType.al,
  64795: CharacterType.al,
  64796: CharacterType.al,
  64797: CharacterType.al,
  64798: CharacterType.al,
  64799: CharacterType.al,
  64800: CharacterType.al,
  64801: CharacterType.al,
  64802: CharacterType.al,
  64803: CharacterType.al,
  64804: CharacterType.al,
  64805: CharacterType.al,
  64806: CharacterType.al,
  64807: CharacterType.al,
  64808: CharacterType.al,
  64809: CharacterType.al,
  64810: CharacterType.al,
  64811: CharacterType.al,
  64812: CharacterType.al,
  64813: CharacterType.al,
  64814: CharacterType.al,
  64815: CharacterType.al,
  64816: CharacterType.al,
  64817: CharacterType.al,
  64818: CharacterType.al,
  64819: CharacterType.al,
  64820: CharacterType.al,
  64821: CharacterType.al,
  64822: CharacterType.al,
  64823: CharacterType.al,
  64824: CharacterType.al,
  64825: CharacterType.al,
  64826: CharacterType.al,
  64827: CharacterType.al,
  64828: CharacterType.al,
  64829: CharacterType.al,
  64830: CharacterType.otherNeutrals,
  64831: CharacterType.otherNeutrals,
  64848: CharacterType.al,
  64849: CharacterType.al,
  64850: CharacterType.al,
  64851: CharacterType.al,
  64852: CharacterType.al,
  64853: CharacterType.al,
  64854: CharacterType.al,
  64855: CharacterType.al,
  64856: CharacterType.al,
  64857: CharacterType.al,
  64858: CharacterType.al,
  64859: CharacterType.al,
  64860: CharacterType.al,
  64861: CharacterType.al,
  64862: CharacterType.al,
  64863: CharacterType.al,
  64864: CharacterType.al,
  64865: CharacterType.al,
  64866: CharacterType.al,
  64867: CharacterType.al,
  64868: CharacterType.al,
  64869: CharacterType.al,
  64870: CharacterType.al,
  64871: CharacterType.al,
  64872: CharacterType.al,
  64873: CharacterType.al,
  64874: CharacterType.al,
  64875: CharacterType.al,
  64876: CharacterType.al,
  64877: CharacterType.al,
  64878: CharacterType.al,
  64879: CharacterType.al,
  64880: CharacterType.al,
  64881: CharacterType.al,
  64882: CharacterType.al,
  64883: CharacterType.al,
  64884: CharacterType.al,
  64885: CharacterType.al,
  64886: CharacterType.al,
  64887: CharacterType.al,
  64888: CharacterType.al,
  64889: CharacterType.al,
  64890: CharacterType.al,
  64891: CharacterType.al,
  64892: CharacterType.al,
  64893: CharacterType.al,
  64894: CharacterType.al,
  64895: CharacterType.al,
  64896: CharacterType.al,
  64897: CharacterType.al,
  64898: CharacterType.al,
  64899: CharacterType.al,
  64900: CharacterType.al,
  64901: CharacterType.al,
  64902: CharacterType.al,
  64903: CharacterType.al,
  64904: CharacterType.al,
  64905: CharacterType.al,
  64906: CharacterType.al,
  64907: CharacterType.al,
  64908: CharacterType.al,
  64909: CharacterType.al,
  64910: CharacterType.al,
  64911: CharacterType.al,
  64914: CharacterType.al,
  64915: CharacterType.al,
  64916: CharacterType.al,
  64917: CharacterType.al,
  64918: CharacterType.al,
  64919: CharacterType.al,
  64920: CharacterType.al,
  64921: CharacterType.al,
  64922: CharacterType.al,
  64923: CharacterType.al,
  64924: CharacterType.al,
  64925: CharacterType.al,
  64926: CharacterType.al,
  64927: CharacterType.al,
  64928: CharacterType.al,
  64929: CharacterType.al,
  64930: CharacterType.al,
  64931: CharacterType.al,
  64932: CharacterType.al,
  64933: CharacterType.al,
  64934: CharacterType.al,
  64935: CharacterType.al,
  64936: CharacterType.al,
  64937: CharacterType.al,
  64938: CharacterType.al,
  64939: CharacterType.al,
  64940: CharacterType.al,
  64941: CharacterType.al,
  64942: CharacterType.al,
  64943: CharacterType.al,
  64944: CharacterType.al,
  64945: CharacterType.al,
  64946: CharacterType.al,
  64947: CharacterType.al,
  64948: CharacterType.al,
  64949: CharacterType.al,
  64950: CharacterType.al,
  64951: CharacterType.al,
  64952: CharacterType.al,
  64953: CharacterType.al,
  64954: CharacterType.al,
  64955: CharacterType.al,
  64956: CharacterType.al,
  64957: CharacterType.al,
  64958: CharacterType.al,
  64959: CharacterType.al,
  64960: CharacterType.al,
  64961: CharacterType.al,
  64962: CharacterType.al,
  64963: CharacterType.al,
  64964: CharacterType.al,
  64965: CharacterType.al,
  64966: CharacterType.al,
  64967: CharacterType.al,
  65008: CharacterType.al,
  65009: CharacterType.al,
  65010: CharacterType.al,
  65011: CharacterType.al,
  65012: CharacterType.al,
  65013: CharacterType.al,
  65014: CharacterType.al,
  65015: CharacterType.al,
  65016: CharacterType.al,
  65017: CharacterType.al,
  65018: CharacterType.al,
  65019: CharacterType.al,
  65020: CharacterType.al,
  65021: CharacterType.otherNeutrals,
  65024: CharacterType.nonspacingMark,
  65025: CharacterType.nonspacingMark,
  65026: CharacterType.nonspacingMark,
  65027: CharacterType.nonspacingMark,
  65028: CharacterType.nonspacingMark,
  65029: CharacterType.nonspacingMark,
  65030: CharacterType.nonspacingMark,
  65031: CharacterType.nonspacingMark,
  65032: CharacterType.nonspacingMark,
  65033: CharacterType.nonspacingMark,
  65034: CharacterType.nonspacingMark,
  65035: CharacterType.nonspacingMark,
  65036: CharacterType.nonspacingMark,
  65037: CharacterType.nonspacingMark,
  65038: CharacterType.nonspacingMark,
  65039: CharacterType.nonspacingMark,
  65040: CharacterType.otherNeutrals,
  65041: CharacterType.otherNeutrals,
  65042: CharacterType.otherNeutrals,
  65043: CharacterType.otherNeutrals,
  65044: CharacterType.otherNeutrals,
  65045: CharacterType.otherNeutrals,
  65046: CharacterType.otherNeutrals,
  65047: CharacterType.otherNeutrals,
  65048: CharacterType.otherNeutrals,
  65049: CharacterType.otherNeutrals,
  65056: CharacterType.nonspacingMark,
  65057: CharacterType.nonspacingMark,
  65058: CharacterType.nonspacingMark,
  65059: CharacterType.nonspacingMark,
  65060: CharacterType.nonspacingMark,
  65061: CharacterType.nonspacingMark,
  65062: CharacterType.nonspacingMark,
  65063: CharacterType.nonspacingMark,
  65064: CharacterType.nonspacingMark,
  65065: CharacterType.nonspacingMark,
  65066: CharacterType.nonspacingMark,
  65067: CharacterType.nonspacingMark,
  65068: CharacterType.nonspacingMark,
  65069: CharacterType.nonspacingMark,
  65072: CharacterType.otherNeutrals,
  65073: CharacterType.otherNeutrals,
  65074: CharacterType.otherNeutrals,
  65075: CharacterType.otherNeutrals,
  65076: CharacterType.otherNeutrals,
  65077: CharacterType.otherNeutrals,
  65078: CharacterType.otherNeutrals,
  65079: CharacterType.otherNeutrals,
  65080: CharacterType.otherNeutrals,
  65081: CharacterType.otherNeutrals,
  65082: CharacterType.otherNeutrals,
  65083: CharacterType.otherNeutrals,
  65084: CharacterType.otherNeutrals,
  65085: CharacterType.otherNeutrals,
  65086: CharacterType.otherNeutrals,
  65087: CharacterType.otherNeutrals,
  65088: CharacterType.otherNeutrals,
  65089: CharacterType.otherNeutrals,
  65090: CharacterType.otherNeutrals,
  65091: CharacterType.otherNeutrals,
  65092: CharacterType.otherNeutrals,
  65093: CharacterType.otherNeutrals,
  65094: CharacterType.otherNeutrals,
  65095: CharacterType.otherNeutrals,
  65096: CharacterType.otherNeutrals,
  65097: CharacterType.otherNeutrals,
  65098: CharacterType.otherNeutrals,
  65099: CharacterType.otherNeutrals,
  65100: CharacterType.otherNeutrals,
  65101: CharacterType.otherNeutrals,
  65102: CharacterType.otherNeutrals,
  65103: CharacterType.otherNeutrals,
  65104: CharacterType.commonNumberSeparator,
  65105: CharacterType.otherNeutrals,
  65106: CharacterType.commonNumberSeparator,
  65108: CharacterType.otherNeutrals,
  65109: CharacterType.commonNumberSeparator,
  65110: CharacterType.otherNeutrals,
  65111: CharacterType.otherNeutrals,
  65112: CharacterType.otherNeutrals,
  65113: CharacterType.otherNeutrals,
  65114: CharacterType.otherNeutrals,
  65115: CharacterType.otherNeutrals,
  65116: CharacterType.otherNeutrals,
  65117: CharacterType.otherNeutrals,
  65118: CharacterType.otherNeutrals,
  65119: CharacterType.et,
  65120: CharacterType.otherNeutrals,
  65121: CharacterType.otherNeutrals,
  65122: CharacterType.es,
  65123: CharacterType.es,
  65124: CharacterType.otherNeutrals,
  65125: CharacterType.otherNeutrals,
  65126: CharacterType.otherNeutrals,
  65128: CharacterType.otherNeutrals,
  65129: CharacterType.et,
  65130: CharacterType.et,
  65131: CharacterType.otherNeutrals,
  65136: CharacterType.al,
  65137: CharacterType.al,
  65138: CharacterType.al,
  65139: CharacterType.al,
  65140: CharacterType.al,
  65142: CharacterType.al,
  65143: CharacterType.al,
  65144: CharacterType.al,
  65145: CharacterType.al,
  65146: CharacterType.al,
  65147: CharacterType.al,
  65148: CharacterType.al,
  65149: CharacterType.al,
  65150: CharacterType.al,
  65151: CharacterType.al,
  65152: CharacterType.al,
  65153: CharacterType.al,
  65154: CharacterType.al,
  65155: CharacterType.al,
  65156: CharacterType.al,
  65157: CharacterType.al,
  65158: CharacterType.al,
  65159: CharacterType.al,
  65160: CharacterType.al,
  65161: CharacterType.al,
  65162: CharacterType.al,
  65163: CharacterType.al,
  65164: CharacterType.al,
  65165: CharacterType.al,
  65166: CharacterType.al,
  65167: CharacterType.al,
  65168: CharacterType.al,
  65169: CharacterType.al,
  65170: CharacterType.al,
  65171: CharacterType.al,
  65172: CharacterType.al,
  65173: CharacterType.al,
  65174: CharacterType.al,
  65175: CharacterType.al,
  65176: CharacterType.al,
  65177: CharacterType.al,
  65178: CharacterType.al,
  65179: CharacterType.al,
  65180: CharacterType.al,
  65181: CharacterType.al,
  65182: CharacterType.al,
  65183: CharacterType.al,
  65184: CharacterType.al,
  65185: CharacterType.al,
  65186: CharacterType.al,
  65187: CharacterType.al,
  65188: CharacterType.al,
  65189: CharacterType.al,
  65190: CharacterType.al,
  65191: CharacterType.al,
  65192: CharacterType.al,
  65193: CharacterType.al,
  65194: CharacterType.al,
  65195: CharacterType.al,
  65196: CharacterType.al,
  65197: CharacterType.al,
  65198: CharacterType.al,
  65199: CharacterType.al,
  65200: CharacterType.al,
  65201: CharacterType.al,
  65202: CharacterType.al,
  65203: CharacterType.al,
  65204: CharacterType.al,
  65205: CharacterType.al,
  65206: CharacterType.al,
  65207: CharacterType.al,
  65208: CharacterType.al,
  65209: CharacterType.al,
  65210: CharacterType.al,
  65211: CharacterType.al,
  65212: CharacterType.al,
  65213: CharacterType.al,
  65214: CharacterType.al,
  65215: CharacterType.al,
  65216: CharacterType.al,
  65217: CharacterType.al,
  65218: CharacterType.al,
  65219: CharacterType.al,
  65220: CharacterType.al,
  65221: CharacterType.al,
  65222: CharacterType.al,
  65223: CharacterType.al,
  65224: CharacterType.al,
  65225: CharacterType.al,
  65226: CharacterType.al,
  65227: CharacterType.al,
  65228: CharacterType.al,
  65229: CharacterType.al,
  65230: CharacterType.al,
  65231: CharacterType.al,
  65232: CharacterType.al,
  65233: CharacterType.al,
  65234: CharacterType.al,
  65235: CharacterType.al,
  65236: CharacterType.al,
  65237: CharacterType.al,
  65238: CharacterType.al,
  65239: CharacterType.al,
  65240: CharacterType.al,
  65241: CharacterType.al,
  65242: CharacterType.al,
  65243: CharacterType.al,
  65244: CharacterType.al,
  65245: CharacterType.al,
  65246: CharacterType.al,
  65247: CharacterType.al,
  65248: CharacterType.al,
  65249: CharacterType.al,
  65250: CharacterType.al,
  65251: CharacterType.al,
  65252: CharacterType.al,
  65253: CharacterType.al,
  65254: CharacterType.al,
  65255: CharacterType.al,
  65256: CharacterType.al,
  65257: CharacterType.al,
  65258: CharacterType.al,
  65259: CharacterType.al,
  65260: CharacterType.al,
  65261: CharacterType.al,
  65262: CharacterType.al,
  65263: CharacterType.al,
  65264: CharacterType.al,
  65265: CharacterType.al,
  65266: CharacterType.al,
  65267: CharacterType.al,
  65268: CharacterType.al,
  65269: CharacterType.al,
  65270: CharacterType.al,
  65271: CharacterType.al,
  65272: CharacterType.al,
  65273: CharacterType.al,
  65274: CharacterType.al,
  65275: CharacterType.al,
  65276: CharacterType.al,
  65279: CharacterType.bn,
  65281: CharacterType.otherNeutrals,
  65282: CharacterType.otherNeutrals,
  65283: CharacterType.et,
  65284: CharacterType.et,
  65285: CharacterType.et,
  65286: CharacterType.otherNeutrals,
  65287: CharacterType.otherNeutrals,
  65288: CharacterType.otherNeutrals,
  65289: CharacterType.otherNeutrals,
  65290: CharacterType.otherNeutrals,
  65291: CharacterType.es,
  65292: CharacterType.commonNumberSeparator,
  65293: CharacterType.es,
  65294: CharacterType.commonNumberSeparator,
  65295: CharacterType.commonNumberSeparator,
  65296: CharacterType.en,
  65297: CharacterType.en,
  65298: CharacterType.en,
  65299: CharacterType.en,
  65300: CharacterType.en,
  65301: CharacterType.en,
  65302: CharacterType.en,
  65303: CharacterType.en,
  65304: CharacterType.en,
  65305: CharacterType.en,
  65306: CharacterType.commonNumberSeparator,
  65307: CharacterType.otherNeutrals,
  65308: CharacterType.otherNeutrals,
  65309: CharacterType.otherNeutrals,
  65310: CharacterType.otherNeutrals,
  65311: CharacterType.otherNeutrals,
  65312: CharacterType.otherNeutrals,
  65339: CharacterType.otherNeutrals,
  65340: CharacterType.otherNeutrals,
  65341: CharacterType.otherNeutrals,
  65342: CharacterType.otherNeutrals,
  65343: CharacterType.otherNeutrals,
  65344: CharacterType.otherNeutrals,
  65371: CharacterType.otherNeutrals,
  65372: CharacterType.otherNeutrals,
  65373: CharacterType.otherNeutrals,
  65374: CharacterType.otherNeutrals,
  65375: CharacterType.otherNeutrals,
  65376: CharacterType.otherNeutrals,
  65377: CharacterType.otherNeutrals,
  65378: CharacterType.otherNeutrals,
  65379: CharacterType.otherNeutrals,
  65380: CharacterType.otherNeutrals,
  65381: CharacterType.otherNeutrals,
  65504: CharacterType.et,
  65505: CharacterType.et,
  65506: CharacterType.otherNeutrals,
  65507: CharacterType.otherNeutrals,
  65508: CharacterType.otherNeutrals,
  65509: CharacterType.et,
  65510: CharacterType.et,
  65512: CharacterType.otherNeutrals,
  65513: CharacterType.otherNeutrals,
  65514: CharacterType.otherNeutrals,
  65515: CharacterType.otherNeutrals,
  65516: CharacterType.otherNeutrals,
  65517: CharacterType.otherNeutrals,
  65518: CharacterType.otherNeutrals,
  65529: CharacterType.otherNeutrals,
  65530: CharacterType.otherNeutrals,
  65531: CharacterType.otherNeutrals,
  65532: CharacterType.otherNeutrals,
  65533: CharacterType.otherNeutrals
};

/// Returns the BiDi type for a given character.
///
/// [character] A Unicode character for which to get the BiDi type.
///
/// Returns the character bidi [CharacterType].
CharacterType getCharacterType(int character) {
  return characterTypes[character] ?? CharacterType.ltr;
}
