import 'package:intl/date_symbols.dart' as intl;
import 'package:intl/number_symbols.dart';

class IntlNn {
  static final dateSymbols = intl.DateSymbols(
    NAME: 'nn',
    ERAS: const <String>[
      'f.Kr.',
      'e.Kr.',
    ],
    ERANAMES: const <String>[
      'før Kristus',
      'etter Kristus',
    ],
    NARROWMONTHS: const <String>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    STANDALONENARROWMONTHS: const <String>[
      'J',
      'F',
      'M',
      'A',
      'M',
      'J',
      'J',
      'A',
      'S',
      'O',
      'N',
      'D',
    ],
    MONTHS: const <String>[
      'januar',
      'februar',
      'mars',
      'april',
      'mai',
      'juni',
      'juli',
      'august',
      'september',
      'oktober',
      'november',
      'desember',
    ],
    STANDALONEMONTHS: const <String>[
      'januar',
      'februar',
      'mars',
      'april',
      'mai',
      'juni',
      'juli',
      'august',
      'september',
      'oktober',
      'november',
      'desember',
    ],
    SHORTMONTHS: const <String>[
      'jan.',
      'feb.',
      'mar.',
      'apr.',
      'mai',
      'jun.',
      'jul.',
      'aug.',
      'sep.',
      'okt.',
      'nov.',
      'des.',
    ],
    STANDALONESHORTMONTHS: const <String>[
      'jan',
      'feb',
      'mar',
      'apr',
      'mai',
      'jun',
      'jul',
      'aug',
      'sep',
      'okt',
      'nov',
      'des',
    ],
    WEEKDAYS: const <String>[
      'søndag',
      'mandag',
      'tirsdag',
      'onsdag',
      'torsdag',
      'fredag',
      'lørdag',
    ],
    STANDALONEWEEKDAYS: const <String>[
      'søndag',
      'mandag',
      'tirsdag',
      'onsdag',
      'torsdag',
      'fredag',
      'lørdag',
    ],
    SHORTWEEKDAYS: const <String>[
      'søn.',
      'man.',
      'tir.',
      'ons.',
      'tor.',
      'fre.',
      'lør.',
    ],
    STANDALONESHORTWEEKDAYS: const <String>[
      'søn.',
      'man.',
      'tir.',
      'ons.',
      'tor.',
      'fre.',
      'lør.',
    ],
    NARROWWEEKDAYS: const <String>[
      'S',
      'M',
      'T',
      'O',
      'T',
      'F',
      'L',
    ],
    STANDALONENARROWWEEKDAYS: const <String>[
      'S',
      'M',
      'T',
      'O',
      'T',
      'F',
      'L',
    ],
    SHORTQUARTERS: const <String>[
      'K1',
      'K2',
      'K3',
      'K4',
    ],
    QUARTERS: const <String>[
      '1. kvartal',
      '2. kvartal',
      '3. kvartal',
      '4. kvartal',
    ],
    AMPMS: const <String>[
      'a.m.',
      'p.m.',
    ],
    DATEFORMATS: const <String>[
      'EEEE d. MMMM y',
      'd. MMMM y',
      'd. MMM y',
      'dd.MM.y',
    ],
    TIMEFORMATS: const <String>[
      'HH:mm:ss zzzz',
      'HH:mm:ss z',
      'HH:mm:ss',
      'HH:mm',
    ],
    FIRSTDAYOFWEEK: 0,
    WEEKENDRANGE: const <int>[
      5,
      6,
    ],
    FIRSTWEEKCUTOFFDAY: 3,
    DATETIMEFORMATS: const <String>[
      '{1} {0}',
      "{1} 'kl'. {0}",
      '{1}, {0}',
      '{1}, {0}',
    ],
  );

  static const datePatterns = {
    'd': 'd.',
    'E': 'ccc',
    'EEEE': 'cccc',
    'LLL': 'LLL',
    'LLLL': 'LLLL',
    'M': 'L.',
    'Md': 'd.M.',
    'MEd': 'EEE d.M.',
    'MMM': 'LLL',
    'MMMd': 'd. MMM',
    'MMMEd': 'EEE d. MMM',
    'MMMM': 'LLLL',
    'MMMMd': 'd. MMMM',
    'MMMMEEEEd': 'EEEE d. MMMM',
    'QQQ': 'QQQ',
    'QQQQ': 'QQQQ',
    'y': 'y',
    'yM': 'M.y',
    'yMd': 'd.M.y',
    'yMEd': 'EEE d.MM.y',
    'yMMM': 'MMM y',
    'yMMMd': 'd. MMM y',
    'yMMMEd': 'EEE d. MMM y',
    'yMMMM': 'MMMM y',
    'yMMMMd': 'd. MMMM y',
    'yMMMMEEEEd': 'EEEE d. MMMM y',
    'yQQQ': 'QQQ y',
    'yQQQQ': 'QQQQ y',
    'H': 'HH',
    'Hm': 'HH:mm',
    'Hms': 'HH:mm:ss',
    'j': 'HH',
    'jm': 'HH:mm',
    'jms': 'HH:mm:ss',
    'jmv': 'HH:mm v',
    'jmz': 'HH:mm z',
    'jz': 'HH z',
    'm': 'm',
    'ms': 'mm:ss',
    's': 's',
    'v': 'v',
    'z': 'z',
    'zzzz': 'zzzz',
    'ZZZZ': 'ZZZZ',
  };

  static const numberSymbols = NumberSymbols(
    NAME: "nb",
    DECIMAL_SEP: ',',
    GROUP_SEP: '\u00A0',
    PERCENT: '%',
    ZERO_DIGIT: '0',
    PLUS_SIGN: '+',
    MINUS_SIGN: '\u2212',
    EXP_SYMBOL: 'E',
    PERMILL: '\u2030',
    INFINITY: '\u221E',
    NAN: 'NaN',
    DECIMAL_PATTERN: '#,##0.###',
    SCIENTIFIC_PATTERN: '#E0',
    PERCENT_PATTERN: '#,##0\u00A0%',
    CURRENCY_PATTERN: '\u00A4\u00A0#,##0.00;\u00A4\u00A0-#,##0.00',
    DEF_CURRENCY_CODE: 'NOK',
  );
}