// Copyright (c) 2019, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

import 'dart:developer';
import 'common/service_test_common.dart';
import 'common/test_helper.dart';

// AUTOGENERATED START
//
// Update these constants by running:
//
// dart pkg/vm_service/test/update_line_numbers.dart <test.dart>
//
const LINE_A = 29;
const LINE_B = 30;
const LINE_C = 34;
const LINE_H = 36;
const LINE_0 = 37;
const LINE_D = 38;
const LINE_I = 40;
const LINE_1 = 44;
const LINE_E = 45;
const LINE_F = 46;
const LINE_G = 47;
// AUTOGENERATED END

Stream<int> foobar() async* {
  yield 1; // LINE_A.
  yield 2; // LINE_B.
}

Future<void> helper() async {
  print('helper'); // LINE_C.
  // ignore: unused_local_variable
  await for (var i in foobar()) /* LINE_H */ {
    debugger(); // LINE_0
    print('loop'); // LINE_D.
  }
  return; // LINE_I.
}

Future<void> testMain() async {
  debugger(); // LINE_1
  print('mmmmm'); // LINE_E.
  await helper(); // LINE_F.
  print('z'); // LINE_G.
}

final tests = <IsolateTest>[
  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_1),
  stepOver, // debugger.

  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_E),
  stepOver, // print.

  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_F),
  stepInto,

  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_C),
  stepOver, // print.

  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_H), // foobar().
  stepInto,

  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_H), // await for.
  stepInto,

  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_A),
  stepOut, // step out of generator.

  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_H), // await for.
  stepInto,

  hasStoppedAtBreakpoint, // debugger().
  stepInto,

  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_D), // print.
  stepInto,

  hasStoppedAtBreakpoint, // await for.
  stepInto,

  hasStoppedAtBreakpoint, // back in generator.
  stoppedAtLine(LINE_B),
  stepOut, // step out of generator.

  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_H), // await for.
  stepInto,

  hasStoppedAtBreakpoint, // debugger().
  stepInto,

  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_D), // print.
  stepInto,

  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_H), // await for.
  stepInto,

  hasStoppedAtBreakpoint,
  stepOut, // step out of generator.

  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_I), // return null.
];

void main([args = const <String>[]]) => runIsolateTests(
      args,
      tests,
      'async_star_step_out_test.dart',
      testeeConcurrent: testMain,
      extraArgs: extraDebuggingArgs,
    );
